

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_MediaAgentXML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge Media Agent From XML.
--  +========================================================================+
-- $Id: CCM_Merge_MediaAgentXML.sp,v 1.21.60.9.46.2 2021/05/24 18:09:38 pnara Exp $
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCM_Merge_MediaAgentXML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Merge_MediaAgentXML <<<'
	drop procedure CCM_Merge_MediaAgentXML
END
IF EXISTS (select * from GxQscripts where name='CCM_Merge_MediaAgentXML')
	delete from GxQscripts where name = 'CCM_Merge_MediaAgentXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_MediaAgentXML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_MediaAgentXML'
GO
print '... Creating Procedure: CCM_Merge_MediaAgentXML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCM_Merge_MediaAgentXML
  @MADataXml xml,
  @ccmParamFlags integer = 0
AS
SET NOCOUNT ON
  DECLARE @errorCode integer
  DECLARE @errorString varchar(4000)
  DECLARE @o_mergedMAClientId integer
  DECLARE @o_mergedCSClientId integer
BEGIN TRANSACTION
  SET @errorCode = -1
	SET @errorString = 'ERROR: GENERAL ERROR!'
	SET @o_mergedMAClientId = 0
	SET @o_mergedCSClientId = 0
	CREATE TABLE #CCM_APP_Application (
		id					INTEGER NOT NULL,
		clientId			integer NOT NULL,
		appTypeId			integer NOT NULL,
		instance	   	    	integer NOT NULL,
		backupSet			integer NOT NULL,
		appNumber			integer NOT NULL,
		dataArchGrpID		smallint NOT NULL,
		logArchGrpID		smallint NOT NULL,
		refTime				INTEGER NOT NULL,
		modified			INTEGER NOT NULL,
		subclientName		nvarchar(128)   NOT NULL,
		subclientStatus     integer NOT NULL,
		ccpId				integer Default 0 NOT NULL,
		ccpTime				INTEGER Default 0 NOT NULL,
		origCCId			tinyint		DEFAULT		2 NOT NULL,
		GUID				uniqueidentifier ROWGUIDCOL,
	)
	CREATE TABLE #CCM_APP_CommCell (
	id					INTEGER NOT NULL,
	number				integer NOT NULL,
	clientId			integer NOT NULL,
	parentId			integer NOT NULL,
	aliasName			nvarchar(256)   NOT NULL,
	flags				integer NOT NULL,
	refTime				INTEGER NOT NULL,
	userName			nvarchar(256)   NOT NULL,
	userPassword		nvarchar(1024)   NOT NULL,
	smtpServer			nvarchar(256)   NOT NULL,
	timeZone			nvarchar(1024)   NOT NULL,
	ipAddress			nvarchar(25)   NOT NULL,
	modified			INTEGER NOT NULL,
	ccOpMode			integer NOT NULL,
	drIpAddress			nvarchar(25)   NOT NULL,
	encNumber			nvarchar(256)   NOT NULL,
	csGUID				nvarchar(40)   NOT NULL,
	type				tinyint default 1 NOT NULL,
    )
  CREATE TABLE #CCM_APP_Client (
	id					INTEGER NOT NULL,
	name			    nvarchar(255)   NOT NULL,
	simOperatingSystemId		integer NOT NULL,
	net_hostname	    nvarchar(255)   NOT NULL,
	client_password	    nvarchar(255)   NOT NULL,
	refTime				INTEGER NOT NULL,
	modified			INTEGER NOT NULL,
	offlineEntity		integer NOT NULL,
	offlineTimeStamp	INTEGER NOT NULL,
	csHostName			nvarchar(255)   NOT NULL,
	clientDescription	nvarchar(MAX) NOT NULL,
	jobResultDir		nvarchar(255)   NOT NULL,
	clientSkewTime		integer NOT NULL,
	cvdPort             integer NOT NULL,
	evmgrcPort			integer NOT NULL,
	status				integer NOT NULL,
	releaseId			integer NOT NULL,
	spaceCheckFlags		integer NOT NULL,
	ccpId				integer Default 0 NOT NULL,
	ccpTime				INTEGER Default 0 NOT NULL,
	origCCId			tinyint		DEFAULT		2 NOT NULL,
	GUID				uniqueidentifier ROWGUIDCOL,
	specialClientFlags	integer Default 0 NOT NULL,
	displayName			nvarchar(255) DEFAULT '' NULL,
	)
  CREATE TABLE #CCM_JMJobAction (
	clientId 			integer NOT NULL,
	mediaAgentID		integer NOT NULL,
	appType				integer NOT NULL,
	opType				integer NOT NULL,
	action				integer NOT NULL,
	appId				integer NOT NULL,
	clientGroupId 		integer NOT NULL,
	enableTimeZone		integer Default 0 NOT NULL,
	enableTime			INTEGER Default 0 NOT NULL,
	UNCenableTime		INTEGER Default 0 NOT NULL,
	instanceID          INTEGER NULL,
	reason				nvarchar(1024) DEFAULT '' NOT NULL,
	)
	CREATE TABLE #CCM_MMHost (
		ClientId					integer NOT NULL,
		MmHostType					integer NOT NULL,
		MmHostSoftState				integer NOT NULL,
		MmHostEnabled				integer NOT NULL,
		OfflineReason				integer NOT NULL,
		OfflineTimeStamp			INTEGER NOT NULL,
		PatchLevel					integer NOT NULL,
		IndexCacheUser				varchar(1024)   NOT NULL,
		IndexCachePassword			varchar(2048)   NOT NULL,
		IndexCachePathName			varchar(1024)   NOT NULL,
		IsIndexShared				integer NOT NULL,
		Attribute					integer NOT NULL,
		ScanIntervalInSec			integer NOT NULL,
		Descript				NVARCHAR(MAX)default '' NOT NULL,
		MaxReservations				integer NOT NULL,
		RMStatus							integer NOT NULL,
		RMStatusUpdateTime		integer NOT NULL,
		RolesBitMask			integer NOT NULL,
	)
  CREATE TABLE #CCM_simAllGalaxyRel (
	id					integer NOT NULL,
	release			    varchar(128)   NOT NULL,
	)
	CREATE TABLE #CCM_APP_ClientProp (
		id				INTEGER NOT NULL,
		componentNameId		integer NOT NULL,
		attrName		    nvarchar(1024)   NOT NULL,
		attrType			integer NOT NULL,
		attrVal			nvarchar(1024)   NOT NULL,
		created			INTEGER NOT NULL,
		modified			INTEGER NOT NULL,
		ccpId				integer Default 0 NOT NULL,
	)
  CREATE TABLE #CCM_APP_Platform (
	clientId		integer NOT NULL,
	platformType	integer NOT NULL,
	install_dir	    nvarchar(255)   NOT NULL,
	refTime			INTEGER NOT NULL,
	)
	CREATE TABLE #CCM_IdxAccessPath (
		IdxAccessPathId			INTEGER NOT NULL,
		IdxCacheId				integer NOT NULL,
		ClientId				integer NOT NULL,
		Path					varchar(1024)   NOT NULL,
		Username				varchar(1024)   NOT NULL,
		Password				varchar(2048)   NOT NULL,
		Enabled					integer NOT NULL,
		SoftState				integer NOT NULL,
		OfflineReason			integer NOT NULL,
		Priority				integer NOT NULL,
		LocalIndexTimeStamp		integer NOT NULL,
		ActualDaysIndexRetain		integer NOT NULL,
		Flags					integer NOT NULL,
		AgeingNoOfDays			integer NOT NULL,
		AgeingPercentDiskspace	integer NOT NULL,
		DiskFreeThresholdMB		integer NOT NULL,
		DiskFreeWarningThreshholdMB	integer NOT NULL,
		TotalCapacityMB			integer NOT NULL,
		FreeDiskSpaceMB			integer Default 0 NOT NULL,
		DiskUsageMB			integer Default 0 NOT NULL,
		DiskUsageLastChecked		integer Default 0 NOT NULL,
		StagingCachePath		varchar(1024)   NOT NULL,
		VolumeGUID				varchar(1024) 	NOT NULL
	)
	CREATE TABLE #CCM_APP_VMToPMMap
	(
		VMClientId			integer   NOT NULL,
		PMClientId			integer   NOT NULL
	)
	INSERT INTO #CCM_App_Application
	SELECT tbl.col.value('@id','integer'),
	       tbl.col.value('@clientId','integer'),
	       tbl.col.value('@appTypeId','integer'),
	       tbl.col.value('@instance','integer'),
	       tbl.col.value('@backupSet','integer'),
	       tbl.col.value('@appNumber', 'integer'),
	       tbl.col.value('@dataArchGrpID', 'smallint'),
	       tbl.col.value('@dataArchGrpID', 'smallint'),
	       tbl.col.value('@refTime', 'integer'),
	       tbl.col.value('@modified', 'integer'),
	       tbl.col.value('@subclientName', 'nvarchar(128)'),
	       tbl.col.value('@subclientStatus', 'integer'),
	       tbl.col.value('@ccpId', 'integer'),
	       tbl.col.value('@ccpTime', 'integer'),
	       tbl.col.value('@origCCId', 'tinyint'),
	       tbl.col.value('@GUID', 'uniqueidentifier')
	FROM   @MADataXml.nodes('MediaAgentData/App_Application/row') tbl(col)
	INSERT INTO #CCM_App_CommCell
	SELECT tbl.col.value('@id','integer'),
	       tbl.col.value('@number','integer'),
	       tbl.col.value('@clientId','integer'),
	       tbl.col.value('@parentId','integer'),
	       tbl.col.value('@aliasName','nvarchar(256)'),
	       tbl.col.value('@flags', 'integer'),
	       tbl.col.value('@refTime', 'integer'),
	       tbl.col.value('@userName', 'nvarchar(256)'),
	       tbl.col.value('@userPassword', 'nvarchar(1024)'),
	       tbl.col.value('@smtpServer', 'nvarchar(256)'),
	       tbl.col.value('@timeZone', 'nvarchar(1024)'),
	       tbl.col.value('@ipAddress', 'nvarchar(25)'),
	       tbl.col.value('@modified', 'integer'),
	       tbl.col.value('@ccOpMode', 'integer'),
	       tbl.col.value('@drIpAddress', 'nvarchar(25)'),
	       tbl.col.value('@encNumber', 'nvarchar(256)'),
	       tbl.col.value('@csGUID', 'nvarchar(40)'),
	       tbl.col.value('@type', 'tinyint')
	FROM   @MADataXml.nodes('MediaAgentData/App_CommCell/row') tbl(col)
	INSERT INTO #CCM_App_Client
	SELECT tbl.col.value('@id','integer'),
	       tbl.col.value('@name','nvarchar(255)'),
	       tbl.col.value('@simOperatingSystemId','integer'),
	       tbl.col.value('@net_hostname','nvarchar(255)'),
	       tbl.col.value('@client_password','nvarchar(255)'),
	       tbl.col.value('@refTime', 'integer'),
	       tbl.col.value('@modified', 'integer'),
	       tbl.col.value('@offlineEntity', 'integer'),
	       tbl.col.value('@offlineTimeStamp', 'integer'),
	       tbl.col.value('@csHostName', 'nvarchar(255)'),
	       tbl.col.value('@clientDescription', 'nvarchar(MAX)'),
	       tbl.col.value('@jobResultDir', 'nvarchar(255)'),
	       tbl.col.value('@clientSkewTime', 'integer'),
	       tbl.col.value('@cvdPort', 'integer'),
	       tbl.col.value('@evmgrcPort', 'integer'),
	       tbl.col.value('@status', 'integer'),
	       tbl.col.value('@releaseId', 'integer'),
	       tbl.col.value('@spaceCheckFlags', 'integer'),
	       tbl.col.value('@ccpId', 'integer'),
	       tbl.col.value('@ccpTime', 'integer'),
	       tbl.col.value('@origCCId', 'tinyint'),
	       tbl.col.value('@GUID', 'uniqueidentifier'),
	       tbl.col.value('@specialClientFlags', 'integer'),
	       tbl.col.value('@displayName', 'nvarchar(255)')
	FROM   @MADataXml.nodes('MediaAgentData/App_Client/row') tbl(col)
	INSERT INTO #CCM_JMJobAction
	SELECT tbl.col.value('@clientId','integer'),
	       tbl.col.value('@mediaAgentID','integer'),
	       tbl.col.value('@appType','integer'),
	       tbl.col.value('@opType','integer'),
	       tbl.col.value('@action','integer'),
	       tbl.col.value('@appId','integer'),
	       tbl.col.value('@clientGroupId','integer'),
	       tbl.col.value('@enableTimeZone','integer'),
	       tbl.col.value('@enableTime','integer'),
	       tbl.col.value('@UNCenableTime','integer'),
	       ISNULL(tbl.col.value('@instanceID','integer'), 0),
	       ISNULL(tbl.col.value('@reason','nvarchar(1024)'), '')
	FROM   @MADataXml.nodes('MediaAgentData/JMJobAction/row') tbl(col)
	INSERT INTO #CCM_MMHost
	SELECT tbl.col.value('@ClientId','integer'),
	       tbl.col.value('@MmHostType','integer'),
	       tbl.col.value('@MmHostSoftState','integer'),
	       tbl.col.value('@MmHostEnabled','integer'),
	       tbl.col.value('@OfflineReason','integer'),
	       tbl.col.value('@OfflineTimeStamp','integer'),
	       tbl.col.value('@PatchLevel','integer'),
	       tbl.col.value('@IndexCacheUser','varchar(1024)'),
	       tbl.col.value('@IndexCachePassword','varchar(2048)'),
	       tbl.col.value('@IndexCachePathName','varchar(1024)'),
	       tbl.col.value('@IsIndexShared','integer'),
	       tbl.col.value('@Attribute','integer'),
	       tbl.col.value('@ScanIntervalInSec','integer'),
	       tbl.col.value('@Descript','NVARCHAR(MAX)'),
	       tbl.col.value('@MaxReservations','integer'),
	       tbl.col.value('@RMStatus','integer'),
	       tbl.col.value('@RMStatusUpdateTime','integer'),
	       ISNULL(tbl.col.value('@RolesBitMask','integer'), 0)
	FROM   @MADataXml.nodes('MediaAgentData/MMHost/row') tbl(col)
	/*
	Setting the attribute flag to indicate it is the Media Agent entry inserted by the 'library sharing' feature where the media agent is pushed from
	other CS. Right now this stored procedure to merge from XML data is used only for this purpose.
	If in future this stored procedure is used for different purposes this needs to be changed to set the attribute based on an input
	variable passed while calling the stored proc
	*/
UPDATE #CCM_MMHost SET Attribute = Attribute | 8192
	INSERT INTO #CCM_simAllGalaxyRel
	SELECT tbl.col.value('@id','integer'),
	       tbl.col.value('@release','varchar(128)')
	FROM   @MADataXml.nodes('MediaAgentData/simAllGalaxyRel/row') tbl(col)
	INSERT INTO #CCM_App_ClientProp
	SELECT tbl.col.value('@id','integer'),
	       tbl.col.value('@componentNameId','integer'),
	       tbl.col.value('@attrName','nvarchar(1024)'),
	       tbl.col.value('@attrType','integer'),
	       tbl.col.value('@attrVal','nvarchar(1024)'),
	       tbl.col.value('@created','integer'),
	       tbl.col.value('@modified','integer'),
	       tbl.col.value('@ccpId','integer')
	FROM   @MADataXml.nodes('MediaAgentData/App_ClientProp/row') tbl(col)
	INSERT INTO #CCM_APP_Platform
	SELECT tbl.col.value('@clientId','integer'),
	       tbl.col.value('@platformType','integer'),
	       tbl.col.value('@install_dir','nvarchar(255)'),
	       tbl.col.value('@refTime','integer')
	FROM   @MADataXml.nodes('MediaAgentData/App_Platform/row') tbl(col)
	INSERT INTO #CCM_IdxAccessPath
	SELECT tbl.col.value('@IdxAccessPathId','integer'),
	       tbl.col.value('@IdxCacheId','integer'),
	       tbl.col.value('@ClientId','integer'),
	       tbl.col.value('@Path','varchar(1024)'),
	       tbl.col.value('@Username','varchar(1024)'),
	       tbl.col.value('@Password','varchar(2048)'),
	       tbl.col.value('@Enabled','integer'),
	       tbl.col.value('@SoftState','integer'),
	       tbl.col.value('@OfflineReason','integer'),
	       tbl.col.value('@Priority','integer'),
	       tbl.col.value('@LocalIndexTimeStamp','integer'),
	       tbl.col.value('@ActualDaysIndexRetain','integer'),
	       tbl.col.value('@Flags','integer'),
	       tbl.col.value('@AgeingNoOfDays','integer'),
	       tbl.col.value('@AgeingPercentDiskspace','integer'),
	       tbl.col.value('@DiskFreeThresholdMB','integer'),
	       tbl.col.value('@DiskFreeWarningThreshholdMB','integer'),
	       tbl.col.value('@TotalCapacityMB','integer'),
	       tbl.col.value('@FreeDiskSpaceMB','integer'),
	       tbl.col.value('@DiskUsageMB','integer'),
	       tbl.col.value('@DiskUsageLastChecked','integer'),
	       tbl.col.value('@StagingCachePath','varchar(1024)'),
		   tbl.col.value('@VolumeGUID','varchar(1024)')
	FROM   @MADataXml.nodes('MediaAgentData/IdxAccessPath/row') tbl(col)
	INSERT INTO #CCM_APP_VMToPMMap
	SELECT tbl.col.value('@VMClientId','integer'),
	       tbl.col.value('@PMClientId','integer')
	FROM   @MADataXml.nodes('MediaAgentData/APP_VMToPMMap/row') tbl(col)
	---------------------------------------------------------
	--- CODE BELOW HERE IS FROM CCM_Merge_MediaAgent.spb  ----------
IF NOT EXISTS (SELECT * FROM #CCM_APP_Client)
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- NO Media Agent to Migrate , PLEASE CAPTURE DATA BEFORE MERGE'
		GOTO CX_ERROR_EXIT
	END
	DECLARE	@release_source varchar(128)
	DECLARE	@release_destination varchar(128)
	DECLARE @mergeToSameCommcell INTEGER
	DECLARE @curTime VARCHAR(1024)
  DECLARE @windowsMA INTEGER
SET @release_source = ISNULL((select top 1 release from #CCM_simAllGalaxyRel order by id desc),'N/A')
	SET @release_destination = ISNULL((select top 1 release from simAllGalaxyRel order by id desc),'N/A')
	---------------------------------------------------------
	---------------------------------------------------------
	-- Create Temp Table to be used by merge operation
	EXEC CCM_Merge_Map 1
	---------------------------------------------------------
--- CODE BELOW HERE IS FROM CCM_Merge_CommCell.spb  ----------
	IF EXISTS (SELECT *
FROM #CCM_APP_Commcell
WHERE type NOT IN (1,
100,
101,
102,
104,
105,
106,
108,
109
	                              ))
	BEGIN
	    SET @errorString = 'ERROR: CCM_Merge_CommCell -- Unknown Commcell Type in Captured database'
		GOTO CX_ERROR_EXIT
	END
	-- Update CommCell entry created by tape import.
	UPDATE APP_CommCell
	SET parentId = B.parentId,
		aliasName = B.aliasName,
		flags = B.flags,
		refTime = B.refTime,
		userName = B.userName,
		userPassword = B.userPassword,
		smtpServer = B.smtpServer,
		timeZone = B.timeZone,
		ipAddress = B.ipAddress,
		modified = B.modified,
		ccOpMode = B.ccOpMode,
		drIpAddress = B.drIpAddress,
		encNumber = B.encNumber,
		csGUID = B.csGUID,
		type = B.type
FROM APP_CommCell A INNER JOIN #CCM_APP_Commcell B ON A.number = B.number
	WHERE A.aliasName LIKE 'TapeImportedCommCell_%'
		AND A.csGUID = ''
		AND B.csGUID <> ''
	IF	@@ERROR > 0
	BEGIN
	    SET @errorString = 'ERROR: CCM_Merge_CommCell -- Update tape import created commcell entry.'
		GOTO CX_ERROR_EXIT
	END
	--Check for duplicate GUID with different number
	/* IF NOT EXISTS (SELECT 1 FROM MMConfigs where name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_DUPLICATE_GUID' and value = 1)
	BEGIN
		IF EXISTS
		(
	*/		--Check in source and destination
			INSERT INTO APP_InvalidGUID(GUID)
			SELECT DISTINCT a.csGUID
FROM #CCM_APP_Commcell a INNER JOIN APP_Commcell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	/*	)
		BEGIN
			SET @errorString = 'ERROR: Duplicate GUIDs with different CommcellId found in source and destination CommServes. Please contact customer support.'
			SET @errorString = @errorString + CHAR(13) + CHAR(10) + 'Following GUIDs are associated with more than one CommCellId'
			SELECT @errorString = @errorString + CHAR(13) + CHAR(10) +  b.csGUID
FROM #CCM_APP_Commcell a INNER JOIN APP_Commcell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
			GOTO CX_ERROR_EXIT
		END
	*/
	/*	IF EXISTS
		(
	*/		--Check in source and source
			INSERT INTO APP_InvalidGUID(GUID)
			SELECT DISTINCT a.csGUID
FROM #CCM_APP_Commcell a INNER JOIN #CCM_APP_Commcell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	/*	)
		BEGIN
			SET @errorString = 'ERROR: Duplicate GUIDs with different CommcellId found in source CommServe. Please contact customer support.'
			SET @errorString = @errorString + CHAR(13) + CHAR(10) + 'Following GUIDs are associated with more than one CommCellId'
			SELECT @errorString = @errorString + CHAR(13) + CHAR(10) +  b.csGUID
FROM #CCM_APP_Commcell a INNER JOIN #CCM_APP_Commcell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
			GOTO CX_ERROR_EXIT
		END
	*/
	/*	IF EXISTS
		(
	*/		--Check in destination and destination
			INSERT INTO APP_InvalidGUID(GUID)
			SELECT DISTINCT a.csGUID
			FROM APP_CommCell a INNER JOIN APP_CommCell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	/*	)
		BEGIN
			SET @errorString = 'ERROR: Duplicate GUIDs with different CommcellId found in destination CommServe. Please contact customer support.'
			SET @errorString = @errorString + CHAR(13) + CHAR(10) + 'Following GUIDs are associated with more than one CommCellId'
			SELECT @errorString = @errorString + CHAR(13) + CHAR(10) +  b.csGUID
			FROM APP_CommCell a INNER JOIN APP_CommCell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
			GOTO CX_ERROR_EXIT
		END
	END
	*/
	--Check for duplicate number with different GUID
	IF NOT EXISTS (SELECT 1 FROM MMConfigs WHERE name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_DUPLICATE_GUID' and value <> 0)
	BEGIN
		IF EXISTS
		(
			SELECT 1
FROM #CCM_APP_Commcell a INNER JOIN APP_Commcell b
				ON a.number = b.number AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND LEN(a.csGUID) > 0 AND a.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.csGUID <> b.csGUID
		)
		BEGIN
			SET @errorString = 'ERROR: Duplicate CommcellId with different GUIDs found in source and destination CommServes. Please contact customer support.'
			SET @errorString = @errorString + CHAR(13) + CHAR(10) + 'Following CommCellId is associated with more than one GUID'
			SELECT @errorString = @errorString + CHAR(13) + CHAR(10) +  CONVERT(varchar, b.number)
FROM #CCM_APP_Commcell a INNER JOIN APP_Commcell b
				ON a.number = b.number AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND LEN(a.csGUID) > 0 AND a.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.csGUID <> b.csGUID
			GOTO CX_ERROR_EXIT
		END
	END
/*	Code change to allow merging of different commcells using same license number together
	 Please note that we are checking for value = 2 here as this allows for the following:
	- default: error out if we encounter two commcells with same license but different guids (value not present or == 0)
	- allow merging two commcell's data with different guids but same license together into a single commcell (value == 1)
	   (means that we treat the commcells with same license numbers as the same commcell even if guids are different)
	- allow merging two commcell's data with different guids but same license together where different guids are
		interpreted as different commcells (value == 2 what this update is for)
  */
	IF EXISTS (SELECT 1 FROM MMConfigs WHERE name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_DUPLICATE_GUID' and value = 2)
	BEGIN
	  /* Change to allow importing data from two different commcells with different guids that have the same license number as
		  two different commcells */
UPDATE  #CCM_APP_Commcell
		SET number = -1
FROM #CCM_APP_Commcell a INNER JOIN APP_Commcell b
				ON a.number = b.number AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND LEN(a.csGUID) > 0 AND a.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.csGUID <> b.csGUID
	-- Setting the number to -1 in the merge db does the following:
	--     - it updates the incoming entry with same number and different guid to -1 in the merge db
	--     - it gets inserted as such in the mapping table.
	--	   -  the query mapping same numbers together will not hit as numbers are different
	-- 	   -  the query that updates a commcell number from unlicensed to licensed will also not pick this up as
	--         this is licensed in the CSDB but not in the merge db, so everything will work...
	END
	-- GET CommCellId TO BE MERGED
INSERT INTO CCM_MAP_CommCell
	SELECT DISTINCT id, 0, number, aliasName, type, csGUID, 0
FROM #CCM_APP_Commcell
	WHERE number <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	/*PrasadNara 1:56 PM 6/22/2012
	 * RackSpace has many commcells with the same guid 'D3DA843D-9BC8-4396-8782-88D73B6C7DBA', so treat it as invalid guid.
	 */
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.csGUID = b.csGUID
	AND a.type = b.type
AND a.type = 1   -- SIMPANA Commcells
	AND LEN(b.csGUID) > 0
	AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
	AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMPANA 1 - GUID Based'
		GOTO CX_ERROR_EXIT
	END
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.number = b.number
	AND a.type = b.type
AND a.type = 1   -- SIMPANA Commcells
	AND a.new_id = 0
	AND a.number <> -1
	AND b.number <> -1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMPANA 1 - number based'
		GOTO CX_ERROR_EXIT
	END
	-- If commcell no is -1 and CS GUID is 00000000-0000-0000-0000-000000000000
	-- then assume that the data is from current commcell. This is to support
	-- tape catalog of media written with eval licenses
UPDATE  CCM_MAP_CommCell SET new_id = 2
	WHERE new_id = 0 AND number = -1
	AND csGUID = '00000000-0000-0000-0000-000000000000'
	AND type = 1
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.aliasName = b.aliasName
	AND a.type = b.type
AND a.type IN (100,101,102,104,105,106, 108, 109)   -- Non-SIMPANA Commcells like NetApp, NetBackup etc
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- NON-SIMPANA 1'
		GOTO CX_ERROR_EXIT
	END
	--
	-- PrasadNara 12:28 PM 11/21/2012
	-- Update the commcell number if it is migrated previously with eval license
	-- and migrating it again after applying license.
	--
	UPDATE APP_CommCell
	SET number = a.number
FROM CCM_MAP_CommCell a INNER JOIN APP_CommCell b
		ON a.new_id = b.id
	WHERE a.number <> -1 AND b.number = -1 AND b.id > 2
		AND NOT EXISTS(SELECT 1 FROM App_CommCell WHERE number = a.number)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- APP_CommCell -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
UPDATE CCM_MAP_CommCell
	SET exist = 1
	WHERE new_id <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- APP_CommCell -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO APP_CommCell
	SELECT	b.number, 0, b.parentId, b.aliasName, b.flags, b.refTime,
			b.userName, b.userPassword, b.smtpServer, b.timeZone, b.ipAddress,
			b.modified, b.ccOpMode, b.drIpAddress, b.encNumber, b.csGUID, b.type
FROM CCM_MAP_CommCell a, #CCM_APP_Commcell b
	WHERE a.old_id = b.id AND a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- APP_CommCell -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	/*
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.number = b.number AND a.new_id = 0
	AND a.type = b.type
AND a.type = 1 -- SIMPANA Commcells
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMAPANA -- 2'
		GOTO CX_ERROR_EXIT
	END
	*/
	/*
	Updating the map table for the new rows inserted in destination App_Commcell - based in GUIDs not based on numbers
	change to support migration even with eval License (number will be -1)
	*/
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.csGUID = b.csGUID AND a.new_id = 0
	AND a.type = b.type
AND a.type = 1 -- SIMPANA Commcells
	AND LEN(b.csGUID) > 0
	AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
	AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMAPANA -- 2'
		GOTO CX_ERROR_EXIT
	END
	--Update the map table based on number incase of empty GUID
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.number = b.number AND a.new_id = 0
	AND a.type = b.type
AND a.type = 1 -- SIMPANA Commcells
	AND b.id > 1
	AND a.number <> -1
	AND b.number <> -1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMAPANA -- 3'
		GOTO CX_ERROR_EXIT
	END
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.aliasName = b.aliasName AND a.new_id = 0
	AND a.type = b.type
AND a.type IN (100,101,102,104,105,106, 108, 109) -- Non-SIMPANA Commcells like NetApp, NetBackup etc
	AND b.id > 1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- NON-SIMAPANA -- 2'
		GOTO CX_ERROR_EXIT
	END
	--Fail merge incase of new commcell id is 0 or 1
IF EXISTS(SELECT 1 FROM CCM_MAP_CommCell WHERE new_id = 0 OR new_id = 1)
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- new_id is 0 or 1'
		GOTO CX_ERROR_EXIT
	END
--- CODE BELOW HERE IS FROM CCM_Merge_Client.spb  ----------
	DECLARE @tblBeforeMerge TABLE (id INT)
	DECLARE @Merge_To_Same_CommCell int
IF EXISTS (SELECT * FROM CCM_MAP_CommCell WHERE new_id = 2 and old_id = 2)
		SET @Merge_To_Same_CommCell = 1
	ELSE
		SET @Merge_To_Same_CommCell = 0
	DECLARE	@tmpFileSystemAppType TABLE ( appTypeId integer)
	INSERT	@tmpFileSystemAppType
	SELECT	DISTINCT type FROM APP_idaType WHERE displayName = 'File System'
-- DB: fix changed tabls
DECLARE @dummy_ccpId INTEGER
SET @dummy_ccpId = 0
DECLARE @dummy_ccpTime INTEGER
SET @dummy_ccpTime = 0
DECLARE @dummy_GUID NVARCHAR(max)
SET @dummy_GUID = '00000000-0000-0000-0000-000000000000'
DECLARE @migratedClientFlag INTEGER = 0x20
IF (@ccmParamFlags & 8) = 8
SET @migratedClientFlag = (@migratedClientFlag | 0x200)
	ELSE
SET @migratedClientFlag = (@migratedClientFlag | 0x2)
	DECLARE @l_RowCount int = 0
	DECLARE @l_ErrorCode int = 0
/*
	-------------------------------------------------------------------------------------------------------------------------------------
	     Source Commcell             Destination Commcell           exists            Action
	Name   hostname  origCCId      Name    hostname    oridCCId
	-------------------------------------------------------------------------------------------------------------------------------------
	 A        B         2                                             0        First Time Merge, proceed fine
	 A        B         2           A         B           3           1        Number corresponding to 2 and 3 are same, Remerge usecase
	 A        B         2           A       non-B         3           1        Number corresponding to 2 and 3 are same ???
	 A        B         2         non-A       B           3           1        Number corresponding to 2 and 3 are same ???
	 A        B         2         non-A     non-B         3           1        Merge of a new client, first time merge
	 A        B         2           A         B           3           0        Number corresponding to 2 and 3 are different
	                                                                           ???
     A        B         2           A       non-B         3           0        Number corresponding to 2 and 3 are different
	                                                                           ???
     A        B         2         non-A       B           3           0        Number corresponding to 2 and 3 are different
	                                                                           ???
     A        B         2         non-A     non-B         3           0        Number corresponding to 2 and 3 are different
																			   First time merge, proceed fine
	-------------------------------------------------------------------------------------------------------------------------------------
*/
	-- Merge APP_Client table
UPDATE #CCM_APP_Client
	SET    origCCId = 2
	WHERE  origCCId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_APP_Client -- UPDATE -- origCCId'
		GOTO CX_ERROR_EXIT
	END
	IF (@ccmParamFlags & 1) = 1
	BEGIN
		--For GRC mark client as GRC migrated client and set flag if client is uninstalled in source
UPDATE #CCM_APP_Client
SET    specialClientFlags = CASE (specialClientFlags & 0x2) WHEN 0 THEN (specialClientFlags | 0x80)
ELSE (specialClientFlags | 0x80 | 0x40) END
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_APP_Client -- UPDATE -- specialClientFlags'
			GOTO CX_ERROR_EXIT
		END
		-- If client is deconfigured on source then set flag.
UPDATE #CCM_APP_Client
SET    specialClientFlags = specialClientFlags | 0x40
FROM #CCM_APP_Client CL
WHERE CL.status & 0x00002 = 0x00002
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_APP_Client -- UPDATE 2 -- specialClientFlags'
			GOTO CX_ERROR_EXIT
		END
	END
	-- Set csHostName for discovered VMs.
	/*
	DECLARE @csHostName VARCHAR(1024)
	SET @csHostName = ( SELECT net_hostname FROM APP_Client WHERE id = 2 )
UPDATE #CCM_APP_Client
	SET csHostName = @csHostName
FROM #CCM_APP_Client
WHERE specialClientFlags & 0xB = 0xB
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_DB_APP_CLIENT -- Failed to set csHostName for Discovered VMs'
		GOTO CX_ERROR_EXIT
	END
	*/
	-- GET ClientId TO BE MERGED
INSERT INTO CCM_MAP_Client
	SELECT DISTINCT id, 0, name, name, net_hostname, net_hostname, origCCId, 0, 0, 0
FROM #CCM_APP_Client
	-- Remove the ones has no Client Id. It may come from Tape Import
	WHERE id > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Update the new_origCCcommCellId
	-- old_origCCcommCellId will never have 0 as it is always defaulted to 2
UPDATE CCM_MAP_Client SET new_origCCcommCellId = ISNULL((SELECT new_id FROM CCM_MAP_CommCell WHERE old_id = old_origCCcommCellId), (SELECT new_id FROM CCM_MAP_CommCell WHERE old_id = 2 /*Source CS*/))
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new_origCCcommCellId'
		GOTO CX_ERROR_EXIT
	END
	-- Give client new net_hostname if it was empty on destination
	UPDATE APP_Client SET net_hostname = b.new_net_hostname
FROM APP_Client a, CCM_MAP_Client b
	WHERE a.name = b.new_name
	AND a.net_hostname = ''
	AND b.new_net_hostname <> ''
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- Client -- UPDATE net_hostname'
		GOTO CX_ERROR_EXIT
	END
	UPDATE App_Client
	SET --name = mapC.new_name,
		simOperatingSystemId = srcC.simOperatingSystemId,
		--net_hostname = mapC.new_net_hostName,
		client_password = srcC.client_password,
		refTime = srcC.refTime,
		modified = srcC.modified,
		offlineEntity = srcC.offlineEntity,
		offlineTimeStamp = srcC.offlineTimeStamp,
		csHostName = srcC.csHostName,
		clientDescription = srcC.clientDescription,
		jobResultDir = srcC.jobResultDir,
		clientSkewTime = srcC.clientSkewTime,
		cvdPort = srcC.cvdPort,
		evmgrcPort = srcC.evmgrcPort,
		status = srcC.status,
		releaseId = srcC.releaseId,
		spaceCheckFlags = srcC.spaceCheckFlags,
		ccpId = srcC.ccpId,
		ccpTime = srcC.ccpTime,
		origCCId = mapC.new_origCCcommCellId,
		GUID = srcC.GUID,
		specialClientFlags = CASE WHEN @Merge_To_Same_CommCell > 0 THEN srcC.specialClientFlags ELSE (srcC.specialClientFlags | @migratedClientFlag) END
FROM App_Client destC, CCM_MAP_Client mapC, #CCM_APP_Client srcC
	WHERE destC.origCCId = 2
	AND destC.id > 2
	AND (destC.specialClientFlags & 2) > 0
	AND (destC.name = mapC.new_name OR destC.net_hostname = mapC.new_net_hostName)
	AND mapC.old_id = srcC.id
	AND srcC.id  = 2
	AND srcC.origCCId = 2
	AND srcC.net_hostName <> ''
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- Update CommNet DummyClient Row'
		GOTO CX_ERROR_EXIT
	END
	--if client is already imported by tapeimport job, then update all the client details.
	UPDATE APP_Client
	SET	name = D.name,
		simOperatingSystemId = D.simOperatingSystemId,
		net_hostname = D.net_hostname,
		client_password = D.client_password,
		refTime = D.refTime,
		modified = D.modified,
		offlineEntity = D.offlineEntity,
		offlineTimeStamp = D.offlineTimeStamp,
		csHostName = D.csHostName,
		clientDescription = D.clientDescription,
		jobResultDir = D.jobResultDir,
		clientSkewTime = D.clientSkewTime,
		cvdPort = D.cvdPort,
		evmgrcPort = D.evmgrcPort,
		status = D.status,
		releaseId = D.releaseId,
		spaceCheckFlags = D.spaceCheckFlags,
		ccpId = D.ccpId,
		ccpTime = D.ccpTime,
		GUID = D.GUID,
		specialClientFlags = D.specialClientFlags,
		displayName = D.displayName
FROM APP_Client A,CCM_TapeImportEntities B, CCM_MAP_CommCell C, #CCM_APP_Client D
WHERE A.id = B.new_id AND B.old_id = D.id AND C.new_id = B.newCCId AND B.entityType = 3
AND (D.specialClientFlags & 0x100) = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE For TapeImported client'
		GOTO CX_ERROR_EXIT
	END
	/*
	 *PrasadNara: 10:33 AM 6/20/2012 Set exist based on below conditions
	 * If client guid matches consider that as remerge of same client
	 * If client guid does NOT match but both client Name and Host Name matches then treat it as remerge case only when config param is set or for EDC or for TapeImport
	 * If client guid does NOT match, client name does NOT match, client host name matches consider that as new entry and merge successfully
	 * If client guid does NOT match, client name matches, client host name does NOT match fail saying name conflict
	 * If client guid does NOT match, both client name and client host name does NOT match consider that as new entry and merge successfully
	 */
	--Match with GUID
UPDATE CCM_MAP_Client SET exist = 1, new_id = b.id
FROM CCM_MAP_Client a, APP_Client b, #CCM_APP_Client c
	WHERE a.old_id = c.id AND b.GUID = c.GUID
		AND LEN(b.GUID) > 0 AND b.GUID <> '00000000-0000-0000-0000-000000000000'
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE exist matching GUID'
		GOTO CX_ERROR_EXIT
	END
	--Client name and net host name both matches
	IF EXISTS (SELECT 1 FROM MMConfigs where name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_CLIENT_GUID_CONFLICT' and value = 1)
    BEGIN
		-- net_hostname will be empty for client migrated through tape import
UPDATE CCM_MAP_Client SET exist = 1, new_id = b.id
FROM CCM_MAP_Client a, APP_Client b
		WHERE a.new_name = b.name
		AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
		AND exist <> 1
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE exist'
			GOTO CX_ERROR_EXIT
		END
	END
	--Match with name and hostname where GUID doesn't exists
UPDATE CCM_MAP_Client SET exist = 1, new_id = b.id
FROM CCM_MAP_Client a, APP_Client b, #CCM_APP_Client c
	WHERE a.new_name = b.name
		AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
		AND (LEN(c.GUID) = 0 OR c.GUID = '00000000-0000-0000-0000-000000000000')
		AND exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE exist matching name and hostname'
		GOTO CX_ERROR_EXIT
	END
	UPDATE 	APP_Client
	SET 	name = b.name + '_old_' + CAST(b.id AS NVARCHAR(64)),
			net_hostname = b.net_hostname + '_old_' + CAST(b.id AS NVARCHAR(64))
FROM 	CCM_MAP_Client a
		INNER JOIN APP_Client b ON a.new_name = b.name
		INNER JOIN APP_ClientProp c ON c.componentNameId = b.id AND c.attrName = 'OwnerCommCellId'
INNER JOIN #CCM_APP_Client e ON a.old_id = e.id
INNER JOIN CCM_MAP_CommCell d ON d.new_id = CAST(c.attrVal AS INT) AND d.old_id = 2
	WHERE	a.exist = 0
		AND e.GUID <> b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new name for index clients.'
		GOTO CX_ERROR_EXIT
	END
	--Update name if it's changed in source
	--Before update check if new name is conflicting with any other existing clients on destination
	IF OBJECT_ID('tempdb..#lt_ClientNameConflict') IS NOT NULL DROP TABLE #lt_ClientNameConflict
	CREATE TABLE #lt_ClientNameConflict (name nvarchar(512), destNetHostName nvarchar(512), destGUID uniqueidentifier, srcNetHostName nvarchar(512), srcGUID uniqueidentifier)
	IF OBJECT_ID('tempdb..#lt_ClientConflict') IS NOT NULL DROP TABLE #lt_ClientConflict
	CREATE TABLE #lt_ClientConflict (oldClientId INT)
	INSERT 	INTO #lt_ClientConflict
	SELECT 	a.old_id
FROM 	CCM_MAP_Client a, APP_Client b, #CCM_APP_Client c
	WHERE	a.exist = 1
			AND a.old_id = c.id
			AND a.new_id <> b.id
			AND a.new_name = b.name
AND	(b.specialClientFlags & 0x20) > 0
	SELECT @l_ErrorCode = @@ERROR, @l_RowCount = @@ROWCOUNT
	IF	@l_ErrorCode > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT Existing Client Name Conflict'
		GOTO CX_ERROR_EXIT
	END
	IF @l_RowCount > 0
	BEGIN
UPDATE 	CCM_MAP_Client
		SET 	new_name = a.new_name + '_CCM_' + CAST(dbo.GetUnixTime(getDate()) AS NVARCHAR(256))
FROM 	CCM_MAP_Client a INNER JOIN #lt_ClientConflict b ON a.old_Id = b.oldClientId
	END
	--Before updating name check for Host Name and CVD port conflict
	IF NOT EXISTS (SELECT * FROM MMConfigs where name = 'CCM_CONFIG_ALLOW_CCM_FOR_CLIENTS_WITH_SAME_HOSTNAME_CVDPORT' AND value = 1)
	BEGIN
		INSERT 	INTO #lt_ClientNameConflict
		SELECT 	b.name, b.net_hostname destNetHostName, b.guid destGUID, a.new_net_hostname srcNetHostName, c.guid srcGUID
FROM 	CCM_MAP_Client a, APP_Client b, #CCM_APP_Client c
		WHERE	a.exist = 1
				AND a.old_id = c.id
				AND a.new_id <> b.id
				AND a.new_net_hostname = b.net_hostname
				AND a.new_net_hostname <> ''
				AND c.cvdPort = b.cvdPort
AND	(b.specialClientFlags & 0x20) > 0
		SELECT @l_ErrorCode = @@ERROR, @l_RowCount = @@ROWCOUNT
		IF	@l_ErrorCode > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT Existing Client HostName and CVD port Conflict'
			GOTO CX_ERROR_EXIT
		END
		IF @l_RowCount > 0
		BEGIN
			SET @errorString = 'ERROR: Client hostname and CVD port conflict. ADVICE: 1. Change the clients host name either on source CommServe or destination CommServe. OR  2. Set "Allow CCM job when multiple clients exists with same host name and cvd port" parameter value to 1 in Media Management configuration when duplicate host name is expected.'
			SELECT 	@errorString = @errorString + CHAR(13) + 'Client [' + name + '] already present with host name ['+ destNetHostName + '] and guid ['+ convert(varchar(50), destGUID) + ']. Importing client host name ['+ srcNetHostName + '] and guid ['+ convert(varchar(50), srcGUID) + '].'
			FROM #lt_ClientNameConflict
			GOTO CX_ERROR_EXIT
		END
	END
	--Update properties of existing clients
	UPDATE		APP_Client
	SET			name 				= b.new_name,
				net_hostname		= b.new_net_hostname,
				simOperatingSystemId= c.simOperatingSystemId,
				client_password		= c.client_password,
				refTime				= c.refTime,
				modified			= c.modified,
				offlineEntity       = c.offlineEntity,
				offlineTimeStamp	= c.offlineTimeStamp,
				clientDescription	= c.clientDescription,
				jobResultDir		= c.jobResultDir,
				clientSkewTime		= c.clientSkewTime,
				cvdPort				= c.cvdPort,
				evmgrcPort			= c.evmgrcPort,
				releaseId			= c.releaseId,
				spaceCheckFlags		= c.spaceCheckFlags,
				displayName			= c.displayName,
				status				= c.status
FROM		APP_Client a, CCM_MAP_Client b, #CCM_APP_Client c
	WHERE		b.exist = 1
				AND	a.id = b.new_id AND b.old_id = c.id
AND	(a.specialClientFlags & 0x20) > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE Existing client properties'
		GOTO CX_ERROR_EXIT
	END
	--Check client name conflict
	DELETE #lt_ClientConflict
	INSERT INTO #lt_ClientConflict
	SELECT 	a.old_id
FROM 	CCM_MAP_Client a, APP_Client b, #CCM_APP_Client c
	WHERE 	a.exist = 0
			AND a.old_id = c.id
			AND a.new_name = b.name
	SELECT @l_ErrorCode = @@ERROR, @l_RowCount = @@ROWCOUNT
	IF	@l_ErrorCode > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT Client Name Conflict'
		GOTO CX_ERROR_EXIT
	END
	IF @l_RowCount > 0
	BEGIN
UPDATE 	CCM_MAP_Client
		SET 	new_name = a.new_name + '_CCM_' + CAST(dbo.GetUnixTime(getDate()) AS NVARCHAR(256))
FROM 	CCM_MAP_Client a INNER JOIN #lt_ClientConflict b ON a.old_Id = b.oldClientId
	END
	--Check for Host Name and CVD port conflict
	IF NOT EXISTS (SELECT * FROM MMConfigs where name = 'CCM_CONFIG_ALLOW_CCM_FOR_CLIENTS_WITH_SAME_HOSTNAME_CVDPORT' AND value = 1)
	BEGIN
		INSERT 	INTO #lt_ClientNameConflict
		SELECT 	b.name, b.net_hostname destNetHostName, b.guid destGUID, a.new_net_hostname srcNetHostName, c.guid srcGUID
FROM 	CCM_MAP_Client a, APP_Client b, #CCM_APP_Client c
		WHERE	a.exist = 0
				AND a.old_id = c.id
				AND a.new_net_hostname = b.net_hostname
				AND a.new_net_hostname <> ''
				AND c.cvdPort = b.cvdPort
		SELECT @l_ErrorCode = @@ERROR, @l_RowCount = @@ROWCOUNT
		IF	@l_ErrorCode > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT Existing Client HostName and CVD port Conflict'
			GOTO CX_ERROR_EXIT
		END
		IF @l_RowCount > 0
		BEGIN
			SET @errorString = 'ERROR: Client hostname and CVD port conflict. ADVICE: 1. Change the clients host name either on source CommServe or destination CommServe. OR  2. Set "Allow CCM job when multiple clients exists with same host name and cvd port" parameter value to 1 in Media Management configuration when duplicate host name is expected.'
			SELECT 	@errorString = @errorString + CHAR(13) + 'Client [' + name + '] already present with host name ['+ destNetHostName + '] and guid ['+ convert(varchar(50), destGUID) + ']. Importing client host name ['+ srcNetHostName + '] and guid ['+ convert(varchar(50), srcGUID) + '].'
			FROM #lt_ClientNameConflict
			GOTO CX_ERROR_EXIT
		END
	END
	-- Old client id should be reused if merge to the same commserver and id not being resued
UPDATE	CCM_MAP_Client SET reuseOldId = 1
FROM	CCM_MAP_Client
	WHERE	@Merge_To_Same_CommCell > 0
	AND		old_id NOT IN (SELECT id FROM APP_Client)
	AND		exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE reuseOldId'
		GOTO CX_ERROR_EXIT
	END
	SET IDENTITY_INSERT APP_Client ON
	INSERT	INTO APP_Client (
			id, name, simOperatingSystemId, net_hostname,
			client_password, refTime, modified, offlineEntity,
			offlineTimeStamp, csHostName, clientDescription,
			jobResultDir, clientSkewTime, cvdPort, evmgrcPort, status, releaseId,
			spaceCheckFlags,ccpId,ccpTime,origCCId,GUID,specialClientFlags,displayName
			)
	SELECT	a.old_id, a.new_name, b.simOperatingSystemId, a.new_net_hostname, b.client_password, b.refTime,
			b.modified, b.offlineEntity, b.offlineTimeStamp, b.csHostName,
			b.clientDescription, b.jobResultDir, b.clientSkewTime,
			b.cvdPort, b.evmgrcPort, b.status, b.releaseId,
			b.spaceCheckFlags, b.ccpId, b.ccpTime, a.new_origCCcommCellId, b.GUID,
			CASE WHEN @Merge_To_Same_CommCell > 0 THEN b.specialClientFlags ELSE (b.specialClientFlags | @migratedClientFlag) END,
			b.displayName
FROM	CCM_MAP_Client a, #CCM_APP_Client b
	WHERE	a.old_name = b.name AND a.old_net_hostname = b.net_hostname
	AND		a.reuseOldId = 1
	AND		a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET IDENTITY_INSERT APP_Client OFF
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- INSERT using old_Id'
		GOTO CX_ERROR_EXIT
	END
	SET IDENTITY_INSERT APP_Client OFF
-- DB: Fix Table Change
	INSERT	INTO APP_Client
	SELECT	a.new_name, b.simOperatingSystemId, a.new_net_hostname, b.client_password, b.refTime,
			b.modified, b.offlineEntity, b.offlineTimeStamp, b.csHostName,
			b.clientDescription, b.jobResultDir, b.clientSkewTime,
			b.cvdPort, b.evmgrcPort, b.status, b.releaseId,
			b.spaceCheckFlags, b.ccpId, b.ccpTime, a.new_origCCcommCellId, b.GUID,
			CASE WHEN @Merge_To_Same_CommCell > 0 THEN b.specialClientFlags ELSE (b.specialClientFlags | @migratedClientFlag) END,
			b.displayName
FROM	CCM_MAP_Client a, #CCM_APP_Client b
	WHERE	a.old_name = b.name AND a.old_net_hostname = b.net_hostname
	AND		a.reuseOldId = 0
	AND		a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- INSERT creating new_Id'
		GOTO CX_ERROR_EXIT
	END
UPDATE	CCM_MAP_Client SET new_id = b.id
FROM	CCM_MAP_Client a, APP_Client b, #CCM_APP_Client c
	WHERE	a.old_id = c.id AND b.GUID = c.GUID
			AND LEN(b.GUID) > 0 AND b.GUID <> '00000000-0000-0000-0000-000000000000'
			AND a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new_id matching GUID'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS (SELECT 1 FROM MMConfigs where name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_CLIENT_GUID_CONFLICT' and value = 1)
    BEGIN
UPDATE	CCM_MAP_Client SET new_id = b.id
FROM	CCM_MAP_Client a, APP_Client b
		WHERE	a.new_name = b.name AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
			AND a.new_id = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new_id'
			GOTO CX_ERROR_EXIT
		END
	END
UPDATE	CCM_MAP_Client SET new_id = b.id
FROM	CCM_MAP_Client a, APP_Client b, #CCM_APP_Client c
	WHERE	a.old_id = c.id
			AND a.new_name = b.name AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
			AND (LEN(c.GUID) = 0 OR c.GUID = '00000000-0000-0000-0000-000000000000')
			AND a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new_id matching name and hostname'
		GOTO CX_ERROR_EXIT
	END
	UPDATE		APP_Client
	SET			client_password		= c.client_password,
				refTime						= c.refTime,
				modified					= c.modified,
				clientDescription	= c.clientDescription,
				jobResultDir			= c.jobResultDir,
				clientSkewTime		= c.clientSkewTime,
				cvdPort						= c.cvdPort,
				evmgrcPort				= c.evmgrcPort,
				--status						= c.status,
				releaseId					= c.releaseId,
specialClientFlags			=  CASE WHEN (a.specialClientFlags & 0x20) > 0
												THEN (@migratedClientFlag | c.specialClientFlags)
												ELSE (c.specialClientFlags & (~CAST((@migratedClientFlag) AS int)))
											   END
FROM		APP_Client a, CCM_MAP_Client b, #CCM_APP_Client c
	WHERE		b.exist = 1
	AND			a.id = b.new_id AND b.old_id = c.id
	AND			a.releaseId < c.releaseId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE release id'
		GOTO CX_ERROR_EXIT
	END
	IF (@ccmParamFlags & 1) = 0
	BEGIN
		-- Update the csHostName if client is pointing to source CS and destination CS contains different csHostName.
		UPDATE	APP_Client
		SET     csHostName =  c.csHostName
FROM	APP_Client a, CCM_MAP_Client b, #CCM_APP_Client c
		WHERE	b.exist = 1
		AND		a.id = b.new_id AND b.old_id = c.id
		AND     a.csHostName <> '' AND a.csHostName <> c.csHostName
AND     (a.specialClientFlags & 0x20) > 0
AND     (c.specialClientFlags & 0x20) = 0
		IF      @@ERROR > 0
		BEGIN
		        SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE csHostName'
		        GOTO CX_ERROR_EXIT
		END
IF (@ccmParamFlags & 8) = 8
		BEGIN
			-- Set remote commcell client flag if merge is RemoteCommCell client merge.
			UPDATE		APP_Client
SET			specialClientFlags			= (a.specialClientFlags | @migratedClientFlag & (~CAST(0x2 AS INT)))
FROM		APP_Client a, CCM_MAP_Client b
			WHERE		b.exist = 1
			AND			a.id = b.new_id
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE specialClientFlags - RemoteCommCellClient'
				GOTO CX_ERROR_EXIT
			END
		END
		ELSE
		BEGIN
			-- Reset grc flags
			UPDATE  APP_Client
SET     specialClientFlags = (a.specialClientFlags & (~CAST((0x80) AS int)) & (~CAST((0x40) AS int)))
FROM    APP_Client a, CCM_MAP_Client b
			WHERE   b.exist = 1
			AND     a.id = b.new_id
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE specialClientFlags'
				GOTO CX_ERROR_EXIT
			END
		END
	END
	--PrasadNara 2:38 PM 7/23/2012 For push MA update all properties of client
	UPDATE	APP_Client
	SET			name 				= b.new_name,
				--net_hostname		= b.new_net_hostname,
				simOperatingSystemId= c.simOperatingSystemId,
				client_password		= c.client_password,
				refTime				= c.refTime,
				modified			= c.modified,
				offlineEntity       = c.offlineEntity,
				offlineTimeStamp	= c.offlineTimeStamp,
				clientDescription	= c.clientDescription,
				jobResultDir		= c.jobResultDir,
				clientSkewTime		= c.clientSkewTime,
				cvdPort				= c.cvdPort,
				evmgrcPort			= c.evmgrcPort,
				--status				= c.status,
				releaseId			= c.releaseId,
				spaceCheckFlags		= c.spaceCheckFlags,
specialClientFlags	= CASE WHEN (a.specialClientFlags & 0x20) > 0
										THEN (@migratedClientFlag | c.specialClientFlags)
										ELSE (c.specialClientFlags  & (~CAST((@migratedClientFlag) AS int)))
									  END,
				displayName			= c.displayName
FROM		APP_Client a, CCM_MAP_Client b, #CCM_APP_Client c
	WHERE		b.exist = 1
	AND			a.id = b.new_id AND b.old_id = c.id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE PushMA all properties'
		GOTO CX_ERROR_EXIT
	END
	/*
	IF EXISTS(SELECT *
FROM   APP_Client a, CCM_MAP_Client b, #CCM_APP_Client c
	          WHERE  b.exist = 1
	          AND    a.id = b.new_id
	          AND    b.old_id = c.id
	          AND    c.releaseId < a.releaseId)
	BEGIN
		SET @errorString = 'ERROR: Source Clients are of older version'
		GOTO CX_ERROR_EXIT
	END
	*/
	----------------------------------------------------------
	-- If the clientId associated with the commcell is not migrated,
	-- reset it to 0
UPDATE #CCM_APP_Commcell
	SET clientId = 0
WHERE clientId NOT IN (SELECT old_id FROM CCM_MAP_Client)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_APP_CommCell -- UPDATE -- clientId'
		GOTO CX_ERROR_EXIT
	END
-- Update clientId column of App_Commcell (CCM_MAP_Client)
	-- for both fresh merge as well as re-merge use cases
	UPDATE APP_CommCell
	SET clientId = d.new_id
FROM APP_CommCell a, CCM_MAP_CommCell b, #CCM_APP_Commcell c, CCM_MAP_Client d
	WHERE a.id = b.new_id
	  AND b.old_id = c.id
	  AND c.clientId <> 0
	  AND a.id <> 2 --Don't touch the existing default commcell entry
	  AND d.old_id = c.clientId
	  AND d.new_id <> 2 --Don't set clientId 2 to migrated CommCell entries
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_CommCell -- UPDATE clientId'
		GOTO CX_ERROR_EXIT
	END
	-- Merge APP_ClientProp table
    --kbora
	--if client is already is imported by tapeimport job, then update all the properties with CCM information
DELETE APP_ClientProp WHERE componentNameId IN (SELECT new_id FROM CCM_TapeImportEntities WHERE entityType = 3)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client --  -- Delete TapeImport properites'
		GOTO CX_ERROR_EXIT
	END
	-- Delete client properties in remerge case if client is already present on dest and modified on source
	DELETE APP_ClientProp
FROM APP_ClientProp A INNER JOIN CCM_MAP_Client B ON A.componentNameId = B.new_Id INNER JOIN #CCM_APP_Client C ON B.old_Id = C.id INNER JOIN APP_Client D ON B.new_Id = D.id
	WHERE B.exist = 1 AND C.modified > D.modified AND A.componentNameId = D.id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- DELETE '
		GOTO CX_ERROR_EXIT
	END
	-- update client modified time in remerge case if client is already present on dest and modified on source
	UPDATE APP_Client
	SET modified = C.modified
FROM APP_Client A INNER JOIN CCM_MAP_Client B ON A.id = B.new_id INNER JOIN #CCM_APP_Client C ON B.old_Id = C.id
	WHERE A.modified < C.modified AND B.exist = 1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE modified in re-migration case'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO CCM_MAP_ClientProp
	SELECT	componentNameId, 0, attrName, attrType, attrVal, created, modified, 0
FROM	#CCM_APP_ClientProp
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_ClientProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ClientProp SET new_componentNameId = b.new_id
FROM	CCM_MAP_ClientProp a, CCM_MAP_Client b
	WHERE	a.old_componentNameId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_ClientProp -- UPDATE new_componentNameId'
		GOTO CX_ERROR_EXIT
	END
	-- Setting passwords to empty.
	UPDATE CMC
	SET attrVal = '' FROM
	CCM_MAP_ClientProp CMC
	INNER JOIN
	APP_CredProps ACP WITH(NOLOCK)
ON ACP.attrPwdName = CMC.attrName AND ACP.cs_attrPwdName = CHECKSUM(CMC.attrName) AND ACP.tableId = 21
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_ClientProp -- Setting passwords to empty.'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(SELECT * FROM CCM_MAP_ClientProp WHERE new_componentNameId = 0)
	BEGIN
		SET @errorString = 'ERROR: New ClientIds not found for APP_ClientProp'
		GOTO CX_ERROR_EXIT
	END
	--Disable Snap Backup properites.
	IF EXISTS(SELECT * FROM CCM_MAP_ClientProp WHERE attrName = 'Snap Backups Enabled')
	BEGIN
		UPDATE CCM_MAP_ClientProp
		SET	attrVal = '0'
		WHERE attrName = 'Snap Backups Enabled' AND attrVal <> '0'
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- Disable Snap Backup properties'
			GOTO CX_ERROR_EXIT
		END
	END
	--Set client cache to CS cache
	IF EXISTS(SELECT * FROM CCM_MAP_ClientProp WHERE attrName = 'UPDATE CACHE AGENT ID')
	BEGIN
		UPDATE CCM_MAP_ClientProp
		SET attrVal = '0'
		WHERE attrName = 'UPDATE CACHE AGENT ID' AND attrVal <> '0'
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- Change software cache to CS '
			GOTO CX_ERROR_EXIT
		END
	END
	--Map Detect MediaAgent for NDMP Server
	IF EXISTS(SELECT 1 FROM CCM_MAP_ClientProp WHERE attrName = 'Detect Media Agent for NDMP Server' AND attrVal <> '0')
	BEGIN
		UPDATE 	CCM_MAP_ClientProp
		SET 	attrVal = CONVERT(varchar(50), ISNULL(b.new_id, 0))
FROM	CCM_MAP_ClientProp a LEFT OUTER JOIN CCM_MAP_Client b ON CONVERT(INT, a.attrVal) = b.old_id
		WHERE 	a.attrName = 'Detect Media Agent for NDMP Server' AND a.attrVal <> '0'
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- Map Detect MediaAgent for NDMP Server '
			GOTO CX_ERROR_EXIT
		END
	END
        -- Begin -Re-map of Proxy clientId for Exchange DAG property
	IF EXISTS(SELECT * FROM CCM_MAP_ClientProp where attrname = 'DAG proxy client')
	BEGIN
		UPDATE 	CCM_MAP_ClientProp
		SET 	attrVal = CAST(ISNULL(b.new_id, '0') AS NVARCHAR)
		FROM	CCM_MAP_ClientProp a
LEFT OUTER JOIN CCM_MAP_Client b ON b.old_id = CAST(a.attrVal AS INTEGER)
		WHERE 	a.attrname = 'DAG proxy client'
				AND b.new_id > 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_ClientProp -- UPDATE - DAG proxy client'
			GOTO CX_ERROR_EXIT
		END
		--Unset DAG use proxy client property if proxy client is not migrated.
		UPDATE 	CCM_MAP_ClientProp
		SET		attrVal = '0'
		WHERE 	attrname = 'DAG use proxy client'  AND modified = 0
				AND NOT EXISTS(SELECT 1 FROM CCM_MAP_ClientProp a WHERE a.attrname = 'DAG proxy client' AND CONVERT(int, ISNULL(attrVal, '0')) > 0  AND modified = 0
									AND a.old_componentNameId = old_componentNameId AND a.new_componentNameId = new_componentNameId)
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_ClientProp -- UPDATE - DAG use proxy client '
			GOTO CX_ERROR_EXIT
		END
	END
	-- End - Re-map of Proxy clientId for Exchange DAG property
	-- Set the owner commcellId
	UPDATE 	CCM_MAP_ClientProp
	SET 	attrVal = CONVERT(VARCHAR(64), B.new_Id)
FROM 	CCM_MAP_ClientProp A INNER JOIN CCM_MAP_CommCell B ON CONVERT(INT, A.attrVal) = B.old_Id AND A.attrName = 'OwnerCommCellId'
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- Failed update OwnerCommCellId. '
		GOTO CX_ERROR_EXIT
	END
	-- For property with histories kept in database only
	-- Update modified if property was modified on source but not on destination
	UPDATE	APP_ClientProp SET modified = b.modified
	FROM	APP_ClientProp a, CCM_MAP_ClientProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.created = b.created
	AND		a.modified = 0 AND b.modified <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	-- Update the attrVal if source has the latest setting for a property
	UPDATE	APP_ClientProp SET attrVal = b.attrVal
	FROM	APP_ClientProp a, CCM_MAP_ClientProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.modified = 0 AND b.modified = 0
	AND		a.created < b.created
	-- The list of client properties that we don't want to update
	-- 'Content Indexing Enable' involves with license issue, and cannot be turned on/off by only setting this attribute
	AND		a.attrName NOT IN ('Content Indexing Enabled','Snap Backups Enabled')
	AND a.attrName not like ('%platformdeleted%') --We cannot blindly update this property as it depends on license consumption, this property will be taken care when we call EXEC AppConfDeconf on the client when license related stuffs are taken care in CCMManager
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ClientProp SET exist = 1
	FROM	CCM_MAP_ClientProp a, APP_ClientProp b
	WHERE	a.new_componentNameId = b.componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		(a.created = b.created OR a.modified = 0 AND b.modified = 0)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_ClientProp -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ClientProp
	SET attrName = attrName + ' - CCM Need to map appId'
	WHERE attrName IN ('VSA Discover Subclient ID', 'Last Backup Subclient')
		AND exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- UPDATE attrName'
		GOTO CX_ERROR_EXIT
	END
-- DB: fix for table changes
	INSERT	INTO APP_ClientProp
	SELECT	new_componentNameId, attrName, attrType, attrVal, created, modified, @dummy_ccpId
	FROM	CCM_MAP_ClientProp
	WHERE	exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Handle for the new 7.0 property of client
	-- Active Physical Node (physical client id in cluster)
	UPDATE	APP_ClientProp
	SET		attrVal = c.new_id
FROM	APP_ClientProp a, CCM_MAP_ClientProp b, CCM_MAP_Client c
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrName = 'Active Physical Node'
	AND		a.attrType = b.attrType
	AND		b.attrVal = c.old_id
	AND		((a.modified = 0 AND b.modified = 0 AND	a.created < b.created) OR b.exist = 0)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- UPDATE Active Physical Node attribute'
		GOTO CX_ERROR_EXIT
	END
	DECLARE @commcellId INTEGER
SELECT @commcellId = new_Id FROM CCM_MAP_CommCell WHERE old_Id = 2
	INSERT INTO APP_ClientProp
	SELECT DISTINCT A.new_Id, 'OwnerCommCellId', 7 /* PROPERTY_INTEGER */, @commcellId  , dbo.GetUnixTime(GETUTCDATE()), 0,0
FROM CCM_MAP_Client A INNER JOIN APP_Client B ON A.new_Id = B.id
	WHERE A.exist = 0
		AND NOT EXISTS ( SELECT 1 FROM APP_ClientProp C WHERE C.componentNameId = B.id AND C.attrName = 'OwnerCommCellId' )
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- Failed to set OwanarCommCellId property. '
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	---------------------------------------------------------
	-- Merge APP_Platform table
	INSERT	INTO CCM_MAP_Platform
	SELECT	clientId, 0, platformType, install_dir, refTime, 0
FROM	#CCM_APP_Platform
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Platform -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_Platform SET new_clientId = b.new_id
FROM	CCM_MAP_Platform a, CCM_MAP_Client b
	WHERE	a.old_clientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Platform -- UPDATE new_clientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_Platform SET exist = 1
	FROM	CCM_MAP_Platform a, APP_Platform b
	WHERE	a.new_clientId = b.clientId
	AND		a.platformType = b.platformType
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Platform -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	    -- Merge of Media Agent Instance
	    -- Media Agent Instance Installation alone too will have APP_Platform records 2 and 4 in the very same Commserv_Merge database
	    -- Record with platformType 4 makes sure that the Media Agent is seen under client computers in commcell GuI.
		INSERT	INTO APP_Platform
		SELECT	new_clientId, platformType, install_dir, refTime
		FROM	CCM_MAP_Platform
		WHERE	platformType in (2,4)
		AND		exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Platform -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	DECLARE @newHostIdList TABLE ( Id int)
	INSERT INTO @newHostIdList
	SELECT b.new_id
FROM #CCM_MMHost a, CCM_MAP_Client b
	WHERE a.clientId = b.old_id
	  AND b.new_id NOT IN (SELECT clientId FROM MMHost)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- @newHostIdList -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Merge Media Agent Specific Table
	INSERT INTO MMHost
	SELECT b.new_id, a.MmHostType, a.MmHostSoftState, a.MmHostEnabled, a.OfflineReason, a.OfflineTimeStamp, a.PatchLevel, a.IndexCacheUser,
	       a.IndexCachePassword, a.IndexCachePathName, a.IsIndexShared, a.Attribute, a.ScanIntervalInSec, a.Descript, a.MaxReservations,
	       a.RMStatus, a.RMStatusUpdateTime, a.RolesBitMask
FROM #CCM_MMHost a, CCM_MAP_Client b
	WHERE a.clientId = b.old_id
	  AND b.new_id NOT IN (SELECT clientId FROM MMHost)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- MMHost -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Merge VM to PM map table
	INSERT INTO APP_VMToPMMap
	SELECT b.new_id, c.new_id
FROM #CCM_APP_VMToPMMap a INNER JOIN CCM_MAP_Client b ON a.VMClientId = b.old_id
		INNER JOIN CCM_MAP_Client c ON a.PMClientId = c.old_id
		LEFT OUTER JOIN APP_VMToPMMap d ON b.new_Id = d.VMClientId AND c.new_id = d.PMClientId
	WHERE d.VMClientId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- APP_VMToPMMap -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Create entries in MMCopyManagerCtrl for newly migrated media agents
	IF EXISTS (SELECT * FROM @newHostIdList)
	BEGIN
		-- For the new media agent, create copy manager /copy manager controller
		INSERT INTO MMCopyManagerCtrl
		(
				ClientId, CopyManagerId, SCSIId, AccessPath
		)
SELECT Id, 1, 'N/A', 'N/A'
		FROM @newHostIdList
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- MMCopyManagerCtrl -- INSERT MMS2_LAN_COPYMGR_ID'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO MMCopyManagerCtrl
		(
				ClientId, CopyManagerId, SCSIId, AccessPath
		)
SELECT Id, 2, 'N/A', 'N/A'
		FROM @newHostIdList
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- MMCopyManagerCtrl -- INSERT MMS2_SNAPVAULT_OPENSYSTEMS_COPYMGR_ID'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO MMCopyManagerCtrl
		(
				ClientId, CopyManagerId, SCSIId, AccessPath
		)
SELECT Id, 3, 'N/A', 'N/A'
		FROM @newHostIdList
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- MMCopyManagerCtrl -- INSERT MMS2_SNAPVAULT_ONTAP_COPYMGR_ID'
			GOTO CX_ERROR_EXIT
		END
	END
	-- Create/Update Index Access Path for the migrated media agents
	/*
	  The existing index cache of the migrated media agent can't be reused because all the index caches are stored under 2\AppId.
      Since AppIds will mean different things on different commserves, there will be a collision  and that could lead to corrupted
      indexes on a new incremental etc. Browse will show weird results
      The only exception to this case is when the migration is from and to the very same commcell
     */
    SET @mergeToSameCommcell = 0
    SET @windowsMA = 0
    SELECT @curTime = CONVERT(VARCHAR(64), dbo.GetUnixTime(getutcdate()))
    IF EXISTS (SELECT * FROM CCM_MAP_Commcell WHERE old_id = 2 and new_id = 2)
    BEGIN
      SET @mergeToSameCommcell = 1
    END
	DECLARE @old_IdxAccessPathId INTEGER
	DECLARE @old_ClientId INTEGER
	DECLARE @new_IdxPoolId INTEGER
	DECLARE @new_IdxCacheId INTEGER
	DECLARE @new_ClientId INTEGER
	DECLARE @old_Path VARCHAR(1024)
	DECLARE @new_Path VARCHAR(1024)
	DECLARE @cur_APId integer
	DECLARE @cur_CID integer
	DECLARE @cur_Poolid integer
	DECLARE @startPos integer = 0
	DECLARE CUR_IdxAccessPath CURSOR LOCAL FOR
SELECT IdxAccessPathId, ClientId, Path FROM #CCM_IdxAccessPath
	OPEN CUR_IdxAccessPath
	FETCH CUR_IdxAccessPath INTO @old_IdxAccessPathId, @old_ClientId, @old_Path
	WHILE @@FETCH_STATUS = 0
	BEGIN
	    SET @new_ClientId   = 0
	    SET @new_IdxPoolId  = 0
	    SET @new_IdxCacheId = 0
		SET @new_ClientId = (SELECT new_id FROM CCM_MAP_Client WHERE old_id = @old_ClientId)
	    IF @new_ClientId = 0
	    BEGIN
		  SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- new_ClientId is not known'
		  GOTO CX_ERROR_EXIT
	    END
	    IF @mergeToSameCommcell = 1
	    BEGIN
	     -- Index Access Path can be the same for a merge to the very same commcell
	     SET @new_Path = @old_Path
	    END
	    ELSE
	    BEGIN
	      -- Merge to a different commcell
	      -- Need to update the Index Access Path
	     SET @windowsMA = (SELECT charindex('\',@old_Path))
	     SET @startPos = 0
	     IF @windowsMA > 0
	     BEGIN
	      IF (RIGHT(@old_Path,1) = '\')                     -- Returns 1st right most character
   	        SET @startPos = 2
		  SET @new_Path = SUBSTRING(@old_Path, 1, LEN(@old_Path) - CHARINDEX('\',REVERSE(@old_Path), @startPos) + 1) + 'IndexCache_' + @curTime
	     END
	     ELSE
	     BEGIN
	      IF (RIGHT(@old_Path,1) = '/')                     -- Returns 1st right most character
   	        SET @startPos = 2
		  SET @new_Path = SUBSTRING(@old_Path, 1, LEN(@old_Path) - CHARINDEX('/',REVERSE(@old_Path), @startPos) + 1) + 'IndexCache_' + @curTime
	     END
	    END
        SET @cur_APId = null
		SET @cur_CId = null
		SELECT @cur_APId = IAP.IdxAccessPathId, @cur_CID = IC.IdxCacheId, @cur_Poolid = IC.IdxPoolId
 		FROM IdxAccessPath IAP INNER JOIN IdxCache IC ON IC.IdxCacheId = IAP.IdxCacheId AND IC.IdxCacheType = 1
 		WHERE IAP.clientID = @new_ClientId
        -- Check if the index cache path for the migrated media agent exists or not
 	    IF (@cur_APId is not null)
 	    BEGIN
			-- we need to remove the current access path in any case
			DELETE FROM IdxAccessPath whERE IdxAccessPathId = @cur_APId
			-- we need to delete the pool and cache in case this one is the only one using it
			IF ((SELECT COUNT(*) from IdxAccessPath WHERE IdxCacheId = @cur_CID) = 0)
			BEGIN
				DELETE FROM IdxCache WHERE IdxCacheId = @cur_CID
				DELETE FROM IdxPool WHERE IdxPoolId = @cur_Poolid
			END
	    END
		-- Create New Index Pool, Index Cache and Index Access Path
		INSERT INTO IdxPool (Description, Enabled, IsShared, AgeingNoOfDays)
VALUES ('CCM Index Pool ' + cast (getdate() as varchar(200)), 1, 0, 15)
		SELECT @new_IdxPoolId = @@IDENTITY, @errorCode = @@ERROR
		IF @errorCode > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- IdxPool -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		-- lastUpdateTime contains special handling for 0,1 and 2;
		-- update mode 0: overwrite ICL without a second thought.
		-- update mode 1: do an autodetect. If an index cache is found and is valid, use it, else fail writing the ICL
		-- update mode 2: do an autodetect. If another index cache is found, use it, else overwrite the ICL no matter what it says
		INSERT INTO IdxCache (
			IdxPoolId, Description, Enabled, Creationtime, SoftState, OfflineReason,
			AgeingPercentDiskspace, FillUpOrder, FreeDiskSpaceMB, LastUpdateTime, LastUpdateAPId,
			DiskUsageMB, DiskUsageLastChecked, DiskFreeThresholdMB, DiskFreeWarningThreshholdMB,
			IdxCacheType,
			DiskReadSpeed, DiskWriteSpeed, CatalogServerClientId, flags, TotalCapacityMB)
		VALUES (
			@new_IdxPoolId, 'CCM Index Cache ' + cast (getdate() as varchar(200)), 1, dbo.GetUnixTime(getutcdate()), 1, 0,
90, 1, 0, 0, 0,
			0, 0, 0, 1024,
			1, -- IDX_CACHE_TYPE
			0, 0, 0, 0, 0
			)
		SELECT @new_IdxCacheId = @@IDENTITY, @errorCode = @@ERROR
		IF @errorCode > 0
		BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- IdxCache -- INSERT'
		GOTO CX_ERROR_EXIT
		END
		INSERT	INTO IdxAccessPath
				 (IdxCacheId, ClientId, Path, Username, Password, Enabled, SoftState, OfflineReason, Priority, LocalIndexTimeStamp, ActualDaysIndexRetain, Flags, DiskFreeWarningThreshholdMB, AgeingNoOfDays, AgeingPercentDiskspace, DiskFreeThresholdMB, TotalCapacityMB, StagingCachePath, VolumeGUID)
		SELECT	@new_IdxCacheId, @new_ClientId, @new_Path, a.UserName, a.Password, a.Enabled, a.SoftState, a.OfflineReason, a.Priority, 2, a.ActualDaysIndexRetain, a.Flags, a.DiskFreeWarningThreshholdMB, a.AgeingNoOfDays, a.AgeingPercentDiskspace, isnull(a.DiskFreeThresholdMB, 500), a.TotalCapacityMB, a.StagingCachePath, a.VolumeGUID
FROM		#CCM_IdxAccessPath a
		WHERE		a.IdxAccessPathId = @old_IdxAccessPathId
		AND     a.ClientId = @old_ClientId
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- IdxAccessPath -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		FETCH CUR_IdxAccessPath INTO @old_IdxAccessPathId, @old_ClientId, @old_Path
	END
	CLOSE CUR_IdxAccessPath
	DEALLOCATE CUR_IdxAccessPath
	/* -- Instead of calling merge_job the needed piece of code is moved here- see below
	-- Merge JM Job Action (Activity Control) of migrated media agents
	EXEC @errorCode = CCM_MERGE_JOB 0, 1, @errStr = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	*/
	--Calling CCM_MERGE_JOB for JMJobAction causes issue due to application map being dropped in merge_main, Hence moving the piece of code here
	-- Merge JM Job Action (Activity Control) of migrated media agents
	/*
	Most cases it should always 1. But why take chance
	*/
	DECLARE @sourceActivityControlAppId   INTEGER
	DECLARE @destActivityControlAppId   INTEGER
SET @sourceActivityControlAppId = ISNULL((SELECT TOP 1 id FROM #CCM_APP_Application WHERE appTypeId = 1000),0)
	SET @destActivityControlAppId   = ISNULL((SELECT TOP 1 id FROM APP_Application WHERE appTypeId = 1000),0)
	IF (@sourceActivityControlAppId = 0 OR @destActivityControlAppId = 0)
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- AppId For ActivityControl Not Found in the database'
		GOTO CX_ERROR_EXIT
	END
	IF @sourceActivityControlAppId = 0 SET @sourceActivityControlAppId = 1
	IF @destActivityControlAppId = 0   SET @destActivityControlAppId = 1
	DECLARE @SQLQuery NVARCHAR(MAX)
IF COL_LENGTH('#CCM_JMJobAction','reason') IS NOT NULL
	BEGIN
		SET @SQLQuery = N'
		INSERT	INTO CCM_MAP_JobAction
		SELECT	clientId, 0, mediaAgentID, appType, opType, action, appId, 0, clientGroupId, 0, 0, 0, reason
FROM	#CCM_JMJobAction
		WHERE ((appId = '+ CAST( @sourceActivityControlAppId AS NVARCHAR(10)) + ' AND mediaAgentId = 1 AND appType = 0 AND clientGroupId = 0 ))'
	END
	ELSE
	BEGIN
		SET @SQLQuery = N'
		INSERT	INTO CCM_MAP_JobAction
		SELECT	clientId, 0, mediaAgentID, appType, opType, action, appId, 0, clientGroupId, 0, 0, 0, ''''
FROM	#CCM_JMJobAction
		WHERE ((appId = '+ CAST( @sourceActivityControlAppId AS NVARCHAR(10)) + ' AND mediaAgentId = 1 AND appType = 0 AND clientGroupId = 0 ))'
	END
	EXEC (@SQLQuery)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- CCM_MAP_JobAction -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JobAction SET new_clientId = old_clientId
	WHERE old_clientId = 1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- CCM_MAP_JobAction -- UPDATE new_clientId to 1'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JobAction SET new_clientId = b.new_id
	FROM CCM_MAP_JobAction a, CCM_MAP_Client b
	WHERE a.old_clientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- CCM_MAP_JobAction -- UPDATE new_clientId'
		GOTO CX_ERROR_EXIT
	END
	-- Reset appId during merge to new default appId
	UPDATE	CCM_MAP_JobAction SET new_appId = @destActivityControlAppId
	WHERE	old_appId = @sourceActivityControlAppId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- CCM_MAP_JobAction -- UPDATE new_appId 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_JobAction SET exist = 1
	FROM	CCM_MAP_JobAction a, JMJobAction b
	WHERE	a.new_clientId = b.clientId and a.mediaAgentID = b.mediaAgentID
	AND		a.appType = b.appType and a.optype = b.optype
	AND		a.new_appId = b.appId and a.clientGroupId = b.clientGroupId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- CCM_MAP_JobAction -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO JMJobAction
	SELECT	new_clientId, mediaAgentID, appType, opType, action, new_appId, clientGroupId, 0, 0, 0, 1, reason
	FROM	CCM_MAP_JobAction
	WHERE	exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- JMJobAction -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Deconfigure migrated clients.
	DECLARE @lt_ClientAppList TABLE (clientId int, appTypeId int)
	DECLARE @clientId int = 0
	DECLARE @appTypeId int = 0
	-- if client is missing or same client exists with migrated flag, then we can call client level deconfigure.
	INSERT INTO @lt_ClientAppList
	SELECT DISTINCT new_Id, 0
	FROM CCM_MAP_CLIENT a INNER JOIN APP_Client b ON a.new_id = b.id
WHERE a.new_id > 0 AND (b.specialClientFlags & 0x20) > 0
	-- if client is present, but agent is missing then we should call agent level deconfigure.
	INSERT 	INTO @lt_ClientAppList
	SELECT  DISTINCT a.new_Id, b.appTypeId
	FROM   	CCM_MAP_CLIENT a INNER JOIN CCM_MAP_IdaName b ON a.old_Id = b.old_clientId
			LEFT OUTER JOIN @lt_ClientAppList c ON c.clientId = a.new_Id
	WHERE 	b.exist = 0 AND c.clientId IS NULL
	-- if client and agent both are present but agent is in deconfigured state, but DR backup has agent in configured state(some backupsets are created), if we merge from DR then we should deconfigure the agent otherwise missing backupsets will be in configured state, so we should deconfigure the agent again.
	INSERT 	INTO @lt_ClientAppList
	SELECT  DISTINCT a.new_Id, b.appTypeId
	FROM   	CCM_MAP_CLIENT a INNER JOIN CCM_MAP_IdaName b ON a.old_Id = b.old_clientId
			LEFT OUTER JOIN @lt_ClientAppList c ON c.clientId = a.new_Id AND (c.appTypeId = b.appTypeId OR c.appTypeId = 0)
	WHERE 	b.exist = 1 AND c.clientId IS NULL
			AND EXISTS (SELECT 1 FROM licUsage WHERE CId = a.new_id AND AppType = b.appTypeId AND OpType = 'UnInstall')
	-- Skip VSA discovered VMs so that we don't need to configure again.
	DELETE @lt_ClientAppList
	FROM @lt_ClientAppList A INNER JOIN APP_ClientProp B ON A.clientId = B.componentNameId
	WHERE B.attrName = 'Virtual Server Discovered Clients' AND CAST(B.attrVal AS INT) = 1
			-- vCenter configured VM should be excluded as this is pseudo client and it has discover clients property.
			AND NOT EXISTS (
				SELECT 1
				FROM APP_APPlication APP
				INNER JOIN APP_InstanceProp InstProp ON APP.instance = InstProp.componentNameId
				WHERE APP.clientId = A.clientId AND InstProp.attrName = N'Virtual Server Instance Type'
				AND InstProp.attrVal <> '' AND InstProp.modified = 0
							)
	/*
	IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#tempError]'))
		DROP TABLE #tempError
	CREATE TABLE #tempError (errCode INTEGER, errStr VARCHAR(MAX) )
	DECLARE @STOREDPROC_QUERY VARCHAR(MAX) = 'DECLARE @errCode INT , @errStr VARCHAR(MAX) ; '
	DECLARE @ERROR_HANDLE_QUERY VARCHAR(MAX) = ' IF @@ERROR <> 0 OR @errCode <> 0 BEGIN INSERT INTO #tempError VALUES (@errCode, @errStr) ; RAISERROR (''%s'' , 16, 1 ,@errStr)  ; END ; '
	SELECT @STOREDPROC_QUERY +=
		' EXEC AppConfDeconf '+CONVERT(VARCHAR,@clientId)+', '+CONVERT(VARCHAR,@appTypeId)+', 0, 2, @errCode OUTPUT, @errStr OUTPUT '+ @ERROR_HANDLE_QUERY
	 FROM @lt_ClientAppList
	BEGIN TRY
		EXEC (@STOREDPROC_QUERY)
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = errCode , @errorString = errStr FROM #tempError
		GOTO CX_ERROR_EXIT
	END CATCH
	*/
	DECLARE DeconfigureClientCur CURSOR LOCAL FORWARD_ONLY
	FOR	SELECT clientId, appTypeId FROM @lt_ClientAppList
	OPEN DeconfigureClientCur
	FETCH DeconfigureClientCur INTO @clientId, @appTypeId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		EXEC AppConfDeconf @clientId, @appTypeId, 0, 2, @errorCode OUTPUT, @errorString OUTPUT
		IF @@ERROR <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
		FETCH NEXT FROM DeconfigureClientCur INTO @clientId, @appTypeId
	END
	CLOSE DeconfigureClientCur
	DEALLOCATE DeconfigureClientCur
	---------------------------------------------------------
	---------------------------------------------------------
	/*
	Now CCM_Map_Client has the new client ids, lets set the clientIds to be returned
	*/
	SELECT @o_mergedCSClientId = new_id
	FROM CCM_Map_Client WHERE old_id = 2
	IF EXISTS (SELECT 1 FROM #CCM_APP_VMToPMMap)
		SELECT @o_mergedMAClientId = new_id
		FROM CCM_Map_Client WHERE old_id = (SELECT top 1 VMClientId FROM #CCM_APP_VMToPMMap)
	ELSE
		SELECT @o_mergedMAClientId = new_id
		FROM CCM_Map_Client WHERE old_id = (SELECT top 1 clientId FROM #CCM_MMHost) --Actually there should be only one row in #CCM_MMHost as this proc is supposed to merge only one MA's data
	--FIx: MR#73609 LibrrayServer-Dont show Unlicensed (Pushed ) MA/client  in Report/nstall Updates, etc
	UPDATE App_Client
	SET specialClientFlags = specialClientFlags | 0x2 --#define SAME_COMMCELL_GALAXY_PACKAGES_ABSENT 0x2
	FROM APP_Client APC
		INNER JOIN CCM_Map_Client MAPC ON APC.id = MAPC.new_id
		LEFT OUTER JOIN simInstalledPackages SIP ON APC.id = SIP.ClientId
	WHERE SIP.ClientId is null
		--AND APC.id in (@o_mergedCSClientId, @o_mergedMAClientId) --12:37 PM 7/18/2012 For pushing cluster MA we will have more than 1 client
	-- Set firewall config.
	IF NOT EXISTS(SELECT 1 FROM APP_ClientProp WHERE componentNameId = @o_mergedMAClientId AND attrName = 'Include in Firewall Config' AND modified = 0)
	BEGIN
		INSERT INTO APP_ClientProp
		SELECT @o_mergedMAClientId, 'Include in Firewall Config', 7, '1', DBO.GetUnixTime(GETUTCDATE()), 0, 0
	END
	SET @errorCode = 0
	SET @errorString = 'NO_ERROR'
	EXEC CCM_Merge_Map 0
COMMIT TRANSACTION
  SELECT	@errorCode, @errorString, @o_mergedMAClientId, @o_mergedCSClientId
	RETURN (0)
CX_ERROR_EXIT:
    EXEC CCM_Merge_Map 0
  IF (Cursor_Status('LOCAL', 'CUR_IdxAccessPath') >= -1)
	BEGIN
		CLOSE CUR_IdxAccessPath
		DEALLOCATE CUR_IdxAccessPath
	END
 -- IF (Cursor_Status('LOCAL', 'CUR_CLIENTLISTCURSOR') >= -1)
--	BEGIN
	--	CLOSE CUR_CLIENTLISTCURSOR
	--	DEALLOCATE CUR_CLIENTLISTCURSOR
--	END
ROLLBACK TRANSACTION
  SELECT	@errorCode, @errorString, @o_mergedMAClientId, @o_mergedCSClientId
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_MediaAgentXML')
	delete from GxQscripts where name = 'CCM_Merge_MediaAgentXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_MediaAgentXML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_MediaAgentXML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_MediaAgentXML',  'v1.21.60.9.46.2', 'CCM_Merge_MediaAgentXML', 'v1.21.60.9.46.2')
GO

