

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_MediaAgent.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge Media Agent.
--  +========================================================================+
-- $Id: CCM_Merge_MediaAgent.sp,v 1.32.190.3 2018/12/27 16:49:01 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Merge_MediaAgent')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Merge_MediaAgent <<<'
	drop procedure CCM_Merge_MediaAgent
END
IF EXISTS (select * from GxQscripts where name='CCM_Merge_MediaAgent')
	delete from GxQscripts where name = 'CCM_Merge_MediaAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_MediaAgent')
	delete from GXDBVersions where aliasname = 'CCM_Merge_MediaAgent'
GO
print '... Creating Procedure: CCM_Merge_MediaAgent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_Merge_MediaAgent
  @isTapeImport INT = 0,
  @ccmParamFlags integer = 0,
  @i_jobId integer
AS
SET NOCOUNT ON
  DECLARE @errorCode integer
  DECLARE @errorString varchar(4000)
BEGIN TRANSACTION TRAN_Merge_MediaAgent
    SET @errorCode = 0
	SET @errorString = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
	--- CODE BELOW HERE IS FROM CCM_Merge_MediaAgent.spb  ----------
	IF NOT EXISTS (SELECT * FROM MASTER..SYSDATABASES WHERE NAME = 'CommServ_Merge')
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- DATABASE CommServ_Merge DOES NOT EXIST'
		GOTO CX_ERROR_EXIT
	END
IF NOT EXISTS (SELECT * FROM CommServ_Merge..CCM_APP_Client)
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- NO Media Agent to Migrate , PLEASE CAPTURE DATA BEFORE MERGE'
		GOTO CX_ERROR_EXIT
	END
	DECLARE	@release_source varchar(128)
	DECLARE	@release_destination varchar(128)
	DECLARE @mergeToSameCommcell INTEGER
	DECLARE @curTime VARCHAR(1024)
  DECLARE @windowsMA INTEGER
SET @release_source = ISNULL((select top 1 release from CommServ_Merge..CCM_simAllGalaxyRel order by id desc),'N/A')
	SET @release_destination = ISNULL((select top 1 release from simAllGalaxyRel order by id desc),'N/A')
	IF @release_source > @release_destination
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- SOURCE COMMCELL HAS HIGHER VERSION THAN DESTINATION: SOURCE IN [' + @release_source + '] AND DESTINATION IN [' + @release_destination + ']'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Answers validation --
	-- Try to answer the questions for client's name and host name based on answer tables (CCMClientAnswers)
IF EXISTS(SELECT * FROM CommServ_Merge..CCM_APP_Client)
    BEGIN
		--DECLARE @commcellNumber INTEGER
        --SET @commcellNumber = 0
		--SET @commcellNumber = (SELECT number FROM CCM_DB_APP_COMMCELL WHERE id = 2 and type = 1)
		DECLARE @commcellGUID nvarchar(max)
SET @commcellGUID = (SELECT csGUID FROM CommServ_Merge..CCM_APP_Commcell WHERE id = 2 and type = 1)
IF EXISTS(SELECT * FROM Commserv..CCMClientAnswers a, CommServ_Merge..CCM_APP_Client b
		          WHERE --a.SourceCommCellId = @commcellNumber
		            a.SourceCommCellGUID = @commcellGUID
		            AND a.OldClientName = b.name
		            AND a.OldClientHostName = b.net_hostname
		            AND (a.NewClientName = '' AND a.NewClientHostName <> ''
		                 OR a.NewClientName <> '' AND a.NewClientHostName = '')
		         )
		BEGIN
		  SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- Answers needed for both client name and hostname'
		  GOTO CX_ERROR_EXIT
		END
IF EXISTS(SELECT * FROM Commserv..CCMClientAnswers a, CommServ_Merge..CCM_APP_Client b
		          WHERE --a.SourceCommCellId = @commcellNumber
					a.SourceCommCellGUID = @commcellGUID
		            AND a.OldClientName = b.name
		            AND a.OldClientHostName = b.net_hostname
		            AND a.NewClientName <> ''
		            AND a.NewClientHostName <> ''
		         )
		BEGIN
		  -- Answer provided, perform the following validations
IF EXISTS (SELECT * FROM Commserv..CCMClientAnswers a, CommServ_Merge..CCM_APP_Client c
   		             WHERE --a.SourceCommCellId = @commcellNumber
   		              a.SourceCommCellGUID = @commcellGUID
		              AND a.OldClientName = c.name
		              AND a.OldClientHostName = c.net_hostname
		              AND a.NewClientName <> ''
		              AND a.NewClientHostName <> ''
		              AND EXISTS (SELECT * FROM Commserv..APP_Client b WHERE (   (a.NewClientName = b.name AND a.NewClientHostName <> b.net_hostname)
		                                                                      OR (a.NewClientName <> b.name AND a.NewClientHostName = b.net_hostname)
		                                                                     )
		                         )
		            )
		  BEGIN
		    SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- New Client Name or New Client Host Name already exists in the destination DB'
		    GOTO CX_ERROR_EXIT
		  END
		  -- All validations done, consider the answers as valid
INSERT INTO CommServ_Merge..CCM_ClientNameMapping
		  SELECT a.name, b.NewClientName, b.NewClientHostName
FROM CommServ_Merge..CCM_APP_Client a, Commserv..CCMClientAnswers b
		  WHERE a.name = b.OldClientName
		    AND a.net_hostname = b.OldClientHostName
  		    --AND b.SourceCommCellId = @commcellNumber
  		    AND b.SourceCommCellGUID = @commcellGUID
  		    AND b.NewClientName <> ''
  		    AND b.NewClientHostName <> ''
  		  IF @@ERROR > 0
		  BEGIN
		 	SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- CCM_ClientNameMapping -- INSERT'
			GOTO CX_ERROR_EXIT
		  END
		END
    END
	---------------------------------------------------------
	-- Create Temp Table to be used by merge operation
	EXEC CCM_Merge_Map 1
	---------------------------------------------------------
	-- Merge CommCell table
	EXEC @errorCode = CCM_MERGE_CommCell @errorString = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	-- Merge Client to BackupSet related tables
	EXEC @errorCode = CCM_MERGE_Client 1, @isEDCMerge = @isTapeImport, @errorString = @errorString OUTPUT -- 1 indicates it is a Merge of a Media Agent Instance
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	DECLARE @newHostIdList TABLE ( Id int)
	INSERT INTO @newHostIdList
	SELECT b.new_id
FROM CommServ_Merge..CCM_MMHost a, CCM_MAP_Client b
	WHERE a.clientId = b.old_id
	  AND b.new_id NOT IN (SELECT clientId FROM MMHost)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- @newHostIdList -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Merge Media Agent Specific Table
	INSERT INTO MMHost
	SELECT b.new_id, a.MmHostType, a.MmHostSoftState, a.MmHostEnabled, a.OfflineReason, a.OfflineTimeStamp, a.PatchLevel, a.IndexCacheUser,
	       a.IndexCachePassword, a.IndexCachePathName, a.IsIndexShared, a.Attribute, a.ScanIntervalInSec, a.Descript, a.MaxReservations,
	       a.RMStatus, a.RMStatusUpdateTime, a.RolesBitMask
FROM CommServ_Merge..CCM_MMHost a, CCM_MAP_Client b
	WHERE a.clientId = b.old_id
	  AND b.new_id NOT IN (SELECT clientId FROM MMHost)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- MMHost -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO MMScaleOutMAInfo
	SELECT B.new_Id, A.NetworkInformation, A.GlusterMetaData, A.HardwareInformation
FROM CommServ_Merge..CCM_MMScaleOutMAInfo A INNER JOIN CCM_MAP_Client B ON A.ClientId = B.old_id
	WHERE NOT EXISTS (SELECT 1 FROM MMScaleOutMAInfo WHERE ClientId = B.new_Id)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- MMScaleOutMAInfo -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE A
	SET NetworkInformation.modify('replace value of (/MediaManager_MMScaleOutHostNWInfo/@hostId)[1] with sql:column("A.ClientId")')
	FROM MMScaleOutMAInfo A
		INNER JOIN CCM_MAP_Client B ON A.ClientId = B.new_Id
INNER JOIN CommServ_Merge..CCM_MMScaleOutMAInfo C ON C.ClientId = B.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- MMScaleOutMAInfo -- UPDATE NetworkInformation'
		GOTO CX_ERROR_EXIT
	END
	-- Create entries in MMCopyManagerCtrl for newly migrated media agents
	IF EXISTS (SELECT * FROM @newHostIdList)
	BEGIN
		-- For the new media agent, create copy manager /copy manager controller
		INSERT INTO MMCopyManagerCtrl
		(
				ClientId, CopyManagerId, SCSIId, AccessPath
		)
SELECT Id, 1, 'N/A', 'N/A'
		FROM @newHostIdList
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- MMCopyManagerCtrl -- INSERT MMS2_LAN_COPYMGR_ID'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO MMCopyManagerCtrl
		(
				ClientId, CopyManagerId, SCSIId, AccessPath
		)
SELECT Id, 2, 'N/A', 'N/A'
		FROM @newHostIdList
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- MMCopyManagerCtrl -- INSERT MMS2_SNAPVAULT_OPENSYSTEMS_COPYMGR_ID'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO MMCopyManagerCtrl
		(
				ClientId, CopyManagerId, SCSIId, AccessPath
		)
SELECT Id, 3, 'N/A', 'N/A'
		FROM @newHostIdList
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- MMCopyManagerCtrl -- INSERT MMS2_SNAPVAULT_ONTAP_COPYMGR_ID'
			GOTO CX_ERROR_EXIT
		END
	END
	-- Create/Update Index Access Path for the migrated media agents
	/*
	  The existing index cache of the migrated media agent can't be reused because all the index caches are stored under 2\AppId.
      Since AppIds will mean different things on different commserves, there will be a collision  and that could lead to corrupted
      indexes on a new incremental etc. Browse will show weird results
      The only exception to this case is when the migration is from and to the very same commcell
     */
    SET @mergeToSameCommcell = 0
    SET @windowsMA = 0
    SELECT @curTime = CONVERT(VARCHAR(64), dbo.GetUnixTime(getutcdate()))
    IF EXISTS (SELECT * FROM CCM_MAP_Commcell WHERE old_id = 2 and new_id = 2)
    BEGIN
      SET @mergeToSameCommcell = 1
    END
	DECLARE @old_IdxAccessPathId INTEGER
	DECLARE @old_ClientId INTEGER
	DECLARE @new_IdxPoolId INTEGER
	DECLARE @new_IdxCacheId INTEGER
	DECLARE @new_ClientId INTEGER
	DECLARE @old_Path VARCHAR(1024)
	DECLARE @new_Path VARCHAR(1024)
	DECLARE @cur_APId integer
	DECLARE @cur_CID integer
	DECLARE @cur_Poolid integer
	DECLARE @startPos integer = 0
	DECLARE CUR_IdxAccessPath CURSOR LOCAL FOR
SELECT IdxAccessPathId, ClientId, Path FROM CommServ_Merge..CCM_IdxAccessPath
	OPEN CUR_IdxAccessPath
	FETCH CUR_IdxAccessPath INTO @old_IdxAccessPathId, @old_ClientId, @old_Path
	WHILE @@FETCH_STATUS = 0
	BEGIN
	    SET @new_ClientId   = 0
	    SET @new_IdxPoolId  = 0
	    SET @new_IdxCacheId = 0
		SET @new_ClientId = (SELECT new_id FROM CCM_MAP_Client WHERE old_id = @old_ClientId)
	    IF @new_ClientId = 0
	    BEGIN
		  SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- new_ClientId is not known'
		  GOTO CX_ERROR_EXIT
	    END
	    IF @mergeToSameCommcell = 1
	    BEGIN
	     -- Index Access Path can be the same for a merge to the very same commcell
	     SET @new_Path = @old_Path
	    END
	    ELSE
	    BEGIN
	      -- Merge to a different commcell
	      -- Need to update the Index Access Path
	     SET @windowsMA = (SELECT charindex('\',@old_Path))
	     SET @startPos = 0
	     IF @windowsMA > 0
	     BEGIN
	      IF (RIGHT(@old_Path,1) = '\')                     -- Returns 1st right most character
   	        SET @startPos = 2
		  SET @new_Path = SUBSTRING(@old_Path, 1, LEN(@old_Path) - CHARINDEX('\',REVERSE(@old_Path), @startPos) + 1) + 'IndexCache_' + @curTime
	     END
	     ELSE
	     BEGIN
	      IF (RIGHT(@old_Path,1) = '/')                     -- Returns 1st right most character
   	        SET @startPos = 2
		  SET @new_Path = SUBSTRING(@old_Path, 1, LEN(@old_Path) - CHARINDEX('/',REVERSE(@old_Path), @startPos) + 1) + 'IndexCache_' + @curTime
	     END
	    END
        SET @cur_APId = null
		SET @cur_CId = null
		SELECT @cur_APId = IAP.IdxAccessPathId, @cur_CID = IC.IdxCacheId, @cur_Poolid = IC.IdxPoolId
 		FROM IdxAccessPath IAP INNER JOIN IdxCache IC ON IC.IdxCacheId = IAP.IdxCacheId AND IC.IdxCacheType = 1
 		WHERE IAP.clientID = @new_ClientId
        -- Check if the index cache path for the migrated media agent exists or not
 	    IF (@cur_APId is not null)
 	    BEGIN
			-- we need to remove the current access path in any case
			DELETE FROM IdxAccessPath whERE IdxAccessPathId = @cur_APId
			-- we need to delete the pool and cache in case this one is the only one using it
			IF ((SELECT COUNT(*) from IdxAccessPath WHERE IdxCacheId = @cur_CID) = 0)
			BEGIN
				DELETE FROM IdxCache WHERE IdxCacheId = @cur_CID
				DELETE FROM IdxPool WHERE IdxPoolId = @cur_Poolid
			END
	    END
		-- Create New Index Pool, Index Cache and Index Access Path
		INSERT INTO IdxPool (Description, Enabled, IsShared, AgeingNoOfDays)
VALUES ('CCM Index Pool ' + cast (getdate() as varchar(200)), 1, 0, 15)
		SELECT @new_IdxPoolId = @@IDENTITY, @errorCode = @@ERROR
		IF @errorCode > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- IdxPool -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		-- lastUpdateTime contains special handling for 0,1 and 2;
		-- update mode 0: overwrite ICL without a second thought.
		-- update mode 1: do an autodetect. If an index cache is found and is valid, use it, else fail writing the ICL
		-- update mode 2: do an autodetect. If another index cache is found, use it, else overwrite the ICL no matter what it says
		INSERT INTO IdxCache (
			IdxPoolId, Description, Enabled, Creationtime, SoftState, OfflineReason,
			AgeingPercentDiskspace, FillUpOrder, FreeDiskSpaceMB, LastUpdateTime, LastUpdateAPId,
			DiskUsageMB, DiskUsageLastChecked, DiskFreeThresholdMB, DiskFreeWarningThreshholdMB,
			IdxCacheType,
			DiskReadSpeed, DiskWriteSpeed, CatalogServerClientId, flags, TotalCapacityMB)
		VALUES (
			@new_IdxPoolId, 'CCM Index Cache ' + cast (getdate() as varchar(200)), 1, dbo.GetUnixTime(getutcdate()), 1, 0,
90, 1, 0, 0, 0,
			0, 0, 0, 1024,
			1, -- IDX_CACHE_TYPE
			0, 0, 0, 0, 0
			)
		SELECT @new_IdxCacheId = @@IDENTITY, @errorCode = @@ERROR
		IF @errorCode > 0
		BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- IdxCache -- INSERT'
		GOTO CX_ERROR_EXIT
		END
		INSERT	INTO IdxAccessPath
				 (IdxCacheId, ClientId, Path, Username, Password, Enabled, SoftState, OfflineReason, Priority, LocalIndexTimeStamp, ActualDaysIndexRetain, Flags, DiskFreeWarningThreshholdMB, AgeingNoOfDays, AgeingPercentDiskspace, DiskFreeThresholdMB, TotalCapacityMB, StagingCachePath, VolumeGUID)
		SELECT	@new_IdxCacheId, @new_ClientId, @new_Path, a.UserName, a.Password, a.Enabled, a.SoftState, a.OfflineReason, a.Priority, 2, a.ActualDaysIndexRetain, a.Flags, a.DiskFreeWarningThreshholdMB, a.AgeingNoOfDays, a.AgeingPercentDiskspace, isnull(a.DiskFreeThresholdMB, 500), a.TotalCapacityMB, a.StagingCachePath, a.VolumeGUID
FROM		CommServ_Merge..CCM_IdxAccessPath a
		WHERE		a.IdxAccessPathId = @old_IdxAccessPathId
		AND     a.ClientId = @old_ClientId
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- IdxAccessPath -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		FETCH CUR_IdxAccessPath INTO @old_IdxAccessPathId, @old_ClientId, @old_Path
	END
	CLOSE CUR_IdxAccessPath
	DEALLOCATE CUR_IdxAccessPath
	/* -- Instead of calling merge_job the needed piece of code is moved here- see below
	-- Merge JM Job Action (Activity Control) of migrated media agents
	EXEC @errorCode = CCM_MERGE_JOB 0, 1, @errStr = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	*/
	--Calling CCM_MERGE_JOB for JMJobAction causes issue due to application map being dropped in merge_main, Hence moving the piece of code here
	-- Merge JM Job Action (Activity Control) of migrated media agents
	/*
	Most cases it should always 1. But why take chance
	*/
	DECLARE @sourceActivityControlAppId   INTEGER
	DECLARE @destActivityControlAppId   INTEGER
SET @sourceActivityControlAppId = ISNULL((SELECT TOP 1 id FROM CommServ_Merge..CCM_APP_Application WHERE appTypeId = 1000),0)
	SET @destActivityControlAppId   = ISNULL((SELECT TOP 1 id FROM APP_Application WHERE appTypeId = 1000),0)
	IF (@sourceActivityControlAppId = 0 OR @destActivityControlAppId = 0)
	AND (@isTapeImport <> 2)
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- AppId For ActivityControl Not Found in the database'
		GOTO CX_ERROR_EXIT
	END
	IF @sourceActivityControlAppId = 0 SET @sourceActivityControlAppId = 1
	IF @destActivityControlAppId = 0   SET @destActivityControlAppId = 1
	DECLARE @SQLQuery NVARCHAR(MAX)
IF COL_LENGTH('CommServ_Merge..CCM_JMJobAction','reason') IS NOT NULL
	BEGIN
		SET @SQLQuery = N'
		INSERT	INTO CCM_MAP_JobAction
		SELECT	clientId, 0, mediaAgentID, appType, opType, action, appId, 0, clientGroupId, 0, 0, 0, reason
FROM	CommServ_Merge..CCM_JMJobAction
		WHERE ((appId = '+ CAST( @sourceActivityControlAppId AS NVARCHAR(10)) + ' AND mediaAgentId = 1 AND appType = 0 AND clientGroupId = 0 ))'
	END
	ELSE
	BEGIN
		SET @SQLQuery = N'
		INSERT	INTO CCM_MAP_JobAction
		SELECT	clientId, 0, mediaAgentID, appType, opType, action, appId, 0, clientGroupId, 0, 0, 0, ''''
FROM	CommServ_Merge..CCM_JMJobAction
		WHERE ((appId = '+ CAST( @sourceActivityControlAppId AS NVARCHAR(10)) + ' AND mediaAgentId = 1 AND appType = 0 AND clientGroupId = 0 ))'
	END
	EXEC (@SQLQuery)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- CCM_MAP_JobAction -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JobAction SET new_clientId = old_clientId
	WHERE old_clientId = 1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- CCM_MAP_JobAction -- UPDATE new_clientId to 1'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JobAction SET new_clientId = b.new_id
	FROM CCM_MAP_JobAction a, CCM_MAP_Client b
	WHERE a.old_clientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- CCM_MAP_JobAction -- UPDATE new_clientId'
		GOTO CX_ERROR_EXIT
	END
	-- Reset appId during merge to new default appId
	UPDATE	CCM_MAP_JobAction SET new_appId = @destActivityControlAppId
	WHERE	old_appId = @sourceActivityControlAppId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- CCM_MAP_JobAction -- UPDATE new_appId 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_JobAction SET exist = 1
	FROM	CCM_MAP_JobAction a, JMJobAction b
	WHERE	a.new_clientId = b.clientId and a.mediaAgentID = b.mediaAgentID
	AND		a.appType = b.appType and a.optype = b.optype
	AND		a.new_appId = b.appId and a.clientGroupId = b.clientGroupId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- CCM_MAP_JobAction -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO JMJobAction
	SELECT	new_clientId, mediaAgentID, appType, opType, action, new_appId, clientGroupId, 0, 0, 0, 1, reason
	FROM	CCM_MAP_JobAction
	WHERE	exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_MediaAgent -- JMJobAction -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Deconfigure migrated clients.
	DECLARE @lt_ClientAppList TABLE (clientId int, appTypeId int)
	DECLARE @clientId int = 0
	DECLARE @appTypeId int = 0
	-- if client is missing or same client exists with migrated flag, then we can call client level deconfigure.
	INSERT INTO @lt_ClientAppList
	SELECT DISTINCT new_Id, 0
	FROM CCM_MAP_CLIENT a INNER JOIN APP_Client b ON a.new_id = b.id
WHERE a.new_id > 0 AND (b.specialClientFlags & 0x20) > 0
	-- if client is present, but agent is missing then we should call agent level deconfigure.
	INSERT 	INTO @lt_ClientAppList
	SELECT  DISTINCT a.new_Id, b.appTypeId
	FROM   	CCM_MAP_CLIENT a INNER JOIN CCM_MAP_IdaName b ON a.old_Id = b.old_clientId
			LEFT OUTER JOIN @lt_ClientAppList c ON c.clientId = a.new_Id
	WHERE 	b.exist = 0 AND c.clientId IS NULL
	-- if client and agent both are present but agent is in deconfigured state, but DR backup has agent in configured state(some backupsets are created), if we merge from DR then we should deconfigure the agent otherwise missing backupsets will be in configured state, so we should deconfigure the agent again.
	INSERT 	INTO @lt_ClientAppList
	SELECT  DISTINCT a.new_Id, b.appTypeId
	FROM   	CCM_MAP_CLIENT a INNER JOIN CCM_MAP_IdaName b ON a.old_Id = b.old_clientId
			LEFT OUTER JOIN @lt_ClientAppList c ON c.clientId = a.new_Id AND (c.appTypeId = b.appTypeId OR c.appTypeId = 0)
	WHERE 	b.exist = 1 AND c.clientId IS NULL
			AND EXISTS (SELECT 1 FROM licUsage WHERE CId = a.new_id AND AppType = b.appTypeId AND OpType = 'UnInstall')
	-- Skip VSA discovered VMs so that we don't need to configure again.
	DELETE @lt_ClientAppList
	FROM @lt_ClientAppList A INNER JOIN APP_ClientProp B ON A.clientId = B.componentNameId
	WHERE B.attrName = 'Virtual Server Discovered Clients' AND CAST(B.attrVal AS INT) = 1
			-- vCenter configured VM should be excluded as this is pseudo client and it has discover clients property.
			AND NOT EXISTS (
				SELECT 1
				FROM APP_APPlication APP
				INNER JOIN APP_InstanceProp InstProp ON APP.instance = InstProp.componentNameId
				WHERE APP.clientId = A.clientId AND InstProp.attrName = N'Virtual Server Instance Type'
				AND InstProp.attrVal <> '' AND InstProp.modified = 0
							)
	/*
	IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#tempError]'))
		DROP TABLE #tempError
	CREATE TABLE #tempError (errCode INTEGER, errStr VARCHAR(MAX) )
	DECLARE @STOREDPROC_QUERY VARCHAR(MAX) = 'DECLARE @errCode INT , @errStr VARCHAR(MAX) ; '
	DECLARE @ERROR_HANDLE_QUERY VARCHAR(MAX) = ' IF @@ERROR <> 0 OR @errCode <> 0 BEGIN INSERT INTO #tempError VALUES (@errCode, @errStr) ; RAISERROR (''%s'' , 16, 1 ,@errStr)  ; END ; '
	SELECT @STOREDPROC_QUERY +=
		' EXEC AppConfDeconf '+CONVERT(VARCHAR,@clientId)+', '+CONVERT(VARCHAR,@appTypeId)+', 0, 2, @errCode OUTPUT, @errStr OUTPUT '+ @ERROR_HANDLE_QUERY
	 FROM @lt_ClientAppList
	BEGIN TRY
		EXEC (@STOREDPROC_QUERY)
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = errCode , @errorString = errStr FROM #tempError
		GOTO CX_ERROR_EXIT
	END CATCH
	*/
	DECLARE DeconfigureClientCur CURSOR LOCAL FORWARD_ONLY
	FOR	SELECT clientId, appTypeId FROM @lt_ClientAppList
	OPEN DeconfigureClientCur
	FETCH DeconfigureClientCur INTO @clientId, @appTypeId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		EXEC AppConfDeconf @clientId, @appTypeId, 0, 2, @errorCode OUTPUT, @errorString OUTPUT
		IF @@ERROR <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
		FETCH NEXT FROM DeconfigureClientCur INTO @clientId, @appTypeId
	END
	CLOSE DeconfigureClientCur
	DEALLOCATE DeconfigureClientCur
	---------------------------------------------------------
	DECLARE @l_curImportJobId Integer
	SET @l_curImportJobId =  ISNULL
	(
		(
			@i_jobId
		), 0
	)
	-- no need to do the below if there is no jobid, we shouldn't fail either as
	-- ccm is actually completed here.
	IF (@isTapeImport <> 2 AND @l_curImportJobId  > 0) --Not needed for EDC
	BEGIN
		--Insert the oldId newId mappings so that they can be used in the cpp layer even after the CCM_Merge_MediaAgent completes
		--Client Id Map - Entity Type - 3
		INSERT INTO CCMMergeEntityMap
SELECT DISTINCT @l_curImportJobId, 2, A.old_id, A.new_id, 3, B.GUID
		FROM CCM_Map_Client A, App_Client B
		WHERE A.new_id = B.id
		AND A.new_id <> 0
		AND NOT EXISTS (SELECT * FROM CCMMergeEntityMap WHERE importJobId = @l_curImportJobId
						AND oldEntityId = A.old_id
AND entityType = 3)
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'CCM_Merge_MediaAgent -- CCMMergeEntityMap -- INSERT -- Client Map'
			GOTO CX_ERROR_EXIT
		END
	END
	---------------------------------------------------------
	---------------------------------------------------------
	SET @errorString = 'NO_ERROR'
	EXEC CCM_Merge_Map 0
COMMIT TRANSACTION TRAN_Merge_MediaAgent
    SELECT	0, @errorString
	RETURN (0)
CX_ERROR_EXIT:
    EXEC CCM_Merge_Map 0
    IF (Cursor_Status('LOCAL', 'CUR_IdxAccessPath') >= -1)
	BEGIN
		CLOSE CUR_IdxAccessPath
		DEALLOCATE CUR_IdxAccessPath
	END
ROLLBACK TRANSACTION TRAN_Merge_MediaAgent
RAISERROR ('%s' , 16, 1, @errorString)
    SELECT	-1, @errorString
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_MediaAgent')
	delete from GxQscripts where name = 'CCM_Merge_MediaAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_MediaAgent')
	delete from GXDBVersions where aliasname = 'CCM_Merge_MediaAgent'
GO

insert into GXDBVersions values(2, 'CCM_Merge_MediaAgent',  '00010032019000030000', 'CCM_Merge_MediaAgent', '00010032019000030000')
GO

