

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_Main_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge data captured from another commserver
--  +========================================================================+
-- $Id: CCM_Merge_Main_from_XML.sp,v 1.7.66.4.8.1 2021/05/24 18:09:34 pnara Exp $
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCM_Merge_Main_from_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Merge_Main_from_XML <<<'
	drop procedure CCM_Merge_Main_from_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Merge_Main_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Main_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Main_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Main_from_XML'
GO
print '... Creating Procedure: CCM_Merge_Main_from_XML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCM_Merge_Main_from_XML
  @tapeReusable integer,
  @isTapeImport integer,
  @i_mergeActivityControl integer,
  @i_mergeHolidays integer,
  @i_mergeOperationWindow integer,
  @i_ccmParamFlags integer,
  @i_skipConflictingMedia integer,
  @i_jobId integer,
  @i_mergeTimeStamp integer,
  @i_indexMAName varchar(1024) = ''
AS
  DECLARE @errorCode integer
  DECLARE @errorString varchar(4000)
---------------------------------------------------------------------
--- CODE BELOW HERE IS FROM CCM_Merge_Main.spb  ----------
SET XACT_ABORT ON
SET NOCOUNT ON
BEGIN TRANSACTION TRAN_Merge_Main
	SET @errorCode = 0
	SET @errorString = 'ERROR: GENERAL ERROR!'
	DECLARE @l_forceOverWrite integer
	-- Temp Table to indicate to other CV Subsystem that this is a CCM Import Operation
	-- CCS Subsystem will bypass trigger processing if Temp Table exist on session for imported data rows.
	 IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NULL
	 BEGIN
		CREATE TABLE #CCM_IMPORT_IS_RUNNING (
			[spid]			INT,
			[startTime]		INT
		)
		INSERT INTO #CCM_IMPORT_IS_RUNNING ([spid], [startTime])
			VALUES (@@SPID, dbo.getUnixTime(GETUTCDATE()))
	 END
	--Create temp table GRC_IMPORT_IS_RUNNING in case of GRC import
	IF ( 1 = (@i_ccmParamFlags & 1)) AND OBJECT_ID('tempdb..#GRC_IMPORT_IS_RUNNING') IS NULL
		CREATE TABLE #GRC_IMPORT_IS_RUNNING (JobId int)
	DECLARE @commcellGUID nvarchar(max)
SET @commcellGUID = (SELECT csGUID FROM #CCM_App_CommCell WHERE id = 2 and type = 1)
	DECLARE @l_curImportJobId Integer
	SET @l_curImportJobId =  ISNULL
	(
		(
			@i_jobId
		), 0
	)
	DECLARE @l_indexMAId INTEGER = 1
	IF @i_indexMAName <> ''
		SET @l_indexMAId = ISNULL((SELECT id FROM App_Client WITH (READUNCOMMITTED) WHERE name = @i_indexMAName), 1)
	IF @l_indexMAId <= 1
		set @l_indexMAId = isnull((select top 1 id from APP_Client where name = CAST((select value from GXGlobalParam where name = 'DefaultCCMFallBackMediaAgent') as nvarchar(512))),0)
	IF @l_indexMAId <= 1
		set @l_indexMAId = isnull((select top 1 CL.id from APP_Client CL, MMHost H where CL.id = H.clientId
		order by (case when exists(select 1 from MMLibraryController where ClientId = H.clientId) then 0 else 1 end),  H.MmHostSoftState desc, H.MmHostEnabled desc),0)
	---------------------------------------------------------
IF NOT EXISTS (SELECT * FROM #CCM_App_Client)
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Main -- NO CLIENT TO MIGRATE, PLEASE CAPTURE DATA BEFORE MERGE'
		GOTO CX_ERROR_EXIT
	END
	--Removing release check since we are supporting cross version ccm
	/*DECLARE	@release_source varchar(128)
	DECLARE	@release_destination varchar(128)
SET @release_source = ISNULL((select top 1 release from #CCM_simAllGalaxyRel order by id desc),'N/A')
	SET @release_destination = ISNULL((select top 1 release from simAllGalaxyRel order by id desc),'N/A')
	IF @isTapeImport = 0
	BEGIN
		IF @release_source <> @release_destination
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- RELEASE MISMATCH: SOURCE IN [' + @release_source + '] AND DESTINATION IN [' + @release_destination + ']'
			GOTO CX_ERROR_EXIT
		END
	END
	*/
	---------------------------------------------------------
	--PrasadNara:In regurar CCM If MA is getting migrated then use the same source MA as Target MA for libraries
	--Here just set the flag and do the mapping after name change
IF (@i_ccmParamFlags & 1) = 0
	BEGIN
		/*UPDATE CCMLibraryAnswers
		SET TargetMediaAgentId = ISNULL(f.clientId, 1),
flags = flags | 1
FROM CCMLibraryAnswers a INNER JOIN #CCM_MMLibrary b ON a.SourceLibraryId = b.LibraryId
INNER JOIN #CCM_MMMasterPool c ON b.LibraryId = c.LibraryId
INNER JOIN #CCM_MMDrivePool d ON c.MasterPoolId = d.MasterPoolId
			INNER JOIN CCMMergeEntityMap e ON d.clientId = e.oldEntityId
			INNER JOIN MMHost f ON e.newEntityId = f.clientId
		WHERE  a.SourceCommCellGUID = @commcellGUID
			AND e.importJobId = @l_curImportJobId
AND e.entityType = 3
			AND b.LibraryTypeId NOT IN (1,9,8)
			AND a.allowEdit = 1
			AND a.TargetMediaAgentId IN (0,1)
			AND e.oldEntityId > 2
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCMLibraryAnswers -- UPDATE -- TargetMediaAgentId 1'
			GOTO CX_ERROR_EXIT
		END
		*/
		--Set the migrated MA new id in SourceMediaAgentId, we will use this during name change and will map the libraries
		IF @l_curImportJobId > 0
		BEGIN
			UPDATE CCMMountPathAnswers
			SET SourceMediaAgentId = ISNULL(g.newEntityId, 1)
			FROM CCMMountPathAnswers a
INNER JOIN #CCM_MMMountPath b ON a.SourceMountPathId = b.MountPathId
				INNER JOIN CCMLibraryAnswers c ON b.LibraryId = c.SourceLibraryId AND a.SourceCommCellGUID = c.SourceCommCellGUID
INNER JOIN #CCM_MMLibrary d ON c.SourceLibraryId = d.LibraryId
INNER JOIN #CCM_MMMasterPool e ON d.LibraryId = e.LibraryId
INNER JOIN #CCM_MMDrivePool f ON e.MasterPoolId = f.MasterPoolId
				INNER JOIN CCMMergeEntityMap g ON f.clientId = g.oldEntityId
			WHERE a.SourceCommCellGUID = @commcellGUID
				AND c.allowEdit = 1
				AND c.TargetMediaAgentId IN (0,1)
				AND d.LibraryTypeId NOT IN (1,9,8)
				AND g.importJobId = @l_curImportJobId
AND g.entityType = 3
				AND g.oldEntityId > 2
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- CCMMountPathAnswers -- UPDATE -- SourceMediaAgentId'
				GOTO CX_ERROR_EXIT
			END
		END
		/*UPDATE CCMDevicePathAnswers
		SET TargetMediaAgentId = ISNULL(d.TargetMediaAgentId, 0),
			TargetDevicePath = a.SourceDevicePath,
			TargetDevicePathUsername = '',
			TargetDevicePathPassword = ''
		FROM CCMDevicePathAnswers a
			INNER JOIN CCMMountPathAnswers b ON a.SourceDeviceId = b.SourceDeviceId
INNER JOIN #CCM_MMMountPath c ON b.SourceMountPathId = c.MountPathId
			INNER JOIN CCMLibraryAnswers d ON c.LibraryId = d.SourceLibraryId
		WHERE a.SourceCommCellGUID = @commcellGUID
			AND b.SourceCommCellGUID = @commcellGUID
			AND d.SourceCommCellGUID = @commcellGUID
AND (d.flags & 1) > 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCMDevicePathAnswers -- UPDATE -- TargetMediaAgentId 1'
			GOTO CX_ERROR_EXIT
		END
		*/
	END
	---------------------------------------------------------
	-- Answers validation --
	-- Try to answer the questions for data path based on answer tables (CCMMediaTypeAnswers)
IF EXISTS(SELECT * FROM #CCM_DataPathMapping)
	BEGIN
UPDATE #CCM_DataPathMapping
	    SET newMediaAgentId = 0, newLibraryId = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_DataPathMapping -- UPDATE 1'
			GOTO CX_ERROR_EXIT
		END
UPDATE #CCM_DataPathMapping
		SET newMediaAgentId = b.mediaAgentId,
			newLibraryId    = b.libraryId,
			newDataPathId   = b.DrivePoolId,
			newSpareGroupId = b.SparePoolGroupId
		FROM CommServ..CCMMediaTypeAnswers b,
			 CommServ..MMRecFmtMedTyp c
WHERE #CCM_DataPathMapping.DriveTypeId = c.DriveTypeId
		  AND c.MediaTypeId = b.MediaTypeId
		  AND b.mediaAgentId > 1 -- 1 is Dummy Media Agent Id
		  AND b.libraryId > 0    -- 0 is Dummy Library Id
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_DataPathMapping -- UPDATE 2'
			GOTO CX_ERROR_EXIT
		END
		-- Unanswered Data Path questions
		--IF EXISTS(SELECT * FROM Commserv_Merge..CCM_DataPathMapping WHERE newMediaAgentId = 0 OR newLibraryId = 0)
		--BEGIN
		-- SET @errorString = 'ERROR: CCM_Merge_Main -- Answers needed for DataPath Mappings, Merge Can not Proceed'
		--  GOTO CX_ERROR_EXIT
		--END
    END
IF EXISTS(SELECT * FROM #CCM_MountPathMapping)
    BEGIN
		-- Try to answer the questions for mount path based on answer tables (CCMMountPathAnswers)
UPDATE #CCM_MountPathMapping
		SET newMountPathName = '', newLibraryId = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_MountPathMapping -- UPDATE 1'
			GOTO CX_ERROR_EXIT
		END
		--Update the password if it is empty in answers table from merge db
		--Password becomes empy in answers table when user doesn't edit the existing credentials in GUI
		UPDATE CommServ..CCMMountPathAnswers
		SET TargetMountPathUserName = b.UserName,
			TargetMountPathPassword = b.UserPassword
FROM CommServ..CCMMountPathAnswers a, #CCM_MMMountPath b
		WHERE a.SourceCommCellGUID = @commcellGUID
			AND a.SourceMountPathId = b.MountPathId
			AND (ISNULL(a.TargetMountPathUserName, '') = '' OR ISNULL(a.TargetMountPathPassword, '') = '' )
			AND ISNULL(b.UserName, '') <> ''
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCMMountPathAnswers -- UPDATE Password'
			GOTO CX_ERROR_EXIT
		END
UPDATE #CCM_MountPathMapping
		SET newLibraryId     = a.TargetLibraryId,
			newMountPathName = a.TargetMountPathName,
			newUserName      = a.TargetMountPathUserName,
			newPassword      = a.TargetMountPathPassword,
			TargetDeviceMediaAgentId = ISNULL(a.TargetDeviceMediaAgentId,0)
		FROM CommServ..CCMMountPathAnswers a
		WHERE --a.SourceCommCellId = @commcellNumber
		  a.SourceCommCellGUID = @commcellGUID
AND a.SourceMountPathId = #CCM_MountPathMapping.MountPathId
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_MountPathMapping -- UPDATE 2'
			GOTO CX_ERROR_EXIT
		END
		-- Unanswered Mount Path questions
		--Skip MountPath ans checking for GRC import and CCM, we check this after migrating Library
		--IF EXISTS(SELECT * FROM CCM_DB_MOUNTPATHMAPPING WHERE newLibraryId = 0 OR (ISNULL(newMountPathName,'') = ''))
		--	AND  (0 = (@i_ccmParamFlags & 1))
		--BEGIN
		--  SET @errorString = 'ERROR: CCM_Merge_Main -- Answers needed for MountPath Mappings, Merge Can not Proceed'
		--  GOTO CX_ERROR_EXIT
		--END
    END
IF EXISTS(SELECT * FROM #CCM_DevicePathMapping)
    BEGIN
		-- Try to answer the questions for device path based on answer tables (CCMdevicePathAnswers)
UPDATE #CCM_DevicePathMapping
		SET newDevicePath = '', newMediaAgentId = 1 --lpulickal
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_DevicePathMapping -- UPDATE 1'
			GOTO CX_ERROR_EXIT
		END
		--Update the password if it is empty in answers table from merge db
		--Password becomes empy in answers table when user doesn't edit the existing credentials in GUI
		UPDATE CommServ..CCMDevicePathAnswers
		SET TargetDevicePathUserName = b.UserName,
			TargetDevicePathPassword = b.UserPassword
FROM Commserv..CCMDevicePathAnswers a, #CCM_MMDeviceController b
		WHERE a.SourceCommCellGUID = @commcellGUID
			AND a.SourceDeviceId = b.DeviceId
			AND a.TargetDevicePath = b.Folder
			AND (ISNULL(a.TargetDevicePathUserName, '') = '' OR ISNULL(a.TargetDevicePathPassword, '') = '' )
			AND ISNULL(b.UserName, '') <> ''
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCMDevicePathAnswers -- UPDATE Password'
			GOTO CX_ERROR_EXIT
		END
UPDATE #CCM_DevicePathMapping
		SET newMediaAgentId = B.TargetMediaAgentId , newDevicePath = B.TargetDevicepath , newUserName = B.TargetDevicePathUserName, newPassword = B.TargetDevicePathPassword
FROM #CCM_DevicePathMapping A, Commserv..CCMDevicePathAnswers B
		WHERE --B.SourceCommcellId = @commcellNumber
		B.SourceCommCellGUID = @commcellGUID
		AND B.SourceDeviceId = A.SourceDeviceId
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_DevicePathMapping -- UPDATE 2'
			GOTO CX_ERROR_EXIT
		END
		-- Unanswered Device Path questions
IF EXISTS(SELECT * FROM #CCM_DevicePathMapping WHERE newMediaAgentId = 0 OR (newMediaAgentId > 1 AND (ISNULL(newDevicePath,'') = '')))
		BEGIN
		  SET @errorString = 'ERROR: CCM_Merge_Main -- Answers needed for DevicePath Mappings, Merge Can not Proceed'
		  GOTO CX_ERROR_EXIT
		END
    END
IF EXISTS(SELECT * FROM #CCM_IdxAccessPathMapping)
    BEGIN
		-- Try to answer the questions for sidb access path based on answer tables (CCMSIDBPathAnswers)
UPDATE #CCM_IdxAccessPathMapping
		SET newClientId = 0, newPath = ''
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_IdxAccessPathMapping -- UPDATE 1'
			GOTO CX_ERROR_EXIT
		END
UPDATE #CCM_IdxAccessPathMapping
		SET newClientId = B.TargetMediaAgentId , newPath = B.TargetpathName , newUserName = B.TargetUserName, newPassword = B.TargetPasword
FROM #CCM_IdxAccessPathMapping A, Commserv..CCMSIDBPathAnswers B
		WHERE --B.SourceCommcellId = @commcellNumber
		B.SourceCommCellGUID = @commcellGUID
		AND B.SourceIdxAccessPathId = A.oldIdxAccessPathId
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_IdxAccessPathMapping -- UPDATE 2'
			GOTO CX_ERROR_EXIT
		END
		--We don't ask mappings for SIDB in both CCM and GRC, doing same for both GRC and CCM
		-- Unanswered IdxAccess Path questions
		--IF EXISTS(SELECT * FROM CCM_DB_IDXACCESSPATHMAPPING WHERE newClientId = 0 OR (ISNULL(newPath,'') = ''))
		--	AND  (0 = (@i_ccmParamFlags & 1))
		--BEGIN
		--  SET @errorString = 'ERROR: CCM_Merge_Main -- Answers needed for SIDB AccessPath Mappings, Merge Can not Proceed'
		--  GOTO CX_ERROR_EXIT
		--END
    END
IF EXISTS(SELECT * FROM #CCM_LibraryMapping)
    BEGIN
		-- Try to answer the questions for library based on answer tables (CCMLibraryAnswers)
UPDATE #CCM_LibraryMapping
		SET newLibraryId = 0, newMediaAgentId = 1, newLibraryName = '' --lpulickal
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_LibraryMapping -- UPDATE 1'
			GOTO CX_ERROR_EXIT
		END
UPDATE #CCM_LibraryMapping
		SET newMediaAgentId = B.TargetMediaAgentId,
			newLibraryId = B.TargetLibraryId,
			newLibraryName = B.TargetLibraryName
FROM #CCM_LibraryMapping A, Commserv..CCMLibraryAnswers B
		WHERE B.SourceCommCellGUID = @commcellGUID
			AND B.SourceLibraryId = A.SourceLibraryId
			AND B.answerGiven = 1
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_LibraryMapping -- UPDATE 2'
			GOTO CX_ERROR_EXIT
		END
		-- Unanswered Library questions
IF EXISTS(SELECT * FROM #CCM_LibraryMapping WHERE newMediaAgentId = 0)
		--	AND  (1 = (@i_ccmParamFlags & 1))
		BEGIN
		  SET @errorString = 'ERROR: CCM_Merge_Main -- Answers needed for Library Mappings, Merge Can not Proceed'
		  GOTO CX_ERROR_EXIT
		END
    END
IF EXISTS(SELECT * FROM #CCM_App_Client)
    BEGIN
        --SET @commcellNumber = 0
		--SET @commcellNumber = (SELECT number FROM Commserv_Merge..CCM_APP_Commcell WHERE id = 2 and type = 1)
SET @commcellGUID = (SELECT csGUID FROM #CCM_App_CommCell WHERE id = 2 and type = 1)
IF EXISTS(SELECT * FROM Commserv..CCMClientAnswers a, #CCM_App_Client b
		          WHERE --a.SourceCommCellId = @commcellNumber
					a.SourceCommCellGUID = @commcellGUID
		            AND a.OldClientName = b.name
		            AND a.OldClientHostName = b.net_hostname
		            AND (a.NewClientName = '' AND a.NewClientHostName <> ''
		                 OR a.NewClientName <> '' AND a.NewClientHostName = '')
		         )
		BEGIN
		  SET @errorString = 'ERROR: CCM_Merge_Main -- Answers needed for both client name and hostname'
		  GOTO CX_ERROR_EXIT
		END
IF EXISTS(SELECT * FROM Commserv..CCMClientAnswers a, #CCM_App_Client b
		          WHERE --a.SourceCommCellId = @commcellNumber
					a.SourceCommCellGUID = @commcellGUID
		            AND a.OldClientName = b.name
		            AND a.OldClientHostName = b.net_hostname
		            AND a.NewClientName <> ''
		            AND a.NewClientHostName <> ''
		         )
		BEGIN
		  -- Answer provided, perform the following validations
IF EXISTS (SELECT * FROM Commserv..CCMClientAnswers a, #CCM_App_Client c
   		             WHERE --a.SourceCommCellId = @commcellNumber
   					  a.SourceCommCellGUID = @commcellGUID
		              AND a.OldClientName = c.name
		              AND a.OldClientHostName = c.net_hostname
		              AND a.NewClientName <> ''
		              AND a.NewClientHostName <> ''
		              AND EXISTS (SELECT * FROM Commserv..APP_Client b WHERE (   (a.NewClientName = b.name AND a.NewClientHostName <> b.net_hostname)
		                                                                      OR (a.NewClientName <> b.name AND a.NewClientHostName = b.net_hostname)
		                                                                     )
																			 AND b.GUID <> c.GUID
		                         )
		            )
		  BEGIN
		    SET @errorString = 'ERROR: CCM_Merge_Main -- New Client Name or New Client Host Name already exists in the destination DB'
			SELECT @errorString = @errorString + CHAR(13) + REPLICATE(' ',80) +'IMPORTED:'+ ' New Name - ' +'['+a.NewClientName+']'+' New Host Name - ' +'['+a.NewClientHostName+']'+ CHAR(13) + REPLICATE(' ',80) +'EXISTING: ' + 'Name - ' +'['+ b.name+']'+ ' Host Name - ' +'['+b.net_hostname+']'
FROM Commserv..CCMClientAnswers a, #CCM_App_Client c, Commserv..APP_Client b
			WHERE	  a.SourceCommCellGUID = @commcellGUID
					  AND a.OldClientName = c.name
					  AND a.OldClientHostName = c.net_hostname
					  AND a.NewClientName <> ''
					  AND a.NewClientHostName <> ''
					  AND ((a.NewClientName = b.name AND a.NewClientHostName <> b.net_hostname)
							OR (a.NewClientName <> b.name AND a.NewClientHostName = b.net_hostname))
		    GOTO CX_ERROR_EXIT
		  END
		  -- All validations done, consider the answers as valid
INSERT INTO #CCM_ClientNameMapping
		  SELECT a.name, b.NewClientName, b.NewClientHostName
FROM #CCM_App_Client a, Commserv..CCMClientAnswers b
		  WHERE a.name = b.OldClientName
		    AND a.net_hostname = b.OldClientHostName
		    AND b.SourceCommCellGUID = @commcellGUID
  		    --AND b.SourceCommCellId = @commcellNumber
  		    AND b.NewClientName <> ''
  		    AND b.NewClientHostName <> ''
  		  IF @@ERROR > 0
		  BEGIN
		 	SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_ClientNameMapping -- INSERT'
			GOTO CX_ERROR_EXIT
		  END
		END
    END
	---------------------------------------------------------
	-- Create Temp Table to be used by merge operation
	EXEC CCM_MERGE_MAP 1
	---------------------------------------------------------
	-- Merge CommCell table
	EXEC @errorCode = CCM_MERGE_CommCell_from_XML @errorString = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	-- Merge Custom Calendar table
	EXEC @errorCode = CCM_Merge_CustomCalendar_from_XML @errStr = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	--kbora, find out all the tapeimport created entities which are also in current merge Db.
	IF @isTapeImport=0
    BEGIN
		-- If any of the subclient belongs to migrated is already came by tape import, just get the tape import created client. we can over write this.
		INSERT INTO CCM_TapeImportEntities
SELECT DISTINCT A.clientId, C.clientId, 3, D.new_id
FROM #CCM_APP_Application A, TapeImportMappings B, APP_Application C, CCM_MAP_CommCell D, APP_Client F -- This is to find out actual commcell id to which client belongs.
WHERE A.id = B.old_Id AND B.entityType = 7 AND A.origCCId = D.old_id AND B.newCCId = D.new_id AND B.new_Id = C.id AND C.clientId = F.id AND (F.specialClientFlags & 0x100) = 0x100
		INSERT INTO CCM_TapeImportEntities
SELECT A.id, C.id, 7, D.new_id
FROM #CCM_APP_Application A,TapeImportMappings B, APP_Application C, CCM_MAP_CommCell D
		WHERE A.id = B.old_Id AND B.newCCId = D.new_id AND B.new_Id = C.id AND C.subclientName='SubClient_'+CAST(C.id AS VARCHAR(100))
UPDATE #CCM_archGroup
		SET origCCcommCellID=2
		WHERE origCCcommCellID=0
UPDATE #CCM_archGroupCopy
		SET origCCcommCellID = 2
		WHERE origCCcommCellID = 0
		INSERT INTO CCM_TapeImportEntities
SELECT B.id, F.id, 17,D.new_id
FROM #CCM_archGroupCopy A, #CCM_archGroup B, TapeImportMappings C, CCM_MAP_CommCell D, archGroupCopy E, archGroup F
WHERE A.id = C.old_Id AND A.origCCcommCellID = D.old_id AND D.new_id = C.newCCId AND A.archGroupId = B.id AND C.new_Id = E.id AND E.archGroupId = F.id AND C.entityType = 18  AND F.type = 8
		INSERT INTO CCM_TapeImportEntities
SELECT A.id, C.id, 18, D.new_id
FROM #CCM_archGroupCopy A, TapeImportMappings B, archGroupCopy C, CCM_MAP_CommCell D
WHERE A.id = B.old_Id AND A.origCCcommCellID = D.old_id AND B.newCCId = D.new_id AND B.new_Id = C.id AND C.type = 8
	END
	ELSE IF  @isTapeImport = 1   --Populate CCM Map tables using TapeImport Map tables
	BEGIN
			INSERT 	INTO CCM_Map_Client
			SELECT 	c.id, b.id, c.name, b.name, c.net_hostname, b.net_hostname, c.origCCId, b.origCCId, 0, 1
			FROM	CCM_TI_MAP_Client a
					INNER JOIN App_Client b ON a.new_clientId = b.id
INNER JOIN #CCM_App_Client c ON a.old_clientId = c.id
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_Map_Client - TapeImport -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			INSERT 	INTO CCM_MAP_Application
			SELECT 	c.id, b.id, c.clientId, b.clientId, c.instance, b.instance, c.backupset, b.backupset, c.dataArchGrpId,
					b.dataArchGrpId, c.logArchGrpId, b.logArchGrpId, b.appTypeId, b.refTime, b.subclientName, c.origCCId, b.origCCId, b.GUID
			FROM	CCM_TI_MAP_Application a
					INNER JOIN App_Application b ON a.new_appId = b.id
INNER JOIN #CCM_APP_Application c ON a.old_appId = c.id
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_Map_Application - TapeImport -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO APP_ClientProp
			SELECT A.new_clientId,B.attrName,B.attrType,B.attrVal,B.created,B.modified,B.ccpId
			FROM CCM_TI_MAP_Client A INNER JOIN Commserv_Merge..CCM_APP_ClientProp B ON A.old_clientId = B.componentNameId AND B.attrName IN ('Encrypt: rsaPubKey', 'Encrypt: rsaPriKeyBPF')
				  LEFT OUTER JOIN  APP_ClientProp C ON A.new_clientId = C.componentNameId AND C.attrName = 'Encrypt: rsaPubKey'
			WHERE C.id IS NULL
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- Enc Key insertion into APP_ClientProp '
				GOTO CX_ERROR_EXIT
			END
			UPDATE APP_ClientProp
			SET attrVal = B.attrVal
			FROM CCM_TI_MAP_Client A INNER JOIN Commserv_Merge..CCM_APP_ClientProp B ON A.old_clientId = B.componentNameId
				  INNER JOIN  APP_ClientProp C ON A.new_clientId = C.componentNameId AND C.attrName = 'Encrypt: rsaPubKey'
			WHERE C.attrVal = ''
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- Enc Key UPDATE into APP_ClientProp '
				GOTO CX_ERROR_EXIT
			END
			UPDATE APP_ClientProp
			SET attrVal = B.attrVal
			FROM CCM_TI_MAP_Client A INNER JOIN Commserv_Merge..CCM_APP_ClientProp B ON A.old_clientId = B.componentNameId
				  INNER JOIN  APP_ClientProp C ON A.new_clientId = C.componentNameId AND C.attrName = 'Encrypt: rsaPriKeyBPF'
			WHERE C.attrVal = ''
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- Enc Key UPDATE into APP_ClientProp '
				GOTO CX_ERROR_EXIT
			END
	END
	-- Pre Check for Barcode and UniqueId collision (only if media exists in the destination commcell)
   IF EXISTS (SELECT * FROM MMMedia WHERE MediaId > 0)
   BEGIN
	DECLARE @BarcodeCollision	TABLE (barcode varchar(255))
	DECLARE @UniqueIdCollision	TABLE (UniqueId varchar(255))
	DECLARE @noOfBarcode		INTEGER
	DECLARE @noOfUniqueId		INTEGER
	DECLARE @newCommcellId INTEGER
	DECLARE @newCommcellNumber varchar(10)
	SELECT @newCommcellId = new_id, @newCommcellNumber = CAST(Number as varchar(10))
	FROM CCM_MAP_Commcell (readuncommitted) WHERE old_id = 2
	-----------------------------------------------------------------------
	-- Update uniqueId if the media is discovered as a new media in destination CS prior to merge and no data is written by destination CS.
	DECLARE @DiscoveredMedia	TABLE (new_MediaId int, old_MediaId int)
	INSERT 	INTO @DiscoveredMedia
	SELECT	DISTINCT a.MediaId, b.MediaId
	FROM	MMMedia a
INNER JOIN #CCM_MMMedia b ON a.Barcode = b.Barcode
			INNER JOIN MMMediaSide c ON a.MediaId = c.MediaId
			INNER JOIN MMVolume d ON a.MediaId = d.MediaId
	WHERE	a.MediaTypeId <> 10001
			AND	a.origCCcommCellId IN (0, 2)
			AND	(SUBSTRING( a.UniqueId, 1, NULLIF(CHARINDEX('_', a.UniqueId),0) - 1) = '2' OR a.UniqueId != b.UniqueId)
			AND a.MediaId > 0 -- MMMedia has a dummy record
			AND c.isOMLValid = 0    --OML_NOT_WRITTEN
			AND NOT EXISTS (SELECT 1 FROM archChunk WHERE VolumeId = d.VolumeId)
	IF EXISTS (SELECT 1 FROM @DiscoveredMedia)
	BEGIN
		UPDATE	MMMedia
		SET		UniqueId 			= c.UniqueId,
				creationTime		= c.creationTime,
				origCCcommCellId	= (CASE c.origCCcommCellId WHEN 0 THEN @newCommcellId
											ELSE (SELECT new_id FROM CCM_MAP_Commcell
											WHERE old_id = c.origCCcommCellId)
										END),
				origCCmediaId 		= (CASE c.origCCmediaId WHEN 0 THEN c.MediaId ELSE c.origCCmediaId END)
		FROM	MMMedia a
				INNER JOIN @DiscoveredMedia b ON a.MediaId = b.new_MediaId
INNER JOIN #CCM_MMMedia c ON b.old_MediaId = c.MediaId
		UPDATE	MMVolume
		SET		origCCcommCellId	= (CASE c.origCCcommCellId WHEN 0 THEN @newCommcellId
											ELSE (SELECT new_id FROM CCM_MAP_Commcell
											WHERE old_id = c.origCCcommCellId)
										END),
				origCCvolumeId 		= (CASE c.origCCvolumeId WHEN 0 THEN c.VolumeId ELSE c.origCCvolumeId END),
				reformatTime 		= c.reformatTime
		FROM	MMVolume a
				INNER JOIN @DiscoveredMedia b ON a.MediaId = b.new_MediaId
INNER JOIN #CCM_MMVolume c ON b.old_MediaId = c.MediaId
	END
	-----------------------------------------------------------------------
	INSERT @BarcodeCollision
	SELECT  a.Barcode
FROM	MMMedia a, #CCM_MMMedia b
	WHERE	a.MediaTypeId <> 10001 AND a.Barcode = b.Barcode
	AND		(CASE a.origCCcommCellId WHEN 0 THEN 2 ELSE a.origCCcommCellId END)
			<>
			(CASE b.origCCcommCellId WHEN 0 THEN @newCommcellId
				ELSE (SELECT new_id FROM CCM_MAP_Commcell
					  WHERE old_id = b.origCCcommCellId)
			 END)
	AND	(SUBSTRING( a.UniqueId, 1, NULLIF(CHARINDEX('_', a.UniqueId),0) - 1) = '2' OR a.UniqueId != b.UniqueId)
	AND a.MediaId > 0 -- MMMedia has a dummy record
	SELECT @noOfBarcode = @@ROWCOUNT
	INSERT @UniqueIdCollision
	SELECT a.UniqueId
FROM	MMMedia a, #CCM_MMMedia b
	WHERE	a.MediaTypeId = 10001
	AND     a.MediaId > 0 -- MMMedia has a dummy record
	AND		a.UniqueId = CASE SUBSTRING( b.UniqueId, 1, NULLIF(CHARINDEX('_', b.UniqueId),0) - 1)
						 WHEN '2' THEN STUFF( b.UniqueId, 1, CHARINDEX('_', b.UniqueId) - 1, @newCommCellNumber)
						 ELSE b.UniqueId
						 END
	AND		(CASE a.origCCcommCellId WHEN 0 THEN 2 ELSE a.origCCcommCellId END)
			<>
			(CASE b.origCCcommCellId WHEN 0 THEN @newCommcellId
				ELSE (SELECT new_id FROM CCM_MAP_Commcell
					  WHERE old_id = b.origCCcommCellId)
			 END)
	SELECT @noOfUniqueId = @@ROWCOUNT
	DECLARE	@MediaReused			TABLE (barcode varchar(255))
	DECLARE @MediaOverwritten	TABLE (barcode varchar(255), mediaId int)
	DECLARE @noOfReused				INTEGER
	DECLARE @noOfOverwritten	INTEGER
	INSERT	@MediaReused
	SELECT	DISTINCT a.Barcode
FROM	MMMedia a, MMVolume b, #CCM_MMVolume c
	WHERE	a.MediaId = b.MediaId AND a.MediaTypeId <> 10001
	AND     a.MediaId > 0 -- MMMedia has a dummy record
	AND		(CASE	b.origCCcommCellId WHEN 0 THEN 2 ELSE b.origCCcommCellId END)
			=
			(CASE c.origCCcommCellId WHEN 0 THEN @newCommcellId
				ELSE	(SELECT new_id FROM CCM_MAP_Commcell WHERE old_id = c.origCCcommCellId)
				END)
	AND		(CASE b.origCCVolumeId WHEN 0 THEN b.VolumeId ELSE b.origCCvolumeId END)
			=
			(CASE c.origCCvolumeId WHEN 0 THEN c.VolumeId ELSE c.origCCvolumeId END)
	AND		b.reformattime > c.reformattime
	AND             c.reformattime > 0  -- Reformat time isn't stored in the tape. Hence this validation shouldn't be applied to Tape import use cases.
	SELECT	@noOfReused = @@ROWCOUNT
	INSERT	@MediaOverwritten
	SELECT  DISTINCT a.Barcode, a.MediaId
FROM	MMMedia a, #CCM_MMMedia b
	WHERE	a.MediaTypeId <> 10001 AND a.Barcode = b.Barcode
	AND     a.MediaId > 0 -- MMMedia has a dummy record
	AND	SUBSTRING( a.UniqueId, 1, NULLIF(CHARINDEX('_', a.UniqueId),0) - 1) != '2'
	AND
	((	(CASE a.origCCcommCellId WHEN 0 THEN 2 ELSE a.origCCcommCellId END)
			<>
			(CASE b.origCCcommCellId WHEN 0 THEN @newCommcellId
				ELSE (SELECT new_id FROM CCM_MAP_Commcell
					  WHERE old_id = b.origCCcommCellId)
			 END)
		AND	a.UniqueId = b.UniqueId
	) OR
	(
		(CASE a.origCCcommCellId WHEN 0 THEN 2 ELSE a.origCCcommCellId END)
			=
			(CASE b.origCCcommCellId WHEN 0 THEN @newCommcellId
				ELSE (SELECT new_id FROM CCM_MAP_Commcell
					  WHERE old_id = b.origCCcommCellId)
			 END)
		AND (
			((SUBSTRING( b.UniqueId, 1, CHARINDEX('_', b.UniqueId) - 1) <> '2') AND (a.UniqueId != b.UniqueId))
			OR
			((SUBSTRING( b.UniqueId, 1, CHARINDEX('_', b.UniqueId) - 1) = '2') AND ((SUBSTRING( b.UniqueId, CHARINDEX('_', b.UniqueId) + 1,LEN(b.UniqueId) )) != ((SUBSTRING( a.UniqueId, CHARINDEX('_', a.UniqueId) + 1,LEN(a.UniqueId) )))))
			)
		--AND	a.UniqueId != b.UniqueId
	))
	SELECT	@noOfOverwritten = @@ROWCOUNT
	INSERT	@MediaOverwritten
	SELECT	DISTINCT a.Barcode, a.MediaId
FROM	MMMedia a, MMVolume b, #CCM_MMVolume c
	WHERE	a.MediaId = b.MediaId AND a.MediaTypeId <> 10001
	AND     a.MediaId > 0 -- MMMedia has a dummy record
	AND		(CASE	b.origCCcommCellId WHEN 0 THEN 2 ELSE b.origCCcommCellId END)
			=
			(CASE c.origCCcommCellId WHEN 0 THEN @newCommcellId
				ELSE	(SELECT new_id FROM CCM_MAP_Commcell WHERE old_id = c.origCCcommCellId)
				END)
	AND		(CASE b.origCCVolumeId WHEN 0 THEN b.VolumeId ELSE b.origCCvolumeId END)
			=
			(CASE c.origCCvolumeId WHEN 0 THEN c.VolumeId ELSE c.origCCvolumeId END)
	AND		b.reformattime <> c.reformattime
	AND             c.reformattime > 0         -- Tapes don't have the reformat time stored in them.Ignore this validaion for Tape Imports.
	AND		a.IsInMediaGroup <> 0
	AND		a.Barcode NOT IN (SELECT Barcode FROM @MediaReused)
	SELECT	@noOfOverwritten = @@ROWCOUNT + @noOfOverwritten
	IF @noOfBarcode > 0 OR @noOfUniqueId > 0 OR @noOfReused > 0 OR @noOfOverwritten > 0
	BEGIN
		IF @i_skipConflictingMedia > 0 --Delete all contents related to the media from Merge DB and proceed with merge
		BEGIN
			DECLARE @MediaToSkip TABLE (MediaId integer)
			DECLARE @MediaIdToSkip integer
			INSERT @MediaToSkip
SELECT MediaId FROM #CCM_MMMedia WHERE BarCode IN (SELECT DISTINCT barcode FROM @BarcodeCollision)
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- @MediaToSkip -- INSERT - BarCode Conflict Media'
				GOTO CX_ERROR_EXIT
			END
			INSERT @MediaToSkip
SELECT MediaId FROM #CCM_MMMedia WHERE UniqueId IN (SELECT DISTINCT UniqueId FROM @UniqueIdCollision)
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- @MediaToSkip -- INSERT - UniqueId Conflict Media'
				GOTO CX_ERROR_EXIT
			END
			INSERT @MediaToSkip
SELECT MediaId FROM #CCM_MMMedia WHERE BarCode IN (SELECT DISTINCT barcode FROM @MediaReused)
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- @MediaToSkip -- INSERT - Reused Media'
				GOTO CX_ERROR_EXIT
			END
			INSERT @MediaToSkip
SELECT MediaId FROM #CCM_MMMedia WHERE BarCode IN (SELECT DISTINCT barcode FROM @MediaOverwritten)
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- @MediaToSkip -- INSERT - OverWritten Media'
				GOTO CX_ERROR_EXIT
			END
			DECLARE CONFLICT_MEDIA_CURSOR CURSOR LOCAL FOR
			SELECT DISTINCT MediaId FROM @MediaToSkip
			OPEN CONFLICT_MEDIA_CURSOR
			FETCH NEXT FROM CONFLICT_MEDIA_CURSOR
			INTO @MediaIdToSkip
			WHILE @@FETCH_STATUS = 0
			BEGIN
				EXEC @errorCode = CCM_ArchDeleteBackupByMedia @MediaIdToSkip
				IF @@error <> 0 OR @errorCode <> 0
				BEGIN
					SET @errorString = 'Skip Conflict Media Enabled. Failed To Delete The Contents For The Conflict Media - BarCode: '
SELECT @errorString = @errorString + Barcode + CHAR(13) + CHAR(10) FROM #CCM_MMMedia WHERE MediaId = @MediaIdToSkip
					GOTO CX_ERROR_EXIT
				END
				EXEC @errorCode = CCM_ArchDeleteBackupByMedia @MediaIdToSkip
				IF @@error <> 0 OR @errorCode <> 0
				BEGIN
					SET @errorString = 'Skip Conflict Media Enabled. Failed To Delete The Contents For Conflicting Media - BarCode: '
SELECT @errorString = @errorString + Barcode + CHAR(13) + CHAR(10) FROM #CCM_MMMedia WHERE MediaId = @MediaIdToSkip
					GOTO CX_ERROR_EXIT
				END
				DECLARE @volumeToDelete table(id integer)
				INSERT INTO @volumeToDelete
				SELECT DISTINCT a.volumeId from Commserv_Merge..CCM_MMVolume a
				LEFT OUTER JOIN Commserv_Merge..CCM_archChunk b ON a.VolumeId= b.volumeId
				where a.MediaId = @MediaIdToSkip
				AND b.volumeId IS NULL
				DELETE FROM Commserv_Merge..CCM_archFileSiloVolume WHERE siloVolumeId in (SELECT id from @volumeToDelete)
				DELETE FROM Commserv_Merge..CCM_MMVolume where VolumeId in (SELECT id from @volumeToDelete)
				DELETE FROM Commserv_Merge..CCM_MMMediaSide WHERE MediaId = @MediaIdToSkip
				DELETE FROM Commserv_Merge..CCM_MMMedia WHERE MediaId = @MediaIdToSkip
				DELETE FROM @volumeToDelete
			FETCH NEXT FROM CONFLICT_MEDIA_CURSOR
			INTO @MediaIdToSkip
			END
			CLOSE CONFLICT_MEDIA_CURSOR
			DEALLOCATE CONFLICT_MEDIA_CURSOR
			DELETE FROM @MediaToSkip
		END
		ELSE --skip conflict media disabled. Fail Job
		BEGIN
			SET @errorString = ''
			SET @errorCode = 0
			IF @noOfBarCode > 0
			BEGIN
				SET @errorString = 'ERROR: BarCode Collision on [' + CAST(@noOfBarcode as varchar(10)) +
					'] Media. Please change the following barcode on either Destination or Source CommCell first.' + CHAR(13) + CHAR(10)
				SELECT @errorString = @errorString + Barcode + CHAR(13) + CHAR(10) FROM @BarcodeCollision
				SET @errorCode = -1
			END
			IF @noOfUniqueId > 0
			BEGIN
				SET @errorString = @errorString + 'ERROR: Unique ID Collision on [' + CAST(@noOfUniqueId as varchar(10)) +
					'] Media. Please change the following Unique ID on either Destination or Source CommCell first.' + CHAR(13) + CHAR(10)
				SELECT @errorString = @errorString + UniqueId + CHAR(13) + CHAR(10) FROM @UniqueIdCollision
				SET @errorCode = -1
			END
			IF @noOfReused > 0
			BEGIN
				SET @errorString = @errorString + 'ERROR: Media Reused in Destination Commcell on [' + CAST(@noOfReused as varchar(10)) +
					'] Media. Please delete those media from source Commcell first before capture.' + CHAR(13) + CHAR(10)
				SELECT @errorString = @errorString + Barcode + CHAR(13) + CHAR(10) FROM @MediaReused
				SET @errorCode = -1
			END
			IF @noOfOverwritten > 0
			BEGIN
				-- Clean up media that got reformated at source in case of GRC
				IF ( 1 = (@i_ccmParamFlags & 1))
				BEGIN
					IF @errorCode <> 0
						GOTO CX_ERROR_EXIT
					IF OBJECT_ID('tempdb..#tmpResutSetForMMS2DeleteMediaByMediaId') IS NOT NULL DROP TABLE #tmpResutSetForMMS2DeleteMediaByMediaId
					CREATE TABLE #tmpResutSetForMMS2DeleteMediaByMediaId (retValue int, errString varchar(256))
					DECLARE @reformatedMediaId integer
					DECLARE @reformatedMediaBarCode varchar(255)
					DECLARE GRC_ReformatedMediaCursor Cursor LOCAL For
						SELECT MediaId, BarCode FROM @MediaOverwritten
					OPEN GRC_ReformatedMediaCursor
					FETCH NEXT FROM GRC_ReformatedMediaCursor
					INTO @reformatedMediaId, @reformatedMediaBarCode
					WHILE @@FETCH_STATUS = 0
					BEGIN
						TRUNCATE TABLE #tmpResutSetForMMS2DeleteMediaByMediaId
						EXEC MMS2DeleteMediaByMediaId @reformatedMediaId
						SELECT @errorCode = retValue, @errorString = errString
						FROM #tmpResutSetForMMS2DeleteMediaByMediaId
						IF @@ERROR > 0 OR @errorCode <> 0
						BEGIN
							SET @errorString = 'ERROR: CCM_Merge_Main -- Failed to delete reformated media [' + @reformatedMediaBarCode + ' - ' + CONVERT(varchar, @reformatedMediaId) + ']. ErrorCode:' + CONVERT(varchar, @errorCode) + ' ErrorString:' + @errorString
							CLOSE GRC_ReformatedMediaCursor
							DEALLOCATE GRC_ReformatedMediaCursor
							DROP TABLE #tmpResutSetForMMS2DeleteMediaByMediaId
							GOTO CX_ERROR_EXIT
						END
						FETCH NEXT FROM GRC_ReformatedMediaCursor
						INTO @reformatedMediaId, @reformatedMediaBarCode
					END
					CLOSE GRC_ReformatedMediaCursor
					DEALLOCATE GRC_ReformatedMediaCursor
					DROP TABLE #tmpResutSetForMMS2DeleteMediaByMediaId
				END
				ELSE
				BEGIN
					SET @errorString = @errorString + 'ERROR: Media has different valid data in both Source and Destination Commcells.' +
						' It appears to the media has been reused and overwritten in one of the Commcells. There are [' + CAST(@noOfOverwritten as varchar(10)) +
						'] Media with this problem. Please confirm which Commcell contains valid data and delete them from the other Commcell first.' + CHAR(13) + CHAR(10)
					SELECT @errorString = @errorString + Barcode + CHAR(13) + CHAR(10) FROM @MediaOverwritten
					SET @errorCode = -1
                END
			END
			IF @errorCode <> 0
				GOTO CX_ERROR_EXIT
		END
	END
   END
	-- Merge ArchGroup table
	EXEC @errorCode = CCM_MERGE_ArchGroup_from_XML @isTapeImport, @i_ccmParamFlags, @errStr = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	-- Merge many copy related tables
	EXEC @errorCode = CCM_MERGE_ArchGroupCopy_from_XML @isTapeImport, @i_ccmParamFlags, @errStr = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	--For Robo Import Populate the DAForeignJobsToBeMarkedAged  table with all the jobs(job,copy,datatypes) that got pruned at source
	--DataAging code will process this table at Destination
	--If job is marked for recopy at source then call recopy code at destination for that copy
	IF (@i_ccmParamFlags & 1) = 1
	BEGIN
		--Populate DAForeignJobsToBeMarkedAged
		IF OBJECT_ID('tempdb.dbo.#lt_JobsToBeAged') is not null DROP TABLE #lt_JobsToBeAged
		CREATE TABLE #lt_JobsToBeAged (JobId int, CommCellId int, CopyId smallint, DataType tinyint, StatusChange tinyint)
		CREATE INDEX #lt_JobsToBeAged_JobCCCopyDataTypeStatus_Idx ON #lt_JobsToBeAged(JobId,CommCellId,CopyId,DataType,StatusChange)
		--Populate DAForeignJobsToBeMarkedAged by comparing incoming dump and destination
		INSERT INTO #lt_JobsToBeAged
		SELECT b.JobId, b.commCellId, b.archGrpCopyId, b.dataType,
CASE a.status WHEN 1000 THEN 5 ELSE 4 END
FROM #CCM_JMJobDataStats a, JMJobDataStats b, CCM_MAP_CommCell c, ArchGroupCopy d
		WHERE a.jobId = b.jobId AND a.commCellId = c.old_Id AND b.commCellId = c.new_Id
			AND a.archGrpCopyId = d.origCCarchCopyId AND b.archGrpCopyId = d.id AND a.dataType = b.dataType AND c.new_id = d.origCCCommCellId
			AND	((a.status = 1000 AND b.status <> 1000) OR ((a.disabled & 256) = 256 AND (b.disabled & 256) <> 256) )
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- #lt_JobsToBeAged -- INSERT 1'
			GOTO CX_ERROR_EXIT
		END
		--Populate the DAForeignJobsToBeMarkedAged using tracking table
IF EXISTS(SELECT * FROM #CCM_GRCJMJobDataStatsTracking)
		BEGIN
			INSERT	INTO CCM_MAP_GRCJMJobDataStatsTracking
			SELECT	commCellId, 0, copyId, 0, jobId, dataType
FROM	#CCM_GRCJMJobDataStatsTracking
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_MAP_GRCJMJobDataStatsTracking -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CCM_MAP_GRCJMJobDataStatsTracking SET new_commCellId = b.new_id
			FROM CCM_MAP_GRCJMJobDataStatsTracking a, CCM_MAP_CommCell b
			WHERE a.old_commCellId = b.old_id
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_MAP_GRCJMJobDataStatsTracking -- UPDATE new_commCellId'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CCM_MAP_GRCJMJobDataStatsTracking SET new_copyId = b.id
			FROM CCM_MAP_GRCJMJobDataStatsTracking a, ArchGroupCopy b
			WHERE a.old_copyId = b.origCCarchCopyId AND a.new_commCellId = b.origCCcommCellId
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- CCM_MAP_GRCJMJobDataStatsTracking -- UPDATE new_copyId'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO #lt_JobsToBeAged
			SELECT B.JobId, A.new_CommCellId, A.new_CopyId, B.DataType, B.StatusChange
FROM CCM_MAP_GRCJMJobDataStatsTracking A INNER JOIN #CCM_GRCJMJobDataStatsTracking B
				ON A.JobId = B.JobId AND A.old_commcellId = B.CommCellId AND A.old_CopyId = B.CopyId AND A.DataType = B.DataType
WHERE B.StatusChange IN (4, 5)
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- #lt_JobsToBeAged -- INSERT 2'
				GOTO CX_ERROR_EXIT
			END
		END
		--Update the status when status is mediaDeleted in tracking table and DAForeignJobsToBeMarkedAged table contains
		--job with status markedAged and is not processed yet
		UPDATE DAForeignJobsToBeMarkedAged
		SET StatusChange = B.StatusChange, ModifiedTime = dbo.GetUnixTime(GETUTCDate())
		FROM DAForeignJobsToBeMarkedAged A INNER JOIN #lt_JobsToBeAged B
			ON A.JobId = B.JobId AND A.CommcellId = B.CommcellId AND A.CopyId = B.CopyId AND A.DataType = B.DataType
WHERE A.StatusChange = 4 AND A.Processed = 0
AND B.StatusChange = 5
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- DAForeignJobsToBeMarkedAged -- UPDATE StatusChange'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO DAForeignJobsToBeMarkedAged(JobId, CommCellId, CopyId, DataType, StatusChange, ModifiedTime)
		SELECT distinct A.JobId, A.CommCellId, A.CopyId, A.DataType, A.StatusChange, dbo.GetUnixTime(GETUTCDate())
		FROM #lt_JobsToBeAged A LEFT OUTER JOIN DAForeignJobsToBeMarkedAged B
			ON A.JobId = B.JobId AND A.CommcellId = B.CommcellId AND A.CopyId = B.CopyId
			AND A.DataType = B.DataType AND A.StatusChange = B.StatusChange
		WHERE B.JobId IS NULL AND A.CopyId > 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- DAForeignJobsToBeMarkedAged -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		DROP TABLE #lt_JobsToBeAged
		--Process jobs which are maked for recopy at source
		IF OBJECT_ID('tempdb.dbo.#lt_JobsToRecopy') is not null DROP TABLE #lt_JobsToRecopy
		CREATE TABLE #lt_JobsToRecopy (jobId int, commcellId int, copyId int)
		DECLARE @l_jobId 		int
		DECLARE @l_commcellId 	int
		DECLARE @l_copyId 		int
		--Get the jobs to recopy by comparing incoming dump and destination
		INSERT INTO #lt_JobsToRecopy
		SELECT b.JobId, b.commCellId, b.archGrpCopyId
FROM #CCM_JMJobDataStats a, JMJobDataStats b, CCM_MAP_CommCell c, ArchGroupCopy d
		WHERE a.jobId = b.jobId AND a.commCellId = c.old_Id AND b.commCellId = c.new_Id
			AND a.archGrpCopyId = d.origCCarchCopyId AND b.archGrpCopyId = d.id AND a.dataType = b.dataType AND c.new_id = d.origCCCommcellId
			AND	(a.status = 101 AND b.status = 100)
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Main -- #lt_JobsToRecopy -- INSERT 1'
			GOTO CX_ERROR_EXIT
		END
		--Get the jobs to recopy using tracking table
IF EXISTS(SELECT * FROM #CCM_GRCJMJobDataStatsTracking)
		BEGIN
			INSERT INTO #lt_JobsToRecopy
			SELECT B.JobId, A.new_CommCellId, A.new_CopyId
FROM CCM_MAP_GRCJMJobDataStatsTracking A INNER JOIN #CCM_GRCJMJobDataStatsTracking B
				ON A.JobId = B.JobId AND A.old_commcellId = B.CommCellId AND A.old_CopyId = B.CopyId AND A.DataType = B.DataType
WHERE B.StatusChange = 2
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- #lt_JobsToRecopy -- INSERT 2'
				GOTO CX_ERROR_EXIT
			END
		END
		IF OBJECT_ID('tempdb..#tmpResutSetForArchAllowJobForCopy') IS NOT NULL DROP TABLE #tmpResutSetForArchAllowJobForCopy
			CREATE TABLE #tmpResutSetForArchAllowJobForCopy (retValue int)
		DECLARE GRC_RecopyJobCursor Cursor LOCAL For
			SELECT distinct JobId, CommCellId, CopyId
			FROM #lt_JobsToRecopy
			WHERE CopyId > 0
		OPEN GRC_RecopyJobCursor
		FETCH NEXT FROM GRC_RecopyJobCursor
		INTO @l_jobId, @l_commcellId, @l_copyId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			EXEC ArchAllowJobForCopy @l_jobId, @l_commcellId, @l_copyId, 1
			SELECT @errorCode = retValue
			FROM #tmpResutSetForArchAllowJobForCopy
			IF @@ERROR > 0 OR @errorCode > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- Failed to mark recopy for JobId [' + CONVERT(varchar, @l_jobId) + '] CommCellId [' + CONVERT(varchar, @l_commcellId) + '] CopyId [' + CONVERT(varchar, @l_copyId) + ']. ErrorCode:' + CONVERT(varchar, @errorCode)
				CLOSE GRC_RecopyJobCursor
				DEALLOCATE GRC_RecopyJobCursor
				DROP TABLE #tmpResutSetForArchAllowJobForCopy
				GOTO CX_ERROR_EXIT
			END
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Main -- Failed to mark jobs for recopy'
				GOTO CX_ERROR_EXIT
			END
			FETCH NEXT FROM GRC_RecopyJobCursor
			INTO @l_jobId, @l_commcellId, @l_copyId
		END
		CLOSE GRC_RecopyJobCursor
		DEALLOCATE GRC_RecopyJobCursor
		DROP TABLE #lt_JobsToRecopy
		DROP TABLE #tmpResutSetForArchAllowJobForCopy
		--Create temp table in case of capture only local data, we will check existense of this table in jobs traking
		--trigger if it exist then donot track jobs(Don't track jobs which are inserted in import)
		IF ( 1 = ISNULL((SELECT value from MMConfigs where name = 'CCM_CONFIG_CAPTURE_ONLY_LOCAL_DATA_FOR_GRC'),1))
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#GRCDoNotTrackJMJobDataStats') IS NULL
				CREATE TABLE #GRCDoNotTrackJMJobDataStats (DummyColumn Int)
		END
		ELSE
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#GRCDoNotTrackJMJobDataStats') IS NOT NULL
				DROP TABLE #GRCDoNotTrackJMJobDataStats
		END
	END
	-- Merge ArchStream and MMS2MediaGroup
	EXEC @errorCode = CCM_MERGE_ArchStream_from_XML @errStr = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	--
	--PrasadNara: Skip merging client and application for tape import
	--
	IF @isTapeImport <> 1
	BEGIN
		-- Merge Client to BackupSet related tables
		EXEC @errorCode = CCM_MERGE_Client_from_XML @errorString = @errorString OUTPUT, @isEDCMerge = @isTapeImport, @ccmParamFlags = @i_ccmParamFlags
		IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
		-- Merge Application related tables
		EXEC @errorCode = CCM_MERGE_Application_from_XML @errStr = @errorString OUTPUT, @isEDCMerge = @isTapeImport, @ccmParamFlags = @i_ccmParamFlags, @i_indexMAId = @l_indexMAId, @jobId = @i_jobId
		IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	END
	-- Merge Media Manager tables
	EXEC @errorCode = CCM_MERGE_MM_from_XML @tapeReusable, @isTapeImport, @i_ccmParamFlags, @l_indexMAId, @errStr = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	-- Merge ArchFile to ArchChunk related tables
	EXEC @errorCode = CCM_MERGE_ArchFile_from_XML @isTapeImport, @i_ccmParamFlags , @i_jobId, @errStr = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	-- Merge Job Manager tables
	EXEC @errorCode = CCM_MERGE_JOB_from_XML @isTapeImport, @i_mergeActivityControl, @i_ccmParamFlags, @i_jobId, @errStr = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	-- Merge Oracle IDA tables
	EXEC @errorCode = CCM_MERGE_Oracle_from_XML @errStr = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	-- Merge Sybase IDA tables
	EXEC @errorCode = CCM_MERGE_Sybase_from_XML @errStr = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	-- Merge SQL IDA tables
	EXEC @errorCode = CCM_MERGE_SQL_from_XML @errStr = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	--For holidays and operationWindow Bit 1 is for merge, Bit 2 is for force overwrite
	IF (1 & @i_mergeHolidays) > 0
	BEGIN
		SET @l_forceOverWrite = CASE WHEN (2 & @i_mergeHolidays) > 0 THEN 1 ELSE 0 END
		EXEC @errorCode = CCM_Merge_Holiday_from_XML @l_forceOverWrite, @errStr = @errorString OUTPUT
		IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	END
	IF (1 & @i_mergeOperationWindow) > 0
	BEGIN
		SET @l_forceOverWrite = CASE WHEN (2 & @i_mergeOperationWindow) > 0 THEN 1 ELSE 0 END
		EXEC @errorCode = CCM_Merge_OperationWindow_from_XML @l_forceOverWrite, @errStr = @errorString OUTPUT
		IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	END
	/* -- Gokul made changes to move this to CPP Layer
	IF @i_ccmParamFlags > 0
	BEGIN
		EXEC @errorCode = CCM_Merge_Schedule @errStr = @errorString OUTPUT
		IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	END
	*/
	-- Merge Snap Tables associated with the captured dump set data
	/*EXEC @errorCode = CCM_Merge_Snap_from_XML @errStr = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT*/
	--Merge SRM agents only if SRM_Merge database exist.
	--IF EXISTS (SELECT * FROM MASTER..SYSDATABASES WHERE NAME = 'SRM_Merge')
	--BEGIN
		--Call SRM table merge entry sp if SRM tables also needs to be merged.
	--	IF EXISTS (SELECT * FROM SRM_Merge..CCM_CSStubClients)
	--	BEGIN
	--		EXEC @errorCode = SRM..CCM_Merge_SRM_Main @errorString = @errorString OUTPUT
	--		IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	--	END
	--END
	---------------------------------------------------------
	-- Deconfigure migrated clients.
	DECLARE @lt_ClientAppList TABLE (clientId int, appTypeId int)
	DECLARE @clientId int = 0
	DECLARE @appTypeId int = 0
	-- if client is missing or same client exists with migrated flag, then we can call client level deconfigure.
	INSERT INTO @lt_ClientAppList
	SELECT DISTINCT new_Id, 0
	FROM CCM_MAP_CLIENT a INNER JOIN APP_Client b ON a.new_id = b.id
WHERE a.new_id > 0 AND (b.specialClientFlags & 0x20) > 0
	-- if client is present, but agent is missing then we should call agent level deconfigure.
	INSERT 	INTO @lt_ClientAppList
	SELECT  DISTINCT a.new_Id, b.appTypeId
	FROM   	CCM_MAP_CLIENT a INNER JOIN CCM_MAP_IdaName b ON a.old_Id = b.old_clientId
			LEFT OUTER JOIN @lt_ClientAppList c ON c.clientId = a.new_Id
	WHERE 	b.exist = 0 AND c.clientId IS NULL
	-- if client and agent both are present but agent is in deconfigured state, but DR backup has agent in configured state(some backupsets are created), if we merge from DR then we should deconfigure the agent otherwise missing backupsets will be in configured state, so we should deconfigure the agent again.
	INSERT 	INTO @lt_ClientAppList
	SELECT  DISTINCT a.new_Id, b.appTypeId
	FROM   	CCM_MAP_CLIENT a INNER JOIN CCM_MAP_IdaName b ON a.old_Id = b.old_clientId
			LEFT OUTER JOIN @lt_ClientAppList c ON c.clientId = a.new_Id AND (c.appTypeId = b.appTypeId OR c.appTypeId = 0)
	WHERE 	b.exist = 1 AND c.clientId IS NULL
			AND EXISTS (SELECT 1 FROM licUsage WHERE CId = a.new_id AND AppType = b.appTypeId AND OpType = 'UnInstall')
	-- Skip the clients from de-configure if no license exists, because we have no way to configure them in name change.
	-- In other words, we don't need to de-configure again if already de-configured.
	DELETE @lt_ClientAppList
	FROM @lt_ClientAppList A INNER JOIN APP_ClientProp B ON A.clientId = B.componentNameId
	WHERE NOT EXISTS (
				SELECT 1
FROM #CCM_LicUsage LIC INNER JOIN CCM_MAP_Client CL ON LIC.CId = CL.old_Id
				WHERE CL.new_id = A.clientId AND (LIC.OpType = 'Install' OR LIC.OpType = 'ReInstall' OR LIC.OpType = 'Re-Install')
				)
	-- If the client is CS client or VM captured to show in the VSA job details, then we should de-configure them.
    -- These clients will have just client info, no other info will be captured, so add agent check.
    -- If atleast one agent exists and no license consumed on source then we don't need to de-configure them.
AND EXISTS (SELECT 1 FROM #CCM_App_IDAName IDA WHERE IDA.clientId = A.clientId)
	-- If clients have some agents with no licenses, then de-configure the agents which have licenses consumed.
	-- So insert the licensed agents for those clients and delete the client entries to avoid client level de-configure.
	-- (We should try to de-configure at client level always, if not possible then go by agent based de-configure.)
	DECLARE @appTypeCountIDATbl TABLE (clientId INT, totAgents INT)
	INSERT 	INTO @appTypeCountIDATbl
	SELECT  a.new_Id, COUNT(b.appTypeId)
FROM CCM_MAP_CLIENT a INNER JOIN #CCM_App_IDAName b ON a.old_Id = b.clientId
		-- Don't consider already de-configured agents.
		-- Otherwise we end up performing agent level de-configure rather than client level even though all other agents already in de-configure state.
		-- (This is required because VSA V2 client has VSA agent configured but no license consumed).
AND b.status & 0x00002 = 0
	GROUP BY a.new_Id
	DECLARE @appTypeCountLicTbl TABLE (clientId INT, totAgents INT)
	INSERT 	INTO @appTypeCountLicTbl
	SELECT  a.new_Id, COUNT(b.appTypeId)
	FROM CCM_MAP_CLIENT a INNER JOIN CCM_MAP_IdaName b ON a.old_Id = b.old_clientId
INNER JOIN #CCM_LicUsage c ON c.CId = a.old_Id AND c.AppType = b.appTypeId
		AND (c.OpType = 'Install' OR c.OpType = 'ReInstall' OR c.OpType = 'Re-Install')
	GROUP BY a.new_Id
	-- Remove the clients which have licenses on all agents.
	DELETE @appTypeCountLicTbl
	FROM @appTypeCountLicTbl A INNER JOIN @appTypeCountIDATbl B ON A.clientId = B.clientId
	WHERE A.totAgents = B.totAgents
	-- Remove the clients from main client list which have licenses only on some of the agents.
	-- These are the clients which require agent based configure.
	DELETE @lt_ClientAppList
	FROM @lt_ClientAppList A INNER JOIN @appTypeCountLicTbl B ON A.clientId = B.clientId
	-- No appType based configure request found (only when client level configure opted).
	WHERE NOT EXISTS (SELECT 1 FROM @lt_ClientAppList C WHERE C.clientId = B.clientId AND C.appTypeId > 0)
	INSERT 	INTO @lt_ClientAppList
	SELECT  A.clientId, D.appTypeId
	FROM @appTypeCountLicTbl A INNER JOIN CCM_MAP_CLIENT B ON A.clientId = B.new_Id
INNER JOIN #CCM_LicUsage C ON C.CId = B.old_Id
		INNER JOIN CCM_MAP_IdaName D ON D.old_clientId = C.CId AND C.AppType = D.appTypeId
		LEFT OUTER JOIN @lt_ClientAppList E ON E.clientId = A.clientId AND E.appTypeId = D.appTypeId
	WHERE (C.OpType = 'Install' OR C.OpType = 'ReInstall' OR C.OpType = 'Re-Install')
		AND E.clientId IS NULL
	DECLARE DeconfigureClientCur CURSOR LOCAL FORWARD_ONLY
	FOR	SELECT clientId, appTypeId FROM @lt_ClientAppList
	OPEN DeconfigureClientCur
	FETCH DeconfigureClientCur INTO @clientId, @appTypeId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		EXEC AppConfDeconf @clientId, @appTypeId, 0, 2, @errorCode OUTPUT, @errorString OUTPUT
		IF @@ERROR <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
		FETCH NEXT FROM DeconfigureClientCur INTO @clientId, @appTypeId
	END
	CLOSE DeconfigureClientCur
	DEALLOCATE DeconfigureClientCur
	/*
		Don't set migrated flag for discovered VMs.
		This is causing issue in SLA report when the same VM is discovered on dest CS and ran new backups(TR 190507-413).
		If a VM is migrated to a destination CS and after that if it is again backed up by the destination CS as well, then the destiantion's SLA report will not contain this migrated VM.
		Ideally, since it is also backed up by the destination CS, we need to show it in the SLA report of the destination commcell.
	*/
	UPDATE APP_Client
SET specialClientFlags = (specialClientFlags  & (~CAST(0x20 AS INT)))
	FROM APP_Client A INNER JOIN CCM_MAP_Client B ON A.id = B.new_id
		INNER JOIN APP_ClientProp C ON C.componentNameId = A.id AND C.attrName = 'Virtual Server Discovered Clients' AND C.attrVal = '1' AND C.modified = 0
		LEFT JOIN LicUsage Lic ON C.componentNameId = Lic.CId
	WHERE B.exist = 0
		AND Lic.id IS NULL
	IF @@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE specialClientFlags for discovered VMs.'
		GOTO CX_ERROR_EXIT
	END
	/*
	If VM is imported for the purpose of showing this VM info in job details, then we un set the CCM flag in the above update.
	But if the same client is coming as a regular client in the next dump, then we should set the CCM flag because we need to show the client in name change.
	*/
	UPDATE APP_Client
SET specialClientFlags = (specialClientFlags  | 0x20)
	FROM APP_Client A INNER JOIN CCM_MAP_Client B ON A.id = B.new_id
		INNER JOIN APP_ClientProp C ON C.componentNameId = A.id AND C.attrName = 'Virtual Server Discovered Clients' AND C.attrVal = '1' AND C.modified = 0
		LEFT JOIN LicUsage Lic ON C.componentNameId = Lic.CId
	WHERE
		-- License exists in un-install mode.
		Lic.id IS NOT NULL
		-- But no license should be in install mode, in case if client is already name changed before, we can't set the CCM flag for such clients.
		AND NOT EXISTS (SELECT 1 FROM LicUsage L WHERE L.CId = A.id AND (L.OpType = 'Install' OR L.OpType = 'ReInstall' OR L.OpType = 'Re-Install'))
AND (specialClientFlags  & 0x20) = 0
	IF @@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE un set specialClientFlags for discovered VMs.'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- no need to do the below if there is no jobid, we shouldn't fail either as
	-- ccm is actually completed here.
	IF (@isTapeImport = 0 AND @l_curImportJobId  > 0) --Not needed for EDC
	BEGIN
		--Insert the oldId newId mappings so that they can be used in the cpp layer even after the CCM_Merge_Main completes
		--Client Id Map - Entity Type - 3
		INSERT INTO CCMMergeEntityMap
SELECT DISTINCT @l_curImportJobId, 2, A.old_id, A.new_id, 3, B.GUID
		FROM CCM_Map_Client A, App_Client B
		WHERE A.new_id = B.id
		AND A.new_id <> 0
		AND NOT EXISTS (SELECT * FROM CCMMergeEntityMap WHERE importJobId = @l_curImportJobId
						AND oldEntityId = A.old_id
AND entityType = 3)
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'CCM_Merge_Main -- CCMMergeEntityMap -- INSERT -- Client Map'
			GOTO CX_ERROR_EXIT
		END
		--Instance Map - Entity Type - 5
		INSERT INTO CCMMergeEntityMap
SELECT DISTINCT @l_curImportJobId, 2, A.old_id, A.new_id, 5, B.GUID
		FROM CCM_Map_InstanceName A, APP_InstanceName B
		WHERE A.new_id = B.id
		AND A.new_id <> 0
		AND NOT EXISTS (SELECT * FROM CCMMergeEntityMap WHERE importJobId = @l_curImportJobId
						AND oldEntityId = A.old_id
AND entityType = 5)
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'CCM_Merge_Main -- CCMMergeEntityMap -- INSERT -- App_InstanceName Map'
			GOTO CX_ERROR_EXIT
		END
		--BackupSet map - Entity Type - 6
		INSERT INTO CCMMergeEntityMap
SELECT DISTINCT @l_curImportJobId, 2, A.old_id, A.new_id, 6, B.GUID
		FROM CCM_MAP_BackupSetName A, APP_BackupSetName B
		WHERE A.new_id = B.id
		AND A.new_id <> 0
		AND NOT EXISTS (SELECT * FROM CCMMergeEntityMap WHERE importJobId = @l_curImportJobId
						AND oldEntityId = A.old_id
AND entityType = 6)
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'CCM_Merge_Main -- CCMMergeEntityMap -- INSERT -- App_BackupSetName Map'
			GOTO CX_ERROR_EXIT
		END
		--SubClientId Map - Entity Type - 7
		INSERT INTO CCMMergeEntityMap
SELECT DISTINCT @l_curImportJobId, 2, A.old_id, A.new_id, 7, B.GUID
		FROM CCM_Map_Application A, APP_Application B
		WHERE A.new_id = B.id
		AND A.new_id <> 0
		AND NOT EXISTS (SELECT * FROM CCMMergeEntityMap WHERE importJobId = @l_curImportJobId
						AND oldEntityId = A.old_id
AND entityType = 7)
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'CCM_Merge_Main -- CCMMergeEntityMap -- INSERT -- App_Application Map'
			GOTO CX_ERROR_EXIT
		END
		--ArchGroupCopy Map - Entity Type - ENTITY_TYPE_STORAGE_POLICY_COPY_ENTITY
		INSERT INTO CCMMergeEntityMap
SELECT DISTINCT @l_curImportJobId, 2, A.old_id, A.new_id, 18, null
		FROM CCM_Map_ArchGroupCopy A inner join ArchGroupCopy B
		ON A.new_id = B.id AND A.new_id <> 0
		left outer join CCMMergeEntityMap C
ON C.importJobId = @l_curImportJobId AND C.oldEntityId = A.old_id AND C.entityType = 18
		WHERE C.oldEntityId is null
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'CCM_Merge_Main -- CCMMergeEntityMap -- INSERT -- ArchGroupCopy Map'
			GOTO CX_ERROR_EXIT
		END
		--IdxSIDBStore Map - Entity Type - ENTITY_TYPE_MEDIA_LOCATIONS  --TODO create a new ENTITY TYPE for store
		INSERT INTO CCMMergeEntityMap
SELECT DISTINCT @l_curImportJobId, 2, A.old_SIDBStoreId, A.new_SIDBStoreId, 41, null
		FROM CCM_Map_IdxSIDBStore A inner join IdxSIDBStore B
		ON A.new_SIDBStoreId = B.SIDBStoreId AND A.new_SIDBStoreId <> 0
		left outer join CCMMergeEntityMap C
ON C.importJobId = @l_curImportJobId AND C.oldEntityId = A.old_SIDBStoreId AND C.entityType = 41
		WHERE C.oldEntityId is null
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'CCM_Merge_Main -- CCMMergeEntityMap -- INSERT -- ArchGroupCopy Map'
			GOTO CX_ERROR_EXIT
		END
		UPDATE  APP_ClientProp
	    SET attrVal = CONVERT(VARCHAR(64), APP.newEntityId),
            attrName = SUBSTRING(attrName, 0, LEN(attrName) - 23)
		FROM CCMMergeEntityMap CL
INNER JOIN APP_ClientProp PROP ON CL.newEntityId = PROP.componentNameId AND CL.entityType = 3 AND PROP.attrName LIKE '% CCM Need to map appId'
				AND CL.importJobId = @l_curImportJobId AND CL.commCellId = 2
INNER JOIN CCMMergeEntityMap APP ON CONVERT(INT, PROP.attrVal) = APP.oldEntityId AND APP.entityType = 7
				AND APP.importJobId = CL.importJobId AND APP.commCellId = CL.commCellId
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'CCM_Merge_Main -- CCMMergeEntityMap -- Update APP_ClientProp -- New property value update failed.'
			GOTO CX_ERROR_EXIT
		END
	END
	-- If jobId is 0 and merge from xml then store the mapping in new table
	IF (@l_curImportJobId = 0 AND @i_mergeTimeStamp > 0)
	BEGIN
		--Client Id Map - Entity Type - 3
		--Setting entityType to 0 when client is already exists. We use this to not delete client when apply cert fails while adding remote client.
		--TODO in next release add a new column for exist.
		INSERT INTO CCMMergeEntityMapXML
SELECT DISTINCT @i_mergeTimeStamp, 2, A.old_id, A.new_id, (case when A.exist = 1 then 0 else 3 end), B.GUID
		FROM CCM_Map_Client A, App_Client B
		WHERE A.new_id = B.id
		AND A.new_id <> 0
		AND NOT EXISTS (SELECT 1 FROM CCMMergeEntityMapXML WHERE importTimeStamp = @i_mergeTimeStamp
						AND oldEntityId = A.old_id
AND entityType = 3)
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'CCM_Merge_Main -- CCMMergeEntityMapXML -- INSERT -- Client Map'
			GOTO CX_ERROR_EXIT
		END
	END
	/* kbora: Set subclient properties for tape import created exchange database subclients. */
	IF @isTapeImport = 1
	BEGIN
		/* Set simOsId for NAS clients */
		UPDATE App_Client
		SET simOperatingSystemId = C.simOperatingSystemId
		FROM App_Client A INNER JOIN CCM_TI_MAP_Client B ON A.id = B.new_clientId
INNER JOIN #CCM_App_Client C ON C.id = B.old_clientId
		WHERE C.simOperatingSystemId > 0 -- only for NAS this simOperatingSystemId > 0
		AND NOT EXISTS (SELECT 1 FROM simOperatingSystem D WHERE D.SubType = 'NAS' AND D.id = A.simOperatingSystemId)
		/* If tape import client */
		AND EXISTS( SELECT 1 FROM APP_ClientProp
						WHERE componentNameId = A.id
						AND attrName = 'TapeImportClientProp' AND modified = 0
					   )
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'CCM_Merge_Main -- App_Client -- UPDATE simOperatingSystemId for tapeimport client failed.'
			GOTO CX_ERROR_EXIT
		END
		UPDATE APP_ClientProp
		SET attrVal = simOS.Name
		FROM APP_Client AC
			INNER JOIN APP_ClientProp ACP ON AC.id = ACP.componentNameId
			INNER JOIN CCM_TI_MAP_Client TC ON AC.id = TC.new_clientId
			INNER JOIN simOperatingSystem simOS ON simOS.id = AC.simOperatingSystemId
		WHERE ACP.attrName = 'Operating System Name'
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'CCM_Merge_Main -- APP_ClientProp -- UPDATE Operating System Name for tapeimport client failed.'
			GOTO CX_ERROR_EXIT
		END
		/* 	For exchange database agent, database names are part of archive file name.
			In browse we show these databases backuped by a particular subclient, if subclient is created by tape import or
			if some databases are missing for existing subclient then we need to repopulate these database names so that browse can show them */
		IF OBJECT_ID('tempdb..#tempSubClientProp') IS NOT NULL
			DROP TABLE #tempSubClientProp
		CREATE TABLE #tempSubClientProp ( appId INT, propName nvarchar(MAX))
		IF OBJECT_ID('tempdb..#subClientsMinAFCTime') IS NOT NULL
			DROP TABLE #subClientsMinAFCTime
		CREATE TABLE #subClientsMinAFCTime ( appId INT, minAfileCTime integer)
		INSERT INTO #tempSubClientProp
		SELECT DISTINCT A.new_appId, SUBSTRING(B.name,CHARINDEX('\',B.name) + 1,  CHARINDEX ('\', SUBSTRING(B.name,CHARINDEX('\',B.name) + 1, LEN(B.name))) - 1 )
		FROM CCM_TI_MAP_Application A INNER JOIN archFile B WITH (NOLOCK) ON A.new_appId = B.appId
AND B.name like 'Microsoft Information Store%' AND A.appTypeId = 53
		INSERT INTO #subClientsMinAFCTime
		SELECT AF.appId, MIN(AF.cTime)
		FROM ArchFile AF WITH (NOLOCK) INNER JOIN CCM_TI_MAP_Application APP ON AF.appId = APP.new_appId
WHERE APP.appTypeId = 53 GROUP BY AF.appId
		INSERT INTO APP_SubClientProp
		SELECT DISTINCT A.new_appId, B.propName, 112, 'Microsoft+1Information+1Store 1 nothing nothing 0',
						D.minAfileCTime , 0, 0
		FROM CCM_TI_MAP_Application A INNER JOIN #tempSubClientProp B ON A.new_appId = B.appId
			INNER JOIN #subClientsMinAFCTime D ON D.appId = A.new_appId
			LEFT OUTER JOIN APP_SubClientProp C ON C.componentNameId = A.new_appId AND C.attrName = B.propName
WHERE A.appTypeId = 53
			AND C.componentNameId IS NULL
		INSERT INTO APP_SubClientProp
		SELECT DISTINCT A.new_appId, 'Microsoft Information Store\SG\' + B.propName, 10, dbo.GetUnixTime(GETUTCDATE()),
					D.minAfileCTime , 0, 0
		FROM CCM_TI_MAP_Application A INNER JOIN #tempSubClientProp B ON A.new_appId = B.appId
			INNER JOIN #subClientsMinAFCTime D ON D.appId = A.new_appId
			LEFT OUTER JOIN APP_SubClientProp C ON C.componentNameId = A.new_appId AND
			C.attrName = 'Microsoft Information Store\SG\' + B.propName
WHERE A.appTypeId = 53
			AND C.componentNameId IS NULL
		/* 	If tape import creates exchange database agent then we don't have the version of the exchange server on the tape to pick the destination exchange server to do out of place restore,
			so populating one of the existing exchange server version */
		INSERT INTO APP_IDAProp
     	SELECT DISTINCT B.id, X.attrName, X.attrType, X.attrVal, dbo.GetUnixTime(GETUTCDATE()), 0, 0
		FROM CCM_TI_MAP_Application A, APP_IDAName B,
					(	SELECT TOP 1 D.* FROM APP_IDAName C
						INNER JOIN APP_IDAProp D ON D.componentNameId = C.id AND D.attrName = 'IDA Version'
WHERE C.appTypeId = 53
					 )  AS X
		WHERE	A.appTypeId = B.appTypeId
				AND A.new_clientId = B.clientId
AND A.appTypeId = 53
				AND NOT EXISTS (SELECT 1 FROM APP_IDAProp E WHERE E.componentNameId = B.id AND E.attrName = 'IDA Version')
		DROP TABLE #tempSubClientProp
	END
	-------------------------Merge Security--------------------
	-- Drop Temp Table used by merge operation
	EXEC CCM_MERGE_MAP 0
	COMMIT	TRANSACTION TRAN_Merge_Main
	SET @errorString = 'NO_ERROR'
	IF OBJECT_ID('tempdb.dbo.#TempMergeMainResultSet') IS NOT NULL
	BEGIN
		INSERT INTO #TempMergeMainResultSet
		SELECT	0, @errorString
	END
	ELSE
		SELECT	0, @errorString
	RETURN
CX_ERROR_EXIT:
	IF (Cursor_Status('LOCAL', 'CONFLICT_MEDIA_CURSOR') >= -1)
    BEGIN
    	CLOSE CONFLICT_MEDIA_CURSOR
		DEALLOCATE CONFLICT_MEDIA_CURSOR
    END
	IF (Cursor_Status('LOCAL', 'GRC_ReformatedMediaCursor') >= -1)
    BEGIN
    	CLOSE GRC_ReformatedMediaCursor
		DEALLOCATE GRC_ReformatedMediaCursor
    END
	IF (Cursor_Status('LOCAL', 'GRC_RecopyJobCursor') >= -1)
    BEGIN
    	CLOSE GRC_RecopyJobCursor
		DEALLOCATE GRC_RecopyJobCursor
    END
	IF (Cursor_Status('LOCAL', 'Cur_ClientList') >= -1)
    BEGIN
		CLOSE Cur_ClientList
		DEALLOCATE Cur_ClientList
    END
	-- Drop Temp Table used by merge operation
	EXEC CCM_MERGE_MAP 0
	ROLLBACK TRANSACTION TRAN_Merge_Main
	IF OBJECT_ID('tempdb.dbo.#TempMergeMainResultSet') IS NOT NULL
	BEGIN
		INSERT INTO #TempMergeMainResultSet
		SELECT	0, @errorString
	END
	ELSE
		SELECT	-1, @errorString
	RETURN (-1)
---------------------------------------------------------------------
GO


IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_Main_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Main_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Main_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Main_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_Main_from_XML',  'v1.7.66.4.8.1', 'CCM_Merge_Main_from_XML', 'v1.7.66.4.8.1')
GO

