

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_MM.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge Media Manager Tables
--  +========================================================================+
-- $Id: CCM_Merge_MM.sp,v 1.143.78.3 2018/12/27 16:43:42 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Merge_MM')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Merge_MM <<<'
	drop procedure CCM_Merge_MM
END
IF EXISTS (select * from GxQscripts where name='CCM_Merge_MM')
	delete from GxQscripts where name = 'CCM_Merge_MM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_MM')
	delete from GXDBVersions where aliasname = 'CCM_Merge_MM'
GO
print '... Creating Procedure: CCM_Merge_MM'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Merge_MM
  @tapeReusable integer,
  @isTapeImport integer,
  @ccmParamFlags integer = 0,
  @i_indexMAId integer = 0,
  @errStr varchar(2048) OUTPUT
AS
	---------------------------------------------------------
--Code below here is from CCM_Merge_MM.spb--
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	declare @new_commcellid integer
	declare @old_commcellid integer
	DECLARE	@index  		INT
	-----------------------------------------------------------------
	declare @isRoboImport integer
	SET @isRoboImport = CASE WHEN (@ccmParamFlags & 1) > 0 THEN 1 ELSE 0 END
	DECLARE @commcellGUID	nvarchar(max)
SET @commcellGUID = (SELECT csGUID FROM CommServ_Merge..CCM_App_Commcell WHERE id = 2 and type = 1)
	DECLARE @commcellId int
	SET @commcellId = (SELECT new_id FROM CCM_MAP_CommCell WHERE old_id = 2)
	DECLARE 	@usePrefix		INT
	DECLARE		@podCellName		VARCHAR(1024)
	DECLARE 	@name			VARCHAR(1024)
	DECLARE 	@tempName		VARCHAR(1024)
	DECLARE 	@SizeOfnameCol 	integer
	SELECT 	@usePrefix = (CASE WHEN ISNULL(longVal, 0) > 0 THEN 0 ELSE 1 END)
	FROM 	GRC_CommCellProp
	WHERE 	commcellId = @commcellId
AND propId = 1
	IF @usePrefix > 0
	BEGIN
		SET @podCellName = ISNULL(
						(
							SELECT stringVal FROM GRC_CommCellProp
							WHERE commcellId = @commcellId
AND propId = 3
						),
						(SELECT aliasName FROM CCM_MAP_CommCell WHERE old_id = 2)
					)
	END
	ELSE
	BEGIN
		SET @podCellName = ISNULL(
						(
							SELECT stringVal FROM GRC_CommCellProp
							WHERE commcellId = @commcellId
AND propId = 2
						),
						(SELECT aliasName FROM CCM_MAP_CommCell WHERE old_id = 2)
					)
	END
	-----------------------------------------------------------------
	--Merge MMLibrary Table
IF EXISTS (SELECT * FROM CommServ_Merge..CCM_MMLibrary)
	BEGIN
		DECLARE @GRCLibrary_LibraryId				integer
		DECLARE @GRCLibrary_new_LibraryId				integer
		DECLARE @GRCLibrary_LibraryName				varchar(128)
		DECLARE @GRCLibrary_AliasName					NVARCHAR(128)
		DECLARE @GRCLibrary_LibrarySoftState			integer
		DECLARE @GRCLibrary_LibraryEnabled				integer
		DECLARE @GRCLibrary_LibraryBroken				integer
		DECLARE @GRCLibrary_LibraryTypeId				integer
		DECLARE @GRCLibrary_new_LibraryTypeId			integer
		DECLARE @GRCLibrary_BarCodeReaderPresent		integer
		DECLARE @GRCLibrary_LibraryInstallTime			integer
		DECLARE @GRCLibrary_LowWaterMarkMB				integer
		DECLARE @GRCLibrary_WarningWaterMark			integer
		DECLARE @GRCLibrary_LibraryLicenseType			integer
		DECLARE @GRCLibrary_new_LibraryLicenseType		integer
		DECLARE @GRCLibrary_LibraryVendor				varchar(16)
		DECLARE @GRCLibrary_LibraryModel				varchar(32)
		DECLARE @GRCLibrary_FirmwareRevision			varchar(32)
		DECLARE @GRCLibrary_SerialNumber				varchar(32)
		DECLARE @GRCLibrary_WWNNumber					varchar(64)
		DECLARE @GRCLibrary_FiberChannelPort			integer
		DECLARE @GRCLibrary_NumberOfMounts				integer
		DECLARE @GRCLibrary_LastServiceTime			integer
		DECLARE @GRCLibrary_DriveCount					integer
		DECLARE @GRCLibrary_BaseAddress				integer
		DECLARE @GRCLibrary_ExternalGUID				varchar(33)
		DECLARE @GRCLibrary_PrivateData				varchar(256)
		DECLARE @GRCLibrary_LibraryAttribute			integer
		DECLARE @GRCLibrary_MountTimeoutSec			integer
		DECLARE @GRCLibrary_UnmountTimeoutSec			integer
		DECLARE @GRCLibrary_NumberOfSoftErrors			integer
		DECLARE @GRCLibrary_NumberOfHardErrors			integer
		DECLARE @GRCLibrary_DefaultMediaTypeId			integer
		DECLARE @GRCLibrary_InventoryInProgress		integer
		DECLARE @GRCLibrary_IsConvertedToSited			integer
		DECLARE @GRCLibrary_LastFullInventoryTime		integer
		DECLARE @GRCLibrary_InventoryJobId_h			integer
		DECLARE @GRCLibrary_InventoryJobId_l			integer
		DECLARE @GRCLibrary_LibraryStatusReason		integer
		DECLARE @GRCLibrary_OfflineTimeStamp			integer
		DECLARE @GRCLibrary_UseWithinDaysInSec			integer
		DECLARE @GRCLibrary_DriveCleanIntervalInSec 	integer
		DECLARE @GRCLibrary_VMSDirection				integer
		DECLARE @GRCLibrary_CacheMountPeriodInSec		integer
		DECLARE @GRCLibrary_StdAlnMedRetentionTime		integer
		DECLARE @GRCLibrary_SlotBaseAddress			integer
		DECLARE @GRCLibrary_NumberOfMailSlots			integer
		DECLARE @GRCLibrary_TURIntervalInSec			integer
		DECLARE @GRCLibrary_ConfigParams				varchar(256)
		DECLARE @GRCLibrary_Descript					NVARCHAR(MAX)
		DECLARE @GRCLibrary_StdAlnChkIntervalInSec		integer
		DECLARE @GRCLibrary_StdAlnNextChkTime			integer
		DECLARE @GRCLibrary_ReadRetryIntervalInSec		integer
		DECLARE @GRCLibrary_ReadRetryAttempts			integer
		DECLARE @GRCLibrary_RestrictActivity			integer
		DECLARE @GRCLibrary_LibraryStatusEventId		integer
		DECLARE @GRCLibrary_StartVMSElementAddress		integer
		DECLARE @GRCLibrary_ExtendedAttributes			integer
		DECLARE @GRCLibrary_ThresholdPercentage		integer
		DECLARE @GRCLibrary_ThresholdVariation			integer
		DECLARE @GRCLibrary_LibrarySubType				integer
		DECLARE @GRCLibrary_VTLType					integer
		DECLARE @GRCLibrary_origCCId				integer
		DECLARE @GRCLibrary_new_origCCId				integer
		DECLARE @GRCLibrary_origLibraryId			integer
		DECLARE @GRCLibrary_LibSvrConfig				XML
		DECLARE @GRCLibrary_new_MediaAgentId			integer
		DECLARE @GRCLibrary_new_MediaAgentName			varchar(512)
		DECLARE @GRCLibrary_MasterPoolId				integer
		DECLARE @GRCLibrary_new_MasterPoolId			integer
		DECLARE @GRCLibrary_DrivePoolId					integer
		DECLARE @GRCLibrary_new_DrivePoolId				integer
		DECLARE @GRCLibrary_LibraryControllerId			integer
		DECLARE @GRCLibrary_new_LibraryControllerId		integer
		DECLARE @GRCLibrary_Exist						integer
		DECLARE @OutOfSpaceAlertInDays  				integer
UPDATE CommServ_Merge..CCM_MMLibrary
		SET origCCId = 2
		WHERE origCCId = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_MM -- MMLibrary -- UPDATE - origCCId'
			GOTO CX_ERROR_EXIT
		END
UPDATE CommServ_Merge..CCM_MMLibrary
		SET origLibraryId = LibraryId
		WHERE origLibraryId = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_MM -- MMLibrary -- UPDATE - origLibraryId'
			GOTO CX_ERROR_EXIT
		END
		DECLARE CCM_GRCLibraryCursor Cursor LOCAL For
		SELECT	a.LibraryId, a.LibraryName, a.AliasName, a.LibrarySoftState, a.LibraryEnabled, a.LibraryBroken, a.LibraryTypeId,
			a.BarCodeReaderPresent, a.LibraryInstallTime, a.LowWaterMarkMB, a.WarningWaterMark, a.LibraryLicenseType, a.LibraryVendor, a.LibraryModel,
			a.FirmwareRevision, a.SerialNumber, a.WWNNumber, a.FiberChannelPort, a.NumberOfMounts, a.LastServiceTime, a.DriveCount,
			a.BaseAddress, a.ExternalGUID, a.PrivateData, a.LibraryAttribute, a.MountTimeoutSec, a.UnmountTimeoutSec,
			a.NumberOfSoftErrors, a.NumberOfHardErrors, a.DefaultMediaTypeId, a.InventoryInProgress, a.IsConvertedToSited,
			a.LastFullInventoryTime, a.InventoryJobId_h, a.InventoryJobId_l, a.LibraryStatusReason, a.OfflineTimeStamp, a.UseWithinDaysInSec,
			a.DriveCleanIntervalInSec, a.VMSDirection, a.CacheMountPeriodInSec, a.StdAlnMedRetentionTime, a.SlotBaseAddress, a.NumberOfMailSlots,
			a.TURIntervalInSec, a.ConfigParams, a.Descript, a.StdAlnChkIntervalInSec, a.StdAlnNextChkTime, a.ReadRetryIntervalInSec,
			a.ReadRetryAttempts, a.RestrictActivity, a.LibraryStatusEventId, a.StartVMSElementAddress, a.ExtendedAttributes,
			a.ThresholdPercentage, a.ThresholdVariation, a.LibrarySubType, a.VTLType, a.origCCId, b.new_Id, a.origLibraryId,
			a.LibSvrConfig, c.newMediaAgentId, c.newLibraryId, a.OutOfSpaceAlertInDays
FROM CommServ_Merge..CCM_MMLibrary a
			INNER JOIN CCM_MAP_CommCell b ON a.origCCId = b.old_Id
INNER JOIN CommServ_Merge..CCM_LibraryMapping c ON a.LibraryId = c.SourceLibraryId
		WHERE a.LibraryId > 0
		OPEN CCM_GRCLibraryCursor
		FETCH NEXT FROM CCM_GRCLibraryCursor
		INTO @GRCLibrary_LibraryId, @GRCLibrary_LibraryName, @GRCLibrary_AliasName, @GRCLibrary_LibrarySoftState,
			@GRCLibrary_LibraryEnabled, @GRCLibrary_LibraryBroken, @GRCLibrary_LibraryTypeId, @GRCLibrary_BarCodeReaderPresent,
			@GRCLibrary_LibraryInstallTime, @GRCLibrary_LowWaterMarkMB, @GRCLibrary_WarningWaterMark, @GRCLibrary_LibraryLicenseType, @GRCLibrary_LibraryVendor,
			@GRCLibrary_LibraryModel, @GRCLibrary_FirmwareRevision, @GRCLibrary_SerialNumber, @GRCLibrary_WWNNumber,
			@GRCLibrary_FiberChannelPort, @GRCLibrary_NumberOfMounts, @GRCLibrary_LastServiceTime, @GRCLibrary_DriveCount,
			@GRCLibrary_BaseAddress, @GRCLibrary_ExternalGUID, @GRCLibrary_PrivateData, @GRCLibrary_LibraryAttribute,
			@GRCLibrary_MountTimeoutSec, @GRCLibrary_UnmountTimeoutSec, @GRCLibrary_NumberOfSoftErrors, @GRCLibrary_NumberOfHardErrors,
			@GRCLibrary_DefaultMediaTypeId, @GRCLibrary_InventoryInProgress, @GRCLibrary_IsConvertedToSited,
			@GRCLibrary_LastFullInventoryTime, @GRCLibrary_InventoryJobId_h, @GRCLibrary_InventoryJobId_l, @GRCLibrary_LibraryStatusReason,
			@GRCLibrary_OfflineTimeStamp, @GRCLibrary_UseWithinDaysInSec, @GRCLibrary_DriveCleanIntervalInSec, @GRCLibrary_VMSDirection,
			@GRCLibrary_CacheMountPeriodInSec, @GRCLibrary_StdAlnMedRetentionTime, @GRCLibrary_SlotBaseAddress, @GRCLibrary_NumberOfMailSlots,
			@GRCLibrary_TURIntervalInSec, @GRCLibrary_ConfigParams, @GRCLibrary_Descript, @GRCLibrary_StdAlnChkIntervalInSec,
			@GRCLibrary_StdAlnNextChkTime, @GRCLibrary_ReadRetryIntervalInSec, @GRCLibrary_ReadRetryAttempts, @GRCLibrary_RestrictActivity,
			@GRCLibrary_LibraryStatusEventId, @GRCLibrary_StartVMSElementAddress, @GRCLibrary_ExtendedAttributes,
			@GRCLibrary_ThresholdPercentage, @GRCLibrary_ThresholdVariation, @GRCLibrary_LibrarySubType, @GRCLibrary_VTLType,
			@GRCLibrary_origCCId, @GRCLibrary_new_origCCId, @GRCLibrary_origLibraryId,
			@GRCLibrary_LibSvrConfig, @GRCLibrary_new_MediaAgentId, @GRCLibrary_new_LibraryId, @OutOfSpaceAlertInDays
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF @GRCLibrary_new_LibraryId = 0
				SET @GRCLibrary_new_LibraryId =
						(
							SELECT top 1 LibraryId FROM MMLibrary
							WHERE (origCCID = @GRCLibrary_new_origCCId AND origLibraryId = @GRCLibrary_origLibraryId)
								OR (origCCID = 2 AND origCCID = @GRCLibrary_new_origCCId AND LibraryId = @GRCLibrary_origLibraryId)
						)
			IF ISNULL(@GRCLibrary_new_LibraryId, 0) = 0
			BEGIN
				SET @GRCLibrary_Exist = 0
				--Set extended attribute
SELECT @GRCLibrary_ExtendedAttributes = @GRCLibrary_ExtendedAttributes | 1048576
				IF @GRCLibrary_new_MediaAgentId <= 1
				BEGIN
SET @GRCLibrary_LibraryStatusReason	= 46011
					SET @GRCLibrary_LibrarySoftState = 0
					SET @GRCLibrary_LibraryEnabled = 0
				END
				IF @GRCLibrary_LibraryTypeId = 3
					SELECT @GRCLibrary_LibraryName = 'DiskLibrary'
				ELSE
					SELECT @GRCLibrary_LibraryName = 'Library'
				--Migrate Tape Library as Deconfigured Library
				IF @GRCLibrary_LibraryTypeId NOT IN (3,8)
				BEGIN
					SET @GRCLibrary_new_LibraryTypeId = 9
					SET @GRCLibrary_new_LibraryLicenseType = 0
				END
				ELSE
				BEGIN
					SET @GRCLibrary_new_LibraryTypeId = @GRCLibrary_LibraryTypeId
					SET @GRCLibrary_new_LibraryLicenseType = @GRCLibrary_LibraryLicenseType
				END
				--Prefix Library alias name with podcell name
				SET @name = @GRCLibrary_AliasName
				IF ( (@ccmParamFlags & 1) = 1) /*GRC merge */
				BEGIN
					IF @usePrefix > 0		/*If use prefix set then add a prefix always*/
					BEGIN
						SET @index = PATINDEX (@podCellName+'[_]%', @name)
						IF @index = 0
							SET @name = @podCellName+'_' + @name
					END
					ELSE IF EXISTS (SELECT 1 FROM MMLibrary WHERE aliasName = @name)  /*If use suffix is set then add a suffix only when name exists already*/
					BEGIN
						SET @index = PATINDEX ('%[_]'+@podCellName, @name)
						IF @index = 0
							SET @name = @name + '_' + @podCellName
					END
				END
				ELSE
				BEGIN
					SET @index = PATINDEX ('%CCM_%', @name)
					IF @index = 0 AND @GRCLibrary_new_origCCId <> 2
						SET @name = 'CCM_' + @name
				END
				SET @index = 0
				SET @tempName = @name
				WHILE(exists (select 1 from MMLibrary where aliasName = @tempName))
				BEGIN
						SET @index = @index + 1
						SET @tempName = @name + '(' + cast(@index as varchar(32)) + ')'
				END
				SET @GRCLibrary_AliasName = @tempName
				SELECT @SizeOfnameCol = CHARACTER_MAXIMUM_LENGTH FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME LIKE 'MMLibrary' AND COLUMN_NAME = 'AliasName'
				IF LEN(@GRCLibrary_AliasName)> @SizeOfnameCol
					SET @GRCLibrary_AliasName = SUBSTRING(@GRCLibrary_AliasName, 1, @SizeOfnameCol)
				INSERT	INTO MMLibrary
				VALUES(@GRCLibrary_LibraryName, @GRCLibrary_AliasName, @GRCLibrary_LibrarySoftState,
					@GRCLibrary_LibraryEnabled, @GRCLibrary_LibraryBroken, @GRCLibrary_new_LibraryTypeId, @GRCLibrary_BarCodeReaderPresent,
					@GRCLibrary_LibraryInstallTime, @GRCLibrary_LowWaterMarkMB, @GRCLibrary_new_LibraryLicenseType, @GRCLibrary_LibraryVendor,
					@GRCLibrary_LibraryModel, @GRCLibrary_FirmwareRevision, @GRCLibrary_SerialNumber, @GRCLibrary_WWNNumber,
					@GRCLibrary_FiberChannelPort, @GRCLibrary_NumberOfMounts, @GRCLibrary_LastServiceTime, @GRCLibrary_DriveCount,
					@GRCLibrary_BaseAddress, @GRCLibrary_ExternalGUID, @GRCLibrary_PrivateData, @GRCLibrary_LibraryAttribute,
					@GRCLibrary_MountTimeoutSec, @GRCLibrary_UnmountTimeoutSec, @GRCLibrary_NumberOfSoftErrors,
					@GRCLibrary_NumberOfHardErrors, @GRCLibrary_DefaultMediaTypeId, @GRCLibrary_InventoryInProgress,
					@GRCLibrary_IsConvertedToSited, @GRCLibrary_LastFullInventoryTime, @GRCLibrary_InventoryJobId_h,
					@GRCLibrary_InventoryJobId_l, @GRCLibrary_LibraryStatusReason, @GRCLibrary_OfflineTimeStamp,
					@GRCLibrary_UseWithinDaysInSec, @GRCLibrary_DriveCleanIntervalInSec, @GRCLibrary_VMSDirection,
					@GRCLibrary_CacheMountPeriodInSec, @GRCLibrary_StdAlnMedRetentionTime, @GRCLibrary_SlotBaseAddress,
					@GRCLibrary_NumberOfMailSlots, @GRCLibrary_TURIntervalInSec, @GRCLibrary_ConfigParams, @GRCLibrary_Descript,
					@GRCLibrary_StdAlnChkIntervalInSec, @GRCLibrary_StdAlnNextChkTime, @GRCLibrary_ReadRetryIntervalInSec,
					@GRCLibrary_ReadRetryAttempts, @GRCLibrary_RestrictActivity, @GRCLibrary_LibraryStatusEventId,
					@GRCLibrary_StartVMSElementAddress, @GRCLibrary_ExtendedAttributes, @GRCLibrary_ThresholdPercentage,
					@GRCLibrary_ThresholdVariation, @GRCLibrary_LibrarySubType, @GRCLibrary_VTLType,
					@GRCLibrary_new_origCCId, @GRCLibrary_origLibraryId, @GRCLibrary_LibSvrConfig, @GRCLibrary_WarningWaterMark, @OutOfSpaceAlertInDays)
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMLibrary -- INSERT'
					GOTO CX_ERROR_EXIT
				END
				SELECT @GRCLibrary_new_LibraryId = SCOPE_IDENTITY()
				--Update Library Name
				UPDATE MMLibrary
				SET LibraryName = LibraryName + CONVERT(varchar, @GRCLibrary_new_LibraryId)
				WHERE LibraryId = @GRCLibrary_new_LibraryId
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMLibrary -- UPDATE LibraryName'
					GOTO CX_ERROR_EXIT
				END
				--Don't migrate master pool for deconfigured libraries and shelf libraries.
				IF (@GRCLibrary_new_LibraryTypeId <> 9) AND (@GRCLibrary_new_LibraryTypeId <> 8)
				BEGIN
					--Merge MMMasterPool
SET @GRCLibrary_MasterPoolId  = ISNULL((SELECT TOP 1 MasterPoolId FROM CommServ_Merge..CCM_MMMasterPool WHERE LibraryId = @GRCLibrary_LibraryId),0)
					IF(@GRCLibrary_MasterPoolId = 0)
					BEGIN
						SET @errStr = "ERROR: CCM_Merge_MM -- MMMasterPool Does Not Exist For Library"
						GOTO CX_ERROR_EXIT
					END
					INSERT INTO MMMasterPool
					SELECT 	'MasterPool_Magnetic_', a.MasterPoolSoftState, a.MasterPoolEnabled, @GRCLibrary_new_LibraryId, a.TotalDrives, a.ReservedDrives,
							a.MaxSwitchForHost, a.Descript, a.DriveTypeId, a.RMStatus, a.RMStatusUpdateTime, b.new_Id, a.MasterPoolId
FROM	CommServ_Merge..CCM_MMMasterPool a
							INNER JOIN CCM_MAP_CommCell b ON a.origCCId = b.old_Id
					WHERE  a.MasterPoolId = @GRCLibrary_MasterPoolId
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMMasterPool -- INSERT'
						GOTO CX_ERROR_EXIT
					END
					SELECT @GRCLibrary_new_MasterPoolId = SCOPE_IDENTITY()
					--Update MasterPoolName
					UPDATE MMMasterPool
					SET MasterPoolName = MasterPoolName + CONVERT(varchar, @GRCLibrary_new_LibraryId) + CONVERT(varchar, @GRCLibrary_new_MasterPoolId)
					WHERE MasterPoolId = @GRCLibrary_new_MasterPoolId
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMMasterPool -- UPDATE Name'
						GOTO CX_ERROR_EXIT
					END
					IF @GRCLibrary_new_MediaAgentId > 1
					BEGIN
						--Merge MMDrivePool
SET @GRCLibrary_DrivePoolId  = ISNULL((SELECT TOP 1 DrivePoolId FROM CommServ_Merge..CCM_MMDrivePool WHERE MasterPoolId = @GRCLibrary_MasterPoolId),0)
						IF(@GRCLibrary_DrivePoolId = 0)
						BEGIN
							SET @errStr = "ERROR: CCM_Merge_MM -- MMDrivePool Does Not Exist For Library"
							GOTO CX_ERROR_EXIT
						END
						SELECT @GRCLibrary_new_MediaAgentName = name
						FROM App_Client
						WHERE id = @GRCLibrary_new_MediaAgentId
						INSERT INTO MMDrivePool
						SELECT 	'DrivePool('+@GRCLibrary_new_MediaAgentName+')', a.DrivePoolSoftState, a.DrivePoolEnabled,
								a.ReservedDrives, a.DrivePoolType, a.MaxDrivesToSwitch, '', 0,
								1, a.Descript, @GRCLibrary_new_MediaAgentId, @GRCLibrary_new_MasterPoolId,
								0, a.RMStatus, a.RMStatusUpdateTime, b.new_Id, a.DrivePoolId
FROM	CommServ_Merge..CCM_MMDrivePool a
								INNER JOIN CCM_MAP_CommCell b ON a.origCCId = b.old_Id
						WHERE  a.DrivePoolId = @GRCLibrary_DrivePoolId
						IF	@@ERROR > 0
						BEGIN
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMDrivePool -- INSERT'
							GOTO CX_ERROR_EXIT
						END
						SELECT @GRCLibrary_new_DrivePoolId = SCOPE_IDENTITY()
						--Update DrivePoolName
						UPDATE MMDrivePool
						SET DrivePoolName = DrivePoolName + CONVERT(varchar, @GRCLibrary_new_DrivePoolId)
						WHERE DrivePoolId = @GRCLibrary_new_DrivePoolId
						IF	@@ERROR > 0
						BEGIN
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMDrivePool -- UPDATE Name'
							GOTO CX_ERROR_EXIT
						END
						--Merge MMLibraryController
SET @GRCLibrary_LibraryControllerId  = ISNULL((SELECT TOP 1 LibraryControllerId FROM CommServ_Merge..CCM_MMLibraryController
							WHERE LibraryId = @GRCLibrary_LibraryId),0)
						IF(@GRCLibrary_LibraryControllerId = 0)
						BEGIN
							SET @errStr = "ERROR: CCM_Merge_MM -- MMLibraryController Does Not Exist For Library"
							GOTO CX_ERROR_EXIT
						END
						INSERT INTO MMLibraryController
						SELECT 	'LmsLibrary'+ convert(varchar, @GRCLibrary_new_LibraryId) + '_',
								@GRCLibrary_new_MediaAgentId, a.LibraryControllerSoftState, a.LibraryControllerActive, a.LibraryControllerType,
								a.LibraryControllerEnabled, @GRCLibrary_new_LibraryId, a.ConnectionType, a.SCSIId
FROM	CommServ_Merge..CCM_MMLibraryController a
						WHERE  a.LibraryControllerId = @GRCLibrary_LibraryControllerId
						IF	@@ERROR > 0
						BEGIN
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMLibraryController -- INSERT'
							GOTO CX_ERROR_EXIT
						END
						SELECT @GRCLibrary_new_LibraryControllerId = SCOPE_IDENTITY()
						--Update LibrarController Name
						UPDATE MMLibraryController
						SET LibraryControllerName = LibraryControllerName + CONVERT(varchar, @GRCLibrary_new_LibraryControllerId)
						WHERE LibraryControllerId = @GRCLibrary_new_LibraryControllerId
						IF	@@ERROR > 0
						BEGIN
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMLibraryController -- UPDATE Name'
							GOTO CX_ERROR_EXIT
						END
					END
				END
			END
			ELSE
			BEGIN
				SET @GRCLibrary_Exist = 1
				--Mark library as online when it is attached to a MA
				IF @GRCLibrary_new_MediaAgentId > 1
				BEGIN
					UPDATE MMLibrary
SET LibraryStatusReason = 46003,
						LibrarySoftState = 1,
						LibraryEnabled = 1
					WHERE LibraryId = @GRCLibrary_new_LibraryId
--AND LibraryStatusReason = 46011
						AND LibrarySoftState = 0
				END
SET @GRCLibrary_MasterPoolId  = ISNULL((SELECT TOP 1 MasterPoolId FROM CommServ_Merge..CCM_MMMasterPool WHERE LibraryId = @GRCLibrary_LibraryId),0)
				/* This check is not needed since some libraries(deconfigured and Shelf) don't have MasterPool
				IF(@GRCLibrary_MasterPoolId = 0)
				BEGIN
					SET @errStr = "ERROR: CCM_Merge_MM -- MMMasterPool Does Not Exist For Library"
					GOTO CX_ERROR_EXIT
				END
				*/
				SET @GRCLibrary_new_MasterPoolId = ISNULL((SELECT TOP 1 MasterPoolId FROM MMMasterPool WHERE LibraryId = @GRCLibrary_new_LibraryId), 0)
				SET @GRCLibrary_new_DrivePoolId = ISNULL((SELECT TOP 1 DrivePoolId FROM MMDrivePool WHERE MasterPoolId = @GRCLibrary_new_MasterPoolId), 0)
				IF (@GRCLibrary_new_DrivePoolId <> 0)
					SET @GRCLibrary_new_MediaAgentId = ISNULL((SELECT TOP 1 ClientId FROM MMDrivePool WHERE DrivePoolId = @GRCLibrary_new_DrivePoolId), 1)
				IF (@GRCLibrary_new_LibraryTypeId <> 9) AND (@GRCLibrary_new_LibraryTypeId <> 8)
				BEGIN
					--Library was migrated with no MA previously and in next import if they choose MA then add DrivePool and LibraryController
					IF (@GRCLibrary_new_DrivePoolId = 0) AND (@GRCLibrary_new_MediaAgentId > 1)
					BEGIN
						--Merge MMDrivePool
SET @GRCLibrary_DrivePoolId  = ISNULL((SELECT TOP 1 DrivePoolId FROM CommServ_Merge..CCM_MMDrivePool WHERE MasterPoolId = @GRCLibrary_MasterPoolId),0)
						IF(@GRCLibrary_DrivePoolId = 0)
						BEGIN
							SET @errStr = "ERROR: CCM_Merge_MM -- MMDrivePool Does Not Exist For Library"
							GOTO CX_ERROR_EXIT
						END
						SELECT @GRCLibrary_new_MediaAgentName = name
						FROM App_Client
						WHERE id = @GRCLibrary_new_MediaAgentId
						INSERT INTO MMDrivePool
						SELECT 	'DrivePool('+@GRCLibrary_new_MediaAgentName+')', a.DrivePoolSoftState, a.DrivePoolEnabled,
								a.ReservedDrives, a.DrivePoolType, a.MaxDrivesToSwitch, '', 0,
								1, a.Descript, @GRCLibrary_new_MediaAgentId, @GRCLibrary_new_MasterPoolId,
								0, a.RMStatus, a.RMStatusUpdateTime, b.new_Id, a.DrivePoolId
FROM	CommServ_Merge..CCM_MMDrivePool a
								INNER JOIN CCM_MAP_CommCell b ON a.origCCId = b.old_Id
						WHERE  a.DrivePoolId = @GRCLibrary_DrivePoolId
						IF	@@ERROR > 0
						BEGIN
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMDrivePool -- INSERT'
							GOTO CX_ERROR_EXIT
						END
						SELECT @GRCLibrary_new_DrivePoolId = SCOPE_IDENTITY()
						--Update DrivePoolName
						UPDATE MMDrivePool
						SET DrivePoolName = DrivePoolName + CONVERT(varchar, @GRCLibrary_new_DrivePoolId)
						WHERE DrivePoolId = @GRCLibrary_new_DrivePoolId
						IF	@@ERROR > 0
						BEGIN
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMDrivePool -- UPDATE Name'
							GOTO CX_ERROR_EXIT
						END
						--Merge MMLibraryController
SET @GRCLibrary_LibraryControllerId  = ISNULL((SELECT TOP 1 LibraryControllerId FROM CommServ_Merge..CCM_MMLibraryController
							WHERE LibraryId = @GRCLibrary_LibraryId),0)
						IF(@GRCLibrary_LibraryControllerId = 0)
						BEGIN
							SET @errStr = "ERROR: CCM_Merge_MM -- MMLibraryController Does Not Exist For Library"
							GOTO CX_ERROR_EXIT
						END
						INSERT INTO MMLibraryController
						SELECT 	'LmsLibrary'+ convert(varchar, @GRCLibrary_new_LibraryId) + '_',
								@GRCLibrary_new_MediaAgentId, a.LibraryControllerSoftState, a.LibraryControllerActive, a.LibraryControllerType,
								a.LibraryControllerEnabled, @GRCLibrary_new_LibraryId, a.ConnectionType, a.SCSIId
FROM	CommServ_Merge..CCM_MMLibraryController a
						WHERE  a.LibraryControllerId = @GRCLibrary_LibraryControllerId
						IF	@@ERROR > 0
						BEGIN
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMLibraryController -- INSERT'
							GOTO CX_ERROR_EXIT
						END
						SELECT @GRCLibrary_new_LibraryControllerId = SCOPE_IDENTITY()
						--Update LibrarController Name
						UPDATE MMLibraryController
						SET LibraryControllerName = LibraryControllerName + CONVERT(varchar, @GRCLibrary_new_LibraryControllerId)
						WHERE LibraryControllerId = @GRCLibrary_new_LibraryControllerId
						IF	@@ERROR > 0
						BEGIN
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMLibraryController -- UPDATE Name'
							GOTO CX_ERROR_EXIT
						END
					END
				END
			END
			INSERT INTO CCM_MAP_Library
			VALUES(@GRCLibrary_LibraryId, @GRCLibrary_new_LibraryId,
				@GRCLibrary_origCCId, @GRCLibrary_new_origCCId,
				@GRCLibrary_new_MasterPoolId, @GRCLibrary_new_DrivePoolId,
				@GRCLibrary_new_MediaAgentId, @GRCLibrary_new_LibraryTypeId,
				@GRCLibrary_Exist)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_Library -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			-- Now that the answer has been used to create a Library
			-- do not allow the edit of the answer from GUI
			-- Do this for only Libraries attached to a MA at Destination
			UPDATE CommServ..CCMLibraryAnswers
			SET allowEdit = 0
			WHERE SourceLibraryId = @GRCLibrary_LibraryId
			  AND SourceCommCellGUID = @commcellGUID
			  AND TargetMediaAgentId > 1
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- CCMLibraryAnswers -- UPDATE -- allowEdit'
				GOTO CX_ERROR_EXIT
			END
			FETCH NEXT FROM CCM_GRCLibraryCursor
			INTO @GRCLibrary_LibraryId, @GRCLibrary_LibraryName, @GRCLibrary_AliasName, @GRCLibrary_LibrarySoftState,
				@GRCLibrary_LibraryEnabled, @GRCLibrary_LibraryBroken, @GRCLibrary_LibraryTypeId, @GRCLibrary_BarCodeReaderPresent,
				@GRCLibrary_LibraryInstallTime, @GRCLibrary_LowWaterMarkMB, @GRCLibrary_WarningWaterMark, @GRCLibrary_LibraryLicenseType, @GRCLibrary_LibraryVendor,
				@GRCLibrary_LibraryModel, @GRCLibrary_FirmwareRevision, @GRCLibrary_SerialNumber, @GRCLibrary_WWNNumber,
				@GRCLibrary_FiberChannelPort, @GRCLibrary_NumberOfMounts, @GRCLibrary_LastServiceTime, @GRCLibrary_DriveCount,
				@GRCLibrary_BaseAddress, @GRCLibrary_ExternalGUID, @GRCLibrary_PrivateData, @GRCLibrary_LibraryAttribute,
				@GRCLibrary_MountTimeoutSec, @GRCLibrary_UnmountTimeoutSec, @GRCLibrary_NumberOfSoftErrors, @GRCLibrary_NumberOfHardErrors,
				@GRCLibrary_DefaultMediaTypeId, @GRCLibrary_InventoryInProgress, @GRCLibrary_IsConvertedToSited,
				@GRCLibrary_LastFullInventoryTime, @GRCLibrary_InventoryJobId_h, @GRCLibrary_InventoryJobId_l,
				@GRCLibrary_LibraryStatusReason, @GRCLibrary_OfflineTimeStamp, @GRCLibrary_UseWithinDaysInSec,
				@GRCLibrary_DriveCleanIntervalInSec, @GRCLibrary_VMSDirection, @GRCLibrary_CacheMountPeriodInSec,
				@GRCLibrary_StdAlnMedRetentionTime, @GRCLibrary_SlotBaseAddress, @GRCLibrary_NumberOfMailSlots,
				@GRCLibrary_TURIntervalInSec, @GRCLibrary_ConfigParams, @GRCLibrary_Descript, @GRCLibrary_StdAlnChkIntervalInSec,
				@GRCLibrary_StdAlnNextChkTime, @GRCLibrary_ReadRetryIntervalInSec, @GRCLibrary_ReadRetryAttempts,
				@GRCLibrary_RestrictActivity, @GRCLibrary_LibraryStatusEventId, @GRCLibrary_StartVMSElementAddress,
				@GRCLibrary_ExtendedAttributes, @GRCLibrary_ThresholdPercentage, @GRCLibrary_ThresholdVariation, @GRCLibrary_LibrarySubType,
				@GRCLibrary_VTLType, @GRCLibrary_origCCId, @GRCLibrary_new_origCCId, @GRCLibrary_origLibraryId,
				@GRCLibrary_LibSvrConfig, @GRCLibrary_new_MediaAgentId, @GRCLibrary_new_LibraryId, @OutOfSpaceAlertInDays
		END
		CLOSE CCM_GRCLibraryCursor
		DEALLOCATE CCM_GRCLibraryCursor
	END --MMLibaray
	--Update answers with new LibraryId
	UPDATE CommServ..CCMLibraryAnswers
	SET TargetLibraryId = b.new_LibraryId
	FROM CommServ..CCMLibraryAnswers a
		INNER JOIN CCM_MAP_Library b ON a.SourceLibraryId = b.old_LibraryId
	WHERE a.SourceCommCellGUID = @commcellGUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCMLibraryAnswers -- UPDATE -- TargetLibraryId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CommServ..CCMMountPathAnswers
	SET TargetLibraryId = c.new_LibraryId
	FROM CommServ..CCMMountPathAnswers a
INNER JOIN CommServ_Merge..CCM_MMMountPath b ON a.SourceMountPathId = b.MountPathId
		INNER JOIN CCM_MAP_Library c ON b.LibraryId = c.old_LibraryId
	WHERE a.SourceCommCellGUID = @commcellGUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCMMountPathAnswers -- UPDATE -- TargetLibraryId'
		GOTO CX_ERROR_EXIT
	END
UPDATE CommServ_Merge..CCM_MountPathMapping
	SET newLibraryId = a.TargetLibraryId
	FROM CommServ..CCMMountPathAnswers a
	WHERE a.SourceCommCellGUID = @commcellGUID
AND a.SourceMountPathId = CommServ_Merge..CCM_MountPathMapping.MountPathId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MountPathMapping -- UPDATE newLibraryId'
		GOTO CX_ERROR_EXIT
	END
	/*
	-- Unanswered Mount Path questions
IF EXISTS(SELECT * FROM CommServ_Merge..CCM_MountPathMapping WHERE newLibraryId = 0 OR (ISNULL(newMountPathName,'') = ''))
	BEGIN
	  SET @errStr = 'ERROR: CCM_Merge_MM -- Answers needed for MountPath Mappings, Merge Can not Proceed'
	  GOTO CX_ERROR_EXIT
	END
	*/
UPDATE CommServ_Merge..CCM_DataPathMapping
	SET	newLibraryId = new_LibraryId,
		newMediaAgentId = b.new_MediaAgentId,
		newDataPathId	= b.new_DrivePoolId
FROM CommServ_Merge..CCM_DataPathMapping a INNER JOIN CCM_MAP_Library b
		ON a.LibraryId = b.old_LibraryId AND b.new_MediaAgentId > 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_DataPathMapping -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	--------------------------------------------------------------------------
	-- MMDataPath --
IF EXISTS (SELECT 1 FROM CommServ_Merge..CCM_DataPathMapping)
	BEGIN
		DECLARE @Fallback_MediaAgentId  INTEGER
		DECLARE @Fallback_LibraryId		INTEGER
		DECLARE @Fallback_DrivePoolId 	INTEGER
		DECLARE @Fallback_SpareGroupId	INTEGER
		set @Fallback_MediaAgentId = @i_indexMAId
		set @Fallback_DrivePoolId  = isnull((select top 1 DrivePoolId from MMDrivePool where clientId = @Fallback_MediaAgentId order by (case when DrivePoolType = 10001 then 0 else 1 end)),0)
		set @Fallback_LibraryId    = isnull((select top 1 LibraryId from MMMasterPool where masterPoolId = (select MasterPoolId from MMDrivePool where DrivePoolId = @Fallback_DrivePoolId)),0)
		set @Fallback_SpareGroupId = isnull((select top 1 SpareGroupId from MMSpareGroup where SpareGroupType = 2 AND LibraryId = @Fallback_LibraryId),0)
		--
		--Add data path to the copies if there is no datapath exists
		--
		/*
			In this TR 200528-168, the data path exists but no DrivePool, SpareGroupId. Adding check to make sure we are adding valid datapath.
		*/
		IF @Fallback_DrivePoolId > 0
		BEGIN
			INSERT INTO MMDataPath
			SELECT 	f.id, @Fallback_DrivePoolId, @Fallback_MediaAgentId,
1 | 2 | 4 | 32,
					@Fallback_SpareGroupId, 0, 0, 0, 0, 0, 0
			FROM 	archGroupCopy f
					INNER JOIN CCM_MAP_ArchGroupCopy a ON a.new_id = f.id
WHERE 	f.dedupeFlags & 134217728 = 0
AND f.extendedFlags & (2 | 8192) = 0
					AND NOT EXISTS(SELECT 1 FROM MMDataPath WHERE copyId = f.id)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- MMDataPath -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			--
			--Add data path for dependent copies
			--
			INSERT INTO MMDataPath
SELECT 	f.id, c.DrivePoolId, c.HostClientId, (c.flag | 32),
					c.SpareGroupId, 0, 0, 0, 0, 0, 0
			FROM    archGroupCopy f  --Copies using gobal policies
			INNER JOIN CCM_MAP_ArchGroupCopy a ON a.new_id = f.id
			INNER JOIN archCopyToGlobalPolicy DC2GC ON f.id = DC2GC.copyId
			INNER JOIN  ArchGroup GAG ON DC2GC.globalPolicyId = GAG.Id
			INNER JOIN MMDataPath c ON GAG.defaultCopy = c.copyId  --global policy copy data paths
			WHERE   NOT EXISTS(SELECT 1 FROM MMDataPath WHERE copyId = f.id)
AND c.flag & 1 > 0
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- MMDataPath -- INSERT copies using global polocies'
				GOTO CX_ERROR_EXIT
			END
			-- Update MediaGroup with the defalut data path.
			UPDATE 	MMMediaGroup
			SET	DrivePoolId  		= c.DrivePoolId,
				SpareGroupId 		= c.SpareGroupId,
				DesiredMediaTypeId 	= DT.DefaultMediaTypeId,
				RecordingFormatId 	= RFMT.RecordingFormatId,
				DataPathId 		= c.DataPathId
			FROM	MMMediaGroup a
				INNER JOIN CCM_MAP_ArchStream b ON a.MediaGroupId = b.new_mediaGroupId
				INNER JOIN MMDataPath c ON b.new_archGroupCopyId = c.copyId,
				MMDriveType DT,
				MMRecFmtMedTyp RFMT
WHERE	a.DataPathId = 0 AND (c.flag & 1) > 0
				AND DT.DefaultMediaTypeId = RFMT.MediaTypeId
				AND DT.DriveTypeId IN  (SELECT  DR.DriveTypeId
							FROM 	MMDrive DR INNER JOIN MMDrivePool DP ON DR.MasterPoolId = DP.MasterPoolId
							WHERE	DP.DrivePoolId = c.DrivePoolId)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- MMMediaGroup -- UPDATE'
				GOTO CX_ERROR_EXIT
			END
		END
	END
	-- End MMDataPath --
	-- MMCenteraInfo --
IF EXISTS (SELECT * FROM CommServ_Merge..CCM_MMCenteraInfo WHERE CenteraId > 0)
	BEGIN
		DECLARE @MMS2CenteraInfo_CenteraId			INTEGER
DECLARE @MMS2CenteraInfo_FriendlyName		varchar(512)
DECLARE @MMS2CenteraInfo_ClusterName		varchar(512)
DECLARE @MMS2CenteraInfo_ClusterId			varchar(512)
DECLARE @MMS2CenteraInfo_Version			varchar(512)
		DECLARE @MMS2CenteraInfo_CapacityMB_h		INTEGER
		DECLARE @MMS2CenteraInfo_CapacityMB_l		INTEGER
		DECLARE @MMS2CenteraInfo_FreeSpaceMB_h		INTEGER
		DECLARE @MMS2CenteraInfo_FreeSpaceMB_l		INTEGER
DECLARE @MMS2CenteraInfo_ReplicateAddress	varchar(512)
		DECLARE @MMS2CenteraInfo_ApiRetryInterval		INTEGER
		DECLARE @MMS2CenteraInfo_newCenteraId 		INTEGER
		DECLARE CCM_MMS2CenteraInfoCursor Cursor LOCAL For
		SELECT distinct CenteraId, FriendlyName, ClusterName, ClusterId, Version,
		CapacityMB_h, CapacityMB_l, FreeSpaceMB_h, FreeSpaceMB_l, ReplicateAddress, ApiRetryInterval
FROM CommServ_Merge..CCM_MMCenteraInfo
		OPEN CCM_MMS2CenteraInfoCursor
		FETCH NEXT FROM CCM_MMS2CenteraInfoCursor
		INTO @MMS2CenteraInfo_CenteraId, @MMS2CenteraInfo_FriendlyName, @MMS2CenteraInfo_ClusterName, @MMS2CenteraInfo_ClusterId, @MMS2CenteraInfo_Version, @MMS2CenteraInfo_CapacityMB_h, @MMS2CenteraInfo_CapacityMB_l, @MMS2CenteraInfo_FreeSpaceMB_h, @MMS2CenteraInfo_FreeSpaceMB_l, @MMS2CenteraInfo_ReplicateAddress, @MMS2CenteraInfo_ApiRetryInterval
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @MMS2CenteraInfo_newCenteraId = (SELECT TOP 1 CenteraId FROM MMCenteraInfo WHERE FriendlyName = @MMS2CenteraInfo_FriendlyName AND ClusterName = @MMS2CenteraInfo_ClusterName AND ClusterId = @MMS2CenteraInfo_ClusterId)
			IF @MMS2CenteraInfo_newCenteraId is null
			BEGIN
				INSERT INTO MMCenteraInfo (FriendlyName, ClusterName, ClusterId, Version, CapacityMB_h, CapacityMB_l, FreeSpaceMB_h, FreeSpaceMB_l, ReplicateAddress, ApiRetryInterval)
				VALUES(@MMS2CenteraInfo_FriendlyName, @MMS2CenteraInfo_ClusterName, @MMS2CenteraInfo_ClusterId, @MMS2CenteraInfo_Version, @MMS2CenteraInfo_CapacityMB_h, @MMS2CenteraInfo_CapacityMB_l, @MMS2CenteraInfo_FreeSpaceMB_h, @MMS2CenteraInfo_FreeSpaceMB_l, @MMS2CenteraInfo_ReplicateAddress, @MMS2CenteraInfo_ApiRetryInterval)
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMCenteraInfo -- INSERT'
					GOTO CX_ERROR_EXIT
				END
				SELECT @MMS2CenteraInfo_newCenteraId = @@IDENTITY
			END
			INSERT INTO CCM_MAP_MMCenteraInfo (old_id, new_id)
			VALUES (@MMS2CenteraInfo_CenteraId, @MMS2CenteraInfo_newCenteraId)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMCenteraInfo -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			FETCH NEXT FROM CCM_MMS2CenteraInfoCursor
			INTO @MMS2CenteraInfo_CenteraId, @MMS2CenteraInfo_FriendlyName, @MMS2CenteraInfo_ClusterName, @MMS2CenteraInfo_ClusterId, @MMS2CenteraInfo_Version, @MMS2CenteraInfo_CapacityMB_h, @MMS2CenteraInfo_CapacityMB_l, @MMS2CenteraInfo_FreeSpaceMB_h, @MMS2CenteraInfo_FreeSpaceMB_l, @MMS2CenteraInfo_ReplicateAddress, @MMS2CenteraInfo_ApiRetryInterval
		END
		CLOSE CCM_MMS2CenteraInfoCursor
		DEALLOCATE CCM_MMS2CenteraInfoCursor
	END
	-- End MMCenteraInfo --
	-- MMCenteraAccessNode --
IF EXISTS (SELECT * FROM CommServ_Merge..CCM_MMCenteraAccessNode WHERE AccessNodeId > 0)
	BEGIN
		DECLARE @MMS2CenteraAccessNode_AccessNodeId		INTEGER
DECLARE @MMS2CenteraAccessNode_NetHostName		varchar(1024)
		DECLARE @MMS2CenteraAccessNode_CenteraId		INTEGER
		DECLARE @MMS2CenteraAccessNode_newCenteraId		INTEGER
		DECLARE @MMS2CenteraAccessNode_newAccessNodeId 		INTEGER
		DECLARE CCM_MMS2CenteraAccessNodeCursor Cursor LOCAL For
		SELECT distinct a.AccessNodeId, a.NetHostName, a.CenteraId, b.new_id
FROM CommServ_Merge..CCM_MMCenteraAccessNode a, CCM_MAP_MMCenteraInfo b
		WHERE a.CenteraId = b.old_id
		OPEN CCM_MMS2CenteraAccessNodeCursor
		FETCH NEXT FROM CCM_MMS2CenteraAccessNodeCursor
		INTO @MMS2CenteraAccessNode_AccessNodeId, @MMS2CenteraAccessNode_NetHostName, @MMS2CenteraAccessNode_CenteraId, @MMS2CenteraAccessNode_newCenteraId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @MMS2CenteraAccessNode_newAccessNodeId = (SELECT TOP 1 AccessNodeId FROM MMCenteraAccessNode WHERE NetHostName = @MMS2CenteraAccessNode_NetHostName AND CenteraId = @MMS2CenteraAccessNode_newCenteraId)
			IF @MMS2CenteraAccessNode_newAccessNodeId is null
			BEGIN
				INSERT INTO MMCenteraAccessNode (NetHostName, CenteraId)
				VALUES(@MMS2CenteraAccessNode_NetHostName, @MMS2CenteraAccessNode_newCenteraId)
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMCenteraAccessNode -- INSERT'
					GOTO CX_ERROR_EXIT
				END
				SELECT @MMS2CenteraAccessNode_newAccessNodeId = @@IDENTITY
			END
			INSERT INTO CCM_MAP_MMCenteraAccessNode (old_id, new_id)
			VALUES (@MMS2CenteraAccessNode_AccessNodeId, @MMS2CenteraAccessNode_newAccessNodeId)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMCenteraAccessNode -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			FETCH NEXT FROM CCM_MMS2CenteraAccessNodeCursor
			INTO @MMS2CenteraAccessNode_AccessNodeId, @MMS2CenteraAccessNode_NetHostName, @MMS2CenteraAccessNode_CenteraId, @MMS2CenteraAccessNode_newCenteraId
		END
		CLOSE CCM_MMS2CenteraAccessNodeCursor
		DEALLOCATE CCM_MMS2CenteraAccessNodeCursor
	END
	-- End MMCenteraAccessNode --
	-- MMContainer --
IF EXISTS (SELECT * FROM CommServ_Merge..CCM_MMContainer WHERE ContainerId > 0)
	BEGIN
		DECLARE @MMS2Container_ContainerId			INTEGER
DECLARE @MMS2Container_ContainerName			varchar(256)
		DECLARE @MMS2Container_Flag					INTEGER
		DECLARE @MMS2Container_Capacity				INTEGER
		DECLARE @MMS2Container_MediaType				INTEGER
DECLARE @MMS2Container_Descript				varchar(3072)
		DECLARE @MMS2Container_CreationTime			INTEGER
		DECLARE @MMS2Container_IsEmpty				INTEGER
		DECLARE @MMS2Container_ContainerEmptyTime	INTEGER
DECLARE @MMS2Container_TrackingId			varchar(256)
		DECLARE @MMS2Container_SidbStoreId			INTEGER
		DECLARE @MMS2Container_newContainerId		INTEGER
		DECLARE @MMS2Container_newSidbStoreId		INTEGER
		DECLARE CCM_MMS2ContainerCursor Cursor LOCAL For
		SELECT distinct ContainerId, ContainerName, Flag, Capacity,
		MediaType, Descript, CreationTime, IsEmpty, ContainerEmptyTime,
		TrackingId, SidbStoreId
FROM CommServ_Merge..CCM_MMContainer
		OPEN CCM_MMS2ContainerCursor
		FETCH NEXT FROM CCM_MMS2ContainerCursor
		INTO @MMS2Container_ContainerId, @MMS2Container_ContainerName, @MMS2Container_Flag, @MMS2Container_Capacity,
		@MMS2Container_MediaType, @MMS2Container_Descript, @MMS2Container_CreationTime,
		@MMS2Container_IsEmpty, @MMS2Container_ContainerEmptyTime,
		@MMS2Container_TrackingId, @MMS2Container_SidbStoreId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @MMS2Container_newContainerId = (SELECT TOP 1 ContainerId FROM MMContainer WHERE ContainerName = @MMS2Container_ContainerName)
			IF @MMS2Container_SidbStoreId = 0
				SET @MMS2Container_newSidbStoreId = 0
			ELSE
				SET @MMS2Container_newSidbStoreId = (SELECT TOP 1 new_SidbStoreId FROM CCM_MAP_IdxSIDBStore WHERE old_SidbStoreId = @MMS2Container_SidbStoreId)
			IF @MMS2Container_newContainerId is null
			BEGIN
				SET @index = PATINDEX ('CCM[_]%', @MMS2Container_ContainerName)
				IF @index > 0
					SET @MMS2Container_ContainerName = 'CCM_' + SUBSTRING(@MMS2Container_ContainerName, @index+4, 1024)
				ELSE
					SET @MMS2Container_ContainerName = 'CCM_' + @MMS2Container_ContainerName
				INSERT INTO MMContainer (ContainerName, Flag, Capacity,
					MediaType, Descript, CreationTime,
					IsEmpty, ContainerEmptyTime,
					TrackingId, SidbStoreId)
				VALUES(@MMS2Container_ContainerName, @MMS2Container_Flag,
					@MMS2Container_Capacity, @MMS2Container_MediaType,
					@MMS2Container_Descript, @MMS2Container_CreationTime,
					@MMS2Container_IsEmpty, @MMS2Container_ContainerEmptyTime,
					@MMS2Container_TrackingId, @MMS2Container_newSidbStoreId)
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMContainer -- INSERT'
					GOTO CX_ERROR_EXIT
				END
				SELECT @MMS2Container_newContainerId = @@IDENTITY
			END
			INSERT INTO CCM_MAP_MMContainer (old_id, new_id)
			VALUES (@MMS2Container_ContainerId, @MMS2Container_newContainerId)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMContainer -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			FETCH NEXT FROM CCM_MMS2ContainerCursor
			INTO @MMS2Container_ContainerId, @MMS2Container_ContainerName, @MMS2Container_Flag,
			@MMS2Container_Capacity, @MMS2Container_MediaType, @MMS2Container_Descript,
			@MMS2Container_CreationTime, @MMS2Container_IsEmpty, @MMS2Container_ContainerEmptyTime,
			@MMS2Container_TrackingId, @MMS2Container_SidbStoreId
		END
		CLOSE CCM_MMS2ContainerCursor
		DEALLOCATE CCM_MMS2ContainerCursor
	END
	-- End MMContainer --
	-- MMExportLocation --
IF EXISTS (SELECT * FROM CommServ_Merge..CCM_MMExportLocation WHERE ExportLocationId > 0)
	BEGIN
		INSERT INTO CCM_MAP_ExportLocation
		SELECT ExportLocationId, 0, origCCId, 0, GUID, ExportLocation, 0
FROM CommServ_Merge..CCM_MMExportLocation
		IF	@@ERROR > 0
		BEGIN
		   SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_ExportLocation -- INSERT'
		   GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_ExportLocation SET new_origCCId = b.new_id
		FROM CCM_MAP_ExportLocation a, CCM_MAP_Commcell b
		WHERE a.old_origCCId = b.old_id
		IF	@@ERROR > 0
		BEGIN
		   SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_ExportLocation -- UPDATE -- new_origCCId'
		   GOTO CX_ERROR_EXIT
		END
		/*
		Should be ok to consider 'already exists' based on 'ExportLocation' name instead of GUID
		as per Rajiv
		*/
		UPDATE CCM_MAP_ExportLocation SET exist = 1
		FROM CCM_MAP_ExportLocation a, MMExportLocation b
		--WHERE a.GUID = b.GUID
		WHERE a.ExportLocation = b.ExportLocation
		IF	@@ERROR > 0
		BEGIN
		   SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_ExportLocation -- UPDATE -- exist'
		   GOTO CX_ERROR_EXIT
		END
		INSERT INTO MMExportLocation
		SELECT a.ExportLocation, a.Type, a.Descript, b.new_origCCId, a.GUID, a.modifiedTime
FROM CommServ_Merge..CCM_MMExportLocation a, CCM_MAP_ExportLocation b
		WHERE /*a.GUID = b.GUID*/a.ExportLocation = b.ExportLocation
		  AND a.origCCId = b.old_origCCId
		  AND b.exist = 0
		  AND a.ExportLocationId > 0
		IF	@@ERROR > 0
		BEGIN
		   SET @errStr = 'ERROR: CCM_Merge_MM -- MMExportLocation -- INSERT'
		   GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_ExportLocation SET new_id = b.ExportLocationId
		FROM CCM_MAP_ExportLocation a, MMExportLocation b
		/*WHERE a.GUID = b.GUID*/
		WHERE a.ExportLocation = b.ExportLocation
		IF	@@ERROR > 0
		BEGIN
		   SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_ExportLocation -- UPDATE -- new_id'
		   GOTO CX_ERROR_EXIT
		END
	END
	-- End MMExportLocation --
	-- MMMedia --
IF EXISTS (SELECT * FROM CommServ_Merge..CCM_MMMedia WHERE MediaId > 0)
	BEGIN
		DECLARE @MMS2Media_MediaId				INTEGER
DECLARE @MMS2Media_UniqueId				varchar(300)
DECLARE @MMS2Media_BarCode				varchar(256)
		DECLARE @MMS2Media_MediaTypeId			INTEGER
		DECLARE @MMS2Media_CreationTime			INTEGER
		DECLARE @MMS2Media_NumberOfReUses		INTEGER
		DECLARE @MMS2Media_LastRestoreTime		INTEGER
		DECLARE @MMS2Media_LastBackupTime		INTEGER
		DECLARE @MMS2Media_LibraryId			INTEGER
		DECLARE @MMS2Media_newLibraryId			INTEGER
		DECLARE @MMS2Media_SpareGroupId			INTEGER
		DECLARE @MMS2Media_LastExportTime		INTEGER
		DECLARE @MMS2Media_MediaLocation		INTEGER
DECLARE @MMS2Media_ExternalGUID			varchar(33)
		DECLARE @MMS2Media_MediaFlags			INTEGER
		DECLARE @MMS2Media_IsOMLWritten			INTEGER
		DECLARE @MMS2Media_MediaStatusReason	INTEGER
		DECLARE @MMS2Media_ExportLocationId		INTEGER
		DECLARE @MMS2Media_LastWriteLibraryId	INTEGER
		DECLARE @MMS2Media_Attributes			INTEGER
		DECLARE @MMS2Media_ContainerId			INTEGER
		DECLARE @MMS2Media_newContainerId		INTEGER
		DECLARE @MMS2Media_OverWriteJobId		bigint
		DECLARE @MMS2Media_origCCcommCellID		INTEGER
		DECLARE @MMS2Media_origCCmediaID		INTEGER
		DECLARE @MMS2Media_IsAged				INTEGER
		DECLARE @MMS2Media_IsInMediaGroup		INTEGER
		DECLARE @MMS2Media_NumberOfSideOverwrites INTEGER
		DECLARE @MMS2Media_newMediaId			INTEGER
		DECLARE @MMS2Media_isexist				INTEGER
		DECLARE @MMS2Media_PinMediaExpireTime INTEGER
		DECLARE @MMS2Media_newIsInMediaGroup	INTEGER
DECLARE @MMS2Media_HwEncKey				varchar(114)
		DECLARE CCM_MMS2MediaCursor Cursor LOCAL For
		SELECT distinct MediaId, UniqueId, BarCode, MediaTypeId,
		CreationTime, NumberOfReUses, LastRestoreTime, LastBackupTime,
		LibraryId, SpareGroupId, LastExportTime, MediaLocation, ExternalGUID,
		MediaFlags, IsOMLWritten, MediaStatusReason, ExportLocationId, LastWriteLibraryId,
		Attributes, ContainerId, OverWriteJobId, origCCcommCellID, origCCmediaID,
		IsAged, IsInMediaGroup, NumberOfSideOverwrites, PinMediaExpireTime, HwEncKey
FROM CommServ_Merge..CCM_MMMedia
		WHERE MediaId > 0
		OPEN CCM_MMS2MediaCursor
		FETCH NEXT FROM CCM_MMS2MediaCursor
		INTO @MMS2Media_MediaId, @MMS2Media_UniqueId, @MMS2Media_BarCode, @MMS2Media_MediaTypeId,
		@MMS2Media_CreationTime, @MMS2Media_NumberOfReUses, @MMS2Media_LastRestoreTime, @MMS2Media_LastBackupTime,
		@MMS2Media_LibraryId, @MMS2Media_SpareGroupId, @MMS2Media_LastExportTime, @MMS2Media_MediaLocation, @MMS2Media_ExternalGUID,
		@MMS2Media_MediaFlags, @MMS2Media_IsOMLWritten, @MMS2Media_MediaStatusReason, @MMS2Media_ExportLocationId, @MMS2Media_LastWriteLibraryId,
		@MMS2Media_Attributes, @MMS2Media_ContainerId, @MMS2Media_OverWriteJobId, @MMS2Media_origCCcommCellID, @MMS2Media_origCCmediaID,
		@MMS2Media_IsAged, @MMS2Media_IsInMediaGroup, @MMS2Media_NumberOfSideOverwrites, @MMS2Media_PinMediaExpireTime, @MMS2Media_HwEncKey
		WHILE @@FETCH_STATUS = 0
		BEGIN
            if @MMS2Media_origCCcommCellID = 0
	 			set @MMS2Media_origCCcommCellID = 2
		    set @new_commcellid = (select top 1 new_id from CCM_MAP_CommCell where old_id = @MMS2Media_origCCcommCellID)
 		    if @new_commcellid is null or @new_commcellid = 0
		    begin
				SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- Cannot find original APP_CommCell id '
				GOTO CX_ERROR_EXIT
		    end
			------------------------------------------------------------------------------------
			-- 07/27/2006 cliu --
			-- If Media is from Media Explorer Catalog, there will be only media id and uniqueId.
			-- Since media id is bogus, we can only use UniqueId to decide Media Mapping.
			-- Usefule info includes CommCell Mapping.
			------------------------------------------------------------------------------------
			IF @isTapeImport = 1
			BEGIN
				IF @MMS2Media_UniqueId = ''	-- Have no UniqueId info, cannot continue
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- Media from Tape Import has no UniqueId.'
					GOTO CX_ERROR_EXIT
				END
				-- UniqueId has two format, '2_BC_Barcode_x' and '100xxx_BC_Barcode_x'.
				-- First one is from 6.1 CommCell, the second is from 5.9 and migrated 6.1 CommCell.
				-- Media from Media Explorer Catalog should always be migrated to the same CommCell.
				-- Check Barcode
				DECLARE @pos2 INTEGER
				DECLARE @pos3 INTEGER
				SET @pos2 = CHARINDEX('_', @MMS2Media_UniqueId, CHARINDEX('_', @MMS2Media_UniqueId) + 1)
				SET @pos3 = CHARINDEX('_', @MMS2Media_UniqueId, @pos2 + 1)
				/*IF (SUBSTRING(@MMS2Media_UniqueId, 0, CHARINDEX('_', @MMS2Media_UniqueId)) <> '2' ) AND
					NOT EXISTS(	SELECT Id FROM APP_CommCell
								WHERE Number = CAST( SUBSTRING(@MMS2Media_UniqueId, 0, CHARINDEX('_', @MMS2Media_UniqueId)) AS INTEGER)
								AND Id = 2
						 )
				BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- Media from Media Explorer Catalog can only merge into original commcell'
						GOTO CX_ERROR_EXIT
				END*/
				SET @MMS2Media_BarCode = SUBSTRING(@MMS2Media_UniqueId, @pos2 + 1, @pos3 - @pos2 - 1)
				SET @MMS2Media_newMediaId =	(SELECT MediaId FROM MMMedia WHERE UniqueId = @MMS2Media_UniqueId)
				-- If tape/optical media dosen't exist in destination, discover the media as new first
				IF @MMS2Media_newMediaId is null
				BEGIN
					SET @MMS2Media_newMediaId = (
						SELECT MediaId FROM MMMedia WHERE BarCode = @MMS2Media_BarCode AND
						EXISTS (SELECT Number FROM CCM_MAP_CommCell WHERE old_id = @MMS2Media_origCCcommCellID AND new_id = 2)
						)
					IF @MMS2Media_newMediaId is null
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- Media from Media Explorer Catalog is not in database. Discover it as new Media first.'
						GOTO CX_ERROR_EXIT
					END
				END
				DECLARE @isMediaInMediaGroup	INTEGER
				DECLARE @isMediaAged			INTEGER
				SET	@isMediaInMediaGroup	= 0
				SET @isMediaAged			= 0
				SELECT	@isMediaAged = isAged,
						@isMediaInMediaGroup = IsInMediaGroup
				FROM		MMMedia
				WHERE		MediaId = @MMS2Media_newMediaId
				-----------------------------------------------------------------------------
				-- 1. If media is not aged and not in media group,
				-- 		it is a spare media, then continue
				--
				-- 2. If media is not aged, and all the chunk in DB are not in captured chunks
				--		media has been recycled, stop the merging
				--
				-- 3. If media is not aged, and all the chunk in DB are in captured chunks,
				-- 		media has not been recycled, continue merging the new data
				--
				-- 4. If media is not aged, and some chunks in database are not in captured chunks,
				--		captured data is not the latest one. Do catalog again.
				--
				-- 5. If media is aged, and all the chunks in DB are in captured chunks,
				--		continue merge and reset the attribute flags
				--
				-- 6. If media is aged, and all the chunk in DB are not in captured chunks
				--		media has been recycled, stop the merging
				--
				-- 7. If media is aged, and some of the chunks in DB are not in captured chunks,
				--		Delete and rediscover the media again. Then continue the merge.
				------------------------------------------------------------------------------
				-- 1.
				IF ( @isMediaAged = 0 AND @isMediaInMediaGroup = 0 )
				BEGIN
					-- Update Unique Id and Creation Time
					UPDATE MMMedia
					SET UniqueId = @MMS2Media_UniqueId, CreationTime = (CASE @MMS2Media_CreationTime
					                                                     WHEN 0 THEN CreationTime
					                                                     ELSE @MMS2Media_CreationTime
					                                                    END)
					WHERE MediaId = @MMS2Media_newMediaId
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- UPDATE Media UniqueId to [' + @MMS2Media_UniqueId + '].'
						GOTO CX_ERROR_EXIT
					END
				END
				/* Skipping these checks since tape catalog may bring partial data as we skip unsupposed application chunks.
				DECLARE @tmpChunkExist TABLE ( chunkId BIGINT, isExist INTEGER )
				IF ( @isMediaAged = 0 AND @isMediaInMediaGroup <> 0 )
				BEGIN
					INSERT	@tmpChunkExist
					SELECT	b.Id, 0
					FROM 		MMVolume a, ArchChunk b
					WHERE		a.MediaId = @MMS2Media_newMediaId
					AND			a.VolumeId = b.VolumeId
					UPDATE	@tmpChunkExist
					SET			isExist = CASE WHEN ISNULL(b.Id, 0) = 0 then 0 else 1 end
FROM		@tmpChunkExist a LEFT JOIN CommServ_Merge..CCM_ArchChunk b
					ON			a.chunkId = b.Id
					IF EXISTS( SELECT chunkId FROM @tmpChunkExist WHERE isExist = 0 )
					BEGIN
						IF EXISTS( SELECT chunkId FROM @tmpChunkExist WHERE isExist = 1)
						BEGIN
							-- 4. Some chunks in database are not in captured database
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- Media [' + @MMS2Media_UniqueId + ']: ' +
														'Some chunks in database are not in captured database. Captured Data from Media Explorer is not the latest. Please catalog the Media again.'
							GOTO CX_ERROR_EXIT
						END
						ELSE
						BEGIN
							-- 2. All chunks are not in captured chunks
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- Media [' + @MMS2Media_UniqueId + ']: ' +
														'All chunks are not in captured chunks. Media from Media Explorer Catalog has been reused. Migration cannot continue.'
							GOTO CX_ERROR_EXIT
						END
					END
					-- 3. all chunks are in captured chunks
					-- continue
				END
				IF ( @isMediaAged <> 0 )
				BEGIN
					INSERT	@tmpChunkExist
					SELECT	b.Id, 0
					FROM 		MMVolume a, ArchChunk b
					WHERE		a.MediaId = @MMS2Media_newMediaId
					AND			a.VolumeId = b.VolumeId
					UPDATE	@tmpChunkExist
					SET			isExist = CASE WHEN ISNULL(b.Id, 0) = 0 then 0 else 1 end
FROM		@tmpChunkExist a LEFT JOIN CommServ_Merge..CCM_ArchChunk b
					ON			a.chunkId = b.Id
					IF EXISTS( SELECT chunkId FROM @tmpChunkExist WHERE isExist = 0 )
					BEGIN
						IF EXISTS( SELECT chunkId FROM @tmpChunkExist WHERE isExist = 1)
						BEGIN
						   -- 7. Some chunks are not in captured database
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- Media [' + @MMS2Media_UniqueId + ']: ' +
														'Some chunks are not in captured database. Captured Data from Media Explorer may not be the latest. Please catalog the Media again.'
							GOTO CX_ERROR_EXIT
						END
						ELSE
						BEGIN
							-- 6. All chunks are not in captured database
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- Media [' + @MMS2Media_UniqueId + ']: ' +
													'All chunks are not in captured database.'
							GOTO CX_ERROR_EXIT
						END
					END
					-- 5. all the chunks are in captured chunks
					-- continue
				END
				*/
				-- Update Media isOMLValid, SideName can be kept as the same
				-- If don't mark OML as valid, media will be overwritten !!!
				UPDATE MMMediaSide SET isOMLValid = 1 WHERE MediaId = @MMS2Media_newMediaId
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- UPDATE MediaSide IsOMLValid for Media [' + @MMS2Media_UniqueId + ']'
					GOTO CX_ERROR_EXIT
				END
				-- Using Media Explorer for migration has to be the same commcell
				-- If catalog several times for one media, there will be duplicate info
				IF NOT EXISTS( SELECT * FROM CCM_MAP_MMMedia WHERE old_id = @MMS2Media_MediaId)
				BEGIN
					INSERT INTO CCM_MAP_MMMedia (old_id, new_id, isexist, isInMediaGroup)
					VALUES (@MMS2Media_MediaId, @MMS2Media_newMediaId, 2, 0)
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMMedia -- Media from Media Explorer Catalog -- INSERT'
						GOTO CX_ERROR_EXIT
					END
					-- Update Attributes
					-- If media is aged, archchunk and job should both be aged.
					-- However data still can be restored. We don't need change anything.
					-- Otherwise if update attributes here, archchunk and job info should also be updated.
					UPDATE	MMMedia
SET		Attributes = (Attributes & ~(268435456 | 134217728)) |
(CASE WHEN @tapeReusable > 0 then 268435456 else 0 end),
							IsInMediaGroup = 1
					WHERE	MediaId = @MMS2Media_newMediaId AND
							IsAged <> 1
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- UPDATE Attributes'
						GOTO CX_ERROR_EXIT
					END
					-- There is no MediaSide info, and Volume info only has VolumeName VolumeId,
					-- so cannot continue to map other tables.
					-- have to do the Volume Mapping here for ArchFile table
					DECLARE @newVolumeId INTEGER
					DECLARE @oldVolumeId INTEGER
					DECLARE @newMediaSideId INTEGER
					-- Volume from Media Explorer has UniqueId as Volume Name
					DECLARE CCM_FetchVolumeCur Cursor LOCAL For
SELECT DISTINCT VolumeId FROM CommServ_Merge..CCM_MMVolume  WHERE mediaId = @MMS2Media_MediaId
					OPEN CCM_FetchVolumeCur
					FETCH NEXT FROM CCM_FetchVolumeCur INTO @oldVolumeId
					WHILE @@FETCH_STATUS = 0
					BEGIN
					        SET @newVolumeId = null
						-- If media already exists in destination and has never been deleted, volume id should remain the same,
						-- which means media can be tape, optical or magnetic
						SELECT @newVolumeId = VolumeId FROM MMVolume
						WHERE MediaId = @MMS2Media_newMediaId AND VolumeId = @oldVolumeId
						-- If newVolumeId is null, it means volume info has been changed since the last ER backup
						-- For tape/one-side optical media, newVolumeId can be decided using new Media Id
						-- For two side optical media, if both sides have been catalogged,
						--     using Media Id can get both new Volume id, and side A has low volume Id
						-- For magnetic media,
						IF ( @newVolumeId is null )
						BEGIN
							IF EXISTS (SELECT MediaId FROM MMMedia WHERE MediaId = @MMS2Media_newMediaId AND MediaTypeId = 10001	)
							BEGIN
								-- handle case of magnetic media, error out for now
								SET @errStr = 'ERROR: CCM_Merge_MM -- Migration of Magnetic Volumes which do not exist in the target commcell is not supported.'
								GOTO CX_ERROR_EXIT
								SET @newMediaSideId = null
								SELECT @newMediaSideId = MediaSideId FROM MMMediaSide WHERE MediaId = @MMS2Media_newMediaId
								IF	@newMediaSideId is null
								BEGIN
				                	SET @errStr = 'ERROR: CCM_Merge_MM -- MMS2MediaSide -- No Media Side for Media [' + CAST(@MMS2Media_newMediaId AS varchar(64)) + ']'
				                  	GOTO CX_ERROR_EXIT
								END
								-- Insert a new Volume, if oldVolumeId is not used, keep using it. Otherwise create a new one
								IF EXISTS (SELECT VolumeName FROM MMVolume WHERE VolumeId = @oldVolumeId)
								BEGIN
									INSERT INTO MMVolume
									(
										VolumeName, CreationTime, VolumeFlags, VolumeInitialized, FlushBlockSizeKB, NumberOfRestores, NumberOfBackups, NumberOfMounts,
										NumberOfSoftErrors, NumberOfHardErrors, LastRestoreTime, LastBackupTime, LogicalBytesMB, PhysicalBytesMB, NumberOfActiveFiles,
									 	LastFile, RecordingFormatId, ExternalGUID, OMLVersion, VolumeState, VolumeFullReason, VolumeFullTime, VolumeFullJobId, origCCcommCellID,
									 	origCCvolumeID, MediaId, MediaSideId, Attributes, MediaGroupId, ReformatTime, RMSpareStatus, RMSpareStatusUpdateTime, SIDBStoreId,
										SiloStatus, CurrMountPathId, FailureErrorCode, MMSpareStatus
									)
									VALUES
									(
										'', dbo.GetUnixTime(getutcdate()), 5, 0, 64, 0, 0, 0,
										0, 0, 0, 0, 0, 0, 0,
										0, 10001, '', 2, 0, 0, 0, 0, @new_commcellid,
										0, @MMS2Media_newMediaId, @newMediaSideId, 0, 0, dbo.GetUnixTime(getutcdate()), -1, 0, 0, -1, 0, 0, 0
									)
									IF	@@ERROR > 0
									BEGIN
										SET @errStr = 'ERROR: CCM_Merge_MM -- MMVolume -- INSERT New'
										GOTO CX_ERROR_EXIT
									END
									SELECT @newVolumeId = @@IDENTITY
									UPDATE MMVolume SET VolumeName = 'V_' + CAST(@newVolumeId AS varchar(64))
									IF	@@ERROR > 0
									BEGIN
										SET @errStr = 'ERROR: CCM_Merge_MM -- MMVolume -- UPDATE VolumeName'
										GOTO CX_ERROR_EXIT
									END
								END
								ELSE -- reuse old VolumeId
								BEGIN
									SET IDENTITY_INSERT MMVolume ON
									INSERT INTO MMVolume
									(
										VolumeId, VolumeName, CreationTime, VolumeFlags, VolumeInitialized, FlushBlockSizeKB, NumberOfRestores, NumberOfBackups, NumberOfMounts,
										NumberOfSoftErrors, NumberOfHardErrors, LastRestoreTime, LastBackupTime, LogicalBytesMB, PhysicalBytesMB, NumberOfActiveFiles,
										LastFile, RecordingFormatId, ExternalGUID, OMLVersion, VolumeState, VolumeFullReason, VolumeFullTime, VolumeFullJobId, origCCcommCellID,
										origCCvolumeID, MediaId, MediaSideId, Attributes, MediaGroupId, ReformatTime, RMSpareStatus, RMSpareStatusUpdateTime, SIDBStoreId, SiloStatus,
										CurrMountPathId, FailureErrorCode, MMSpareStatus
									)
									VALUES
									(
										@oldVolumeId, 'V_' + CAST(@oldVolumeId AS varchar(64)), dbo.GetUnixTime(getutcdate()), 5, 0, 64, 0, 0, 0,
										0, 0, 0, 0, 0, 0, 0,
										0, 10001, '', 2, 0, 0, 0, 0, @new_commcellid,
										0, @MMS2Media_newMediaId, @newMediaSideId, 0, 0, dbo.GetUnixTime(getutcdate()), -1, 0, 0, -1, 0, 0, 0
									)
									IF	@@ERROR > 0
									BEGIN
										SET @errStr = 'ERROR: CCM_Merge_MM -- MMVolume -- INSERT with VolumeId'
										SET IDENTITY_INSERT MMVolume OFF
										GOTO CX_ERROR_EXIT
									END
									SET IDENTITY_INSERT MMVolume OFF
									SET @newVolumeId = @oldVolumeId
								END
							END
							ELSE -- tape/optical media
							BEGIN
								-- for now only handle tape and one-sided optical media
								DECLARE @sideCount INTEGER
								SET @sideCount = (SELECT COUNT(*) FROM MMMediaSide WHERE MediaId = @MMS2Media_newMediaId)
								IF @sideCount = 1
								BEGIN
									SET @newVolumeId = (SELECT VolumeId FROM MMVolume WHERE MediaId = @MMS2Media_newMediaId)
								END
								ELSE IF @sideCount = 2 -- multi-side (2) media
								BEGIN
									-- double sided optical media
									-- Cursor always select lower volume id first.
									-- If volume mapping exists in CCM_MAP_MMVolume, then current volume should be Side B
									-- Otherwise, current volume should be Side A with lower new volume id.
									IF EXISTS ( SELECT old_id FROM CCM_MAP_MMVolume WHERE new_mediaId = @MMS2Media_newMediaId )
									BEGIN
										-- select higher volume id
										SET @newVolumeId = (SELECT TOP 1 VolumeId FROM MMVolume WHERE MediaId = @MMS2Media_newMediaId Order By VolumeId DESC)
									END
									ELSE -- Side A with lower volume Id
									BEGIN
										SET @newVolumeId = (SELECT TOP 1 VolumeId FROM MMVolume WHERE MediaId = @MMS2Media_newMediaId Order By VolumeId)
									END
								END
								ELSE
								BEGIN
									SET @errStr = 'ERROR: CCM_Merge_MM -- Invalid Number of Media sides [' + CAST(@sideCount as varchar(11)) + '] for Media [' + @MMS2Media_UniqueId +'].'
									GOTO CX_ERROR_EXIT
								END
							END
						END
						IF (@newVolumeId is null)
						BEGIN
							SET @errStr = 'ERROR: CCM_Merge_MM -- Could not determine new volumeId.'
							GOTO CX_ERROR_EXIT
						END
						-- IF media shows as spare in db prior to migration, we need update the volume info
						IF EXISTS (SELECT VolumeId FROM MMVolume WHERE VolumeId = @newVolumeId AND MediaGroupId = 0)
						BEGIN
							-- Find a compitable media group for this volume first
							DECLARE @l_archChunkId	BIGINT
							DECLARE @l_archCopyId	INTEGER
							DECLARE @newMediaGroupId INTEGER
SET @l_archChunkId = ( SELECT TOP 1 id FROM CommServ_Merge..CCM_ArchChunk WHERE VolumeId = @oldVolumeId )
SET @l_archCopyId  = ( SELECT DISTINCT B.new_id FROM CommServ_Merge..CCM_ArchChunkMapping A, CCM_MAP_archGroupCopy B
													WHERE A.archChunkId = @l_archChunkId AND A.archCopyId=B.old_Id AND A.commCellId=B.old_origCCcommCellId )
							IF @l_archCopyId is null
							BEGIN
									SET @errStr = 'ERROR: CCM_Merge_MM -- Cannot determine the Copy for Media [' + @MMS2Media_UniqueId + '].'
									GOTO CX_ERROR_EXIT
							END
							SET @newMediaGroupId = (
								SELECT TOP 1 mg.MediaGroupId
								FROM	MMMediaGroup as mg, MMMedia as mm, MMVolume as mv, ArchStream as mas
								WHERE	mm.MediaId = @MMS2Media_newMediaId AND
											mv.VolumeId = @newVolumeId AND
											mg.SpareGroupId = mm.SpareGroupId AND
											mg.DesiredMediaTypeId = mm.MediaTypeId AND
											mg.RecordingFormatId = mv.RecordingFormatId AND
											mas.ArchGroupCopyId = @l_archCopyId AND
											mas.MediaGroupId = mg.MediaGroupId
							)
							-- There is a possiblity that the storage policy copy associated with the chunks of media is deleted
							-- In such cases, the copyId is manually updated with the id of another existing copy id in files
							-- generated by Media Explorer (ArchFileCopy.txt, ArchChunkMapping.txt, JMBkpStats.txt). Based on this
							-- new copy id, we need to select a newMediaGroupId. This is applicable only for Tape Import usecases.
							IF @newMediaGroupId is null AND @isTapeImport = 1
							BEGIN
							      SET @newMediaGroupId = (
									        SELECT TOP 1 MediaGroupId   -- Copy could have multiple stream(s) each having a media group
									        FROM ArchStream
										WHERE ArchGroupCopyId = @l_archCopyId
									       )
							    IF @newMediaGroupId is null
							    BEGIN
							      SET @errStr = 'ERROR: CCM_Merge_MM -- No Active Stream for Copy [' + CAST(@l_archCopyId AS VARCHAR) + '].'
							      GOTO CX_ERROR_EXIT
							    END
							END
							IF @newMediaGroupId is null
							BEGIN
								SET @errStr = 'ERROR: CCM_Merge_MM -- Cannot determine the Media Group for Media [' + @MMS2Media_UniqueId + '].'
								GOTO CX_ERROR_EXIT
							END
							UPDATE MMVolume
							SET MediaGroupId = @newMediaGroupId
							WHERE VolumeId = @newVolumeId
						END
						IF @isTapeImport = 0
						BEGIN
						UPDATE MMVolume SET VolumeFlags = 2, VolumeFullReason = 20 WHERE VolumeId = @newVolumeId
						END
						-- Only keep the Volume Id Mapping for CCM_Merge_ArchFile
						INSERT INTO CCM_MAP_MMVolume (old_id, new_id, old_mediasideid, new_mediasideid, old_mediaid, new_mediaid, old_mediagroupid, new_mediagroupid, exist)
						VALUES (@oldVolumeId, @newVolumeId, 0, 0, @MMS2Media_newMediaId, @MMS2Media_newMediaId, 0, 0, 1)
						IF	@@ERROR > 0
						BEGIN
							SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- Media from Tape Import -- INSERT'
							GOTO CX_ERROR_EXIT
						END
						FETCH NEXT FROM CCM_FetchVolumeCur INTO @oldVolumeId
					END
					CLOSE CCM_FetchVolumeCur
					DEALLOCATE CCM_FetchVolumeCur
				END -- After Mapping Media and Volume
				-- There is no more info for rest comparison, continue to the next
				FETCH NEXT FROM CCM_MMS2MediaCursor
				INTO @MMS2Media_MediaId, @MMS2Media_UniqueId, @MMS2Media_BarCode, @MMS2Media_MediaTypeId,
				@MMS2Media_CreationTime, @MMS2Media_NumberOfReUses, @MMS2Media_LastRestoreTime, @MMS2Media_LastBackupTime,
				@MMS2Media_LibraryId, @MMS2Media_SpareGroupId, @MMS2Media_LastExportTime, @MMS2Media_MediaLocation, @MMS2Media_ExternalGUID,
				@MMS2Media_MediaFlags, @MMS2Media_IsOMLWritten, @MMS2Media_MediaStatusReason, @MMS2Media_ExportLocationId, @MMS2Media_LastWriteLibraryId,
				@MMS2Media_Attributes, @MMS2Media_ContainerId, @MMS2Media_OverWriteJobId, @MMS2Media_origCCcommCellID, @MMS2Media_origCCmediaID,
				@MMS2Media_IsAged, @MMS2Media_IsInMediaGroup, @MMS2Media_NumberOfSideOverwrites, @MMS2Media_PinMediaExpireTime, @MMS2Media_HwEncKey
				CONTINUE
			END -- FOR isTapeImport
			-- Update Media Unique Id using original CommCell Number as prefix
			-- It can make sure no duplicate unique id after migrating from multiple CommCells.
			-- Also it will provide backward compatibility for 5.9, since in 5.9 prefix of media is always the commCell Number.
			-- Even the media prefix is like '2_' in 6.1, OML verification function considers such sutiation.
			-- -- change unique id
			-- -- select @MMS2Media_UniqueId = stuff(@MMS2Media_UniqueId, 1, len(cast(@MMS2Media_origCCcommCellID as varchar(10))), cast(@new_commcellid as varchar(10)))
			DECLARE	@commCellNumber	INTEGER
			SET		@commCellNumber	= (SELECT Number FROM CCM_MAP_CommCell WHERE old_id = @MMS2Media_origCCcommCellID)
			IF SUBSTRING( @MMS2Media_UniqueId, 1, CHARINDEX('_', @MMS2Media_UniqueId) - 1) = CAST(@MMS2Media_origCCcommCellID as varchar(10))
			BEGIN
				SELECT @MMS2Media_UniqueId = STUFF( @MMS2Media_UniqueId, 1, CHARINDEX('_', @MMS2Media_UniqueId) - 1,
																	CASE WHEN @commCellNumber = -1 THEN CAST(@new_commcellid as varchar(10))
																	ELSE CAST(@commCellNumber as varchar(10)) END)
			END
			IF @MMS2Media_MediaTypeId != 10001
				IF EXISTS (SELECT * FROM MMMedia WHERE BarCode = @MMS2Media_BarCode
									 AND NOT(((origCCcommCellID = @new_commcellid) OR (origCCcommCellID = 0 AND @new_commcellId = 2))))
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- BarCode Collision on ' + @MMS2Media_BarCode
					GOTO CX_ERROR_EXIT
				END
			ELSE
				IF EXISTS (SELECT * FROM MMMedia WHERE UniqueId = @MMS2Media_UniqueId
									 AND NOT(((origCCcommCellID = @new_commcellid) OR (origCCcommCellID = 0 AND @new_commcellId = 2))))
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- UniqueId Collision on ' + @MMS2Media_UniqueId
					GOTO CX_ERROR_EXIT
				END
			IF @MMS2Media_MediaTypeId != 10001
				SET @MMS2Media_newMediaId  = (SELECT top 1 MediaId FROM MMMedia WHERE BarCode = @MMS2Media_BarCode)
			ELSE
				-- If the unique id of magnetic media is '2_XXX', we replace it with current commcell number.
				-- Therefore, simply comparing unique id is not enough
				SET @MMS2Media_newMediaId  = (SELECT top 1 MediaId FROM MMMedia
																			WHERE (UniqueId = @MMS2Media_UniqueId AND ((origCCcommCellID = @new_commcellid) OR (origCCcommCellID = 0 AND @new_commcellid = 2)))
																			OR (UniqueId = STUFF( @MMS2Media_UniqueId, 1, CHARINDEX('_', @MMS2Media_UniqueId) - 1, CAST(@new_commcellid as varchar(10))))
																			)
			IF @tapeReusable > 0
set @MMS2Media_Attributes = @MMS2Media_Attributes | 268435456
			ELSE
set @MMS2Media_Attributes = @MMS2Media_Attributes & ~268435456
			IF @MMS2Media_newMediaId is null
			BEGIN
				SET	@MMS2Media_isexist = 0
				-- Keep tracking the media attributes for whether can merge Volumes later (Media in MediaGroup)
				-- Media & Volume can be safely migrated
				SET @MMS2Media_newIsInMediaGroup = 0
				if exists (select * from MMMedia where mediaid = @MMS2Media_MediaId)
				begin
					-- new media --
					-- reset following attributes while inserting
					-- MMS2_PINNED_FOR_RECALL
					-- MMS2_PINNED
					INSERT INTO MMMedia (UniqueId, BarCode, MediaTypeId,
					CreationTime, NumberOfReUses, LastRestoreTime, LastBackupTime,
					LibraryId, SpareGroupId, LastExportTime, MediaLocation, ExternalGUID,
					MediaFlags, IsOMLWritten, MediaStatusReason, ExportLocationId, LastWriteLibraryId,
					Attributes, ContainerId, OverWriteJobId, origCCcommCellID, origCCmediaID, Descript, NumberOfSideOverwrites, ScheduleRunId, retentionFlags, retentionExpireTime,
					IsAged, IsInMediaGroup, PinMediaExpireTime, origSpareGroupId, RMSpareStatus, RMSpareStatusUpdateTime, ExtendedAttributes, minRetentionTime, HwEncKey)
					VALUES(@MMS2Media_UniqueId, @MMS2Media_BarCode, @MMS2Media_MediaTypeId,
					@MMS2Media_CreationTime, @MMS2Media_NumberOfReUses, @MMS2Media_LastRestoreTime, @MMS2Media_LastBackupTime,
					0, 0, @MMS2Media_LastExportTime, 3, @MMS2Media_ExternalGUID,
					@MMS2Media_MediaFlags, @MMS2Media_IsOMLWritten, @MMS2Media_MediaStatusReason, 0, 0,
@MMS2Media_Attributes & ~(134217728 | 16777216 | 536870912), 0, 0, @new_commcellid, @MMS2Media_MediaId, '', @MMS2Media_NumberOfSideOverwrites, 0, 0, 0, @MMS2Media_IsAged, @MMS2Media_IsInMediaGroup, @MMS2Media_PinMediaExpireTime, 0, -1, 0, 0, 0, @MMS2Media_HwEncKey)
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- INSERT'
						GOTO CX_ERROR_EXIT
					END
					SELECT @MMS2Media_newMediaId = @@IDENTITY
				end
				else
				begin
					-- new media, but use the same media id --
					SET IDENTITY_INSERT MMMedia ON
					-- reset following attributes
					-- MMS2_PINNED_FOR_RECALL
					-- MMS2_PINNED
					INSERT INTO MMMedia (MediaId, UniqueId, BarCode, MediaTypeId,
					CreationTime, NumberOfReUses, LastRestoreTime, LastBackupTime,
					LibraryId, SpareGroupId, LastExportTime, MediaLocation, ExternalGUID,
					MediaFlags, IsOMLWritten, MediaStatusReason, ExportLocationId, LastWriteLibraryId,
					Attributes, ContainerId, OverWriteJobId, origCCcommCellID, origCCmediaID, Descript, NumberOfSideOverwrites, ScheduleRunId, retentionFlags, retentionExpireTime,
					IsAged, IsInMediaGroup, PinMediaExpireTime, origSpareGroupId, RMSpareStatus, RMSpareStatusUpdateTime, ExtendedAttributes, minRetentionTime, HwEncKey)
					VALUES(@MMS2Media_MediaId, @MMS2Media_UniqueId, @MMS2Media_BarCode, @MMS2Media_MediaTypeId,
					@MMS2Media_CreationTime, @MMS2Media_NumberOfReUses, @MMS2Media_LastRestoreTime, @MMS2Media_LastBackupTime,
					0, 0, @MMS2Media_LastExportTime, 3, @MMS2Media_ExternalGUID,
					@MMS2Media_MediaFlags, @MMS2Media_IsOMLWritten, @MMS2Media_MediaStatusReason, 0, 0,
@MMS2Media_Attributes & ~(134217728 | 16777216 | 536870912), 0, 0, @new_commcellid, @MMS2Media_MediaId, '', @MMS2Media_NumberOfSideOverwrites, 0, 0, 0, @MMS2Media_IsAged, @MMS2Media_IsInMediaGroup, @MMS2Media_PinMediaExpireTime, 0, -1, 0, 0, 0, @MMS2Media_HwEncKey)
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- INSERT'
						SET IDENTITY_INSERT MMMedia OFF
						GOTO CX_ERROR_EXIT
					END
					SET IDENTITY_INSERT MMMedia OFF
					SELECT @MMS2Media_newMediaId = @MMS2Media_MediaId
				end
			END
			ELSE
			BEGIN
				SET	@MMS2Media_isexist = 1
				-- Keep tracking the media attributes for whether can merge Volumes later (Media in MediaGroup)
				-- Media & Volume can be safely migrated based on current IsInMediaGroup value
				SELECT @MMS2Media_newIsInMediaGroup = IsInMediaGroup FROM MMMedia WHERE MediaId = @MMS2Media_newMediaId
				UPDATE MMMedia
				SET NumberOfReUses = @MMS2Media_NumberOfReUses,
				LastRestoreTime = @MMS2Media_LastRestoreTime,
				LastBackupTime = @MMS2Media_LastBackupTime,
				LastExportTime = @MMS2Media_LastExportTime,
				MediaFlags = CASE @MMS2Media_MediaTypeId WHEN 10001 THEN MediaFlags ELSE @MMS2Media_MediaFlags END,
				IsOMLWritten = @MMS2Media_IsOMLWritten,
				MediaStatusReason = @MMS2Media_MediaStatusReason,
				Attributes = @MMS2Media_Attributes,
				NumberOfSideOverwrites = @MMS2Media_NumberOfSideOverwrites,
				IsAged = @MMS2Media_IsAged,
				IsInMediaGroup = @MMS2Media_IsInMediaGroup,
				origCCcommCellId = @new_commcellId,
				HwEncKey = @MMS2Media_HwEncKey
				WHERE MediaId = @MMS2Media_newMediaId
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- UPDATE'
					GOTO CX_ERROR_EXIT
				END
			END
			--update MMMedia
			--set Descript = (select Descript FROM Commserv_Merge..CCM_MMMedia WHERE MediaId = @MMS2Media_MediaId)
			--WHERE MediaId = @MMS2Media_newMediaId
			IF @MMS2Media_LibraryId > 0
			BEGIN
				SELECT @MMS2Media_newLibraryId = new_LibraryId FROM CCM_Map_Library WHERE old_LibraryId = @MMS2Media_LibraryId
				IF @MMS2Media_newLibraryId IS NULL OR @MMS2Media_newLibraryId = 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- New id for old libraryId ['+@MMS2Media_LibraryId+'] not found'
					GOTO CX_ERROR_EXIT
				END
				UPDATE MMMedia
				SET LibraryId = @MMS2Media_newLibraryId
				WHERE MediaId = @MMS2Media_newMediaId AND LibraryId=0
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMMedia -- Update LibraryId'
					GOTO CX_ERROR_EXIT
				END
			END
			INSERT INTO CCM_MAP_MMMedia (old_id, new_id, isexist, isInMediaGroup)
			VALUES (@MMS2Media_MediaId, @MMS2Media_newMediaId, @MMS2Media_isexist, @MMS2Media_newIsInMediaGroup)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMMedia -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			IF @MMS2Media_MediaTypeId = 10001
			BEGIN
				UPDATE MMMedia
				SET SpareGroupId = 0,
				-- library is set during mount path merge --
				-- MEDIA_FLAG_READONLY --
				-- If migration is in the same commcell, the mount path still need to be used for backup
				MediaFlags = CASE @new_commcellid WHEN 2 THEN MediaFlags ELSE 4 END
				WHERE MediaId = @MMS2Media_newMediaId
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- UPDATE'
					GOTO CX_ERROR_EXIT
				END
			END
			-- figure out containerid and exportlocationid
			SET @MMS2Media_newContainerId = ISNULL((SELECT new_id FROM CCM_MAP_MMContainer WHERE old_id = @MMS2Media_ContainerId), 0)
			IF @MMS2Media_newContainerId > 0
			BEGIN
				UPDATE MMMedia
				SET	ContainerId = @MMS2Media_newContainerId
				WHERE MediaId = @MMS2Media_newMediaId
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- UPDATE ContainerId'
					GOTO CX_ERROR_EXIT
				END
			END
			IF @MMS2Media_ExportLocationId > 0
			BEGIN
				UPDATE MMMedia
				SET	ExportLocationId = (SELECT isnull(new_id, 0) FROM CCM_MAP_ExportLocation WHERE old_id = @MMS2Media_ExportLocationId)
				WHERE MediaId = @MMS2Media_newMediaId
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- UPDATE ExportLocationId'
					GOTO CX_ERROR_EXIT
				END
			END
			FETCH NEXT FROM CCM_MMS2MediaCursor
			INTO @MMS2Media_MediaId, @MMS2Media_UniqueId, @MMS2Media_BarCode, @MMS2Media_MediaTypeId,
			@MMS2Media_CreationTime, @MMS2Media_NumberOfReUses, @MMS2Media_LastRestoreTime, @MMS2Media_LastBackupTime,
			@MMS2Media_LibraryId, @MMS2Media_SpareGroupId, @MMS2Media_LastExportTime, @MMS2Media_MediaLocation, @MMS2Media_ExternalGUID,
			@MMS2Media_MediaFlags, @MMS2Media_IsOMLWritten, @MMS2Media_MediaStatusReason, @MMS2Media_ExportLocationId, @MMS2Media_LastWriteLibraryId,
			@MMS2Media_Attributes, @MMS2Media_ContainerId, @MMS2Media_OverWriteJobId, @MMS2Media_origCCcommCellID, @MMS2Media_origCCmediaID,
			@MMS2Media_IsAged, @MMS2Media_IsInMediaGroup, @MMS2Media_NumberOfSideOverwrites, @MMS2Media_PinMediaExpireTime, @MMS2Media_HwEncKey
		END
		CLOSE CCM_MMS2MediaCursor
		DEALLOCATE CCM_MMS2MediaCursor
	END
	-- End MMMedia --
	-- MMMediaSide --
IF EXISTS (SELECT * FROM CommServ_Merge..CCM_MMMediaSide WHERE MediaSideId > 0)
	BEGIN
		DECLARE @MMS2MediaSide_MediaSideId			INTEGER
		DECLARE @MMS2MediaSide_MediaId				INTEGER
DECLARE @MMS2MediaSide_SideName				varchar(80)
		DECLARE @MMS2MediaSide_MediaSideFlags		INTEGER
		DECLARE @MMS2MediaSide_NumberOfRestores		INTEGER
		DECLARE @MMS2MediaSide_NumberOfBackups		INTEGER
		DECLARE @MMS2MediaSide_NumberOfMounts		INTEGER
		DECLARE @MMS2MediaSide_NumberOfSoftErrors	INTEGER
		DECLARE @MMS2MediaSide_NumberOfHardErrors	INTEGER
		DECLARE @MMS2MediaSide_NumberOfReUses		INTEGER
		DECLARE @MMS2MediaSide_LastRestoreTime		INTEGER
		DECLARE @MMS2MediaSide_LastBackupTime		INTEGER
		DECLARE @MMS2MediaSide_TotalSpaceMB			BIGINT
		DECLARE @MMS2MediaSide_FreeBytesMB			BIGINT
		DECLARE @MMS2MediaSide_LogicalBytesMB		INTEGER
		DECLARE @MMS2MediaSide_PhysicalBytesMB		INTEGER
		DECLARE @MMS2MediaSide_IsOMLValid			INTEGER
DECLARE @MMS2MediaSide_FailureReason		varchar(64)
DECLARE @MMS2MediaSide_ExternalGUID			varchar(33)
		DECLARE @MMS2MediaSide_IsOMLWritten			INTEGER
		DECLARE @MMS2MediaSide_isErasable			INTEGER
		DECLARE @MMS2MediaSide_UploadDataMB			INTEGER
		DECLARE @MMS2MediaSide_DownloadDataMB		INTEGER
		DECLARE @MMS2MediaSide_newMediaId			INTEGER
		DECLARE @MMS2MediaSide_isExist				INTEGER
		DECLARE @MMS2MediaSide_newMediaSideId		INTEGER
		DECLARE @MMS2MediaSide_isMediaExist			INTEGER
		declare @mediaSideCount integer
		declare @bSecondSide integer
		set @mediaSideCount = 0
		set @bSecondSide = 0
		DECLARE CCM_MMS2MediaSideCursor Cursor LOCAL For
		SELECT distinct a.MediaSideId, a.MediaId, a.SideName, a.MediaSideFlags,
		a.NumberOfRestores, a.NumberOfBackups, a.NumberOfMounts,
		a.NumberOfSoftErrors, a.NumberOfHardErrors, a.NumberOfReUses,
		a.LastRestoreTime, a.LastBackupTime, a.TotalSpaceMB, a.FreeBytesMB,
		a.LogicalBytesMB, a.PhysicalBytesMB, a.IsOMLValid, a.FailureReason,
		a.ExternalGUID, a.IsOMLWritten, a.isErasable, a.UploadDataMB, a.DownloadDataMB, b.new_id, b.isexist
FROM CommServ_Merge..CCM_MMMediaSide a, CCM_MAP_MMMedia b
		WHERE a.MediaSideId > 0
		AND	a.MediaId = b.old_id
		OPEN CCM_MMS2MediaSideCursor
		FETCH NEXT FROM CCM_MMS2MediaSideCursor
		INTO @MMS2MediaSide_MediaSideId, @MMS2MediaSide_MediaId, @MMS2MediaSide_SideName, @MMS2MediaSide_MediaSideFlags,
		@MMS2MediaSide_NumberOfRestores, @MMS2MediaSide_NumberOfBackups, @MMS2MediaSide_NumberOfMounts,
		@MMS2MediaSide_NumberOfSoftErrors, @MMS2MediaSide_NumberOfHardErrors, @MMS2MediaSide_NumberOfReUses,
		@MMS2MediaSide_LastRestoreTime, @MMS2MediaSide_LastBackupTime, @MMS2MediaSide_TotalSpaceMB, @MMS2MediaSide_FreeBytesMB,
		@MMS2MediaSide_LogicalBytesMB, @MMS2MediaSide_PhysicalBytesMB, @MMS2MediaSide_IsOMLValid, @MMS2MediaSide_FailureReason,
		@MMS2MediaSide_ExternalGUID, @MMS2MediaSide_IsOMLWritten, @MMS2MediaSide_isErasable, @MMS2MediaSide_UploadDataMB, @MMS2MediaSide_DownloadDataMB, @MMS2MediaSide_newMediaId, @MMS2MediaSide_isMediaExist
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF @MMS2MediaSide_isMediaExist = 0
			BEGIN
				-- declare @MMS2MediaSide_newMediaSideId2 integer
				-- select @MMS2MediaSide_newMediaSideId2 = 1 + isnull(max(MediaSideId), 0)
				-- from MMMediaSide
				-- if @MMS2MediaSide_newMediaSideId2 is null or @MMS2MediaSide_newMediaSideId2 <= 0
				--	set @MMS2MediaSide_newMediaSideId2 = 1
				-- normally a mediasideId looks like A_1234 - with the side letter first
				-- however, really old backups have the side letter at the end - and for reading OMLs we have 2 different routines to check this.
				-- for such really old data, leave the sidename as is, do not change. This has been tested to work.
				if (right(@MMS2MediaSide_SideName,1) not in ('A', 'B'))
				begin
					-- select @MMS2MediaSide_SideName = stuff(@MMS2MediaSide_SideName, len(@MMS2MediaSide_SideName)-len(cast(@MMS2MediaSide_MediaSideId as varchar(10)))+1, len(@MMS2MediaSide_SideName), cast(@MMS2MediaSide_newMediaSideId2 as varchar(10)))
					select @MMS2MediaSide_SideName = stuff(@MMS2MediaSide_SideName, len(@MMS2MediaSide_SideName)-len(cast(@MMS2MediaSide_MediaId as varchar(10)))+1, len(@MMS2MediaSide_SideName), cast(@MMS2MediaSide_newMediaId as varchar(10)))
				end
				--
				-- change the creation SideName to use Media Id from Media Side Id
				SET @MMS2MediaSide_isExist = 0
				if exists (select * from MMMediaSide where mediasideid = @MMS2MediaSide_MediaSideId)
				begin
					-- new media side --
					INSERT INTO MMMediaSide (MediaId, SideName, MediaSideFlags,
						NumberOfRestores, NumberOfBackups, NumberOfMounts,
						NumberOfSoftErrors, NumberOfHardErrors, NumberOfReUses,
						LastRestoreTime, LastBackupTime, TotalSpaceMB, FreeBytesMB,
						LogicalBytesMB, PhysicalBytesMB, IsOMLValid, FailureReason,
						ExternalGUID, IsOMLWritten, isErasable, UploadDataMB, DownloadDataMB)
					VALUES(@MMS2MediaSide_newMediaId, @MMS2MediaSide_SideName, @MMS2MediaSide_MediaSideFlags,
					@MMS2MediaSide_NumberOfRestores, @MMS2MediaSide_NumberOfBackups, @MMS2MediaSide_NumberOfMounts,
					@MMS2MediaSide_NumberOfSoftErrors, @MMS2MediaSide_NumberOfHardErrors, @MMS2MediaSide_NumberOfReUses,
					@MMS2MediaSide_LastRestoreTime, @MMS2MediaSide_LastBackupTime, @MMS2MediaSide_TotalSpaceMB, @MMS2MediaSide_FreeBytesMB,
					@MMS2MediaSide_LogicalBytesMB, @MMS2MediaSide_PhysicalBytesMB, @MMS2MediaSide_IsOMLValid, @MMS2MediaSide_FailureReason,
					@MMS2MediaSide_ExternalGUID, @MMS2MediaSide_IsOMLWritten, @MMS2MediaSide_isErasable, @MMS2MediaSide_UploadDataMB, @MMS2MediaSide_DownloadDataMB)
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMMediaSide -- INSERT'
						GOTO CX_ERROR_EXIT
					END
					SELECT @MMS2MediaSide_newMediaSideId  = @@IDENTITY
					-- if @MMS2MediaSide_newMediaSideId != @MMS2MediaSide_newMediaSideId2
					-- begin
					--	select @MMS2MediaSide_SideName = stuff(@MMS2MediaSide_SideName, len(@MMS2MediaSide_SideName)-len(cast(@MMS2MediaSide_newMediaSideId2 as varchar(10)))+1, len(@MMS2MediaSide_SideName), cast(@MMS2MediaSide_newMediaSideId as varchar(10)))
					--	update MMMediaSide set sidename = @MMS2MediaSide_SideName where mediasideid = @MMS2MediaSide_newMediaSideId
					-- end
				end
				else
				begin
					SET IDENTITY_INSERT MMMediaSide ON
					-- new media side --
					INSERT INTO MMMediaSide (MediaSideId, MediaId, SideName, MediaSideFlags,
						NumberOfRestores, NumberOfBackups, NumberOfMounts,
						NumberOfSoftErrors, NumberOfHardErrors, NumberOfReUses,
						LastRestoreTime, LastBackupTime, TotalSpaceMB, FreeBytesMB,
						LogicalBytesMB, PhysicalBytesMB, IsOMLValid, FailureReason,
						ExternalGUID, IsOMLWritten, isErasable, UploadDataMB, DownloadDataMB)
					VALUES(@MMS2MediaSide_MediaSideId, @MMS2MediaSide_newMediaId, @MMS2MediaSide_SideName, @MMS2MediaSide_MediaSideFlags,
					@MMS2MediaSide_NumberOfRestores, @MMS2MediaSide_NumberOfBackups, @MMS2MediaSide_NumberOfMounts,
					@MMS2MediaSide_NumberOfSoftErrors, @MMS2MediaSide_NumberOfHardErrors, @MMS2MediaSide_NumberOfReUses,
					@MMS2MediaSide_LastRestoreTime, @MMS2MediaSide_LastBackupTime, @MMS2MediaSide_TotalSpaceMB, @MMS2MediaSide_FreeBytesMB,
					@MMS2MediaSide_LogicalBytesMB, @MMS2MediaSide_PhysicalBytesMB, @MMS2MediaSide_IsOMLValid, @MMS2MediaSide_FailureReason,
					@MMS2MediaSide_ExternalGUID, @MMS2MediaSide_IsOMLWritten, @MMS2MediaSide_isErasable, @MMS2MediaSide_UploadDataMB, @MMS2MediaSide_DownloadDataMB)
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMMediaSide -- INSERT'
						SET IDENTITY_INSERT MMMediaSide OFF
						GOTO CX_ERROR_EXIT
					END
					SET IDENTITY_INSERT MMMediaSide OFF
					SELECT @MMS2MediaSide_newMediaSideId  = @MMS2MediaSide_MediaSideId
					-- if @MMS2MediaSide_newMediaSideId != @MMS2MediaSide_newMediaSideId2
					-- begin
					--	select @MMS2MediaSide_SideName = stuff(@MMS2MediaSide_SideName, len(@MMS2MediaSide_SideName)-len(cast(@MMS2MediaSide_newMediaSideId2 as varchar(10)))+1, len(@MMS2MediaSide_SideName), cast(@MMS2MediaSide_newMediaSideId as varchar(10)))
					--	update MMMediaSide set sidename = @MMS2MediaSide_SideName where mediasideid = @MMS2MediaSide_newMediaSideId
					-- end
				end
			END
			ELSE
			BEGIN
				SET @MMS2MediaSide_isExist = 1
				select @mediaSideCount = count(*) from MMMediaSide where mediaid = @MMS2MediaSide_newMediaId
				if @mediaSideCount = 1
				begin
					select @MMS2MediaSide_newMediaSideId = mediasideid from MMMediaSide where mediaid = @MMS2MediaSide_newMediaId
				end
				if @mediaSideCount = 2 and @bSecondSide = 0
				begin
					select @MMS2MediaSide_newMediaSideId = min(mediasideid) from MMMediaSide where mediaid = @MMS2MediaSide_newMediaId
					set @bSecondSide = 1
				end
				if @mediaSideCount = 2 and @bSecondSide = 1
				begin
					select @MMS2MediaSide_newMediaSideId = max(mediasideid) from MMMediaSide where mediaid = @MMS2MediaSide_newMediaId
					set @bSecondSide = 0
				end
				-- media side already exist --
				UPDATE MMMediaSide
				SET MediaSideFlags = @MMS2MediaSide_MediaSideFlags,
				NumberOfRestores = @MMS2MediaSide_NumberOfRestores,
				NumberOfBackups = @MMS2MediaSide_NumberOfBackups,
				NumberOfMounts = @MMS2MediaSide_NumberOfMounts,
				NumberOfSoftErrors = @MMS2MediaSide_NumberOfSoftErrors,
				NumberOfHardErrors = @MMS2MediaSide_NumberOfHardErrors,
				NumberOfReUses = @MMS2MediaSide_NumberOfReUses,
				LastRestoreTime = @MMS2MediaSide_LastRestoreTime,
				LastBackupTime = @MMS2MediaSide_LastBackupTime,
				TotalSpaceMB = @MMS2MediaSide_TotalSpaceMB,
				FreeBytesMB = @MMS2MediaSide_FreeBytesMB,
				LogicalBytesMB = @MMS2MediaSide_LogicalBytesMB,
				PhysicalBytesMB = @MMS2MediaSide_PhysicalBytesMB,
				IsOMLValid = @MMS2MediaSide_IsOMLValid,
				FailureReason = @MMS2MediaSide_FailureReason,
				ExternalGUID = @MMS2MediaSide_ExternalGUID,
				IsOMLWritten = @MMS2MediaSide_IsOMLWritten,
				isErasable = @MMS2MediaSide_isErasable,
				UploadDataMB = @MMS2MediaSide_UploadDataMB,
				DownloadDataMB = @MMS2MediaSide_DownloadDataMB
				WHERE MediaSideId = @MMS2MediaSide_newMediaSideId
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMediaSide -- UPDATE'
					GOTO CX_ERROR_EXIT
				END
			END
			INSERT INTO CCM_MAP_MMMediaSide (old_id, new_id, old_mediaid, new_mediaid, isexist)
			VALUES (@MMS2MediaSide_MediaSideId, @MMS2MediaSide_newMediaSideId, @MMS2MediaSide_MediaId, @MMS2MediaSide_newMediaId, @MMS2MediaSide_isExist)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMMediaSide -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			FETCH NEXT FROM CCM_MMS2MediaSideCursor
			INTO @MMS2MediaSide_MediaSideId, @MMS2MediaSide_MediaId, @MMS2MediaSide_SideName, @MMS2MediaSide_MediaSideFlags,
			@MMS2MediaSide_NumberOfRestores, @MMS2MediaSide_NumberOfBackups, @MMS2MediaSide_NumberOfMounts,
			@MMS2MediaSide_NumberOfSoftErrors, @MMS2MediaSide_NumberOfHardErrors, @MMS2MediaSide_NumberOfReUses,
			@MMS2MediaSide_LastRestoreTime, @MMS2MediaSide_LastBackupTime, @MMS2MediaSide_TotalSpaceMB, @MMS2MediaSide_FreeBytesMB,
			@MMS2MediaSide_LogicalBytesMB, @MMS2MediaSide_PhysicalBytesMB, @MMS2MediaSide_IsOMLValid, @MMS2MediaSide_FailureReason,
			@MMS2MediaSide_ExternalGUID, @MMS2MediaSide_IsOMLWritten, @MMS2MediaSide_isErasable, @MMS2MediaSide_UploadDataMB, @MMS2MediaSide_DownloadDataMB, @MMS2MediaSide_newMediaId, @MMS2MediaSide_isMediaExist
		END
		CLOSE CCM_MMS2MediaSideCursor
		DEALLOCATE CCM_MMS2MediaSideCursor
	END
	-- End MMMediaSide --
	-- MMMountPath --
IF EXISTS (SELECT * FROM CommServ_Merge..CCM_MMMountPath WHERE MountPathId > 0)
	BEGIN
		DECLARE @MMS2MountPath_MountPathId						INTEGER
DECLARE @MMS2MountPath_MountPathName					varchar(1024)
		DECLARE @MMS2MountPath_MediaSideId						INTEGER
DECLARE @MMS2MountPath_UserName							varchar(1024)
DECLARE @MMS2MountPath_UserPassword						varchar(2048)
		DECLARE @MMS2MountPath_IsEnabled						INTEGER
		DECLARE @MMS2MountPath_NumberOfWriters					INTEGER
		DECLARE @MMS2MountPath_MaxConcurrentWriters				INTEGER
		DECLARE @MMS2MountPath_CurrentFileMarker				INTEGER
		DECLARE @MMS2MountPath_IsOffline						INTEGER
		DECLARE @MMS2MountPath_OfflineReason					INTEGER
		DECLARE @MMS2MountPath_MountPathTypeId					INTEGER
		DECLARE @MMS2MountPath_OffLineTimeStamp					INTEGER
		DECLARE @MMS2MountPath_origCCcommCellID					INTEGER
		DECLARE @MMS2MountPath_origCCmediaSideID				INTEGER
		DECLARE @MMS2MountPath_MaxDataToWriteMB					INTEGER
		DECLARE @MMS2MountPath_MagneticSpaceRsrvInMB			INTEGER
		DECLARE @MMS2MountPath_Attribute						INTEGER
		DECLARE @MMS2MountPath_newMediaSideId					INTEGER
		DECLARE @MMS2MountPath_newMountPathId					INTEGER
		DECLARE @MMS2MountPath_newLibraryId						INTEGER
DECLARE @MMS2MountPath_newMountPathName					varchar(1024)
DECLARE @MMS2MountPath_newUserName							varchar(1024)
DECLARE @MMS2MountPath_newUserPassword						varchar(2048)
		DECLARE @MMS2MountPath_isExist							INTEGER
		DECLARE @MMS2MountPath_origCCMountPathID		INTEGER
		DECLARE @MMS2MountPath_MagneticChunkFileIncrSizeMB	INTEGER
		DECLARE @MMS2MountPath_newDeviceAccess				INTEGER
		DECLARE @MMS2MountPath_newDeviceAttributes			INTEGER
		--DECLARE @commcellNum                                INTEGER
		DECLARE @targetLibraryId                            INTEGER
		DECLARE @targetMediaAgentId                         INTEGER
		--SET @commcellNum = (SELECT number FROM CCM_DB_APP_COMMCELL WHERE id = 2 and type = 1)
UPDATE CommServ_Merge..CCM_MMMountPath
		SET    origCCcommCellID = 2
		WHERE  origCCcommCellID = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MMMountPath -- UPDATE -- origCCcommCellID'
			GOTO CX_ERROR_EXIT
		END
UPDATE CommServ_Merge..CCM_MMMountPath
		SET    origCCmediaSideID = MediaSideId
		WHERE  origCCmediaSideID = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MMMountPath -- UPDATE -- origCCmediaSideID'
			GOTO CX_ERROR_EXIT
		END
UPDATE CommServ_Merge..CCM_MMMountPath
		SET    origCCMountPathID = MountPathId
		WHERE  origCCMountPathID = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MMMountPath -- UPDATE -- origCCMountPathID'
			GOTO CX_ERROR_EXIT
		END
		/*PrasadNara 12:28 PM 7/26/2012
		 * If a magnetic mount path is mapped to cloud library then fail the merge
		 * If a cloud mount path is mapped to magnetic library then check other mount paths of the library have data,
		 * if they have data then fail the merge, otherwise go ahead with merge and mark the other mountpaths readonly
		 */
		IF EXISTS(
			SELECT 1
FROM CommServ_Merge..CCM_MMMountPath a
INNER JOIN CommServ_Merge..CCM_MountPathMapping b ON a.MountPathId = b.MountPathId
				INNER JOIN MMLibrary c ON b.newLibraryId = c.LibraryId
				INNER JOIN MMMountPath d ON c.LibraryId = d.LibraryId
			WHERE a.MountPathTypeId <> 7 AND d.MountPathTypeId = 7   --"MOUNT_PATH_EXTERNAL_REMOTE_HOST"
		)
		BEGIN
			SET @errStr = 'ERROR: Mapping non-cloud mount path to a cloud library is not supported, Please remap the below mount paths to proper library.'+ CHAR(13) + CHAR(10)
			SELECT @errStr = @errStr + 'MountPath [' + a.MountPathName + '], Device ['+ b.SourceDeviceName +']'
FROM CommServ_Merge..CCM_MMMountPath a
INNER JOIN CommServ_Merge..CCM_MountPathMapping b ON a.MountPathId = b.MountPathId
				INNER JOIN MMLibrary c ON b.newLibraryId = c.LibraryId
			WHERE a.MountPathTypeId <> 7 AND EXISTS(SELECT 1 FROM MMMountPath d WHERE d.LibraryId = c.LibraryId AND d.MountPathTypeId = 7)
			GOTO CX_ERROR_EXIT
		END
		IF OBJECT_ID('tempdb.dbo.#MountPathsToMarkReadOnly') IS NOT NULL DROP TABLE #MountPathsToMarkReadOnly
		CREATE TABLE #MountPathsToMarkReadOnly (mountPathId int, mediaSideId int)
		INSERT INTO #MountPathsToMarkReadOnly
		SELECT d.MountPathId, d.MediaSideId
FROM CommServ_Merge..CCM_MMMountPath a
INNER JOIN CommServ_Merge..CCM_MountPathMapping b ON a.MountPathId = b.MountPathId
			INNER JOIN MMLibrary c ON b.newLibraryId = c.LibraryId
			INNER JOIN MMMountPath d ON c.LibraryId = d.LibraryId
		WHERE a.MountPathTypeId = 7 AND d.MountPathTypeId <> 7   --"MOUNT_PATH_EXTERNAL_REMOTE_HOST"
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_MM -- #MountPathsToMarkReadOnly -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		IF EXISTS(SELECT 1 FROM #MountPathsToMarkReadOnly)
		BEGIN
			IF EXISTS(
				SELECT 1 FROM #MountPathsToMarkReadOnly a
					INNER JOIN MMMediaSide b ON a.MediaSideId = b.MediaSideId
					INNER JOIN MMVolume c WITH(READUNCOMMITTED) ON b.MediaId = c.MediaId
			)
			BEGIN
				SET @errStr = 'ERROR: Mapping cloud mount path to a non-cloud library having data is not supported, Please remap the below mount paths to proper library.'+ CHAR(13) + CHAR(10)
				SELECT @errStr = @errStr + 'MountPath [' + a.MountPathName + '], Device ['+ b.SourceDeviceName +']'
FROM CommServ_Merge..CCM_MMMountPath a
INNER JOIN CommServ_Merge..CCM_MountPathMapping b ON a.MountPathId = b.MountPathId
					INNER JOIN MMLibrary c ON b.newLibraryId = c.LibraryId
				WHERE a.MountPathTypeId = 7 AND
					EXISTS(
						SELECT 1 FROM MMMountPath d INNER JOIN MMMediaSide e ON d.MediaSideId = e.MediaSideId
							INNER JOIN MMVolume f WITH(READUNCOMMITTED) ON e.MediaId = f.MediaId
						WHERE d.LibraryId = c.LibraryId AND d.MountPathTypeId <> 7
					)
				GOTO CX_ERROR_EXIT
			END
			ELSE
			BEGIN
				--Mark the existing mount paths as read only in the library which user selected to host cloud mount path
				UPDATE MMMountPath
				SET MaxConcurrentWriters = 0
				WHERE MountPathId IN (SELECT MountPathId FROM #MountPathsToMarkReadOnly)
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMountPath -- Update MaxConcurrentWriters'
					GOTO CX_ERROR_EXIT
				END
				UPDATE MMMedia
				SET MediaFlags = 4  --MEDIA_FLAG_READONLY 4
				FROM MMMedia a INNER JOIN MMMediaSide b ON a.MediaId = b.MediaId
					INNER JOIN #MountPathsToMarkReadOnly c ON b.MediaSideId = c.MediaSideId
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- Update MediaFlags'
					GOTO CX_ERROR_EXIT
				END
			END
		END
		DECLARE CCM_MMS2MountPathCursor Cursor LOCAL For
		SELECT distinct a.MountPathId, a.MountPathName, a.MediaSideId, a.UserName,
		a.UserPassword, a.IsEnabled, a.NumberOfWriters,
		a.MaxConcurrentWriters,
		a.CurrentFileMarker,
		a.IsOffline, a.OfflineReason, a.MountPathTypeId, a.OffLineTimeStamp,
		a.origCCcommCellID, a.origCCmediaSideID, a.MaxDataToWriteMB, a.MagneticSpaceRsrvInMB, a.Attribute, b.new_id,
		c.newLibraryId, c.newMountPathName, c.newUserName, c.newPassword, a.origCCMountPathID, a.MagneticChunkFileIncrSizeMB
FROM CommServ_Merge..CCM_MMMountPath a, CCM_MAP_MMMediaSide b, CommServ_Merge..CCM_MountPathMapping c
		WHERE a.MountPathId > 0
		AND	a.MediaSideId = b.old_id
		AND a.MountPathId = c.MountPathId
		OPEN CCM_MMS2MountPathCursor
		FETCH NEXT FROM CCM_MMS2MountPathCursor
		INTO @MMS2MountPath_MountPathId, @MMS2MountPath_MountPathName, @MMS2MountPath_MediaSideId, @MMS2MountPath_UserName,
		@MMS2MountPath_UserPassword, @MMS2MountPath_IsEnabled, @MMS2MountPath_NumberOfWriters,
		@MMS2MountPath_MaxConcurrentWriters,
		@MMS2MountPath_CurrentFileMarker, @MMS2MountPath_IsOffline, @MMS2MountPath_OfflineReason, @MMS2MountPath_MountPathTypeId,
		@MMS2MountPath_OffLineTimeStamp, @MMS2MountPath_origCCcommCellID, @MMS2MountPath_origCCmediaSideID, @MMS2MountPath_MaxDataToWriteMB,
		@MMS2MountPath_MagneticSpaceRsrvInMB, @MMS2MountPath_Attribute, @MMS2MountPath_newMediaSideId,
		@MMS2MountPath_newLibraryId, @MMS2MountPath_newMountPathName, @MMS2MountPath_newUserName, @MMS2MountPath_newUserPassword,
		@MMS2MountPath_origCCMountPathID, @MMS2MountPath_MagneticChunkFileIncrSizeMB
		WHILE @@FETCH_STATUS = 0
		BEGIN
			if @MMS2MountPath_origCCcommCellID = 0
				set @MMS2MountPath_origCCcommCellID = 2
			set @new_commcellid = (select top 1 new_id from CCM_MAP_CommCell where old_id = @MMS2MountPath_origCCcommCellID)
			if @new_commcellid is null or @new_commcellid = 0
			begin
				SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- Cannot find original APP_CommCell id '
				GOTO CX_ERROR_EXIT
			end
			IF (@MMS2MountPath_MountPathTypeId = 0)
			BEGIN
				if exists (select * from MMMountPath where MountPathName = @MMS2MountPath_newMountPathName
									and ((origCCcommCellID > 0 AND origCCcommCellID != @new_commcellid) OR (origCCcommCellID = 0 AND @new_commcellId != 2))
									and mediasideid in (select mediasideid from MMMediaSide where mediaid in (select mediaid from MMMedia where libraryid = @MMS2MountPath_newLibraryId)))
				begin
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMountPath -- Cannot have duplicate mount path [' + @MMS2MountPath_newMountPathName + '] in the same library [' + CAST(@MMS2MountPath_newLibraryId AS varchar(10)) + ']'
					GOTO CX_ERROR_EXIT
				end
				if charindex('\\', @MMS2MountPath_newMountPathName) > 0
				and exists (select * from MMMountPath where MountPathName = @MMS2MountPath_newMountPathName
									and ((origCCcommCellID > 0 AND origCCcommCellID != @new_commcellid) OR (origCCcommCellID = 0 AND @new_commcellId != 2)))
				begin
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMountPath -- Cannot have duplicate UNC mount path '
					GOTO CX_ERROR_EXIT
				end
			END
			IF @MMS2MountPath_origCCMountPathID = 0
				SET @MMS2MountPath_origCCMountPathID = @MMS2MountPath_MountPathId
			IF @MMS2MountPath_origCCMediaSideID = 0
				SET @MMS2MountPath_origCCMediaSideID = @MMS2MountPath_MediaSideId
			-- Set the mountPath as readonly. If migration is in the same commcell, the mount path still need to be used for backup
			-- Set the device as readonly and a special flag for identifying migrated device for CCM and GRC
			IF @new_commcellid <> 2
			BEGIN
SET @MMS2MountPath_Attribute = @MMS2MountPath_Attribute | 4
				SET @MMS2MountPath_MaxConcurrentWriters = 0
SET	@MMS2MountPath_newDeviceAccess = (4 | 64)
				--Set the special attribute on Device to identify it as CCM/GRC migrated Device
IF(@ccmParamFlags & 1) > 0
SET @MMS2MountPath_newDeviceAttributes = 8
				ELSE
SET @MMS2MountPath_newDeviceAttributes = 4
			END
			ELSE
			BEGIN
SET	@MMS2MountPath_newDeviceAccess = 6
				SET @MMS2MountPath_newDeviceAttributes = 0
			END
			-- SET @MMS2MountPath_newMountPathId = (SELECT top 1 MountPathId FROM MMMountPath WHERE origCCcommCellID = @new_commcellid AND origCCmediaSideID = @MMS2MountPath_MediaSideId)
			-- The code above doesn't consider the situation when merging to the same commcell. origCCmediaSideId will be 0
			SET @MMS2MountPath_newMountPathId =
						(
							SELECT top 1 MountPathId FROM MMMountPath
							WHERE (origCCcommCellID = @new_commcellid AND origCCmediaSideID = @MMS2MountPath_origCCmediaSideID) OR
										((origCCcommCellID = 0 OR origCCcommCellID = 2)AND @new_commcellid = 2 AND mediaSideId = @MMS2MountPath_origCCmediaSideID)
						)
			IF @MMS2MountPath_newMountPathId is null
			BEGIN
				SET @MMS2MountPath_isExist = 0
				SET @MMS2MountPath_newMountPathId = 1
				if exists (select * from MMMountPath where mountpathid > 0)
					SELECT @MMS2MountPath_newMountPathId  = isnull(max(MountPathId), 0) + 1
					FROM MMMountPath
				declare @MMS2MountPath_newMasterPoolId integer
				set @MMS2MountPath_newMasterPoolId = (select top 1 MasterPoolId from MMMasterPool where LibraryId = @MMS2MountPath_newLibraryId)
				if @MMS2MountPath_newMasterPoolId is null or @MMS2MountPath_newMasterPoolId = 0
				begin
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- UPDATE'
					GOTO CX_ERROR_EXIT
				end
				--Regular MountPath Mapped to Shared Library
				DECLARE @targetMountPathType integer
				SET @targetMountPathType = ISNULL((SELECT top 1 mountPathTypeId FROM MMMountPath WHERE LibraryId =  @MMS2MountPath_newLibraryId),4)
				IF (@targetMountPathType in (2,4)) AND @MMS2MountPath_MountPathTypeId = 0
				BEGIN
					DECLARE @targetDeviceMediaAgentId integer
					DECLARE @i_devId		INTEGER
					DECLARE @s_devName	VARCHAR(256)
					SET @targetDeviceMediaAgentId = ISNULL((SELECT TargetDeviceMediaAgentId
									FROM   CommServ..CCMMountPathAnswers
									WHERE  SourceMountPathId = @MMS2MountPath_MountPathId
									--AND    SourceCommCellId  = @commcellNum
									AND	   SourceCommCellGUID = @commcellGUID),0)
					--This check is not needed for GRC since user can select no MA, this is not need for CCM also.
					--IF (@targetDeviceMediaAgentId = 0) AND (@isRoboImport = 0)
					--BEGIN
					--	SET @errStr = 'ERROR: Answer not found for MediaAgent  for Target Device'
					--	GOTO CX_ERROR_EXIT
					--END
					-- new mount path --
					INSERT INTO MMMountPath (MountPathId, MountPathName, MediaSideId, UserName,
					UserPassword, IsEnabled, NumberOfWriters,
					MaxConcurrentWriters,
					CurrentFileMarker,
					IsOffline, OfflineReason, MountPathTypeId, OffLineTimeStamp,
					origCCcommCellID, origCCmediaSideID, MaxDataToWriteMB, MagneticSpaceRsrvInMB, Attribute, MasterPoolId, LibraryId, RMStatus, RMStatusUpdateTime, MountPathOfflineReasonEventId,
					OrigCCMountPathId, MagneticChunkFileIncrSizeMB, StagingMountPathId)
					VALUES(@MMS2MountPath_newMountPathId, '', @MMS2MountPath_newMediaSideId, @MMS2MountPath_newUserName,
					@MMS2MountPath_newUserPassword, @MMS2MountPath_IsEnabled, @MMS2MountPath_NumberOfWriters,
					@MMS2MountPath_MaxConcurrentWriters,
					@MMS2MountPath_CurrentFileMarker, @MMS2MountPath_IsOffline, @MMS2MountPath_OfflineReason, @targetMountPathType,
					@MMS2MountPath_OffLineTimeStamp, @new_commcellid, @MMS2MountPath_origCCMediaSideId, @MMS2MountPath_MaxDataToWriteMB,
					@MMS2MountPath_MagneticSpaceRsrvInMB, @MMS2MountPath_Attribute, @MMS2MountPath_newMasterPoolId, @MMS2MountPath_newLibraryId, -1, 0, 0,
					@MMS2MountPath_origCCMountPathID, @MMS2MountPath_MagneticChunkFileIncrSizeMB, 0)
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMMountPath -- INSERT'
						GOTO CX_ERROR_EXIT
					END
					INSERT INTO MMDevice VALUES('',1,0,1,0,0,0,0,0,0,0,0,0,@MMS2MountPath_newDeviceAttributes,'',0,0,2,0,1)
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMDevice -- INSERT'
						GOTO CX_ERROR_EXIT
					END
					SET @i_devId = SCOPE_IDENTITY()
					SET @s_devName = 'Device_'+CONVERT(VARCHAR(32),@i_devId)
					UPDATE MMDevice SET AliasName = @s_devName WHERE DeviceId = @i_devId
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMDevice -- UPDATE'
						GOTO CX_ERROR_EXIT
					END
					INSERT INTO MMMountPathToStorageDevice VALUES (@MMS2MountPath_newMountPathId,0,@i_devId)
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMMountPathToStorageDevice -- INSERT'
						GOTO CX_ERROR_EXIT
					END
					IF @targetDeviceMediaAgentId > 1
					BEGIN
						INSERT INTO MMDeviceController VALUES (@targetDeviceMediaAgentId, @i_devId,0,1,0,0,
							@MMS2MountPath_newUserName,@MMS2MountPath_newUserPassword,@MMS2MountPath_newMountPathName,
							0,1,0,0,0, @MMS2MountPath_newDeviceAccess,0,0,0)
						IF	@@ERROR > 0
						BEGIN
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMDeviceController -- INSERT'
							GOTO CX_ERROR_EXIT
						END
						--PrasadNara 12:12 PM 8/9/2012
						--If user selects allow pruning from destination option then give full access to the destination for that mountpath
IF (@ccmParamFlags & 1) = 0
						BEGIN
							UPDATE MMDeviceController
SET DeviceAccessType =  6
							FROM MMDeviceController a, MMMountPathToStorageDevice b,
								CommServ..CCMMountPathAnswers c
							WHERE a.DeviceId = b.DeviceId AND b.MountPathId = @MMS2MountPath_newMountPathId
								AND c.SourceMountPathId = @MMS2MountPath_MountPathId AND c.SourceCommCellGUID = @commcellGUID
AND (c.allowEdit & 2) > 0
							IF	@@ERROR > 0
							BEGIN
								SET @errStr = 'ERROR: CCM_Merge_MM -- MMDeviceController -- UPDATE DeviceAccessType'
								GOTO CX_ERROR_EXIT
							END
						END
					END
				END
				ELSE
				BEGIN
					-- new mount path --
					INSERT INTO MMMountPath (MountPathId, MountPathName, MediaSideId, UserName,
					UserPassword, IsEnabled, NumberOfWriters,
					MaxConcurrentWriters,
					CurrentFileMarker,
					IsOffline, OfflineReason, MountPathTypeId, OffLineTimeStamp,
					origCCcommCellID, origCCmediaSideID, MaxDataToWriteMB, MagneticSpaceRsrvInMB, Attribute, MasterPoolId, LibraryId, RMStatus, RMStatusUpdateTime, MountPathOfflineReasonEventId,
					OrigCCMountPathId, MagneticChunkFileIncrSizeMB, StagingMountPathId)
					VALUES(@MMS2MountPath_newMountPathId, @MMS2MountPath_newMountPathName, @MMS2MountPath_newMediaSideId, @MMS2MountPath_newUserName,
					@MMS2MountPath_newUserPassword, @MMS2MountPath_IsEnabled, @MMS2MountPath_NumberOfWriters,
					@MMS2MountPath_MaxConcurrentWriters,
					@MMS2MountPath_CurrentFileMarker, @MMS2MountPath_IsOffline, @MMS2MountPath_OfflineReason, @MMS2MountPath_MountPathTypeId,
					@MMS2MountPath_OffLineTimeStamp, @new_commcellid, @MMS2MountPath_origCCMediaSideId, @MMS2MountPath_MaxDataToWriteMB,
					@MMS2MountPath_MagneticSpaceRsrvInMB, @MMS2MountPath_Attribute, @MMS2MountPath_newMasterPoolId, @MMS2MountPath_newLibraryId, -1, 0, 0,
					@MMS2MountPath_origCCMountPathID, @MMS2MountPath_MagneticChunkFileIncrSizeMB, 0)
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_MM -- MMMountPath -- INSERT'
						GOTO CX_ERROR_EXIT
					END
				END
				IF EXISTS (SELECT * FROM GXCounter WHERE name = 'MPID_Counter')
				BEGIN
				   UPDATE GXCounter
				   SET next_l = @MMS2MountPath_newMountPathId
				   WHERE name = 'MPID_Counter'
				END
				ELSE
				BEGIN
				   INSERT INTO GXCounter VALUES ('MPID_Counter',0,@MMS2MountPath_newMountPathId)
				END
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- GXCounter -- UPDATE'
					GOTO CX_ERROR_EXIT
				END
				UPDATE MMMedia
				SET LibraryId = @MMS2MountPath_newLibraryId, MediaLocation = 2
				WHERE MediaId IN (SELECT MediaId FROM MMMediaSide WHERE MediaSideId = @MMS2MountPath_newMediaSideId)
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- UPDATE'
					GOTO CX_ERROR_EXIT
				END
				declare @MMS2MountPath_newMediaId integer
				set @MMS2MountPath_newMediaId = (SELECT top 1 MediaId FROM MMMediaSide WHERE MediaSideId = @MMS2MountPath_newMediaSideId)
				if @MMS2MountPath_newMediaId is null or @MMS2MountPath_newMediaId = 0
				begin
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- UPDATE'
					GOTO CX_ERROR_EXIT
				end
				-- insert drive for each mount path added
				INSERT INTO MMDrive(DriveName, AliasName, DriveSoftState,
				DriveEnabled, DriveBroken, CleaningRequired,
				DriveInstallTime, DriveOccupied, MediaId, MasterPoolId,
				DriveVendor, DriveModel, FirmwareRevision, SerialNumber,
				WWNNumber, FiberChannelPort, ConnectionType, DriveTypeId,
				DriveNumber, NumRestoresLifeTime,
				NumBackupsLifeTime, NumMountsLifeTime,
				NumSoftErrsSinceClean, NumSoftErrsLifeTime,
				NumHardErrsSinceClean, NumHardErrsLifeTime,
				MinutesUsedSinceClean, MinutesUsedLifeTime,
				LastCleantime, LastServiceTime, ExternalGUID,
				PrivateData, OfflineReason, OfflineTimeStamp,
				VolumeId, MountStatus, LastLogicalUnmountTime, LastUseTime, SlotName,
				CurrentFileMarker, FileMarkerCacheType,
				SlotElementAddress, Descript,
				ReadThrougputMBsec, WriteThrougputMBsec, Attributes, OpPhase, RequestId, RMStatus, RMStatusUpdateTime, SCSIDeviceIdentifier, DriveOfflineReasonEventId, origCCId,
				origDriveId, LSCSName, LSResStatus, LSResStr)
				values('MagneticDrive_' + cast(@MMS2MountPath_newMediaId as varchar(10)),
					@MMS2MountPath_newMountPathName, 1, 1, 0, 0,
					dbo.GetUnixTime(getdate()), 1, @MMS2MountPath_newMediaId, @MMS2MountPath_newMasterPoolId,
					'Magnetic', 'Magnetic', 'Magnetic', '', '',
					0, 0, 10001, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					'', '', 4, 0, 0, 1, 0, 0, '', 0, 0, -1, '', 0, 0, 0, 0, 0, -1, 0, '', 0, @new_commcellid, 0,'', 0, '')
			END
			ELSE
			BEGIN
				SET @MMS2MountPath_isExist = 1
				-- mount path already exist --
				UPDATE MMMountPath
				SET
				UserName = @MMS2MountPath_newUserName,
				UserPassword = @MMS2MountPath_newUserPassword,
				IsEnabled = @MMS2MountPath_IsEnabled,
				NumberOfWriters = @MMS2MountPath_NumberOfWriters,
				--MaxConcurrentWriters = @MMS2MountPath_MaxConcurrentWriters,
				CurrentFileMarker = @MMS2MountPath_CurrentFileMarker,
				IsOffline = @MMS2MountPath_IsOffline,
				OfflineReason = @MMS2MountPath_OfflineReason,
				--MountPathTypeId = @MMS2MountPath_MountPathTypeId,
				OffLineTimeStamp = @MMS2MountPath_OffLineTimeStamp,
				origCCcommCellID = @new_commcellid,
				origCCmediaSideID = @MMS2MountPath_origCCMediaSideId,
				MaxDataToWriteMB = @MMS2MountPath_MaxDataToWriteMB,
				MagneticSpaceRsrvInMB = @MMS2MountPath_MagneticSpaceRsrvInMB,
				--Attribute = @MMS2MountPath_Attribute,
				origCCMountPathID = @MMS2MountPath_origCCMountPathID,
				MagneticChunkFileIncrSizeMB = @MMS2MountPath_MagneticChunkFileIncrSizeMB
				WHERE MountPathId = @MMS2MountPath_newMountPathId
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMMountPath -- UPDATE'
					GOTO CX_ERROR_EXIT
				END
				--Add DeviceController for Regular MountPath migrated without DeviceController in previous import
				DECLARE @trgtDeviceMediaAgentId integer
				SET @trgtDeviceMediaAgentId = ISNULL((SELECT TargetDeviceMediaAgentId
								FROM   CommServ..CCMMountPathAnswers
								WHERE  SourceMountPathId = @MMS2MountPath_MountPathId
								--AND    SourceCommCellId  = @commcellNum
								AND	   SourceCommCellGUID = @commcellGUID),0)
				DECLARE @trgtMountPathType integer
				SET @trgtMountPathType = ISNULL((SELECT top 1 mountPathTypeId FROM MMMountPath WHERE LibraryId =  @MMS2MountPath_newLibraryId),4)
				IF (@trgtMountPathType in (2,4)) AND @MMS2MountPath_MountPathTypeId = 0
				BEGIN
					DECLARE @i_DeviceId int
					SET @i_DeviceId = (SELECT DeviceId FROM MMMountPathToStorageDevice WHERE MountPathId = @MMS2MountPath_newMountPathId)
					IF NOT EXISTS(SELECT * FROM MMDeviceController WHERE DeviceId = @i_DeviceId) AND (@trgtDeviceMediaAgentId > 1)
					BEGIN
						INSERT INTO MMDeviceController VALUES (@trgtDeviceMediaAgentId, @i_DeviceId,0,1,0,0,
							@MMS2MountPath_newUserName, @MMS2MountPath_newUserPassword, @MMS2MountPath_newMountPathName,
							0,1,0,0,0, @MMS2MountPath_newDeviceAccess,0,0,0)
						IF	@@ERROR > 0
						BEGIN
							SET @errStr = 'ERROR: CCM_Merge_MM -- MMDeviceController -- INSERT'
							GOTO CX_ERROR_EXIT
						END
						--PrasadNara 12:12 PM 8/9/2012
						--If user selects allow pruning from destination option then give full access to the destination for that mountpath
IF (@ccmParamFlags & 1) = 0
						BEGIN
							UPDATE MMDeviceController
SET DeviceAccessType = 6
							FROM MMDeviceController a, MMMountPathToStorageDevice b,
								CommServ..CCMMountPathAnswers c
							WHERE a.DeviceId = b.DeviceId AND b.MountPathId = @MMS2MountPath_newMountPathId
								AND c.SourceMountPathId = @MMS2MountPath_MountPathId AND c.SourceCommCellGUID = @commcellGUID
AND (c.allowEdit & 2) > 0
							IF	@@ERROR > 0
							BEGIN
								SET @errStr = 'ERROR: CCM_Merge_MM -- MMDeviceController -- UPDATE DeviceAccessType'
								GOTO CX_ERROR_EXIT
							END
						END
					END
				END
			END
			INSERT INTO CCM_MAP_MMMountPath (old_id, new_id, old_mediasideid, new_mediasideid, isexist)
			VALUES (@MMS2MountPath_MountPathId, @MMS2MountPath_newMountPathId, @MMS2MountPath_MediaSideId, @MMS2MountPath_newMediaSideId, @MMS2MountPath_isExist)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMMountPath -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			SET @targetLibraryId    = 0
			SET @targetMediaAgentId = 0
			SET @targetLibraryId = ISNULL((SELECT TargetLibraryId
									FROM   CommServ..CCMMountPathAnswers
									WHERE  SourceMountPathId = @MMS2MountPath_MountPathId
									--AND    SourceCommCellId  = @commcellNum
									AND	   SourceCommCellGUID = @commcellGUID), 0)
			IF @targetLibraryId = 0
			BEGIN
			  SET @errStr = 'ERROR: CCM_Merge_MM -- Could not determine target library information'
			  GOTO CX_ERROR_EXIT
			END
			SET @targetMediaAgentId = ISNULL((SELECT DISTINCT top 1 b.ClientId
									   FROM   CommServ..MMMasterPool a, CommServ..MMDrivePool b
									   WHERE  a.MasterPoolId = b.MasterPoolId
									   AND    b.DrivePoolId > 0
									   AND    a.MasterPoolId > 0
									   AND    a.LibraryId = @targetLibraryId), 0)
			--IF @targetMediaAgentId <= 1 AND @isRoboImport = 0
			--BEGIN
			--  SET @errStr = 'ERROR: CCM_Merge_MM -- Could not determine target media agent information'
			--  GOTO CX_ERROR_EXIT
			--END
			-- #define SIM_CSL_AT_V2_MAGNETIC_LIBRARY            84 -- This is DDO License
			-- #define CV_APPTYPE_MAGNETIC_LIBRARY             1020
			-- Check if the license SIM_CSL_AT_V2_MAGNETIC_LIBRARY is consumed for the media agent
			-- to which the target library is registered
			IF NOT EXISTS (SELECT * FROM CommServ..LicUsage WHERE CId = @targetMediaAgentId AND LicType = 84 AND AppType = 1020 AND OpType = 'Install')
				AND (@targetMediaAgentId > 1)
			BEGIN
IF NOT EXISTS (SELECT * FROM CommServ_Merge..CCM_MountPathLicense WHERE clientId = @targetMediaAgentId)
			 BEGIN
			  -- Need to consume license
INSERT INTO CommServ_Merge..CCM_MountPathLicense VALUES (@targetMediaAgentId)
			  IF @@error > 0
			  BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MountPathLicense -- INSERT -- @targetMediaAgentId'
				GOTO CX_ERROR_EXIT
			  END
			 END
			END
			-- Now that the answer has been used to create a mountpath
			-- do not allow the edit of the answer from GuI
			UPDATE CommServ..CCMMountPathAnswers
SET allowEdit = (allowEdit & (~1))
			WHERE SourceMountPathId = @MMS2MountPath_MountPathId
			  --AND SourceCommCellId  = @commcellNum
			  AND SourceCommCellGUID = @commcellGUID
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- CCMMountPathAnswers -- UPDATE -- allowEdit 1'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CommServ..CCMMountPathAnswers
SET allowEdit = (a.allowEdit | 1)
			FROM CommServ..CCMMountPathAnswers a INNER JOIN CommServ..CCMLibraryAnswers b
				ON a.TargetLibraryId = b.TargetLibraryId AND a.SourceCommCellGUID = b.SourceCommCellGUID
			WHERE SourceMountPathId = @MMS2MountPath_MountPathId
				AND	b.TargetMediaAgentId <= 1
				AND a.SourceCommCellGUID = @commcellGUID
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_MM -- CCMMountPathAnswers -- UPDATE -- allowEdit 2'
				GOTO CX_ERROR_EXIT
			END
			FETCH NEXT FROM CCM_MMS2MountPathCursor
			INTO @MMS2MountPath_MountPathId, @MMS2MountPath_MountPathName, @MMS2MountPath_MediaSideId, @MMS2MountPath_UserName,
			@MMS2MountPath_UserPassword, @MMS2MountPath_IsEnabled, @MMS2MountPath_NumberOfWriters,
			@MMS2MountPath_MaxConcurrentWriters,
			@MMS2MountPath_CurrentFileMarker, @MMS2MountPath_IsOffline, @MMS2MountPath_OfflineReason, @MMS2MountPath_MountPathTypeId,
			@MMS2MountPath_OffLineTimeStamp, @MMS2MountPath_origCCcommCellID, @MMS2MountPath_origCCmediaSideID, @MMS2MountPath_MaxDataToWriteMB,
			@MMS2MountPath_MagneticSpaceRsrvInMB, @MMS2MountPath_Attribute, @MMS2MountPath_newMediaSideId,
			@MMS2MountPath_newLibraryId, @MMS2MountPath_newMountPathName, @MMS2MountPath_newUserName, @MMS2MountPath_newUserPassword,
			@MMS2MountPath_origCCMountPathID, @MMS2MountPath_MagneticChunkFileIncrSizeMB
		END
		CLOSE CCM_MMS2MountPathCursor
		DEALLOCATE CCM_MMS2MountPathCursor
	END
	-- End MMMountPath --
	UPDATE CommServ..CCMMountPathAnswers
	SET TargetMountPathId = b.new_id
	FROM CommServ..CCMMountPathAnswers a
		INNER JOIN CCM_MAP_MMMountPath b ON a.SourceMountPathId = b.old_id
	WHERE a.SourceCommCellGUID = @commcellGUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCMMountPathAnswers -- UPDATE -- TargetMountPathId'
		GOTO CX_ERROR_EXIT
	END
	--MMDevice and MMdeviceController
IF EXISTS (SELECT * FROM CommServ_Merge..CCM_MMDevice WHERE DeviceId > 0)
	BEGIN
		DECLARE @MMDevice_DeviceId INTEGER
		DECLARE @MMDevice_AliasName nvarchar(256)
		DECLARE @MMDevice_DeviceEnabled INTEGER
		DECLARE @MMDevice_DeviceBroken INTEGER
		DECLARE @MMDevice_DeviceTypeId INTEGER
		DECLARE @MMDevice_NumRestoresLifeTime INTEGER
		DECLARE @MMDevice_NumBackupsLifeTime INTEGER
		DECLARE @MMDevice_NumMountsLifeTime INTEGER
		DECLARE @MMDevice_NumErrsLIfeTime INTEGER
		DECLARE @MMDevice_MinutesUsedLifeTime INTEGER
		DECLARE @MMDevice_OffLineReason INTEGER
		DECLARE @MMDevice_SNRPartitionId INTEGER
		DECLARE @MMDevice_DeviceStatus INTEGER
		DECLARE @MMDevice_DRUId INTEGER
		DECLARE @MMDevice_DeviceAttributes INTEGER
		DECLARE @MMDevice_DRUDeviceId varchar(256)
		DECLARE @MMDevice_RMStatus INTEGER
		DECLARE @MMDevice_RMStatusUpdateTime INTEGER
		DECLARE @MMDevice_origCCId INTEGER
		DECLARE @MMDevice_origDeviceId INTEGER
		DECLARE @MMDevice_newMediaAgentId INTEGER
		DECLARE @MMDevice_newDevicePath varchar(1024)
		DECLARE @MMDevice_newuserName varchar(1024)
		DECLARE @MMDevice_newPassword varchar(2048)
		DECLARE @MMDevice_newDeviceId INTEGER
		DECLARE @MMDevice_isExist INTEGER
		DECLARE @MMDevice_controllerId INTEGER
		DECLARE @MMDevice_MountPathForDevice INTEGER
		DECLARE @MMDevice_newDeviceAccess INTEGER
		DECLARE @newDeviceControllerId INTEGER
		DECLARE @MMDevice_DisplayDeviceTypeId INTEGER
UPDATE CommServ_Merge..CCM_MMDevice SET origCCId = 2
		WHERE origCCId = 0
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MMDevice -- UPDATE -- origCCID'
			GOTO CX_ERROR_EXIT
		END
UPDATE CommServ_Merge..CCM_MMDevice SET origDeviceId = DeviceId
		Where origDeviceId = 0
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MMDevice -- UPDATE -- origDeviceID'
			GOTO CX_ERROR_EXIT
		END
		DECLARE CCM_MMDevicePathCursor Cursor LOCAL For
		SELECT DISTINCT A.DeviceId, A.AliasName, A.DeviceEnabled, A.DeviceBroken, A.DeviceTypeId, A.NumRestoresLifeTime,
		A.NumBackupsLifeTime, A.NumMountsLifeTime, A.NumErrsLifeTime, A.MinutesUsedLifeTime, A.OffLineReason,
		A.SNRPartitionId, A.DeviceStatus, A.DRUId, A.DeviceAttributes, A.DRUDeviceId, A.RMStatus, A.RMStatusUpdateTime,
		A.origCCId, A.origDeviceId, B.newMediaAgentId, B.newDevicePath, B.newuserName, B.newPassword, A.DisplayDeviceTypeId
FROM CommServ_Merge..CCM_MMDevice A, CommServ_Merge..CCM_DevicePathMapping B
		WHERE A.DeviceId = B.SourceDeviceId
		AND A.DeviceId > 0
		OPEN CCM_MMDevicePathCursor
		FETCH NEXT FROM CCM_MMDevicePathCursor
		INTO @MMDevice_DeviceId, @MMDevice_AliasName, @MMDevice_DeviceEnabled, @MMDevice_DeviceBroken, @MMDevice_DeviceTypeId,
		@MMDevice_NumRestoresLifeTime, @MMDevice_NumBackupsLifeTime, @MMDevice_NumMountsLifeTime, @MMDevice_NumErrsLifeTime,
		@MMDevice_MinutesUsedLifeTime, @MMDevice_OffLineReason, @MMDevice_SNRPartitionId, @MMDevice_DeviceStatus, @MMDevice_DRUId,
		@MMDevice_DeviceAttributes, @MMDevice_DRUDeviceId, @MMDevice_RMStatus, @MMDevice_RMStatusUpdateTime, @MMDevice_origCCId,
		@MMDevice_origDeviceId, @MMDevice_newMediaAgentId, @MMDevice_newDevicePath, @MMDevice_newUserName, @MMDevice_newPassword, @MMDevice_DisplayDeviceTypeId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF @MMDevice_origCCId = 0
				SET @MMDevice_origCCId = 2
			set @new_commcellid = (select top 1 new_id from CCM_MAP_CommCell where old_id = @MMDevice_origCCId)
			if @new_commcellid is null or @new_commcellid = 0
			begin
				SET @errStr = 'ERROR: CCM_Merge_MM -- MMDevice -- Cannot find original APP_CommCell id '
				GOTO CX_ERROR_EXIT
			end
			--Set the special attribute on Device to identify it as CCM/GRC migrated Device
			IF @new_commcellid <> 2
			BEGIN
IF(@ccmParamFlags & 1) > 0
SET @MMDevice_DeviceAttributes = @MMDevice_DeviceAttributes | 8
				ELSE
SET @MMDevice_DeviceAttributes = @MMDevice_DeviceAttributes | 4
			END
			-- Set the device as readonly and a special flag for identifying migrated device for CCM and GRC
SET	@MMDevice_newDeviceAccess = (4 | 64)
			IF @MMDevice_origDeviceId = 0
				SET @MMDevice_origDeviceId = @MMDevice_DeviceId
			SET @MMDevice_newDeviceId = (
										SELECT top 1 DeviceId FROM MMDevice
										WHERE (origCCId = @new_commcellid AND origDeviceId = @MMDevice_origDeviceId) OR
												((origCCId = 0 OR origCCId = 2)AND @new_commcellid = 2 AND DeviceId = @MMDevice_origDeviceId)
										)
			IF @MMDevice_newDeviceId is null
			BEGIN
				DECLARE @sourceCommcellGUID nvarchar(max)
				DECLARE @sourceCommcellNumber integer
SET @sourceCommcellGUID = (SELECT csGUID FROM CommServ_Merge..CCM_App_Commcell WHERE id = 2 and type = 1)
SET @sourceCommcellNumber = (SELECT number FROM CommServ_Merge..CCM_App_Commcell WHERE id = 2 and type = 1)
				--Set Device AliasName
				SET @name = @MMDevice_AliasName
				IF ( (@ccmParamFlags & 1) = 1) /*GRC merge */
				BEGIN
					IF @usePrefix > 0		/*If use prefix set then add a prefix always*/
					BEGIN
						SET @index = PATINDEX (@podCellName+'[_]%', @name)
						IF @index = 0
							SET @name = @podCellName+'_' + @name
					END
					ELSE IF EXISTS (SELECT 1 FROM MMDevice WHERE AliasName = @name)  /*If use suffix is set then add a suffix only when name exists already*/
					BEGIN
						SET @index = PATINDEX ('%[_]'+@podCellName, @name)
						IF @index = 0
							SET @name = @name + '_' + @podCellName
					END
					ELSE			/*If name is like Device_<number> then append CommCellId to the name even if use suffix is set and name doesn't exist*/
					BEGIN
						SET @index = PATINDEX ('Device[_]%', @name)
						IF @index > 0 AND ISNUMERIC(SUBSTRING(@name, 8, LEN(@name) - 7)) > 0
						BEGIN
							IF @sourceCommcellNumber <> -1
							   SET @name = @name + '_' + SUBSTRING(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), @sourceCommcellNumber)),3,8)
							ELSE
							   SET @name = @name + '_' + @sourceCommcellGUID
						END
					END
				END
				ELSE
				BEGIN
					SET @index = PATINDEX ('%CCM_%', @name)
					IF @index = 0 AND @new_commcellid <> 2   /*Don't prepend any text to the name if capture is from same CommServe */
					BEGIN
						SET @index = PATINDEX ('Device[_]%', @name)
						IF @index > 0 AND ISNUMERIC(SUBSTRING(@name, 8, LEN(@name) - 7)) > 0  /*If name is like Device_<number> then append CommCellId to the name*/
						BEGIN
							IF @sourceCommcellNumber <> -1
							   SET @name = 'CCM_' + @name + '_' + SUBSTRING(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), @sourceCommcellNumber)),3,8)
							ELSE
							   SET @name = 'CCM_' + @name + '_' + @sourceCommcellGUID
						END
						ELSE 			/*If name is not like Device_<number> then just prepend CCM_ to the name */
						BEGIN
							SET @name = 'CCM_' + @name
						END
					END
				END
				SET @index = 0
				SET @tempName = @name
				WHILE(exists (select 1 from MMDevice where AliasName = @tempName))
				BEGIN
						SET @index = @index + 1
						SET @tempName = @name + '(' + cast(@index as varchar(32)) + ')'
				END
				SET @MMDevice_AliasName = @tempName
				SELECT @SizeOfnameCol = CHARACTER_MAXIMUM_LENGTH FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME LIKE 'MMDevice' AND COLUMN_NAME = 'AliasName'
				IF LEN(@MMDevice_AliasName)> @SizeOfnameCol
					SET @MMDevice_AliasName = SUBSTRING(@MMDevice_AliasName, 1, @SizeOfnameCol)
				SET @MMDevice_isExist = 0
				SET IDENTITY_INSERT MMDEVICE OFF
				INSERT INTO MMDevice
				VALUES(@MMDevice_AliasName, @MMDevice_DeviceEnabled, @MMDevice_DeviceBroken, @MMDevice_DeviceTypeId,
				@MMDevice_NumRestoresLifeTime, @MMDevice_NumBackupsLifeTime, @MMDevice_NumMountsLifeTime, @MMDevice_NumErrsLifeTime,
				@MMDevice_MinutesUsedLifeTime, @MMDevice_OffLineReason, @MMDevice_SNRPartitionId, @MMDevice_DeviceStatus, @MMDevice_DRUId,
				@MMDevice_DeviceAttributes, @MMDevice_DRUDeviceId, @MMDevice_RMStatus, @MMDevice_RMStatusUpdateTime, @new_commcellid,
				@MMDevice_origDeviceId, @MMDevice_DisplayDeviceTypeId)
				IF @@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MMDevice -- INSERT'
					GOTO CX_ERROR_EXIT
				END
				SET @MMDevice_newDeviceId = SCOPE_IDENTITY()
				IF (@MMDevice_newMediaAgentId > 1)
				BEGIN
SET @MMDevice_controllerId  = ISNULL((SELECT TOP 1 DeviceControllerId FROM CommServ_Merge..CCM_MMDeviceController WHERE DeviceId = @MMDevice_DeviceId),0)
					IF(@MMDevice_controllerId = 0)
					BEGIN
						SET @errStr = "ERROR: CCM_Merge_MM -- MMDeviceController Does Not Exist FOr Device"
						GOTO CX_ERROR_EXIT
					END
					SET IDENTITY_INSERT MMDeviceController OFF
					INSERT INTO MMDeviceController
					SELECT @MMDevice_newMediaAgentId, @MMDevice_newDeviceId, DeviceControllerActive, DeviceControllerEnabled, SNRVolumeId, UseCount,
					@MMDevice_newUserName, @MMDevice_newPassword, @MMDevice_newDevicePath, DeviceMounted, DeviceAccessible, VolumeRecoveryStatus, VolumeRecoveryTime,
					VolumeScsiReserved, CASE WHEN @new_commcellid = 2 THEN DeviceAccessType ELSE @MMDevice_newDeviceAccess END, RMStatus, RMStatusUpdatetime, CredentialAssocId
FROM CommServ_Merge..CCM_MMDeviceController
					WHERE  DeviceControllerId = @MMDevice_controllerId
					IF @@ERROR > 0
					BEGIN
						SET @errStr = "ERROR: CCM_MERGE_MM -- MMDeviceController -- INSERT"
						GOTO CX_ERROR_EXIT
					END
					SET @newDeviceControllerId = SCOPE_IDENTITY()
					-- In case of GRC, if there exists devices shared with multiple MAs then make sure same MAs can access the newly imported mount paths.
IF (@ccmParamFlags & 1) > 0
					BEGIN
						INSERT INTO MMDeviceController
						SELECT DISTINCT LC.clientId, @MMDevice_newDeviceId, DeviceControllerActive, DeviceControllerEnabled, SNRVolumeId, UseCount,
							@MMDevice_newUserName, @MMDevice_newPassword, @MMDevice_newDevicePath, DeviceMounted, DeviceAccessible, VolumeRecoveryStatus, VolumeRecoveryTime,
							VolumeScsiReserved, CASE WHEN @new_commcellid = 2 THEN DeviceAccessType ELSE @MMDevice_newDeviceAccess END, RMStatus, RMStatusUpdatetime, CredentialAssocId
						FROM MMLibraryController LC INNER JOIN CCMMountPathAnswers MPA ON LC.LibraryId = MPA.TargetLibraryId AND MPA.SourceCommCellGUID = @commcellGUID
INNER JOIN CommServ_Merge..CCM_MMDeviceController ON DeviceId = MPA.SourceDeviceId AND DeviceControllerId = @MMDevice_controllerId
						WHERE MPA.SourceDeviceId = @MMDevice_DeviceId
							AND NOT EXISTS (SELECT 1 FROM MMDeviceController DC WHERE DC.DeviceId = @MMDevice_newDeviceId AND DC.clientId = LC.clientId)
						IF @@ERROR > 0
						BEGIN
							SET @errStr = "ERROR: CCM_MERGE_MM -- MMDeviceController -- INSERT Failed for GRC additional mount paths."
							GOTO CX_ERROR_EXIT
						END
					END
					INSERT INTO CCM_MAP_MMDeviceController
					SELECT @MMDevice_controllerId, @newDeviceControllerId
					IF @@ERROR > 0
					BEGIN
						SET @errStr = "ERROR: CCM_Merge_MM -- Failed to insert DeviceController mapping."
						GOTO CX_ERROR_EXIT
					END
				END
			END
			ELSE
			BEGIN
				/* To Do Update existing */
				SET @MMDevice_isExist = 1
				--Add DeviceController for Devices migrated without DeviceController in previous import
				IF NOT EXISTS(SELECT * FROM MMDeviceController WHERE DeviceId = @MMDevice_newDeviceId) AND (@MMDevice_newMediaAgentId > 1)
				BEGIN
SET @MMDevice_controllerId  = ISNULL((SELECT TOP 1 DeviceControllerId FROM CommServ_Merge..CCM_MMDeviceController WHERE DeviceId = @MMDevice_DeviceId),0)
					IF(@MMDevice_controllerId = 0)
					BEGIN
						SET @errStr = "ERROR: CCM_Merge_MM -- MMDeviceController Does Not Exist FOr Device"
						GOTO CX_ERROR_EXIT
					END
IF @MMDevice_newDevicePath = (SELECT Folder FROM CommServ_Merge..CCM_MMDeviceController WHERE DeviceControllerId = @MMDevice_controllerId)
						AND @MMDevice_newPassword <> ''
					BEGIN
SET @MMDevice_newUserName = (SELECT UserName FROM CommServ_Merge..CCM_MMDeviceController WHERE DeviceControllerId = @MMDevice_controllerId)
SET @MMDevice_newPassword = (SELECT UserPassword FROM CommServ_Merge..CCM_MMDeviceController WHERE DeviceControllerId = @MMDevice_controllerId)
					END
					SET IDENTITY_INSERT MMDeviceController OFF
					INSERT INTO MMDeviceController
					SELECT @MMDevice_newMediaAgentId, @MMDevice_newDeviceId, DeviceControllerActive, DeviceControllerEnabled, SNRVolumeId, UseCount,
					@MMDevice_newUserName, @MMDevice_newPassword, @MMDevice_newDevicePath, DeviceMounted, DeviceAccessible, VolumeRecoveryStatus, VolumeRecoveryTime,
					VolumeScsiReserved, CASE WHEN @new_commcellid = 2 THEN DeviceAccessType ELSE @MMDevice_newDeviceAccess END, RMStatus, RMStatusUpdatetime, CredentialAssocId
FROM CommServ_Merge..CCM_MMDeviceController
					WHERE  DeviceControllerId = @MMDevice_controllerId
					IF @@ERROR > 0
					BEGIN
						SET @errStr = "ERROR: CCM_MERGE_MM -- MMDeviceController -- INSERT"
						GOTO CX_ERROR_EXIT
					END
					SET @newDeviceControllerId = SCOPE_IDENTITY()
					INSERT INTO CCM_MAP_MMDeviceController
					SELECT @MMDevice_controllerId, @newDeviceControllerId
					IF @@ERROR > 0
					BEGIN
						SET @errStr = "ERROR: CCM_Merge_MM -- Failed to insert DeviceController mapping"
						GOTO CX_ERROR_EXIT
					END
				END
			END
			INSERT INTO CCM_MAP_MMDevice (old_DeviceId, new_DeviceId, isExist)
			VALUES (@MMDevice_Deviceid, @MMDevice_newDeviceId, @MMDevice_isExist)
			IF @@ERROR > 0
			BEGIN
				SET @errStr = "ERROR: CCM_Merge_MM -- CCM_MAP_MMDevice"
				GOTO CX_ERROR_EXIT
			END
			--PrasadNara 12:12 PM 8/9/2012
			--If user selects allow pruning from destination option then give full access to the destination for that mountpath
IF (@ccmParamFlags & 1) = 0
			BEGIN
				UPDATE MMDeviceController
SET DeviceAccessType =  6
				FROM MMDeviceController a INNER JOIN MMMountPathToStorageDevice b ON a.DeviceId = b.DeviceId
					INNER JOIN CCM_MAP_MMMountPath c ON b.MountPathId = c.new_id
					INNER JOIN CommServ..CCMMountPathAnswers d ON c.old_Id = d.SourceMountPathId
				WHERE d.SourceCommCellGUID = @commcellGUID
AND (d.allowEdit & 2) > 0
				IF	@@ERROR > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_MM -- MMDeviceController -- UPDATE DeviceAccessType'
					GOTO CX_ERROR_EXIT
				END
			END
			UPDATE CommServ..CCMDevicePathAnswers
			SET allowEdit = 0
			WHERE SourceDeviceId = @MMDevice_Deviceid
			--AND SourceCommCellId  = @commcellNum
			AND SourceCommCellGUID = @commcellGUID
			AND TargetMediaAgentId > 1
			IF @@ERROR > 0
			BEGIN
				SET @errStr = "ERROR: CCM_MERGE_MM -- CCMDevicePathAnswers -- UPDATE allowEdit = 0"
				GOTO CX_ERROR_EXIT
			END
			FETCH NEXT FROM CCM_MMDevicePathCursor
			INTO @MMDevice_Deviceid, @MMDevice_AliasName, @MMDevice_DeviceEnabled, @MMDevice_DeviceBroken, @MMDevice_DeviceTypeId,
			@MMDevice_NumRestoresLifeTime, @MMDevice_NumBackupsLifeTime, @MMDevice_NumMountsLifeTime, @MMDevice_NumErrsLifeTime,
			@MMDevice_MinutesUsedLifeTime, @MMDevice_OffLineReason, @MMDevice_SNRPartitionId, @MMDevice_DeviceStatus, @MMDevice_DRUId,
			@MMDevice_DeviceAttributes, @MMDevice_DRUDeviceId, @MMDevice_RMStatus, @MMDevice_RMStatusUpdateTime, @MMDevice_origCCId,
			@MMDevice_origDeviceId, @MMDevice_newMediaAgentId, @MMDevice_newDevicePath, @MMDevice_newUserName, @MMDevice_newPassword, @MMDevice_DisplayDeviceTypeId
		END
		CLOSE CCM_MMDevicePathCursor
		DEALLOCATE CCM_MMDevicePathCursor
		UPDATE CCMDevicePathAnswers
		SET TargetDeviceId = B.new_DeviceId
		FROM CCMDevicePathAnswers A INNER JOIN CCM_MAP_MMDevice B ON A.SourceDeviceId = B.old_DeviceId
		WHERE A.SourceCommCellGUID = @commcellGUID AND A.TargetDeviceId = 0
		IF @@ERROR > 0
		BEGIN
			SET @errStr = "ERROR: CCM_Merge_MM -- CCMDevicePathAnswers -- Update TargetDeviceId"
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO CCM_MAP_MMMountPathToStorageDevice
		SELECT MountPathId,0,CenteraId,0,DeviceId,0
FROM CommServ_Merge..CCM_MMMountPathToStorageDevice
		IF @@ERROR > 0
		BEGIN
			SET @errStr = "ERROR: CCM_Merge_MM -- CCM_MAP_MMMountPathToStorageDevice -- INSERT"
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_MMMountPathToStorageDevice
		SET new_MountPathId = new_id
		FROM CCM_MAP_MMMountPath WHERE old_id = old_MountPathId
		IF @@ERROR > 0
		BEGIN
			SET @errStr = "ERROR: CCM_Merge_MM -- CCM_MAP_MMMountPathToStorageDevice  -- UPDATE New MountPathId"
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_MMMountPathToStorageDevice
		SET new_DeviceId = B.new_DeviceId
		FROM CCM_MAP_MMMountPathToStorageDevice A, CCM_MAP_MMDevice B
		WHERE A.old_DeviceId = B.old_DeviceId
		IF @@ERROR > 0
		BEGIN
			SET @errStr = "ERROR: CCM_Merge_MM -- CCM_MAP_MMMountPathToStorageDevice  -- UPDATE New DevicePathId"
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_MMMountPathToStorageDevice
		SET new_CenteraId = new_id
		FROM CCM_MAP_MMCenteraInfo WHERE old_id = old_CenteraId
		IF @@ERROR > 0
		BEGIN
			SET @errStr = "ERROR: CCM_Merge_MM -- CCM_MAP_MMMountPathToStorageDevice  -- UPDATE New CenteraId"
			GOTO CX_ERROR_EXIT
		END
		IF EXISTS (SELECT * FROM CCM_MAP_MMMountPathToStorageDevice WHERE new_MountPathId = 0 OR (new_DeviceId = 0 AND new_CenteraId = 0))
		BEGIN
			SET @errStr = "ERROR: CCM_Merge_MM -- CCM_MAP_MMMountPathToStorageDevice -- New Id's NOT Found"
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO MMMountPathToStorageDevice
		SELECT new_MountPathId, new_CenteraId, new_DeviceId
		FROM CCM_MAP_MMMountPathToStorageDevice
		WHERE NOT EXISTS (SELECT * FROM MMMountPathToStorageDevice WHERE MountPathId = new_MountPathId)
		IF @@ERROR > 0
		BEGIN
			SET @errStr = "ERROR: CCM_Merge_MM -- MMMountPathToStorageDevice -- INSERT"
			GOTO CX_ERROR_EXIT
		END
	END --End of MMDevice, MMDeviceController, MMMountPathToStorageDevice
	UPDATE CCM_MAP_CredentialAssoc
	SET new_entityId = B.new_DeviceControllerId
FROM CCM_MAP_CredentialAssoc A INNER JOIN CCM_MAP_MMDeviceController B ON A.old_entityId = B.old_DeviceControllerId AND A.entityType = 186
	WHERE A.new_entityId = 0
	IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_CredentialAssoc -- UPDATE new_entityId'
        GOTO CX_ERROR_EXIT
    END
	INSERT INTO APP_CredentialAssoc
	SELECT A.new_credentialId, A.entityType, A.new_entityId, A.CredAssocGUID
	FROM CCM_MAP_CredentialAssoc A
WHERE A.new_entityId > 0 AND A.entityType = 186
		AND NOT EXISTS(SELECT 1 FROM APP_CredentialAssoc B WHERE B.CredAssocGUID = A.CredAssocGUID)
	IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_MM -- APP_CredentialAssoc -- INSERT'
        GOTO CX_ERROR_EXIT
    END
	UPDATE CCM_MAP_CredentialAssoc
	SET new_assocId = B.assocId
	FROM CCM_MAP_CredentialAssoc A INNER JOIN APP_CredentialAssoc B ON B.CredAssocGUID = A.CredAssocGUID
	WHERE A.new_assocId = 0
	IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_CredentialAssoc -- UPDATE new_assocId'
        GOTO CX_ERROR_EXIT
    END
	UPDATE MMDeviceController
	SET CredentialAssocId = B.new_assocId
	FROM CCM_MAP_MMDeviceController A
INNER JOIN CCM_MAP_CredentialAssoc B ON A.new_DeviceControllerId = B.new_entityId AND B.entityType = 186
		INNER JOIN MMDeviceController C ON C.DeviceControllerId = A.new_DeviceControllerId AND A.old_DeviceControllerId = B.old_entityId
	WHERE C.CredentialAssocId <> B.new_assocId
	IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_MM -- MMDeviceController -- UPDATE - CredentialAssocId.'
        GOTO CX_ERROR_EXIT
    END
	-- MMDiskHWInfo --
	INSERT INTO MMDiskHWInfo
	SELECT A.deviceId, A.diskSerialNum, B.newEntityId, A.blockSize, A.version, A.numBlocks, A.flags, A.deviceLocation, A.deviceOSPath, A.backingDevice, A.blockDeviceUUID,
			A.freeSpaceMB, A.diskCapacityMB, A.ErrorCode, A.Properties, A.blockNumber, A.SubVolume, A.Vendor, A.FileSystem, A.Product, A.MountOptions,
			A.BrickFullPath, A.BrickHealth, A.BlockDeviceHealth, A.mountPathUsageType, A.GUID
FROM CommServ_Merge..CCM_MMDiskHWInfo A
INNER JOIN CCMMergeEntityMap B ON B.oldEntityId = A.hostId AND B.entityType = 3
		LEFT OUTER JOIN MMDiskHWInfo C ON A.GUID = C.GUID
	WHERE C.GUID IS NULL
	IF @@ERROR > 0
	BEGIN
		SET @errStr = "ERROR: CCM_Merge_MM -- MMDiskHWInfo -- INSERT"
		GOTO CX_ERROR_EXIT
	END
	-- There are devices with id 0 so added seperate updates.
	UPDATE A
	SET A.deviceId = B.new_DeviceId
	FROM MMDiskHWInfo A INNER JOIN CCM_MAP_MMDevice B ON A.deviceId = B.old_DeviceId
	WHERE A.deviceId <> B.new_DeviceId AND A.deviceId > 0
	IF @@ERROR > 0
	BEGIN
		SET @errStr = "ERROR: CCM_Merge_MM -- MMDiskHWInfo -- UPDATE deviceId."
		GOTO CX_ERROR_EXIT
	END
	-- MMSDSStoragePool --
	INSERT INTO MMSDSStoragePool
	SELECT A.StoragePoolName, B.new_LibraryId, D.new_Id, A.DisperseFactor, A.RedundancyFactor, A.NodesPerBlock, A.StoragePoolEnabled,
	A.NetworkInformation, A.Metadata, A.StoragePoolStatus, A.Flags
FROM CommServ_Merge..CCM_MMSDSStoragePool A
		INNER JOIN CCM_MAP_Library B ON A.LibraryId = B.old_LibraryId
		INNER JOIN CCM_MAP_ArchGroup D ON A.GDSPId = D.old_Id
		LEFT OUTER JOIN MMSDSStoragePool E ON E.LibraryId = B.new_LibraryId AND E.GDSPId = D.new_Id
	WHERE E.StoragePoolName IS NULL
	IF @@ERROR > 0
	BEGIN
		SET @errStr = "ERROR: CCM_Merge_MM -- MMSDSStoragePool -- INSERT."
		GOTO CX_ERROR_EXIT
	END
	-- MMVolume --
	-- For Tape Import, there wouldn't be any records in CCM_MAP_MMMMediaSide.
    -- Hence, there isn't any need to execute the contents
    -- Merge of MMVolume for tape import is done above in the Media cursor
	IF EXISTS (SELECT *
FROM CommServ_Merge..CCM_MMVolume a, CCM_MAP_MMMediaSide b, CCM_MAP_ArchStream c
	           WHERE a.VolumeId > 0
	             AND a.MediaSideId = b.old_id
		         AND a.MediaGroupId = c.old_mediaGroupId)
	BEGIN
UPDATE CommServ_Merge..CCM_MMVolume
	 SET origCCcommCellID = 2
	 WHERE origCCcommCellID = 0
	 IF	@@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MMVolume -- UPDATE -- origCCcommCellID'
		GOTO CX_ERROR_EXIT
	 END
UPDATE CommServ_Merge..CCM_MMVolume
	 SET origCCvolumeID = VolumeId
	 WHERE origCCvolumeID = 0
	 IF	@@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MMVolume -- UPDATE -- origCCvolumeID'
		GOTO CX_ERROR_EXIT
	 END
	 IF @tapeReusable = 0
	 BEGIN
UPDATE CommServ_Merge..CCM_MMVolume
SET VolumeFlags = 2, VolumeFullReason = 42019 -- 42019
	  IF @@ERROR > 0
	  BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MMVolume -- UPDATE -- VolumeFlags, VolumeFullReason'
		GOTO CX_ERROR_EXIT
	  END
	 END
	 INSERT INTO CCM_MAP_MMVolume
	 SELECT VolumeId, 0, origCCcommCellID, 0, origCCvolumeID, 0, MediaId, 0, MediaSideId, 0, MediaGroupId, 0, SIDBStoreId, 0, 1, 0, (CASE ReformatTime
	                                                                                                                                                      WHEN 0 THEN 0
	                                                                                                                                                      ELSE 1
	                                                                                                                                                     END),
            RecordingFormatId, 0 , null, null, 0, currMountPathId, 0
FROM CommServ_Merge..CCM_MMVolume
	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- INSERT'
		GOTO CX_ERROR_EXIT
	 END
	 IF @isTapeImport = 1
	 BEGIN
		 -- The reformat time of a volume is not stored in the Media. Media explorer's tape catelog stores a value of 0
		 -- in MMVolume.txt, which further reaches Commserv_Merge database.
		 -- Consider the creation time of the first Chunk in the volume as reformat time, as its value would be
		 -- close to the reformat time of the Media.
		  DECLARE @lt_volume TABLE
		  (
		   VolumeId	int,
		   Time	int
		  )
		  INSERT INTO @lt_volume
		  SELECT a.VolumeId, ISNULL(MIN(b.createTime),0)
FROM CommServ_Merge..CCM_MMVolume a, CommServ_Merge..CCM_ArchChunk b
		  WHERE b.commCellId = 2
		    AND b.volumeId = a.volumeId
		    AND a.ReformatTime = 0
		  GROUP BY a.VolumeId
		  IF @@ERROR > 0
		  BEGIN
			SET @errStr = 'ERROR: CCM_Merge_MM -- @lt_volume -- INSERT'
			GOTO CX_ERROR_EXIT
		  END
UPDATE CommServ_Merge..CCM_MMVolume
		  SET ReformatTime = b.Time
FROM CommServ_Merge..CCM_MMVolume a, @lt_volume b, CCM_MAP_CommCell c
		  WHERE b.volumeId = a.volumeId
		    AND a.origCCcommCellID = c.old_id
		    AND c.new_id = 2                                          -- For tape import commcell Id 2 will be mapped as 2
		    AND a.ReformatTime = 0
		  IF @@ERROR > 0
		  BEGIN
			SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MMVolume -- UPDATE -- ReformatTime'
			GOTO CX_ERROR_EXIT
		  END
	 END
	 UPDATE CCM_MAP_MMVolume
	 SET new_origCCcommCellID = b.new_id
	 FROM CCM_MAP_MMVolume a, CCM_MAP_CommCell b
	 WHERE a.old_origCCcommCellID = b.old_id
	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE -- new_origCCcommCellID'
		GOTO CX_ERROR_EXIT
	 END
	 IF EXISTS (SELECT * FROM CCM_MAP_MMVolume where new_origCCcommCellID = 0)
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- MMVolume -- Cannot find original APP_CommCell id '
		GOTO CX_ERROR_EXIT
     END
     UPDATE CCM_MAP_MMVolume
     SET new_MediaSideId = b.new_id, new_MediaId = b.new_mediaid
     FROM CCM_MAP_MMVolume a, CCM_MAP_MMMediaSide b
     WHERE a.old_MediaSideId = b.old_id
	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE -- new_MediaSideId, new_MediaId'
		GOTO CX_ERROR_EXIT
	 END
     UPDATE CCM_MAP_MMVolume
     SET new_MediaGroupId = b.new_mediaGroupId
     FROM CCM_MAP_MMVolume a, CCM_MAP_ArchStream b
     WHERE a.old_MediaGroupId = b.old_mediaGroupId
	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE -- new_MediaGroupId'
		GOTO CX_ERROR_EXIT
	 END
     UPDATE CCM_MAP_MMVolume
     SET new_SIDBStoreId = b.new_SIDBStoreId
     FROM CCM_MAP_MMVolume a, CCM_MAP_IdxSIDBStore b
     WHERE a.old_SIDBStoreId > 0
       AND a.old_SIDBStoreId = b.old_SIDBStoreId
       AND b.new_commCellId = a.new_origCCcommCellID
	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE -- new_SIDBStoreId'
		GOTO CX_ERROR_EXIT
	 END
     UPDATE CCM_MAP_MMVolume
     SET IsInMediaGroup = b.IsInMediaGroup
     FROM CCM_MAP_MMVolume a, CCM_MAP_MMMedia b
     WHERE a.new_MediaId = b.new_id
	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE -- IsInMediaGroup'
		GOTO CX_ERROR_EXIT
	 END
	 UPDATE CCM_MAP_MMVolume
     SET new_currMountPathId = b.new_id
     FROM CCM_MAP_MMVolume a, CCM_MAP_MMMountPath b
     WHERE a.old_currMountPathId = b.old_id
       AND a.RecordingFormatId = 10001
	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE -- new_currMountPathId'
		GOTO CX_ERROR_EXIT
	 END
	 -- Existing Magnectic Volumes
     UPDATE CCM_MAP_MMVolume
     SET new_id = b.VolumeId, exist = 1
     FROM CCM_MAP_MMVolume a, MMVolume b
     WHERE a.RecordingFormatId = 10001
       AND b.origCCcommCellID = a.new_origCCcommCellID
       AND b.origCCvolumeID = a.old_origCCvolumeID
	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE 1 -- new_id for Magnetic Volumes'
		GOTO CX_ERROR_EXIT
	 END
     UPDATE CCM_MAP_MMVolume
     SET new_id = b.VolumeId, exist = 1
     FROM CCM_MAP_MMVolume a, MMVolume b
     WHERE a.RecordingFormatId = 10001
       AND b.origCCcommCellID = 0
       AND a.new_origCCcommCellID = 2
       AND b.VolumeId = a.old_origCCvolumeID
	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE 2 -- new_id for Magnetic Volumes'
		GOTO CX_ERROR_EXIT
	 END
     -- Existing Optical and Tape Volumes
     UPDATE CCM_MAP_MMVolume
     SET new_id = b.VolumeId, exist = 1
     FROM CCM_MAP_MMVolume a, MMVolume b
     WHERE a.RecordingFormatId <> 10001
       AND ((b.origCCcommCellID = a.new_origCCcommCellID) OR (b.origCCcommCellID = 0 AND a.new_origCCcommCellID = 2))
       AND b.MediaSideId = a.new_MediaSideId
	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE -- new_id for Non-Magnetic Volumes'
		GOTO CX_ERROR_EXIT
	 END
	 -- Reuse Old Id for non-existent volumes
     UPDATE CCM_MAP_MMVolume
     SET reuseOldId = 0
     FROM CCM_MAP_MMVolume a, MMVolume b
     WHERE a.old_id = b.VolumeId
       AND a.new_id = 0
       AND a.exist = 0
	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE -- reuseOldId'
		GOTO CX_ERROR_EXIT
	 END
     -- Insert non-existent volumes, but reuse old volume ids
     SET IDENTITY_INSERT MMVolume ON
     INSERT INTO MMVolume (VolumeId, VolumeName, CreationTime, VolumeFlags,
					VolumeInitialized, FlushBlockSizeKB,
					NumberOfRestores, NumberOfBackups, NumberOfMounts,
					NumberOfSoftErrors, NumberOfHardErrors,
					LastRestoreTime, LastBackupTime,
					LogicalBytesMB, PhysicalBytesMB, NumberOfActiveFiles,
					LastFile, RecordingFormatId, ExternalGUID,
					OMLVersion, VolumeState, VolumeFullReason,VolumeFullTime,
					VolumeFullJobId,origCCcommCellID, origCCvolumeID,
					MediaId, MediaSideId, Attributes, MediaGroupId,	ReformatTime, RMSpareStatus, RMSpareStatusUpdateTime, SIDBStoreId,
					SiloStatus,CurrMountPathId, FailureErrorCode, MMSpareStatus)
	 SELECT a.VolumeId, a.VolumeName, a.CreationTime, a.VolumeFlags, a.VolumeInitialized, a.FlushBlockSizeKB, a.NumberOfRestores, a.NumberOfBackups,
	        a.NumberOfMounts, a.NumberOfSoftErrors, a.NumberOfHardErrors, a.LastRestoreTime, a.LastBackupTime, a.LogicalBytesMB,
	        a.PhysicalBytesMB, a.NumberOfActiveFiles, a.LastFile, a.RecordingFormatId, a.ExternalGUID, a.OMLVersion, a.VolumeState,
	        a.VolumeFullReason, a.VolumeFullTime, 0, b.new_origCCcommCellID, a.VolumeId, b.new_MediaId, b.new_MediaSideId,
CASE WHEN @isRoboImport > 0 THEN a.Attributes | 1024 ELSE a.Attributes END, b.new_MediaGroupId, a.ReformatTime, -1, 0, b.new_SIDBStoreId, a.SiloStatus,
		  b.new_currMountPathId, a.FailureErrorCode, a.MMSpareStatus
FROM CommServ_Merge..CCM_MMVolume a, CCM_MAP_MMVolume b
	 WHERE a.VolumeId = b.old_id
	   AND b.exist = 0
	   AND b.reuseOldId = 1
	 IF	@@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- MMVolume -- INSERT -- New Volumes, Reuse Old Ids'
		SET IDENTITY_INSERT MMVolume OFF
		GOTO CX_ERROR_EXIT
	 END
     SET IDENTITY_INSERT MMVolume OFF
	 -- Insert non-existent volumes, generate new volume ids
     INSERT INTO MMVolume (VolumeName, CreationTime, VolumeFlags,
					VolumeInitialized, FlushBlockSizeKB,
					NumberOfRestores, NumberOfBackups, NumberOfMounts,
					NumberOfSoftErrors, NumberOfHardErrors,
					LastRestoreTime, LastBackupTime,
					LogicalBytesMB, PhysicalBytesMB, NumberOfActiveFiles,
					LastFile, RecordingFormatId, ExternalGUID,
					OMLVersion, VolumeState, VolumeFullReason,VolumeFullTime,
					VolumeFullJobId,origCCcommCellID, origCCvolumeID,
					MediaId, MediaSideId, Attributes, MediaGroupId,	ReformatTime, RMSpareStatus, RMSpareStatusUpdateTime, SIDBStoreId,
					SiloStatus,CurrMountPathId, FailureErrorCode, MMSpareStatus)
	 SELECT a.VolumeName, a.CreationTime, a.VolumeFlags, a.VolumeInitialized, a.FlushBlockSizeKB, a.NumberOfRestores, a.NumberOfBackups,
	        a.NumberOfMounts, a.NumberOfSoftErrors, a.NumberOfHardErrors, a.LastRestoreTime, a.LastBackupTime, a.LogicalBytesMB,
	        a.PhysicalBytesMB, a.NumberOfActiveFiles, a.LastFile, a.RecordingFormatId, a.ExternalGUID, a.OMLVersion, a.VolumeState,
	        a.VolumeFullReason, a.VolumeFullTime, 0, b.new_origCCcommCellID, a.VolumeId, b.new_MediaId, b.new_MediaSideId,
CASE WHEN @isRoboImport > 0 THEN a.Attributes | 1024 ELSE a.Attributes END, b.new_MediaGroupId, a.ReformatTime, -1, 0, b.new_SIDBStoreId, a.SiloStatus,
		  b.new_currMountPathId, a.FailureErrorCode, a.MMSpareStatus
FROM CommServ_Merge..CCM_MMVolume a, CCM_MAP_MMVolume b
	 WHERE a.VolumeId = b.old_id
	   AND b.exist = 0
	   AND b.reuseOldId = 0
	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- MMVolume -- INSERT -- New Volumes, Generate New Ids'
		GOTO CX_ERROR_EXIT
	 END
     -- re-format time validation for existing volumes
     -- if the current commcell has a later reformattime than the original commcell, then the media has
	 -- been reused in the new commcell.
 	 -- It is a valid case for destination commcell to have reused the tape
 	 -- but Commcell migration should fail here as not all data could be migrated.
 	 DECLARE @lt_reused_volume TABLE
 	 (
 	  old_id int,
 	  new_id int,
 	  old_reformatTime int,
 	  new_reformatTime int,
 	  IsInMediaGroup int
 	 )
 	 INSERT INTO @lt_reused_volume
 	 SELECT b.old_id, b.new_id, a.reformatTime, c.reformatTime, 0
FROM CommServ_Merge..CCM_MMVolume a, CCM_MAP_MMVolume b, MMVolume c
 	 WHERE a.VolumeId = b.old_id
 	   AND b.new_id <> 0
 	   AND b.new_id = c.VolumeId
 	   AND b.exist = 1
 	   AND c.reformatTime > a.reformatTime
 	 IF @@ROWCOUNT > 0
 	 BEGIN
	   SET @errStr = 'ERROR: CCM_Merge_MM -- Reused Volumes in destination commcell' + CHAR(13) + CHAR(10)
	   SELECT @errStr = @errStr +  'Old Volume Id, New Volume Id, Old Reformat Time, New Refomart Time' + CHAR(13) + CHAR(10)
	   SELECT @errStr = @errStr + cast(old_id as varchar(10)) + ',' + cast(new_id as varchar(10)) + ',' + cast (old_reformatTime as varchar(20)) + ',' + cast (new_reformatTime as varchar(20)) + CHAR(13) + CHAR(10) FROM @lt_reused_volume
	   GOTO CX_ERROR_EXIT
 	 END
 	 -- if the media in original commcell have different reformatime compared to current commcell,
     -- also check the MediaInMediaGroup property, in case of the media has been reused and overwritten in original commcell.
	 -- The merge should fail, otherwise the media information in current commcell will be overwritten.
 	 DELETE FROM @lt_reused_volume
     IF @@ERROR > 0
 	 BEGIN
 	   SET @errStr = 'ERROR: CCM_Merge_MM -- @lt_reused_volume - DELETE'
	   GOTO CX_ERROR_EXIT
 	 END
 	 INSERT INTO @lt_reused_volume
 	 SELECT b.old_id, b.new_id, a.reformatTime, c.reformatTime, b.IsInMediaGroup
FROM CommServ_Merge..CCM_MMVolume a, CCM_MAP_MMVolume b, MMVolume c
 	 WHERE a.VolumeId = b.old_id
 	   AND b.new_id <> 0
 	   AND b.new_id = c.VolumeId
 	   AND b.exist = 1
 	   AND c.reformatTime <> a.reformatTime
 	   AND b.IsInMediaGroup <> 0
	   AND b.reformatTimePresent = 1 -- reFormat time isn't stored in Media, for tape import
     IF @@ROWCOUNT > 0
 	 BEGIN
	   SET @errStr = 'ERROR: CCM_Merge_MM -- Media was detected to contain valid data for the destination commserve.'
				   + ' However, it appears that this media was reused and overwritten by the source commserver.'
				   + ' It is possible that this caused data to be overwritten.' + CHAR(13) + CHAR(10)
	   SELECT @errStr = @errStr +  'Old Volume Id, New Volume Id, Old Reformat Time, New Refomart Time, IsInMediaGroup' + CHAR(13) + CHAR(10)
	   SELECT @errStr = @errStr + cast(old_id as varchar(10)) + ',' + cast(new_id as varchar(10)) + ',' + cast (old_reformatTime as varchar(20)) + ',' + cast (new_reformatTime as varchar(20)) + ',' + cast(IsInMediaGroup as varchar(10)) + ',' + CHAR(13) + CHAR(10) FROM @lt_reused_volume
	   GOTO CX_ERROR_EXIT
 	 END
 	-- update existent volumes
    UPDATE MMVolume
	SET VolumeFlags = a.VolumeFlags,
	FlushBlockSizeKB = a.FlushBlockSizeKB,
	NumberOfRestores = a.NumberOfRestores,
	NumberOfBackups = a.NumberOfBackups,
	NumberOfMounts = a.NumberOfMounts,
	NumberOfSoftErrors = a.NumberOfSoftErrors,
	NumberOfHardErrors = a.NumberOfHardErrors,
	LastRestoreTime = a.LastRestoreTime,
	LastBackupTime = a.LastBackupTime,
	LogicalBytesMB = a.LogicalBytesMB,
	PhysicalBytesMB = a.PhysicalBytesMB,
	NumberOfActiveFiles = a.NumberOfActiveFiles,
	LastFile = a.LastFile,
	RecordingFormatId = a.RecordingFormatId,
	ExternalGUID = a.ExternalGUID,
	OMLVersion = a.OMLVersion,
	VolumeState = a.VolumeState,
	VolumeFullReason = a.VolumeFullReason,
	VolumeFullTime = a.VolumeFullTime,
Attributes = CASE WHEN @isRoboImport > 0 THEN a.Attributes | 1024 ELSE a.Attributes END,
	ReformatTime = (CASE b.reformatTimePresent
	                 WHEN 1 THEN a.ReformatTime
	                 ELSE c.ReformatTime
	                END),
	MediaGroupId = (CASE WHEN b.new_MediaGroupId <> 0 AND c.MediaGroupId = 0
					 THEN b.new_MediaGroupId
					 ELSE c.MediaGroupId
					END),
	origCCcommCellID = b.new_origCCcommCellID,
	origCCvolumeID = b.old_origCCvolumeID,
	SiloStatus = a.SiloStatus
FROM CommServ_Merge..CCM_MMVolume a, CCM_MAP_MMVolume b , MMVolume c
	WHERE a.VolumeId = b.old_id
	AND b.new_id = c.VolumeId
	AND b.new_id <> 0
	AND b.exist = 1
 	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- MMVolume -- UPDATE'
		GOTO CX_ERROR_EXIT
	 END
	 UPDATE CCM_MAP_MMVolume
	 SET SpareGroupId = b.SpareGroupId, DrivePoolId = b.DrivePoolId
	 FROM CCM_MAP_MMVolume a, MMMediaGroup b, MMMedia c
	 WHERE a.RecordingFormatId <> 10001
	   AND c.LibraryId = 0
	   AND a.new_MediaId = c.MediaId
	   AND a.new_MediaGroupId = b.MediaGroupId
 	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE -- SpareGroupId,DrivePoolId'
		GOTO CX_ERROR_EXIT
	 END
	 IF EXISTS (SELECT a.old_id FROM CCM_MAP_MMVolume a, MMMedia b
                WHERE a.new_MediaId = b.MediaId
                  AND a.RecordingFormatId <> 10001
                  AND b.LibraryId = 0
                  AND (a.SpareGroupId is null OR a.DrivePoolId is null)
               )
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- MMVolume -- GET MediaGroup'
		GOTO CX_ERROR_EXIT
	 END
	 UPDATE CCM_MAP_MMVolume
	 SET LibraryId = b.LibraryId
	 FROM CCM_MAP_MMVolume a, MMSpareGroup b, MMMedia c
	 WHERE a.RecordingFormatId <> 10001
	   AND c.LibraryId = 0
	   AND a.new_MediaId = c.MediaId
	   AND a.SpareGroupId = b.SpareGroupId
 	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE -- LibraryId'
		GOTO CX_ERROR_EXIT
	 END
	-- spare group id could be zero if put into shelf --
	 UPDATE MMMedia
	 SET SpareGroupId = a.SpareGroupId,
	     LibraryId = a.LibraryId
	 FROM CCM_MAP_MMVolume a, MMMedia b
	 WHERE a.RecordingFormatId <> 10001
	   AND b.LibraryId = 0
	   AND a.new_MediaId = b.MediaId
	   AND b.MediaTypeId in (select distinct MediaTypeId from MMRecFmtMedTyp where DriveTypeId in (select distinct DriveTypeId from MMDrive))
	-- Getlist of Drives from MMDrive , Get list of MediaTypes from MMRecFmtMedTyp for those Drives
	-- Set new libary id's only if the mediaTypeId exist in that MediaType List
	-- Others will get library id as 0, So that they get into the orphaned media List
 	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- MMMedia -- UPDATE -- SpareGroupId,LibraryId'
		GOTO CX_ERROR_EXIT
	 END
	 -- update mapping table with new volume ids
     UPDATE CCM_MAP_MMVolume
     SET new_id = old_id
     WHERE exist = 0
       AND reuseOldId = 1
 	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE -- new_id for reusedOldId'
		GOTO CX_ERROR_EXIT
	 END
     -- update mapping table with new volume ids
     UPDATE CCM_MAP_MMVolume
     SET new_id = c.VolumeId
FROM CommServ_Merge..CCM_MMVolume a, CCM_MAP_MMVolume b, MMVolume c
     WHERE a.VolumeId = b.old_id
       AND b.exist = 0
       AND b.reuseOldId = 0
       AND c.origCCcommCellID = b.new_origCCcommCellID
       AND c.origCCvolumeID = a.VolumeId
 	 IF @@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM -- CCM_MAP_MMVolume -- UPDATE -- new_id for non-reusedOldId'
		GOTO CX_ERROR_EXIT
	 END
	 IF EXISTS(SELECT * FROM CCM_MAP_MMVolume WHERE new_id = 0)
	 BEGIN
	    SET @errStr = 'ERROR: CCM_Merge_MM -- unknown new volumes ids'
		GOTO CX_ERROR_EXIT
	 END
		IF @isTapeImport = 1
		BEGIN
			UPDATE MMMediaSide
			SET PhysicalBytesMB =ISNULL( (	SELECT SUM(X.physicalSize/(1024*1024)) FROM archFileCopy x ,(
									SELECT DISTINCT F.archFileId,F.commCellId
									FROM MMMediaSide C,MMVolume D, archChunk E, archChunkMapping F
									WHERE C.MediaId=D.MediaId AND D.VolumeId=E.volumeId AND E.id = F.archChunkId AND E.commCellId = F.commCellId AND A.MediaId = C.MediaId
									)AS Y WHERE X.archFileId=Y.archFileId AND X.commCellId = Y.commCellId ),0),
			LogicalBytesMB		=ISNULL((	SELECT SUM(X.logicalSize/(1024*1024)) FROM archFileCopy x ,(
									SELECT DISTINCT F.archFileId,F.commCellId
									FROM MMMediaSide C,MMVolume D, archChunk E, archChunkMapping F
									WHERE C.MediaId=D.MediaId AND D.VolumeId=E.volumeId AND E.id = F.archChunkId AND E.commCellId = F.commCellId AND A.MediaId = C.MediaId
									)AS Y WHERE X.archFileId=Y.archFileId AND X.commCellId = Y.commCellId ),0)
			FROM MMMediaSide A,CCM_MAP_MMMedia B
			WHERE A.MediaId=B.new_id
			IF @@ERROR > 0
			BEGIN
				SET @errStr = 'CCM_Merge_Main -- UPDATE MMMediaSide for TapeImport'
				GOTO CX_ERROR_EXIT
			END
			UPDATE MMVolume
			SET PhysicalBytesMB=B.PhysicalBytesMB , LogicalBytesMB=B.LogicalBytesMB
			FROM MMVolume A, MMMediaSide B, CCM_MAP_MMMedia C
			WHERE A.MediaId = B.MediaId AND B.MediaId = C.new_id
			IF @@ERROR > 0
			BEGIN
				SET @errStr = 'CCM_Merge_Main -- UPDATE MMVolume for TapeImport'
				GOTO CX_ERROR_EXIT
			END
		END
	END
	-- End MMVolume --
	-----------------------------------------------------------------------------
	--Merge MMEntityProp
	--PrasadNara: Don't set the new commcellid, We don't have option to change the owner of the copy
	--When we give option to set the owner of the copy then we can rollback this change.
	--UPDATE CCM_DB_MMENTITYPROP SET intVal = b.new_id
	--FROM CCM_DB_MMENTITYPROP a inner join CCM_MAP_CommCell b on a.intVal = b.old_id AND a.propertyName = 'GRCOwnerCommCellId'
	--IF @@ERROR > 0
	--BEGIN
	--	SET @errStr = 'ERROR: CCM_Merge_MM - MMEntityProp -Update Owner CommCellId'
	--	GOTO CX_ERROR_EXIT
	--END
	UPDATE MMEntityProp SET intVal = a.intVal, longlongVal = a.longlongVal, stringVal = a.stringVal
FROM CommServ_Merge..CCM_MMEntityProp a, CCM_Map_ArchGroup b, MMEntityProp c
WHERE a.EntityId = b.old_id AND a.EntityType = 1 AND b.new_id = c.EntityId AND c.EntityType = 1
	AND a.propertyName = c.propertyName AND a.modified > c.modified
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM - MMEntityProp -ArchGroup prop - Update failed'
		GOTO CX_ERROR_EXIT
	END
	UPDATE MMEntityProp SET intVal = a.intVal, longlongVal = a.longlongVal, stringVal = a.stringVal
FROM CommServ_Merge..CCM_MMEntityProp a, CCM_Map_ArchGroupCopy b, MMEntityProp c
WHERE a.EntityId = b.old_id AND a.EntityType = 2 AND b.new_id = c.EntityId AND c.EntityType = 2
	AND a.propertyName = c.propertyName AND a.modified > c.modified
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM - MMEntityProp -ArchGroupCopy prop - Update failed'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO MMEntityProp
	SELECT b.new_id, a.EntityType, a.propertyName, a.propDataType, a.intVal, a.longlongVal, a.stringVal, a.created, a.modified, d.new_id
FROM CommServ_Merge..CCM_MMEntityProp a inner join CCM_Map_ArchGroup b ON a.EntityId = b.old_id AND a.EntityType = 1
	inner join CCM_MAP_CommCell d ON a.CommCellId = d.old_id
left outer join MMEntityProp c ON b.new_id = c.EntityId AND c.EntityType = 1 AND a.propertyName = c.propertyName
	WHERE c.EntityId is null
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM - MMEntityProp -ArchGroup prop - Insert failed'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO MMEntityProp
	SELECT b.new_id, a.EntityType, a.propertyName, a.propDataType, a.intVal, a.longlongVal, a.stringVal, a.created, a.modified, d.new_id
FROM CommServ_Merge..CCM_MMEntityProp a inner join CCM_Map_ArchGroupCopy b ON a.EntityId = b.old_id AND a.EntityType = 2
	inner join CCM_MAP_CommCell d ON a.CommCellId = d.old_id
left outer join MMEntityProp c ON b.new_id = c.EntityId AND c.EntityType = 2 AND a.propertyName = c.propertyName
	WHERE c.EntityId is null
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_MM - MMEntityProp -ArchGroupCopy prop - Insert failed'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------------------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	IF (Cursor_Status('LOCAL', 'CopyIdCursor') >= -1)
	BEGIN
		CLOSE CopyIdCursor
		DEALLOCATE CopyIdCursor
	END
	RETURN (-1)
	---------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_MM')
	delete from GxQscripts where name = 'CCM_Merge_MM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_MM')
	delete from GXDBVersions where aliasname = 'CCM_Merge_MM'
GO

insert into GXDBVersions values(2, 'CCM_Merge_MM',  '00010143007800030000', 'CCM_Merge_MM', '00010143007800030000')
GO

