

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_JOB_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge tables:
--	|					JMJobAction
--	|					JMJobStats
--	|					JMBkpStats
--	|					JMBkpAtmptStats
--	|					JMAdminJobStatsTable
--	|					JMAdminJobAttemptStatsTable
--	|					JMJobOptions
--	|					JobDataLink
--	|					JMJobSnapshotStats
--	|					JMJobDataStats
--	|					JMOracleRACClientsUsed
--	|					archCheckHistory
--  +========================================================================+
-- $Id: CCM_Merge_JOB_from_XML.sp,v 1.3.72.3 2018/12/27 16:38:48 vikashkumar Exp $
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCM_Merge_JOB_from_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Merge_JOB_from_XML <<<'
	drop procedure CCM_Merge_JOB_from_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Merge_JOB_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_JOB_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_JOB_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_JOB_from_XML'
GO
print '... Creating Procedure: CCM_Merge_JOB_from_XML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCM_Merge_JOB_from_XML
  @isTapeImport integer,
  @i_mergeActivityControl integer,
  @ccmParamFlags integer = 0,
  @i_jobId integer, 
  @errStr varchar(1024) OUTPUT
AS
	---------------------------------------------------------
--Code below here is from CCM_Merge_Job.spb--
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	DECLARE @l_curImportJobId Integer
	SET @l_curImportJobId =  ISNULL
	(
		(
			@i_jobId
		), 0
	)
	---------------------------------------------------------
	IF @i_mergeActivityControl > 0
	BEGIN
	-- Merge JMJobAction Table
	DECLARE @SQLQuery NVARCHAR(MAX)
	-- Create two default entry for each client newly migrated
IF COL_LENGTH('TEMPDB..#CCM_JMJobAction','reason') IS NOT NULL
	BEGIN
		SET @SQLQuery = N'
		INSERT	INTO CCM_MAP_JobAction
		SELECT	clientId, 0, mediaAgentID, appType, opType, action, appId, 0, clientGroupId, instanceID, 0, 0, reason
FROM	#CCM_JMJobAction '
	END
	ELSE
	BEGIN
		SET @SQLQuery = N'
		INSERT	INTO CCM_MAP_JobAction
		SELECT	clientId, 0, mediaAgentID, appType, opType, action, appId, 0, clientGroupId, 1, 1, 0, ''''
FROM	#CCM_JMJobAction '
	END
	EXEC (@SQLQuery)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JobAction -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JobAction SET new_clientId = old_clientId
	WHERE old_clientId = 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JobAction -- UPDATE new_clientId to 1'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JobAction SET new_clientId = b.new_id
	FROM CCM_MAP_JobAction a, CCM_MAP_Client b
	WHERE a.old_clientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JobAction -- UPDATE new_clientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JobAction SET new_instanceID = b.new_id
	FROM CCM_MAP_JobAction a, CCM_MAP_InstanceName b
	WHERE a.old_instanceID = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JobAction -- UPDATE new_instanceID'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JobAction SET new_appId = b.new_id
	FROM CCM_MAP_JobAction a, CCM_MAP_Application b
	WHERE a.old_appId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JobAction -- UPDATE new_appId 1'
		GOTO CX_ERROR_EXIT
	END
	/*
	Most cases it should always 1. But why take chance
	*/
	DECLARE @sourceActivityControlAppId   INTEGER
	DECLARE @destActivityControlAppId   INTEGER
SET @sourceActivityControlAppId = ISNULL((SELECT TOP 1 id FROM #CCM_App_Application WHERE appTypeId = 1000),0)
	SET @destActivityControlAppId   = ISNULL((SELECT TOP 1 id FROM APP_Application WHERE appTypeId = 1000),0)
	IF (@sourceActivityControlAppId = 0 OR @destActivityControlAppId = 0) AND (@isTapeImport = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- AppId For ActivityControl Not Found in the database'
		GOTO CX_ERROR_EXIT
	END
	IF @sourceActivityControlAppId = 0 SET @sourceActivityControlAppId = 1
	IF @destActivityControlAppId = 0   SET @destActivityControlAppId = 1
	-- Reset appId during merge to new default appId
	UPDATE	CCM_MAP_JobAction SET new_appId = @destActivityControlAppId
	WHERE	old_appId = @sourceActivityControlAppId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JobAction -- UPDATE new_appId 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_JobAction SET exist = 1
	FROM	CCM_MAP_JobAction a, JMJobAction b
	WHERE	a.new_clientId = b.clientId and a.mediaAgentID = b.mediaAgentID
	AND		a.appType = b.appType and a.optype = b.optype
	AND		a.new_appId = b.appId and a.clientGroupId = b.clientGroupId
	AND		a.new_instanceID = b.instanceID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JobAction -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO JMJobAction
	SELECT	new_clientId, mediaAgentID, appType, opType, action, new_appId, clientGroupId, 0, 0, 0, new_instanceID, reason
	FROM	CCM_MAP_JobAction
	WHERE	exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobAction -- INSERT '
		GOTO CX_ERROR_EXIT
	END
	END
	---------------------------------------------------------
	-- Merge JMJobStats Table
	INSERT	INTO CCM_MAP_JMJobStats
	SELECT	commCellId, 0, jobId, 0
FROM	#CCM_JMJobStats
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobStats -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobStats SET new_commCellId = b.new_id
	FROM CCM_MAP_JMJobStats a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobStats -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobStats SET exist = 1
	FROM CCM_MAP_JMJobStats a, JMJobStats b
	WHERE a.jobId = b.jobId AND a.new_commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobStats -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO JMJobStats
	SELECT	b.jobId, b.status, b.opType, a.new_commCellId, b.jobCategory, b.jobDescription, b.xmlJobInfo, b.subOpType, b.foreignToken
FROM	CCM_MAP_JMJobStats a, #CCM_JMJobStats b
	WHERE	a.jobId = b.jobId
	AND		a.old_commCellId = b.commCellId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobStats -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE JMJobStats
	SET    jobDescription = c.jobDescription
FROM   JMJobStats a, CCM_MAP_JMJobStats b, #CCM_JMJobStats c
	WHERE  a.jobId = b.jobId
	  AND  a.commCellId = b.new_commCellId
	  AND  c.jobId = b.jobId
	  AND  c.commCellId = b.old_commCellId
	  AND  b.exist = 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobStats -- UPDATE -- jobDescription'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge JMBkpStats Table
	INSERT	INTO CCM_MAP_JMBkpStats
	SELECT	DISTINCT commCellId, 0, appId, 0, dataArchGrpId, 0, logArchGrpId, 0, diffArchGrpId, 0, jobId, 0
FROM	#CCM_JMBkpStats
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMBkpStats -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMBkpStats SET new_commCellId = b.new_id
	FROM CCM_MAP_JMBkpStats a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMBkpStats -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMBkpStats SET new_appId = b.new_id
	FROM CCM_MAP_JMBkpStats a, CCM_MAP_Application b
	WHERE a.old_appId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMBkpStats -- UPDATE new_appId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMBkpStats SET new_dataArchGrpId = b.new_id
	FROM CCM_MAP_JMBkpStats a, CCM_MAP_ArchGroup b
	WHERE a.old_dataArchGrpId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMBkpStats -- UPDATE new_dataArchGrpId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMBkpStats SET new_logArchGrpId = b.new_id
	FROM CCM_MAP_JMBkpStats a, CCM_MAP_ArchGroup b
	WHERE a.old_logArchGrpId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMBkpStats -- UPDATE new_logArchGrpId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMBkpStats SET new_diffArchGrpId = b.new_id
	FROM	CCM_MAP_JMBkpStats a, CCM_MAP_ArchGroup b
	WHERE	a.old_diffArchGrpId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMBkpStats -- UPDATE new_diffArchGrpId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMBkpStats SET exist = 1
	FROM CCM_MAP_JMBkpStats a, JMBkpStats b
	WHERE a.jobId = b.jobId AND a.new_commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMBkpStats -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------------------------------------------
	-- Update GXCounter's Job_Counter with maximum jobId after Merge into JMJobStats
	-- JMJobStats tracks all kinds of jobs including Admin, Backup, Aging Jobs.
	DECLARE @maxJobCounter INTEGER
	SET @maxJobCounter = 0
	SET @maxJobCounter = ISNULL((SELECT max(jobId) FROM JMJobStats where commCellId = 2),0)
	IF EXISTS (SELECT * FROM GXCounter WHERE name = 'Job_Counter' AND next_l < @maxJobCounter)
	BEGIN
	 UPDATE GXCounter
	 SET next_l = @maxJobCounter
	 WHERE name = 'Job_Counter'
	 IF	@@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- GXCounter -- UPDATE'
		GOTO CX_ERROR_EXIT
	 END
	END
	ELSE IF NOT EXISTS (SELECT * FROM GXCounter WHERE name = 'Job_Counter')
	BEGIN
	 INSERT INTO GXCounter VALUES ('Job_Counter',0,@maxJobCounter)
	 IF	@@ERROR > 0
	 BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- GXCounter -- INSERT'
		GOTO CX_ERROR_EXIT
	 END
	END
	---------------------------------------------------------------------------------------------
	INSERT	INTO JMBkpStats
	SELECT	DISTINCT b.jobId, a.new_commCellId, a.new_appId, b.appType,
			b.numAttempts, a.new_dataArchGrpId, b.copyId, b.bkpLevel, b.indexOverride,
			b.status, b.duration, b.numStreams, b.servStartDate, b.servEndDate,
			b.opType, b.fullCycleNum, b.initFrom, '' /*b.failureReason*/, b.bkpOptions,
			b.scanFileFailures, b.scanFolderFailures, b.backupFileFailures,
			b.backupFolderFailures, b.oraSubLevel, b.username, b.totalWriteTime,
			b.priority, b.totalCompBytes, b.totalUncompBytes, b.totalNumOfFiles,
			b.bkpattributes, a.new_logArchGrpId, b.totalNumOfFolders,
			b.failureErrorCode, b.lastIncrJobTime, b.scanType,
			b.scanTypeChangeReason, b.numStreamsRequested,
			b.dataStatus, b.agedTime, b.mediaDeletedTime, dbo.GetUnixTime(GetUTCDate()),
			b.version, b.idaVersion, b.cIndexTime, b.cycleSequence, b.filesToXfer, 0, a.new_diffArchGrpId,
			b.totalBackupSize, b.percentageChange, b.targetClientId,
			b.totalUncompBytesToXfer, b.displayStatus, b.dataBackedUp, b.logsBackedUp, b.openChain,
			b.secondaryBkpLevel, b.jobIdPrepared, b.jobIdActedOn, b.fromTime, b.toTime, 0,  -- The schedule (subTaskId) isn't migrated
			b.nwTransBytes, b.totSkippedObjects, b.bkpAttributesEx, b.jobReferenceTime
FROM	CCM_MAP_JMBkpStats a, #CCM_JMBkpStats b
	WHERE	a.jobId = b.jobId
	AND		a.old_commCellId = b.commCellId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE JMBkpStats
	SET    status           = c.status,
	       mediaDeletedTime = c.mediaDeletedTime,
	       dataStatus       = c.dataStatus,
	       agedTime         = c.agedTime
FROM   CCM_MAP_JMBkpStats a, JMBkpStats b, #CCM_JMBkpStats c
	WHERE  a.jobId = b.jobId
	AND	   a.new_commCellId = b.commCellId
	AND	   a.jobId = c.jobId
	AND	   a.old_commCellId = c.commCellId
	AND	   a.exist = 1
		   AND (NOT EXISTS (SELECT * FROM App_Application WHERE id = b.appId))
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- UPDATE existing -- status, mediaDeletedTime, dataStatus, agedTime'
		GOTO CX_ERROR_EXIT
	END
	-- cliu, Update Form 4039
	-- When Job is deleted, entry in JMBkpStats table might not be removed and still used for QNet.
	-- If will be completely removed after 7 days after deletion.
	-- If the job still exists in table JMBkpStats and DataStatus is set to 2 or 3, or AppId is different from the mapping table,
	-- update it with the latest value.
	--		DATA_STATUS_VALID=0,
	--		DATA_STATUS_AGED = 1,
	--		DATA_STATUS_MEDIADELETED = 2,
	--		DATA_STATUS_NODATA = 3
	UPDATE JMBkpStats
	SET		appId			= a.new_appId,
			dataArchGrpId	= a.new_dataArchGrpId,
			logArchGrpId	= a.new_logArchGrpId,
			diffArchGrpId	= a.new_diffArchGrpId,
			dataStatus		= c.dataStatus,
			status           = c.status,
			mediaDeletedTime = c.mediaDeletedTime,
			agedTime         = c.agedTime,
			fullCycleNum	 = c.fullCycleNum
FROM	CCM_MAP_JMBkpStats a, JMBkpStats b, #CCM_JMBkpStats c
	WHERE	a.jobId = b.jobId
	AND		a.new_commCellId = b.commCellId
	AND		a.jobId = c.jobId
	AND		a.old_commCellId = c.commCellId
	AND		a.exist = 1
	AND		(b.DataStatus in (2, 3) OR NOT EXISTS (SELECT * FROM App_Application WHERE id = b.appId))
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- UPDATE existing with DataStatus (2, 3)'
		GOTO CX_ERROR_EXIT
	END
	UPDATE JMBkpStats
	SET    modifiedTime     = c.modifiedTime
FROM   CCM_MAP_JMBkpStats a, JMBkpStats b, #CCM_JMBkpStats c
	WHERE  a.jobId = b.jobId
	AND	   a.new_commCellId = b.commCellId
	AND	   a.jobId = c.jobId
	AND	   a.old_commCellId = c.commCellId
	AND	   a.exist = 1
	AND    c.modifiedTime > b.modifiedTime
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- UPDATE existing -- modifiedTime'
		GOTO CX_ERROR_EXIT
	END
	declare @skipUpdate integer = 0
	SET @skipUpdate = ISNULL((SELECT value from MMConfigs where name = 'CCM_CONFIG_SKIP_UPDATE_JOB_DATA_STATUS'),0)
	IF @isTapeImport=1
	BEGIN
		UPDATE JMBkpStats
		SET dataArchGrpId = (SELECT new_id FROM CCM_MAP_ArchGroup WHERE old_id = B.old_dataArchGrpId)
		FROM JMBkpStats A INNER JOIN CCM_MAP_JMBkpStats B ON A.jobId = B.jobId AND A.commCellId = B.new_commCellId
		WHERE B.exist = 1  AND NOT EXISTS (SELECT 1 FROM archGroup WHERE id = A.dataArchGrpId)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- UPDATE existing -- dataArchGrpId in TapeImport'
			GOTO CX_ERROR_EXIT
		END
		UPDATE JMBKP
		SET totalBackupSize = (SELECT TOP 1 ISNULL(SUM(ACM.physicalSize),0) FROM archChunkMapping ACM  WHERE JMBKP.jobId = ACM.jobId AND JMBKP.commCellId = ACM.commCellId GROUP BY ACM.archCopyId)
		FROM JMBkpStats JMBKP INNER JOIN CCM_MAP_JMBkpStats B ON JMBKP.jobId = B.jobId AND JMBKP.commCellId = B.new_commCellId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- UPDATE existing -- totalBackupSize in TapeImport'
			GOTO CX_ERROR_EXIT
		END
	END
	ELSE
	BEGIN
		-- If sp or copy is deleted, then we still have entries in JMBkpStats table, we need to update them.
        UPDATE JMBkpStats
        SET     dataArchGrpId = a.new_dataArchGrpId,
                logArchGrpId = a.new_logArchGrpId,
                agedTime = b.agedTime,
                mediaDeletedTime = b.mediaDeletedTime,
                modifiedTime = b.modifiedTime
FROM    CCM_MAP_JMBkpStats a, #CCM_JMBkpStats b, JMBkpStats c
        WHERE   a.jobId = b.jobId AND a.old_commCellId = b.commCellId AND a.old_dataArchGrpId = b.dataArchGrpId AND a.old_logArchGrpId = b.logArchGrpId
        AND     a.jobId = c.jobId AND a.new_commCellId = c.commCellId
        AND     exist = 1
        AND     (
					(c.agedTime > 0)
					OR
					(
						((@ccmParamFlags & 1) > 0)
						 AND @skipUpdate = 0
					)
				)
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- UPDATE existing -- dataArchGrpId and logArchGrpId.'
			GOTO CX_ERROR_EXIT
		END
		-- kbora
		-- Update all the job's appType belongs to a subclient.
		UPDATE JMBkpStats
		SET appType = C.appTypeId
		FROM JMBkpStats A, CCM_TapeImportEntities B, APP_Application C
WHERE A.appId = B.new_id AND B.entityType = 7  AND A.appId = C.id
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'CCM_Merge_Main -- UPDATE JMBkpStats appType for tapeimported jobs'
			GOTO CX_ERROR_EXIT
		END
		-- Update all the job's details. the above uupdate is needed becuase when tape import brings one subcliets 10 jobs, and when ccm brings the same subclient 5 jobs, the other 5
		-- jobs brought by tape import can not be updated for appType. so we should keep that.
		UPDATE JMBkpStats
		SET appType = C.appType,
			numAttempts = C.numAttempts,
			bkpLevel = C.bkpLevel,
			indexOverride = C.indexOverride,
			status = C.status,
			duration = C.duration,
			numStreams = C.numStreams,
			servStartDate = C.servStartDate,
			servEndDate = C.servEndDate,
			opType = C.opType,
			fullCycleNum = C.fullCycleNum,
			initFrom = C.initFrom,
			failureReason = C.failureReason,
			bkpOptions = C.bkpOptions,
			scanFileFailures = C.scanFileFailures,
			scanFolderFailures = C.scanFolderFailures,
			backupFileFailures = C.backupFileFailures,
			backupFolderFailures = C.backupFolderFailures,
			oraSubLevel = C.oraSubLevel,
			username = C.username,
			totalWriteTime = C.totalWriteTime,
			priority = C.priority,
			totalCompBytes = C.totalCompBytes,
			totalUncompBytes = C.totalUncompBytes,
			totalNumOfFiles = C.totalNumOfFiles,
			bkpattributes = C.bkpattributes,
		--	logArchGrpId = C.logArchGrpId talk to prasad.
			totalNumOfFolders = C.totalNumOfFolders,
			failureErrorCode = C.failureErrorCode,
			lastIncrJobTime = C.lastIncrJobTime,
			scanType = C.scanType,
			scanTypeChangeReason = C.scanTypeChangeReason,
			numStreamsRequested = C.numStreamsRequested,
			dataStatus = C.dataStatus,
			agedTime = C.agedTime,
			mediaDeletedTime = C.mediaDeletedTime,
			modifiedTime = C.modifiedTime,
			version = C.version,
			idaVersion = C.idaVersion,
			cIndexTime = C.cIndexTime,
			cycleSequence = C.cycleSequence,
			filesToXfer = C.filesToXfer,
		--	cloudId = C.cloudId,
		--	diffArchGrpId = C.diffArchGrpId talk to prasad.
			totalBackupSize = C.totalBackupSize,
			percentageChange = C.percentageChange,
		--	targetClientId = C.targetClientId,
			totalUncompBytesToXfer = C.totalUncompBytesToXfer,
			displayStatus = C.displayStatus,
			dataBackedUp = C.dataBackedUp,
			logsBackedUp = C.logsBackedUp,
			openChain = C.openChain,
			secondaryBkpLevel = C.secondaryBkpLevel,
		--	jobIdPrepared = C.jobIdPrepared,
		--	jobIdActedOn = C.jobIdActedOn,
			fromTime = C.fromTime,
			toTime = C.toTime,
		--	subTaskId = C.subTaskId,
			nwTransBytes = C.nwTransBytes,
			totSkippedObjects = C.totSkippedObjects,
			bkpAttributesEx = C.bkpAttributesEx,
			jobReferenceTime = C.jobReferenceTime
FROM JMBkpStats A, CCM_TapeImportEntities B, #CCM_JMBkpStats C, CCM_MAP_CommCell D
WHERE A.jobId = C.jobId AND A.commCellId = D.new_id AND C.commCellId = D.old_id AND A.appId = B.new_id AND B.entityType = 7
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'CCM_Merge_Main -- UPDATE JMBkpStats  for tapeimported jobs'
			GOTO CX_ERROR_EXIT
		END
	END
	---------------------------------------------------------
	-- Merge JMBkpAtmptStats Table
	INSERT	INTO CCM_MAP_JMBkpAtmptStats
	SELECT	commCellId, 0, archGrpId, 0, copyId, 0, jobId, number, phase, 0
FROM	#CCM_JMBkpAtmptStats
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMBkpAtmptStats -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMBkpAtmptStats SET new_commCellId = b.new_id
	FROM CCM_MAP_JMBkpAtmptStats a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMBkpAtmptStats -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMBkpAtmptStats SET new_archGrpId = b.new_id
	FROM CCM_MAP_JMBkpAtmptStats a, CCM_MAP_ArchGroup b
	WHERE a.old_archGrpId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMBkpAtmptStats -- UPDATE new_archGrpId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMBkpAtmptStats SET new_copyId = b.new_id
	FROM CCM_MAP_JMBkpAtmptStats a, CCM_MAP_ArchGroupCopy b
	WHERE a.old_copyId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMBkpAtmptStats -- UPDATE new_copyId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_JMBkpAtmptStats SET exist = 1
	FROM	CCM_MAP_JMBkpAtmptStats a, JMBkpAtmptStats b
	WHERE	a.jobId = b.jobId
	AND		a.new_commCellId = b.commCellId AND a.new_copyId = b.copyId
	AND		a.number = b.number AND a.phase = b.phase
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMBkpAtmptStats -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO JMBkpAtmptStats
	SELECT	b.jobId, b.number, b.phase, b.elapsedTime,
			b.servStartDate, b.servEndDate, b.unCompBytes, b.compBytes,
			b.numObjects, b.status, b.failureReason, b.writetime,
			b.restartString, b.attributes, a.new_commCellId, b.numFolders,
			a.new_archGrpId, a.new_copyId, b.maxStreamsUsed, b.modifiedTime, b.nwTransBytes, b.totalAllocationTime, b.totalWaitTimeBeforeAllocation,
			b.readThroughput, b.writeThroughput, b.networkThroughput, b.sidbLookups, b.mediaAgent
FROM	CCM_MAP_JMBkpAtmptStats a, #CCM_JMBkpAtmptStats b
	WHERE	a.jobId = b.jobId
	AND		a.old_commCellId = b.commCellId
	AND		a.old_copyId = b.copyId
	AND		a.number = b.number AND a.phase = b.phase
	AND		a.exist <> 1
	AND		a.new_copyId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpAtmptStats -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge CCM_JMFailureReasonMsg Table
	--       CCM_JMFailureReasonMsgParam Table
	DECLARE @failureMessageId           INT
	DECLARE @newMessageId               INT
	DECLARE @failureMessageJobId        INT
	DECLARE @failureMessageCommCellId   INT
	DECLARE @CCM_JMFailureReasonMsgHelper	TABLE
	(	sortOrder int identity(1,1) primary key,
		jobId int,
		old_commCellId int,
		new_commCellId int,
		old_id int
	)
	-- Insert all the applicable failure reasons of job into helper table
	INSERT INTO @CCM_JMFailureReasonMsgHelper
	SELECT BKP.jobId, BKP.commCellId, MAP.new_commCellId, CAST(JMFR._ID AS INT)
	FROM CCM_MAP_JMBkpStats MAP
INNER JOIN #CCM_JMBkpStats BKP ON MAP.jobId = BKP.jobId AND MAP.old_commCellId = BKP.commCellId AND MAP.exist <> 1
	CROSS APPLY dbo.CCM_SplitStringByToken(BKP.failureReason, ',') AS JMFR
	-- Insert failure reasons one by one and update new failureReasonId in DB.
	DECLARE GetNextFailureMsgID CURSOR LOCAL FAST_FORWARD
	FOR SELECT old_id, jobId, new_commCellId FROM @CCM_JMFailureReasonMsgHelper
	OPEN GetNextFailureMsgID
	FETCH GetNextFailureMsgID INTO @failureMessageId, @failureMessageJobId, @failureMessageCommCellId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO JMFailureReasonMsg
					(messageId, paramNum, errorType, commCellId, jobId, client, subsystem,
					 copyId, rcId, reservationId, flags, guiAlertColorLevel, clientVersion,
					 serverVersion, iDA, opType, phaseNumber, customMessageId, failureReasonTime)
		SELECT	messageId, paramNum, errorType, @failureMessageCommCellId, jobId, client, subsystem,
				copyId, rcId, reservationId, flags, guiAlertColorLevel, clientVersion,
				serverVersion, iDA, opType, phaseNumber, customMessageId, failureReasonTime
FROM	#CCM_JMFailureReasonMsg A
		WHERE	id = @failureMessageId
				AND NOT EXISTS ( SELECT  id
					                FROM    JMFailureReasonMsg
					                WHERE   messageId = A.messageId
					                        AND commcellId = @failureMessageCommCellId
					                        AND jobId = @failureMessageJobId )
		IF @@ROWCOUNT = 1
		BEGIN
            SET @newMessageId = SCOPE_IDENTITY()
            IF @newMessageId IS NOT null
			BEGIN
		        INSERT	INTO JMFailureReasonMsgParam
		        SELECT	@newMessageId, eventid, position, type, size, data
FROM	#CCM_JMFailureReasonMsgParam
		        WHERE	msgId = @failureMessageId
				UPDATE  JMBkpStats
				SET     failureReason = ISNULL(failureReason, '') + CAST(@newMessageId AS VARCHAR(30) ) + ','
				WHERE   jobId = @failureMessageJobId
				AND		commCellId = @failureMessageCommCellId
				AND		LEN(ISNULL(failureReason, '') + CAST(@newMessageId AS VARCHAR(30) ) + ',') < 256  --CVMAXMESSAGEIDLENGTH
			END
        END
		FETCH GetNextFailureMsgID INTO @failureMessageId, @failureMessageJobId, @failureMessageCommCellId
	END
	CLOSE GetNextFailureMsgID
	DEALLOCATE GetNextFailureMsgID
	---------------------------------------------------------
	---------------------------------------------------------
	-- Merge JMAdminJobStatsTable Table
	INSERT	INTO CCM_MAP_JMAdminJobStatsTable
	SELECT	commCellId, 0, appId, 0, archGrpId, 0, archGrpName, '', jobId, 0
FROM	#CCM_JMAdminJobStatsTable
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMAdminJobStatsTable -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMAdminJobStatsTable SET new_commCellId = b.new_id
	FROM CCM_MAP_JMAdminJobStatsTable a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMAdminJobStatsTable -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMAdminJobStatsTable SET new_appId = b.new_id
	FROM CCM_MAP_JMAdminJobStatsTable a, CCM_MAP_Application b
	WHERE a.old_appId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMAdminJobStatsTable -- UPDATE new_appId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMAdminJobStatsTable SET new_archGrpId = b.new_id
	FROM CCM_MAP_JMAdminJobStatsTable a, CCM_MAP_ArchGroup b
	WHERE a.old_archGrpId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMAdminJobStatsTable -- UPDATE new_archGrpId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMAdminJobStatsTable SET new_archGrpId = b.new_id
	FROM CCM_MAP_JMAdminJobStatsTable a, CCM_MAP_ArchGroup b
	WHERE a.old_archGrpId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMAdminJobStatsTable -- UPDATE new_archGrpName'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMAdminJobStatsTable SET exist = 1
	FROM CCM_MAP_JMAdminJobStatsTable a, JMAdminJobStatsTable b
	WHERE a.jobId = b.jobId AND a.new_commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMAdminJobStatsTable -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO JMAdminJobStatsTable
	SELECT	b.jobId, b.opType, b.status,
			b.servStart, b.servEnd, a.new_archGrpID, a.new_archGrpName,
			b.AP_NumDays, b.AP_IsForecast, b.AP_SeqNum, b.AC_NewMediaFlag,
			b.ER_BkpLevel, b.ER_DbName, b.ER_Destination, b.ER_SendCount,
			b.ER_MediasUsed, b.EX_TotalMedia, b.EX_TotalSuccess, b.EX_TotalFailures,
			b.initFrom, b.failureReason, b.archGrpCopyID, b.LibraryID,
			b.MI_InventoryType, b.username, b.totalWriteTime, b.noOfStreams,
			b.priority, a.new_commCellId, a.new_appId, b.failureErrorCode, b.TotalSize, b.fullCycleNum,
			b.dataStatus, b.workFlowId, b.embeddedObjects, b.uncompBytes, b.numFiles, b.skippedItems, b.jobFlags, 0,
			b.successIndex, b.failIndex, b.totalBackupSize, b.version, b.fromTime, b.toTime, 0, b.otherOpName, -- The schedule (subTaskId) isn't migrated
			b.nwTransBytes
FROM	CCM_MAP_JMAdminJobStatsTable a, #CCM_JMAdminJobStatsTable b
	WHERE	a.jobId = b.jobId
	AND		a.old_commCellId = b.commCellId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMAdminJobStatsTable -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- cliu, Update Form 4039
	-- When Job is deleted, entry in JMAdminJobStatsTable table might not be removed and still used for QNet.
	-- If will be completely removed after 7 days after deletion.
	-- If the job still exists in table JMAdminJobStatsTable and DataStatus is set to 2 or 3, or AppId is different from the mapping table,
	-- update it with the latest value.
	--		DATA_STATUS_VALID=0,
	--		DATA_STATUS_AGED = 1,
	--		DATA_STATUS_MEDIADELETED = 2,
	--		DATA_STATUS_NODATA = 3
	UPDATE JMAdminJobStatsTable
	SET		appId			= a.new_appId,
			archGrpId		= a.new_archGrpId,
			archGrpName		= a.new_archGrpName,
			dataStatus		= c.dataStatus
FROM	CCM_MAP_JMAdminJobStatsTable a, JMAdminJobStatsTable b, #CCM_JMAdminJobStatsTable c
	WHERE	a.jobId = b.jobId
	AND		a.new_commCellId = b.commCellId
	AND		a.jobId = c.jobId
	AND		a.old_commCellId = c.commCellId
	AND		a.exist = 1
	AND		(b.DataStatus in (2, 3) OR (b.appId <> 0 AND NOT EXISTS (SELECT * FROM App_Application WHERE id = b.appId)))
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMAdminJobStatsTable -- UPDATE existing with DataStatus (2, 3)'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge JMAdminJobAttemptStatsTable Table
	INSERT	INTO CCM_MAP_JMAdminJobAttemptStatsTable
	SELECT	commCellId, 0, jobId,  0
FROM	#CCM_JMAdminJobAttemptStatsTable
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMAdminJobAttemptStatsTable -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMAdminJobAttemptStatsTable SET new_commCellId = b.new_id
	FROM CCM_MAP_JMAdminJobAttemptStatsTable a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMAdminJobAttemptStatsTable -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMAdminJobAttemptStatsTable SET exist = 1
	FROM CCM_MAP_JMAdminJobAttemptStatsTable a, JMAdminJobAttemptStatsTable b
	WHERE a.jobId = b.jobId AND a.new_commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMAdminJobAttemptStatsTable -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO JMAdminJobAttemptStatsTable
	SELECT	distinct b.jobId, b.attemptNum, b.phaseNum,
			b.status, b.startTime, b.endTime, b.elapsedTime,
			b.failureReason, b.writeTime, a.new_commCellId, b.embeddedObjects, b.uncompBytes, b.numFiles, b.skippedItems, b.TotalSize, b.nwTransBytes, b.totalAllocationTime, b.totalWaitTimeBeforeAllocation
FROM	CCM_MAP_JMAdminJobAttemptStatsTable a, #CCM_JMAdminJobAttemptStatsTable b
	WHERE	a.jobId = b.jobId
	AND		a.old_commCellId = b.commCellId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMAdminJobAttemptStatsTable -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge JMJobOptions Table
	INSERT	INTO CCM_MAP_JMJobOptions
	SELECT	commCellId, 0, jobId, attributeId, attributeName, 0
FROM	#CCM_JMJobOptions
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobOptions -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobOptions SET new_commCellId = b.new_id
	FROM CCM_MAP_JMJobOptions a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobOptions -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_JMJobOptions SET exist = 1
	FROM	CCM_MAP_JMJobOptions a, JMJobOptions b
	WHERE	a.jobId = b.jobId AND a.new_commCellId = b.commCellId
	AND		a.attributeId = b.attributeId AND a.attributeName = b.attributeName
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobOptions -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO JMJobOptions
	SELECT	b.jobId, a.new_commCellId, b.attributeId,
			b.attributeName, b.attributeValueInt, b.attributeValue
FROM	CCM_MAP_JMJobOptions a, #CCM_JMJobOptions b
	WHERE	a.jobId = b.jobId
	AND		a.old_commCellId = b.commCellId
	AND		a.attributeId = b.attributeId AND a.attributeName = b.attributeName
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobOptions -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge JMJobDataLink Table
	INSERT	INTO CCM_MAP_JMJobDataLink
	SELECT	commCellId, 0, parentAppid, 0, childAppId, 0, parentjobId,  childjobid, 0
FROM	#CCM_JMJobDataLink
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobDataLink -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobDataLink SET new_commCellId = b.new_id
	FROM CCM_MAP_JMJobDataLink a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobDataLink -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobDataLink SET new_parentAppid = b.new_id
	FROM CCM_MAP_JMJobDataLink a, CCM_MAP_Application b
	WHERE a.old_parentAppid = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobDataLink -- UPDATE new_parentAppid'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobDataLink SET new_childAppid = b.new_id
	FROM CCM_MAP_JMJobDataLink a, CCM_MAP_Application b
	WHERE a.old_childAppid = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobDataLink -- UPDATE new_childAppid'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_JMJobDataLink SET exist = 1
	FROM	CCM_MAP_JMJobDataLink a, JMJobDataLink b
	WHERE	a.new_commCellId = b.commCellId
	AND		a.childJobId = b.childJobId
	AND		a.parentJobId = b.parentJobId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobDataLink -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO JMJobDataLink
	SELECT	a.new_commCellId, b.parentJobId, b.childJobId,
			a.new_parentAppid, a.new_childAppid, b.linkType, b.childJobStatus
FROM	CCM_MAP_JMJobDataLink a, #CCM_JMJobDataLink b
	WHERE	a.old_commCellId = b.commCellId
	AND		a.childJobId = b.childJobId
	AND		a.parentJobId = b.parentJobId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobDataLink -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge JMJobDataStats Table
	INSERT	INTO CCM_MAP_JMJobDataStats
	SELECT	commCellId, 0, archGrpId, 0, archGrpCopyId, 0, appId, 0, jobId, dataType, 0
FROM	#CCM_JMJobDataStats
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobDataStats -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobDataStats SET new_commCellId = b.new_id
	FROM CCM_MAP_JMJobDataStats a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobDataStats -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobDataStats SET new_appId = b.new_id
	FROM CCM_MAP_JMJobDataStats a, CCM_MAP_Application b
	WHERE a.old_appId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobDataStats -- UPDATE new_appId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobDataStats SET new_archGrpId = b.new_id
	FROM CCM_MAP_JMJobDataStats a, CCM_MAP_ArchGroup b
	WHERE a.old_archGrpId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobDataStats -- UPDATE new_archGrpId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobDataStats SET new_archGrpCopyId = b.new_id
	FROM CCM_MAP_JMJobDataStats a, CCM_MAP_ArchGroupCopy b
	WHERE a.old_archGrpCopyId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobDataStats -- UPDATE new_archGrpCopyId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_JMJobDataStats SET exist = 1
	FROM	CCM_MAP_JMJobDataStats a, JMJobDataStats b
	WHERE	a.jobId = b.jobId
	AND		a.new_commCellId = b.commCellId
	AND		a.new_archGrpCopyId = b.archGrpCopyId AND a.dataType = b.dataType
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobDataStats -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO JMJobDataStats
	SELECT	b.jobId, a.new_archGrpId, a.new_archGrpCopyId,
			b.dataType, b.optype, 0, b.status, b.disabled,
			a.new_appId, a.new_commCellId, b.archCheckEndTime,
			b.archCheckStatus, b.retentionFlags,
			b.manualRetentionEndTime, b.copiedTime, b.agedTime, b.mediaDeletedTime, b.modifiedTime,
			b.sizeOnMedia, b.agedBy, b.flags, b.jobSelectionTime,
			(CASE WHEN b.auxCopyStatus != -1 THEN b.auxCopyStatus WHEN b.status != 1000 THEN b.status ELSE -1 END),
			b.unCompSize
FROM	CCM_MAP_JMJobDataStats a, #CCM_JMJobDataStats b
	WHERE	a.jobId = b.jobId
	AND		a.old_commCellId = b.commCellId
	AND		a.old_archGrpCopyId = b.archGrpCopyId
	AND		a.dataType = b.dataType
	AND		a.exist <> 1
    AND     a.new_archGrpCopyId > 0
     -- above - the (a.new_archGrpCopyId > 0) condition was added due to failing merges that happened
     -- when storage policy copies on the source had been deleted.
     --   When storage policy copies are deleted, the archgroupcopy entry is deleted from the DB,
     --   JMJobDataStats entries have their status set to 1000 (overwritten), but the copyIds stay intact - eventhough
     --   the actual information about the copyIds is gone.
     -- Note - it is debateable whether we should be bringing in anything with status 1000,but leaving for now.
     --  Note - copyIds should have been properly mapped. If copies do not exist on dest already, they are created.
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobDataStats -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	--Fix: -Update the status always during robo migration but retaining the old behavior with regular CCM for now.
	--Flag bit 1 set in @ccmParamFlags if robo job
	IF @isTapeImport = 1
	BEGIN
		UPDATE JMJobDataStats
		SET		status = b.status,
disabled = 256,
				agedBy = b.agedBy,
				agedTime = b.agedTime,
				mediaDeletedTime = b.mediaDeletedTime,
				modifiedTime = b.modifiedTime,
				retentionFlags = b.retentionFlags,
				manualRetentionEndTime = b.manualRetentionEndTime,
				flags = b.flags,
				jobSelectionTime = b.jobSelectionTime,
				auxCopyStatus = (CASE WHEN b.auxCopyStatus != -1 THEN b.auxCopyStatus WHEN b.status != 1000 THEN b.status ELSE -1 END),
				unCompSize = b.unCompSize
		FROM		CCM_MAP_JMJobDataStats a, CommServ_Merge..CCM_JMJobDataStats b, JMJobDataStats c, archGroupCopy d
		WHERE		a.jobId = b.jobId AND a.old_commCellId = b.commCellId AND a.old_archGrpCopyId = b.archGrpCopyId AND a.dataType = b.dataType
		AND			a.jobId = c.jobId AND a.new_commCellId = c.commCellId AND a.new_archGrpCopyId = c.archGrpCopyId AND a.dataType = c.dataType
		AND			exist = 1
		AND			(
						(c.status in (1000) OR c.disabled > 0)
						AND
						NOT EXISTS (SELECT 1 from App_Application where id = c.appId)
					)
		AND       c.archGrpCopyId = d.id
AND 	d.type <> 8
	END
	ELSE
	BEGIN
		UPDATE JMJobDataStats
		SET		status = b.status,
				disabled = b.disabled,
				agedBy = b.agedBy,
				agedTime = b.agedTime,
				mediaDeletedTime = b.mediaDeletedTime,
				modifiedTime = b.modifiedTime,
				retentionFlags = b.retentionFlags,
				manualRetentionEndTime = b.manualRetentionEndTime,
				flags = b.flags,
				jobSelectionTime = b.jobSelectionTime,
				auxCopyStatus = (CASE WHEN b.auxCopyStatus != -1 THEN b.auxCopyStatus WHEN b.status != 1000 THEN b.status ELSE -1 END),
				unCompSize = b.unCompSize
FROM		CCM_MAP_JMJobDataStats a, #CCM_JMJobDataStats b, JMJobDataStats c
		WHERE		a.jobId = b.jobId AND a.old_commCellId = b.commCellId AND a.old_archGrpCopyId = b.archGrpCopyId AND a.dataType = b.dataType
		AND			a.jobId = c.jobId AND a.new_commCellId = c.commCellId AND a.new_archGrpCopyId = c.archGrpCopyId AND a.dataType = c.dataType
		AND			exist = 1
		AND			(
						(c.status in (1000) OR c.disabled > 0)
						OR
						(
							((@ccmParamFlags & 1) > 0)
							 AND @skipUpdate = 0
						)
					)
	END
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobDataStats -- Update status'
		GOTO CX_ERROR_EXIT
	END
	/*
	The following update statement is required because there was a case where the client/subclient was deleted after migration -
	That removes the JMBkpStats entry and the App_Application entry from the DB but not JMJobDataStats entry.
	And when the same subclient data is migrated again it gets a new appid and JMBkpStats gets merged with new appId but we don't merge JMJobDataStats
	as the row already exists for the same job but the AppId is left as such. So we need to update the AppId
	*/
	UPDATE JMJobDataStats
	SET appId = (SELECT appId FROM JMBkpStats where jobId = JDS.jobId AND commcellId = JDS.commcellId)
	FROM JMJobDataStats JDS, CCM_MAP_JMJobDataStats MAP_JDS
	WHERE JDS.jobId = MAP_JDS.jobId
	AND JDS.commCellId = MAP_JDS.new_commCellId
	AND MAP_JDS.exist = 1
	AND NOT EXISTS (SELECT * from App_Application where id = JDS.appId)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobDataStats -- Update AppId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE JMJobDataStats
	SET opType = C.opType,
		auxCopyJobId = C.auxCopyJobId,
		status = C.status,
		disabled = C.disabled,
		archCheckEndTime = C.archCheckEndTime,
		archCheckStatus = C.archCheckStatus,
		retentionFlags = C.retentionFlags,
		manualRetentionEndTime = C.manualRetentionEndTime,
		copiedTime = C.copiedTime,
		agedTime = C.agedTime,
		mediaDeletedTime = C.mediaDeletedTime,
		modifiedTime = C.modifiedTime,
		sizeOnMedia = C.sizeOnMedia,
		agedBy = C.agedBy,
		flags = C.flags,
		jobSelectionTime = C.jobSelectionTime,
		auxCopyStatus = (CASE WHEN C.auxCopyStatus != -1 THEN C.auxCopyStatus WHEN C.status != 1000 THEN C.status ELSE -1 END),
		unCompSize = C.unCompSize
FROM JMJobDataStats A, CCM_TapeImportEntities B, #CCM_JMJobDataStats C, CCM_MAP_CommCell D, CCM_MAP_ArchGroupCopy E
	WHERE A.jobId = C.jobId AND A.dataType = C.dataType
              AND A.archGrpCopyId = E.new_id  AND C.archGrpCopyId = E.old_id
              AND A.commCellId = D.new_id AND C.commCellId = D.old_id
AND A.appId = B.new_id AND B.entityType = 7
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'CCM_Merge_Main -- UPDATE JMJobDataStats  for tapeimported jobs'
		GOTO CX_ERROR_EXIT
	END
	IF @isTapeImport=1
		BEGIN
			-- mark jobs Aged which are coming in tapeimport job, and copy is not created tapeimport.
			UPDATE JMJobDataStats
SET disabled = A.disabled|256,
				manualRetentionEndTime = A.manualRetentionEndTime,
				agedTime = dbo.GetUnixTime(getutcdate()),
agedBy = (A.agedBy | 67108864)
			FROM JMJobDataStats A, CCM_MAP_JMJobDataStats B, archGroupCopy C, CCM_MAP_CommCell D
			WHERE 	A.jobId=B.jobId
					AND     A.commCellId=B.new_commCellId
				    AND		A.dataType = B.dataType
                    AND     A.archGrpCopyId = B.new_archGrpCopyId
					AND 	B.new_archGrpCopyId = C.id
AND		C.type<>8
					AND   	B.old_commCellId = D.old_Id
					AND   	B.exist = 0
			IF @@ERROR>0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobDataStats -- Update status'
				GOTO CX_ERROR_EXIT
			END
			UPDATE JMJobDataStats
SET disabled = A.disabled|2,
				manualRetentionEndTime = -1
			FROM JMJobDataStats A, CCM_MAP_JMJobDataStats B, archGroupCopy C, CCM_MAP_CommCell D
			WHERE 	A.jobId=B.jobId
					AND     A.commCellId=B.new_commCellId
				    AND		A.dataType = B.dataType
                    AND     A.archGrpCopyId = B.new_archGrpCopyId
					AND 	B.new_archGrpCopyId = C.id
					AND   	B.old_commCellId = D.old_Id
					AND   	B.exist = 0
AND 	C.type = 8
			IF @@ERROR>0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobDataStats -- Update status'
				GOTO CX_ERROR_EXIT
			END
			-- mark all data types as aged if any of the data type is aged
			UPDATE JMJobDataStats
SET disabled=A.disabled|256,
				agedTime = dbo.GetUnixTime(getutcdate()),
agedBy = (A.agedBy | 67108864)
			FROM JMJobDataStats A, (SELECT distinct jobId, new_commCellId, new_archGrpCopyId FROM CCM_MAP_JMJobDataStats) B
			WHERE 	A.jobId=B.jobId
					AND     A.commCellId=B.new_commCellId
				    AND     A.archGrpCopyId = B.new_archGrpCopyId
AND		A.disabled & 256 = 0
AND 	EXISTS (SELECT 1 FROM JMJobDataStats JS WHERE JS.jobId = A.jobId AND JS.commcellId = A.commcellId AND JS.archGrpCopyId = A.archGrpCopyId AND JS.disabled & 256 > 0)
			IF @@ERROR>0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobDataStats -- Update disabled '
				GOTO CX_ERROR_EXIT
			END
			-- for newly created tape import copy when primary exists, jobs will be created with status 101. when tape import brings such data back then we should mark status as 100.
			UPDATE 	JMJobDataStats
			SET 	status = 100, auxCopyStatus = 100
			FROM 	JMJobDataStats A, CCM_MAP_JMJobDataStats B, archGroupCopy C
			WHERE 	A.jobId = B.jobId
					AND     A.commCellId=B.new_commCellId
				    AND		A.dataType = B.dataType
                    AND     A.archGrpCopyId = B.new_archGrpCopyId
					AND 	B.new_archGrpCopyId = C.id
AND		C.type = 8
					AND 	A.status = 101
			IF @@ERROR>0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobDataStats -- Update status for secondry copy created jobs. '
				GOTO CX_ERROR_EXIT
			END
			/*
			-- if any of the archFile is not cataloged fully mark job as partially avilable
            -- mark job status to full if archive file is fully cataloged
			UPDATE JMJobDataStats
			SET status =  CASE WHEN EXISTS (SELECT 1 FROM CCM_TI_AllArchiveFiles B WHERE A.jobId = B.jobId AND B.commCellId =D.old_id AND B.fileType = A.dataType
			                                AND B.CopyId = C.old_archGrpCopyId AND (B.isArchFileClose = 0 OR B.isChunkSeqMatched = 0 )) THEN 103 ELSE 100 END,
				auxCopyStatus =  CASE WHEN EXISTS (SELECT 1 FROM CCM_TI_AllArchiveFiles B WHERE A.jobId = B.jobId AND B.commCellId =D.old_id AND B.fileType = A.dataType
			                                AND B.CopyId = C.old_archGrpCopyId AND (B.isArchFileClose = 0 OR B.isChunkSeqMatched = 0 )) THEN 103 ELSE 100 END
			FROM JMJobDataStats A, CCM_MAP_JMJobDataStats C, CCM_MAP_CommCell D
			WHERE  		A.jobId=C.jobId
						AND   A.commCellId=C.new_commCellId
						AND	  A.dataType = C.dataType
						AND   A.archGrpCopyId = C.new_archGrpCopyId
						AND   C.old_commCellId = D.old_Id
			IF @@ERROR>0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobDataStats -- Update status to 103 or 100'
				GOTO CX_ERROR_EXIT
			END
			*/
            UPDATE JMBkpStats
			SET	status = 1,opType = 4,
			servStartDate = ( SELECT TOP 1 CTime FROM ArchFile a
							  WHERE c.jobId = a.jobId AND
									c.commcellId = a.commcellid
							  ORDER BY CTime),
			servEndDate   = ( SELECT TOP 1 CTime+1 FROM ArchFile a
							  WHERE c.jobId = a.jobId AND
									c.commcellId = a.commcellid
							  ORDER BY CTime DESC),
			totalUncompBytes = ( SELECT SUM(b.physicalSize)
							  FROM ArchFile as a, ArchFileCopy as b
							  WHERE c.jobId = a.jobId AND
									c.commcellId = a.commcellid AND
									a.id = b.archFileId AND a.commCellId = b.commCellId)
FROM JMBkpStats c, #CCM_JMBkpStats d, CCM_MAP_JMBkpStats e
			WHERE c.jobId = d.jobId and c.commCellId = e.new_commCellId and e.jobid=d.jobid and e.old_commcellid=d.commcellid
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMBkpStats -- UPDATE CCM_JMBkpStats'
				GOTO CX_ERROR_EXIT
			END
		/*	-- age the jobs which are coming in tape import job and copy is not created tapeimport. make sure we are not aging jobs already present on cataloged media as well as on CS.
			UPDATE JMBkpStats
			SET		dataStatus		 = 1,
					agedTime         = dbo.GetUnixTime(getutcdate()),
					mediaDeletedTime = 0
FROM	CCM_MAP_JMBkpStats a, JMBkpStats b, #CCM_JMBkpStats c
			WHERE	a.jobId = b.jobId
			AND		a.new_commCellId = b.commCellId
			AND		a.jobId = c.jobId
			AND		a.old_commCellId = c.commCellId
                        AND     EXISTS(SELECT 1 FROM JMJobDataStats d,archGroupCopy e
					WHERE  d.archGrpCopyId = e.id
AND 	e.type<>8
                                               AND d.jobId = b.jobId AND d.commCellId = b.commCellId)
			AND		a.exist <> 1
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- UPDATE JMBkpStats dataStatus, agedTime, mediaDeletedTime for tapeimported jobs'
				GOTO CX_ERROR_EXIT
			END
		*/
			-- If the job is aged in all copies, then mark it aged in JMBkpStats too
			UPDATE JMBkpStats
			SET		dataStatus		 = 1,
					agedTime         = dbo.GetUnixTime(getutcdate()),
					mediaDeletedTime = 0
FROM	CCM_MAP_JMBkpStats a, JMBkpStats b, #CCM_JMBkpStats c, JMJobDataStats d
			WHERE	a.jobId = b.jobId
			AND		a.new_commCellId = b.commCellId
			AND		a.jobId = c.jobId
			AND		a.old_commCellId = c.commCellId
AND     (SELECT count(*) FROM JMJobDataStats e WHERE e.jobId = a.jobId and e.commcellId = a.new_commCellId and (e.disabled & 256) = 0) = 0
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- UPDATE JMBkpStats dataStatus, agedTime, mediaDeletedTime'
				GOTO CX_ERROR_EXIT
			END
			/******************************************************************
			*			Generate full cycle number, sequence number for tape import jobs.
			******************************************************************/
			DECLARE @nowTime INT
			SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
			IF object_id('tempdb.dbo.#tmpJobsTable1') is not NULL DROP TABLE #tmpJobsTable1
			CREATE TABLE #tmpJobsTable1
			(
			bkpLevel int,
			appid int,
			jobid int,
			commCellId int,
			cycle int,
			sequence int
			)
			IF object_id('tempdb.dbo.#tmpJobsTable2') is not NULL DROP TABLE #tmpJobsTable2
			CREATE TABLE #tmpJobsTable2
			(
			bkpLevel int,
			appid int,
			jobid int,
			commcellId int,
			cycle int,
			sequence int
			)
			;WITH bkpjobs AS
			( SELECT j.bkpLevel, j.appId, j.jobId, j.commCellId, ROW_NUMBER() over ( PARTITION by j.appId order by j.jobId ) AS rownum, 1 AS seq
			FROM JMBkpStats j
			WHERE j.bkpLevel  IN (1 /*FULL*/,64 /*SYNTHETIC_FULL*/,128 /*SYNTHETIC_FULL_AND_INCR*/)
				AND j.status IN (1,3,14,16) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS, COMMITTED
				AND EXISTS (SELECT 1 FROM CCM_MAP_JMBkpStats jMap WHERE j.appId = jMap.new_appId AND j.commCellId = jMap.new_commCellId)
			)
			INSERT into #tmpJobsTable1
			SELECT * FROM bkpjobs
			-- UPDATE FULL/Synth FULL jobs cycle and seq number.
			UPDATE JMBkpStats
			SET fullCycleNum = T1.cycle, cyclesequence = T1.sequence
			FROM #tmpJobsTable1 T1 INNER JOIN JMBkpStats J ON J.jobid = T1.jobid AND J.commCellId = T1.commcellId
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- UPDATE FULL/Synth FULL jobs cycle and seq number for tape import jobs'
				GOTO CX_ERROR_EXIT
			END
			-- UPDATE Non full jobs cycle number.
			UPDATE JMBkpStats
			SET fullCycleNum = (SELECT ISNULL ((SELECT TOP 1 T1.cycle FROM #tmpJobsTable1 T1 WHERE T1.appid = J.appId AND T1.jobid < J.jobId  ORDER BY T1.jobId DESC), 1))
			FROM JMBkpStats J INNER JOIN #tmpJobsTable1 T ON J.jobId = T.jobId AND J.commcellId = T.commcellId AND J.appId = T.appId
			WHERE J.bkpLevel NOT IN (1 /*FULL*/,64 /*SYNTHETIC_FULL*/,128 /*SYNTHETIC_FULL_AND_INCR*/) AND status IN (1,3,14,16)  -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS, COMMITTED
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- UPDATE NON FULL jobs cycle and seq number for tape import jobs'
				GOTO CX_ERROR_EXIT
			END
			-- UPDATE full cycle number in appMgr table to be consistent with JM tables.
			UPDATE A
			SET modified = @nowTime
			FROM APP_SubClientProp A INNER JOIN #tmpJobsTable1 T ON A.componentNameId = T.appid
			WHERE attrName = 'sys:full cycle num'
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- UPDATE full cycle number in appMgr table for tape import jobs'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT appid, 'sys:full cycle num', 10, MAX(cycle), @nowTime, 0 , 0
			FROM #tmpJobsTable1
			GROUP By appid
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- INSERT full cycle num in appMgr table for tape import jobs'
				GOTO CX_ERROR_EXIT
			END
			DROP TABLE #tmpJobsTable1
			;WITH bkpjobs1 AS
			( SELECT j.bkpLevel, j.appId, j.jobId, j.commcellId, fullCycleNum AS cycle, ROW_NUMBER() over ( PARTITION by j.appId, j.fullCycleNum order by j.jobId ) AS rownum
			FROM JMBkpStats j
			WHERE j.status IN (1,3,14,16)  -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS, COMMITTED
				AND EXISTS (SELECT 1 FROM CCM_MAP_JMBkpStats jMap WHERE j.appId = jMap.new_appId AND j.commCellId = jMap.new_commCellId)
			)
			INSERT into #tmpJobsTable2
			SELECT *  FROM bkpjobs1
			-- UPDATE Non full jobs sequence number.
			UPDATE JMBkpStats
			SET cyclesequence = T2.sequence
			FROM #tmpJobsTable2 T2 INNER JOIN JMBkpStats J ON J.jobid = T2.jobid AND J.commCellId = T2.commcellId
			WHERE J.bkpLevel NOT IN (1 /*FULL*/,64 /*SYNTHETIC_FULL*/,128 /*SYNTHETIC_FULL_AND_INCR*/)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- UPDATE Non full jobs sequence number for tape import jobs'
				GOTO CX_ERROR_EXIT
			END
			-- UPDATE sequence number in appMgr table to be consistent with JM tables.
			UPDATE A
			SET modified = @nowTime
			FROM APP_SubClientProp A INNER JOIN #tmpJobsTable2 T ON A.componentNameId = T.appid
			WHERE attrName = 'sys:non full cycle num'
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- UPDATE sequence number in appMgr table for tape import jobs'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT A.appid, 'sys:non full cycle num', 10, MAX(A.sequence), @nowTime, 0 , 0
			FROM #tmpJobsTable2 A
			INNER JOIN (SELECT appid, MAX(cycle) "cycle"
						FROM #tmpJobsTable2 B
						GROUP BY appid) TEMP ON A.appid = TEMP.appid AND A.cycle = TEMP.cycle -- Find latest cycle by join and take max sequence
			GROUP BY A.appid
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- INSERT sequence number in appMgr table for tape import jobs'
				GOTO CX_ERROR_EXIT
			END
			DROP TABLE #tmpJobsTable2
			-- Update opType for existing subclients.
			UPDATE J
			SET opType = JS.opType
			FROM JMBkpStats J
				INNER JOIN CCM_MAP_JMBkpStats jMap ON J.appId = jMap.new_appId AND J.commCellId = jMap.new_CommCellId AND J.jobid = jMap.jobId
				INNER JOIN JMBkpStats JS ON JS.appId = J.appId AND JS.commCellId = J.commCellId AND JS.fullCycleNum = J.fullCycleNum
			WHERE JS.opType <> J.opType AND JS.duration > 0 		-- duration > 0 means its existing job, not imported by tape import.
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMBkpStats -- update opType for tape import jobs'
				GOTO CX_ERROR_EXIT
			END
			--mark tapeimport DR as aged
			UPDATE JMAdminJobStatsTable
			SET dataStatus=1
			FROM JMAdminJobStatsTable A, CCM_MAP_JMAdminJobStatsTable B, archGroupCopy D
			WHERE A.jobId = B.jobId AND A.commCellId = B.new_commCellId
AND A.archGrpCopyID = D.id AND D.type <>8 AND B.exist = 0
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_JOB -- JMAdminJobStatsTable -- UPDATE JMAdminJobStatsTable dataStatus for tapeimport'
				GOTO CX_ERROR_EXIT
			END
	END
	DELETE DF
	FROM MMDeletedAF DF
	INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON ACM.archChunkId = DF.ArchChunkId AND ACM.commCellId = DF.CommCellId
	INNER JOIN CCM_MAP_ArchChunkMapping MapACM WITH (NOLOCK) ON MapACM.archChunkId = ACM.ArchChunkId and MapACM.new_commCellId = ACM.commCellId
		and MapACM.archFileId = ACM.archFileId and MapACM.new_ChunkCommCellId = ACM.ChunkCommCellId
	INNER JOIN JMJobDataStats JM WITH (NOLOCK) ON disabled & 256 = 0 AND JM.status = 100 and JM.commCellId = ACM.commCellId and JM.jobid = ACM.jobId and ACM.archCopyId = JM.archGrpCopyId
	WHERE DF.copyId = ACM.archCopyId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- MMDeletedAF -- DELETE.'
		GOTO CX_ERROR_EXIT
	END
	DELETE AfTrck
	FROM MMDeletedArchFileTracking AfTrck
	INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON ACM.archFileId = AfTrck.archFileId AND ACM.archCopyId = AfTrck.copyId AND ACM.commCellId = AfTrck.CommCellId
	INNER JOIN CCM_MAP_ArchChunkMapping MapACM WITH (NOLOCK) ON MapACM.archFileId  = ACM.archFileId  AND MapACM.new_copyId = ACM.archCopyId AND MapACM.new_commCellId = ACM.commCellId
	INNER JOIN JMJobDataStats JM WITH (NOLOCK) ON disabled & 256 = 0 AND JM.status = 100 AND JM.commCellId = ACM.commCellId AND JM.jobid = ACM.jobId AND ACM.archCopyId = JM.archGrpCopyId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- MMDeletedArchFileTracking -- DELETE.'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge JMOracleRACClientsUsed Table
	INSERT	INTO CCM_MAP_JMOracleRACClientsUsed
	SELECT	commCellId, 0, racInstanceId, 0, racHostId, 0, jobId, phaseNumber, attemptNumber, isControlHost, 0
FROM	#CCM_JMOracleRacClientsUsed
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMOracleRACClientsUsed -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMOracleRACClientsUsed SET new_commCellId = b.new_id
	FROM CCM_MAP_JMOracleRACClientsUsed a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMOracleRACClientsUsed -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMOracleRACClientsUsed SET new_racInstanceId = b.new_id
	FROM CCM_MAP_JMOracleRACClientsUsed a, CCM_MAP_AppOracleRacInstance b
	WHERE a.old_racInstanceId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMOracleRACClientsUsed -- UPDATE new_racInstanceId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMOracleRACClientsUsed SET new_racHostId = b.new_id
	FROM CCM_MAP_JMOracleRACClientsUsed a, CCM_MAP_Client b
	WHERE a.old_racHostId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMOracleRACClientsUsed -- UPDATE new_racHostId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_JMOracleRACClientsUsed SET exist = 1
	FROM	CCM_MAP_JMOracleRACClientsUsed a, JMOracleRACClientsUsed b
	WHERE	a.new_commCellId = b.commCellId
	AND		a.new_racInstanceId = b.racInstanceId
	AND		a.new_racHostId = b.racHostId
	AND		a.jobId = b.jobId
	AND		a.phaseNumber = b.phaseNumber
	AND		a.attemptNumber = b.attemptNumber
	AND		a.isControlHost = b.isControlHost
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMOracleRACClientsUsed -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO JMOracleRACClientsUsed
	SELECT	b.jobId, a.new_commCellId,
			b.phaseNumber, b.attemptNumber,
			a.new_racInstanceId, a.new_racHostId, b.isControlHost
FROM	CCM_MAP_JMOracleRACClientsUsed a, #CCM_JMOracleRacClientsUsed b
	WHERE	a.jobId = b.jobId
	AND		a.old_commCellId = b.commCellId
	AND		a.old_racInstanceId = b.racInstanceId
	AND		a.old_racHostId = b.racHostId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMOracleRACClientsUsed -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge ArchCheckHistory Table
	INSERT	INTO CCM_MAP_ArchCheckHistory
	SELECT	commCellId, 0, archCopyId, 0, jobId, archCheckEndTime, 0
FROM	#CCM_ArchCheckHistory
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_ArchCheckHistory -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchCheckHistory SET new_commCellId = b.new_id
	FROM CCM_MAP_ArchCheckHistory a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_ArchCheckHistory -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchCheckHistory SET new_archCopyId = b.new_id
	FROM CCM_MAP_ArchCheckHistory a, CCM_MAP_ArchGroupCopy b
	WHERE a.old_archCopyId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_ArchCheckHistory -- UPDATE new_archCopyId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchCheckHistory SET exist = 1
	FROM	CCM_MAP_ArchCheckHistory a, ArchCheckHistory b
	WHERE	a.jobId = b.jobId
	AND		a.new_commCellId = b.commCellId
	AND		a.new_archCopyId = b.archCopyId
	AND		a.archCheckEndTime = b.archCheckEndTime
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_ArchCheckHistory -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO ArchCheckHistory
	SELECT	b.jobId, a.new_commCellId, a.new_archCopyId, 0,
			b.adminJobType, b.archCheckEndTime, b.archCheckStatus, b.errorString, b.flags
FROM	CCM_MAP_ArchCheckHistory a, #CCM_ArchCheckHistory b
	WHERE	a.jobId = b.jobId
	AND		a.old_commCellId = b.commCellId
	AND		a.old_archCopyId = b.archCopyId
	AND		a.archCheckEndTime = b.archCheckEndTime
	AND		a.exist = 0
	AND		a.new_archCopyId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- ArchCheckHistory -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge archFailedKilledJobInfo Table
	INSERT INTO CCM_MAP_archFailedKilledJobInfo
	SELECT jobId, commCellId, 0, appId, 0, archGrpId, 0, archGrpCopyId, 0, 0
FROM #CCM_ArchFailedKilledJobInfo
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_archFailedKilledJobInfo -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_archFailedKilledJobInfo
	SET    new_origCCId = b.new_id
	FROM   CCM_MAP_archFailedKilledJobInfo a, CCM_MAP_CommCell b
	WHERE  a.old_origCCId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_archFailedKilledJobInfo -- UPDATE -- new_origCCId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_archFailedKilledJobInfo
	SET    new_archGrpId = b.new_id
	FROM   CCM_MAP_archFailedKilledJobInfo a, CCM_MAP_ArchGroup b
	WHERE  a.old_archGrpId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_archFailedKilledJobInfo -- UPDATE -- new_archGrpId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_archFailedKilledJobInfo
	SET    new_archGrpCopyId = b.new_id
	FROM   CCM_MAP_archFailedKilledJobInfo a, CCM_MAP_ArchGroupCopy b
	WHERE  a.old_archGrpCopyId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_archFailedKilledJobInfo -- UPDATE -- new_archGrpCopyId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_archFailedKilledJobInfo
	SET    new_appId = b.new_id
	FROM   CCM_MAP_archFailedKilledJobInfo a, CCM_MAP_Application b
	WHERE  a.old_appId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_archFailedKilledJobInfo -- UPDATE -- new_appId'
		GOTO CX_ERROR_EXIT
	END
	-- archgrpcopyid is 0 on the source for all entries - so it should map to 0 also
	-- that is why we do not check it here.
	IF EXISTS (SELECT * FROM CCM_MAP_archFailedKilledJobInfo WHERE new_origCCId = 0 OR new_archGrpId = 0 OR new_appId = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_archFailedKilledJobInfo -- New ids not known -- Fail Merge'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_archFailedKilledJobInfo
	SET    exist = 1
	FROM   CCM_MAP_archFailedKilledJobInfo a, archFailedKilledJobInfo b
	WHERE  a.jobId = b.jobId
	  AND  a.new_origCCId = b.commCellId
	  AND  a.new_archGrpCopyId = b.archGrpCopyId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_archFailedKilledJobInfo -- UPDATE -- exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO archFailedKilledJobInfo
	SELECT b.jobId, a.new_origCCId, b.servStartDate, b.servEndDate, a.new_appId, b.appType, a.new_archGrpId, a.new_archGrpCopyId, b.bkpLevel,
	       b.opType, b.retentionFlags, b.flags
FROM   CCM_MAP_archFailedKilledJobInfo a, #CCM_ArchFailedKilledJobInfo b
	WHERE  a.jobId = b.jobId
	  AND  a.old_origCCId = b.commCellId
	  AND  a.old_archGrpCopyId = b.archGrpCopyId
	  AND  a.old_archGrpId = b.archGrpId
	  AND  a.old_appId = b.appId
	  AND  a.exist = 0
	  AND  a.new_archGrpCopyId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- archFailedKilledJobInfo -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------
	--Merge JMJobSnapshotStats table
	INSERT INTO CCM_MAP_JMJobSnapshotStats
	SELECT jobId, commCellId, 0, appId, 0, archGrpId, 0, 0
FROM #CCM_JMJobSnapShotStats
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobSnapshotStats -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobSnapshotStats SET new_commCellId = b.new_id
	FROM CCM_MAP_JMJobSnapshotStats a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobSnapshotStats -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobSnapshotStats
	SET    new_appId = b.new_id
	FROM   CCM_MAP_JMJobSnapshotStats a, CCM_MAP_Application b
	WHERE  a.old_appId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobSnapshotStats -- UPDATE -- new_appId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobSnapshotStats
	SET    new_archGrpId = b.new_id
	FROM   CCM_MAP_JMJobSnapshotStats a, CCM_MAP_ArchGroup b
	WHERE  a.old_archGrpId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobSnapshotStats -- UPDATE -- new_archGrpId'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS (SELECT * FROM CCM_MAP_JMJobSnapshotStats WHERE new_commCellId = 0 OR new_archGrpId = 0 OR new_appId = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobSnapshotStats -- New ids not known -- Fail Merge'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_JMJobSnapshotStats SET exist = 1
	FROM CCM_MAP_JMJobSnapshotStats a, JMJobSnapshotStats b
	WHERE a.jobId = b.jobId AND a.new_commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_JMJobSnapshotStats -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
UPDATE #CCM_JMJobSnapShotStats
SET disabled = disabled | 1, unPickReason = 10
FROM CCM_MAP_JMJobSnapshotStats a, #CCM_JMJobSnapShotStats b, App_CommCell c
	WHERE	a.jobId = b.jobId
	AND		a.old_commCellId = b.commCellId
	AND 	a.exist <> 1
	AND 	(b.disabled & 1) = 0
AND		a.new_commCellId > 2
	AND		a.new_commCellId = c.id
	AND		c.type = 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobSnapshotStats -- Disable Materialization'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO JMJobSnapshotStats
	SELECT	b.jobId, a.new_commCellId, b.materializationStatus, b.disabled, b.materializationJobId, a.new_appId, a.new_archGrpId, b.unPickReason, b.flags
FROM	CCM_MAP_JMJobSnapshotStats a, #CCM_JMJobSnapShotStats b
	WHERE	a.jobId = b.jobId
	AND		a.old_commCellId = b.commCellId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMJobSnapshotStats -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-----------------------------------------------------------------
    INSERT	INTO edcJobIdMap
    SELECT	E.*
FROM	#CCM_edcJobIdMap E, JMJobStats J
    WHERE		E.newJobId = J.jobId
			AND E.mergedCcId = J.commCellId
			AND NOT EXISTS (SELECT	*
							FROM	edcJobIdMap EE
							WHERE		EE.newJobId = J.jobId
									AND EE.mergedCcId = J.commCellId)
	-----------------------------------------------------------------
	--Merge EvMsg  AND EvParam Tables
	INSERT INTO CCM_MAP_EvMsg
	SELECT a.id, a.commCellId, b.new_id, a.clientId, 0, a.userId, 0, a.mediaId, 0,
		a.libraryId, 0, a.maClientId, 0, 0
FROM #CCM_EvMsg a INNER JOIN CCM_MAP_CommCell b ON a.commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_EvMsg -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_EvMsg
	SET	new_clientId = b.new_id
	FROM CCM_MAP_EvMsg a INNER JOIN CCM_MAP_Client b ON a.old_clientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_EvMsg -- UPDATE new_clientId'
		GOTO CX_ERROR_EXIT
	END
	IF @l_curImportJobId > 0
	BEGIN
		UPDATE CCM_MAP_EvMsg
		SET new_userId = b.newEntityId
FROM CCM_MAP_EvMsg a INNER JOIN CCMMergeEntityMap b ON a.old_userId = b.oldEntityId AND b.entityType = 13
		WHERE b.importJobId = @l_curImportJobId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_EvMsg -- UPDATE new_userId'
			GOTO CX_ERROR_EXIT
		END
	END
	UPDATE CCM_MAP_EvMsg
	SET new_mediaId = new_id
	FROM CCM_MAP_EvMsg a INNER JOIN CCM_MAP_MMMedia  b on a.old_mediaId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_EvMsg -- UPDATE new_mediaId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_EvMsg
	SET new_libraryId = b.new_libraryId
	FROM CCM_MAP_EvMsg a INNER JOIN CCM_MAP_Library  b on a.old_libraryId = b.old_libraryId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_EvMsg -- UPDATE new_libraryId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_EvMsg
	SET	new_maClientId = b.new_id
	FROM CCM_MAP_EvMsg a INNER JOIN CCM_MAP_Client b ON a.old_maClientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_EvMsg -- UPDATE new_maClientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_EvMsg
	SET	exist = 1
	FROM CCM_MAP_EvMsg a INNER JOIN EvMsg b ON a.Id = b.id AND a.new_CommCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- CCM_MAP_EvMsg -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO EvMsg (id, timeSource, timeServer, severity, ack, acked, type, paramNum, messageId, jobId_h, jobId_l,
	clientID, commCellID, userID, subsystemId, client, commCell, userName, subsystem, msgEnglish,
	repeatCount, lastOccurrence, nextPost, mediaId, driveId, libraryId, maClientId)
	SELECT a.id, a.timeSource, a.timeServer, a.severity, a.ack, a.acked, a.type, a.paramNum, a. messageId, a.jobId_h, a.jobId_l,
		b.new_clientid, b.new_commcellid, b.new_userId, a.subSystemId, a.client, a.commCell, a.userName, a.subSystem, a.msgEnglish,
		a.repeatCount, a.lastOccurrence, a.nextPost, b.new_mediaid, 0, b.new_libraryid, b.new_maClientid
FROM #CCM_EvMsg a INNER JOIN CCM_MAP_EvMsg b ON a.id = b.id AND a.commCellId = b.old_commCellId
	WHERE b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- EvMsg -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE GXCounter
	SET next_l = (SELECT MAX(id) FROM EvMsg)
	WHERE name LIKE 'Event_Counter'
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- Update for GxCounter with max id of EvMsg'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO EvParam
	SELECT a.evMsgId, a.position, a.type, a.size, a.data, a.eventId, b.new_Id
FROM #CCM_EvParam a INNER JOIN CCM_MAP_CommCell b ON a.commCellId = b.old_id
		LEFT OUTER JOIN EvParam c ON a.evMsgId = c.evMsgId AND a.position = c.position AND b.new_id = c.commCellId
	WHERE c.evMsgId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- EvParam -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	--------------------------------------------------------
	-- Merge APP_VMProp Table
IF(OBJECT_ID('TempDb..#CCM_APP_VMProp') IS NOT NULL)
	BEGIN
		INSERT INTO APP_VMProp
		SELECT A.jobId , C.new_id, B.new_id, A.attrName, A.attrType, A.attrVal, A.ClientJobId
FROM #CCM_APP_VMProp A INNER JOIN CCM_MAP_Client B ON A.VMclientId = B.old_id
			INNER JOIN CCM_MAP_CommCell C ON A.CommCellId = C.old_id
			LEFT OUTER JOIN APP_VMProp D ON D.jobId = A.jobId AND D.VMclientId = B.new_id AND D.CommCellId = C.new_id
		WHERE D.JobId IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_JOB -- APP_VMProp -- INSERT'
			GOTO CX_ERROR_EXIT
		END
	END
	-----------------------------------------------------------
	-- Merge JMQinetixUpdateStatus table
IF(OBJECT_ID('TEMPDB..#CCM_JMQinetixUpdateStatus') IS NOT NULL)
	BEGIN
		INSERT INTO JMQinetixUpdateStatus
		SELECT A.jobId, D.new_Id, B.new_Id, C.name, A.status, A.category, A.ostype, A.discoverPhaseStatus, D.aliasName, A.clientRegistry, A.installedUpdates, A.statusMessage, A.transferStatus
FROM #CCM_JMQinetixUpdateStatus A INNER JOIN CCM_MAP_Client B ON A.clientId = B.old_Id
			INNER JOIN APP_Client C ON C.id = B.new_Id
			INNER JOIN CCM_MAP_CommCell D ON A.commCellId = D.old_Id
			LEFT OUTER JOIN JMQinetixUpdateStatus E ON A.jobId = E.jobId AND E.commCellId = D.new_Id
		WHERE E.jobId IS NULL
	END
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_JOB -- JMQinetixUpdateStatus -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
	---------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_JOB_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_JOB_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_JOB_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_JOB_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_JOB_from_XML',  '00010003007200030000', 'CCM_Merge_JOB_from_XML', '00010003007200030000')
GO

