

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_Holiday_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge SchedHoliday table.
--  +========================================================================+
-- $Id: CCM_Merge_Holiday_from_XML.sp,v 1.2.186.1 2018/03/20 00:51:08 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Merge_Holiday_from_XML <<<'

IF EXISTS (select * from sysobjects where name='CCM_Merge_Holiday_from_XML')
	drop procedure CCM_Merge_Holiday_from_XML
IF EXISTS (select * from GxQscripts where name='CCM_Merge_Holiday_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Holiday_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Holiday_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Holiday_from_XML'
GO
print '... Creating Procedure: CCM_Merge_Holiday_from_XML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Merge_Holiday_from_XML
  @i_forceOverWrite integer,
  @errStr varchar(1024) OUTPUT
AS
	---------------------------------------------------------
--Code below here is from CCM_Merge_Holiday.spb--
SET NOCOUNT ON
	-- Do not use transaction here, because it is called by another stored procedure with transaction
	-- Commserv_Merge..CCM_SchedHoliday will not have holidays associated with a group.
	-- CCM_Merge_Holiday should be called only after CCM_Merge_Client
	----------------------------------------------------------------------------------------------------------------------
	--
	--   Source Commcell           Destination Commcell     exist                Action
	--
	--    dates   name                dates     name
	----------------------------------------------------------------------------------------------------------------------
	--     A       B                   A         B            1             Holiday exists, do nothing
	--     A       B                   A        non-B         1             Holiday exists with different name, update with latest name
	--     A       B                  non-A      B            0             Insert holiday with the same name
	--     A       B                  non-A     non-B         0             Insert holiday with the new name
	---------------------------------------------------------------------------------------------------------------------
	SET @errStr = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
	INSERT INTO CCM_MAP_SchedHoliday
	SELECT DISTINCT id, 0, clientId, 0, startYear,startMonth,startDay,startHour,startMinute,startSecond,endYear,endMonth,endDay,endHour,endMinute,endSecond,description,modified,groupId,0
FROM #CCM_SchedHoliday
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Holiday -- CCM_MAP_SchedHoliday -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SchedHoliday SET newClientId = b.new_id
	FROM CCM_MAP_SchedHoliday a, CCM_MAP_Client b
	WHERE a.oldClientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Holiday -- CCM_MAP_SchedHoliday -- UPDATE newClientId'
		GOTO CX_ERROR_EXIT
	END
	--If force overwrite is selected then delete existing entries
	IF 1 = @i_forceOverWrite
	BEGIN
		DELETE 	SchedHoliday
		FROM	SchedHoliday a INNER JOIN CCM_MAP_SchedHoliday b ON a.clientId = b.newClientId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Holiday -- SchedHoliday -- DELETE if forceOverWrite'
			GOTO CX_ERROR_EXIT
		END
	END
	ELSE
	BEGIN
		UPDATE	CCM_MAP_SchedHoliday SET exist = 1, new_id = b.id
		FROM	CCM_MAP_SchedHoliday a, SchedHoliday b
		WHERE	a.newClientId = b.clientId and
				a.startYear = b.startYear and
				a.startMonth = b.startMonth and
				a.startDay = b.startDay and
				a.startHour = b.startHour and
				a.startMinute = b.startMinute and
				a.startSecond = b.startSecond and
				a.endYear = b.endYear and
				a.endMonth = b.endMonth and
				a.endDay = b.endDay and
				a.endHour = b.endHour and
				a.endMinute = b.endMinute and
				a.endSecond = b.endSecond and
				a.groupId = b.groupId --and              -- Check to make sure group specific holidays are avoided
				--a.vtPolicyId = b.vtPolicyId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Holiday -- CCM_MAP_SchedHoliday -- UPDATE exist'
			GOTO CX_ERROR_EXIT
		END
	END
	-- Insert non-exist holidays only
	INSERT INTO SchedHoliday
	SELECT a.startYear,
           a.startMonth,
		   a.startDay,
		   a.startHour,
		   a.startMinute,
		   a.startSecond,
		   a.endYear,
		   a.endMonth,
		   a.endDay,
		   a.endHour,
		   a.endMinute,
		   a.endSecond,
		   dbo.GetUnixTime(getutcdate()),
		   a.description,
		   a.newClientId,
		   a.groupId,                                                 -- groupId will be 0 as the holiday is client specific holiday
		   0 --a.vtPolicyId -- we don't migrate vt policy so set it to 0
	FROM CCM_MAP_SchedHoliday a
	WHERE a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Holiday -- SchedHoliday -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Modify holiday on destination machine if it is recently modified from source machine
	UPDATE SchedHoliday	SET description = b.description
	FROM SchedHoliday a, CCM_MAP_SchedHoliday b
	WHERE b.exist = 1
	  AND a.id = b.new_id
	  AND a.modified < b.modified
	  AND a.description <> b.description
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Holiday -- SchedHoliday -- UPDATE description'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
	---------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_Holiday_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Holiday_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Holiday_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Holiday_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_Holiday_from_XML',  '00010002018600010000', 'CCM_Merge_Holiday_from_XML', '00010002018600010000')
GO

