

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_Entities_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Procedure: Merge captured entities from an XML.
--  +========================================================================+
-- $Id: CCM_Merge_Entities_from_XML.sp,v 1.10.12.3.4.1 2021/03/20 05:23:21 cliu Exp $
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCM_Merge_Entities_from_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Merge_Entities_from_XML <<<'
	drop procedure CCM_Merge_Entities_from_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Merge_Entities_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Entities_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Entities_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Entities_from_XML'
GO
print '... Creating Procedure: CCM_Merge_Entities_from_XML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCM_Merge_Entities_from_XML
  @i_CapturedDataXml XML,
  @i_flags integer,
  @i_mergeTimeStamp integer
AS
  DECLARE @o_errCode int
  DECLARE @o_errStr varchar(1024)
SET @o_errCode = -1
SET @o_errStr = 'ERROR: GENERAL ERROR!'
SET NOCOUNT ON
BEGIN TRY
--Macro CCM_CREATE_TEMP_TABLES_ALL will be replaced with create table #CCM_* statements by DB_SQL_project while building the .sql from .sp

IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_DataPathMapping]') )
BEGIN
	DROP TABLE #CCM_DataPathMapping
END


CREATE  TABLE   #CCM_DataPathMapping (
	oldCopyId			integer	NOT NULL,

	newCopyId			integer	NOT NULL,

	oldPolicyName		varchar(1024)	NOT NULL,

	oldCopyName			varchar(1024)	NOT NULL,

	newMediaAgentId		integer	NOT NULL,

	newLibraryId		integer	NOT NULL,

	newDataPathId		integer	NOT NULL,

	newSpareGroupId		integer	NOT NULL,

	LibraryId           integer	NOT NULL,

	LibraryName         varchar(128)	NOT NULL,

	ClientId            integer	NOT NULL,

	DriveTypeId         integer	NOT NULL,

	DrivePoolId         integer	NOT NULL,

	flag                integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ClientNameMapping]') )
BEGIN
	DROP TABLE #CCM_ClientNameMapping
END


CREATE  TABLE   #CCM_ClientNameMapping (
	old_name				varchar(1024)	NOT NULL,

	new_name				varchar(1024)	NOT NULL,

	new_net_hostname		varchar(1024)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MountPathMapping]') )
BEGIN
	DROP TABLE #CCM_MountPathMapping
END


CREATE  TABLE   #CCM_MountPathMapping (
	MountPathId			integer	NOT NULL,

	newLibraryId		integer	NOT NULL,

	newMountPathName	varchar(1024)	NOT NULL,

	newUserName			varchar(1024)	NOT NULL,

	newPassword			varchar(2048)	NOT NULL,

	MountPathName            nvarchar(2048)	NOT NULL,

	SourceMediaAgentId       integer	NOT NULL,

	SourceMediaAgentName     nvarchar(510)	NOT NULL,

	MountPathType			 integer	NOT NULL,

	TargetDeviceMediaAgentId integer	NOT NULL,

	SourceDeviceId			 integer	NOT NULL,

	SourceDeviceName		 nvarchar(516)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ClientLicenses]') )
BEGIN
	DROP TABLE #CCM_ClientLicenses
END


CREATE  TABLE   #CCM_ClientLicenses (
	Old_clientId integer	NOT NULL,

	New_clientId integer	NOT NULL,

	appType integer	NOT NULL,

	simProdMapId integer	NOT NULL,

	simLicAppType integer	NOT NULL,

	simLicName varchar(128)	NOT NULL,

	minAppId integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxAccessPathMapping]') )
BEGIN
	DROP TABLE #CCM_IdxAccessPathMapping
END


CREATE  TABLE   #CCM_IdxAccessPathMapping (
	oldIdxSIDBStoreId		integer	NOT NULL,

	oldIdxSIDBStoreName	varchar(128)	NOT NULL,

	oldIdxAccessPathId	integer	NOT NULL,

	oldStoragePolicyName varchar(128)	NOT NULL,

	oldCopyName					varchar(128)	NOT NULL,

	oldClientName				varchar(128)	NOT NULL,

	oldPath							varchar(1024)	NOT NULL,

	newClientId					integer	NOT NULL,

	newPath							varchar(1024)	NOT NULL,

	newUserName					varchar(1024)	NOT NULL,

	newPassword					varchar(2048)	NOT NULL,

	isGlobal			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_VirtualClientLicenses]') )
BEGIN
	DROP TABLE #CCM_VirtualClientLicenses
END


CREATE  TABLE   #CCM_VirtualClientLicenses (
	OldVMClientId			integer	NOT NULL,

	NewVMClientId			integer	NOT NULL,

	NewVMName               nvarchar(510)	NOT NULL,

	OldPMClientId			integer	NOT NULL,

	NewPMClientId			integer	NOT NULL,

	NewPMName               nvarchar(510)	NOT NULL,

	AppType				integer	NOT NULL,

	LicType				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MountPathLicense]') )
BEGIN
	DROP TABLE #CCM_MountPathLicense
END


CREATE  TABLE   #CCM_MountPathLicense (
	clientId integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_DevicePathMapping]') )
BEGIN
	DROP TABLE #CCM_DevicePathMapping
END


CREATE  TABLE   #CCM_DevicePathMapping (
	SourceDeviceId		integer	NOT NULL,

	SourceDeviceName				varchar(max) NOT NULL,

	SourceDevicePath				varchar(max) NOT NULL,

	newMediaAgentId		integer	NOT NULL,

	newDevicePath		varchar(1024)	NOT NULL,

	newUserName			varchar(1024)	NOT NULL,

	newPassword			varchar(2048)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LibraryMapping]') )
BEGIN
	DROP TABLE #CCM_LibraryMapping
END


CREATE  TABLE   #CCM_LibraryMapping (
	SourceLibraryId			integer	NOT NULL,

	SourceLibraryName		nvarchar(128)	NOT NULL,

	SourceLibraryTypeId		integer	NOT NULL,

	newMediaAgentId			integer	NOT NULL,

	newLibraryId			integer	NOT NULL,

	newLibraryName			nvarchar(128)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_FeatureLicenses]') )
BEGIN
	DROP TABLE #CCM_FeatureLicenses
END


CREATE  TABLE   #CCM_FeatureLicenses (
	clientId integer	NOT NULL,

	appTypeId integer	NOT NULL,

	simLicAppType integer	NOT NULL,

	simLicName varchar(128)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ReformatedMedia]') )
BEGIN
	DROP TABLE #CCM_ReformatedMedia
END


CREATE  TABLE   #CCM_ReformatedMedia (
	MediaId				integer	NOT NULL,

	CommCellId			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CommCell]') )
BEGIN
	DROP TABLE #CCM_APP_CommCell
END


CREATE  TABLE   #CCM_APP_CommCell (
	id					INTEGER NOT NULL,

	number				integer	NOT NULL,

	clientId			integer	NOT NULL,

	parentId			integer	NOT NULL,

	aliasName			nvarchar(256)	NOT NULL,

	flags				integer	NOT NULL,

	refTime				INTEGER  NOT NULL,

	userName			nvarchar(256)	NOT NULL,

	userPassword		nvarchar(1024)	NOT NULL,

	smtpServer			nvarchar(256)	NOT NULL,

	timeZone			nvarchar(1024)	NOT NULL,

	ipAddress			nvarchar(25)	NOT NULL,

	modified			INTEGER  NOT NULL,

	ccOpMode			integer	NOT NULL,

	drIpAddress			nvarchar(25)	NOT NULL,

	encNumber			nvarchar(256)	NOT NULL,

	csGUID				nvarchar(40)	NOT NULL,

	type				tinyint default 1	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Client]') )
BEGIN
	DROP TABLE #CCM_APP_Client
END


CREATE  TABLE   #CCM_APP_Client (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	name			    nvarchar(255)	NOT NULL,

	simOperatingSystemId		integer	NOT NULL,	--  "FOREIGN KEY TO ANOTHER TABLE?"

	net_hostname	    nvarchar(255)	NOT NULL,

	client_password	    nvarchar(255)	NOT NULL,

	refTime				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	offlineEntity		integer	NOT NULL,

	offlineTimeStamp	INTEGER  NOT NULL,

	csHostName			nvarchar(255)	NOT NULL,

	clientDescription				nvarchar(MAX) NOT NULL,

	jobResultDir		nvarchar(255)	NOT NULL,

	clientSkewTime		integer	NOT NULL,

	cvdPort             integer	NOT NULL,

	evmgrcPort			integer	NOT NULL,

	status				integer	NOT NULL,

	releaseId			integer	NOT NULL,

	spaceCheckFlags		integer	NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy

	ccpTime				INTEGER  Default 0 NOT NULL,	-- "     "

	origCCId			integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	GUID				uniqueidentifier ROWGUIDCOL NULL,

	specialClientFlags	integer Default 0 NOT NULL,

	displayName			nvarchar(255) DEFAULT 'REPLACEWITHCLIENTNAME' NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ClientProp]') )
BEGIN
	DROP TABLE #CCM_APP_ClientProp
END


CREATE  TABLE   #CCM_APP_ClientProp (
	id					INTEGER NOT NULL,

	componentNameId		integer	NOT NULL,

	attrName			nvarchar(1024)	NOT NULL,

	attrType			integer	NOT NULL,

	attrVal				nvarchar(1024)	NOT NULL,

	created				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_VMProp]') )
BEGIN
	DROP TABLE #CCM_APP_VMProp
END


CREATE  TABLE   #CCM_APP_VMProp (
	jobId				integer	NOT NULL,

	commCellId			integer	NOT NULL,

	VMclientId			integer	NOT NULL,

	attrName			nvarchar(1024)	NOT NULL,

	attrType			integer	NOT NULL,

	attrVal				nvarchar(1024)	NOT NULL,

	ClientJobId			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMQinetixUpdateStatus]') )
BEGIN
	DROP TABLE #CCM_JMQinetixUpdateStatus
END


CREATE  TABLE   #CCM_JMQinetixUpdateStatus (
	jobId			integer	NOT NULL,

	commCellId		integer	NOT NULL,

	clientId		integer	NOT NULL,

	clientName		nvarchar(255)	NOT NULL,

	status			integer	NOT NULL,

	category		integer	NOT NULL,

	ostype			integer	NOT NULL,

	discoverPhaseStatus	integer	NOT NULL,

	foreignCommCellName	nvarchar(256)	NOT NULL,

	clientRegistry		XML,

	installedUpdates				nvarchar(MAX) NOT NULL,

	statusMessage		varchar(256)default '',	-- Localised message Ids from JMFailureReasonMsg NOT NULL

	transferStatus		integer NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Platform]') )
BEGIN
	DROP TABLE #CCM_APP_Platform
END


CREATE  TABLE   #CCM_APP_Platform (
	clientId		integer	NOT NULL,	-- clientId maps to client table

	platformType	integer	NOT NULL,	-- CV Platform Type defines in CVPlatformInfo.h

	install_dir	    nvarchar(255)	NOT NULL,

	refTime			INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_IDAName]') )
BEGIN
	DROP TABLE #CCM_APP_IDAName
END


CREATE  TABLE   #CCM_APP_IDAName (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	clientId			integer	NOT NULL,	--Foreign key to APP_Client Table

	appTypeId		    integer	NOT NULL,	--Foreign key to APP_iDAType table

	status				integer	NOT NULL,

	refTime				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy

	ccpTime				INTEGER  Default 0 NOT NULL	-- "     "



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_IDAProp]') )
BEGIN
	DROP TABLE #CCM_APP_IDAProp
END


CREATE  TABLE   #CCM_APP_IDAProp (
	id				INTEGER NOT NULL,

	componentNameId		integer	NOT NULL,

	attrName		    	nvarchar(1024)	NOT NULL,

	attrType			integer	NOT NULL,

	attrVal				nvarchar(MAX)NOT NuLl,

	created			INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_DCvolInfo]') )
BEGIN
	DROP TABLE #CCM_APP_DCvolInfo
END


CREATE  TABLE   #CCM_APP_DCvolInfo (
	id                   INTEGER NOT NULL,

	componentNameId      integer	NOT NULL,

	volName              nvarchar(400)	NOT NULL,

	capacity             integer	NOT NULL,

	initialRunStatus	  integer	NOT NULL,

	state				  integer	NOT NULL,

	refTime              INTEGER  NOT NULL,

	flags                integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_InstanceName]') )
BEGIN
	DROP TABLE #CCM_APP_InstanceName
END


CREATE  TABLE   #CCM_APP_InstanceName (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	name			    nvarchar(512)	NOT NULL,

	refTime				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	status				integer	NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy

	ccpTime				INTEGER  Default 0 NOT NULL,	-- "     "

	origCCId			integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	GUID				uniqueidentifier ROWGUIDCOL NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_InstanceProp]') )
BEGIN
	DROP TABLE #CCM_APP_InstanceProp
END


CREATE  TABLE   #CCM_APP_InstanceProp (
	id				INTEGER NOT NULL,

	componentNameId		integer	NOT NULL,

	attrName		    	nvarchar(1024)	NOT NULL,

	attrType			integer	NOT NULL,

	attrVal				nvarchar(MAX) NOT NULL,

	created			INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_InstFilterFile]') )
BEGIN
	DROP TABLE #CCM_APP_InstFilterFile
END


CREATE  TABLE   #CCM_APP_InstFilterFile (
	componentNameId		integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	type				integer	NOT NULL,

	fileName				nvarchar(MAX) NOT NULL,

	created				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	id                  INTEGER NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_BackupSetName]') )
BEGIN
	DROP TABLE #CCM_APP_BackupSetName
END


CREATE  TABLE   #CCM_APP_BackupSetName (
	id			INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	name			nvarchar(128)	NOT NULL,

	refTime			INTEGER  NOT NULL,

	modified		INTEGER  NOT NULL,

	status			integer	NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy

	ccpTime				INTEGER  Default 0 NOT NULL,	-- "     "

	origCCId			integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	GUID				uniqueidentifier ROWGUIDCOL NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_BackupSetProp]') )
BEGIN
	DROP TABLE #CCM_APP_BackupSetProp
END


CREATE  TABLE   #CCM_APP_BackupSetProp (
	id				INTEGER NOT NULL,

	componentNameId		integer	NOT NULL,

	attrName		    	nvarchar(1024)	NOT NULL,

	attrType			integer	NOT NULL,

	attrVal				nvarchar(MAX)NOT NuLl,

	created			INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_BackupSetFilterFile]') )
BEGIN
	DROP TABLE #CCM_APP_BackupSetFilterFile
END


CREATE  TABLE   #CCM_APP_BackupSetFilterFile (
	componentNameId		integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	type				integer	NOT NULL,

	fileName	    	nvarchar(1024)	NOT NULL,

	created				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Application]') )
BEGIN
	DROP TABLE #CCM_APP_Application
END


CREATE  TABLE   #CCM_APP_Application (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	clientId			integer	NOT NULL,

	appTypeId			integer	NOT NULL,

	instance	   	    	integer	NOT NULL,

	backupSet			integer	NOT NULL,

	appNumber			integer	NOT NULL,

	dataArchGrpID		smallint	NOT NULL,	-- Data Archive Group

	logArchGrpID		smallint	NOT NULL,	-- Index Archive Group

	refTime				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	subclientName		nvarchar(128)	NOT NULL,

	subclientStatus     integer	NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy

	ccpTime				INTEGER  Default 0 NOT NULL,	-- "     "

	origCCId			integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	GUID				uniqueidentifier ROWGUIDCOL NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_SubClientProp]') )
BEGIN
	DROP TABLE #CCM_APP_SubClientProp
END


CREATE  TABLE   #CCM_APP_SubClientProp (
	id				INTEGER NOT NULL,

	componentNameId		integer	NOT NULL,

	attrName		    	nvarchar(1024)	NOT NULL,

	attrType			integer	NOT NULL,

	attrVal				nvarchar(MAX)NOT NuLl,

	created			INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ComponentProp]') )
BEGIN
	DROP TABLE #CCM_APP_ComponentProp
END


CREATE  TABLE   #CCM_APP_ComponentProp (
	id				INTEGER NOT NULL,

	componentType	integer	NOT NULL,	-- Mailbox name, mailbox GUID, etc .... These are defined FOR this table

	componentId		integer	NOT NULL,	-- Key into existing property table  (e.g. subClientProp)

	propertyTypeId	integer	NOT NULL,	-- PROPERTY_EXCHANGE_MBOX (enum Property_Enum)

	dataType		integer	NOT NULL,	-- Integer, String, etc ... Also Property_enum!

	longVal			integer	NOT NULL,	-- Used to hold value for anything that will fit in it (long/short/bool etc ...

	longlongVal		bigint	NOT NULL,	-- Used to hold values for 64 bit entities

	stringVal       nVarchar(MaX) NULL,	-- Used to hold the rest!

	created			INTEGER  NOT NULL,

	modified		INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ScFilterFile]') )
BEGIN
	DROP TABLE #CCM_APP_ScFilterFile
END


CREATE  TABLE   #CCM_APP_ScFilterFile (
	id                  INTEGER NOT NULL,

	componentNameId		integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	type				integer	NOT NULL,

	fileName				nvarchar(MAX) NOT NULL,

	created				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_VMToPMMap]') )
BEGIN
	DROP TABLE #CCM_APP_VMToPMMap
END


CREATE  TABLE   #CCM_APP_VMToPMMap (
	VMClientId			integer	NOT NULL,

	PMClientId			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_VMBackupSet]') )
BEGIN
	DROP TABLE #CCM_APP_VMBackupSet
END


CREATE  TABLE   #CCM_APP_VMBackupSet (
	VMClientId			integer	NOT NULL,

	ParentBackupSetId	integer	NOT NULL,

	ChildBackupSetId	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simClientAppsV2]') )
BEGIN
	DROP TABLE #CCM_simClientAppsV2
END


CREATE  TABLE   #CCM_simClientAppsV2 (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	clientId			   integer	NOT NULL,

	simProdMapId		integer	NOT NULL,

	simGroupId			integer	NOT NULL,	-- NOT CURRENTLY A FOREGN KEY ... CONTRAINT ISSUES!!!!

	status				integer	NOT NULL,

	installTime			INTEGER  NOT NULL,

	buildId				varchar(32)	NOT NULL,

	releaseId			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simAllGalaxyRel]') )
BEGIN
	DROP TABLE #CCM_simAllGalaxyRel
END


CREATE  TABLE   #CCM_simAllGalaxyRel (
	id					integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	release			    varchar(128)	NOT NULL,

	buildNum			integer DEFAULT 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_PatchDBSPInfo]') )
BEGIN
	DROP TABLE #CCM_PatchDBSPInfo
END


CREATE  TABLE   #CCM_PatchDBSPInfo (
	SPNumber			integer	NOT NULL,

	PatchName			nvarchar(64)	NOT NULL,

	AppTypeId			integer	NOT NULL,

	SpMinorVersion		integer	NOT NULL,

	AliasName			nvarchar(64)	NOT NULL,

	StepNo				integer	NOT NULL,

	TransactionID		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simInstalledPackages]') )
BEGIN
	DROP TABLE #CCM_simInstalledPackages
END


CREATE  TABLE   #CCM_simInstalledPackages (
	id					INTEGER NOT NULL,

	ClientId			integer	NOT NULL,

	simPackageID		integer	NOT NULL,

	OpTime				datetime,

	OpType				char(25)	NOT NULL,

	UserID				integer	NOT NULL,

	HighestSP			integer	NOT NULL,

	AdditionalPatches				nvarchar(max)NULL,

	MissingPatches				nvarchar(max)NULL,

	Node				nvarchar(255),

	IsActive			integer default (1)	NOT NULL,

	SpMinorVersion		integer	NOT NULL,

	Baseline			integer	NOT NULL,

	BaselineDeltaSP				nvarchar(max)NULL,

	BaselineDeltaUpdate				nvarchar(max)NULL,

	SPVersionId			integer NULL,

	UPNumber		integer NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simInstalledPackagesHistory]') )
BEGIN
	DROP TABLE #CCM_simInstalledPackagesHistory
END


CREATE  TABLE   #CCM_simInstalledPackagesHistory (
	id					INTEGER NOT NULL,

	simInstalledPkgID	integer	NOT NULL,

	simPackageID		integer	NOT NULL,

	ClientId			integer	NOT NULL,

	InstallState		integer	NOT NULL,

	OpType				char(25)	NOT NULL,

	PreviousReleaseID	integer	NOT NULL,

	ReleaseID			integer	NOT NULL,

	OpTime				datetime,

	UserID				integer	NOT NULL,

	AppType				integer	NOT NULL,

	LicType				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simXMLRequest]') )
BEGIN
	DROP TABLE #CCM_simXMLRequest
END


CREATE  TABLE   #CCM_simXMLRequest (
	id			INTEGER NOT NULL,

	clientId	integer	NOT NULL,

	OpTimeUTC	datetime,

	xmlBlob		XML,

	xmlResponse	XML DEFAULT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CustomCalendar]') )
BEGIN
	DROP TABLE #CCM_APP_CustomCalendar
END


CREATE  TABLE   #CCM_APP_CustomCalendar (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	name				nvarchar(1024) 			NOT NULL,	-- Name of calendar

	beginYear			integer									NOT NULL,

	beginMonth			integer									NOT NULL,

	beginDate			integer									NOT NULL,

	noOfyears			integer									NOT NULL,

	isDefault			integer									NOT NULL,

	calType				integer									NOT NULL,

	createdTime			integer									NOT NULL,

	modifiedTime		integer									NOT NULL,

	origCCId			integer									DEFAULT		2	NOT NULL,

	GUID				uniqueidentifier ROWGUIDCOL NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CustomCalendarMonths]') )
BEGIN
	DROP TABLE #CCM_APP_CustomCalendarMonths
END


CREATE  TABLE   #CCM_APP_CustomCalendarMonths (
	calendarId			integer	NOT NULL,	-- FOREIGN KEY TO APP_CustomCalendar

	year				integer 		NOT NULL,			-- 2004, 2005

	month				integer 		NOT NULL,			-- Jan - 1, Feb = 2

	offset				integer									NOT NULL,		-- Offset from the standard calendar

	daysCount			integer									NOT NULL,   	-- Number of days in month

	startDate			DATETIME								NOT NULL,

	endDate				DATETIME								NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_OracleRacInstance]') )
BEGIN
	DROP TABLE #CCM_APP_OracleRacInstance
END


CREATE  TABLE   #CCM_APP_OracleRacInstance (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	instaceId			integer	NOT NULL,	-- Foreign key to galaxy instance Id

	clientId			integer	NOT NULL,	-- Foreign key to client table

	name				nvarchar(255)	NOT NULL,

	oracleHome		    nvarchar(255)	NOT NULL,

	oracleUser		    nvarchar(255)	NOT NULL,

	parellelInstance    nvarchar(255)	NOT NULL,

	InstanceOraUser     nvarchar(255)	NOT NULL,

	InstanceOraPasswd   nvarchar(255)	NOT NULL,

	InstanceOraService  nvarchar(255)	NOT NULL,

	tnsAdmin			nvarchar(255)	NOT NULL,

	threadId			integer	NOT NULL,

	instanceNumber		integer	NOT NULL,

	flag				integer	NOT NULL,

	status				integer	NOT NULL,	--Status Open = 1, mounted = 2, shutdown = 3, started = 4

	sbtLibName			nvarchar(255)	NOT NULL,

	ntPassword			nvarchar(255)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ExtendedProperties]') )
BEGIN
	DROP TABLE #CCM_APP_ExtendedProperties
END


CREATE  TABLE   #CCM_APP_ExtendedProperties (
	clientId			integer	NOT NULL,

	appTypeId			integer	NOT NULL,

	instance	   	    integer	NOT NULL,

	backupSet			integer	NOT NULL,

	subclientId			integer	NOT NULL,

	attrType			integer	NOT NULL,

	attrName	    	nvarchar(64)	NOT NULL,

	attrVal				nvarchar(max)NULL,

	MD5					varchar(64)	NOT NULL,

	created				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer	NOT NULL,	-- 9.0 Client Configuration Policy



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ClientGroup]') )
BEGIN
	DROP TABLE #CCM_APP_ClientGroup
END


CREATE  TABLE   #CCM_APP_ClientGroup (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	name				nvarchar(512)	NOT NULL,

	description				nvarchar(MAX) NOT NULL,

	flag				integer	NOT NULL,

	status				integer	NOT NULL,

	userId				integer	NOT NULL,

	refTime				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	fwPorts				nvarchar(255) default('')	NOT NULL,

	origCCId			integer		DEFAULT		2	NOT NULL,

	GUID				uniqueidentifier ROWGUIDCOL NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SchedHoliday]') )
BEGIN
	DROP TABLE #CCM_SchedHoliday
END


CREATE  TABLE   #CCM_SchedHoliday (
	startYear   integer	NOT NULL,

	startMonth  integer	NOT NULL,

	startDay    integer	NOT NULL,

	startHour   integer	NOT NULL,

	startMinute integer	NOT NULL,

	startSecond integer	NOT NULL,

	endYear     integer	NOT NULL,

	endMonth    integer	NOT NULL,

	endDay      integer	NOT NULL,

	endHour     integer	NOT NULL,

	endMinute   integer	NOT NULL,

	endSecond   integer	NOT NULL,

	modified	INTEGER  NOT NULL,	-- Used To Monitor if anything has changed

	description	nvarchar(80)	NOT NULL,

	clientId    integer	NOT NULL,

	groupId     integer	NOT NULL,

	id			INTEGER NOT NULL,

	vtPolicyId	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_OpWindowRule]') )
BEGIN
	DROP TABLE #CCM_APP_OpWindowRule
END


CREATE  TABLE   #CCM_APP_OpWindowRule (
	id				    integer	NOT NULL,

	clientId			integer	NOT NULL,

	appTypeId			integer	NOT NULL,

	opType				integer	NOT NULL,

	daysOfWeek			integer	NOT NULL,

	startTime			integer	NOT NULL,

	endTime				integer	NOT NULL,

	enable				integer	NOT NULL,

	description			nvarchar(1024)	NOT NULL,

	utilization			integer	NOT NULL,

	clientGroupId		integer	NOT NULL,

	instanceId			integer	NOT NULL,

	backupsetId			integer	NOT NULL,

	subclientId			integer	NOT NULL,

	startDate			integer	NOT NULL,

	endDate				integer	NOT NULL,

	schedulePolicyId	integer default 0	NOT NULL,

	weekOfTheMonth		integer default -1	NOT NULL,

	doNotSubmitJob		integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_MongoDbSCPriority]') )
BEGIN
	DROP TABLE #CCM_APP_MongoDbSCPriority
END


CREATE  TABLE   #CCM_APP_MongoDbSCPriority (
	id 			INTEGER NOT NULL,  		--Primary Key

	mdbNode		INTEGER	NOT NULL,

	subclientId 		INTEGER	NOT NULL,

	priority    INTEGER	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archGroup]') )
BEGIN
	DROP TABLE #CCM_archGroup
END


CREATE  TABLE   #CCM_archGroup (
	id                  SMALLINT NOT NULL,

	defaultCopy			smallint	NOT NULL,

	name				NVARCHAR(144)	NOT NULL,

	description				NVARCHAR(MAX) NOT NULL,

	maxStreams			integer	NOT NULL,

	type				tinyint	NOT NULL,

	incrSP				smallint	NOT NULL,

	origCCcommCellID	integer	NOT NULL,

	origCCarchGroupId	smallint	NOT NULL,

	defaultSnapCopy		smallint	NOT NULL,

	SIBlockSizeKB		integer	NOT NULL,

	AuxCopyAlertGB		integer	NOT NULL,

	AuxCopyAlertDays	integer	NOT NULL,

	flags				integer	NOT NULL,

	mediaPassword		varchar(2048)	NOT NULL,

	TimeZoneType		tinyint	NOT NULL,

	TimeZone				varchar(255)	NOT NULL,

	SubclientExtensionTimeStamp 			integer Default 0	NOT NULL,

	SubclientExtensionTimeStampEncrypted 	varchar(2048) Default ''	NOT NULL,

	logSP				smallint Default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archGroupCopy]') )
BEGIN
	DROP TABLE #CCM_archGroupCopy
END


CREATE  TABLE   #CCM_archGroupCopy (
	id					SMALLINT NOT NULL,		-- THIS FIELD -EITHER- AUTOGENERATED -OR- PASSED IN

	archGroupId      	smallint	NOT NULL,

	copy				smallint	NOT NULL,

	name				NVARCHAR(64)	NOT NULL,

	flags				integer	NOT NULL,

	maxMultiplex		tinyint	NOT NULL,	-- How many clients can backup to this copy simultaneously

	isActive			tinyint	NOT NULL,

	type				tinyint	NOT NULL,

	startTime			INTEGER  NOT NULL,

	waitForIfOffline	integer	NOT NULL,

	waitForIfBusy		integer	NOT NULL,

	archCheckStartTime	INTEGER  NOT NULL,

	origCCcommCellID	integer	NOT NULL,

	origCCarchCopyId	smallint	NOT NULL,

	sourceCopyId		smallint	NOT NULL,

	delayedDays			smallint	NOT NULL,

	maxStreamNum		integer	NOT NULL,

	archCheckValidPeriod	integer	NOT NULL,

	calendarId			integer	NOT NULL,

	SIDBStoreId			integer	NOT NULL,	-- The SIDBStoreId associated for this copy.

	encType				tinyint	NOT NULL,

	encKeyLen			smallint	NOT NULL,

	isSnapCopy			tinyint Default 0	NOT NULL,

	isMirrorCopy		tinyint Default 0	NOT NULL,

	NWWriteSpeed		integer Default 0	NOT NULL,

	SIDBSnapIntervalHours	integer Default 0	NOT NULL,

	siloAppId			integer Default 0	NOT NULL,

	nDataInstance		integer Default 0	NOT NULL,

	description				NVARCHAR(MAX)Default '' NOT NULL,

	dedupeFlags			integer Default 0	NOT NULL,

	blockCacheValidDays	integer Default 0	NOT NULL,

	nSiloStreams		integer Default 1	NOT NULL,

	silosInCache		integer Default 0	NOT NULL,

	siloRestoreMAClientId	integer Default 0	NOT NULL,

	siloRestoreClientId	integer Default 0	NOT NULL,

	sealStoreTaskId		integer Default 0	NOT NULL,

	extendedFlags		bigint Default 0	NOT NULL,

	destMediaCopyId		integer Default 0	NOT NULL,

	maxCacheDBSizeMB	integer Default 0	NOT NULL,

	DDBLimitExtensionTimeStamp integer Default 0	NOT NULL,

	DDBLimitExtensionTimeStampEncrypted varchar(2048) Default ''	NOT NULL,

	archCheckValidPeriodType	integer Default 3	NOT NULL,

	endTime				INTEGER  DEFAULT 2147483647 NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopyMediaRefreshProp]') )
BEGIN
	DROP TABLE #CCM_archCopyMediaRefreshProp
END


CREATE  TABLE   #CCM_archCopyMediaRefreshProp (
	copyId				smallint	NOT NULL,

	targetCopyId		smallint	NOT NULL,

	flags				integer	NOT NULL,

	daysAfterWritten	integer	NOT NULL,

	daysBeforeAged		integer	NOT NULL,

	percentage			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopyToGlobalPolicy]') )
BEGIN
	DROP TABLE #CCM_archCopyToGlobalPolicy
END


CREATE  TABLE   #CCM_archCopyToGlobalPolicy (
	copyId			smallint	NOT NULL,

	globalPolicyId		smallint	NOT NULL,

	flags			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archStream]') )
BEGIN
	DROP TABLE #CCM_archStream
END


CREATE  TABLE   #CCM_archStream (
	archGroupId			smallint	NOT NULL,

	archGroupCopyId		smallint	NOT NULL,

	stream				integer	NOT NULL,

	mediaGroupId		integer	NOT NULL,

	isActive			tinyint	NOT NULL,

	lastUsedTime		integer	NOT NULL,

	physicalDataSizeInGB	integer	NOT NULL,

	flags				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAgingRule]') )
BEGIN
	DROP TABLE #CCM_archAgingRule
END


CREATE  TABLE   #CCM_archAgingRule (
	copyId			  	smallint	NOT NULL,

	retentionDays  	integer	NOT NULL,

	fullCycles     	integer	NOT NULL,

	flags			   		integer	NOT NULL,

	weekStart				integer	NOT NULL,

	monthStart			integer	NOT NULL,

	yearStart				integer	NOT NULL,

	archiverRetDays integer DEFAULT -1	NOT NULL,

	retentionJobs			integer	NOT NULL,

	minutesSinceDayStarts            integer NOT NULL default 0,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAgingRuleExtended]') )
BEGIN
	DROP TABLE #CCM_archAgingRuleExtended
END


CREATE  TABLE   #CCM_archAgingRuleExtended (
	copyId			smallint	NOT NULL,

	retentionDays		integer	NOT NULL,

	retentionRule		integer	NOT NULL,

	currPeriodBegin		INTEGER  NOT NULL,

	currPeriodEnd		INTEGER  NOT NULL,

	prevPeriodBegin		INTEGER  NOT NULL,

	nextPeriodEnd		INTEGER  NOT NULL,

	GraceDays				integer	NOT NULL,

	EveryXHours                               integer not null  default  0,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAppCopyAgingRule]') )
BEGIN
	DROP TABLE #CCM_archAppCopyAgingRule
END


CREATE  TABLE   #CCM_archAppCopyAgingRule (
	appId										integer	NOT NULL,

	copyId			  					smallint	NOT NULL,

	retentionDays  					integer	NOT NULL,

	fullCycles 				    	integer	NOT NULL,

	flags			   						integer	NOT NULL,

	weekStart								integer	NOT NULL,

	monthStart							integer	NOT NULL,

	yearStart								integer	NOT NULL,

	archiverRetDays 				integer	NOT NULL,

	retentionJobs						integer	NOT NULL,

	minutesSinceDayStarts   integer	NOT NULL,

	archGrpId								smallint	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAppCopyAgingRuleExtended]') )
BEGIN
	DROP TABLE #CCM_archAppCopyAgingRuleExtended
END


CREATE  TABLE   #CCM_archAppCopyAgingRuleExtended (
	appId						integer	NOT NULL,

	copyId					smallint	NOT NULL,

	retentionDays		integer	NOT NULL,

	retentionRule		integer	NOT NULL,

	GraceDays				integer	NOT NULL,

	EveryXHours     integer	NOT NULL,

	archGrpId				smallint	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archSelectiveCopy]') )
BEGIN
	DROP TABLE #CCM_archSelectiveCopy
END


CREATE  TABLE   #CCM_archSelectiveCopy (
	copyId			smallint	NOT NULL,

	type			tinyint	NOT NULL,

	numPeriod		tinyint	NOT NULL,

	dayNumber		smallint	NOT NULL,

	startPeriod		INTEGER  NOT NULL,

	nextPeriod		INTEGER  NOT NULL,

	prevPeriodBegin	INTEGER  NOT NULL,

	nextPeriodEnd	INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopyToApp]') )
BEGIN
	DROP TABLE #CCM_archCopyToApp
END


CREATE  TABLE   #CCM_archCopyToApp (
	copyId			smallint	NOT NULL,

	clientId		integer	NOT NULL,

	appTypeId		integer	NOT NULL,

	instanceId	   	integer	NOT NULL,

	backupSetId		integer	NOT NULL,

	subClientId		integer	NOT NULL,

	clientGroupId	integer default 0	NOT NULL,

	exclude			integer default 0	NOT NULL,

	assocType		integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopySIDBStore]') )
BEGIN
	DROP TABLE #CCM_archCopySIDBStore
END


CREATE  TABLE   #CCM_archCopySIDBStore (
	CopyId							smallint	NOT NULL,

	SIDBStoreId						integer	NOT NULL,

	CommCellId						integer	NOT NULL,

	flags							integer	NOT NULL,

	TotalDataSizeBytes				bigint	NOT NULL,

	InstancedDataSizeBytes			bigint	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchEncKeyProvider]') )
BEGIN
	DROP TABLE #CCM_ArchEncKeyProvider
END


CREATE  TABLE   #CCM_ArchEncKeyProvider (
	KeyProviderId		INTEGER NOT NULL,

	KeyProviderName		NVARCHAR(64)	NOT NULL,

	KeyProviderType		integer	NOT NULL,

	EncType				integer	NOT NULL,

	EncKeyLength		integer	NOT NULL,

	Properties				nvarchar(max) NOT NULL,

	Modified			INTEGER  NOT NULL,

	Created				INTEGER  NOT NULL,

	GUID				uniqueidentifier,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchEncKeyProviderAssoc]') )
BEGIN
	DROP TABLE #CCM_ArchEncKeyProviderAssoc
END


CREATE  TABLE   #CCM_ArchEncKeyProviderAssoc (
	KeyProviderAssocId		INTEGER NOT NULL,

	KeyProviderId			integer	NOT NULL,

	EntityId				integer	NOT NULL,

	EntityType				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchCopyEncProperties]') )
BEGIN
	DROP TABLE #CCM_ArchCopyEncProperties
END


CREATE  TABLE   #CCM_ArchCopyEncProperties (
	CopyId				smallint	NOT NULL,

	PubKey				varchar(2048)	NOT NULL,

	PriKey				varchar(3072)	NOT NULL,

	MasterKeyId			varchar(2048)	NOT NULL,

	KeyProviderId		int	NOT NULL,

	EncType				int	NOT NULL,

	LastValidatedTime	INTEGER  default 0 NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archPipeConfig]') )
BEGIN
	DROP TABLE #CCM_archPipeConfig
END


CREATE  TABLE   #CCM_archPipeConfig (
	appNumber			integer	NOT NULL,

	compressWhere		tinyint	NOT NULL,

	numNWAgents			tinyint	NOT NULL,

	NWWriteSpeed		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFile]') )
BEGIN
	DROP TABLE #CCM_archFile
END


CREATE  TABLE   #CCM_archFile (
	id				INTEGER NOT NULL,

	name				NVARCHAR(2048)	NOT NULL,

	commCellId			integer	NOT NULL,

	archGroupId			smallint	NOT NULL,

	objName1			varchar(2048)	NOT NULL,

	flags				integer	NOT NULL,

	appId				integer	NOT NULL,

	fileType			tinyint	NOT NULL,

	cTime				integer	NOT NULL,

	jobId				integer	NOT NULL,

	backupLevel			integer	NOT NULL,

	isValid				smallint	NOT NULL,

	cloudId				integer	NOT NULL,

	contentIndexTime	integer	NOT NULL,

	nPushedItems		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileOracle]') )
BEGIN
	DROP TABLE #CCM_archFileOracle
END


CREATE  TABLE   #CCM_archFileOracle (
	archFileId		integer	NOT NULL,

	commCellId		integer	NOT NULL,

	appId					integer	NOT NULL,

	instanceId		integer	NOT NULL,

	clientId			integer	NOT NULL,

	archFileName	NVARCHAR(2048)	NOT NULL,

	fileType			integer	NOT NULL,

	flags					integer	NOT NULL,

	jobId					integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileOracleBackupPiece]') )
BEGIN
	DROP TABLE #CCM_archFileOracleBackupPiece
END


CREATE  TABLE   #CCM_archFileOracleBackupPiece (
	archFileId		INTEGER	NOT NULL,

	commCellId		INTEGER	NOT NULL,

	instanceId		INTEGER	NOT NULL,

	backupPiece		NVARCHAR(512)	NOT NULL,

	offset			BIGINT	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileCopy]') )
BEGIN
	DROP TABLE #CCM_archFileCopy
END


CREATE  TABLE   #CCM_archFileCopy (
	archFileId			integer	NOT NULL,	-- From archFile table

	commCellId     		integer	NOT NULL,

	archCopyId			smallint	NOT NULL,

	flags				integer	NOT NULL,

	isValid				smallint	NOT NULL,

	streamNum			integer	NOT NULL,

	lastChunkNumber		integer	NOT NULL,

	physicalSize		bigint	NOT NULL,

	logicalSize			bigint	NOT NULL,

	drivePoolId			int	NOT NULL,

	encRSA				tinyint	NOT NULL,

	encKeyType			tinyint	NOT NULL,

	encKey				varchar(1024)	NOT NULL,

	modifiedTime		INTEGER  NOT NULL,

	mediaType			integer	NOT NULL,

	agedBy				bigint	NOT NULL,

	encKeyId			int default 0	NOT NULL,

	unCompSize			bigint DEFAULT -1	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archChunk]') )
BEGIN
	DROP TABLE #CCM_archChunk
END


CREATE  TABLE   #CCM_archChunk (
	id				bigint	NOT NULL,	-- 64 bit number for unique chunk idetification

	commCellId      integer	NOT NULL,

	volumeId		integer	NOT NULL,

	fileMarkerNo	integer	NOT NULL,

	createTime		integer	NOT NULL,

	version			tinyint	NOT NULL,

	cclip			varchar(255)	NOT NULL,

	physicalSize	bigint	NOT NULL,

	logicalSize		bigint	NOT NULL,

	writeTime		integer	NOT NULL,

	flags			integer	NOT NULL,

	modifiedTime	INTEGER  NOT NULL,

	hwEncKey		varchar(114)	NOT NULL,

	agedBy			bigint	NOT NULL,

	origCCId		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archChunkMapping]') )
BEGIN
	DROP TABLE #CCM_archChunkMapping
END


CREATE  TABLE   #CCM_archChunkMapping (
	archChunkId			bigint	NOT NULL,

	archFileId			integer	NOT NULL,

	commCellId			integer	NOT NULL,

	archCopyId			smallint	NOT NULL,

	chunkNumber			integer	NOT NULL,

	physicalOffset		bigint	NOT NULL,

	logicalOffset		bigint	NOT NULL,

	physicalSize		bigint	NOT NULL,

	logicalSize			bigint	NOT NULL,

	flags				integer	NOT NULL,

	modifiedTime		INTEGER  NOT NULL,

	dedupedSize			bigint	NOT NULL,

	agedBy				bigint	NOT NULL,

	chunkCommCellId     integer	NOT NULL,

	jobId				integer	NOT NULL,

	unCompSize			bigint DEFAULT -1	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archDB2Log]') )
BEGIN
	DROP TABLE #CCM_archDB2Log
END


CREATE  TABLE   #CCM_archDB2Log (
	archFileId	integer	NOT NULL,

	firstLogTime	integer	NOT NULL,

	lastLogTime	integer	NOT NULL,

	firstLogNumber	integer	NOT NULL,

	lastLogNumber	integer	NOT NULL,

	commCellId	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCheckHistory]') )
BEGIN
	DROP TABLE #CCM_archCheckHistory
END


CREATE  TABLE   #CCM_archCheckHistory (
	jobId			integer	NOT NULL,

	commCellId      integer	NOT NULL,	--can be tinyint if it's tinyint in JM tables.

	archCopyId      smallint	NOT NULL,

	adminJobId		integer	NOT NULL,

	adminJobType	tinyint	NOT NULL,

	archCheckEndTime INTEGER  NOT NULL,

	archCheckStatus	tinyint	NOT NULL,

	errorString		varchar(4096)	NOT NULL,

	flags			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileSiloVolume]') )
BEGIN
	DROP TABLE #CCM_archFileSiloVolume
END


CREATE  TABLE   #CCM_archFileSiloVolume (
	archFileId			integer	NOT NULL,

	commCellId			integer	NOT NULL,

	siloVolumeId		integer	NOT NULL,

	lastSiloChunkId		bigint	NOT NULL,

	flags				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archChunkToSilo]') )
BEGIN
	DROP TABLE #CCM_archChunkToSilo
END


CREATE  TABLE   #CCM_archChunkToSilo (
	archChunkId		bigint	NOT NULL,	-- 64 bit number for unique chunk idetification

	commCellId      integer	NOT NULL,

	volumeId		integer	NOT NULL,

	flags			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFailedKilledJobInfo]') )
BEGIN
	DROP TABLE #CCM_archFailedKilledJobInfo
END


CREATE  TABLE   #CCM_archFailedKilledJobInfo (
	jobId							integer	NOT NULL,

	commCellId				integer	NOT NULL,

	servStartDate			INTEGER  NOT NULL,

	servEndDate				INTEGER  NOT NULL,

	appId							integer	NOT NULL,

	appType						integer	NOT NULL,

	archGrpId					smallint	NOT NULL,

	archGrpCopyId			smallint	NOT NULL,

	bkpLevel					integer	NOT NULL,

	opType						integer	NOT NULL,

	retentionFlags		integer	NOT NULL,

	flags							integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobStats]') )
BEGIN
	DROP TABLE #CCM_JMJobStats
END


CREATE  TABLE   #CCM_JMJobStats (
	jobId			integer	NOT NULL,

	status			integer	NOT NULL,

	opType			integer	NOT NULL,

	commCellId		integer	NOT NULL,

	jobCategory		integer	NOT NULL,

	jobDescription				nvarchar(max) NOT NULL,

	xmlJobInfo				nvarchar(max) NOT NULL,

	subOpType			integer	NOT NULL,

	foreignToken		nvarchar(2048)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobAction]') )
BEGIN
	DROP TABLE #CCM_JMJobAction
END


CREATE  TABLE   #CCM_JMJobAction (
	clientId 			integer	NOT NULL,	-- From APP_Client table

	mediaAgentID		integer	NOT NULL,

	appType				integer	NOT NULL,	-- From APP_iDAType table

	opType				integer	NOT NULL,

	action				integer	NOT NULL,

	appId				integer	NOT NULL,

	clientGroupId 		integer	NOT NULL,

	enableTimeZone		integer Default 0	NOT NULL,	-- 9.0 Timezone and time when to "re-enable"  Activity Control

	enableTime			INTEGER  Default 0 NOT NULL,	-- Skewed by Timezone

	UNCenableTime		INTEGER  Default 0 NOT NULL,	-- Greenich Time

	instanceID			INTEGER	NOT NULL,

	reason				NVARCHAR(1024) DEFAULT ''	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMBkpStats]') )
BEGIN
	DROP TABLE #CCM_JMBkpStats
END


CREATE  TABLE   #CCM_JMBkpStats (
	jobId				integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer	NOT NULL,

	appId				integer	NOT NULL,

	appType				integer	NOT NULL,

	numAttempts		integer	NOT NULL,

	dataArchGrpId		integer	NOT NULL,

	copyID				integer	NOT NULL,

	bkpLevel			integer	NOT NULL,

	indexOverride		integer	NOT NULL,

	status				integer	NOT NULL,

	duration			integer	NOT NULL,

	numStreams			integer	NOT NULL,

	servStartDate		INTEGER  NOT NULL,	-- Unix style date

	servEndDate			INTEGER  NOT NULL,	-- Unix style date

	opType				integer	NOT NULL,	-- From CVOpType Enum Type

	fullCycleNum		integer	NOT NULL,	-- Added for "Sparce Copy"

	initFrom		integer	NOT NULL,

	failureReason		varchar(256)	NOT NULL,

	bkpOptions		integer	NOT NULL,	-- Backup Options

	scanFileFailures	integer	NOT NULL,

	scanFolderFailures	integer	NOT NULL,

	backupFileFailures	integer	NOT NULL,

	backupFolderFailures	integer	NOT NULL,

	oraSubLevel		    integer	NOT NULL,	-- Sub backup level for oracle incremental job

	username		    nvarchar(255)	NOT NULL,

	totalWriteTime			integer	NOT NULL,

	priority	integer	NOT NULL,

	totalCompBytes		bigint	NOT NULL,

	totalUncompBytes	bigint	NOT NULL,

	totalNumOfFiles		bigint	NOT NULL,

	bkpattributes		bigint	NOT NULL,

	logArchGrpId		integer	NOT NULL,

	totalNumOfFolders	bigint	NOT NULL,

	failureErrorCode	integer	NOT NULL,

	lastIncrJobTime		integer	NOT NULL,

	scanType		integer	NOT NULL,

	scanTypeChangeReason	varchar(24),	-- saves the reason why the scan type was changed NOT NULL

	numStreamsRequested	integer	NOT NULL,

	dataStatus			integer	NOT NULL,

	agedTime			INTEGER  NOT NULL,

	mediaDeletedTime	INTEGER  NOT NULL,

	modifiedTime		INTEGER  NOT NULL,

	version				integer	NOT NULL,

	idaVersion			integer	NOT NULL,

	cIndexTime			INTEGER  NOT NULL,

	cycleSequence		integer	NOT NULL,

	filesToXfer			bigint	NOT NULL,

	cloudId				integer	NOT NULL,

	diffArchGrpId		integer	NOT NULL,

	totalBackupSize		bigint	NOT NULL,

	percentageChange 	integer	NOT NULL,

	targetClientId		integer	NOT NULL,

	totalUncompBytesToXfer	bigint	NOT NULL,

	displayStatus		integer	NOT NULL,

	dataBackedUp		integer	NOT NULL,

	logsBackedUp		integer	NOT NULL,

	openChain			integer	NOT NULL,

	secondaryBkpLevel	integer	NOT NULL,

	jobIdPrepared		integer	NOT NULL,

	jobIdActedOn		integer	NOT NULL,

	fromTime			integer	NOT NULL,

	toTime				integer	NOT NULL,

	subTaskId			integer	NOT NULL,

	nwTransBytes		bigint	NOT NULL,

	totSkippedObjects	bigint	NOT NULL,

	bkpAttributesEx		bigint	NOT NULL,

	jobReferenceTime	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMBkpAtmptStats]') )
BEGIN
	DROP TABLE #CCM_JMBkpAtmptStats
END


CREATE  TABLE   #CCM_JMBkpAtmptStats (
	jobId				integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	number				integer	NOT NULL,

	phase				integer	NOT NULL,

	elapsedTime			INTEGER  NOT NULL,

	servStartDate		INTEGER  NOT NULL,	-- Unix style date?

	servEndDate			INTEGER  NOT NULL,	-- Unix style date?

	unCompBytes			bigint	NOT NULL,

	compBytes			bigint	NOT NULL,

	numObjects			bigint	NOT NULL,	-- DOES THIS REALLY NEED TO BE A bigint?

	status				integer	NOT NULL,

	failureReason		varchar(256)	NOT NULL,

	writeTime			integer	NOT NULL,

	restartString		varchar(4096)	NOT NULL,

	attributes			integer	NOT NULL,

	commCellId			integer	NOT NULL,

	numFolders			bigint	NOT NULL,

	archGrpId			integer	NOT NULL,

	copyId				integer	NOT NULL,

	maxStreamsUsed		integer	NOT NULL,

	modifiedTime		INTEGER  NOT NULL,

	nwTransBytes		bigint	NOT NULL,

	totalAllocationTime				integer	NOT NULL,

	totalWaitTimeBeforeAllocation	integer	NOT NULL,

	readThroughput		float	NOT NULL,

	writeThroughput		float	NOT NULL,

	networkThroughput	float	NOT NULL,

	sidbLookups			float	NOT NULL,

	mediaAgent				nvarchar(max) NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMAdminJobStatsTable]') )
BEGIN
	DROP TABLE #CCM_JMAdminJobStatsTable
END


CREATE  TABLE   #CCM_JMAdminJobStatsTable (
	jobId				integer	NOT NULL,

	opType				integer	NOT NULL,

	status				integer	NOT NULL,

	servStart			INTEGER  NOT NULL,

	servEnd  			INTEGER  NOT NULL,

	archGrpID			integer	NOT NULL,

	archGrpName				nvarchar(max) NOT NULL,

	AP_NumDays			integer	NOT NULL,

	AP_IsForecast			integer	NOT NULL,

	AP_SeqNum			integer	NOT NULL,

	AC_NewMediaFlag			integer	NOT NULL,

	ER_BkpLevel			integer	NOT NULL,

	ER_DbName				nvarchar(max) NOT NULL,

	ER_Destination				nvarchar(max) NOT NULL,

	ER_SendCount			integer	NOT NULL,

	ER_MediasUsed				nvarchar(max) NOT NULL,

	EX_TotalMedia		bigint	NOT NULL,

	EX_TotalSuccess		bigint	NOT NULL,

	EX_TotalFailures	bigint	NOT NULL,

	initFrom		integer	NOT NULL,

	failureReason		varchar(256)	NOT NULL,

	archGrpCopyID			integer	NOT NULL,

	LibraryID		integer	NOT NULL,

	MI_InventoryType	integer	NOT NULL,

	username		    nvarchar(255)	NOT NULL,

	totalWriteTime		integer	NOT NULL,

	noOfStreams		integer	NOT NULL,

	priority	integer	NOT NULL,

	commCellId		integer	NOT NULL,

	appID			integer	NOT NULL,

	failureErrorCode	integer	NOT NULL,

	TotalSize		bigint	NOT NULL,

	fullCycleNum		integer	NOT NULL,

	dataStatus			integer	NOT NULL,

	workFlowId		integer	NOT NULL,

	embeddedObjects	bigint	NOT NULL,

	uncompBytes	bigint	NOT NULL,

	numFiles	bigint	NOT NULL,

	skippedItems	bigint	NOT NULL,

	jobFlags		integer	NOT NULL,

	cloudId			integer	NOT NULL,

	successIndex	bigint	NOT NULL,

	failIndex		bigint	NOT NULL,

	totalBackupSize	bigint	NOT NULL,

	version			integer	NOT NULL,

	fromTime		integer	NOT NULL,

	toTime			integer	NOT NULL,

	subTaskId		integer	NOT NULL,

	otherOpName				nvarchar(max) NOT NULL,

	nwTransBytes	bigint	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMAdminJobAttemptStatsTable]') )
BEGIN
	DROP TABLE #CCM_JMAdminJobAttemptStatsTable
END


CREATE  TABLE   #CCM_JMAdminJobAttemptStatsTable (
	jobId				integer	NOT NULL,

	attemptNum			integer	NOT NULL,

	phaseNum			integer	NOT NULL,

	status				integer	NOT NULL,

	startTime			INTEGER  NOT NULL,

	endTime				INTEGER  NOT NULL,

	elapsedTime			INTEGER  NOT NULL,

	failureReason		varchar(256)	NOT NULL,

	writeTime		integer	NOT NULL,

	commCellId		integer	NOT NULL,

	embeddedObjects	bigint	NOT NULL,

	uncompBytes		bigint	NOT NULL,

	numFiles		bigint	NOT NULL,

	skippedItems	bigint	NOT NULL,

	TotalSize		bigint	NOT NULL,

	nwTransBytes	bigint	NOT NULL,

	totalAllocationTime				integer	NOT NULL,

	totalWaitTimeBeforeAllocation	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobDataLink]') )
BEGIN
	DROP TABLE #CCM_JMJobDataLink
END


CREATE  TABLE   #CCM_JMJobDataLink (
	commCellId		integer	NOT NULL,

	parentJobId		integer	NOT NULL,

	childJobId		integer	NOT NULL,

	parentAppid		integer	NOT NULL,

	childAppid		integer	NOT NULL,

	linkType		integer	NOT NULL,

	childJobStatus		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobOptions]') )
BEGIN
	DROP TABLE #CCM_JMJobOptions
END


CREATE  TABLE   #CCM_JMJobOptions (
	jobId			integer	NOT NULL,

	commCellId		integer	NOT NULL,

	attributeId		integer	NOT NULL,

	attributeName	    	varchar(64)	NOT NULL,

	attributeValueInt	bigint	NOT NULL,

	attributeValue				nvarchar(MAX) NOT NULL,

	id                  INTEGER NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobDataStats]') )
BEGIN
	DROP TABLE #CCM_JMJobDataStats
END


CREATE  TABLE   #CCM_JMJobDataStats (
	jobId			integer	NOT NULL,

	archGrpId		smallint	NOT NULL,

	archGrpCopyId	smallint	NOT NULL,

	dataType		tinyint	NOT NULL,

	opType			tinyint	NOT NULL,

	auxCopyJobId	integer	NOT NULL,

	status			smallint	NOT NULL,

	disabled		integer	NOT NULL,

	appId			integer	NOT NULL,

	commCellId		integer	NOT NULL,	--can be tinyint if it's tinyint in JM tables.

	archCheckEndTime INTEGER  NOT NULL,

	archCheckStatus	tinyint	NOT NULL,

	retentionFlags	integer	NOT NULL,

	manualRetentionEndTime bigint	NOT NULL,

	copiedTime 		INTEGER  NOT NULL,

	agedTime		INTEGER  NOT NULL,

	mediaDeletedTime INTEGER  NOT NULL,

	modifiedTime	INTEGER  NOT NULL,

	sizeOnMedia		bigint	NOT NULL,

	agedBy			bigint	NOT NULL,

	flags			integer	NOT NULL,

	jobSelectionTime	bigint	NOT NULL,

	auxCopyStatus	smallInt DEFAULT -1	NOT NULL,

	unCompSize		bigint DEFAULT -1	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMOracleRACClientsUsed]') )
BEGIN
	DROP TABLE #CCM_JMOracleRACClientsUsed
END


CREATE  TABLE   #CCM_JMOracleRACClientsUsed (
	jobId					integer	NOT NULL,

	commCellId				integer	NOT NULL,

	phaseNumber				integer	NOT NULL,

	attemptNumber			integer	NOT NULL,

	racInstanceId			integer	NOT NULL,

	racHostId				integer	NOT NULL,

	isControlHost			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobInfo]') )
BEGIN
	DROP TABLE #CCM_JMJobInfo
END


CREATE  TABLE   #CCM_JMJobInfo (
	jobId				integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	initFrom		integer	NOT NULL,

	opType			integer	NOT NULL,

	userId			integer	NOT NULL,	-- FK REFERENCE ?????

	clientPriority	integer	NOT NULL,

	opPriority		integer	NOT NULL,

	appPriority		integer	NOT NULL,

	combPriority	integer	NOT NULL,

	currentPhase	integer	NOT NULL,

	jobStartTime	integer	NOT NULL,	-- TIME_T ????

	attemptStartTime integer	NOT NULL,

	serverEndTime	integer	NOT NULL,

	jobElapsedTime	integer	NOT NULL,

	elapsedTime		integer	NOT NULL,

	lastStartOrRun	integer	NOT NULL,

	phaseParams				varchar(max) NOT NULL,

	restartString				varchar(max) NOT NULL,

	startAttempts	integer	NOT NULL,

	runAttempts		integer	NOT NULL,

	state			integer	NOT NULL,

	pendingCause	integer	NOT NULL,

	restartable		integer	NOT NULL,

	appArgs				varchar(max) NOT NULL,

	numOfFailures		integer	NOT NULL,

	failureReason		varchar(256)	NOT NULL,

	preemptable			integer	NOT NULL,

	taskLinkID		integer	NOT NULL,

	percentcomplete		integer	NOT NULL,

	displayState		integer	NOT NULL,

	commCellId		integer	NOT NULL,

	resourcesAllocated	integer	NOT NULL,

	currentContext		integer	NOT NULL,

	libraryList				nvarchar(max) NOT NULL,

	driveList				nvarchar(max) NOT NULL,

	opUsername				nvarchar(max) NOT NULL,

	phaseOnSuccess		integer	NOT NULL,

	interruptedPhase	integer	NOT NULL,

	errorType		integer	NOT NULL,

	licenseVerified		integer	NOT NULL,

	currentPhaseName				nvarchar(max) NOT NULL,

	timeToComplete		integer	NOT NULL,

	lastUpdateFromClient	integer	NOT NULL,

	lastStateChangeTime	bigint	NOT NULL,	-- this column saves the time in milliseconds

	jobCategory		integer	NOT NULL,

	recoveredFromServiceRestart	integer	NOT NULL,

	noOfGUIMonitors		integer	NOT NULL,

	isScheduledAlert		integer	NOT NULL,

	jobBasedAlertId			integer	NOT NULL,

	alertName		nvarchar(128)	NOT NULL,

	shortMediaAgent				nvarchar(max),		-- short version of media agent name NOT NULL

	seqNumber		BIGINT default (0) NOT NULL,	-- sequence number

	activeFile				NVARCHAR(max) NOT NULL,

	guiAlertColorLevel	integer	NOT NULL,

	jobDescription				nvarchar(max) NOT NULL,

	xmlJobInfo				nvarchar(max) NOT NULL,

	subOpType				integer	NOT NULL,

	foreignToken		nvarchar(2048)	NOT NULL,

	preparedJobId			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMAdminJobInfoTable]') )
BEGIN
	DROP TABLE #CCM_JMAdminJobInfoTable
END


CREATE  TABLE   #CCM_JMAdminJobInfoTable (
	jobId				integer	NOT NULL,

	opType				integer	NOT NULL,

	status				integer	NOT NULL,

	servStart			INTEGER  NOT NULL,

	servEnd  			INTEGER  NOT NULL,

	archGrpID			integer	NOT NULL,

	archGrpName				nvarchar(max) NOT NULL,

	AP_NumDays			integer	NOT NULL,

	AP_IsForecast			integer	NOT NULL,

	AP_SeqNum			integer	NOT NULL,

	AC_NewMediaFlag			integer	NOT NULL,

	ER_BkpLevel			integer	NOT NULL,

	ER_DbName				nvarchar(max) NOT NULL,

	ER_Destination				nvarchar(max) NOT NULL,

	ER_SendCount			integer	NOT NULL,

	ER_MediasUsed				nvarchar(max) NOT NULL,

	TotalObjects		bigint	NOT NULL,

	ObjectsDone		bigint	NOT NULL,

	ObjectsFailed		bigint	NOT NULL,

	archGrpCopyID		integer	NOT NULL,

	LibraryID		integer	NOT NULL,

	MI_InventoryType	integer	NOT NULL,

	currentWriteTime	integer	NOT NULL,

	noOfStreams		integer	NOT NULL,

	appID			integer	NOT NULL,

	dependantJobId		integer	NOT NULL,

	workFlowId		integer	NOT NULL,

	srcMediaAgent				nvarchar(max) NOT NULL,

	destMediaAgent				nvarchar(max) NOT NULL,

	drivePoolId			integer	NOT NULL,

	mediaId				integer	NOT NULL,

	sourceJobId			integer	NOT NULL,

	TotalSize		bigint	NOT NULL,

	noOfStreamsAllocated	integer	NOT NULL,

	maxRestarts		integer	NOT NULL,

	restartInterval		integer	NOT NULL,

	embeddedObjects	bigint	NOT NULL,

	uncompBytes	bigint	NOT NULL,

	numFiles	bigint	NOT NULL,

	skippedItems	bigint	NOT NULL,

	writeTime	integer	NOT NULL,

	reportType		integer	NOT NULL,

	cloudId		integer	NOT NULL,

	reportSetId    integer	NOT NULL,

	reportName				nvarchar(max) NOT NULL,

	reportSetName				nvarchar(max) NOT NULL,

	fromTime	integer	NOT NULL,

	toTime		integer	NOT NULL,

	subTaskId		integer	NOT NULL,

	otherOpName				nvarchar(max) NOT NULL,

	nwTransBytes	bigint	NOT NULL,

	commCellId		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMBkpJobInfo]') )
BEGIN
	DROP TABLE #CCM_JMBkpJobInfo
END


CREATE  TABLE   #CCM_JMBkpJobInfo (
	jobId		integer	NOT NULL,

	commcellId		integer	NOT NULL,

	applicationId		integer	NOT NULL,

	numStreams		integer	NOT NULL,

	currentPolicy		integer	NOT NULL,

	targetCopyList				varchar(max) NOT NULL,

	bkpLevel		integer	NOT NULL,

	indexOverride		integer	NOT NULL,

	startNewMedia		integer	NOT NULL,

	compBytes		bigint	NOT NULL,

	unCompBytes		bigint	NOT NULL,

	filesToXfer		bigint	NOT NULL,

	backupTaskId		integer	NOT NULL,

	scanFileFailures	integer	NOT NULL,

	scanFolderFailures	integer	NOT NULL,

	backupFileFailures	integer	NOT NULL,

	backupFolderFailures	integer	NOT NULL,

	shadowCopyId				varchar(MAX) NOT NULL,

	bkpOptions		integer	NOT NULL,	-- Backup Options

	oraSubLevel		integer	NOT NULL,	-- Sub backup level for oracle incremental job

	bkpattributes		bigint	NOT NULL,

	dataPolicy		integer	NOT NULL,

	logPolicy		integer	NOT NULL,

	filesXfered		bigint	NOT NULL,

	currentThroughput	float	NOT NULL,

	averageThroughput	float	NOT NULL,

	filesIndexed		bigint	NOT NULL,

	filesFailedToIndex	bigint	NOT NULL,

	filesSkippedForIndex	bigint	NOT NULL,

	contentIndexDBSize	bigint	NOT NULL,

	totalMediaUsageTime	bigint	NOT NULL,

	mediaAgentName				nvarchar(max) NOT NULL,

	scanType		integer	NOT NULL,

	scanTypeChangeReason	varchar(24),	-- saves the reason why the scan type was changed NOT NULL

	numStreamsAllocated	integer	NOT NULL,

	maxRestarts		integer	NOT NULL,

	restartInterval		integer	NOT NULL,

	cloudId			integer	NOT NULL,

	diffPolicy		integer	NOT NULL,

	targetClientId		integer	NOT NULL,

	unCompBytesToXfer	bigint	NOT NULL,

	secondaryBkpLevel	integer	NOT NULL,

	jobIdActedOn		integer	NOT NULL,

	fromTime			integer	NOT NULL,

	toTime				integer	NOT NULL,

	nwTransBytes		bigint	NOT NULL,

	totSkippedObjects	bigint	NOT NULL,

	bkpAttributesEx		bigint	NOT NULL,

	jobReferenceTime	integer	NOT NULL,

	totReadBytes			bigint	NOT NULL,

	totReadTime				bigint	NOT NULL,

	totPhysicalWriteBytes	bigint	NOT NULL,

	totPhysicalWriteTime	bigint	NOT NULL,

	totNwTransTime			bigint	NOT NULL,

	totSidbLookups			bigint	NOT NULL,

	totSidbLookupTime		bigint	NOT NULL,

	readCurrentThroughput	float	NOT NULL,

	readAverageThroughput	float	NOT NULL,

	writeCurrentThroughput	float	NOT NULL,

	writeAverageThroughput	float	NOT NULL,

	networkCurrentThroughput	float	NOT NULL,

	networkAverageThroughput	float	NOT NULL,

	sidbCurrentLookups		float	NOT NULL,

	sidbAverageLookups		float	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobSnapshotStats]') )
BEGIN
	DROP TABLE #CCM_JMJobSnapshotStats
END


CREATE  TABLE   #CCM_JMJobSnapshotStats (
	jobId					integer	NOT NULL,

	commcellId				integer	NOT NULL,

	materializationStatus	smallint	NOT NULL,

	disabled				integer	NOT NULL,

	materializationJobId	integer	NOT NULL,

	appId					integer	NOT NULL,

	archGrpId				smallint	NOT NULL,

	unPickReason			integer	NOT NULL,

	flags					integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_GRCJMJobDataStatsTracking]') )
BEGIN
	DROP TABLE #CCM_GRCJMJobDataStatsTracking
END


CREATE  TABLE   #CCM_GRCJMJobDataStatsTracking (
	trackingId			BIGINT NOT NULL,

	commCellId			integer	NOT NULL,

	jobId						integer	NOT NULL,

	copyId		smallint	NOT NULL,

	dataType				tinyint	NOT NULL,

	statusChange			tinyint 	NOT NULL,

	createdTime		INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMFailureReasonMsg]') )
BEGIN
	DROP TABLE #CCM_JMFailureReasonMsg
END


CREATE  TABLE   #CCM_JMFailureReasonMsg (
	id					INTEGER NOT NULL,							-- PRIMARY KEY FOR THIS TABLE

	messageId			integer	NOT NULL,	-- The event message Identifier.

	paramNum			integer	NOT NULL,	-- Number of parameters assoc. w/ this message

	errorType			integer	NOT NULL,	-- The type of the error (hardware, software)

	commCellId			integer	NOT NULL,

	jobId				integer	NOT NULL,	-- f-key to JMJobStats(jobId)

	client				nvarchar(255),	-- Name of client who sent the message NOT NULL

	subsystem			nvarchar(255),	-- Name of application who sent the message NOT NULL

	copyId				integer	NOT NULL,	-- copy for which this message is generated

	rcId				integer	NOT NULL,	-- the rcid set for this message

	reservationId		integer	NOT NULL,	-- the reservation id for this message

	flags				integer	NOT NULL,	-- dont know any use right now

	guiAlertColorLevel	integer	NOT NULL,	-- level for gui popups

	clientVersion		integer	NOT NULL,	-- client version

	serverVersion		integer	NOT NULL,	-- server version

	iDA					integer	NOT NULL,	-- ida

	opType				integer	NOT NULL,	-- operation type

	phaseNumber			integer	NOT NULL,	-- phase number

	customMessageId		integer not null default(0),	-- custom (client provided) message id

	failureReasonTime	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMFailureReasonMsgParam]') )
BEGIN
	DROP TABLE #CCM_JMFailureReasonMsgParam
END


CREATE  TABLE   #CCM_JMFailureReasonMsgParam (
	msgId				integer	NOT NULL,	-- Points to JMFailureReasonMsg table

	eventid				integer	NOT NULL,	-- the eventid of the parameter

	position			integer	NOT NULL,	-- Parameter Position in the English Table

	type				integer	NOT NULL,	-- The Type of parameter Stored Here

	size				integer	NOT NULL,	-- The size of the data (in bytes)

	data				nvarchar(1023)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_evMsg]') )
BEGIN
	DROP TABLE #CCM_evMsg
END


CREATE  TABLE   #CCM_evMsg (
	id					INTEGER	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	timeSource     INTEGER  NOT NULL,	-- UNIX time event occured accord. to src computer

	timeServer     INTEGER  NOT NULL,	-- UNIX time when the event was rec'd by the EMS

	severity       integer	NOT NULL,	-- the level EL_INFO, EL_MINOR, EL_MAJOR, EL_CRITICAL

	ack            integer	NOT NULL,	-- Does this event require acknowledgement?

	acked          integer	NOT NULL,	-- Has the event been acknowledged?

	type           integer	NOT NULL,	-- ET_USER or ET_SYSTEM

	paramNum       integer	NOT NULL,	-- Number of parameters assoc. w/ this message

	messageId      integer	NOT NULL,	-- The event message Identifier.

	jobId_h	 integer	NOT NULL,

	jobId_l	 integer	NOT NULL,

	clientID       integer	NOT NULL,	-- f-key to client(id)

	commCellID     integer	NOT NULL,	-- f-key to commCell(id)

	userID         integer	NOT NULL,	-- f-key to users(id)

	subsystemID    integer	NOT NULL,	-- f-key to subsystem(id)

	client         varchar(128)	NOT NULL,

	commCell       varchar(128)	NOT NULL,

	userName       varchar(128)	NOT NULL,

	subsystem      varchar(128)	NOT NULL,

	msgEnglish     varchar(1024)	NOT NULL,

	repeatCount    integer	NOT NULL,

	lastOccurrence INTEGER  NOT NULL,

	nextPost       INTEGER  NOT NULL,

	mediaId					integer	NOT NULL,

	driveId					integer	NOT NULL,

	libraryId				integer	NOT NULL,

	maClientId			integer	NOT NULL,

	entityId		integer	default 0	NOT NULL,

	entityType	integer default 0	NOT NULL,

	anomalous   integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_evParam]') )
BEGIN
	DROP TABLE #CCM_evParam
END


CREATE  TABLE   #CCM_evParam (
	evMsgId				integer	NOT NULL,	-- Points to evMsg table

	position			integer	NOT NULL,	-- Parameter Position in the English Table

	type				integer	NOT NULL,	-- The Type of parameter Stored Here

	size				integer	NOT NULL,	-- The size of the data (in bytes)

	data				nvarchar(MAX),		--Support unlimited GUI Audit message NOT NULL

	eventId				integer	NOT NULL,	-- Event Id of the Message

	commcellId			integer		DEFAULT		2	NOT NULL,	--CN2 change.



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMExportLocation]') )
BEGIN
	DROP TABLE #CCM_MMExportLocation
END


CREATE  TABLE   #CCM_MMExportLocation (
	ExportLocationId	INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	ExportLocation		NVARCHAR(64)	NOT NULL,

	Type				integer	NOT NULL,

	Descript			NVARCHAR(256)	NOT NULL,

	origCCId			integer			NOT NULL,

	GUID				uniqueidentifier ROWGUIDCOL,

	ModifiedTime		integer		DEFAULT		0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMedia]') )
BEGIN
	DROP TABLE #CCM_MMMedia
END


CREATE  TABLE   #CCM_MMMedia (
	MediaId				INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	UniqueId			varchar(300)	NOT NULL,

	BarCode				varchar(256)	NOT NULL,

	MediaTypeId			integer	NOT NULL,

	CreationTime		INTEGER  NOT NULL,

	NumberOfReUses		integer	NOT NULL,

	LastRestoreTime		INTEGER  NOT NULL,

	LastBackupTime		INTEGER  NOT NULL,

	LibraryId			integer	NOT NULL,

	SpareGroupId		integer	NOT NULL,

	LastExportTime		INTEGER  NOT NULL,

	MediaLocation		integer	NOT NULL,

	ExternalGUID		varchar(33)	NOT NULL,

	MediaFlags			integer	NOT NULL,

	IsOMLWritten		integer	NOT NULL,

	MediaStatusReason	integer	NOT NULL,

	ExportLocationId	integer	NOT NULL,

	LastWriteLibraryId	integer	NOT NULL,

	Attributes			integer	NOT NULL,

	ContainerId			integer	NOT NULL,

	OverWriteJobId		bigint	NOT NULL,

	origCCcommCellID	integer	NOT NULL,

	origCCmediaID		integer	NOT NULL,

	Descript				NVARCHAR(MAX)default '' NOT NULL,

	NumberOfSideOverwrites integer	NOT NULL,

	ScheduleRunId		bigint	NOT NULL,

	retentionFlags integer	NOT NULL,

	retentionExpireTime bigint	NOT NULL,

	IsAged				integer	NOT NULL,

	IsInMediaGroup		integer	NOT NULL,

	PinMediaExpireTime				integer	NOT NULL,

	origSpareGroupId					integer	NOT NULL,

	RMSpareStatus							integer	NOT NULL,

	RMSpareStatusUpdateTime		integer	NOT NULL,

	ExtendedAttributes		integer	NOT NULL,

	minRetentionTime bigint	NOT NULL,

	HwEncKey			varchar(114)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMediaSide]') )
BEGIN
	DROP TABLE #CCM_MMMediaSide
END


CREATE  TABLE   #CCM_MMMediaSide (
	MediaSideId			INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	MediaId				integer	NOT NULL,

	SideName			varchar(80)	NOT NULL,

	MediaSideFlags		integer	NOT NULL,

	NumberOfRestores	integer	NOT NULL,

	NumberOfBackups		integer	NOT NULL,

	NumberOfMounts		integer	NOT NULL,

	NumberOfSoftErrors	integer	NOT NULL,

	NumberOfHardErrors	integer	NOT NULL,

	NumberOfReUses		integer	NOT NULL,

	LastRestoreTime		INTEGER  NOT NULL,

	LastBackupTime		INTEGER  NOT NULL,

	TotalSpaceMB		bigint	NOT NULL,

	FreeBytesMB			bigint	NOT NULL,

	LogicalBytesMB		integer	NOT NULL,

	PhysicalBytesMB		integer	NOT NULL,

	IsOMLValid			integer	NOT NULL,

	FailureReason		varchar(64)	NOT NULL,

	ExternalGUID		varchar(33)	NOT NULL,

	IsOMLWritten		integer	NOT NULL,

	isErasable			integer	NOT NULL,

	UploadDataMB		integer	NOT NULL,

	DownloadDataMB		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMVolume]') )
BEGIN
	DROP TABLE #CCM_MMVolume
END


CREATE  TABLE   #CCM_MMVolume (
	VolumeId			INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	VolumeName			varchar(112)	NOT NULL,

	CreationTime		INTEGER  NOT NULL,

	VolumeFlags			integer	NOT NULL,

	VolumeInitialized	integer	NOT NULL,

	FlushBlockSizeKB	integer	NOT NULL,

	NumberOfRestores	integer	NOT NULL,

	NumberOfBackups		integer	NOT NULL,

	NumberOfMounts		integer	NOT NULL,

	NumberOfSoftErrors	integer	NOT NULL,

	NumberOfHardErrors	integer	NOT NULL,

	LastRestoreTime		INTEGER  NOT NULL,

	LastBackupTime		INTEGER  NOT NULL,

	LogicalBytesMB		integer	NOT NULL,

	PhysicalBytesMB		integer	NOT NULL,

	NumberOfActiveFiles	integer	NOT NULL,

	LastFile			integer	NOT NULL,

	RecordingFormatId	integer	NOT NULL,

	ExternalGUID		varchar(33)	NOT NULL,

	OMLVersion			integer	NOT NULL,

	VolumeState			integer	NOT NULL,

	VolumeFullReason	integer	NOT NULL,

	VolumeFullTime		integer	NOT NULL,

	VolumeFullJobId		bigint	NOT NULL,

	origCCcommCellID	integer	NOT NULL,

	origCCvolumeID		integer	NOT NULL,

	MediaId				integer	NOT NULL,

	MediaSideId			integer	NOT NULL,

	Attributes			integer	NOT NULL,

	MediaGroupId		integer	NOT NULL,

	ReformatTime		INTEGER  NOT NULL,

	RMSpareStatus							integer	NOT NULL,

	RMSpareStatusUpdateTime		integer	NOT NULL,

	SIDBStoreId			integer	NOT NULL,

	SiloStatus			integer	NOT NULL,

	CurrMountPathId		integer	NOT NULL,

	FailureErrorCode		integer	NOT NULL,

	MMSpareStatus		integer	NOT NULL,

	LastSizeUpdateTime	INTEGER  NOT null default 0



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMediaGroup]') )
BEGIN
	DROP TABLE #CCM_MMMediaGroup
END


CREATE  TABLE   #CCM_MMMediaGroup (
	MediaGroupId			INTEGER NOT NULL,

	MediaGroupName			varchar(64)	NOT NULL,

	DrivePoolId				integer	NOT NULL,

	SpareGroupId			integer	NOT NULL,

	DesiredMediaTypeId		integer	NOT NULL,

	RecordingFormatId		integer	NOT NULL,

	DataPathId				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMountPath]') )
BEGIN
	DROP TABLE #CCM_MMMountPath
END


CREATE  TABLE   #CCM_MMMountPath (
	MountPathId						integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	MountPathName					NVARCHAR(1024)	NOT NULL,

	MediaSideId						integer	NOT NULL,

	UserName						varchar(1024)	NOT NULL,

	UserPassword					varchar(2048)	NOT NULL,

	IsEnabled						integer	NOT NULL,

	NumberOfWriters					integer	NOT NULL,

	MaxConcurrentWriters			integer	NOT NULL,

	CurrentFileMarker				integer	NOT NULL,

	IsOffline						integer	NOT NULL,

	OfflineReason					integer	NOT NULL,

	MountPathTypeId					integer	NOT NULL,

	OffLineTimeStamp				INTEGER  NOT NULL,

	origCCcommCellID				integer	NOT NULL,

	origCCmediaSideID				integer	NOT NULL,

	MaxDataToWriteMB				integer	NOT NULL,

	MagneticSpaceRsrvInMB			integer	NOT NULL,

	Attribute						integer	NOT NULL,

	MasterPoolId					integer	NOT NULL,

	LibraryId						integer	NOT NULL,

	RMStatus						integer	NOT NULL,

	RMStatusUpdateTime				integer	NOT NULL,

	OrigCCMountPathId				integer	NOT NULL,	-- On upgrade set this value to 0 and during

	MagneticChunkFileIncrSizeMB		integer	NOT NULL,

	MountPathOfflineReasonEventId	integer	NOT NULL,

	StagingMountPathId				integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDevice]') )
BEGIN
	DROP TABLE #CCM_MMDevice
END


CREATE  TABLE   #CCM_MMDevice (
	DeviceId				INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	AliasName				NVARCHAR(128)	NOT NULL,

	DeviceEnabled			integer	NOT NULL,

	DeviceBroken			integer	NOT NULL,

	DeviceTypeId			integer	NOT NULL,

	NumRestoresLifeTime		integer	NOT NULL,

	NumBackupsLifeTime		integer	NOT NULL,

	NumMountsLifeTime		integer	NOT NULL,

	NumErrsLifeTime			integer	NOT NULL,

	MinutesUsedLifeTime		integer	NOT NULL,

	OfflineReason			integer	NOT NULL,

	SNRPartitionId			integer	NOT NULL,

	DeviceStatus			integer	NOT NULL,

	DRUId					integer	NOT NULL,

	DeviceAttributes		integer	NOT NULL,

	DRUDeviceId				varchar(256)	NOT NULL,

	RMStatus								integer	NOT NULL,

	RMStatusUpdateTime			integer	NOT NULL,

	origCCId			integer	NOT NULL,

	origDeviceId			integer	NOT NULL,

	DisplayDeviceTypeId			integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDeviceController]') )
BEGIN
	DROP TABLE #CCM_MMDeviceController
END


CREATE  TABLE   #CCM_MMDeviceController (
	DeviceControllerId			INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	ClientId					integer	NOT NULL,

	DeviceId					integer	NOT NULL,

	DeviceControllerActive		integer	NOT NULL,

	DeviceControllerEnabled		integer	NOT NULL,

	SNRVolumeId					integer	NOT NULL,

	UseCount					integer	NOT NULL,

	UserName					varchar(1024)	NOT NULL,

	UserPassword				varchar(2048)	NOT NULL,

	Folder						varchar(1024)	NOT NULL,

	DeviceMounted				integer	NOT NULL,

	DeviceAccessible			integer	NOT NULL,

	VolumeRecoveryStatus		integer	NOT NULL,

	VolumeRecoveryTime			integer	NOT NULL,

	VolumeScsiReserved			integer	NOT NULL,

	DeviceAccessType			integer	NOT NULL,

	RMStatus								integer	NOT NULL,

	RMStatusUpdateTime			integer	NOT NULL,

	CredentialAssocId			integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMountPathToStorageDevice]') )
BEGIN
	DROP TABLE #CCM_MMMountPathToStorageDevice
END


CREATE  TABLE   #CCM_MMMountPathToStorageDevice (
	MountPathId		integer	NOT NULL,

	CenteraId		integer	NOT NULL,

	DeviceId		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMNDMPHostInfo]') )
BEGIN
	DROP TABLE #CCM_MMNDMPHostInfo
END


CREATE  TABLE   #CCM_MMNDMPHostInfo (
	NDMPHostId				INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	Login					varchar(1024)	NOT NULL,

	Password				varchar(2048)	NOT NULL,

	ListenPort				integer	NOT NULL,

	FirmwareRevision		varchar(32)	NOT NULL,

	OSType					integer	NOT NULL,

	AuthenticationScheme	integer	NOT NULL,

	ProtocolType			integer	NOT NULL,

	ProtocolRevision		varchar(32)	NOT NULL,

	CapabilityFlags			integer	NOT NULL,

	ClientId				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMContainer]') )
BEGIN
	DROP TABLE #CCM_MMContainer
END


CREATE  TABLE   #CCM_MMContainer (
	ContainerId				INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	ContainerName			NVARCHAR(256)	NOT NULL,

	Flag					integer	NOT NULL,

	Capacity				integer	NOT NULL,

	MediaType				integer	NOT NULL,

	Descript				NVARCHAR(3072)	NOT NULL,

	CreationTime			INTEGER  NOT NULL,

	IsEmpty					integer	NOT NULL,

	ContainerEmptyTime		INTEGER  NOT NULL,

	TrackingId				NVARCHAR(256) default ''	NOT NULL,

	SIDBStoreId				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMCenteraInfo]') )
BEGIN
	DROP TABLE #CCM_MMCenteraInfo
END


CREATE  TABLE   #CCM_MMCenteraInfo (
	CenteraId					INTEGER NOT NULL,			--PRIMARY KEY FOR THIS TABLE

	FriendlyName					varchar(512)	NOT NULL,

	ClusterName					varchar(512)	NOT NULL,

	ClusterId					varchar(512)	NOT NULL,

	Version						varchar(512)	NOT NULL,

	CapacityMB_h	 integer	NOT NULL,

	CapacityMB_l	 integer	NOT NULL,

	FreeSpaceMB_h	 integer	NOT NULL,

	FreeSpaceMB_l	 integer	NOT NULL,

	ReplicateAddress			varchar(512)	NOT NULL,

	ApiRetryInterval			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMCenteraAccessNode]') )
BEGIN
	DROP TABLE #CCM_MMCenteraAccessNode
END


CREATE  TABLE   #CCM_MMCenteraAccessNode (
	AccessNodeId			INTEGER NOT NULL,			--PRIMARY KEY FOR THIS TABLE

	NetHostName				varchar(1024)	NOT NULL,

	CenteraId				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMHost]') )
BEGIN
	DROP TABLE #CCM_MMHost
END


CREATE  TABLE   #CCM_MMHost (
	ClientId					integer	NOT NULL,

	MmHostType					integer	NOT NULL,

	MmHostSoftState				integer	NOT NULL,

	MmHostEnabled				integer	NOT NULL,

	OfflineReason				integer	NOT NULL,

	OfflineTimeStamp			INTEGER  NOT NULL,

	PatchLevel					integer	NOT NULL,

	IndexCacheUser				varchar(1024)	NOT NULL,

	IndexCachePassword			varchar(2048)	NOT NULL,

	IndexCachePathName			varchar(1024)	NOT NULL,

	IsIndexShared				integer	NOT NULL,

	Attribute					integer	NOT NULL,

	ScanIntervalInSec			integer	NOT NULL,

	Descript				NVARCHAR(MAX)default '' NOT NULL,

	MaxReservations				integer	NOT NULL,

	RMStatus							integer	NOT NULL,

	RMStatusUpdateTime		integer	NOT NULL,

	RolesBitMask			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxAccessPath]') )
BEGIN
	DROP TABLE #CCM_IdxAccessPath
END


CREATE  TABLE   #CCM_IdxAccessPath (
	IdxAccessPathId			INTEGER NOT NULL,

	IdxCacheId				integer	NOT NULL,

	ClientId				integer	NOT NULL,

	Path					varchar(1024)	NOT NULL,

	Username				varchar(1024)	NOT NULL,

	Password				varchar(2048)	NOT NULL,

	Enabled					integer	NOT NULL,

	SoftState				integer	NOT NULL,

	OfflineReason			integer	NOT NULL,

	Priority				integer	NOT NULL,

	LocalIndexTimeStamp		integer	NOT NULL,

	ActualDaysIndexRetain		integer	NOT NULL,

	Flags					integer	NOT NULL,

	AgeingNoOfDays			integer	NOT NULL,

	AgeingPercentDiskspace	integer	NOT NULL,

	DiskFreeThresholdMB		integer	NOT NULL,

	DiskFreeWarningThreshholdMB	integer	NOT NULL,

	TotalCapacityMB			integer	NOT NULL,

	FreeDiskSpaceMB			integer Default 0	NOT NULL,

	DiskUsageMB			integer Default 0	NOT NULL,

	DiskUsageLastChecked		integer Default 0	NOT NULL,

	StagingCachePath		varchar(1024)	NOT NULL,

	VolumeGUID			varchar(1024)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMLibrary]') )
BEGIN
	DROP TABLE #CCM_MMLibrary
END


CREATE  TABLE   #CCM_MMLibrary (
	LibraryId				INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	LibraryName				varchar(128)	NOT NULL,

	AliasName				NVARCHAR(128)	NOT NULL,

	LibrarySoftState		integer	NOT NULL,

	LibraryEnabled			integer	NOT NULL,

	LibraryBroken			integer	NOT NULL,

	LibraryTypeId			integer	NOT NULL,

	BarCodeReaderPresent	integer	NOT NULL,

	LibraryInstallTime		INTEGER  NOT NULL,

	LowWaterMarkMB			integer	NOT NULL,

	LibraryLicenseType		integer	NOT NULL,

	LibraryVendor			varchar(16)	NOT NULL,

	LibraryModel			varchar(32)	NOT NULL,

	FirmwareRevision		varchar(32)	NOT NULL,

	SerialNumber			varchar(32)	NOT NULL,

	WWNNumber				varchar(64)	NOT NULL,

	FiberChannelPort		integer	NOT NULL,

	NumberOfMounts			integer	NOT NULL,

	LastServiceTime			INTEGER  NOT NULL,

	DriveCount				integer	NOT NULL,

	BaseAddress				integer	NOT NULL,

	ExternalGUID			varchar(33)	NOT NULL,

	PrivateData				varchar(256)	NOT NULL,

	LibraryAttribute		integer	NOT NULL,

	MountTimeoutSec			integer	NOT NULL,

	UnmountTimeoutSec		integer	NOT NULL,

	NumberOfSoftErrors		integer	NOT NULL,

	NumberOfHardErrors		integer	NOT NULL,

	DefaultMediaTypeId		integer	NOT NULL,

	InventoryInProgress		integer	NOT NULL,

	IsConvertedToSited		integer	NOT NULL,

	LastFullInventoryTime	integer	NOT NULL,

	InventoryJobId_h	 integer	NOT NULL,

	InventoryJobId_l	 integer	NOT NULL,

	LibraryStatusReason		integer	NOT NULL,

	OfflineTimeStamp		INTEGER  NOT NULL,

	UseWithinDaysInSec		INTEGER  NOT NULL,

	DriveCleanIntervalInSec INTEGER  NOT NULL,

	VMSDirection			integer	NOT NULL,

	CacheMountPeriodInSec	integer	NOT NULL,

	StdAlnMedRetentionTime	INTEGER  NOT NULL,

	SlotBaseAddress			integer	NOT NULL,

	NumberOfMailSlots		integer	NOT NULL,

	TURIntervalInSec		integer	NOT NULL,

	ConfigParams			varchar(256)	NOT NULL,

	Descript				NVARCHAR(MAX)default '' NOT NULL,

	StdAlnChkIntervalInSec	INTEGER  NOT NULL,

	StdAlnNextChkTime		INTEGER  NOT NULL,

	ReadRetryIntervalInSec	INTEGER  NOT NULL,

	ReadRetryAttempts		integer	NOT NULL,

	RestrictActivity		integer	NOT NULL,

	LibraryStatusEventId	integer	NOT NULL,

	StartVMSElementAddress	integer	NOT NULL,

	ExtendedAttributes		integer	NOT NULL,

	ThresholdPercentage		integer	NOT NULL,

	ThresholdVariation		integer	NOT NULL,

	LibrarySubType			integer	NOT NULL,

	VTLType					integer	NOT NULL,

	origCCId				integer	NOT NULL,

	origLibraryId			integer	NOT NULL,

	LibSvrConfig			XML,

	WarningWaterMark		integer	NOT NULL,

	OutOfSpaceAlertInDays		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMasterPool]') )
BEGIN
	DROP TABLE #CCM_MMMasterPool
END


CREATE  TABLE   #CCM_MMMasterPool (
	MasterPoolId			INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	MasterPoolName			NVARCHAR(64)	NOT NULL,

	MasterPoolSoftState		integer	NOT NULL,

	MasterPoolEnabled		integer	NOT NULL,

	LibraryId				integer	NOT NULL,

	TotalDrives				integer	NOT NULL,

	ReservedDrives			integer	NOT NULL,

	MaxSwitchForHost		integer	NOT NULL,

	Descript				NVARCHAR(MAX)default '' NOT NULL,

	DriveTypeId				integer	NOT NULL,

	RMStatus					integer	NOT NULL,

	RMStatusUpdateTime		integer	NOT NULL,

	origCCId			integer	NOT NULL,

	origMasterPoolId		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDrivePool]') )
BEGIN
	DROP TABLE #CCM_MMDrivePool
END


CREATE  TABLE   #CCM_MMDrivePool (
	DrivePoolId			INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	DrivePoolName		NVARCHAR(64)	NOT NULL,

	DrivePoolSoftState	integer	NOT NULL,

	DrivePoolEnabled	integer	NOT NULL,

	ReservedDrives		integer	NOT NULL,

	DrivePoolType		integer	NOT NULL,

	MaxDrivesToSwitch	integer	NOT NULL,

	CopyMgrAccessPath   varchar(64)	NOT NULL,

	CopyManagerCtrlId	integer	NOT NULL,

	CostCategoryId		integer	NOT NULL,

	Descript				NVARCHAR(MAX)default '' NOT NULL,

	ClientId			integer	NOT NULL,

	MasterPoolId		integer	NOT NULL,

	NDMPHostId			integer	NOT NULL,

	RMStatus				integer	NOT NULL,

	RMStatusUpdateTime		integer	NOT NULL,

	origCCId			integer	NOT NULL,

	origDrivePoolId			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMLibraryController]') )
BEGIN
	DROP TABLE #CCM_MMLibraryController
END


CREATE  TABLE   #CCM_MMLibraryController (
	LibraryControllerId				INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	LibraryControllerName			varchar(144)	NOT NULL,

	ClientId						integer	NOT NULL,

	LibraryControllerSoftState		integer	NOT NULL,

	LibraryControllerActive			integer	NOT NULL,

	LibraryControllerType			integer	NOT NULL,

	LibraryControllerEnabled		integer	NOT NULL,

	LibraryId						integer	NOT NULL,

	ConnectionType					integer	NOT NULL,

	SCSIId							varchar(32)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlVersion]') )
BEGIN
	DROP TABLE #CCM_sqlVersion
END


CREATE  TABLE   #CCM_sqlVersion (
	id				INTEGER NOT NULL,

	commCellId		integer not null,

	type			integer	NOT NULL,

	major			integer not null,

	minor			integer 	NOT NULL,	--default 0,

	build			integer 	NOT NULL,	--default 0,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlServer]') )
BEGIN
	DROP TABLE #CCM_sqlServer
END


CREATE  TABLE   #CCM_sqlServer (
	instanceId		integer not null,			-- PRIMARY KEY FOR THIS TABLE

	commCellId		integer not null,

	serverName		varchar(128)	NOT NULL,

	sqlVersionId	integer not null,

	sa				varchar(128)	NOT NULL,

	saPassword		varchar(512)	NOT NULL,

	undoFile		varchar(1024)	NOT NULL,

	addTime			integer	NOT NULL,

	removalTime		integer default 0	NOT NULL,

	deleteFlag		integer default 0	NOT NULL,

	sqlNTAccount	varchar(256)	NOT NULL,

	sqlNTPassword	varchar(512)	NOT NULL,

	sqlServiceName	varchar(256)	NOT NULL,

	flags			integer default 0	NOT NULL,

	clientId		integer default 1	NOT NULL,	-- Default client setting to maintain foreign key integrity!



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlDatabase]') )
BEGIN
	DROP TABLE #CCM_sqlDatabase
END


CREATE  TABLE   #CCM_sqlDatabase (
	backupSetId			integer not null,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlServerId			integer not null,

	applicationNumber	integer	NOT NULL,

	databaseId			integer	NOT NULL,

	databaseName		varchar(128)	NOT NULL,

	creationTime		DATETIME,

	streams				integer default 1	NOT NULL,

	maxStreams			integer default 1	NOT NULL,

	allowFlags			integer	NOT NULL,

	addTime				integer	NOT NULL,

	removalTime			integer default 0	NOT NULL,

	deleteFlag			integer default 0	NOT NULL,

	systemFlags			integer default 0	NOT NULL,

	logStreams			integer default 1	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileGroup]') )
BEGIN
	DROP TABLE #CCM_sqlFileGroup
END


CREATE  TABLE   #CCM_sqlFileGroup (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlDatabaseId		integer not null,

	applicationNumber	integer	NOT NULL,

	groupId				integer	NOT NULL,

	fileGroupName		varchar(128)	NOT NULL,

	streams				integer default 1	NOT NULL,

	maxStreams			integer	default 1	NOT NULL,

	addTime				integer	NOT NULL,

	removalTime			integer default 0	NOT NULL,

	deleteFlag			integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFile]') )
BEGIN
	DROP TABLE #CCM_sqlFile
END


CREATE  TABLE   #CCM_sqlFile (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlFileGroupId		integer not null,

	fileId				integer	NOT NULL,

	physicalName		varchar(260)	NOT NULL,

	logicalName			varchar(128)	NOT NULL,

	size				integer	NOT NULL,

	maxSize				integer	NOT NULL,

	addTime				integer	NOT NULL,

	removalTime			integer default 0	NOT NULL,

	deleteFlag			integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlBackupSet]') )
BEGIN
	DROP TABLE #CCM_sqlBackupSet
END


CREATE  TABLE   #CCM_sqlBackupSet (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlDatabaseId		integer	NOT NULL,

	backupSetId			integer	NOT NULL,

	name				varchar(128)	NOT NULL,

	description			varchar(255)	NOT NULL,

	userName			varchar(128)	NOT NULL,

	vendorId			integer	NOT NULL,

	sqlVersionId		integer not null,

	mtfVersionId		integer not null,

	timeZone			integer	NOT NULL,

	galaxyStartTime		integer	NOT NULL,

	galaxyFinishTime	integer	NOT NULL,

	compatibility		integer	NOT NULL,

	dbVersion			integer	NOT NULL,

	backupSize			varchar(32)	NOT NULL,

	mediaSetId			integer	NOT NULL,

	streams				integer	NOT NULL,

	jobId_h	 integer  default 0	NOT NULL,

	jobId_l	 integer  default 0	NOT NULL,

	sqlFileSubClientId	integer default 0	NOT NULL,	-- if not zero, key to SqlFileSubClient Table



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlLSNs]') )
BEGIN
	DROP TABLE #CCM_sqlLSNs
END


CREATE  TABLE   #CCM_sqlLSNs (
	sqlBackupSetId		integer not null,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlDatabaseId		integer not null,

	startTime			DATETIME,

	finishTime			DATETIME,

	backupType			integer	NOT NULL,

	firstLSN			varchar(32)	NOT NULL,

	lastLSN				varchar(32)	NOT NULL,

	checkpointLSN		varchar(32)	NOT NULL,

	fullBackupLSN		varchar(32)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlArchiveSet]') )
BEGIN
	DROP TABLE #CCM_sqlArchiveSet
END


CREATE  TABLE   #CCM_sqlArchiveSet (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlBackupSetId		integer not null,

	mediaSetId			integer	NOT NULL,

	sequenceNumber		integer	NOT NULL,

	archiveGroup		integer	NOT NULL,

	archiveFile			integer	NOT NULL,

	bIsTombstoned		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlBackupFile]') )
BEGIN
	DROP TABLE #CCM_sqlBackupFile
END


CREATE  TABLE   #CCM_sqlBackupFile (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlFileGroupId		integer not null,

	sqlBackupSetId		integer not null,

	number				integer	NOT NULL,

	physicalName		varchar(260)	NOT NULL,

	logicalName			varchar(128)	NOT NULL,

	physicalDrive		varchar(260)	NOT NULL,

	pageSize			integer	NOT NULL,

	pageCount			integer	NOT NULL,

	type				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileSubClient]') )
BEGIN
	DROP TABLE #CCM_sqlFileSubClient
END


CREATE  TABLE   #CCM_sqlFileSubClient (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlDatabaseId		integer not null,

	applicationNumber	integer not null,		-- points to the APP_Application table but not foreign constraint is created for it!

	subClientName		varchar(128)	NOT NULL,

	streams				integer default 1	NOT NULL,

	maxStreams			integer	default 1	NOT NULL,

	flags				integer default 0	NOT NULL,

	sqlFileSubClientGroupId		integer default 0	NOT NULL,	-- points to the sqlFileSubClientGroup entry that is the root of the list, no foreign index!



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileSubClientGroup]') )
BEGIN
	DROP TABLE #CCM_sqlFileSubClientGroup
END


CREATE  TABLE   #CCM_sqlFileSubClientGroup (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlFileSubClientId	integer not null,		-- Parent

	sqlFileId			integer default 0	NOT NULL,	-- requires sqlFileGroupId to be set

	sqlFileGroupId		integer default 0	NOT NULL,	-- sqlFileId can be set or 0 to indicate include the entire file group

	nextId				integer default 0	NOT NULL,	-- points to next sqlFileSubClientGroup Record, network access



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlLogMarkNames]') )
BEGIN
	DROP TABLE #CCM_sqlLogMarkNames
END


CREATE  TABLE   #CCM_sqlLogMarkNames (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlDatabaseId		integer not null,

	name				varchar(64)	NOT NULL,

	description			varchar(255)	NOT NULL,

	lsn					varchar(32)	NOT NULL,

	markTime			DATETIME,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlNames]') )
BEGIN
	DROP TABLE #CCM_sqlNames
END


CREATE  TABLE   #CCM_sqlNames (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	sqlId				integer	NOT NULL,

	name				varchar(1024)	NOT NULL,

	type				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlNames2]') )
BEGIN
	DROP TABLE #CCM_sqlNames2
END


CREATE  TABLE   #CCM_sqlNames2 (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	sqlId				integer	NOT NULL,

	name				nvarchar(1024)	NOT NULL,

	type				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlDbBackupInfo]') )
BEGIN
	DROP TABLE #CCM_sqlDbBackupInfo
END


CREATE  TABLE   #CCM_sqlDbBackupInfo (
	id							INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	backup_set_id				integer	NOT NULL,

	majorVersion				integer	NOT NULL,

	minorVersion				integer	NOT NULL,

	buildVersion				integer	NOT NULL,

	database_creation_date		integer	NOT NULL,

	backup_start_Date			integer	NOT NULL,

	backup_finish_Date			integer	NOT NULL,

	type						char(1)	NOT NULL,

	instanceId					integer	NOT NULL,

	appId						integer	NOT NULL,

	backup_size					bigint	NOT NULL,

	dbId						integer	NOT NULL,

	first_lsn					varchar(32)	NOT NULL,

	last_lsn					varchar(32)	NOT NULL,

	checkpoint_lsn				varchar(32)	NOT NULL,

	full_bkup_lsn				varchar(32)	NOT NULL,

	sqlNameId					integer	NOT NULL,

	sqlLastLogBackup			integer	NOT NULL,

	sqlVssFullbackupTime		varchar(64) NULL,

	is_copy						integer	NOT NULL,

	backupmethod				integer	NOT NULL,

	backupVendor				integer	NOT NULL,

	jobId						integer	NOT NULL,

	replica_id					uniqueidentifier NULL,

	group_database_id			uniqueidentifier NULL,

	first_recovery_fork_guid	uniqueidentifier NULL,

	last_recovery_fork_guid		uniqueidentifier NULL,

	differential_base_guid		uniqueidentifier NULL,

	database_guid				uniqueidentifier NULL,

	fork_point_lsn				varchar(32),

	differential_base_lsn		varchar(32),

	compressed_backup_size		varchar(32),

	begins_log_chain			char(1) NULL,

	has_backup_checksums		char(1) NULL,

	database_bkup_lsn			varchar(32)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlArchiveInfo]') )
BEGIN
	DROP TABLE #CCM_sqlArchiveInfo
END


CREATE  TABLE   #CCM_sqlArchiveInfo (
	sqlDbBackupFileId		integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	commCellId				integer	NOT NULL,

	aFileId					integer	NOT NULL,

	aFileOffset				bigint	NOT NULL,

	aGroupId				integer	NOT NULL,

	appId					integer	NOT NULL,

	DbFile				nvarchar(MAX)NULL,

	backupJobId				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileBackupInfo]') )
BEGIN
	DROP TABLE #CCM_sqlFileBackupInfo
END


CREATE  TABLE   #CCM_sqlFileBackupInfo (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	sqlDbBackupInfoId	integer not null,

	number				integer	NOT NULL,

	pageSize			bigint	NOT NULL,

	pageCount			integer	NOT NULL,

	type				integer	NOT NULL,

	sqlNameFgId			integer	NOT NULL,

	sqlNamePhyId		integer	NOT NULL,

	sqlNameLogId		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlLogMarks]') )
BEGIN
	DROP TABLE #CCM_sqlLogMarks
END


CREATE  TABLE   #CCM_sqlLogMarks (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	dbId				integer not null,

	instanceId			integer not null,

	dbName				nvarchar(128)	NOT NULL,

	name				nvarchar(64)	NOT NULL,

	description			nvarchar(255)	NOT NULL,

	lsn					varchar(32)	NOT NULL,

	markTime			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_oracleDataFiles]') )
BEGIN
	DROP TABLE #CCM_oracleDataFiles
END


CREATE  TABLE   #CCM_oracleDataFiles (
	id						INTEGER NOT NULL,							-- serial field for unqiue key and tablespace id

	name					varchar(2048),	-- Same as Job Manager jobID NOT NULL

	tblId					integer	NOT NULL,	-- TableSpace which this data file belongs to

	instId					integer	NOT NULL,	-- Instance Id to joing with AppManager Instance properties

	bkpNode					varchar(64),	-- Oracle Parallel Server Node NOT NULL

	status					integer	NOT NULL,	-- Status of Tablespace  ONLINE, OFFLINE, READ_ONLY

	created					INTEGER  NOT NULL,	-- Time at which Tablespace was inserted into table

	deleteFlag				integer	NOT NULL,	-- 0 = not deleted, 1 = deleted

	deleted			    	INTEGER  NOT NULL,	-- Time at which Tablespace was deleted

	modified				INTEGER  NOT NULL,	-- last time tablespace was updated

	opType					integer	NOT NULL,	-- type of entry, for browse or for backup

	backupsetId				integer	NOT NULL,	-- Galaxy BackupSetId

	maxDBdataSize			bigint	NOT NULL,	-- Maximum database size

	freeDBDataSize			bigint	NOT NULL,	-- Availabl space for data

	underDBDir				integer	NOT NULL,

	contType				integer	NOT NULL,

	totalPages				integer	NOT NULL,

	isAccessible			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_oracleTableSpaces]') )
BEGIN
	DROP TABLE #CCM_oracleTableSpaces
END


CREATE  TABLE   #CCM_oracleTableSpaces (
	id                  INTEGER NOT NULL,                     	-- serial field for unqiue key and tablespace id

	name                varchar(64),	-- Same as Job Manager jobID NOT NULL

	instId              integer	NOT NULL,	-- Instance Id to joing with AppManager Instance properties

	bkpNode             varchar(64),	-- Oracle Parallel Server Node NOT NULL

	status              integer	NOT NULL,	-- Status of Tablespace  ONLINE, OFFLINE, READ_ONLY

	created             INTEGER  NOT NULL,	-- Time at which Tablespace was inserted into table

	deleteFlag          integer	NOT NULL,	-- 0 = not deleted, 1 = deleted

	deleted             INTEGER  NOT NULL,	-- Time at which Tablespace was deleted

	modified            INTEGER  NOT NULL,	-- last time tablespace was updated

	opType              integer	NOT NULL,	-- type of entry, for browse or for backup

	backupsetId         integer	NOT NULL,	-- Galaxy BackupSetId

	tablespaceId        integer	NOT NULL,	-- DB2 tablespaceId

	maxDBdataSize       bigint	NOT NULL,	-- Maximum database size

	freeDBDataSize      bigint	NOT NULL,	-- Availabl space for data

	pdbId		integer default 0	NOT NULL,	--establishes relationship between OraclePDBs and OracleTablespaces (default value 0)

	highwatermark       integer default 0	NOT NULL,	--Store high watermark value for DB2 tablespaces.



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_oracleObjects]') )
BEGIN
	DROP TABLE #CCM_oracleObjects
END


CREATE  TABLE   #CCM_oracleObjects (
	id						INTEGER NOT NULL,							-- serial field for unqiue key

	subClientId				integer	NOT NULL,

	taskId					bigint	NOT NULL,	-- restore task id, only used for restore set type

	instId					integer	NOT NULL,	-- Instance Id to joing with AppManager Instance properties

	type					integer	NOT NULL,	-- TABLESPACE or DATAFILE

	parentId				integer	NOT NULL,	-- Parent Id, if this object has parent

	objId					integer	NOT NULL,	-- TableSpace which this data file belongs to

	setType					integer	NOT NULL,	-- 0 = do not backup, 1 = backup

	actionType				integer	NOT NULL,	-- Type of action: 0 - remove, 1 - change, 2 - add.

	name					varchar(2048),	-- The path of the new container for redirection. NOT NULL

	underDBDir				integer	NOT NULL,

	contType				integer	NOT NULL,

	totalPages				integer	NOT NULL,

	isAccessible			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_OraclePluggableDBs]') )
BEGIN
	DROP TABLE #CCM_OraclePluggableDBs
END


CREATE  TABLE   #CCM_OraclePluggableDBs (
	pdbId               INTEGER NOT NULL,                     	-- serial field for unqiue key and tablespace id

	name                varchar(64),	-- Same as Job Manager jobID NOT NULL

	instId              integer	NOT NULL,	-- Instance Id to joing with AppManager Instance properties

	created             INTEGER  NOT NULL,	-- Time at which Tablespace was inserted into table

	deleteFlag          integer	NOT NULL,	-- 0 = not deleted, 1 = deleted

	deleted             INTEGER  NOT NULL,	-- Time at which Oracle PDB was deleted

	modified            INTEGER  NOT NULL,	-- last time tablespace was updated

	opType              integer	NOT NULL,	-- type of entry, for browse or for backup

	dbAttributes		xml,			    	-- Attributes of DB

	dbId				bigint					NOT NULL,	--dbId of the PDB



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybArchFileInfo]') )
BEGIN
	DROP TABLE #CCM_sybArchFileInfo
END


CREATE  TABLE   #CCM_sybArchFileInfo (
	id INTEGER NOT NULL,

	commCellId integer	NOT NULL,

	archFileId integer	NOT NULL,

	sybInstanceId integer	NOT NULL,

	sybSubclientId integer	NOT NULL,

	sybDatabaseId integer	NOT NULL,

	sybDatabaseName varchar(64)	NOT NULL,

	sybBackupJobId_h	 integer	NOT NULL,

	sybBackupJobId_l	 integer	NOT NULL,

	stream integer	NOT NULL,

	maxStream integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybTransLog]') )
BEGIN
	DROP TABLE #CCM_sybTransLog
END


CREATE  TABLE   #CCM_sybTransLog (
	id INTEGER NOT NULL,

	sybArchFileId	integer	NOT NULL,

	startTime	integer	NOT NULL,

	finishTime	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybSystemDevices]') )
BEGIN
	DROP TABLE #CCM_sybSystemDevices
END


CREATE  TABLE   #CCM_sybSystemDevices (
	id INTEGER NOT NULL,

	sybBackupJobId_h integer	NOT NULL,

	sybBackupJobId_l integer	NOT NULL,

	commCellId    integer	NOT NULL,

	sybInstanceId integer	NOT NULL,

	sybSubclientId integer	NOT NULL,

	sybDatabaseId integer	NOT NULL,

	sybDatabaseName varchar(64)	NOT NULL,

	sybDevNumber integer	NOT NULL,

	sybDevLogicalName varchar(32)	NOT NULL,

	sybDevPhyName varchar(127)	NOT NULL,

	sybDevSize integer	NOT NULL,

	sybDevStatus integer	NOT NULL,

	sybDevCtrlType integer	NOT NULL,

	sybDevHigh integer	NOT NULL,

	sybDevLow integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybSystemUsages]') )
BEGIN
	DROP TABLE #CCM_sybSystemUsages
END


CREATE  TABLE   #CCM_sybSystemUsages (
	id INTEGER NOT NULL,

	sybDevId integer	NOT NULL,

	sybBackupJobId_h integer	NOT NULL,

	sybBackupJobId_l integer	NOT NULL,

	commCellId    integer	NOT NULL,

	sybInstanceId integer	NOT NULL,

	sybSubclientId integer	NOT NULL,

	sybDatabaseId integer	NOT NULL,

	sybDatabaseName varchar(64)	NOT NULL,

	sysSysLstart integer	NOT NULL,

	sybSysVstart integer	NOT NULL,

	sybSysVsize integer	NOT NULL,

	sybSysSegMap integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LicUsage]') )
BEGIN
	DROP TABLE #CCM_LicUsage
END


CREATE  TABLE   #CCM_LicUsage (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	Name			    nvarchar(255)	NOT NULL,

	CId					integer	NOT NULL,

	LicType				integer	NOT NULL,

	AppType				integer	NOT NULL,

	OpType				char(25)	NOT NULL,

	OpTimeUTC			datetime,

	TokensUsed			integer	NOT NULL,

	Eval				integer	NOT NULL,

	ExpiryDateUTC		datetime,

	ReleaseId			integer	NOT NULL,

	EncryptedField		varchar(2048)	NOT NULL,

	SimOSID				integer	NOT NULL,	-- simOsId from simpackagev2 to get rid of simpkg, pm and scav2 tbls

	Build				varchar(32),	-- Buildid from simclientappsv2 NOT NULL

	InstallFlag			integer DEFAULT 0	NOT NULL,	-- This is for storing if the install is for VM(Parags req)

	UserID				integer DEFAULT 0	NOT NULL,

	UsedCapacity		float	DEFAULT 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LicUsageHistory]') )
BEGIN
	DROP TABLE #CCM_LicUsageHistory
END


CREATE  TABLE   #CCM_LicUsageHistory (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	LicUsageId			integer	NOT NULL,

	Name				nvarchar(255)	NOT NULL,

	CId					integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	LicType				integer	NOT NULL,

	AppType				integer	NOT NULL,

	OpType				char(25)	NOT NULL,

	OpTimeUTC			datetime,

	TokensUsed			integer	NOT NULL,

	Eval				integer	NOT NULL,

	ExpiryDateUTC		datetime,

	ReleaseId			integer	NOT NULL,

	EncryptedField		varchar(2048)	NOT NULL,

	CreateTimeUTC		datetime,

	SimOSID				integer	NOT NULL,	-- simOsId from simpackagev2 to get rid of simpkg, pm and scav2 tbls

	Build				varchar(32),	-- Buildid from simclientappsv2 NOT NULL

	InstallFlag			integer DEFAULT 0	NOT NULL,	-- This is for storing if the install is for VM(Parags req)

	UserID				integer DEFAULT 0	NOT NULL,

	UsedCapacity		float	DEFAULT 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LicAal]') )
BEGIN
	DROP TABLE #CCM_LicAal
END


CREATE  TABLE   #CCM_LicAal (
	simLicAppTypeId		integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	eval_fld1			char ( 64)	NOT NULL,

	perm_fld1			char ( 64)	NOT NULL,

	commcellId		integer DEFAULT 2	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxSIDBStore]') )
BEGIN
	DROP TABLE #CCM_IdxSIDBStore
END


CREATE  TABLE   #CCM_IdxSIDBStore (
	SIDBStoreId						INTEGER NOT NULL,

	SIDBStoreName					NVARCHAR(256),	--	- by default, format will be: 'SIDB_CopyName_ID' NOT NULL

	SIDBStoreAliasName				NVARCHAR(256),	--	- by default, format will be: 'SIDB_CopyName' NOT NULL

	CommCellId						integer	NOT NULL,	--	- Needed for CCM.

	IdxCacheId						integer	NOT NULL,

	IdxAccessPathId					integer	NOT NULL,

	ClientId						integer	NOT NULL,	--redudandant but good for queries

	FirstBackupTime					INTEGER  NOT NULL,

	MinObjSizeKB					bigint	NOT NULL,

	oldestEligibleObjArchiveTime	INTEGER  NOT NULL,

	SignatureType					integer	NOT NULL,

	flags							integer	NOT NULL,

	TotalDataSizeBytes				bigint	NOT NULL,

	InstancedDataSizeBytes			bigint	NOT NULL,

	Status							integer	NOT NULL,

	LastAccessTime					integer	NOT NULL,

	CreatedTime						integer	NOT NULL,

	SealedTime						integer	NOT NULL,

	origCCSIDBStoreId				integer	NOT NULL,

	Version							integer	NOT NULL,

	SIDBSnapPath					varchar(1024)	NOT NULL,

	LastSnapTime					integer	NOT NULL,

	LastRecoveryTime				integer	NOT NULL,

	SealedReason					integer	NOT NULL,

	SIDBSiloedTime					integer	NOT NULL,

	SIDBSiloStatus					integer	NOT NULL,

	SIDBSiloJobId					integer	NOT NULL,

	SubStoreCount					integer	NOT NULL,

	MaxAllowedConnections				integer	NOT NULL,

	MaxNumOfAFsInSecFile				integer	NOT NULL,

	LastDDBVerificationTime			bigint DEFAULT 0	NOT NULL,

	LastDataVerificationTime		bigint DEFAULT 0	NOT NULL,

	DedupFactor					integer DEFAULT 1	NOT NULL,

	AppTypeGroupId					integer DEFAULT 0	NOT NULL,	--Refers to App_AppTypeGroup table

	ExtendedFlags					bigint DEFAULT 0	NOT NULL,

	FullReason						tinyint DEFAULT 0	NOT NULL,

	FullTime						INTEGER  DEFAULT 0 NOT NULL,

	SIDBGroupId						integer DEFAULT 0	NOT NULL,	--Refers to IdxSIDBGroup table

	LastQuickDDBVerificationTime	bigint DEFAULT 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxSIDBSubStore]') )
BEGIN
	DROP TABLE #CCM_IdxSIDBSubStore
END


CREATE  TABLE   #CCM_IdxSIDBSubStore (
	SIDBStoreId						integer	NOT NULL,

	SubStoreId						INTEGER NOT NULL,

	commCellId						integer	NOT NULL,

	GroupNumber						integer	NOT NULL,

	IdxCacheId						integer	NOT NULL,

	IdxAccessPathId					integer	NOT NULL,

	ClientId						integer	NOT NULL,	--redudandant but good for queries

	FirstBackupTime					INTEGER  NOT NULL,

	flags							integer	NOT NULL,

	TotalDataSizeBytes				bigint	NOT NULL,

	InstancedDataSizeBytes			bigint	NOT NULL,

	Status							integer	NOT NULL,

	LastAccessTime					integer	NOT NULL,

	CreatedTime						integer	NOT NULL,

	SealedTime						integer	NOT NULL,

	Version							integer	NOT NULL,

	SIDBSnapPath					varchar(1024)	NOT NULL,

	LastSnapTime					integer	NOT NULL,

	origSubStoreId					integer	NOT NULL,

	ReconLevel					integer	NOT NULL,

	LastSnapJobId					integer default 0	NOT NULL,

	DDBBackupCSGUID					nvarchar(40)	NOT NULL,

	PrimaryId					bigint default 0	NOT NULL,

	MemDbTimeStamp					integer default 0	NOT NULL,

	CorruptionTime					integer default 0	NOT NULL,

	ZeroRefBatchSeq						bigint default 0	NOT NULL,

	StartLogSequence				varchar(128) default ''	NOT NULL,

	EndLogSequence				varchar(128) default ''	NOT NULL,

	SnapLogSequence				varchar(128) default ''	NOT NULL,

	MaxNumOfAFsInSecFile			integer default 0	NOT NULL,

	ExtendedFlags				bigint default 0	NOT NULL,

	DDBSubClientId				integer default 0	NOT NULL,

	PageSize				integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_GXGlobalParam]') )
BEGIN
	DROP TABLE #CCM_GXGlobalParam
END


CREATE  TABLE   #CCM_GXGlobalParam (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	name		    	nvarchar(64)	NOT NULL,

	value				nvarchar(max) NOT NULL,

	created				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_Pattern]') )
BEGIN
	DROP TABLE #CCM_TM_Pattern
END


CREATE  TABLE   #CCM_TM_Pattern (
	patternId				INTEGER NOT NULL,

	name					nvarchar(255)					NOT NULL,

	ownerId					integer					NOT NULL,

	status					integer					NOT NULL,

	flags					integer					NOT NULL,

	freq_type				integer					NOT NULL,

	freq_interval			integer					NOT NULL,

	freq_relative_interval	integer					NOT NULL,

	freq_recurrence_factor	integer					NOT NULL,

	freq_subday_interval	integer					NOT NULL,

	skipOccurence			integer					NOT NULL,

	skipDayNumber			integer					NOT NULL,

	active_start_date		DATETIME			,

	active_start_time		integer					NOT NULL,

	active_end_date			DATETIME			,

	active_end_time			integer					NOT NULL,

	active_end_occurence	integer					NOT NULL,

	created					integer					NOT NULL,

	modified				integer					NOT NULL,

	tzId					integer					NOT NULL,

	calendarId				integer					NOT NULL,

	description				nvarchar(2048)	NOT NULL,

	local_start_date		integer					NOT NULL,

	local_end_date			integer					NOT NULL,

	disabled				tinyint					NOT NULL,

	deleted					tinyint					NOT NULL,

	scheduling				tinyint					NOT NULL,

	freq_restart_interval  	integer					NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_PatternAssoc]') )
BEGIN
	DROP TABLE #CCM_TM_PatternAssoc
END


CREATE  TABLE   #CCM_TM_PatternAssoc (
	patternAssocId				INTEGER NOT NULL,

	patternId					integer					NOT NULL,

	subTaskId					integer					NOT NULL,

	flags						integer					NOT NULL,	--schedule pattern is expired for this association

	disabled					tinyint					NOT NULL,

	deleted						tinyint					NOT NULL,

	scheduling					tinyint					NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_SubTask]') )
BEGIN
	DROP TABLE #CCM_TM_SubTask
END


CREATE  TABLE   #CCM_TM_SubTask (
	subTaskId				INTEGER NOT NULL,

	subTaskName				nvarchar(255) null,

	taskId					integer					NOT NULL,

	subTaskType				integer					NOT NULL,

	operationType			integer					NOT NULL,

	flags					integer					NOT NULL,

	subTaskOrder			integer					NOT NULL,

	deleted					tinyint					NOT NULL,

	uninstalled				tinyint					NOT NULL,

	defaultTask				tinyint					NOT NULL,

	subOperationType		xml					,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_AssocEntity]') )
BEGIN
	DROP TABLE #CCM_TM_AssocEntity
END


CREATE  TABLE   #CCM_TM_AssocEntity (
	assocId					INTEGER NOT NULL,

	assocType				integer					NOT NULL,

	taskId					integer					NOT NULL,

	flags					integer					NOT NULL,

	created					integer					NOT NULL,

	clientGroupId			integer					NOT NULL,

	clientId				integer					NOT NULL,

	apptypeId				integer					NOT NULL,

	instanceId				integer					NOT NULL,

	backupsetId				integer					NOT NULL,

	subclientId				integer					NOT NULL,

	policyId				integer					NOT NULL,

	copyId					integer					NOT NULL,

	srmReportSet			integer					NOT NULL,

	srmReportType			integer					NOT NULL,

	exclude					tinyint					NOT NULL,

	trackingPolicyId		integer					NOT NULL,

	MediaAgentId			integer					NOT NULL,

	agentlessPolicyId		integer					NOT NULL,

	workflowId				integer					NOT NULL,

	sidbStoreId				integer					NOT NULL,

	libraryId				integer					NOT NULL,

	logMonitoringPolicyId	integer					NOT NULL,

	entityId				integer	NOT NULL DEFAULT 0 , --Added for supporting Inventory data source and any other future entity types, entity type is stored in assoctype



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_Task]') )
BEGIN
	DROP TABLE #CCM_TM_Task
END


CREATE  TABLE   #CCM_TM_Task (
	taskId					INTEGER NOT NULL,

	taskName                nvarchar(255) null,

	taskType				integer					NOT NULL,

	flags					integer					NOT NULL,

	status					integer					NOT NULL,

	created					integer					NOT NULL,

	modified				integer					NOT NULL,

	alertId			 		integer					NOT NULL,

	ownerId					integer					NOT NULL,

	runUserId				integer					NOT NULL,

	initiatedFrom			integer					NOT NULL,

	sequenceNumber			varchar(255)			NOT NULL,

	localeId				integer					NOT NULL,

	description				nvarchar(2048) null,

	deleted					tinyint					NOT NULL,

	disabled				tinyint					NOT NULL,

	uninstalled				tinyint					NOT NULL,

	invalid					tinyint					NOT NULL,

	defaultTask				tinyint					NOT NULL,

	savedReport				tinyint					NOT NULL,

	serial					tinyint					NOT NULL,

	policyType				tinyint					NOT NULL,

	origCCId			integer		DEFAULT		2	NOT NULL,

	GUID				varchar(40)	DEFAULT	newid()	NOT NULL,

	isEZOperation			tinyint					NOT NULL,

	isAgentlessSRM			tinyint					NOT NULL,

	hidden				tinyint					NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMVolume]') )
BEGIN
	DROP TABLE #CCM_SMVolume
END


CREATE  TABLE   #CCM_SMVolume (
	SMVolumeId						INTEGER NOT NULL,

	SourceClientId					integer	NOT NULL,

	MountHostId						integer	NOT NULL,

	CommCellId						integer	NOT NULL,

	JobId							integer	NOT NULL,

	ArchFileId						integer	NOT NULL,

	CopyId							smallint	NOT NULL,

	AppId							integer	NOT NULL,

	AppTypeId						integer	NOT NULL,

	PruneFlags						integer	NOT NULL,

	VolumeFlags						bigint	NOT NULL,

	VolumeStatus					integer	NOT NULL,

	VolumeStatusUpdateTime			INTEGER  NOT NULL,

	MountStatus						integer	NOT NULL,

	MountStatusUpdateTime			INTEGER  NOT NULL,

	LogicalUnmountTime				INTEGER  NOT NULL,

	CreationTime					INTEGER  NOT NULL,

	RetryCount						integer	NOT NULL,

	DevMode							integer	NOT NULL,

	UserId							integer	NOT NULL,

	GroupId							integer	NOT NULL,

	SnapSource						integer	NOT NULL,

	MountProxyId					integer	NOT NULL,

	RemoteOp						integer	NOT NULL,

	RemoteOpStatus					integer	NOT NULL,

	VmHostId						integer	NOT NULL,

	RecoveryPointId					bigint	NOT NULL,

	OriginClientId					integer	NOT NULL,

	SourcePath						NVARCHAR(1024) default ''	NOT NULL,

	MountPath						NVARCHAR(1024) default ''	NOT NULL,

	SourceGUID						NVARCHAR(1024) default ''	NOT NULL,

	MountGUID						NVARCHAR(1024) default ''	NOT NULL,

	SourceDevice					NVARCHAR(1024) default ''	NOT NULL,

	MountDevice						NVARCHAR(1024) default ''	NOT NULL,

	MountOptions					NVARCHAR(1024) default ''	NOT NULL,

	ShadowSetId						NVARCHAR(40) default ''	NOT NULL,

	ShadowCopyId					NVARCHAR(40) default ''	NOT NULL,

	RepBasePath						NVARCHAR(1024) default ''	NOT NULL,

	RepRelativePath					NVARCHAR(1024) default ''	NOT NULL,

	OriginSourcePath				NVARCHAR(1024) default ''	NOT NULL,

	GUID						uniqueidentifier ROWGUIDCOL,		-- for Unique identification across CommCells

	ReserveField1				integer default 0	NOT NULL,

	ReserveField2				integer default 0	NOT NULL,

	ReserveFieldStr				NVARCHAR(255) default ''	NOT NULL,

	SourceVolumeId				integer default 0	NOT NULL,

	MasterJobId					integer default 0	NOT NULL,

	PartitionNum				integer default 0	NOT NULL,

	UsedSpaceBytes				bigint default 0	NOT NULL,

	TotalSpaceBytes				bigint default 0	NOT NULL,

	PseudoClientId				integer default 0	NOT NULL,

	RequestId					integer default 0	NOT NULL,

	TotalRetryCount				integer	default 0	NOT NULL,

	GroupingId					bigint default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMVolSnapMap]') )
BEGIN
	DROP TABLE #CCM_SMVolSnapMap
END


CREATE  TABLE   #CCM_SMVolSnapMap (
	SMVolSnapMapId		INTEGER NOT NULL,

	SMVolumeId			integer	NOT NULL,

	SMSnapId			integer	NOT NULL,

	MetaDataId			integer	NOT NULL,

	GroupId				integer	NOT NULL,

	PruneFlags			integer	NOT NULL,

	OrigCCId					integer	DEFAULT	2	NOT NULL,	-- for CommCell Migration Path

	GUID						uniqueidentifier ROWGUIDCOL,		-- for Unique identification across CommCells

	ReserveField1				integer default 0	NOT NULL,

	ReserveField2				integer default 0	NOT NULL,

	ReserveFieldStr				NVARCHAR(255) default ''	NOT NULL,

	Flags				bigint default 0	NOT NULL,

	GroupType			bigint default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMMetaData]') )
BEGIN
	DROP TABLE #CCM_SMMetaData
END


CREATE  TABLE   #CCM_SMMetaData (
	MetaDataId			INTEGER NOT NULL,

	MetaDataType		integer	NOT NULL,

	RefType				integer	NOT NULL,

	RefId				integer	NOT NULL,

	PruneFlags			integer	NOT NULL,

	MetaData				nvarchar(max) NOT NULL,

	OrigCCId					integer	DEFAULT	2	NOT NULL,	-- for CommCell Migration Path

	GUID						uniqueidentifier ROWGUIDCOL,		-- for Unique identification across CommCells

	ReserveField1				integer default 0	NOT NULL,

	ReserveField2				integer default 0	NOT NULL,

	ReserveFieldStr				NVARCHAR(255) default ''	NOT NULL,

	Flags				bigint default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMSnap]') )
BEGIN
	DROP TABLE #CCM_SMSnap
END


CREATE  TABLE   #CCM_SMSnap (
	SMSnapId						INTEGER NOT NULL,

	SnapShotEngineId				integer	NOT NULL,

	OriginalSnapEngineId			integer	NOT NULL,

	ControlHostId					integer	NOT NULL,

	GroupId							integer	NOT NULL,

	SnapType						integer	NOT NULL,

	SnapFlags						bigint	NOT NULL,

	PruneFlags						integer	NOT NULL,

	SnapStatus						integer	NOT NULL,

	SnapStatusUpdateTime			INTEGER  NOT NULL,

	CreationTime					INTEGER  NOT NULL,

	ReplicationStatus				bigint	NOT NULL,

	DeviceEntryType					integer	NOT NULL,

	ConnectionType					integer	NOT NULL,

	SnapSourceDevice				NVARCHAR(1024) default ''	NOT NULL,

	SnapDevice						NVARCHAR(1024) default ''	NOT NULL,

	ShadowCopyId					NVARCHAR(40) default ''	NOT NULL,

	UniqueIdentifier				NVARCHAR(1024) default ''	NOT NULL,

	SourceIdentifier				NVARCHAR(1024) default ''	NOT NULL,

	TargetIdentifier				NVARCHAR(1024) default ''	NOT NULL,

	OrigCCId						integer	DEFAULT	2	NOT NULL,	-- for CommCell Migration Path

	GUID							uniqueidentifier ROWGUIDCOL,		-- for Unique identification across CommCells

	ReserveField1					integer default 0	NOT NULL,

	ReserveField2					integer default 0	NOT NULL,

	ReserveFieldStr					NVARCHAR(255) default ''	NOT NULL,

	ArrayVolumeId					integer default 0	NOT NULL,

	LunId							integer default 0	NOT NULL,

	UsedSpaceBytes					bigint default -1	NOT NULL,

	ReserveField3					integer default 0	NOT NULL,

	ReserveField4					integer default 0	NOT NULL,

	ArraySrcDevice					NVARCHAR(1024) default ''	NOT NULL,

	ArrayTgtDevice					NVARCHAR(1024) default ''	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMControlHost]') )
BEGIN
	DROP TABLE #CCM_SMControlHost
END


CREATE  TABLE   #CCM_SMControlHost (
	ControlHostId				INTEGER NOT NULL,

	SnapShotEngineId			integer	NOT NULL,

	SnapVendorName				NVARCHAR(128) default ''	NOT NULL,

	SMArrayId					NVARCHAR(1024) default ''	NOT NULL,

	SMHostIP					NVARCHAR(1024) default ''	NOT NULL,

	SMHostName					NVARCHAR(1024) default ''	NOT NULL,

	SMHostPortNumber			integer	NOT NULL,

	SMHostUserName				NVARCHAR(1024) default ''	NOT NULL,

	SMHostPassword				NVARCHAR(2048) default ''	NOT NULL,

	SMHostFlags					integer	NOT NULL,

	SMHostStatus				integer	NOT NULL,

	SMHostDescription			NVARCHAR(1024) default ''	NOT NULL,

	SnapShotEngineName			NVARCHAR(1024) default ''	NOT NULL,

	DeviceGroupName				NVARCHAR(1024) default ''	NOT NULL,

	SMHostOption				integer	NOT NULL,

	SourceId					integer default 0	NOT NULL,

	OrigCCId					integer	DEFAULT	2	NOT NULL,	-- for CommCell Migration Path

	GUID						uniqueidentifier ROWGUIDCOL,		-- for Unique identification across CommCells

	ReserveField1				integer default 0	NOT NULL,

	ReserveField2				integer default 0	NOT NULL,

	ReserveFieldStr				NVARCHAR(255) default ''	NOT NULL,

	ClientId					integer default 1	NOT NULL,

	SoftState					integer default 0	NOT NULL,

	IsEnabled					integer default 0	NOT NULL,

	IsActive					integer default 0	NOT NULL,

	BrokenCode					integer default 0	NOT NULL,

	ReasonCode					integer default 0	NOT NULL,

	Flags						bigint default 0	NOT NULL,

	AdminConsole				NVARCHAR(1024) default ''	NOT NULL,

	Properties					XML default '',

	ReserveField3				integer default 0	NOT NULL,

	ReserveField4				integer default 0	NOT NULL,

	GroupingId					bigint default 0	NOT NULL,

	UniqueIdentifier			NVARCHAR(1024) default ''	NOT NULL,

	CreatedTime					DATETIME NOT NULL DEFAULT (GETUTCDATE()),

	ModifiedTime				DATETIME NOT NULL DEFAULT (GETUTCDATE()),

	CredentialId				integer default -1	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSProviders]') )
BEGIN
	DROP TABLE #CCM_UMDSProviders
END


CREATE  TABLE   #CCM_UMDSProviders (
	id				INTEGER NOT NULL,									-- Primary Key for this table

	domainName 		nvarchar(255),	-- full name NOT NULL

	hostName		nvarchar(4000),	-- Name used for connection NOT NULL

	description		nvarchar(3072),	-- "Friendly" name NOT NULL

	login			nvarchar(255),	-- login name NOT NULL

	password		nvarchar(400),	-- encrypted password NOT NULL

	trustedHostUser	nvarchar(255),	-- Obsoleted NOT NULL

	trustedHostPW	nvarchar(400),	--Obsoleted NOT NULL

	flags			integer	NOT NULL,	-- password aging policy

	enabled			integer	NOT NULL,	-- login enabled flag

	serviceType		integer	NOT NULL,	-- AD, etc .. For now, just "AD"

	modified		INTEGER  NOT NULL,	-- Used to determine "what has changed"

	dnsRoot			nvarchar(255),	-- Template name that will be dispalyed in the GUI NOT NULL

	dnsRootStatus	integer	NOT NULL,	-- dnsRoot status --(1-Resolved 0-UnResolved)

	useSecureLdap	integer	NOT NULL,	-- 1-Use SecureLdap 0-Use Ldap

	origCCId		integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	GUID			uniqueidentifier ROWGUIDCOL,			-- for uniquely identify across commcells

	port			integer 		DEFAULT         0	NOT NULL,

	resourceId		integer			DEFAULT         0		NOT NULL,

	checkTime		INTEGER 			DEFAULT			(24*60*60) NOT NULL,	-- Number of seconds before a user is revalidated against name server (0==infinite)

	ownerId			integer			DEFAULT			1	NOT NULL,	--User who created the domain, default owner is the master user

	ownerCompany	integer			DEFAULT			0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSgroups]') )
BEGIN
	DROP TABLE #CCM_UMDSgroups
END


CREATE  TABLE   #CCM_UMDSgroups (
	id			integer	NOT NULL,

	umdsProviderId		integer	NOT NULL,	-- Points to UMDSProviders table

	enabled				integer	NOT NULL,	-- is this group enabled

	name				nvarchar(255),	-- group name (from Externam Service) NOT NULL

	description			nvarchar(3072),	-- group description (friendly name) CV internal NOT NULL

	email				nvarchar(255),	-- Group Mail id NOT NULL

	lastCredSetTime 	INTEGER   default 0 NOT NULL,	-- Last time email was updated for this group

	oldId       		integer  default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMGroups]') )
BEGIN
	DROP TABLE #CCM_UMGroups
END


CREATE  TABLE   #CCM_UMGroups (
	id					INTEGER NOT NULL,								-- Primary Key for this table

	groupFlags			integer	NOT NULL,	-- is this group enabled

	allCapabilities		integer	NOT NULL,	-- See GF_XXX definitions above

	allAssociations		integer	NOT NULL,	-- with unlimited access

	selfAssociation		integer	NOT NULL,	-- has association to self

	name				NVARCHAR(255)	NOT NULL,

	description			NVARCHAR(3072),	-- group description NOT NULL

	origCCId			integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	GUID				uniqueidentifier ROWGUIDCOL,      	-- for Unique identification across CommCells

	umdsProviderId		integer DEFAULT 0	NOT NULL,	--umdsProviderId in case of external groups

	email				NVARCHAR(255) NOT NULL DEFAULT '',	--emailId in case of external groups

	lastCredSetTime		integer DEFAULT 0	NOT NULL,	--lastCredSetTime



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSGroupMaps]') )
BEGIN
	DROP TABLE #CCM_UMDSGroupMaps
END


CREATE  TABLE   #CCM_UMDSGroupMaps (
	umDSgroupId			integer	NOT NULL,	-- foreign key to UMUsers table

	umgroupId			integer	NOT NULL,	-- foreign key to UMGroups table

	flag				integer	NOT NULL,	-- For Maintenance

	umdsGroupMapsId     INTEGER NOT NULL, 	-- primary key of the table



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMUsers]') )
BEGIN
	DROP TABLE #CCM_UMUsers
END


CREATE  TABLE   #CCM_UMUsers (
	id				INTEGER NOT NULL,									-- Primary Key for this table

	name		    NVARCHAR(255)	NOT NULL,

	description				NVARCHAR(MAX) NOT NULL,

	login			NVARCHAR(255)	NOT NULL,

	password		nvarchar(400),	-- encrypted password NOT NULL

	email			NVARCHAR(255)	NOT NULL,

	datePasswordSet integer	NOT NULL,	-- password change date

	dateExpires		integer	NOT NULL,	-- account expiration date

	policy			integer	NOT NULL,	-- password aging policy

	enabled			integer	NOT NULL,	-- login enabled flag

	flags			integer	NOT NULL,	-- Deleted et al

	modified		INTEGER  NOT NULL,	-- Used to determine "what has changed"

	pVer			integer	NOT NULL,	-- Password Version .. actually a char casted up

	Pager           varchar(255),	-- Pager e-mail address NOT NULL

	lastLogInTime	INTEGER  NOT NULL,	-- Last time a user logged in with this login

	credSetTime		INTEGER  NOT NULL,	-- Last time the users credentials were updated

	umDSproviderId	integer	NOT NULL,	-- Points to umDSProvider table (==0 means local Commcell User)

	userGuid	 	nvarchar(256),	-- Generated User GUID ( also used in Commcell Migration) NOT NULL

	origUserGuid 	nvarchar(256),	-- Original DM2 User GUID NOT NULL

	origCCId		integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	salt			nvarchar(400) DEFAULT ''	NOT NULL,

	companyId		integer		DEFAULT		0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMUserGroup]') )
BEGIN
	DROP TABLE #CCM_UMUserGroup
END


CREATE  TABLE   #CCM_UMUserGroup (
	userId				integer	NOT NULL,	-- forign key to UMUsers table

	groupId				integer	NOT NULL,	-- foring key to UMGroups table

	flag				integer	NOT NULL,	-- For Maintenance

	umUserGroupId       INTEGER NOT NULL, 	-- primary key



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMUserPrefs]') )
BEGIN
	DROP TABLE #CCM_UMUserPrefs
END


CREATE  TABLE   #CCM_UMUserPrefs (
	userId		integer	NOT NULL,

	value				nvarchar(max) NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSUserGroup]') )
BEGIN
	DROP TABLE #CCM_UMDSUserGroup
END


CREATE  TABLE   #CCM_UMDSUserGroup (
	userId				integer	NOT NULL,	-- foreign key to UMUsers table

	groupId				integer	NOT NULL,	-- foreign key to UMgroup table

	flag				integer	NOT NULL,	-- For Maintenance

	umdsUserGroupId     INTEGER NOT NULL, 	--primary key



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMRoles]') )
BEGIN
	DROP TABLE #CCM_UMRoles
END


CREATE  TABLE   #CCM_UMRoles (
	id 						INTEGER NOT NULL,

	commcellId 			    integer    DEFAULT 2	NOT NULL,

	name   					NVARCHAR(255),	-- roles name NOT NULL

	description               NVARCHAR(3072),	-- roles description NOT NULL

	disabled             		integer	NOT NULL,	-- is this roles disabled

	isPrivate   				integer	NOT NULL,	-- keeping it as isPrivate instead of private since private is a keyword in cpp

	flags						integer	NOT NULL,	--to indicate DUMMY, DEFAULT, HIDDEN, etc

	ownerId                   integer	NOT NULL,

	created 					INTEGER  NOT NULL,

	modified 					INTEGER  NOT NULL,

	GUID                      uniqueidentifier ROWGUIDCOL,      	-- for Unique identification across CommCells

	xmlProperties				xml,										--for storing any properties that get added in the form of xml

	capabilitiesBitMask		bigint NOT NULL default 0,

	permissionsString			varchar(512) NOT NULL default ''



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMRolesPermissions]') )
BEGIN
	DROP TABLE #CCM_UMRolesPermissions
END


CREATE  TABLE   #CCM_UMRolesPermissions (
	roleId 			    			integer	NOT NULL,

	hierarchyLevel               		integer	NOT NULL,

	categoryId           	    		integer	NOT NULL,

	permissionId                   	integer	NOT NULL,

	excludeCategory	         		integer	NOT NULL,

	excludePermission					integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMRolesWithPermissionsExpanded]') )
BEGIN
	DROP TABLE #CCM_UMRolesWithPermissionsExpanded
END


CREATE  TABLE   #CCM_UMRolesWithPermissionsExpanded (
	roleId 							INT	NOT NULL,

	categoryId 						INT	NOT NULL,

	permissionId 					INT	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMOwners]') )
BEGIN
	DROP TABLE #CCM_UMOwners
END


CREATE  TABLE   #CCM_UMOwners (
	entityType			INT	NOT NULL,	--entity type defined in cventities.x

	entityId			INT	NOT NULL,	--entity id

	userOrGroupId		INT	NOT NULL,	--user or user group or external group id

	isUser				INT	NOT NULL,	--flag which when set to 1 indicates that the id in userOrGroupId column is userId else user Group Id

	authorId		    INT	NOT NULL,	--whoever is doing this operation

	flags				INT DEFAULT 1	NOT NULL,	--used to save some very important information like system created or user created

	companyId			INT DEFAULT 0	NOT NULL,	--this column refers to the company Id of this user / group to which this owner association is made for.



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMOwnerRoles]') )
BEGIN
	DROP TABLE #CCM_UMOwnerRoles
END


CREATE  TABLE   #CCM_UMOwnerRoles (
	entityType			INT	NOT NULL,	--entity type defined in cventities.x

	entityId			INT	NOT NULL,	--entity id

	roleId				INT		DEFAULT 0	NOT NULL,	--when role is associated

	permissionId		INT		DEFAULT 0	NOT NULL,	--when permission is associated directly

	authorId			INT	NOT NULL,	--whoever is doing that operation



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMSecurityAssociations]') )
BEGIN
	DROP TABLE #CCM_UMSecurityAssociations
END


CREATE  TABLE   #CCM_UMSecurityAssociations (
	roleId 						INT   DEFAULT 0	NOT NULL,	--when role is associated

	permissionId                INT   DEFAULT 0	NOT NULL,	--when permission is associated directly

	userOrGroupId 				INT	NOT NULL,	--user Id or user Group Id

	isUser 						INT	NOT NULL,	--flag which when set to 1 indicates that the id in userOrGroupId column is userId else user Group Id

	isRoleAllowed 				INT 	DEFAULT 1	NOT NULL,	--when set to 0 means that role is denied

	propagateToChildObjects 	INT 	DEFAULT 1	NOT NULL,	--flag to indicate whether the association should propagate to child objects

	roleValidityDate 			INT 	DEFAULT 0	NOT NULL,	--expiration date for this association (UTC)

	timeZone 					INT 	DEFAULT 0	NOT NULL,	--time zone for this expiration date (used only to send data back to GUI)

	exclude 					INT 	DEFAULT 0	NOT NULL,	--if some entity needs to be excluded from parent selection

	entityType1 				INT		DEFAULT 0	NOT NULL,	--the 5 entity hierarchy on which association is done

	entityId1 					INT		DEFAULT 0	NOT NULL,

	entityType2 				INT		DEFAULT 0	NOT NULL,

	entityId2 					INT		DEFAULT 0	NOT NULL,

	entityType3 				INT		DEFAULT 0	NOT NULL,

	entityId3 					INT		DEFAULT 0	NOT NULL,

	entityType4 				INT		DEFAULT 0	NOT NULL,

	entityId4 					INT		DEFAULT 0	NOT NULL,

	entityType5 				INT		DEFAULT 0	NOT NULL,

	entityId5 					INT		DEFAULT 0	NOT NULL,

	includeAll					INT		DEFAULT 0	NOT NULL,	--to indicate whether all entities of this entity type is selected or not

	isCreator					INT     DEFAULT 0	NOT NULL,	--flag to indicate whether this row corresponds to a entity creator (permissions are hard-coded in code)

	authorId					INT		DEFAULT 0	NOT NULL,	--this is a column for future reference- to indicate which user has done this operation

	companyId					INT		DEFAULT 0	NOT NULL,	--this column refers to the company Id of this user / group to which this security association is made for.

	securityId                          INTEGER NOT NULL,             	--this is a primary key column



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_edcJobIdMap]') )
BEGIN
	DROP TABLE #CCM_edcJobIdMap
END


CREATE  TABLE   #CCM_edcJobIdMap (
	mergedCcId	    integer		    not null,

	foreignJobId	nvarchar(512)	not null,

	newJobId	    integer		    not null



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_edcClientNameMap]') )
BEGIN
	DROP TABLE #CCM_edcClientNameMap
END


CREATE  TABLE   #CCM_edcClientNameMap (
	exServerAliasName 	nvarchar(255)	not null,

	exMachineName 		nvarchar(255)	not null,

	exMachineHostName 	nvarchar(255)	not null,

	gxMachineName 		nvarchar(255)	not null,

	gxMachineHostName 	nvarchar(255)	not null,

	creationTime 		integer		    not null,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archMaterializeSnapshotProp]') )
BEGIN
	DROP TABLE #CCM_archMaterializeSnapshotProp
END


CREATE  TABLE   #CCM_archMaterializeSnapshotProp (
	archGroupId		smallint	NOT NULL,

	enabled			tinyint	NOT NULL,

	type			tinyint	NOT NULL,

	flags			integer	NOT NULL,

	startTime		INTEGER  NOT NULL,

	sourceCopyId	smallint	NOT NULL,

	deferredDays	smallint	NOT NULL,

	numPeriod		tinyint	NOT NULL,

	dayNumber		smallint	NOT NULL,

	currPeriodBegin	INTEGER  NOT NULL,

	currPeriodEnd	INTEGER  NOT NULL,

	calendarId		integer	NOT NULL,

	numOfReaders	tinyint	NOT NULL,

	prevPeriodBegin	INTEGER  NOT NULL,

	nextPeriodEnd	INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_PatchUpdateAgentInfo]') )
BEGIN
	DROP TABLE #CCM_PatchUpdateAgentInfo
END


CREATE  TABLE   #CCM_PatchUpdateAgentInfo (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	clientId			integer	NOT NULL,

	isLocalDrive		integer	NOT NULL,

	cachePath			nvarchar(255)	NOT NULL,

	username			nvarchar(255)	NOT NULL,

	passwd				nvarchar(255)	NOT NULL,

	isEnabled			integer	NOT NULL,

	autoSyncWithCS		integer	NOT NULL,

	inSyncWithCS		integer	NOT NULL,

	isDeleted			integer	NOT NULL,

	packageStatus		integer	NOT NULL,

	SWSharePath			nvarchar(255)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_PatchMultiCache]') )
BEGIN
	DROP TABLE #CCM_PatchMultiCache
END


CREATE  TABLE   #CCM_PatchMultiCache (
	ClientId		integer	NOT NULL,

	ReleaseId		integer	NOT NULL,

	OSId			integer	NOT NULL,

	HighestSP		nvarchar(255)	NOT NULL,

	AddUpdates				nvarchar(max)NULL,

	IsSPValid       integer	NOT NULL,

	SPVersionId		integer NULL,

	id				INTEGER NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_CCRCommCellReadiness]') )
BEGIN
	DROP TABLE #CCM_CCRCommCellReadiness
END


CREATE  TABLE   #CCM_CCRCommCellReadiness (
	CCRId					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	CCRLevel				integer	NOT NULL,

	CCRStartTime			INTEGER  NOT NULL,

	CCREndTime				INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_CCRToSubClient]') )
BEGIN
	DROP TABLE #CCM_CCRToSubClient
END


CREATE  TABLE   #CCM_CCRToSubClient (
	CCRId					integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	ClientId				integer	NOT NULL,

	SubClientId				integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	DataPathId				integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	CCRResultFlag			integer	NOT NULL,

	lastUnCompBytes			bigint	NOT NULL,

	lastCompBytes			bigint	NOT NULL,

	capacityAvailable		bigint	NOT NULL,

	appTypeId				integer	NOT NULL,

	dataWritten					bigint	NOT NULL,

	CCRNetworkReadinessFlag		bigint	NOT NULL,

	CCRResourceReadinessFlag	bigint	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_CCRClientToClient]') )
BEGIN
	DROP TABLE #CCM_CCRClientToClient
END


CREATE  TABLE   #CCM_CCRClientToClient (
	FromClientId				integer	NOT NULL,

	FromClientInterfaceName		varchar(255)	NOT NULL,

	ToClientId					integer	NOT NULL,

	ToClientInterfaceName		varchar(255)	NOT NULL,

	NumberOfNWHops				integer	NOT NULL,

	NWDelayInMilliSec			integer	NOT NULL,

	LastUpdateTime				INTEGER  NOT NULL,

	IsEnabled					integer	NOT NULL,

	Flag						integer	NOT NULL,

	errorCode					integer	NOT NULL,

	lastOnlineTime				INTEGER  NOT NULL,

	serviceType					integer	NOT NULL,

	IsDip						integer	NOT NULL,

	lastOfflineTime				INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileCopyDedup]') )
BEGIN
	DROP TABLE #CCM_archFileCopyDedup
END


CREATE  TABLE   #CCM_archFileCopyDedup (
	archFileId				integer	NOT NULL,

	commCellId     			integer	NOT NULL,

	archCopyId				smallint	NOT NULL,

	SIDBStoreId				integer	NOT NULL,

	primaryObjects			integer	NOT NULL,

	secondaryObjects		integer	NOT NULL,

	primaryObjSize			bigint	NOT NULL,

	secondaryObjSize		bigint	NOT NULL,

	primaryMetaDataSize		bigint	NOT NULL,

	secondaryMetaDataSize	bigint	NOT NULL,

	transDataSize			bigint	NOT NULL,

	savedDataSize			bigint	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileSIDBKeys]') )
BEGIN
	DROP TABLE #CCM_archFileSIDBKeys
END


CREATE  TABLE   #CCM_archFileSIDBKeys (
	archFileId		integer	NOT NULL,

	commCellId		integer	NOT NULL,

	archCopyId		smallint	NOT NULL,

	encKeyType		tinyint	NOT NULL,

	encKey			varchar(1024)	NOT NULL,

	SIDBStoreId		integer	NOT NULL,

	encRSA			tinyint default 0	NOT NULL,

	encKeyId		integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMEntityProp]') )
BEGIN
	DROP TABLE #CCM_MMEntityProp
END


CREATE  TABLE   #CCM_MMEntityProp (
	EntityId		INTEGER	NOT NULL,	-- Will have SPID, SPCID, LibraryID etc

	EntityType		TINYINT	NOT NULL,	-- Will have entity type information like SP, SPC, Library etic, is defined in MMDefines.h

	propertyName	NVARCHAR(256)	NOT NULL,

	propDataType	INTEGER	NOT NULL,	-- Integer, String, etc ... Also Property_enum!, is defined in MMDefines.h

	intVal			INTEGER NULL DEFAULT 0, 		-- Used to hold value for anything that will fit in it (long/short/bool etc ...

	longlongVal		BIGINT NULL DEFAULT 0, 					-- Used to hold values for 64 bit entities

	stringVal				NVARCHAR(MAX) DEFAULT '',			-- Used to hold the rest! NOT NULL

	created			INTEGER  NOT NULL,

	modified		INTEGER  NOT NULL,

	CommCellId		INTEGER DEFAULT 2	NOT NULL,	-- Will have CommCell Id



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_DlpClientPass]') )
BEGIN
	DROP TABLE #CCM_DlpClientPass
END


CREATE  TABLE   #CCM_DlpClientPass (
	id		 INTEGER NOT NULL,

	clientId 	 INTEGER	NOT NULL,

	created  	 INTEGER	NOT NULL,

	flags			 INTEGER	NOT NULL,

	passPhrase VARCHAR(256)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archIndexingAged]') )
BEGIN
	DROP TABLE #CCM_archIndexingAged
END


CREATE  TABLE   #CCM_archIndexingAged (
	currentIdxServer    integer	NOT NULL,

	archFileId			integer	NOT NULL,

	commCellId			integer	NOT NULL,

	appId				integer	NOT NULL,

	pruneTime			integer	NOT NULL,

	backupSetGUID		uniqueidentifier ROWGUIDCOL NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_App_IndexDBInfo]') )
BEGIN
	DROP TABLE #CCM_App_IndexDBInfo
END


CREATE  TABLE   #CCM_App_IndexDBInfo (
	id							INTEGER NOT NULL,

	dbName                      VARCHAR(128) NOT NULL,

	type                        INTEGER	NOT NULL,

	idxDbEngineType             INTEGER	NOT NULL,

	backupSetId                 INT	NOT NULL,

	currentIdxServer            INT	NOT NULL,

	backupSetGUID               uniqueidentifier ROWGUIDCOL NOT NULL,

	properties                  XML NULL,

	isPrimary					INT NOT NULL,

	committedTransactionId      BIGINT DEFAULT 0 NOT NULL,

	archGroupId      			INT DEFAULT 0 NOT NULL,

	flags      					INT DEFAULT 0 NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_App_IndexCheckpointInfo]') )
BEGIN
	DROP TABLE #CCM_App_IndexCheckpointInfo
END


CREATE  TABLE   #CCM_App_IndexCheckpointInfo (
	dbName                	VARCHAR(128) NOT NULL,

	backupSetGUID           uniqueidentifier ROWGUIDCOL NOT NULL,

	afileId					INT	NOT NULL,

	commcellId            	INT	NOT NULL,

	startTime				BIGINT	NOT NULL,

	endTime               	BIGINT	NOT NULL,

	flags      			  	INT DEFAULT 0 NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_GRC_History]') )
BEGIN
	DROP TABLE #CCM_GRC_History
END


CREATE  TABLE   #CCM_GRC_History (
	EntityId							integer	NOT NULL,

	EntityType							integer	NOT NULL,

	DestCCID							integer	NOT NULL,

	SourceCCId 							integer	NOT NULL,

	EntityIdOnSourceCC 					integer	NOT NULL,

	ImportJobIdOnDestCC 				integer	NOT NULL,

	ImportTime							INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDiskHWInfo]') )
BEGIN
	DROP TABLE #CCM_MMDiskHWInfo
END


CREATE  TABLE   #CCM_MMDiskHWInfo (
	diskId			INTEGER NOT NULL, 	-- PRIMARY KEY FOR THIS TABLE

	deviceId		integer	NOT NULL,

	diskSerialNum		varchar(100)	NOT NULL,

	hostId			integer	NOT NULL,

	blockSize		integer	NOT NULL,

	version			integer	NOT NULL,

	numBlocks		bigint	NOT NULL,

	flags			bigint	NOT NULL,

	deviceLocation      varchar(1024)	NOT NULL,

	deviceOSPath		varchar(1024)	NOT NULL,

	backingDevice		varchar(1024)	NOT NULL,

	blockDeviceUUID		varchar(1024)	NOT NULL,

	freeSpaceMB			bigint	NOT NULL,

	diskCapacityMB		bigint	NOT NULL,

	ErrorCode			integer	NOT NULL,

	Properties			XML default '',

	blockNumber			integer default 0	NOT NULL,

	SubVolume			varchar(64)	NOT NULL,

	Vendor				varchar(16)	NOT NULL,

	FileSystem			varchar(32)	NOT NULL,

	Product				varchar(32)	NOT NULL,

	MountOptions		varchar(1024)	NOT NULL,

	BrickFullPath		varchar(1024)	NOT NULL,

	BrickHealth			integer	NOT NULL,

	BlockDeviceHealth	integer	NOT NULL,

	mountPathUsageType	integer	NOT NULL,

	GUID 				UNIQUEIDENTIFIER DEFAULT NEWID(),



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMScaleOutMAInfo]') )
BEGIN
	DROP TABLE #CCM_MMScaleOutMAInfo
END


CREATE  TABLE   #CCM_MMScaleOutMAInfo (
	ClientId 			integer	NOT NULL,

	NetworkInformation          	XML default '',

	GlusterMetaData				varbinary(max) NOT NULL,

	HardwareInformation				XML default '',



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMSDSStoragePool]') )
BEGIN
	DROP TABLE #CCM_MMSDSStoragePool
END


CREATE  TABLE   #CCM_MMSDSStoragePool (
	StoragePoolId				INTEGER NOT NULL,

	StoragePoolName				nvarchar(512)	NOT NULL,

	LibraryId					integer	NOT NULL,

	GDSPId						integer	NOT NULL,

	DisperseFactor				integer	NOT NULL,

	RedundancyFactor			integer	NOT NULL,

	NodesPerBlock				integer	NOT NULL,

	StoragePoolEnabled			integer	NOT NULL,

	NetworkInformation			XML default '',

	Metadata					XML default '',

	StoragePoolStatus			integer NOT null default 0,

	Flags					bigint NOT null default 0,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CredentialAssoc]') )
BEGIN
	DROP TABLE #CCM_APP_CredentialAssoc
END


CREATE  TABLE   #CCM_APP_CredentialAssoc (
	assocId				INTEGER NOT NULL,

	credentialId		integer	NOT NULL,	-- foreign key to APP_CredentialRecords table

	entityType			integer	NOT NULL,

	entityId			integer	NOT NULL,

	CredAssocGUID		UNIQUEIDENTIFIER DEFAULT NEWSEQUENTIALID(),



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Credentials]') )
BEGIN
	DROP TABLE #CCM_APP_Credentials
END


CREATE  TABLE   #CCM_APP_Credentials (
	credentialId		INTEGER NOT NULL,

	credentialName		NVARCHAR(255),

	recordType			integer	NOT NULL,

	userName		    NVARCHAR(255)	NOT NULL,

	password			nvarchar(400)	NOT NULL,

	description			nvarchar(1024)	NOT NULL,

	created				INTEGER  NOT NULL,

	enabled             integer	NOT NULL,

	flags				integer	NOT NULL,

	credentialGUID		uniqueidentifier default NEWSEQUENTIALID(),

	credentialInfo		xml default '',



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchEncKeys]') )
BEGIN
	DROP TABLE #CCM_ArchEncKeys
END


CREATE  TABLE   #CCM_ArchEncKeys (
	encKeyId		INTEGER NOT NULL,

	clientId		integer	NOT NULL,

	archCopyId		smallint	NOT NULL,

	encRSA			tinyint default 0	NOT NULL,

	encKeyType		int default 0	NOT NULL,

	encKey			varchar(1024)	NOT NULL,

	isActive		tinyint default 0	NOT NULL,

	createTime		INTEGER  NOT NULL,

	expiredTime		INTEGER  NOT NULL,

	origEncKeyId	int	NOT NULL,



) 

END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errCode = ERROR_NUMBER()
	SET @o_errStr = 'Exception in creating CCM_* tables in temp db at ERROR_LINE(): '+ CAST(ERROR_LINE() as varchar(10))+' ERROR_MESSAGE(): ' + ERROR_MESSAGE()
	GOTO CX_ERROR_EXIT
END CATCH
DECLARE @xmlDoc int
EXEC sp_xml_preparedocument @xmlDoc OUTPUT, @i_CapturedDataXml
IF @@ERROR > 0
BEGIN
	SET @o_errCode = @@ERROR
	SET @o_errStr =  'ERROR: CCM_Merge_Entities_from_XML -- Failure in sp_xml_prepareddocument'
	GOTO CX_ERROR_EXIT
END
BEGIN TRY

INSERT INTO #CCM_DataPathMapping
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_DataPathMapping/row', 3)
WITH #CCM_DataPathMapping

INSERT INTO #CCM_ClientNameMapping
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_ClientNameMapping/row', 3)
WITH #CCM_ClientNameMapping

INSERT INTO #CCM_MountPathMapping
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MountPathMapping/row', 3)
WITH #CCM_MountPathMapping

INSERT INTO #CCM_ClientLicenses
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_ClientLicenses/row', 3)
WITH #CCM_ClientLicenses

INSERT INTO #CCM_IdxAccessPathMapping
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_IdxAccessPathMapping/row', 3)
WITH #CCM_IdxAccessPathMapping

INSERT INTO #CCM_VirtualClientLicenses
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_VirtualClientLicenses/row', 3)
WITH #CCM_VirtualClientLicenses

INSERT INTO #CCM_MountPathLicense
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MountPathLicense/row', 3)
WITH #CCM_MountPathLicense

INSERT INTO #CCM_DevicePathMapping
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_DevicePathMapping/row', 3)
WITH #CCM_DevicePathMapping

INSERT INTO #CCM_LibraryMapping
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_LibraryMapping/row', 3)
WITH #CCM_LibraryMapping

INSERT INTO #CCM_FeatureLicenses
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_FeatureLicenses/row', 3)
WITH #CCM_FeatureLicenses

INSERT INTO #CCM_ReformatedMedia
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_ReformatedMedia/row', 3)
WITH #CCM_ReformatedMedia

INSERT INTO #CCM_APP_CommCell
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_CommCell/row', 3)
WITH #CCM_APP_CommCell

INSERT INTO #CCM_APP_Client
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_Client/row', 3)
WITH #CCM_APP_Client

INSERT INTO #CCM_APP_ClientProp
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_ClientProp/row', 3)
WITH #CCM_APP_ClientProp

INSERT INTO #CCM_APP_VMProp
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_VMProp/row', 3)
WITH #CCM_APP_VMProp

INSERT INTO #CCM_JMQinetixUpdateStatus
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMQinetixUpdateStatus/row', 3)
WITH #CCM_JMQinetixUpdateStatus

INSERT INTO #CCM_APP_Platform
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_Platform/row', 3)
WITH #CCM_APP_Platform

INSERT INTO #CCM_APP_IDAName
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_IDAName/row', 3)
WITH #CCM_APP_IDAName

INSERT INTO #CCM_APP_IDAProp
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_IDAProp/row', 3)
WITH #CCM_APP_IDAProp

INSERT INTO #CCM_APP_DCvolInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_DCvolInfo/row', 3)
WITH #CCM_APP_DCvolInfo

INSERT INTO #CCM_APP_InstanceName
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_InstanceName/row', 3)
WITH #CCM_APP_InstanceName

INSERT INTO #CCM_APP_InstanceProp
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_InstanceProp/row', 3)
WITH #CCM_APP_InstanceProp

INSERT INTO #CCM_APP_InstFilterFile
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_InstFilterFile/row', 3)
WITH #CCM_APP_InstFilterFile

INSERT INTO #CCM_APP_BackupSetName
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_BackupSetName/row', 3)
WITH #CCM_APP_BackupSetName

INSERT INTO #CCM_APP_BackupSetProp
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_BackupSetProp/row', 3)
WITH #CCM_APP_BackupSetProp

INSERT INTO #CCM_APP_BackupSetFilterFile
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_BackupSetFilterFile/row', 3)
WITH #CCM_APP_BackupSetFilterFile

INSERT INTO #CCM_APP_Application
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_Application/row', 3)
WITH #CCM_APP_Application

INSERT INTO #CCM_APP_SubClientProp
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_SubClientProp/row', 3)
WITH #CCM_APP_SubClientProp

INSERT INTO #CCM_APP_ComponentProp
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_ComponentProp/row', 3)
WITH #CCM_APP_ComponentProp

INSERT INTO #CCM_APP_ScFilterFile
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_ScFilterFile/row', 3)
WITH #CCM_APP_ScFilterFile

INSERT INTO #CCM_APP_VMToPMMap
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_VMToPMMap/row', 3)
WITH #CCM_APP_VMToPMMap

INSERT INTO #CCM_APP_VMBackupSet
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_VMBackupSet/row', 3)
WITH #CCM_APP_VMBackupSet

INSERT INTO #CCM_simClientAppsV2
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_simClientAppsV2/row', 3)
WITH #CCM_simClientAppsV2

INSERT INTO #CCM_simAllGalaxyRel
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_simAllGalaxyRel/row', 3)
WITH #CCM_simAllGalaxyRel

INSERT INTO #CCM_PatchDBSPInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_PatchDBSPInfo/row', 3)
WITH #CCM_PatchDBSPInfo

INSERT INTO #CCM_simInstalledPackages
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_simInstalledPackages/row', 3)
WITH #CCM_simInstalledPackages

INSERT INTO #CCM_simInstalledPackagesHistory
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_simInstalledPackagesHistory/row', 3)
WITH #CCM_simInstalledPackagesHistory

INSERT INTO #CCM_simXMLRequest
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_simXMLRequest/row', 3)
WITH #CCM_simXMLRequest

INSERT INTO #CCM_APP_CustomCalendar
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_CustomCalendar/row', 3)
WITH #CCM_APP_CustomCalendar

INSERT INTO #CCM_APP_CustomCalendarMonths
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_CustomCalendarMonths/row', 3)
WITH #CCM_APP_CustomCalendarMonths

INSERT INTO #CCM_APP_OracleRacInstance
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_OracleRacInstance/row', 3)
WITH #CCM_APP_OracleRacInstance

INSERT INTO #CCM_APP_ExtendedProperties
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_ExtendedProperties/row', 3)
WITH #CCM_APP_ExtendedProperties

INSERT INTO #CCM_APP_ClientGroup
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_ClientGroup/row', 3)
WITH #CCM_APP_ClientGroup

INSERT INTO #CCM_SchedHoliday
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_SchedHoliday/row', 3)
WITH #CCM_SchedHoliday

INSERT INTO #CCM_APP_OpWindowRule
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_OpWindowRule/row', 3)
WITH #CCM_APP_OpWindowRule

INSERT INTO #CCM_APP_MongoDbSCPriority
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_MongoDbSCPriority/row', 3)
WITH #CCM_APP_MongoDbSCPriority

INSERT INTO #CCM_archGroup
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archGroup/row', 3)
WITH #CCM_archGroup

INSERT INTO #CCM_archGroupCopy
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archGroupCopy/row', 3)
WITH #CCM_archGroupCopy

INSERT INTO #CCM_archCopyMediaRefreshProp
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archCopyMediaRefreshProp/row', 3)
WITH #CCM_archCopyMediaRefreshProp

INSERT INTO #CCM_archCopyToGlobalPolicy
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archCopyToGlobalPolicy/row', 3)
WITH #CCM_archCopyToGlobalPolicy

INSERT INTO #CCM_archStream
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archStream/row', 3)
WITH #CCM_archStream

INSERT INTO #CCM_archAgingRule
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archAgingRule/row', 3)
WITH #CCM_archAgingRule

INSERT INTO #CCM_archAgingRuleExtended
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archAgingRuleExtended/row', 3)
WITH #CCM_archAgingRuleExtended

INSERT INTO #CCM_archAppCopyAgingRule
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archAppCopyAgingRule/row', 3)
WITH #CCM_archAppCopyAgingRule

INSERT INTO #CCM_archAppCopyAgingRuleExtended
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archAppCopyAgingRuleExtended/row', 3)
WITH #CCM_archAppCopyAgingRuleExtended

INSERT INTO #CCM_archSelectiveCopy
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archSelectiveCopy/row', 3)
WITH #CCM_archSelectiveCopy

INSERT INTO #CCM_archCopyToApp
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archCopyToApp/row', 3)
WITH #CCM_archCopyToApp

INSERT INTO #CCM_archCopySIDBStore
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archCopySIDBStore/row', 3)
WITH #CCM_archCopySIDBStore

INSERT INTO #CCM_ArchEncKeyProvider
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_ArchEncKeyProvider/row', 3)
WITH #CCM_ArchEncKeyProvider

INSERT INTO #CCM_ArchEncKeyProviderAssoc
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_ArchEncKeyProviderAssoc/row', 3)
WITH #CCM_ArchEncKeyProviderAssoc

INSERT INTO #CCM_ArchCopyEncProperties
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_ArchCopyEncProperties/row', 3)
WITH #CCM_ArchCopyEncProperties

INSERT INTO #CCM_archPipeConfig
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archPipeConfig/row', 3)
WITH #CCM_archPipeConfig

INSERT INTO #CCM_archFile
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archFile/row', 3)
WITH #CCM_archFile

INSERT INTO #CCM_archFileOracle
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archFileOracle/row', 3)
WITH #CCM_archFileOracle

INSERT INTO #CCM_archFileOracleBackupPiece
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archFileOracleBackupPiece/row', 3)
WITH #CCM_archFileOracleBackupPiece

INSERT INTO #CCM_archFileCopy
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archFileCopy/row', 3)
WITH #CCM_archFileCopy

INSERT INTO #CCM_archChunk
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archChunk/row', 3)
WITH #CCM_archChunk

INSERT INTO #CCM_archChunkMapping
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archChunkMapping/row', 3)
WITH #CCM_archChunkMapping

INSERT INTO #CCM_archDB2Log
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archDB2Log/row', 3)
WITH #CCM_archDB2Log

INSERT INTO #CCM_archCheckHistory
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archCheckHistory/row', 3)
WITH #CCM_archCheckHistory

INSERT INTO #CCM_archFileSiloVolume
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archFileSiloVolume/row', 3)
WITH #CCM_archFileSiloVolume

INSERT INTO #CCM_archChunkToSilo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archChunkToSilo/row', 3)
WITH #CCM_archChunkToSilo

INSERT INTO #CCM_archFailedKilledJobInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archFailedKilledJobInfo/row', 3)
WITH #CCM_archFailedKilledJobInfo

INSERT INTO #CCM_JMJobStats
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMJobStats/row', 3)
WITH #CCM_JMJobStats

INSERT INTO #CCM_JMJobAction
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMJobAction/row', 3)
WITH #CCM_JMJobAction

INSERT INTO #CCM_JMBkpStats
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMBkpStats/row', 3)
WITH #CCM_JMBkpStats

INSERT INTO #CCM_JMBkpAtmptStats
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMBkpAtmptStats/row', 3)
WITH #CCM_JMBkpAtmptStats

INSERT INTO #CCM_JMAdminJobStatsTable
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMAdminJobStatsTable/row', 3)
WITH #CCM_JMAdminJobStatsTable

INSERT INTO #CCM_JMAdminJobAttemptStatsTable
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMAdminJobAttemptStatsTable/row', 3)
WITH #CCM_JMAdminJobAttemptStatsTable

INSERT INTO #CCM_JMJobDataLink
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMJobDataLink/row', 3)
WITH #CCM_JMJobDataLink

INSERT INTO #CCM_JMJobOptions
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMJobOptions/row', 3)
WITH #CCM_JMJobOptions

INSERT INTO #CCM_JMJobDataStats
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMJobDataStats/row', 3)
WITH #CCM_JMJobDataStats

INSERT INTO #CCM_JMOracleRACClientsUsed
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMOracleRACClientsUsed/row', 3)
WITH #CCM_JMOracleRACClientsUsed

INSERT INTO #CCM_JMJobInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMJobInfo/row', 3)
WITH #CCM_JMJobInfo

INSERT INTO #CCM_JMAdminJobInfoTable
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMAdminJobInfoTable/row', 3)
WITH #CCM_JMAdminJobInfoTable

INSERT INTO #CCM_JMBkpJobInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMBkpJobInfo/row', 3)
WITH #CCM_JMBkpJobInfo

INSERT INTO #CCM_JMJobSnapshotStats
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMJobSnapshotStats/row', 3)
WITH #CCM_JMJobSnapshotStats

INSERT INTO #CCM_GRCJMJobDataStatsTracking
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_GRCJMJobDataStatsTracking/row', 3)
WITH #CCM_GRCJMJobDataStatsTracking

INSERT INTO #CCM_JMFailureReasonMsg
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMFailureReasonMsg/row', 3)
WITH #CCM_JMFailureReasonMsg

INSERT INTO #CCM_JMFailureReasonMsgParam
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_JMFailureReasonMsgParam/row', 3)
WITH #CCM_JMFailureReasonMsgParam

INSERT INTO #CCM_evMsg
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_evMsg/row', 3)
WITH #CCM_evMsg

INSERT INTO #CCM_evParam
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_evParam/row', 3)
WITH #CCM_evParam

INSERT INTO #CCM_MMExportLocation
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMExportLocation/row', 3)
WITH #CCM_MMExportLocation

INSERT INTO #CCM_MMMedia
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMMedia/row', 3)
WITH #CCM_MMMedia

INSERT INTO #CCM_MMMediaSide
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMMediaSide/row', 3)
WITH #CCM_MMMediaSide

INSERT INTO #CCM_MMVolume
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMVolume/row', 3)
WITH #CCM_MMVolume

INSERT INTO #CCM_MMMediaGroup
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMMediaGroup/row', 3)
WITH #CCM_MMMediaGroup

INSERT INTO #CCM_MMMountPath
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMMountPath/row', 3)
WITH #CCM_MMMountPath

INSERT INTO #CCM_MMDevice
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMDevice/row', 3)
WITH #CCM_MMDevice

INSERT INTO #CCM_MMDeviceController
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMDeviceController/row', 3)
WITH #CCM_MMDeviceController

INSERT INTO #CCM_MMMountPathToStorageDevice
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMMountPathToStorageDevice/row', 3)
WITH #CCM_MMMountPathToStorageDevice

INSERT INTO #CCM_MMNDMPHostInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMNDMPHostInfo/row', 3)
WITH #CCM_MMNDMPHostInfo

INSERT INTO #CCM_MMContainer
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMContainer/row', 3)
WITH #CCM_MMContainer

INSERT INTO #CCM_MMCenteraInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMCenteraInfo/row', 3)
WITH #CCM_MMCenteraInfo

INSERT INTO #CCM_MMCenteraAccessNode
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMCenteraAccessNode/row', 3)
WITH #CCM_MMCenteraAccessNode

INSERT INTO #CCM_MMHost
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMHost/row', 3)
WITH #CCM_MMHost

INSERT INTO #CCM_IdxAccessPath
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_IdxAccessPath/row', 3)
WITH #CCM_IdxAccessPath

INSERT INTO #CCM_MMLibrary
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMLibrary/row', 3)
WITH #CCM_MMLibrary

INSERT INTO #CCM_MMMasterPool
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMMasterPool/row', 3)
WITH #CCM_MMMasterPool

INSERT INTO #CCM_MMDrivePool
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMDrivePool/row', 3)
WITH #CCM_MMDrivePool

INSERT INTO #CCM_MMLibraryController
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMLibraryController/row', 3)
WITH #CCM_MMLibraryController

INSERT INTO #CCM_sqlVersion
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlVersion/row', 3)
WITH #CCM_sqlVersion

INSERT INTO #CCM_sqlServer
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlServer/row', 3)
WITH #CCM_sqlServer

INSERT INTO #CCM_sqlDatabase
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlDatabase/row', 3)
WITH #CCM_sqlDatabase

INSERT INTO #CCM_sqlFileGroup
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlFileGroup/row', 3)
WITH #CCM_sqlFileGroup

INSERT INTO #CCM_sqlFile
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlFile/row', 3)
WITH #CCM_sqlFile

INSERT INTO #CCM_sqlBackupSet
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlBackupSet/row', 3)
WITH #CCM_sqlBackupSet

INSERT INTO #CCM_sqlLSNs
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlLSNs/row', 3)
WITH #CCM_sqlLSNs

INSERT INTO #CCM_sqlArchiveSet
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlArchiveSet/row', 3)
WITH #CCM_sqlArchiveSet

INSERT INTO #CCM_sqlBackupFile
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlBackupFile/row', 3)
WITH #CCM_sqlBackupFile

INSERT INTO #CCM_sqlFileSubClient
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlFileSubClient/row', 3)
WITH #CCM_sqlFileSubClient

INSERT INTO #CCM_sqlFileSubClientGroup
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlFileSubClientGroup/row', 3)
WITH #CCM_sqlFileSubClientGroup

INSERT INTO #CCM_sqlLogMarkNames
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlLogMarkNames/row', 3)
WITH #CCM_sqlLogMarkNames

INSERT INTO #CCM_sqlNames
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlNames/row', 3)
WITH #CCM_sqlNames

INSERT INTO #CCM_sqlNames2
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlNames2/row', 3)
WITH #CCM_sqlNames2

INSERT INTO #CCM_sqlDbBackupInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlDbBackupInfo/row', 3)
WITH #CCM_sqlDbBackupInfo

INSERT INTO #CCM_sqlArchiveInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlArchiveInfo/row', 3)
WITH #CCM_sqlArchiveInfo

INSERT INTO #CCM_sqlFileBackupInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlFileBackupInfo/row', 3)
WITH #CCM_sqlFileBackupInfo

INSERT INTO #CCM_sqlLogMarks
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sqlLogMarks/row', 3)
WITH #CCM_sqlLogMarks

INSERT INTO #CCM_oracleDataFiles
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_oracleDataFiles/row', 3)
WITH #CCM_oracleDataFiles

INSERT INTO #CCM_oracleTableSpaces
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_oracleTableSpaces/row', 3)
WITH #CCM_oracleTableSpaces

INSERT INTO #CCM_oracleObjects
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_oracleObjects/row', 3)
WITH #CCM_oracleObjects

INSERT INTO #CCM_OraclePluggableDBs
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_OraclePluggableDBs/row', 3)
WITH #CCM_OraclePluggableDBs

INSERT INTO #CCM_sybArchFileInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sybArchFileInfo/row', 3)
WITH #CCM_sybArchFileInfo

INSERT INTO #CCM_sybTransLog
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sybTransLog/row', 3)
WITH #CCM_sybTransLog

INSERT INTO #CCM_sybSystemDevices
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sybSystemDevices/row', 3)
WITH #CCM_sybSystemDevices

INSERT INTO #CCM_sybSystemUsages
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_sybSystemUsages/row', 3)
WITH #CCM_sybSystemUsages

INSERT INTO #CCM_LicUsage
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_LicUsage/row', 3)
WITH #CCM_LicUsage

INSERT INTO #CCM_LicUsageHistory
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_LicUsageHistory/row', 3)
WITH #CCM_LicUsageHistory

INSERT INTO #CCM_LicAal
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_LicAal/row', 3)
WITH #CCM_LicAal

INSERT INTO #CCM_IdxSIDBStore
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_IdxSIDBStore/row', 3)
WITH #CCM_IdxSIDBStore

INSERT INTO #CCM_IdxSIDBSubStore
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_IdxSIDBSubStore/row', 3)
WITH #CCM_IdxSIDBSubStore

INSERT INTO #CCM_GXGlobalParam
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_GXGlobalParam/row', 3)
WITH #CCM_GXGlobalParam

INSERT INTO #CCM_TM_Pattern
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_TM_Pattern/row', 3)
WITH #CCM_TM_Pattern

INSERT INTO #CCM_TM_PatternAssoc
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_TM_PatternAssoc/row', 3)
WITH #CCM_TM_PatternAssoc

INSERT INTO #CCM_TM_SubTask
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_TM_SubTask/row', 3)
WITH #CCM_TM_SubTask

INSERT INTO #CCM_TM_AssocEntity
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_TM_AssocEntity/row', 3)
WITH #CCM_TM_AssocEntity

INSERT INTO #CCM_TM_Task
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_TM_Task/row', 3)
WITH #CCM_TM_Task

INSERT INTO #CCM_SMVolume
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_SMVolume/row', 3)
WITH #CCM_SMVolume

INSERT INTO #CCM_SMVolSnapMap
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_SMVolSnapMap/row', 3)
WITH #CCM_SMVolSnapMap

INSERT INTO #CCM_SMMetaData
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_SMMetaData/row', 3)
WITH #CCM_SMMetaData

INSERT INTO #CCM_SMSnap
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_SMSnap/row', 3)
WITH #CCM_SMSnap

INSERT INTO #CCM_SMControlHost
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_SMControlHost/row', 3)
WITH #CCM_SMControlHost

INSERT INTO #CCM_UMDSProviders
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMDSProviders/row', 3)
WITH #CCM_UMDSProviders

INSERT INTO #CCM_UMDSgroups
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMDSgroups/row', 3)
WITH #CCM_UMDSgroups

INSERT INTO #CCM_UMGroups
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMGroups/row', 3)
WITH #CCM_UMGroups

INSERT INTO #CCM_UMDSGroupMaps
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMDSGroupMaps/row', 3)
WITH #CCM_UMDSGroupMaps

INSERT INTO #CCM_UMUsers
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMUsers/row', 3)
WITH #CCM_UMUsers

INSERT INTO #CCM_UMUserGroup
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMUserGroup/row', 3)
WITH #CCM_UMUserGroup

INSERT INTO #CCM_UMUserPrefs
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMUserPrefs/row', 3)
WITH #CCM_UMUserPrefs

INSERT INTO #CCM_UMDSUserGroup
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMDSUserGroup/row', 3)
WITH #CCM_UMDSUserGroup

INSERT INTO #CCM_UMRoles
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMRoles/row', 3)
WITH #CCM_UMRoles

INSERT INTO #CCM_UMRolesPermissions
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMRolesPermissions/row', 3)
WITH #CCM_UMRolesPermissions

INSERT INTO #CCM_UMRolesWithPermissionsExpanded
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMRolesWithPermissionsExpanded/row', 3)
WITH #CCM_UMRolesWithPermissionsExpanded

INSERT INTO #CCM_UMOwners
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMOwners/row', 3)
WITH #CCM_UMOwners

INSERT INTO #CCM_UMOwnerRoles
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMOwnerRoles/row', 3)
WITH #CCM_UMOwnerRoles

INSERT INTO #CCM_UMSecurityAssociations
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_UMSecurityAssociations/row', 3)
WITH #CCM_UMSecurityAssociations

INSERT INTO #CCM_edcJobIdMap
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_edcJobIdMap/row', 3)
WITH #CCM_edcJobIdMap

INSERT INTO #CCM_edcClientNameMap
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_edcClientNameMap/row', 3)
WITH #CCM_edcClientNameMap

INSERT INTO #CCM_archMaterializeSnapshotProp
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archMaterializeSnapshotProp/row', 3)
WITH #CCM_archMaterializeSnapshotProp

INSERT INTO #CCM_PatchUpdateAgentInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_PatchUpdateAgentInfo/row', 3)
WITH #CCM_PatchUpdateAgentInfo

INSERT INTO #CCM_PatchMultiCache
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_PatchMultiCache/row', 3)
WITH #CCM_PatchMultiCache

INSERT INTO #CCM_CCRCommCellReadiness
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_CCRCommCellReadiness/row', 3)
WITH #CCM_CCRCommCellReadiness

INSERT INTO #CCM_CCRToSubClient
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_CCRToSubClient/row', 3)
WITH #CCM_CCRToSubClient

INSERT INTO #CCM_CCRClientToClient
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_CCRClientToClient/row', 3)
WITH #CCM_CCRClientToClient

INSERT INTO #CCM_archFileCopyDedup
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archFileCopyDedup/row', 3)
WITH #CCM_archFileCopyDedup

INSERT INTO #CCM_archFileSIDBKeys
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archFileSIDBKeys/row', 3)
WITH #CCM_archFileSIDBKeys

INSERT INTO #CCM_MMEntityProp
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMEntityProp/row', 3)
WITH #CCM_MMEntityProp

INSERT INTO #CCM_DlpClientPass
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_DlpClientPass/row', 3)
WITH #CCM_DlpClientPass

INSERT INTO #CCM_archIndexingAged
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_archIndexingAged/row', 3)
WITH #CCM_archIndexingAged

INSERT INTO #CCM_App_IndexDBInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_App_IndexDBInfo/row', 3)
WITH #CCM_App_IndexDBInfo

INSERT INTO #CCM_App_IndexCheckpointInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_App_IndexCheckpointInfo/row', 3)
WITH #CCM_App_IndexCheckpointInfo

INSERT INTO #CCM_GRC_History
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_GRC_History/row', 3)
WITH #CCM_GRC_History

INSERT INTO #CCM_MMDiskHWInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMDiskHWInfo/row', 3)
WITH #CCM_MMDiskHWInfo

INSERT INTO #CCM_MMScaleOutMAInfo
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMScaleOutMAInfo/row', 3)
WITH #CCM_MMScaleOutMAInfo

INSERT INTO #CCM_MMSDSStoragePool
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_MMSDSStoragePool/row', 3)
WITH #CCM_MMSDSStoragePool

INSERT INTO #CCM_APP_CredentialAssoc
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_CredentialAssoc/row', 3)
WITH #CCM_APP_CredentialAssoc

INSERT INTO #CCM_APP_Credentials
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_APP_Credentials/row', 3)
WITH #CCM_APP_Credentials

INSERT INTO #CCM_ArchEncKeys
SELECT * FROM
OPENXML (@xmlDoc,'/CaptureResponse/CapturedData/CCM_ArchEncKeys/row', 3)
WITH #CCM_ArchEncKeys


END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errCode = ERROR_NUMBER()
	SET @o_errStr = 'Exception in inserting into CCM_* tables from XML at ERROR_LINE(): '+ CAST(ERROR_LINE() as varchar(10))+' ERROR_MESSAGE(): ' + ERROR_MESSAGE()
	GOTO CX_ERROR_EXIT
END CATCH
EXEC sp_xml_removedocument @xmlDoc
IF OBJECT_ID('tempdb.dbo.#TempReadQuestionsResultSet') IS NOT NULL DROP TABLE #TempReadQuestionsResultSet
CREATE TABLE #TempReadQuestionsResultSet (errCode int, errStr varchar(1024))
EXEC CCM_Merge_Read_Questions_From_XML 0
SET @o_errCode = (SELECT TOP 1 errCode FROM #TempReadQuestionsResultSet)
IF @o_errCode <> 0
BEGIN
	SET @o_errStr = 'ERROR: CCM_Merge_Entities_from_XML -- CCM_Merge_Read_Questions failed - ' + ISNULL((SELECT TOP 1 errStr FROM #TempReadQuestionsResultSet), 'UNKNOWN ERROR')
	GOTO CX_ERROR_EXIT
END
IF OBJECT_ID('tempdb.dbo.#TempReadQuestionsResultSet') IS NOT NULL DROP TABLE #TempReadQuestionsResultSet
IF OBJECT_ID('tempdb.dbo.#TempMergeMainResultSet') IS NOT NULL DROP TABLE #TempMergeMainResultSet
CREATE TABLE #TempMergeMainResultSet (errCode int, errStr varchar(1024))
EXEC CCM_Merge_Main_from_XML 0,0,0,0,0,@i_flags,0,0,@i_mergeTimeStamp
SET @o_errCode = (SELECT TOP 1 errCode FROM #TempMergeMainResultSet)
IF @o_errCode <> 0
BEGIN
	SET @o_errStr = 'ERROR: CCM_Merge_Entities_from_XML -- CCM_Merge_Main failed - ' + ISNULL((SELECT TOP 1 errStr FROM #TempMergeMainResultSet), 'UNKNOWN ERROR')
	GOTO CX_ERROR_EXIT
END
IF OBJECT_ID('tempdb.dbo.#TempMergeMainResultSet') IS NOT NULL DROP TABLE #TempMergeMainResultSet
BEGIN TRY
--Macro CCM_DROP_TEMP_TABLES_ALL will be replaced with 'drop table #CCM_*' statements by DB_SQL project while building the .sql from .sp

IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_DataPathMapping]') )
BEGIN
	DROP TABLE #CCM_DataPathMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ClientNameMapping]') )
BEGIN
	DROP TABLE #CCM_ClientNameMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MountPathMapping]') )
BEGIN
	DROP TABLE #CCM_MountPathMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ClientLicenses]') )
BEGIN
	DROP TABLE #CCM_ClientLicenses
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxAccessPathMapping]') )
BEGIN
	DROP TABLE #CCM_IdxAccessPathMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_VirtualClientLicenses]') )
BEGIN
	DROP TABLE #CCM_VirtualClientLicenses
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MountPathLicense]') )
BEGIN
	DROP TABLE #CCM_MountPathLicense
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_DevicePathMapping]') )
BEGIN
	DROP TABLE #CCM_DevicePathMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LibraryMapping]') )
BEGIN
	DROP TABLE #CCM_LibraryMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_FeatureLicenses]') )
BEGIN
	DROP TABLE #CCM_FeatureLicenses
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ReformatedMedia]') )
BEGIN
	DROP TABLE #CCM_ReformatedMedia
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CommCell]') )
BEGIN
	DROP TABLE #CCM_APP_CommCell
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Client]') )
BEGIN
	DROP TABLE #CCM_APP_Client
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ClientProp]') )
BEGIN
	DROP TABLE #CCM_APP_ClientProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_VMProp]') )
BEGIN
	DROP TABLE #CCM_APP_VMProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMQinetixUpdateStatus]') )
BEGIN
	DROP TABLE #CCM_JMQinetixUpdateStatus
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Platform]') )
BEGIN
	DROP TABLE #CCM_APP_Platform
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_IDAName]') )
BEGIN
	DROP TABLE #CCM_APP_IDAName
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_IDAProp]') )
BEGIN
	DROP TABLE #CCM_APP_IDAProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_DCvolInfo]') )
BEGIN
	DROP TABLE #CCM_APP_DCvolInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_InstanceName]') )
BEGIN
	DROP TABLE #CCM_APP_InstanceName
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_InstanceProp]') )
BEGIN
	DROP TABLE #CCM_APP_InstanceProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_InstFilterFile]') )
BEGIN
	DROP TABLE #CCM_APP_InstFilterFile
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_BackupSetName]') )
BEGIN
	DROP TABLE #CCM_APP_BackupSetName
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_BackupSetProp]') )
BEGIN
	DROP TABLE #CCM_APP_BackupSetProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_BackupSetFilterFile]') )
BEGIN
	DROP TABLE #CCM_APP_BackupSetFilterFile
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Application]') )
BEGIN
	DROP TABLE #CCM_APP_Application
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_SubClientProp]') )
BEGIN
	DROP TABLE #CCM_APP_SubClientProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ComponentProp]') )
BEGIN
	DROP TABLE #CCM_APP_ComponentProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ScFilterFile]') )
BEGIN
	DROP TABLE #CCM_APP_ScFilterFile
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_VMToPMMap]') )
BEGIN
	DROP TABLE #CCM_APP_VMToPMMap
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_VMBackupSet]') )
BEGIN
	DROP TABLE #CCM_APP_VMBackupSet
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simClientAppsV2]') )
BEGIN
	DROP TABLE #CCM_simClientAppsV2
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simAllGalaxyRel]') )
BEGIN
	DROP TABLE #CCM_simAllGalaxyRel
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_PatchDBSPInfo]') )
BEGIN
	DROP TABLE #CCM_PatchDBSPInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simInstalledPackages]') )
BEGIN
	DROP TABLE #CCM_simInstalledPackages
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simInstalledPackagesHistory]') )
BEGIN
	DROP TABLE #CCM_simInstalledPackagesHistory
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simXMLRequest]') )
BEGIN
	DROP TABLE #CCM_simXMLRequest
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CustomCalendar]') )
BEGIN
	DROP TABLE #CCM_APP_CustomCalendar
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CustomCalendarMonths]') )
BEGIN
	DROP TABLE #CCM_APP_CustomCalendarMonths
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_OracleRacInstance]') )
BEGIN
	DROP TABLE #CCM_APP_OracleRacInstance
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ExtendedProperties]') )
BEGIN
	DROP TABLE #CCM_APP_ExtendedProperties
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ClientGroup]') )
BEGIN
	DROP TABLE #CCM_APP_ClientGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SchedHoliday]') )
BEGIN
	DROP TABLE #CCM_SchedHoliday
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_OpWindowRule]') )
BEGIN
	DROP TABLE #CCM_APP_OpWindowRule
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_MongoDbSCPriority]') )
BEGIN
	DROP TABLE #CCM_APP_MongoDbSCPriority
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archGroup]') )
BEGIN
	DROP TABLE #CCM_archGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archGroupCopy]') )
BEGIN
	DROP TABLE #CCM_archGroupCopy
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopyMediaRefreshProp]') )
BEGIN
	DROP TABLE #CCM_archCopyMediaRefreshProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopyToGlobalPolicy]') )
BEGIN
	DROP TABLE #CCM_archCopyToGlobalPolicy
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archStream]') )
BEGIN
	DROP TABLE #CCM_archStream
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAgingRule]') )
BEGIN
	DROP TABLE #CCM_archAgingRule
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAgingRuleExtended]') )
BEGIN
	DROP TABLE #CCM_archAgingRuleExtended
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAppCopyAgingRule]') )
BEGIN
	DROP TABLE #CCM_archAppCopyAgingRule
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAppCopyAgingRuleExtended]') )
BEGIN
	DROP TABLE #CCM_archAppCopyAgingRuleExtended
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archSelectiveCopy]') )
BEGIN
	DROP TABLE #CCM_archSelectiveCopy
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopyToApp]') )
BEGIN
	DROP TABLE #CCM_archCopyToApp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopySIDBStore]') )
BEGIN
	DROP TABLE #CCM_archCopySIDBStore
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchEncKeyProvider]') )
BEGIN
	DROP TABLE #CCM_ArchEncKeyProvider
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchEncKeyProviderAssoc]') )
BEGIN
	DROP TABLE #CCM_ArchEncKeyProviderAssoc
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchCopyEncProperties]') )
BEGIN
	DROP TABLE #CCM_ArchCopyEncProperties
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archPipeConfig]') )
BEGIN
	DROP TABLE #CCM_archPipeConfig
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFile]') )
BEGIN
	DROP TABLE #CCM_archFile
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileOracle]') )
BEGIN
	DROP TABLE #CCM_archFileOracle
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileOracleBackupPiece]') )
BEGIN
	DROP TABLE #CCM_archFileOracleBackupPiece
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileCopy]') )
BEGIN
	DROP TABLE #CCM_archFileCopy
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archChunk]') )
BEGIN
	DROP TABLE #CCM_archChunk
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archChunkMapping]') )
BEGIN
	DROP TABLE #CCM_archChunkMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archDB2Log]') )
BEGIN
	DROP TABLE #CCM_archDB2Log
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCheckHistory]') )
BEGIN
	DROP TABLE #CCM_archCheckHistory
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileSiloVolume]') )
BEGIN
	DROP TABLE #CCM_archFileSiloVolume
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archChunkToSilo]') )
BEGIN
	DROP TABLE #CCM_archChunkToSilo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFailedKilledJobInfo]') )
BEGIN
	DROP TABLE #CCM_archFailedKilledJobInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobStats]') )
BEGIN
	DROP TABLE #CCM_JMJobStats
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobAction]') )
BEGIN
	DROP TABLE #CCM_JMJobAction
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMBkpStats]') )
BEGIN
	DROP TABLE #CCM_JMBkpStats
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMBkpAtmptStats]') )
BEGIN
	DROP TABLE #CCM_JMBkpAtmptStats
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMAdminJobStatsTable]') )
BEGIN
	DROP TABLE #CCM_JMAdminJobStatsTable
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMAdminJobAttemptStatsTable]') )
BEGIN
	DROP TABLE #CCM_JMAdminJobAttemptStatsTable
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobDataLink]') )
BEGIN
	DROP TABLE #CCM_JMJobDataLink
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobOptions]') )
BEGIN
	DROP TABLE #CCM_JMJobOptions
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobDataStats]') )
BEGIN
	DROP TABLE #CCM_JMJobDataStats
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMOracleRACClientsUsed]') )
BEGIN
	DROP TABLE #CCM_JMOracleRACClientsUsed
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobInfo]') )
BEGIN
	DROP TABLE #CCM_JMJobInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMAdminJobInfoTable]') )
BEGIN
	DROP TABLE #CCM_JMAdminJobInfoTable
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMBkpJobInfo]') )
BEGIN
	DROP TABLE #CCM_JMBkpJobInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobSnapshotStats]') )
BEGIN
	DROP TABLE #CCM_JMJobSnapshotStats
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_GRCJMJobDataStatsTracking]') )
BEGIN
	DROP TABLE #CCM_GRCJMJobDataStatsTracking
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMFailureReasonMsg]') )
BEGIN
	DROP TABLE #CCM_JMFailureReasonMsg
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMFailureReasonMsgParam]') )
BEGIN
	DROP TABLE #CCM_JMFailureReasonMsgParam
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_evMsg]') )
BEGIN
	DROP TABLE #CCM_evMsg
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_evParam]') )
BEGIN
	DROP TABLE #CCM_evParam
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMExportLocation]') )
BEGIN
	DROP TABLE #CCM_MMExportLocation
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMedia]') )
BEGIN
	DROP TABLE #CCM_MMMedia
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMediaSide]') )
BEGIN
	DROP TABLE #CCM_MMMediaSide
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMVolume]') )
BEGIN
	DROP TABLE #CCM_MMVolume
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMediaGroup]') )
BEGIN
	DROP TABLE #CCM_MMMediaGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMountPath]') )
BEGIN
	DROP TABLE #CCM_MMMountPath
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDevice]') )
BEGIN
	DROP TABLE #CCM_MMDevice
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDeviceController]') )
BEGIN
	DROP TABLE #CCM_MMDeviceController
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMountPathToStorageDevice]') )
BEGIN
	DROP TABLE #CCM_MMMountPathToStorageDevice
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMNDMPHostInfo]') )
BEGIN
	DROP TABLE #CCM_MMNDMPHostInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMContainer]') )
BEGIN
	DROP TABLE #CCM_MMContainer
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMCenteraInfo]') )
BEGIN
	DROP TABLE #CCM_MMCenteraInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMCenteraAccessNode]') )
BEGIN
	DROP TABLE #CCM_MMCenteraAccessNode
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMHost]') )
BEGIN
	DROP TABLE #CCM_MMHost
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxAccessPath]') )
BEGIN
	DROP TABLE #CCM_IdxAccessPath
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMLibrary]') )
BEGIN
	DROP TABLE #CCM_MMLibrary
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMasterPool]') )
BEGIN
	DROP TABLE #CCM_MMMasterPool
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDrivePool]') )
BEGIN
	DROP TABLE #CCM_MMDrivePool
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMLibraryController]') )
BEGIN
	DROP TABLE #CCM_MMLibraryController
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlVersion]') )
BEGIN
	DROP TABLE #CCM_sqlVersion
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlServer]') )
BEGIN
	DROP TABLE #CCM_sqlServer
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlDatabase]') )
BEGIN
	DROP TABLE #CCM_sqlDatabase
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileGroup]') )
BEGIN
	DROP TABLE #CCM_sqlFileGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFile]') )
BEGIN
	DROP TABLE #CCM_sqlFile
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlBackupSet]') )
BEGIN
	DROP TABLE #CCM_sqlBackupSet
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlLSNs]') )
BEGIN
	DROP TABLE #CCM_sqlLSNs
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlArchiveSet]') )
BEGIN
	DROP TABLE #CCM_sqlArchiveSet
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlBackupFile]') )
BEGIN
	DROP TABLE #CCM_sqlBackupFile
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileSubClient]') )
BEGIN
	DROP TABLE #CCM_sqlFileSubClient
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileSubClientGroup]') )
BEGIN
	DROP TABLE #CCM_sqlFileSubClientGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlLogMarkNames]') )
BEGIN
	DROP TABLE #CCM_sqlLogMarkNames
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlNames]') )
BEGIN
	DROP TABLE #CCM_sqlNames
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlNames2]') )
BEGIN
	DROP TABLE #CCM_sqlNames2
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlDbBackupInfo]') )
BEGIN
	DROP TABLE #CCM_sqlDbBackupInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlArchiveInfo]') )
BEGIN
	DROP TABLE #CCM_sqlArchiveInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileBackupInfo]') )
BEGIN
	DROP TABLE #CCM_sqlFileBackupInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlLogMarks]') )
BEGIN
	DROP TABLE #CCM_sqlLogMarks
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_oracleDataFiles]') )
BEGIN
	DROP TABLE #CCM_oracleDataFiles
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_oracleTableSpaces]') )
BEGIN
	DROP TABLE #CCM_oracleTableSpaces
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_oracleObjects]') )
BEGIN
	DROP TABLE #CCM_oracleObjects
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_OraclePluggableDBs]') )
BEGIN
	DROP TABLE #CCM_OraclePluggableDBs
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybArchFileInfo]') )
BEGIN
	DROP TABLE #CCM_sybArchFileInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybTransLog]') )
BEGIN
	DROP TABLE #CCM_sybTransLog
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybSystemDevices]') )
BEGIN
	DROP TABLE #CCM_sybSystemDevices
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybSystemUsages]') )
BEGIN
	DROP TABLE #CCM_sybSystemUsages
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LicUsage]') )
BEGIN
	DROP TABLE #CCM_LicUsage
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LicUsageHistory]') )
BEGIN
	DROP TABLE #CCM_LicUsageHistory
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LicAal]') )
BEGIN
	DROP TABLE #CCM_LicAal
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxSIDBStore]') )
BEGIN
	DROP TABLE #CCM_IdxSIDBStore
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxSIDBSubStore]') )
BEGIN
	DROP TABLE #CCM_IdxSIDBSubStore
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_GXGlobalParam]') )
BEGIN
	DROP TABLE #CCM_GXGlobalParam
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_Pattern]') )
BEGIN
	DROP TABLE #CCM_TM_Pattern
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_PatternAssoc]') )
BEGIN
	DROP TABLE #CCM_TM_PatternAssoc
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_SubTask]') )
BEGIN
	DROP TABLE #CCM_TM_SubTask
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_AssocEntity]') )
BEGIN
	DROP TABLE #CCM_TM_AssocEntity
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_Task]') )
BEGIN
	DROP TABLE #CCM_TM_Task
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMVolume]') )
BEGIN
	DROP TABLE #CCM_SMVolume
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMVolSnapMap]') )
BEGIN
	DROP TABLE #CCM_SMVolSnapMap
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMMetaData]') )
BEGIN
	DROP TABLE #CCM_SMMetaData
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMSnap]') )
BEGIN
	DROP TABLE #CCM_SMSnap
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMControlHost]') )
BEGIN
	DROP TABLE #CCM_SMControlHost
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSProviders]') )
BEGIN
	DROP TABLE #CCM_UMDSProviders
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSgroups]') )
BEGIN
	DROP TABLE #CCM_UMDSgroups
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMGroups]') )
BEGIN
	DROP TABLE #CCM_UMGroups
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSGroupMaps]') )
BEGIN
	DROP TABLE #CCM_UMDSGroupMaps
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMUsers]') )
BEGIN
	DROP TABLE #CCM_UMUsers
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMUserGroup]') )
BEGIN
	DROP TABLE #CCM_UMUserGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMUserPrefs]') )
BEGIN
	DROP TABLE #CCM_UMUserPrefs
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSUserGroup]') )
BEGIN
	DROP TABLE #CCM_UMDSUserGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMRoles]') )
BEGIN
	DROP TABLE #CCM_UMRoles
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMRolesPermissions]') )
BEGIN
	DROP TABLE #CCM_UMRolesPermissions
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMRolesWithPermissionsExpanded]') )
BEGIN
	DROP TABLE #CCM_UMRolesWithPermissionsExpanded
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMOwners]') )
BEGIN
	DROP TABLE #CCM_UMOwners
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMOwnerRoles]') )
BEGIN
	DROP TABLE #CCM_UMOwnerRoles
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMSecurityAssociations]') )
BEGIN
	DROP TABLE #CCM_UMSecurityAssociations
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_edcJobIdMap]') )
BEGIN
	DROP TABLE #CCM_edcJobIdMap
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_edcClientNameMap]') )
BEGIN
	DROP TABLE #CCM_edcClientNameMap
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archMaterializeSnapshotProp]') )
BEGIN
	DROP TABLE #CCM_archMaterializeSnapshotProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_PatchUpdateAgentInfo]') )
BEGIN
	DROP TABLE #CCM_PatchUpdateAgentInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_PatchMultiCache]') )
BEGIN
	DROP TABLE #CCM_PatchMultiCache
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_CCRCommCellReadiness]') )
BEGIN
	DROP TABLE #CCM_CCRCommCellReadiness
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_CCRToSubClient]') )
BEGIN
	DROP TABLE #CCM_CCRToSubClient
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_CCRClientToClient]') )
BEGIN
	DROP TABLE #CCM_CCRClientToClient
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileCopyDedup]') )
BEGIN
	DROP TABLE #CCM_archFileCopyDedup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileSIDBKeys]') )
BEGIN
	DROP TABLE #CCM_archFileSIDBKeys
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMEntityProp]') )
BEGIN
	DROP TABLE #CCM_MMEntityProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_DlpClientPass]') )
BEGIN
	DROP TABLE #CCM_DlpClientPass
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archIndexingAged]') )
BEGIN
	DROP TABLE #CCM_archIndexingAged
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_App_IndexDBInfo]') )
BEGIN
	DROP TABLE #CCM_App_IndexDBInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_App_IndexCheckpointInfo]') )
BEGIN
	DROP TABLE #CCM_App_IndexCheckpointInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_GRC_History]') )
BEGIN
	DROP TABLE #CCM_GRC_History
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDiskHWInfo]') )
BEGIN
	DROP TABLE #CCM_MMDiskHWInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMScaleOutMAInfo]') )
BEGIN
	DROP TABLE #CCM_MMScaleOutMAInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMSDSStoragePool]') )
BEGIN
	DROP TABLE #CCM_MMSDSStoragePool
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CredentialAssoc]') )
BEGIN
	DROP TABLE #CCM_APP_CredentialAssoc
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Credentials]') )
BEGIN
	DROP TABLE #CCM_APP_Credentials
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchEncKeys]') )
BEGIN
	DROP TABLE #CCM_ArchEncKeys
END

END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errCode = ERROR_NUMBER()
	SET @o_errStr = 'Exception in dropping CCM_* tables from tempdb at ERROR_LINE(): '+ CAST(ERROR_LINE() as varchar(10))+' ERROR_MESSAGE(): ' + ERROR_MESSAGE()
	GOTO CX_ERROR_EXIT
END CATCH
SET @o_errCode = 0
SET @o_errStr = 'ERROR: NO ERROR!'
SELECT @o_errCode, @o_errStr
RETURN(0)
CX_ERROR_EXIT:
IF OBJECT_ID('#TempReadQuestionsResultSet') IS NOT NULL DROP TABLE #TempReadQuestionsResultSet
IF OBJECT_ID('#TempMergeMainResultSet') IS NOT NULL DROP TABLE #TempMergeMainResultSet
RAISERROR ('%s' , 16, 1, @o_errStr)
SELECT	@o_errCode, @o_errStr
RETURN(-1)

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_Entities_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Entities_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Entities_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Entities_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_Entities_from_XML',  'v1.10.12.3.4.1', 'CCM_Merge_Entities_from_XML', 'v1.10.12.3.4.1')
GO

