

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_CustomCalendar_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge APP_CustomCalendar table.
--  |                   Merge APP_CustomCalendarMonths table.
--  +========================================================================+
-- $Id: CCM_Merge_CustomCalendar_from_XML.sp,v 1.1.208.1 2018/03/20 00:39:21 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Merge_CustomCalendar_from_XML <<<'

IF EXISTS (select * from sysobjects where name='CCM_Merge_CustomCalendar_from_XML')
	drop procedure CCM_Merge_CustomCalendar_from_XML
IF EXISTS (select * from GxQscripts where name='CCM_Merge_CustomCalendar_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_CustomCalendar_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_CustomCalendar_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_CustomCalendar_from_XML'
GO
print '... Creating Procedure: CCM_Merge_CustomCalendar_from_XML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Merge_CustomCalendar_from_XML
  @errStr varchar(1024) OUTPUT
AS
SET NOCOUNT ON
	-- Do not use transaction here, because it is called by another stored procedure with transaction
	SET @errStr = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
	--Code below here is from CCM_Merge_CustomCalendar.spb ---
	-- Merge APP_CustomCalendar
	INSERT	INTO CCM_MAP_AppCustomCalendar
	SELECT	DISTINCT a.id, 0, a.name, a.calType, a.createdTime, a.modifiedTime, 0, a.origCCId, 0
FROM	#CCM_App_CustomCalendar a, #CCM_ArchGroupCopy b
	WHERE	a.id = b.calendarId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_CustomCalendar -- CCM_MAP_AppCustomCalendar -- INSERT -- CCM_ArchGroupCopy'
		GOTO CX_ERROR_EXIT
	END
	-- Merge APP_CustomCalendar during client's Schedule Migration
	INSERT	INTO CCM_MAP_AppCustomCalendar
	SELECT	DISTINCT a.id, 0, a.name, a.calType, a.createdTime, a.modifiedTime, 0, a.origCCId, 0
FROM	#CCM_App_CustomCalendar a, #CCM_TM_Pattern b
	WHERE	a.id = b.calendarId
	AND     a.id NOT IN (SELECT old_id FROM CCM_MAP_AppCustomCalendar)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_CustomCalendar -- CCM_MAP_AppCustomCalendar -- INSERT -- CCM_TM_Pattern'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_AppCustomCalendar SET exist = 1
	FROM	CCM_MAP_AppCustomCalendar a, APP_CustomCalendar b
	WHERE	a.name = b.name and a.calType = b.calType and a.createdTime = b.createdTime
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_CustomCalendar -- CCM_MAP_AppCustomCalendar -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	-- Modify calendar on destination machine if it is recently modified from source machine
	UPDATE	CCM_MAP_AppCustomCalendar SET exist = 2
	FROM	CCM_MAP_AppCustomCalendar a, APP_CustomCalendar b
	WHERE	a.name = b.name and a.calType = b.calType and a.createdTime = b.createdTime
	AND		a.modifiedTime > b.modifiedTime
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_CustomCalendar -- CCM_MAP_AppCustomCalendar -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_AppCustomCalendar SET new_origCCId = b.new_id
	FROM	CCM_MAP_AppCustomCalendar a, CCM_MAP_CommCell b
	WHERE	a.old_origCCId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_CustomCalendar -- CCM_MAP_AppCustomCalendar -- UPDATE new_origCCId'
		GOTO CX_ERROR_EXIT
	END
	-- Insert non-exist calendar only
	-- Migrated calendars can not become default calendar
	INSERT INTO APP_CustomCalendar
	SELECT	b.name, b.beginYear, b.beginMonth, b.beginDate, b.noOfyears,
			0, b.calType, b.createdTime, b.modifiedTime, a.new_origCCId, NewID() -- b.GUID
FROM	CCM_MAP_AppCustomCalendar a, #CCM_App_CustomCalendar b
	WHERE	a.exist = 0
	---- conditions a.old_id = b.id
				AND a.old_id = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_CustomCalendar -- APP_CustomCalendar -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_AppCustomCalendar SET new_id = b.id
	FROM	CCM_MAP_AppCustomCalendar a, APP_CustomCalendar b
	WHERE	a.name = b.name and a.calType = b.calType and a.createdTime = b.createdTime
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_CustomCalendar -- CCM_MAP_AppCustomCalendar -- UPDATE new_id'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	APP_CustomCalendar
	SET		beginYear = c.beginYear,
			beginMonth = c.beginMonth,
			beginDate = c.beginDate,
			noOfyears = c.noOfyears,
			modifiedTime = c.modifiedTime
FROM	APP_CustomCalendar a, CCM_MAP_AppCustomCalendar b, #CCM_App_CustomCalendar c
	WHERE	a.id = b.new_id and b.old_id = c.id and b.exist = 2
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_CustomCalendar -- APP_CustomCalendar -- UPDATE existing calendar'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	INSERT INTO APP_CustomCalendarMonths
	SELECT	a.new_id, b.year, b.month, b.offset, b.daysCount, b.startDate, b.endDate
FROM	CCM_MAP_AppCustomCalendar a, #CCM_App_CustomCalendarMonths b
	WHERE	a.old_id = b.calendarId and a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_CustomCalendar -- APP_CustomCalendarMonths -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	APP_CustomCalendarMonths
	SET		year = c.year,
			month = c.month,
			offset = c.offset,
			daysCount = c.daysCount,
			startDate = c.startDate,
			endDate = c.endDate
FROM	APP_CustomCalendarMonths a, CCM_MAP_AppCustomCalendar b, #CCM_App_CustomCalendarMonths c
	WHERE	a.calendarId = b.new_id and b.old_id = c.calendarId and b.exist = 2
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_CustomCalendar -- APP_CustomCalendarMonths -- UPDATE existing calendar'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_CustomCalendar_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_CustomCalendar_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_CustomCalendar_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_CustomCalendar_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_CustomCalendar_from_XML',  '00010001020800010000', 'CCM_Merge_CustomCalendar_from_XML', '00010001020800010000')
GO

