

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_CommCell.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge APP_CommCell table.
--  +========================================================================+
-- $Id: CCM_Merge_CommCell.sp,v 1.28.80.1 2018/03/20 00:34:03 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Merge_CommCell <<<'

IF EXISTS (select * from sysobjects where name='CCM_Merge_CommCell')
	drop procedure CCM_Merge_CommCell
IF EXISTS (select * from GxQscripts where name='CCM_Merge_CommCell')
	delete from GxQscripts where name = 'CCM_Merge_CommCell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_CommCell')
	delete from GXDBVersions where aliasname = 'CCM_Merge_CommCell'
GO
print '... Creating Procedure: CCM_Merge_CommCell'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Merge_CommCell
  @errorString varchar(1024) OUTPUT
AS
SET NOCOUNT ON
	-- Do not use transaction here, because it is called by another stored procedure with transaction
	-- CCM_Merge_Commcell is used to merge both SIMPANA and NON-SIMPANA commcells (like NetApp, NetBackup)
	-- SIMPANA Based commcells have unique number in app_commcell and different commcells can have same name
	-- NON-SIMPANA commcells are assumed to have unique names
	-- Types of Commcell
	-- #define COMMCELL_TYPE_GALAXY                        1
	-- #define COMMCELL_TYPE_NETBACKUP                   100
    -- #define COMMCELL_TYPE_BACKUPEXEC                  101
    -- #define COMMCELL_TYPE_NETAPP                      102
    -- #define COMMCELL_TYPE_TSM                         104
    -- #define COMMCELL_TYPE_NWK						 105
	-- #define COMMCELL_TYPE_VEEAM						 108
	SET @errorString = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
--- CODE BELOW HERE IS FROM CCM_Merge_CommCell.spb  ----------
	IF EXISTS (SELECT *
FROM CommServ_Merge..CCM_APP_CommCell
WHERE type NOT IN (1,
100,
101,
102,
104,
105,
106,
108,
109
	                              ))
	BEGIN
	    SET @errorString = 'ERROR: CCM_Merge_CommCell -- Unknown Commcell Type in Captured database'
		GOTO CX_ERROR_EXIT
	END
	-- Update CommCell entry created by tape import.
	UPDATE APP_CommCell
	SET parentId = B.parentId,
		aliasName = B.aliasName,
		flags = B.flags,
		refTime = B.refTime,
		userName = B.userName,
		userPassword = B.userPassword,
		smtpServer = B.smtpServer,
		timeZone = B.timeZone,
		ipAddress = B.ipAddress,
		modified = B.modified,
		ccOpMode = B.ccOpMode,
		drIpAddress = B.drIpAddress,
		encNumber = B.encNumber,
		csGUID = B.csGUID,
		type = B.type
FROM APP_CommCell A INNER JOIN CommServ_Merge..CCM_APP_CommCell B ON A.number = B.number
	WHERE A.aliasName LIKE 'TapeImportedCommCell_%'
		AND A.csGUID = ''
		AND B.csGUID <> ''
	IF	@@ERROR > 0
	BEGIN
	    SET @errorString = 'ERROR: CCM_Merge_CommCell -- Update tape import created commcell entry.'
		GOTO CX_ERROR_EXIT
	END
	--Check for duplicate GUID with different number
	/* IF NOT EXISTS (SELECT 1 FROM MMConfigs where name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_DUPLICATE_GUID' and value = 1)
	BEGIN
		IF EXISTS
		(
	*/		--Check in source and destination
			INSERT INTO APP_InvalidGUID(GUID)
			SELECT DISTINCT a.csGUID
FROM CommServ_Merge..CCM_APP_CommCell a INNER JOIN APP_Commcell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	/*	)
		BEGIN
			SET @errorString = 'ERROR: Duplicate GUIDs with different CommcellId found in source and destination CommServes. Please contact customer support.'
			SET @errorString = @errorString + CHAR(13) + CHAR(10) + 'Following GUIDs are associated with more than one CommCellId'
			SELECT @errorString = @errorString + CHAR(13) + CHAR(10) +  b.csGUID
FROM CommServ_Merge..CCM_APP_CommCell a INNER JOIN APP_Commcell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
			GOTO CX_ERROR_EXIT
		END
	*/
	/*	IF EXISTS
		(
	*/		--Check in source and source
			INSERT INTO APP_InvalidGUID(GUID)
			SELECT DISTINCT a.csGUID
FROM CommServ_Merge..CCM_APP_CommCell a INNER JOIN CommServ_Merge..CCM_APP_CommCell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	/*	)
		BEGIN
			SET @errorString = 'ERROR: Duplicate GUIDs with different CommcellId found in source CommServe. Please contact customer support.'
			SET @errorString = @errorString + CHAR(13) + CHAR(10) + 'Following GUIDs are associated with more than one CommCellId'
			SELECT @errorString = @errorString + CHAR(13) + CHAR(10) +  b.csGUID
FROM CommServ_Merge..CCM_APP_CommCell a INNER JOIN CommServ_Merge..CCM_APP_CommCell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
			GOTO CX_ERROR_EXIT
		END
	*/
	/*	IF EXISTS
		(
	*/		--Check in destination and destination
			INSERT INTO APP_InvalidGUID(GUID)
			SELECT DISTINCT a.csGUID
			FROM APP_CommCell a INNER JOIN APP_CommCell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	/*	)
		BEGIN
			SET @errorString = 'ERROR: Duplicate GUIDs with different CommcellId found in destination CommServe. Please contact customer support.'
			SET @errorString = @errorString + CHAR(13) + CHAR(10) + 'Following GUIDs are associated with more than one CommCellId'
			SELECT @errorString = @errorString + CHAR(13) + CHAR(10) +  b.csGUID
			FROM APP_CommCell a INNER JOIN APP_CommCell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
			GOTO CX_ERROR_EXIT
		END
	END
	*/
	--Check for duplicate number with different GUID
	IF NOT EXISTS (SELECT 1 FROM MMConfigs WHERE name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_DUPLICATE_GUID' and value <> 0)
	BEGIN
		IF EXISTS
		(
			SELECT 1
FROM CommServ_Merge..CCM_APP_CommCell a INNER JOIN APP_Commcell b
				ON a.number = b.number AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND LEN(a.csGUID) > 0 AND a.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.csGUID <> b.csGUID
		)
		BEGIN
			SET @errorString = 'ERROR: Duplicate CommcellId with different GUIDs found in source and destination CommServes. Please contact customer support.'
			SET @errorString = @errorString + CHAR(13) + CHAR(10) + 'Following CommCellId is associated with more than one GUID'
			SELECT @errorString = @errorString + CHAR(13) + CHAR(10) +  CONVERT(varchar, b.number)
FROM CommServ_Merge..CCM_APP_CommCell a INNER JOIN APP_Commcell b
				ON a.number = b.number AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND LEN(a.csGUID) > 0 AND a.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.csGUID <> b.csGUID
			GOTO CX_ERROR_EXIT
		END
	END
/*	Code change to allow merging of different commcells using same license number together
	 Please note that we are checking for value = 2 here as this allows for the following:
	- default: error out if we encounter two commcells with same license but different guids (value not present or == 0)
	- allow merging two commcell's data with different guids but same license together into a single commcell (value == 1)
	   (means that we treat the commcells with same license numbers as the same commcell even if guids are different)
	- allow merging two commcell's data with different guids but same license together where different guids are
		interpreted as different commcells (value == 2 what this update is for)
  */
	IF EXISTS (SELECT 1 FROM MMConfigs WHERE name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_DUPLICATE_GUID' and value = 2)
	BEGIN
	  /* Change to allow importing data from two different commcells with different guids that have the same license number as
		  two different commcells */
UPDATE  CommServ_Merge..CCM_APP_CommCell
		SET number = -1
FROM CommServ_Merge..CCM_APP_CommCell a INNER JOIN APP_Commcell b
				ON a.number = b.number AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND LEN(a.csGUID) > 0 AND a.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.csGUID <> b.csGUID
	-- Setting the number to -1 in the merge db does the following:
	--     - it updates the incoming entry with same number and different guid to -1 in the merge db
	--     - it gets inserted as such in the mapping table.
	--	   -  the query mapping same numbers together will not hit as numbers are different
	-- 	   -  the query that updates a commcell number from unlicensed to licensed will also not pick this up as
	--         this is licensed in the CSDB but not in the merge db, so everything will work...
	END
	-- GET CommCellId TO BE MERGED
INSERT INTO CCM_MAP_CommCell
	SELECT DISTINCT id, 0, number, aliasName, type, csGUID, 0
FROM CommServ_Merge..CCM_APP_CommCell
	WHERE number <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	/*PrasadNara 1:56 PM 6/22/2012
	 * RackSpace has many commcells with the same guid 'D3DA843D-9BC8-4396-8782-88D73B6C7DBA', so treat it as invalid guid.
	 */
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.csGUID = b.csGUID
	AND a.type = b.type
AND a.type = 1   -- SIMPANA Commcells
	AND LEN(b.csGUID) > 0
	AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
	AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMPANA 1 - GUID Based'
		GOTO CX_ERROR_EXIT
	END
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.number = b.number
	AND a.type = b.type
AND a.type = 1   -- SIMPANA Commcells
	AND a.new_id = 0
	AND a.number <> -1
	AND b.number <> -1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMPANA 1 - number based'
		GOTO CX_ERROR_EXIT
	END
	-- If commcell no is -1 and CS GUID is 00000000-0000-0000-0000-000000000000
	-- then assume that the data is from current commcell. This is to support
	-- tape catalog of media written with eval licenses
UPDATE  CCM_MAP_CommCell SET new_id = 2
	WHERE new_id = 0 AND number = -1
	AND csGUID = '00000000-0000-0000-0000-000000000000'
	AND type = 1
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.aliasName = b.aliasName
	AND a.type = b.type
AND a.type IN (100,101,102,104,105,106, 108, 109)   -- Non-SIMPANA Commcells like NetApp, NetBackup etc
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- NON-SIMPANA 1'
		GOTO CX_ERROR_EXIT
	END
	--
	-- PrasadNara 12:28 PM 11/21/2012
	-- Update the commcell number if it is migrated previously with eval license
	-- and migrating it again after applying license.
	--
	UPDATE APP_CommCell
	SET number = a.number
FROM CCM_MAP_CommCell a INNER JOIN APP_CommCell b
		ON a.new_id = b.id
	WHERE a.number <> -1 AND b.number = -1 AND b.id > 2
		AND NOT EXISTS(SELECT 1 FROM App_CommCell WHERE number = a.number)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- APP_CommCell -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
UPDATE CCM_MAP_CommCell
	SET exist = 1
	WHERE new_id <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- APP_CommCell -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO APP_CommCell
	SELECT	b.number, 0, b.parentId, b.aliasName, b.flags, b.refTime,
			b.userName, b.userPassword, b.smtpServer, b.timeZone, b.ipAddress,
			b.modified, b.ccOpMode, b.drIpAddress, b.encNumber, b.csGUID, b.type
FROM CCM_MAP_CommCell a, CommServ_Merge..CCM_APP_CommCell b
	WHERE a.old_id = b.id AND a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- APP_CommCell -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	/*
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.number = b.number AND a.new_id = 0
	AND a.type = b.type
AND a.type = 1 -- SIMPANA Commcells
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMAPANA -- 2'
		GOTO CX_ERROR_EXIT
	END
	*/
	/*
	Updating the map table for the new rows inserted in destination App_Commcell - based in GUIDs not based on numbers
	change to support migration even with eval License (number will be -1)
	*/
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.csGUID = b.csGUID AND a.new_id = 0
	AND a.type = b.type
AND a.type = 1 -- SIMPANA Commcells
	AND LEN(b.csGUID) > 0
	AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
	AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMAPANA -- 2'
		GOTO CX_ERROR_EXIT
	END
	--Update the map table based on number incase of empty GUID
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.number = b.number AND a.new_id = 0
	AND a.type = b.type
AND a.type = 1 -- SIMPANA Commcells
	AND b.id > 1
	AND a.number <> -1
	AND b.number <> -1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMAPANA -- 3'
		GOTO CX_ERROR_EXIT
	END
UPDATE CCM_MAP_CommCell SET new_id = b.id
FROM CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.aliasName = b.aliasName AND a.new_id = 0
	AND a.type = b.type
AND a.type IN (100,101,102,104,105,106, 108, 109) -- Non-SIMPANA Commcells like NetApp, NetBackup etc
	AND b.id > 1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- NON-SIMAPANA -- 2'
		GOTO CX_ERROR_EXIT
	END
	--Fail merge incase of new commcell id is 0 or 1
IF EXISTS(SELECT 1 FROM CCM_MAP_CommCell WHERE new_id = 0 OR new_id = 1)
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- new_id is 0 or 1'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errorString = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_CommCell')
	delete from GxQscripts where name = 'CCM_Merge_CommCell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_CommCell')
	delete from GXDBVersions where aliasname = 'CCM_Merge_CommCell'
GO

insert into GXDBVersions values(2, 'CCM_Merge_CommCell',  '00010028008000010000', 'CCM_Merge_CommCell', '00010028008000010000')
GO

