

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_Client_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge tables:
--	|					APP_Client
--	|					APP_ClientProp
--	|					APP_Platform
--	|					APP_IDAName
--	|					APP_IDAProp
--	|					APP_DCvolInfo
--	|					APP_InstanceName
--	|					APP_InstanceProp
--	|					APP_BackupSetName
--	|					APP_BackupSetProp
--	|					APP_OracleRacInstance
--	|					simInstalledPackages
--	|					simInstalledPackagesHistory
--	|					simXMLRequest
--	|					LicUsageHistory
--  +========================================================================+
-- $Id: CCM_Merge_Client_from_XML.sp,v 1.15.34.3.6.3 2021/05/24 18:09:20 pnara Exp $
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCM_Merge_Client_from_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Merge_Client_from_XML <<<'
	drop procedure CCM_Merge_Client_from_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Merge_Client_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Client_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Client_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Client_from_XML'
GO
print '... Creating Procedure: CCM_Merge_Client_from_XML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCM_Merge_Client_from_XML
  @i_mediaAgentMerge integer = 0,
  @isEDCMerge integer = 0,
  @ccmParamFlags integer = 0,
  @errorString varchar(1024) OUTPUT
AS
SET NOCOUNT ON
	SET @errorString = 'ERROR: GENERAL ERROR!'
	-------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM CCM_Merge_Client.spb  ----------
	DECLARE @tblBeforeMerge TABLE (id INT)
	DECLARE @Merge_To_Same_CommCell int
IF EXISTS (SELECT * FROM CCM_MAP_CommCell WHERE new_id = 2 and old_id = 2)
		SET @Merge_To_Same_CommCell = 1
	ELSE
		SET @Merge_To_Same_CommCell = 0
	DECLARE	@tmpFileSystemAppType TABLE ( appTypeId integer)
	INSERT	@tmpFileSystemAppType
	SELECT	DISTINCT type FROM APP_idaType WHERE displayName = 'File System'
-- DB: fix changed tabls
DECLARE @dummy_ccpId INTEGER
SET @dummy_ccpId = 0
DECLARE @dummy_ccpTime INTEGER
SET @dummy_ccpTime = 0
DECLARE @dummy_GUID NVARCHAR(max)
SET @dummy_GUID = '00000000-0000-0000-0000-000000000000'
DECLARE @migratedClientFlag INTEGER = 0x20
IF (@ccmParamFlags & 8) = 8
SET @migratedClientFlag = (@migratedClientFlag | 0x200)
	ELSE
SET @migratedClientFlag = (@migratedClientFlag | 0x2)
	DECLARE @l_RowCount int = 0
	DECLARE @l_ErrorCode int = 0
/*
	-------------------------------------------------------------------------------------------------------------------------------------
	     Source Commcell             Destination Commcell           exists            Action
	Name   hostname  origCCId      Name    hostname    oridCCId
	-------------------------------------------------------------------------------------------------------------------------------------
	 A        B         2                                             0        First Time Merge, proceed fine
	 A        B         2           A         B           3           1        Number corresponding to 2 and 3 are same, Remerge usecase
	 A        B         2           A       non-B         3           1        Number corresponding to 2 and 3 are same ???
	 A        B         2         non-A       B           3           1        Number corresponding to 2 and 3 are same ???
	 A        B         2         non-A     non-B         3           1        Merge of a new client, first time merge
	 A        B         2           A         B           3           0        Number corresponding to 2 and 3 are different
	                                                                           ???
     A        B         2           A       non-B         3           0        Number corresponding to 2 and 3 are different
	                                                                           ???
     A        B         2         non-A       B           3           0        Number corresponding to 2 and 3 are different
	                                                                           ???
     A        B         2         non-A     non-B         3           0        Number corresponding to 2 and 3 are different
																			   First time merge, proceed fine
	-------------------------------------------------------------------------------------------------------------------------------------
*/
	-- Merge APP_Client table
UPDATE #CCM_App_Client
	SET    origCCId = 2
	WHERE  origCCId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_APP_Client -- UPDATE -- origCCId'
		GOTO CX_ERROR_EXIT
	END
	IF (@ccmParamFlags & 1) = 1
	BEGIN
		--For GRC mark client as GRC migrated client and set flag if client is uninstalled in source
UPDATE #CCM_App_Client
SET    specialClientFlags = CASE (specialClientFlags & 0x2) WHEN 0 THEN (specialClientFlags | 0x80)
ELSE (specialClientFlags | 0x80 | 0x40) END
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_APP_Client -- UPDATE -- specialClientFlags'
			GOTO CX_ERROR_EXIT
		END
		-- If client is deconfigured on source then set flag.
UPDATE #CCM_App_Client
SET    specialClientFlags = specialClientFlags | 0x40
FROM #CCM_App_Client CL
WHERE CL.status & 0x00002 = 0x00002
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_APP_Client -- UPDATE 2 -- specialClientFlags'
			GOTO CX_ERROR_EXIT
		END
	END
	-- Set csHostName for discovered VMs.
	/*
	DECLARE @csHostName VARCHAR(1024)
	SET @csHostName = ( SELECT net_hostname FROM APP_Client WHERE id = 2 )
UPDATE #CCM_App_Client
	SET csHostName = @csHostName
FROM #CCM_App_Client
WHERE specialClientFlags & 0xB = 0xB
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_DB_APP_CLIENT -- Failed to set csHostName for Discovered VMs'
		GOTO CX_ERROR_EXIT
	END
	*/
	-- GET ClientId TO BE MERGED
INSERT INTO CCM_MAP_Client
	SELECT DISTINCT id, 0, name, name, net_hostname, net_hostname, origCCId, 0, 0, 0
FROM #CCM_App_Client
	-- Remove the ones has no Client Id. It may come from Tape Import
	WHERE id > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Get new client name and net_hostname from user
UPDATE CCM_MAP_Client SET new_name = b.new_name, new_net_hostName = b.new_net_hostName
FROM CCM_MAP_Client a, #CCM_ClientNameMapping b
	WHERE a.old_name = b.old_name
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new_name'
		GOTO CX_ERROR_EXIT
	END
	-- Update the new_origCCcommCellId
	-- old_origCCcommCellId will never have 0 as it is always defaulted to 2
UPDATE CCM_MAP_Client SET new_origCCcommCellId = ISNULL((SELECT new_id FROM CCM_MAP_CommCell WHERE old_id = old_origCCcommCellId), (SELECT new_id FROM CCM_MAP_CommCell WHERE old_id = 2 /*Source CS*/))
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new_origCCcommCellId'
		GOTO CX_ERROR_EXIT
	END
	-- Give client new net_hostname if it was empty on destination
	UPDATE APP_Client SET net_hostname = b.new_net_hostname
FROM APP_Client a, CCM_MAP_Client b
	WHERE a.name = b.new_name
	AND a.net_hostname = ''
	AND b.new_net_hostname <> ''
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- Client -- UPDATE net_hostname'
		GOTO CX_ERROR_EXIT
	END
	UPDATE App_Client
	SET --name = mapC.new_name,
		simOperatingSystemId = srcC.simOperatingSystemId,
		--net_hostname = mapC.new_net_hostName,
		client_password = srcC.client_password,
		refTime = srcC.refTime,
		modified = srcC.modified,
		offlineEntity = srcC.offlineEntity,
		offlineTimeStamp = srcC.offlineTimeStamp,
		csHostName = srcC.csHostName,
		clientDescription = srcC.clientDescription,
		jobResultDir = srcC.jobResultDir,
		clientSkewTime = srcC.clientSkewTime,
		cvdPort = srcC.cvdPort,
		evmgrcPort = srcC.evmgrcPort,
		status = srcC.status,
		releaseId = srcC.releaseId,
		spaceCheckFlags = srcC.spaceCheckFlags,
		ccpId = srcC.ccpId,
		ccpTime = srcC.ccpTime,
		origCCId = mapC.new_origCCcommCellId,
		GUID = srcC.GUID,
		specialClientFlags = CASE WHEN @Merge_To_Same_CommCell > 0 THEN srcC.specialClientFlags ELSE (srcC.specialClientFlags | @migratedClientFlag) END
FROM App_Client destC, CCM_MAP_Client mapC, #CCM_App_Client srcC
	WHERE destC.origCCId = 2
	AND destC.id > 2
	AND (destC.specialClientFlags & 2) > 0
	AND (destC.name = mapC.new_name OR destC.net_hostname = mapC.new_net_hostName)
	AND mapC.old_id = srcC.id
	AND srcC.id  = 2
	AND srcC.origCCId = 2
	AND srcC.net_hostName <> ''
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- Update CommNet DummyClient Row'
		GOTO CX_ERROR_EXIT
	END
	--if client is already imported by tapeimport job, then update all the client details.
	UPDATE APP_Client
	SET	name = D.name,
		simOperatingSystemId = D.simOperatingSystemId,
		net_hostname = D.net_hostname,
		client_password = D.client_password,
		refTime = D.refTime,
		modified = D.modified,
		offlineEntity = D.offlineEntity,
		offlineTimeStamp = D.offlineTimeStamp,
		csHostName = D.csHostName,
		clientDescription = D.clientDescription,
		jobResultDir = D.jobResultDir,
		clientSkewTime = D.clientSkewTime,
		cvdPort = D.cvdPort,
		evmgrcPort = D.evmgrcPort,
		status = D.status,
		releaseId = D.releaseId,
		spaceCheckFlags = D.spaceCheckFlags,
		ccpId = D.ccpId,
		ccpTime = D.ccpTime,
		GUID = D.GUID,
		specialClientFlags = D.specialClientFlags,
		displayName = D.displayName
FROM APP_Client A,CCM_TapeImportEntities B, CCM_MAP_CommCell C, #CCM_App_Client D
WHERE A.id = B.new_id AND B.old_id = D.id AND C.new_id = B.newCCId AND B.entityType = 3
AND (D.specialClientFlags & 0x100) = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE For TapeImported client'
		GOTO CX_ERROR_EXIT
	END
	/*
	 *PrasadNara: 10:33 AM 6/20/2012 Set exist based on below conditions
	 * If client guid matches consider that as remerge of same client
	 * If client guid does NOT match but both client Name and Host Name matches then treat it as remerge case only when config param is set or for EDC or for TapeImport
	 * If client guid does NOT match, client name does NOT match, client host name matches consider that as new entry and merge successfully
	 * If client guid does NOT match, client name matches, client host name does NOT match fail saying name conflict
	 * If client guid does NOT match, both client name and client host name does NOT match consider that as new entry and merge successfully
	 */
	--Match with GUID
UPDATE CCM_MAP_Client SET exist = 1, new_id = b.id
FROM CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
	WHERE a.old_id = c.id AND b.GUID = c.GUID
		AND LEN(b.GUID) > 0 AND b.GUID <> '00000000-0000-0000-0000-000000000000'
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE exist matching GUID'
		GOTO CX_ERROR_EXIT
	END
	--Client name and net host name both matches
	IF EXISTS (SELECT 1 FROM MMConfigs where name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_CLIENT_GUID_CONFLICT' and value = 1)
		OR (@isEDCMerge = 2) --EDC Merge
		OR (@isEDCMerge = 1) --Tape Import
    BEGIN
		-- net_hostname will be empty for client migrated through tape import
UPDATE CCM_MAP_Client SET exist = 1, new_id = b.id
FROM CCM_MAP_Client a, APP_Client b
		WHERE a.new_name = b.name
		AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
		AND exist <> 1
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE exist'
			GOTO CX_ERROR_EXIT
		END
	END
	--Match with name and hostname where GUID doesn't exists
UPDATE CCM_MAP_Client SET exist = 1, new_id = b.id
FROM CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
	WHERE a.new_name = b.name
		AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
		AND (LEN(c.GUID) = 0 OR c.GUID = '00000000-0000-0000-0000-000000000000')
		AND exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE exist matching name and hostname'
		GOTO CX_ERROR_EXIT
	END
	UPDATE 	APP_Client
	SET 	name = b.name + '_old_' + CAST(b.id AS NVARCHAR(64)),
			net_hostname = b.net_hostname + '_old_' + CAST(b.id AS NVARCHAR(64))
FROM 	CCM_MAP_Client a
		INNER JOIN APP_Client b ON a.new_name = b.name
		INNER JOIN APP_ClientProp c ON c.componentNameId = b.id AND c.attrName = 'OwnerCommCellId'
INNER JOIN #CCM_App_Client e ON a.old_id = e.id
INNER JOIN CCM_MAP_CommCell d ON d.new_id = CAST(c.attrVal AS INT) AND d.old_id = 2
	WHERE	a.exist = 0
		AND e.GUID <> b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new name for index clients.'
		GOTO CX_ERROR_EXIT
	END
	-- Update conflicting pseudo client names.
UPDATE 	CCM_MAP_Client
	SET 	new_name = a.new_name + '_CCM_' + CAST(dbo.GetUnixTime(getDate()) AS NVARCHAR(256)),
			new_net_hostName = a.new_net_hostName + '_CCM_' + CAST(dbo.GetUnixTime(getDate()) AS NVARCHAR(256))
FROM 	CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
	WHERE	a.old_id = c.id
			AND c.GUID <> b.GUID
			AND c.name = b.name
AND NOT EXISTS(SELECT 1 FROM #CCM_simInstalledPackages d WHERE d.clientId = c.id)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new name for discovered VM clients.'
		GOTO CX_ERROR_EXIT
	END
	--Update name if it's changed in source
	--Before update check if new name is conflicting with any other existing clients on destination
	IF OBJECT_ID('tempdb..#lt_ClientNameConflict') IS NOT NULL DROP TABLE #lt_ClientNameConflict
	CREATE TABLE #lt_ClientNameConflict (name nvarchar(512), destNetHostName nvarchar(512), destGUID uniqueidentifier, srcNetHostName nvarchar(512), srcGUID uniqueidentifier)
	IF OBJECT_ID('tempdb..#lt_ClientConflict') IS NOT NULL DROP TABLE #lt_ClientConflict
	CREATE TABLE #lt_ClientConflict (oldClientId INT)
	INSERT 	INTO #lt_ClientConflict
	SELECT 	a.old_id
FROM 	CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
	WHERE	a.exist = 1
			AND a.old_id = c.id
			AND a.new_id <> b.id
			AND a.new_name = b.name
AND	(b.specialClientFlags & 0x20) > 0
	SELECT @l_ErrorCode = @@ERROR, @l_RowCount = @@ROWCOUNT
	IF	@l_ErrorCode > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT Existing Client Name Conflict'
		GOTO CX_ERROR_EXIT
	END
	IF @l_RowCount > 0
	BEGIN
UPDATE 	CCM_MAP_Client
		SET 	new_name = a.new_name + '_CCM_' + CAST(dbo.GetUnixTime(getDate()) AS NVARCHAR(256))
FROM 	CCM_MAP_Client a INNER JOIN #lt_ClientConflict b ON a.old_Id = b.oldClientId
	END
	--Before updating name check for Host Name and CVD port conflict
	IF NOT EXISTS (SELECT * FROM MMConfigs where name = 'CCM_CONFIG_ALLOW_CCM_FOR_CLIENTS_WITH_SAME_HOSTNAME_CVDPORT' AND value = 1)
	BEGIN
		INSERT 	INTO #lt_ClientNameConflict
		SELECT 	b.name, b.net_hostname destNetHostName, b.guid destGUID, a.new_net_hostname srcNetHostName, c.guid srcGUID
FROM 	CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
		WHERE	a.exist = 1
				AND a.old_id = c.id
				AND a.new_id <> b.id
				AND a.new_net_hostname = b.net_hostname
				AND a.new_net_hostname <> ''
				AND c.cvdPort = b.cvdPort
AND	(b.specialClientFlags & 0x20) > 0
		SELECT @l_ErrorCode = @@ERROR, @l_RowCount = @@ROWCOUNT
		IF	@l_ErrorCode > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT Existing Client HostName and CVD port Conflict'
			GOTO CX_ERROR_EXIT
		END
		IF @l_RowCount > 0
		BEGIN
			SET @errorString = 'ERROR: Client hostname and CVD port conflict. ADVICE: 1. Change the clients host name either on source CommServe or destination CommServe. OR  2. Set "Allow CCM job when multiple clients exists with same host name and cvd port" parameter value to 1 in Media Management configuration when duplicate host name is expected.'
			SELECT 	@errorString = @errorString + CHAR(13) + 'Client [' + name + '] already present with host name ['+ destNetHostName + '] and guid ['+ convert(varchar(50), destGUID) + ']. Importing client host name ['+ srcNetHostName + '] and guid ['+ convert(varchar(50), srcGUID) + '].'
			FROM #lt_ClientNameConflict
			GOTO CX_ERROR_EXIT
		END
	END
	--Update properties of existing clients
	UPDATE		APP_Client
	SET			name 				= b.new_name,
				net_hostname		= b.new_net_hostname,
				simOperatingSystemId= c.simOperatingSystemId,
				client_password		= c.client_password,
				refTime				= c.refTime,
				modified			= c.modified,
				offlineEntity       = c.offlineEntity,
				offlineTimeStamp	= c.offlineTimeStamp,
				clientDescription	= c.clientDescription,
				jobResultDir		= c.jobResultDir,
				clientSkewTime		= c.clientSkewTime,
				cvdPort				= c.cvdPort,
				evmgrcPort			= c.evmgrcPort,
				releaseId			= c.releaseId,
				spaceCheckFlags		= c.spaceCheckFlags,
				displayName			= c.displayName,
				status				= c.status
FROM		APP_Client a, CCM_MAP_Client b, #CCM_App_Client c
	WHERE		b.exist = 1
				AND	a.id = b.new_id AND b.old_id = c.id
AND	(a.specialClientFlags & 0x20) > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE Existing client properties'
		GOTO CX_ERROR_EXIT
	END
	--Check client name conflict
	DELETE #lt_ClientConflict
	INSERT INTO #lt_ClientConflict
	SELECT 	a.old_id
FROM 	CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
	WHERE 	a.exist = 0
			AND a.old_id = c.id
			AND a.new_name = b.name
	SELECT @l_ErrorCode = @@ERROR, @l_RowCount = @@ROWCOUNT
	IF	@l_ErrorCode > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT Client Name Conflict'
		GOTO CX_ERROR_EXIT
	END
	IF @l_RowCount > 0
	BEGIN
UPDATE 	CCM_MAP_Client
		SET 	new_name = a.new_name + '_CCM_' + CAST(dbo.GetUnixTime(getDate()) AS NVARCHAR(256))
FROM 	CCM_MAP_Client a INNER JOIN #lt_ClientConflict b ON a.old_Id = b.oldClientId
	END
	--Check for Host Name and CVD port conflict
	IF NOT EXISTS (SELECT * FROM MMConfigs where name = 'CCM_CONFIG_ALLOW_CCM_FOR_CLIENTS_WITH_SAME_HOSTNAME_CVDPORT' AND value = 1)
	BEGIN
		INSERT 	INTO #lt_ClientNameConflict
		SELECT 	b.name, b.net_hostname destNetHostName, b.guid destGUID, a.new_net_hostname srcNetHostName, c.guid srcGUID
FROM 	CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
		WHERE	a.exist = 0
				AND a.old_id = c.id
				AND a.new_net_hostname = b.net_hostname
				AND a.new_net_hostname <> ''
				AND c.cvdPort = b.cvdPort
		SELECT @l_ErrorCode = @@ERROR, @l_RowCount = @@ROWCOUNT
		IF	@l_ErrorCode > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT Existing Client HostName and CVD port Conflict'
			GOTO CX_ERROR_EXIT
		END
		IF @l_RowCount > 0
		BEGIN
			SET @errorString = 'ERROR: Client hostname and CVD port conflict. ADVICE: 1. Change the clients host name either on source CommServe or destination CommServe. OR  2. Set "Allow CCM job when multiple clients exists with same host name and cvd port" parameter value to 1 in Media Management configuration when duplicate host name is expected.'
			SELECT 	@errorString = @errorString + CHAR(13) + 'Client [' + name + '] already present with host name ['+ destNetHostName + '] and guid ['+ convert(varchar(50), destGUID) + ']. Importing client host name ['+ srcNetHostName + '] and guid ['+ convert(varchar(50), srcGUID) + '].'
			FROM #lt_ClientNameConflict
			GOTO CX_ERROR_EXIT
		END
	END
	-- Old client id should be reused if merge to the same commserver and id not being resued
UPDATE	CCM_MAP_Client SET reuseOldId = 1
FROM	CCM_MAP_Client
	WHERE	@Merge_To_Same_CommCell > 0
	AND		old_id NOT IN (SELECT id FROM APP_Client)
	AND		exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE reuseOldId'
		GOTO CX_ERROR_EXIT
	END
	SET IDENTITY_INSERT APP_Client ON
	INSERT	INTO APP_Client (
			id, name, simOperatingSystemId, net_hostname,
			client_password, refTime, modified, offlineEntity,
			offlineTimeStamp, csHostName, clientDescription,
			jobResultDir, clientSkewTime, cvdPort, evmgrcPort, status, releaseId,
			spaceCheckFlags,ccpId,ccpTime,origCCId,GUID,specialClientFlags,displayName
			)
	SELECT	a.old_id, a.new_name, b.simOperatingSystemId, a.new_net_hostname, b.client_password, b.refTime,
			b.modified, b.offlineEntity, b.offlineTimeStamp, b.csHostName,
			b.clientDescription, b.jobResultDir, b.clientSkewTime,
			b.cvdPort, b.evmgrcPort, b.status, b.releaseId,
			b.spaceCheckFlags, b.ccpId, b.ccpTime, a.new_origCCcommCellId, b.GUID,
			CASE WHEN @Merge_To_Same_CommCell > 0 THEN b.specialClientFlags ELSE (b.specialClientFlags | @migratedClientFlag) END,
			b.displayName
FROM	CCM_MAP_Client a, #CCM_App_Client b
	WHERE	a.old_name = b.name AND a.old_net_hostname = b.net_hostname
	AND		a.reuseOldId = 1
	AND		a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET IDENTITY_INSERT APP_Client OFF
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- INSERT using old_Id'
		GOTO CX_ERROR_EXIT
	END
	SET IDENTITY_INSERT APP_Client OFF
-- DB: Fix Table Change
	INSERT	INTO APP_Client
	SELECT	a.new_name, b.simOperatingSystemId, a.new_net_hostname, b.client_password, b.refTime,
			b.modified, b.offlineEntity, b.offlineTimeStamp, b.csHostName,
			b.clientDescription, b.jobResultDir, b.clientSkewTime,
			b.cvdPort, b.evmgrcPort, b.status, b.releaseId,
			b.spaceCheckFlags, b.ccpId, b.ccpTime, a.new_origCCcommCellId, b.GUID,
			CASE WHEN @Merge_To_Same_CommCell > 0 THEN b.specialClientFlags ELSE (b.specialClientFlags | @migratedClientFlag) END,
			b.displayName
FROM	CCM_MAP_Client a, #CCM_App_Client b
	WHERE	a.old_name = b.name AND a.old_net_hostname = b.net_hostname
	AND		a.reuseOldId = 0
	AND		a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- INSERT creating new_Id'
		GOTO CX_ERROR_EXIT
	END
UPDATE	CCM_MAP_Client SET new_id = b.id
FROM	CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
	WHERE	a.old_id = c.id AND b.GUID = c.GUID
			AND LEN(b.GUID) > 0 AND b.GUID <> '00000000-0000-0000-0000-000000000000'
			AND a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new_id matching GUID'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS (SELECT 1 FROM MMConfigs where name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_CLIENT_GUID_CONFLICT' and value = 1)
		OR (@isEDCMerge = 2)
		OR (@isEDCMerge = 1)
    BEGIN
UPDATE	CCM_MAP_Client SET new_id = b.id
FROM	CCM_MAP_Client a, APP_Client b
		WHERE	a.new_name = b.name AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
			AND a.new_id = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new_id'
			GOTO CX_ERROR_EXIT
		END
	END
UPDATE	CCM_MAP_Client SET new_id = b.id
FROM	CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
	WHERE	a.old_id = c.id
			AND a.new_name = b.name AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
			AND (LEN(c.GUID) = 0 OR c.GUID = '00000000-0000-0000-0000-000000000000')
			AND a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new_id matching name and hostname'
		GOTO CX_ERROR_EXIT
	END
	UPDATE		APP_Client
	SET			client_password		= c.client_password,
				refTime						= c.refTime,
				modified					= c.modified,
				clientDescription	= c.clientDescription,
				jobResultDir			= c.jobResultDir,
				clientSkewTime		= c.clientSkewTime,
				cvdPort						= c.cvdPort,
				evmgrcPort				= c.evmgrcPort,
				--status						= c.status,
				releaseId					= c.releaseId,
specialClientFlags			=  CASE WHEN (a.specialClientFlags & 0x20) > 0
												THEN (@migratedClientFlag | c.specialClientFlags)
												ELSE (c.specialClientFlags & (~CAST((@migratedClientFlag) AS int)))
											   END
FROM		APP_Client a, CCM_MAP_Client b, #CCM_App_Client c
	WHERE		b.exist = 1
	AND			a.id = b.new_id AND b.old_id = c.id
	AND			a.releaseId < c.releaseId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE release id'
		GOTO CX_ERROR_EXIT
	END
	--For EDC clients that have been marked as deleted and reappeared
	IF @isEDCMerge = 2
	BEGIN
		UPDATE APP_Client
		SET clientDescription = SUBSTRING( clientDescription, 1, PATINDEX( '%Deleted on External Server at%', clientDescription ) - 1 )
WHERE id IN ( SELECT new_id FROM CCM_MAP_Client )
		AND clientDescription LIKE '%Deleted on External Server at%'
	END
	IF @@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- EDC:Reset APP_Client clientDescription for clients that have reappeared'
		GOTO CX_ERROR_EXIT
	END
	IF (@ccmParamFlags & 1) = 0
	BEGIN
		-- Update the csHostName if client is pointing to source CS and destination CS contains different csHostName.
		UPDATE	APP_Client
		SET     csHostName =  c.csHostName
FROM	APP_Client a, CCM_MAP_Client b, #CCM_App_Client c
		WHERE	b.exist = 1
		AND		a.id = b.new_id AND b.old_id = c.id
		AND     a.csHostName <> '' AND a.csHostName <> c.csHostName
AND     (a.specialClientFlags & 0x20) > 0
AND     (c.specialClientFlags & 0x20) = 0
		IF      @@ERROR > 0
		BEGIN
		        SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE csHostName'
		        GOTO CX_ERROR_EXIT
		END
IF (@ccmParamFlags & 8) = 8
		BEGIN
			-- Set remote commcell client flag if merge is RemoteCommCell client merge.
			UPDATE		APP_Client
SET			specialClientFlags			= (a.specialClientFlags | @migratedClientFlag & (~CAST(0x2 AS INT)))
FROM		APP_Client a, CCM_MAP_Client b
			WHERE		b.exist = 1
			AND			a.id = b.new_id
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE specialClientFlags - RemoteCommCellClient'
				GOTO CX_ERROR_EXIT
			END
		END
		ELSE
		BEGIN
			-- Reset grc flags
			UPDATE  APP_Client
SET     specialClientFlags = (a.specialClientFlags & (~CAST((0x80) AS int)) & (~CAST((0x40) AS int)))
FROM    APP_Client a, CCM_MAP_Client b
			WHERE   b.exist = 1
			AND     a.id = b.new_id
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE specialClientFlags'
				GOTO CX_ERROR_EXIT
			END
		END
	END
	/*
	IF EXISTS(SELECT *
FROM   APP_Client a, CCM_MAP_Client b, #CCM_App_Client c
	          WHERE  b.exist = 1
	          AND    a.id = b.new_id
	          AND    b.old_id = c.id
	          AND    c.releaseId < a.releaseId)
	BEGIN
		SET @errorString = 'ERROR: Source Clients are of older version'
		GOTO CX_ERROR_EXIT
	END
	*/
	----------------------------------------------------------
	-- If the clientId associated with the commcell is not migrated,
	-- reset it to 0
UPDATE #CCM_App_CommCell
	SET clientId = 0
WHERE clientId NOT IN (SELECT old_id FROM CCM_MAP_Client)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_APP_CommCell -- UPDATE -- clientId'
		GOTO CX_ERROR_EXIT
	END
-- Update clientId column of App_Commcell (CCM_MAP_Client)
	-- for both fresh merge as well as re-merge use cases
	UPDATE APP_CommCell
	SET clientId = d.new_id
FROM APP_CommCell a, CCM_MAP_CommCell b, #CCM_App_CommCell c, CCM_MAP_Client d
	WHERE a.id = b.new_id
	  AND b.old_id = c.id
	  AND c.clientId <> 0
	  AND a.id <> 2 --Don't touch the existing default commcell entry
	  AND d.old_id = c.clientId
	  AND d.new_id <> 2 --Don't set clientId 2 to migrated CommCell entries
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_CommCell -- UPDATE clientId'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------
	-- Merge SMControlHost table
UPDATE #CCM_SMControlHost
    SET    origCCId = 2
    WHERE  origCCId = 0
    IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_SMControlHost -- UPDATE -- origCCId to 2'
        GOTO CX_ERROR_EXIT
    END
    INSERT INTO CCM_MAP_SMControlHost
    SELECT ControlHostId, 0, origCCId, 0, SMArrayId, SMHostName, GUID, ClientId, (CASE WHEN ClientId = 1 THEN 1 ELSE 0 END), 0
FROM #CCM_SMControlHost
    IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_SMControlHost -- INSERT'
        GOTO CX_ERROR_EXIT
    END
    UPDATE CCM_MAP_SMControlHost SET new_origCCId = b.new_id
    FROM CCM_MAP_SMControlHost a, CCM_MAP_Commcell b
    WHERE a.old_origCCId = b.old_id
    IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_SMControlHost -- UPDATE -- new_origCCId'
        GOTO CX_ERROR_EXIT
    END
    UPDATE CCM_MAP_SMControlHost SET new_ClientId = b.new_id
    FROM CCM_MAP_SMControlHost a, CCM_MAP_Client b
    WHERE a.old_ClientId = b.old_id
    IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_SMControlHost -- UPDATE -- new_ClientId'
        GOTO CX_ERROR_EXIT
    END
    UPDATE CCM_MAP_SMControlHost SET new_id = b.ControlHostId, exist = 1
    FROM CCM_MAP_SMControlHost a, SMControlHost b
    WHERE a.GUID = b.GUID
    IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_SMControlHost -- UPDATE -- new_id -- existing control hosts'
        GOTO CX_ERROR_EXIT
    END
    INSERT INTO SMControlHost
    SELECT DISTINCT a.SnapShotEngineId, a.SnapVendorName, a.SMArrayId, a.SMHostIP, a.SMHostName, a.SMHostPortNumber, a.SMHostUserName, a.SMHostPassword,
           a.SMHostFlags, a.SMHostStatus, a.SMHostDescription, a.SnapShotEngineName, a.DeviceGroupName, a.SMHostOption, a.SourceId,
           b.new_origCCId, a.GUID, a.ReserveField1, a.ReserveField2, a.ReserveFieldStr,
           b.new_ClientId, a.SoftState, a.IsEnabled, a.IsActive, a.BrokenCode, a.ReasonCode, a.Flags, a.AdminConsole,
           CAST(a.Properties AS NVARCHAR(MAX)), a.ReserveField3, a.ReserveField4, a.GroupingId, a.UniqueIdentifier, a.CreatedTime, a.ModifiedTime , a.CredentialId
FROM #CCM_SMControlHost a, CCM_MAP_SMControlHost b
    WHERE a.ControlHostId = b.old_id
      AND a.GUID = b.GUID
      AND b.exist = 0
	  AND b.new_ClientId > 0	-- If merge is from v10, we are not capturing client.
    IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- SMControlHost -- INSERT'
        GOTO CX_ERROR_EXIT
    END
    UPDATE CCM_MAP_SMControlHost SET new_id = b.ControlHostId
    FROM CCM_MAP_SMControlHost a, SMControlHost b
    WHERE a.GUID = b.GUID
    IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_SMControlHost -- UPDATE -- new_id -- inserted control hostks'
        GOTO CX_ERROR_EXIT
    END
	-- Merge APP_Credentials table
	DECLARE @credName varchar(1024)
	DECLARE @tempName varchar(1024)
	DECLARE @index integer
	DECLARE @ccellId INTEGER
	DECLARE @credId INTEGER
	DECLARE @credGUID uniqueidentifier
	DECLARE @tempCredId INTEGER
	DECLARE @o_ErrorString varchar(1024)
	DECLARE @o_ErrorCode integer
	DECLARE CUR_APP_CRED CURSOR LOCAL FOR
SELECT credentialName, credentialId, credentialGUID FROM #CCM_APP_Credentials
	OPEN CUR_APP_CRED
	FETCH CUR_APP_CRED INTO @credName, @tempCredId, @credGUID
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF (NOT EXISTS(SELECT 1 FROM APP_Credentials WHERE credentialGUID = @credGUID))
		BEGIN
SELECT @ccellId = new_Id FROM CCM_MAP_CommCell WHERE old_Id = 2
IF ( (@ccmParamFlags & 1  ) = 1  ) /*GRC merge */
			BEGIN
				DECLARE @podCellName VARCHAR(1024)
				IF (SELECT ISNULL(longVal, 0) FROM GRC_CommCellProp
				WHERE commcellId = @ccellId
AND propId = 1 ) = 0        	/*If use prefix is set, then add a prefix always*/
				BEGIN
					SET @podCellName = ISNULL(	(
												SELECT stringVal FROM GRC_CommCellProp
												WHERE commcellId = @ccellId
AND propId = 3
												),
												(
												SELECT aliasName FROM CCM_MAP_CommCell WHERE old_id = 2
												)
											)
					SET @index = PATINDEX (@podCellName+'[_]%', @credName)
					IF @index = 0
						SET @credName = @podCellName + '_' + @credName
				END
				ELSE IF EXISTS (SELECT 1 FROM APP_Credentials WHERE credentialName = @credName)  /*If use suffix is set, then add a suffix only when name exists already*/
				BEGIN
					SET @podCellName = ISNULL(
										(
										SELECT stringVal FROM GRC_CommCellProp
										WHERE commcellId = @ccellId
AND propId = 2
										),
										(SELECT aliasName FROM CCM_MAP_CommCell WHERE old_id = 2)
									)
					SET @index = PATINDEX ('%[_]'+@podCellName, @credName)
					IF @index = 0
					BEGIN
						SET @credName = @credName + '_' + @podCellName
					END
				END
			END
			ELSE
			BEGIN
				SET @index = PATINDEX ('CCM_%', @credName)
				IF @index > 0
				BEGIN
					SET @credName = 'CCM_' + SUBSTRING(@credName, @index+4, 1024)
				END
				ELSE
				BEGIN
					SET @credName = 'CCM_' + @credName
				END
			END
			SET @index = 0
			SET @tempName = @credName
			WHILE ( EXISTS (SELECT 1 FROM APP_Credentials WHERE credentialName = @tempName))
			BEGIN
				SET @index = @index + 1
				SET @tempName = @credName + '(' + cast(@index as varchar(32)) + ')'
			END
			SET @credName = @tempName
			DECLARE @SizeOfnameCol integer
			SELECT @SizeOfnameCol = CHARACTER_MAXIMUM_LENGTH FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME LIKE 'APP_Credentials' AND COLUMN_NAME = 'credentialName'
			IF LEN(@credName)> @SizeOfnameCol
			BEGIN
				SET @credName = SUBSTRING(@credName, 1, @SizeOfnameCol)
			END
			INSERT INTO APP_Credentials
			SELECT @credName, A.recordType, A.userName, '', A.description, A.created, A.enabled, A.flags, A.credentialGUID, A.credentialInfo
FROM #CCM_APP_Credentials A
			WHERE A.credentialId = @tempCredId
			IF  @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Credentials -- INSERT failed for ' + @credName + 'credential'
				GOTO CX_ERROR_EXIT
			END
			SELECT @credId = credentialId FROM APP_Credentials WHERE credentialName = @credName
			EXEC sec_setCreatorForEntity @loggedInUserID = 1, --admin
			@creatorRoleID = 0,
			@creatorPermissions = '220,218',
			@errorCode = @o_ErrorCode OUTPUT,
			@errorString = @o_ErrorString OUTPUT,
			@entityType1 = 174, --CREDENTIAL_ENTITY
			@entityId1 = @credId,
			@creatorUserGroupId = 1 -- master
			IF  @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Credentials -- Setting owner for the credential ' + @credName + 'failed, ErrorStr[' + @o_ErrorString + '] and ErrCode[' + cast(@o_ErrorCode as varchar(256))
				GOTO CX_ERROR_EXIT
			END
		END
		FETCH CUR_APP_CRED INTO @credName, @tempCredId, @credGUID
	END
	CLOSE CUR_APP_CRED
	DEALLOCATE CUR_APP_CRED
	-- Merge APP_CredentialAssoc table
	INSERT INTO CCM_MAP_CredentialAssoc
	SELECT assocId, 0, credentialId, 0, entityId, 0, entityType, CredAssocGUID, 0
FROM #CCM_APP_CredentialAssoc
	IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_CredentialAssoc -- INSERT'
        GOTO CX_ERROR_EXIT
    END
	UPDATE CCM_MAP_CredentialAssoc
	SET new_credentialId = C.credentialId
FROM CCM_MAP_CredentialAssoc A INNER JOIN #CCM_APP_Credentials B ON A.old_credentialId = B.credentialId
		INNER JOIN APP_Credentials C ON B.credentialGUID = C.credentialGUID
	IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_CredentialAssoc -- UPDATE new_credentialId'
        GOTO CX_ERROR_EXIT
    END
	UPDATE CCM_MAP_CredentialAssoc
	SET new_entityId = B.new_id
FROM CCM_MAP_CredentialAssoc A INNER JOIN CCM_MAP_SMControlHost B ON A.old_entityId = B.old_id AND A.entityType = 153
	WHERE A.new_entityId = 0
	IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_CredentialAssoc -- UPDATE new_entityId'
        GOTO CX_ERROR_EXIT
    END
	INSERT INTO APP_CredentialAssoc
	SELECT A.new_credentialId, A.entityType, A.new_entityId, A.CredAssocGUID
	FROM CCM_MAP_CredentialAssoc A
WHERE A.new_entityId > 0 AND A.entityType = 153
		AND NOT EXISTS(SELECT 1 FROM APP_CredentialAssoc B WHERE B.CredAssocGUID = A.CredAssocGUID)
	IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- APP_CredentialAssoc -- INSERT'
        GOTO CX_ERROR_EXIT
    END
	UPDATE CCM_MAP_CredentialAssoc
	SET new_assocId = B.assocId
	FROM CCM_MAP_CredentialAssoc A INNER JOIN APP_CredentialAssoc B ON B.CredAssocGUID = A.CredAssocGUID
	WHERE A.new_assocId = 0
	IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_CredentialAssoc -- UPDATE new_assocId'
        GOTO CX_ERROR_EXIT
    END
	UPDATE SMControlHost
	SET CredentialId = C.new_assocId
	FROM CCM_MAP_SMControlHost A INNER JOIN SMControlHost B ON A.new_id = B.ControlHostId
INNER JOIN CCM_MAP_CredentialAssoc C ON B.ControlHostId = C.new_entityId AND C.entityType = 153
	WHERE A.exist = 0
		AND C.new_assocId > 0
	IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- SMControlHost -- UPDATE CredentialId'
        GOTO CX_ERROR_EXIT
    END
	-- Merge APP_ClientProp table
    --kbora
	--if client is already is imported by tapeimport job, then update all the properties with CCM information
DELETE APP_ClientProp WHERE componentNameId IN (SELECT new_id FROM CCM_TapeImportEntities WHERE entityType = 3)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client --  -- Delete TapeImport properites'
		GOTO CX_ERROR_EXIT
	END
	-- Delete client properties in remerge case if client is already present on dest and modified on source
	DELETE APP_ClientProp
FROM APP_ClientProp A INNER JOIN CCM_MAP_Client B ON A.componentNameId = B.new_Id INNER JOIN #CCM_App_Client C ON B.old_Id = C.id INNER JOIN APP_Client D ON B.new_Id = D.id
	WHERE B.exist = 1 AND C.modified > D.modified AND A.componentNameId = D.id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- DELETE '
		GOTO CX_ERROR_EXIT
	END
	-- update client modified time in remerge case if client is already present on dest and modified on source
	UPDATE APP_Client
	SET modified = C.modified
FROM APP_Client A INNER JOIN CCM_MAP_Client B ON A.id = B.new_id INNER JOIN #CCM_App_Client C ON B.old_Id = C.id
	WHERE A.modified < C.modified AND B.exist = 1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE modified in re-migration case'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO CCM_MAP_ClientProp
	SELECT	componentNameId, 0, attrName, attrType, attrVal, created, modified, 0
FROM	#CCM_App_ClientProp
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_ClientProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ClientProp SET new_componentNameId = b.new_id
FROM	CCM_MAP_ClientProp a, CCM_MAP_Client b
	WHERE	a.old_componentNameId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_ClientProp -- UPDATE new_componentNameId'
		GOTO CX_ERROR_EXIT
	END
	-- Setting passwords to empty.
	UPDATE CMC
	SET attrVal = '' FROM
	CCM_MAP_ClientProp CMC
	INNER JOIN
	APP_CredProps ACP WITH(NOLOCK)
ON ACP.attrPwdName = CMC.attrName AND ACP.cs_attrPwdName = CHECKSUM(CMC.attrName) AND ACP.tableId = 21
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_ClientProp -- Setting passwords to empty.'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(SELECT * FROM CCM_MAP_ClientProp WHERE new_componentNameId = 0)
	BEGIN
		SET @errorString = 'ERROR: New ClientIds not found for APP_ClientProp'
		GOTO CX_ERROR_EXIT
	END
	--Disable Snap Backup properites.
	IF EXISTS(SELECT * FROM CCM_MAP_ClientProp WHERE attrName = 'Snap Backups Enabled')
	BEGIN
		UPDATE CCM_MAP_ClientProp
		SET	attrVal = '0'
		WHERE attrName = 'Snap Backups Enabled' AND attrVal <> '0'
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- Disable Snap Backup properties'
			GOTO CX_ERROR_EXIT
		END
	END
	--Set client cache to CS cache
	IF EXISTS(SELECT * FROM CCM_MAP_ClientProp WHERE attrName = 'UPDATE CACHE AGENT ID')
	BEGIN
		UPDATE CCM_MAP_ClientProp
		SET attrVal = '0'
		WHERE attrName = 'UPDATE CACHE AGENT ID' AND attrVal <> '0'
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- Change software cache to CS '
			GOTO CX_ERROR_EXIT
		END
	END
	--Map Detect MediaAgent for NDMP Server
	IF EXISTS(SELECT 1 FROM CCM_MAP_ClientProp WHERE attrName = 'Detect Media Agent for NDMP Server' AND attrVal <> '0')
	BEGIN
		UPDATE 	CCM_MAP_ClientProp
		SET 	attrVal = CONVERT(varchar(50), ISNULL(b.new_id, 0))
FROM	CCM_MAP_ClientProp a LEFT OUTER JOIN CCM_MAP_Client b ON CONVERT(INT, a.attrVal) = b.old_id
		WHERE 	a.attrName = 'Detect Media Agent for NDMP Server' AND a.attrVal <> '0'
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- Map Detect MediaAgent for NDMP Server '
			GOTO CX_ERROR_EXIT
		END
	END
        -- Begin -Re-map of Proxy clientId for Exchange DAG property
	IF EXISTS(SELECT * FROM CCM_MAP_ClientProp where attrname = 'DAG proxy client')
	BEGIN
		UPDATE 	CCM_MAP_ClientProp
		SET 	attrVal = CAST(ISNULL(b.new_id, '0') AS NVARCHAR)
		FROM	CCM_MAP_ClientProp a
LEFT OUTER JOIN CCM_MAP_Client b ON b.old_id = CAST(a.attrVal AS INTEGER)
		WHERE 	a.attrname = 'DAG proxy client'
				AND b.new_id > 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_ClientProp -- UPDATE - DAG proxy client'
			GOTO CX_ERROR_EXIT
		END
		--Unset DAG use proxy client property if proxy client is not migrated.
		UPDATE 	CCM_MAP_ClientProp
		SET		attrVal = '0'
		WHERE 	attrname = 'DAG use proxy client'  AND modified = 0
				AND NOT EXISTS(SELECT 1 FROM CCM_MAP_ClientProp a WHERE a.attrname = 'DAG proxy client' AND CONVERT(int, ISNULL(attrVal, '0')) > 0  AND modified = 0
									AND a.old_componentNameId = old_componentNameId AND a.new_componentNameId = new_componentNameId)
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_ClientProp -- UPDATE - DAG use proxy client '
			GOTO CX_ERROR_EXIT
		END
	END
	-- End - Re-map of Proxy clientId for Exchange DAG property
	-- Set the owner commcellId
	UPDATE 	CCM_MAP_ClientProp
	SET 	attrVal = CONVERT(VARCHAR(64), B.new_Id)
FROM 	CCM_MAP_ClientProp A INNER JOIN CCM_MAP_CommCell B ON CONVERT(INT, A.attrVal) = B.old_Id AND A.attrName = 'OwnerCommCellId'
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- Failed update OwnerCommCellId. '
		GOTO CX_ERROR_EXIT
	END
	-- Set the new ControlHost id
	UPDATE 	CCM_MAP_ClientProp
	SET 	attrVal = CONVERT(VARCHAR(64), B.new_Id)
	FROM 	CCM_MAP_ClientProp A INNER JOIN CCM_MAP_SMControlHost B ON CONVERT(INT, A.attrVal) = B.old_Id AND A.attrName = 'Snap Control Host ID'
	WHERE 	B.new_id > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- Failed update Snap Control Host ID. '
		GOTO CX_ERROR_EXIT
	END
	-- For property with histories kept in database only
	-- Update modified if property was modified on source but not on destination
	UPDATE	APP_ClientProp SET modified = b.modified
	FROM	APP_ClientProp a, CCM_MAP_ClientProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.created = b.created
	AND		a.modified = 0 AND b.modified <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	-- Update the attrVal if source has the latest setting for a property
	UPDATE	APP_ClientProp SET attrVal = b.attrVal
	FROM	APP_ClientProp a, CCM_MAP_ClientProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.modified = 0 AND b.modified = 0
	AND		a.created < b.created
	-- The list of client properties that we don't want to update
	-- 'Content Indexing Enable' involves with license issue, and cannot be turned on/off by only setting this attribute
	AND		a.attrName NOT IN ('Content Indexing Enabled','Snap Backups Enabled')
	AND a.attrName not like ('%platformdeleted%') --We cannot blindly update this property as it depends on license consumption, this property will be taken care when we call EXEC AppConfDeconf on the client when license related stuffs are taken care in CCMManager
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ClientProp SET exist = 1
	FROM	CCM_MAP_ClientProp a, APP_ClientProp b
	WHERE	a.new_componentNameId = b.componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		(a.created = b.created OR a.modified = 0 AND b.modified = 0)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_ClientProp -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ClientProp
	SET attrName = attrName + ' - CCM Need to map appId'
	WHERE attrName IN ('VSA Discover Subclient ID', 'Last Backup Subclient')
		AND exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- UPDATE attrName'
		GOTO CX_ERROR_EXIT
	END
-- DB: fix for table changes
	INSERT	INTO APP_ClientProp
	SELECT	new_componentNameId, attrName, attrType, attrVal, created, modified, @dummy_ccpId
	FROM	CCM_MAP_ClientProp
	WHERE	exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Handle for the new 7.0 property of client
	-- Active Physical Node (physical client id in cluster)
	UPDATE	APP_ClientProp
	SET		attrVal = c.new_id
FROM	APP_ClientProp a, CCM_MAP_ClientProp b, CCM_MAP_Client c
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrName = 'Active Physical Node'
	AND		a.attrType = b.attrType
	AND		b.attrVal = c.old_id
	AND		((a.modified = 0 AND b.modified = 0 AND	a.created < b.created) OR b.exist = 0)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- UPDATE Active Physical Node attribute'
		GOTO CX_ERROR_EXIT
	END
	DECLARE @commcellId INTEGER
SELECT @commcellId = new_Id FROM CCM_MAP_CommCell WHERE old_Id = 2
	INSERT INTO APP_ClientProp
	SELECT DISTINCT A.new_Id, 'OwnerCommCellId', 7 /* PROPERTY_INTEGER */, @commcellId  , dbo.GetUnixTime(GETUTCDATE()), 0,0
FROM CCM_MAP_Client A INNER JOIN APP_Client B ON A.new_Id = B.id
	WHERE A.exist = 0
		AND NOT EXISTS ( SELECT 1 FROM APP_ClientProp C WHERE C.componentNameId = B.id AND C.attrName = 'OwnerCommCellId' )
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- Failed to set OwanarCommCellId property. '
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge DlpClientPass
	IF OBJECT_ID('#CCM_DlpClientPass') IS NOT NULL
IF EXISTS(SELECT * FROM #CCM_DlpClientPass)
	BEGIN
		INSERT INTO DlpClientPass
		SELECT B.new_id,A.created,A.flags,A.passPhrase
FROM #CCM_DlpClientPass A INNER JOIN CCM_MAP_Client B ON A.clientId = B.old_id
		LEFT OUTER JOIN DlpClientPass C ON B.new_id=C.clientId
										   AND A.created=C.created
										   AND A.flags=C.flags
										   AND A.passPhrase=C.passPhrase
		WHERE  C.clientId IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- DlpClientPass -- INSERT'
			GOTO CX_ERROR_EXIT
		END
	END
	---------------------------------------------------------
	-- Merge APP_Platform table
	INSERT	INTO CCM_MAP_Platform
	SELECT	clientId, 0, platformType, install_dir, refTime, 0
FROM	#CCM_App_Platform
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Platform -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_Platform SET new_clientId = b.new_id
FROM	CCM_MAP_Platform a, CCM_MAP_Client b
	WHERE	a.old_clientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Platform -- UPDATE new_clientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_Platform SET exist = 1
	FROM	CCM_MAP_Platform a, APP_Platform b
	WHERE	a.new_clientId = b.clientId
	AND		a.platformType = b.platformType
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Platform -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	IF @i_mediaAgentMerge = 0
	BEGIN
	    -- Merge of Client Instance
		INSERT	INTO APP_Platform
		SELECT	new_clientId, platformType, install_dir, refTime
		FROM	CCM_MAP_Platform
		WHERE	platformType = 4
		AND		exist = 0
  END
  ELSE
  BEGIN
	    -- Merge of Media Agent Instance
	    -- Media Agent Instance Installation alone too will have APP_Platform records 2 and 4 in the very same Commserv_Merge database
	    -- Record with platformType 4 makes sure that the Media Agent is seen under client computers in commcell GuI.
		INSERT	INTO APP_Platform
		SELECT	new_clientId, platformType, install_dir, refTime
		FROM	CCM_MAP_Platform
		WHERE	platformType in (2,4)
		AND		exist = 0
  END
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Platform -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge APP_IDAName table
	-- GET IdaNameId TO BE MERGED
	INSERT INTO CCM_MAP_IdaName
	SELECT DISTINCT id, 0, clientId, 0, appTypeId, 0
FROM #CCM_App_IDAName
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_IdaName -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_IdaName SET new_clientId = b.new_Id
FROM CCM_MAP_IdaName a, CCM_MAP_Client b
	WHERE a.old_clientId = b.old_Id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_IdaName -- UPDATE -- 1'
		GOTO CX_ERROR_EXIT
	END
	--kbora, updating with compatible appType. This works only for Windows File System IDA.
	IF OBJECT_ID('tempdb..#WinCompatibleAppTypes') IS NOT NULL
		DROP TABLE #WinCompatibleAppTypes
	CREATE TABLE #WinCompatibleAppTypes ( appTypeId INT)
	INSERT INTO #WinCompatibleAppTypes
	SELECT DISTINCT A.type
	FROM APP_iDAType A, APP_AppTypeGroupAssoc B
	WHERE B.appGroupId=57 AND A.displayName LIKE '%File System%' AND A.type = B.appTypeId
	UPDATE APP_IDAName
	SET appTypeId = C.appTypeId
	FROM APP_IDAName A, #WinCompatibleAppTypes B, CCM_MAP_IdaName C,CCM_TapeImportEntities D
	WHERE A.clientId = D.new_id AND A.appTypeId = B.appTypeId AND C.old_clientId = D.old_id AND D.entityType=3
	AND A.appTypeId IN (SELECT appTypeId FROM #WinCompatibleAppTypes) AND C.appTypeId IN (SELECT appTypeId FROM #WinCompatibleAppTypes)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_IdaName -- appTypeId for tape imported iDa'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_IdaName SET new_id = b.id, exist = 1
	FROM CCM_MAP_IdaName a, APP_IDAName b
	WHERE a.new_clientId = b.clientId and a.appTypeId = b.appTypeId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_IdaName -- UPDATE -- 2'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO APP_IDAName
	SELECT	a.new_clientId, b.appTypeId, b.status, b.refTime, b.modified, b.ccpId, b.ccpTime
FROM	CCM_MAP_IdaName a, #CCM_App_IDAName b
	WHERE	a.old_clientId = b.clientId AND a.appTypeId = b.appTypeId
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_IDAName -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_IdaName SET new_id = id
	FROM	CCM_MAP_IdaName a, APP_IDAName b
	WHERE	a.new_clientId = b.clientId AND a.appTypeId = b.appTypeId
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_IdaName -- UPDATE new_id'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge APP_IDAProp table
	INSERT	INTO CCM_MAP_IdaProp
	SELECT	componentNameId, 0, attrName, attrType, attrVal, created, modified, 0
FROM	#CCM_App_IDAProp
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_IdaProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_IdaProp SET new_componentNameId = b.new_id
	FROM CCM_MAP_IdaProp a, CCM_MAP_IdaName b
	WHERE a.old_componentNameId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_IdaProp -- UPDATE new_componentNameId'
		GOTO CX_ERROR_EXIT
	END
	-- Setting passwords to empty.
	UPDATE CMI
	SET attrVal = '' FROM
	CCM_MAP_IdaProp CMI
    INNER JOIN
	APP_CredProps ACP WITH(NOLOCK)
ON ACP.attrPwdName = CMI.attrName AND ACP.cs_attrPwdName = CHECKSUM(CMI.attrName) AND ACP.tableId = 31
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_IdaProp -- Setting passwords to empty'
		GOTO CX_ERROR_EXIT
	END
	-- For property with histories kept in database only
	-- Update modified if property was modified on source but not on destination
	UPDATE	APP_IDAProp SET modified = b.modified
	FROM	APP_IDAProp a, CCM_MAP_IdaProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.created = b.created
	AND		a.modified = 0 AND b.modified <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_IDAProp -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	-- Update the attrVal if source has the latest setting for a property
	UPDATE	APP_IDAProp SET attrVal = b.attrVal
	FROM	APP_IDAProp a, CCM_MAP_IdaProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.modified = 0 AND b.modified = 0
	AND		a.created < b.created
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_IDAProp -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_IdaProp SET exist = 1
	FROM	CCM_MAP_IdaProp a, APP_IDAProp b
	WHERE	a.new_componentNameId = b.componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		(a.created = b.created OR a.modified = 0 AND b.modified = 0)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_IdaProp -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO APP_IDAProp
	SELECT	new_componentNameId, attrName, attrType, attrVal, created, modified, @dummy_ccpId
	FROM	CCM_MAP_IdaProp
	WHERE	exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_IDAProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge APP_DCvolInfo table
	INSERT	INTO CCM_MAP_AppDCvolInfo
	SELECT	componentNameId, 0, volName, 0
FROM	#CCM_App_DCvolInfo
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_AppDCvolInfo -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_AppDCvolInfo SET new_componentNameId = b.new_id
	FROM CCM_MAP_AppDCvolInfo a, CCM_MAP_IdaName b
	WHERE a.old_componentNameId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_AppDCvolInfo -- UPDATE new_componentNameId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_AppDCvolInfo SET exist = 1
	FROM	CCM_MAP_AppDCvolInfo a, APP_DCvolInfo b
	WHERE	a.new_componentNameId = b.componentNameId
	AND		a.volName = b.volName
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_AppDCvolInfo -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO APP_DCvolInfo
	SELECT	a.new_componentNameId, b.volName, b.initialRunStatus, b.state, b.capacity, b.refTime, b.flags
FROM	CCM_MAP_AppDCvolInfo a, #CCM_App_DCvolInfo b
	WHERE	a.old_componentNameId = b.componentNameId
	AND		a.volName = b.volName
	AND		a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_DCvolInfo -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge APP_InstanceName table
	-- GET InstanceId TO BE MERGED
	INSERT INTO CCM_MAP_InstanceName
	SELECT DISTINCT a.id, 0, b.clientId, 0, b.appTypeId, a.name, a.refTime, a.modified, a.status, a.origCCId, 0, a.GUID
FROM #CCM_App_InstanceName a, #CCM_App_Application b
	WHERE a.id = b.instance
	AND   a.id <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceName -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_InstanceName SET new_clientId = b.new_id
FROM CCM_MAP_InstanceName a, CCM_MAP_Client b
	WHERE a.old_clientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceName -- UPDATE new_clientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_InstanceName SET new_origCCId = b.new_id
FROM CCM_MAP_InstanceName a, CCM_MAP_CommCell b
	WHERE a.old_origCCId = b.old_id
    IF   @@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceName -- UPDATE new_origCCId'
		GOTO CX_ERROR_EXIT
	END
	--
	--Match with the GUID, if GUID is empty then match with the name
	--
	UPDATE CCM_MAP_InstanceName SET new_id = b.id
	FROM CCM_MAP_InstanceName a, APP_InstanceName b
	WHERE ( a.GUID = b.GUID AND LEN(a.GUID) > 0 AND a.GUID <> @dummy_GUID ) OR
	-- If default VSA instance exists then don't create another.
( a.name = b.name AND a.status = b.status AND b.name = 'VMInstance' AND b.status = 0x200000 )
    IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceName -- UPDATE -- Match with GUID'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_InstanceName SET new_id = b.id
	FROM CCM_MAP_InstanceName a, APP_InstanceName b, APP_Application c
	WHERE a.name = b.name AND a.refTime = b.refTime
	AND   a.new_clientId = c.clientid
	AND	  a.appTypeId = c.appTypeId
	AND   b.id = c.instance
	AND	  a.new_id = 0
      	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceName -- UPDATE -- 1'
		GOTO CX_ERROR_EXIT
	END
	------------------------------------------------------------------
	--
	-- Make sure there is only one file system iDA per one client even though appTypes are different
	-- Have to match instance, backupset and application all
	--
	UPDATE CCM_MAP_InstanceName SET new_id = b.Instance
	FROM CCM_MAP_InstanceName a, APP_Application b
	WHERE a.new_clientId = b.clientid
	AND	  a.appTypeId IN (SELECT appTypeId FROM @tmpFileSystemAppType)
	AND   b.appTypeId IN (SELECT appTypeId FROM @tmpFileSystemAppType)
	AND	  a.appTypeId <> b.appTypeId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceName -- UPDATE new_id -- only one file system iDA per client'
		GOTO CX_ERROR_EXIT
	END
	------------------------------------------------------------------
    IF @isEDCMerge = 2
	BEGIN
		-- For EDC Merge, merge the default backupset with the existing backupset instead of creating
		-- on always. Required
		UPDATE CCM_MAP_InstanceName SET new_origCCId = c.origCCId, new_id = b.id
		FROM CCM_MAP_InstanceName a, APP_InstanceName b, APP_Application c
		WHERE a.name = b.name --AND a.refTime = b.refTime
		AND   a.new_clientId = c.clientid
		AND   a.appTypeId = c.appTypeId
		AND   b.id = c.instance
	END
    IF  @@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceName -- EDC:Update'
		GOTO CX_ERROR_EXIT
	END
	--
	--PrasadNara: Update the instance in case of GRC, for CCM update only name when source is latest
	--
IF (@ccmParamFlags & 1) > 0
	BEGIN
		UPDATE	App_InstanceName
		SET		name 	= a.name,
				status	= a.status,
				modified= a.modified
		FROM	CCM_MAP_InstanceName a
				INNER JOIN App_InstanceName c ON a.new_id = c.id
		WHERE 	a.modified >= c.modified
				AND a.new_id > 0
		IF  @@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- APP_InstanceName -- UPDATE existing entries'
			GOTO CX_ERROR_EXIT
		END
	END
	ELSE
	BEGIN
		UPDATE	App_InstanceName
		SET		name 	= a.name,
				modified= a.modified
		FROM	CCM_MAP_InstanceName a
				INNER JOIN App_InstanceName c ON a.new_id = c.id
		WHERE 	a.modified >= c.modified
				AND a.new_id > 0
		IF  @@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- APP_InstanceName -- UPDATE existing entries'
			GOTO CX_ERROR_EXIT
		END
	END
	DELETE FROM @tblBeforeMerge
	INSERT INTO @tblBeforeMerge SELECT id FROM APP_InstanceName
	DECLARE @new_id int
	DECLARE @old_id int
	DECLARE @errorCode int
	DECLARE Cur_InstanceName cursor LOCAL for SELECT old_id FROM CCM_MAP_InstanceName WHERE new_id = 0
	OPEN Cur_InstanceName
	FETCH Cur_InstanceName into @old_id
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF	@Merge_To_Same_CommCell > 0 AND @old_id NOT IN (SELECT id FROM @tblBeforeMerge)
		BEGIN
			-------------------------------------------------------------
			-- Merge to same CommCell and id not used, keep the same id
			-------------------------------------------------------------
			SET IDENTITY_INSERT APP_InstanceName ON
			INSERT	INTO APP_InstanceName (
					id, name, refTime, modified, status, origCCId, GUID
					)
			SELECT	old_id, name, refTime, modified, status, new_origCCId, GUID
			FROM	CCM_MAP_InstanceName
			WHERE	old_id = @old_id
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Client -- APP_InstanceName -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			SET IDENTITY_INSERT APP_InstanceName OFF
			SET @new_id = @old_id
		END
		ELSE
		BEGIN
			-------------------------------------------------------------
			-- Merge to same commcell but id is reused, create new id
			-- OR
			-- Merge to different commcell, create new id
			-------------------------------------------------------------
-- DB: fix for table change
			INSERT	INTO APP_InstanceName
			SELECT	name, refTime, modified, status, @dummy_ccpId, @dummy_ccpTime, new_origCCId, GUID
			FROM	CCM_MAP_InstanceName
			WHERE	old_id = @old_id
			SELECT @new_id = SCOPE_IDENTITY(), @errorCode = @@ERROR
			IF	@errorCode > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Client -- APP_InstanceName -- INSERT -- Create new_id'
				GOTO CX_ERROR_EXIT
			END
		END
		UPDATE CCM_MAP_InstanceName SET new_id = @new_id WHERE old_id = @old_id
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceName -- UPDATE new_id After Insertion'
			GOTO CX_ERROR_EXIT
		END
		FETCH Cur_InstanceName into @old_id
	END
	-- Insert the default instance to map table
	INSERT INTO CCM_MAP_InstanceName
	SELECT DISTINCT id, id, 0, 0, 0, name, refTime, modified, status, origCCId, origCCId, GUID
	FROM APP_InstanceName
	WHERE id = 1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceName -- Get Default Instance'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge APP_InstanceProp table
	INSERT	INTO CCM_MAP_InstanceProp
	SELECT	componentNameId, 0, attrName, attrType, attrVal, created, modified, 0
FROM	#CCM_App_InstanceProp
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_InstanceProp SET new_componentNameId = b.new_id
	FROM CCM_MAP_InstanceProp a, CCM_MAP_InstanceName b
	WHERE a.old_componentNameId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- UPDATE new_componentNameId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_InstanceProp SET attrVal = b.new_id
	FROM	CCM_MAP_InstanceProp a, CCM_MAP_ArchGroup b
	WHERE	a.attrName like 'DB2 Default % SP'
	AND		a.attrVal = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- UPDATE new_componentNameId'
		GOTO CX_ERROR_EXIT
	END
	-- Setting passwords to empty.
	UPDATE CMI
	SET attrVal = '' FROM
	CCM_MAP_InstanceProp CMI
    INNER JOIN
	APP_CredProps ACP WITH(NOLOCK)
ON ACP.attrPwdName = CMI.attrName AND ACP.cs_attrPwdName = CHECKSUM(CMI.attrName) AND ACP.tableId = 41
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- Setting passwords to empty.'
		GOTO CX_ERROR_EXIT
	END
	-- Re-Map the client ids stored in property DB2 Partition Clients in APP_InstanceProp
	DECLARE @old_componentNameId integer
	DECLARE @new_componentNameId integer
	DECLARE @attrVal nvarchar(max)
	DECLARE @newattrVal nvarchar(max)
	DECLARE @lt_map_table TABLE (PartitionId INT , oldClientId INT, newClientId INT)
	DECLARE @lt_reform DB2PartitionString
	DECLARE	CUR_DB2DBF_InstanceProp cursor LOCAL for
		SELECT	old_componentNameId,new_componentNameId,attrVal
		FROM	CCM_MAP_InstanceProp
		WHERE	attrName = 'DB2 Partition Clients'
	OPEN CUR_DB2DBF_InstanceProp
	FETCH CUR_DB2DBF_InstanceProp into @old_componentNameId,@new_componentNameId,@attrVal
	WHILE @@FETCH_STATUS = 0
	BEGIN
	    INSERT INTO @lt_map_table
        SELECT *,0 FROM parseDB2PartitionClientIdString(@attrVal)
        IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- INSERT @lt_map_table'
			GOTO CX_ERROR_EXIT
		END
        UPDATE @lt_map_table SET newClientId = b.new_id
FROM @lt_map_table a, CCM_MAP_Client b
        WHERE a.oldClientId = b.old_id
        IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- UPDATE @lt_map_table -- newClientId'
			GOTO CX_ERROR_EXIT
		END
        INSERT INTO @lt_reform
        SELECT PartitionId, newClientId
        FROM @lt_map_table
        IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- INSERT @lt_reform'
			GOTO CX_ERROR_EXIT
		END
        SET @newattrVal = dbo.formDB2PartitionClientIdString(@lt_reform)
        DELETE FROM @lt_map_table
        IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- DELETE @lt_map_table'
			GOTO CX_ERROR_EXIT
		END
        DELETE FROM @lt_reform
        IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- DELETE @lt_reform'
			GOTO CX_ERROR_EXIT
		END
        UPDATE	CCM_MAP_InstanceProp SET attrVal = @newattrVal
		FROM	CCM_MAP_InstanceProp
		WHERE	attrName = 'DB2 Partition Clients'
		AND		attrVal = @attrVal
		AND     old_componentNameId = @old_componentNameId
		AND     new_componentNameId = @new_componentNameId
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- UPDATE attrVal DB2DPF'
			GOTO CX_ERROR_EXIT
		END
		FETCH CUR_DB2DBF_InstanceProp into @old_componentNameId,@new_componentNameId,@attrVal
	END
	CLOSE CUR_DB2DBF_InstanceProp
	DEALLOCATE CUR_DB2DBF_InstanceProp
	-- Re-map of client ids done for DB2 DPF Property
	-- Begin -Re-map of Database clientId for Documentum instance property
	IF EXISTS(SELECT * FROM CCM_MAP_InstanceProp where attrname = 'DOCUMENTUM DbClientId')
	BEGIN
		UPDATE CCM_MAP_InstanceProp SET attrVal = CAST(a.new_id AS NVARCHAR)
FROM CCM_MAP_Client a,CCM_MAP_InstanceProp
		WHERE attrname = 'DOCUMENTUM DbClientId'
		AND a.old_id = CAST(attrVal AS INTEGER)
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- UPDATE - Documentum DbClientId '
			GOTO CX_ERROR_EXIT
		END
	END
	-- End - Re-map of Database clientId for Documentum instance property
	-- Re-Map the client ids stored in property for SAP HANA Database Clients in APP_InstanceProp
	DECLARE	CUR_SAP_HANA_InstanceProp cursor LOCAL FORWARD_ONLY for
		SELECT	old_componentNameId,new_componentNameId,attrVal
		FROM	CCM_MAP_InstanceProp
		WHERE	attrName = 'Database Clients'
	OPEN CUR_SAP_HANA_InstanceProp
	FETCH CUR_SAP_HANA_InstanceProp into @old_componentNameId,@new_componentNameId,@attrVal
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @newattrVal = ''
	    SELECT @newattrVal = (@newattrVal + '+' + CONVERT(varchar, b.new_Id))
		FROM
			(
				SELECT  ROW_NUMBER() OVER (ORDER BY ((SELECT NULL))) AS RowId, _ID
				FROM dbo.CCM_SplitStringByToken(@attrVal, '+')
			) a,
			CCM_MAP_Client b
        WHERE a._ID = b.old_id and b.new_id > 0
		ORDER BY RowId
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- new attrVal'
			GOTO CX_ERROR_EXIT
		END
		-- If the Database Client is not auto captured (XML based capture), then we don't get newId so this newattrVal will be empty.
		IF LEN(@newattrVal) > 0
			SET @newattrVal = RIGHT(@newattrVal, LEN(@newattrVal)-1)
		UPDATE	CCM_MAP_InstanceProp
		SET 	attrVal = @newattrVal
		WHERE	attrName = 'Database Clients'
		AND		attrVal = @attrVal
		AND     old_componentNameId = @old_componentNameId
		AND     new_componentNameId = @new_componentNameId
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- UPDATE attrVal Database Clients'
			GOTO CX_ERROR_EXIT
		END
		DELETE	CCM_MAP_InstanceProp
		WHERE	attrName = 'Database Clients' AND ISNULL(attrVal, '') = ''
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- DELETE Database Clients'
			GOTO CX_ERROR_EXIT
		END
		FETCH CUR_SAP_HANA_InstanceProp into @old_componentNameId,@new_componentNameId,@attrVal
	END
	CLOSE CUR_SAP_HANA_InstanceProp
	DEALLOCATE CUR_SAP_HANA_InstanceProp
	-- Re-map of client ids done for SAP HANA Database clients Property
	-- Begin -Re-map of Proxy clientId for SQL Always ON instance property
	IF EXISTS(SELECT * FROM CCM_MAP_InstanceProp where attrname = 'Proxy Client Id')
	BEGIN
		UPDATE 	CCM_MAP_InstanceProp
		SET 	attrVal = CAST(ISNULL(b.new_id, '0') AS NVARCHAR)
		FROM	CCM_MAP_InstanceProp a
LEFT OUTER JOIN CCM_MAP_Client b ON b.old_id = CAST(a.attrVal AS INTEGER)
		WHERE 	a.attrname = 'Proxy Client Id'
				AND b.new_id > 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- UPDATE - Proxy Client Id '
			GOTO CX_ERROR_EXIT
		END
		--Delete property if proxy client is not migrated.
		DELETE 	CCM_MAP_InstanceProp
		WHERE 	attrname = 'Proxy Client Id' AND attrVal = '0'
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- DELETE - Proxy Client Id '
			GOTO CX_ERROR_EXIT
		END
		--Delete proxy client name property if proxy client is not migrated.
		DELETE 	CCM_MAP_InstanceProp
		WHERE 	attrname = 'Proxy Client Name'
				AND NOT EXISTS(SELECT 1 FROM CCM_MAP_InstanceProp a WHERE a.attrname = 'Proxy Client Id'
									AND a.old_componentNameId = old_componentNameId AND a.new_componentNameId = new_componentNameId)
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- DELETE - Proxy Client Id '
			GOTO CX_ERROR_EXIT
		END
	END
	-- End - Re-map of Proxy clientId for SQL Always ON instance property
	-- Map VSA memberservers
	DECLARE @xmlStr XML
	DECLARE	CUR_VSA_InstanceProps  CURSOR LOCAL FOR
	SELECT new_componentNameId, attrVal FROM CCM_MAP_InstanceProp WHERE attrName = 'Vs Member Servers'
	OPEN CUR_VSA_InstanceProps
	FETCH CUR_VSA_InstanceProps INTO @new_componentNameId,@attrVal
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF OBJECT_ID('tempdb..#memberServers') IS NOT NULL
		   DROP TABLE #memberServers
		CREATE TABLE #memberServers
		(
		_type_ INT,
		clientId INT,
		clientName NVARCHAR(1024),
		clientSidePackage INT,
		consumeLicense INT,
		srmReportSet INT,
		srmReportType INT,
		type INT
		)
		SET @xmlStr = CAST(@attrVal AS XML)
		INSERT INTO #memberServers
		SELECT
		doc.col.value('@_type_', 'INT'),
		doc.col.value('@clientId', 'INT'),
		doc.col.value('@clientName', 'NVARCHAR(1024)'),
		doc.col.value('@clientSidePackage', 'INT'),
		doc.col.value('@consumeLicense', 'INT'),
		doc.col.value('@srmReportSet', 'INT'),
		doc.col.value('@srmReportType', 'INT'),
		doc.col.value('@type', 'INT')
		FROM @xmlStr.nodes('/App_MemberServers/memberServers/client') doc(col)
		DELETE #memberServers
WHERE clientId NOT IN ( SELECT old_id FROM CCM_MAP_Client)
		UPDATE #memberServers
		SET clientId = B.new_id
FROM #memberServers A INNER JOIN CCM_MAP_Client B ON A.clientId = B.old_id
		DECLARE @memberServers XML =
		(
		SELECT _type_ as 'client/@_type_',
				clientId as 'client/@clientId',
				clientName as 'client/@clientName',
				clientSidePackage as 'client/@clientSidePackage',
				srmReportSet as 'client/@srmReportSet',
				type as 'client/@type'
		FROM #memberServers
		FOR xml PATH ('memberServers')
		)
		DECLARE @tempAttrVal XML =
		(
		SELECT
		@memberServers
		FOR XML PATH('App_MemberServers' )
		)
		UPDATE 	CCM_MAP_InstanceProp
		SET 	attrVal = CAST(@tempAttrVal AS NVARCHAR(MAX))
		FROM	CCM_MAP_InstanceProp
		WHERE 	new_componentNameId = @new_componentNameId
			AND attrName = 'Vs Member Servers'
		FETCH CUR_VSA_InstanceProps INTO @new_componentNameId,@attrVal
	END
	-- For property with histories kept in database only
	-- Update modified if property was modified on source but not on destination
	UPDATE	APP_InstanceProp SET modified = b.modified
	FROM	APP_InstanceProp a, CCM_MAP_InstanceProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.created = b.created
	AND		a.modified = 0 AND b.modified <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_InstanceProp -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	-- Update the attrVal if source has the latest setting for a property
	UPDATE	APP_InstanceProp SET attrVal = b.attrVal
	FROM	APP_InstanceProp a, CCM_MAP_InstanceProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.modified = 0 AND b.modified = 0
	AND		a.created < b.created
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_InstanceProp -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_InstanceProp SET exist = 1
	FROM	CCM_MAP_InstanceProp a, APP_InstanceProp b
	WHERE	a.new_componentNameId = b.componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		(a.created = b.created OR a.modified = 0 AND b.modified = 0)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_InstanceProp -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	-- Set the new ControlHost id
	UPDATE 	CCM_MAP_InstanceProp
	SET 	attrVal = CONVERT(VARCHAR(64), B.new_Id)
	FROM 	CCM_MAP_InstanceProp A INNER JOIN CCM_MAP_SMControlHost B ON CONVERT(INT, A.attrVal) = B.old_Id AND A.attrName = 'Array ID'
	WHERE 	B.new_id > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- Failed update Array ID.'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO APP_InstanceProp
	SELECT	new_componentNameId, attrName, attrType, attrVal, created, modified, @dummy_ccpId
	FROM	CCM_MAP_InstanceProp
	WHERE	exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_InstanceProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Merge APP_CredentialAssoc table
	UPDATE CCM_MAP_CredentialAssoc
	SET new_entityId = B.new_id
FROM CCM_MAP_CredentialAssoc A INNER JOIN CCM_MAP_InstanceName B ON A.old_entityId = B.old_id AND A.entityType = 5
	WHERE A.new_entityId = 0
	IF  @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_CredentialAssoc -- UPDATE new_entityId for instance.'
        GOTO CX_ERROR_EXIT
    END
	INSERT INTO APP_CredentialAssoc
	SELECT A.new_credentialId, A.entityType, A.new_entityId, A.CredAssocGUID
	FROM CCM_MAP_CredentialAssoc A
WHERE A.new_entityId > 0 AND A.entityType = 5
		AND NOT EXISTS(SELECT 1 FROM APP_CredentialAssoc B WHERE B.CredAssocGUID = A.CredAssocGUID)
	IF @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- APP_CredentialAssoc -- INSERT'
        GOTO CX_ERROR_EXIT
    END
	UPDATE CCM_MAP_CredentialAssoc
	SET new_assocId = B.assocId
	FROM CCM_MAP_CredentialAssoc A INNER JOIN APP_CredentialAssoc B ON B.CredAssocGUID = A.CredAssocGUID
	WHERE A.new_assocId = 0
		AND B.assocId > 0
	IF @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_CredentialAssoc -- UPDATE new_assocId'
        GOTO CX_ERROR_EXIT
    END
	UPDATE APP_InstanceProp
	SET attrVal = CAST(B.new_assocId AS VARCHAR(64))
	FROM CCM_MAP_InstanceProp A
INNER JOIN CCM_MAP_CredentialAssoc B ON A.new_componentNameId = B.new_entityId AND B.entityType = 5 AND A.attrName = 'Virtual Server Credential Assoc Id' AND B.old_assocId = CAST(A.attrVal AS INT)
		INNER JOIN APP_InstanceProp C ON C.componentNameId = A.new_componentNameId AND A.attrName = C.attrName AND C.modified = 0
	WHERE A.exist = 0
	IF @@ERROR > 0
    BEGIN
        SET @errorString = 'ERROR: CCM_Merge_Client -- APP_InstanceProp -- UPDATE - Virtual Server Credential Assoc Id'
        GOTO CX_ERROR_EXIT
    END
	---------------------------------------------------------
	-- Merge APP_BackupSetName table
UPDATE #CCM_App_BackupSetName
	SET    origCCId = 2
	WHERE  origCCId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_APP_BackupSetName -- UPDATE -- origCCId'
		GOTO CX_ERROR_EXIT
	END
	-- GET BackupSetId TO BE MERGED
	INSERT INTO CCM_MAP_BackupSetName
	SELECT DISTINCT a.id, 0, b.clientid, 0, b.instance, 0, b.appTypeId, a.name, a.refTime, a.modified, a.status, a.origCCId, 0,
			ISNULL(NULLIF(a.GUID, @dummy_GUID), NEWID()) -- bring in the GUID, create a new one if the capture has a NULL or a 0d GUID.
FROM #CCM_App_BackupSetName a, #CCM_App_Application b
	WHERE a.id = b.backupSet
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetName -- INSERT'
		GOTO CX_ERROR_EXIT
	END
IF EXISTS (SELECT * FROM #CCM_App_BackupSetName
WHERE id in (SELECT componentNameId FROM #CCM_App_BackupSetProp WHERE attrName = 'SILO Copy ID' AND attrVal > 0))
	BEGIN
		UPDATE CCM_MAP_BackupSetName SET new_clientId = 2
WHERE old_id in (SELECT componentNameId FROM #CCM_App_BackupSetProp WHERE attrName = 'SILO Copy ID' AND attrVal > 0)
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetName -- Reassign SILO BackupSet to Destination Commserv Client'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_BackupSetName SET name = 'SILO_BackupSet_'+B.name+'_'+C.name
FROM #CCM_App_BackupSetProp A, archGroup B, archGroupCopy C, CCM_MAP_ArchGroupCopy D
		WHERE CCM_MAP_BackupSetName.old_id = A.componentNameId
		AND A.attrName = 'SILO Copy ID'
		AND A.attrVal > 0
		AND A.attrVal = D.old_id
		AND D.new_id <> 0
		AND D.new_id = C.id
		AND C.archGroupId = B.id
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetName -- Update SILO BackupSet Name'
			GOTO CX_ERROR_EXIT
		END
	END
	UPDATE CCM_MAP_BackupSetName SET new_clientId = b.new_id
FROM CCM_MAP_BackupSetName a, CCM_MAP_Client b
	WHERE a.old_clientId = b.old_id
	AND new_clientId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetName -- UPDATE new_clientId'
		GOTO CX_ERROR_EXIT
	END
UPDATE CCM_MAP_BackupSetName SET new_origCCId = ISNULL((SELECT new_id FROM CCM_MAP_CommCell WHERE old_id = old_origCCId), (SELECT new_id FROM CCM_MAP_CommCell WHERE old_id = 2 /*Source CS*/))
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetName -- UPDATE new_origCCId'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS (SELECT * FROM CCM_MAP_BackupSetName WHERE new_origCCId = 0)
	BEGIN
	    SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetName -- unknown new_origCCId ids'
		GOTO CX_ERROR_EXIT
	END
	-- For default instance id 1, CCM_MAP_InstanceName table has appTypeId as 0.
	-- Therefore, if instance id is 1, the new instance id still remain 1 as DefaultInstanceName
	UPDATE CCM_MAP_BackupSetName SET new_instanceId = b.new_id
	FROM CCM_MAP_BackupSetName a, CCM_MAP_InstanceName b
	WHERE a.old_instanceId = b.old_id
	AND   ( a.appTypeId = b.appTypeId OR a.old_instanceId = 1 )
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetName -- UPDATE new_instanceId'
		GOTO CX_ERROR_EXIT
	END
	--
	--Match with GUID, if GUID is empty then match with name
	--
	UPDATE CCM_MAP_BackupSetName SET new_id = b.id
	FROM CCM_MAP_BackupSetName a, APP_BackupSetName b
	WHERE a.GUID = b.GUID AND LEN(a.GUID) > 0 AND a.GUID <> @dummy_GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetName -- UPDATE new_id match with GUID'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_BackupSetName SET new_id = b.id
	FROM CCM_MAP_BackupSetName a, APP_BackupSetName b, APP_Application c
	WHERE a.name = b.name AND a.refTime = b.refTime
	AND   a.new_clientId = c.clientid
	AND   a.new_instanceId = c.instance
	AND   a.appTypeId = c.appTypeId
	AND   b.id = c.BackupSet
	AND   a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetName -- UPDATE new_id'
		GOTO CX_ERROR_EXIT
	END
	IF @isEDCMerge = 2
	BEGIN
		UPDATE CCM_MAP_BackupSetName SET new_id = b.id, new_origCCId = b.origCCId
		FROM
		CCM_MAP_BackupSetName a, APP_BackupSetName b, APP_Application c
		WHERE a.name = b.name AND
		a.new_clientId = c.clientid
		AND   a.new_instanceId = c.instance
		AND   a.appTypeId = c.appTypeId
		AND   b.id = c.BackupSet
	END
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetName -- UPDATE new_id FOR EDC BackupSet'
		GOTO CX_ERROR_EXIT
	END
	------------------------------------------------------------------
	--
	-- Make sure there is only one file system iDA per one client even though appTypes are different
	-- Have to match instance, backupset and application all
	--
	UPDATE CCM_MAP_BackupSetName SET new_id = c.Id
	FROM CCM_MAP_BackupSetName a, APP_Application b, APP_BackupSetName c
	WHERE  a.new_clientId = b.clientid
	AND   a.new_instanceId = b.instance
	AND	  a.appTypeId IN (SELECT appTypeId FROM @tmpFileSystemAppType)
	AND   b.appTypeId IN (SELECT appTypeId FROM @tmpFileSystemAppType)
	AND   a.appTypeId <> b.appTypeId
	AND		b.BackupSet = c.Id
	AND		((a.GUID = c.GUID AND LEN(a.GUID) > 0 AND a.GUID <> @dummy_GUID) OR a.name = c.name)
	AND		a.refTime = c.refTime
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetName -- UPDATE new_id-- only one file system iDA per client'
		GOTO CX_ERROR_EXIT
	END
	--
	--PrasadNara: Update the backupset in case of GRC, for CCM update only name when source is latest
	--
IF (@ccmParamFlags & 1) > 0
	BEGIN
		UPDATE	App_BackupSetName
		SET		name 	= a.name,
				status	= a.status,
				modified= a.modified
		FROM	CCM_MAP_BackupSetName a
				INNER JOIN App_BackupSetName c ON a.new_id = c.id
		WHERE 	a.modified >= c.modified
				AND a.new_id > 0
		IF  @@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- APP_BackupSetName -- UPDATE existing entries'
			GOTO CX_ERROR_EXIT
		END
	END
	ELSE
	BEGIN
		UPDATE	App_BackupSetName
		SET		name 	= a.name,
				modified= a.modified
		FROM	CCM_MAP_BackupSetName a
				INNER JOIN App_BackupSetName c ON a.new_id = c.id
		WHERE 	a.modified >= c.modified
				AND a.new_id > 0
		IF  @@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- APP_BackupSetName -- UPDATE existing entries'
			GOTO CX_ERROR_EXIT
		END
	END
	------------------------------------------------------------------
	DELETE FROM @tblBeforeMerge
	INSERT INTO @tblBeforeMerge SELECT id FROM APP_BackupSetName
	DECLARE Cur_BackupSetName cursor LOCAL for SELECT old_id FROM CCM_MAP_BackupSetName WHERE new_id = 0
	OPEN Cur_BackupSetName
	FETCH Cur_BackupSetName into @old_id
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF EXISTS ( SELECT 1 FROM CCM_MAP_BackupSetName a, APP_BackupSetName b, APP_Application c
					WHERE a.new_clientId = c.clientid
					AND   a.new_instanceId = c.instance
					AND   a.appTypeId = c.appTypeId
					AND   b.id = c.BackupSet
AND  (b.status & 0x00008 = 0x00008)
AND  (a.status & 0x00008 = 0x00008)
					AND   a.old_id = @old_id )
		BEGIN
			UPDATE CCM_MAP_BackupSetName
SET status = (status & (~CAST(0x00008 AS INT)))
			FROM CCM_MAP_BackupSetName
WHERE (status & 0x00008 = 0x00008)
			AND old_id = @old_id
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetName -- Update status.'
				GOTO CX_ERROR_EXIT
			END
		END
		IF	@Merge_To_Same_CommCell > 0 AND @old_id NOT IN (SELECT id FROM @tblBeforeMerge)
		BEGIN
			-------------------------------------------------------------
			-- Merge to same CommCell and id not used, keep the same id
			-------------------------------------------------------------
			SET IDENTITY_INSERT APP_BackupSetName ON
			INSERT	INTO APP_BackupSetName (
					id, name, refTime, modified, status, ccpId, ccpTime, origCCId, GUID
					)
			SELECT	old_id, name, refTime, modified, status, @dummy_ccpId, @dummy_ccpTime, new_origCCId, GUID
			FROM	CCM_MAP_BackupSetName
			WHERE	old_id = @old_id
			SELECT @new_id = @old_id, @errorCode = @@ERROR
			IF	@errorCode > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Client -- APP_BackupSetName -- INSERT with old_id'
				GOTO CX_ERROR_EXIT
			END
			SET IDENTITY_INSERT APP_BackupSetName OFF
		END
		ELSE
		BEGIN
			-------------------------------------------------------------
			-- Merge to same commcell but id is reused, create new id
			-- OR
			-- Merge to different commcell, create new id
			-------------------------------------------------------------
-- DB: fix table change:
			INSERT	INTO APP_BackupSetName
			SELECT	name, refTime, modified, status, @dummy_ccpId, @dummy_ccpTime, new_origCCId, GUID
			FROM	CCM_MAP_BackupSetName
			WHERE	old_id = @old_id
			SELECT @new_id = SCOPE_IDENTITY(), @errorCode = @@ERROR
			IF	@errorCode > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Client -- APP_BackupSetName -- INSERT with new_id'
				GOTO CX_ERROR_EXIT
			END
		END
		UPDATE CCM_MAP_BackupSetName SET new_id = @new_id WHERE old_id = @old_id
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetName -- UPDATE new_id After Insertion'
			GOTO CX_ERROR_EXIT
		END
		FETCH Cur_BackupSetName into @old_id
	END
	---------------------------------------------------------
	-- Merge APP_VMBackupSet table
	INSERT INTO APP_VMBackupSet
	SELECT CL.new_id, PBKP.new_id, CBKP.new_id
FROM #CCM_APP_VMBackupSet VM
		INNER JOIN CCM_MAP_BackupSetName PBKP ON VM.ParentBackupSetId = PBKP.old_Id
		INNER JOIN CCM_MAP_BackupSetName CBKP ON VM.ChildBackupSetId = CBKP.old_id
		INNER JOIN CCM_MAP_Client CL ON VM.VMClientId = CL.old_id
	WHERE NOT EXISTS (SELECT 1 FROM APP_VMBackupSet WHERE VMClientId = CL.new_id AND ParentBackupSetId = PBKP.new_id AND ChildBackupSetId = CBKP.new_id)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_VMBackupSet -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge APP_BackupSetProp table
	INSERT	INTO CCM_MAP_BackupSetProp
	SELECT	componentNameId, 0, attrName, attrType, attrVal, created, modified, 0
FROM	#CCM_App_BackupSetProp
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_BackupSetProp SET new_componentNameId = b.new_id
	FROM CCM_MAP_BackupSetProp a, CCM_MAP_BackupSetName b
	WHERE a.old_componentNameId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetProp -- UPDATE new_componentNameId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_BackupSetProp SET attrVal = b.new_id
	FROM	CCM_MAP_BackupSetProp a, CCM_MAP_ArchGroup b
	WHERE	a.attrName like 'DB2 Default % SP'
	AND		a.attrVal = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetProp -- UPDATE new_componentNameId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_BackupSetProp SET attrVal = b.new_id
	FROM	CCM_MAP_BackupSetProp a, CCM_MAP_ArchGroupCopy b
	WHERE	a.attrName = 'SILO Copy ID' AND a.attrVal > 0
	AND		a.attrVal = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetProp -- UPDATE SILO Copy Id'
		GOTO CX_ERROR_EXIT
	END
	-- Setting passwords to empty.
	UPDATE CMB
	SET attrVal = '' FROM
	CCM_MAP_BackupsetProp CMB
    INNER JOIN
	APP_CredProps ACP WITH(NOLOCK)
ON ACP.attrPwdName = CMB.attrName AND ACP.cs_attrPwdName = CHECKSUM(CMB.attrName) AND ACP.tableId = 51
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetProp -- Setting passwords to empty.'
		GOTO CX_ERROR_EXIT
	END
	-- For property with histories kept in database only
	-- Update modified if property was modified on source but not on destination
	UPDATE	APP_BackupSetProp SET modified = b.modified
	FROM	APP_BackupSetProp a, CCM_MAP_BackupSetProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.created = b.created
	AND		a.modified = 0 AND b.modified <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_BackupSetProp -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	-- Update the attrVal if source has the latest setting for a property
	UPDATE	APP_BackupSetProp SET attrVal = b.attrVal
	FROM	APP_BackupSetProp a, CCM_MAP_BackupSetProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.modified = 0 AND b.modified = 0
	AND		a.created < b.created
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_BackupSetProp -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_BackupSetProp SET exist = 1
	FROM	CCM_MAP_BackupSetProp a, APP_BackupSetProp b
	WHERE	a.new_componentNameId = b.componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		(a.created = b.created OR a.modified = 0 AND b.modified = 0)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_BackupSetProp -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO APP_BackupSetProp
	SELECT	new_componentNameId, attrName, attrType, attrVal, created, modified, @dummy_ccpId
	FROM	CCM_MAP_BackupSetProp
	WHERE	exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_BackupSetProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Reset certain attributes for backupset properties
	UPDATE	APP_BackupSetProp SET attrVal = 0
	FROM	APP_BackupSetProp a, CCM_MAP_BackupSetProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		((a.modified = 0 AND b.modified = 0 AND a.created < b.created) OR b.exist = 0)
	AND		b.attrName in ('Associated subclient policy')
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_BackupSetProp -- UPDATE attributes'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge APP_OracleRacInstance table
	INSERT	INTO CCM_MAP_AppOracleRacInstance
	SELECT	id, 0, instaceId, 0, clientId, 0, 0
FROM	#CCM_App_OracleRacInstance
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_AppOracleRacInstance -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_AppOracleRacInstance SET new_instanceId = b.new_id
	FROM CCM_MAP_AppOracleRacInstance a, CCM_MAP_InstanceName b
	WHERE a.old_instanceId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_AppOracleRacInstance -- UPDATE new_instanceId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_AppOracleRacInstance SET new_clientId = b.new_id
FROM CCM_MAP_AppOracleRacInstance a, CCM_MAP_Client b
	WHERE a.old_clientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_AppOracleRacInstance -- UPDATE new_clientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_AppOracleRacInstance SET exist = 1
	FROM	CCM_MAP_AppOracleRacInstance a, APP_OracleRacInstance b
	WHERE	a.new_instanceId = b.instaceId
	AND		a.new_clientId = b.clientId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_AppOracleRacInstance -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO APP_OracleRacInstance
	SELECT	a.new_instanceId, a.new_clientId,
			b.name, b.oracleHome, b.oracleUser, b.parellelInstance,
			b.InstanceOraUser, b.InstanceOraPasswd, b.InstanceOraService,
			b.tnsAdmin, b.threadId, b.instanceNumber, b.flag, b.status, b.sbtLibName, b.ntPassword
FROM	CCM_MAP_AppOracleRacInstance a, #CCM_App_OracleRacInstance b
	WHERE	a.old_instanceId = b.instaceId
	AND		a.old_clientId = b.clientId
	AND		a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_OracleRacInstance -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_AppOracleRacInstance SET new_id = b.id
	FROM CCM_MAP_AppOracleRacInstance a, APP_OracleRacInstance b
	WHERE	a.new_instanceId = b.instaceId
	AND		a.new_clientId = b.clientId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_AppOracleRacInstance -- UPDATE new_id'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	INSERT INTO CCM_MAP_VMToPMMap
    SELECT VMClientId, 0, PMClientId, 0, 0
FROM #CCM_App_VMToPMMap
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_VMToPMMap -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_VMToPMMap
	SET newVMClientId = b.new_id
FROM CCM_MAP_VMToPMMap a, CCM_MAP_Client b
	WHERE a.oldVMClientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_VMToPMMap -- UPDATE -- newVMClientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_VMToPMMap
	SET newPMClientId = b.new_id
FROM CCM_MAP_VMToPMMap a, CCM_MAP_Client b
	WHERE a.oldPMClientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_VMToPMMap -- UPDATE -- newPMClientId'
		GOTO CX_ERROR_EXIT
	END
	-- Remove dependent cluster clients if not auto captured.
	DELETE CCM_MAP_VMToPMMap WHERE newPMClientId = 0 OR newVMClientId = 0
	UPDATE CCM_MAP_VMToPMMap
	SET exist = 1
	FROM CCM_MAP_VMToPMMap a, APP_VMToPMMap b
	WHERE a.newVMClientId = b.VMClientId
	  AND a.newPMClientId = b.PMClientId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_VMToPMMap -- UPDATE -- exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO APP_VMToPMMap
	SELECT newVMClientId, newPMClientId
	FROM CCM_MAP_VMToPMMap
	WHERE exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_VMToPMMap -- INSERT -- exist'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- MMNDMPHostInfo --
IF EXISTS (SELECT * FROM #CCM_MMNDMPHostInfo WHERE NDMPHostId > 0)
	BEGIN
		DECLARE @MMS2NDMPHostInfo_NDMPHostId				INTEGER
DECLARE @MMS2NDMPHostInfo_Login						varchar(1024)
DECLARE @MMS2NDMPHostInfo_Password					varchar(2048)
		DECLARE @MMS2NDMPHostInfo_ListenPort				INTEGER
DECLARE @MMS2NDMPHostInfo_FirmwareRevision			varchar(32)
		DECLARE @MMS2NDMPHostInfo_OSType					INTEGER
		DECLARE @MMS2NDMPHostInfo_AuthenticationScheme		INTEGER
		DECLARE @MMS2NDMPHostInfo_ProtocolType				INTEGER
DECLARE @MMS2NDMPHostInfo_ProtocolRevision			varchar(32)
		DECLARE @MMS2NDMPHostInfo_CapabilityFlags			INTEGER
		DECLARE @MMS2NDMPHostInfo_ClientId					INTEGER
		DECLARE @MMS2NDMPHostInfo_newClientId				INTEGER
		DECLARE @MMS2NDMPHostInfo_newNDMPHostId				INTEGER
		DECLARE CCM_MMS2NDMPHostInfoCursor Cursor LOCAL For
		SELECT distinct a.NDMPHostId, a.Login, a.Password, a.ListenPort, a.FirmwareRevision,
		a.OSType, a.AuthenticationScheme, a.ProtocolType, a.ProtocolRevision, a.CapabilityFlags,
		a.ClientId, b.new_id
FROM #CCM_MMNDMPHostInfo a, CCM_MAP_Client b
		WHERE a.ClientId = b.old_id
		OPEN CCM_MMS2NDMPHostInfoCursor
		FETCH NEXT FROM CCM_MMS2NDMPHostInfoCursor
		INTO @MMS2NDMPHostInfo_NDMPHostId, @MMS2NDMPHostInfo_Login, @MMS2NDMPHostInfo_Password, @MMS2NDMPHostInfo_ListenPort,
		@MMS2NDMPHostInfo_FirmwareRevision, @MMS2NDMPHostInfo_OSType, @MMS2NDMPHostInfo_AuthenticationScheme,
		@MMS2NDMPHostInfo_ProtocolType, @MMS2NDMPHostInfo_ProtocolRevision, @MMS2NDMPHostInfo_CapabilityFlags,
		@MMS2NDMPHostInfo_ClientId, @MMS2NDMPHostInfo_newClientId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @MMS2NDMPHostInfo_newNDMPHostId = (SELECT TOP 1 NDMPHostId FROM MMNDMPHostInfo WHERE ClientId = @MMS2NDMPHostInfo_newClientId)
			IF @MMS2NDMPHostInfo_newNDMPHostId is null
			BEGIN
				INSERT INTO MMNDMPHostInfo (Login, Password, ListenPort,
				FirmwareRevision, OSType, AuthenticationScheme,
				ProtocolType, ProtocolRevision, CapabilityFlags,
				ClientId)
				VALUES(@MMS2NDMPHostInfo_Login, @MMS2NDMPHostInfo_Password, @MMS2NDMPHostInfo_ListenPort,
				@MMS2NDMPHostInfo_FirmwareRevision, @MMS2NDMPHostInfo_OSType, @MMS2NDMPHostInfo_AuthenticationScheme,
				@MMS2NDMPHostInfo_ProtocolType, @MMS2NDMPHostInfo_ProtocolRevision, @MMS2NDMPHostInfo_CapabilityFlags,
				@MMS2NDMPHostInfo_newClientId)
				IF	@@ERROR > 0
				BEGIN
					SET @errorString = 'ERROR: CCM_Merge_Client -- MMNDMPHostInfo -- INSERT'
					GOTO CX_ERROR_EXIT
				END
				SELECT @MMS2NDMPHostInfo_newNDMPHostId = @@IDENTITY
			END
			INSERT INTO CCM_MAP_MMNDMPHostInfo (old_id, new_id)
			VALUES (@MMS2NDMPHostInfo_NDMPHostId, @MMS2NDMPHostInfo_newNDMPHostId)
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_MMNDMPHostInfo -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			FETCH NEXT FROM CCM_MMS2NDMPHostInfoCursor
			INTO @MMS2NDMPHostInfo_NDMPHostId, @MMS2NDMPHostInfo_Login, @MMS2NDMPHostInfo_Password, @MMS2NDMPHostInfo_ListenPort,
			@MMS2NDMPHostInfo_FirmwareRevision, @MMS2NDMPHostInfo_OSType, @MMS2NDMPHostInfo_AuthenticationScheme,
			@MMS2NDMPHostInfo_ProtocolType, @MMS2NDMPHostInfo_ProtocolRevision, @MMS2NDMPHostInfo_CapabilityFlags,
			@MMS2NDMPHostInfo_ClientId, @MMS2NDMPHostInfo_newClientId
		END
		CLOSE CCM_MMS2NDMPHostInfoCursor
		DEALLOCATE CCM_MMS2NDMPHostInfoCursor
	END
	-- End MMNDMPHostInfo --
	---------------------------------------------------------
	INSERT	CCM_MAP_simInstalledPackages
	SELECT	DISTINCT a.old_id, a.new_id, b.simPackageId, c.releaseId, 0, c.modified, 0, 0
FROM	CCM_MAP_Client a, #CCM_simInstalledPackages b, #CCM_App_Client c, App_Client d
	WHERE	a.old_id = b.clientId
	  AND   b.clientId = c.id
	  AND	a.new_id = d.id
AND 	((d.specialClientFlags & 0x20) = 0 OR (d.specialClientFlags & 0x200) = 0x200)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_simInstalledPackages -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Keep the ones from clients with higher release id
	UPDATE	CCM_MAP_simInstalledPackages
	SET		dest_releaseId = b.releaseId, dest_modified = b.Modified
	FROM	CCM_MAP_simInstalledPackages a, App_Client b
	WHERE	a.new_clientId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_simInstalledPackages -- UPDATE dest_releaseId, dest_modified'
		GOTO CX_ERROR_EXIT
	END
	-- destination has higher release id, don't touch patch info for this client
	UPDATE CCM_MAP_simInstalledPackages
	SET		exist = 1
	FROM   CCM_MAP_simInstalledPackages a, simInstalledPackages b
				WHERE	a.source_releaseId < a.dest_releaseId
	  AND  a.new_clientId = b.ClientId
	  AND  a.simPackageId = b.simPackageId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_simInstalledPackages -- UPDATE exist when source_releaseid < dest_releaseid'
		GOTO CX_ERROR_EXIT
	END
	-- source has higher release id, remove all the patch info for this client and merge from source
	DELETE simInstalledPackages
	FROM   simInstalledPackages a, CCM_MAP_simInstalledPackages b
	WHERE  a.clientId = b.new_clientId
	  AND  a.simPackageId = b.simPackageId
	  AND  b.dest_releaseId > 0
	  AND  b.source_releaseId > b.dest_releaseId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- simInstalledPackages -- DELETE when source_releaseId > dest_releaseId'
		GOTO CX_ERROR_EXIT
	END
	-- source and destination have the same release id, compare the backup data to decide which one to keep
	UPDATE	CCM_MAP_simInstalledPackages
	SET		exist = 1
	FROM    CCM_MAP_simInstalledPackages a, simInstalledPackages b
	WHERE	a.source_releaseId = a.dest_releaseId
	  AND	a.source_modified <= a.dest_modified
  	  AND   a.new_clientId = b.ClientId
	  AND   a.simPackageId = b.simPackageId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_simInstalledPackages -- UPDATE exist when same releaseid and source_modifed <= dest_modified'
		GOTO CX_ERROR_EXIT
	END
	DELETE	simInstalledPackages
	FROM	simInstalledPackages a, CCM_MAP_simInstalledPackages b
	WHERE	a.clientId = b.new_clientId
	AND     a.simPackageId = b.simPackageId
	AND		b.source_releaseId = b.dest_releaseId
	AND		b.source_modified > b.dest_modified
	AND		b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- simInstalledPackages -- DELETE when same releaseid and source_modified > dest_modified'
		GOTO CX_ERROR_EXIT
	END
	DECLARE @SQLQuery NVARCHAR(MAX)
        IF EXISTS(SELECT * FROM TempDB.sys.columns WHERE Name = 'SPVersionId' AND Object_ID = Object_ID('TempDB..#CCM_simInstalledPackages'))
	BEGIN
		SET @SQLQuery = N'
		INSERT INTO simInstalledPackages
		SELECT	a.new_clientId, b.simPackageId, b.OpTime, ''MIGRATED'', b.UserID, b.HighestSP, b.AdditionalPatches, b.MissingPatches, b.Node, b.IsActive,
				b.SpMinorVersion,  8 /*b.Baseline*/, b.BaselineDeltaSP, b.BaselineDeltaUpdate /* SET BASELINE TO NOT_APLICABLE  FOR MIGRATED CLIENTS */, b.SPVersionId, 0
FROM	CCM_MAP_simInstalledPackages a, #CCM_simInstalledPackages b
		WHERE	a.old_clientId = b.clientId AND a.simPackageId = b.simPackageId
		AND		a.exist = 0 '
	END
	ELSE
	BEGIN
		SET @SQLQuery = N'
		INSERT INTO simInstalledPackages
		SELECT	a.new_clientId, b.simPackageId, b.OpTime, ''MIGRATED'', b.UserID, b.HighestSP, b.AdditionalPatches, b.MissingPatches, b.Node, b.IsActive,
				b.SpMinorVersion,  8 /*b.Baseline*/, b.BaselineDeltaSP, b.BaselineDeltaUpdate /* SET BASELINE TO NOT_APLICABLE  FOR MIGRATED CLIENTS */, 0, 0
FROM	CCM_MAP_simInstalledPackages a, #CCM_simInstalledPackages b
		WHERE	a.old_clientId = b.clientId AND a.simPackageId = b.simPackageId
		AND		a.exist = 0 '
	END
	EXEC (@SQLQuery)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- simInstalledPackages -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	INSERT	CCM_MAP_simInstalledPackagesHistory
	SELECT	DISTINCT b.simInstalledPkgID, c.id, a.old_id, a.new_id, b.simPackageId, b.OpType, b.OpTime, 0
FROM	CCM_MAP_Client a, #CCM_simInstalledPackagesHistory b, simInstalledPackages c
	WHERE	a.old_id = b.clientId AND a.new_id = c.clientId AND b.simPackageId = c.simPackageId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_simInstalledPackagesHistory -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_simInstalledPackagesHistory
	SET exist = 1
	FROM CCM_MAP_simInstalledPackagesHistory a, simInstalledPackagesHistory b
	WHERE a.new_simInstalledPkgID = b.simInstalledPkgID
	AND a.OpTime = b.OpTime
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_simInstalledPackagesHistory -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO simInstalledPackagesHistory
	SELECT	a.new_simInstalledPkgID, a.simPackageId, a.new_clientId, b.InstallState, 'MIGRATED', b.PreviousReleaseId,
			b.ReleaseId, b.OpTime, b.UserId, b.AppType, b.LicType
FROM CCM_MAP_simInstalledPackagesHistory a, #CCM_simInstalledPackagesHistory b
	WHERE a.old_simInstalledPkgID = b.simInstalledPkgID
	AND a.OpType = b.OpType
	AND a.OpTime = b.OpTime
	AND a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- simInstalledPackagesHistory -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	INSERT CCM_MAP_simXMLRequest
	SELECT a.old_id, a.new_id, b.OpTimeUTC, b.xmlBlob, 0
FROM CCM_MAP_Client a, #CCM_simXMLRequest b
	WHERE a.old_id = b.clientId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_simXMLRequest -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_simXMLRequest
	SET exist = 1
	FROM CCM_MAP_simXMLRequest a, simXMLRequest b
	WHERE a.new_clientId = b.clientId
	AND a.OpTimeUTC = b.OpTimeUTC
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_simXMLRequest -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO simXMLRequest
	SELECT new_clientId, OpTimeUTC, xmlBlob, NULL
	FROM CCM_MAP_simXMLRequest
	WHERE exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- simXMLRequest -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	--	Merge LicUsage table
	INSERT INTO CCM_MAP_LicUsage
	SELECT	a.id, 0, a.Name, a.CId, c.id, a.LicType, a.AppType, 'UnInstall', GETUTCDATE(), a.TokensUsed,
			a.Eval, a.ExpiryDateUTC, c.ReleaseId, a.EncryptedField, c.simOperatingSystemId, a.Build, a.InstallFlag, 1, a.UsedCapacity
FROM 	#CCM_LicUsage a
INNER JOIN CCM_MAP_Client b ON a.CId = b.old_Id
			INNER JOIN App_Client c ON b.new_id = c.id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_LicUsage -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_LicUsage
	SET		Build		= '0(' + ISNULL((SELECT attrVal from App_ClientProp where attrName = 'Galaxy Build' and componentNameId = new_CId), (case releaseId when 16 then 'BUILD80' when 15 then 'BUILD116' when 14 then 'BUILD84' when 13 then 'BUILD68' end))   + ')'
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_LicUsage -- UPDATE releaseId'
		GOTO CX_ERROR_EXIT
	END
	DECLARE @STR_DASH varchar(10) =':-'
	DECLARE @var_ID INT
	DECLARE @var_encryptedField varchar(2048)
	DECLARE @newEncFld varchar(2048)
	DECLARE @TempLicUsage   TABLE(t_Id INT, t_rawData varchar(2048) , t_newencryptedField varchar(2048))
	insert into @TempLicUsage (t_Id, t_rawData)
	select  old_Id, name  + @STR_DASH +
				CAST(new_CId AS VARCHAR(64)) + @STR_DASH +
				CAST(Lictype AS VARCHAR(64)) + @STR_DASH +
				CAST(AppType AS VARCHAR(64)) + @STR_DASH +
				LTRIM(RTRIM(OpType))  + @STR_DASH +
				CAST(dbo.GetUnixTime(OpTimeUTC) AS VARCHAR(64)) + @STR_DASH +
				CAST(TokensUsed AS VARCHAR(64)) + @STR_DASH +
				CAST(Eval AS VARCHAR(64)) + @STR_DASH +
				CAST(dbo.GetUnixTime(ExpiryDateUTC) AS VARCHAR(64)) + @STR_DASH +
				CAST(ReleaseId AS VARCHAR(64)) + @STR_DASH +
				CAST(SimOSID AS VARCHAR(64)) + @STR_DASH +
				Build + @STR_DASH +
				CAST(InstallFlag AS VARCHAR(64))
	from	CCM_MAP_LicUsage
	DECLARE EncryptLicUsageCursor CURSOR LOCAL FORWARD_ONLY FOR  SELECT t_Id, t_rawData FROM @TempLicUsage
	OPEN EncryptLicUsageCursor
	FETCH EncryptLicUsageCursor INTO @var_ID, @var_encryptedField
	WHILE @@FETCH_STATUS = 0
	BEGIN
		EXEC pswEncryptionManaged @var_encryptedField, @newEncFld OUTPUT
		IF (@newEncFld IS NULL or LEN(@newEncFld) = 0)
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- Failure in decrypting the licensing record ' + CAST(@var_ID   AS varchar(64) )
			GOTO CX_ERROR_EXIT
		END
		ELSE
		BEGIN
			UPDATE @TempLicUsage  SET t_newencryptedField=@newEncFld   WHERE t_Id = @var_ID
		END
		FETCH NEXT FROM EncryptLicUsageCursor INTO @var_ID,@var_encryptedField
	END
	CLOSE EncryptLicUsageCursor
	DEALLOCATE EncryptLicUsageCursor
	UPDATE	CCM_MAP_LicUsage
	SET		EncryptedField = t_newencryptedField
	FROM	@TempLicUsage
	WHERE 	old_id = t_Id
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- LicUsage -- UPDATE EncryptedField'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_LicUsage
	SET		new_id = b.id
	FROM	CCM_MAP_LicUsage a
			INNER JOIN LicUsage b
			ON a.new_CId = b.CId
			AND a.LicType = b.LicType
			AND a.AppType = b.AppType
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- LicUsage -- UPDATE new_id'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO LicUsage
	SELECT	a.Name, a.new_CId, a.LicType, a.AppType, a.OpType, a.OpTimeUTC, a.TokensUsed,
			a.Eval, a.ExpiryDateUTC, a.ReleaseId, a.EncryptedField, a.SimOSID, a.Build, a.InstallFlag,
			a.UserID, a.UsedCapacity
	FROM	CCM_MAP_LicUsage a
	WHERE 	a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- LicUsage -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Insert licUsageId as 0 for Migrated LicUsageHistory
	-- We've no idea of what is the destination id is going to be(for the cId, licType) at this point
	-- And OpType always 'UnInstall' for migrated history as per Hemant
	INSERT INTO LicUsageHistory
	SELECT 0, A.Name, B.new_id , A.LicType, A.AppType,'UnInstall', A.OpTimeUTC,
	A.TokensUsed, A.Eval, A.ExpiryDateUTC, A.ReleaseId, A.EncryptedField,
	A.CreateTimeUTC, A.SimOSID, A.Build, A.InstallFlag, A.UserID, A.UsedCapacity
FROM #CCM_LicUsageHistory A, CCM_MAP_Client B
	WHERE A.CId = B.old_id
	AND B.new_id <> 0
	AND NOT EXISTS
	(SELECT * FROM LicUsageHistory
	WHERE CId = B.new_id
	AND LicType = A.LicType
	AND CreateTimeUTC = A.CreateTimeUTC)
	IF @@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_MERGE_CLIENT -- LicUsageHistory -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CCMClientLicenses
	SELECT DISTINCT	b.old_Id, c.id, d.appTypeId, 0, a.LicType, '', 0, '', ''
FROM 	#CCM_LicUsage a
INNER JOIN CCM_MAP_Client b ON a.CId = b.old_Id
			INNER JOIN App_Client c ON b.new_id = c.id
			INNER JOIN CCM_MAP_IdaName d ON d.new_clientId = c.id AND d.appTypeId = a.appType
			LEFT OUTER JOIN CCMClientLicenses e ON e.new_clientId = c.id AND e.appType = d.appTypeId
	WHERE a.OpType = 'Install' AND e.appType IS NULL
	IF @@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_MERGE_CLIENT -- CCMClientLicenses -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	CLOSE Cur_InstanceName
	DEALLOCATE Cur_InstanceName
	CLOSE Cur_BackupSetName
	DEALLOCATE Cur_BackupSetName
	-------------------------------------------------------------------------------
	DECLARE		@grc_ClientGroup	VARCHAR(2048)
	DECLARE		@clientGroupID		INTEGER
	DECLARE		@description		VARCHAR(2048)
	--Flag bit 1 set in @ccmParamFlags if robo job
	--For GRC if a client group is selected by user to associate all migrated clients with it then add association
	IF(@ccmParamFlags & 1) = 1
	BEGIN
		SELECT @grc_ClientGroup = ( SELECT ISNULL(stringVal, '') FROM GRC_CommCellProp
WHERE commcellId = (SELECT new_id FROM CCM_MAP_CommCell WHERE old_id = 2)
AND propId = 7
								)
		SET @description = 	'Automatically Created by Import from Podcell'
	END
	-- create client group for CCM clients
	ELSE
	BEGIN
SELECT @grc_ClientGroup = ( SELECT aliasName FROM CCM_MAP_CommCell WHERE old_Id = 2)
		SET @grc_ClientGroup = @grc_ClientGroup + '_clients'
		SET @description = 'Automatically Created by CommCell Migration'
	END
		IF @grc_ClientGroup <> ''
		BEGIN
			SELECT @clientGroupID = id
			FROM APP_ClientGroup
			WHERE name = @grc_ClientGroup
			IF (@clientGroupID is null)
			BEGIN
			INSERT INTO APP_ClientGroup
							(
								name,
								description,
								flag,
								status,
								userId,
								refTime,
								modified,
								fwPorts,
								origCCId,
								GUID
							)
						VALUES(
								@grc_ClientGroup,
								@description,
								0,
								0,
								1, --admin user id
								dbo.GetUnixTime(getDate()),
								dbo.GetUnixTime(getDate()),
								'',
								0,
								NEWID()
							 )
				SET @clientGroupID = SCOPE_IDENTITY()
			END
			MERGE APP_ClientGroupAssoc AS TARGET
			USING(
					SELECT
					DISTINCT new_id
FROM	CCM_MAP_Client
				)AS SOURCE (clientId)
			ON TARGET.clientGroupId = @clientGroupID AND TARGET.clientId = SOURCE.clientId
			WHEN NOT MATCHED BY TARGET
			THEN INSERT(clientGroupId, clientId)
				 VALUES(@clientGroupID, SOURCE.clientId);
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_MERGE_CLIENT -- ClientGroupAssoc -- INSERT'
				GOTO CX_ERROR_EXIT
			END
		END
	--------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	SET @errorString = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	IF (Cursor_Status('LOCAL', 'Cur_InstanceName') >= -1)
	BEGIN
		CLOSE Cur_InstanceName
		DEALLOCATE Cur_InstanceName
	END
	IF (Cursor_Status('LOCAL', 'Cur_BackupSetName') >= -1)
	BEGIN
		CLOSE Cur_BackupSetName
		DEALLOCATE Cur_BackupSetName
	END
	IF (Cursor_Status('LOCAL', 'CUR_DB2DBF_InstanceProp') >= -1)
	BEGIN
		CLOSE CUR_DB2DBF_InstanceProp
		DEALLOCATE CUR_DB2DBF_InstanceProp
	END
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_Client_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Client_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Client_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Client_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_Client_from_XML',  'v1.15.34.3.6.3', 'CCM_Merge_Client_from_XML', 'v1.15.34.3.6.3')
GO

