

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_ClientGroupProp.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merges DlpGroupProp in CCM Merge process, we can use this
--  | stored proc if we want to merge other tables when clientgroup migaration happens.
--  +========================================================================+
-- $Id: CCM_Merge_ClientGroupProp.sp,v 1.3.66.1 2018/03/20 00:29:44 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Merge_ClientGroupProp <<<'

IF EXISTS (select * from sysobjects where name='CCM_Merge_ClientGroupProp')
	drop procedure CCM_Merge_ClientGroupProp
IF EXISTS (select * from GxQscripts where name='CCM_Merge_ClientGroupProp')
	delete from GxQscripts where name = 'CCM_Merge_ClientGroupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_ClientGroupProp')
	delete from GXDBVersions where aliasname = 'CCM_Merge_ClientGroupProp'
GO
print '... Creating Procedure: CCM_Merge_ClientGroupProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_Merge_ClientGroupProp
  @new_clientGroupId integer,
  @old_clientGroupId integer,
  @isForceOverWrite integer,
  @inputXml xml
AS
SET NOCOUNT ON
	DECLARE @errorString varchar(1000)
	SET @errorString = 'ERROR: GENERAL ERROR!'
	IF NOT EXISTS(SELECT * FROM APP_ClientGroup WHERE id=@new_clientGroupId)
	BEGIN
		SET @errorString = 'ERROR: ClientGroup Does not exists --MergeDlpGroupProp'
		GOTO CX_ERROR_EXIT
	END
	SELECT
		 (Tbl.col.value('@groupId', 'INT')) AS groupId,
		 (Tbl.col.value('@attrName', 'NVARCHAR(MAX)')) AS attrName,
		 (Tbl.col.value('@attrVal', 'NVARCHAR(MAX)')) AS attrVal,
		 (Tbl.col.value('@created', 'INT')) AS created,
		 (Tbl.col.value('@modified', 'INT')) AS modified,
		 (Tbl.col.value('@flag', 'INT')) AS flag
	INTO #TempSpecificGroupProp
	FROM @inputXml.nodes('/EVGui_ClientGroupInfo/DlpProp') Tbl(col)
	-------------------------------------------------------------------------------
	IF EXISTS(SELECT 1 FROM #TempSpecificGroupProp)
	BEGIN
		IF @isForceOverWrite = 0
		BEGIN
			--Update modfiedTime is source has a latest value
			UPDATE	DlpGroupProp
			SET		modified = b.modified
			FROM	DlpGroupProp a, #TempSpecificGroupProp b
			WHERE	a.groupId=@new_clientGroupId
					AND	a.attrName = b.attrName
					AND	a.created = b.created
					AND	a.modified = 0 AND b.modified <> 0
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: Update DlpGroupProp failed --MergeDlpGroupProp'
				GOTO CX_ERROR_EXIT
			END
			-- Update the attrVal if source has the latest setting for a property
			UPDATE	DlpGroupProp
			SET attrVal = b.attrVal, flag=b.flag
			FROM	DlpGroupProp a, #TempSpecificGroupProp b
			WHERE	a.groupId=@new_clientGroupId
			AND		a.attrName = b.attrName
			AND		a.modified = 0 AND b.modified = 0
			AND		a.created < b.created
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: Update DlpGroupProp failed --MergeDlpGroupProp'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO DlpGroupProp
			SELECT @new_clientGroupId,a.attrName,a.attrVal,a.created,a.modified,a.flag
			FROM #TempSpecificGroupProp a LEFT OUTER JOIN DlpGroupProp b ON b.groupId=@new_clientGroupId AND a.attrName = b.attrName
																			AND a.created = b.created AND a.modified = b.modified
			WHERE b.groupId IS NULL
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: Insert DlpGroupProp failed --MergeDlpGroupProp'
				GOTO CX_ERROR_EXIT
			END
		END
		ELSE
		BEGIN
			DELETE	DlpGroupProp
			WHERE	groupId=@new_clientGroupId
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: Delete DlpGroupProp failed --MergeDlpGroupProp'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO DlpGroupProp
			SELECT @new_clientGroupId,attrName,attrVal,created,modified,flag
			FROM #TempSpecificGroupProp
			IF	@@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: Insert DlpGroupProp failed --MergeDlpGroupProp'
				GOTO CX_ERROR_EXIT
			END
		END
	END
	DROP TABLE #TempSpecificGroupProp
	SET @errorString = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_ClientGroupProp')
	delete from GxQscripts where name = 'CCM_Merge_ClientGroupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_ClientGroupProp')
	delete from GXDBVersions where aliasname = 'CCM_Merge_ClientGroupProp'
GO

insert into GXDBVersions values(2, 'CCM_Merge_ClientGroupProp',  '00010003006600010000', 'CCM_Merge_ClientGroupProp', '00010003006600010000')
GO

