

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_ArchStream.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge tables:
--	|					ArchStream
--	|					MMMediaGroup
--  +========================================================================+
-- $Id: CCM_Merge_ArchStream.sp,v 1.18.208.1 2018/03/20 00:40:25 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Merge_ArchStream <<<'

IF EXISTS (select * from sysobjects where name='CCM_Merge_ArchStream')
	drop procedure CCM_Merge_ArchStream
IF EXISTS (select * from GxQscripts where name='CCM_Merge_ArchStream')
	delete from GxQscripts where name = 'CCM_Merge_ArchStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_ArchStream')
	delete from GXDBVersions where aliasname = 'CCM_Merge_ArchStream'
GO
print '... Creating Procedure: CCM_Merge_ArchStream'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Merge_ArchStream
  @errStr varchar(1024) OUTPUT
AS
	---------------------------------------------------------
-- Code below here is from CCM_Merge_ArchStream.spb --
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
	-- Merge ArchStream Table
	INSERT into CCM_MAP_ArchStream
	SELECT	a.old_id, a.new_id, b.old_id, b.new_id, c.stream, '', '', mediaGroupId, 0, 0, 0
FROM CCM_MAP_ArchGroup a, CCM_MAP_ArchGroupCopy b, CommServ_Merge..CCM_ArchStream c
	WHERE a.old_id = c.archGroupId AND b.old_id = c.archGroupCopyId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchStream -- CCM_MAP_ArchStream -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Do not merge existing streams
	UPDATE CCM_MAP_ArchStream SET exist = 1, mediaGroup_exist = 1
	FROM CCM_MAP_ArchStream a, ArchStream b
	WHERE a.new_archGroupCopyId = b.archGroupCopyId AND a.stream = b.stream
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchStream -- CCM_MAP_ArchStream -- DELETE'
		GOTO CX_ERROR_EXIT
	END
	-- Entries with mediaGroupId = 0 will be updated at the end of this file
	INSERT into ArchStream
	SELECT a.new_archGroupId, a.new_archGroupCopyId, a.stream, 0, 1, b.lastUsedTime, b.physicalDataSizeInGB, b.flags
FROM CCM_MAP_ArchStream a, CommServ_Merge..CCM_ArchStream b
	WHERE a.old_archGroupCopyId = b.archGroupCopyId AND a.stream = b.stream
	AND a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchStream -- ArchStream -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchStream set new_mediaGroupName =
			'AG['	+ convert(varchar(20), new_archGroupId)		+ ']_AGC['
					+ convert(varchar(20), new_archGroupCopyId) + ']_stream['
					+ convert(varchar(20), stream)				+ ']'
FROM CCM_MAP_ArchStream A INNER JOIN CommServ_Merge..CCM_ArchGroupCopy B ON A.old_archGroupCopyId = B.id
WHERE B.extendedFlags & 2 = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchStream -- CCM_MAP_ArchStream -- UPDATE new_mediaGroupName'
		GOTO CX_ERROR_EXIT
	END
/*
	UPDATE CCM_MAP_ArchStream set old_mediaGroupName =
			'AG['	+ convert(varchar(20), old_archGroupId)		+ ']_AGC['
					+ convert(varchar(20), old_archGroupCopyId) + ']_stream['
					+ convert(varchar(20), stream)				+ ']'
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchStream -- CCM_MAP_ArchStream -- UPDATE old_mediaGroupName'
		GOTO CX_ERROR_EXIT
	END
*/
	---------------------------------------------------------
	-- Merge MMMediaGroup Table
/*
	UPDATE	CCM_MAP_ArchStream SET mediaGroup_exist = 1
	FROM	CCM_MAP_ArchStream a, MMMediaGroup b
	WHERE	a.new_mediaGroupName = b.mediaGroupName
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchStream -- CCM_MAP_ArchStream -- UPDATE mediaGroup_exist'
		GOTO CX_ERROR_EXIT
	END
*/
	DECLARE @tblBeforeMerge TABLE (id INT)
	INSERT INTO @tblBeforeMerge SELECT MediaGroupId FROM MMMediaGroup
	IF EXISTS (SELECT * FROM CCM_MAP_CommCell WHERE new_id = 2 and old_id = 2)
	BEGIN
			-------------------------------------------------------------
			-- Merge to same APP_CommCell and id not used, keep the same id
			-------------------------------------------------------------
			SET IDENTITY_INSERT MMMediaGroup ON
			INSERT	INTO MMMediaGroup (
					MediaGroupId, MediaGroupName, DrivePoolId,
					SpareGroupId, DesiredMediaTypeId, RecordingFormatId,
					DataPathId
					)
			SELECT	a.old_mediaGroupId, a.new_mediaGroupName,
					0, 0, 0, 0, 0
FROM	CCM_MAP_ArchStream a, CommServ_Merge..CCM_MMMediaGroup b
			WHERE	a.old_mediaGroupId = b.MediaGroupId
			AND		a.mediaGroup_exist = 0 AND a.new_mediaGroupName <> ''
			AND		NOT EXISTS (SELECT 1 FROM @tblBeforeMerge WHERE id = a.old_mediaGroupId)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_ArchStream -- MMMediaGroup -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			SET IDENTITY_INSERT MMMediaGroup OFF
			-------------------------------------------------------------
			-- Merge to same APP_CommCell but id is reused, create new id
			-------------------------------------------------------------
			INSERT	INTO MMMediaGroup
			SELECT	a.new_mediaGroupName,
					0, 0, 0, 0, 0
FROM	CCM_MAP_ArchStream a, CommServ_Merge..CCM_MMMediaGroup b
			WHERE	a.old_mediaGroupId = b.MediaGroupId
			AND		a.mediaGroup_exist = 0 AND a.new_mediaGroupName <> ''
			AND		EXISTS (SELECT 1 FROM @tblBeforeMerge WHERE id = a.old_mediaGroupId)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_ArchStream -- MMMediaGroup -- INSERT'
				GOTO CX_ERROR_EXIT
			END
	END
	ELSE
	BEGIN
			----------------------------------------------
			-- Merge to different APP_CommCell, create new id
			----------------------------------------------
			INSERT	into MMMediaGroup
			SELECT	a.new_mediaGroupName,
					0, 0, 0, 0, 0
FROM	CCM_MAP_ArchStream a, CommServ_Merge..CCM_MMMediaGroup b
			WHERE	a.old_mediaGroupId = b.MediaGroupId
			AND		a.mediaGroup_exist = 0 AND a.new_mediaGroupName <> ''
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_ArchStream -- MMMediaGroup -- INSERT'
				GOTO CX_ERROR_EXIT
			END
	END
	UPDATE CCM_MAP_ArchStream set new_mediaGroupId = AS2.MediaGroupId
	FROM  CCM_MAP_ArchStream AS1,
		( 	SELECT A.old_mediaGroupId, B.mediaGroupId
			FROM CCM_MAP_ArchStream A, MMMediaGroup B
			WHERE A.new_mediaGroupName = B.mediaGroupName AND A.new_mediaGroupName <> ''
									)	AS AS2
	WHERE AS1.old_mediaGroupId = AS2.old_mediaGroupId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchStream -- CCM_MAP_ArchStream -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge ArchStream Table
	-- UPDATE ArchStream table for the new mediaGroup created
	UPDATE ArchStream set mediaGroupId = b.new_mediaGroupId
	FROM ArchStream a, CCM_MAP_ArchStream b
	WHERE a.archGroupCopyId = b.new_archGroupCopyId
	AND a.stream = b.stream
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchStream -- MMMediaGroup -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
	---------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_ArchStream')
	delete from GxQscripts where name = 'CCM_Merge_ArchStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_ArchStream')
	delete from GXDBVersions where aliasname = 'CCM_Merge_ArchStream'
GO

insert into GXDBVersions values(2, 'CCM_Merge_ArchStream',  '00010018020800010000', 'CCM_Merge_ArchStream', '00010018020800010000')
GO

