

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_ArchGroup_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge ArchGroup table
--  +========================================================================+
-- $Id: CCM_Merge_ArchGroup_from_XML.sp,v 1.2.200.2 2018/12/27 16:40:45 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Merge_ArchGroup_from_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Merge_ArchGroup_from_XML <<<'
	drop procedure CCM_Merge_ArchGroup_from_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Merge_ArchGroup_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_ArchGroup_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_ArchGroup_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_ArchGroup_from_XML'
GO
print '... Creating Procedure: CCM_Merge_ArchGroup_from_XML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Merge_ArchGroup_from_XML
  @isTapeImport integer,
  @ccmParamFlags integer,
  @errStr varchar(1024) OUTPUT
AS
	---------------------------------------------------------
-- Code below here is from CCM_Merge_ArchGroup.spb
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	DECLARE @commcellId int
	SET @commcellId = (SELECT new_id FROM CCM_MAP_CommCell WHERE old_id = 2)
	---------------------------------------------------------
UPDATE	#CCM_ArchGroup
	SET		origCCcommCellId = 2
	WHERE	origCCcommCellId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- Commserv_Merge..CCM_ArchGroup -- UPDATE origCCcommcellId'
		GOTO CX_ERROR_EXIT
	END
UPDATE	#CCM_ArchGroup
	SET		origCCarchGroupId = id
	WHERE	origCCarchGroupId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- Commserv_Merge..CCM_ArchGroup -- UPDATE origCCarchGroupId'
		GOTO CX_ERROR_EXIT
	END
	-- GET ArchGroupId TO BE MERGED
	INSERT into CCM_MAP_ArchGroup
	SELECT distinct id, 0, defaultCopy, 0, origCCcommCellId, 0, origCCarchGroupId, origCCarchGroupId, incrSP, 0, defaultSnapCopy, 0, name, description, 0, logSP, 0
FROM #CCM_ArchGroup
WHERE type <> 4
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_ArchGroup -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- set original commcellid
	UPDATE CCM_MAP_ArchGroup SET  new_origCCcommCellId = b.new_id
	FROM CCM_MAP_ArchGroup a INNER JOIN CCM_MAP_CommCell b ON a.old_origCCcommCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_ArchGroup -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	--kbora , update all properties if policy is created by tape import and CCM bringing the same policy.
	UPDATE archGroup
	SET name = B.name,
		description = B.description,
		maxStreams = B.maxStreams,
		type = B.type,
		SIBlockSizeKB = B.SIBlockSizeKB,
		AuxCopyAlertGB = B.AuxCopyAlertGB,
		AuxCopyAlertDays = B.AuxCopyAlertDays,
		flags = B.flags,
		mediaPassword = B.mediaPassword,
		TimeZoneType = B.TimeZoneType,
		TimeZone = B.TimeZone
FROM archGroup A, #CCM_ArchGroup B,CCM_TapeImportEntities C
WHERE B.id = C.old_id AND A.id = C.new_id AND A.origCCcommCellID = C.newCCId AND C.entityType=17
AND B.type <> 8
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: archGroup -- CCM_MAP_ArchGroup --From CCM_TapeImportEntities'
		GOTO CX_ERROR_EXIT
	END
	-- If original commcellid and archgroupid exist in current db, do not create new storage policy
	UPDATE CCM_MAP_ArchGroup SET new_id = b.id, exist = 1
	FROM CCM_MAP_ArchGroup a, ArchGroup b
	WHERE a.new_origCCcommCellId = b.origCCcommCellId AND a.new_origCCarchGroupId = b.origCCarchGroupId
	AND b.origCCarchGroupId <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_ArchGroup -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	-- If migrate back to original commcell and original storage policy exists, do not create new
	UPDATE CCM_MAP_ArchGroup SET new_id = b.id, exist = 1
	FROM CCM_MAP_ArchGroup a, ArchGroup b
	WHERE a.new_origCCcommCellId = 2
	AND a.new_origCCarchGroupId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_ArchGroup -- UPDATE 4'
		GOTO CX_ERROR_EXIT
	END
	-- If migrate back to original commcell but original storage policy was deleted,
	-- set new_id to -1, create new one using its original id later
	UPDATE CCM_MAP_ArchGroup SET new_id = -1
	FROM CCM_MAP_ArchGroup
	WHERE new_origCCcommCellId = 2
	AND exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_ArchGroup -- UPDATE 5'
		GOTO CX_ERROR_EXIT
	END
	-- Update maxStreams of exist storage policies
	UPDATE ArchGroup SET maxStreams = c.maxStreams
FROM ArchGroup a, CCM_MAP_ArchGroup b, #CCM_ArchGroup c
	WHERE a.id = b.new_id and b.old_id = c.id
	AND a.maxStreams < c.maxStreams
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- ArchGroup -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	DECLARE @errorCode integer
	DECLARE @new_id integer
	DECLARE @old_id integer
	DECLARE @name varchar(1024)
	DECLARE @tempName varchar(1024)
	DECLARE @new_origCCcommCellId integer
	DECLARE @new_origCCarchGroupId integer
	DECLARE @description varchar(1024)
	DECLARE @index int
	DECLARE CUR_ArchGroup cursor LOCAL for
		SELECT old_id, new_id, new_origCCcommCellId, new_origCCarchGroupId, name, description
		FROM CCM_MAP_ArchGroup
		WHERE exist = 0
	OPEN CUR_ArchGroup
	FETCH CUR_ArchGroup into @old_id, @new_id, @new_origCCcommCellId, @new_origCCarchGroupId, @name, @description
	while @@FETCH_STATUS = 0
	BEGIN
		-- DefaultCopy is set to 0 and will be updated once archgroupcopy table is merged
		-- IncrSp is SET to 0 and will be updated after all storage policies are added
		IF @new_id = -1
		BEGIN
			-- Migrate back to original commcell but original storage policy was deleted,
			-- so create new one using its original id
			SET @new_id = @new_origCCarchGroupId
			SET @index = 0
			SET @tempName = @name
			WHILE(exists (select * from archGroup where name = @tempName))
			BEGIN
				SET @index = @index + 1
				SET @tempName = @name + '(' + cast(@index as varchar(32)) + ')'
			END
			SET @name = @tempName
			SET IDENTITY_INSERT ArchGroup ON
			INSERT into ArchGroup (
				id, defaultCopy, name, description, maxStreams, type, incrSP, origCCcommCellID, origCCarchGroupId, defaultSnapCopy,
				SIBlockSizeKB, AuxCopyAlertGB, AuxCopyAlertDays, flags, mediaPassword, TimeZoneType, TimeZone)
			values(@new_origCCarchGroupId, 0, @name, @description, 0, 0, 0, @new_origCCcommCellId, @new_origCCarchGroupId, 0,
				0, 0, 0, 0, '', 0, '')
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- ArchGroup -- INSERT 1'
				SET IDENTITY_INSERT ArchGroup OFF
				GOTO CX_ERROR_EXIT
			END
			SET IDENTITY_INSERT ArchGroup OFF
			UPDATE ArchGroup SET
				maxStreams = b.maxStreams,
				type = b.type,
				SIBlockSizeKB = b.SIBlockSizeKB,
				AuxCopyAlertGB = b.AuxCopyAlertGB,
				AuxCopyAlertDays = b.AuxCopyAlertDays,
				flags = b.flags,
				mediaPassword = b.mediaPassword,
				TimeZoneType = b.TimeZoneType,
				TimeZone = b.TimeZone
FROM  ArchGroup a, #CCM_ArchGroup b
			WHERE a.id = @new_id and b.id = @old_id
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- ArchGroup -- UPDATE 3'
				GOTO CX_ERROR_EXIT
			END
		END
		ELSE IF @new_id = 0
		BEGIN
			IF @isTapeImport = 2
			BEGIN
				SET @index = PATINDEX ('EDC[_]%', @name)
				IF @index > 0
					SET @name = 'EDC_' + SUBSTRING(@name, @index+4, 1024)
				ELSE
					SET @name = 'EDC_' + @name
			END
			ELSE IF ( (@ccmParamFlags & 1) = 1) /*GRC merge */
			BEGIN
				DECLARE		@podCellName	VARCHAR(1024)
				IF (
					SELECT ISNULL(longVal, 0) FROM GRC_CommCellProp
					WHERE commcellId = @commcellId
AND propId = 1
				) = 0								/*If use prefix set then add a prefix always*/
				BEGIN
					SET @podCellName = ISNULL(
											(
												SELECT stringVal FROM GRC_CommCellProp
												WHERE commcellId = @commcellId
AND propId = 3
											),
											(SELECT aliasName FROM CCM_MAP_CommCell WHERE old_id = 2)
										)
					SET @index = PATINDEX (@podCellName+'[_]%', @name)
					IF @index = 0
						SET @name = @podCellName+'_' + @name
				END
				ELSE IF EXISTS (SELECT 1 FROM archGroup WHERE name = @name)  /*If use suffix is set then add a suffix only when name exists already*/
				BEGIN
					SET @podCellName = ISNULL(
											(
												SELECT stringVal FROM GRC_CommCellProp
												WHERE commcellId = @commcellId
AND propId = 2
											),
											(SELECT aliasName FROM CCM_MAP_CommCell WHERE old_id = 2)
										)
					SET @index = PATINDEX ('%[_]'+@podCellName, @name)
					IF @index = 0
						SET @name = @name + '_' + @podCellName
				END
			END
			ELSE
			BEGIN
				SET @index = PATINDEX ('CCM[_]%', @name)
				IF @index > 0
					SET @name = 'CCM_' + SUBSTRING(@name, @index+4, 1024)
				ELSE
					SET @name = 'CCM_' + @name
			END
			SET @index = 0
			SET @tempName = @name
			WHILE(exists (select * from archGroup where name = @tempName))
			BEGIN
					SET @index = @index + 1
					SET @tempName = @name + '(' + cast(@index as varchar(32)) + ')'
			END
			SET @name = @tempName
			SET @description = 'Automatically Created by CommCell Migration'
			DECLARE @SizeOfnameCol integer
			SELECT @SizeOfnameCol = CHARACTER_MAXIMUM_LENGTH FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME LIKE 'archGroup' AND COLUMN_NAME = 'name'
			IF LEN(@name)> @SizeOfnameCol
				SET @name = SUBSTRING(@name, 1, @SizeOfnameCol)
			INSERT into ArchGroup (
				defaultCopy, name, description,
				maxStreams, type, incrSP,
				origCCcommCellID, origCCarchGroupId, defaultSnapCopy,
				SIBlockSizeKB, AuxCopyAlertGB, AuxCopyAlertDays, flags, mediaPassword, TimeZoneType, TimeZone)
			--
			--Hide migrated Global Policies (GDSP, GACP and GSP) by default
			--
			SELECT 0, @name, @description,
						maxStreams, type, 0,
						@new_origCCcommCellId, @new_origCCarchGroupId, 0,
						SIBlockSizeKB, AuxCopyAlertGB, AuxCopyAlertDays,
						CASE @new_origCCcommCellId WHEN 2
							THEN flags
							ELSE
							(
flags | 262144 & ~536870912
| (CASE WHEN (@ccmParamFlags & 1) > 0 THEN 524288 ELSE 0 END)
| (CASE WHEN flags & (256 | 16384 | 8388608) > 0 THEN 64 ELSE 0 END)
							)
						END,
						mediaPassword, TimeZoneType, TimeZone
FROM #CCM_ArchGroup
			WHERE id = @old_id
			SELECT @new_id = @@IDENTITY, @errorCode = @@ERROR
			IF	@errorCode > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- ArchGroup -- INSERT 2'
				GOTO CX_ERROR_EXIT
			END
		END
		UPDATE CCM_MAP_ArchGroup SET new_id = @new_id WHERE old_id = @old_id
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_ArchGroup -- UPDATE new_id'
			GOTO CX_ERROR_EXIT
		END
		FETCH CUR_ArchGroup into @old_id, @new_id, @new_origCCcommCellId, @new_origCCarchGroupId, @name, @description
	END
	SELECT * INTO #tempArchGroup FROM CCM_MAP_ArchGroup
	UPDATE	CCM_MAP_ArchGroup SET new_incrSP = b.new_id
	FROM	CCM_MAP_ArchGroup a, #tempArchGroup b
	WHERE	a.old_incrSP = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_ArchGroup -- UPDATE new_incrSP'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchGroup SET new_logSP = b.new_id
	FROM	CCM_MAP_ArchGroup a, #tempArchGroup b
	WHERE	a.old_logSP = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_ArchGroup -- UPDATE new_logSP'
		GOTO CX_ERROR_EXIT
	END
	DROP TABLE #tempArchGroup
	UPDATE	ArchGroup SET incrSP = b.new_incrSP, logSP = b.new_logSP
	FROM	ArchGroup a, CCM_MAP_ArchGroup b
	WHERE	a.id = b.new_id
	AND		b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_ArchGroup -- UPDATE new_incrSP'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	CLOSE CUR_ArchGroup
	DEALLOCATE CUR_ArchGroup
IF EXISTS(SELECT * FROM #CCM_ArchMaterializeSnapShotProp)
	BEGIN
		INSERT INTO CCM_MAP_archMaterializeSnapshotProp
		SELECT archGroupId, 0, sourceCopyId, 0, calendarId, 0, 0
FROM #CCM_ArchMaterializeSnapShotProp
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_archMaterializeSnapshotProp -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_archMaterializeSnapshotProp SET new_ArchGrpId = b.new_Id
		FROM CCM_MAP_archMaterializeSnapshotProp a, CCM_MAP_ArchGroup b WHERE a.old_ArchGrpId = b.old_id
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_archMaterializeSnapshotProp -- UPDATE ArchGroupId'
			GOTO CX_ERROR_EXIT
		END
		IF EXISTS(SELECT * FROM CCM_MAP_archMaterializeSnapshotProp where new_ArchGrpId = 0)
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroup - Failed to get new ArchGroupId for archMaterializeSnapshotProp'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_archMaterializeSnapshotProp SET new_sourceCopyId = b.new_Id
		FROM CCM_MAP_archMaterializeSnapshotProp a, CCM_MAP_ArchGroupCopy b WHERE a.old_sourceCopyId = b.old_id
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_archMaterializeSnapshotProp -- UPDATE sourceCopyId'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_archMaterializeSnapshotProp SET new_calendarId = b.new_Id
		FROM CCM_MAP_archMaterializeSnapshotProp a, CCM_MAP_AppCustomCalendar b WHERE a.old_calendarId = b.old_id
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_archMaterializeSnapshotProp -- UPDATE CalendarId'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_archMaterializeSnapshotProp SET exist = 1
		FROM CCM_MAP_archMaterializeSnapshotProp a, archMaterializeSnapshotProp b
		WHERE a.new_ArchGrpId = b.archGroupId
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- CCM_MAP_archMaterializeSnapshotProp -- SET EXIST'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO archMaterializeSnapshotProp
		SELECT a.new_archGrpId, b.enabled, b.type, b.flags, b.startTime, a.new_sourceCopyId, b.deferredDays, b.numPeriod, b.dayNumber,
		b.currPeriodBegin, b.currPeriodEnd, a.new_calendarId, b.numOfReaders, b.prevPeriodBegin, b.nextPeriodEnd
FROM CCM_MAP_archMaterializeSnapshotProp a INNER JOIN #CCM_ArchMaterializeSnapShotProp b ON a.old_ArchGrpId = b.archGroupId
		WHERE a.exist = 0
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroup -- archMaterializeSnapshotProp -- INSERT'
			GOTO CX_ERROR_EXIT
		END
	END
	RETURN (0)
CX_ERROR_EXIT:
	CLOSE CUR_ArchGroup
	DEALLOCATE CUR_ArchGroup
	RETURN (-1)
	---------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_ArchGroup_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_ArchGroup_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_ArchGroup_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_ArchGroup_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_ArchGroup_from_XML',  '00010002020000020000', 'CCM_Merge_ArchGroup_from_XML', '00010002020000020000')
GO

