

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_ArchGroupCopy.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge tables:
--	|					ArchGroupCopy
--	|					ArchAgingRule
--	|					ArchAgingRuleExtended
--	|					ArchSelectiveCopy
--	|					IdxSIDBStore
--	|					IdxSIDBSubStore
--  +========================================================================+
-- $Id: CCM_Merge_ArchGroupCopy.sp,v 1.83.72.3 2018/12/27 16:46:42 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Merge_ArchGroupCopy')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Merge_ArchGroupCopy <<<'
	drop procedure CCM_Merge_ArchGroupCopy
END
IF EXISTS (select * from GxQscripts where name='CCM_Merge_ArchGroupCopy')
	delete from GxQscripts where name = 'CCM_Merge_ArchGroupCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_ArchGroupCopy')
	delete from GXDBVersions where aliasname = 'CCM_Merge_ArchGroupCopy'
GO
print '... Creating Procedure: CCM_Merge_ArchGroupCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_Merge_ArchGroupCopy
  @isTapeImport integer,
  @ccmParamFlags integer,
  @errStr varchar(1024) OUTPUT
AS
	---------------------------------------------------------
-- Code below here is from CCM_Merge_ArchGroupCopy.spb --
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	DECLARE @commcellId int
	SET @commcellId = (SELECT new_id FROM CCM_MAP_CommCell WHERE old_id = 2)
	---------------------------------------------------------
UPDATE	CommServ_Merge..CCM_ArchGroupCopy
	SET		origCCcommCellId = 2
	WHERE	origCCcommCellId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- Commserv_Merge..CCM_ArchGroupCopy -- UPDATE origCCcommcellId'
		GOTO CX_ERROR_EXIT
	END
UPDATE	CommServ_Merge..CCM_ArchGroupCopy
	SET		origCCArchCopyId = id
	WHERE	origCCArchCopyId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- Commserv_Merge..CCM_ArchGroupCopy -- UPDATE origCCArchCopyId'
		GOTO CX_ERROR_EXIT
	END
	-- GET ArchGroupCopyId TO BE MERGED
	INSERT into CCM_MAP_ArchGroupCopy
	SELECT distinct id, 0, origCCcommCellId, 0, origCCArchCopyId, origCCArchCopyId, archGroupId, 0, calendarId, 0, name, 0, 0, 0, siloAppId, 0,
		sourceCopyId, 0, 0
FROM CommServ_Merge..CCM_ArchGroupCopy
WHERE archGroupId NOT IN (SELECT DISTINCT id FROM CommServ_Merge..CCM_ArchGroup WHERE type = 4)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_ArchGroupCopy -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchGroupCopy SET new_archGroupId = b.new_id
	FROM CCM_MAP_ArchGroupCopy a, CCM_MAP_ArchGroup b
	WHERE a.old_archGroupId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_ArchGroupCopy -- UPDATE new_archGroupId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchGroupCopy SET new_calendarId = b.new_id
	FROM CCM_MAP_ArchGroupCopy a, CCM_MAP_AppCustomCalendar b
	WHERE a.old_calendarId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_ArchGroupCopy -- UPDATE new_calendarId'
		GOTO CX_ERROR_EXIT
	END
	-- set new original commcell id
	UPDATE CCM_MAP_ArchGroupCopy SET new_origCCcommCellId = b.new_id
	FROM CCM_MAP_ArchGroupCopy a INNER JOIN CCM_MAP_CommCell b ON a.old_origCCcommCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_ArchGroupCopy -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
        UPDATE archGroupCopy
	SET name = B.name,
		copy= B.copy,
		flags = B.flags,
		maxMultiplex = B.maxMultiplex,
		isActive = B.isActive,
		type = B.type,
		startTime = B.startTime,
		waitForIfOffline = B.waitForIfOffline,
		waitForIfBusy = B.waitForIfBusy,
		archCheckStartTime = B.archCheckStartTime,
	--	sourceCopyId = B.sourceCopyId,
		delayedDays = B.delayedDays,
		maxStreamNum = B.maxStreamNum,
		archCheckValidPeriod = B.archCheckValidPeriod,
	--	calendarId = B.calendarId,
	--	SIDBStoreId = B.SIDBStoreId,
		encType = B.encType,
		encKeyLen = B.encKeyLen,
		isSnapCopy = B.isSnapCopy,
		isMirrorCopy = B.isMirrorCopy,
		NWWriteSpeed = B.NWWriteSpeed,
		SIDBSnapIntervalHours = B.SIDBSnapIntervalHours,
	--	siloAppId = B.siloAppId,
	--	nDataInstance = B.nDataInstance,
		description = B.description,
		dedupeFlags = B.dedupeFlags,
		blockCacheValidDays = B.blockCacheValidDays,
		nSiloStreams = B.nSiloStreams,
		silosInCache = B.silosInCache,
	--	siloRestoreMAClientId = B.siloRestoreMAClientId,
	--	siloRestoreClientId = B.siloRestoreClientId,
	--	sealStoreTaskId = B.sealStoreTaskId,
		extendedFlags = B.extendedFlags,
	--	destMediaCopyId = B.destMediaCopyId,
		maxCacheDBSizeMB = B.maxCacheDBSizeMB,
		archCheckValidPeriodType = B.archCheckValidPeriodType,
		endTime = B.endTime
FROM archGroupCopy A, CommServ_Merge..CCM_ArchGroupCopy B, CCM_TapeImportEntities C
WHERE B.id = C.old_id AND A.origCCcommCellID = C.newCCId AND A.id = C.new_id AND C.entityType=18
AND B.type <> 8
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: archGroupCopy -- CCM_MAP_ArchGroupCopy -- update with CCM_TapeImportEntities table'
		GOTO CX_ERROR_EXIT
	END
	-- If original commcellid and ArchGroupCopyid exist in current db, do not create new storage policy copy
	UPDATE CCM_MAP_ArchGroupCopy SET new_id = b.id, exist = 1
	FROM CCM_MAP_ArchGroupCopy a, ArchGroupCopy b
	WHERE a.new_origCCcommCellId = b.origCCcommCellId AND a.new_origCCArchCopyId = b.origCCArchCopyId
	AND b.origCCArchCopyId <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_ArchGroupCopy -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	-- If migrate back to original commcell and original storage policy copy exists, do not create new
	UPDATE CCM_MAP_ArchGroupCopy SET new_id = b.id, exist = 1
	FROM CCM_MAP_ArchGroupCopy a, ArchGroupCopy b
	WHERE a.new_origCCcommCellId = 2
	AND a.new_origCCArchCopyId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_ArchGroupCopy -- UPDATE 4'
		GOTO CX_ERROR_EXIT
	END
	-- If migrate back to original commcell but original storage policy copy was deleted,
	-- set new_id to -1, create new one using its original id later if original id is available.
	UPDATE CCM_MAP_ArchGroupCopy
	SET new_id = -1
	FROM CCM_MAP_ArchGroupCopy
	WHERE new_origCCcommCellId = 2
	AND exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_ArchGroupCopy -- UPDATE 5'
		GOTO CX_ERROR_EXIT
	END
	-- Update maxStreamNum of exist storage policy copies
	UPDATE ArchGroupCopy SET maxStreamNum = c.maxStreamNum
FROM ArchGroupCopy a, CCM_MAP_ArchGroupCopy b, CommServ_Merge..CCM_ArchGroupCopy c
	WHERE a.id = b.new_id and b.old_id = c.id
	AND a.maxStreamNum < c.maxStreamNum
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchGroupCopy -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	-- Update new copy name if it is changed.
IF ( (@ccmParamFlags & 1	) = 1	) /*GRC merge */
	BEGIN
		UPDATE ArchGroupCopy SET name = c.name
FROM ArchGroupCopy a, CCM_MAP_ArchGroupCopy b, CommServ_Merge..CCM_ArchGroupCopy c
		WHERE a.id = b.new_id and b.old_id = c.id
			AND a.name <> c.name
			AND NOT EXISTS (SELECT 1 FROM ArchGroupCopy AGC WHERE AGC.archGroupId = a.archGroupId AND AGC.name = a.name)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchGroupCopy -- UPDATE copy name.'
			GOTO CX_ERROR_EXIT
		END
	END
	---------------------------------------------------------
	--Handling precedence values for snap
	declare @tbl_1 table (AGId int, countSnapCopy int, maxSnapCopyPrecedence int)
	/*
	Get the list of storage policyIds
	and for each of those storage policies get the count of new snap copies in merge dump that is not yet present in destination CS
	and the maximum precedence of a snap copy in destination CS for that storage policy
	*/
	/*Incoming policy has new snap copy and destination policy already has snap copy*/
	INSERT INTO @tbl_1
	SELECT distinct b.new_archGroupId, COUNT(distinct a.id), max(c.copy)
FROM CommServ_Merge..CCM_ArchGroupCopy a inner join CCM_Map_ArchGroupCopy b
	ON a.id = b.old_id AND b.exist = 0 AND a.isSnapCopy > 0
	inner join archGroupCopy c ON c.archGroupId = b.new_archGroupId AND c.isSnapCopy > 0
	GROUP BY b.new_archGroupId
	/*Incoming policy has new snap copy and destination policy does not have snap copy*/
	INSERT INTO @tbl_1
	SELECT distinct b.new_archGroupId, COUNT(distinct a.id), 0
FROM CommServ_Merge..CCM_ArchGroupCopy a inner join CCM_Map_ArchGroupCopy b
	ON a.id = b.old_id AND b.exist = 0 AND a.isSnapCopy > 0
	inner join archGroupCopy c ON c.archGroupId = b.new_archGroupId AND c.isSnapCopy = 0
	AND NOT EXISTS (SELECT * FROM @tbl_1 WHERE AGId = b.new_archGroupId)
	GROUP BY b.new_archGroupId
	DECLARE @AGId int
	DECLARE @AGCId int
	DECLARE @tmpCnt int
	DECLARE PolicyCursor CURSOR LOCAL FOR
	SELECT distinct AGId FROM @tbl_1
	OPEN PolicyCursor
	FETCH NEXT FROM PolicyCursor INTO @AGId
	/*Iterate through each storage policy Id*/
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @tmpCnt = 1
		/*
		For the storage policy - iterate through each snap copy in merge dump that are not present in destination CS yet
		*/
		DECLARE CopyCursor CURSOR LOCAL FOR
SELECT a.id from CommServ_Merge..CCM_ArchGroupCopy a inner join CCM_Map_ArchGroupCopy b
		ON a.id = b.old_id AND b.new_archGroupId = @AGId AND a.isSnapCopy > 0 AND b.exist = 0
		order by a.copy
		OPEN CopyCursor
		FETCH NEXT FROM CopyCursor INTO @AGCId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			/*
			Set the precedence of the snap copies in merge dump
			such that these snap copies come immediately after the existing snap copies
			*/
UPDATE CommServ_Merge..CCM_ArchGroupCopy SET copy = (SELECT maxSnapCopyPrecedence from @tbl_1 WHERE AGId = @AGId) + @tmpCnt
			WHERE id = @AGCId
			SET @tmpCnt = @tmpCnt + 1
			FETCH NEXT FROM CopyCursor INTO @AGCId
		END
		CLOSE CopyCursor
		DEALLOCATE CopyCursor
		/*
		Now that we have put the new snap copies immediately after existing snap copies we have to
		push the existing non-snap copies down to accomodate the new snap copies
		*/
		UPDATE archGroupCopy SET copy = copy + (SELECT countSnapCopy from @tbl_1 WHERE AGId = @AGId)
		WHERE archGroupId = @AGId AND isSnapCopy = 0 AND copy > (SELECT maxSnapCopyPrecedence from @tbl_1 WHERE AGId = archGroupId)
		FETCH NEXT FROM PolicyCursor INTO @AGId
	END
	CLOSE PolicyCursor
	DEALLOCATE PolicyCursor
	--Handling precedence values for non-snap copies
	/*
	Get the list of storage policy Ids which are having new non-snap copies in the merge dump
	*/
	DECLARE PolicyCurSor_1 CURSOR LOCAL FOR
	SELECT distinct b.new_ArchGroupId
FROM CommServ_Merge..CCM_ArchGroupCopy a inner join CCM_Map_ArchGroupCopy b
	ON a.id = b.old_id AND a.isSnapCopy = 0 AND b.exist = 0
	inner join ArchGroupCopy c ON c.archGroupId = b.new_ArchGroupId
	OPEN PolicyCurSor_1
	FETCH NEXT FROM PolicyCurSor_1 INTO @AGId
	/*Iterate through each storage policy Id*/
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @tmpCnt = 1
		/*
		Iterate through each non-snap copy in merge dump that are not present in destination CS yet
		*/
		DECLARE CopyCursor_1 CURSOR LOCAL FOR
SELECT a.id from CommServ_Merge..CCM_ArchGroupCopy a inner join CCM_Map_ArchGroupCopy b
		ON a.id = b.old_id AND b.new_archGroupId = @AGId AND a.isSnapCopy = 0 AND b.exist = 0
		order by a.copy
		OPEN CopyCursor_1
		FETCH NEXT FROM CopyCursor_1 INTO @AGCId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			/*
			Assign copy precedence to these new non-snap copies such that these come at the end after the existing copies
			*/
UPDATE CommServ_Merge..CCM_ArchGroupCopy SET copy = (SELECT max(copy) FROM ArchGroupCopy WHERE archGroupId = @AGId) + @tmpCnt
			WHERE id = @AGCId
			SET @tmpCnt = @tmpCnt + 1
			FETCH NEXT FROM CopyCursor_1 INTO @AGCId
		END
		CLOSE CopyCursor_1
		DEALLOCATE CopyCursor_1
		FETCH NEXT FROM PolicyCurSor_1 INTO @AGId
	END
	CLOSE PolicyCursor_1
	DEALLOCATE PolicyCursor_1
	---------------------------------------------------------
	DECLARE @errorCode integer
	DECLARE @new_id integer
	DECLARE @old_id integer
	DECLARE @name varchar(1024)
	DECLARE @tempName varchar(1024)
	DECLARE @new_origCCcommCellId integer
	DECLARE @new_origCCArchCopyId integer
	DECLARE @new_archGroupId integer
	DECLARE @new_calendarId integer
	DECLARE @index int
	DECLARE CUR_ArchGroupCopy cursor LOCAL for
		SELECT old_id, new_id, new_origCCcommCellId, new_origCCArchCopyId, new_archGroupId, name, new_calendarId
		FROM CCM_MAP_ArchGroupCopy
		WHERE exist = 0
	OPEN CUR_ArchGroupCopy
	FETCH CUR_ArchGroupCopy into @old_id, @new_id, @new_origCCcommCellId, @new_origCCArchCopyId, @new_archGroupId, @name, @new_calendarId
	while @@FETCH_STATUS = 0
	BEGIN
		-- DefaultCopy is SET to 0 AND will be updated once ArchGroupCopycopy table is merged
		-- IncrSp is SET to 0 AND should be reconfig by user IF it is needed
		-- siloAppId is SET to 0 AND will be updated once App_Application table is merged
		-- siloRestoreMAClientId AND siloRestoreClientId columns are always set to 0 when merged
		IF @new_id = -1
		BEGIN
			-- Migrate back to original commcell but original storage policy copy was deleted,
			-- so create new one using its original id
			SET @new_id = @new_origCCArchCopyId
			SET @index = 0
			SET @tempName = @name
			WHILE(exists (select * from archGroupCopy where name = @tempName and archGroupId = @new_archGroupId))
			BEGIN
				SET @index = @index + 1
				SET @tempName = @name + '(' + cast(@index as varchar(32)) + ')'
			END
			SET @name	= @tempName
			SET IDENTITY_INSERT ArchGroupCopy ON
			INSERT INTO ArchGroupCopy
					(id, archGroupId, copy, name, flags,
					maxMultiplex, isActive, type, startTime, waitForIfOffline,
					waitForIfBusy, archCheckStartTime, origCCcommCellID, origCCarchCopyId, sourceCopyId,
					delayedDays, maxStreamNum, archCheckValidPeriod, calendarId, SIDBStoreId,
					encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
					SIDBSnapIntervalHours, siloAppId, nDataInstance, description, dedupeFlags,
					blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId,
					sealStoreTaskId, extendedFlags, destMediaCopyId, maxCacheDBSizeMB, archCheckValidPeriodType, endTime)
			VALUES	(@new_origCCArchCopyId, @new_archGroupId, 0, @name,	0,
					0, 0, 0, 0,	0,
					0, 0, @new_origCCcommCellId, @new_origCCArchCopyId,	0,
					0, 0, 0, @new_calendarId, 0,
					0, 0, 0, 0,	0,
					0, 0, 0,'', 0,
					0, 0, 0, 0, 0,
					0, 0, 0, 0, 0, 2147483647)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchGroupCopy -- INSERT 1'
				SET IDENTITY_INSERT ArchGroupCopy OFF
				GOTO CX_ERROR_EXIT
			END
			SET IDENTITY_INSERT ArchGroupCopy OFF
			UPDATE ArchGroupCopy SET
				copy = b.copy,
				flags = b.flags,
				maxMultiplex = b.maxMultiplex,
				isActive = b.isActive,
				type = b.type,
				startTime = b.startTime,
				waitForIfOffline = b.waitForIfOffline,
				waitForIfBusy = b.waitForIfBusy,
				archCheckStartTime = b.archCheckStartTime,
				-- sourceCopyId = b.sourceCopyId,
				delayedDays = b.delayedDays,
				maxStreamNum = b.maxStreamNum,
				archCheckValidPeriod = b.archCheckValidPeriod,
				-- siloAppId = b.siloAppId,
				nDataInstance = b.nDataInstance,
				description = b.description,
				isSnapCopy = b.isSnapCopy,
				isMirrorCopy = b.isMirrorCopy,
				silosInCache = b.silosInCache,
				blockCacheValidDays = b.blockCacheValidDays,
				NWWriteSpeed = b.NWWriteSpeed,
				nSiloStreams = b.nSiloStreams,
				--siloRestoreMAClientId = b.siloRestoreMAClientId,
				--siloRestoreClientId = b.siloRestoreClientId,
				SIDBSnapIntervalHours = b.SIDBSnapIntervalHours,
dedupeFlags = (b.dedupeFlags & ~262144),
				sealStoreTaskId = 0,
				extendedFlags	= b.extendedFlags,
				maxCacheDBSizeMB = b.maxCacheDBSizeMB,
				archCheckValidPeriodType = b.archCheckValidPeriodType,
				endTime = b.endTime
FROM  ArchGroupCopy a, CommServ_Merge..CCM_ArchGroupCopy b
			WHERE a.id = @new_id and b.id = @old_id
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchGroupCopy -- UPDATE 2'
				GOTO CX_ERROR_EXIT
			END
		END
		ELSE IF @new_id = 0
		BEGIN
			IF @isTapeImport = 2
			BEGIN
				SET @index = PATINDEX ('EDC_%', @name)
				IF @index > 0
					SET @name = 'EDC_' + SUBSTRING(@name, @index+4, 1024)
				ELSE
					SET @name = 'EDC_' + @name
			END
ELSE IF ( (@ccmParamFlags & 1	) = 1	) /*GRC merge */
			BEGIN
				DECLARE		@podCellName	VARCHAR(1024)
				IF (
					SELECT ISNULL(longVal, 0) FROM GRC_CommCellProp
					WHERE commcellId = @commcellId
AND propId = 1
				) = 0								/*If use prefix set then add a prefix always*/
				BEGIN
					SET @podCellName = ISNULL(
											(
												SELECT stringVal FROM GRC_CommCellProp
												WHERE commcellId = @commcellId
AND propId = 3
											),
											(SELECT aliasName FROM CCM_MAP_CommCell WHERE old_id = 2)
										)
					SET @index = PATINDEX (@podCellName+'[_]%', @name)
					IF @index = 0
						SET @name = @podCellName+'_' + @name
				END
				ELSE IF EXISTS (SELECT 1 FROM archGroupCopy WHERE name = @name AND archGroupId = @new_archGroupId)  /*If use suffix is set then add a suffix only when name exists already*/
				BEGIN
					SET @podCellName = ISNULL(
											(
												SELECT stringVal FROM GRC_CommCellProp
												WHERE commcellId = @commcellId
AND propId = 2
											),
											(SELECT aliasName FROM CCM_MAP_CommCell WHERE old_id = 2)
										)
					SET @index = PATINDEX ('%[_]'+@podCellName, @name)
					IF @index = 0
						SET @name = @name + '_' + @podCellName
				END
			END
			ELSE
			BEGIN
				SET @index = PATINDEX ('%CCM_%', @name)
				IF @index > 0
					SET @name = 'CCM_' + SUBSTRING(@name, @index+4, 1024)
				ELSE
					SET @name = 'CCM_' + @name
			END
			SET @index = 0
			SET @tempName = @name
			WHILE(exists (select * from archGroupCopy where name = @tempName and archGroupId = @new_archGroupId))
			BEGIN
				SET @index = @index + 1
				SET @tempName = @name + '(' + cast(@index as varchar(32)) + ')'
			END
			SET @name = @tempName
			DECLARE @SizeOfnameCol integer
			SELECT @SizeOfnameCol = CHARACTER_MAXIMUM_LENGTH FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME LIKE 'archGroupCopy' AND COLUMN_NAME = 'name'
			IF LEN(@name)> @SizeOfnameCol
				SET @name = SUBSTRING(@name, 1, @SizeOfnameCol)
			INSERT into ArchGroupCopy (
				archGroupId, copy, name, flags,
				maxMultiplex, isActive, type, startTime, waitForIfOffline,
				waitForIfBusy, archCheckStartTime, origCCcommCellID, origCCarchCopyId, sourceCopyId,
				delayedDays, maxStreamNum, archCheckValidPeriod, calendarId, SIDBStoreId,
				encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
				SIDBSnapIntervalHours, siloAppId, nDataInstance, description, dedupeFlags,
				blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId,
				sealStoreTaskId, extendedFlags, destMediaCopyId, maxCacheDBSizeMB, archCheckValidPeriodType, endTime)
			SELECT @new_archGroupId, copy, @name, flags,
				maxMultiplex, isActive, type, startTime, waitForIfOffline,
				waitForIfBusy, archCheckStartTime, @new_origCCcommCellId, @new_origCCarchCopyId, 0,
				delayedDays, maxStreamNum, archCheckValidPeriod, @new_calendarId, 0,
				encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
SIDBSnapIntervalHours, 0, nDataInstance, description, dedupeFlags & (~262144),
				blockCacheValidDays, nSiloStreams, silosInCache, 0, 0, 0,
				CASE @new_origCCcommCellId WHEN 2
					THEN extendedFlags
					ELSE
					(
CASE WHEN (@ccmParamFlags & 1) > 0
THEN (extendedFlags | 32 | 64)
ELSE (extendedFlags | 32)
						END
					)
				END,
				0, maxCacheDBSizeMB, archCheckValidPeriodType, endTime
FROM CommServ_Merge..CCM_ArchGroupCopy
			WHERE id = @old_id
			SELECT @new_id = @@IDENTITY, @errorCode = @@ERROR
			IF	@errorCode > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchGroupCopy -- INSERT 2'
				GOTO CX_ERROR_EXIT
			END
		END
		UPDATE CCM_MAP_ArchGroupCopy SET new_id = @new_id WHERE old_id = @old_id
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_ArchGroupCopy -- UPDATE 6'
			GOTO CX_ERROR_EXIT
		END
		FETCH CUR_ArchGroupCopy into @old_id, @new_id, @new_origCCcommCellId, @new_origCCArchCopyId, @new_archGroupId, @name, @new_calendarId
	END
	CLOSE CUR_ArchGroupCopy
	DEALLOCATE CUR_ArchGroupCopy
	--Update source copy id
	UPDATE 	ArchGroupCopy
	SET 	sourceCopyId = d.new_id
	FROM  	ArchGroupCopy a INNER JOIN CCM_MAP_ArchGroupCopy b ON a.id = b.new_id
INNER JOIN CommServ_Merge..CCM_ArchGroupCopy c ON b.old_id = c.id
		INNER JOIN CCM_MAP_ArchGroupCopy d ON c.sourceCopyId = d.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchGroupCopy -- UPDATE sourceCopyId'
		GOTO CX_ERROR_EXIT
	END
	--Update destMedia copy id
	UPDATE 	ArchGroupCopy
	SET 	destMediaCopyId = d.new_id
	FROM  	ArchGroupCopy a INNER JOIN CCM_MAP_ArchGroupCopy b ON a.id = b.new_id
INNER JOIN CommServ_Merge..CCM_ArchGroupCopy c ON b.old_id = c.id
		INNER JOIN CCM_MAP_ArchGroupCopy d ON c.destMediaCopyId = d.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchGroupCopy -- UPDATE destMediaCopyId'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Update defaultCopy of ArchGroup table
	UPDATE	CCM_MAP_ArchGroup SET new_defaultCopy = b.new_id
	FROM	CCM_MAP_ArchGroup a, CCM_MAP_ArchGroupCopy b
	WHERE	a.old_id = b.old_archGroupId
	AND		a.old_defaultCopy = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_ArchGroup -- UPDATE new_defaultCopy'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	ArchGroup set defaultCopy = b.new_defaultCopy
	FROM	ArchGroup a, CCM_MAP_ArchGroup b
	WHERE	a.id = b.new_id
	AND
	(
		b.exist = 0
		OR
		(
			(
(@ccmParamFlags & 1) > 0
OR EXISTS(SELECT 1 FROM CCM_TapeImportEntities c WHERE b.old_id = c.old_id AND a.origCCcommCellID = c.newCCId AND a.id = c.new_id AND c.entityType=17)
			)
			AND a.defaultCopy <> b.new_defaultCopy
		)
	)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchGroup -- UPDATE defaultCopy'
		GOTO CX_ERROR_EXIT
	END
	-- Update defaultSnapCopy of ArchGroup table
	UPDATE	CCM_MAP_ArchGroup SET new_defaultSnapCopy = b.new_id
	FROM	CCM_MAP_ArchGroup a, CCM_MAP_ArchGroupCopy b
	WHERE	a.old_id = b.old_archGroupId
	AND		a.old_defaultSnapCopy = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_ArchGroup -- UPDATE new_defaultSnapCopy'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	ArchGroup set defaultSnapCopy = b.new_defaultSnapCopy
	FROM	ArchGroup a, CCM_MAP_ArchGroup b
	WHERE	a.id = b.new_id
	AND
	(
		b.exist = 0
		OR
		(
			(
(@ccmParamFlags & 1) > 0
				OR
EXISTS(SELECT 1 FROM CCM_TapeImportEntities c WHERE b.old_id = c.old_id AND a.origCCcommCellID = c.newCCId AND a.id = c.new_id AND c.entityType=17)
			)
			AND a.defaultSnapCopy <> b.new_defaultSnapCopy
		)
	)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchGroup -- UPDATE defaultSnapCopy'
		GOTO CX_ERROR_EXIT
	END
	-- End ArchGroupCopy Merge
	---------------------------------------------------------
	-- Merge ArchCopyMediaRefreshProp
	INSERT INTO ArchCopyMediaRefreshProp
	SELECT A.new_id,C.new_id, B.flags, B.daysAfterWritten, B.daysBeforeAged, B.percentage
FROM CommServ_Merge..CCM_ArchCopyMediaRefreshProp B
		 INNER JOIN CCM_MAP_ArchGroupCopy A ON A.old_id = B.copyId
		 INNER JOIN CCM_MAP_ArchGroupCopy C ON B.targetCopyId = C.old_id
	WHERE NOT EXISTS(SELECT 1 FROM ArchCopyMediaRefreshProp WHERE copyId = A.new_id)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchCopyMediaRefreshProp'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge archCopyToGlobalPolicy
	INSERT INTO archCopyToGlobalPolicy
	SELECT B.new_Id, C.new_Id, A.flags
FROM CommServ_Merge..CCM_archCopyToGlobalPolicy A INNER JOIN CCM_MAP_ArchGroupCopy B ON A.copyId = B.old_id
		INNER JOIN CCM_MAP_ArchGroup C ON A.globalPolicyId = C.old_id
		LEFT OUTER JOIN archCopyToGlobalPolicy D ON B.new_id = D.copyId
	WHERE D.copyId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- archCopyToGlobalPolicy'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge ArchAgingRule Table
	--Disable dataaging for GRC copies. If user enables dataaging using MMConfig param then don't disable DA.
	--Do the same for regular CCM also
	DECLARE @enableDataAging integer = 0
	SET @enableDataAging = ISNULL((SELECT value from MMConfigs where name = 'CCM_CONFIG_ENABLE_DATAAGING_FOR_GRC'),0)
	IF (@enableDataAging = 0)
	BEGIN
UPDATE CommServ_Merge..CCM_ArchAgingRule
SET	flags = (CASE WHEN (@ccmParamFlags & 1) > 0
THEN (flags | 256 | 4) ELSE (flags | 4) END)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchAgingRule - UPDATE Disable DataAging'
			GOTO CX_ERROR_EXIT
		END
	END
	insert into ArchAgingRule
	select a.new_id, b.retentionDays, b.fullCycles, b.flags, b.weekStart, b.monthStart, b.yearStart, b.archiverRetDays, b.retentionJobs , b.minutesSinceDayStarts
from CCM_MAP_ArchGroupCopy a, CommServ_Merge..CCM_ArchAgingRule b
	where a.old_id = b.copyId
	and a.new_id not in (select copyId from ArchAgingRule)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchAgingRule'
		GOTO CX_ERROR_EXIT
	END
	-- kbora Update tape import created properties
	UPDATE archAgingRule
	SET retentionDays = D.retentionDays,
		fullCycles = D.fullCycles,
		flags = D.flags,
		weekStart = D.weekStart,
		monthStart = D.monthStart,
		yearStart = D.yearStart,
		archiverRetDays = D.archiverRetDays,
		retentionJobs = D.retentionJobs,
		minutesSinceDayStarts = D.minutesSinceDayStarts
FROM archAgingRule A, CCM_TapeImportEntities B, CCM_MAP_ArchGroupCopy C, CommServ_Merge..CCM_ArchAgingRule D
WHERE A.copyId = B.new_id AND B.entityType = 18 AND C.old_id = D.copyId AND C.new_id = A.copyId
              AND C.new_origCCcommCellId = B.newCCId
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'CCM_Merge_Main -- UPDATE archAgingRule for tapeimported Copies'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge ArchAgingRuleExtended Table
	insert into ArchAgingRuleExtended
	select a.new_id, b.retentionDays, b.retentionRule, b.currPeriodBegin, b.currPeriodEnd, b.prevPeriodBegin, b.nextPeriodEnd, b.GraceDays , b.EveryXHours
from CCM_MAP_ArchGroupCopy a, CommServ_Merge..CCM_ArchAgingRuleExtended b, CommServ_Merge..CCM_ArchGroupCopy c
	where a.old_id = b.copyId
	and a.new_id not in (select distinct copyId from ArchAgingRuleExtended)
	and c.id = a.old_id
	-- For GACP dependent copies, trigger will take care of adding this info.
and (c.destMediaCopyId = 0 OR (c.destMediaCopyId > 0 AND c.extendedFlags & 2048 = 2048))
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchAgingRuleExtended'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge ArchSelectiveCopy Table
-- DB: Table change FIX:
	insert into ArchSelectiveCopy
	select a.new_id, b.type, b.numPeriod, b.dayNumber, b.startPeriod, b.nextPeriod, b.prevPeriodBegin, b.nextPeriodEnd
from CCM_MAP_ArchGroupCopy a, CommServ_Merge..CCM_ArchSelectiveCopy b
	where a.old_id = b.copyId
	and a.new_id not in (select distinct copyId from ArchSelectiveCopy)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchSelectiveCopy'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge IdxSIDBStore Table
	/*
	   Consider only those SIDB Store(s) for which the answers are provided by the merge user
	                                      Incoming SIDB Stores
	                                               |
                  ------------------------------------------------------------------------
                  |                                                                       |
            existing SIDB Stores                                                   New SIDB Stores
                  |                                                                       |
           ----------------------                                               ---------------------
           |                     |                                              |                    |
  New copy association   No new copy association                         New copy association   Already migrated copy
      from source             from source                                    from source             |
           |                     |                                              |                    |
   Insert copy assoc         No action                                   Create SIDB Store      Create SIDB Store
                                                                         Insert copy assoc      Update copy assoc
	*/
	DECLARE @commcellGUID nvarchar(max)
SET @commcellGUID = (SELECT csGUID FROM CommServ_Merge..CCM_APP_Commcell WHERE id = 2 and type = 1)
UPDATE CommServ_Merge..CCM_IdxSIDBStore
	SET origCCSIDBStoreId = SIDBStoreId
	WHERE origCCSIDBStoreId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_IdxSIDBStore -- UPDATE -- origCCSIDBStoreId'
		GOTO CX_ERROR_EXIT
	END
UPDATE CommServ_Merge..CCM_IdxSIDBStore
	SET CommCellId = 2
	WHERE CommCellId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_IdxSIDBStore -- UPDATE -- CommCellId'
		GOTO CX_ERROR_EXIT
	END
	-- Get the IdxSIDBStore list to be merged
	INSERT	INTO CCM_MAP_IdxSIDBStore
	SELECT	a.SIDBStoreId, 0, a.origCCSIDBStoreId, a.CommCellId, b.new_id, 0
FROM	CommServ_Merge..CCM_IdxSIDBStore a, CCM_MAP_CommCell b
	WHERE   a.CommCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_IdxSIDBStore -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Check whether IdxSIDBStore exists
	UPDATE	CCM_MAP_IdxSIDBStore
	SET     exist = 1, new_SIDBStoreId = b.SIDBStoreId                  -- 1 indicates SIDB exists
	FROM	CCM_MAP_IdxSIDBStore a, idxSIDBStore b
	WHERE (
			 (b.origCCSIDBStoreId <> 0 and a.origCCSIDBStoreId = b.origCCSIDBStoreId)
			 OR
			 (b.origCCSIDBStoreId = 0 and a.origCCSIDBStoreId = b.SIDBStoreId)
			  )
	AND		a.new_CommCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_IdxSIDBStore -- UPDATE exist SIDB alone'
		GOTO CX_ERROR_EXIT
	END
	-- Merge all stores as sealed except if merging from same CommCell
	INSERT INTO IdxSIDBStore (
		SIDBStoreName, SIDBStoreAliasName, CommCellId,
		IdxCacheId, IdxAccessPathId, ClientId,
		FirstBackupTime, MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType,
		flags, TotalDataSizeBytes, InstancedDataSizeBytes, Status,
		LastAccessTime, CreatedTime, SealedTime, origCCSIDBStoreId, Version,
		SIDBSnapPath, LastSnapTime, LastRecoveryTime, SealedReason, SIDBSiloedTime, SIDBSiloStatus, SIDBSiloJobId, SubStoreCount, MaxAllowedConnections, MaxNumOfAFsInSecFile, AppTypeGroupId, ExtendedFlags)
	SELECT
		b.SIDBStoreName, b.SIDBStoreAliasName, a.new_commCellId,
		0 /*IdxCacheId*/, 0 /*IdxAccessPathId*/, 0 /*clientId*/,
		b.FirstBackupTime, b.MinObjSizeKB, b.oldestEligibleObjArchiveTime, b.SignatureType,
		b.flags, b.TotalDataSizeBytes, b.InstancedDataSizeBytes, b.Status,
		b.LastAccessTime, b.CreatedTime, CASE SealedTime WHEN 0 THEN dbo.GetUnixTime(getutcdate()) ELSE SealedTime END,
		a.origCCSIDBStoreId, b.Version, b.SIDBSnapPath, b.LastSnapTime, b.LastRecoveryTime,
CASE SealedReason WHEN 0 THEN 7 ELSE SealedReason END,
		b.SIDBSiloedTime, b.SIDBSiloStatus, b.SIDBSiloJobId, b.SubStoreCount,
b.MaxAllowedConnections, b.MaxNumOfAFsInSecFile, b.AppTypeGroupId, b.ExtendedFlags & ~(2)
FROM	CCM_MAP_IdxSIDBStore a, CommServ_Merge..CCM_IdxSIDBStore b
	WHERE	a.old_SIDBStoreId = b.SIDBStoreId
			AND   a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- IdxSIDBStore -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	--Update the new storeId in map table
	UPDATE	CCM_MAP_IdxSIDBStore
	SET		new_SIDBStoreId = b.SIDBStoreId
	FROM	CCM_MAP_IdxSIDBStore a, IdxSIDBStore b
	WHERE	a.origCCSIDBStoreId = b.origCCSIDBStoreId
	  AND   a.new_commcellId = b.CommCellId
	  AND   a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_IdxSIDBStore -- UPDATE newSIDBStoreId'
		GOTO CX_ERROR_EXIT
	END
	-- Create the Copy association for the migrated SIDB Store (if it is not already present)
	INSERT 	INTO archCopySIDBStore
	SELECT 	c.new_id, a.new_SIDBStoreId, a.new_CommcellId,
b.flags & ~(4 | 2),
			b.TotalDataSizeBytes, b.InstancedDataSizeBytes
	FROM	CCM_MAP_IdxSIDBStore a
INNER JOIN CommServ_Merge..CCM_archCopySIDBStore b ON a.old_SIDBStoreId = b.SIDBStoreId
			INNER JOIN CCM_MAP_ArchGroupCopy c ON b.CopyId = c.old_id
			LEFT OUTER JOIN archCopySIDBStore d ON c.new_id = d.CopyId AND a.new_SIDBStoreId = d.SIDBStoreId AND a.new_CommCellId = d.CommCellId
	WHERE  	d.CopyId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- archCopySIDBStore -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- If GDSP has an active store already then set that as active on merging dependent copy also if exists
	UPDATE	CS
	SET		flags = GCS.flags
	FROM    archCopySIDBStore CS
            INNER JOIN CCM_MAP_ArchGroupCopy CMAP ON CS.copyId =  CMAP.new_id
            INNER JOIN archCopyToGlobalPolicy DC2GC ON DC2GC.copyId = CS.copyId
            INNER JOIN archGroupCopy GC ON GC.archGroupId = DC2GC.globalPolicyId
            INNER JOIN archCopySIDBStore GCS ON GCS.copyId = GC.id AND CS.SIDBStoreId = GCS.SIDBStoreId AND GCS.commCellId = CS.commCellId
	WHERE   CMAP.exist = 0
AND (GC.dedupeFlags & 268435456) > 0
AND GCS.flags & (4 | 2) = (4 | 2)
AND CS.flags & (4 | 2) <> (4 | 2)
	--Merge IdxSIDBSubStore
UPDATE CommServ_Merge..CCM_IdxSIDBSubStore
	SET origSubStoreId = SubStoreId
	WHERE origSubStoreId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_IdxSIDBSubStore -- UPDATE -- origSubStoreId'
		GOTO CX_ERROR_EXIT
	END
UPDATE CommServ_Merge..CCM_IdxSIDBSubStore
	SET CommCellId = 2
	WHERE CommCellId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_IdxSIDBSubStore -- UPDATE -- CommCellId'
		GOTO CX_ERROR_EXIT
	END
	--
	--PrasadNara: Migrate Stores with dummy accessPath.
	--
	INSERT 	INTO CCM_MAP_IdxSIDBSubStore
	SELECT 	a.SIDBStoreId, b.new_SIDBStoreId, a.SubStoreId, 0, a.CommCellId, b.new_CommCellId, a.clientId, 1, a.origSubStoreId, 0
FROM 	CommServ_Merge..CCM_IdxSIDBSubStore a, CCM_MAP_IdxSIDBStore b
	WHERE 	a.SIDBStoreId = b.old_SIDBStoreId
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_IdxSIDBSubStore -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS (SELECT * from CCM_MAP_IdxSIDBSubStore where new_SIDBStoreId = 0 OR new_commCellId = 0 OR new_ClientId = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_IdxSIDBSubStore -- New StoreId or CommcellId or ClientId could not be obtained for substores'
		GOTO CX_ERROR_EXIT
	END
	--Check for existing substores
	UPDATE CCM_MAP_IdxSIDBSubStore
	SET new_subStoreId = b.SubStoreId, exist = 1
	FROM CCM_MAP_IdxSIDBSubStore a, IdxSIDBSubStore b
	WHERE (
				(b.origSubStoreId = 0 AND a.origSubStoreId = b.SubStoreId)
				OR
				(b.origSubStoreId <> 0 AND a.origSubStoreId = b.origSubStoreId)
				)
	AND a.new_SIDBStoreId = b.SIDBStoreId
	AND a.new_CommCellId = b.CommCellId
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_IdxSIDBSubStore -- UPDATE Exist'
		GOTO CX_ERROR_EXIT
	END
	--Merge substores
	INSERT INTO IdxSIDBSubStore (
		SIDBStoreId, commCellId,GroupNumber,IdxCacheId,IdxAccessPathId,ClientId,FirstBackupTime,flags,TotalDataSizeBytes,
		InstancedDataSizeBytes,Status,LastAccessTime,CreatedTime,SealedTime,Version,SIDBSnapPath,LastSnapTime,origSubStoreId, ReconLevel, LastSnapJobId, DDBBackupCSGUID, PrimaryId,MemDbTimeStamp,CorruptionTime,ZeroRefBatchSeq, StartLogSequence, EndLogSequence, SnapLogSequence, MaxNumOfAFsInSecFile, ExtendedFlags, PageSize)
	SELECT
		a.new_SIDBStoreId, a.new_commCellId, b.GroupNumber,
		0 /*IdxCacheId*/, 0 /*IdxAccessPathId*/, a.new_clientId,
		b.FirstBackupTime, b.flags, b.TotalDataSizeBytes, b.InstancedDataSizeBytes, b.Status,
		b.LastAccessTime, b.CreatedTime, CASE b.SealedTime WHEN 0 THEN dbo.GetUnixTime(getutcdate()) ELSE b.SealedTime END, b.Version,
		b.SIDBSnapPath, b.LastSnapTime, b.origSubStoreId, b.ReconLevel,b.LastSnapJobId, b.DDBBackupCSGUID, b.PrimaryId,b.MemDbTimeStamp,b.CorruptionTime,b.ZeroRefBatchSeq,b.StartLogSequence, b.EndLogSequence, b.SnapLogSequence, b.MaxNumOfAFsInSecFile, b.ExtendedFlags, b.PageSize
FROM	CCM_MAP_IdxSIDBSubStore a, CommServ_Merge..CCM_IdxSIDBSubStore b
	WHERE	a.old_subStoreId = b.subStoreId
	  AND   a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- IdxSIDBSubStore -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	--Update new substoreId in map table
	UPDATE 	CCM_MAP_IdxSIDBSubStore
	SET 	new_subStoreId = SubStoreId
	FROM	CCM_MAP_IdxSIDBSubStore a, IdxSIDBSubStore b
	WHERE	a.origSubStoreId = b.origSubStoreId
	  AND   a.new_commcellId = b.CommCellId
	  AND   a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_IdxSIDBSubStore -- Update new substoreId'
		GOTO CX_ERROR_EXIT
	END
	-- Update ArchGroupCopy table
	UPDATE ArchGroupCopy
	SET	   SIDBStoreId = b.new_SIDBStoreId, dedupeFlags = a.dedupeFlags | 262144
FROM   ArchGroupCopy a, CCM_MAP_IdxSIDBStore b, CommServ_Merge..CCM_ArchGroupCopy c, CCM_MAP_ArchGroupCopy d
	WHERE  a.id = d.new_id
	  AND  d.old_id = c.id
	  AND  c.SIDBStoreId = b.old_SIDBStoreId
	  AND a.SIDBStoreId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchGroupCopy -- UPDATE SIDBStoreId'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	/*Prasad Nara: Apr 13, 2012
	 * Source CS                                   	    	Dest CS
	 * --------------------------------------         	    -------------------------------------
	 * GDSP -> Store A   got migrated              ------->	Store A      sealed
	 *														GDSP got associated with new store B
     *
	 * New sp/copy  copy_1 got created
	 * to use GDSP. So copy_1 uses Store A
     *
	 * GDSP copy and new copy copy_1 gets migrated -------> Here ccm sees GDSP copy already has an active store B
	 *														so doesnt call archCopyStartNewSIDBStore as
	 *														we do not need to create new store.
	 *														But the copy copy_1 that uses the GDSP ends up with store A that is sealed here.
	 *
	 * Fix this by updating the archGroupCopy with the active store of GDSP and insert rows into archCopySIDBStore
	 * for the copies which are using GDSP and pointing to a sealed store Store A
	 * so that these copies points to active store Store B that was created in previous merge.
	 */
	DECLARE @lt_NewCopiesUsingGDSP TABLE (copyId int, SIDBStoreId int, commCellId int, flags int)
	DECLARE @l_errCode INT = 0
	DECLARE @l_rowCount INT = 0
	--Get the copies pointing to sealed store and which are using GDSP having active store
	INSERT 	INTO @lt_NewCopiesUsingGDSP
	SELECT 	DC.Id, GCS.SIDBStoreId, GCS.commCellId, GCS.flags
	FROM 	CCM_MAP_ArchGroupCopy CMAP
			INNER JOIN archGroupCopy DC ON DC.id = CMAP.new_id
			INNER JOIN archCopyToGlobalPolicy DC2GC ON DC2GC.copyId = DC.id
			INNER JOIN archGroupCopy GC ON GC.archGroupId = DC2GC.globalPolicyId
			INNER JOIN archCopySIDBStore GCS ON GCS.copyId = GC.id
AND GCS.flags & (4 | 2) = (4 | 2)
WHERE 	(GC.dedupeFlags & 268435456) <> 0
			AND NOT EXISTS
			(
				SELECT 	1
				FROM 	archCopySIDBStore DCS
				WHERE 	DCS.copyId = DC.id
AND DCS.flags & (4 | 2) = (4 | 2)
			)
	SELECT @l_errCode = @@ERROR, @l_rowCount = @@ROWCOUNT
	IF  @l_errCode > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- @lt_NewCopiesUsingGDSP -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	IF @l_rowCount > 0
	BEGIN
		--Insert copy and new store association
		INSERT 	INTO archCopySIDBStore
		SELECT 	copyId, SIDBStoreId, commcellId, flags, 0, 0
		FROM 	@lt_NewCopiesUsingGDSP
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- archCopySIDBStore -- INSERT new copy association'
			GOTO CX_ERROR_EXIT
		END
		--Update the copies storeId with active StoreId
		UPDATE 	archGroupCopy
		SET 	SIDBStoreId = b.SIDBStoreId
		FROM 	archGroupCopy a
				INNER JOIN @lt_NewCopiesUsingGDSP b ON a.id = b.copyId
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- archGroupCopy -- UPDATE storeId'
			GOTO CX_ERROR_EXIT
		END
	END
	--------------------------------------------------------
	/*
	Incoming Copies -- So just check if the copy has an associated store that is open and active
	It might be either the incoming store for this copy already exists but sealed somehow and this copy has no other active store
	Or the only store it has is the one brought by CCM - and we'll seal the incoming store
	So set flag that this copy needs to create store - and created in CCM_Merge_MM
	*/
	UPDATE 	CCM_MAP_ArchGroupCopy
	SET 	copyNeedsStore = 1
	FROM	CCM_MAP_ArchGroupCopy a, ArchGroupCopy b
	WHERE 	a.new_id > 0
			AND a.new_id = b.id
AND b.dedupeFlags & (134217728 | 262144) = 262144
			AND NOT EXISTS
			(
				SELECT 	1
				FROM 	archCopySIDBStore c
				WHERE 	c.copyId = b.id
AND c.flags & (4 | 2) = (4 | 2)
			)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- CCM_MAP_ArchGroupCopy -- UPDATE copyNeedsStore'
		GOTO CX_ERROR_EXIT
	END
	-- Create new stores for the incoming archGroupCopies
	-- which does not have an active store
	-- we create dummy store just a place holder to make GUI/Reports work properly
	-- remove this code once we support CCM copy without active store
DECLARE @CopyNeedsStore TABLE(copyId int, storeName nvarchar(256), SIDBStoreId int)
	DECLARE @l_today DATETIME = GetUTCDate()
	DECLARE @l_todayStr NVARCHAR(30) = N' (' + CAST(@l_today AS nvarchar(24)) + N')'
	DECLARE @l_now INT = dbo.GetUnixTime(@l_today)
	INSERT 	INTO @CopyNeedsStore
SELECT 	b.id, (case when b.dedupeFlags & 268435456 > 0 then c.name else c.name + '_' + b.name end), 0
	FROM	CCM_MAP_ArchGroupCopy a, ArchGroupCopy b, ArchGroup c
	WHERE 	a.new_id > 0
			AND a.new_id = b.id
			AND b.archGroupId = c.id
AND b.dedupeFlags & (134217728 | 262144) = 262144
			AND NOT EXISTS
			(
				SELECT 	1
				FROM 	archCopySIDBStore c
				WHERE 	c.copyId = b.id
AND c.flags & (4 | 2) = (4 | 2)
			)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- @CopyNeedsStore -- Get Copy Needs Store'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO IdxSIDBStore (SIDBStoreName, SIDBStoreAliasName, CommCellId,
							IdxCacheId, IdxAccessPathId, ClientId, FirstBackupTime,
							MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType, flags,
							TotalDataSizeBytes, InstancedDataSizeBytes, Status, LastAccessTime,
							CreatedTime, SealedTime, origCCSIDBStoreId, Version,
							SIDBSnapPath, LastSnapTime, LastRecoveryTime, SealedReason,
							SIDBSiloedTime, SIDBSiloStatus, SIDBSiloJobId, SubStoreCount,
							MaxAllowedConnections, MaxNumOfAFsInSecFile, LastDDBVerificationTime, LastDataVerificationTime,
							DedupFactor, AppTypeGroupId, ExtendedFlags)
	SELECT	StoreName + @l_todayStr, StoreName, 2,
			0, 0, 0, -1,
			50, -1, 4, 0,
			0, 0, 0, 0,
			@l_now, 0, 0, -1,
			'', 0, 0, 0,
			0, 0, 0, 1,
			0, 0, 0, 0,
0, 0, 2
	FROM	@CopyNeedsStore
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- IdxSIDBStore -- Create New DDB'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	C
	SET		SIDBStoreId = S.SIDBStoreId
	FROM	@CopyNeedsStore C, IdxSIDBStore S
	WHERE	S.SIDBStoreName = C.StoreName + @l_todayStr
AND S.ExtendedFlags & 2 > 0
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- @CopyNeedsStore -- UPDATE SIDBStoreId'
		GOTO CX_ERROR_EXIT
	END
	-- taken from IdxSIDBSubStore.upg
	INSERT INTO IdxSIDBSubStore (
		SIDBStoreId, commCellId,GroupNumber,IdxCacheId,IdxAccessPathId,ClientId,FirstBackupTime,flags,TotalDataSizeBytes,
		InstancedDataSizeBytes,Status,LastAccessTime,CreatedTime,SealedTime,Version,SIDBSnapPath,LastSnapTime,origSubStoreId, ReconLevel, LastSnapJobId, DDBBackupCSGUID, PrimaryId,MemDbTimeStamp,CorruptionTime,ZeroRefBatchSeq, StartLogSequence, EndLogSequence, SnapLogSequence, MaxNumOfAFsInSecFile, ExtendedFlags, DDBSubClientId, PageSize)
	SELECT S.SIDBStoreId, S.CommCellId, 0, 0, 0, 1, S.FirstBackupTime, S.flags, S.TotalDataSizeBytes, S.InstancedDataSizeBytes,
                 S.Status, S.LastAccessTime, S.CreatedTime, S.SealedTime, S.Version, S.SIDBSnapPath, S.LastSnapTime, 0, 0, 0, '', 0, 0, 0, 0, '', '', '', 0, 0, 0, 0
	FROM IdxSIDBStore S INNER JOIN @CopyNeedsStore T ON T.SIDBStoreId = S.SIDBStoreId
	WHERE S.SIDBStoreId > 0
		AND NOT EXISTS (SELECT 1 FROM IdxSIDBSubStore T WHERE T.SIDBStoreId = S.SIDBStoreId)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- IdxSIDBSubStore -- Create New subStore.'
		GOTO CX_ERROR_EXIT
	END
	INSERT  INTO archCopySIDBStore
SELECT  GP.copyId, C.SIDBStoreId, 2, (4 | 2), 0, 0
    FROM    @CopyNeedsStore C, archGroupCopy AGC WITH(READUNCOMMITTED), archCopyToGlobalPolicy GP WITH(READUNCOMMITTED)
WHERE C.copyId = AGC.id AND AGC.dedupeFlags & 268435456 > 0
    AND AGC.archGroupId = GP.globalPolicyId
    IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- IdxSIDBSubStore -- Insert.'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO archCopySIDBStore
SELECT	copyId, SIDBStoreId, 2, (4 | 2), 0, 0
	FROM	@CopyNeedsStore
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- archCopySIDBStore -- INSERT active DDB association'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	AGC
	SET 	SIDBStoreId = C.SIDBStoreId
	FROM	archGroupCopy AGC, @CopyNeedsStore C
	WHERE	AGC.id = C.copyId
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- archGroupCopy -- UPDATE active SIDBStoreId'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge ArchEncKeyProvider & ArchEncKeyProviderAssoc & ArchCopyEncProperties Tables
	-- Before merge first remove passphrase client details as we are not migrating passphrase clients.
	IF OBJECT_ID('tempdb..#keyProvider') IS NOT NULL
		DROP TABLE #keyProvider
	CREATE TABLE #keyProvider ( keyProviderId INT, Properties XML)
	INSERT INTO #keyProvider
	SELECT KeyProviderId, Properties
FROM CommServ_Merge..CCM_ArchEncKeyProvider
	UPDATE #keyProvider
	SET Properties.modify('delete /App_EncKeyProviderProperties/passphraseClient')
UPDATE CommServ_Merge..CCM_ArchEncKeyProvider
	SET Properties = CAST(B.Properties AS NVARCHAR(MAX))
FROM CommServ_Merge..CCM_ArchEncKeyProvider A INNER JOIN #keyProvider B ON A.KeyProviderId = B.keyProviderId
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: Failed to delete the passphrase client info from merge db.'
		GOTO CX_ERROR_EXIT
	END
IF EXISTS(SELECT 1 FROM CommServ_Merge..CCM_ArchEncKeyProvider WHERE KeyProviderId = 1)
	BEGIN
		-- If CommServer specific passphrase is set then restores doesn't work on destination since we can't decrypt keys
		-- So blocking import for this case
		DECLARE @l_properties xml = ISNULL((SELECT properties FROM ArchEncKeyProvider WHERE KeyProviderId = 1), '<App_EncKeyProviderProperties/>')
		IF ISNULL((SELECT	col.value('@usePassphrase', 'int')
			FROM @l_properties.nodes('App_EncKeyProviderProperties') as node(col)), 0) = 1
		BEGIN
			SET @errStr = 'ERROR: CCM is not supported when CommServer specific passphrase is used for encrypting master keys. ADVICE: Disable passphrase temporarily and enable it back after doing CCM'
			GOTO CX_ERROR_EXIT
		END
	END
	--Check for any name conflicts
IF EXISTS(SELECT 1 FROM CommServ_Merge..CCM_ArchEncKeyProvider a INNER JOIN ArchEncKeyProvider b ON a.KeyProviderName = b.KeyProviderName AND a.GUID <> b.GUID )
	BEGIN
		SET @errStr = 'ERROR: Key providers with following names already exists. ADVICE: Change the key providers name either on source CommServe or destination CommServe'
		SELECT @errStr = @errStr + CHAR(13)+CHAR(10) + a.KeyProviderName
FROM CommServ_Merge..CCM_ArchEncKeyProvider a INNER JOIN ArchEncKeyProvider b ON a.KeyProviderName = b.KeyProviderName AND a.GUID <> b.GUID
		GOTO CX_ERROR_EXIT
	END
	--Update properties for existing entries if source has latest values
	UPDATE	ArchEncKeyProvider
	SET		KeyProviderName = b.KeyProviderName,
			EncType			= b.EncType,
			EncKeyLength	= b.EncKeyLength,
			Properties		= b.Properties
	FROM	ArchEncKeyProvider a
INNER JOIN CommServ_Merge..CCM_ArchEncKeyProvider b ON a.GUID = b.GUID
	WHERE	b.Modified > a.Modified AND a.KeyProviderId > 1  --Do not update default CV Provider properties.
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchEncKeyProvider -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	IF @isTapeImport <> 1
	BEGIN
		INSERT 	INTO ArchEncKeyProvider
		SELECT 	a.KeyProviderName, a.KeyProviderType, a.EncType, a.EncKeyLength, a.Properties, a.Modified, a.Created, a.GUID
FROM	CommServ_Merge..CCM_ArchEncKeyProvider a
				LEFT OUTER JOIN ArchEncKeyProvider b ON a.GUID = b.GUID
		WHERE	b.GUID IS NULL
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchEncKeyProvider -- INSERT'
			GOTO CX_ERROR_EXIT
		END
IF OBJECT_ID('CommServ_Merge..CCM_ArchEncKeyProviderAssoc') IS NOT NULL
		BEGIN
			INSERT 	INTO ArchEncKeyProviderAssoc (EntityId, EntityType, KeyProviderId)
			SELECT	c.new_id, a.EntityType, d.KeyProviderId
FROM	CommServ_Merge..CCM_ArchEncKeyProviderAssoc a
INNER JOIN CommServ_Merge..CCM_ArchEncKeyProvider b ON a.KeyProviderId = b.KeyProviderId
INNER JOIN CCM_MAP_ArchGroupCopy c ON a.EntityId = c.old_id AND a.EntityType = 18
					INNER JOIN ArchEncKeyProvider d ON b.GUID = d.GUID
LEFT OUTER JOIN ArchEncKeyProviderAssoc e ON c.new_id = e.EntityId AND e.EntityType = 18
			WHERE	e.EntityId IS NULL
			IF @@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchEncKeyProviderAssoc -- INSERT'
				GOTO CX_ERROR_EXIT
			END
		END
		ELSE
		BEGIN
			INSERT 	INTO ArchEncKeyProviderAssoc (EntityId, EntityType, KeyProviderId)
SELECT	c.new_id, 18, d.KeyProviderId
FROM	CommServ_Merge..CCM_ArchCopyEncProperties a
INNER JOIN CommServ_Merge..CCM_ArchEncKeyProvider b ON a.KeyProviderId = b.KeyProviderId
					INNER JOIN CCM_MAP_ArchGroupCopy c ON a.CopyId = c.old_id
					INNER JOIN ArchEncKeyProvider d ON b.GUID = d.GUID
LEFT OUTER JOIN ArchEncKeyProviderAssoc e ON c.new_id = e.EntityId AND e.EntityType = 18
			WHERE	e.EntityId IS NULL
			IF @@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchEncKeyProviderAssoc -- INSERT'
				GOTO CX_ERROR_EXIT
			END
		END
		INSERT 	INTO ArchCopyEncProperties (CopyId, PubKey, PriKey, MasterKeyId, KeyProviderId, EncType)
		SELECT	c.new_id, a.PubKey, a.PriKey, a.MasterKeyId, d.KeyProviderId, a.EncType
FROM	CommServ_Merge..CCM_ArchCopyEncProperties a
INNER JOIN CommServ_Merge..CCM_ArchEncKeyProvider b ON a.KeyProviderId = b.KeyProviderId
				INNER JOIN CCM_MAP_ArchGroupCopy c ON a.CopyId = c.old_id
				INNER JOIN ArchEncKeyProvider d ON b.GUID = d.GUID
				LEFT OUTER JOIN ArchCopyEncProperties e ON c.new_id = e.CopyId
		WHERE	e.CopyId IS NULL
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- ArchCopyEncProperties -- INSERT'
			GOTO CX_ERROR_EXIT
		END
	END
	IF @isTapeImport = 1
	BEGIN
		UPDATE ArchCopyEncProperties
		SET PriKey = A.PriKey,
			MasterKeyId = A.MasterKeyId
FROM CommServ_Merge..CCM_ArchCopyEncProperties A INNER JOIN CCM_MAP_ArchGroupCopy B ON A.CopyId = B.old_id
			INNER JOIN ArchCopyEncProperties C ON C.CopyId = B.new_id
		WHERE B.name LIKE 'TapeImportCopy_SP%' /* Only missing copies get this name */
		DECLARE @KeyProviderList NVARCHAR(MAX) = ''
		SELECT  @KeyProviderList = @KeyProviderList + CASE A.KeyProviderType
WHEN 1 THEN 'COMMVAULT'
WHEN 2 THEN 'KMIP'
WHEN 3 THEN 'AWS KMS'
WHEN 4 THEN 'AZURE KEY VAULT'
WHEN 5 THEN 'SAFENET'
WHEN 6 THEN 'PASSPHRASE'
					ELSE ''
					END + ', '
FROM CommServ_Merge..CCM_ArchEncKeyProvider A LEFT OUTER JOIN ArchEncKeyProvider B ON A.KeyProviderType = B.KeyProviderType WHERE B.KeyProviderId IS NULL
		IF @KeyProviderList <> ''
		BEGIN
			SET  @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- There are no Security keyproviders exists on this CommServer for the KeyProvider that are being merged. Please configure the keyProviders: ' + @KeyProviderList
			GOTO CX_ERROR_EXIT
		END
		ELSE
		BEGIN
			UPDATE ArchCopyEncProperties
			SET KeyProviderId = CASE WHEN E.KeyProviderId IS NULL THEN
					(SELECT MAX(AKP.KeyProviderId) FROM ArchEncKeyProvider AKP WHERE AKP.KeyProviderType = D.KeyProviderType) ELSE E.KeyProviderId END
FROM CommServ_Merge..CCM_ArchCopyEncProperties A INNER JOIN CCM_MAP_ArchGroupCopy B ON A.CopyId = B.old_id
				INNER JOIN ArchCopyEncProperties C ON C.CopyId = B.new_id
INNER JOIN CommServ_Merge..CCM_ArchEncKeyProvider D ON D.KeyProviderId = A.KeyProviderId
				LEFT OUTER JOIN ArchEncKeyProvider E ON E.GUID = D.GUID
			WHERE B.name LIKE 'TapeImportCopy_SP%' /* Only missing copies get this name */
		END
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	IF (Cursor_Status('LOCAL', 'CUR_ArchGroupCopy') >= -1)
	BEGIN
		CLOSE CUR_ArchGroupCopy
		DEALLOCATE CUR_ArchGroupCopy
	END
	IF (Cursor_Status('LOCAL', 'CUR_SIDB_SubStore') >= -1)
	BEGIN
		CLOSE CUR_SIDB_SubStore
		DEALLOCATE CUR_SIDB_SubStore
	END
	RETURN (-1)
	---------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_ArchGroupCopy')
	delete from GxQscripts where name = 'CCM_Merge_ArchGroupCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_ArchGroupCopy')
	delete from GXDBVersions where aliasname = 'CCM_Merge_ArchGroupCopy'
GO

insert into GXDBVersions values(2, 'CCM_Merge_ArchGroupCopy',  '00010083007200030000', 'CCM_Merge_ArchGroupCopy', '00010083007200030000')
GO

