

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_ArchFile.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge tables:
--	|					ArchFile
--	|					ArchFileCopy
--	|					ArchDB2Log
--	|					ArchChunk
--	|					ArchChunkMapping
--  +========================================================================+
-- $Id: CCM_Merge_ArchFile.sp,v 1.37.190.2 2018/12/27 16:46:27 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Merge_ArchFile')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Merge_ArchFile <<<'
	drop procedure CCM_Merge_ArchFile
END
IF EXISTS (select * from GxQscripts where name='CCM_Merge_ArchFile')
	delete from GxQscripts where name = 'CCM_Merge_ArchFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_ArchFile')
	delete from GXDBVersions where aliasname = 'CCM_Merge_ArchFile'
GO
print '... Creating Procedure: CCM_Merge_ArchFile'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_Merge_ArchFile
  @isTapeImport integer,
  @ccmParamFlags integer = 0,
  @i_jobId integer, 
  @errStr varchar(1024) OUTPUT
AS
SET NOCOUNT ON
	---------------------------------------------------------
--Code below here is from CCM_Merge_ArchFile.spb --
	SET @errStr = 'ERROR: GENERAL ERROR!'
	DECLARE @l_curImportJobId Integer
	SET @l_curImportJobId =  ISNULL
	(
	 (
		 @i_jobId
	 ), 0
	)
	---------------------------------------------------------
	-- Merge ArchFile Table
	INSERT	INTO CCM_MAP_ArchFile
	SELECT	id, commCellId, 0, archGroupId, 0, appId, 0, 0
FROM CommServ_Merge..CCM_ArchFile
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFile -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFile SET new_commCellId = b.new_id
	FROM CCM_MAP_ArchFile a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFile -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
IF EXISTS (SELECT * FROM CCM_MAP_ArchFile WHERE old_archGroupId in (SELECT id FROM CommServ_Merge..CCM_ArchGroup WHERE type = 4))
	BEGIN
IF NOT EXISTS (SELECT * FROM archGroup WHERE type = 4)
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFile -- SRM Analytics Storage Policy Not found in the destination database'
			GOTO CX_ERROR_EXIT
		END
UPDATE CCM_MAP_ArchFile SET new_archGroupId = (SELECT top 1 id FROM archGroup WHERE type = 4)
WHERE old_archGroupId in (SELECT id FROM CommServ_Merge..CCM_ArchGroup WHERE type = 4)
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFile -- UPDATE SRM Analytics archGroupId'
			GOTO CX_ERROR_EXIT
		END
	END
	UPDATE CCM_MAP_ArchFile SET new_archGroupId = b.new_id
	FROM CCM_MAP_ArchFile a, CCM_MAP_ArchGroup b
	WHERE a.old_archGroupId = b.old_id
	AND a.new_archGroupId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFile -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFile SET new_appId = b.new_id
	FROM CCM_MAP_ArchFile a, CCM_MAP_Application b
	WHERE a.old_appId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFile -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFile SET exist = 1
	FROM CCM_MAP_ArchFile a, ArchFile b
	WHERE a.id = b.id AND a.new_commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFile -- UPDATE 4'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CCM_ArchFile_Temp
	SELECT	b.id, b.name, a.new_commCellId, a.new_archGroupId,
			b.objName1, b.flags, a.new_appId, b.fileType, b.cTime,
			b.jobId, b.backupLevel,	b.isValid, b.cloudId, b.contentIndexTime, 0
FROM	CCM_MAP_ArchFile a, CommServ_Merge..CCM_ArchFile b
	WHERE	a.id = b.id AND a.old_commCellId = b.commCellId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_ArchFile_Temp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	--Pick Migrated jobs for CI if CI is enabled on destination
	IF EXISTS
	(
		SELECT 	1
		FROM 	archContentIndexingRules CI WITH(READUNCOMMITTED)
				INNER JOIN CCM_MAP_ArchGroup AG ON CI.archgroupid = AG.new_id
		WHERE 	CI.enabled = 1
	)
	BEGIN
		UPDATE 	AF
SET		flags = (AF.flags | 16)
		FROM 	CCM_ArchFile_Temp AF
				INNER JOIN CCM_MAP_ArchFile AFMAP ON AF.id = AFMAP.id AND AF.commCellId = AFMAP.new_commCellId
INNER JOIN CommServ_Merge..CCM_JMBkpStats JB ON AF.jobId = JB.jobId AND AFMAP.old_commCellId = JB.commCellId
				INNER JOIN archContentIndexingRules R WITH(READUNCOMMITTED) ON AF.archgroupid = R.archgroupid
				INNER JOIN APP_Application S WITH(READUNCOMMITTED) ON AF.appId = S.id
				INNER JOIN APP_ClientProp CP WITH(READUNCOMMITTED) ON CP.componentnameId = S.clientId
		WHERE 	AF.commcellId > 2  --only for migrated jobs
AND (AF.flags & 496) = 0
				AND AF.isValid = 1
AND AF.filetype = 1
				AND JB.totaluncompBytes > 0
				AND R.enabled = 1			--Check if CI is enabled at SP level
				AND CP.attrName = N'Content Indexing Enabled' AND CP.attrVal = N'1' AND CP.modified = 0   --Check if CI is enabled at client level
				AND S.appTypeId IN
				(
					-- From OffliineCI-SupportedApptypes.doc
					-- 1.1	File System apptypes
1,
11,
13,
17,
18,
19,
20,
21,
29,
33,
34,
36,
38,
42,
43,
63,
64,
74,
73,
86,
106,
128,
124,
					-- 1.2	File System Archiver apptypes
58,
66,
					-- 1.3	Exchange application apptypes
8,
14,
35,
44,
45,
54,
55,
56,
57,
67,
68,
82,
					-- 1.4	Share point application apptypes
46,
78,
89,
					-- 1.5	Lotus notes application apptypes
52,
90,
					--gmail / gdrive
134
				)
				AND S.subclientName <> 'IndexBackup'  -- Filter out IndexBackup Subclients
AND (S.subclientStatus & 0x20000) = 0  -- Filter out Edge Subclients
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- Pick jobs for CI'
			GOTO CX_ERROR_EXIT
		END
	END
	SET IDENTITY_INSERT ArchFile ON
	INSERT	INTO ArchFile (
			id, name, commCellId, archGroupId,
			objName1, flags, appId, fileType, cTime,
			jobId, backupLevel,	isValid, cloudId, contentIndexTime, nPushedItems)
	SELECT	id, name, commCellId,archGroupId,
			objName1, flags, appId, fileType, cTime,
			jobId, backupLevel,	isValid, cloudId, contentIndexTime, 0
	FROM	CCM_ArchFile_Temp
/*
	INSERT	INTO ArchFile (
			id, name, commCellId, archGroupId,
			objName1, flags, appId, fileType, cTime,
			jobId, backupLevel,	isValid, cloudId, contentIndexTime, nPushedItems)
	SELECT	b.id, b.name, a.new_commCellId, a.new_archGroupId,
			b.objName1, b.flags, a.new_appId, b.fileType, b.cTime,
			b.jobId, b.backupLevel,	b.isValid, b.cloudId, b.contentIndexTime, 0
	FROM	CCM_MAP_ArchFile a, Commserv_Merge..CCM_ArchFile b
	WHERE	a.id = b.id AND a.old_commCellId = b.commCellId
	AND		a.exist <> 1
*/
	IF	@@ERROR > 0
	BEGIN
		SET IDENTITY_INSERT ArchFile OFF
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFile -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	SET IDENTITY_INSERT ArchFile OFF
	UPDATE archFile
	SET name = C.name,
		objName1 = C.objName1,
		flags = C.flags,
		cTime = C.cTime,
		backupLevel = C.backupLevel,
		isValid = C.isValid,
	--	cloudId = C.cloudId,
		contentIndexTime = C.contentIndexTime,
		nPushedItems = C.nPushedItems
FROM archFile A, CCM_TapeImportEntities B, CommServ_Merge..CCM_ArchFile C, CCM_MAP_CommCell D
WHERE A.appId = B.new_id AND B.entityType = 7  AND A.id = C.id AND A.commCellId = D.new_id AND C.commCellId = D.old_id
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'CCM_Merge_ArchFile -- UPDATE archFile for TapeImpoted jobs'
		GOTO CX_ERROR_EXIT
	END
	---- Merge archIndexingAged Table
	INSERT INTO archIndexingAged
	SELECT	C.new_id, A.archFileId, B.new_id, D.new_id, A.pruneTime, A.backupSetGUID
FROM CommServ_Merge..CCM_archIndexingAged A INNER JOIN CCM_MAP_CommCell B ON A.commCellId = B.old_id
			INNER JOIN CCM_MAP_Client C ON A.currentIdxServer = C.old_id
			INNER JOIN CCM_MAP_Application D ON A.appId = D.old_id
			LEFT OUTER JOIN archIndexingAged E ON E.commCellId = B.new_id AND E.archFileId = A.archFileId
	WHERE	E.archFIleId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- archIndexingAged -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------
	-- Merge ArchFileOracle Table
	INSERT	INTO CCM_MAP_ArchFileOracle
	SELECT	archFileId, commCellId, 0, appId, 0, instanceId, 0, clientId, 0, 0
FROM CommServ_Merge..CCM_ArchFileOracle
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileOracle -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFileOracle SET new_commCellId = b.new_id
	FROM CCM_MAP_ArchFileOracle a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileOracle -- UPDATE CommCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFileOracle SET new_appId = b.new_id
	FROM CCM_MAP_ArchFileOracle a, CCM_MAP_Application b
	WHERE a.old_appId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileOracle -- UPDATE appId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFileOracle SET new_instanceId = b.new_id
	FROM CCM_MAP_ArchFileOracle a, CCM_MAP_InstanceName b
	WHERE a.old_instanceId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileOracle -- UPDATE instanceId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFileOracle SET new_clientId = b.new_id
	FROM CCM_MAP_ArchFileOracle a, CCM_MAP_Client b
	WHERE a.old_clientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileOracle -- UPDATE clientId'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(SELECT * FROM CCM_MAP_ArchFileOracle
			  WHERE (old_commCellId <> 0 AND new_commCellId = 0)
				OR (old_appId <> 0 AND new_appId = 0)
				OR (old_instanceId <> 0 AND new_instanceId = 0)
				OR (old_clientId <> 0 AND new_clientId = 0)
			)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileOracle -- Failed to Map new ids'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFileOracle SET exist = 1
	FROM CCM_MAP_ArchFileOracle a, ArchFileOracle b
	WHERE a.archFileid = b.archFileid AND a.new_commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileOracle -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO ArchFileOracle (
			archFileId, commCellId, appId, instanceId, clientId,
			archFileName, fileType, flags, jobId)
	SELECT	b.archFileId, a.new_commCellId, a.new_appId, a.new_instanceId, a.new_clientId,
			b.archFileName, b.fileType, b.flags, b.jobId
FROM	CCM_MAP_ArchFileOracle a, CommServ_Merge..CCM_ArchFileOracle b
	WHERE	a.archFileId = b.archFileId AND a.old_commCellId = b.commCellId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileOracle -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	---------------------------------------------------------
	---- Merge archFileOracleBackupPiece Table
	INSERT	INTO archFileOracleBackupPiece
	SELECT	a.archFileId, b.new_Id, c.new_Id, a.backupPiece, a.offset
FROM	CommServ_Merge..CCM_archFileOracleBackupPiece a, CCM_MAP_CommCell b, CCM_MAP_InstanceName c
	WHERE	a.commCellId = b.old_Id AND a.instanceId = c.old_Id
	AND		NOT EXISTS (SELECT 1 FROM archFileOracleBackupPiece P WHERE a.archFileid = P.archFileid AND b.new_Id = P.commCellId AND c.new_Id = P.instanceId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_archFileOracleBackupPiece -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge ArchEncKeys table
	INSERT	INTO CCM_MAP_archEncKeys
	SELECT	DISTINCT clientId, 0, archCopyId, 0, encKeyId, 0, encRSA, encKeyType, encKey, 0
FROM	CommServ_Merge..CCM_archEncKeys
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_archEncKeys -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_archEncKeys SET new_clientId = b.new_id
	FROM CCM_MAP_archEncKeys a, CCM_MAP_Client b
	WHERE a.old_clientId = b.old_id
	UPDATE CCM_MAP_archEncKeys SET new_archCopyId = b.new_id
	FROM CCM_MAP_archEncKeys a, CCM_MAP_ArchGroupCopy b
	WHERE a.old_archCopyId = b.old_id
	UPDATE	CCM_MAP_archEncKeys SET exist = 1, new_encKeyId = b.encKeyId
	FROM	CCM_MAP_archEncKeys a, ArchEncKeys b
	WHERE	a.new_clientId = b.clientId AND a.new_archCopyId = b.archCopyId
	AND		b.encRSA = a.encRSA AND b.encKeyType = a.encKeyType AND b.encKey = a.encKey
	INSERT	INTO ArchEncKeys (
			clientId, archCopyId,
			encRSA, encKeyType, encKey,
			isActive, createTime, expiredTime, origEncKeyId)
	SELECT	a.new_clientId, a.new_archCopyId,
			b.encRSA, b.encKeyType, b.encKey,
			0, b.createTime, b.expiredTime, 0
FROM	CCM_MAP_archEncKeys a, CommServ_Merge..CCM_archEncKeys b
	WHERE 	a.old_encKeyId = b.encKeyId
	AND		a.exist <> 1
	UPDATE	CCM_MAP_archEncKeys SET new_encKeyId = b.encKeyId
	FROM	CCM_MAP_archEncKeys a, ArchEncKeys b
	WHERE	a.new_clientId = b.clientId AND a.new_archCopyId = b.archCopyId
	AND		b.encRSA = a.encRSA AND b.encKeyType = a.encKeyType AND b.encKey = a.encKey
	AND		a.exist <> 1
	-- Merge ArchFileCopy Table
	INSERT	INTO CCM_MAP_ArchFileCopy
	SELECT	archfileid, commCellId, 0, archCopyId, 0, 0
FROM CommServ_Merge..CCM_ArchFileCopy
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileCopy -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFileCopy SET new_commCellId = b.new_id
	FROM CCM_MAP_ArchFileCopy a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileCopy -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFileCopy SET new_archCopyId = b.new_id
	FROM CCM_MAP_ArchFileCopy a, CCM_MAP_ArchGroupCopy b
	WHERE a.old_archCopyId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileCopy -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchFileCopy SET exist = 1
	FROM	CCM_MAP_ArchFileCopy a, ArchFileCopy b
	WHERE	a.archFileId = b.archFileId AND a.new_commCellId = b.commCellId
	AND		a.new_archCopyId = b.archCopyId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileCopy -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CCM_ArchFileCopy_Temp
	SELECT	b.archfileid, a.new_commCellId, a.new_archCopyId,
			b.flags, b.isValid, b.streamNum, b.lastChunkNumber,
			b.physicalSize, b.logicalSize, 0,
			b.encRSA, b.encKeyType, b.encKey, b.modifiedTime, b.mediaType, b.agedBy, isnull(c.new_encKeyId, 0), b.unCompSize
FROM	CCM_MAP_ArchFileCopy a, CommServ_Merge..CCM_ArchFileCopy b LEFT JOIN CCM_MAP_archEncKeys c ON b.encKeyId = c.old_encKeyId
	WHERE	a.archFileId = b.archFileId AND a.old_commCellId = b.commCellId
	AND		a.old_archCopyId = b.archCopyId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_ArchFileCopy_Temp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO ArchFileCopy (
			archFileId, commCellId, archCopyId,
			flags, isValid, streamNum, lastChunkNumber,
			physicalSize, logicalSize, drivePoolId,
			encRSA, encKeyType, encKey, modifiedTime, mediaType, agedBy, encKeyId, unCompSize)
	SELECT	archFileId, commCellId, archCopyId,
			flags, isValid, streamNum, lastChunkNumber,
			physicalSize, logicalSize, 0 /*drivePoolId*/,
			encRSA, encKeyType, encKey, modifiedTime, mediaType, agedBy, encKeyId, unCompSize
	FROM	CCM_ArchFileCopy_Temp
/*
	INSERT	INTO ArchFileCopy (
			archFileId, commCellId, archCopyId,
			flags, isValid, streamNum, lastChunkNumber,
			physicalSize, logicalSize, drivePoolId,
			encRSA, encKeyType, encKey, modifiedTime)
	SELECT	b.archfileid, a.new_commCellId, a.new_archCopyId,
			b.flags, b.isValid, b.streamNum, b.lastChunkNumber,
			b.physicalSize, b.logicalSize, 0,
			b.encRSA, b.encKeyType, b.encKey, b.modifiedTime
	FROM	CCM_MAP_ArchFileCopy a, Commserv_Merge..CCM_ArchFileCopy b
	WHERE	a.archFileId = b.archFileId AND a.old_commCellId = b.commCellId
	AND		a.old_archCopyId = b.archCopyId
	AND		a.exist <> 1
*/
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileCopy -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Update encryption keys.
	UPDATE A
	SET encKey = C.encKey,
		encKeyType = C.encKeyType,
		encRSA = C.encRSA,
		encKeyId = isnull(D.new_encKeyId, 0)
	FROM ArchFileCopy A
		INNER JOIN CCM_MAP_ArchFileCopy B ON A.archFileId = B.archFileId
			AND A.commCellId = B.new_commCellId AND A.archCopyId = B.new_archCopyId
INNER JOIN CommServ_Merge..CCM_ArchFileCopy C ON C.archFIleId = B.archFIleId
			AND C.commCellId = B.old_CommCellId AND C.archCopyId = B.old_archCopyId
		LEFT JOIN CCM_MAP_archEncKeys D ON D.old_encKeyId = C.encKeyId
	WHERE B.exist = 1 AND C.encKeyType > 0 AND A.encKeyType = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- ArchFileCopy -- UPDATE encryption keys'
		GOTO CX_ERROR_EXIT
	END
	UPDATE archFileCopy
	SET flags = D.flags,
		isValid = D.isValid,
		streamNum = D.streamNum,
		lastChunkNumber = D.lastChunkNumber,
		physicalSize = D.physicalSize,
		logicalSize = D.logicalSize,
	--	drivePoolId = D.drivePoolId, need to ask prasad.
		encRSA = D.encRSA,
		encKeyType = D.encKeyType,
		encKey = D.encKey,
		modifiedTime = D.modifiedTime,
		mediaType = D.mediaType,
		agedBy = D.agedBy,
		encKeyId = isnull(F.new_encKeyId, 0),
		unCompSize = D.unCompSize
FROM archFileCopy A, archFile B, CCM_TapeImportEntities C,CommServ_Merge..CCM_ArchFileCopy D LEFT JOIN CCM_MAP_archEncKeys F ON D.encKeyId = F.old_encKeyId, CCM_MAP_CommCell E
WHERE A.archFileId = B.id AND A.CommCellId = B.CommCellId AND B.appId = C.new_id AND C.entityType = 7
              AND A.archFileId = D.archFileId AND A.commCellId = E.new_id AND E.old_id = D.commCellId
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'CCM_Merge_Main -- UPDATE archFileCopy for TapeImpoted jobs'
		GOTO CX_ERROR_EXIT
	END
	IF @isTapeImport = 1
	BEGIN
		/*
		-- populate CCM_TI_AllArchiveFiles table with AFile info from CommServ Database
		INSERT INTO CCM_TI_AllArchiveFilesAndChunks
SELECT  d.jobid, d.id, b.old_id, d.fileTYpe, a.archChunkId, e.old_id, a.chunkNumber, CASE WHEN f.flags & 16384 > 0 THEN 0 ELSE 1 END
		FROM 	archChunkMapping a
				INNER JOIN archFile d ON a.archFileId = d.id AND a.commcellId = d.commcellId
				INNER JOIN archFileCopy f ON a.archFileId = f.archFIleId AND a.commcellId = f.commcellId and a.archCopyId = f.archCopyId
				INNER JOIN CCM_MAP_ArchGroupCopy b ON a.archCopyId = b.new_id
				INNER JOIN CCM_MAP_Commcell e ON a.commcellId = e.new_id
INNER JOIN CommServ_Merge..CCM_JMJobDataStats JS ON  d.jobId = JS.jobId AND e.old_id = JS.commcellId AND b.old_id = JS.archGrpCopyId AND d.fileType = JS.dataType
				LEFT OUTER JOIN CCM_TI_AllArchiveFilesAndChunks c ON a.archFileId = c.archFileId AND e.old_id = c.commcellId AND a.archChunkId = c.chunkId AND  b.old_id = c.copyId
		WHERE	c.archFileId IS NULL
		INSERT 	INTO CCM_TI_AllArchiveFiles
		SELECT 	jobId, archfileId, copyId, fileType, commcellid, max(isArchFileClose),1 -- CASE WHEN max(chunkSeqNo) = count(*) THEN 1 ELSE 0 END
		FROM 	CCM_TI_AllArchiveFilesAndChunks
		GROUP BY jobId, archfileId, copyId, fileType, commcellid
		-- First check if all the ArchiveFiles are cataloged completely or missing some medias for that archive file to catalog
		UPDATE archFileCopy
SET flags= (CASE B.isArchFileClose WHEN 0 THEN (flags | 16384) ELSE (flags & ~16384) END)
		FROM archFileCopy A, CCM_TI_AllArchiveFiles B, CCM_Map_CommCell C, CCM_MAP_ArchGroupCopy D
		WHERE A.archFileId=B.archFileId AND A.commCellId = C.new_id  AND C.old_id = B.CommCellId AND
			  A.archCopyId = D.new_id AND B.copyId = D.old_id
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- ArchFile UPDATE when TapeImport job is Run'
			GOTO CX_ERROR_EXIT
		END
		*/
		-- mark archFiles which are coming in tapeimport as aged and this job should be on non-tapimport copy.
		UPDATE ArchFileCopy
SET flags = (A.flags | 256), agedBy = (A.agedBy | 67108864)							 -- Mark Imported Chunks as aged
		FROM  archFileCopy A, CCM_MAP_ArchFileCopy B, archGroupCopy C
		WHERE A.archFileId = B.archFileId AND A.commCellId = B.new_commCellId AND A.archCopyId = B.new_archCopyId
			AND B.new_archCopyId = c.id
AND C.type <> 8
			AND B.exist = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_ArchFileCopy -- UPDATE Aged'
			GOTO CX_ERROR_EXIT
		END
	END
	---------------------------------------------------------
	-- Merge ArchFileCopyDedup Table
	INSERT INTO CCM_MAP_ArchFileCopyDedup
	SELECT	archFileId, commCellId, 0, archCopyId, 0, SIDBStoreId, 0, 0
FROM CommServ_Merge..CCM_ArchFileCopyDedup
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileCopyDedup -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFileCopyDedup SET new_commCellId = b.new_id
	FROM CCM_MAP_ArchFileCopyDedup a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileCopyDedup -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFileCopyDedup SET new_archCopyId = b.new_id
	FROM CCM_MAP_ArchFileCopyDedup a, CCM_MAP_ArchGroupCopy b
	WHERE a.old_archCopyId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileCopyDedup -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFileCopyDedup SET new_SIDBStoreId = b.new_SIDBStoreId
	FROM CCM_MAP_ArchFileCopyDedup a, CCM_Map_IdxSIDBStore b
	WHERE a.old_SIDBStoreId = b.old_SIDBStoreId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileCopyDedup -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(SELECT * FROM CCM_MAP_ArchFileCopyDedup
	WHERE (old_CommCellId <> 0 AND new_CommCellId = 0) OR (old_archCopyId <> 0 AND new_archCopyId = 0) OR (old_SIDBStoreId <> 0 AND new_SIDBStoreId = 0))
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileCopyDedup -- New CommcellId or New archCopyId or New SIDBStoreId not found'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchFileCopyDedup SET exist = 1
	FROM	CCM_MAP_ArchFileCopyDedup a, ArchFileCopyDedup b
	WHERE	a.archFileId = b.archFileId AND a.new_commCellId = b.commCellId
	AND		a.new_archCopyId = b.archCopyId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileCopyDedup -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO ArchFileCopyDedup
	SELECT a.archFileId, a.new_commCellId, a.new_archCopyId, a.new_SIDBStoreId, b.primaryObjects, b.secondaryObjects, b.primaryObjSize,
		   b.secondaryObjSize, b.primaryMetaDataSize, b.secondaryMetaDataSize, b.transDataSize, b.savedDataSize
FROM CCM_MAP_ArchFileCopyDedup a inner join CommServ_Merge..CCM_ArchFileCopyDedup b
	ON a.archFileId = b.archFileId AND a.old_commCellId = b.commCellId AND a.old_archCopyId = b.archCopyId
	WHERE a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- ArchFileCopyDedup -- Insert'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	--Merge ArchFileSIDBKeys
IF EXISTS(SELECT * FROM CommServ_Merge..CCM_ArchFileSIDBKeys)
	BEGIN
		INSERT INTO CCM_MAP_archFileSIDBKeys
		SELECT distinct a.archFileId, a.CommCellId, 0, a.archCopyId, 0, a.SIDBStoreId, 0, a.encKeyId, 0, 0
FROM CommServ_Merge..CCM_ArchFileSIDBKeys a
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_archFileSIDBKeys -- INSERT FAILED'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_archFileSIDBKeys SET new_CommCellId = b.new_id
		FROM CCM_MAP_archFileSIDBKeys a, CCM_Map_CommCell b
		WHERE a.old_CommCellId = b.old_id
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_archFileSIDBKeys -- UPDATE new_CommcellId FAILED'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_archFileSIDBKeys SET new_archCopyId = b.new_id
		FROM CCM_MAP_archFileSIDBKeys a, CCM_Map_ArchGroupCopy b
		WHERE a.old_archCopyId = b.old_id
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_archFileSIDBKeys -- UPDATE new_archCopyId FAILED - 1'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_archFileSIDBKeys SET new_archCopyId = b.newEntityId
		FROM CCM_MAP_archFileSIDBKeys a INNER JOIN CCMMergeEntityMap b
ON a.old_archCopyId = b.oldEntityId AND b.EntityType = 18
			AND b.importJobId = @l_curImportJobId AND a.new_archCopyId = 0
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_archFileSIDBKeys -- UPDATE new_archCopyId FAILED - 2'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_archFileSIDBKeys SET new_SIDBStoreId = b.new_SIDBStoreId
		FROM CCM_MAP_archFileSIDBKeys a, CCM_Map_IdxSIDBStore b
		WHERE a.old_SIDBStoreId = b.old_SIDBStoreId
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_archFileSIDBKeys -- UPDATE new_SIDBStoreId FAILED - 1'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_archFileSIDBKeys SET new_SIDBStoreId = b.newEntityId
		FROM CCM_MAP_archFileSIDBKeys a INNER JOIN CCMMergeEntityMap b
ON a.old_SIDBStoreId = b.oldEntityId AND b.EntityType = 41
			AND b.importJobId = @l_curImportJobId AND a.new_SIDBStoreId = 0
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_archFileSIDBKeys -- UPDATE new_SIDBStoreId FAILED - 2'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_archFileSIDBKeys SET new_encKeyId = b.new_encKeyId
		FROM CCM_MAP_archFileSIDBKeys a INNER JOIN CCM_MAP_archEncKeys b
			ON a.old_encKeyId = b.old_encKeyId
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_archFileSIDBKeys -- UPDATE new_encKeyId FAILED - 1'
			GOTO CX_ERROR_EXIT
		END
		-- New copyId may be 0 when copy is deleted on source CS.
		IF EXISTS(SELECT * FROM CCM_MAP_archFileSIDBKeys
		WHERE (old_CommCellId <> 0 AND new_CommCellId = 0) /*OR (old_archCopyId <> 0 AND new_archCopyId = 0)*/ OR (old_SIDBStoreId <> 0 AND new_SIDBStoreId = 0))
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_archFileSIDBKeys -- New CommcellId or New archCopyId or New SIDBStoreId not found'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_archFileSIDBKeys SET exist = 1
		FROM CCM_MAP_archFileSIDBKeys a, archFileSIDBKeys b
		WHERE a.archFileId = b.archFileId AND a.new_CommCellId = b.CommCellId AND a.new_archCopyId = b.archCopyId AND a.new_SIDBStoreId = b.SIDBStoreId
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_archFileSIDBKeys -- UPDATE exist FAILED'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO archFileSIDBKeys
		SELECT distinct a.archFileId, a.new_CommCellId, a.new_archCopyId, b.encKeyType, b.encKey, a.new_SIDBStoreId, b.encRSA, a.new_encKeyId
FROM CCM_MAP_archFileSIDBKeys a, CommServ_Merge..CCM_ArchFileSIDBKeys b
		WHERE a.archFileId = b.archFileId AND a.old_CommCellId = b.CommCellId AND a.old_archCopyId = b.archCopyId AND a.old_SIDBStoreId = b.SIDBStoreId
		AND a.exist = 0
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- archFileSIDBKeys -- INSERT FAILED'
			GOTO CX_ERROR_EXIT
		END
	END
	---------------------------------------------------------
	--Fix: -Update the columns always during robo migration but retaining the old behavior with regular CCM for now.
	--Flag bit 1 set in @ccmParamFlags if robo job
	declare @skipUpdate integer = 0
	SET @skipUpdate = ISNULL((SELECT value from MMConfigs where name = 'CCM_CONFIG_SKIP_UPDATE_JOB_DATA_STATUS'),0)
	IF ((@ccmParamFlags & 1) > 0	AND @skipUpdate = 0)
	BEGIN
		UPDATE ArchFileCopy SET flags = c.flags, isValid = c.isValid, streamNum = c.streamNum, lastChunkNumber = c.lastChunkNumber,
		physicalSize = c.physicalSize, logicalSize = c.logicalSize, modifiedTime = c.modifiedTime, agedBy = c.agedBy, unCompSize = c.unCompSize
FROM CCM_MAP_ArchFileCopy a, ArchFileCopy b, CommServ_Merge..CCM_ArchFileCopy c
		WHERE	a.archFileId = b.archFileId AND a.new_commCellId = b.commCellId
		AND	a.new_archCopyId = b.archCopyId AND a.archFileId = c.archFileId AND a.old_commCellId = c.commCellId AND a.old_archCopyId = c.archCopyId
		AND a.exist = 1
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- ArchFileCopy -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
	END
	---------------------------------------------------------
	-- Merge ArchDB2Log Table
	INSERT	INTO CCM_MAP_ArchDB2Log
	SELECT	archFileId, commCellId, 0, 0
FROM CommServ_Merge..CCM_ArchDB2Log
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchDB2Log -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchDB2Log SET new_commCellId = b.new_id
	FROM CCM_MAP_ArchDB2Log a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchDB2Log -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchDB2Log SET exist = 1
	FROM	CCM_MAP_ArchDB2Log a, ArchDB2Log b
	WHERE	a.archFileId = b.archFileId AND a.new_commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchDB2Log -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO ArchDB2Log (
			archFileId, firstLogTime, lastLogTime,
			firstLogNumber, lastLogNumber, commCellId)
	SELECT	b.archFileId, b.firstLogTime, b.lastLogTime,
			b.firstLogNumber, b.lastLogNumber, a.new_commCellId
FROM	CCM_MAP_ArchDB2Log a, CommServ_Merge..CCM_ArchDB2Log b
	WHERE	a.archFileId = b.archFileId AND a.old_commCellId = b.commCellId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchDB2Log -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------------------------------
	-- Merge ArchChunk Table
	INSERT	INTO CCM_MAP_ArchChunk
	SELECT	id, commCellId, 0, volumeId, 0, 0
FROM CommServ_Merge..CCM_ArchChunk
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunk -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchChunk SET new_commCellId = b.new_id
	FROM CCM_MAP_ArchChunk a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunk -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchChunk SET new_volumeId = b.new_Id
	FROM CCM_MAP_ArchChunk a, CCM_MAP_MMVolume b
	WHERE a.old_volumeId = b.old_Id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunk -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchChunk SET exist = 1
	FROM CCM_MAP_ArchChunk a, ArchChunk b
	WHERE a.id = b.id AND a.new_commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunk -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	-- 08/29/2006 cliu
	-- For every chunks inserted, we need to mark the corresponding media as in mediagroup.
	IF @isTapeImport = 1
	BEGIN
		UPDATE	MMMedia
		SET		IsAged = 0,	IsInMediaGroup = 1
		FROM	(SELECT DISTINCT new_volumeId as volumeId
				 FROM CCM_MAP_ArchChunk WHERE exist <> 1) c
				INNER JOIN
				MMVolume v
				ON c.volumeId = v.volumeId AND v.recordingFormatId <> 10001
		WHERE	v.mediaId = MMMedia.mediaId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunk -- UPDATE MMMedia for Attributes'
			GOTO CX_ERROR_EXIT
		END
	END
	INSERT INTO CCM_ArchChunk_Temp
	SELECT	b.id, a.new_commCellId, a.new_volumeId, b.fileMarkerNo, b.createTime,
			b.version, b.cclip, b.physicalSize,
			b.logicalSize, b.writeTime, b.flags, b.modifiedTime, b.hwEncKey, b.agedBy
FROM	CCM_MAP_ArchChunk a, CommServ_Merge..CCM_ArchChunk b
	WHERE	a.id = b.id AND a.old_commCellId = b.commCellId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_ArchChunk_Temp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO ArchChunk (
			id, commCellId, volumeId, fileMarkerNo, createTime,
			version, cclip, physicalSize, logicalSize, writeTime, flags, modifiedTime, hwEncKey, agedBy, origCCId)
	SELECT	id, commCellId, volumeId, fileMarkerNo, createTime,
			version, cclip, physicalSize, logicalSize, writeTime, flags, modifiedTime, hwEncKey, agedBy, commCellId
	FROM	CCM_ArchChunk_Temp
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- ArchChunk -- INSERT'
		GOTO CX_ERROR_EXIT
	END
-- todo - above - remap the OrigCCId.
	--Fix: -Update the columns always during robo migration but retaining the old behavior with regular CCM for now.
	--Flag bit 1 set in @ccmParamFlags if robo job
	IF ((@ccmParamFlags & 1) > 0	AND @skipUpdate = 0)
	BEGIN
		UPDATE ArchChunk SET physicalSize = c.physicalSize, logicalSize = c.logicalSize, writeTime = c.writeTime, flags = c.flags,
		modifiedTime = c.modifiedTime, agedBy = c.agedBy
FROM CCM_MAP_ArchChunk a, ArchChunk b, CommServ_Merge..CCM_ArchChunk c
		WHERE a.id = b.id AND a.new_commCellId = b.commCellId AND a.id = c.id AND a.old_commCellId  = c.commCellId
		AND a.exist = 1
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- ArchChunk -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
	END
/*
	INSERT	INTO ArchChunk (
			id, commCellId, volumeId, fileMarkerNo, createTime,
			version, cclip, physicalSize, logicalSize, writeTime, flags, modifiedTime, hwEncKey)
	SELECT	b.id, a.new_commCellId, a.new_volumeId, b.fileMarkerNo, b.createTime,
			b.version, b.cclip, b.physicalSize,
			b.logicalSize, b.writeTime, b.flags, b.modifiedTime, b.hwEncKey
	FROM	CCM_MAP_ArchChunk a, Commserv_Merge..CCM_ArchChunk b
	WHERE	a.id = b.id AND a.old_commCellId = b.commCellId
	AND		a.exist <> 1
*/
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunk -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE archChunk
	SET fileMarkerNo = E.fileMarkerNo,
		createTime = E.createTime,
		version = E.version,
		cclip = E.cclip,
		physicalSize = E.physicalSize,
		logicalSize = E.logicalSize,
		writeTime = E.writeTime,
		flags = E.flags,
		modifiedTime = E.modifiedTime,
		hwEncKey = E.hwEncKey,
		agedBy = E.agedBy
FROM archChunk A, archFile B, archChunkMapping C, CCM_TapeImportEntities D, CommServ_Merge..CCM_ArchChunk E, CCM_MAP_CommCell F
	WHERE A.id = C.archChunkId AND A.commCellId = C.chunkCommCellId AND B.id = C.archFileId AND B.commCellId = C.commCellId
AND B.appId = D.new_id AND D.entityType = 7
              AND A.id = E.id AND A.commCellId = F.new_id AND E.commCellId = F.old_id
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'CCM_Merge_Main -- UPDATE archChunk for TapeImpoted jobs'
		GOTO CX_ERROR_EXIT
	END
	IF @isTapeImport = 1
	BEGIN
		-- mark all tapeimport created chunks as aged, and chunks should not belong to tape import created copy.
		UPDATE ArchChunk
SET flags = (B.flags | 256), agedBy = (B.agedBy | 67108864) -- Mark Imported Chunks as aged
		FROM archChunk B, archChunkMapping C, CCM_MAP_ArchChunk D, archGroupCopy E
		WHERE B.id = c.archChunkId AND B.commCellId = C.chunkCommCellId
                AND D.id = C.archChunkId AND D.new_CommCellId = C.chunkCommCellId
		AND C.archCopyId = E.id
AND E.type<>8
		AND D.exist = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_ArchChunk -- UPDATE Aged'
			GOTO CX_ERROR_EXIT
		END
	END
	---------------------------------------------------------
	-- Merge ArchChunkMapping Table
	INSERT	INTO CCM_MAP_ArchChunkMapping
	SELECT	archChunkId, archFileId, commCellId, 0, chunkCommcellId, 0, archCopyId, 0, 0
FROM CommServ_Merge..CCM_ArchChunkMapping
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunkMapping -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchChunkMapping SET new_commCellId = b.new_id
	FROM CCM_MAP_ArchChunkMapping a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunkMapping -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchChunkMapping SET new_chunkCommCellId = b.new_id
	FROM CCM_MAP_ArchChunkMapping a, CCM_MAP_CommCell b
	WHERE a.old_chunkCommCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunkMapping -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchChunkMapping SET new_copyId = b.new_id
	FROM CCM_MAP_ArchChunkMapping a, CCM_MAP_ArchGroupCopy b
	WHERE a.old_copyId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunkMapping -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchChunkMapping SET exist = 1
	FROM	CCM_MAP_ArchChunkMapping a, ArchChunkMapping b
	WHERE	a.archChunkId = b.archChunkId AND a.new_commCellId = b.commCellId AND a.new_ChunkCommcellId = b.chunkCommcellId
	AND a.archFileId = b.archFileId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunkMapping -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CCM_ArchChunkMapping_Temp
	SELECT	b.archChunkId, b.archFileId, a.new_commCellId, a.new_ChunkCommCellId, a.new_copyId,
			b.chunkNumber, b.physicalOffset, b.logicalOffset, b.physicalSize,
			b.logicalSize, b.flags, b.modifiedTime, b.dedupedSize,
			b.agedBy, b.jobId, unCompSize
FROM	CCM_MAP_ArchChunkMapping a, CommServ_Merge..CCM_ArchChunkMapping b
	WHERE	a.archFileId = b.archFileId AND a.old_commCellId = b.commCellId
	AND		a.old_copyId = b.archCopyId AND a.archChunkId = b.archChunkId AND a.old_ChunkCommcellId = b.chunkCommcellId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_ArchChunkMapping_Temp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	/*
	 *	If job is recopied, then we create different set of chunks, but if we perform CCM from DR taken before recopy,
	 *	we merge those chunks also. So we need to skip merge of complete list of chunks coming from DR. We may have more chunks created after recopy or vice versa.
	 *  So the check should be, if at least one such chunk exists then skip merge of complete job, not just archive file or chunk.
	 */
	IF OBJECT_ID('tempdb..#reCopiedChunkList') IS NOT NULL
		DROP TABLE #reCopiedChunkList
	CREATE TABLE #reCopiedChunkList
	(
		jobId 			INT,
		aFileId 		INT,
		archChunkId 	INT,
		archCopyId 		INT,
		commCellId 		INT,
		chunkCommCellId INT
	)
	INSERT INTO #reCopiedChunkList
	SELECT tACM.jobId, tACM.archFIleId, tACM.archChunkId, tACM.archCopyId, tACM.commCellId, tACM.chunkCommCellId
	FROM CCM_ArchChunkMapping_Temp tACM
	WHERE EXISTS ( SELECT 1
					FROM archChunkMapping ACM INNER JOIN CCM_ArchChunkMapping_Temp CCM
					ON ACM.jobId = CCM.jobId AND ACM.archFileId = CCM.archFileId AND ACM.archCopyId = CCM.archCopyId AND ACM.chunkNumber = CCM.chunkNumber
						AND ACM.commCellid = CCM.commCellid AND ACM.archChunkId <> CCM.archChunkId
					WHERE ACM.jobId = tACM.jobId AND ACM.archFileId = tACM.archFileId  AND ACM.archCopyId = tACM.archCopyId AND ACM.commCellId = tACM.commCellId )
		AND @isTapeImport = 0
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- reCopiedChunkList -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO ArchChunkMapping (
			archChunkId, archFileId, commCellId, archCopyId,
			chunkNumber, physicalOffset, logicalOffset, physicalSize,
			logicalSize, flags, modifiedTime, dedupedSize, agedBy, chunkCommCellId, jobId, unCompSize)
	SELECT	archChunkId, archFileId, commCellId, archCopyId,
			chunkNumber, physicalOffset, logicalOffset, physicalSize,
			logicalSize, flags, modifiedTime, dedupedSize, agedBy, chunkCommCellId, jobId, unCompSize
	FROM	CCM_ArchChunkMapping_Temp Temp
	WHERE	NOT EXISTS( SELECT 1
						FROM #reCopiedChunkList tACM
						WHERE tACM.jobId = Temp.jobId AND tACM.archCopyId = Temp.archCopyid AND tACM.commCellid = Temp.commCellid
					)
	-- Delete already recopied chunks.
	DELETE ArchChunk
	FROM ArchChunk AC INNER JOIN CCM_ArchChunk_Temp tAC ON AC.id = tAC.id AND AC.commCellId = tAC.commCellId
		INNER JOIN #reCopiedChunkList tCH ON tAC.id = tCH.archChunkId AND tAC.commCellid = tCH.chunkCommCellId
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- ArchChunk -- Delete already recopied chunks.'
		GOTO CX_ERROR_EXIT
	END
	--Fix: -Update the columns always during robo migration but retaining the old behavior with regular CCM for now.
	--Flag bit 1 set in @ccmParamFlags if robo job
	IF ((@ccmParamFlags & 1) > 0	AND @skipUpdate = 0)
	BEGIN
		UPDATE ArchChunkMapping SET physicalOffSet = c.physicalOffSet, logicalOffSet = c.logicalOffSet,
		physicalSize = c.physicalSize, logicalSize = c.logicalSize, flags = c.flags, modifiedTime = c.modifiedTime,
		dedupedSize = c.dedupedSize, agedBy = c.agedBy, unCompSize = C.unCompSize
FROM CCM_MAP_ArchChunkMapping a, ArchChunkMapping b, CommServ_Merge..CCM_ArchChunkMapping c
		WHERE	a.archChunkId = b.archChunkId AND a.new_commCellId = b.commCellId AND a.new_ChunkCommcellId = b.chunkCommcellId
		AND	a.new_copyId = b.archCopyId AND a.archFileId = b.archFileId AND a.archChunkId = c.archChunkId AND a.old_commCellId = c.commCellId
		AND   a.old_ChunkCommcellId = c.chunkCommcellId AND a.old_copyId = c.archCopyId AND a.archFileId = c.archFileId
		AND		a.exist = 1
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- ArchChunkMapping -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
	END
/*
	INSERT	INTO ArchChunkMapping (
			archChunkId, archFileId, commCellId, archCopyId,
			chunkNumber, physicalOffset, logicalOffset, physicalSize,
			logicalSize, flags, modifiedTime)
	SELECT	b.archChunkId, b.archFileId, a.new_commCellId, a.new_copyId,
			b.chunkNumber, b.physicalOffset, b.logicalOffset, b.physicalSize,
			b.logicalSize, b.flags, b.modifiedTime
	FROM	CCM_MAP_ArchChunkMapping a, Commserv_Merge..CCM_ArchChunkMapping b
	WHERE	a.archFileId = b.archFileId AND a.old_commCellId = b.commCellId
	AND		a.old_copyId = b.archCopyId AND a.archChunkId = b.archChunkId
	AND		a.exist <> 1
*/
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunkMapping -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE archChunkMapping
	SET     chunkNumber = D.chunkNumber,
		physicalOffset = D.physicalOffset,
		logicalOffset = D.logicalOffset,
		physicalSize = D.physicalSize,
		logicalSize = D.logicalSize,
		flags = D.flags,
		modifiedTime = D.modifiedTime,
		agedBy = D.agedBy,
		unCompSize = D.unCompSize
FROM archChunkMapping A, archFile B, CCM_TapeImportEntities C, CommServ_Merge..CCM_ArchChunkMapping D, CCM_MAP_CommCell E
	WHERE A.archFileId = B.id AND A.commCellId = B.CommCellId AND A.archFileId = D.archFileId AND A.archChunkId = D.archChunkId AND A.commCellId = E.new_id
AND D.commCellId = E.old_id AND B.appId = C.new_id AND C.entityType = 7
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'CCM_Merge_Main -- UPDATE archChunkMapping for TapeImpoted jobs'
		GOTO CX_ERROR_EXIT
	END
	IF @isTapeImport = 1
	BEGIN
		-- mark all tape import archfiles as aged and this archfiles should be on non tapeimport created copy.
		UPDATE ArchChunkMapping
SET flags = (B.flags | 256), agedBy = (B.agedBy | 67108864) -- Mark Imported Chunks as aged
		FROM archChunkMapping B, CCM_MAP_ArchChunkMapping C, archGroupCopy D
		WHERE B.archChunkId=C.archChunkId
				AND B.chunkCommCellId = C.new_ChunkCommCellId
				AND B.archFileId=C.archFileId
				AND B.commCellId=C.new_commCellId
				AND B.archCopyId = D.id
AND D.type<>8
				AND C.exist = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_ArchChunkMapping -- UPDATE Aged'
			GOTO CX_ERROR_EXIT
		END
		DECLARE @afileId INT
		DECLARE @physicalOffset BIGINT
		DECLARE @physicalSize BIGINT
		DECLARE @chunkId BIGINT
		DECLARE @chunkSeqNo INT
		DECLARE @archCopyId INT
		DECLARE @NextOffset BIGINT
		DECLARE @SeqNo INT
		DECLARE @commCellId INT
		DECLARE @PrevAfileId INT
		DECLARE @StartFound BIT
		DECLARE @PrevCopyId INT
		SET @NextOffset = 0
		IF OBJECT_ID('TEMPDB..#TempAFTable') IS NOT NULL
				DROP TABLE #TempAFTable
		CREATE TABLE #TempAFTable(
		aFileId INT,
		archChunkId BIGINT,
		archCopyId SMALLINT,
		commCellId INT,
		seqNo INT
		)
		DECLARE chunkMapCur CURSOR FOR
		SELECT DISTINCT A.archFileId,A.archCopyId,A.archChunkId,A.chunkNumber,A.physicalSize,A.physicalOffset,A.commCellId FROM archChunkMapping A INNER JOIN CCM_MAP_archChunkMapping B ON A.archFileId = B.archFileId AND A.commCellId = B.new_commCellId AND A.archCopyId = B.new_copyId  ORDER BY A.archFileid,A.archCopyId,A.physicalOffset ASC
		OPEN chunkMapCur
		FETCH NEXT FROM  chunkMapCur INTO @afileId,@archCopyId,@chunkId,@chunkSeqNo,@physicalSize,@physicalOffset,@commCellId
		SET @PrevAfileId = @afileId
		SET @PrevCopyId = @archCopyId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @SeqNo = CASE WHEN @NextOffset = 0 THEN 1
								 WHEN (@NextOffset = @physicalOffset AND @StartFound = 1) THEN @SeqNo + 1
								 ELSE -1
							END
			IF @SeqNo = 1
			SET @StartFound = 1
			IF (@PrevAfileId <> @afileId OR @PrevCopyId <> @archCopyId)
			BEGIN
				SET @StartFound = 0
				SET @SeqNo = 0
				SET @NextOffset = @physicalOffset
				SET @PrevAfileId = @afileId
				SET @PrevCopyId = @archCopyId
				CONTINUE
			END
			IF @chunkSeqNo<>@SeqNo AND @SeqNo <> -1 AND @StartFound = 1
			INSERT INTO #TempAFTable
			SELECT @afileId,@chunkId,@archCopyId,@commCellId,@SeqNo
			SET @PrevAfileId = @afileId
			SET @PrevCopyId = @archCopyId
			SET @NextOffset = @physicalOffset+@physicalSize
			FETCH NEXT FROM  chunkMapCur INTO @afileId,@archCopyId,@chunkId,@chunkSeqNo,@physicalSize,@physicalOffset,@commCellId
		END
		CLOSE chunkMapCur
		DEALLOCATE chunkMapCur
		UPDATE ACM
		SET chunkNumber = TAF.seqNo
		FROM archChunkMapping ACM INNER JOIN #TempAFTable TAF ON ACM.archFileId = TAF.aFileId AND ACM.archChunkId = TAF.archChunkId AND ACM.archCopyId = TAF.archCopyId AND ACM.commCellId = TAF.commCellId
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'CCM_Merge_Main -- Tape import chunk seqNo update'
			GOTO CX_ERROR_EXIT
		END
		DROP TABLE #TempAFTable
		UPDATE archFileCopy
		SET physicalSize = RES.totPhysicalSize, logicalSize = RES.totLogicalSize, lastChunkNumber = RES.maxChunkNumber, unCompSize = RES.unCompSize
		FROM archFileCopy AFC ,
			(	SELECT ACM.archFileId, ACM.archCopyId, ACM.commCellId, SUM(ACM.physicalSize) AS totPhysicalSize, SUM(ACM.logicalSize) as totLogicalSize, MAX(ACM.chunkNumber) as maxChunkNumber,
						(CASE WHEN MIN(ACM.unCompSize) = -1 THEN -1 ELSE SUM(ACM.unCompSize) END) AS unCompSize
				FROM archChunkMapping ACM WITH (NOLOCK)
					INNER JOIN CCM_MAP_ArchFileCopy tAFC ON ACM.archFileId = tAFC.archFileId AND ACM.archCopyId = tAFC.new_archCopyId AND ACM.commCellId = tAFC.new_commCellId
				GROUP BY ACM.archFileId, ACM.archCopyId, ACM.commCellId
			) AS RES
	   WHERE AFC.archFileId = RES.archFileId AND AFC.archCopyId = RES.archCopyId AND AFC.commCellId = RES.commCellId
			AND ( RES.totPhysicalSize <> AFC.physicalSize OR RES.totLogicalSize <> AFC.logicalSize OR AFC.lastChunkNumber <> RES.maxChunkNumber )
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- archFileCopy -- Update physicalSize, logicalSize, lastChunkNumber for tape import'
			GOTO CX_ERROR_EXIT
		END
		-- Set correct stream number when some chunks already exists and remaining coming via tape import.
		IF OBJECT_ID('tempdb..#tapeCatalogArchFileList') IS NOT NULL
		DROP TABLE #tapeCatalogArchFileList
		CREATE TABLE #tapeCatalogArchFileList
		(
			segmentId		INT IDENTITY (1, 1),
			archFileId		INT,
			archCopyId		INt,
			commCellId		INT,
			streamNum		INT,
			primary key(segmentId)
		)
		CREATE INDEX #tapeCatalogArchFileList_Idx ON #tapeCatalogArchFileList(archFileId, archCopyId, commCellId)
		IF OBJECT_ID('tempdb..#chunkList') IS NOT NULL
		DROP TABLE #chunkList
		CREATE TABLE #chunkList
		(
			segmentId		INT,
			archFileId		INT,
			archCopyId		INT,
			archChunkId		INT,
			commCellId		INT,
			chunkCommCellId	INT,
			streamNum		INT,
			primary key(segmentId, archFileId, archChunkId, archCopyId, commCellId)
		)
		DECLARE @af_count      INTEGER
		DECLARE @chunk_count   INTEGER
		-- Get all tape import archive files.
		INSERT INTO #tapeCatalogArchFileList
		SELECT DISTINCT AFC.archFileId, AFC.archCopyId, AFC.commCellId, AFC.streamNum
		FROM archFileCopy AFC INNER JOIN CCM_MAP_ArchFileCopy tAFC ON AFC.archFileId = tAFC.archFileId AND AFC.archCopyId = tAFC.new_archCopyId AND AFC.commCellId = tAFC.new_commCellId
		WHERE AFC.drivePoolId = 0 AND AFC.modifiedTime = 0 AND AFC.mediaType = 0 -- tape import archfiles set with 0 for these three fields
		SET @af_count = @@ROWCOUNT
		WHILE (@af_count > 0 OR @chunk_count > 0)
		BEGIN
			-- Get all the chunks of archfiles.
			INSERT INTO #chunkList
			SELECT DISTINCT TAF.segmentId, ACM.archFileId, ACM.archCopyId, ACM.archChunkId, ACM.commCellId, ACM.chunkCommCellId, AFC.streamNum
			FROM archChunkMapping ACM INNER JOIN #tapeCatalogArchFileList TAF ON ACM.archFileId = TAF.archFileId
				AND ACM.archCopyId = TAF.archCopyId AND ACM.commCellId = TAF.commCellId
				INNER JOIN archFileCopy AFC ON AFC.archFileId = ACM.archFileId AND AFC.archCopyId = ACM.archCopyId AND AFC.commCellId = ACM.commCellId
			WHERE NOT EXISTS (SELECT 1 FROM #chunkList T WHERE T.segmentId = TAF.segmentId AND T.archFileId = ACM.archFileId AND T.archChunkId = ACM.archChunkId AND T.archCopyId = ACM.archCopyId AND T.commCellId = ACM.commCellId)
			SET @chunk_count = @@ROWCOUNT
			-- Get all the archive files on chunks.
			INSERT INTO #chunkList
			SELECT DISTINCT TCH.segmentId, ACM.archFileId, ACM.archCopyId, ACM.archChunkId, ACM.commCellId, ACM.chunkCommCellId, AFC.streamNum
			FROM archChunkMapping ACM INNER JOIN #chunkList TCH ON ACM.archChunkId = TCH.archChunkId
				AND ACM.archCopyId = TCH.archCopyId AND ACM.chunkCommCellId = TCH.chunkCommCellId
				INNER JOIN archFileCopy AFC ON AFC.archFileId = ACM.archFileId AND AFC.archCopyId = ACM.archCopyId AND AFC.commCellId = ACM.commCellId
			WHERE NOT EXISTS (SELECT 1 FROM #chunkList T WHERE T.segmentId = TCH.segmentId AND T.archFileId = ACM.archFileId AND T.archChunkId = ACM.archChunkId AND T.archCopyId = ACM.archCopyId AND T.commCellId = ACM.commCellId)
			SET @af_count = @@ROWCOUNT
		END
		UPDATE #tapeCatalogArchFileList
		SET streamNum = ISNULL((SELECT MAX(streamNum) FROM #chunkList TCH WHERE TCH.segmentId = TAF.segmentId), streamNum)
		FROM #tapeCatalogArchFileList TAF
		UPDATE archFileCopy
		SET streamNum = TAF.streamNum
		FROM #tapeCatalogArchFileList TAF INNER JOIN archFileCopy AFC ON TAF.archFileId = AFC.archFileId AND TAF.archCopyId = AFC.archCopyId AND TAF.commCellId = AFC.commCellId
		WHERE TAF.streamNum <> AFC.streamNum
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchFile -- archFileCopy -- Update streamNum.'
			GOTO CX_ERROR_EXIT
		END
	END
	---------------------------------------------------------
	-- Merge ArchChunkToSILO Table
	INSERT	INTO CCM_MAP_ArchChunkToSILO
	SELECT	archChunkId, commCellId, 0, volumeId, 0, 0
FROM CommServ_Merge..CCM_ArchChunkToSilo
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunkToSILO -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchChunkToSILO SET new_commCellId = b.new_id
	FROM CCM_MAP_ArchChunkToSILO a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunkToSILO -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchChunkToSILO SET new_volumeId = b.new_Id
	FROM CCM_MAP_ArchChunkToSILO a, CCM_MAP_MMVolume b
	WHERE a.old_volumeId = b.old_Id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunkToSILO -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchChunkToSILO SET exist = 1
	FROM	CCM_MAP_ArchChunkToSILO a, ArchChunkToSILO b
	WHERE	a.archChunkId = b.archChunkId AND a.new_commCellId = b.commCellId
	AND		a.new_volumeId = b.volumeId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchChunkToSILO -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO ArchChunkToSILO (
			archChunkId, commCellId, volumeId, flags
			)
	SELECT	b.archChunkId, a.new_commCellId, a.new_volumeId, b.flags
FROM	CCM_MAP_ArchChunkToSILO a, CommServ_Merge..CCM_ArchChunkToSilo b
	WHERE	a.archChunkId = b.archChunkId AND a.old_commCellId = b.commCellId
	AND		a.old_volumeId = b.volumeId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_ArchChunkToSILO -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge ArchFileSiloVolume Table
	INSERT	INTO CCM_MAP_ArchFileSiloVolume
	SELECT	archFileId, commCellId, 0, siloVolumeId, 0, 0
FROM CommServ_Merge..CCM_ArchFileSiloVolume
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileSiloVolume -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFileSiloVolume SET new_commCellId = b.new_id
	FROM CCM_MAP_ArchFileSiloVolume a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileSiloVolume -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ArchFileSiloVolume SET new_siloVolumeId = b.new_Id
	FROM CCM_MAP_ArchFileSiloVolume a, CCM_MAP_MMVolume b
	WHERE a.old_siloVolumeId = b.old_Id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileSiloVolume -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchFileSiloVolume SET exist = 1
	FROM	CCM_MAP_ArchFileSiloVolume a, ArchFileSiloVolume b
	WHERE	a.archFileId = b.archFileId AND a.new_commCellId = b.commCellId
	AND		a.new_siloVolumeId = b.siloVolumeId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- CCM_MAP_ArchFileSiloVolume -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO ArchFileSiloVolume (
			archFileId, commCellId, siloVolumeId, lastSiloChunkId, flags
			)
	SELECT	b.archFileId, a.new_commCellId, a.new_siloVolumeId, b.lastSiloChunkId, b.flags
FROM	CCM_MAP_ArchFileSiloVolume a, CommServ_Merge..CCM_ArchFileSiloVolume b
	WHERE	a.archFileId = b.archFileId AND a.old_commCellId = b.commCellId
	AND		a.old_siloVolumeId = b.siloVolumeId
	AND		a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- ArchFileSiloVolume -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO App_IndexCheckpointInfo
	SELECT  a.dbName, a.backupSetGUID, a.afileId, b.new_id, a.startTime, a.endTime, a.flags
FROM    CommServ_Merge..CCM_App_IndexCheckpointInfo a
			INNER JOIN CCM_MAP_CommCell b ON a.commCellId = b.old_id
			LEFT OUTER JOIN App_IndexCheckpointInfo c ON a.afileId = c.afileId and b.new_id = c.commCellId
    WHERE   c.afileId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_ArchFile -- App_IndexCheckpointInfo -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
	---------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_ArchFile')
	delete from GxQscripts where name = 'CCM_Merge_ArchFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_ArchFile')
	delete from GXDBVersions where aliasname = 'CCM_Merge_ArchFile'
GO

insert into GXDBVersions values(2, 'CCM_Merge_ArchFile',  '00010037019000020000', 'CCM_Merge_ArchFile', '00010037019000020000')
GO

