

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_Application_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge tables:
--	|					APP_Application
--	|					APP_SubClientProp
--	|					APP_ScFilterFile
--	|					APP_InstFilterFile
--	|					APP_ExtendedProperties
--	|					ArchPipeConfig
--	|					ArchCopyToApp
--  +========================================================================+
-- $Id: CCM_Merge_Application_from_XML.sp,v 1.2.116.5.6.1 2021/05/24 18:09:22 pnara Exp $
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCM_Merge_Application_from_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Merge_Application_from_XML <<<'
	drop procedure CCM_Merge_Application_from_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Merge_Application_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Application_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Application_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Application_from_XML'
GO
print '... Creating Procedure: CCM_Merge_Application_from_XML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCM_Merge_Application_from_XML
  @isEDCMerge integer = 0,
  @ccmParamFlags integer = 0,
  @i_indexMAId integer = 0,
  @jobId integer = 0,
  @errStr varchar(1024) OUTPUT
AS
	---------------------------------------------------------
-- Code below here is from CCM_Merge_Application.spb --
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	DECLARE @tblBeforeMerge TABLE (id INT)
-- DB: Fox Tanles changes
DECLARE @dummy_ccpId INTEGER
SET @dummy_ccpId = 0
DECLARE @dummy_ccpTime INTEGER
SET @dummy_ccpTime = 0
DECLARE @dummy_GUID uniqueidentifier
SET @dummy_GUID = '00000000-0000-0000-0000-000000000000'
	DECLARE	@tmpFileSystemAppType TABLE ( appTypeId integer)
	INSERT	@tmpFileSystemAppType
	SELECT	DISTINCT type FROM APP_idaType WHERE displayName = 'File System'
	---------------------------------------------------------
	-- Merge APP_Application table
	-- GET ApplicationId TO BE MERGED
	INSERT	INTO CCM_MAP_Application
	SELECT	id, 0, clientId, 0, instance,
			0, backupSet, 0, dataArchGrpId, 1, logArchGrpId, 1,
			appTypeId, refTime, subclientName, origCCId, 0, GUID
FROM #CCM_App_Application
	-- Remove the ones has no Client Id. It may come from Tape Import.
	WHERE	clientId > 0
	AND appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	--Merge DB has SILO backup sets need to be reassigned to Commserv Client of Destination CS
IF EXISTS (SELECT * FROM #CCM_App_Application where backupSet in
(SELECT componentNameId FROM #CCM_App_BackupSetProp WHERE attrName = 'SILO Copy ID' AND attrVal > 0))
	BEGIN
		IF NOT EXISTS
		(
			SELECT 1
			from app_idaname AN INNER JOIN @tmpFileSystemAppType tt ON AN.appTypeId = tt.appTypeId
			WHERE AN.clientId = 2
		)
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- Destination Commserv Client does not have File System IDA installed for import of SILO backupsets'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_Application SET new_clientId = 2
		WHERE old_backupSet in
(SELECT componentNameId FROM #CCM_App_BackupSetProp WHERE attrName = 'SILO Copy ID' AND attrVal > 0)
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- UPDATE new_clientId = 2 FOR SILO backupset subclients'
			GOTO CX_ERROR_EXIT
		END
		-- now remap the apptypes of the silo backupset clients. Probably this code is not only needed for silo, but for all
		-- filesystem backupsets, but I do not want to risk regression (build 82)
		 DECLARE @l_CSFSAppType Int
		 SELECT TOP 1  @l_CSFSAppType = AN.appTypeId
		 from app_idaname AN INNER JOIN @tmpFileSystemAppType tt ON AN.appTypeId = tt.appTypeId
		 WHERE AN.clientId = 2
		 -- it is impossible not to get an apptype here as otherwise we would not be in this if block
		 UPDATE CCM_MAP_APPLICATION
		 SET appTypeId = @l_CSFSAppType
		 WHERE old_backupSet in
(SELECT componentNameId FROM #CCM_App_BackupSetProp WHERE attrName = 'SILO Copy ID' AND attrVal > 0)
		 IF @@ERROR > 0
		 BEGIN
		 	SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- Failed to update Silo backupset apptypes'
		 	GOTO CX_ERROR_EXIT
		 END
	END
	UPDATE CCM_MAP_Application SET new_clientId = b.new_id
	FROM CCM_MAP_Application a, CCM_MAP_Client b
	WHERE a.old_clientId = b.old_id
	AND a.new_clientId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- UPDATE new_clientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_Application SET new_instance = b.new_id
	FROM CCM_MAP_Application a, CCM_MAP_InstanceName b
	WHERE a.old_instance = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- UPDATE new_instance'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_Application SET new_backupSet = b.new_id
	FROM CCM_MAP_Application a, CCM_MAP_BackupSetName b
	WHERE a.old_backupset = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- UPDATE new_backupSet'
		GOTO CX_ERROR_EXIT
	END
IF EXISTS(SELECT * FROM #CCM_ArchGroup WHERE type = 4)
	BEGIN
		DECLARE @SrcAnalyticsAGId integer
		DECLARE @DestAnalyticsAGId integer
SET @SrcAnalyticsAGId = ISNULL((SELECT top 1 id FROM #CCM_ArchGroup WHERE type = 4),0)
SET @DestAnalyticsAGId = ISNULL((SELECT top 1 id FROM ArchGroup WHERE type = 4),0)
		IF @SrcAnalyticsAGId <> 0
		AND EXISTS(SELECT * FROM CCM_MAP_Application WHERE old_dataArchGrpId = @SrcAnalyticsAGId OR old_logArchGrpId = @SrcAnalyticsAGId)
		BEGIN
			IF @DestAnalyticsAGId = 0
			BEGIN
				/* PrasadNara: Don't fail the job.
				-- Skip the import of subclient associated with SRM analytics storage policy incase destination doesn't has it.
				-- Instead of skipping map the subclients to default dummy policy.
				-- SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- SRM Analytics Storage Policy Not found in the destination database'
				-- GOTO CX_ERROR_EXIT
				*/
				SET @DestAnalyticsAGId = 1
			END
			UPDATE CCM_MAP_Application SET new_dataArchGrpId = @DestAnalyticsAGId
			WHERE old_dataArchGrpId = @SrcAnalyticsAGId
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- UPDATE SRM Analytics Storage Policy Id'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CCM_MAP_Application SET new_logArchGrpId = @DestAnalyticsAGId
			WHERE old_logArchGrpId = @SrcAnalyticsAGId
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- UPDATE SRM Analytics Storage Policy Id'
				GOTO CX_ERROR_EXIT
			END
		END
	END
	UPDATE CCM_MAP_Application SET new_dataArchGrpId = b.new_id
	FROM CCM_MAP_Application a, CCM_MAP_ArchGroup b
	WHERE a.old_dataArchGrpId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- UPDATE new_dataArchGrpId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_Application SET new_logArchGrpId = b.new_id
	FROM CCM_MAP_Application a, CCM_MAP_ArchGroup b
	WHERE a.old_logArchGrpId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- UPDATE new_logArchGrpId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_Application SET new_origCCId = b.new_id
	FROM CCM_MAP_Application a, CCM_MAP_CommCell b
	WHERE a.old_origCCId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- UPDATE new_origCCId'
		GOTO CX_ERROR_EXIT
	END
	--changed by kbora , TapeImport new design.
	UPDATE APP_Application
	SET	clientId  = G.new_id,
        appTypeId = B.appTypeId,
		instance = F.new_id,
		backupSet = E.new_id,
		appNumber = B.appNumber,
		refTime = B.refTime,
		modified = B.modified,
		subclientName = B.subclientName,
		subclientStatus = B.subclientStatus,
        origCCId = D.new_id,
		GUID = B.GUID
FROM APP_Application A, #CCM_App_Application B, CCM_TapeImportEntities C, CCM_MAP_CommCell D,
         CCM_MAP_BackupSetName E, CCM_Map_InstanceName F, CCM_Map_Client G
WHERE B.id = C.old_id AND C.newCCId = D.new_id AND A.id = C.new_id AND C.entityType = 7
        AND B.backupSet = E.old_id AND B.instance = F.old_id AND B.clientId = G.old_id
        AND A.subclientName = 'SubClient_'+CAST(A.id AS VARCHAR(100))
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_Application -- UPDATE WITH CCM_TapeImportEntities table'
		GOTO CX_ERROR_EXIT
	END
    UPDATE	APP_Application
	SET 	appTypeId = D.appTypeId, origCCId = D.origCCId
    FROM 	APP_Application A,
            (
				SELECT 	DISTINCT b.backupset, b.appTypeId, b.origCCId
				FROM	App_Application b
INNER JOIN CCM_TapeImportEntities c ON b.id = c.new_id AND c.entityType = 7
			) AS D
	WHERE   A.backupSet = D.backupSet AND A.appTypeId <> D.appTypeId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_Application -- UPDATE AppTypeId WITH CCM_TapeImportEntities table'
		GOTO CX_ERROR_EXIT
	END
	--
	--First Match with GUID, if GUID is empty then match with the name
	--
	UPDATE	CCM_MAP_Application SET new_id = b.id
	FROM	CCM_MAP_Application a, APP_Application b
	WHERE	a.new_clientId = b.clientId
	AND		a.new_instance = b.instance
	AND		a.new_backupset = b.backupSet
	AND		a.appTypeId = b.appTypeId
	AND		a.GUID = b.GUID
	AND 	LEN(a.GUID) > 0
	AND 	a.GUID <> @dummy_GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- UPDATE new_id - Matching With GUID'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_Application SET new_id = b.id
	FROM	CCM_MAP_Application a, APP_Application b
	WHERE	a.new_clientId = b.clientId
	AND		a.new_instance = b.instance
	AND		a.new_backupset = b.backupSet
	AND		a.appTypeId = b.appTypeId
	AND		a.subclientName = b.subclientName
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- UPDATE new_id'
		GOTO CX_ERROR_EXIT
	END
	------------------------------------------------------------------
	--
	-- Make sure there is only one file system iDA per one client even though appTypes are different
	-- Have to match instance, backupset and application all
	--
	IF EXISTS ( SELECT *
							FROM	CCM_MAP_Application a, APP_Application b
							WHERE	a.new_clientId = b.clientId
							AND		a.new_instance = b.instance
							AND		a.new_backupset = b.backupSet
							AND		((a.GUID = b.GUID AND LEN(a.GUID) > 0 AND a.GUID <> @dummy_GUID) OR a.subclientName = b.subclientName)
							AND	  	a.appTypeId IN (SELECT appTypeId FROM @tmpFileSystemAppType)
							AND   	b.appTypeId IN (SELECT appTypeId FROM @tmpFileSystemAppType)
							AND		a.appTypeId <> b.appTypeId
						)
	BEGIN
		DECLARE @srcClientId		INT
		DECLARE @srcAppType			INT
		DECLARE @srcMaxOpTime		DATETIME
		DECLARE @dstClientId		INT
		DECLARE @dstAppType			INT
		DECLARE @dstMaxOpTime		DATETIME
		DECLARE CUR_GetFileSystemIda CURSOR LOCAL FOR
							SELECT DISTINCT a.old_clientId, a.appTypeId, b.clientId, b.appTypeId
							FROM	CCM_MAP_Application a, APP_Application b
							WHERE	a.new_clientId = b.clientId
							AND		a.new_instance = b.instance
							AND		a.new_backupset = b.backupSet
							AND		((a.GUID = b.GUID AND LEN(a.GUID) > 0 AND a.GUID <> @dummy_GUID) OR a.subclientName = b.subclientName)
							AND	  	a.appTypeId IN (SELECT appTypeId FROM @tmpFileSystemAppType)
							AND   	b.appTypeId IN (SELECT appTypeId FROM @tmpFileSystemAppType)
							AND		a.appTypeId <> b.appTypeId
		OPEN CUR_GetFileSystemIda
		FETCH CUR_GetFileSystemIda into @srcClientId, @srcAppType, @dstClientId, @dstAppType
		WHILE @@FETCH_STATUS = 0
		BEGIN
			-- source has higher priority be default
			SELECT @srcMaxOpTime = ISNULL(MAX(OpTimeUTC), getutcdate())
FROM	#CCM_LicUsageHistory
			WHERE CId = @srcClientId AND AppType = @srcAppType
			SELECT @dstMaxOpTime = ISNULL(MAX(OpTimeUTC), dbo.getdatetime(0))
			FROM LicUsageHistory
			WHERE CId = @dstClientId AND AppType = @dstAppType
			-- source has the latest version
			IF @srcMaxOpTime > @dstMaxOpTime
			BEGIN
				UPDATE APP_Application
				SET		appTypeId = a.appTypeId
				FROM	CCM_MAP_Application a, APP_Application b
				WHERE	a.new_clientId = b.clientId
				AND		a.new_instance = b.instance
				AND		a.new_backupset = b.backupSet
				AND		((a.GUID = b.GUID AND LEN(a.GUID) > 0 AND a.GUID <> @dummy_GUID) OR a.subclientName = b.subclientName)
				AND		a.new_clientId = @dstClientId
				AND		a.old_clientId = @srcClientId
				AND		a.appTypeId = @srcAppType
				AND		b.appTypeId = @dstAppType
				UPDATE	CCM_MAP_Application SET new_id = b.id
				FROM	CCM_MAP_Application a, APP_Application b
				WHERE	a.new_clientId = b.clientId
				AND		a.new_instance = b.instance
				AND		a.new_backupset = b.backupSet
				AND		a.appTypeId = b.appTypeId
				AND		((a.GUID = b.GUID AND LEN(a.GUID) > 0 AND a.GUID <> @dummy_GUID) OR a.subclientName = b.subclientName)
				AND		a.new_clientId = @dstClientId
				AND		a.old_clientId = @srcClientId
			END
			ELSE
			-- destination has the latest version
			BEGIN
				UPDATE	CCM_MAP_Application SET new_id = b.id
				FROM	CCM_MAP_Application a, APP_Application b
				WHERE	a.new_clientId = b.clientId
				AND		a.new_instance = b.instance
				AND		a.new_backupset = b.backupSet
				AND		((a.GUID = b.GUID AND LEN(a.GUID) > 0 AND a.GUID <> @dummy_GUID) OR a.subclientName = b.subclientName)
				AND		a.new_clientId = @dstClientId
				AND		a.old_clientId = @srcClientId
				AND		a.appTypeId = @srcAppType
				AND		b.appTypeId = @dstAppType
			END
			FETCH CUR_GetFileSystemIda into @srcClientId, @srcAppType, @dstClientId, @dstAppType
		END
		CLOSE CUR_GetFileSystemIda
		DEALLOCATE CUR_GetFileSystemIda
	END
	--
	--PrasadNara: Update the subclient in case of GRC
	--
IF (@ccmParamFlags & 1) > 0
	BEGIN
		UPDATE	App_Application
		SET		dataArchGrpId 	= a.new_dataArchGrpId,
				logArchGrpId 	= a.new_logArchGrpId,
				subClientName	= a.subclientName,
				subclientStatus	= b.subclientStatus,
				modified 		= b.modified
		FROM	CCM_MAP_Application a
INNER JOIN #CCM_App_Application b ON a.old_id = b.id
				INNER JOIN App_Application c ON a.new_id = c.id
		WHERE 	b.modified >= c.modified
				AND a.new_id > 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- APP_Application -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
	END
	--
	--PrasadNara: Update the subclientname in case source is latest
	--
	UPDATE	App_Application
	SET		subClientName	= a.subclientName,
			modified 		= b.modified
	FROM	CCM_MAP_Application a
INNER JOIN #CCM_App_Application b ON a.old_id = b.id
			INNER JOIN App_Application c ON a.new_id = c.id
	WHERE 	b.modified >= c.modified
			AND a.new_id > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_Application -- UPDATE subclientname'
		GOTO CX_ERROR_EXIT
	END
	--
	--PrasadNara: Update the storage policy association when subclient is associated with no storage policy in destination.
	--
	UPDATE	App_Application
	SET		dataArchGrpId 	= a.new_dataArchGrpId
	FROM	CCM_MAP_Application a
			INNER JOIN App_Application c ON a.new_id = c.id
	WHERE 	a.new_id > 0
			AND c.dataArchGrpId = 1 --DUMMY Storage policy
			AND a.new_dataArchGrpId > 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_Application -- UPDATE dataArchGrpId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	App_Application
	SET		logArchGrpId 	= a.new_logArchGrpId
	FROM	CCM_MAP_Application a
			INNER JOIN App_Application c ON a.new_id = c.id
	WHERE 	a.new_id > 0
			AND c.logArchGrpId = 1 --DUMMY Storage policy
			AND a.new_logArchGrpId > 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_Application -- UPDATE logArchGrpId'
		GOTO CX_ERROR_EXIT
	END
	------------------------------------------------------------------
	IF EXISTS (SELECT * FROM CCM_MAP_CommCell WHERE new_id = 2 and old_id = 2)
	BEGIN
			-------------------------------------------------------------
			-- Merge to same APP_CommCell and id not used, keep the same id
			-------------------------------------------------------------
			DELETE FROM @tblBeforeMerge
			INSERT INTO @tblBeforeMerge SELECT id FROM APP_Application
			SET IDENTITY_INSERT APP_Application ON
			INSERT	INTO APP_Application (
					id, clientId, appTypeId, instance, backupSet, appNumber,
					dataArchGrpID, logArchGrpID, refTime,
					modified, subclientName, subclientStatus, origCCId, GUID
					)
			SELECT	a.old_id, a.new_clientId, a.appTypeId,
					a.new_instance, a.new_backupSet, b.appNumber,
					new_dataArchGrpId, new_logArchGrpId, b.refTime, b.modified,
					b.subclientName, b.subclientStatus, a.new_origCCId,
					isnull(nullif(b.GUID, @dummy_GUID), newid())
FROM	CCM_MAP_Application a, #CCM_App_Application b
			WHERE	a.old_clientId = b.clientId
			AND		a.old_instance = b.instance
			AND		a.old_backupset = b.backupSet
			AND		a.appTypeId = b.appTypeId
			AND		a.subclientName = b.subclientName
			AND		a.new_id = 0
			AND		a.old_id NOT IN (SELECT id FROM @tblBeforeMerge)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Application -- APP_Application -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			SET IDENTITY_INSERT APP_Application OFF
			-------------------------------------------------------------
			-- Merge to same APP_CommCell but id is reused, create new id
			-------------------------------------------------------------
-- DB: Fox Tanles changes
			INSERT	INTO APP_Application
			SELECT	a.new_clientId, a.appTypeId,
					a.new_instance, a.new_backupSet, b.appNumber,
					new_dataArchGrpId, new_logArchGrpId, b.refTime, b.modified,
					b.subclientName, b.subclientStatus, @dummy_ccpId, @dummy_ccpTime, a.new_origCCId,
					isnull(nullif(b.GUID, @dummy_GUID), newid())
FROM	CCM_MAP_Application a, #CCM_App_Application b
			WHERE	a.old_clientId = b.clientId
			AND		a.old_instance = b.instance
			AND		a.old_backupset = b.backupSet
			AND		a.appTypeId = b.appTypeId
			AND		a.subclientName = b.subclientName
			AND		a.new_id = 0
			AND		a.old_id IN (SELECT id FROM @tblBeforeMerge)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Application -- APP_Application -- INSERT'
				GOTO CX_ERROR_EXIT
			END
	END
	ELSE
	BEGIN
			----------------------------------------------
			-- Merge to different APP_CommCell, create new id
			----------------------------------------------
			INSERT INTO APP_Application
			SELECT	a.new_clientId, a.appTypeId,
					a.new_instance, a.new_backupSet, b.appNumber,
					new_dataArchGrpId, new_logArchGrpId, b.refTime, b.modified,
					b.subclientName, b.subclientStatus, @dummy_ccpId, @dummy_ccpTime, a.new_origCCId,
 					isnull(nullif(b.GUID, @dummy_GUID), newid())
FROM CCM_MAP_Application a, #CCM_App_Application b
			WHERE	a.old_clientId = b.clientId
			AND		a.old_instance = b.instance
			AND		a.old_backupset = b.backupSet
			AND	-- this change is for silo backupset subclients when the one CS is on x64 and the other is win32
			(	a.appTypeId = b.appTypeId OR a.new_clientId = 2 AND a.new_origCCId <> 2
			)
			AND		a.subclientName = b.subclientName
			AND		a.new_id = 0
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Application -- APP_Application -- INSERT'
				GOTO CX_ERROR_EXIT
			END
	END
	UPDATE	CCM_MAP_Application SET new_id = b.id
	FROM	CCM_MAP_Application a, APP_Application b
	WHERE	a.new_clientId = b.clientId
	AND		a.new_instance = b.instance
	AND		a.new_backupset = b.backupSet
	AND		a.appTypeId = b.appTypeId
	AND		(a.GUID = b.GUID AND LEN(a.GUID) > 0 AND a.GUID <> @dummy_GUID)
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- UPDATE 5matching with GUID'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_Application SET new_id = b.id
	FROM	CCM_MAP_Application a, APP_Application b
	WHERE	a.new_clientId = b.clientId
	AND		a.new_instance = b.instance
	AND		a.new_backupset = b.backupSet
	AND		a.appTypeId = b.appTypeId
	AND		a.subclientName = b.subclientName
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_Application -- UPDATE 5'
		GOTO CX_ERROR_EXIT
	END
	IF @isEDCMerge = 2
	BEGIN
		UPDATE APP_Application
		SET subclientStatus = b.subclientStatus
FROM APP_Application a, #CCM_App_Application b, CCM_MAP_Application c
		WHERE a.id = c.new_id AND b.id = c.old_id AND a.modified < b.modified
	END
	-- Update VSA discovered subclientId.
	UPDATE 	APP_ClientProp
	SET 	attrVal = CONVERT(VARCHAR(64), APP.new_Id),
			attrName = SUBSTRING(attrName, 0, LEN(attrName) - 23)
	FROM 	CCM_MAP_Client CL INNER JOIN APP_ClientProp PROP ON CL.new_id = PROP.componentNameId AND PROP.attrName LIKE '% CCM Need to map appId'
			INNER JOIN CCM_MAP_Application APP ON CONVERT(INT, PROP.attrVal) = APP.old_Id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Client -- APP_ClientProp -- Failed update VSA Discover Subclient ID. '
		GOTO CX_ERROR_EXIT
	END
	-- Update ArchGroupCopy Table siloAppId Column
	UPDATE	CCM_MAP_ArchGroupCopy SET new_siloAppId = b.new_id
	FROM	CCM_MAP_ArchGroupCopy a, CCM_MAP_Application b
	WHERE	a.old_siloAppId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ArchGroupCopy -- UPDATE new_siloAppId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	ArchGroupCopy set siloAppId = b.new_siloAppId
	FROM	ArchGroupCopy a, CCM_MAP_ArchGroupCopy b
	WHERE	a.id = b.new_id
	AND		b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- ArchGroupCopy -- UPDATE siloAppId'
		GOTO CX_ERROR_EXIT
	END
	/*
	 * PrasadNara: Permanent migration  reset APP_Application storage policy associations in case primary copy of assigned policy is GRC copy to
	 * a)	A storage policy of the same name in case it exists locally (Rackspace)
	 * b)	A storage policy given by an MMConfig param
	 * c)	No storage policy (dummy entry)
	 */
IF (@ccmParamFlags & 1) = 0
	BEGIN
		DECLARE @lt_ArchGroup TABLE(Id int, newId int, isPrimaryCopyGRCCopy int)
		INSERT INTO @lt_ArchGroup
		SELECT DISTINCT new_dataArchGrpId, 1,  0
		FROM CCM_MAP_Application
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- lt_ArchGroup -- INSERT  - 1'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO @lt_ArchGroup
		SELECT DISTINCT a.new_logArchGrpId, 1, 0
		FROM CCM_MAP_Application a LEFT OUTER JOIN @lt_ArchGroup b ON a.new_logArchGrpId = b.id
		WHERE b.Id IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- lt_ArchGroup -- INSERT  - 2'
			GOTO CX_ERROR_EXIT
		END
		UPDATE @lt_ArchGroup
		SET isPrimaryCopyGRCCopy = 1
		FROM @lt_ArchGroup a INNER JOIN archGroup b ON a.Id = b.Id
			INNER JOIN ArchAgingRule c ON b.defaultCopy = c.copyId
WHERE (c.flags & 256) > 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- lt_ArchGroup -- UPDATE isPrimaryCopyGRCCopy'
			GOTO CX_ERROR_EXIT
		END
		DELETE @lt_ArchGroup
		WHERE isPrimaryCopyGRCCopy = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- lt_ArchGroup -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		UPDATE @lt_ArchGroup
		SET newId = d.Id
		FROM @lt_ArchGroup a INNER JOIN CCM_MAP_ArchGroup b ON a.Id = b.new_id
INNER JOIN #CCM_ArchGroup c ON b.old_id = c.Id
			INNER JOIN ArchGroup d ON c.name = d.name
		WHERE a.Id <> d.Id
AND d.type <> 4
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- lt_ArchGroup -- UPDATE - newId - 1'
			GOTO CX_ERROR_EXIT
		END
		UPDATE @lt_ArchGroup
		SET newId = ISNULL((SELECT value FROM MMConfigs WHERE name = 'CCM_CONFIG_STORAGEPOLICY_FOR_CLIENT'), 1)
		WHERE newId = 1
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- lt_ArchGroup -- UPDATE - newId - 2'
			GOTO CX_ERROR_EXIT
		END
		UPDATE APP_Application
		SET dataArchGrpId = c.newId
		FROM APP_Application a INNER JOIN CCM_MAP_Application b ON a.Id = b.new_Id
			INNER JOIN @lt_ArchGroup c ON b.new_dataArchGrpId = c.Id
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- App_Application -- RESET - dataArchGrpId'
			GOTO CX_ERROR_EXIT
		END
		UPDATE APP_Application
		SET logArchGrpId = c.newId
		FROM APP_Application a INNER JOIN CCM_MAP_Application b ON a.Id = b.new_Id
			INNER JOIN @lt_ArchGroup c ON b.new_logArchGrpId = c.Id
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- App_Application -- RESET - logArchGrpId'
			GOTO CX_ERROR_EXIT
		END
	END
	------------------------------------------------------------
	-- Merge App_IndexDbInfo table
	INSERT INTO App_IndexDBInfo
	SELECT A.dbName, A.type, A.idxDbEngineType, B.id, @i_indexMAId, A.backupSetGUID, A.properties, A.isPrimary, A.committedTransactionId, 0, A.flags
FROM #CCM_App_IndexDBInfo A INNER JOIN APP_BackupSetName B ON A.backupSetGUID = B.GUID
	LEFT OUTER JOIN App_IndexDBInfo C ON C.backupSetGUID = A.backupSetGUID AND A.dbName = C.dbName AND A.idxDbEngineType = C.idxDbEngineType
	WHERE C.backupSetGUID IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- App_IndexDBInfo -- Insert'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge APP_SubClientProp table
	----------------------------------------------------------
	--  property won't be migrated
	--	'last data SP'
	--	'last log SP'
	----------------------------------------------------------
        --kbora
	--if subclient is already imported by tapeimport job, then update all the properties with CCM information
DELETE APP_SubclientProp WHERE componentNameId IN (SELECT new_id FROM CCM_TapeImportEntities WHERE entityType = 7)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- Delete TapeImport properites'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO CCM_MAP_SubclientProp
	SELECT	a.id, 0, a.componentNameId, 0, a.attrName, a.attrType, a.attrVal, a.created, a.modified, 0
FROM	#CCM_App_SubClientProp a
INNER JOIN #CCM_App_Application b ON a.componentNameId = b.id
	WHERE	a.attrName <> 'last data SP'
	AND		a.attrName <> 'last log SP'
	AND		b.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_SubclientProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Setting passwords to empty.
	UPDATE CMS
	SET attrVal = '' FROM
	CCM_MAP_SubclientProp CMS
    INNER JOIN
	APP_CredProps ACP WITH(NOLOCK)
ON ACP.attrPwdName = CMS.attrName AND ACP.cs_attrPwdName = CHECKSUM(CMS.attrName) AND ACP.tableId = 61
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- Setting passwords to empty.'
		GOTO CX_ERROR_EXIT
	END
	-- update silo copy
	UPDATE	CCM_MAP_SubclientProp
    SET attrVal = b.new_id
	FROM	CCM_MAP_SubclientProp a, CCM_MAP_ArchGroupCopy b
	WHERE	a.attrName = 'SILO Copy ID' AND a.attrVal > 0
	AND		a.attrVal = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- failed to update the silo copy in the subclient properties'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SubclientProp SET new_componentNameId = b.new_id
	FROM	CCM_MAP_SubclientProp a, CCM_MAP_Application b
	WHERE	a.old_componentNameId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_SubclientProp -- UPDATE new_componentNameId'
		GOTO CX_ERROR_EXIT
	END
	-- Update Documentum subclient property 'Documentum Streams'
	-- attrVal: "Client_Id_1" + SPACE + "No Of Streams" + "Client_Id_2" + SPACE + "No of Streams"  etc.
	-- These client Id's need to  be mapped to new clients
	IF EXISTS(SELECT * FROM CCM_MAP_SubclientProp where attrname = 'Documentum Streams')
	BEGIN
		DECLARE @oldComponentId INTEGER
		DECLARE @oldAttrVal NVARCHAR(1024)
		DECLARE @newAttrVal NVARCHAR(1024)
		DECLARE @doc_stream_attrValue_temp TABLE(id integer identity, oldValue integer, newValue integer)
		DECLARE CCM_MAP_SubclientPropDocumentumStreamsCursor Cursor LOCAL for
		SELECT old_componentNameId, attrVal from CCM_MAP_SubclientProp
		WHERE attrName = 'Documentum Streams'
		OPEN CCM_MAP_SubclientPropDocumentumStreamsCursor
		FETCH NEXT FROM CCM_MAP_SubclientPropDocumentumStreamsCursor INTO
		@oldComponentId, @oldAttrVal
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO @doc_stream_attrValue_temp
			SELECT CAST(Value AS INTEGER),0 FROM cte_split_inline (@oldAttrVal,'')
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_SubclientProp -- Insert @doc_stream_attrValue_temp '
				GOTO CX_ERROR_EXIT
			END
			UPDATE @doc_stream_attrValue_temp SET newValue = oldValue
			FROM @doc_stream_attrValue_temp a
			WHERE (a.id % 2) = 0 -- Odd rows have client id's that needs to be mapped, Even Rows have No. of Streams - need not care about
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_SubclientProp -- Update @doc_stream_attrValue_temp '
				GOTO CX_ERROR_EXIT
			END
			UPDATE @doc_stream_attrValue_temp SET newValue = b.new_id
			FROM @doc_stream_attrValue_temp a, CCM_MAP_Client b
			WHERE a.oldValue = b.old_id
			AND (a.id % 2) <> 0 -- Odd rows have client id's that needs to be mapped, Even Rows have No. of Streams - need not care about
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_SubclientProp -- Update @doc_stream_attrValue_temp '
				GOTO CX_ERROR_EXIT
			END
			IF EXISTS (SELECT * FROM @doc_stream_attrValue_temp WHERE newValue = 0 AND oldValue <> 0)
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_SubclientProp -- New ClientId Unknown for Documentum Streams'
				GOTO CX_ERROR_EXIT
			END
			SET @newAttrVal = NULL
			SELECT @newAttrVal = COALESCE(@newAttrVal+' ','') + CAST(ISNULL(newValue,0) AS NVARCHAR) FROM @doc_stream_attrValue_temp
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_SubclientProp -- Select @newAttrVal for Documentum Streams '
				GOTO CX_ERROR_EXIT
			END
			UPDATE CCM_MAP_SubclientProp SET attrVal = @newAttrVal
			WHERE old_componentNameId = @oldComponentId
			AND attrName = 'Documentum Streams'
			AND attrVal = @oldAttrVal
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_SubclientProp -- UPDATE @newAttrVal for Documentum Streams '
				GOTO CX_ERROR_EXIT
			END
			DELETE FROM @doc_stream_attrValue_temp
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_SubclientProp -- DELETE - @doc_stream_attrValue_temp '
				GOTO CX_ERROR_EXIT
			END
		FETCH NEXT FROM CCM_MAP_SubclientPropDocumentumStreamsCursor INTO
		@oldComponentId, @oldAttrVal
		END
		CLOSE CCM_MAP_SubclientPropDocumentumStreamsCursor
		DEALLOCATE CCM_MAP_SubclientPropDocumentumStreamsCursor
	END
	-- End of - Update Documentum subclient property 'Documentum Streams' to new Client Id's
	-- Update Documentum subclient property 'Documentum Storage Policy Id'
	IF EXISTS(SELECT * FROM CCM_MAP_SubclientProp where attrname = 'Documentum Storage Policy Id')
	BEGIN
		UPDATE CCM_MAP_SubclientProp SET attrVal = CAST(a.new_id AS NVARCHAR)
		FROM CCM_MAP_ArchGroup a,CCM_MAP_SubclientProp
		WHERE attrname = 'Documentum Storage Policy Id'
		AND a.old_id = CAST(attrVal AS INTEGER)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_SubclientProp -- UPDATE - Documentum Storage Policy Id '
			GOTO CX_ERROR_EXIT
		END
	END
    IF EXISTS(SELECT * FROM CCM_MAP_SubclientProp where attrname = 'Oracle RAC Data Properties')
    BEGIN
	-- Update Oracle Subclient Property 'Oracle RAC Data Properties'
	-- attrVal: "First_ID" + SPACE + "String_A" + "+" + "Second_ID" + SPACE + "String_B"
	-- First_id and Second_id are IDs in APP_OracleRacInstance table
	DECLARE @CCM_MAP_SubclientProp_Oracle TABLE (
			old_componentNameId int,
			new_componentNameId int,
			old_attrVal nvarchar(1024),
			new_attrVal nvarchar(1024)
			)
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'lt_oracle_rac_temp')
		DROP TABLE lt_oracle_rac_temp
	CREATE TABLE lt_oracle_rac_temp(
			id integer identity,
			oldValue integer,
			newValue integer
			)
	DECLARE @CCM_MAP_SubclientProp_Oracle_oldComponentId INTEGER
	DECLARE @CCM_MAP_SubclientProp_Oracle_newComponentId INTEGER
	DECLARE @CCM_MAP_SubclientProp_Oracle_oldAttrVal     NVARCHAR(1024)
	DECLARE @CCM_MAP_SubclientProp_Oracle_newAttrVal     NVARCHAR(1024)
	DECLARE @value                                       NVARCHAR(512)
	DECLARE @tempValue                                   NVARCHAR(512)
	insert into @CCM_MAP_SubclientProp_Oracle
	select old_componentNameId, new_componentNameId, attrVal, N''
	from CCM_MAP_SubclientProp where attrname = 'Oracle RAC Data Properties'
	DECLARE CCM_MAP_SubclientProp_OracleCursor Cursor LOCAL For
	SELECT old_componentNameId, new_componentNameId, old_attrVal
	FROM @CCM_MAP_SubclientProp_Oracle
	OPEN CCM_MAP_SubclientProp_OracleCursor
	FETCH NEXT FROM CCM_MAP_SubclientProp_OracleCursor
	INTO @CCM_MAP_SubclientProp_Oracle_oldComponentId, @CCM_MAP_SubclientProp_Oracle_newComponentId, @CCM_MAP_SubclientProp_Oracle_oldAttrVal
	WHILE @@FETCH_STATUS = 0
	BEGIN
        SET @CCM_MAP_SubclientProp_Oracle_newAttrVal = ''
        SET @tempValue = ''
		DECLARE AttrVal_Plus_Cursor Cursor LOCAL For
		select * from cte_split_inline(@CCM_MAP_SubclientProp_Oracle_oldAttrVal,'+') -- '62 1 1+63 1 2+59 1 3'
		-- Cursor will have the following records
		-- 62 1 1
		-- 63 1 2
		-- 59 1 3
		OPEN AttrVal_Plus_Cursor
		FETCH NEXT FROM AttrVal_Plus_Cursor
		INTO @value
		WHILE @@FETCH_STATUS = 0
		BEGIN
		 -- @value will have 63 1 2 or 62 1 1 or 59 1 3
		 INSERT INTO lt_oracle_rac_temp
		 SELECT CAST(Value AS INTEGER),CAST(Value AS INTEGER) FROM cte_split_inline(@value,' ') -- '63 1 2'
		 -- lt_oracle_rac_temp will have the following records
		 -- 1 63 63
		 -- 2  1  1
		 -- 3  2  2
		 UPDATE lt_oracle_rac_temp
		 SET newValue = ISNULL((select new_id from CCM_MAP_AppOracleRacInstance where old_id = oldValue),0)
		 WHERE id = 1
		 IF EXISTS(SELECT * FROM lt_oracle_rac_temp WHERE id = 1 and newValue = 0)
		 BEGIN
		  DELETE CCM_MAP_SubclientProp
		  WHERE  old_componentNameId = @CCM_MAP_SubclientProp_Oracle_oldComponentId
				 AND new_componentNameId = @CCM_MAP_SubclientProp_Oracle_newComponentId
				 AND attrname = 'Oracle RAC Data Properties'
				 AND attrVal = @CCM_MAP_SubclientProp_Oracle_oldAttrVal
		  DELETE @CCM_MAP_SubclientProp_Oracle
		  WHERE  old_componentNameId = @CCM_MAP_SubclientProp_Oracle_oldComponentId
				 AND new_componentNameId = @CCM_MAP_SubclientProp_Oracle_newComponentId
				 AND old_attrVal = @CCM_MAP_SubclientProp_Oracle_oldAttrVal
		  BREAK
		 END
		 Select @tempValue = COALESCE(@tempValue+' ','') + CAST(ISNULL(newValue,0) AS NVARCHAR) FROM lt_oracle_rac_temp
		 TRUNCATE TABLE lt_oracle_rac_temp
		 FETCH NEXT FROM AttrVal_Plus_Cursor
		 INTO @value
		 IF(@@FETCH_STATUS = 0)
		 BEGIN
		  SET @tempValue = @tempValue + '+'
		 END
		END
		CLOSE AttrVal_Plus_Cursor
		DEALLOCATE AttrVal_Plus_Cursor
        SET @CCM_MAP_SubclientProp_Oracle_newAttrVal = @tempValue
		UPDATE @CCM_MAP_SubclientProp_Oracle
		SET new_attrVal = @CCM_MAP_SubclientProp_Oracle_newAttrVal
		WHERE old_componentNameId = @CCM_MAP_SubclientProp_Oracle_oldComponentId
		  AND new_componentNameId = @CCM_MAP_SubclientProp_Oracle_newComponentId
		  AND old_attrVal = @CCM_MAP_SubclientProp_Oracle_oldAttrVal
	FETCH NEXT FROM CCM_MAP_SubclientProp_OracleCursor
	INTO @CCM_MAP_SubclientProp_Oracle_oldComponentId, @CCM_MAP_SubclientProp_Oracle_newComponentId, @CCM_MAP_SubclientProp_Oracle_oldAttrVal
	END
	CLOSE CCM_MAP_SubclientProp_OracleCursor
	DEALLOCATE CCM_MAP_SubclientProp_OracleCursor
	DROP TABLE lt_oracle_rac_temp
	update CCM_MAP_SubclientProp set attrVal = b.new_attrVal
	from CCM_MAP_SubclientProp a, @CCM_MAP_SubclientProp_Oracle b
	where a.old_componentNameId = b.old_componentNameId
	and a.new_componentNameId = b.new_componentNameId
	and a.attrname = 'Oracle RAC Data Properties'
	and a.attrVal = b.old_attrVal
	END -- Logic to Handle 'Oracle RAC Data Properties'
	----------------------------------------------------------
	--  property with no history stored in table
	----------------------------------------------------------
	--	CV_PROP_FULL_BACKUP_REFTIME		"sys:last full";
	--	CV_PROP_INCR_BACKUP_REFTIME		"sys:last incr";
	--	CV_PROP_DIFF_BACKUP_REFTIME		"sys:last diff";
	--	CV_PROP_FULL_BACKUP_CYCLE_NUM	"sys:full cycle num";
	--	CV_PRE_CMD_CHANGE_TIME			"last pre cmd change"
	--	CV_POST_CMD_CHANGE_TIME			"last post cmd change"
	--	CV_SC_CONTENT_CHANGE_TIME		"last content change"
	--	CV_DATA_ARCH_CHANGE_TIME		"last data arch change"
	--	CV_IDX_ARCH_CHANGE_TIME			"last idx arch change"
	UPDATE	CCM_MAP_SubclientProp SET exist = 1
	FROM	CCM_MAP_SubclientProp a, APP_SubClientProp b
	WHERE	a.new_componentNameId = b.componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.modified = 0 AND b.modified = 0
	AND		(		a.attrName = N'sys:last full'
				or	a.attrName = N'sys:last incr'
				or	a.attrName = N'sys:last diff'
				or	a.attrName = N'sys:full cycle num'
				or	a.attrName = N'last pre cmd change'
				or	a.attrName = N'last post cmd change'
				or	a.attrName = N'last content change'
				or	a.attrName = N'last data arch change'
				or	a.attrName = N'last idx arch change'
			)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_SubclientProp -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	-- If the listed property exists on both source and dest,
	-- then keep the one with higher value
	UPDATE	APP_SubClientProp SET attrVal = b.attrVal
	FROM	APP_SubClientProp a, CCM_MAP_SubclientProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.modified = 0 AND b.modified = 0
	AND		a.attrVal < b.attrVal
	AND		b.exist = 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_SubClientProp -- UPDATE attrVal'
		GOTO CX_ERROR_EXIT
	END
	-- For property with histories kept in database only
	-- Update modified if property was modified on source but not on destination
	UPDATE	APP_SubClientProp SET modified = b.modified
	FROM	APP_SubClientProp a, CCM_MAP_SubclientProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.created = b.created
	AND		a.modified = 0 AND b.modified <> 0
	AND		b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_SubClientProp -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	-- Update the attrVal if source has the latest setting for a property
	UPDATE	APP_SubClientProp SET attrVal = b.attrVal
	FROM	APP_SubClientProp a, CCM_MAP_SubclientProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		a.modified = 0 AND b.modified = 0
	AND		a.created < b.created
	AND		b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_SubClientProp -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SubclientProp SET exist = 1
	FROM	CCM_MAP_SubclientProp a, APP_SubClientProp b
	WHERE	a.new_componentNameId = b.componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		(a.created = b.created OR a.modified = 0 AND b.modified = 0)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_SubclientProp -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO APP_SubClientProp
	SELECT	new_componentNameId, attrName, attrType, attrVal, created, modified, @dummy_ccpId
	FROM	CCM_MAP_SubclientProp
	WHERE	exist = 0
	AND     attrName NOT IN (N'sys:last full', N'sys:last incr', N'sys:last diff', N'Virtual Server SNAP Info') -- All INCR/DIFF are forced to FULL after Merge
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_SubClientProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	--Update new Id
	UPDATE	CCM_MAP_SubclientProp SET new_id = b.id
	FROM	CCM_MAP_SubclientProp a, APP_SubClientProp b
	WHERE	a.new_componentNameId = b.componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		(a.created = b.created OR a.modified = 0 AND b.modified = 0)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_SubclientProp -- UPDATE new_Id'
		GOTO CX_ERROR_EXIT
	END
	-- Reset certain attributes for subclient properties
	UPDATE	APP_SubClientProp SET attrVal = 0
	FROM	APP_SubClientProp a, CCM_MAP_SubclientProp b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.attrName = b.attrName
	AND		a.attrType = b.attrType
	AND		((a.modified = 0 AND b.modified = 0 AND a.created < b.created) OR b.exist = 0)
	AND		b.attrName in ('Associated subclient policy')
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_SubClientProp -- UPDATE attributes'
		GOTO CX_ERROR_EXIT
	END
	-- Delete these properties even for a re-merge, so that all INCR/DIFF are forced to FULL
	-- First set the reason for marking FULL.
	IF OBJECT_ID('tempdb.dbo.#SubClients') IS NOT NULL
		DROP TABLE #SubClients
	CREATE TABLE #SubClients(appId INT)
	INSERT INTO #SubClients
	SELECT DISTINCT A.componentNameId
    FROM APP_SubClientProp A INNER JOIN CCM_MAP_SubclientProp B ON A.componentNameId = B.new_componentNameId
    WHERE B.exist = 1
      AND A.attrName IN (N'sys:last full',N'sys:last incr',N'sys:last diff')
	  AND A.modified = 0
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_SubClientProp -- INSERT #SubClients.'
		GOTO CX_ERROR_EXIT
	END
	UPDATE  APP_SubClientProp
    SET     modified = dbo.GetUnixTime(GETUTCDATE())
    FROM    APP_SubClientProp PROP, #SubClients APP
    WHERE   PROP.ComponentNameId = APP.appId
		AND PROP.attrName = N'Reason last backup time cleared'
		AND PROP.modified = 0
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_SubClientProp -- UPDATE modified for - Reason last backup time cleared'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
    SELECT appId, 'Reason last backup time cleared', 7, 46 /*CV_CLEAR_COMMCELL_MIGRATION*/, dbo.GetUnixTime(GETUTCDATE()), 0, 0
    FROM #SubClients
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_SubClientProp -- INSERT property - Reason last backup time cleared'
		GOTO CX_ERROR_EXIT
	END
    DELETE FROM APP_SubClientProp
    FROM CCM_MAP_SubclientProp b
    WHERE componentNameId = b.new_componentNameId
      AND b.exist = 1
      AND APP_SubClientProp.attrName IN (N'sys:last full',N'sys:last incr',N'sys:last diff')
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_SubClientProp -- DELETE Properties'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_CredentialAssoc
	SET new_entityId = B.new_id
FROM CCM_MAP_CredentialAssoc A INNER JOIN CCM_MAP_Application B ON A.old_entityId = B.old_id AND A.entityType = 7
	WHERE A.new_entityId = 0
	IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_CredentialAssoc -- UPDATE new_entityId'
        GOTO CX_ERROR_EXIT
    END
	INSERT INTO APP_CredentialAssoc
	SELECT A.new_credentialId, A.entityType, A.new_entityId, A.CredAssocGUID
	FROM CCM_MAP_CredentialAssoc A
WHERE A.new_entityId > 0 AND A.entityType = 7
		AND NOT EXISTS(SELECT 1 FROM APP_CredentialAssoc B WHERE B.CredAssocGUID = A.CredAssocGUID)
	IF @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Application -- APP_CredentialAssoc -- INSERT.'
        GOTO CX_ERROR_EXIT
    END
	UPDATE CCM_MAP_CredentialAssoc
	SET new_assocId = B.assocId
	FROM CCM_MAP_CredentialAssoc A INNER JOIN APP_CredentialAssoc B ON B.CredAssocGUID = A.CredAssocGUID
	WHERE A.new_assocId = 0
	IF @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_CredentialAssoc -- UPDATE new_assocId'
        GOTO CX_ERROR_EXIT
    END
	UPDATE APP_SubClientProp
	SET attrVal = CAST(B.new_assocId AS VARCHAR(64))
	FROM CCM_MAP_SubclientProp A
INNER JOIN CCM_MAP_CredentialAssoc B ON A.new_componentNameId = B.new_entityId AND B.entityType = 7 AND A.attrName = 'prepost Credential Assoc Id' AND CAST(B.old_assocId AS VARCHAR(64)) = A.attrVal
		INNER JOIN APP_SubClientProp C ON C.componentNameId = A.new_componentNameId AND A.attrName = C.attrName AND C.modified = 0
	WHERE A.exist = 0
		  AND C.cs_attrName = CHECKSUM(N'prepost Credential Assoc Id')
	IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Application -- APP_SubClientProp -- UPDATE - prepost Credential Assoc Id'
        GOTO CX_ERROR_EXIT
    END
	UPDATE APP_SubClientProp
	SET attrVal = CAST(B.new_assocId AS VARCHAR(64))
	FROM CCM_MAP_SubclientProp A
INNER JOIN CCM_MAP_CredentialAssoc B ON A.new_componentNameId = B.new_entityId AND B.entityType = 7 AND A.attrName = 'UNCPath Credential Assoc Id' AND CAST(B.old_assocId AS VARCHAR(64)) = A.attrVal
		INNER JOIN APP_SubClientProp C ON C.componentNameId = A.new_componentNameId AND A.attrName = C.attrName AND C.modified = 0
	WHERE A.exist = 0
		  AND C.cs_attrName = CHECKSUM(N'UNCPath Credential Assoc Id')
	IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Application -- APP_SubClientProp -- UPDATE - UNCPath Credential Assoc Id'
        GOTO CX_ERROR_EXIT
    END
	---------------------------------------------------------
	-- Merge APP_ScFilterFile table
	INSERT	INTO CCM_MAP_ScFilterFile
	SELECT	a.componentNameId, 0, a.type, a.fileName, a.created, a.modified, 0
FROM	#CCM_App_ScFilterFile a
INNER JOIN #CCM_App_Application b ON a.componentNameId = b.id
	WHERE	b.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ScFilterFile -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ScFilterFile SET new_componentNameId = b.new_id
	FROM	CCM_MAP_ScFilterFile a, CCM_MAP_Application b
	WHERE	a.old_componentNameId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ScFilterFile -- UPDATE new_componentNameId'
		GOTO CX_ERROR_EXIT
	END
	--Documentum App Saves client Id's in fileName column -- Need to map those clientId's in strings
	DECLARE @CCM_Documentum_InstFilterFileOldName     NVARCHAR(1024)
	DECLARE @CCM_Documentum_InstFilterFileNewName     NVARCHAR(1024)
	DECLARE @InstFilterFileName_Temp TABLE (value NVARCHAR(1024))
	DECLARE @Old_ClientId INTEGER
	DECLARE @New_ClientId INTEGER
	DECLARE CCM_Documentum_InstFilterFileNameCursor Cursor LOCAL For
	SELECT DISTINCT fileName FROM CCM_MAP_ScFilterFile
	WHERE type in (16,17) 	-- CV_DOCUMENTUM_FTI_FILTER =16  CV_DOCUMENTUM_SA_FILTER =17
	OPEN CCM_Documentum_InstFilterFileNameCursor
	FETCH NEXT FROM CCM_Documentum_InstFilterFileNameCursor
	INTO @CCM_Documentum_InstFilterFileOldName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE FROM @InstFilterFileName_Temp
		INSERT INTO @InstFilterFileName_Temp
		SELECT VALUE FROM cte_split_inline(@CCM_Documentum_InstFilterFileOldName,'')
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ScFilterFile -- Insert @InstFilterFileName_Temp '
			GOTO CX_ERROR_EXIT
		END
		SET @Old_ClientId = CAST((SELECT TOP(1) VALUE FROM @InstFilterFileName_Temp) AS INTEGER)
		SET @New_ClientId = ISNULL((SELECT TOP(1) new_id FROM CCM_MAP_Client where old_id = @Old_ClientId),0)
		IF (@New_ClientId = 0 AND @Old_ClientId <> 0)
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ScFilterFile -- New ClientId Unknown for Documentum InstFilterFileName'
			GOTO CX_ERROR_EXIT
		END
		UPDATE TOP(1) @InstFilterFileName_Temp SET VALUE = CAST (@New_ClientId AS NVARCHAR)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ScFilterFile -- Update @InstFilterFileName_Temp '
			GOTO CX_ERROR_EXIT
		END
		SET @CCM_Documentum_InstFilterFileNewName = NULL
		SELECT @CCM_Documentum_InstFilterFileNewName = COALESCE(@CCM_Documentum_InstFilterFileNewName+' ','')  + value
		FROM @InstFilterFileName_Temp
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ScFilterFile -- SELECT @CCM_Documentum_InstFilterFileNewName '
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_ScFilterFile SET fileName = @CCM_Documentum_InstFilterFileNewName
		WHERE fileName = @CCM_Documentum_InstFilterFileOldName
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ScFilterFile -- UPDATE CCM_MAP_ScFilterFile '
			GOTO CX_ERROR_EXIT
		END
		FETCH NEXT FROM CCM_Documentum_InstFilterFileNameCursor
		INTO @CCM_Documentum_InstFilterFileOldName
	END
	CLOSE CCM_Documentum_InstFilterFileNameCursor
	DEALLOCATE CCM_Documentum_InstFilterFileNameCursor
	--End of processing fileName for Documentum App
	-- Update the modification time if property was modified on source
	UPDATE	APP_ScFilterFile SET modified = b.modified
	FROM	APP_ScFilterFile a, CCM_MAP_ScFilterFile b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.type = b.type
	AND		a.fileName = b.fileName
	AND		a.created = b.created
	AND		a.modified = 0 AND b.modified <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_ScFilterFile -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	-- Get duplicated property
	-- Property modified on destination won't be overwritten
	UPDATE	CCM_MAP_ScFilterFile SET exist = 1
	FROM	CCM_MAP_ScFilterFile a, APP_ScFilterFile b
	WHERE	a.new_componentNameId = b.componentNameId
	AND		a.type = b.type
	AND		a.fileName = b.fileName
	AND		a.created = b.created
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ScFilterFile -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO APP_ScFilterFile
	SELECT	new_componentNameId, type, fileName, created, modified, @dummy_ccpId
	FROM	CCM_MAP_ScFilterFile
	WHERE	exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_ScFilterFile -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge APP_InstFilterFile table
	INSERT	INTO CCM_MAP_InstFilterFile
	SELECT	componentNameId, 0, type, fileName, created, modified, 0
FROM	#CCM_App_InstFilterFile
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_InstFilterFile -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_InstFilterFile SET new_componentNameId = b.new_id
	FROM	CCM_MAP_InstFilterFile a, CCM_MAP_InstanceName b
	WHERE	a.old_componentNameId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_InstFilterFile -- UPDATE new_componentNameId'
		GOTO CX_ERROR_EXIT
	END
	--Documentum App Saves client Id's in fileName column -- Need to map those clientId's in strings
	--DECLARE @CCM_Documentum_InstFilterFileOldName     NVARCHAR(1024)
	--DECLARE @CCM_Documentum_InstFilterFileNewName     NVARCHAR(1024)
	--DECLARE @InstFilterFileName_Temp TABLE (value NVARCHAR(1024))
	--DECLARE @Old_ClientId INTEGER
	--DECLARE @New_ClientId INTEGER
	DECLARE CCM_Documentum_InstFilterFileNameCursor Cursor LOCAL For
	SELECT DISTINCT fileName FROM CCM_MAP_InstFilterFile
	WHERE type in (16,17) 	-- CV_DOCUMENTUM_FTI_FILTER =16  CV_DOCUMENTUM_SA_FILTER =17
	OPEN CCM_Documentum_InstFilterFileNameCursor
	FETCH NEXT FROM CCM_Documentum_InstFilterFileNameCursor
	INTO @CCM_Documentum_InstFilterFileOldName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE FROM @InstFilterFileName_Temp
		INSERT INTO @InstFilterFileName_Temp
		SELECT VALUE FROM cte_split_inline(@CCM_Documentum_InstFilterFileOldName,'')
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_InstFilterFile -- Insert @InstFilterFileName_Temp '
			GOTO CX_ERROR_EXIT
		END
		SET @Old_ClientId = CAST((SELECT TOP(1) VALUE FROM @InstFilterFileName_Temp) AS INTEGER)
		SET @New_ClientId = ISNULL((SELECT TOP(1) new_id FROM CCM_MAP_Client where old_id = @Old_ClientId),0)
		IF (@New_ClientId = 0 AND @Old_ClientId <> 0)
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_InstFilterFile -- New ClientId Unknown for Documentum InstFilterFileName'
			GOTO CX_ERROR_EXIT
		END
		UPDATE TOP(1) @InstFilterFileName_Temp SET VALUE = CAST (@New_ClientId AS NVARCHAR)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_InstFilterFile -- Update @InstFilterFileName_Temp '
			GOTO CX_ERROR_EXIT
		END
		SET @CCM_Documentum_InstFilterFileNewName = NULL
		SELECT @CCM_Documentum_InstFilterFileNewName = COALESCE(@CCM_Documentum_InstFilterFileNewName+' ','')  + value
		FROM @InstFilterFileName_Temp
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_InstFilterFile -- SELECT @CCM_Documentum_InstFilterFileNewName '
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_InstFilterFile SET fileName = @CCM_Documentum_InstFilterFileNewName
		WHERE fileName = @CCM_Documentum_InstFilterFileOldName
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_InstFilterFile -- UPDATE CCM_MAP_InstFilterFile '
			GOTO CX_ERROR_EXIT
		END
		FETCH NEXT FROM CCM_Documentum_InstFilterFileNameCursor
		INTO @CCM_Documentum_InstFilterFileOldName
	END
	CLOSE CCM_Documentum_InstFilterFileNameCursor
	DEALLOCATE CCM_Documentum_InstFilterFileNameCursor
	--End of processing fileName for Documentum App
	-- Update the modification time if property was modified on source
	UPDATE	APP_InstFilterFile SET modified = b.modified
	FROM	APP_InstFilterFile a, CCM_MAP_InstFilterFile b
	WHERE	a.componentNameId = b.new_componentNameId
	AND		a.type = b.type
	AND		a.fileName = b.fileName
	AND		a.created = b.created
	AND		a.modified = 0 AND b.modified <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_InstFilterFile -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	-- Get duplicated property
	-- Property modified on destination won't be overwritten
	UPDATE	CCM_MAP_InstFilterFile SET exist = 1
	FROM	CCM_MAP_InstFilterFile a, APP_InstFilterFile b
	WHERE	a.new_componentNameId = b.componentNameId
	AND		a.type = b.type
	AND		a.fileName = b.fileName
	AND		a.created = b.created
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_InstFilterFile -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO APP_InstFilterFile
	SELECT	new_componentNameId, type, fileName, created, modified
	FROM	CCM_MAP_InstFilterFile
	WHERE	exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_InstFilterFile -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge APP_ExtendedProperties table
	INSERT	INTO CCM_MAP_AppExtendedProperties
	SELECT	clientId, 0, instance, 0, backupSet, 0, subclientId, 0, appTypeId, attrType, attrName, attrVal, MD5, created, modified, 0
FROM	#CCM_App_ExtendedProperties
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_AppExtendedProperties -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_AppExtendedProperties SET new_clientId = b.new_id
	FROM	CCM_MAP_AppExtendedProperties a, CCM_MAP_Client b
	WHERE	a.old_clientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_AppExtendedProperties -- UPDATE new_clientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_AppExtendedProperties SET new_instance = b.new_id
	FROM	CCM_MAP_AppExtendedProperties a, CCM_MAP_InstanceName b
	WHERE	a.old_instance = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_AppExtendedProperties -- UPDATE new_instance'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_AppExtendedProperties SET new_backupSet = b.new_id
	FROM	CCM_MAP_AppExtendedProperties a, CCM_MAP_BackupSetName b
	WHERE	a.old_backupSet = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_AppExtendedProperties -- UPDATE new_backupSet'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_AppExtendedProperties SET new_subclientId = b.new_id
	FROM	CCM_MAP_AppExtendedProperties a, CCM_MAP_Application b
	WHERE	a.old_subclientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_AppExtendedProperties -- UPDATE new_subclientId'
		GOTO CX_ERROR_EXIT
	END
	-- For property with histories kept in database only
	-- Update modified if property was modified on source but not on destination
	UPDATE	APP_ExtendedProperties SET modified = b.modified
	FROM	APP_ExtendedProperties a, CCM_MAP_AppExtendedProperties b
	WHERE	a.clientId = b.new_clientId
	AND		a.instance = b.new_instance
	AND		a.backupSet = b.new_backupSet
	AND		a.subclientId = b.new_subclientId
	AND		a.appTypeId = b.appTypeId
	AND		a.attrType = b.attrType
	AND		a.attrName = b.attrName
	AND		a.created = b.created
	AND		a.modified = 0 AND b.modified <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_AppExtendedProperties -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	-- Update the attrVal if source has the latest setting for a property
	UPDATE	APP_ExtendedProperties SET attrVal = b.attrVal
	FROM	APP_ExtendedProperties a, CCM_MAP_AppExtendedProperties b
	WHERE	a.clientId = b.new_clientId
	AND		a.instance = b.new_instance
	AND		a.backupSet = b.new_backupSet
	AND		a.subclientId = b.new_subclientId
	AND		a.appTypeId = b.appTypeId
	AND		a.attrType = b.attrType
	AND		a.attrName = b.attrName
	AND		a.modified = 0 AND b.modified = 0
	AND		a.created < b.created
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_ExtendedProperties -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_AppExtendedProperties SET exist = 1
	FROM	CCM_MAP_AppExtendedProperties b, APP_ExtendedProperties a
	WHERE	a.clientId = b.new_clientId
	AND		a.instance = b.new_instance
	AND		a.backupSet = b.new_backupSet
	AND		a.subclientId = b.new_subclientId
	AND		a.appTypeId = b.appTypeId
	AND		a.attrType = b.attrType
	AND		a.attrName = b.attrName
	AND		(a.created = b.created OR a.modified = 0 AND b.modified = 0)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_AppExtendedProperties -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO APP_ExtendedProperties
	SELECT	new_clientId, appTypeId, new_instance, new_backupSet, new_subclientId, attrType, attrName, attrVal, MD5, created, modified, @dummy_ccpId
	FROM	CCM_MAP_AppExtendedProperties
	WHERE	exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_ExtendedProperties -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge archAppCopyAgingRule Table
IF(OBJECT_ID('tempdb..#CCM_archAppCopyAgingRule') IS NOT NULL)
	BEGIN
		INSERT INTO archAppCopyAgingRule
		SELECT B.new_Id, C.new_Id, A.retentionDays, A.fullCycles, A.flags, A.weekStart, A.monthStart, A.yearStart, A.archiverRetDays, A.retentionJobs, A.minutesSinceDayStarts, C.new_archGroupId
FROM #CCM_archAppCopyAgingRule A INNER JOIN CCM_MAP_Application B ON A.appId = B.old_Id
			INNER JOIN CCM_MAP_ArchGroupCopy C ON A.copyId = C.old_Id AND A.archGrpId = C.old_archGroupId
			LEFT OUTER JOIN archAppCopyAgingRule D ON D.appId = B.new_Id AND D.copyId = C.new_Id
		WHERE D.appId IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- archAppCopyAgingRule'
			GOTO CX_ERROR_EXIT
		END
	END
	---------------------------------------------------------
	-- Merge archAppCopyAgingRuleExtended Table
IF(OBJECT_ID('tempdb..#CCM_archAppCopyAgingRuleExtended') IS NOT NULL)
	BEGIN
		INSERT INTO archAppCopyAgingRuleExtended
		SELECT B.new_Id, C.new_Id, A.retentionDays, A.retentionRule, A.GraceDays, A.EveryXHours, C.new_archGroupId
FROM #CCM_archAppCopyAgingRuleExtended A INNER JOIN CCM_MAP_Application B ON A.appId = B.old_Id
			INNER JOIN CCM_MAP_ArchGroupCopy C ON A.copyId = C.old_Id AND A.archGrpId = C.old_archGroupId
			LEFT OUTER JOIN archAppCopyAgingRuleExtended D ON D.appId = B.new_Id AND D.copyId = C.new_Id AND D.retentionRule = A.retentionRule
		WHERE D.appId IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_ArchGroupCopy -- archAppCopyAgingRuleExtended'
			GOTO CX_ERROR_EXIT
		END
	END
	---------------------------------------------------------
	-- Merge ArchPipeConfig Table
	UPDATE ArchPipeConfig
	SET compressWhere = b.compressWhere,
		numNWAgents = b.numNWAgents,
		NWWriteSpeed = b.NWWriteSpeed
from CCM_MAP_Application a, #CCM_ArchPipeConfig b, ArchPipeConfig c
	where a.old_id = b.appNumber
	and a.new_id = c.appNumber
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- ArchPipeConfig'
		GOTO CX_ERROR_EXIT
	END
	insert into ArchPipeConfig
	select a.new_id, b.compressWhere, b.numNWAgents, b.NWWriteSpeed
from CCM_MAP_Application a, #CCM_ArchPipeConfig b
	where a.old_id = b.appNumber
	and a.new_id not in (select appNumber from ArchPipeConfig)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- ArchPipeConfig'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge ArchCopyToApp Table
	-- 	Copy with no subset defined will have no row in archCopyToApp table.
	-- 	Copy with empty subset defined will have a row with clientId = -1.
	-- 	If subset is defined for copy on source and:
	--		a. if copy is new, migrate all subset for migrated clients.
	--			Add "empty subset" for copy if migrated clients are not included in subset.
	--		b. if copy exists on destination and subset is defined on destination,
	--			add subset definition which does not exist yet in destination.
	--			Remove "empty subset" for copy if valid subset defined for copy.
	--	All conditions other than what mentioned will require no subset migration for copy.
	--	A subset definition for a client is considered as exists on destination copy,
	--		if all the following conditions are true:
	--			a. instanceId is 0 on source or destination, or exists on destination
	--			b. backupsetId is 0 on source or destination, or exists on destination
	--			c. subclientId is 0 on source or destination, or exists on destination
	INSERT	INTO CCM_MAP_ArchCopyToApp
	SELECT	DISTINCT copyId, 0, clientId, -1, instanceId, -1,
			backupSetId, -1, subClientId, -1, appTypeId, 0
FROM	#CCM_ArchCopyToApp
	WHERE	copyId in (select old_id from CCM_MAP_ArchGroupCopy)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ArchCopyToApp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchCopyToApp SET new_copyId = b.new_id
	FROM	CCM_MAP_ArchCopyToApp a, CCM_MAP_ArchGroupCopy b
	WHERE	a.old_copyId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ArchCopyToApp -- UPDATE new_copyId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchCopyToApp SET new_clientId = b.new_id
	FROM	CCM_MAP_ArchCopyToApp a, CCM_MAP_Client b
	WHERE	a.old_clientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ArchCopyToApp -- UPDATE new_clientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchCopyToApp SET new_instanceId = b.new_id
	FROM	CCM_MAP_ArchCopyToApp a, CCM_MAP_InstanceName b
	WHERE	a.old_instanceId = b.old_id AND a.new_clientId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ArchCopyToApp -- UPDATE new_instanceId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchCopyToApp SET new_backupsetId = b.new_id
	FROM	CCM_MAP_ArchCopyToApp a, CCM_MAP_BackupSetName b
	WHERE	a.old_backupsetId = b.old_id AND a.new_clientId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ArchCopyToApp -- UPDATE new_backupsetId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchCopyToApp SET new_subclientId = b.new_id
	FROM	CCM_MAP_ArchCopyToApp a, CCM_MAP_Application b
	WHERE	a.old_subclientId = b.old_id AND a.new_clientId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ArchCopyToApp -- UPDATE new_subclientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ArchCopyToApp SET exist = 1
	FROM	CCM_MAP_ArchCopyToApp a, ArchCopyToApp b
	WHERE	a.new_copyId = b.copyId
	AND		a.new_clientId = b.clientId
	AND		(a.new_instanceId = b.instanceId or a.old_instanceId = 0 or b.instanceId = 0)
	AND		(a.new_backupsetId = b.backupsetId or a.old_backupsetid = 0 or b.backupsetId = 0)
	AND		(a.new_subclientId = b.subclientId or a.old_subclientid = 0 or b.subclientId = 0)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ArchCopyToApp -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	-- If subset_source = 0, copy has no subset defined on source
	-- If subset_source = -1, copy has empty subset defined on source
	-- If subset_source > 0, copy has subset defined for client on source
	UPDATE CCM_MAP_ArchGroupCopy SET subset_source = b.old_clientId
	FROM CCM_MAP_ArchGroupCopy a, CCM_MAP_ArchCopyToApp b
	WHERE a.old_id = b.old_copyId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ArchGroupCopy -- UPDATE subset_source'
		GOTO CX_ERROR_EXIT
	END
	-- If subset_dest = 0, copy has no subset defined on destination
	-- If subset_dest = -1, copy has empty subset defined on destination
	-- If subset_dest > 0, copy has subset defined for client on destination
	UPDATE CCM_MAP_ArchGroupCopy SET subset_dest = b.clientId
	FROM CCM_MAP_ArchGroupCopy a, ArchCopyToApp b
	WHERE a.new_Id = b.copyId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ArchGroupCopy -- UPDATE subset_dest'
		GOTO CX_ERROR_EXIT
	END
	DECLARE	@new_copyId integer
	-- We only care about copy with subset defined on source
	-- And copy is either new or has subset defined on destination
	DECLARE	CUR_copyToApp cursor LOCAL for
		SELECT	new_id
		FROM	CCM_MAP_ArchGroupCopy
		WHERE	subset_source <> 0
		AND		(exist = 0 or exist = 1 and subset_dest <> 0)
	OPEN CUR_copyToApp
	FETCH CUR_copyToApp into @new_copyId
	while @@FETCH_STATUS = 0
	BEGIN
			-- Merge subset definition not exist on destination database
			INSERT	INTO ArchCopyToApp
			SELECT	new_copyId, new_clientId, appTypeId, new_instanceId, new_backupsetId, new_subclientId, 0, 0, 0
			FROM	CCM_MAP_ArchCopyToApp
			WHERE	new_copyId = @new_copyId
			AND		new_clientId > 0
			AND		new_instanceId >= 0
			AND		new_backupsetId >= 0
			AND		new_subclientId >= 0
			AND		exist = 0
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Application -- ArchCopyToApp -- INSERT subset'
				GOTO CX_ERROR_EXIT
			END
			-- Remove empty subset from destination if there are clients are in subset
			IF		EXISTS (SELECT * FROM ArchCopyToApp WHERE copyId = @new_copyId AND clientId <> -1)
			BEGIN
					DELETE	FROM ArchCopyToApp
					WHERE	copyId = @new_copyId
					AND		clientId = -1
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_Application -- ArchCopyToApp -- DELETE empty subset'
						GOTO CX_ERROR_EXIT
					END
			END
			-- Add empty subset to destination for new copy if migrated clients are not in subset
			IF		NOT EXISTS (SELECT * FROM ArchCopyToApp WHERE copyId = @new_copyId)
			BEGIN
					INSERT	INTO ArchCopyToApp
					SELECT	@new_copyId, -1, -1, -1, -1, -1, -1, -1, -1
					IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_Application -- ArchCopyToApp -- INSERT empty subset'
						GOTO CX_ERROR_EXIT
					END
			END
			FETCH CUR_copyToApp into @new_copyId
	END
	---------------------------------------------------------
	CLOSE CUR_copyToApp
	DEALLOCATE CUR_copyToApp
    INSERT	INTO edcClientNameMap
    SELECT	*
FROM	#CCM_edcClientNameMap N
	WHERE	NOT EXISTS(	SELECT	*
						FROM	edcClientNameMap E
						WHERE		N.exServerAliasName = E.exServerAliasName
								AND N.gxMachineName = E.gxMachineName
								AND N.gxMachineHostName = E.gxMachineHostName )
	----------------------------------------------------------
	--Merge PatchUpdateAgentInfo table
IF EXISTS (SELECT * FROM #CCM_PatchUpdateAgentInfo WHERE ClientId not in (SELECT old_id from CCM_Map_Client where new_id <> 0))
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_PatchUpdateAgentInfo -- New Client Id not found'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO PatchUpdateAgentInfo (clientId, isLocalDrive, cachePath, username, passwd, isEnabled, autoSyncWithCS, inSyncWithCS, isDeleted, packageStatus, SWSharePath)
	SELECT b.new_id, a.isLocalDrive, a.cachePath, a.username, a.passwd, a.isEnabled, a.autoSyncWithCS, a.inSyncWithCS, a.isDeleted, a.packageStatus, a.SWSharePath
FROM #CCM_PatchUpdateAgentInfo a inner join CCM_Map_Client b ON a.ClientId = b.old_id
	left outer join PatchUpdateAgentInfo c ON b.new_id = c.clientId
	WHERE c.clientId is null
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- PatchUpdateAgentInfo -- Insert'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------
	--Merge PatchMultiCache table
IF EXISTS (SELECT 1 FROM #CCM_PatchMultiCache WHERE ClientId not in (SELECT old_id from CCM_Map_Client where new_id <> 0))
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_PatchMultiCache -- New Client Id not found'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO PatchMultiCache
	SELECT b.new_id, a.ReleaseId, a.OSId, a.HighestSP, a.AddUpdates, a.IsSPValid , a.SPVersionId
FROM #CCM_PatchMultiCache a inner join CCM_Map_Client b ON a.ClientId = b.old_id
	left outer join PatchMultiCache c ON b.new_id = c.clientId AND a.ReleaseId = c.ReleaseId AND a.OSId = c.OSId
	WHERE c.ClientId is null
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- PatchMultiCache -- Insert'
	END
	----------------------------------------------------------
	/*
	--Merging App_EntityMapping
	DECLARE @SourceCCNewId INT = (SELECT new_id FROM CCM_MAP_CommCell WHERE old_id = 2)
	--Map all captured clients
	INSERT INTO App_EntityMapping
SELECT	DISTINCT a.new_Id,3, @SourceCCNewId, a.old_Id
	FROM 	CCM_MAP_Client a
			LEFT OUTER JOIN App_EntityMapping b
ON a.new_Id = b.EntityId AND b.EntityType = 3
			AND b.OrigCCId = @SourceCCNewId AND a.old_Id = b.EntityIdOnOrigCC
	WHERE 	b.EntityId IS NULL
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- App_EntityMapping -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO App_EntityMapping
SELECT	DISTINCT b.new_Id, 3, c.new_id, a.EntityIdOnOrigCC
FROM 	#CCM_App_EntityMapping a
INNER JOIN CCM_MAP_Client b ON a.EntityId = b.old_id AND a.EntityType = 3
			INNER JOIN CCM_MAP_CommCell c ON a.OrigCCId = c.old_id
LEFT OUTER JOIN App_EntityMapping d ON b.new_Id = d.EntityId AND d.EntityType = 3
				AND c.new_id = d.OrigCCId AND a.EntityIdOnOrigCC = d.EntityIdOnOrigCC
	WHERE 	d.EntityId IS NULL
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- App_EntityMapping -- INSERT Captured Entries'
		GOTO CX_ERROR_EXIT
	END
	*/
	-------------------------------------------------------------
IF(OBJECT_ID('TEMPDB..#CCM_GRC_History') IS NOT NULL)
	BEGIN
		-- Merge GRC_History table
		DECLARE @SourceCCNewId INT = (SELECT new_id FROM CCM_MAP_CommCell WHERE old_id = 2)
		INSERT INTO GRC_History
SELECT	DISTINCT a.new_Id,3, 2 /* destCCid */, @SourceCCNewId, a.old_Id, @jobId, dbo.GetUnixTime(GETUTCDATE())
		FROM 	CCM_MAP_Client a
				LEFT OUTER JOIN GRC_History b
ON a.new_Id = b.EntityId AND b.EntityType = 3 AND b.DestCCID = 2
		WHERE 	b.EntityId IS NULL
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- GRC_History -- INSERT Migrated entities.'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO GRC_History
SELECT	b.new_Id, 3, c.new_id, e.new_Id, a.EntityIdOnSourceCC, a.ImportJobIdOnDestCC, a.ImportTime
FROM 	#CCM_GRC_History a
INNER JOIN CCM_MAP_Client b ON a.EntityId = b.old_id AND a.EntityType = 3
				INNER JOIN CCM_MAP_CommCell c ON a.DestCCID = c.old_id
				INNER JOIN CCM_MAP_CommCell e ON e.old_id = a.SourceCCId
LEFT OUTER JOIN GRC_History d ON b.new_Id = d.EntityId AND d.EntityType = 3 AND c.new_id = d.DestCCID
		WHERE 	d.EntityId IS NULL
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Application -- GRC_History -- INSERT Captured GRC_History Entries.'
			GOTO CX_ERROR_EXIT
		END
	END
	----------------------------------------------------------
	-- Merge APP_ComponentProp  --TODO: Migrating only CV_COMPONENT_TYPE_EXMB and CV_COMPONENT_TYPE_LN_DOC properties need to migrated other properties
	INSERT INTO CCM_MAP_ComponentProp
	SELECT componentId, 0, componentType, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified, 0
FROM #CCM_App_ComponentProp
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ComponentProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ComponentProp
	SET	new_componentId = b.new_id
	FROM CCM_MAP_ComponentProp a, CCM_MAP_SubClientProp b
	WHERE a.old_componentId = b.old_Id
AND componentType IN (7, 9)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ComponentProp -- UPDATE new_componentId'
		GOTO CX_ERROR_EXIT
	END
	-- For property with histories kept in database only
	-- Update modified if property was modified on source but not on destination
	UPDATE	APP_ComponentProp SET modified = b.modified
	FROM	APP_ComponentProp a, CCM_MAP_ComponentProp b
	WHERE	a.componentId = b.new_componentId
	AND		a.componentType = b.componentType
	AND		a.propertyTypeId = b.propertyTypeId
	AND 	a.dataType = b.dataType
	AND		a.created = b.created
	AND		a.modified = 0 AND b.modified <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_ComponentProp -- UPDATE modified'
		GOTO CX_ERROR_EXIT
	END
	-- Update the stringVal if source has the latest setting for a property
	UPDATE	APP_ComponentProp SET stringVal = b.stringVal
	FROM	APP_ComponentProp a, CCM_MAP_ComponentProp b
	WHERE	a.componentId = b.new_componentId
	AND		a.componentType = b.componentType
	AND		a.propertyTypeId = b.propertyTypeId
	AND 	a.dataType = b.dataType
	AND		a.modified = 0 AND b.modified = 0
	AND		a.created < b.created
AND     a.dataType = 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_ComponentProp -- UPDATE stringVal'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_ComponentProp SET exist = 1
	FROM	CCM_MAP_ComponentProp a, APP_ComponentProp b
	WHERE	a.new_componentId = b.componentId
	AND		a.componentType = b.componentType
	AND		a.propertyTypeId = b.propertyTypeId
	AND 	a.dataType = b.dataType
	AND		(a.created = b.created OR a.modified = 0 AND b.modified = 0)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- CCM_MAP_ComponentProp -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO APP_ComponentProp
	SELECT	componentType, new_componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified
	FROM	CCM_MAP_ComponentProp
	WHERE	exist = 0 and new_componentId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Application -- APP_ComponentProp -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
    -- The cursor might not exist for some initial errors in this stored procedure.
    IF (Cursor_Status('LOCAL', 'CUR_copyToApp') >= -1)
	BEGIN
		CLOSE CUR_copyToApp
		DEALLOCATE CUR_copyToApp
	END
	IF (Cursor_Status('LOCAL', 'CCM_MAP_SubclientProp_OracleCursor') >= -1)
	BEGIN
		CLOSE CCM_MAP_SubclientProp_OracleCursor
		DEALLOCATE CCM_MAP_SubclientProp_OracleCursor
	END
	IF (Cursor_Status('LOCAL', 'AttrVal_Plus_Cursor') >= -1)
	BEGIN
		CLOSE AttrVal_Plus_Cursor
		DEALLOCATE AttrVal_Plus_Cursor
	END
	IF (Cursor_Status('LOCAL', 'CCM_Documentum_InstFilterFileNameCursor') >= -1)
	BEGIN
		CLOSE CCM_Documentum_InstFilterFileNameCursor
		DEALLOCATE CCM_Documentum_InstFilterFileNameCursor
	END
	IF (Cursor_Status('LOCAL', 'CCM_MAP_SubclientPropDocumentumStreamsCursor') >= -1)
	BEGIN
		CLOSE CCM_MAP_SubclientPropDocumentumStreamsCursor
		DEALLOCATE CCM_MAP_SubclientPropDocumentumStreamsCursor
	END
	RETURN (-1)
	---------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_Application_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Application_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Application_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Application_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_Application_from_XML',  'v1.2.116.5.6.1', 'CCM_Merge_Application_from_XML', 'v1.2.116.5.6.1')
GO

