

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_GetAnswer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCM_GetAnswer.sp,v $ $Id: CCM_GetAnswer.sp,v 1.5 2011/08/18 15:53:18 pkrishnan Exp $";
-- =============================================
-- Author:		Krithika Chandrasekaran
-- Create date: 08/19/2009
-- Description:	Get the CCM answer file details.
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_GetAnswer <<<'

IF EXISTS (select * from sysobjects where name='CCM_GetAnswer')
	drop procedure CCM_GetAnswer
IF EXISTS (select * from GxQscripts where name='CCM_GetAnswer')
	delete from GxQscripts where name = 'CCM_GetAnswer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_GetAnswer')
	delete from GXDBVersions where aliasname = 'CCM_GetAnswer'
GO
print '... Creating Procedure: CCM_GetAnswer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_GetAnswer
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @dummyxml XML
AS
BEGIN
	DECLARE @xmlText xml
	DECLARE @MediaTable table
	(
		id int,
		name nvarchar(1024),
		libId int,
		libName nvarchar(1024),
		mediaAgentId int,
		mediaAgentName nvarchar(1024),
		drivePoolId int,
		drivePoolName nvarchar(1024),
		spareGroupId int,
		spareGroupName nvarchar(1024)
	)
	DECLARE @MountPathTable table
	(
		sourceCommcellId int,
		sourceCSGUID nvarchar(max),
		sourceCommCellName nvarchar(1024),
		mediaAgentId int,
		mediaAgentName nvarchar(1024),
		sourceMountPathId int,
		sourceMountPathName  nvarchar(1024),
		libraryId int,
		destLibraryName nvarchar(1024),
		destinationMountPath nvarchar(1024),
		userName nvarchar(1024),
		password nvarchar(1024),
		isEditable int,
		sourceMountPathType int
	)
	declare @ClientAnswerTable table
	(
		sourceCommcellId int,
		sourceCSGUID nvarchar(max),
		sourceCommCellName nvarchar(1024),
		oldClientName nvarchar(1024),
		oldClientHostName nvarchar(1024),
		newClientName nvarchar(1024),
		newClientHostName nvarchar(1024)
	);
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	declare @ClientCCIDTable table
	(
		ccID int,
		ccName nvarchar(1024),
		csGUID nvarchar(max)
	);
	declare @CCIDTable table
	(
		ccID int,
		ccName nvarchar(1024),
		csGUID nvarchar(max)
	);
	INSERT @MediaTable
	SELECT MMT.MediaTypeId, MMT.MediaTypeName,LIB.LibraryId,LIB.AliasName ,client.id,client.name,drive.DrivePoolId,drive.DrivePoolName,spareGroup.SpareGroupId,spareGroup.SpareGroupName
	FROM CCMMediaTypeAnswers AS CCM, MMMediaType AS MMT,MMLibrary AS LIB,MMHost AS host,APP_Client AS client,MMDrivePool AS drive,MMSpareGroup AS spareGroup
	WHERE CCM.MediaTypeId = MMT.MediaTypeId and CCM.libraryId=LIB.LibraryId and host.ClientId=client.id and CCM.mediaAgentId=host.ClientId and drive.DrivePoolId=CCM.DrivePoolId and spareGroup.SpareGroupId=CCM.SparePoolGroupId
	INSERT @MountPathTable
	SELECT	MOUNT.SourceCommCellId,MOUNT.SourceCommCellGUID,MOUNT.SourceCommCellNAme,MOUNT.SourceMediaAgentId,
			MOUNT.SourceMediaAgentName,MOUNT.SourceMountPathId,MOUNT.SourceMountPathName,Lib.LibraryId,Lib.AliasName,MOUNT.TargetMountPathName,MOUNT.TargetMountPathUserName,MOUNT.TargetMountPathPassword,MOUNT.allowEdit, MOUNT.MountPathType
	FROM CCMMountPathAnswers AS MOUNT ,MMLibrary as Lib
	where MOUNT.TargetLibraryId=Lib.LibraryId
	INSERT @CCIDTable
	SELECT DISTINCT SourceCommCellId, SourceCommCellName, SourceCommCellGUID
	FROM CCMMountPathAnswers
	INSERT @ClientCCIDTable
	SELECT DISTINCT SourceCommCellId, SourceCommCellName, SourceCommCellGUID
	FROM CCMClientAnswers
	INSERT @ClientAnswerTable
	SELECT ClientAns.SourceCommCellId,ClientAns.SourceCommCellGUID,ClientAns.SourceCommCellName,ClientAns.OldClientName,
	ClientAns.OldClientHostName,ClientAns.NewClientName,ClientAns.NewClientHostName
	FROM CCMClientAnswers ClientAns
	SET @xmlText =(SELECT
						 (SELECT
								  (SELECT
								   T.id AS '@mediaTypeId' , T.name AS '@mediaTypeName'
								   FOR XML PATH ('mediaType'),TYPE
								   ),
								  (SELECT
									T.libId AS '@libraryId' , T.libName AS '@libraryName'
									where T.libId>0
								   FOR XML PATH ('library'),TYPE
								   ),
								  (SELECT
								   T.mediaAgentId AS '@mediaAgentId' , T.mediaAgentName AS '@mediaAgentName'
								   where T.mediaAgentId>1
								   FOR XML PATH ('mediaAgent'),TYPE
								   ),
								  (SELECT
								  T.drivePoolId AS '@drivePoolId' , T.drivePoolName AS '@drivePoolName'
								  where T.drivePoolId>0
								   FOR XML PATH ('drivePool'),TYPE
								   ),
									(SELECT
									   T.spareGroupId AS '@spareMediaGroupId' , T.spareGroupName AS '@spareMediaGroupName'
									 where T.spareGroupId>0
								   FOR XML PATH ('spareGroup'),TYPE
								   )
								FROM @MediaTable T
								  where T.id>0 Order By T.id
								FOR XML PATH('mediaTypeMappings'),TYPE
					   ),
					   ( SELECT
						 ( SELECT
						   T.ccID AS '@commCellId' , T.ccName AS '@commCellName' , T.csGUID AS '@csGUID'
						   FOR XML PATH ('sourceCommcell'),TYPE
						  ),
						  (SELECT
							   M.destinationMountPath as '@destinationMountPath',M.userName as '@username', M.password as '@password',M.isEditable as '@isEditable',M.sourceMountPathType as '@sourceMountPathType',
							  (SELECT
							   M.mediaAgentId AS '@mediaAgentId' , M.mediaAgentName AS '@mediaAgentName'
							   FOR XML PATH ('mediaAgent'),TYPE
							   ),
							  (SELECT
							   M.sourceMountPathId AS '@mountPathId' , M.sourceMountPathName AS '@mountPathName'
							   FOR XML PATH ('sourceMountPath'),TYPE
							  ),
							  (SELECT
							   M.libraryId AS '@libraryId' , M.destLibraryName AS '@libraryName'
								where M.libraryId>0
							   FOR XML PATH ('destinationLibrary'),TYPE
							  )
							  FROM @MountPathTable M
							  Where M.sourceCSGUID = T.csGUID  AND M.mediaAgentId > 1 and M.sourceMountPathId > 0
							  FOR XML PAth('mountPaths'), TYPE
						   )
						   FROM @CCIDTable AS T
						   ORDER BY T.ccID
						   FOR XML PATH('mountPathMap') ,TYPE
						),
						( SELECT
						  ( SELECT
						   T.ccID AS '@commCellId' , T.ccName AS '@commCellName' , T.csGUID AS '@csGUID'
						   FOR XML PATH ('sourceCommcell'),TYPE
						   ),
						  (SELECT
							   M.oldClientName as '@oldClientName',M.oldClientHostName as '@oldClientHostName', M.newClientName as '@newClientName',M.newClientHostName  as '@newClientHostName'
							  FROM @ClientAnswerTable M
							  Where M.sourceCSGUID = T.csGUID
							  FOR XML PAth('clientAnswers'), TYPE
						   )
						   FROM @ClientCCIDTable AS T
						   ORDER BY T.ccID
						   FOR XML PATH('clientAnswerMap') ,TYPE
						)
						FOR XML PATH('TMMsg_CCMAnswerFileOptionsResp'))
	SELECT @xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_GetAnswer')
	delete from GxQscripts where name = 'CCM_GetAnswer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_GetAnswer')
	delete from GXDBVersions where aliasname = 'CCM_GetAnswer'
GO

insert into GXDBVersions values(2, 'CCM_GetAnswer',  '00010005000000000000', 'CCM_GetAnswer', '00010005000000000000')
GO

