

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_GRCPopulateJobsToCapture.sp] ---------- 

--  +===================================================================================================+
--  | Stored Procedure: Populate the list of job/data to be captured before capaturing data.
--  +===================================================================================================+
-- $Id: CCM_GRCPopulateJobsToCapture.sp,v 1.8.48.6 2018/03/22 13:08:08 kbora Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_GRCPopulateJobsToCapture <<<'

IF EXISTS (select * from sysobjects where name='CCM_GRCPopulateJobsToCapture')
	drop procedure CCM_GRCPopulateJobsToCapture
IF EXISTS (select * from GxQscripts where name='CCM_GRCPopulateJobsToCapture')
	delete from GxQscripts where name = 'CCM_GRCPopulateJobsToCapture'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_GRCPopulateJobsToCapture')
	delete from GXDBVersions where aliasname = 'CCM_GRCPopulateJobsToCapture'
GO
print '... Creating Procedure: CCM_GRCPopulateJobsToCapture'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_GRCPopulateJobsToCapture
  @i_GrcCommCellGUID varchar(36),
  @ccmParamFlags integer,
  @i_jobId integer,
  @time_from integer,
  @errorString varchar(1024) OUTPUT
AS
SET NOCOUNT ON
DECLARE @errorCode int
SET @errorCode = -1
SET @errorString = 'ERROR: GENERAL ERROR!'
DECLARE @currentEndTrackId bigint = 0
DECLARE @currentEndTrackTime int = 0
DECLARE @GrcCommCellId 	int
SELECT @GrcCommCellId = id FROM App_CommCell WHERE csGUID = @i_GrcCommCellGUID
-- Populate new subclients in subclient tracking table with tracking info 0.
INSERT 	INTO GRC_SubclientTrackingStats
SELECT	@GrcCommCellId, a.id, 0, @time_from
FROM 	Commserv_Capture..CCM_App_Application a
		LEFT OUTER JOIN GRC_SubclientTrackingStats b ON a.id = b.subclientId AND b.commcellId = @GrcCommCellId
WHERE	b.subclientId IS NULL
SET @errorCode = @@ERROR
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Insert -- GRC_SubclientTrackingStats -- Returned Error Code: ' + cast(@errorCode as varchar(10))
	GOTO CX_EXIT
END
-- Populate startTracking info for each subclient for this job.
INSERT 	INTO GRC_SubclientTrackingInfo
SELECT	@i_jobId, 2 /*job commcellId*/, a.id, c.trackingId, c.trackingTime
FROM	Commserv_Capture..CCM_App_Application a
		INNER JOIN GRC_SubclientTrackingStats c ON a.id = c.subclientId AND c.commcellId = @GrcCommCellId
		LEFT OUTER JOIN GRC_SubclientTrackingInfo b ON b.jobId = @i_jobId AND b.subclientId = a.id
WHERE	b.subclientId IS NULL
SET @errorCode = @@ERROR
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Insert -- GRC_SubclientTrackingInfo -- Returned Error Code: ' + cast(@errorCode as varchar(10))
	GOTO CX_EXIT
END
/*
If not incremental then
the start trackid and time are 0
and end track id and end track time are the maximum in the track table now, which will go into state file
And we would not populate the #GRC_JOBS_TO_CAPTURE table so capture will be a full capture
*/
IF (0 = (@ccmParamFlags & 4))
BEGIN
	--Set start tracking info to 0 so that full export happens
	UPDATE	GRC_SubclientTrackingInfo
	SET		trackingId 		= 0,
			trackingTime	= @time_from
	WHERE	jobId = @i_jobId AND subclientId > 0
SET @errorCode = 0
	SET @errorString = 'NO ERROR'
	GOTO CX_EXIT
END
-- Get the currentEndTrackId from GRC_SubClientTrackingInfo table. We set the current end track info in this table with subclientId = 0 while populating the state info in DB.
SET 	@currentEndTrackId = ISNULL((SELECT trackingId FROM GRC_SubclientTrackingInfo WHERE jobId = @i_jobId AND subclientId = 0), 0)
-- If populate state file fails for some reason then currEndTrack info will be 0 so populate the currentEndTrak info.
IF @currentEndTrackId = 0
BEGIN
	-- Get current end trackId and time.
	SET @currentEndTrackId = ISNULL((SELECT max(trackingId) FROM GRCJMJobDataStatsTracking WITH (NOLOCK)),0)
	SET @currentEndTrackTime = ISNULL((SELECT createdTime FROM GRCJMJobDataStatsTracking WITH (NOLOCK) WHERE trackingId = @currentEndTrackId), dbo.GetUnixTime(getutcdate()))
	-- Update current end trackid and time in GRC_SubclientTrackingInfo table
	-- SubclientId = 0 represents the current end tracking info. End traking info is same for all the subclients captured in a job.
	IF NOT EXISTS(SELECT 1 FROM GRC_SubclientTrackingInfo WHERE jobId = @i_jobId AND subclientId = 0)
	BEGIN
		INSERT INTO GRC_SubclientTrackingInfo
		VALUES ( @i_jobId, 2 /*job commcellId*/, 0 /*subclientId*/, @currentEndTrackId, @currentEndTrackTime )
	END
	ELSE
	BEGIN
		UPDATE	GRC_SubclientTrackingInfo
		SET		trackingId = @currentEndTrackId,
				trackingTime = @currentEndTrackTime
		WHERE	jobId = @i_jobId AND subclientId = 0
	END
END
--Check if there any status changes happened after last export, if yes then get the list of jobs who's status changed.
IF EXISTS(SELECT * FROM GRC_SubclientTrackingInfo WHERE jobId = @i_jobId AND subclientId > 0 AND @currentEndTrackId > trackingId)
BEGIN
	/*
	Gather the list of jobs that became available and also that status change is the latest status change of that job
	*/
	/* This table will be created in caller of this proc
	IF OBJECT_ID('tempdb..#GRC_JOBS_TO_CAPTURE') IS NOT NULL DROP TABLE #GRC_JOBS_TO_CAPTURE
	CREATE TABLE #GRC_JOBS_TO_CAPTURE
    (
		jobId int,
		commcellId int,
		copyId smallint,
		dataType tinyint
    )
    CREATE INDEX GRC_JOBS_TO_CAPTURE_Idx ON #GRC_JOBS_TO_CAPTURE(jobId,commcellId,copyId,datatype)
	*/
	IF OBJECT_ID('tempdb.dbo.#GRCJMJobDataStatsTracking') IS NOT NULL DROP TABLE #GRCJMJobDataStatsTracking
		CREATE TABLE #GRCJMJobDataStatsTracking
		(
			trackingId		BIGINT,
			PRIMARY KEY (trackingId)
		)
	INSERT INTO #GRCJMJobDataStatsTracking
	SELECT	MAX(T.trackingId)
	FROM	GRCJMJobDataStatsTracking T WITH (NOLOCK)
			INNER JOIN JMJobDataStats C WITH (READUNCOMMITTED) ON T.jobId = C.jobId AND T.commcellId = C.commcellId AND T.copyId = C.archGrpCopyId AND T.dataType = C.dataType
			INNER JOIN GRC_SubclientTrackingInfo E ON C.appId = E.subclientId AND E.jobId = @i_jobId AND E.subclientId > 0
	WHERE 	T.trackingId > E.trackingId AND T.trackingId <= @currentEndTrackId
AND statusChange <> 6 --If any other status change happened after GRC_JOB_STATUS_CHANGE_AVAILABLE other than GRC_JOB_STATUS_CHANGE_MISC we need not capture as other status changes mean the job is deleted
	GROUP BY T.jobId, T.commcellId, T.copyId, T.dataType
	--Get the list of jobs created after last export
	INSERT	INTO #GRC_JOBS_TO_CAPTURE
	SELECT	distinct B.jobId, B.commcellId, B.copyId, B.dataType
	FROM	#GRCJMJobDataStatsTracking A
			INNER JOIN GRCJMJobDataStatsTracking B WITH (NOLOCK) ON A.trackingId = B.trackingId
WHERE	B.statusChange = 1
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	BEGIN
		SET @errorString = 'Insert -- GRC_JOBS_TO_CAPTURE -- Returned Error Code: ' + cast(@errorCode as varchar(10))
		GOTO CX_EXIT
	END
	-- INSERT	INTO #GRC_JOBS_TO_CAPTURE
	-- SELECT	distinct 0, 0, C.copyId, 0
	-- FROM	Commserv_Capture..CCM_App_Application A
			-- INNER JOIN GRC_SubclientTrackingInfo B ON A.id = B.subclientId AND B.jobId = @i_jobId AND B.subclientId > 0
			-- INNER JOIN GRCJMJobDataStatsTracking C WITH (NOLOCK) ON B.trackingId > C.trackingId AND C.trackingId <= @currentEndTrackId AND C.statusChange = GRC_JOB_STATUS_CHANGE_AVAILABLE
	-- SET @errorCode = @@ERROR
	-- IF @errorCode <> 0
	-- BEGIN
		-- SET @errorString = 'Insert -- GRC_JOBS_TO_CAPTURE -- Returned Error Code: ' + cast(@errorCode as varchar(10))
		-- GOTO CX_EXIT
	-- END
	/*This is the set of jobs for which disabled, manualRetentionEndTime and retentionFlags so we'll include these jobs also so table will be updated in desination CS*/
	INSERT	INTO #GRC_JOBS_TO_CAPTURE
	SELECT 	distinct JDS.jobId, JDS.commcellId, JDS.archGrpCopyId, JDS.dataType
	FROM 	JMJobDataStats JDS WITH (NOLOCK)
			inner join GRCJMJobDataStatsTracking JDSTrack WITH (NOLOCK)
			ON JDS.jobId = JDSTrack.jobId AND JDS.commcellId = JDSTrack.commcellId AND JDS.archGrpCopyId = JDSTrack.copyId AND JDS.dataType = JDSTrack.dataType
AND JDSTrack.statusChange = 6 AND JDSTrack.trackingId <= @currentEndTrackId  AND JDS.status = 100
			INNER JOIN Commserv_Capture..CCM_App_Application D ON JDS.appId = D.id
			INNER JOIN GRC_SubclientTrackingInfo E ON D.id = E.subclientId AND E.jobId = @i_jobId AND E.subclientId > 0 AND JDSTrack.trackingId > E.trackingId
			left outer join #GRC_JOBS_TO_CAPTURE A ON A.jobId = JDS.jobId AND A.commcellId = JDS.commcellId AND A.copyId = JDS.archGrpCopyId AND A.dataType = JDS.dataType
	WHERE 	A.jobId is null
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	BEGIN
		SET @errorString = 'Insert -- GRC_JOBS_TO_CAPTURE -- Returned Error Code: ' + cast(@errorCode as varchar(10))
		GOTO CX_EXIT
	END
END
SET @errorCode = 0
SET @errorString = 'NO ERROR'
CX_EXIT:
IF @errorCode <> 0
BEGIN
	IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#GRC_JOBS_TO_CAPTURE]') )
		IF NOT EXISTS (SELECT * FROM #GRC_JOBS_TO_CAPTURE)
			DROP TABLE #GRC_JOBS_TO_CAPTURE
END
RETURN @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_GRCPopulateJobsToCapture')
	delete from GxQscripts where name = 'CCM_GRCPopulateJobsToCapture'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_GRCPopulateJobsToCapture')
	delete from GXDBVersions where aliasname = 'CCM_GRCPopulateJobsToCapture'
GO

insert into GXDBVersions values(2, 'CCM_GRCPopulateJobsToCapture',  '00010008004800060000', 'CCM_GRCPopulateJobsToCapture', '00010008004800060000')
GO

