

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_GRCGetRemoteCommservList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCM_GRCGetRemoteCommservList.sp,v $ $Id: CCM_GRCGetRemoteCommservList.sp,v 1.4.88.1 2018/03/20 00:47:46 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   CCM_GRCGetRemoteCommservList   - returns remote cell info
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_GRCGetRemoteCommservList <<<'

IF EXISTS (select * from sysobjects where name='CCM_GRCGetRemoteCommservList')
	drop procedure CCM_GRCGetRemoteCommservList
IF EXISTS (select * from GxQscripts where name='CCM_GRCGetRemoteCommservList')
	delete from GxQscripts where name = 'CCM_GRCGetRemoteCommservList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_GRCGetRemoteCommservList')
	delete from GXDBVersions where aliasname = 'CCM_GRCGetRemoteCommservList'
GO
print '... Creating Procedure: CCM_GRCGetRemoteCommservList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_GRCGetRemoteCommservList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
  DECLARE @o_CCClientName varchar(255)
  DECLARE @o_InterfaceName varchar(255)
  DECLARE @o_DisplayName nvarchar(510)
  DECLARE @o_ChildId integer
IF OBJECT_ID('tempdb..#clientInfoTbl') IS NOT NULL DROP TABLE #clientInfoTbl
CREATE TABLE #clientInfoTbl (
								clientName		varchar(255),
								hostName		varchar(255),
								displayName	varchar(255),
								clientId		varchar(255)
							 )
INSERT INTO #clientInfoTbl
SELECT
	ACL.name,
	ACL.net_hostname,
	ACL.name,
	ACL.id
FROM APP_Client ACL
INNER JOIN APP_CommCell ACC ON ACL.id = ACC.clientId
WHERE ACL.id > 2
UNION
SELECT
	ACL.name,
	ACL.net_hostname,
	ACL.name,
	ACL.id
FROM APP_Client ACL
LEFT OUTER JOIN APP_IDAName AIDA ON ACL.id = AIDA.clientId
LEFT OUTER JOIN MMHost MMH ON ACL.id = MMH.ClientId
LEFT OUTER JOIN simInstalledPackages SIMPKG ON ACL.id = SIMPKG.ClientId
WHERE AIDA.clientId is null
	AND MMH.ClientId  is null
	AND SIMPKG.ClientId is null
	AND ACL.id > 2
	AND (ACL.specialClientFlags & 01) = 0 --filter out hide in GUI clients #define HIDE_IN_GUI_CLIENT_LIST 0x1
	AND ACL.OrigCCId = 2
if exists( select * from master..sysdatabases where name='QNet')
BEGIN
	EXEC ('INSERT INTO #clientInfoTbl
     SELECT CHL.CCClientName,
                  CHL.InterfaceName,
                  CHL.DisplayName,
                  CHL.ChildId
     FROM qnet..Child CHL WHERE CHL.ChildId not in (SELECT clientId FROM #clientInfoTbl)')
END
SELECT * FROM #clientInfoTbl
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_GRCGetRemoteCommservList')
	delete from GxQscripts where name = 'CCM_GRCGetRemoteCommservList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_GRCGetRemoteCommservList')
	delete from GXDBVersions where aliasname = 'CCM_GRCGetRemoteCommservList'
GO

insert into GXDBVersions values(2, 'CCM_GRCGetRemoteCommservList',  '00010004008800010000', 'CCM_GRCGetRemoteCommservList', '00010004008800010000')
GO

