

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Export_CopyTableFromLinkedServer.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: CCM_Export_CopyTableFromLinkedServer.sp,v 1.6.12.1 2018/03/20 00:47:10 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Export_CopyTableFromLinkedServer <<<'

IF EXISTS (select * from sysobjects where name='CCM_Export_CopyTableFromLinkedServer')
	drop procedure CCM_Export_CopyTableFromLinkedServer
IF EXISTS (select * from GxQscripts where name='CCM_Export_CopyTableFromLinkedServer')
	delete from GxQscripts where name = 'CCM_Export_CopyTableFromLinkedServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Export_CopyTableFromLinkedServer')
	delete from GXDBVersions where aliasname = 'CCM_Export_CopyTableFromLinkedServer'
GO
print '... Creating Procedure: CCM_Export_CopyTableFromLinkedServer'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Export_CopyTableFromLinkedServer
  @isExportFromLinkedServer integer,
  @fromTbl VARCHAR(1012),
  @toTbl VARCHAR(1012),
  @selectLinkedColumnList VARCHAR(MAX),
  @CaptureDbName VARCHAR(1012),
  @queryTailStr VARCHAR(MAX)
AS
DECLARE @select_colListForInsert Varchar(MAX),
		@insert_colList Varchar(MAX),
	   @SQLStatment VARCHAR(MAX),
	   @hasIdentity INT
SET @insert_colList = ''
SET @select_colListForInsert = ''
DECLARE  @selectColumnListTbl TABLE (ID int, colName varchar(256))
IF(@selectLinkedColumnList is null OR LEN(@selectLinkedColumnList) = 0)
BEGIN
	select
		@select_colListForInsert =
		CASE
		WHEN DATA_TYPE = 'xml' AND @isExportFromLinkedServer <> 0
		THEN
			 @select_colListForInsert + 'CAST('+COLUMN_NAME+' AS nvarchar(max)) AS '+COLUMN_NAME+','
		ELSE
			@select_colListForInsert + COLUMN_NAME + ' , '
		END,
		@selectLinkedColumnList =
		CASE
		WHEN @queryTailStr is not null
		THEN
			@selectLinkedColumnList+'a.'+COLUMN_NAME + ' , '
		END,
		@insert_colList = @insert_colList + COLUMN_NAME + ' , '
	from information_schema.columns
	where TABLE_NAME = @fromTbl
	SET @insert_colList = '('+Substring(@insert_colList,1,len(@insert_colList)-1)+')'
	SET @select_colListForInsert = Substring(@select_colListForInsert, 1, LEN(@select_colListForInsert)-1)
	IF(@queryTailStr is not null AND LEN(@queryTailStr) > 0)
		SET @selectLinkedColumnList = Substring(@selectLinkedColumnList,1,len(@selectLinkedColumnList)-1)
	ELSE
		SET @selectLinkedColumnList = '*'
END
ELSE
BEGIN
	INSERT @selectColumnListTbl
	select * from dbo.SplitString(@selectLinkedColumnList, ',')
	update @selectColumnListTbl
	SET colName =  SUBSTRING(colName,CHARINDEX('.',colName,  1)+1, LEN(colName))
	SELECT @select_colListForInsert  =
	CASE
	WHEN B.DATA_TYPE = 'xml' AND @isExportFromLinkedServer <> 0
	THEN
			@select_colListForInsert + 'CAST('+B.COLUMN_NAME+' AS nvarchar(max)) AS '+B.COLUMN_NAME+','
	ELSE
			@select_colListForInsert + B.COLUMN_NAME + ' , '
	END
	FROM @selectColumnListTbl A INNER JOIN information_schema.columns B ON A.colName = B.COLUMN_NAME
	WHERE TABLE_NAME = @fromTbl
	SET @select_colListForInsert = Substring(@select_colListForInsert,1, LEN(@select_colListForInsert)-1)
END
--Create target table if it doesn't exists
IF (OBJECT_ID(@toTbl) IS NULL)
BEGIN
SET @SQLStatment = 'SELECT * INTO '+@toTbl+' FROM '+@fromTbl+' Where 1 = 0'
exec(@SQLStatment )
SET @hasIdentity = OBJECTPROPERTY(object_ID(@fromTbl), 'TableHasIdentity')
END
IF(@isExportFromLinkedServer <> 0)
BEGIN
	SET @SQLStatment = 'INSERT INTO '+@toTbl+@insert_colList+' select '+@selectLinkedColumnList+' from openquery(ccm_export_linkedserver, ''SELECT ' +@select_colListForInsert+ ' From '+@CaptureDbName+'.dbo.'+@fromTbl+''') '+@queryTailStr
END
ELSE
BEGIN
	---Use synonym if its locale instance
	set @fromTbl = 'CCM_SOURCE_'+@fromTbl
	SET @SQLStatment = 'INSERT INTO '+@toTbl+@insert_colList+' SELECT ' + @selectLinkedColumnList + ' From '+@fromTbl+' '+@queryTailStr
END
IF(@hasIdentity= 1)
	EXEC SQLUtilIdentityInsert @SQLStatment, @toTbl
ELSE
	exec(@SQLStatment )
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Export_CopyTableFromLinkedServer')
	delete from GxQscripts where name = 'CCM_Export_CopyTableFromLinkedServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Export_CopyTableFromLinkedServer')
	delete from GXDBVersions where aliasname = 'CCM_Export_CopyTableFromLinkedServer'
GO

insert into GXDBVersions values(2, 'CCM_Export_CopyTableFromLinkedServer',  '00010006001200010000', 'CCM_Export_CopyTableFromLinkedServer', '00010006001200010000')
GO

