

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Drop_Synonyms.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Drop Synonyms created for the tables of user specified DB
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Drop_Synonyms <<<'

IF EXISTS (select * from sysobjects where name='CCM_Drop_Synonyms')
	drop procedure CCM_Drop_Synonyms
IF EXISTS (select * from GxQscripts where name='CCM_Drop_Synonyms')
	delete from GxQscripts where name = 'CCM_Drop_Synonyms'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Drop_Synonyms')
	delete from GXDBVersions where aliasname = 'CCM_Drop_Synonyms'
GO
print '... Creating Procedure: CCM_Drop_Synonyms'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Drop_Synonyms
  @Capture_DB_Name varchar(1024)
AS
  DECLARE @errorString varchar(1024);
SET NOCOUNT ON
BEGIN TRANSACTION TRAN_CCMDROPSYN
	SET @errorString = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
	IF NOT EXISTS (SELECT * FROM MASTER..SYSDATABASES WHERE NAME = @Capture_DB_Name)
	BEGIN
		SET @errorString = 'DATABASE ' +@Capture_DB_Name+ ' DOES NOT EXIST'
		GOTO CX_ERROR_EXIT
	END
	/*
	Get all the list of tables from the Commserv_Capture DB
	Drop synonyms of the template CCM_SOURCE_<Table Name> from the Commserv DB
	*/
	--DECLARE @TABLE_NAME VARCHAR (1024)
	DECLARE @SYNONYM_DROP_QUERY VARCHAR(MAX)
	DECLARE @TABLE_LIST table(TableName VARCHAR(1024))
	IF OBJECT_ID('CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA') IS NOT NULL
		DROP SYNONYM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA
	SET @SYNONYM_DROP_QUERY = 'CREATE SYNONYM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA' + ' FOR [' + @Capture_DB_Name + '].information_schema.tables'
	EXEC (@SYNONYM_DROP_QUERY)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Drop_Synonyms -- Create Synonym CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA Failed'
		GOTO CX_ERROR_EXIT
	END
	--Get the table names from the commserv_capture DB for which synonyms need to be dropped
	IF (NOT EXISTS(SELECT 1 FROM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA WHERE TABLE_NAME = 'CCM_APP_CLIENT'))
	BEGIN
		INSERT INTO @TABLE_LIST
		SELECT table_name
		FROM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA
		WHERE table_type = 'base table'
	END
	ELSE
	BEGIN
		INSERT INTO @TABLE_LIST
		SELECT SUBSTRING(table_name,5,1024)  -- Example: Get substring App_Client from CCM_App_Client
		FROM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA
		WHERE table_type = 'base table'
		AND CHARINDEX('CCM_',table_name) = 1
		AND CHARINDEX('CCM_TEMP_',table_name) = 0
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'simPackageMap')
			INSERT INTO @TABLE_LIST VALUES ('simPackageMap')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'simLicAppTypeV2')
			INSERT INTO @TABLE_LIST VALUES ('simLicAppTypeV2')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'MMDataPath')
			INSERT INTO @TABLE_LIST VALUES ('MMDataPath')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'MMDrivePool')
			INSERT INTO @TABLE_LIST VALUES ('MMDrivePool')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'MMMasterPool')
			INSERT INTO @TABLE_LIST VALUES ('MMMasterPool')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'MMLibrary')
			INSERT INTO @TABLE_LIST VALUES ('MMLibrary')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'MMDrive')
			INSERT INTO @TABLE_LIST VALUES ('MMDrive')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'IdxCache')
			INSERT INTO @TABLE_LIST VALUES ('IdxCache')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'JMJobInfo')
			INSERT INTO @TABLE_LIST VALUES ('JMJobInfo')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'archCopySIDBStore')
			INSERT INTO @TABLE_LIST VALUES ('archCopySIDBStore')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'IDXAccessPath')
			INSERT INTO @TABLE_LIST VALUES ('IDXAccessPath')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'simAppTypeLicTypeMap')
			INSERT INTO @TABLE_LIST VALUES ('simAppTypeLicTypeMap')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'App_ClientGroupAssoc')
			INSERT INTO @TABLE_LIST VALUES ('App_ClientGroupAssoc')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'IdxSIDBSubStore')
			INSERT INTO @TABLE_LIST VALUES ('IdxSIDBSubStore')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'archFileSIDBKeys')
			INSERT INTO @TABLE_LIST VALUES ('archFileSIDBKeys')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'APP_VMToPMMap')
			INSERT INTO @TABLE_LIST VALUES ('APP_VMToPMMap')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'SMVolume')
			INSERT INTO @TABLE_LIST VALUES ('SMVolume')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'App_SCGRule')
			INSERT INTO @TABLE_LIST VALUES ('App_SCGRule')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'ArchAppCopyToBeAged')
			INSERT INTO @TABLE_LIST VALUES ('ArchAppCopyToBeAged')
	END
	SET @SYNONYM_DROP_QUERY = ''
	SELECT @SYNONYM_DROP_QUERY += 'DROP SYNONYM CCM_SOURCE_' + TableName + ' ; '
	FROM @TABLE_LIST
	WHERE EXISTS (SELECT 1 FROM dbo.SYSOBJECTS WHERE name = 'CCM_SOURCE_' + TableName AND XTYPE = 'SN')
	EXEC (@SYNONYM_DROP_QUERY)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Drop_Synonyms -- Drop Synonym Failed'
		GOTO CX_ERROR_EXIT
	END
	IF OBJECT_ID('CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA') IS NOT NULL
		DROP SYNONYM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA
	---------------------------------------------------------
COMMIT TRANSACTION TRAN_CCMDROPSYN
	SET @errorString = 'NO_ERROR'
	SELECT	0, @errorString
	RETURN 0
CX_ERROR_EXIT:
	IF OBJECT_ID('CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA') IS NOT NULL
		DROP SYNONYM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA
	ROLLBACK TRANSACTION TRAN_CCMDROPSYN
	SELECT	-1, @errorString
	RETURN -1
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Drop_Synonyms')
	delete from GxQscripts where name = 'CCM_Drop_Synonyms'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Drop_Synonyms')
	delete from GXDBVersions where aliasname = 'CCM_Drop_Synonyms'
GO

insert into GXDBVersions values(2, 'CCM_Drop_Synonyms',  '00000000000000000000', 'CCM_Drop_Synonyms', '00000000000000000000')
GO

