

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Create_Synonyms.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Create Synonyms for the tables of user specified DB
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Create_Synonyms <<<'

IF EXISTS (select * from sysobjects where name='CCM_Create_Synonyms')
	drop procedure CCM_Create_Synonyms
IF EXISTS (select * from GxQscripts where name='CCM_Create_Synonyms')
	delete from GxQscripts where name = 'CCM_Create_Synonyms'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Create_Synonyms')
	delete from GXDBVersions where aliasname = 'CCM_Create_Synonyms'
GO
print '... Creating Procedure: CCM_Create_Synonyms'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Create_Synonyms
  @Capture_From_DB varchar(1024),
  @Capture_DB_Name varchar(1024),
  @isExportFromOtherSQL integer
AS
  DECLARE @returnCode integer
  DECLARE @errorString varchar(1024);
SET NOCOUNT ON
BEGIN TRANSACTION TRAN_CCMCREATESYN
	SET @errorString = 'ERROR: GENERAL ERROR!'
	 DECLARE @linkedServerName VARCHAR(256)
	 SET	@linkedServerName = 'CCM_Export_LinkedServer'
	---------------------------------------------------------
	IF OBJECT_ID('CCM_SYNONYM_CAPTURE_SYS_DATABASES_TABLE_SCHEMA') IS NOT null
		DROP SYNONYM CCM_SYNONYM_CAPTURE_SYS_DATABASES_TABLE_SCHEMA
		EXEC('CREATE SYNONYM CCM_SYNONYM_CAPTURE_SYS_DATABASES_TABLE_SCHEMA FOR master.sys.databases')
	IF NOT EXISTS (SELECT * FROM CCM_SYNONYM_CAPTURE_SYS_DATABASES_TABLE_SCHEMA WHERE NAME = @Capture_DB_Name)
	BEGIN
		SET @errorString = 'DATABASE ' +@Capture_DB_Name+ ' DOES NOT EXIST'
		GOTO CX_ERROR_EXIT
	END
	/*
		Get list of tables from the commserv_cpature DB into cursor
		For every <table_name> from cursor
		create synonym CCM_SOURCE_<table_name> for Capture_From_DB..<table_name>
	*/
	--DECLARE @TABLE_NAME VARCHAR (1024)
	DECLARE @SYNONYM_DROP_QUERY VARCHAR (MAX) = ''
	DECLARE @SYNONYM_CREATE_QUERY VARCHAR(MAX) = ''
	DECLARE @TABLE_LIST table(TableName VARCHAR(1024))
	IF OBJECT_ID('CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA') IS NOT null
		DROP SYNONYM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA
		SET @SYNONYM_CREATE_QUERY = 'CREATE SYNONYM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA FOR [' + @Capture_DB_Name + '].information_schema.tables'
	EXEC (@SYNONYM_CREATE_QUERY)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Create_Synonyms -- Create Synonym CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA Failed'
		GOTO CX_ERROR_EXIT
	END
	IF (NOT EXISTS(SELECT 1 FROM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA WHERE TABLE_NAME = 'CCM_APP_CLIENT'))  -- lpulickal , 3rd Dec 2013. To suit the capture_to_xml case
	BEGIN
		INSERT INTO @TABLE_LIST
		SELECT table_name
		FROM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA
		WHERE table_type = 'base table'
	END
	ELSE
	BEGIN
		--Get the table names from the commserv_capture DB for which synonyms need to be created
		INSERT INTO @TABLE_LIST
		SELECT SUBSTRING(table_name,5,1024)  -- Get substring App_Client from CCM_App_Client
		FROM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA
		WHERE table_type = 'base table'
		AND CHARINDEX('CCM_',table_name) = 1
		AND CHARINDEX('CCM_TEMP_',table_name) = 0
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'simPackageMap')
			INSERT INTO @TABLE_LIST VALUES ('simPackageMap')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'simLicAppTypeV2')
			INSERT INTO @TABLE_LIST VALUES ('simLicAppTypeV2')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'MMDataPath')
			INSERT INTO @TABLE_LIST VALUES ('MMDataPath')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'MMDrivePool')
			INSERT INTO @TABLE_LIST VALUES ('MMDrivePool')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'MMMasterPool')
			INSERT INTO @TABLE_LIST VALUES ('MMMasterPool')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'MMLibrary')
			INSERT INTO @TABLE_LIST VALUES ('MMLibrary')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'MMDrive')
			INSERT INTO @TABLE_LIST VALUES ('MMDrive')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'IdxCache')
			INSERT INTO @TABLE_LIST VALUES ('IdxCache')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'JMJobInfo')
			INSERT INTO @TABLE_LIST VALUES ('JMJobInfo')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'archCopySIDBStore')
			INSERT INTO @TABLE_LIST VALUES ('archCopySIDBStore')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'IDXAccessPath')
			INSERT INTO @TABLE_LIST VALUES ('IDXAccessPath')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'simAppTypeLicTypeMap')
			INSERT INTO @TABLE_LIST VALUES ('simAppTypeLicTypeMap')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'App_ClientGroupAssoc')
			INSERT INTO @TABLE_LIST VALUES ('App_ClientGroupAssoc')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'IdxSIDBSubStore')
			INSERT INTO @TABLE_LIST VALUES ('IdxSIDBSubStore')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'archFileSIDBKeys')
			INSERT INTO @TABLE_LIST VALUES ('archFileSIDBKeys')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'APP_VMToPMMap')
			INSERT INTO @TABLE_LIST VALUES ('APP_VMToPMMap')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'SMVolume')
			INSERT INTO @TABLE_LIST VALUES ('SMVolume')
		IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'App_SCGRule')
			INSERT INTO @TABLE_LIST VALUES ('App_SCGRule')
	IF NOT EXISTS (SELECT 1 FROM @TABLE_LIST WHERE TableName = 'ArchAppCopyToBeAged')
		INSERT INTO @TABLE_LIST VALUES ('ArchAppCopyToBeAged')
	END
	SET @SYNONYM_CREATE_QUERY = ''
	SELECT @SYNONYM_DROP_QUERY += 'DROP SYNONYM CCM_SOURCE_' + TableName + ' ; '
	FROM @TABLE_LIST
	WHERE EXISTS (SELECT 1 FROM dbo.SYSOBJECTS WHERE name = 'CCM_SOURCE_' + TableName AND XTYPE = 'SN')
	EXEC (@SYNONYM_DROP_QUERY)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Create_Synonyms -- Drop existing Synonym Failed'
		GOTO CX_ERROR_EXIT
	END
	SELECT @SYNONYM_CREATE_QUERY +=
	CASE WHEN @isExportFromOtherSQL = 1
		THEN  'CREATE SYNONYM CCM_SOURCE_' + TableName + ' FOR '+@linkedServerName+'.[' + @Capture_From_DB + '].dbo.' + TableName + ' ; '
		ELSE  'CREATE SYNONYM CCM_SOURCE_' + TableName + ' FOR [' + @Capture_From_DB + '].dbo.' + TableName + ' ; '
		END
	FROM @TABLE_LIST
	EXEC (@SYNONYM_CREATE_QUERY)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Create_Synonyms -- Drop existing Synonym Failed'
		GOTO CX_ERROR_EXIT
	END
	IF OBJECT_ID('CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA') IS NOT NULL
		DROP SYNONYM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA
	---------------------------------------------------------
COMMIT TRANSACTION TRAN_CCMCREATESYN
	SET @errorString = 'NO_ERROR'
	SELECT	0, @errorString
	RETURN 0
CX_ERROR_EXIT:
  IF OBJECT_ID('CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA') IS NOT NULL
		DROP SYNONYM CCM_SYNONYM_CAPTURE_DB_TABLE_SCHEMA
	ROLLBACK TRANSACTION TRAN_CCMCREATESYN
	SELECT	-1, @errorString
	RETURN -1
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Create_Synonyms')
	delete from GxQscripts where name = 'CCM_Create_Synonyms'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Create_Synonyms')
	delete from GXDBVersions where aliasname = 'CCM_Create_Synonyms'
GO

insert into GXDBVersions values(2, 'CCM_Create_Synonyms',  '00000000000000000000', 'CCM_Create_Synonyms', '00000000000000000000')
GO

