

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Convert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCM_Convert.sp,v $ $Id: CCM_Convert.sp,v 1.22.54.2 2018/03/20 00:41:02 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "CCM_Convert"								|
--	|																		|
--	| THIS PROCEDURE INSERTS THE MEDIAEXPLORER OUTPUT INTO THE CCM          |
--	| DATABASE, WHICH CAN BE LATER USED BY THE MERGE FEATURE OF THE COMMCELL|
--	| MIGRATION TOOL														|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Convert <<<'

IF EXISTS (select * from sysobjects where name='CCM_Convert')
	drop procedure CCM_Convert
IF EXISTS (select * from GxQscripts where name='CCM_Convert')
	delete from GxQscripts where name = 'CCM_Convert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Convert')
	delete from GXDBVersions where aliasname = 'CCM_Convert'
GO
print '... Creating Procedure: CCM_Convert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Convert
  @cabFileFolder nvarchar(1024)
AS
  DECLARE @returnCode integer	
  DECLARE @errStr varchar(1024)
SET NOCOUNT ON
DECLARE @File nvarchar( 1024 )
DECLARE @SQLString nvarchar(2048)
-- Execute as sysadmin because we read/write into other databases.
-- db_cvexecutor cannot access other databses.
-- Escalated permissions will automatically revert when this stored procs exits.
EXECUTE AS LOGIN = 'sqladmin_cv'
BEGIN TRANSACTION TRAN_Convert_Cab
	SET @errStr = 'ERROR: GENERAL ERROR!'
	--------------------APP_Application.txt------------------------
	SET @File = @cabFileFolder + N'APP_Application.txt'
	SET @SQLString = N'BULK INSERT CommServ_Convert..CCM_TEMP_APP_Application FROM ''' + @File + ''' WITH ( FIRSTROW = 2, FIELDTERMINATOR = '','', ROWTERMINATOR = ''\n'' )'
	EXEC sp_executesql @SQLString
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_APP_Application'
		GOTO CX_ERROR_EXIT
	END
	--------------------ArchChunk.txt------------------------
	SET @File = @cabFileFolder + 'ArchChunk.txt'
	SET @SQLString = N'BULK INSERT CommServ_Convert..CCM_TEMP_ArchChunk FROM ''' + @File + ''' WITH ( FIRSTROW = 2, FIELDTERMINATOR = '','', ROWTERMINATOR = ''\n'' )'
	EXEC sp_executesql @SQLString
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_ArchChunk'
		GOTO CX_ERROR_EXIT
	END
	--------------------ArchChunkMapping.txt-----------------
	SET @File = @cabFileFolder + 'ArchChunkMapping.txt'
	SET @SQLString = N'BULK INSERT CommServ_Convert..CCM_TEMP_ArchChunkMapping FROM ''' + @File + ''' WITH ( FIRSTROW = 2, FIELDTERMINATOR = '','', ROWTERMINATOR = ''\n'' )'
	EXEC sp_executesql @SQLString
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_ArchChunkMapping'
		GOTO CX_ERROR_EXIT
	END
	--------------------ArchFile.txt------------------------
	SET @File = @cabFileFolder + 'ArchFile.txt'
	SET @SQLString = N'BULK INSERT CommServ_Convert..CCM_TEMP_ArchFile FROM ''' + @File + ''' WITH ( FIRSTROW = 2, FIELDTERMINATOR = '','', ROWTERMINATOR = ''\n'' )'
	EXEC sp_executesql @SQLString
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_ArchFile'
		GOTO CX_ERROR_EXIT
	END
	--------------------ArchFileCopy.txt------------------------
	SET @File = @cabFileFolder + 'ArchFileCopy.txt'
	SET @SQLString = N'BULK INSERT CommServ_Convert..CCM_TEMP_ArchFileCopy FROM ''' + @File + ''' WITH ( FIRSTROW = 2, FIELDTERMINATOR = '','', ROWTERMINATOR = ''\n'' )'
	EXEC sp_executesql @SQLString
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_ArchFileCopy'
		GOTO CX_ERROR_EXIT
	END
	--------------------APP_Client.txt------------------------
	SET @File = @cabFileFolder + 'APP_Client.txt'
	SET @SQLString = N'BULK INSERT CommServ_Convert..CCM_TEMP_APP_Client FROM ''' + @File + ''' WITH ( FIRSTROW = 2, FIELDTERMINATOR = '','', ROWTERMINATOR = ''\n'' )'
	EXEC sp_executesql @SQLString
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_APP_Client'
		GOTO CX_ERROR_EXIT
	END
	--------------------APP_CommCell.txt------------------------
	SET @File = @cabFileFolder + 'APP_CommCell.txt'
	SET @SQLString = N'BULK INSERT CommServ_Convert..CCM_TEMP_APP_CommCell FROM ''' + @File + ''' WITH ( FIRSTROW = 2, FIELDTERMINATOR = '','', ROWTERMINATOR = ''\n'' )'
	EXEC sp_executesql @SQLString
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_APP_CommCell'
		GOTO CX_ERROR_EXIT
	END
	--------------------JmBkpStats.txt------------------------
	SET @File = @cabFileFolder + 'JmBkpStats.txt'
	SET @SQLString = N'BULK INSERT CommServ_Convert..CCM_TEMP_JmBkpStats FROM ''' + @File + ''' WITH ( FIRSTROW = 2, FIELDTERMINATOR = '','', ROWTERMINATOR = ''\n'' )'
	EXEC sp_executesql @SQLString
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_JmBkpStats'
		GOTO CX_ERROR_EXIT
	END
	--------------------MMMedia.txt------------------------
	SET @File = @cabFileFolder + 'MMMedia.txt'
	SET @SQLString = N'BULK INSERT CommServ_Convert..CCM_TEMP_MMMedia FROM ''' + @File + ''' WITH ( FIRSTROW = 2, FIELDTERMINATOR = '','', ROWTERMINATOR = ''\n'' )'
	EXEC sp_executesql @SQLString
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_MMMedia'
		GOTO CX_ERROR_EXIT
	END
	--------------------MMVolume.txt------------------------
	SET @File = @cabFileFolder + 'MMVolume.txt'
	SET @SQLString = N'BULK INSERT CommServ_Convert..CCM_TEMP_MMVolume FROM ''' + @File + ''' WITH ( FIRSTROW = 2, FIELDTERMINATOR = '','', ROWTERMINATOR = ''\n'' )'
	EXEC sp_executesql @SQLString
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_MMVolume'
		GOTO CX_ERROR_EXIT
	END
	-------------------Do Mappings if required------------------
	IF EXISTS(SELECT 1 FROM SYSOBJECTS WHERE NAME = 'TapeImport_Mappings')
	BEGIN
IF EXISTS(SELECT 1 FROM TapeImport_Mappings WHERE entityType = 7)
		BEGIN
			--Check for missing subclient and mapped new subclient are belongs to same IDA or not
			IF EXISTS(SELECT 1 FROM CommServ_Convert..CCM_TEMP_APP_Application A
				INNER JOIN TapeImport_Mappings B ON A.id = B.old_Id
				INNER JOIN APP_Application C ON B.new_Id = C.Id
WHERE A.appTypeId <> C.appTypeId AND B.EntityType = 7)
			BEGIN
				SET @errStr = 'ERROR: Invalid subclient mapping. Missing old subclient and mapped new subclient are belongs to different IDA, Please map following subclients properly.' + CHAR(13) + CHAR(10)
				SELECT @errStr = (@errStr + 'oldId: ' + CONVERT(varchar, A.id) + ', IDAType: ' + C.name + ' ==> newId: ' + CONVERT(varchar, B.new_id) + ', IDAType: ' + D.name + CHAR(13) + CHAR(10) )
				FROM CommServ_Convert..CCM_TEMP_APP_Application A
					INNER JOIN TapeImport_Mappings B ON A.id = B.old_Id
					INNER JOIN APP_Application E ON B.new_Id = E.Id
					INNER JOIN APP_IDAType C ON A.appTypeId = C.type
					INNER JOIN APP_IDAType D ON E.appTypeId = D.type
WHERE A.appTypeId <> E.appTypeId AND B.EntityType = 7
				GOTO CX_ERROR_EXIT
			END
			--Replace missing subclient with new mapped subclient
			UPDATE CommServ_Convert..CCM_TEMP_APP_Application
			SET id = C.id,
				appNumber = C.appNumber,
				dataArchGrpId = C.dataArchGrpId,
				logArchGrpId = C.logArchGrpId
			FROM CommServ_Convert..CCM_TEMP_APP_Application A
INNER JOIN TapeImport_Mappings B ON A.id = B.old_Id AND B.entityType = 7
				INNER JOIN APP_Application C ON B.new_Id = C.id
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_APP_Application UPDATE'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CommServ_Convert..CCM_TEMP_ArchFile
			SET appId = B.new_Id
			FROM CommServ_Convert..CCM_TEMP_ArchFile A INNER JOIN TapeImport_Mappings B
ON A.appId = B.old_Id AND B.entityType = 7
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_ArchFile UPDATE appId'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CommServ_Convert..CCM_TEMP_JmBkpStats
			SET appId = B.new_Id
			FROM CommServ_Convert..CCM_TEMP_JmBkpStats A INNER JOIN TapeImport_Mappings B
ON A.appId = B.old_Id AND B.entityType = 7
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_JmBkpStats UPDATE appId'
				GOTO CX_ERROR_EXIT
			END
		END
IF EXISTS(SELECT 1 FROM TapeImport_Mappings WHERE entityType = 18)
		BEGIN
			DECLARE @lt_NewCopy TABLE (oldCopyId int, newCopyId int, oldArchGroupId int, newArchGroupId int)
			INSERT INTO @lt_NewCopy
			SELECT A.old_Id, A.new_Id, A.oldArchGroupId, B.archGroupId
			FROM TapeImport_Mappings A INNER JOIN ArchGroupCopy B ON A.new_Id = B.Id
WHERE A.entityType = 18
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- lt_NewCopy INSERT'
				GOTO CX_ERROR_EXIT
			END
			UPDATE @lt_NewCopy
			SET oldArchGroupId = C.archGroupId
			FROM @lt_NewCopy A INNER JOIN CommServ_Convert..CCM_TEMP_ArchFileCopy B ON A.oldCopyId = B.archCopyId
				INNER JOIN CommServ_Convert..CCM_TEMP_ArchFile C ON B.archFileId = C.Id AND B.CommcellId = C.CommcellId
			WHERE A.oldArchGroupId = 0
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- lt_NewCopy UPDATE'
				GOTO CX_ERROR_EXIT
			END
			DELETE @lt_NewCopy
			WHERE oldArchGroupId = 0
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- lt_NewCopy DELETE'
				GOTO CX_ERROR_EXIT
			END
			--Check for copies of one old storage policy are mapped with copies of only one new storage policy
			IF EXISTS(SELECT 1 FROM @lt_NewCopy A INNER JOIN @lt_NewCopy B ON A.oldArchGroupId = B.oldArchGroupId WHERE A.newArchGroupId <> B.newArchGroupId)
			BEGIN
				SET @errStr = 'ERROR: Invalid mappings for storage policy copies. ' +  CHAR(13) + CHAR(10)
							  + 'Mapping copies of a one storage policy to copies of different new storage polices is not allowed.'  + CHAR(13) + CHAR(10)
							  + 'The below copies are mapped incorrectly'  + CHAR(13) + CHAR(10)
				SELECT @errStr = (@errStr + 'old storagePolicy\Copy : ' + CONVERT(varchar, A.oldArchGroupId) + '\' + CONVERT(varchar, A.oldCopyId) + ' ==> ' + 'new storagePolicy\Copy : ' + CONVERT(varchar, A.newArchGroupId) + '\' + CONVERT(varchar, A.newCopyId) + CHAR(13) + CHAR(10))
				FROM @lt_NewCopy A INNER JOIN @lt_NewCopy B ON A.oldArchGroupId = B.oldArchGroupId WHERE A.newArchGroupId <> B.newArchGroupId
				GOTO CX_ERROR_EXIT
			END
			--if old storage policy exist in current db then the deleted copy should mapped with the same old storage policy's copy
			IF EXISTS(SELECT 1 FROM @lt_NewCopy A INNER JOIN ArchGroup B ON A.oldArchGroupId = B.Id WHERE A.oldArchGroupId <> A.newArchGroupId)
			BEGIN
				SET @errStr = 'ERROR: Mapping deleted copies of existing storage policy to copies of different new storage policy is not allowed.'  + CHAR(13) + CHAR(10)
							  + 'The below copies are mapped incorrectly'  + CHAR(13) + CHAR(10)
				SELECT @errStr = (@errStr + 'old storagePolicy\Copy : ' + CONVERT(varchar, A.oldArchGroupId) + '\' + CONVERT(varchar, A.oldCopyId) + ' ==> ' + 'new storagePolicy\Copy : ' + CONVERT(varchar, A.newArchGroupId) + '\' + CONVERT(varchar, A.newCopyId) + CHAR(13) + CHAR(10))
				FROM @lt_NewCopy A INNER JOIN ArchGroup B ON A.oldArchGroupId = B.Id WHERE A.oldArchGroupId <> A.newArchGroupId
				GOTO CX_ERROR_EXIT
			END
			UPDATE CommServ_Convert..CCM_TEMP_ArchChunkMapping
			SET archCopyId = B.newCopyId
			FROM CommServ_Convert..CCM_TEMP_ArchChunkMapping A INNER JOIN @lt_NewCopy B
				ON A.archCopyId = B.oldCopyId
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- CCM_TEMP_ArchChunkMapping UPDATE archCopyId'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CommServ_Convert..CCM_TEMP_ArchFile
			SET archGroupId = B.newArchGroupId
			FROM CommServ_Convert..CCM_TEMP_ArchFile A INNER JOIN @lt_NewCopy B
				ON A.archGroupId = B.oldArchGroupId
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- CCM_ArchFile UPDATE archGroupId'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CommServ_Convert..CCM_TEMP_ArchFileCopy
			SET archCopyId = B.newCopyId
			FROM CommServ_Convert..CCM_TEMP_ArchFileCopy A INNER JOIN @lt_NewCopy B
				ON A.archCopyId = B.oldCopyId
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- CCM_ArchFileCopy UPDATE archCopyId'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CommServ_Convert..CCM_TEMP_JmBkpStats
			SET dataArchGrpId = B.newArchGroupId
			FROM CommServ_Convert..CCM_TEMP_JmBkpStats A INNER JOIN @lt_NewCopy B
				ON A.dataArchGrpId = B.oldArchGroupId
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- CCM_JmBkpStats UPDATE dataArchGrpId'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CommServ_Convert..CCM_TEMP_JmBkpStats
			SET logArchGrpId = B.newArchGroupId
			FROM CommServ_Convert..CCM_TEMP_JmBkpStats A INNER JOIN @lt_NewCopy B
				ON A.logArchGrpId = B.oldArchGroupId
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- CCM_JmBkpStats UPDATE logArchGrpId'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CommServ_Convert..CCM_TEMP_JmBkpStats
			SET diffArchGrpId = B.newArchGroupId
			FROM CommServ_Convert..CCM_TEMP_JmBkpStats A INNER JOIN @lt_NewCopy B
				ON A.diffArchGrpId = B.oldArchGroupId
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- CCM_JmBkpStats UPDATE diffArchGrpId'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CommServ_Convert..CCM_TEMP_JmBkpStats
			SET copyId = B.newCopyId
			FROM CommServ_Convert..CCM_TEMP_JmBkpStats A INNER JOIN @lt_NewCopy B
				ON A.copyId = B.oldCopyId
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- CCM_JmBkpStats UPDATE copyId'
				GOTO CX_ERROR_EXIT
			END
			UPDATE TapeImport_Mappings
			SET oldArchGroupId = B.oldArchGroupId
			FROM TapeImport_Mappings A INNER JOIN @lt_NewCopy B
				ON A.old_Id = B.oldCopyId
WHERE A.entityType = 18
				AND A.oldArchGroupId = 0
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Convert -- TapeImport_Mappings UPDATE oldArchGroupId'
				GOTO CX_ERROR_EXIT
			END
		END
		--Set allow reset to false
		UPDATE TapeImport_Mappings
		SET allowReset = 0
		FROM TapeImport_Mappings A INNER JOIN CommServ_Convert..CCM_TEMP_APP_Application B
			ON A.new_Id = B.Id
WHERE A.entityType = 7
		UPDATE TapeImport_Mappings
		SET allowReset = 0
		FROM TapeImport_Mappings A INNER JOIN CommServ_Convert..CCM_TEMP_ArchFileCopy B
			ON A.new_Id = B.archCopyId
WHERE A.entityType = 18
	END
	-----Check still any entities are missing after mapping--------
	IF EXISTS
	(
		SELECT 1
		FROM CommServ_Convert..CCM_TEMP_APP_Application A
			LEFT OUTER JOIN APP_Application B ON A.Id = B.Id
		WHERE B.Id IS NULL
	)
	OR EXISTS
	(
		SELECT 1
		FROM CommServ_Convert..CCM_TEMP_ArchFileCopy A
			LEFT OUTER JOIN ArchGroupCopy B ON A.archCopyId = B.Id
		WHERE B.Id IS NULL
	)
	BEGIN
		SET @errStr = 'ERROR: Missing subclients or storage policy copies. ' +  CHAR(13) + CHAR(10)
					+ 'Please map the below entities and retry.'  + CHAR(13) + CHAR(10)
		SELECT @errStr = (@errStr + 'subclient : ' + CONVERT(varchar, A.Id) ) + CHAR(13) + CHAR(10)
		FROM CommServ_Convert..CCM_TEMP_APP_Application A
			LEFT OUTER JOIN APP_Application B ON A.Id = B.Id
		WHERE B.Id IS NULL
		DECLARE @lt_MissingCopies TABLE(copyId int, archGroupId int, archGroupName varchar(1024))
		INSERT INTO @lt_MissingCopies
		SELECT DISTINCT A.archCopyId, B.archGroupId, null
		FROM CommServ_Convert..CCM_TEMP_ArchFileCopy A
			INNER JOIN CommServ_Convert..CCM_TEMP_ArchFile B ON A.archFileId = B.Id AND A.CommcellId = B.CommcellId
			LEFT OUTER JOIN ArchGroupCopy C ON A.archCopyId = C.Id
		WHERE C.Id IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Convert -- lt_MissingCopies  INSERT'
			GOTO CX_ERROR_EXIT
		END
		UPDATE @lt_MissingCopies
		SET archGroupName = B.name
		FROM @lt_MissingCopies A INNER JOIN ArchGroup B ON A.archGroupId = B.Id
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Convert -- lt_MissingCopies  UPDATE'
			GOTO CX_ERROR_EXIT
		END
		IF EXISTS(SELECT 1 FROM @lt_MissingCopies)
		BEGIN
			SELECT @errStr = (@errStr + 'storagePolicyCopy : ' + CONVERT(varchar, copyId)
				+ CASE WHEN archGroupName IS NULL THEN '' ELSE '(StoragePolicy: ' + archGroupName + ')' END) + CHAR(13) + CHAR(10)
			FROM @lt_MissingCopies
		END
		GOTO CX_ERROR_EXIT
	END
	-------------------Populate convert db---------------------
	INSERT INTO CommServ_Convert..CCM_APP_Application
	SELECT a.* FROM CommServ_Convert..CCM_TEMP_APP_Application a
	WHERE a.id NOT IN (SELECT id FROM CommServ_Convert..CCM_APP_Application)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_APP_Application from CCM_TEMP_APP_Application'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Convert..CCM_ArchChunk
	SELECT a.* FROM CommServ_Convert..CCM_TEMP_ArchChunk a
	WHERE (SELECT COUNT(*)
	       FROM CommServ_Convert..CCM_ArchChunk
	       WHERE id = a.id
	       AND   commCellId = a.commCellId) = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_ArchChunk from CCM_TEMP_ArchChunk'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Convert..CCM_ArchChunkMapping
	SELECT a.* FROM CommServ_Convert..CCM_TEMP_ArchChunkMapping a
	WHERE (SELECT COUNT(*)
	       FROM CommServ_Convert..CCM_ArchChunkMapping
	       WHERE archChunkId = a.archChunkId
	       AND   archFileId  = a.archFileId
	       AND   commCellId  = a.commCellId) = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_ArchChunkMapping from CCM_TEMP_ArchChunkMapping'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Convert..CCM_ArchFile
	SELECT a.* FROM CommServ_Convert..CCM_TEMP_ArchFile a
	WHERE (SELECT COUNT(*)
	       FROM CommServ_Convert..CCM_ArchFile
	       WHERE id = a.id
	       AND   commCellId = a.commCellId) = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_ArchFile from CCM_TEMP_ArchFile'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Convert..CCM_ArchFileCopy
	SELECT a.* FROM CommServ_Convert..CCM_TEMP_ArchFileCopy a
	WHERE (SELECT COUNT(*)
	       FROM CommServ_Convert..CCM_ArchFileCopy
	       WHERE archFileId  = a.archFileId
	       AND   commCellId  = a.commCellId
	       AND   archCopyId  = a.archCopyId) = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_ArchFileCopy from CCM_TEMP_ArchFileCopy'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Convert..CCM_APP_Client
	SELECT a.* FROM CommServ_Convert..CCM_TEMP_APP_Client a
	WHERE a.id NOT IN (SELECT id FROM CommServ_Convert..CCM_APP_Client)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_APP_Client from CCM_TEMP_APP_Client'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Convert..CCM_APP_CommCell
	SELECT a.* FROM CommServ_Convert..CCM_TEMP_APP_CommCell a
	WHERE a.id NOT IN (SELECT id FROM CommServ_Convert..CCM_APP_CommCell)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_APP_CommCell from CCM_TEMP_APP_CommCell'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Convert..CCM_JmBkpStats
	SELECT a.* FROM CommServ_Convert..CCM_TEMP_JmBkpStats a
	WHERE (SELECT COUNT(*)
	       FROM CommServ_Convert..CCM_JmBkpStats
	       WHERE jobId = a.jobId
	       AND   commCellId = a.commCellId) = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_JmBkpStats from CCM_TEMP_JmBkpStats'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Convert..CCM_MMMedia
	SELECT a.* FROM CommServ_Convert..CCM_TEMP_MMMedia a
	WHERE a.MediaId NOT IN (SELECT MediaId FROM CommServ_Convert..CCM_MMMedia)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_MMMedia from CCM_TEMP_MMMedia'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Convert..CCM_MMVolume
	SELECT a.* FROM CommServ_Convert..CCM_TEMP_MMVolume a
	WHERE a.VolumeId NOT IN (SELECT VolumeId FROM CommServ_Convert..CCM_MMVolume)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Convert -- CCM_MMVolume from CCM_TEMP_MMVolume'
		GOTO CX_ERROR_EXIT
	END
	TRUNCATE TABLE CommServ_Convert..CCM_TEMP_APP_Application
	TRUNCATE TABLE CommServ_Convert..CCM_TEMP_ArchChunk
	TRUNCATE TABLE CommServ_Convert..CCM_TEMP_ArchChunkMapping
	TRUNCATE TABLE CommServ_Convert..CCM_TEMP_ArchFile
	TRUNCATE TABLE CommServ_Convert..CCM_TEMP_ArchFileCopy
	TRUNCATE TABLE CommServ_Convert..CCM_TEMP_APP_Client
	TRUNCATE TABLE CommServ_Convert..CCM_TEMP_APP_CommCell
	TRUNCATE TABLE CommServ_Convert..CCM_TEMP_JmBkpStats
	TRUNCATE TABLE CommServ_Convert..CCM_TEMP_MMMedia
	TRUNCATE TABLE CommServ_Convert..CCM_TEMP_MMVolume
	COMMIT	TRANSACTION TRAN_Convert_Cab
	SET @errStr = 'NO_ERROR'
	SELECT	0, @errStr
	RETURN
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION TRAN_Convert_Cab
	RAISERROR ('%s' , 16, 1, @errStr)
	SELECT -1, @errStr
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Convert')
	delete from GxQscripts where name = 'CCM_Convert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Convert')
	delete from GXDBVersions where aliasname = 'CCM_Convert'
GO

insert into GXDBVersions values(2, 'CCM_Convert',  '00010022005400020000', 'CCM_Convert', '00010022005400020000')
GO

