

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_checkForNewEntities.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: checks if any new entities are picked for the current capture from pervious capture.
--  +========================================================================+
-- $Id: CCM_Capture_checkForNewEntities.sp,v 1.1.2.3 2019/06/23 02:45:22 kbora Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_checkForNewEntities')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_checkForNewEntities <<<'
	drop procedure CCM_Capture_checkForNewEntities
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_checkForNewEntities')
	delete from GxQscripts where name = 'CCM_Capture_checkForNewEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_checkForNewEntities')
	delete from GXDBVersions where aliasname = 'CCM_Capture_checkForNewEntities'
GO
print '... Creating Procedure: CCM_Capture_checkForNewEntities'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_checkForNewEntities
  @i_jobId INTEGER,
  @i_csGUID varchar(36)
AS
  DECLARE @retCode INT;
SET NOCOUNT ON
	SET @retCode = 1
	IF EXISTS (	SELECT 1
				FROM (SELECT id, value, type FROM CCMCaptureEntitiesCache WHERE isResultStr = 0 AND csGUID = @i_csGUID ) AS A
					FULL OUTER JOIN CCMCaptureEntities B ON A.value = B.value AND A.type = B.type
				WHERE A.id IS NULL OR B.id IS NULL
				)
		OR NOT EXISTS(SELECT 1 FROM CCMCaptureEntitiesCache WHERE csGUID = @i_csGUID)
	BEGIN
		DELETE CCMCaptureEntitiesCache WHERE csGUID = @i_csGUID
		INSERT INTO CCMCaptureEntitiesCache
		SELECT A.*, 0, @i_csGUID
		FROM CCMCaptureEntities A
		WHERE A.jobid = @i_jobId
		SET @retCode = 0
	END
    ELSE
	BEGIN
		DELETE CCMCaptureEntities WHERE jobid = @i_jobId
		INSERT INTO CCMCaptureEntities
		SELECT type, value, priority, status, @i_jobId, reservedint, reservedchar, defaultsc
		FROM CCMCaptureEntitiesCache
		WHERE isResultStr = 1 AND csGUID = @i_csGUID
	END
	SELECT @retCode
	RETURN  0
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_checkForNewEntities')
	delete from GxQscripts where name = 'CCM_Capture_checkForNewEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_checkForNewEntities')
	delete from GXDBVersions where aliasname = 'CCM_Capture_checkForNewEntities'
GO

insert into GXDBVersions values(2, 'CCM_Capture_checkForNewEntities',  '00010001000200030000', 'CCM_Capture_checkForNewEntities', '00010001000200030000')
GO

