

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_SubClient_to_XML.sp] ---------- 

--  +================================================================================================+
--  | Stored Procedure: Capture sub-client to migrate into temp tables which will be converted to XML
--  +================================================================================================+
-- $Id: CCM_Capture_SubClient_to_XML.sp,v 1.5.72.4 2018/12/27 16:43:21 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_SubClient_to_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_SubClient_to_XML <<<'
	drop procedure CCM_Capture_SubClient_to_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_SubClient_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_SubClient_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SubClient_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SubClient_to_XML'
GO
print '... Creating Procedure: CCM_Capture_SubClient_to_XML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_SubClient_to_XML
  @i_subClientList varchar(max),
  @i_clientId integer,
  @time_from integer,
  @time_to integer,
  @i_captureActivityControl integer,
  @i_captureHolidays integer,
  @i_captureOperationWindow integer,
  @i_captureSchedule integer,
  @s_dumpSetName varchar(128),
  @isDefaultSubClient integer,
  @ccmParamFlags integer,
  @i_jobId integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024)
AS
--Code Below Here is From CCM_Capture_SubClient.spb
  DECLARE @errorCode integer;
  DECLARE @errorStr varchar(1024);
   DECLARE @SRMAppTypeId	 integer;
SET NOCOUNT ON
        -- 1) Validate if the specified sub-client can be migrated.
        --      If not and if global option is set to fail CCM,  return fatel error
        --      If not and if global option is not set to fail CCM, return error
        -- 2) Once validations are done, insert records into CCM_APP_Application
        -- 3) Invoke CCM_Capture_Client for the client corresponding to the specified sub-client
        -- 4) Invoke CCM_Capture_Main for the specified time
        -- 5) Commit transaction and return to caller
        SET @errorCode = 0
        SET @errorStr = 'ERROR: GENERAL ERROR!'
		IF (@ccmParamFlags & 1) = 1 --GRC Job
		BEGIN
			UPDATE MMConfigs SET value = 0 WHERE name =	'GRC_CONFIG_DISABLE_JMJOBDATASTATS_TRACKING' AND value <> 0
		END
		-----------------------------------------------------------------------------------------
		BEGIN TRANSACTION CCMCAPSUBCLIENT
			-- CommServ_Capture..CCM_APP_Application
		IF @i_clientId <= 0
		BEGIN
			IF OBJECT_ID('tempdb..#scList') IS NOT NULL DROP TABLE #scList
				CREATE TABLE #scList (scId INT)
			CREATE INDEX #scList_scId_Idx ON #scList (scId)
			INSERT INTO #scList
			SELECT DISTINCT _id FROM SplitStringByDelimiter(@i_subClientList,'_')
INSERT INTO #CCM_APP_Application
			SELECT A.*
			FROM CCM_SOURCE_APP_Application A INNER JOIN #scList B ON A.id = B.scId
WHERE NOT EXISTS (SELECT 1 FROM #CCM_APP_Application C WHERE C.id = A.id )
				AND A.appTypeId <> 1000
				AND NOT EXISTS (SELECT 1 FROM GetAppTypesForAppGroup(132,0) APP WHERE A.appTypeId = APP.appTypeId)
				AND NOT EXISTS (	SELECT 1
									FROM CCM_SOURCE_APP_Client CL
WHERE CL.id = A.clientId AND (CL.status & 0x4000000) = 0x4000000
AND (CL.status & 0x10000000) = 0x10000000
							   )
			IF	@@ERROR > 0
			BEGIN
				SET @errorStr = 'ERROR: CCM_Capture_SubClient -- CCM_APP_Application'
				GOTO CX_ERROR_EXIT
			END
		END
	    IF (@time_from < 0 OR @time_to < 0)
     	BEGIN
 	        SET @errorStr = 'ERROR: CCM_Capture_SubClient -- Invalid Time(s)'
		    GOTO CX_ERROR_EXIT
	    END
		-- When capture is done from staged DR Restore (staging DR via CommServDisasterRecoveryTool.exe will set the passwords to empty and changes net_hostname to _disabled) we should fail capture of such clients.
		DECLARE @clientList NVARCHAR(1024) = ''
		SELECT @clientList = @clientList + A.name +', '
FROM   CCM_SOURCE_APP_Client A WITH (NOLOCK) INNER JOIN #CCM_APP_Application B ON A.id = B.clientId
		WHERE  A.client_password = ''
		IF @clientList <> ''
		BEGIN
			SET @errorStr = 'ERROR: CCM_Capture_SubClient -- The list of clients ['+ @clientList +'] have no client password, run capture from original database or skip these clents from capture.'
			GOTO CX_ERROR_EXIT
		END
        -----------------------------------------------------------------------------------------
        -- CCM_Capture_Client
        EXEC @errorCode = CCM_Capture_Client_to_XML @i_clientId, @i_isExportFromLinkedServer, @i_exportDBName
        IF @errorCode <> 0
        BEGIN
               SET @errorStr = 'ERROR: CCM_Capture_SubClient -- CCM_Capture_Client'
               GOTO CX_ERROR_EXIT
        END
        -----------------------------------------------------------------------------------------
        -- CCM_Capture_Main
        EXEC @errorCode = CCM_Capture_Main_to_XML @time_from, @time_to, @i_captureActivityControl, @i_captureHolidays, @i_captureOperationWindow, @i_captureSchedule, @isDefaultSubClient, @ccmParamFlags, @i_jobId, @i_isExportFromLinkedServer, @i_exportDBName, @errorString = @errorStr OUTPUT
        IF @errorCode <> 0
        BEGIN
               GOTO CX_ERROR_EXIT
        END
	    -----------------------------------------------------------------------------------------
	    /*
			@isDefaultSubClient <> 0 if the procedure call is to capture only configuration
			for defaultSubClient of the backupset
			This is needed when the user selects a subClient from the backupSet but not the
			defaultSubCliet.
			Every backupSet needs defaultSubClient for proper functionality of other SubClients
			Hence capturing only certain App_ configuration tables for defaultSubClient
			No need of questions and answers in this case
		*/
		IF @isDefaultSubClient <> 0
		BEGIN
			GOTO CX_SKIP_EXIT
		END
		-------------------------------------------------------------------------------------------
	    -- Populate the questions into the CommServ Database tables keeping track of questions
	    INSERT INTO CCMMountPathMapping
        SELECT DISTINCT @s_dumpSetName, a.MountPathId, a.newLibraryId, a.newMountPathName, a.newUserName, a.newPassword, a.MountPathName,
                        a.SourceMediaAgentId,a.SourceMediaAgentName, a.MountPathType, a.TargetDeviceMediaAgentId, a.SourceDeviceId, a.SourceDeviceName
FROM   #CCM_MountPathMapping a
				LEFT OUTER JOIN CCMMountPathMapping b
				ON b.dumpSetName           = @s_dumpSetName
				  AND b.MountPathId           = a.MountPathId
		WHERE	b.MountPathId IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errorStr = 'ERROR: CCM_Capture_SubClient -- CCMMountPathMapping -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO CCMDevicePathMapping
		SELECT DISTINCT @s_dumpSetName,A.SourceDeviceId, A.SourceDeviceName, A.SourceDevicePath, A.newMediaAgentId, A.newDevicePath, A.newUserName, A.newPassword
FROM #CCM_DevicePathMapping A
				LEFT OUTER JOIN CCMDevicePathMapping B
				ON @s_dumpSetName = B.dumpSetName
				AND A.SourceDeviceId = B.SourceDeviceId
		WHERE	B.SourceDeviceId IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errorStr = 'ERROR: CCM_Capture_SubClient -- CCMDevicePathMapping -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO CCMClientNameMapping
		SELECT DISTINCT @s_dumpSetName, a.name, a.net_hostname, '', ''
FROM   #CCM_APP_Client a
				LEFT OUTER JOIN CCMClientNameMapping b
		        ON b.dumpSetName = @s_dumpSetName
					AND b.old_name = a.name
		WHERE	b.old_name IS NULL
			AND NOT EXISTS (SELECT 1
				FROM CCM_SOURCE_APP_ClientProp c WHERE c.componentNameId = a.id
AND ((c.attrName = 'Index Server Type' AND c.attrVal = 15) OR (c.attrName = 'Virtual Server Discovered Clients' AND c.attrVal = '1')) AND c.modified = 0
				)  -- skip indexing clients, VSA discovered VMs.
		IF	@@ERROR > 0
		BEGIN
			SET @errorStr = 'ERROR: CCM_Capture_SubClient -- CCMClientNameMapping -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		--Populate CCMEntitiesCaptured table to keep track of captured entities
		--Get Current capture jobid
		DECLARE @l_curCaptureJobId Integer
		SET @l_curCaptureJobId =  ISNULL
		(
			(
				@i_jobId
			), 0
		)
		--Add captured copies to EntitiesCaptured list
		IF @l_curCaptureJobId <> 0 -- lpulickal edit , capture_job_id foreign key error
		BEGIN
			INSERT INTO CCMEntitiesCaptured
SELECT DISTINCT @l_curCaptureJobId, 2, a.Id, 0, 18, null
FROM #CCM_archGroupCopy a LEFT OUTER JOIN CCMEntitiesCaptured b
				ON a.Id = b.EntityId AND b.EntityCCId = 0
AND b.EntityType = 18 AND b.CaptureJobId = @l_curCaptureJobId
			WHERE b.EntityId IS NULL
			IF	@@ERROR > 0
			BEGIN
				SET @errorStr = 'ERROR: CCM_Capture_SubClien -- CCMEntitiesCaptured -- ArchGroupCopy'
				GOTO CX_ERROR_EXIT
			END
			--Add captured stores to EntitiesCaptured list
			INSERT INTO CCMEntitiesCaptured
SELECT DISTINCT @l_curCaptureJobId, 2, a.SIDBStoreId, 0, 41, null
FROM #CCM_IdxSIDBStore a LEFT OUTER JOIN CCMEntitiesCaptured b
				ON a.SIDBStoreId = b.EntityId AND b.EntityCCId = 0
AND b.EntityType = 41 AND b.CaptureJobId = @l_curCaptureJobId
			WHERE b.EntityId IS NULL
			IF	@@ERROR > 0
			BEGIN
				SET @errorStr = 'ERROR: CCM_Capture_SubClien -- CCMEntitiesCaptured -- IdxSIDBStore'
				GOTO CX_ERROR_EXIT
			END
			--Add captured clients to EntitiesCaptured list
			INSERT INTO CCMEntitiesCaptured
SELECT DISTINCT @l_curCaptureJobId, 2, a.Id, 0, 3, null
FROM #CCM_APP_Client a LEFT OUTER JOIN CCMEntitiesCaptured b
				ON a.Id = b.EntityId AND b.EntityCCId = 0
AND b.EntityType = 3 AND b.CaptureJobId = @l_curCaptureJobId
			WHERE b.EntityId IS NULL
			IF	@@ERROR > 0
			BEGIN
				SET @errorStr = 'ERROR: CCM_Capture_SubClien -- CCMEntitiesCaptured -- App_Client'
				GOTO CX_ERROR_EXIT
			END
		END
CX_SKIP_EXIT:
	SET @errorStr = 'NO_ERROR'
	COMMIT	TRANSACTION CCMCAPSUBCLIENT
	IF object_id('tempdb.dbo.#l_errResponse_temp') IS NOT NULL
	BEGIN
		INSERT INTO #l_errResponse_temp VALUES (@errorCode, @errorStr)
	END
	ELSE
		SELECT	@errorCode, @errorStr
	RETURN (@errorCode)
CX_ERROR_EXIT:
	IF (Cursor_Status('LOCAL', 'AccessPathQuestionsCursor') >= -1)
    BEGIN
   		CLOSE AccessPathQuestionsCursor
   		DEALLOCATE AccessPathQuestionsCursor
   	END
	ROLLBACK TRANSACTION CCMCAPSUBCLIENT
	RAISERROR ('%s' , 16, 1, @errorStr)
CX_SAFE_EXIT:
	IF object_id('tempdb.dbo.#l_errResponse_temp') IS NOT NULL
	BEGIN
		INSERT INTO #l_errResponse_temp VALUES (@errorCode, @errorStr)
	END
	ELSE
		SELECT	@errorCode, @errorStr
	RETURN (@errorCode)
GO


IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_SubClient_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_SubClient_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SubClient_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SubClient_to_XML'
GO

insert into GXDBVersions values(2, 'CCM_Capture_SubClient_to_XML',  '00010005007200040000', 'CCM_Capture_SubClient_to_XML', '00010005007200040000')
GO

