

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_SubClient_to_80.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture sub-client to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_SubClient_to_80.sp,v 1.5.72.2 2018/03/20 00:35:08 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_SubClient_to_80 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_SubClient_to_80')
	drop procedure CCM_Capture_SubClient_to_80
IF EXISTS (select * from GxQscripts where name='CCM_Capture_SubClient_to_80')
	delete from GxQscripts where name = 'CCM_Capture_SubClient_to_80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SubClient_to_80')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SubClient_to_80'
GO
print '... Creating Procedure: CCM_Capture_SubClient_to_80'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_SubClient_to_80
  @i_subClientId integer,
  @i_clientId integer,
  @time_from integer,
  @time_to integer,
  @i_captureActivityControl integer,
  @i_captureHolidays integer,
  @i_captureOperationWindow integer,
  @i_captureSchedule integer,
  @s_dumpSetName varchar(128),
  @isDefaultSubClient integer,
  @ccmParamFlags integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024)
AS
--Code Below Here is From CCM_Capture_SubClient.spb
  DECLARE @errorCode integer;
  DECLARE @errorStr varchar(1024);
   DECLARE @SRMAppTypeId	 integer;
SET NOCOUNT ON
        -- 1) Validate if the specified sub-client can be migrated.
        --      If not and if global option is set to fail CCM,  return fatel error
        --      If not and if global option is not set to fail CCM, return error
        -- 2) Once validations are done, insert records into CCM_APP_Application
        -- 3) Invoke CCM_Capture_Client for the client corresponding to the specified sub-client
        -- 4) Invoke CCM_Capture_Main for the specified time
        -- 5) Commit transaction and return to caller
        SET @errorCode = 0
        SET @errorStr = 'ERROR: GENERAL ERROR!'
        -----------------------------------------------------------------------------------------
		BEGIN TRANSACTION CCMCAPSUBCLIENT
        IF (@i_subClientId < 0) -- 0 indicates the request is to capture the client without any sub-clients
     	BEGIN
 	        SET @errorStr = 'ERROR: CCM_Capture_SubClient -- Invalid subclient'
		    GOTO CX_ERROR_EXIT
	    END
	    IF (@time_from < 0 OR @time_to < 0)
     	BEGIN
 	        SET @errorStr = 'ERROR: CCM_Capture_SubClient -- Invalid Time(s)'
		    GOTO CX_ERROR_EXIT
	    END
	    -- The client id can't be determined from the sub-client id for clients
	    -- which don't have any sub-clients and capture of such clients needs
	    -- to be supported.
	    IF(@i_clientId <= 1) -- 1 is the dummy client
	    BEGIN
	        SET @errorStr = 'ERROR: CCM_Capture_SubClient -- Invalid client'
		    GOTO CX_ERROR_EXIT
	    END
		-- When capture is done from staged DR Restore (staging DR via CommServDisasterRecoveryTool.exe will set the passwords to empty and changes net_hostname to _disabled) we should fail capture of such clients.
		DECLARE @ClientName VARCHAR(1024)
		SET @ClientName = ISNULL ((SELECT name FROM CCM_SOURCE_APP_Client WHERE id = @i_clientId AND client_password = ''), '')
		IF @ClientName <> ''
		BEGIN
			SET @errorStr = 'ERROR: CCM_Capture_SubClient -- client ['+ @ClientName +'] has no client password, run capture from original database or skip this clent from capture.'
			GOTO CX_ERROR_EXIT
		END
        -----------------------------------------------------------------------------------------
        /*IF NOT EXISTS (SELECT * FROM APP_Application WHERE id = @i_subClientId AND appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(99)))
        BEGIN
        DECLARE @subClientName nvarchar(256)
        SET @subClientName = (SELECT subclientName FROM APP_Application WHERE id = @i_subClientId)
         IF EXISTS (SELECT * FROM MMConfigs where name = 'CCM_CONFIG_FAIL_MIGRATION_FOR_UNSUPPORTED_APPLICATIONS' and value = 1)
         BEGIN
             SET @errorStr = 'ERROR: Unsupported Application Types selected for Migration. Please unselect the sub-clients ' + @subClientName
             SET @errorCode = -2
             GOTO CX_SAFE_EXIT
         END
         ELSE IF EXISTS (SELECT * FROM MMConfigs where name = 'CCM_CONFIG_FAIL_MIGRATION_FOR_UNSUPPORTED_APPLICATIONS' and value = 0)
         BEGIN
             SET @errorStr = 'ERROR: Unsupported Application Types selected for Migration. Ignore capture of the sub-clients' + @subClientName
             SET @errorCode = -1
             GOTO CX_SAFE_EXIT
         END
        END
        IF (@validateSubClient > 0)
        BEGIN
          GOTO CX_SAFE_EXIT
        END*/
        -----------------------------------------------------------------------------------------
		-- CommServ_Capture..CCM_APP_Application
INSERT INTO CommServ_Capture..CCM_APP_Application
	    SELECT
	    id, clientId, appTypeId, instance, backupSet, appNumber,
	    dataArchGrpID, logArchGrpID, refTime, modified, subclientName, subclientStatus
	    FROM CCM_SOURCE_APP_Application
	    WHERE id = @i_subClientId
AND id not in (SELECT id FROM CommServ_Capture..CCM_APP_Application)
	    IF	@@ERROR > 0
	    BEGIN
		    SET @errorStr = 'ERROR: CCM_Capture_SubClient -- CCM_APP_Application'
		    GOTO CX_ERROR_EXIT
	    END
        -----------------------------------------------------------------------------------------
        -- CCM_Capture_Client
        EXEC @errorCode = CCM_Capture_Client_to_80 @i_clientId
        IF @errorCode <> 0
        BEGIN
               SET @errorStr = 'ERROR: CCM_Capture_SubClient -- CCM_Capture_Client'
               GOTO CX_ERROR_EXIT
        END
        -----------------------------------------------------------------------------------------
        -- CCM_Capture_Main
        EXEC @errorCode = CCM_Capture_Main_to_80 @i_subClientId, @i_clientId , @time_from, @time_to, @i_captureActivityControl, @i_captureHolidays, @i_captureOperationWindow, @i_captureSchedule, @isDefaultSubClient, @ccmParamFlags, @i_isExportFromLinkedServer, @i_exportDBName, @errorString = @errorStr OUTPUT
        IF @errorCode <> 0
        BEGIN
               GOTO CX_ERROR_EXIT
        END
	    -----------------------------------------------------------------------------------------
	    /*
			@isDefaultSubClient <> 0 if the procedure call is to capture only configuration
			for defaultSubClient of the backupset
			This is needed when the user selects a subClient from the backupSet but not the
			defaultSubCliet.
			Every backupSet needs defaultSubClient for proper functionality of other SubClients
			Hence capturing only certain App_ configuration tables for defaultSubClient
			No need of questions and answers in this case
		*/
		IF @isDefaultSubClient <> 0
		BEGIN
			GOTO CX_SKIP_EXIT
		END
CX_SKIP_EXIT:
	SET @errorStr = 'NO_ERROR'
	COMMIT	TRANSACTION CCMCAPSUBCLIENT
	IF object_id('tempdb.dbo.#l_errResponse_temp') IS NOT NULL
	BEGIN
		INSERT INTO #l_errResponse_temp VALUES (@errorCode, @errorStr)
	END
	ELSE
		SELECT	@errorCode, @errorStr
	RETURN (@errorCode)
CX_ERROR_EXIT:
	IF (Cursor_Status('LOCAL', 'AccessPathQuestionsCursor') >= -1)
    BEGIN
   		CLOSE AccessPathQuestionsCursor
   		DEALLOCATE AccessPathQuestionsCursor
   	END
	ROLLBACK TRANSACTION CCMCAPSUBCLIENT
	RAISERROR ('%s' , 16, 1, @errorStr)
CX_SAFE_EXIT:
	IF object_id('tempdb.dbo.#l_errResponse_temp') IS NOT NULL
	BEGIN
		INSERT INTO #l_errResponse_temp VALUES (@errorCode, @errorStr)
	END
	ELSE
		SELECT	@errorCode, @errorStr
	RETURN (@errorCode)
GO


IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_SubClient_to_80')
	delete from GxQscripts where name = 'CCM_Capture_SubClient_to_80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SubClient_to_80')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SubClient_to_80'
GO

insert into GXDBVersions values(2, 'CCM_Capture_SubClient_to_80',  '00010005007200020000', 'CCM_Capture_SubClient_to_80', '00010005007200020000')
GO

