

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_SubClient_To_90.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture sub-client to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_SubClient_To_90.sp,v 1.3.72.2 2018/03/20 00:36:02 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_SubClient_To_90 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_SubClient_To_90')
	drop procedure CCM_Capture_SubClient_To_90
IF EXISTS (select * from GxQscripts where name='CCM_Capture_SubClient_To_90')
	delete from GxQscripts where name = 'CCM_Capture_SubClient_To_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SubClient_To_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SubClient_To_90'
GO
print '... Creating Procedure: CCM_Capture_SubClient_To_90'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_SubClient_To_90
  @i_subClientId integer,
  @i_clientId integer,
  @time_from integer,
  @time_to integer,
  @i_captureActivityControl integer,
  @i_captureHolidays integer,
  @i_captureOperationWindow integer,
  @i_captureSchedule integer,
  @s_dumpSetName varchar(128),
  @isDefaultSubClient integer,
  @ccmParamFlags integer,
  @i_jobId integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024)
AS
--Code Below Here is From CCM_Capture_SubClient.spb
  DECLARE @errorCode integer;
  DECLARE @errorStr varchar(1024);
   DECLARE @SRMAppTypeId	 integer;
SET NOCOUNT ON
        -- 1) Validate if the specified sub-client can be migrated.
        --      If not and if global option is set to fail CCM,  return fatel error
        --      If not and if global option is not set to fail CCM, return error
        -- 2) Once validations are done, insert records into CCM_APP_Application
        -- 3) Invoke CCM_Capture_Client for the client corresponding to the specified sub-client
        -- 4) Invoke CCM_Capture_Main for the specified time
        -- 5) Commit transaction and return to caller
        SET @errorCode = 0
        SET @errorStr = 'ERROR: GENERAL ERROR!'
		IF (@ccmParamFlags & 1) = 1 --GRC Job
		BEGIN
			UPDATE MMConfigs SET value = 0 WHERE name =	'GRC_CONFIG_DISABLE_JMJOBDATASTATS_TRACKING' AND value <> 0
		END
        -----------------------------------------------------------------------------------------
		BEGIN TRANSACTION CCMCAPSUBCLIENT
        IF (@i_subClientId < 0) -- 0 indicates the request is to capture the client without any sub-clients
     	BEGIN
 	        SET @errorStr = 'ERROR: CCM_Capture_SubClient -- Invalid subclient'
		    GOTO CX_ERROR_EXIT
	    END
	    IF (@time_from < 0 OR @time_to < 0)
     	BEGIN
 	        SET @errorStr = 'ERROR: CCM_Capture_SubClient -- Invalid Time(s)'
		    GOTO CX_ERROR_EXIT
	    END
	    -- The client id can't be determined from the sub-client id for clients
	    -- which don't have any sub-clients and capture of such clients needs
	    -- to be supported.
	    IF(@i_clientId <= 1) -- 1 is the dummy client
	    BEGIN
	        SET @errorStr = 'ERROR: CCM_Capture_SubClient -- Invalid client'
		    GOTO CX_ERROR_EXIT
	    END
		-- When capture is done from staged DR Restore (staging DR via CommServDisasterRecoveryTool.exe will set the passwords to empty and changes net_hostname to _disabled) we should fail capture of such clients.
		DECLARE @ClientName VARCHAR(1024)
		SET @ClientName = ISNULL ((SELECT name FROM CCM_SOURCE_APP_Client WHERE id = @i_clientId AND client_password = ''), '')
		IF @ClientName <> ''
		BEGIN
			SET @errorStr = 'ERROR: CCM_Capture_SubClient -- client ['+ @ClientName +'] has no client password, run capture from original database or skip this clent from capture.'
			GOTO CX_ERROR_EXIT
		END
        -----------------------------------------------------------------------------------------
        /*IF NOT EXISTS (SELECT * FROM APP_Application WHERE id = @i_subClientId AND appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(99)))
        BEGIN
        DECLARE @subClientName nvarchar(256)
        SET @subClientName = (SELECT subclientName FROM APP_Application WHERE id = @i_subClientId)
         IF EXISTS (SELECT * FROM MMConfigs where name = 'CCM_CONFIG_FAIL_MIGRATION_FOR_UNSUPPORTED_APPLICATIONS' and value = 1)
         BEGIN
             SET @errorStr = 'ERROR: Unsupported Application Types selected for Migration. Please unselect the sub-clients ' + @subClientName
             SET @errorCode = -2
             GOTO CX_SAFE_EXIT
         END
         ELSE IF EXISTS (SELECT * FROM MMConfigs where name = 'CCM_CONFIG_FAIL_MIGRATION_FOR_UNSUPPORTED_APPLICATIONS' and value = 0)
         BEGIN
             SET @errorStr = 'ERROR: Unsupported Application Types selected for Migration. Ignore capture of the sub-clients' + @subClientName
             SET @errorCode = -1
             GOTO CX_SAFE_EXIT
         END
        END
        IF (@validateSubClient > 0)
        BEGIN
          GOTO CX_SAFE_EXIT
        END*/
        -----------------------------------------------------------------------------------------
		-- CommServ_Capture..CCM_APP_Application
INSERT INTO CommServ_Capture..CCM_APP_Application
	    SELECT
	    *
	    FROM CCM_SOURCE_APP_Application
	    WHERE id = @i_subClientId
AND id not in (SELECT id FROM CommServ_Capture..CCM_APP_Application)
	    IF	@@ERROR > 0
	    BEGIN
		    SET @errorStr = 'ERROR: CCM_Capture_SubClient -- CCM_APP_Application'
		    GOTO CX_ERROR_EXIT
	    END
        -----------------------------------------------------------------------------------------
        -- CCM_Capture_Client
        EXEC @errorCode = CCM_Capture_Client_to_90 @i_clientId
        IF @errorCode <> 0
        BEGIN
               SET @errorStr = 'ERROR: CCM_Capture_SubClient -- CCM_Capture_Client'
               GOTO CX_ERROR_EXIT
        END
        -----------------------------------------------------------------------------------------
        -- CCM_Capture_Main
        EXEC @errorCode = CCM_Capture_Main_To_90 @i_subClientId, @i_clientId , @time_from, @time_to, @i_captureActivityControl, @i_captureHolidays, @i_captureOperationWindow, @i_captureSchedule, @isDefaultSubClient, @ccmParamFlags, @i_jobId, @i_isExportFromLinkedServer, @i_exportDBName, @errorString = @errorStr OUTPUT
        IF @errorCode <> 0
        BEGIN
               GOTO CX_ERROR_EXIT
        END
	    -----------------------------------------------------------------------------------------
	    /*
			@isDefaultSubClient <> 0 if the procedure call is to capture only configuration
			for defaultSubClient of the backupset
			This is needed when the user selects a subClient from the backupSet but not the
			defaultSubCliet.
			Every backupSet needs defaultSubClient for proper functionality of other SubClients
			Hence capturing only certain App_ configuration tables for defaultSubClient
			No need of questions and answers in this case
		*/
		IF @isDefaultSubClient <> 0
		BEGIN
			GOTO CX_SKIP_EXIT
		END
		-------------------------------------------------------------------------------------------
	    -- Populate the questions into the CommServ Database tables keeping track of questions
	    INSERT INTO CCMMountPathMapping
        SELECT DISTINCT @s_dumpSetName, a.MountPathId, a.newLibraryId, a.newMountPathName, a.newUserName, a.newPassword, a.MountPathName,
                        a.SourceMediaAgentId,a.SourceMediaAgentName, a.MountPathType, a.TargetDeviceMediaAgentId, a.SourceDeviceId, a.SourceDeviceName
FROM   CommServ_Capture..CCM_MountPathMapping a
				LEFT OUTER JOIN CCMMountPathMapping b
				ON b.dumpSetName           = @s_dumpSetName
				  AND b.MountPathId           = a.MountPathId
		WHERE	b.MountPathId IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errorStr = 'ERROR: CCM_Capture_SubClient -- CCMMountPathMapping -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO CCMDevicePathMapping
		SELECT DISTINCT @s_dumpSetName,A.SourceDeviceId, A.SourceDeviceName, A.SourceDevicePath, A.newMediaAgentId, A.newDevicePath, A.newUserName, A.newPassword
FROM CommServ_Capture..CCM_DevicePathMapping A
				LEFT OUTER JOIN CCMDevicePathMapping B
				ON @s_dumpSetName = B.dumpSetName
				AND A.SourceDeviceId = B.SourceDeviceId
		WHERE	B.SourceDeviceId IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errorStr = 'ERROR: CCM_Capture_SubClient -- CCMDevicePathMapping -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO CCMClientNameMapping
		SELECT DISTINCT @s_dumpSetName, a.name, a.net_hostname, '', ''
FROM   CommServ_Capture..CCM_APP_Client a
				LEFT OUTER JOIN CCMClientNameMapping b
		        ON b.dumpSetName = @s_dumpSetName
					AND b.old_name = a.name
		WHERE	b.old_name IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errorStr = 'ERROR: CCM_Capture_SubClient -- CCMClientNameMapping -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		--Populate CCMEntitiesCaptured table to keep track of captured entities
		--Get Current capture jobid
		DECLARE @l_curCaptureJobId Integer
		SET @l_curCaptureJobId =  ISNULL
		(
			(
				@i_jobId
			), 0
		)
		--Add captured copies to EntitiesCaptured list
		IF @l_curCaptureJobId <> 0 -- lpulickal edit , capture_job_id foreign key error
		BEGIN
			INSERT INTO CCMEntitiesCaptured
SELECT DISTINCT @l_curCaptureJobId, 2, a.Id, 0, 18, null
FROM CommServ_Capture..CCM_archGroupCopy a LEFT OUTER JOIN CCMEntitiesCaptured b
				ON a.Id = b.EntityId AND b.EntityCCId = 0
AND b.EntityType = 18 AND b.CaptureJobId = @l_curCaptureJobId
			WHERE b.EntityId IS NULL
			IF	@@ERROR > 0
			BEGIN
				SET @errorStr = 'ERROR: CCM_Capture_SubClien -- CCMEntitiesCaptured -- ArchGroupCopy'
				GOTO CX_ERROR_EXIT
			END
			--Add captured stores to EntitiesCaptured list
			INSERT INTO CCMEntitiesCaptured
SELECT DISTINCT @l_curCaptureJobId, 2, a.SIDBStoreId, 0, 41, null
FROM CommServ_Capture..CCM_IdxSIDBStore a LEFT OUTER JOIN CCMEntitiesCaptured b
				ON a.SIDBStoreId = b.EntityId AND b.EntityCCId = 0
AND b.EntityType = 41 AND b.CaptureJobId = @l_curCaptureJobId
			WHERE b.EntityId IS NULL
			IF	@@ERROR > 0
			BEGIN
				SET @errorStr = 'ERROR: CCM_Capture_SubClien -- CCMEntitiesCaptured -- IdxSIDBStore'
				GOTO CX_ERROR_EXIT
			END
			--Add captured clients to EntitiesCaptured list
			INSERT INTO CCMEntitiesCaptured
SELECT DISTINCT @l_curCaptureJobId, 2, a.Id, 0, 3, null
FROM CommServ_Capture..CCM_APP_Client a LEFT OUTER JOIN CCMEntitiesCaptured b
				ON a.Id = b.EntityId AND b.EntityCCId = 0
AND b.EntityType = 3 AND b.CaptureJobId = @l_curCaptureJobId
			WHERE b.EntityId IS NULL
			IF	@@ERROR > 0
			BEGIN
				SET @errorStr = 'ERROR: CCM_Capture_SubClien -- CCMEntitiesCaptured -- App_Client'
				GOTO CX_ERROR_EXIT
			END
		END
CX_SKIP_EXIT:
	SET @errorStr = 'NO_ERROR'
	COMMIT	TRANSACTION CCMCAPSUBCLIENT
	IF object_id('tempdb.dbo.#l_errResponse_temp') IS NOT NULL
	BEGIN
		INSERT INTO #l_errResponse_temp VALUES (@errorCode, @errorStr)
	END
	ELSE
		SELECT	@errorCode, @errorStr
	RETURN (@errorCode)
CX_ERROR_EXIT:
	IF (Cursor_Status('LOCAL', 'AccessPathQuestionsCursor') >= -1)
    BEGIN
   		CLOSE AccessPathQuestionsCursor
   		DEALLOCATE AccessPathQuestionsCursor
   	END
	ROLLBACK TRANSACTION CCMCAPSUBCLIENT
	RAISERROR ('%s' , 16, 1, @errorStr)
CX_SAFE_EXIT:
	IF object_id('tempdb.dbo.#l_errResponse_temp') IS NOT NULL
	BEGIN
		INSERT INTO #l_errResponse_temp VALUES (@errorCode, @errorStr)
	END
	ELSE
		SELECT	@errorCode, @errorStr
	RETURN (@errorCode)
GO


IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_SubClient_To_90')
	delete from GxQscripts where name = 'CCM_Capture_SubClient_To_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SubClient_To_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SubClient_To_90'
GO

insert into GXDBVersions values(2, 'CCM_Capture_SubClient_To_90',  '00010003007200020000', 'CCM_Capture_SubClient_To_90', '00010003007200020000')
GO

