

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Set_Priority.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Sets the priority for the entities to be captured
--  +========================================================================+
-- $Id: CCM_Capture_Set_Priority.sp,v 1.22.12.26.20.1 2021/05/24 18:09:30 pnara Exp $
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCM_Capture_Set_Priority')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_Set_Priority <<<'
	drop procedure CCM_Capture_Set_Priority
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Set_Priority')
	delete from GxQscripts where name = 'CCM_Capture_Set_Priority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Set_Priority')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Set_Priority'
GO
print '... Creating Procedure: CCM_Capture_Set_Priority'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCM_Capture_Set_Priority
  @i_jobId integer,
  @i_no_of_subclients integer = 1,
  @time_from integer = 0,
  @time_to integer = 0,
  @i_capture_complete_cluster integer = 0,
  @i_csGUID varchar(36),
  @i_isGRC integer = 0,
  @i_isExportFromLinkedServer integer = 0,
  @i_exportDBName varchar(36)
AS
  DECLARE @errorString varchar(1024);
SET NOCOUNT ON
    SET @errorString = 'ERROR: GENERAL ERROR!'
    SET NOCOUNT ON
	---------------------------------------------------------
	IF NOT EXISTS (select 1 FROM MASTER..SYSDATABASES WHERE NAME = 'CommServ')
	BEGIN
		SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- DATABASE CommServ DOES NOT EXIST'
		GOTO CX_ERROR_EXIT
	END
	/*
	 Update the Priority of CCMCaptureEntities table as per the application need
	 Priority is set as 1 for IndexingSubClient to make sure that indexing sub clients
	 are processed first for both capture and merge.
	 */
	 UPDATE Commserv..CCMCaptureEntities
	 SET priority = 1
	 FROM Commserv..CCMCaptureEntities a, CCM_SOURCE_APP_Application b
	 WHERE a.type = 7                            -- EntityType_SUBCLIENT_ENTITY (CvEntitiesMsgs.h)
	   AND a.value = CAST(b.id as varchar(32))
	   AND b.subClientName = 'IndexingSubclient'
	   AND a.jobId = @i_jobId
	 IF @@ERROR > 0
	 BEGIN
	    SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- UPDATE -- priority'
		GOTO CX_ERROR_EXIT
	 END
	 /*******************************************************************************************************************
	 *
	 *                         Changes to take care of capture of clustered clients
	 *
	 ********************************************************************************************************************/
	 /*
								This module make sure to have dependent snap clients(not part of cluster) in the same dump
								and also if the cluster clients have dependent snap clients they will get into the dump with the cluster together
	 */
	 /*
	   	 for each row in CCMCaptureEntities of type 7 and for the specific Job
	     {
		   fetch the client id and determine if it a clustered client
		   if(not clustered)
			  if(! client id has dependent snap clients)
				continue to the next row in CCMCaptureEntities
			  else
				add the dependent clients to snap_clients list
		   else
			  fetch all the clients as a part of the cluster and also the dependent snap clients of them
			  Note: there are 2 cases.
			  Case 1: In nonclustered client, this list of clients we fetch will contain only the dependent snaps which need to stay together
			  Case 2: If clustered it will have the cluster clients and also their dependent snap clients
			  if(any of the dependent client's sub-client is already stored in CCMCaptureEntities)
				 note down the ids to delete them from CCMCaptureEntities
				 form a id, kind of string and update them in the current row
				 delete the already stored rows in CCMCaptureEntities
			  else
				form a id, kind of string for all sub-clients of the specific client id and update them in the current row
		 }
	 */
	 DECLARE @subClientId INTEGER
	 DECLARE @clientId INTEGER
	 DECLARE @clusterClientId INTEGER
	 DECLARE @rowId INTEGER
	 DECLARE @cluster_clients TABLE (id integer)
	 IF OBJECT_ID('tempdb..#subclientlist') IS NOT NULL DROP TABLE #subclientlist
		CREATE TABLE #subclientlist (rowId integer, subClientId integer, PRIMARY KEY (rowId, subClientId))
	 DECLARE @toDelete TABLE(id integer)
	 DECLARE @valueString VARCHAR(max)
	 DECLARE CCM_CCMCaptureEntitiesCursor Cursor LOCAL For
	 SELECT id, value FROM CCMCaptureEntities
	 WHERE type = 7
	   AND jobId = @i_jobId
	   AND @i_capture_complete_cluster = 1
	 OPEN CCM_CCMCaptureEntitiesCursor
     FETCH NEXT FROM CCM_CCMCaptureEntitiesCursor
     INTO @rowId, @subClientId
     WHILE @@FETCH_STATUS = 0
     BEGIN
        SET @clientId = 0
        SET @clientId = (SELECT clientId FROM CCM_SOURCE_APP_Application WHERE id = @subClientId)
        IF (@clientId <= 1)
        BEGIN
          SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- Invalid Client Id'
		  GOTO CX_ERROR_EXIT
        END
        -- GetClusterClientsForClient will return a list of clients forming the cluster
        -- to which @clientId belongs.
        -- It returns nothing in case @clientId isn't a part of any particular cluster
        INSERT INTO @cluster_clients
        SELECT * FROM GetClusterClientsForClient(@clientId)
        IF @@ROWCOUNT = 0
      	BEGIN
			FETCH NEXT FROM CCM_CCMCaptureEntitiesCursor
			INTO @rowId, @subClientId
			CONTINUE
		END
        DECLARE CCM_ClusterClientsCursor Cursor LOCAL For
        SELECT id FROM @cluster_clients --@cluster_clients
        OPEN CCM_ClusterClientsCursor
        FETCH NEXT FROM CCM_ClusterClientsCursor
        INTO @clusterClientId
        WHILE @@FETCH_STATUS = 0
        BEGIN
            IF NOT EXISTS (select 1 FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
                           WHERE a.value = CAST(b.id AS varchar(32))
                             AND a.type = 7
                             AND a.jobId = @i_jobId
                             AND b.clientId = @clusterClientId)
            BEGIN
				-- None of the sub-client(s) of the dependent cluster is selected in GuI
				-- Hence, automatically consider all sub-clients of the selected cluster clientId
				-- Automatic consideration is not for snap clients.
				INSERT INTO #subclientlist
				SELECT @rowId, id
				FROM CCM_SOURCE_APP_Application
				WHERE clientId = @clusterClientId
				IF @@ERROR > 0
				BEGIN
					SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- #subclientlist -- INSERT -- All subclients of the cluster'
					GOTO CX_ERROR_EXIT
				END
            END
            ELSE
            BEGIN
               -- Few or all sub-client(s) of the dependent cluster is selected in GuI
               -- Hence, consider only the selected ones.
               -- Delete the corresponding rows in CCMCaptureEntities
               INSERT INTO #subclientlist
               SELECT @rowId, b.id
               FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
               WHERE a.value = CAST(b.id AS varchar(32))
                 AND a.type = 7
                 AND a.jobId = @i_jobId
                 AND b.clientId = @clusterClientId
                 AND a.id <> @rowId
		       IF @@ERROR > 0
			   BEGIN
				   SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- #subclientlist -- INSERT -- Selected subclients'
				   GOTO CX_ERROR_EXIT
			   END
               INSERT INTO @toDelete
               SELECT a.id
               FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
               WHERE a.value = CAST(b.id AS varchar(32))
                 AND a.type = 7
                 AND a.jobId = @i_jobId
                 AND b.clientId = @clusterClientId
                 AND a.id <> @rowId
		       IF @@ERROR > 0
			   BEGIN
				   SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- @toDelete -- INSERT -- Selected subclients'
				   GOTO CX_ERROR_EXIT
			   END
			   -- delete from CCMCaptureEntities for all ids which have been marked to be deleted
			   -- This is needed because, the entire cluster should be captured in a single dump
			   -- and merged in a single go (attempt)
			   DELETE FROM CCMCaptureEntities
			   WHERE id IN (SELECT id from @toDelete)
			   IF @@ERROR > 0
			   BEGIN
			  	  SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- DELETE'
			  	  GOTO CX_ERROR_EXIT
			   END
			   DELETE FROM @toDelete
			   IF @@ERROR > 0
			   BEGIN
			  	  SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- @toDelete -- DELETE'
			  	  GOTO CX_ERROR_EXIT
			   END
            END
			FETCH NEXT FROM CCM_ClusterClientsCursor
			INTO @clusterClientId
        END
        CLOSE CCM_ClusterClientsCursor
   	    DEALLOCATE CCM_ClusterClientsCursor
        DELETE FROM @cluster_clients
		IF @@ERROR > 0
		BEGIN
		   SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- @cluster_clients -- DELETE'
		   GOTO CX_ERROR_EXIT
		END
		FETCH NEXT FROM CCM_CCMCaptureEntitiesCursor
        INTO @rowId, @subClientId
     END
     CLOSE CCM_CCMCaptureEntitiesCursor
   	 DEALLOCATE CCM_CCMCaptureEntitiesCursor
   	 DECLARE CCM_SubClientCursor Cursor LOCAL For
     SELECT DISTINCT rowId FROM #subclientlist
     OPEN CCM_SubClientCursor
     FETCH NEXT FROM CCM_SubClientCursor
     INTO @rowId
     WHILE @@FETCH_STATUS = 0
     BEGIN
        SET @valueString = null
        SELECT @valueString = COALESCE(@valueString + '_','') + cast(subClientId as varchar(32))
        FROM #subclientlist
        WHERE rowId = @rowId
   	    IF @@ERROR > 0
	    BEGIN
	       SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- @valueString'
	       GOTO CX_ERROR_EXIT
	    END
        UPDATE CCMCaptureEntities
        SET value = value + '_' + @valueString
        WHERE id = @rowId
   	    IF @@ERROR > 0
	    BEGIN
	       SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- UPDATE -- value'
	       GOTO CX_ERROR_EXIT
	    END
		FETCH NEXT FROM CCM_SubClientCursor
        INTO @rowId
     END
     CLOSE CCM_SubClientCursor
     DEALLOCATE CCM_SubClientCursor
	 /*******************************************************************************************************************
	 *
	 *                         Changes to take care of capturing VSA clients
	 *
	 ********************************************************************************************************************/
	 /*
	 1. If VSA client is selected,
		a. Capture all the VM clients for that VSA client.
		b. Skip "VSA Discover SubclientId" property for the VM clients if any of the above selected VMs are referring to different VSA client.
		c. make sure all go to single dump.
	*/
	 DECLARE @VMClients TABLE(VMClientId integer)
	 DECLARE @memberServers TABLE(vsMemberServers xml)
	 DECLARE @ProxyClients TABLE(clientId integer)
	 DECLARE @VMClientId INT
	 DECLARE @VSAClientId INT
	 DELETE FROM #subclientlist
	 DECLARE CCM_VSAClientCursor Cursor LOCAL For
	 SELECT A.id, B.id, B.clientId
	 FROM CCMCaptureEntities A
		INNER JOIN CCM_SOURCE_APP_Application B ON A.value = CAST(B.id AS varchar(32))
		INNER JOIN CCM_SOURCE_App_InstanceProp C ON B.instance = C.componentNameId AND C.attrName = 'Virtual Server Instance Type'
		INNER JOIN APP_ClientProp CL ON CL.componentNameId = B.clientId
	 WHERE CHARINDEX('_',A.value) = 0
		 AND A.type = 7
		 AND A.jobId = @i_jobId
AND B.appTypeId = 106
		 AND CL.attrName = 'IndexingV2_VSA' AND CL.attrVal = 1 AND CL.modified = 0
	 OPEN CCM_VSAClientCursor
     FETCH NEXT FROM CCM_VSAClientCursor
     INTO @rowId, @subClientId, @VSAClientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO @VMClients
		SELECT DISTINCT componentNameId
		FROM CCM_SOURCE_APP_ClientProp
WHERE attrName = 'VSA Discover Subclient ID' AND CAST(attrVal AS INT) = @subClientId AND modified = 0
		IF @@ROWCOUNT = 0
		BEGIN
			FETCH NEXT FROM CCM_VSAClientCursor
			INTO @rowId, @subClientId, @VSAClientId
			CONTINUE
		END
		DECLARE CCM_VMClientsCursor Cursor LOCAL For
		SELECT VMClientId FROM @VMClients
		OPEN CCM_VMClientsCursor
		FETCH NEXT FROM CCM_VMClientsCursor
		INTO @VMClientId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF NOT EXISTS (select 1 FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
						   WHERE a.value = CAST(b.id AS varchar(32))
							 AND a.type = 7
							 AND a.jobId = @i_jobId
							 AND CHARINDEX('_', a.value) = 0
							 AND b.clientId = @VMClientId)
			BEGIN
				-- None of the sub-client(s) of the VM client is selected in GuI
				-- Hence, automatically consider all sub-clients of the selected VM clientId
				INSERT INTO #subclientlist
				SELECT DISTINCT @rowId, JM.childAppid
				FROM CCM_SOURCE_JMJobDataLink JM INNER JOIN CCM_SOURCE_APP_Application APP ON JM.childAppid = APP.id
				WHERE JM.parentAppid = @subClientId	AND APP.clientId = @VMClientId
				IF @@ERROR > 0
				BEGIN
					SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- #subclientlist -- INSERT -- All subclients of the VM client.'
					GOTO CX_ERROR_EXIT
				END
			END
			ELSE
			BEGIN
			   -- Few or all sub-client(s) of the VM client is selected in GuI
			   -- Hence, consider only the selected ones.
			   -- Delete the corresponding rows in CCMCaptureEntities
			   INSERT INTO #subclientlist
			   SELECT @rowId, b.id
			   FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
			   WHERE a.value = CAST(b.id AS varchar(32))
				 AND a.type = 7
				 AND a.jobId = @i_jobId
				 AND b.clientId = @VMClientId
				 AND CHARINDEX('_',value) = 0
			   IF @@ERROR > 0
			   BEGIN
				   SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- #subclientlist -- INSERT -- Selected subclients for VM client.'
				   GOTO CX_ERROR_EXIT
			   END
			   DELETE CCMCaptureEntities
			   FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
			   WHERE a.value = CAST(b.id AS varchar(32))
				 AND a.type = 7
				 AND a.jobId = @i_jobId
				 AND CHARINDEX('_', a.value) = 0
				 AND b.clientId = @VMClientId
			   IF @@ERROR > 0
			   BEGIN
				  SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- DELETE VM subclients.'
				  GOTO CX_ERROR_EXIT
			   END
			END
			FETCH NEXT FROM CCM_VMClientsCursor
			INTO @VMClientId
		END
		CLOSE CCM_VMClientsCursor
		DEALLOCATE CCM_VMClientsCursor
		DELETE FROM @VMClients
		DELETE FROM @memberServers
		DELETE FROM @ProxyClients
		/*
		Select the proxy clients into to same dump, otherwise we can't merge the memberServers without client entry.
		If atleast one subclient is selected from proxy client, then select that subclient.
		if no subclient selected from proxy, then we don't merge the memberServers for this VSA on destination.
		*/
		INSERT INTO @memberServers
		SELECT CAST(IP.attrVal AS XML)
FROM (SELECT clientid, instance FROM CCM_SOURCE_APP_Application APP WHERE appTypeId = 106 AND clientId = @VSAClientId GROUP BY clientid, instance) AS APP
			INNER JOIN APP_InstanceProp IP ON APP.instance = IP.componentNameId AND IP.attrName = 'Vs Member Servers'
		INSERT INTO @ProxyClients
		SELECT DISTINCT ref.value('client[1]/@clientId', 'INTEGER')
		FROM  @memberServers srvTab cross apply srvTab.vsMemberServers.nodes('App_MemberServers/memberServers') R ( ref )
		INSERT INTO #subclientlist
		SELECT @rowId, b.id
		FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b, @ProxyClients c
		WHERE a.value = CAST(b.id AS varchar(32))
		 AND a.type = 7
		 AND a.jobId = @i_jobId
		 AND b.clientId = c.clientId
		 AND CHARINDEX('_',value) = 0
		IF @@ERROR > 0
		BEGIN
		   SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- #subclientlist -- INSERT -- Selected VM proxy client subclients.'
		   GOTO CX_ERROR_EXIT
		END
		DELETE CCMCaptureEntities
		FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b, @ProxyClients c
		WHERE a.value = CAST(b.id AS varchar(32))
		 AND a.type = 7
		 AND a.jobId = @i_jobId
		 AND CHARINDEX('_', a.value) = 0
		 AND b.clientId = c.clientid
		IF @@ERROR > 0
		BEGIN
		  SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- DELETE Proxy client subclients.'
		  GOTO CX_ERROR_EXIT
		END
		/*
		Get selected subclients for the current VSA client and add them to the same dump.
		*/
	   INSERT INTO #subclientlist
	   SELECT @rowId, b.id
	   FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
	   WHERE a.value = CAST(b.id AS varchar(32))
		 AND a.type = 7
		 AND a.jobId = @i_jobId
		 AND b.id = @subClientId
		 AND CHARINDEX('_',value) = 0
	   IF @@ERROR > 0
	   BEGIN
		   SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- #subclientlist -- INSERT -- Selected VSA client subclients.'
		   GOTO CX_ERROR_EXIT
	   END
	   DELETE CCMCaptureEntities
	   FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
	   WHERE a.value = CAST(b.id AS varchar(32))
		 AND a.type = 7
		 AND a.jobId = @i_jobId
		 AND b.id = @subClientId
		 AND CHARINDEX('_',a.value) = 0
		 AND a.id <> @rowId
	   IF @@ERROR > 0
	   BEGIN
		  SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- DELETE VSA client subclients.'
		  GOTO CX_ERROR_EXIT
	   END
	FETCH NEXT FROM CCM_VSAClientCursor
	INTO @rowId, @subClientId, @VSAClientId
	END
	CLOSE CCM_VSAClientCursor
	DEALLOCATE CCM_VSAClientCursor
	/*
	 2. If VM client is selected but not it's VSA client, then select all the VSA pseudo clients based on the "VSA Discover SubclientId".
	*/
	 DECLARE CCM_VMClientCursor Cursor LOCAL For
	 SELECT A.id, B.id, B.clientId
	 FROM CCMCaptureEntities A
		INNER JOIN CCM_SOURCE_APP_Application B ON A.value = CAST(B.id AS varchar(32))
		INNER JOIN CCM_SOURCE_APP_ClientProp C ON B.clientId = C.componentNameId AND C.attrName = 'Virtual Server Discovered Clients' AND CAST(C.attrVal AS INT) = 1
	 WHERE CHARINDEX('_',A.value) = 0
		 AND A.type = 7
		 AND A.jobId = @i_jobId
	 OPEN CCM_VMClientCursor
     FETCH NEXT FROM CCM_VMClientCursor
     INTO @rowId, @subClientId, @VMClientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO #subclientlist
		SELECT @rowId, CAST(CLPROP.attrVal AS INT)
		FROM CCM_SOURCE_APP_ClientProp CLPROP INNER JOIN CCM_SOURCE_APP_Application APP ON APP.id = CAST(CLPROP.attrVal AS INT)
WHERE CLPROP.attrName = 'VSA Discover Subclient ID' AND CLPROP.componentNameId = @VMClientId
		-- If multiple VMs discovered under same VSA client, we may end up adding same subclient.
			AND NOT EXISTS (SELECT 1 FROM #subClientList WHERE subClientId = CAST(CLPROP.attrVal AS INT))
		IF @@ERROR > 0
		BEGIN
		   SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- #subclientlist -- INSERT -- Selected VM clients subclients.'
		   GOTO CX_ERROR_EXIT
		END
		INSERT INTO #subclientlist
		SELECT @rowId, b.id
		FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
		WHERE a.value = CAST(b.id AS varchar(32))
		 AND a.type = 7
		 AND a.jobId = @i_jobId
		 AND b.clientId = @VMClientId
		 AND CHARINDEX('_',value) = 0
		 AND NOT EXISTS (SELECT 1 FROM #subclientlist c WHERE c.subClientId = b.id)
		IF @@ERROR > 0
		BEGIN
		   SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- #subclientlist -- INSERT -- Selected VM clients subclients --'
		   GOTO CX_ERROR_EXIT
		END
		DELETE CCMCaptureEntities
		FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
		WHERE a.value = CAST(b.id AS varchar(32))
		 AND a.type = 7
		 AND a.jobId = @i_jobId
		 AND b.clientId = @VMClientId
		 AND CHARINDEX('_',a.value) = 0
		 AND a.id <> @rowId
		IF @@ERROR > 0
		BEGIN
		  SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- DELETE VM clients subclients.'
		  GOTO CX_ERROR_EXIT
		END
		FETCH NEXT FROM CCM_VMClientCursor
		INTO @rowId, @subClientId, @VMClientId
	END
	CLOSE CCM_VMClientCursor
	DEALLOCATE CCM_VMClientCursor
	/* Make the dump strings, if the subclient count is is less than config then append the next set of subclients. */
	DECLARE @subClientCountPerDump INT = 0
	SET @subClientCountPerDump = ISNULL((SELECT value FROM MMConfigs WHERE NAME = 'CCM_CONFIG_MAXIMUM_NUMBER_SUBCLIENTS_IN_A_DUMP'), 50)
	DECLARE @subClientCount INT = 0
	DECLARE @prevRowId INT = 0
	DECLARE CCM_VSASubClientCursor Cursor LOCAL For
	SELECT DISTINCT rowId FROM #subclientlist
	OPEN CCM_VSASubClientCursor
	FETCH NEXT FROM CCM_VSASubClientCursor
	INTO @rowId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @subClientCount = 0
		SET @valueString = null
		SELECT @valueString = COALESCE(@valueString + '_','') + cast(subClientId as varchar(32))
		FROM #subclientlist
		WHERE rowId = @rowId
		IF @@ERROR > 0
		BEGIN
		   SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- @valueString'
		   GOTO CX_ERROR_EXIT
		END
		SELECT @subClientCount = COUNT(1) FROM #subclientlist WHERE rowId = @rowId
		WHILE @subClientCount < @subClientCountPerDump
		BEGIN
			SET @prevRowId = @rowId
			FETCH NEXT FROM CCM_VSASubClientCursor
			INTO @rowId
			IF @@FETCH_STATUS <> 0
				BREAK
			DELETE CCMCaptureEntities WHERE id = @prevRowId
			DELETE #subclientlist WHERE rowId = @prevRowId
			SELECT @valueString = COALESCE(@valueString + '_','') + cast(subClientId as varchar(32))
			FROM #subclientlist
			WHERE rowId = @rowId
			SELECT @subClientCount = (@subClientCount + COUNT(1)) FROM #subclientlist WHERE rowId = @rowId
		END
		UPDATE CCMCaptureEntities
		SET value = @valueString
		WHERE id = @rowId
		IF @@ERROR > 0
		BEGIN
		   SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- UPDATE -- value for VSA agent.'
		   GOTO CX_ERROR_EXIT
		END
		FETCH NEXT FROM CCM_VSASubClientCursor
		INTO @rowId
	END
	CLOSE CCM_VSASubClientCursor
	DEALLOCATE CCM_VSASubClientCursor
	/*******************************************************************************************************************
	 *
	 *                Changes to take care of capture of all the sub-clients of Oracle Rac pseudo client
	 *                and their corresponding physical clients in the very same dump file
	 *
	 ********************************************************************************************************************/
	/*
1]Check if sub clients belonging to oracle RAC pseudo client exists for capture (appType - 80)
	2]Get all the physical clients associated with rac instances of this subclient (From App_OracleRACInstance)
	3]Get the subclients of these clients
	4]Have single row with all these subclients (physical and pseudo) in CCMCaptureEntities
	Do this for every oracle Rac Instance
	*/
	DECLARE @ORACLE_RAC_SUBCLIENTS TABLE (scId INTEGER)
	DECLARE @ORACLE_RAC_PSEUDO_INSTANCES TABLE (instanceId integer)
	DECLARE @ORACLE_RAC_PHYSICAL_CLIENTS TABLE (id INTEGER)
	DECLARE @ORACLE_RAC_PHYSICAL_SUBCLIENTS TABLE (scId INTEGER)
	DECLARE @ORACLE_RAC_INSTANCE_SUBCLIENTS TABLE (scId INTEGER)
	DECLARE @racPhysicalClient INTEGER
	DECLARE @racInstance integer
	INSERT INTO @ORACLE_RAC_SUBCLIENTS
	SELECT b.id FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
	WHERE CHARINDEX('_',value) = 0
	AND a.type = 7
	AND a.jobId = @i_jobId
	AND a.value = CAST(b.id AS varchar(32))
AND b.appTypeId = 80
	IF @@ERROR > 0
	BEGIN
	    SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- Insert -- @ORACLE_RAC_SUBCLIENTS'
	    GOTO CX_ERROR_EXIT
	END
	INSERT INTO @ORACLE_RAC_PSEUDO_INSTANCES
	SELECT DISTINCT instance FROM CCM_SOURCE_APP_Application
	WHERE id in (SELECT scID from @ORACLE_RAC_SUBCLIENTS)
	IF @@ERROR > 0
	BEGIN
	    SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- Insert -- @ORACLE_RAC_PSEUDO_INSTANCES'
	    GOTO CX_ERROR_EXIT
	END
	DECLARE OracleRacInstanceCursor CURSOR LOCAL FOR
	SELECT DISTINCT instanceId from @ORACLE_RAC_PSEUDO_INSTANCES
	 OPEN OracleRacInstanceCursor
     FETCH NEXT FROM OracleRacInstanceCursor
     INTO @racInstance
     WHILE @@FETCH_STATUS = 0
     BEGIN
		DELETE FROM @ORACLE_RAC_PHYSICAL_CLIENTS
		DELETE FROM @ORACLE_RAC_PHYSICAL_SUBCLIENTS
		INSERT INTO @ORACLE_RAC_PHYSICAL_CLIENTS
		SELECT DISTINCT clientId from CCM_SOURCE_APP_OracleRacInstance
		WHERE instaceId = @racInstance
		IF @@ERROR > 0
		BEGIN
		    SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- Insert --@ORACLE_RAC_PHYSICAL_CLIENTS'
		    GOTO CX_ERROR_EXIT
		END
		DECLARE CCM_Oracle_RAC_ClientsCursor CURSOR LOCAL For
        SELECT id FROM @ORACLE_RAC_PHYSICAL_CLIENTS
        OPEN CCM_Oracle_RAC_ClientsCursor
        FETCH NEXT FROM CCM_Oracle_RAC_ClientsCursor
        INTO @racPhysicalClient
        WHILE @@FETCH_STATUS = 0
        BEGIN
			-- 3]Get the subclients of these clients
            IF NOT EXISTS (select 1 FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
                           WHERE a.value = CAST(b.id AS varchar(32))
                             AND a.type = 7
                             AND a.jobId = @i_jobId
                             AND b.clientId = @racPhysicalClient)
            BEGIN
				-- None of the sub-client(s) of the dependent cluster is selected in GuI
				-- Hence, automatically consider all sub-clients of the selected cluster clientId
			    INSERT INTO @ORACLE_RAC_PHYSICAL_SUBCLIENTS
			    SELECT id
			    FROM CCM_SOURCE_APP_Application
			    WHERE clientId = @racPhysicalClient
				IF @@ERROR > 0
				BEGIN
					SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- @ORACLE_RAC_PHYSICAL_SUBCLIENTS	 -- Insert'
					GOTO CX_ERROR_EXIT
				END
            END
            ELSE
            BEGIN
               -- Few or all sub-client(s) of the dependent cluster is selected in GuI
               -- Hence, consider only the selected ones.
               -- Delete the corresponding rows in CCMCaptureEntities
               INSERT INTO @ORACLE_RAC_PHYSICAL_SUBCLIENTS
               SELECT b.id
               FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
               WHERE a.value = CAST(b.id AS varchar(32))
                 AND a.type = 7
                 AND a.jobId = @i_jobId
                 AND b.clientId = @racPhysicalClient
                 AND CHARINDEX('_',value) = 0
		       IF @@ERROR > 0
			   BEGIN
				   SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- @ORACLE_RAC_PHYSICAL_SUBCLIENTS	 -- Insert'
				   GOTO CX_ERROR_EXIT
			   END
               DELETE FROM CCMCaptureEntities
               FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
               WHERE a.value = CAST(b.id AS varchar(32))
                 AND a.type = 7
                 AND a.jobId = @i_jobId
                 AND b.clientId = @racPhysicalClient
                 AND CHARINDEX('_',value) = 0
			   IF @@ERROR > 0
			   BEGIN
			  	  SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- Delete for Oracle RAC'
			  	  GOTO CX_ERROR_EXIT
			   END
            END
        FETCH NEXT FROM CCM_Oracle_RAC_ClientsCursor
		INTO @racPhysicalClient
        END
        CLOSE CCM_Oracle_RAC_ClientsCursor
   	    DEALLOCATE CCM_Oracle_RAC_ClientsCursor
   	    DELETE FROM @ORACLE_RAC_INSTANCE_SUBCLIENTS
   	    INSERT INTO @ORACLE_RAC_INSTANCE_SUBCLIENTS
   	    SELECT b.id
        FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
        WHERE a.value = CAST(b.id AS varchar(32))
        AND a.type = 7
        AND a.jobId = @i_jobId
        AND b.instance = @racInstance
        AND CHARINDEX('_',a.value) = 0
		IF @@ERROR > 0
		BEGIN
		    SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- Insert --@ORACLE_RAC_INSTANCE_SUBCLIENTS'
		    GOTO CX_ERROR_EXIT
		END
		SET @rowId = (SELECT top(1) a.id
        FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
        WHERE a.value = CAST(b.id AS varchar(32))
        AND a.type = 7
        AND a.jobId = @i_jobId
        AND b.instance = @racInstance
        AND CHARINDEX('_',value) = 0 )
        IF @@ERROR > 0
		BEGIN
		    SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- Set @rowId - Oracle Rac'
		    GOTO CX_ERROR_EXIT
		END
        DELETE FROM CCMCaptureEntities
        FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
        WHERE a.value = CAST(b.id AS varchar(32))
        AND a.type = 7
        AND a.jobId = @i_jobId
        AND b.instance = @racInstance
        AND a.id <> @rowId
        AND CHARINDEX('_',a.value) = 0
        IF @@ERROR > 0
		BEGIN
		    SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities - Delete For Oracle Rac'
		    GOTO CX_ERROR_EXIT
		END
        DELETE FROM @ORACLE_RAC_SUBCLIENTS
        INSERT INTO @ORACLE_RAC_SUBCLIENTS
        SELECT DISTINCT scId FROM @ORACLE_RAC_PHYSICAL_SUBCLIENTS
        IF @@ERROR > 0
		BEGIN
		    SET @errorString = 'ERROR: CCM_Capture_Set_Priority --INSERT @ORACLE_RAC_SUBCLIENTS'
		    GOTO CX_ERROR_EXIT
		END
        INSERT INTO @ORACLE_RAC_SUBCLIENTS
        SELECT DISTINCT scId FROM @ORACLE_RAC_INSTANCE_SUBCLIENTS
        IF @@ERROR > 0
		BEGIN
		    SET @errorString = 'ERROR: CCM_Capture_Set_Priority --INSERT @ORACLE_RAC_SUBCLIENTS'
		    GOTO CX_ERROR_EXIT
		END
        SET @valueString = null
        SELECT @valueString = COALESCE(@valueString + '_','') + cast(scId as varchar(32))
        FROM @ORACLE_RAC_SUBCLIENTS
        IF @@ERROR > 0
	    BEGIN
	       SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- @valueString FOR Oracle Rac'
	       GOTO CX_ERROR_EXIT
	    END
        -- 4]Have single row with all these subclients (physical and pseudo) in CCMCaptureEntities
        UPDATE CCMCaptureEntities SET value = @valueString WHERE id = @rowId
        IF @@ERROR > 0
	    BEGIN
	       SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- Update FOR Oracle Rac'
	       GOTO CX_ERROR_EXIT
	    END
	 FETCH NEXT FROM OracleRacInstanceCursor
	 INTO @racInstance
     END
     CLOSE OracleRacInstanceCursor
     DEALLOCATE OracleRacInstanceCursor
   /*******************************************************************************************************************
   *				 Changes to take care of capture of SAP HANA physical clients and psuedo clients together in a single dump
   *				 Physical clients obtained from
   *				 App_InstanceProp::attrVal where componentNameId = @instanceId and attrname = 'Database Clients'
   *
   ********************************************************************************************************************/
     /*
If we have subclients of Apptype - 135 to be captured
     {
			For Every Distinct SAP HANA Clients
			{
				Get the list of physical SAP HANA clients to be captured along with this
				{
					*Group the subclients selected for capture of psuedo SAP HANA client
						and the subclients of the other physical clients together in a single row
						of CCMCaptureEntities ('_' separated subclient Ids)
					*Delete from the CCMCaptureEntities If the Subclients
						included in this group also exists in another row (duplicate basically)
				}
			}
	  }
    */
	 IF EXISTS (select 1 from CCMCaptureEntities a, CCM_SOURCE_APP_Application b
	 WHERE CHARINDEX('_',a.value) = 0
	 AND a.jobId = @i_jobId
	 AND a.type = 7
	 AND a.value = CAST(b.id AS varchar(32))
AND b.appTypeId = 135)
	 BEGIN
		DECLARE @SapHanaInstanceId integer
		DECLARE @PhysicalClients TABLE(clientId integer)
		DECLARE @PsuedoAndPhysicalSubClients TABLE (subClientId integer)
		DECLARE	SapHanaClientsCursor CURSOR LOCAL FOR
		SELECT DISTINCT	b.instance from CCMCaptureEntities a, CCM_SOURCE_APP_Application b
		WHERE CHARINDEX('_',a.value) = 0
		AND a.jobId = @i_jobId
		AND a.type = 7
		AND a.value = CAST(b.id AS varchar(32))
AND b.appTypeId = 135
		OPEN SapHanaClientsCursor
		FETCH NEXT FROM SapHanaClientsCursor INTO @SapHanaInstanceId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			DELETE @PhysicalClients
			INSERT @PhysicalClients
			SELECT *
			FROM dbo.SplitStringByDelimiter((SELECT attrVal FROM CCM_SOURCE_APP_InstanceProp WHERE componentNameId = @SapHanaInstanceId AND attrName = 'Database Clients' AND modified = 0), '+')
			DELETE @PsuedoAndPhysicalSubClients
			/*SubClients of the physical Clients*/
			INSERT @PsuedoAndPhysicalSubClients
			SELECT id FROM CCM_SOURCE_App_Application a, @PhysicalClients b
			WHERE a.clientId = b.clientId
			/*Selected SubClients of the psuedo Client*/
			INSERT @PsuedoAndPhysicalSubClients
			SELECT DISTINCT	a.value from CCMCaptureEntities a, CCM_SOURCE_APP_Application b
			WHERE CHARINDEX('_',a.value) = 0
			AND a.jobId = @i_jobId
			AND a.type = 7
			AND a.value = CAST(b.id AS varchar(32))
			AND b.instance = @SapHanaInstanceId
			SET @rowId = (SELECT top(1) a.id
			FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
			WHERE a.value = CAST(b.id AS varchar(32))
			AND CHARINDEX('_',a.value) = 0
			AND a.type = 7
			AND a.jobId = @i_jobId
			AND b.instance = @SapHanaInstanceId)
			DELETE CCMCaptureEntities
			FROM CCMCaptureEntities a, @PsuedoAndPhysicalSubClients b
			WHERE CHARINDEX('_',a.value) = 0
			AND a.type = 7
			AND a.jobId = @i_jobId
			AND a.value = CAST(b.subClientId AS varchar(32))
			AND a.id <> @rowId
			SET @valueString = null
			SELECT @valueString = COALESCE(@valueString + '_','') + cast(subClientId as varchar(32))
			FROM @PsuedoAndPhysicalSubClients
			UPDATE CCMCaptureEntities SET value = @valueString WHERE id = @rowId
			FETCH NEXT FROM SapHanaClientsCursor INTO @SapHanaInstanceId
		END
		CLOSE SapHanaClientsCursor
		DEALLOCATE SapHanaClientsCursor
	END
   /*******************************************************************************************************************
   *				 Changes to take care of capture of documentum dependent clients together in a single dump
   *				 Dependent clients obtained from
   *				 App_SCFilterFile::fileName where componentNameId = @subclientId for type = 16 (FTIList) and type = 17 (SA List)
   *				 App_InstFilterFile::fileName where componentNameId = @instanceId for type = 16 (FTIList) and type = 17 (SA List)
   *				 App_InstanceProp::attrVal where componentNameId = @instanceId and attrname = 'DOCUMENTUM DbClientId'
   *
   ********************************************************************************************************************/
     /*
If we have subclients of Apptype - 128 to be captured
     {
			For Every Distinct Documentum Clients
			{
				Get the list of dependent documentum clients to be captured along with this
				{
					*Group the subclients selected for Capture in the main documentum client
						and the subclients of the other dependency clients together in a single row
						of CCMCaptureEntities ('_' separated subclient Ids)
					*Delete from the CCMCaptureEntities If the Subclients
						included in this group also exists in another row (duplicate basically)
				}
			}
	  }
    */
	 IF EXISTS (select 1 from CCMCaptureEntities a, CCM_SOURCE_APP_Application b
	 WHERE CHARINDEX('_',a.value) = 0
	 AND a.jobId = @i_jobId
	 AND a.type = 7
	 AND a.value = CAST(b.id AS varchar(32))
AND b.appTypeId = 128)
	 BEGIN
		DECLARE @DocumentumClientId integer
		DECLARE @DocDependentClients TABLE(clientId integer)
		DECLARE @DocAndDependentSubClients TABLE (subClientId integer)
		DECLARE	DocumentumClientsCursor CURSOR LOCAL FOR
		SELECT DISTINCT	b.clientId from CCMCaptureEntities a, CCM_SOURCE_APP_Application b
		WHERE CHARINDEX('_',a.value) = 0
		AND a.jobId = @i_jobId
		AND a.type = 7
		AND a.value = CAST(b.id AS varchar(32))
AND b.appTypeId = 128
		OPEN DocumentumClientsCursor
		FETCH NEXT FROM DocumentumClientsCursor INTO @DocumentumClientId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			DELETE @DocDependentClients
			INSERT @DocDependentClients
			SELECT * FROM CCMGetDependentClientsForDocumentumClient(@DocumentumClientId)
			DELETE @DocAndDependentSubClients
			/*SubClients of the dependent Clients*/
			INSERT @DocAndDependentSubClients
			SELECT id FROM CCM_SOURCE_App_Application a, @DocDependentClients b
			WHERE a.clientId = b.clientId
			/*SubClients of the dependent Client*/
			INSERT @DocAndDependentSubClients
			SELECT DISTINCT	a.value from CCMCaptureEntities a, CCM_SOURCE_APP_Application b
			WHERE CHARINDEX('_',a.value) = 0
			AND a.jobId = @i_jobId
			AND a.type = 7
			AND a.value = CAST(b.id AS varchar(32))
			AND b.clientId = @DocumentumClientId
			SET @rowId = (SELECT top(1) a.id
			FROM CCMCaptureEntities a, CCM_SOURCE_APP_Application b
			WHERE a.value = CAST(b.id AS varchar(32))
			AND CHARINDEX('_',a.value) = 0
			AND a.type = 7
			AND a.jobId = @i_jobId
			AND b.clientId = @DocumentumClientId)
			DELETE CCMCaptureEntities
			FROM CCMCaptureEntities a, @DocAndDependentSubClients b
			WHERE CHARINDEX('_',a.value) = 0
			AND a.type = 7
			AND a.jobId = @i_jobId
			AND a.value = CAST(b.subClientId AS varchar(32))
			AND a.id <> @rowId
			SET @valueString = null
			SELECT @valueString = COALESCE(@valueString + '_','') + cast(subClientId as varchar(32))
			FROM @DocAndDependentSubClients
			UPDATE CCMCaptureEntities SET value = @valueString WHERE id = @rowId
			FETCH NEXT FROM DocumentumClientsCursor INTO @DocumentumClientId
		END
		CLOSE DocumentumClientsCursor
		DEALLOCATE DocumentumClientsCursor
	END
   	 /*******************************************************************************************************************
	 *
	 *                Changes to take care of capture of all those sub-clients, which have the dependent jobs,
	 *                in the very same dump file
	 *
	 ********************************************************************************************************************/
	    /*
	     for each row in CCMCaptureEntities of type 7  and value not having _ in them and for the specific jobs
	     {
	       get the rowid
	       identify_dependent_sub_clients (sub_client_id, time_from, time_to)
	       will return a list of sub clients excluding the current sub_client_id
	       delete from CCMCaptureEntities if any rows (type 7, specific jobid, not having _) has one the sub_client_id
	       update CCMCaptureEntities with the _ formed string of all new dependent sub_client_ids
	       update CCMCaptureEntties set value = value + '_'
	     }
	     */
	IF EXISTS (SELECT 1 FROM JMJobDataLink)
	BEGIN
	DECLARE @dependent_sub_clients TABLE (id integer)
	DECLARE @appId int
    DECLARE CCM_CCMCaptureEntities_SubClient_Jobs_Cursor CURSOR LOCAL For
	SELECT id, value FROM CCMCaptureEntities
	WHERE type = 7
	   AND jobId = @i_jobId
	   AND CHARINDEX('_',value) = 0
	OPEN CCM_CCMCaptureEntities_SubClient_Jobs_Cursor
    FETCH NEXT FROM CCM_CCMCaptureEntities_SubClient_Jobs_Cursor
    INTO @rowId, @subClientId
    WHILE @@FETCH_STATUS = 0
    BEGIN
		INSERT INTO @dependent_sub_clients
        SELECT * FROM GetDependentSubClientForSubClient(@subClientId)
        IF @@ROWCOUNT = 0
        BEGIN
          -- The sub client doesn't have any jobs depending on jobs of other sub-clients
          FETCH NEXT FROM CCM_CCMCaptureEntities_SubClient_Jobs_Cursor
          INTO @rowId, @subClientId
          CONTINUE
        END
		--Get dependent subclients recursively
		DECLARE Recursive_Dependent_SubClient_Cursor CURSOR LOCAL FOR
		SELECT Id FROM @dependent_sub_clients
		OPEN Recursive_Dependent_SubClient_Cursor
		FETCH NEXT FROM Recursive_Dependent_SubClient_Cursor
		INTO @appId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO @dependent_sub_clients
			SELECT a.* FROM GetDependentSubClientForSubClient(@appId) AS a
				LEFT OUTER JOIN @dependent_sub_clients b ON a.id = b.id
			WHERE b.id is null  AND a.id <> @subclientId
			FETCH NEXT FROM Recursive_Dependent_SubClient_Cursor
			INTO @appId
		END
		CLOSE Recursive_Dependent_SubClient_Cursor
		DEALLOCATE Recursive_Dependent_SubClient_Cursor
        DELETE FROM CCMCaptureEntities
        WHERE type = 7
		AND jobId = @i_jobId
		AND CHARINDEX('_',value) = 0
		AND value in (SELECT CAST(id AS varchar(32)) FROM @dependent_sub_clients)
   	    IF @@ERROR > 0
	    BEGIN
	       SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- DELETE -- dependent sub clients'
	       GOTO CX_ERROR_EXIT
	    END
		SET @valueString = null
        SELECT @valueString = COALESCE(@valueString + '_','') + cast(id as varchar(32))
        FROM @dependent_sub_clients
		UPDATE CCMCaptureEntities
        SET value = value + '_' + @valueString
        WHERE id = @rowId
   	    IF @@ERROR > 0
	    BEGIN
	       SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- UPDATE -- value -- dependent sub clients'
	       GOTO CX_ERROR_EXIT
	    END
	    DELETE FROM @dependent_sub_clients
	    FETCH NEXT FROM CCM_CCMCaptureEntities_SubClient_Jobs_Cursor
		INTO @rowId, @subClientId
    END
    CLOSE CCM_CCMCaptureEntities_SubClient_Jobs_Cursor
    DEALLOCATE CCM_CCMCaptureEntities_SubClient_Jobs_Cursor
	END
	 /*******************************************************************************************************************
	 *
	 *                Changes to take care of capture of multiple sub-clients in the very same dump file
	 *
	 ********************************************************************************************************************/
		/*
	   	 for each row in CCMCaptureEntities of type 7 and value not having _ in them and for the specific Job
	     {
	       get the rowid
	       insert into temp_table (rowid, value)
	       select top <value-1> from CCMCaptureEntities (jobid, value not having _ and type as 7)
	       order by rowid
	       update CCMCaptureEntties set value = value + '_'
	       delete the corresponding entries from CCMCaptureEntties
	       fetch the next row in the cursor
	     }*/
   IF @i_no_of_subclients > 1
   BEGIN
	DELETE FROM #subclientlist
	DECLARE @SQL VARCHAR(4000)
	DECLARE CCM_CCMCaptureEntities_SubClient_Cursor CURSOR LOCAL For
	SELECT id, value FROM CCMCaptureEntities
	WHERE type = 7
	   AND jobId = @i_jobId
	   AND CHARINDEX('_',value) = 0
	--ORDER BY id                          -- Order by clause causes the dynamic cursor to behave as a static cursor
	OPEN CCM_CCMCaptureEntities_SubClient_Cursor
    FETCH NEXT FROM CCM_CCMCaptureEntities_SubClient_Cursor
    INTO @rowId, @subClientId
    WHILE @@FETCH_STATUS = 0
    BEGIN
        SET @SQL='SELECT TOP '+cast(@i_no_of_subclients as varchar(max))+' id, value
                  FROM  CCMCaptureEntities
                  WHERE type = 7
                  AND  CHARINDEX(''_'',value) = 0
                  AND  jobId = '+cast(@i_jobId as varchar(max))+'order by id'
        INSERT INTO #subclientlist
        EXEC(@SQL)
        IF @@ERROR > 0
	    BEGIN
	       SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- #subclientlist -- INSERT'
	       GOTO CX_ERROR_EXIT
	    END
        SET @valueString = null
        SELECT @valueString = COALESCE(@valueString + '_','') + cast(subClientId as varchar(32))
        FROM #subclientlist
        UPDATE CCMCaptureEntities
        SET value = @valueString
        WHERE id = @rowId
        IF @@ERROR > 0
	    BEGIN
	       SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- UPDATE -- value'
	       GOTO CX_ERROR_EXIT
	    END
        DELETE FROM CCMCaptureEntities
        FROM CCMCaptureEntities a, #subclientlist b
        WHERE a.id = b.rowId
        AND   a.value = cast(b.subClientId as varchar(32))
        AND   CHARINDEX('_',a.value) = 0
        AND   a.id <> @rowId
        IF @@ERROR > 0
	    BEGIN
	       SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- DELETE'
	       GOTO CX_ERROR_EXIT
	    END
        DELETE FROM #subclientlist
        IF @@ERROR > 0
	    BEGIN
	       SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- #subclientlist -- DELETE'
	       GOTO CX_ERROR_EXIT
	    END
		FETCH NEXT FROM CCM_CCMCaptureEntities_SubClient_Cursor
		INTO @rowId, @subClientId
    END
    CLOSE CCM_CCMCaptureEntities_SubClient_Cursor
    DEALLOCATE CCM_CCMCaptureEntities_SubClient_Cursor
   END
   /*********************************************************************************************************************************************************
	 *
	 *                Changes to take care of capture of defaultSubClient if a sub-client in a backupSet is selected for capture without the defaultSubClient
	 *
	 ********************************************************************************************************************************************************/
    /*
		for every row from
		{
			CCM_CCMCaptureEntitiesCursor for (rowId, value) pairs like 162, 3_4 in CCMCaptureEntities
			split the value to subclient id's
			insert into #subclientlist TABLE(rowId integer, subClientId integer)
		}
	*/
    DELETE FROM #subclientlist
	IF @@ERROR > 0
	BEGIN
	       SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- #subclientlist -- DELETE'
	       GOTO CX_ERROR_EXIT
	END
     DECLARE @defaultSCList TABLE(rowId integer, subClientId integer)
     DECLARE @defaultSubClient integer
     DECLARE @appTypeId integer
	 DECLARE @instanceId integer
     DECLARE @backupSetId integer
     DECLARE CCM_CCMCaptureEntitiesCursor CURSOR LOCAL For
	 SELECT id, value FROM CCMCaptureEntities
	 WHERE type = 7
	   AND jobId = @i_jobId
	 OPEN CCM_CCMCaptureEntitiesCursor
     FETCH NEXT FROM CCM_CCMCaptureEntitiesCursor
     INTO @rowId, @valueString
     WHILE @@FETCH_STATUS = 0
     BEGIN
		insert into #subclientlist
		select @rowId,_ID from dbo.SplitStringByDelimiter(@valueString,'_')
		IF @@ERROR > 0
	    BEGIN
	       SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- #subclientlist -- INSERT'
	       GOTO CX_ERROR_EXIT
	    END
	 FETCH NEXT FROM CCM_CCMCaptureEntitiesCursor
        INTO @rowId, @valueString
     END
     CLOSE CCM_CCMCaptureEntitiesCursor
   	 DEALLOCATE CCM_CCMCaptureEntitiesCursor
	/*
		for every row from
		{
			CCM_SUBCLIENT_LIST_CURSOR for (rowId, subClientId) pairs from #subclientlist
			if the default subClientId corresponding to this subClientId and its backupSet
			doesn't already exist in #subclientlist
			insert rowId, defaultSubClientId into #subclientlist and  @defaultSCList
		}
	*/
	DELETE FROM @defaultSCList
	DECLARE CCM_SUBCLIENT_LIST_CURSOR CURSOR LOCAL FORWARD_ONLY for
	SELECT rowId, subClientId from #subclientlist
	OPEN CCM_SUBCLIENT_LIST_CURSOR
	FETCH NEXT FROM CCM_SUBCLIENT_LIST_CURSOR
	INTO @rowId, @subClientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
	SELECT	@clientId = clientId,
			@appTypeId = appTypeId,
			@instanceId = instance,
			@backupSetId = backupSet
	FROM	CCM_SOURCE_APP_Application
	WHERE	id = @subClientId
	set @defaultSubClient = (select id from CCM_SOURCE_app_application where clientId = @clientId and appTypeId = @appTypeId and instance = @instanceId and backupSet = @backupSetId
and (subclientStatus & 0x00008) = 0x00008 and (subclientStatus & 0x0200) = 0)
	IF (ISNULL(@defaultSubClient,0) <> 0)
	BEGIN
		IF NOT EXISTS (select 1 from #subclientlist where subClientId = @defaultSubClient)
			AND NOT EXISTS (SELECT 1 FROM @defaultSCList WHERE rowId = @rowId AND subClientId = @defaultSubClient)
		BEGIN
			insert into @defaultSCList values(@rowId,@defaultSubClient)
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- @defaultSCList -- INSERT'
				GOTO CX_ERROR_EXIT
			END
		END
	END
	IF @instanceId = 1
	BEGIN
		set @defaultSubClient =	(SELECT TOP 1 A.id
								FROM CCM_SOURCE_app_application A INNER JOIN CCM_SOURCE_APP_BackupSetName B ON A.backupSet = B.id AND A.appTypeId = @appTypeId AND A.clientId = @clientId
WHERE B.status & 0x00008 = 0x00008 AND B.name <> 'DR-BackupSet' AND ( A.subclientStatus & 0x00008 ) = 0x00008 and ( A.subclientStatus & 0x0200 ) = 0)
	END
	IF (ISNULL(@defaultSubClient,0) <> 0)
	BEGIN
		IF NOT EXISTS (select 1 from #subclientlist where subClientId = @defaultSubClient)
			AND NOT EXISTS (SELECT 1 FROM @defaultSCList WHERE rowId = @rowId AND subClientId = @defaultSubClient)
		BEGIN
			insert into @defaultSCList values(@rowId,@defaultSubClient)
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- @defaultSCList -- INSERT'
				GOTO CX_ERROR_EXIT
			END
		END
	END
	/*
	Capture file system agent configuration (default subclient of default backupset of file system agent ) if any other agent selected of a particular client.
	*/
	set @defaultSubClient =	(
								SELECT TOP 1 A.id
								FROM CCM_SOURCE_app_application A INNER JOIN CCM_SOURCE_APP_BackupSetName B ON A.backupSet = B.id
								INNER JOIN (SELECT clientId FROM CCM_SOURCE_app_application WHERE id = @subClientId )AS C ON A.clientId = C.clientId
WHERE 	B.status & 0x00008 > 0
										AND B.name <> 'DR-BackupSet'
AND ( A.subclientStatus & 0x00008 ) = 0x00008
AND ( A.subclientStatus & 0x0200 ) = 0
										AND A.appTypeId IN ( SELECT appTypeId FROM App_AppTypeGroups WHERE App  LIKE 'File System' )
							)
	IF (ISNULL(@defaultSubClient,0) <> 0)
	BEGIN
		IF NOT EXISTS (select 1 from #subclientlist where subClientId = @defaultSubClient)
			AND NOT EXISTS (SELECT 1 FROM @defaultSCList WHERE rowId = @rowId AND subClientId = @defaultSubClient)
		BEGIN
			insert into @defaultSCList values(@rowId,@defaultSubClient)
			IF @@ERROR > 0
			BEGIN
				SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- @defaultSCList -- INSERT'
				GOTO CX_ERROR_EXIT
			END
		END
	END
	-- Pick index backup subclients for all picked backupsets.
	/*
	INSERT INTO #subClientList
	SELECT DISTINCT @rowId, APP.id
	FROM CCM_SOURCE_APP_Application APP
INNER JOIN App_InstanceProp IPROP ON APP.instance = IPROP.componentNameId AND IPROP.attrName = 'Distributed Cluster Type' AND IPROP.attrVal = 7
		INNER JOIN CCM_SOURCE_APP_Application APP1 ON ((APP1.dataArchGrpID > 1 AND APP1.dataArchGrpID = APP.dataArchGrpID) OR (APP1.logArchGrpID > 1 AND APP1.logArchGrpID = APP.dataArchGrpID)) AND APP1.id = @subClientId
	WHERE NOT EXISTS (SELECT 1 FROM #subClientList WHERE subClientId = APP.Id)
	*/
	DECLARE @backupSetGUID NVARCHAR(1024)
	DECLARE @subClientGUID NVARCHAR(1024)
	DECLARE @CheckSum INT
	DECLARE @afName NVARCHAR(1024)
	SELECT @backupSetGUID = GUID FROM CCM_SOURCE_APP_BackupSetName WHERE id = @backupSetId
	SET @CheckSum	= CHECKSUM('IdxCheckPoint_' + @backupSetGUID + ':' + @backupSetGUID )
	SET @afName		= 'IdxCheckPoint_' + @backupSetGUID + ':' + @backupSetGUID
	INSERT INTO #subClientList
	SELECT DISTINCT @rowId, A.appid
	FROM CCM_SOURCE_archFile A WITH(NOLOCK) WHERE A.cs_afname = @CheckSum AND A.name = @afName
	AND NOT EXISTS (SELECT 1 FROM #subClientList WHERE subClientId = A.appid AND rowid = @rowId)
	SELECT @subClientGUID = GUID FROM CCM_SOURCE_APP_Application WHERE id = @subClientId
	SET @CheckSum	= CHECKSUM('IdxCheckPoint_' + @backupSetGUID + ':' + @subClientGUID )
	SET @afName		= 'IdxCheckPoint_' + @backupSetGUID + ':' + @subClientGUID
	INSERT INTO #subClientList
	SELECT DISTINCT @rowId, A.appid
	FROM CCM_SOURCE_archFile A WITH(NOLOCK) WHERE A.cs_afname = @CheckSum AND A.name = @afName
	AND NOT EXISTS (SELECT 1 FROM #subClientList WHERE subClientId = A.appid AND rowid = @rowId)
	FETCH NEXT FROM CCM_SUBCLIENT_LIST_CURSOR
	INTO @rowId, @subClientId
     END
     /*
			for every row from
			{
				CCM_SubClientCursor for distinct rowId from #subclientlist
				reform the valueString like 3_4_2 (2 newly added defaultSubClientId)
				and set the value column in CCMCaptureEntities to new value String
			}
	 */
     DECLARE CCM_SubClientCursor CURSOR LOCAL For
     SELECT DISTINCT rowId FROM #subclientlist
     OPEN CCM_SubClientCursor
     FETCH NEXT FROM CCM_SubClientCursor
     INTO @rowId
     WHILE @@FETCH_STATUS = 0
     BEGIN
        SET @valueString = null
        SELECT @valueString = COALESCE(@valueString + '_','') + cast(subClientId as varchar(32))
        FROM #subclientlist
        WHERE rowId = @rowId
        UPDATE CCMCaptureEntities
        SET value = @valueString
        WHERE id = @rowId
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
		FETCH NEXT FROM CCM_SubClientCursor
        INTO @rowId
     END
     CLOSE CCM_SubClientCursor
     DEALLOCATE CCM_SubClientCursor
     /*
			for every row from
			{
				CCM_DefaultSubClientCursor for distinct rowId from @defaultSCList
				form the value string like 2_3 (2 and 3 will be the newly added defaultSubClients in this rowId) for every row Id
				and set the value in the column 'defaultsc' of CCMCaptureEntities
			}
	*/
     DECLARE CCM_DefaultSubClientCursor CURSOR LOCAL For
     SELECT DISTINCT rowId FROM @defaultSCList
     OPEN CCM_DefaultSubClientCursor
     FETCH NEXT FROM CCM_DefaultSubClientCursor
     INTO @rowId
     WHILE @@FETCH_STATUS = 0
     BEGIN
        SET @valueString = null
        SELECT @valueString = COALESCE(@valueString + '_','') + cast(subClientId as varchar(32))
        FROM @defaultSCList
        WHERE rowId = @rowId
        UPDATE CCMCaptureEntities
        SET defaultsc = @valueString
        WHERE id = @rowId
		IF @@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Capture_Set_Priority -- CCMCaptureEntities -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
		FETCH NEXT FROM CCM_DefaultSubClientCursor
        INTO @rowId
     END
     CLOSE CCM_DefaultSubClientCursor
     DEALLOCATE CCM_DefaultSubClientCursor
	---------------------------------------------------------
	-- Combine all MAs to one list so that in one shot we can capture all MAs.
	IF EXISTS (SELECT 1 FROM CCMCaptureEntities WHERE type = 11 AND jobId = @i_jobId)
	BEGIN
		IF OBJECT_ID('tempdb..#MAList') IS NOT NULL DROP TABLE #MAList
			CREATE TABLE #MAList (id INT)
		INSERT INTO #MAList
		SELECT CAST(value AS INT)
		FROM CCMCaptureEntities WHERE type = 11 AND jobId = @i_jobId
		IF @i_isExportFromLinkedServer > 0
		BEGIN
			DECLARE  @SQLStatment NVARCHAR(MAX)
			SET @SQLStatment = '
			INSERT INTO #MAList
			SELECT DISTINCT C.hostId
			FROM #MAList A
				INNER JOIN OPENQUERY(CCM_Export_LinkedServer, ''SELECT hostId, deviceId FROM '+ @i_exportDBName +'.dbo.MMDiskHWInfo'') B ON A.id = B.hostId
				INNER JOIN OPENQUERY(CCM_Export_LinkedServer, ''SELECT hostId, deviceId FROM '+ @i_exportDBName +'.dbo.MMDiskHWInfo'') C ON C.deviceId = B.deviceId AND B.deviceId > 0
			WHERE NOT EXISTS (SELECT 1 FROM #MAList WHERE id = C.hostId)'
			EXEC (@SQLStatment)
		END
		ELSE
		BEGIN
			INSERT INTO #MAList
			SELECT DISTINCT C.hostId
			FROM #MAList A INNER JOIN CCM_SOURCE_MMDiskHWInfo B ON A.id = B.hostId
			INNER JOIN CCM_SOURCE_MMDiskHWInfo C ON C.deviceId = B.deviceId AND B.deviceId > 0
			WHERE NOT EXISTS (SELECT 1 FROM #MAList WHERE id = C.hostId)
		END
		DECLARE @minRowId INTEGER
		SET @minRowId = ISNULL((SELECT MIN(id) FROM CCMCaptureEntities WHERE type = 11 AND jobId = @i_jobId), 0)
		DECLARE @MAList nvarchar(max) = ''
		SELECT  @MAList = @MAList + CAST (id AS VARCHAR(128)) + '_' FROM #MAList
		SET @MAList = LEFT(@MAList, LEN(@MAList)-1)
		UPDATE CCMCaptureEntities
		SET value = @MAList
		WHERE id = @minRowId
		DELETE CCMCaptureEntities
		WHERE id <> @minRowId AND type = 11 AND jobId = @i_jobId
	END
	/* Cache the entity list so that next export can skip this proc. */
	IF @i_isGRC > 0
	BEGIN
		INSERT INTO CCMCaptureEntitiesCache
		SELECT A.*, 1, @i_csGUID
		FROM CCMCaptureEntities A
		WHERE A.jobid = @i_jobId
	END
	SET @errorString = 'NO_ERROR'
	SELECT	0, @errorString
	RETURN  0
CX_ERROR_EXIT:
   	IF (Cursor_Status('LOCAL', 'CCM_CCMCaptureEntitiesCursor') >= -1)
	BEGIN
		CLOSE CCM_CCMCaptureEntitiesCursor
		DEALLOCATE CCM_CCMCaptureEntitiesCursor
	END
	IF (Cursor_Status('LOCAL', 'CCM_CCMCaptureEntities_SubClient_Cursor') >= -1)
	BEGIN
		CLOSE CCM_CCMCaptureEntities_SubClient_Cursor
		DEALLOCATE CCM_CCMCaptureEntities_SubClient_Cursor
	END
	IF (Cursor_Status('LOCAL', 'CCM_ClusterClientsCursor') >= -1)
	BEGIN
		CLOSE CCM_ClusterClientsCursor
		DEALLOCATE CCM_ClusterClientsCursor
	END
	IF (Cursor_Status('LOCAL', 'CCM_SubClientCursor') >= -1)
	BEGIN
		CLOSE CCM_SubClientCursor
		DEALLOCATE CCM_SubClientCursor
	END
	IF (Cursor_Status('LOCAL', 'CCM_CCMCaptureEntities_SubClient_Jobs_Cursor') >= -1)
	BEGIN
		CLOSE CCM_CCMCaptureEntities_SubClient_Jobs_Cursor
		DEALLOCATE CCM_CCMCaptureEntities_SubClient_Jobs_Cursor
	END
	IF (Cursor_Status('LOCAL', 'CCM_Oracle_RAC_ClientsCursor') >= -1)
	BEGIN
		CLOSE CCM_Oracle_RAC_ClientsCursor
		DEALLOCATE CCM_Oracle_RAC_ClientsCursor
	END
	IF (Cursor_Status('LOCAL', 'OracleRacInstanceCursor') >= -1)
	BEGIN
		CLOSE OracleRacInstanceCursor
		DEALLOCATE OracleRacInstanceCursor
	END
	IF (Cursor_Status('LOCAL', 'CCM_SUBCLIENT_LIST_CURSOR') >= -1)
	BEGIN
		CLOSE CCM_SUBCLIENT_LIST_CURSOR
		DEALLOCATE CCM_SUBCLIENT_LIST_CURSOR
	END
	IF (Cursor_Status('LOCAL', 'CCM_DefaultSubClientCursor') >= -1)
	BEGIN
		CLOSE CCM_DefaultSubClientCursor
		DEALLOCATE CCM_DefaultSubClientCursor
	END
	IF (Cursor_Status('LOCAL', 'DocumentumClientsCursor') >= -1)
	BEGIN
		CLOSE DocumentumClientsCursor
		DEALLOCATE DocumentumClientsCursor
	END
	SELECT	-1, @errorString
	RETURN  -1
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Set_Priority')
	delete from GxQscripts where name = 'CCM_Capture_Set_Priority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Set_Priority')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Set_Priority'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Set_Priority',  'v1.22.12.26.20.1', 'CCM_Capture_Set_Priority', 'v1.22.12.26.20.1')
GO

