

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Security.sp] ---------- 

--  +========================================================================+
--  | Stored Procedure: Capture Security (NameServer, User Group and User) data to migrate.
--	| Author : Gokul
--  +========================================================================+
-- $Id: CCM_Capture_Security.sp,v 1.9.208.3 2019/09/28 03:14:41 snandhini Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_Security')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_Security <<<'
	drop procedure CCM_Capture_Security
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Security')
	delete from GxQscripts where name = 'CCM_Capture_Security'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Security')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Security'
GO
print '... Creating Procedure: CCM_Capture_Security'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_Security
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024)
AS
  DECLARE @errCode INTEGER
  DECLARE @errStr varchar(1024)
SET NOCOUNT ON
	BEGIN TRANSACTION CCMCAPSECURITY
	SET @errStr = 'ERROR: GENERAL ERROR!'
	-------------------------------------------------------------
--Code below here is from CCM_Capture_Security.spb
	---------------------------------------------------------
				-- First Commcell Capture --
	---------------------------------------------------------
	-- CommServ_Capture..CCM_APP_CommCell
INSERT INTO CommServ_Capture..CCM_APP_CommCell
	SELECT * FROM CCM_SOURCE_APP_CommCell WHERE Number <> 0
AND id not in (SELECT id FROM CommServ_Capture..CCM_APP_CommCell)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_APP_CommCell'
		GOTO CX_ERROR_EXIT
	END
	--------------------------------------------------------
	-- CommServ_Capture..CCM_simAllGalaxyRel
INSERT INTO CommServ_Capture..CCM_simAllGalaxyRel
    SELECT  *
    FROM CCM_SOURCE_simAllGalaxyRel
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_simAllGalaxyRel'
        GOTO CX_ERROR_EXIT
    END
	--------------------------------------------------------
	-- CommServ_Capture..CCM_PatchDBSPInfo
INSERT INTO CommServ_Capture..CCM_PatchDBSPInfo
	SELECT A.*
FROM CCM_SOURCE_PatchDBSPInfo A LEFT JOIN CommServ_Capture..CCM_PatchDBSPInfo B ON A.SPNumber = B.SPNumber
	WHERE B.SPNumber IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_PatchDBSPInfo'
		GOTO CX_ERROR_EXIT
	END
	--------------------------------------------------------
-- Do complete security merge only if you do not have data in #EntitiesToMergeSecurity
IF object_id('tempdb.dbo.#EntitiesToMergeSecurity') is null
BEGIN
	-- Step 1
	-- CommServ_Capture..CCM_UMDSProviders
INSERT INTO CommServ_Capture..CCM_UMDSProviders
	SELECT * FROM CCM_SOURCE_UMDSProviders
	WHERE CCM_SOURCE_UMDSProviders.domainName NOT IN ('CTE Provider','Commcell')
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMDSProviders'
		GOTO CX_ERROR_EXIT
	END
	-- Step 2
	-- CommServ_Capture..CCM_UMDSGroups
INSERT INTO CommServ_Capture..CCM_UMDSGroups
	SELECT * FROM CCM_SOURCE_UMDSgroups
WHERE CCM_SOURCE_UMDSgroups.umdsProviderId IN (SELECT id FROM CommServ_Capture..CCM_UMDSProviders)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMDSGroups'
		GOTO CX_ERROR_EXIT
	END
	-- Step 3
	-- CommServ_Capture..CCM_UMGroups
INSERT INTO CommServ_Capture..CCM_UMGroups
	SELECT * FROM CCM_SOURCE_UMGroups
	--WHERE UMGroups.name NOT IN ('master','CV_Restricted_Visibility','View All','Common Outlook Add-Ins')
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMGroups'
		GOTO CX_ERROR_EXIT
	END
	-- Step 5
	-- CommServ_Capture..CCM_UMDSGroupMaps
INSERT INTO CommServ_Capture..CCM_UMDSGroupMaps
	SELECT * FROM CCM_SOURCE_UMDSGroupMaps
WHERE CCM_SOURCE_UMDSGroupMaps.umDSgroupId IN (SELECT id FROM CommServ_Capture..CCM_UMDSGroups)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMDSGroupMaps'
		GOTO CX_ERROR_EXIT
	END
	-- Step 6
	-- CommServ_Capture..CCM_UMUsers
INSERT INTO CommServ_Capture..CCM_UMUsers
	SELECT * FROM CCM_SOURCE_UMUsers
	WHERE CCM_SOURCE_UMUsers.id > 0 AND CCM_SOURCE_UMUsers.name <> 'Default Outlook User'
	AND CCM_SOURCE_UMUsers.login NOT LIKE '%Deleted%' AND CCM_SOURCE_UMUsers.userGuid <> ''
AND (CCM_SOURCE_UMUsers.origCCid <> 0 OR CCM_SOURCE_UMUsers.flags & 0x040 > 0) AND CCM_SOURCE_UMUsers.flags & 0x004 = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMUsers'
		GOTO CX_ERROR_EXIT
	END
	-- Step 7
	-- CommServ_Capture..CCM_UMUserGroup
INSERT INTO CommServ_Capture..CCM_UMUserGroup
	SELECT * FROM CCM_SOURCE_UMUserGroup
WHERE CCM_SOURCE_UMUserGroup.userId IN (SELECT id FROM CommServ_Capture..CCM_UMUsers)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMUsers'
		GOTO CX_ERROR_EXIT
	END
	-- Step 8
	-- CommServ_Capture..CCM_UMUserPrefs
INSERT INTO CommServ_Capture..CCM_UMUserPrefs
	SELECT * FROM CCM_SOURCE_UMUserPrefs
WHERE CCM_SOURCE_UMUserPrefs.userId IN (SELECT id FROM CommServ_Capture..CCM_UMUsers)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMUserPrefs'
		GOTO CX_ERROR_EXIT
	END
	-- Step 9
	-- CommServ_Capture..CCM_UMDSUserGroup
INSERT INTO CommServ_Capture..CCM_UMDSUserGroup
	SELECT * FROM CCM_SOURCE_UMDSUserGroup
WHERE userId IN (SELECT id FROM CommServ_Capture..CCM_UMUsers) AND groupId IN (SELECT id FROM CommServ_Capture..CCM_UMGroups)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMDSUserGroup'
		GOTO CX_ERROR_EXIT
	END
	--Step 11
	--CommServ_Capture..CCM_UMRoles
	DECLARE @tailQuery VARCHAR(MAX)
	SET @tailQuery = 'A WHERE A.id <> 0 '
EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'UMRoles', 'CommServ_Capture..CCM_UMRoles', '', @i_exportDBName, @tailQuery
	IF  @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMROLES'
		GOTO CX_ERROR_EXIT
	END
	--Step 12
	--CommServ_Capture..CCM_UMRolesPermissions
INSERT INTO CommServ_Capture..CCM_UMRolesPermissions
	SELECT * from CCM_SOURCE_UMRolesPermissions
	IF  @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMROLESPERMISSIONS'
		GOTO CX_ERROR_EXIT
	END
	--Step 13
	--CommServ_Capture..CCM_UMRolesWithPermissionsExpanded
INSERT INTO CommServ_Capture..CCM_UMRolesWithPermissionsExpanded
	SELECT * from CCM_SOURCE_UMRolesWithPermissionsExpanded
	IF  @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMROLESWITHPERMISSIONSEXPANDED'
		GOTO CX_ERROR_EXIT
	END
	--Step 14
	--CommServ_Capture..CCM_UMOwners
INSERT INTO CommServ_Capture..CCM_UMOwners
	SELECT * FROM CCM_SOURCE_UMOwners
	IF  @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMOWNERS'
		GOTO CX_ERROR_EXIT
	END
	--Step 15
	--CommServ_Capture..CCM_UMOwnerRoles
INSERT INTO CommServ_Capture..CCM_UMOwnerRoles
	SELECT * FROM CCM_SOURCE_UMOwnerRoles
	IF  @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMOWNERROLES'
		GOTO CX_ERROR_EXIT
	END
	--Step 16
	--CommServ_Capture..CCM_UMSecurityAssociations
INSERT INTO CommServ_Capture..CCM_UMSecurityAssociations
	SELECT * FROM CCM_SOURCE_UMSecurityAssociations
	IF  @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security -- CCM_UMSECURITYASSOCIATIONS'
		GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------
END
ELSE
BEGIN
	IF object_id('tempdb.dbo.#UserAndGroups') IS NOT NULL
		DROP TABLE #UserAndGroups
	CREATE TABLE #UserAndGroups(userOrGroupId INT, isUser INT)
	-- Get all users and groups who have permissions on  #EntitiesToMergeSecurity
		INSERT INTO #UserAndGroups
			SELECT userOrGroupId, isUser
			FROM CCM_SOURCE_UMSecurityAssociations UMS
			INNER JOIN #EntitiesToMergeSecurity EMS
			ON UMS.entityType1 = EMS.entityType AND UMS.entityId1 = EMS.entityId AND UMS.entityType2 = 0
			UNION
			SELECT userOrGroupId, isUser
			FROM CCM_SOURCE_UMOwners UMO
			INNER JOIN #EntitiesToMergeSecurity EMS
			ON UMO.entityType = EMS.entityType AND UMO.entityId = EMS.entityId
	-- now capture the providers for these users and groups
	-- Step 1
    -- CommServ_Capture..CCM_UMDSProviders
INSERT INTO CommServ_Capture..CCM_UMDSProviders
    SELECT CCM_SOURCE_UMDSProviders.* FROM CCM_SOURCE_UMDSProviders
	INNER JOIN (
				SELECT P.id
				FROM CCM_SOURCE_UMDSProviders P
				INNER JOIN CCM_SOURCE_UMUsers U ON	P.id = U.umdsProviderId
				INNER JOIN #UserAndGroups UG ON UG.isUser = 1 AND UG.userOrGroupId = U.id
				UNION
				SELECT P.id
				FROM CCM_SOURCE_UMDSProviders P
				INNER JOIN CCM_SOURCE_UMGroups G ON	P.id = G.umdsProviderId
				INNER JOIN #UserAndGroups UG ON UG.isUser = 0 AND UG.userOrGroupId = G.id
			 )ReqProv
	ON CCM_SOURCE_UMDSProviders.id = ReqProv.id
LEFT JOIN CommServ_Capture..CCM_UMDSProviders Existing
	ON Existing.id = CCM_SOURCE_UMDSProviders.id
    WHERE CCM_SOURCE_UMDSProviders.domainName NOT IN ('CTE Provider','Commcell')
	AND Existing.id IS NULL
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Capture_Security for entities -- CCM_UMDSProviders'
        GOTO CX_ERROR_EXIT
    END
	-- Step 2
    -- CommServ_Capture..CCM_UMDSGroups
INSERT INTO CommServ_Capture..CCM_UMDSGroups
	    SELECT CCM_SOURCE_UMDSgroups.* FROM CCM_SOURCE_UMDSgroups
		INNER JOIN #UserAndGroups ReqUG on CCM_SOURCE_UMDSgroups.id = ReqUG.userOrGroupId AND ReqUG.isUser = 0
LEFT JOIN CommServ_Capture..CCM_UMDSGroups Existing
		ON Existing.id = CCM_SOURCE_UMDSgroups.id
WHERE CCM_SOURCE_UMDSgroups.umdsProviderId IN (SELECT id FROM CommServ_Capture..CCM_UMDSProviders)
		AND Existing.id IS NULL
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Capture_Security for entities -- CCM_UMDSGroups'
        GOTO CX_ERROR_EXIT
    END
	-- Step 3
    -- CommServ_Capture..CCM_UMGroups
INSERT INTO CommServ_Capture..CCM_UMGroups
	    SELECT CCM_SOURCE_UMGroups.* FROM CCM_SOURCE_UMGroups
		INNER JOIN #UserAndGroups ReqUG on CCM_SOURCE_UMGroups.id = ReqUG.userOrGroupId AND ReqUG.isUser = 0
LEFT JOIN CommServ_Capture..CCM_UMGroups Existing
		ON Existing.id = CCM_SOURCE_UMGroups.id
	    WHERE Existing.id IS NULL
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Capture_Security  for entities -- CCM_UMGroups'
        GOTO CX_ERROR_EXIT
    END
    -- Step 5
    -- CommServ_Capture..CCM_UMDSGroupMaps
INSERT INTO CommServ_Capture..CCM_UMDSGroupMaps
	    SELECT CCM_SOURCE_UMDSGroupMaps.* FROM CCM_SOURCE_UMDSGroupMaps
LEFT JOIN CommServ_Capture..CCM_UMDSGroupMaps Existing
		ON Existing.umdsgroupid = CCM_SOURCE_UMDSGroupMaps.umdsgroupid AND Existing.umgroupid = CCM_SOURCE_UMDSGroupMaps.umgroupid
WHERE CCM_SOURCE_UMDSGroupMaps.umDSgroupId IN (SELECT id FROM CommServ_Capture..CCM_UMDSGroups)
AND CCM_SOURCE_UMDSGroupMaps.umgroupId IN (SELECT id FROM CommServ_Capture..CCM_UMGroups)
		AND Existing.umdsgroupid IS NULL
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Capture_Security  for entities -- CCM_UMDSGroupMaps'
        GOTO CX_ERROR_EXIT
    END
    -- Step 6
    -- CommServ_Capture..CCM_UMUsers
INSERT INTO CommServ_Capture..CCM_UMUsers
	    SELECT CCM_SOURCE_UMUsers.* FROM CCM_SOURCE_UMUsers
		INNER JOIN #UserAndGroups ReqUsers ON CCM_SOURCE_UMUsers.id = ReqUsers.userOrGroupId AND ReqUsers.isUser = 1
LEFT JOIN CommServ_Capture..CCM_UMUsers Existing
		ON Existing.id = CCM_SOURCE_UMUsers.id
	    WHERE CCM_SOURCE_UMUsers.id > 0 AND CCM_SOURCE_UMUsers.name <> 'Default Outlook User'
	    AND CCM_SOURCE_UMUsers.login NOT LIKE '%Deleted%' AND CCM_SOURCE_UMUsers.userGuid <> ''
AND (CCM_SOURCE_UMUsers.origCCid <> 0 OR CCM_SOURCE_UMUsers.flags & 0x040 > 0) AND CCM_SOURCE_UMUsers.flags & 0x004 = 0
		AND Existing.id IS NULL
	IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Capture_Security  for entities -- CCM_UMUsers'
        GOTO CX_ERROR_EXIT
    END
	-- Step 7
    -- CommServ_Capture..CCM_UMUserGroup
INSERT INTO CommServ_Capture..CCM_UMUserGroup
	    SELECT CCM_SOURCE_UMUserGroup.* FROM CCM_SOURCE_UMUserGroup
LEFT JOIN CommServ_Capture..CCM_UMUserGroup Existing
		ON Existing.userId = CCM_SOURCE_UMUserGroup.userId AND Existing.groupId = CCM_SOURCE_UMUserGroup.groupId
WHERE CCM_SOURCE_UMUserGroup.userId IN (SELECT id FROM CommServ_Capture..CCM_UMUsers)
AND CCM_SOURCE_UMUserGroup.groupId IN (SELECT id FROM CommServ_Capture..CCM_UMGroups)
	    AND Existing.userId IS NULL
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Capture_Security  for entities-- CCM_UMUserGroup'
        GOTO CX_ERROR_EXIT
    END
	-- Step 8
    -- CommServ_Capture..CCM_UMUserPrefs
INSERT INTO CommServ_Capture..CCM_UMUserPrefs
	    SELECT CCM_SOURCE_UMUserPrefs.* FROM CCM_SOURCE_UMUserPrefs
LEFT JOIN CommServ_Capture..CCM_UMUserPrefs Existing
		ON Existing.userId = CCM_SOURCE_UMUserPrefs.userId
WHERE CCM_SOURCE_UMUserPrefs.userId IN (SELECT id FROM CommServ_Capture..CCM_UMUsers)
	    AND Existing.userId IS NULL
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Capture_Security  for entities -- CCM_UMUserPrefs'
        GOTO CX_ERROR_EXIT
    END
	-- Step 9
    -- CommServ_Capture..CCM_UMDSUserGroup
INSERT INTO CommServ_Capture..CCM_UMDSUserGroup
	    SELECT CCM_SOURCE_UMDSUserGroup.* FROM CCM_SOURCE_UMDSUserGroup
LEFT JOIN CommServ_Capture..CCM_UMDSUserGroup Existing
		ON Existing.userId = CCM_SOURCE_UMDSUserGroup.userId AND Existing.groupid =  CCM_SOURCE_UMDSUserGroup.groupId
WHERE CCM_SOURCE_UMDSUserGroup.userId IN (SELECT id FROM CommServ_Capture..CCM_UMUsers) AND CCM_SOURCE_UMDSUserGroup.groupId IN (SELECT id FROM CommServ_Capture..CCM_UMGroups)
	    AND Existing.userId IS NULL
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Capture_Security  for entities -- CCM_UMDSUserGroup'
        GOTO CX_ERROR_EXIT
    END
    -- Step 11
    --CommServ_Capture..CCM_UMRoles
	DECLARE @tailQuery2 VARCHAR(MAX)
	SET @tailQuery2 = ' A INNER JOIN (
						SELECT roleId FROM CCM_SOURCE_UMSecurityAssociations UMS
						INNER JOIN #EntitiesToMergeSecurity EMS
						ON UMS.entityType1 = EMS.entityType AND UMS.entityId1 = EMS.entityId AND UMS.entityType2 = 0
						UNION
						SELECT roleId FROM CCM_SOURCE_UMOwnerRoles UMOR
						INNER JOIN #EntitiesToMergeSecurity EMS
						ON UMOR.entityType = EMS.entityType AND UMOR.entityId = EMS.entityId
					   )ReqRoles
						ON ReqRoles.roleid = A.id
LEFT JOIN CommServ_Capture..CCM_UMRoles Existing
						ON Existing.id = A.id
						WHERE A.id <> 0
						AND Existing.id IS NULL
					'
EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'UMRoles', 'CommServ_Capture..CCM_UMRoles', '', @i_exportDBName, @tailQuery2
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Capture_Security for entities-- CCM_UMROLES'
        GOTO CX_ERROR_EXIT
    END
    --Step 12
    --CommServ_Capture..CCM_UMRolesPermissions
INSERT INTO CommServ_Capture..CCM_UMRolesPermissions
	    SELECT CCM_SOURCE_UMRolesPermissions.* FROM CCM_SOURCE_UMRolesPermissions
LEFT JOIN CommServ_Capture..CCM_UMRolesPermissions Existing
		ON Existing.roleId = CCM_SOURCE_UMRolesPermissions.roleId AND Existing.hierarchyLevel = CCM_SOURCE_UMRolesPermissions.hierarchyLevel AND Existing.categoryId = CCM_SOURCE_UMRolesPermissions.categoryId  AND Existing.permissionId = CCM_SOURCE_UMRolesPermissions.permissionId
WHERE CCM_SOURCE_UMRolesPermissions.roleId in ( SELECT id FROM CommServ_Capture..CCM_UMRoles)
		AND Existing.roleId IS NULL
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Capture_Security  for entities -- CCM_UMROLESPERMISSIONS'
        GOTO CX_ERROR_EXIT
    END
	--Step 13
    --CommServ_Capture..CCM_UMRolesWithPermissionsExpanded
INSERT INTO CommServ_Capture..CCM_UMRolesWithPermissionsExpanded
	    SELECT CCM_SOURCE_UMRolesWithPermissionsExpanded.* from CCM_SOURCE_UMRolesWithPermissionsExpanded
LEFT JOIN CommServ_Capture..CCM_UMRolesWithPermissionsExpanded Existing
		ON Existing.roleId = CCM_SOURCE_UMRolesWithPermissionsExpanded.roleId AND Existing.permissionId = CCM_SOURCE_UMRolesWithPermissionsExpanded.permissionId
WHERE CCM_SOURCE_UMRolesWithPermissionsExpanded.roleId in ( SELECT id FROM CommServ_Capture..CCM_UMRoles)
		AND Existing.roleId IS NULL
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Capture_Security  for entities -- CCM_UMROLESWITHPERMISSIONSEXPANDED'
        GOTO CX_ERROR_EXIT
    END
	--Step 14
	--CommServ_Capture..CCM_UMOwners
INSERT INTO CommServ_Capture..CCM_UMOwners
		SELECT UMO.* FROM CCM_SOURCE_UMOwners UMO
		INNER JOIN #EntitiesToMergeSecurity EMS
		ON UMO.entityType = EMS.entityType AND UMO.entityId = EMS.entityId
LEFT JOIN CommServ_Capture..CCM_UMOwners Existing
		ON Existing.entityType = UMO.entityType AND Existing.entityId = UMO.entityId AND Existing.isUser = UMO.isUser AND Existing.userOrGroupId = UMO.userOrGroupId
		WHERE Existing.entityType IS NULL
	IF  @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security  for entities -- CCM_UMOWNERS'
		GOTO CX_ERROR_EXIT
	END
	--Step 15
	--CommServ_Capture..CCM_UMOwnerRoles
INSERT INTO CommServ_Capture..CCM_UMOwnerRoles
		SELECT UMO.* FROM CCM_SOURCE_UMOwnerRoles UMO
		INNER JOIN #EntitiesToMergeSecurity EMS
		ON UMO.entityType = EMS.entityType AND UMO.entityId = EMS.entityId
LEFT JOIN CommServ_Capture..CCM_UMOwnerRoles Existing
		ON Existing.entityType = UMO.entityType AND Existing.entityId =  UMO.entityId AND Existing.roleId = UMO.roleId AND Existing.permissionId = UMO.permissionId
		WHERE Existing.entityType IS NULL
	IF  @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security  for entities -- CCM_UMOWNERROLES'
		GOTO CX_ERROR_EXIT
	END
	--Step 16
	--CommServ_Capture..CCM_UMSecurityAssociations
INSERT INTO CommServ_Capture..CCM_UMSecurityAssociations
		SELECT UMS.* FROM CCM_SOURCE_UMSecurityAssociations UMS
		INNER JOIN #EntitiesToMergeSecurity EMS
		ON UMS.entityType1 = EMS.entityType AND UMS.entityId1 = EMS.entityId AND UMS.entityType2 = 0
LEFT JOIN CommServ_Capture..CCM_UMSecurityAssociations Existing
		ON Existing.roleId = UMS.roleId AND Existing.permissionId = UMS.permissionId AND Existing.isUser = UMS.isUser AND Existing.userOrGroupId = UMS.userOrGroupId AND Existing.entityType1 = UMS.entityType1 AND Existing.entityId1 = UMS.entityId1 AND Existing.entityType2 = 0 AND Existing.isCreator = UMS.isCreator
		WHERE Existing.roleId IS NULL
	IF  @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Security  for entities -- CCM_UMSECURITYASSOCIATIONS'
		GOTO CX_ERROR_EXIT
	END
	IF object_id('tempdb.dbo.#UserAndGroups') IS NOT NULL
		DROP TABLE #UserAndGroups
END
	-------------------------------------------------------------
	-------------------------------------------------------------
	-------------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	COMMIT	TRANSACTION CCMCAPSECURITY
	SELECT 0, @errStr
	RETURN
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION CCMCAPSECURITY
	SELECT -1, @errStr
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Security')
	delete from GxQscripts where name = 'CCM_Capture_Security'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Security')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Security'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Security',  '00010009020800030000', 'CCM_Capture_Security', '00010009020800030000')
GO

