

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Schedule.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture Schedules associated with the client/Sub-clients.
--  +========================================================================+
-- $Id: CCM_Capture_Schedule.sp,v 1.5.274.1 2018/03/20 00:48:30 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_Schedule <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_Schedule')
	drop procedure CCM_Capture_Schedule
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Schedule')
	delete from GxQscripts where name = 'CCM_Capture_Schedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Schedule')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Schedule'
GO
print '... Creating Procedure: CCM_Capture_Schedule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_Schedule
  @i_clientId integer,
  @i_subClientId integer,
  @errStr varchar(1024) OUTPUT
AS
SET NOCOUNT ON
    -- Do not use transaction here, because it is called by another stored procedure with transaction
	SET @errStr = 'ERROR: GENERAL ERROR!'
	/*
	 Following tables keep track of the schedules of a client
	                TM_Task                                       UMDSProviders
                      |                                                |
	                  |                                                |
	    --------------------------------                            UMUsers             APP_CustomCalendar
	    |                               |                              |                        |
	 TM_SubTask                  TM_AssocEntity                        |                        |
	    |                                                              --------------------------
	    |                                                                         |
	    |                                                                         |
	    |                                                                     TM_Pattern
	    |                                                                         |
	    |                                                                         |
	    ---------------------------------------------------------------------------
	                                        |
	                                        |
	                                 TM_PatternAssoc
	 TM_Task is independent
	 TM_SubTask depends on TM_Task
	 TM_AssocEntity depends on TM_Task
	 TM_PatternAssoc depends on TM_Pattern and TM_SubTask
	 TM_Pattern depends on APP_CustomCalendar
	 TM_Pattern depends on UMUsers
	 UMUsers depends on UMDSProviders
	 Migraton of a schedule of a client will also migrate the calendar.
	 It will not migrate the associated users (UMUsers), instead the migrated schedule will
	 be associated with the default admin user of the destination commcell.
	 */
	---------------------------------------------------------
	IF (@i_subClientId < 0)
	BEGIN
	    SET @errStr = 'ERROR: CCM_Capture_Schedule -- Invalid subclient'
		GOTO CX_ERROR_EXIT
	END
	IF (@i_clientId <= 1)
	BEGIN
	    SET @errStr = 'ERROR: CCM_Capture_Schedule -- Invalid clientId'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	INSERT INTO CommServ_Capture..CCM_TM_Pattern
	SELECT a.*
	FROM CCM_SOURCE_TM_Pattern a, CCM_SOURCE_TM_PatternAssoc b, CCM_SOURCE_TM_SubTask c, CCM_SOURCE_TM_AssocEntity d, CCM_SOURCE_TM_Task e
	WHERE a.patternId = b.patternId
	  AND b.subTaskId = c.subTaskId
	  AND c.taskId    = d.taskId
	  AND d.taskId	= e.taskId
	  AND (   (d.clientId  = @i_clientId AND d.subClientId = @i_subClientId)  -- sub Client Specific Schedule
	       OR (d.clientId  = @i_clientId AND d.subClientId = 0)               -- client Specific Schedule
	      )
	  AND e.taskType = 2 -- Only schedules
	  AND a.patternId NOT IN (SELECT patternId FROM CommServ_Capture..CCM_TM_Pattern)
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_Schedule -- CCM_TM_Pattern'
	 GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Capture..CCM_APP_CustomCalendar
	SELECT *
	FROM CCM_SOURCE_APP_CustomCalendar
	WHERE id in (SELECT calendarId FROM CommServ_Capture..CCM_TM_Pattern)
	  AND id NOT IN (SELECT id FROM CommServ_Capture..CCM_APP_CustomCalendar)
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_Schedule -- CCM_APP_CustomCalendar'
	 GOTO CX_ERROR_EXIT
	END
	/*
	The schedule will be associated with the default admin user of the
	destination commcell. Hence, there isn't any use of capturing the
	user information from the source commcell.
	INSERT INTO CommServ_Capture..CCM_UMUsers
	SELECT *
	FROM UMUsers
	WHERE id in (SELECT ownerId FROM CommServ_Capture..CCM_TM_Pattern)
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_Schedule -- CCM_UMUsers'
	 GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Capture..CCM_UMDSProviders
	SELECT *
	FROM UMDSProviders
	WHERE id in (SELECT umDSproviderId FROM CommServ_Capture..CCM_UMUsers)
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_Schedule -- CCM_UMDSProviders'
	 GOTO CX_ERROR_EXIT
	END
	*/
	INSERT INTO CommServ_Capture..CCM_TM_PatternAssoc
	SELECT a.*
	FROM CCM_SOURCE_TM_PatternAssoc a
	WHERE a.patternId in (SELECT patternId FROM CommServ_Capture..CCM_TM_Pattern)
	AND a.patternAssocId NOT IN (SELECT patternAssocId FROM CommServ_Capture..CCM_TM_PatternAssoc)
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_Schedule -- CCM_TM_PatternAssoc'
	 GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Capture..CCM_TM_SubTask
	SELECT a.*
	FROM CCM_SOURCE_TM_SubTask a
	WHERE a.subTaskId in (SELECT subTaskId FROM CommServ_Capture..CCM_TM_PatternAssoc)
	AND   a.subTaskId NOT IN (SELECT subTaskId FROM CommServ_Capture..CCM_TM_SubTask)
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_Schedule -- CCM_TM_SubTask'
	 GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Capture..CCM_TM_AssocEntity
	SELECT a.*
	FROM CCM_SOURCE_TM_AssocEntity a
	WHERE a.taskId in (SELECT taskId FROM CommServ_Capture..CCM_TM_SubTask)
	AND (   (a.clientId  = @i_clientId AND a.subClientId = @i_subClientId)  -- sub Client Specific Schedule
	     OR (a.clientId  = @i_clientId AND a.subClientId = 0)               -- client Specific Schedule
	    )
	AND a.assocId NOT IN (SELECT assocId FROM CommServ_Capture..CCM_TM_AssocEntity)
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_Schedule -- CCM_TM_AssocEntity'
	 GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Capture..CCM_TM_Task
	SELECT a.*
	FROM CCM_SOURCE_TM_Task a
	WHERE a.taskId in (SELECT taskId FROM CommServ_Capture..CCM_TM_AssocEntity)
	AND   a.taskId NOT IN (SELECT taskId FROM CommServ_Capture..CCM_TM_Task)
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_Schedule -- CCM_TM_Task'
	 GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Schedule')
	delete from GxQscripts where name = 'CCM_Capture_Schedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Schedule')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Schedule'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Schedule',  '00010005027400010000', 'CCM_Capture_Schedule', '00010005027400010000')
GO

