

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_SQLChain_PopulateArchAppCopy.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_SQLChain_PopulateArchAppCopy.sp,v 1.3.12.8 2020/12/23 03:27:18 hkapadia Exp $
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCM_Capture_SQLChain_PopulateArchAppCopy')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_SQLChain_PopulateArchAppCopy <<<'
	drop procedure CCM_Capture_SQLChain_PopulateArchAppCopy
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_SQLChain_PopulateArchAppCopy')
	delete from GxQscripts where name = 'CCM_Capture_SQLChain_PopulateArchAppCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SQLChain_PopulateArchAppCopy')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SQLChain_PopulateArchAppCopy'
GO
print '... Creating Procedure: CCM_Capture_SQLChain_PopulateArchAppCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCM_Capture_SQLChain_PopulateArchAppCopy
AS
-- table name defines
	SET NOCOUNT ON
	DECLARE @currentTime INTEGER
	SET @currentTime = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @errorCode		INTEGER
	SET		@errorCode		= 0
	DECLARE	@RetentionDaysWhenCyclesIgnored		INTEGER
	SET			@RetentionDaysWhenCyclesIgnored		= 30
	DECLARE	@ignoreCyclesOnDeConfiguredClients		INTEGER
	SET			@ignoreCyclesOnDeConfiguredClients		= 0
	DECLARE @ignoreCyclesOnBackupActivityDisabledSubclients INTEGER
	SET			@ignoreCyclesOnBackupActivityDisabledSubclients = 0
	DECLARE	@HonorSPCopyRetentionForContentStore		INTEGER
	SET			@HonorSPCopyRetentionForContentStore		= 0
	DECLARE	@numberOfDaysForDeconfiguredClients		INTEGER
	SET			@numberOfDaysForDeconfiguredClients		= 0
	DECLARE	@DaysRetForEdgeClientOnSpoolCopy		INTEGER
	SET			@DaysRetForEdgeClientOnSpoolCopy		= 15
	DECLARE @honorBasicCyclesOnlyToApplyLogRule INTEGER
	SET 		@honorBasicCyclesOnlyToApplyLogRule	= 0
	DECLARE @honorDaysOnlyRetForVSAV2Parent INTEGER
	SET 		@honorDaysOnlyRetForVSAV2Parent	= 0
	DECLARE @checkSumAssociatedSP INTEGER
	SET @checkSumAssociatedSP = CHECKSUM(N'Associated subclient Policy')
	DECLARE @checkSumIsTurboSC INTEGER
	SET @checkSumIsTurboSC = CHECKSUM(N'Is Turbo Subclient')
	DECLARE @checkSumFirstTurboJobId INTEGER
	SET @checkSumFirstTurboJobId = CHECKSUM(N'First Turbo Job Id')
	DECLARE @checkSumIsTrueUpEnabled INTEGER
	SET @checkSumIsTrueUpEnabled = CHECKSUM(N'Is true up enabled for FS')
	DECLARE @checkSumIsBLRFS INTEGER
	SET @checkSumIsBLRFS = CHECKSUM(N'Is BLR Replication Subclient')
	DECLARE @totalAppIdFound		INTEGER
	DECLARE @totalAppIdToBeAged		INTEGER
	DECLARE @totalAppIdSqlChain		INTEGER
	DECLARE @totalAppIdExtRet		INTEGER
	DECLARE @totalAppIdUnknown		INTEGER
	DECLARE @AppIdSelected		INTEGER
	SET		@totalAppIdFound		= 0
	SET		@totalAppIdToBeAged		= 0
	SET		@totalAppIdSqlChain		= 0
	SET		@totalAppIdExtRet		= 0
	SET		@totalAppIdUnknown		= 0
	SET		@AppIdSelected	= 0
	----------------------------------------------------------------------------------
	-- For cases when cycles are ignored, only days will be honored for retention
	-- However, if the retention days on the copy is 0 days, then get the retention
	-- days configured by user in the mmconfigs table
	----------------------------------------------------------------------------------
	SELECT @RetentionDaysWhenCyclesIgnored = isnull(value, 30)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_RETENTION_DAYS_WHEN_CYCLES_IGNORED'
	SELECT @ignoreCyclesOnDeConfiguredClients = isnull(value, 0)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_IGNORE_CYCLES_ON_DECONFIGURED_CLIENTS'
	SELECT @ignoreCyclesOnBackupActivityDisabledSubclients = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_IGNORE_CYCLES_ON_BACKUP_ACTIVITY_DISABLED_SUBCLIENTS'
	SELECT @HonorSPCopyRetentionForContentStore = isnull(value, 0)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_HONOR_STORAGE_POLICY_RETENTION_FOR_CONTENT_STORE_DATA'
	SELECT @numberOfDaysForDeconfiguredClients = isnull(value, 0)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_NUMBER_OF_DAYS_TO_KEEP_JOBS_OF_DECONFIGURED_CLIENTS'
	SELECT @DaysRetForEdgeClientOnSpoolCopy = isnull(value, 15)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_EDGEDRIVE_NEW_AF_CREATE_INTERVAL_IN_DAYS'
	SELECT @honorBasicCyclesOnlyToApplyLogRule = isnull(value, 0)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_HONOR_BASIC_CYCLES_ONLY_TO_APPLY_LOG_RULE'
	SELECT @honorDaysOnlyRetForVSAV2Parent = isnull(value, 0)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_HONOR_DAYS_ONLY_RET_FOR_VSA_V2_PARENT'
	if object_id('tempdb.dbo.#DA_JobDataStats') is not null DROP TABLE #DA_JobDataStats
	CREATE	TABLE #DA_JobDataStats (
			AppId int, CopyId int, FileType int,
			JobId int, CommCellId int
			)
	CREATE INDEX Idx_DA_JobDataStats_1 ON #DA_JobDataStats (AppId, CopyId, FileType)
	CREATE INDEX Idx_DA_JobDataStats_2 ON #DA_JobDataStats (JobId, CommCellId)
	if object_id('tempdb.dbo.#tmpDAHoldClientList') is not null DROP TABLE #tmpDAHoldClientList
	CREATE	TABLE #tmpDAHoldClientList(
			clientId INTEGER,
			reasonId INTEGER
			)
	CREATE INDEX Idx_tmpDAHoldClientList_1 ON #tmpDAHoldClientList (clientId)
	if object_id('tempdb.dbo.#tmpDAHoldInstanceList') is not null DROP TABLE #tmpDAHoldInstanceList
	CREATE	TABLE #tmpDAHoldInstanceList(
			instanceId INTEGER
			)
	CREATE INDEX Idx_tmpDAHoldInstanceList_1 ON #tmpDAHoldInstanceList (instanceId)
	if object_id('tempdb.dbo.#tmpDAHoldAppIdList') is not null DROP TABLE #tmpDAHoldAppIdList
	CREATE	TABLE #tmpDAHoldAppIdList(
			appId INTEGER
			)
	CREATE INDEX Idx_tmpDAHoldAppIdList_1 ON #tmpDAHoldAppIdList (appId)
	DECLARE	@tblOldestJob TABLE (
			AppId int,
			CopyId int,
			FileType int,
			StartTimeOldestJob int,
			Primary Key (AppId, CopyId, FileType)
	)
	if object_id('tempdb.dbo.#tblOracleOnDemandAppId') is not null DROP TABLE #tblOracleOnDemandAppId
	CREATE TABLE #tblOracleOnDemandAppId (
		appId int
		PRIMARY KEY (appId)
	)
	DECLARE @tblSPDBAppId TABLE (
			appId int
			)
	DECLARE @tblSqlOldNoChainAppId TABLE (
			appId int
			)
	DECLARE @tblSpoolCopy	TABLE (
			archGroupId int, spoolCopyId int, justInTime int, isSnapCopy int,
			primary key (archGroupId, spoolCopyId)
			)
	DECLARE	@tblCopyToAge TABLE (
			copyId int
			)
	DECLARE	@tblInstanceToAge TABLE (
			instanceId int, havingFFG int
			)
	DECLARE	@tblBackupSetToAge TABLE (
			backupSetId int
			)
	DECLARE	@tblSubclientToAge TABLE (
			appId int
			)
	DECLARE	@tblAppNewSPLastFull TABLE (
			appId int,
			newFullFound int,
			startTimeLastFull int
			)
	DECLARE	@tblAppNewSPCurrFull TABLE (
			appId int,
			startTimeCurrFull int
			)
	DECLARE	@tblAppIdSelectedForProcessing TABLE (
			appId int,
			primary key (appId)
			)
	if object_id('tempdb.dbo.#tblTurboAppId') is not null DROP TABLE #tblTurboAppId
	CREATE	TABLE #tblTurboAppId(
			appId int,
			primary key (appId)
			)
	DECLARE	@tblPSTArchiveAppId TABLE (
			appId int,
			primary key (appId)
			)
	DECLARE	@tblLogOnlyAppId TABLE (
			appId int,
			primary key (appId)
			)
	DECLARE @tblMatSrcCopy TABLE (
		archGroupId INT,
		sourceCopyId INT
	)
	DECLARE @tblAppIdWithDaysOnlyRet TABLE (
			appId int,
			primary key (appId)
			)
	if object_id('tempdb.dbo.#tblAppIdWithCIFSNFSConfig') is not null DROP TABLE #tblAppIdWithCIFSNFSConfig
	CREATE	TABLE #tblAppIdWithCIFSNFSConfig(
			appId					INTEGER
			primary key 	(appId)
			)
	if object_id('tempdb.dbo.#tmpSCWithRetOverride') is not null DROP TABLE #tmpSCWithRetOverride
	CREATE	TABLE #tmpSCWithRetOverride(
			appId					INTEGER,
			OverrideType 	INTEGER
			primary key 	(appId)
			)
	if object_id('tempdb.dbo.#tmpSCWithRunningRestores') is not null DROP TABLE #tmpSCWithRunningRestores
	CREATE	TABLE #tmpSCWithRunningRestores(
			backupSetId INTEGER,
			appId 			INTEGER
			)
	if object_id('tempdb.dbo.#tmpVSAAppAwareSC') is not null DROP TABLE #tmpVSAAppAwareSC
	CREATE	TABLE #tmpVSAAppAwareSC(
			parentAppId			INTEGER,
			childAppId			INTEGER
			)
	CREATE INDEX Idx_tmpVSAAppAwareSC_1 ON #tmpVSAAppAwareSC (childAppId)
	if object_id('tempdb.dbo.#tmpNASSCOverrideSpoolRet') is not null DROP TABLE #tmpNASSCOverrideSpoolRet
	CREATE	TABLE #tmpNASSCOverrideSpoolRet(
			appId					INTEGER
			primary key 	(appId)
			)
	if object_id('tempdb.dbo.#tmpCBTEnabledSubclients') is not null DROP TABLE #tmpCBTEnabledSubclients
	CREATE	TABLE #tmpCBTEnabledSubclients(
			appId					INTEGER
			primary key 	(appId)
			)
	if object_id('tempdb.dbo.#AppGetSubclientsWithBackupDisabledExtTable') is not null DROP TABLE #AppGetSubclientsWithBackupDisabledExtTable
	CREATE	TABLE #AppGetSubclientsWithBackupDisabledExtTable (
			appId		INTEGER
			PRIMARY KEY (appId)
			)
	if object_id('tempdb.dbo.#tmpSharepointV2Client') is not null DROP TABLE #tmpSharepointV2Client
	CREATE	TABLE #tmpSharepointV2Client (
			clientId		INTEGER
			PRIMARY KEY (clientId)
			)
	if object_id('tempdb.dbo.#tmpClientsToSkipDA') is not null DROP TABLE #tmpClientsToSkipDA
	CREATE	TABLE #tmpClientsToSkipDA (
			clientId		INTEGER
			PRIMARY KEY (clientId)
			)
	if object_id('tempdb.dbo.#tmpDaysForDeconfigClients') is not null DROP TABLE #tmpDaysForDeconfigClients
	CREATE	TABLE #tmpDaysForDeconfigClients (
			clientId			INTEGER,
			retentionDays	INTEGER
			PRIMARY KEY (clientId)
			)
	-- Get Oracle On Demand subclients
	INSERT	INTO #tblOracleOnDemandAppId
	SELECT	a.id
	FROM	App_Application a WITH (NOLOCK), App_InstanceName b WITH (NOLOCK)
WHERE	a.AppTypeId IN (22, 80)
	AND		a.instance = b.id
AND		b.status & 0x0800 > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Get SharePoint DB subclients
	INSERT	INTO @tblSPDBAppId
	SELECT	id
	FROM	App_Application WITH (NOLOCK)
WHERE	AppTypeId IN (78)
AND		subclientStatus & 0x0800 > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Get all Sharepoint V2 clients
	INSERT INTO #tmpSharepointV2Client
	SELECT DISTINCT componentNameId
	FROM 	App_ClientProp WITH (NOLOCK)
	WHERE	attrName = N'IndexingV2_Sharepoint'
	AND	attrVal = '1'
	AND	modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Get all special clients to skip DA
	INSERT INTO #tmpClientsToSkipDA
	SELECT DISTINCT componentNameId
	FROM 	App_ClientProp WITH (NOLOCK)
	WHERE	attrName = N'SpecialClient_SkipDataAging'
	AND	attrVal = '1'
	AND	modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Get Edge Drive Subclients and FS Subclients honoring Days Only Retention
	INSERT	INTO @tblAppIdWithDaysOnlyRet
	EXEC getDaysOnlyRetentionSubclient
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Get log only Subclients
	INSERT	INTO @tblLogOnlyAppId
	SELECT	id
	FROM	App_Application WITH (NOLOCK)
WHERE	subclientStatus & 0x0080 > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Get CIFS/NFS configured subclients
	INSERT	INTO #tblAppIdWithCIFSNFSConfig
	EXEC getCIFSNFSSubclient
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT INTO #tmpCBTEnabledSubclients
	EXEC GetCBTEnabledAppIdList
	--Get subclients with backup activity disabled
	INSERT INTO #AppGetSubclientsWithBackupDisabledExtTable
	EXEC AppGetSubclientsWithBackupDisabled '<CVGui_GetSubclientsWithBackupDisabledReq />'
	--Get list of subclients with retention override
	INSERT INTO #tmpSCWithRetOverride
	SELECT DISTINCT componentNameId, CAST(attrVal AS INT)
	FROM	 App_SubclientProp WITH (NOLOCK)
	WHERE	attrName = 'Override storage policy copy retention'
	AND		CAST(attrVal AS INT) > 0
	AND		modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Get list of subclients with running restore jobs
	--Do not consider Persistent Recovery (Recall) jobs, Power restore jobs, Index restore jobs, Sync Restore (Live Sync) jobs, Edge Sync Jobs
	INSERT INTO #tmpSCWithRunningRestores
SELECT DISTINCT bkpSetId, dbo.GetJobOption(jobId, 140007)
	FROM RunningRestores WITH (NOLOCK)
	WHERE opType NOT IN (29, 54, 55, 12, 105) 	-- Skip recall jobs, Power restore, Power find and retrieve, Index restore, CS Live Sync
	AND		(rstAttributes & 0x1100) = 0 	-- Skip Sync Restore and Edge Sync
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- get all appids which have had a storage policy change without forcing a full
	INSERT	INTO @tblAppNewSPLastFull
	SELECT	componentNameId, 0, MAX(CAST(attrVal AS int))
	FROM	App_SubclientProp WITH (NOLOCK)
	WHERE	attrName = 'sys:last full start with SP Change'
	AND		modified = 0
	AND		attrVal <> '0'
	AND		attrVal <> ''
	GROUP	BY componentNameId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT	INTO @tblAppNewSPCurrFull
	SELECT	a.appId, MAX(b.ServStartDate)
	FROM	@tblAppNewSPLastFull a, JMBkpStats b WITH (NOLOCK), App_Application APP WITH (NOLOCK), APP_iDAType ATYPE WITH (NOLOCK), JMJobStats JS WITH (NOLOCK)
	WHERE	a.appId = APP.id
	AND		APP.appTypeId = ATYPE.type
	AND		a.appId = b.appId
	AND		b.jobId = JS.jobId
	AND		b.commCellId = JS.commCellId
	AND		(b.status IN (1, 14) OR (ATYPE.isCWEjobValid = 1 AND b.status IN (3)))
	AND		b.bkpLevel in (1, 64, 128, 1024, 32768, 131072, 262144)
	AND		b.datastatus = 0
	AND		((b.opType NOT IN (59, 60)) OR (b.opType = 59 AND JS.subOpType != 96)) -- Exclude Backup Copy \ Deferred Cataloging Jobs
	GROUP	BY a.appId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	UPDATE	@tblAppNewSPLastFull SET newFullFound = 1
	FROM	@tblAppNewSPLastFull a, @tblAppNewSPCurrFull b
	WHERE	a.appId = b.appId
	AND		a.startTimeLastFull < b.startTimeCurrFull
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- invalidate the attribute change because we now have a full for the storage policy
	INSERT INTO @tblMatSrcCopy
	SELECT a.id, (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
	FROM	archGroup a WITH (NOLOCK), archMaterializeSnapshotProp b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
	WHERE	a.id = b.archGroupId
	AND		a.id = c.archGroupId
	AND		c.id = (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
	AND		c.isSnapCopy > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Set Materialization Source Copy as source of Mirror copy, if materialization Source Copy is Mirror Copy
	WHILE EXISTS(SELECT T.sourceCopyId FROM @tblMatSrcCopy T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	BEGIN
		UPDATE @tblMatSrcCopy
		SET sourceCopyId = (CASE AGC.sourceCopyId WHEN 0 THEN AG.defaultSnapCopy ELSE AGC.sourceCopyId END)
		FROM	@tblMatSrcCopy T, archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		WHERE	T.sourceCopyId = AGC.id
		AND		T.archGroupId = AGC.archGroupId
		AND		AGC.archGroupId = AG.id
		AND		AGC.isSnapCopy > 0
		AND		AGC.isMirrorCopy > 0
		IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Get AppId with non-ASR backup
	-- Log only subclients with index should not be processed as data
	-- Log archive files of Oracle On Demand are aged together with data
INSERT	INTO #ArchAppCopyToBeAged
SELECT	DISTINCT a.appId, b.archCopyId, 0, 2,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, '', 0, 0, 0
FROM	CommServ_Capture..CCM_ArchFile a WITH (NOLOCK), archFileCopy b WITH (NOLOCK)
	WHERE	a.id = b.archFileId
	AND		a.commCellId = b.commCellId
	AND		a.backupLevel != 512
	AND		b.flags & 256 = 0
	AND		( (a.fileType != 4)
	OR		  (a.appId IN (SELECT appId FROM #tblOracleOnDemandAppId))
	OR      (a.appId IN (SELECT appId FROM @tblSPDBAppId))
				)
	AND 	(a.appId NOT IN (SELECT	appId FROM @tblLogOnlyAppId))
	UNION
SELECT	DISTINCT a.appId, a.archGrpCopyId, 0, 2,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, '', 0, 0, 0
FROM	#JMJobDataStats a WITH (NOLOCK), JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND		a.commCellId = b.commCellId
	AND		b.bkpLevel != 512
	AND		a.disabled & 256 = 0
	AND		( (a.dataType != 4)
	OR		  (a.appId IN (SELECT appId FROM #tblOracleOnDemandAppId))
	OR		  (a.appId IN (SELECT appId FROM @tblSPDBAppId))
				)
	AND 	(a.appId NOT IN (SELECT	appId FROM @tblLogOnlyAppId))
	UNION
SELECT	DISTINCT a.appId, a.archGrpCopyId, 0, 2,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, '', 0, 0, 0
FROM	#JMJobDataStats a WITH (NOLOCK), JMAdminJobStatsTable b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND		a.commCellId = b.commCellId
	AND		b.ER_BkpLevel != 512
	AND		a.disabled & 256 = 0
	AND		( (a.dataType != 4)
	OR		  (a.appId IN (SELECT appId FROM #tblOracleOnDemandAppId))
	OR		  (a.appId IN (SELECT appId FROM @tblSPDBAppId))
	)
	AND 	(a.appId NOT IN (SELECT	appId FROM @tblLogOnlyAppId))
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Get AppId with ASR backup
	-- Set FileType to APPFLAGS_ASR to satisfy primary key
INSERT	INTO #ArchAppCopyToBeAged
SELECT	DISTINCT a.appId, b.archCopyId, 512, 512,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, '', 0, 0, 0
FROM	CommServ_Capture..CCM_ArchFile a WITH (NOLOCK), archFileCopy b WITH (NOLOCK)
	WHERE	a.id = b.archFileId
	AND		a.commCellId = b.commCellId
	AND		a.backupLevel = 512
	AND		b.flags & 256 = 0
	UNION
SELECT	DISTINCT a.appId, a.archGrpCopyId, 512, 512,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, '', 0, 0, 0
FROM	#JMJobDataStats a WITH (NOLOCK), JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND		a.commCellId = b.commCellId
	AND		b.bkpLevel = 512
	AND		a.disabled & 256 = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Get AppId with log
	-- Log archive files of Oracle On Demand are aged together with data
INSERT	INTO #ArchAppCopyToBeAged
SELECT	DISTINCT a.appId, b.archCopyId, 4, 4,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, '', 0, 0, 0
FROM	CommServ_Capture..CCM_ArchFile a WITH (NOLOCK), archFileCopy b WITH (NOLOCK)
	WHERE	a.id = b.archFileId
	AND		a.commCellId = b.commCellId
	AND		b.flags & 256 = 0
	AND		a.fileType = 4
	AND		a.appId NOT IN (SELECT appId FROM #tblOracleOnDemandAppId)
	AND		a.appId NOT IN (SELECT appId FROM @tblSPDBAppId)
	UNION
SELECT	DISTINCT a.appId, a.archGrpCopyId, 4, 4,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, '', 0, 0, 0
FROM	#JMJobDataStats a WITH (NOLOCK), JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND		a.commCellId = b.commCellId
	AND		a.disabled & 256 = 0
	AND		a.dataType = 4
	AND		a.appId NOT IN (SELECT appId FROM #tblOracleOnDemandAppId)
	AND		a.appId NOT IN (SELECT appId FROM @tblSPDBAppId)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- DO NOT consider the hidden copy for media refresh during DataAging
DELETE #ArchAppCopyToBeAged
WHERE copyId IN (SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE type = 5)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--------------------------------------------------------------------------------
	-- Get last full backup start time before storage policy of a subclient changes
	-- The startTimeLastFull will be used to calculate the time for days retention
	-- on each copy till the NEW FULL is available. Once the NEW FULL is available,
	-- the last cycle preserved will be pruned based on days retention of individual
	-- copies
	--------------------------------------------------------------------------------
UPDATE	#ArchAppCopyToBeAged
	SET		startTimeLastFull = b.startTimeLastFull
FROM	#ArchAppCopyToBeAged a, @tblAppNewSPLastFull b
	WHERE	a.appId = b.appId
	AND		b.newFullFound = 0
	AND 	a.appId NOT IN (SELECT appId FROM @tblAppIdWithDaysOnlyRet)
	AND		a.appId NOT IN (SELECT appId FROM @tblLogOnlyAppId)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
	SET		appType = b.appTypeId, clientId = b.clientId,
			instanceId = b.instance, backupSetId = b.backupSet,
			fullArchGrpId = b.dataArchGrpId, incrArchGrpId = b.logArchGrpID,
			subclientStatus = b.subclientStatus, isCWEjobValid = C.isCWEjobValid
FROM	#ArchAppCopyToBeAged a, App_Application b WITH (NOLOCK), APP_iDAType c WITH (NOLOCK)
	WHERE	a.appId = b.id
	AND		b.appTypeId = c.type
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
	SET		incrArchGrpId = b.incrSP
FROM	#ArchAppCopyToBeAged a, ArchGroup b WITH (NOLOCK)
	WHERE	a.fullArchGrpId = b.id
AND 	appFlags & 4 = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
	SET		archGrpId = b.archGroupId,
			copyIsActive = b.isActive,
			copyType = b.type,
			copyIsSnap = b.isSnapCopy,
			copyIsSnapMirror = b.isMirrorCopy,
			calendarId = b.calendarId
FROM	#ArchAppCopyToBeAged a, ArchGroupCopy b WITH (NOLOCK)
	WHERE	a.copyId = b.id
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
	SET		primaryCopyId = CASE a.copyIsSnap WHEN 0 THEN b.defaultCopy ELSE b.defaultSnapCopy END
FROM	#ArchAppCopyToBeAged a, ArchGroup b WITH (NOLOCK)
	WHERE	a.archGrpId = b.id
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- If Materialization source copy is not specified then source copy will be Primary Snap Copy
UPDATE	#ArchAppCopyToBeAged
	SET		copyIsMatSource = 1
FROM	#ArchAppCopyToBeAged a, @tblMatSrcCopy T
	WHERE	a.archGrpId = T.archGroupId
	AND		a.copyId = T.sourceCopyId
	AND		a.copyIsSnap > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Do not pick any jobs on mirror copy. They will have retention of primary Snap copy
UPDATE	#ArchAppCopyToBeAged
SET		DoNotAge = DoNotAge | 524288
FROM	#ArchAppCopyToBeAged a
	WHERE	a.copyIsSnap > 0
	AND		a.copyIsSnapMirror > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Copy with Data aging disabled flag will not be aged!
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = b.retentionDays,
			retentionCycles = b.fullCycles,
retainIncrBeforeDiff = CASE b.flags & 64 WHEN 64 THEN 0 ELSE 1 END,
DoNotAge = CASE b.flags & 4 WHEN 4 THEN DoNotAge | 4 ELSE DoNotAge END,
appFlags = CASE b.flags & 4 WHEN 4 THEN appFlags | 8 ELSE appFlags END
FROM	#ArchAppCopyToBeAged a, ArchAgingRule b WITH (NOLOCK)
	WHERE	a.copyId = b.copyId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Honor subclient copy retention if retention is overridden at subclient level
	-- DO NOT honor spool retention at subclient level.
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = CASE WHEN (b.fullCycles = 0 AND b.retentionDays = 0) THEN 1 ELSE b.retentionDays END,
				retentionCycles = b.fullCycles,
retainIncrBeforeDiff = CASE b.flags & 64 WHEN 64 THEN 0 ELSE 1 END,
DoNotAge = CASE b.flags & 4 WHEN 4
THEN DoNotAge | 4 ELSE DoNotAge END,
appFlags = CASE b.flags & 4 WHEN 4
THEN (appFlags | 8 | 268435456)
ELSE (appFlags | 268435456) END
FROM	#ArchAppCopyToBeAged a, archAppCopyAgingRule b WITH (NOLOCK), #tmpSCWithRetOverride c
	WHERE	a.appId = b.appId
	AND		b.appId = c.appId
	AND		a.archGrpId = b.archGrpId
	AND		(
					(c.OverrideType = 1 AND a.copyId = a.primaryCopyId AND (b.copyId = 0 OR b.copyId = a.copyId)) --Override only Primary Copy's Retention
					OR
					(c.OverrideType = 2 AND (b.copyId = 0 OR b.copyId = a.copyId)) --Override All Copy's Retention
					OR
					(c.OverrideType = 3 AND b.copyId = a.copyId) --Override each Copy's Retention
				)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------
	---  Select appId to be aged by Data aging    ---
	-------------------------------------------------
	-- This stored procedure will select all appId based on Granular Selection/Full DataAging
	-- and mark the appIdSelectedForProcessing = 1 and appIdSelectedForPruning = 1
UPDATE	#ArchAppCopyToBeAged
		SET		appIdSelectedForProcessing = 1, appIdSelectedForPruning = 0
		SET @errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	-- Retain all differential/incremental in a cycle for Sharepoint DB jobs
UPDATE	#ArchAppCopyToBeAged
	SET		retainIncrBeforeDiff = 1
	WHERE	appId IN (SELECT appId FROM @tblSPDBAppId)
	AND retainIncrBeforeDiff = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Clients with Data aging disabled flag will not be aged!
	INSERT INTO #tmpDAHoldClientList
	EXEC GetDAHoldClientList 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	IF EXISTS (SELECT clientId FROM #tmpDAHoldClientList WHERE clientId < 0)
		 GOTO CX_ERROR_EXIT
	-- Instances with Data aging disabled flag will not be aged!
	INSERT INTO #tmpDAHoldInstanceList
	EXEC GetDAHoldInstanceList
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	IF EXISTS (SELECT instanceId FROM #tmpDAHoldInstanceList WHERE instanceId < 0)
		 GOTO CX_ERROR_EXIT
	-- Subclients with Data aging disabled flag will not be aged!
	INSERT INTO #tmpDAHoldAppIdList
	EXEC GetDAHoldAppIdList
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	IF EXISTS (SELECT appId FROM #tmpDAHoldAppIdList WHERE appId < 0)
		 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
SET 	DoNotAge = DoNotAge | 4,
appFlags = CASE WHEN (b.reasonId = 1) THEN (appFlags | 64)
WHEN (b.reasonId = 2) THEN (appFlags | 128)
WHEN (b.reasonId = 3) THEN (appFlags | 256)
												ELSE appFlags
									 END
FROM	#ArchAppCopyToBeAged a, #tmpDAHoldClientList b
	WHERE	a.clientId = b.clientId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
SET 	DoNotAge = DoNotAge | 4,
appFlags = appFlags | 1073741824
FROM	#ArchAppCopyToBeAged a, #tmpDAHoldInstanceList b
	WHERE	a.instanceId = b.instanceId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
SET 	DoNotAge = DoNotAge | 4,
appFlags = appFlags | CAST(8589934592 AS bigint)
FROM	#ArchAppCopyToBeAged a, #tmpDAHoldAppIdList b
	WHERE	a.appId = b.appId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Allow pruning of Cloud Laptop Clients since now Synth Fulls are supported.
	-- Force 1 cycle retention for Cloud Laptop Clients when retention on copy is set to 0 cycles
UPDATE	#ArchAppCopyToBeAged
	SET		retentionCycles = 1
FROM	#ArchAppCopyToBeAged a, CommCellCloudLaptopClients b WITH (NOLOCK)
	WHERE	a.clientId = b.clientId
	AND 	a.retentionCycles = 0
	AND		a.retentionDays > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
		-- Disable DataAging for subclients for which restore job is currently running
UPDATE	#ArchAppCopyToBeAged
SET 	DoNotAge = DoNotAge | 4,
appFlags = appFlags | 262144
FROM	#ArchAppCopyToBeAged a, #tmpSCWithRunningRestores b
		WHERE	a.backupSetId = b.backupSetId
		AND		a.appId = b.appId
		IF @@ERROR > 0 GOTO CX_ERROR_EXIT
		-- Disable DataAging for backupsets for which restore job is currently running
UPDATE	#ArchAppCopyToBeAged
SET 	DoNotAge = DoNotAge | 4,
appFlags = appFlags | 262144
FROM	#ArchAppCopyToBeAged a, #tmpSCWithRunningRestores b
		WHERE	a.backupSetId = b.backupSetId
		AND		b.appId <= 0
		IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Update Snap job based retention
UPDATE	#ArchAppCopyToBeAged
	SET		retentionJobs = AAR.retentionJobs
FROM	#ArchAppCopyToBeAged a, archAgingRule AAR WITH (NOLOCK)
	WHERE	a.copyId = AAR.copyId
	AND		a.copyIsSnap != 0
AND		(AAR.flags & 128) > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Honor subclient copy retention if retention is overridden at subclient level
	--DO NOT honor 0 job retention
UPDATE	#ArchAppCopyToBeAged
	SET		retentionJobs = CASE WHEN b.retentionJobs = 0 THEN 1 ELSE b.retentionJobs END,
appFlags = appFlags | 268435456
FROM	#ArchAppCopyToBeAged a, archAppCopyAgingRule b WITH (NOLOCK), #tmpSCWithRetOverride c
	WHERE	a.appId = b.appId
	AND		b.appId = c.appId
	AND		a.archGrpId = b.archGrpId
	AND		(
					(c.OverrideType = 1 AND a.copyId = a.primaryCopyId AND (b.copyId = 0 OR b.copyId = a.copyId)) --Override only Primary Copy's Retention
					OR
					(c.OverrideType = 2 AND (b.copyId = 0 OR b.copyId = a.copyId)) --Override All Copy's Retention
					OR
					(c.OverrideType = 3 AND b.copyId = a.copyId) --Override each Copy's Retention
				)
	AND		a.copyIsSnap != 0
AND		(b.flags & 128) > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Update Snap job based retention appFlags
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | 33554432
	WHERE	retentionJobs > 0
	AND		copyIsSnap != 0
	AND		appType NOT IN (
				SELECT appTypeId
				FROM APP_IDATypeHandlingInfo WITH (NOLOCK)
				WHERE ignoreJobRetention = 1
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark copies with Days only Retention (Ignore Dependency Check)
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | 1048576
FROM	#ArchAppCopyToBeAged a, ArchAgingRule b WITH (NOLOCK)
	WHERE	a.copyId = b.copyId
AND		(b.flags & 16) = 16
AND		a.appFlags & 268435456 = 0
	AND		a.appType NOT IN (
				SELECT appTypeId
				FROM APP_IDATypeHandlingInfo WITH (NOLOCK)
				WHERE ignoreJobRetention = 1
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark copies with Days only Retention (Ignore Dependency Check)
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | 1048576
FROM	#ArchAppCopyToBeAged a, archAppCopyAgingRule b WITH (NOLOCK), #tmpSCWithRetOverride c
	WHERE	a.appId = b.appId
	AND		b.appId = c.appId
	AND		a.archGrpId = b.archGrpId
	AND		(
					(c.OverrideType = 1 AND a.copyId = a.primaryCopyId AND (b.copyId = 0 OR b.copyId = a.copyId)) --Override only Primary Copy's Retention
					OR
					(c.OverrideType = 2 AND (b.copyId = 0 OR b.copyId = a.copyId)) --Override All Copy's Retention
					OR
					(c.OverrideType = 3 AND b.copyId = a.copyId) --Override each Copy's Retention
				)
AND		(b.flags & 16) = 16
AND		a.appFlags & 268435456 > 0
	AND		a.appType NOT IN (
			SELECT appTypeId
			FROM APP_IDATypeHandlingInfo WITH (NOLOCK)
			WHERE ignoreJobRetention = 1
		)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update the retentionDays for Migrator and Archiver AppTypes
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = b.archiverRetDays,
appFlags = appFlags | 2048
FROM	#ArchAppCopyToBeAged a, ArchAgingRule b WITH (NOLOCK)
	WHERE	a.copyId = b.copyId
	AND	appType IN (
				SELECT appTypeId
				FROM APP_IDATypeHandlingInfo WITH (NOLOCK)
				WHERE isDMAppType = 1
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Honor subclient copy retention if retention is overridden at subclient level
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = b.archiverRetDays,
appFlags = appFlags | 268435456
FROM	#ArchAppCopyToBeAged a, archAppCopyAgingRule b WITH (NOLOCK), #tmpSCWithRetOverride c
	WHERE	a.appId = b.appId
	AND		b.appId = c.appId
	AND		a.archGrpId = b.archGrpId
	AND		(
					(c.OverrideType = 1 AND a.copyId = a.primaryCopyId AND (b.copyId = 0 OR b.copyId = a.copyId)) --Override only Primary Copy's Retention
					OR
					(c.OverrideType = 2 AND (b.copyId = 0 OR b.copyId = a.copyId)) --Override All Copy's Retention
					OR
					(c.OverrideType = 3 AND b.copyId = a.copyId) --Override each Copy's Retention
				)
AND		a.appFlags & 2048 > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Honor copy level extended retention only if retention is not overridden at subclient level
UPDATE	#ArchAppCopyToBeAged
	SET		extendedRetention = 1
FROM	#ArchAppCopyToBeAged a, ArchAgingRuleExtended b WITH (NOLOCK)
	WHERE	a.copyId = b.copyId
AND		a.appFlags & 2 > 0
AND		a.appFlags & 268435456 = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Honor subclient copy extended retention if retention is overridden at subclient level
UPDATE	#ArchAppCopyToBeAged
	SET		extendedRetention = 1
FROM	#ArchAppCopyToBeAged a, ArchAppCopyAgingRuleExtended b WITH (NOLOCK), #tmpSCWithRetOverride c
	WHERE	a.appId = b.appId
	AND		b.appId = c.appId
	AND		a.archGrpId = b.archGrpId
	AND		(
					(c.OverrideType = 1 AND a.copyId = a.primaryCopyId AND (b.copyId = 0 OR b.copyId = a.copyId)) --Override only Primary Copy's Retention
					OR
					(c.OverrideType = 2 AND (b.copyId = 0 OR b.copyId = a.copyId)) --Override All Copy's Retention
					OR
					(c.OverrideType = 3 AND b.copyId = a.copyId) --Override each Copy's Retention
				)
AND		a.appFlags & 2 > 0
AND		a.appFlags & 268435456 > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	DECLARE @CSClientTimeZone varchar(255)
	SET @CSClientTimeZone = dbo.GetClientTimeZone(2) -- ClientId for CommServ is 2
	-- Update the TimeZoneToHonor based on CS / CLIENT /SP TimeZone selected
	-- IF CS TimeZone Selected
UPDATE	#ArchAppCopyToBeAged
	SET		TimeZoneToHonor = @CSClientTimeZone
FROM	#ArchAppCopyToBeAged a, ArchGroup b WITH (NOLOCK)
	WHERE	a.archGrpId = b.id
AND		b.TimeZoneType = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- IF CLIENT TimeZone Selected
UPDATE	#ArchAppCopyToBeAged
	SET		TimeZoneToHonor = ISNULL(dbo.GetClientTimeZone(a.clientId), @CSClientTimeZone)
FROM	#ArchAppCopyToBeAged a, ArchGroup b WITH (NOLOCK)
	WHERE	a.archGrpId = b.id
AND		b.TimeZoneType = 1
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- IF STORAGE POLICY TimeZone Selected
UPDATE	#ArchAppCopyToBeAged
	SET		TimeZoneToHonor = ISNULL(b.TimeZone, @CSClientTimeZone)
FROM	#ArchAppCopyToBeAged a, ArchGroup b WITH (NOLOCK)
	WHERE	a.archGrpId = b.id
AND		b.TimeZoneType = 2
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- IF TimeZone Info not available, then default to CS TimeZone
UPDATE	#ArchAppCopyToBeAged
	SET		TimeZoneToHonor = @CSClientTimeZone
	WHERE	LEN(TimeZoneToHonor) = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT INTO #tblTurboAppId
	SELECT	DISTINCT T.componentNameId
	FROM	APP_Application APP WITH (NOLOCK), App_SubclientProp T WITH (NOLOCK), App_SubclientProp T1 WITH (NOLOCK)
	WHERE	T.attrName = N'Associated subclient Policy'
	AND		T.cs_attrName = @checkSumAssociatedSP
	AND 	CAST(T.attrVal AS INT) = APP.Id
	AND		APP.appTypeId = 1030
	AND 	T.modified = 0
	AND		APP.Id = T1.componentNameId
	AND 	T1.attrName = N'Is Turbo Subclient'
	AND		T1.cs_attrName = @checkSumIsTurboSC
	AND 	T1.attrVal = '1'
	AND 	T1.modified = 0
	UNION
	SELECT	DISTINCT T.componentNameId
	FROM	App_SubclientProp T WITH (NOLOCK)
	WHERE	T.attrName = N'Is Turbo Subclient'
	AND		T.cs_attrName = @checkSumIsTurboSC
	AND 	T.attrVal = '1'
	AND 	T.modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	DELETE #tblTurboAppId
	WHERE appId NOT IN ( 	SELECT DISTINCT T.componentNameId
												FROM	App_SubclientProp T WITH (NOLOCK)
												WHERE	T.attrName = N'First Turbo Job Id'
												AND		T.cs_attrName = @checkSumFirstTurboJobId
												AND		CAST(T.attrVal AS INT) != 0
												AND		T.modified = 0
										 )
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT INTO @tblPSTArchiveAppId
	SELECT	DISTINCT componentNameId
	FROM	App_SubclientProp WITH (NOLOCK)
	WHERE	attrName = 'ReferenceCopy PST Archiving'
	AND		attrVal = '1'
	AND		modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
SET			appFlags = appFlags | CAST(68719476736 AS bigint)
	WHERE (
					appId IN (SELECT appId FROM #tblTurboAppId)
					OR
				 	appId IN (SELECT appId FROM @tblPSTArchiveAppId)
				 )
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Force 1 cycle retention for Turbo FS subclients when retention on copy is set to 0 cycles
UPDATE	#ArchAppCopyToBeAged
	SET		retentionCycles = 1
FROM	#ArchAppCopyToBeAged a, #tblTurboAppId b
	WHERE	a.appId = b.appId
	AND 	a.retentionCycles = 0
	AND		a.retentionDays > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Force 1 cycle retention for PST Archiver subclients when retention on copy is set to 0 cycles
UPDATE	#ArchAppCopyToBeAged
	SET		retentionCycles = 1
FROM	#ArchAppCopyToBeAged a, @tblPSTArchiveAppId b
	WHERE	a.appId = b.appId
	AND 	a.retentionCycles = 0
	AND		a.retentionDays > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark appId with Days only Retention (Ignore Dependency Check)
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = CASE retentionCycles
													WHEN 0 THEN
														retentionDays
													ELSE
														CASE retentionDays
															WHEN 0 THEN
																@RetentionDaysWhenCyclesIgnored
															ELSE
																retentionDays
														END
												END,
	retentionCycles = 0,
appFlags = appFlags | 1048576
	WHERE	appId IN (SELECT appId FROM @tblAppIdWithDaysOnlyRet)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update the Archiver Retention Days for Turbo subclients with "Honor Archiver Agent Retention" option enabled
	-- Treat the subclient as "Days only retention" if "Honor Archiver Agent Retention" option is enabled
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = b.archiverRetDays,
appFlags = appFlags | (1048576 | 2048)
FROM	#ArchAppCopyToBeAged a, ArchAgingRule b WITH (NOLOCK), App_SubclientProp c WITH (NOLOCK)
	WHERE	a.copyId = b.copyId
AND		a.appFlags & 268435456 = 0
	AND		a.appId = c.componentNameId
	AND		c.attrName = 'Honor Archiver Agent Retention'
	AND		c.attrVal = '1'
	AND		c.modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = b.archiverRetDays,
appFlags = appFlags | (1048576 | 2048)
FROM	#ArchAppCopyToBeAged a, archAppCopyAgingRule b WITH (NOLOCK), #tmpSCWithRetOverride c, App_SubclientProp d WITH (NOLOCK)
	WHERE	a.appId = b.appId
	AND		b.appId = c.appId
	AND		a.archGrpId = b.archGrpId
	AND		(
					(c.OverrideType = 1 AND a.copyId = a.primaryCopyId AND (b.copyId = 0 OR b.copyId = a.copyId)) --Override only Primary Copy's Retention
					OR
					(c.OverrideType = 2 AND (b.copyId = 0 OR b.copyId = a.copyId)) --Override All Copy's Retention
					OR
					(c.OverrideType = 3 AND b.copyId = a.copyId) --Override each Copy's Retention
				)
AND		a.appFlags & 268435456 > 0
	AND		a.appId = d.componentNameId
	AND		d.attrName = 'Honor Archiver Agent Retention'
	AND		d.attrVal = '1'
	AND		d.modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark subclients with extend subclient retention flag for TURBO subclients
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | 16777216
FROM	#ArchAppCopyToBeAged a, APP_Application APP WITH (NOLOCK), APP_SubClientProp PROP1 WITH (NOLOCK), APP_SubClientProp PROP2 WITH (NOLOCK)
	WHERE a.appId = PROP1.componentNameId
	AND		PROP1.attrName = 'Associated subclient Policy'
	AND 	PROP1.modified = 0
	AND 	CAST(PROP1.attrVal AS INT) = APP.Id
	AND 	APP.appTypeId = 1030
	AND		APP.Id = PROP2.componentNameId
	AND 	PROP2.attrName = 'Is Archive Retention Mode Enabled'
	AND 	PROP2.attrVal = '1'
	AND 	PROP2.modified = 0
AND		a.appFlags & 1048576 > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark subclients with extend subclient retention flag for TURBO subclients
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | 16777216
FROM	#ArchAppCopyToBeAged a, APP_SubClientProp PROP1 WITH (NOLOCK)
	WHERE a.appId = PROP1.componentNameId
	AND 	PROP1.attrName = 'Is Archive Retention Mode Enabled'
	AND 	PROP1.attrVal = '1'
	AND 	PROP1.modified = 0
AND		a.appFlags & 1048576 > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-------------------------------------------
	-- Update Data Rules for SQL AppTypes    --
	-------------------------------------------
UPDATE	#ArchAppCopyToBeAged
	SET		appTypeToAge = 1, fileType = 1
WHERE	appFlags & 2 > 0
	AND		appType IN (
81,
4,
16,
70
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Get Subclients of SQL Database installed before 6.1 with no restore chain
	INSERT	INTO @tblSqlOldNoChainAppId
	SELECT	a.appId
FROM	#ArchAppCopyToBeAged a, App_SubclientProp b WITH (NOLOCK)
	WHERE	a.appId = b.componentNameId
	AND		b.attrName = 'alwaysFullAfterRestore'
	AND		b.attrVal = '1'
	AND		b.modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Get Subclients of SQL Database installed before 6.1 with restore chain
	-- These Subclients will be chained by calling sql api and aged seperately
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | 16
FROM	#ArchAppCopyToBeAged
WHERE	appFlags & 2 > 0
AND		subclientStatus & 0x00008 > 0
	AND		appId NOT IN (SELECT appId FROM @tblSqlOldNoChainAppId)
	AND		appType IN (
4,
16,
70
			)
	-- SQL File or File Group installed before 6.1
	-- Ignore extended retention for SQL file/filegroup Subclients
UPDATE	#ArchAppCopyToBeAged
	SET		extendedRetention = 0
WHERE	appFlags & 2 > 0
AND		subclientStatus & 0x00008 = 0
	AND		appType IN (
4,
16,
70
			)
			-- default subclient indicates that this is a data subclient, non default subclient=file file group
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Get Subclients of SQL Database installed after 6.1
	-- These Subclients will be chained in stored procedure
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | 32
FROM	#ArchAppCopyToBeAged a, App_SubclientProp b WITH (NOLOCK)
WHERE	a.appFlags & 2 > 0
AND		a.appType = 81
	AND		a.appId = b.componentNameId
	AND		b.attrName = 'mssql subclient type'
	AND		b.attrVal = '1'
	AND		b.modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark the SQL logs
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | 4096
FROM	#ArchAppCopyToBeAged a, App_SubclientProp b WITH (NOLOCK)
WHERE	a.appFlags & 4 > 0
AND		a.appType = 81
	AND		a.appId = b.componentNameId
	AND		b.attrName = 'mssql subclient type'
	AND		b.attrVal IN ('1', '2') -- Database and FFG
	AND		b.modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- SQL File or File Group installed after 6.1
	-- Ignore extended retention for SQL file/filegroup Subclients
UPDATE	#ArchAppCopyToBeAged
	SET		extendedRetention = 0
WHERE	appFlags & 32 = 0
AND		appType = 81
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	----------------------------------------------
	-- Update Data Rules for ORACLE AppTypes    --
	----------------------------------------------
	-- Update Oracle AppTypes
	-- Oracle On Demand subclients are not considered as regular Oracle subclients
UPDATE #ArchAppCopyToBeAged
	SET		appTypeToAge = 1, fileType = 1,
appFlags = appFlags | 1024
WHERE	appFlags & 2 > 0
	AND		appId NOT IN (SELECT appId FROM #tblOracleOnDemandAppId)
	AND		appType IN (
2,
22,
23,
80
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Ignore cycle and extended retention rules for commandLine Subclient
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = CASE retentionCycles
													WHEN 0 THEN
														retentionDays
													ELSE
														CASE retentionDays
															WHEN 0 THEN
																@RetentionDaysWhenCyclesIgnored
															ELSE
																retentionDays
														END
												END,
	retentionCycles = 0,
	StartTimeLastFull = 0
WHERE	appFlags & 1024 > 0
AND		subclientStatus & 0x0040 > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Ignore cycle for Oracle On Demand subclient
	-- Extended Retention Rules are not supported
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = CASE retentionCycles
													WHEN 0 THEN
														retentionDays
													ELSE
														CASE retentionDays
															WHEN 0 THEN
																@RetentionDaysWhenCyclesIgnored
															ELSE
																retentionDays
														END
												END,
	retentionCycles = 0, extendedRetention = 0, StartTimeLastFull = 0, appTypeToAge = 1
FROM	#ArchAppCopyToBeAged a, #tblOracleOnDemandAppId b
	WHERE	a.appId = b.appId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Ignore cycle for MySQL/Postgres commandLine Subclient
UPDATE	#ArchAppCopyToBeAged
	SET		appTypeToAge = 1, fileType = 1,
retentionDays = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
													CASE retentionCycles
														WHEN 0 THEN
															retentionDays
														ELSE
															CASE retentionDays
																WHEN 0 THEN
																	@RetentionDaysWhenCyclesIgnored
																ELSE
																	retentionDays
															END
													END
												ELSE
													retentionDays
											END,
retentionCycles = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
														0
													ELSE
														retentionCycles
												END,
StartTimeLastFull = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
														0
													ELSE
														StartTimeLastFull
												END
WHERE	appFlags & 2 > 0
AND		appType IN ( 	104,
125	)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update SAP AppTypes
UPDATE #ArchAppCopyToBeAged
	SET		appTypeToAge = 1, fileType = 1,
appFlags = appFlags | 2097152
WHERE	appFlags & 2 > 0
	AND		appType IN (
61,
79,
135
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Ignore cycle for Sap-Oracle/SAP for MaxDB/SAP HANA commandLine Subclient
	-- Honor Extended Retention for Sap-Oracle/SAP-MaxDB Selective Online Fulls (Commandline also)
UPDATE	#ArchAppCopyToBeAged
SET		retentionDays = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
													CASE retentionCycles
														WHEN 0 THEN
															retentionDays
														ELSE
															CASE retentionDays
																WHEN 0 THEN
																	@RetentionDaysWhenCyclesIgnored
																ELSE
																	retentionDays
															END
													END
												ELSE
													retentionDays
											END,
retentionCycles = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
														0
													ELSE
														retentionCycles
												END,
StartTimeLastFull = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
														0
													ELSE
														StartTimeLastFull
												END
WHERE	appFlags & 2 > 0
	AND		appType IN (
61,
79,
135
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------
	-- Update Data Rules for remaining AppTypes    --
	-------------------------------------------------
	-- Ignore cycle for commandLine Subclient
	-- Honor extended retention for DB2, Sybase and Informix
	-- For DB2 appTypes when the client version is 10.0 or above we'll allow ext. retention always but if it is below 10.0 ext. retention is disabled for cmd line subclients
UPDATE	#ArchAppCopyToBeAged
	SET		appTypeToAge = 1, fileType = 1,
extendedRetention = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
														0
													ELSE
														1
												END,
retentionDays = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
													CASE retentionCycles
														WHEN 0 THEN
															retentionDays
														ELSE
															CASE retentionDays
																WHEN 0 THEN
																	@RetentionDaysWhenCyclesIgnored
																ELSE
																	retentionDays
															END
													END
												ELSE
													retentionDays
											END,
retentionCycles = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
														0
													ELSE
														retentionCycles
												END,
StartTimeLastFull = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
														0
													ELSE
														StartTimeLastFull
												END
WHERE	appFlags & 2 > 0
	AND		appType IN (
5,
3
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Retention settings for DB2 appTypes
UPDATE	#ArchAppCopyToBeAged
	SET		appTypeToAge = 1, fileType = 1,
							extendedRetention = CASE WHEN (SELECT releaseId FROM App_Client WITH (NOLOCK) WHERE id = clientId) >= 15
													THEN
													1
													ELSE
CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
															0
														ELSE
															1
														END
												 END,
retentionDays = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
													CASE retentionCycles
														WHEN 0 THEN
															retentionDays
														ELSE
															CASE retentionDays
																WHEN 0 THEN
																	@RetentionDaysWhenCyclesIgnored
																ELSE
																	retentionDays
															END
													END
												ELSE
													retentionDays
											END,
retentionCycles = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
														0
													ELSE
														retentionCycles
												END,
StartTimeLastFull = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
														0
													ELSE
														StartTimeLastFull
												END
WHERE	appFlags & 2 > 0
	AND		appType IN (
37,
62,
103
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Ignore extended retention for Sybase IQ
UPDATE	#ArchAppCopyToBeAged
	SET		appTypeToAge = 1, fileType = 1,
			extendedRetention = 0,
retentionDays = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
													CASE retentionCycles
														WHEN 0 THEN
															retentionDays
														ELSE
															CASE retentionDays
																WHEN 0 THEN
																	@RetentionDaysWhenCyclesIgnored
																ELSE
																	retentionDays
															END
													END
												ELSE
													retentionDays
											END,
retentionCycles = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
														0
													ELSE
														retentionCycles
												END,
StartTimeLastFull = CASE subclientStatus & 0x0040
WHEN 0x0040 THEN
														0
													ELSE
														StartTimeLastFull
												END
WHERE	appFlags & 2 > 0
	AND		appType IN (
126
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Age Lotus Notes data by fileType = 0
UPDATE	#ArchAppCopyToBeAged
	SET		appTypeToAge = 1
WHERE	appFlags & 2 > 0
	AND		appType IN (
6,
59,
51,
77
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update Documentum appType
UPDATE #ArchAppCopyToBeAged
	SET		appTypeToAge = 1, fileType = 1,
appFlags = appFlags | 4194304
WHERE	appFlags & 2 > 0
	AND		appType IN (
128
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark True-Up enabled Subclients
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | 8388608
FROM	#ArchAppCopyToBeAged a, APP_Application APP WITH (NOLOCK), App_SubclientProp T WITH (NOLOCK), App_SubclientProp T1 WITH (NOLOCK)
	WHERE	a.appId = T.componentNameId
	AND		T.attrName = N'Associated subclient Policy'
	AND		T.cs_attrName = @checkSumAssociatedSP
	AND 	CAST(T.attrVal AS INT) = APP.Id
	AND		APP.appTypeId = 1030
	AND 	T.modified = 0
	AND		APP.Id = T1.componentNameId
	AND 	T1.attrName = N'Is true up enabled for FS'
	AND		T1.cs_attrName = @checkSumIsTrueUpEnabled
	AND 	T1.attrVal = '1'
	AND 	T1.modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark True-Up enabled Subclients
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | 8388608
FROM	#ArchAppCopyToBeAged a, App_SubclientProp b WITH (NOLOCK)
	WHERE	a.appId = b.componentNameId
	AND 	b.attrName = N'Is true up enabled for FS'
	AND		b.cs_attrName = @checkSumIsTrueUpEnabled
	AND		b.attrVal = '1'
	AND		b.modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark DDB Backup Subclient
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | 67108864
FROM	#ArchAppCopyToBeAged a, App_SubclientProp b WITH (NOLOCK)
	WHERE	a.appId = b.componentNameId
	AND		b.attrName = 'DDB Backup'
	AND		b.attrVal = '1'
	AND		b.modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark BLR FS Subclients
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | CAST(4294967296 AS bigint)
FROM	#ArchAppCopyToBeAged a, App_SubclientProp b WITH (NOLOCK)
	WHERE	a.appId = b.componentNameId
	AND 	b.attrName = N'Is BLR Replication Subclient'
	AND		b.cs_attrName = @checkSumIsBLRFS
	AND		b.attrVal = '1'
	AND		b.modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark VSA APP consistent Subclients
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | 134217728
FROM	#ArchAppCopyToBeAged a, JMVSAAppJobLink b WITH (NOLOCK)
	WHERE	a.appId = b.parentAppId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark AppAware APP Subclients
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | CAST(17179869184 AS bigint)
FROM	#ArchAppCopyToBeAged a, JMVSAAppJobLink b WITH (NOLOCK)
	WHERE	a.appId = b.childAppId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark VSA V2 psuedo client subclients
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | CAST(2147483648 AS bigint)
FROM	#ArchAppCopyToBeAged a, JMJobDataLink b WITH (NOLOCK)
WHERE	a.appId = b.parentAppId AND b.linkType IN (7, 8)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Honor days only retention for VSA V2 Parent jobs
	IF @honorDaysOnlyRetForVSAV2Parent != 0
	BEGIN
UPDATE	#ArchAppCopyToBeAged
		SET		appTypeToAge = 1, StartTimeLastFull = 0,
appFlags = appFlags | 1048576,
				retentionDays = CASE retentionCycles
														WHEN 0 THEN
															retentionDays
														ELSE
															CASE retentionDays
																WHEN 0 THEN
																	@RetentionDaysWhenCyclesIgnored
																ELSE
																	retentionDays
															END
													END,
				retentionCycles = 0, extendedRetention = 0
WHERE	appFlags & CAST(2147483648 AS bigint) > 0
		IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	END
	-- Update Migrator and Archiver AppTypes
	-- All backup jobs will be treated as Full
UPDATE	#ArchAppCopyToBeAged
	SET		appTypeToAge = 1, StartTimeLastFull = 0,
appFlags = appFlags | 2048,
			retentionDays = CASE retentionCycles
													WHEN 0 THEN
														retentionDays
													ELSE
														CASE retentionDays
															WHEN 0 THEN
																@RetentionDaysWhenCyclesIgnored
															ELSE
																retentionDays
														END
												END,
			retentionCycles = 0, extendedRetention = 0
WHERE	appFlags & 2048 > 0
					OR 		appType IN (
82,
83,
73,
45,
58,
56,
57,
66,
67,
68,
89,
90
														)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update File System Like AppTypes
UPDATE	#ArchAppCopyToBeAged
	SET		appTypeToAge = 1
	WHERE	appType IN (
7,
60,
52,
9,
8,
15,
14,
32,
69,
46,
78,
33,
34,
35,
44,
53,
54,
55,
11,
13,
88,
21,
1000,
1,
41,
17,
18,
29,
86,
10,
12,
25,
24,
48,
19,
20,
74,
64,
63,
40,
38,
36,
42,
43,
39,
65,
75,
76,
87,
71,
72,
91,
106,
130,
134,
139
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update retention criteria for OBJECT_STORE / CONTENT_SERVER=OBJECT_SERVER
	-- DO NOT Honor SP/Copy Retention for Content Store Based On MMConfigs Option
	IF @HonorSPCopyRetentionForContentStore = 0
	BEGIN
		-- Set retention to Infinite
UPDATE	#ArchAppCopyToBeAged
		SET	appTypeToAge = 1, extendedRetention = 0,
				retentionDays = (CASE WHEN (retentionDays = 0 AND retentionCycles = 0) THEN retentionDays ELSE -1 END),
				retentionCycles = (CASE WHEN (retentionDays = 0 AND retentionCycles = 0) THEN retentionCycles ELSE -1 END)
		WHERE	appType IN (
131,
124
										)
	END
	ELSE
	BEGIN
		-- Ignore Cycles/Extended Retention for CONTENT_SERVER
UPDATE	#ArchAppCopyToBeAged
		SET	appTypeToAge = 1, extendedRetention = 0,
				retentionCycles = 0, StartTimeLastFull = 0,
				retentionDays = CASE retentionCycles
												WHEN 0 THEN
													retentionDays
												ELSE
													CASE retentionDays
														WHEN 0 THEN
															@RetentionDaysWhenCyclesIgnored
														ELSE
															retentionDays
													END
												END
		WHERE	appType IN (
131,
124
										)
	END
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Erase backup Subclient, retain 3 cycles only
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = 0, retentionCycles = 3,
			extendedRetention = 0
WHERE	subclientStatus & 0x0200 > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- OnDemand File System Backupset, ignore cycles
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = CASE retentionCycles
													WHEN 0 THEN
														retentionDays
													ELSE
														CASE retentionDays
															WHEN 0 THEN
																@RetentionDaysWhenCyclesIgnored
															ELSE
																retentionDays
														END
												END,
	retentionCycles = 0,
	StartTimeLastFull = 0
FROM	#ArchAppCopyToBeAged a, App_BackupsetProp b WITH (NOLOCK)
WHERE	a.appFlags & 2 > 0
	AND		a.backupSetId = b.ComponentNameId
	AND		b.attrName = 'OnDemand Backupset'
	AND		b.attrVal = '1'
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- OnDemand SQL/Sybase Subclient, ignore cycles, ignore Extended Retention
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = CASE retentionCycles
													WHEN 0 THEN
														retentionDays
													ELSE
														CASE retentionDays
															WHEN 0 THEN
																@RetentionDaysWhenCyclesIgnored
															ELSE
																retentionDays
														END
												END,
	retentionCycles = 0, extendedRetention = 0, StartTimeLastFull = 0
FROM	#ArchAppCopyToBeAged a,  App_SubclientProp b WITH (NOLOCK)
WHERE	a.appFlags & 2 > 0
AND		a.appType IN (81, 5)
	AND		a.appId = b.componentNameId
	AND		b.attrName = 'On Demand Subclient'
	AND		b.attrVal = '1'
	AND		b.modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Force 1 cycle retention for Reference Copy subclients when retention on copy is set to 0 cycles
UPDATE	#ArchAppCopyToBeAged
	SET		retentionCycles = 1
FROM	#ArchAppCopyToBeAged a, APP_Application b WITH (NOLOCK)
	WHERE	a.appId = b.id
	AND		b.subclientStatus & 0x10000 = 0x10000		--CV_STATUS_REFCOPY_SUB
	AND 	a.retentionCycles = 0
	AND		a.retentionDays > 0
AND		a.appFlags & 1048576 = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-----------------------------------------------------
	-- Update Data Rules for Subclients on Spool Copy  --
	-----------------------------------------------------
	-- mark copy as spool copy
UPDATE	#ArchAppCopyToBeAged
	SET		CopyIsSpool = 1
FROM	#ArchAppCopyToBeAged
	WHERE	retentionDays = 0
	AND	retentionCycles = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Get NAS Subclients to override Spool Retention
	INSERT	INTO #tmpNASSCOverrideSpoolRet
	EXEC getNasiDASpoolCopySubclients
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update NAS agent retention to 0 days/1 Cycle when retention on SNAP copy is Spool and job based retention is not honored
	-- Update NAS agent retention to 1 job count when retention on SNAP copy is Spool and job based retention is honored
	-- Fix for MR# 62481\183205
UPDATE	#ArchAppCopyToBeAged
		SET		copyIsSpool = 0,
					retentionDays = 0,
					retentionCycles = 1,
					retentionJobs = CASE WHEN ATI.appTypeId IS NULL THEN 1 ELSE 0 END,
appFlags = CASE WHEN ATI.appTypeId IS NULL THEN (appFlags | 33554432) ELSE appFlags END
FROM #ArchAppCopyToBeAged A INNER JOIN #tmpNASSCOverrideSpoolRet B
		ON 	A.appId = B.appId
		LEFT OUTER JOIN APP_IDATypeHandlingInfo ATI WITH (NOLOCK)
		ON 	A.appType = ATI.appTypeId
		AND ATI.ignoreJobRetention = 1
		WHERE A.retentionDays = 0
		AND	A.retentionCycles = 0
		AND	A.copyIsSpool = 1
		AND	A.copyIsSnap != 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update CIFS/NFS configured subclients to honor 0 days/1 Cycle when retention on SNAP copy is Spool and job based retention is not honored
	-- Update CIFS/NFS configured subclients to honor 1 job count when retention on SNAP copy is Spool and job based retention is honored
	-- Fix for MR# 121992
UPDATE	#ArchAppCopyToBeAged
		SET		copyIsSpool = 0,
					retentionDays = 0,
					retentionCycles = 1,
					retentionJobs = CASE WHEN ATI.appTypeId IS NULL THEN 1 ELSE 0 END,
appFlags = CASE WHEN ATI.appTypeId IS NULL THEN (appFlags | 33554432) ELSE appFlags END
FROM #ArchAppCopyToBeAged A INNER JOIN #tblAppIdWithCIFSNFSConfig B
		ON 	A.appId = B.appId
		LEFT OUTER JOIN APP_IDATypeHandlingInfo ATI WITH (NOLOCK)
		ON 	A.appType = ATI.appTypeId
		AND ATI.ignoreJobRetention = 1
		WHERE A.retentionDays = 0
		AND	A.retentionCycles = 0
		AND	A.copyIsSpool = 1
		AND	A.copyIsSnap != 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update CBT configured subclients to honor 0 days/1 Cycle when retention on SNAP copy is Spool and job based retention is not honored
	-- Update CBT configured subclients to honor 1 job count when retention on SNAP copy is Spool and job based retention is honored
	-- Fix for MR# 189084
UPDATE	#ArchAppCopyToBeAged
		SET		copyIsSpool = 0,
					retentionDays = 0,
					retentionCycles = 1,
					retentionJobs = CASE WHEN ATI.appTypeId IS NULL THEN 1 ELSE 0 END,
appFlags = CASE WHEN ATI.appTypeId IS NULL THEN (appFlags | 33554432) ELSE appFlags END
FROM #ArchAppCopyToBeAged A INNER JOIN #tmpCBTEnabledSubclients B
		ON 	A.appId = B.appId
		LEFT OUTER JOIN APP_IDATypeHandlingInfo ATI WITH (NOLOCK)
		ON 	A.appType = ATI.appTypeId
		AND ATI.ignoreJobRetention = 1
		WHERE A.retentionDays = 0
		AND	A.retentionCycles = 0
		AND	A.copyIsSpool = 1
		AND	A.copyIsSnap != 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update DDB Subclients to 1 day/1 Cycle when retention is Spool to honor DDB retention
	--Fix for MR# 91324
UPDATE	#ArchAppCopyToBeAged
	SET	copyIsSpool = 0,
		retentionDays = 1,
		retentionCycles = 1
	WHERE 	retentionDays = 0
	AND	retentionCycles = 0
	AND	copyIsSpool = 1
AND	(appFlags & 67108864) > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Ignore extended retention for Edge drive subclients
UPDATE	#ArchAppCopyToBeAged
	SET	extendedRetention = 0
FROM #ArchAppCopyToBeAged a, APP_Application b WITH (NOLOCK)
	WHERE	a.appId = b.id
AND		b.subclientStatus & 0x20000 = 0x20000
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update Edge Drive subclient retention to 0 days/1 Cycle when retention is Spool
	-- and Edge Drive client is honoring cycle based retention
	-- Fix for MR# 117088
UPDATE	#ArchAppCopyToBeAged
	SET	copyIsSpool = 0,
			retentionDays = 0,
			retentionCycles = 1
FROM #ArchAppCopyToBeAged a, APP_Application b WITH (NOLOCK)
	WHERE	a.appId = b.id
AND		b.subclientStatus & 0x20000 = 0x20000
	AND 	a.retentionDays = 0
	AND		a.retentionCycles = 0
	AND		a.copyIsSpool = 1
	AND 	a.appId NOT IN (SELECT appId FROM @tblAppIdWithDaysOnlyRet)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update Edge Drive subclient retention to X days when retention is Spool
	-- and Edge Drive client is honoring Days Only retention
UPDATE	#ArchAppCopyToBeAged
	SET	copyIsSpool = 0,
			retentionDays = @DaysRetForEdgeClientOnSpoolCopy,
			retentionCycles = 0,
appFlags = appFlags | 1048576
FROM #ArchAppCopyToBeAged a, APP_Application b WITH (NOLOCK)
	WHERE	a.appId = b.id
AND		b.subclientStatus & 0x20000 = 0x20000
	AND 	a.retentionDays = 0
	AND		a.retentionCycles = 0
	AND		a.copyIsSpool = 1
	AND 	a.appId IN (SELECT appId FROM @tblAppIdWithDaysOnlyRet)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update Edge Drive subclient retention to N days when retention is 0 days/Y Cycles
	-- and Edge Drive client is honoring Days Only retention
UPDATE	#ArchAppCopyToBeAged
	SET	retentionDays = CASE retentionDays WHEN 0 THEN @RetentionDaysWhenCyclesIgnored ELSE retentionDays END,
			retentionCycles = 0,
appFlags = appFlags | 1048576
FROM #ArchAppCopyToBeAged a, APP_Application b WITH (NOLOCK)
	WHERE	a.appId = b.id
AND		b.subclientStatus & 0x20000 = 0x20000
	AND 	a.retentionDays >= 0
	AND		a.retentionCycles >= 0
	AND 	a.appId IN (SELECT appId FROM @tblAppIdWithDaysOnlyRet)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Disable DataAging on edge drive subclients until synth full support is added.
	--Remove this after Synth Full support is added to follow retention rules on copy.
UPDATE	#ArchAppCopyToBeAged
SET		DoNotAge = DoNotAge | 4,
appFlags = appFlags | 536870912
FROM #ArchAppCopyToBeAged a, APP_Application b WITH (NOLOCK)
	WHERE	a.appId = b.id
AND		b.subclientStatus & 0x20000 = 0x20000
	AND 	a.appId NOT IN (SELECT appId FROM @tblAppIdWithDaysOnlyRet)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Disable DataAging for Exchange OnePass agent as DataAging should not prune any jobs.
	-- Pruning will happen as part of Synthetic Full space reclaimation job.
	--	MR# 152032
UPDATE	#ArchAppCopyToBeAged
	SET		appTypeToAge = 1, extendedRetention = 0,
DoNotAge = DoNotAge | 4,
appFlags = appFlags | 536870912
WHERE	appType IN (137)
	AND		(retentionDays > 0 OR retentionCycles > 0 OR retentionJobs > 0)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Disable DataAging for Sharepoint V2 clients as DataAging should not prune any jobs.
	-- Pruning will happen as part of Synthetic Full space reclaimation job.
UPDATE	#ArchAppCopyToBeAged
SET		DoNotAge = DoNotAge | 4,
appFlags = appFlags | 536870912
FROM #ArchAppCopyToBeAged A, #tmpSharepointV2Client T
	WHERE	A.clientId = T.clientId
	AND		(A.retentionDays > 0 OR A.retentionCycles > 0 OR A.retentionJobs > 0)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Disable DataAging for all Indexing V2 cloud agents \ clients as DataAging should not prune any jobs.
	-- Pruning will happen as part of Synthetic Full space reclaimation job.
UPDATE	#ArchAppCopyToBeAged
SET		DoNotAge = DoNotAge | 4,
appFlags = appFlags | 536870912
FROM #ArchAppCopyToBeAged A, #tmpClientsToSkipDA T
	WHERE	A.clientId = T.clientId
	AND		(A.retentionDays > 0 OR A.retentionCycles > 0 OR A.retentionJobs > 0)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-----------------------------------------------------------
	----- Update Data Rules for special Subclient status ------
	-----------------------------------------------------------
	-- Subclient is using different storage policy for backup
	-- Ignore cycles for data on its old storage policy
	-- The Last Full job will be kept till the new Full
	-- job runs on new SP
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = CASE retentionCycles
													WHEN 0 THEN
														retentionDays
													ELSE
														CASE retentionDays
															WHEN 0 THEN
																@RetentionDaysWhenCyclesIgnored
															ELSE
																retentionDays
														END
												END,
				retentionCycles = 0,
appFlags = appFlags | 8192
	WHERE	fullArchGrpId > 1
	AND		ArchGrpId <> fullArchGrpId
	AND		ArchGrpId <> incrArchGrpId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Subclient hard deleted, age all dangling data
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = 0, retentionCycles = 0,
			extendedRetention = 0, StartTimeLastFull = 0,
appFlags = appFlags | 16384
	WHERE	fullArchGrpId = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Do not ignore cycles if the client is uninstalled
	-- Ignore cycles if the subclient is deleted
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = CASE retentionCycles
													WHEN 0 THEN
														retentionDays
													ELSE
														CASE retentionDays
															WHEN 0 THEN
																@RetentionDaysWhenCyclesIgnored
															ELSE
																retentionDays
														END
												END,
				retentionCycles = 0, StartTimeLastFull = 0,
appFlags = appFlags | 65536
WHERE	subclientStatus & 0x00004 > 0
	AND		appId NOT IN (SELECT appId FROM #tblTurboAppId)
	AND		appId NOT IN (SELECT appId FROM @tblPSTArchiveAppId)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Keep last cycle forever for deleted TURBO subclient
UPDATE	#ArchAppCopyToBeAged
SET		retentionCycles = CASE WHEN ((appFlags & 2048) = 0 AND (appFlags & 1048576) = 0) THEN 1 ELSE 0 END,
StartTimeLastFull = CASE WHEN ((appFlags & 2048) = 0 AND (appFlags & 1048576) = 0) THEN StartTimeLastFull ELSE 0 END,
appFlags = appFlags | 65536
WHERE	subclientStatus & 0x00004 > 0
	AND		(
					appId IN (SELECT appId FROM #tblTurboAppId)
					OR
				 	appId IN (SELECT appId FROM @tblPSTArchiveAppId)
				 )
	AND 	(retentionCycles > 0 OR retentionDays > 0)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update subclients with backup activity disabled
	-- Need this to print in DA report
UPDATE #ArchAppCopyToBeAged
SET		appFlags = appFlags | CAST(34359738368 AS bigint)
FROM 	#ArchAppCopyToBeAged T, #AppGetSubclientsWithBackupDisabledExtTable TMP
	WHERE	T.appId = TMP.appId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Get number of days to honor for de-configured clients if override at client level
	INSERT INTO #tmpDaysForDeconfigClients
	SELECT DISTINCT componentNameId, CASE WHEN attrVal IS NULL THEN 0
																				WHEN LEN(attrVal) = 0 THEN 0
																				ELSE CAST(attrVal AS INT)
																	 END
	FROM 	App_ClientProp WITH (NOLOCK)
	WHERE	attrName = N'Number of days to keep data of de-configured clients'
	AND	modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Honor @numberOfDaysForDeconfiguredClients if it is greater than SP/Copy Retention Days for de-configured clients
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = CASE 	WHEN (T.retentionDays IS NOT NULL AND T.retentionDays < 0)
																THEN -1
															WHEN (T.retentionDays IS NOT NULL)
																THEN
																	CASE 	WHEN (T.retentionDays > A.retentionDays)
																					THEN T.retentionDays
																				ELSE
																					A.retentionDays
																	END
															WHEN (@numberOfDaysForDeconfiguredClients = -1)
																THEN -1
															ELSE
																CASE 	WHEN (@numberOfDaysForDeconfiguredClients > A.retentionDays)
																				THEN @numberOfDaysForDeconfiguredClients
																			ELSE
																				A.retentionDays
																END
												END
FROM #ArchAppCopyToBeAged A LEFT OUTER JOIN #tmpDaysForDeconfigClients T
	ON A.clientId = T.clientId
WHERE	A.subclientStatus & 0x00002 > 0
	AND 	(A.retentionCycles > 0 OR A.retentionDays > 0 OR A.retentionJobs > 0)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Ignore cycles if the client is uninstalled
	IF @ignoreCyclesOnDeConfiguredClients = 1
	BEGIN
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = CASE retentionCycles
													WHEN 0 THEN
														retentionDays
													ELSE
														CASE retentionDays
															WHEN 0 THEN
																@RetentionDaysWhenCyclesIgnored
															ELSE
																retentionDays
														END
												END,
				retentionCycles = 0, StartTimeLastFull = 0
WHERE	subclientStatus & 0x00002 > 0
	AND		appId NOT IN (SELECT appId FROM #tblTurboAppId)
	AND		appId NOT IN (SELECT appId FROM @tblPSTArchiveAppId)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Keep last cycle forever for TURBO subclient
UPDATE	#ArchAppCopyToBeAged
SET		retentionCycles = CASE WHEN ((appFlags & 2048) = 0 AND (appFlags & 1048576) = 0) THEN 1 ELSE 0 END,
StartTimeLastFull = CASE WHEN ((appFlags & 2048) = 0 AND (appFlags & 1048576) = 0) THEN StartTimeLastFull ELSE 0 END
WHERE	subclientStatus & 0x00002 > 0
	AND		(
					appId IN (SELECT appId FROM #tblTurboAppId)
					OR
				 	appId IN (SELECT appId FROM @tblPSTArchiveAppId)
				 )
		AND 	(retentionCycles > 0 OR retentionDays > 0)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	END
	IF @ignoreCyclesOnBackupActivityDisabledSubclients = 1
	BEGIN
UPDATE	#ArchAppCopyToBeAged
	SET		retentionDays = CASE retentionCycles
													WHEN 0 THEN
														retentionDays
													ELSE
														CASE retentionDays
															WHEN 0 THEN
																@RetentionDaysWhenCyclesIgnored
															ELSE
																retentionDays
														END
												END,
				retentionCycles = 0, StartTimeLastFull = 0
WHERE	appFlags & CAST(34359738368 AS bigint) > 0
	AND		appId NOT IN (SELECT appId FROM #tblTurboAppId)
	AND		appId NOT IN (SELECT appId FROM @tblPSTArchiveAppId)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Keep last cycle forever for TURBO subclient
UPDATE	#ArchAppCopyToBeAged
SET		retentionCycles = CASE WHEN ((appFlags & 2048) = 0 AND (appFlags & 1048576) = 0) THEN 1 ELSE 0 END,
StartTimeLastFull = CASE WHEN ((appFlags & 2048) = 0 AND (appFlags & 1048576) = 0) THEN StartTimeLastFull ELSE 0 END
WHERE	appFlags & CAST(34359738368 AS bigint) > 0
	AND		(
					appId IN (SELECT appId FROM #tblTurboAppId)
					OR
				 	appId IN (SELECT appId FROM @tblPSTArchiveAppId)
				 )
		AND 	(retentionCycles > 0 OR retentionDays > 0)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	END
	--Ignore SP_CHANGE_KEEP_LAST_FULL rule if the client is uninstalled and cycle retention is 0 when MMConfig parameter is set to honor cycles on de-configured clients.
	IF @ignoreCyclesOnDeConfiguredClients = 0
	BEGIN
UPDATE	#ArchAppCopyToBeAged
	SET		StartTimeLastFull = 0
WHERE	subclientStatus & 0x00002 > 0
	AND 	retentionCycles = 0
	AND		appId NOT IN (SELECT appId FROM #tblTurboAppId)
	AND		appId NOT IN (SELECT appId FROM @tblPSTArchiveAppId)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	END
	--Ignore SP_CHANGE_KEEP_LAST_FULL rule if backup activity is disabled on the client\subclient and cycle retention is 0 when MMConfig parameter is set to honor cycles on backup activity disabled clients.
	IF @ignoreCyclesOnBackupActivityDisabledSubclients = 0
	BEGIN
UPDATE	#ArchAppCopyToBeAged
	SET		StartTimeLastFull = 0
WHERE	appFlags & CAST(34359738368 AS bigint) > 0
	AND 	retentionCycles = 0
	AND		appId NOT IN (SELECT appId FROM #tblTurboAppId)
	AND		appId NOT IN (SELECT appId FROM @tblPSTArchiveAppId)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	END
	-- Set the appFlags for reports
UPDATE	#ArchAppCopyToBeAged
SET			appFlags = appFlags | 32768
WHERE	subclientStatus & 0x00002 > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	------------------------------------
	-- Update Log Rules for Subclient --
	------------------------------------
	-- DATODO -- Get the appTypes for logs that needs to be pruned at subclient level
	-- Default logAginglevel to LOGAGING_SUBCLIENT
UPDATE	#ArchAppCopyToBeAged
SET		logAgingLevel = 3
WHERE	appFlags & 4 > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Age log at instance level
UPDATE	#ArchAppCopyToBeAged
	SET		appTypeToAge = 1,
logAgingLevel = 1
WHERE	appFlags & 4 > 0
	AND		appType IN (
81,
6,
59,
51,
77,
2,
22,
23,
80,
3,
61,
79,
104,
128
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--AGE SQL Diff. data at instance level
UPDATE	#ArchAppCopyToBeAged
SET		linkToLog = 1, logAgingLevel = 1
WHERE	appFlags & 32 > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Age log at backupset level
UPDATE	#ArchAppCopyToBeAged
	SET		appTypeToAge = 1,
logAgingLevel = 2
WHERE	appFlags & 4 > 0
	AND		appType IN (
37,
62,
4,
16,
70,
103,
125,
135
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Age log at subclient level
UPDATE	#ArchAppCopyToBeAged
	SET		appTypeToAge = 1,
logAgingLevel = 3
WHERE	appFlags & 4 > 0
	AND		appType IN (
5,
126
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	----------------------------------------------------------------
	-- The spool copies without justInTime are pruned by separete
	-- stored procedure	(daAgeSpoolCopies.sp)
	-- Do not process the Spool Copy without justInTime enabled
	----------------------------------------------------------------
UPDATE	#ArchAppCopyToBeAged
SET		DoNotAge = DoNotAge | 8
FROM	#ArchAppCopyToBeAged a, archAgingRule b WITH (NOLOCK)
	WHERE	a.copyId = b.CopyId
	AND 	a.CopyIsSpool = 1
AND 	(b.flags & 8) = 0
AND		(a.appFlags & 33554432) = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-----------------------------------
	-- Update DoNotAge for Subclient --
	-----------------------------------
UPDATE	#ArchAppCopyToBeAged
SET		DoNotAge = DoNotAge | 2
	WHERE	(retentionDays = -1 OR retentionCycles = -1)
AND		(appFlags & 33554432) = 0
AND		(appFlags & 67108864) = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--If this parameter is enabled then set days\cycles reason for INFINITE retention to consider SP change ignore cycle case
	IF @honorBasicCyclesOnlyToApplyLogRule = 1
	BEGIN
UPDATE	#ArchAppCopyToBeAged
SET		DoNotAge = DoNotAge | 32
		WHERE	retentionCycles = -1
AND		(appFlags & 33554432) = 0
AND		(appFlags & 67108864) = 0
		IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	END
	-- Do not age data of unknown apptype
UPDATE	#ArchAppCopyToBeAged
SET		AgeStatus = 2,
DoNotAge = DoNotAge | 1,
appFlags = appFlags | 524288
	WHERE	appTypeToAge = 0
	SELECT 	@errorCode = @@ERROR, @totalAppIdUnknown = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	INSERT INTO @tblAppIdSelectedForProcessing
	SELECT	DISTINCT appId
FROM	#ArchAppCopyToBeAged
	WHERE	appIdSelectedForProcessing > 0
	AND		appTypeToAge > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Get instances with logs being selected
	INSERT	INTO @tblInstanceToAge
	SELECT	distinct a.instanceId, 0
FROM	#ArchAppCopyToBeAged a, @tblAppIdSelectedForProcessing b
	WHERE	a.appId = b.appId
	AND		a.appTypeToAge > 0
AND 	a.logAgingLevel = 1
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Get backupsets with logs being selected
	INSERT	INTO @tblBackupSetToAge
	SELECT	distinct a.backupSetId
FROM	#ArchAppCopyToBeAged a, @tblAppIdSelectedForProcessing b
	WHERE	a.appId = b.appId
	AND		a.appTypeToAge > 0
AND 	a.logAgingLevel = 2
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Get subclients with logs being selected
	INSERT	INTO @tblSubclientToAge
	SELECT	distinct a.appId
FROM	#ArchAppCopyToBeAged a, @tblAppIdSelectedForProcessing b
	WHERE	a.appId = b.appId
	AND		a.appTypeToAge > 0
AND 	a.logAgingLevel = 3
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark the instances with FFG subclient
	UPDATE	@tblInstanceToAge
	SET			havingFFG = 1
FROM 		@tblInstanceToAge inst, #ArchAppCopyToBeAged aca
	WHERE 	inst.instanceId = aca.instanceId
AND			aca.appFlags & 2 > 0
AND			aca.appFlags & 32 = 0
AND			aca.appType = 81
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark the instances with FFG subclient
	UPDATE	@tblInstanceToAge
	SET			havingFFG = 1
FROM 		@tblInstanceToAge inst, #ArchAppCopyToBeAged aca, App_SubclientProp prop WITH (NOLOCK)
	WHERE 	inst.instanceId = aca.instanceId
AND			aca.appFlags & 4 > 0
AND			aca.appType = 81
	AND			aca.appId = prop.componentNameId
	AND			prop.attrName = 'mssql subclient type'
	AND			prop.attrVal = '2' -- FFG
	AND			prop.modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | 131072
FROM	#ArchAppCopyToBeAged aca, @tblInstanceToAge inst
	WHERE	aca.instanceId = inst.instanceId
	AND		inst.havingFFG = 1
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark data and log to be aged on all copies if they are selected
UPDATE	#ArchAppCopyToBeAged
	SET		appIdSelectedForProcessing = 1, linkToLog = 1,
logAgingLevel = 1
FROM	#ArchAppCopyToBeAged
WHERE	appFlags & 2 > 0
	AND		instanceId IN (SELECT instanceId FROM @tblInstanceToAge)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
	SET		appIdSelectedForProcessing = 1
FROM	#ArchAppCopyToBeAged
WHERE	appFlags & 4 > 0
	AND		instanceId IN (SELECT instanceId FROM @tblInstanceToAge)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
	SET		appIdSelectedForProcessing = 1, linkToLog = 1,
logAgingLevel = 2
FROM	#ArchAppCopyToBeAged
WHERE	appFlags & 2 > 0
	AND		backupSetId IN (SELECT backupSetId FROM @tblBackupSetToAge)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
	SET		appIdSelectedForProcessing = 1
FROM	#ArchAppCopyToBeAged
WHERE	appFlags & 4 > 0
	AND		backupSetId IN (SELECT backupSetId FROM @tblBackupSetToAge)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
	SET		appIdSelectedForProcessing = 1, linkToLog = 1,
logAgingLevel = 3
FROM	#ArchAppCopyToBeAged
WHERE	appFlags & 2 > 0
	AND		appId IN (SELECT appId FROM @tblSubclientToAge)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
UPDATE	#ArchAppCopyToBeAged
	SET		appIdSelectedForProcessing = 1
FROM	#ArchAppCopyToBeAged
WHERE	appFlags & 4 > 0
	AND		appId IN (SELECT appId FROM @tblSubclientToAge)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Select all the copies for processing on selected Storage Policies
UPDATE	#ArchAppCopyToBeAged
	SET		appIdSelectedForProcessing = 1
WHERE	archGrpId IN (SELECT DISTINCT archGrpId FROM #ArchAppCopyToBeAged WHERE appIdSelectedForProcessing = 1)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	--Select all the SP\copies for selected subclients to compute jobs in cycle across SPs
UPDATE	#ArchAppCopyToBeAged
	SET		appIdSelectedForProcessing = 1
FROM 	#ArchAppCopyToBeAged A, @tblAppIdSelectedForProcessing T
	WHERE A.appId = T.appId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
    --Do not link turbo subclient data with log
UPDATE	#ArchAppCopyToBeAged
	SET		linkToLog = 0, logAgingLevel = 0
	WHERE	appId IN (SELECT appId FROM #tblTurboAppId)
    AND     (linkToLog > 0 OR logAgingLevel > 0)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Do not age appId filtered out by quick data aging
UPDATE	#ArchAppCopyToBeAged
SET		DoNotAge = DoNotAge | 8
	WHERE	appIdSelectedForProcessing = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Overwrite all DoNotAge flags for SILO_APP
UPDATE	#ArchAppCopyToBeAged
SET		DoNotAge = 262144
FROM	#ArchAppCopyToBeAged a, ArchGroupCopy b WITH (NOLOCK)
	WHERE	a.appId = b.siloAppId
	AND		b.siloAppId > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Skip Indexing Subclient from Aging
UPDATE	#ArchAppCopyToBeAged
SET		DoNotAge = 33554432
FROM	#ArchAppCopyToBeAged a, App_SubclientProp b WITH (NOLOCK)
	WHERE	a.appId = b.componentNameId
	AND		b.attrName = N'Index SubClient'
	AND		b.attrVal = '1'
	AND		b.modified = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Mark VSA V2 Parent Subclients
UPDATE	#ArchAppCopyToBeAged
SET		appFlags = appFlags | CAST(2147483648 AS bigint)
FROM	#ArchAppCopyToBeAged a, JMJobDataLink b WITH (NOLOCK)
	WHERE	a.appId = b.parentAppId
AND 	b.linkType IN (7, 8)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	----- Get oldest data time for appId linked to log that won't be aged ---------
	-------------------------------------------------------------------------------
	-- This time is used by log aging. To be copied jobs are included
	INSERT	INTO #DA_JobDataStats
	SELECT	a.AppId, a.CopyId, a.FileType, b.JobId, b.CommCellId
FROM	#ArchAppCopyToBeAged a, JMJobDataStats b WITH (NOLOCK)
WHERE	a.appFlags & 2 > 0
	AND		a.DoNotAge > 0
	AND 	a.LinkToLog > 0
	AND		(b.status = 100 or b.status in (101, 102, 103) and b.disabled & 1 = 0)
	AND 	b.Disabled & 256 = 0
	AND 	a.AppId = b.AppId
	AND 	a.CopyId = b.ArchGrpCopyId
	AND 	(a.FileType = 0 OR a.FileType = b.dataType)
	GROUP	BY a.AppId, a.CopyId, a.FileType, b.JobId, b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Get earliest job start time for a successful or partially successful data job per
	-- appId and copy that cannot be pruned and have associated logs
	INSERT	INTO @tblOldestJob
	SELECT	a.AppId, a.CopyId, a.FileType,
			MIN(b.ServStartDate)
	FROM	#DA_JobDataStats a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND		a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		b.status in (1, 3, 14)
	GROUP	BY a.AppId, a.CopyId, a.FileType
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- initialize AgeTimeBasicRet to oldest job to be retained because of exceptions
	-- (not actual basic retention days)
UPDATE	#ArchAppCopyToBeAged
	SET		AgeTimeBasicRet = b.StartTimeOldestJob
FROM	#ArchAppCopyToBeAged a, @tblOldestJob b
	WHERE	a.AppId = b.AppId
	AND		a.CopyId = b.CopyId
	AND		a.FileType = b.FileType
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Mark not-aged for appid that do not need to be aged
UPDATE	#ArchAppCopyToBeAged
SET		AgeStatus = 5
	WHERE	DoNotAge > 0
	AND		AgeStatus = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	----------------------------- Get return variables ----------------------------
	-------------------------------------------------------------------------------
	SET		@totalAppIdFound = (
SELECT COUNT(*) FROM #ArchAppCopyToBeAged
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	SET		@totalAppIdToBeAged = (
SELECT COUNT(*) FROM #ArchAppCopyToBeAged
			WHERE	AgeStatus = 0
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- SQL subclients to be chained
	SET		@totalAppIdSqlChain = (
SELECT COUNT(*) FROM #ArchAppCopyToBeAged
			WHERE	AgeStatus = 0
AND		(  AppFlags & 16 > 0
OR AppFlags & 32 > 0
					)
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	SET		@totalAppIdExtRet = (
SELECT COUNT(*) FROM #ArchAppCopyToBeAged
			WHERE	AgeStatus = 0
			AND		extendedRetention > 0
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	if object_id('tempdb.dbo.#DA_JobDataStats') is not null DROP TABLE #DA_JobDataStats
	if object_id('tempdb.dbo.#tmpDAHoldClientList') is not null DROP TABLE #tmpDAHoldClientList
	if object_id('tempdb.dbo.#tmpDAHoldInstanceList') is not null DROP TABLE #tmpDAHoldInstanceList
	if object_id('tempdb.dbo.#tmpDAHoldAppIdList') is not null DROP TABLE #tmpDAHoldAppIdList
	if object_id('tempdb.dbo.#tmpSCWithRetOverride') is not null DROP TABLE #tmpSCWithRetOverride
	if object_id('tempdb.dbo.#tmpSCWithRunningRestores') is not null DROP TABLE #tmpSCWithRunningRestores
	if object_id('tempdb.dbo.#tmpVSAAppAwareSC') is not null DROP TABLE #tmpVSAAppAwareSC
	if object_id('tempdb.dbo.#tmpNASSCOverrideSpoolRet') is not null DROP TABLE #tmpNASSCOverrideSpoolRet
	if object_id('tempdb.dbo.#tblAppIdWithCIFSNFSConfig') is not null DROP TABLE #tblAppIdWithCIFSNFSConfig
	if object_id('tempdb.dbo.#tmpCBTEnabledSubclients') is not null DROP TABLE #tmpCBTEnabledSubclients
	if object_id('tempdb.dbo.#tblOracleOnDemandAppId') is not null DROP TABLE #tblOracleOnDemandAppId
	if object_id('tempdb.dbo.#tblTurboAppId') is not null DROP TABLE #tblTurboAppId
	if object_id('tempdb.dbo.#tmpSharepointV2Client') is not null DROP TABLE #tmpSharepointV2Client
	if object_id('tempdb.dbo.#tmpClientsToSkipDA') is not null DROP TABLE #tmpClientsToSkipDA
	if object_id('tempdb.dbo.#tmpDaysForDeconfigClients') is not null DROP TABLE #tmpDaysForDeconfigClients
	RETURN (0)
CX_ERROR_EXIT:
	if object_id('tempdb.dbo.#DA_JobDataStats') is not null DROP TABLE #DA_JobDataStats
	if object_id('tempdb.dbo.#tmpDAHoldClientList') is not null DROP TABLE #tmpDAHoldClientList
	if object_id('tempdb.dbo.#tmpDAHoldInstanceList') is not null DROP TABLE #tmpDAHoldInstanceList
	if object_id('tempdb.dbo.#tmpDAHoldAppIdList') is not null DROP TABLE #tmpDAHoldAppIdList
	if object_id('tempdb.dbo.#tmpSCWithRetOverride') is not null DROP TABLE #tmpSCWithRetOverride
	if object_id('tempdb.dbo.#tmpSCWithRunningRestores') is not null DROP TABLE #tmpSCWithRunningRestores
	if object_id('tempdb.dbo.#tmpVSAAppAwareSC') is not null DROP TABLE #tmpVSAAppAwareSC
	if object_id('tempdb.dbo.#tmpNASSCOverrideSpoolRet') is not null DROP TABLE #tmpNASSCOverrideSpoolRet
	if object_id('tempdb.dbo.#tblAppIdWithCIFSNFSConfig') is not null DROP TABLE #tblAppIdWithCIFSNFSConfig
	if object_id('tempdb.dbo.#tmpCBTEnabledSubclients') is not null DROP TABLE #tmpCBTEnabledSubclients
	if object_id('tempdb.dbo.#tblOracleOnDemandAppId') is not null DROP TABLE #tblOracleOnDemandAppId
	if object_id('tempdb.dbo.#tblTurboAppId') is not null DROP TABLE #tblTurboAppId
	if object_id('tempdb.dbo.#tmpSharepointV2Client') is not null DROP TABLE #tmpSharepointV2Client
	if object_id('tempdb.dbo.#tmpClientsToSkipDA') is not null DROP TABLE #tmpClientsToSkipDA
	if object_id('tempdb.dbo.#tmpDaysForDeconfigClients') is not null DROP TABLE #tmpDaysForDeconfigClients
    RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_SQLChain_PopulateArchAppCopy')
	delete from GxQscripts where name = 'CCM_Capture_SQLChain_PopulateArchAppCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SQLChain_PopulateArchAppCopy')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SQLChain_PopulateArchAppCopy'
GO

insert into GXDBVersions values(2, 'CCM_Capture_SQLChain_PopulateArchAppCopy',  '00010003001200080000', 'CCM_Capture_SQLChain_PopulateArchAppCopy', '00010003001200080000')
GO

