

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_SQLChain_Data.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_SQLChain_Data.sp,v 1.3.12.3 2018/12/27 16:36:22 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_SQLChain_Data')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_SQLChain_Data <<<'
	drop procedure CCM_Capture_SQLChain_Data
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_SQLChain_Data')
	delete from GxQscripts where name = 'CCM_Capture_SQLChain_Data'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SQLChain_Data')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SQLChain_Data'
GO
print '... Creating Procedure: CCM_Capture_SQLChain_Data'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_SQLChain_Data
AS
	SET NOCOUNT ON
	DECLARE @errorCode								INTEGER
	DECLARE @numAppIdChained					INTEGER
	DECLARE	@instanceId								INTEGER
	DECLARE @instanceListCursorFlag 	INTEGER
	DECLARE @currentTime 							INTEGER
	DECLARE	@numJobCopy								INTEGER
	DECLARE	@isSQLAlwaysOn						INTEGER
	DECLARE @enableBkpCopyChainFix		INTEGER
	SET		@errorCode								= 0
	SET		@numAppIdChained					= 0
	SET		@instanceId								= 0
	SET 	@instanceListCursorFlag 	= 0
	SET		@isSQLAlwaysOn						= 0
	SET		@enableBkpCopyChainFix		= 1
	DECLARE 	@IgnoreLogRule 	INTEGER
	SET				@IgnoreLogRule 	= 0
	DECLARE 	@honorSQLChainForFullOnSelCopy 	INTEGER
	SET				@honorSQLChainForFullOnSelCopy 	= 1
	-------------------------------------------------------------------------------
	---------------- Apply SQL Chain Rule based on Param Value --------------------
	-------------------------------------------------------------------------------
	SELECT @IgnoreLogRule = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_PRUNE_ALL_DB_AGENT_LOGS_BY_DAYS_ONLY_RETENTION'
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT @honorSQLChainForFullOnSelCopy = isnull(value, 1)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_HONOR_SQL_CHAINING_FOR_FULL_ON_SELECTIVE_COPY'
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT @enableBkpCopyChainFix = isnull(value, 1)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_ENABLE_SQL_BACKUP_COPY_CHAIN_FIX'
	SET	@errorCode = @@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	IF @IgnoreLogRule = 0
	BEGIN
		SET 	@currentTime = dbo.GetUnixTime(GETUTCDATE())
		SET 	@numJobCopy								= 0
		-------------------------------------------------------------------------------
		-- Table variable declarations
		-------------------------------------------------------------------------------
		DECLARE @tblAppIdList TABLE (
				appId int,
				fileType int,
				Primary key (appId, fileType)
				)
		CREATE	TABLE #DA_JobDataStats (
				AppId int, archGrpId int, CopyId int,
				JobId int, CommCellId int, DataStatus int,
				Disabled int, ManualRet int, JobFlags int
				)
		CREATE CLUSTERED INDEX Idx_DA_JobDataStats ON #DA_JobDataStats (JobId, CommCellId, CopyId)
		CREATE	TABLE #DA_JobCopyList (
				AppId int, AppFlags bigint,
				CopyId int, FileType int,
				JobId int, CommCellId int,
				StartTime int, EndTime int,
				BkpLevel int, JobStatus int,
				DataStatus int, Disabled int,
				isCWEjobValid int, JobFlags int,
				isSnapJob smallint
				)
		CREATE INDEX Idx_DA_JobCopyList_1 ON #DA_JobCopyList (AppId, CopyId)
		CREATE CLUSTERED INDEX Idx_DA_JobCopyList_2 ON #DA_JobCopyList (JobId, CommCellId, CopyId)
		CREATE INDEX Idx_DA_JobCopyList_3 ON #DA_JobCopyList (StartTime)
		-- Create just the table
		SELECT	*
		INTO	#DA_AppCopyList
		FROM ArchAppCopyToBeAged
		WHERE 1 = 2
		CREATE INDEX Idx_DA_AppCopyList ON #DA_AppCopyList (AppId, CopyId)
		CREATE TABLE #nonAgedLogAFs (
			commCellId	int,
			archFileId	int,
			jobId				int,
			isSnapJob		smallint
		)
		CREATE CLUSTERED INDEX Idx_nonAgedLogAFs_1 ON #nonAgedLogAFs (archFileId, commCellId)
		CREATE INDEX Idx_nonAgedLogAFs_2 ON #nonAgedLogAFs (jobId, commCellId)
		CREATE TABLE #NonAgedLSNData (
			databaseId				int,
			type							char,
			full_bkup_lsn 		NUMERIC(25, 0),
			lastJobStartDate	int,
			jobId							int
		)
		CREATE CLUSTERED INDEX Idx_NonAgedLSNData_1 ON #NonAgedLSNData (databaseId, full_bkup_lsn, type)
		CREATE TABLE #SQLIdsToKeepForChaining (
			sqldbBackupFileId	int,
			jobId							int
		)
		CREATE CLUSTERED INDEX Idx_SQLIdsToKeepForChaining_1 ON #SQLIdsToKeepForChaining (sqldbBackupFileId)
		CREATE TABLE #AFsToRetainForChaining (
			commCellId		int,
			archFileId		int,
			jobId					int,
			isSnapJob			int,
			chainedJobId	int
		)
		CREATE CLUSTERED INDEX Idx_AFsToRetainForChaining_1 ON #AFsToRetainForChaining (archFileId, commCellId)
		CREATE INDEX Idx_AFsToRetainForChaining_2 ON #AFsToRetainForChaining (jobId, commCellId)
EXEC SQLUtilTruncateTable '#ArchFileSQLToBeCaptured'
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		DECLARE	instanceListCursor CURSOR STATIC FOR
		SELECT	distinct instanceId
FROM	#ArchAppCopyToBeAged
WHERE	((appFlags & (4|4096)) = (4|4096)
OR		(appFlags & 32) = 32)
		AND		appTypeToAge > 0
AND 	logAgingLevel = 1
		AND		appIdSelectedForProcessing = 1
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		SET		@instanceListCursorFlag = 1
		OPEN	instanceListCursor
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		FETCH	NEXT
		FROM instanceListCursor
		INTO @instanceId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Processing SQL chain check at instance level
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			DELETE FROM @tblAppIdList
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			TRUNCATE TABLE #DA_JobDataStats
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			TRUNCATE TABLE #DA_JobCopyList
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			TRUNCATE TABLE #DA_AppCopyList
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			TRUNCATE TABLE #nonAgedLogAFs
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			TRUNCATE TABLE #NonAgedLSNData
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			TRUNCATE TABLE #SQLIdsToKeepForChaining
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			TRUNCATE TABLE #AFsToRetainForChaining
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			SET	@isSQLAlwaysOn = 0
			IF EXISTS (	SELECT 1
									FROM APP_Application A WITH (NOLOCK), APP_Client C WITH (NOLOCK)
									WHERE A.Instance = @instanceId
									AND		A.ClientId = C.Id
AND		(C.status & 0x20000000) = 0x20000000
								)
			BEGIN
				SET	@isSQLAlwaysOn = 1
			END
			INSERT	INTO @tblAppIdList
					(appId, fileType)
			SELECT	DISTINCT appId, fileType
FROM	#ArchAppCopyToBeAged
			WHERE	instanceId = @instanceId
AND 	((appFlags & (4|4096)) = (4|4096)
OR		(appFlags & 32) = 32)
			AND		appTypeToAge > 0
AND 	logAgingLevel = 1
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			-- Get appId to be processed
			INSERT INTO	#DA_AppCopyList
			SELECT	b.*
FROM	@tblAppIdList a, #ArchAppCopyToBeAged b
			WHERE	a.appId = b.appId
			AND 	a.fileType = b.fileType
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			-------------------------------------------------------------------------------
			-- Get the data from JMJobDataStats table for the appIds to be processed
			-- on all copies
			-- This table may contain entries for ASR backup
			-------------------------------------------------------------------------------
			INSERT	INTO #DA_JobDataStats
			SELECT	b.AppId, b.archGrpId, b.archGrpCopyId,
					b.JobId, b.CommCellId, DataStatus=MAX(b.status),
Disabled=MAX(b.Disabled & 1),
ManualRet=MAX(b.Disabled & 2),
JobFlags = ((MAX(CASE WHEN (b.Disabled & 64) <> 0 THEN 1 ELSE 0 END)) | (MAX(CASE WHEN c.type > 1 THEN 2 ELSE 0 END)))
FROM	#DA_AppCopyList a, #JMJobDataStats b WITH (NOLOCK), APP_CommCell C WITH (NOLOCK)
			WHERE	a.AppId = b.AppId
			AND 	b.status <> 1000
AND 	b.Disabled & 256 = 0
			AND 	a.FileType = b.dataType
			AND		b.CommCellId = c.id
			GROUP	BY b.AppId, b.archGrpId, b.archGrpCopyId, b.JobId, b.CommCellId
			SET	@errorCode	=	@@ERROR
			IF		@errorCode != 0 GOTO CX_EXIT
			-------------------------------------------------------------------------------
			-- Remove Foreign backups if there are any
			-------------------------------------------------------------------------------
			DELETE	#DA_JobDataStats
WHERE	(JobFlags & 2) <> 0
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			-------------------------------------------------------------------------------
			-- Get the data from #DA_JobDataStats table for the appIds to be processed
			-- on selected copies only
			-------------------------------------------------------------------------------
			INSERT	INTO #DA_JobCopyList
			SELECT	DISTINCT a.AppId, a.AppFlags,
							a.CopyId, a.FileType,
							b.JobId, b.CommCellId,
							StartTime = -1, EndTime = -1,
							BkpLevel = -1, JobStatus = -1,
							DataStatus = b.DataStatus, Disabled = b.Disabled,
							a.isCWEjobValid, JobFlags = b.JobFlags, isSnapJob = 0
			FROM	#DA_AppCopyList a, #DA_JobDataStats b
			WHERE	a.AppId = b.AppId
			AND 	a.CopyId = b.CopyId
			SELECT 	@errorCode = @@ERROR, @numJobCopy = @@ROWCOUNT
			IF		@errorCode != 0 GOTO CX_EXIT
			--Truncate table to keep freeing tempDB space
			TRUNCATE TABLE #DA_JobDataStats
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			IF		@numJobCopy > 0
			BEGIN
				----------------------------------------------------------------------------------------------
				-- Get the Start Time, End Time, Backuplevel, JobStatus and fullCycleNum of the selected jobs
				----------------------------------------------------------------------------------------------
				-- Update job info for regular backup
				UPDATE	#DA_JobCopyList
				SET 	StartTime = b.ServStartDate,
							EndTime = b.ServEndDate,
							BkpLevel = b.BkpLevel,
							JobStatus = b.Status,
							isSnapJob = CASE WHEN (c.opType = 59 AND c.subOpType = 0 AND @enableBkpCopyChainFix = 1) THEN 1 ELSE 0 END
				FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK), JMJobStats c WITH (NOLOCK)
				WHERE	a.JobId = b.JobId
				AND 	a.CommCellId = b.CommCellId
				AND		b.JobId = c.JobId
				AND 	b.CommCellId = c.CommCellId
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
				--Do not keep the FULL jobs that are retained by basic retention days
				--Keep only Differential jobs and transaction log jobs to check for chaining
				DELETE #DA_JobCopyList
				WHERE BkpLevel = 1
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
				--AgeTimeByDays will be 0 for infinite retention
				UPDATE	#DA_AppCopyList
				SET 	AgeTimeByDays = @currentTime - RetentionDays * 24 * 3600
				WHERE RetentionDays >= 0
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
				--Keep only those log jobs that are retained by basic retention days and not on selective copy and fully copied\to-be-copied
				DELETE #DA_JobCopyList
				FROM	#DA_JobCopyList a, #DA_AppCopyList b
				WHERE	a.AppId = b.AppId
				AND 	a.CopyId = b.CopyId
				AND 	a.FileType = b.FileType
				AND		((a.StartTime < b.AgeTimeByDays) OR (a.DataStatus IN (101, 102, 103) AND a.Disabled != 0) OR (@honorSQLChainForFullOnSelCopy = 0 AND b.copyType = 2)) --(selective copy)
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
				-- get archive files for logs that are NOT prunable based on days in the copy they reside
				INSERT INTO #nonAgedLogAFs (commCellId, ArchFileId, jobId, isSnapJob)
				SELECT DISTINCT b.commCellId, b.id, b.jobId, a.isSnapJob
				FROM 	#DA_JobCopyList a, archFile b WITH (NOLOCK)
				WHERE a.jobId = b.jobId
				AND		a.commcellid = b.commcellid
				AND   a.fileType = b.fileType
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
				--Truncate table to keep freeing tempDB space
				TRUNCATE TABLE #DA_JobCopyList
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
				-- Use sqlNameId when AlwaysOn else dbId for legacy cases
				-- get sqlNameId/dbId and LSN info for archfiles of unprunable logs
				INSERT INTO #NonAgedLSNData (databaseId, type, full_bkup_lsn, lastJobStartDate, jobId)
				SELECT (CASE WHEN @isSQLAlwaysOn = 0 THEN SBI.dbId ELSE SBI.sqlNameId END) AS databaseId, SBI.type, CAST(SBI.full_bkup_lsn AS NUMERIC(25, 0)) AS full_bkup_lsn, MAX(SBI.backup_start_Date), 0
				FROM 	#nonAgedLogAFs NAAFs, sqlArchiveInfo SAI WITH (NOLOCK), sqlDBBackupInfo SBI WITH (NOLOCK)
				WHERE SAI.afileId = NAAFs.ArchFileId
				AND		SAI.commcellId = NAAFs.commCellId
				AND 	SBI.id = SAI.sqldbBackupFileId
				AND		NAAFs.isSnapJob = 0
				GROUP BY (CASE WHEN @isSQLAlwaysOn = 0 THEN SBI.dbId ELSE SBI.sqlNameId END), SBI.type, full_bkup_lsn
				UNION
				SELECT (CASE WHEN @isSQLAlwaysOn = 0 THEN SBI.dbId ELSE SBI.sqlNameId END) AS databaseId, SBI.type, CAST(SBI.full_bkup_lsn AS NUMERIC(25, 0)) AS full_bkup_lsn, MAX(SBI.backup_start_Date), 0
				FROM 	#nonAgedLogAFs NAAFs, sqlArchiveInfo SAI WITH (NOLOCK), sqlDBBackupInfo SBI WITH (NOLOCK)
				WHERE SAI.backupJobId = NAAFs.jobId
				AND		SAI.commcellId = NAAFs.commCellId
				AND 	SBI.id = SAI.sqldbBackupFileId
				AND		NAAFs.isSnapJob = 1
				GROUP BY (CASE WHEN @isSQLAlwaysOn = 0 THEN SBI.dbId ELSE SBI.sqlNameId END), SBI.type, full_bkup_lsn
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
				--Truncate table to keep freeing tempDB space
				TRUNCATE TABLE #nonAgedLogAFs
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
				--Update with the last jobId in the chain
				UPDATE #NonAgedLSNData
				SET jobId = SBI.jobId
				FROM #NonAgedLSNData NAL, sqlDBBackupInfo SBI WITH (NOLOCK)
				WHERE ( (@isSQLAlwaysOn = 0 AND	SBI.dbId = NAL.databaseId)
								OR
								(@isSQLAlwaysOn = 1 AND	SBI.sqlNameId = NAL.databaseId)
							)
				AND CAST(SBI.full_bkup_lsn AS NUMERIC(25, 0)) = NAL.full_bkup_lsn
				AND SBI.type = NAL.type
				AND	SBI.backup_start_Date = NAL.lastJobStartDate
				AND SBI.instanceId = @instanceId
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
				-- Retain all the LOG backups with same full_bkup_lsn
				-- Retain the dependent full backups (query after first UNION ALL)
				INSERT INTO	#SQLIdsToKeepForChaining (sqldbBackupFileId, jobId)
				SELECT SBI.id, NAL.jobId
				FROM 	#NonAgedLSNData NAL, sqlDBBackupInfo SBI WITH (NOLOCK)
				WHERE ( (@isSQLAlwaysOn = 0 AND	SBI.dbId = NAL.databaseId)
								OR
								(@isSQLAlwaysOn = 1 AND	SBI.sqlNameId = NAL.databaseId)
							)
				AND CAST(SBI.full_bkup_lsn AS NUMERIC(25, 0)) = NAL.full_bkup_lsn
				AND SBI.type = 'L'
				AND NAL.type = 'L'
				AND SBI.instanceId = @instanceId
				UNION ALL
				SELECT SBI.id, NAL.jobId
				FROM #NonAgedLSNData NAL, sqlDBBackupInfo SBI WITH (NOLOCK)
				WHERE ( (@isSQLAlwaysOn = 0 AND	SBI.dbId = NAL.databaseId)
								OR
								(@isSQLAlwaysOn = 1 AND	SBI.sqlNameId = NAL.databaseId)
							)
				AND CAST(SBI.checkpoint_lsn AS NUMERIC(25, 0)) = NAL.full_bkup_lsn
				AND SBI.type = 'D'
				AND	NAL.type IN ('L', 'I')
				AND SBI.instanceId = @instanceId
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
				--Truncate table to keep freeing tempDB space
				TRUNCATE TABLE #NonAgedLSNData
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
				-- get the AFs\Jobs we need to retain.
				INSERT INTO #AFsToRetainForChaining (commCellId, archFileId, jobId, isSnapJob, chainedJobId)
				SELECT DISTINCT SAI.commCellId, SAI.aFileId, SAI.backupJobId, 0, SIds.jobId
				FROM 	#SQLIdsToKeepForChaining SIds, sqlArchiveInfo SAI WITH (NOLOCK)
				WHERE SAI.sqlDBBackupFileId = SIds.sqldbBackupFileId
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
				--Truncate table to keep freeing tempDB space
				TRUNCATE TABLE #SQLIdsToKeepForChaining
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
				-- Update job info for regular backup
				IF @enableBkpCopyChainFix = 1
				BEGIN
					UPDATE	#AFsToRetainForChaining
					SET 	isSnapJob = CASE WHEN (b.opType = 59 AND b.subOpType = 0) THEN 1 ELSE 0 END
					FROM	#AFsToRetainForChaining a, JMJobStats b WITH (NOLOCK)
					WHERE	a.JobId = b.JobId
					AND 	a.CommCellId = b.CommCellId
					SET	@errorCode	=	@@ERROR
					IF	@errorCode != 0 GOTO CX_EXIT
				END
				IF @enableBkpCopyChainFix = 0
				BEGIN
INSERT INTO #ArchFileSQLToBeCaptured (archFileId, commCellId)
					SELECT	DISTINCT a.id, a.commCellId
FROM	archFile a WITH (NOLOCK), archFileCopy b WITH (NOLOCK), #JMJobDataStats c WITH (NOLOCK), #AFsToRetainForChaining d
					WHERE	a.id = b.archFileId
					AND		a.commCellId = b.commCellId
					AND		a.id = d.archFileId
					AND		a.commCellId = d.commCellId
					AND		a.jobId = c.jobId
					AND		a.commCellId = c.commCellId
					AND 	a.fileType = c.dataType
					AND		c.archGrpCopyId = b.archCopyId
AND		c.disabled & 256 = 0
					AND		c.status = 100
					AND		d.isSnapJob = 0
				END
				ELSE
				BEGIN
INSERT INTO #ArchFileSQLToBeCaptured (archFileId, commCellId)
					SELECT	DISTINCT a.id, a.commCellId
FROM	archFile a WITH (NOLOCK), #JMJobDataStats b WITH (NOLOCK), #AFsToRetainForChaining c
					WHERE	a.id = c.archFileId
					AND		a.commCellId = c.commCellId
					AND		a.jobId = b.jobId
					AND		a.commCellId = b.commCellId
					AND 	a.fileType = b.dataType
AND		b.disabled & 256 = 0
					AND		b.status = 100
					AND		c.isSnapJob = 0
					UNION
					SELECT	DISTINCT a.id, a.commCellId
FROM	archFile a WITH (NOLOCK), #JMJobDataStats b WITH (NOLOCK), #AFsToRetainForChaining c
					WHERE	a.jobId = c.jobId
					AND		a.commCellId = c.commCellId
					AND		a.jobId = b.jobId
					AND		a.commCellId = b.commCellId
					AND 	a.fileType = b.dataType
AND		b.disabled & 256 = 0
					AND		b.status = 100
					AND		c.isSnapJob = 1
					SET	@errorCode	=	@@ERROR
					IF	@errorCode != 0 GOTO CX_EXIT
				END
				--Truncate table to keep freeing tempDB space
				TRUNCATE TABLE #AFsToRetainForChaining
				SET	@errorCode	=	@@ERROR
				IF	@errorCode != 0 GOTO CX_EXIT
			END
			FETCH	NEXT
			FROM instanceListCursor
			INTO @instanceId
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END
	END
CX_EXIT:
	IF @instanceListCursorFlag = 1
	BEGIN
			CLOSE				instanceListCursor
			DEALLOCATE	instanceListCursor
	END
	RETURN @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_SQLChain_Data')
	delete from GxQscripts where name = 'CCM_Capture_SQLChain_Data'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SQLChain_Data')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SQLChain_Data'
GO

insert into GXDBVersions values(2, 'CCM_Capture_SQLChain_Data',  '00010003001200030000', 'CCM_Capture_SQLChain_Data', '00010003001200030000')
GO

