

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_SCPolicy.sp] ---------- 

--  +========================================================================+
--  | Stored Procedure: All Subclient Policies data to migrate.
--	| Author : Gokul
--  +========================================================================+
-- $Id: CCM_Capture_SCPolicy.sp,v 1.15.88.2 2018/03/20 00:47:19 jiechen Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_SCPolicy')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_SCPolicy <<<'
	drop procedure CCM_Capture_SCPolicy
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_SCPolicy')
	delete from GxQscripts where name = 'CCM_Capture_SCPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SCPolicy')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SCPolicy'
GO
print '... Creating Procedure: CCM_Capture_SCPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_SCPolicy
  @s_dumpSetName varchar(128),
  @i_jobId integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024)
AS
  DECLARE @errCode INTEGER
  DECLARE @errorString varchar(1024)
	-------------------------------------------------------------
--Code below here is from CCM_Capture_SCPolicy.spb
SET NOCOUNT ON
	BEGIN TRANSACTION CCMCAPSUBCPOLICY
	SET @errCode = 0
	SET @errorString = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
				-- First Commcell Capture --
	---------------------------------------------------------
	-- CommServ_Capture..CCM_APP_CommCell
INSERT INTO CommServ_Capture..CCM_APP_CommCell
	SELECT * FROM CCM_SOURCE_APP_CommCell WHERE Number <> 0
AND id not in (SELECT id FROM CommServ_Capture..CCM_APP_CommCell)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Capture_SCPolicy -- CCM_APP_CommCell'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Step 1
	-- Capture Subclient Policies
	-- CommServ_Capture..CCM_APP_BackupSetName
INSERT INTO CommServ_Capture..CCM_APP_BackupSetName
	SELECT * FROM CCM_SOURCE_APP_BackupSetName
	WHERE CCM_SOURCE_APP_BackupSetName.status = 128 -- Subclient Policies
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Capture_SCPolicy -- CCM_APP_BackupSetName'
		GOTO CX_ERROR_EXIT
	END
	-- Step 2
	-- Capture Subclient Policy properties
	-- CommServ_Capture..CCM_APP_BackupSetProp
INSERT INTO CommServ_Capture..CCM_APP_BackupSetProp
	SELECT * FROM CCM_SOURCE_APP_BackupSetProp
WHERE CCM_SOURCE_APP_BackupSetProp.componentNameId IN (SELECT id FROM CommServ_Capture..CCM_APP_BackupSetName)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Capture_SCPolicy -- CCM_APP_BackupSetProp'
		GOTO CX_ERROR_EXIT
	END
	-- Step 3
	-- Capture template subclients
	-- CommServ_Capture..CCM_APP_Application
INSERT INTO CommServ_Capture..CCM_APP_Application
	SELECT * FROM CCM_SOURCE_APP_Application
WHERE CCM_SOURCE_APP_Application.backupSet IN (SELECT id FROM CommServ_Capture..CCM_APP_BackupSetName)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Capture_SCPolicy -- CCM_APP_Application'
		GOTO CX_ERROR_EXIT
	END
	-- Step 4
	-- Capture the subclient policies
	-- CommServ_Capture..CCM_APP_SubClientProp
INSERT INTO CommServ_Capture..CCM_APP_SubClientProp
	SELECT id, componentNameId, attrName, attrType, attrVal, created, modified, ccpId
	FROM CCM_SOURCE_APP_SubClientProp
WHERE CCM_SOURCE_APP_SubClientProp.componentNameId IN (SELECT id FROM CommServ_Capture..CCM_APP_Application)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Capture_SCPolicy -- CCM_APP_SubClientProp'
		GOTO CX_ERROR_EXIT
	END
	-- Step 5
	-- Capture Subclient Contents
	-- CommServ_Capture..CCM_APP_ScFilterFile
INSERT INTO CommServ_Capture..CCM_APP_ScFilterFile
	SELECT id, componentNameId, type, fileName, created, modified, ccpId
	FROM CCM_SOURCE_APP_ScFilterFile
WHERE CCM_SOURCE_APP_ScFilterFile.componentNameId IN (SELECT id FROM CommServ_Capture..CCM_APP_Application)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Capture_SCPolicy -- CCM_APP_ScFilterFile'
		GOTO CX_ERROR_EXIT
	END
	-- Step 6
	-- CommServ_Capture..CCM_archPipeConfig
INSERT INTO CommServ_Capture..CCM_archPipeConfig
	SELECT * FROM CCM_SOURCE_archPipeConfig
WHERE CCM_SOURCE_archPipeConfig.appNumber IN (SELECT id FROM CommServ_Capture..CCM_APP_Application)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Capture_SCPolicy -- CCM_archPipeConfig'
		GOTO CX_ERROR_EXIT
	END
	-- Need to Migrate Calendar as Storage Policy copy is associated with them
	-- CommServ_Capture..CCM_APP_CustomCalendar
INSERT INTO CommServ_Capture..CCM_APP_CustomCalendar
	SELECT * FROM CCM_SOURCE_APP_CustomCalendar
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Capture_SCPolicy -- CCM_APP_CustomCalendar'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_APP_CustomCalendarMonths
INSERT INTO CommServ_Capture..CCM_APP_CustomCalendarMonths
	SELECT * FROM CCM_SOURCE_APP_CustomCalendarMonths
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Capture_SCPolicy -- CCM_APP_CustomCalendarMonths'
		GOTO CX_ERROR_EXIT
	END
	-- Sub-client Policy Migration should also migrate the associated Storage Policy
	DECLARE @errorCode INT = 0
	EXEC @errorCode = CCM_CAPTURE_AG 0, @i_jobId, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
	-------------------------------------------------------------------
	-- CommServ_Capture..CCM_App_ComponentProp
INSERT INTO CommServ_Capture..CCM_App_ComponentProp
	SELECT a.*
	FROM CCM_SOURCE_App_ComponentProp a
LEFT OUTER JOIN CommServ_Capture..CCM_App_ComponentProp b ON a.Id = b.Id
	WHERE b.Id IS NULL
AND a.ComponentId IN (SELECT Id FROM CommServ_Capture..CCM_APP_SubClientProp)
AND a.ComponentType IN (7, 9)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Capture_APP -- CCM_App_ComponentProp'
		GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------
	SET @errorString = 'NO_ERROR'
	COMMIT	TRANSACTION CCMCAPSUBCPOLICY
	SELECT 0, @errorString
	RETURN
CX_ERROR_EXIT:
   -- IF (Cursor_Status('LOCAL', 'CCM_ApplicationCursor') >= -1)
	--BEGIN
	--	CLOSE CCM_ApplicationCursor
	--	DEALLOCATE CCM_ApplicationCursor
	--END
	IF (Cursor_Status('LOCAL', 'AccessPathQuestionsCursor') >= -1)
	BEGIN
		CLOSE AccessPathQuestionsCursor
		DEALLOCATE AccessPathQuestionsCursor
	END
	ROLLBACK TRANSACTION CCMCAPSUBCPOLICY
	SELECT -1, @errorString
	RETURN
	-------------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_SCPolicy')
	delete from GxQscripts where name = 'CCM_Capture_SCPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SCPolicy')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SCPolicy'
GO

insert into GXDBVersions values(2, 'CCM_Capture_SCPolicy',  '00010015008800020000', 'CCM_Capture_SCPolicy', '00010015008800020000')
GO

