

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_SCP_To_90.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture subclient policy data to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_SCP_To_90.sp,v 1.2.86.1 2018/03/20 00:30:03 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_SCP_To_90 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_SCP_To_90')
	drop procedure CCM_Capture_SCP_To_90
IF EXISTS (select * from GxQscripts where name='CCM_Capture_SCP_To_90')
	delete from GxQscripts where name = 'CCM_Capture_SCP_To_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SCP_To_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SCP_To_90'
GO
print '... Creating Procedure: CCM_Capture_SCP_To_90'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_SCP_To_90
  @i_subClientId integer,
  @i_clientId integer,
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_SCP.spb
SET NOCOUNT ON
	-- Do not use transaction here, because it is called by another stored procedure with transaction
	/**************************************************************
	 * PrasadNara: 10:08 PM 9/3/2012
	 * We are calling this proc only when capturing last subclient in the dump.
	 * So making changes as required to capture this for all captured subclients in the dump.
	 **************************************************************/
   declare @timeStamp		integer
   declare @errorCode integer
   /*
   declare @SCPId  integer
   declare @createdTime integer
   declare @backupsetid	integer
   */
   IF OBJECT_ID('tempdb.dbo.#lt_SCP') IS NOT NULL DROP TABLE #lt_SCP
   CREATE TABLE #lt_SCP (scpId int, createdTime int, subClientId int)
--  BEGIN
BEGIN TRY
   set @timeStamp   = ( select dbo.getunixtime( getutcdate() ) )
IF EXISTS ( SELECT id FROM CommServ_Capture..CCM_App_BackupSetProp
			WHERE attrName = N'Associated subclient Policy' AND
				CONVERT( int, attrval ) > 0 )
     BEGIN
			INSERT INTO #lt_SCP
Select CONVERT( int, attrval ),  created, componentNameId from CommServ_Capture..CCM_App_SubClientProp
			where attrName = N'Associated subclient Policy' and modified = 0 and CONVERT( int, attrval ) > 0
			IF EXISTS(SELECT 1 FROM #lt_SCP)
			BEGIN
					----Insert the subclient content into the associated subclient
					DECLARE @insertSCfile TABLE
					(
					id INTEGER,
					type INTEGER, filename NVarChar(1024), created INTEGER, modified integer, scpId integer, subclientId integer)
					Insert into @insertSCfile
 					SELECT distinct
 					a.id,
 					a.type, a.filename, a.created, a.modified, b.scpId, b.subclientId
					from CCM_SOURCE_APP_scfilterfile a INNER JOIN #lt_SCP b ON a.componentnameId = b.scpId
					where (a.modified = 0 OR a.created > b.createdTime)
					update @insertSCfile set created = b.createdTime
					from @insertSCfile a INNER JOIN #lt_SCP b ON a.scpId = b.scpId
					where a.modified = 0 and a.created < b.createdTime
Insert into CommServ_Capture..CCM_App_ScFilterFile (
 					id,
 					componentNAmeId, type, filename,created, modified)
 					SELECT distinct
 					id,
 					subClientId, type, filename, created, modified from @insertSCfile
					----Insert the subclient properties into the associated subclient
					DECLARE @insertSCProp TABLE ( id INTEGER , attrName NVarChar(256), attrTYpe integer,
						attrVal nvarchar(1024), created INTEGER, modified integer, scpId int, subclientId int)
 					Insert into @insertSCProp
					SELECT DISTINCT a.id,  a.attrName, a.attrType, a.attrVal, a.created, a.modified, b.scpId, b.subclientId
					from CCM_SOURCE_APP_subclientprop a INNER JOIN #lt_SCP b ON a.componentnameId = b.scpId
					where (a.modified = 0 OR a.created > b.createdTime)
					update @insertSCProp set created = b.createdTime
					from @insertSCProp a INNER JOIN #lt_SCP b ON a.scpId = b.scpId
					where a.modified = 0 and a.created < b.createdTime
Insert into CommServ_Capture..CCM_App_SubClientProp (id, componentNameId, attrName, attrType, attrVal, created, modified)
 					SELECT DISTINCT id, subClientId, attrName, attrType, attrVal, created, modified from @insertSCProp
Update CommServ_Capture..CCM_App_SubClientProp set modified = @timeStamp
from CommServ_Capture..CCM_App_SubClientProp a INNER JOIN #lt_SCP b ON a.componentnameId = b.subclientId
					where a.attrName = N'Associated subclient Policy' and a.modified = 0
					DELETE @insertSCfile
					DELETE @insertSCProp
			END
		--Remove the association in backupset prop
Update CommServ_Capture..CCM_App_BackupSetProp set modified = @timeStamp where attrName = N'Associated subclient Policy' and modified = 0
	 END
DECLARE @lt_doubleEntries TABLE (componentNameId INTEGER, attrName NVarChar(255), MaxId INTEGER)
INSERT INTO @lt_doubleEntries
SELECT componentNameId, attrName, MaxId
FROM  (
	select componentNameId, attrName, max(id) as MaxId, count(id) as SettingCount
from CommServ_Capture..CCM_App_SubClientProp
		where modified = 0
		group by componentNameId, attrName
	) as T
WHERE T.SettingCount > 1
DELETE 	CommServ_Capture..CCM_App_SubClientProp
FROM 	CommServ_Capture..CCM_App_SubClientProp AS SCP, @lt_doubleEntries AS tt
WHERE 	SCP.componentNameId = tt.ComponentNameId
	AND SCP.attrName = tt.attrName
	AND SCP.modified = 0 AND SCP.id <> tt.MaxId
	SET @errStr = ""
	SET @errorCode = 0
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	SET @errStr = 'ERROR: CCM_Capture_SCP'
	SET @errorCode = -1
END CATCH;
RETURN @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_SCP_To_90')
	delete from GxQscripts where name = 'CCM_Capture_SCP_To_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_SCP_To_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_SCP_To_90'
GO

insert into GXDBVersions values(2, 'CCM_Capture_SCP_To_90',  '00010002008600010000', 'CCM_Capture_SCP_To_90', '00010002008600010000')
GO

