

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_OperationWindow.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture Operation windows associated with the client/Sub-clients.
--  +========================================================================+
-- $Id: CCM_Capture_OperationWindow.sp,v 1.5.208.2 2018/11/14 19:34:09 kbora Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_OperationWindow')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_OperationWindow <<<'
	drop procedure CCM_Capture_OperationWindow
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_OperationWindow')
	delete from GxQscripts where name = 'CCM_Capture_OperationWindow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_OperationWindow')
	delete from GXDBVersions where aliasname = 'CCM_Capture_OperationWindow'
GO
print '... Creating Procedure: CCM_Capture_OperationWindow'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_OperationWindow
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_OperationWindow.spb
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	/**************************************************************
	 * PrasadNara: 10:08 PM 9/3/2012
	 * We are calling this proc only when capturing last subclient in the dump.
	 * So making changes as required to capture this for all captured subclients in the dump.
	 **************************************************************/
	---------------------------------------------------------
	/*PrasadNara: 4:19 PM 8/24/2012 MR#84347 Don't capture global operation window.*/
	-- Sub-client Specific Operation Window
INSERT INTO CommServ_Capture..CCM_APP_OpWindowRule
	SELECT a.*
	FROM CCM_SOURCE_APP_OpWindowRule a
INNER JOIN CommServ_Capture..CCM_App_Application b ON a.subclientId = b.id
	WHERE a.clientGroupId = 0                                            -- Avoid Group Specific Operation Window
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_OperationWindow -- CCM_APP_OpWindowRule'
	 GOTO CX_ERROR_EXIT
	END
	-- Backupset Specific Operation Window
INSERT INTO CommServ_Capture..CCM_APP_OpWindowRule
	SELECT a.*
	FROM CCM_SOURCE_APP_OpWindowRule a
INNER JOIN CommServ_Capture..CCM_App_BackupSetname b ON a.backupsetId = b.id
	WHERE a.subclientId = 0
	   AND a.clientGroupId = 0                                            -- Avoid Group Specific Operation Window
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_OperationWindow -- CCM_APP_OpWindowRule'
	 GOTO CX_ERROR_EXIT
	END
	-- Instance Specific Operation Window
INSERT INTO CommServ_Capture..CCM_APP_OpWindowRule
	SELECT a.*
	FROM CCM_SOURCE_APP_OpWindowRule a
INNER JOIN CommServ_Capture..CCM_App_InstanceName b ON a.instanceId = b.id
	WHERE a.subclientId = 0
	   AND a.backupsetId = 0
	   AND a.clientGroupId = 0                                            -- Avoid Group Specific Operation Window
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_OperationWindow -- CCM_APP_OpWindowRule'
	 GOTO CX_ERROR_EXIT
	END
	-- Client Specific Operation Window
INSERT INTO CommServ_Capture..CCM_APP_OpWindowRule
	SELECT a.*
	FROM CCM_SOURCE_APP_OpWindowRule a
INNER JOIN CommServ_Capture..CCM_App_Client b ON a.clientId = b.id
	WHERE a.subclientId = 0
	   AND a.backupsetId = 0
	   AND a.instanceId = 0
	   AND a.clientGroupId = 0
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_OperationWindow -- CCM_APP_OpWindowRule'
	 GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_OperationWindow')
	delete from GxQscripts where name = 'CCM_Capture_OperationWindow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_OperationWindow')
	delete from GXDBVersions where aliasname = 'CCM_Capture_OperationWindow'
GO

insert into GXDBVersions values(2, 'CCM_Capture_OperationWindow',  '00010005020800020000', 'CCM_Capture_OperationWindow', '00010005020800020000')
GO

