

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_MediaAgent_To_90.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture Media Agent.
--  +========================================================================+
-- $Id: CCM_Capture_MediaAgent_To_90.sp,v 1.4.78.2 2018/03/20 00:37:25 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_MediaAgent_To_90 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_MediaAgent_To_90')
	drop procedure CCM_Capture_MediaAgent_To_90
IF EXISTS (select * from GxQscripts where name='CCM_Capture_MediaAgent_To_90')
	delete from GxQscripts where name = 'CCM_Capture_MediaAgent_To_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_MediaAgent_To_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_MediaAgent_To_90'
GO
print '... Creating Procedure: CCM_Capture_MediaAgent_To_90'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_MediaAgent_To_90
  @i_mediaAgnetId integer,
  @s_dumpSetName varchar(128),
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errStr varchar(1024) OUTPUT
AS
--- CODE BELOW HERE IS FROM CCM_Capture_MediaAgent.spb  ----------
	DECLARE @activityControlAppId   INTEGER
	/*
	Most cases it should always 1. But why take chance
	*/
	SET @activityControlAppId = ISNULL((SELECT TOP 1 id FROM CCM_SOURCE_APP_Application WHERE appTypeId = 1000),0)
	IF (@activityControlAppId = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- AppId For ActivityControl Not Found in the database'
		GOTO CX_ERROR_EXIT
	END
	-- When capture is done from staged DR Restore (staging DR via CommServDisasterRecoveryTool.exe will set the passwords to empty and changes net_hostname to _disabled) we should fail capture of such clients.
	DECLARE @ClientName VARCHAR(1024)
	SET @ClientName = ISNULL ((SELECT name FROM CCM_SOURCE_APP_Client WHERE id = @i_mediaAgnetId AND client_password = ''), '')
	IF @ClientName <> ''
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- Media agent ['+ @ClientName +'] has no client password, run capture from original database or skip this clent from capture.'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO CommServ_Capture..CCM_App_Application
	SELECT * FROM CCM_SOURCE_APP_Application
	WHERE id = @activityControlAppId
	AND @activityControlAppId NOT IN
(SELECT id FROM CommServ_Capture..CCM_App_Application)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent - CCM_App_Application - Insert -- Activity Control App'
        GOTO CX_ERROR_EXIT
	END
	/*PrasadNara 7:56 PM 7/17/2012
	 *To support pushing cluster MA we need to capture physical nodes as well along with virtual node
	 */
	---------------------------------------------------------
	IF NOT EXISTS (SELECT * FROM MASTER..SYSDATABASES WHERE NAME = 'CommServ_Capture')
	BEGIN
		SET @errStr = 'DATABASE CommServ_Capture DOES NOT EXIST'
		GOTO CX_ERROR_EXIT
	END
IF EXISTS (SELECT * FROM CommServ_Capture..CCM_App_CommCell)
	BEGIN
		SET @errStr = 'DATABASE CommServ_Capture HAS OLD CONTENTS, PLEASE DROP IT AND RECREATE A NEW ONE'
		GOTO CX_ERROR_EXIT
	END
	IF @i_mediaAgnetId < 2
	BEGIN
		SET @errStr = 'Invalid Media Agent Id'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
INSERT INTO CommServ_Capture..CCM_APP_Client
	SELECT id, name, simOperatingSystemId, net_hostname, client_password, refTime, modified,
	offlineEntity, offlineTimeStamp, csHostName, clientDescription, jobResultDir, clientSkewTime,
	cvdPort,evmgrcPort, status, releaseId, spaceCheckFlags ,ccpId,ccpTime,origCCId,GUID,specialClientFlags
	FROM CCM_SOURCE_APP_Client
	WHERE id = @i_mediaAgnetId
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_APP_Client'
	 GOTO CX_ERROR_EXIT
	END
INSERT INTO CommServ_Capture..CCM_JMJobAction
	SELECT DISTINCT a.clientId, a.mediaAgentID, a.appType, a.opType, a.action, a.appId , a.clientGroupId, a.enableTimeZone, a.enableTime , a.UNCenableTime
	FROM CCM_SOURCE_JMJobAction a
	WHERE (
	        (appId = @activityControlAppId AND mediaAgentId = 1 AND appType = 0 AND clientGroupId = 0 AND
				clientId = @i_mediaAgnetId
			) -- client level activity control
		  )
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_JMJobAction'
	 GOTO CX_ERROR_EXIT
	END
INSERT INTO CommServ_Capture..CCM_MMHost
	SELECT * FROM CCM_SOURCE_MMHost
	WHERE  clientId = @i_mediaAgnetId
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_MMHost'
	 GOTO CX_ERROR_EXIT
	END
	-- Capture commcell records
	-- CommServ_Capture..CCM_APP_CommCell
INSERT INTO CommServ_Capture..CCM_App_CommCell
	SELECT
		a.id, a.number, a.clientId, a.parentId, a.aliasName, a.flags, a.refTime,
		a.userName, a.userPassword, a.smtpServer, a.timeZone, a.ipAddress, a.modified, a.ccOpMode,
		a.drIpAddress, dbo.NormalizeForXML(a.encNumber), a.csGUID, a.type
	FROM CCM_SOURCE_APP_CommCell a WHERE Number <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_APP_CommCell'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_simAllGalaxyRel
INSERT INTO CommServ_Capture..CCM_simAllGalaxyRel
	SELECT
	id, release
	FROM CCM_SOURCE_simAllGalaxyRel
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_simAllGalaxyRel'
		GOTO CX_ERROR_EXIT
	END
	-- Delete releases higher than 9.0
DELETE 	CommServ_Capture..CCM_simAllGalaxyRel
	WHERE	id > 14
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_simAllGalaxyRel - DELETE'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_PatchDBSPInfo
INSERT INTO CommServ_Capture..CCM_PatchDBSPInfo
	SELECT A.*
FROM CCM_SOURCE_PatchDBSPInfo A LEFT JOIN CommServ_Capture..CCM_PatchDBSPInfo B ON A.SPNumber = B.SPNumber
	WHERE B.SPNumber IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_PatchDBSPInfo '
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_ClientProp
INSERT INTO CommServ_Capture..CCM_APP_ClientProp
SELECT A.* FROM CCM_SOURCE_APP_ClientProp A INNER JOIN CommServ_Capture..CCM_APP_Client B ON A.componentNameId = B.id
	WHERE A.attrName NOT IN ('Data Encryption',                    -- CS Specific Properties which need not be captured as CS is never migrated
					 'Data Verification',
					 'Data Multiplexing',
					 'Commcell Migration',
					 'Grid Store',
					 'Installed Content Addressed Storage',
					 'Installed DVD Support',
					 'Installed UDO Support',
					 'Installed CommCell Readiness Check',
					 'Installed Advanced FileSystem iDA Options',
					 'Installed 1-Touch Server for Windows',
					 'Installed Client Groups',
					 'Installed Advanced Copy Features',
					 'Installed Advanced Media Management Features',
					 'Installed Recovery Points',
					 'Active Directory Signon',
					 'Compliance Search',
					 'Legal Hold',
					 'Compliance Director',
					 'Tagging',
					 'Microsoft Office Sharepoint Server',
					 'CommNet Advanced Reporting',
					 'File Level Enabler for SRM',
					 'Library Sharing Across CommCells',
					 'SAP ArchiveLink',
					 'Vault Tracker AppType',
					 'GX Compliance',
					 'System Recovery Boot Server',
					 'Installed CommServe Database',
					 'PlatformDeleted 1',
					 'Commcell timezone Id',
					 'Free space available on Cache',
					 'Cache Current Usage',
					 'Cache Expected Usage',
					 'SRM Services',
					 'Installed CommServe Database',
					 'PlatformDeleted 2',
					 -- skipping these MA analytics properties for temp migration, this should be enabled after name change if needed. If we migrate, push MA delete fails.
					 'AnalyticSearchEngineEnabled',
					 'Analytics_index-dir',
					 'Analytics_Memory_MB',
					 'Analytics_baseport'
					 )
		AND NOT EXISTS(select 1 from CCM_SOURCE_simAppTypeLicTypeMap where isCellLevel = 1 AND A.attrName = dbo.getlicensePropName(appTypeId))
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_APP_ClientProp'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_Platform
INSERT INTO CommServ_Capture..CCM_APP_Platform
	SELECT * FROM CCM_SOURCE_APP_Platform
WHERE clientId IN (SELECT id FROM CommServ_Capture..CCM_APP_Client)
AND platFormType <> 2
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_APP_Platform'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO CommServ_Capture..CCM_APP_Platform
SELECT a.* FROM CCM_SOURCE_APP_Platform a INNER JOIN CommServ_Capture..CCM_MMHost b ON a.clientId = b.clientId
LEFT OUTER JOIN CommServ_Capture..CCM_APP_Platform c ON a.clientId = c.clientId AND a.platFormType = c.platFormType
WHERE a.platFormType = 2 AND c.clientId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_APP_Platform - INSERT MA platForm'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_IdxAccessPath
INSERT INTO CommServ_Capture..CCM_IdxAccessPath
	SELECT AP.IdxAccessPathId, AP.IdxCacheId, AP.ClientId, AP.Path, AP.Username, AP.Password, AP.Enabled, AP.SoftState, AP.OfflineReason, AP.Priority,
		AP.LocalIndexTimeStamp, AP.ActualDaysIndexRetain, AP.Flags, AP.AgeingNoOfDays, AP.AgeingPercentDiskspace, AP.DiskFreeThresholdMB,
		AP.DiskFreeWarningThreshholdMB, AP.TotalCapacityMB, AP.FreeDiskSpaceMB, AP.DiskUsageMB,	AP.DiskUsageLastChecked, AP.StagingCachePath
	FROM CCM_SOURCE_IdxAccessPath AP INNER JOIN CCM_SOURCE_IdxCache IC ON IC.IdxCacheId = AP.IdxCacheId AND IC.IdxCacheType = 1
WHERE AP.clientId IN (SELECT clientId FROM CommServ_Capture..CCM_MMHost)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_IdxAccessPath'
		GOTO CX_ERROR_EXIT
	END
	/*
	AppType - 1001 is not a real license to be consumed - it is pseudo license - CommClient Base
	So every client should have a row in licUsage for AppType - 1001 irrespective of consume license or not
	*/
INSERT	INTO CommServ_Capture..CCM_LicUsage            -- MediaAgent specific licUsage entires
	SELECT	a.*
	FROM 	CCM_SOURCE_LicUsage a
WHERE	a.CId IN (SELECT id FROM CommServ_Capture..CCM_APP_Client)
			AND a.AppType in (1002, 1001, 1092)
			AND a.licType NOT IN (71, 10, 26, 33554432)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_LicUsage)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_licUsage'
		GOTO CX_ERROR_EXIT
	END
	--LicTypes
	--10           Library Control Module     --Library level licenses need not be migrated
	--26           Shared Storage License
	--71           Centera Mount Path
	--33554432	   MediaAgent (General MA license- not used from 9.0)
	--Commserv_Capture..CCM_licUsageHistory
INSERT 	INTO CommServ_Capture..CCM_LicUsageHistory
	SELECT 	DISTINCT a.*
FROM 	CCM_SOURCE_LicUsageHistory a, CommServ_Capture..CCM_LicUsage b
	WHERE 	a.CId = b.CId AND a.AppType = b.AppType AND a.LicType = b.LicType
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_LicUsageHistory)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_licUsageHistory'
	END
	-- CommServ_Capture..CCM_simInstalledPackages
INSERT INTO CommServ_Capture..CCM_simInstalledPackages	-- MediaAgent specific simInstalledPackages entires
	SELECT
		a.id,
		a.ClientId,
		a.simPackageID,
		a.OpTime,
		a.OpType,
		a.UserID,
		a.HighestSP,
		cast (a.AdditionalPatches as nvarchar(max)),
		cast (a.MissingPatches as nvarchar(max)),
		a.Node,
		a.IsActive,
		a.SpMinorVersion,
		a.Baseline,
		cast (a.BaselineDeltaSP as nvarchar(max)),
		cast (a.BaselineDeltaUpdate as nvarchar(max))
	FROM CCM_SOURCE_simInstalledPackages a
	WHERE a.ClientId = @i_mediaAgnetId
	AND a.simPackageID in (SELECT DISTINCT simPackageId FROM CCM_SOURCE_simPackageMap WHERE apptype = 1002)
   	AND NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_simInstalledPackages
	WHERE  ClientId = a.ClientId
	AND    simPackageID = a.simPackageID)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_simInstalledPackages'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_simInstalledPackagesHistory
INSERT INTO CommServ_Capture..CCM_simInstalledPackagesHistory
SELECT a.* from CCM_SOURCE_simInstalledPackagesHistory a, CommServ_Capture..CCM_simInstalledPackages b
	WHERE a.simInstalledPkgID = b.id
	AND NOT EXISTS(SELECT 1
FROM CommServ_Capture..CCM_simInstalledPackagesHistory
		 WHERE simInstalledPkgID = a.simInstalledPkgID
		 AND OpType = a.OpType
		 AND OpTime = a.OpTime)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_simInstalledPackagesHistory'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_simXMLRequest
/*INSERT INTO CommServ_Capture..CCM_simXMLRequest
	SELECT a.* from CCM_SOURCE_simXMLRequest a
	WHERE a.ClientId = @i_mediaAgnetId
	AND (SELECT COUNT(*)
FROM CommServ_Capture..CCM_simXMLRequest
		 WHERE clientId = a.clientId
		 AND OpTimeUTC = a.OpTimeUTC) = 0*/
	DECLARE @tailQuery NVARCHAR(2048)
	DECLARE @ColumnListStr  NVARCHAR(2048)
	SET @tailQuery = ' a 	WHERE a.ClientId ='+cast(@i_mediaAgnetId as varchar(256))+'
	AND NOT EXISTS(SELECT 1
		 FROM CommServ_Capture..CCM_simXMLRequest
		 WHERE clientId = a.clientId
		 AND OpTimeUTC = a.OpTimeUTC) '
	SET @ColumnListStr =
    'a.id , a.clientId , a.OpTimeUTC , a.xmlBlob'
    EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'simXMLRequest', 'CommServ_Capture..CCM_simXMLRequest', @ColumnListStr, @i_exportDBName,@tailQuery
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_simXMLRequest'
		GOTO CX_ERROR_EXIT
	END
	--CCMClientNameMapping
	INSERT INTO CCMClientNameMapping
	SELECT DISTINCT @s_dumpSetName, a.name, a.net_hostname, '', ''
FROM   CommServ_Capture..CCM_APP_Client a
			LEFT OUTER JOIN CCMClientNameMapping b
	        ON b.dumpSetName = @s_dumpSetName
			AND	b.old_name = a.name
	WHERE	b.old_name IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCMClientNameMapping -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_MediaAgent_To_90')
	delete from GxQscripts where name = 'CCM_Capture_MediaAgent_To_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_MediaAgent_To_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_MediaAgent_To_90'
GO

insert into GXDBVersions values(2, 'CCM_Capture_MediaAgent_To_90',  '00010004007800020000', 'CCM_Capture_MediaAgent_To_90', '00010004007800020000')
GO

