

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_MediaAgentXML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture Media Agent into the XML
--  +========================================================================+
-- $Id: CCM_Capture_MediaAgentXML.sp,v 1.13.14.5 2018/12/27 16:40:09 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_MediaAgentXML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_MediaAgentXML <<<'
	drop procedure CCM_Capture_MediaAgentXML
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_MediaAgentXML')
	delete from GxQscripts where name = 'CCM_Capture_MediaAgentXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_MediaAgentXML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_MediaAgentXML'
GO
print '... Creating Procedure: CCM_Capture_MediaAgentXML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_MediaAgentXML
  @i_mediaAgnetId integer
AS
  DECLARE @errorCode int
  DECLARE @errorString varchar(1024) 
  DECLARE @MADataXml xml
SET NOCOUNT ON
SET @errorCode = -1
SET @errorString = 'ERROR: GENERAL ERROR!'
	--DECLARE @TABLE_NAME VARCHAR (1024)
	DECLARE @SYNONYM_DROP_QUERY VARCHAR (MAX)	= ''
	DECLARE @SYNONYM_CREATE_QUERY VARCHAR(MAX) = ''
	DECLARE @TABLE_LIST table(TableName VARCHAR(1024))
	INSERT INTO @TABLE_LIST VALUES ('APP_Application')
	INSERT INTO @TABLE_LIST VALUES ('APP_Client')
	INSERT INTO @TABLE_LIST VALUES ('JMJobAction')
	INSERT INTO @TABLE_LIST VALUES ('MMHost')
	INSERT INTO @TABLE_LIST VALUES ('APP_CommCell')
	INSERT INTO @TABLE_LIST VALUES ('simAllGalaxyRel')
	INSERT INTO @TABLE_LIST VALUES ('APP_ClientProp')
	INSERT INTO @TABLE_LIST VALUES ('APP_Platform')
	INSERT INTO @TABLE_LIST VALUES ('IdxAccessPath')
	INSERT INTO @TABLE_LIST VALUES ('IdxCache')
	INSERT INTO @TABLE_LIST VALUES ('APP_VMToPMMap')
	INSERT INTO @TABLE_LIST VALUES ('simAppTypeLicTypeMap')
	SELECT @SYNONYM_DROP_QUERY += 'DROP SYNONYM CCM_SOURCE_' + TableName + ' ; '
	FROM @TABLE_LIST
	WHERE EXISTS (SELECT 1 FROM dbo.SYSOBJECTS WHERE name = 'CCM_SOURCE_' + TableName AND XTYPE = 'SN')
	EXEC (@SYNONYM_DROP_QUERY)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Create_Synonyms -- Drop existing Synonym Failed'
		GOTO CX_ERROR_EXIT
	END
	SELECT @SYNONYM_CREATE_QUERY += 'CREATE SYNONYM CCM_SOURCE_' + TableName + ' FOR [CommServ]..' + TableName + ' ; '
	FROM @TABLE_LIST
	EXEC (@SYNONYM_CREATE_QUERY)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: Create Synonym Failed'
		GOTO CX_ERROR_EXIT
	END
/*	--Removed cursor and added work around to optimise code
	DECLARE TABLE_NAME_CURSOR CURSOR LOCAL FOR
	SELECT distinct TableName FROM @TABLE_LIST
	OPEN TABLE_NAME_CURSOR
	FETCH NEXT FROM TABLE_NAME_CURSOR
	INTO @TABLE_NAME
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF EXISTS (SELECT * FROM dbo.SYSOBJECTS WHERE name = 'CCM_SOURCE_' + @TABLE_NAME AND XTYPE = 'SN')
		BEGIN
				SET @SYNONYM = 'CCM_SOURCE_' + @TABLE_NAME
				EXEC('DROP SYNONYM ' + @SYNONYM)
				IF	@@ERROR > 0
				BEGIN
					SET @errorString = 'ERROR: CCM_Create_Synonyms -- Drop existing Synonym Failed'
					GOTO CX_ERROR_EXIT
				END
		END
		SET @SYNONYM_CREATE_QUERY = 'CREATE SYNONYM CCM_SOURCE_' + @TABLE_NAME + ' FOR [CommServ]..' +@TABLE_NAME
		EXEC (@SYNONYM_CREATE_QUERY)
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: Create Synonym Failed'
			GOTO CX_ERROR_EXIT
		END
		FETCH NEXT FROM TABLE_NAME_CURSOR
		INTO @TABLE_NAME
	END
	CLOSE TABLE_NAME_CURSOR
	DEALLOCATE TABLE_NAME_CURSOR
*/
	CREATE TABLE #CCM_APP_Application (
		id					INTEGER NOT NULL,
		clientId			integer NOT NULL,
		appTypeId			integer NOT NULL,
		instance	   	    	integer NOT NULL,
		backupSet			integer NOT NULL,
		appNumber			integer NOT NULL,
		dataArchGrpID		smallint NOT NULL,
		logArchGrpID		smallint NOT NULL,
		refTime				INTEGER NOT NULL,
		modified			INTEGER NOT NULL,
		subclientName		nvarchar(128)   NOT NULL,
		subclientStatus     integer NOT NULL,
		ccpId				integer Default 0 NOT NULL,
		ccpTime				INTEGER Default 0 NOT NULL,
		origCCId			tinyint		DEFAULT		2 NOT NULL,
		GUID				uniqueidentifier ROWGUIDCOL,
	)
	CREATE TABLE #CCM_APP_CommCell (
	id					INTEGER NOT NULL,
	number				integer NOT NULL,
	clientId			integer NOT NULL,
	parentId			integer NOT NULL,
	aliasName			nvarchar(256)   NOT NULL,
	flags				integer NOT NULL,
	refTime				INTEGER NOT NULL,
	userName			nvarchar(256)   NOT NULL,
	userPassword		nvarchar(1024)   NOT NULL,
	smtpServer			nvarchar(256)   NOT NULL,
	timeZone			nvarchar(1024)   NOT NULL,
	ipAddress			nvarchar(25)   NOT NULL,
	modified			INTEGER NOT NULL,
	ccOpMode			integer NOT NULL,
	drIpAddress			nvarchar(25)   NOT NULL,
	encNumber			nvarchar(256)   NOT NULL,
	csGUID				nvarchar(40)   NOT NULL,
	type				tinyint default 1 NOT NULL,
    )
  CREATE TABLE #CCM_APP_Client (
	id					INTEGER NOT NULL,
	name			    nvarchar(255)   NOT NULL,
	simOperatingSystemId		integer NOT NULL,
	net_hostname	    nvarchar(255)   NOT NULL,
	client_password	    nvarchar(255)   NOT NULL,
	refTime				INTEGER NOT NULL,
	modified			INTEGER NOT NULL,
	offlineEntity		integer NOT NULL,
	offlineTimeStamp	INTEGER NOT NULL,
	csHostName			nvarchar(255)   NOT NULL,
	clientDescription	nvarchar(MAX) NOT NULL,
	jobResultDir		nvarchar(255)   NOT NULL,
	clientSkewTime		integer NOT NULL,
	cvdPort             integer NOT NULL,
	evmgrcPort			integer NOT NULL,
	status				integer NOT NULL,
	releaseId			integer NOT NULL,
	spaceCheckFlags		integer NOT NULL,
	ccpId				integer Default 0 NOT NULL,
	ccpTime				INTEGER Default 0 NOT NULL,
	origCCId			tinyint		DEFAULT		2 NOT NULL,
	GUID				uniqueidentifier ROWGUIDCOL,
	specialClientFlags	integer Default 0 NOT NULL,
	displayName		nvarchar(255) DEFAULT '' NULL,
	)
  CREATE TABLE #CCM_JMJobAction (
	clientId 			integer NOT NULL,
	mediaAgentID		integer NOT NULL,
	appType				integer NOT NULL,
	opType				integer NOT NULL,
	action				integer NOT NULL,
	appId				integer NOT NULL,
	clientGroupId 		integer NOT NULL,
	enableTimeZone		integer Default 0 NOT NULL,
	enableTime			INTEGER Default 0 NOT NULL,
	UNCenableTime		INTEGER Default 0 NOT NULL,
	instanceID			INTEGER NULL,
	reason				nvarchar(1024) DEFAULT '' NOT NULL,
	)
	CREATE TABLE #CCM_MMHost (
		ClientId					integer NOT NULL,
		MmHostType					integer NOT NULL,
		MmHostSoftState				integer NOT NULL,
		MmHostEnabled				integer NOT NULL,
		OfflineReason				integer NOT NULL,
		OfflineTimeStamp			INTEGER NOT NULL,
		PatchLevel					integer NOT NULL,
		IndexCacheUser				varchar(1024)   NOT NULL,
		IndexCachePassword			varchar(2048)   NOT NULL,
		IndexCachePathName			varchar(1024)   NOT NULL,
		IsIndexShared				integer NOT NULL,
		Attribute					integer NOT NULL,
		ScanIntervalInSec			integer NOT NULL,
		Descript				NVARCHAR(MAX)default '' NOT NULL,
		MaxReservations				integer NOT NULL,
		RMStatus							integer NOT NULL,
		RMStatusUpdateTime		integer NOT NULL,
		RolesBitMask            integer NOT NULL,
	)
  CREATE TABLE #CCM_simAllGalaxyRel (
	id					integer NOT NULL,
	release			    varchar(128)   NOT NULL,
	buildNum            integer DEFAULT 0,
	)
	CREATE TABLE #CCM_APP_ClientProp (
		id				INTEGER NOT NULL,
		componentNameId		integer NOT NULL,
		attrName		    nvarchar(1024)   NOT NULL,
		attrType			integer NOT NULL,
		attrVal			nvarchar(1024)   NOT NULL,
		created			INTEGER NOT NULL,
		modified			INTEGER NOT NULL,
		ccpId				integer Default 0 NOT NULL,
	)
  CREATE TABLE #CCM_APP_Platform (
	clientId		integer NOT NULL,
	platformType	integer NOT NULL,
	install_dir	    nvarchar(255)   NOT NULL,
	refTime			INTEGER NOT NULL,
	)
	CREATE TABLE #CCM_IdxAccessPath (
		IdxAccessPathId			INTEGER NOT NULL,
		IdxCacheId				integer NOT NULL,
		ClientId				integer NOT NULL,
		Path					varchar(1024)   NOT NULL,
		Username				varchar(1024)   NOT NULL,
		Password				varchar(2048)   NOT NULL,
		Enabled					integer NOT NULL,
		SoftState				integer NOT NULL,
		OfflineReason			integer NOT NULL,
		Priority				integer NOT NULL,
		LocalIndexTimeStamp		integer NOT NULL,
		ActualDaysIndexRetain		integer NOT NULL,
		Flags					integer NOT NULL,
		AgeingNoOfDays			integer NOT NULL,
		AgeingPercentDiskspace	integer NOT NULL,
		DiskFreeThresholdMB		integer NOT NULL,
		DiskFreeWarningThreshholdMB	integer NOT NULL,
		TotalCapacityMB			integer NOT NULL,
		FreeDiskSpaceMB			integer Default 0 NOT NULL,
		DiskUsageMB			integer Default 0 NOT NULL,
		DiskUsageLastChecked		integer Default 0 NOT NULL,
		StagingCachePath		varchar(1024)   NOT NULL,
		VolumeGUID				varchar(1024)   NOT NULL,
	)
	CREATE TABLE #CCM_APP_VMToPMMap
	(
		VMClientId			integer   NOT NULL,
		PMClientId			integer   NOT NULL
	)
	DECLARE @errStr varchar(1024)
	SET @errStr = @errorString
    ---------------------------------------------------------
--- CODE BELOW HERE IS FROM CCM_Capture_MediaAgent.spb  ----------
	DECLARE @activityControlAppId   INTEGER
	/*
	Most cases it should always 1. But why take chance
	*/
	SET @activityControlAppId = ISNULL((SELECT TOP 1 id FROM CCM_SOURCE_APP_Application WHERE appTypeId = 1000),0)
	IF (@activityControlAppId = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- AppId For ActivityControl Not Found in the database'
		GOTO CX_ERROR_EXIT
	END
	IF OBJECT_ID('tempdb..#MAList') IS NOT NULL DROP TABLE #MAList
		CREATE TABLE #MAList (id INT)
	INSERT INTO #MAList
	SELECT @i_mediaAgnetId
	-- When capture is done from staged DR Restore (staging DR via CommServDisasterRecoveryTool.exe will set the passwords to empty and changes net_hostname to _disabled) we should fail capture of such clients.
	DECLARE @clientList NVARCHAR(1024) = ''
	SELECT @clientList = @clientList + A.name +', '
	FROM   CCM_SOURCE_APP_Client A WITH (NOLOCK) INNER JOIN #MAList B ON A.id = B.id
	WHERE  A.client_password = ''
	IF @clientList <> ''
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- Media agent ['+ @clientList +'] has no client password, run capture from original database or skip this clent from capture.'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO #CCM_App_Application
	SELECT * FROM CCM_SOURCE_APP_Application
	WHERE id = @activityControlAppId
	AND @activityControlAppId NOT IN
(SELECT id FROM #CCM_App_Application)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent - CCM_App_Application - Insert -- Activity Control App'
        GOTO CX_ERROR_EXIT
	END
	/*PrasadNara 7:56 PM 7/17/2012
	 *To support pushing cluster MA we need to capture physical nodes as well along with virtual node
	 */
	IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @i_mediaAgnetId AND attrName = 'Virtual Client' AND attrVal = 1 AND modified = 0)
	BEGIN
		INSERT INTO #MAList
		SELECT A.PMClientId
		FROM APP_VMToPMMap A INNER JOIN #MAList B ON A.VMClientId = B.id
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- #MAList - INSERT'
			GOTO CX_ERROR_EXIT
		END
	END
INSERT INTO #CCM_APP_Client
	SELECT A.*
	FROM CCM_SOURCE_APP_Client A INNER JOIN #MAList B ON A.id = B.id
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_APP_Client'
	 GOTO CX_ERROR_EXIT
	END
	/*Capture the cs client also as it is needed by for library sharing feature*/
INSERT INTO #CCM_APP_Client
	SELECT srcTbl.* FROM
	(SELECT * FROM CCM_SOURCE_APP_Client WHERE id = (select clientId from CCM_SOURCE_APP_COMMCELL WHERE id = 2) AND id > 1) srcTbl
left outer join #CCM_APP_Client destTbl ON srcTbl.id = destTbl.id
	WHERE destTbl.id is null
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_APP_Client'
	 GOTO CX_ERROR_EXIT
	END
	/*PrasadNara 1:14 PM 7/18/2012  Capture VM to PM map for cluster MA capture*/
INSERT INTO #CCM_APP_VMToPMMap
	SELECT A.* FROM CCM_SOURCE_APP_VMToPMMap A INNER JOIN #MAList B ON A.VMClientId = B.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_APP_VMToPMMap'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO #CCM_JMJobAction
	SELECT DISTINCT a.*
	FROM CCM_SOURCE_JMJobAction a INNER JOIN #MAList b ON a.clientId = b.id
	WHERE appId = @activityControlAppId AND mediaAgentId = 1 AND appType = 0 AND clientGroupId = 0
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_JMJobAction'
	 GOTO CX_ERROR_EXIT
	END
INSERT INTO #CCM_MMHost
	SELECT * FROM CCM_SOURCE_MMHost
	WHERE  clientId IN (SELECT id FROM #MAList)
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_MMHost'
	 GOTO CX_ERROR_EXIT
	END
UPDATE #CCM_MMHost SET attribute = attribute & (~4096)
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- UNSET FLAG ATTRIBUTE MMS2_MA_HOST_IS_LIBRARY_SERVER -- CCM_MMHost'
	 GOTO CX_ERROR_EXIT
	END
	-- Capture commcell records
	-- CommServ_Capture..CCM_APP_CommCell
INSERT INTO #CCM_App_CommCell
	SELECT
		a.id, a.number, a.clientId, a.parentId, a.aliasName, a.flags, a.refTime,
		a.userName, a.userPassword, a.smtpServer, a.timeZone, a.ipAddress, a.modified, a.ccOpMode,
		a.drIpAddress, dbo.NormalizeForXML(a.encNumber), a.csGUID, a.type
	FROM CCM_SOURCE_APP_CommCell a WHERE Number <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_APP_CommCell'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_simAllGalaxyRel
INSERT INTO #CCM_simAllGalaxyRel
	SELECT 	*
	FROM CCM_SOURCE_simAllGalaxyRel
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_simAllGalaxyRel'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_ClientProp
INSERT INTO #CCM_APP_ClientProp
SELECT A.* FROM CCM_SOURCE_APP_ClientProp A INNER JOIN #CCM_APP_Client B ON A.componentNameId = B.id
	WHERE A.attrName NOT IN ('Data Encryption',                    -- CS Specific Properties which need not be captured as CS is never migrated
					 'Data Verification',
					 'Data Multiplexing',
					 'Commcell Migration',
					 'Grid Store',
					 'Installed Content Addressed Storage',
					 'Installed DVD Support',
					 'Installed UDO Support',
					 'Installed CommCell Readiness Check',
					 'Installed Advanced FileSystem iDA Options',
					 'Installed 1-Touch Server for Windows',
					 'Installed Client Groups',
					 'Installed Advanced Copy Features',
					 'Installed Advanced Media Management Features',
					 'Installed Recovery Points',
					 'Active Directory Signon',
					 'Compliance Search',
					 'Legal Hold',
					 'Compliance Director',
					 'Tagging',
					 'Microsoft Office Sharepoint Server',
					 'CommNet Advanced Reporting',
					 'File Level Enabler for SRM',
					 'Library Sharing Across CommCells',
					 'SAP ArchiveLink',
					 'Vault Tracker AppType',
					 'GX Compliance',
					 'System Recovery Boot Server',
					 'Installed CommServe Database',
					 'PlatformDeleted 1',
					 'Commcell timezone Id',
					 'Free space available on Cache',
					 'Cache Current Usage',
					 'Cache Expected Usage',
					 'SRM Services',
					 'Installed CommServe Database',
					 'PlatformDeleted 2',
					 -- skipping these MA analytics properties for temp migration, this should be enabled after name change if needed. If we migrate, push MA delete fails.
					 'AnalyticSearchEngineEnabled',
					 'Analytics_index-dir',
					 'Analytics_Memory_MB',
					 'Analytics_baseport'
					 )
		AND NOT EXISTS(select 1 from CCM_SOURCE_simAppTypeLicTypeMap where isCellLevel = 1 AND A.attrName = dbo.getlicensePropName(appTypeId))
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_APP_ClientProp'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_Platform
INSERT INTO #CCM_APP_Platform
	SELECT * FROM CCM_SOURCE_APP_Platform
WHERE clientId IN (SELECT id FROM #CCM_APP_Client)
AND platFormType <> 2
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_APP_Platform'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO #CCM_APP_Platform
SELECT a.* FROM CCM_SOURCE_APP_Platform a INNER JOIN #CCM_MMHost b ON a.clientId = b.clientId
LEFT OUTER JOIN #CCM_APP_Platform c ON a.clientId = c.clientId AND a.platFormType = c.platFormType
WHERE a.platFormType = 2 AND c.clientId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_APP_Platform - INSERT MA platForm'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_IdxAccessPath
INSERT INTO #CCM_IdxAccessPath
	SELECT AP.*
	FROM CCM_SOURCE_IdxAccessPath AP INNER JOIN CCM_SOURCE_IdxCache IC ON IC.IdxCacheId = AP.IdxCacheId AND IC.IdxCacheType = 1
WHERE AP.clientId IN (SELECT clientId FROM #CCM_MMHost)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MediaAgent -- CCM_IdxAccessPath'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errorString = @errStr
	--By default capture_commcell stored proc captures all rows in App_CommCell, here let us filter those that are not needed
	DELETE FROM #CCM_App_CommCell
	WHERE id > 2
	AND id not in (SELECT origCCId FROM #CCM_APP_Application)
	AND id not in (SELECT origCCId FROM #CCM_APP_Client)
	set @MADataXml =
	(
	select
	cast((select * from #CCM_App_Application for xml raw,root('App_Application')) as xml),
	cast((select * from #CCM_App_CommCell for xml raw,root('App_CommCell')) as xml),
	cast((select * from #CCM_App_Client for xml raw,root('App_Client')) as xml),
	cast((select * from #CCM_JMJobAction for xml raw,root('JMJobAction')) as xml),
	cast((select * from #CCM_MMHost for xml raw,root('MMHost')) as xml),
	cast((select * from #CCM_simAllGalaxyRel for xml raw,root('simAllGalaxyRel')) as xml),
	cast((select * from #CCM_App_ClientProp for xml raw,root('App_ClientProp')) as xml),
	cast((select * from #CCM_App_Platform for xml raw,root('App_Platform')) as xml),
	cast((select * from #CCM_IdxAccessPath for xml raw,root('IdxAccessPath')) as xml),
	cast((select * from #CCM_APP_VMToPMMap for xml raw,root('APP_VMToPMMap')) as xml)
	for xml path(''),root('MediaAgentData')
	)
	SET @errorCode = 0
	SET @errorString = 'NO ERROR'
  SELECT	@errorCode, @errorString, @MADataXml
  RETURN(0)
CX_ERROR_EXIT:
	--IF (Cursor_Status('LOCAL', 'TABLE_NAME_CURSOR') >= -1)
	--BEGIN
	--	CLOSE TABLE_NAME_CURSOR
	--	DEALLOCATE TABLE_NAME_CURSOR
	--END
  SELECT	@errorCode, @errorString, @MADataXml
	RETURN(-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_MediaAgentXML')
	delete from GxQscripts where name = 'CCM_Capture_MediaAgentXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_MediaAgentXML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_MediaAgentXML'
GO

insert into GXDBVersions values(2, 'CCM_Capture_MediaAgentXML',  '00010013001400050000', 'CCM_Capture_MediaAgentXML', '00010013001400050000')
GO

