

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Main_to_XML.sp] ---------- 

--  +=================================================================================================================+
--  | Stored Procedure: Capture ALL data for commcell migration merge into temp tables that will be converted to XML
--  +=================================================================================================================+
-- $Id: CCM_Capture_Main_to_XML.sp,v 1.4.72.4 2018/12/27 16:42:42 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_Main_to_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_Main_to_XML <<<'
	drop procedure CCM_Capture_Main_to_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Main_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_Main_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Main_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Main_to_XML'
GO
print '... Creating Procedure: CCM_Capture_Main_to_XML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_Main_to_XML
  @time_from integer,
  @time_to integer,
  @i_captureActivityControl integer,
  @i_captureHolidays integer,
  @i_captureOperationWindow integer,
  @i_captureSchedule integer,
  @isDefaultSubClient integer,
  @ccmParamFlags integer,
  @i_jobId integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errorString varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_Main.spb
  DECLARE @errorCode integer;
SET XACT_ABORT ON
SET NOCOUNT ON
    -- Do not use transaction here, because it is called by another stored procedure with transaction
	SET @errorCode = 0
	SET @errorString = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
	/*
			@isDefaultSubClient <> 0 if the procedure call is to capture only configuration
			for defaultSubClient of the backupset
			This is needed when the user selects a subClient from the backupSet but not the
			defaultSubCliet.
			Every backupSet needs defaultSubClient for proper functionality of other SubClients
			Hence capturing only certain App_ configuration tables for defaultSubClient
			and exiting
	*/
	IF @isDefaultSubClient <> 0
	BEGIN
		EXEC @errorCode = CCM_CAPTURE_APP_to_XML 0, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		ELSE GOTO CX_SKIP_EXIT
	END
	---------------------------------------------------------
	/*
	 CCM_sqlDbBackupInfo is generated based on sqlDbBackupInfo.tbl file. The column sqlVssFullbackupTime
is nullable in Commserv database however it is not nullable in CommServ_Capture database.
	 Generally, this coulmn will not have null values for a fresh stand along SQL iDA installation, however
	 if the Commserv was upgraded from 6.1 then the column will have null values and this null values has to
	 be carried forward to the new commcell during commcell migration.
	 Hence, the type of the column is changed to allow nulls in the following DDL SQL Query statement.
	 */
ALTER TABLE #CCM_sqlDbBackupInfo ALTER COLUMN sqlVssFullbackupTime varchar(64) NULL
	/*
	 CCM_sqlArchiveInfo is generated based on sqlArchiveInfo.tbl file. The column DbFile
is nullable in Commserv database however it is not nullable in CommServ_Capture database.
	 Generally, this coulmn will not have null values for a fresh stand along SQL iDA installation, however
	 if the Commserv was upgraded from 6.1 then the column will have null values and this null values has to
	 be carried forward to the new commcell during commcell migration.
	 Hence, the type of the column is changed to allow nulls in the following DDL SQL Query statement.
	 */
ALTER TABLE #CCM_sqlArchiveInfo ALTER COLUMN DbFile nvarchar(MAX) NULL
	---------------------------------------------------------
	EXEC @errorCode = CCM_CAPTURE_APP_to_XML @i_captureActivityControl, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	EXEC @errorCode = CCM_CAPTURE_AF_to_XML @time_from, @time_to, @ccmParamFlags, @i_jobid, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	EXEC @errorCode = CCM_CAPTURE_JOB_to_XML @ccmParamFlags, @i_jobId, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	EXEC @errorCode = CCM_CAPTURE_AG_to_XML @ccmParamFlags, @i_jobId, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	EXEC @errorCode = CCM_CAPTURE_MM_to_XML @ccmParamFlags, @i_isExportFromLinkedServer, @i_exportDBName, @i_jobId, @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	EXEC @errorCode = CCM_CAPTURE_SCP_to_XML @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	IF @i_captureHolidays > 0
	BEGIN
		EXEC @errorCode = CCM_Capture_Holiday_to_XML @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	END
	IF @i_captureOperationWindow > 0
	BEGIN
		EXEC @errorCode = CCM_Capture_OperationWindow_to_XML @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
CX_SKIP_EXIT:
	SET @errorString = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO


IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Main_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_Main_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Main_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Main_to_XML'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Main_to_XML',  '00010004007200040000', 'CCM_Capture_Main_to_XML', '00010004007200040000')
GO

