

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Main_to_80.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture ALL data for commcell migration merge.
--  +========================================================================+
-- $Id: CCM_Capture_Main_to_80.sp,v 1.3.72.2 2018/03/20 00:42:56 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_Main_to_80 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_Main_to_80')
	drop procedure CCM_Capture_Main_to_80
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Main_to_80')
	delete from GxQscripts where name = 'CCM_Capture_Main_to_80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Main_to_80')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Main_to_80'
GO
print '... Creating Procedure: CCM_Capture_Main_to_80'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_Main_to_80
  @i_subClientId integer,
  @i_clientId integer,
  @time_from integer,
  @time_to integer,
  @i_captureActivityControl integer,
  @i_captureHolidays integer,
  @i_captureOperationWindow integer,
  @i_captureSchedule integer,
  @isDefaultSubClient integer,
  @ccmParamFlags integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errorString varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_Main.spb
  DECLARE @errorCode integer;
SET XACT_ABORT ON
SET NOCOUNT ON
    -- Do not use transaction here, because it is called by another stored procedure with transaction
	SET @errorCode = 0
	SET @errorString = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
IF NOT EXISTS (SELECT * FROM CommServ_Capture..CCM_APP_Client)
	BEGIN
		SET @errorString = 'CLIENT LIST IS EMPTY! PLEASE CAPTURE CLIENT FIRST!'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	---------------------------------------------------------
	/*
	 CCM_sqlDbBackupInfo is generated based on sqlDbBackupInfo.tbl file. The column sqlVssFullbackupTime
is nullable in Commserv database however it is not nullable in CommServ_Capture_80 database.
	 Generally, this coulmn will not have null values for a fresh stand along SQL iDA installation, however
	 if the Commserv was upgraded from 6.1 then the column will have null values and this null values has to
	 be carried forward to the new commcell during commcell migration.
	 Hence, the type of the column is changed to allow nulls in the following DDL SQL Query statement.
	 */
ALTER TABLE CommServ_Capture..CCM_sqlDbBackupInfo ALTER COLUMN sqlVssFullbackupTime varchar(64) NULL
	/*
	 CCM_sqlArchiveInfo is generated based on sqlArchiveInfo.tbl file. The column DbFile
is nullable in Commserv database however it is not nullable in CommServ_Capture_80 database.
	 Generally, this coulmn will not have null values for a fresh stand along SQL iDA installation, however
	 if the Commserv was upgraded from 6.1 then the column will have null values and this null values has to
	 be carried forward to the new commcell during commcell migration.
	 Hence, the type of the column is changed to allow nulls in the following DDL SQL Query statement.
	 */
ALTER TABLE CommServ_Capture..CCM_sqlArchiveInfo ALTER COLUMN DbFile varchar(1024) NULL
	---------------------------------------------------------
	EXEC @errorCode = CCM_CAPTURE_APP_to_80 i_subClientId, i_clientId, i_captureActivityControl, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	--If this is last subclient in this dump then capture below procs.
IF (2 = (@ccmParamFlags & 2))
	BEGIN
		EXEC @errorCode = CCM_CAPTURE_AF_to_80 i_subClientId, i_clientId, time_from, time_to, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		EXEC @errorCode = CCM_CAPTURE_JOB_to_80 i_subClientId, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		EXEC @errorCode = CCM_CAPTURE_AG_to_80 i_subClientId, i_clientId, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		EXEC @errorCode = CCM_CAPTURE_MM_to_80 i_clientId, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		EXEC @errorCode = CCM_CAPTURE_SCP_to_80 i_subClientId, i_clientId, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		-- now set the SQL NULL columns to empty strings, so that merge
		-- does not fail on CS's that did not upgrade but got newly
		-- installed and have non-nullable columns.
UPDATE CommServ_Capture..CCM_sqlDbBackupInfo
		SET sqlVssFullbackupTime = ''
		WHERE sqlVssFullbackupTime IS null
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Capture_Main -- CCM_sqlDbBackupInfo -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
UPDATE CommServ_Capture..CCM_sqlArchiveInfo
		SET DbFile = ''
		WHERE DbFile IS null
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Capture_Main -- CCM_sqlArchiveInfo -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
	END --IS_LAST_SUBCLIENT_IN_DUMP
	---------------------------------------------------------
CX_SKIP_EXIT:
	SET @errorString = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Main_to_80')
	delete from GxQscripts where name = 'CCM_Capture_Main_to_80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Main_to_80')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Main_to_80'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Main_to_80',  '00010003007200020000', 'CCM_Capture_Main_to_80', '00010003007200020000')
GO

