

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Main_From_90.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture ALL data for commcell migration merge.
--  +========================================================================+
-- $Id: CCM_Capture_Main_From_90.sp,v 1.3.72.2 2018/03/20 00:29:01 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_Main_From_90 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_Main_From_90')
	drop procedure CCM_Capture_Main_From_90
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Main_From_90')
	delete from GxQscripts where name = 'CCM_Capture_Main_From_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Main_From_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Main_From_90'
GO
print '... Creating Procedure: CCM_Capture_Main_From_90'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_Main_From_90
  @i_subClientId integer,
  @i_clientId integer,
  @time_from integer,
  @time_to integer,
  @i_captureActivityControl integer,
  @i_captureHolidays integer,
  @i_captureOperationWindow integer,
  @i_captureSchedule integer,
  @isDefaultSubClient integer,
  @ccmParamFlags integer,
  @i_jobId integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errorString varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_Main.spb
  DECLARE @errorCode integer;
SET XACT_ABORT ON
SET NOCOUNT ON
    -- Do not use transaction here, because it is called by another stored procedure with transaction
	SET @errorCode = 0
	SET @errorString = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
IF NOT EXISTS (SELECT * FROM CommServ_Capture..CCM_APP_Client)
	BEGIN
		SET @errorString = 'CLIENT LIST IS EMPTY! PLEASE CAPTURE CLIENT FIRST!'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	/*
			@isDefaultSubClient <> 0 if the procedure call is to capture only configuration
			for defaultSubClient of the backupset
			This is needed when the user selects a subClient from the backupSet but not the
			defaultSubCliet.
			Every backupSet needs defaultSubClient for proper functionality of other SubClients
			Hence capturing only certain App_ configuration tables for defaultSubClient
			and exiting
	*/
	IF @isDefaultSubClient <> 0
	BEGIN
		EXEC @errorCode = CCM_CAPTURE_APP_FROM_90 @i_subClientId, @i_clientId, 0, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		ELSE GOTO CX_SKIP_EXIT
	END
	---------------------------------------------------------
	/*
	 CCM_sqlDbBackupInfo is generated based on sqlDbBackupInfo.tbl file. The column sqlVssFullbackupTime
is nullable in Commserv database however it is not nullable in CommServ_Capture database.
	 Generally, this coulmn will not have null values for a fresh stand along SQL iDA installation, however
	 if the Commserv was upgraded from 6.1 then the column will have null values and this null values has to
	 be carried forward to the new commcell during commcell migration.
	 Hence, the type of the column is changed to allow nulls in the following DDL SQL Query statement.
	 */
ALTER TABLE CommServ_Capture..CCM_sqlDbBackupInfo ALTER COLUMN sqlVssFullbackupTime varchar(64) NULL
	/*
	 CCM_sqlArchiveInfo is generated based on sqlArchiveInfo.tbl file. The column DbFile
is nullable in Commserv database however it is not nullable in CommServ_Capture database.
	 Generally, this coulmn will not have null values for a fresh stand along SQL iDA installation, however
	 if the Commserv was upgraded from 6.1 then the column will have null values and this null values has to
	 be carried forward to the new commcell during commcell migration.
	 Hence, the type of the column is changed to allow nulls in the following DDL SQL Query statement.
	 */
ALTER TABLE CommServ_Capture..CCM_sqlArchiveInfo ALTER COLUMN DbFile varchar(1024) NULL
	---------------------------------------------------------
	EXEC @errorCode = CCM_CAPTURE_APP_FROM_90 @i_subClientId, @i_clientId, @i_captureActivityControl, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	--If this is last subclient in this dump then capture below procs.
IF (2 = (@ccmParamFlags & 2))
	BEGIN
		EXEC @errorCode = CCM_CAPTURE_AF @i_subClientId, @i_clientId, @time_from, @time_to, @ccmParamFlags, @i_jobid, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		EXEC @errorCode = CCM_CAPTURE_JOB @i_subClientId, @ccmParamFlags, @i_jobid, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		EXEC @errorCode = CCM_CAPTURE_AG @i_subClientId, @i_clientId, @ccmParamFlags, @i_jobId, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		EXEC @errorCode = CCM_CAPTURE_MM @i_clientId, @ccmParamFlags, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		EXEC @errorCode = CCM_CAPTURE_SCP @i_subClientId, @i_clientId, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		IF @i_captureHolidays > 0
		BEGIN
			EXEC @errorCode = CCM_Capture_Holiday @i_clientId, @errStr = @errorString OUTPUT
			IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		END
		IF @i_captureOperationWindow > 0
		BEGIN
			EXEC @errorCode = CCM_Capture_OperationWindow @i_clientId, @i_subClientId, @errStr = @errorString OUTPUT
			IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		END
		/*EXEC @errorCode = CCM_Capture_Snap @i_subClientId, @i_jobId, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT*/
	END --IS_LAST_SUBCLIENT_IN_DUMP
	---------------------------------------------------------
CX_SKIP_EXIT:
	SET @errorString = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO


IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Main_From_90')
	delete from GxQscripts where name = 'CCM_Capture_Main_From_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Main_From_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Main_From_90'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Main_From_90',  '00010003007200020000', 'CCM_Capture_Main_From_90', '00010003007200020000')
GO

