

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Main.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture ALL data for commcell migration merge.
--  +========================================================================+
-- $Id: CCM_Capture_Main.sp,v 1.33.72.4 2018/12/27 16:39:18 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_Main')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_Main <<<'
	drop procedure CCM_Capture_Main
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Main')
	delete from GxQscripts where name = 'CCM_Capture_Main'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Main')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Main'
GO
print '... Creating Procedure: CCM_Capture_Main'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_Main
  @time_from integer,
  @time_to integer,
  @i_captureActivityControl integer,
  @i_captureHolidays integer,
  @i_captureOperationWindow integer,
  @i_captureSchedule integer,
  @isDefaultSubClient integer,
  @ccmParamFlags integer,
  @i_jobId integer,
  @i_GrcCommCellGUID varchar(36),
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errorString varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_Main.spb
  DECLARE @errorCode integer;
SET XACT_ABORT ON
SET NOCOUNT ON
    -- Do not use transaction here, because it is called by another stored procedure with transaction
	SET @errorCode = 0
	SET @errorString = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
	/*
			@isDefaultSubClient <> 0 if the procedure call is to capture only configuration
			for defaultSubClient of the backupset
			This is needed when the user selects a subClient from the backupSet but not the
			defaultSubCliet.
			Every backupSet needs defaultSubClient for proper functionality of other SubClients
			Hence capturing only certain App_ configuration tables for defaultSubClient
			and exiting
	*/
	IF @isDefaultSubClient <> 0
	BEGIN
		EXEC @errorCode = CCM_CAPTURE_APP 0, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
		ELSE GOTO CX_SKIP_EXIT
	END
	---------------------------------------------------------
	/*
	 CCM_sqlDbBackupInfo is generated based on sqlDbBackupInfo.tbl file. The column sqlVssFullbackupTime
is nullable in Commserv database however it is not nullable in CommServ_Capture database.
	 Generally, this coulmn will not have null values for a fresh stand along SQL iDA installation, however
	 if the Commserv was upgraded from 6.1 then the column will have null values and this null values has to
	 be carried forward to the new commcell during commcell migration.
	 Hence, the type of the column is changed to allow nulls in the following DDL SQL Query statement.
	 */
ALTER TABLE CommServ_Capture..CCM_sqlDbBackupInfo ALTER COLUMN sqlVssFullbackupTime varchar(64) NULL
	/*
	 CCM_sqlArchiveInfo is generated based on sqlArchiveInfo.tbl file. The column DbFile
is nullable in Commserv database however it is not nullable in CommServ_Capture database.
	 Generally, this coulmn will not have null values for a fresh stand along SQL iDA installation, however
	 if the Commserv was upgraded from 6.1 then the column will have null values and this null values has to
	 be carried forward to the new commcell during commcell migration.
	 Hence, the type of the column is changed to allow nulls in the following DDL SQL Query statement.
	 */
ALTER TABLE CommServ_Capture..CCM_sqlArchiveInfo ALTER COLUMN DbFile nvarchar(MAX) NULL
	---------------------------------------------------------
	EXEC @errorCode = CCM_CAPTURE_APP @i_captureActivityControl, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	-- For GRC job populate jobs to capture for incremental caputres
IF (1 = (@ccmParamFlags & 1))
	BEGIN
		IF OBJECT_ID('tempdb..#GRC_JOBS_TO_CAPTURE') IS NOT NULL DROP TABLE #GRC_JOBS_TO_CAPTURE
		CREATE TABLE #GRC_JOBS_TO_CAPTURE
		(
			jobId int,
			commcellId int,
			copyId smallint,
			dataType tinyint
		)
		CREATE INDEX GRC_JOBS_TO_CAPTURE_Idx ON #GRC_JOBS_TO_CAPTURE(jobId,commcellId,copyId,datatype)
		EXEC @errorCode = CCM_GRCPopulateJobsToCapture @i_GrcCommCellGUID, @ccmParamFlags, @i_jobId,@time_from, @errorString = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	END
	EXEC @errorCode = CCM_CAPTURE_AF  @time_from, @time_to, @ccmParamFlags, @i_jobid, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	EXEC @errorCode = CCM_CAPTURE_JOB @ccmParamFlags, @i_jobid, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	EXEC @errorCode = CCM_CAPTURE_AG @ccmParamFlags, @i_jobId, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	EXEC @errorCode = CCM_CAPTURE_MM  @ccmParamFlags, @i_isExportFromLinkedServer, @i_exportDBName, @i_jobid, @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	EXEC @errorCode = CCM_CAPTURE_SCP @errStr = @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	IF @i_captureHolidays > 0
	BEGIN
		EXEC @errorCode = CCM_Capture_Holiday @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	END
	IF @i_captureOperationWindow > 0
	BEGIN
		EXEC @errorCode = CCM_Capture_OperationWindow @errStr = @errorString OUTPUT
		IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
CX_SKIP_EXIT:
	SET @errorString = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO


IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Main')
	delete from GxQscripts where name = 'CCM_Capture_Main'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Main')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Main'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Main',  '00010033007200040000', 'CCM_Capture_Main', '00010033007200040000')
GO

