

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_MM_to_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_MM_to_XML.sp,v 1.5.72.5 2018/12/27 16:37:20 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_MM_to_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_MM_to_XML <<<'
	drop procedure CCM_Capture_MM_to_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_MM_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_MM_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_MM_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_MM_to_XML'
GO
print '... Creating Procedure: CCM_Capture_MM_to_XML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_MM_to_XML
  @ccmParamFlags integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @i_jobid INT, 
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_MM.spb
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	/**************************************************************
	 * PrasadNara: 10:08 PM 9/3/2012
	 * We are calling this proc only when capturing last subclient in the dump.
	 * So making changes as required to capture all MM tables for all captured subclients in the dump.
	 **************************************************************/
	---------------------------------------------------------
	-- CommServ_Capture..CCM_MMVolume
	--Capture Volumes corresponding to the captured archChunks
INSERT INTO #CCM_MMVolume
	SELECT MV.*
FROM CCM_SOURCE_MMVolume as MV inner join ( SELECT DISTINCT VolumeId FROM #CCM_ArchChunk) as AC
	ON MV.VolumeId = AC.VolumeId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMVolume by archChunk'
		GOTO CX_ERROR_EXIT
	END
	--Capture SILOed volumes
INSERT INTO #CCM_MMVolume
	SELECT MV.*
FROM CCM_SOURCE_MMVolume as MV inner join ( SELECT DISTINCT siloVolumeId FROM #CCM_archFileSiloVolume) as CSV
	ON MV.VolumeId = CSV.siloVolumeId
WHERE NOT EXISTS(select 1 from #CCM_MMVolume where volumeId = MV.VolumeId)
		AND MV.VolumeId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMVolume by archFileSILOVolume'
		GOTO CX_ERROR_EXIT
	END
	--Capture all volumes for optical media
INSERT INTO #CCM_MMVolume
	SELECT distinct MV.*
FROM CCM_SOURCE_MMVolume as MV inner join #CCM_MMVolume as CMV
	ON MV.MediaId = CMV.MediaId
	WHERE MV.RecordingFormatId <> 10001
AND NOT EXISTS(select 1 from #CCM_MMVolume where volumeId = MV.VolumeId)
	AND MV.VolumeId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMVolume by MediaId for optical media'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMMedia
INSERT INTO #CCM_MMMedia
	SELECT a.*
	from CCM_SOURCE_MMMedia a
WHERE EXISTS (SELECT 1 from #CCM_MMVolume b WHERE b.mediaId = a.mediaId)
	AND   a.MediaId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMMedia by MediaId'
		GOTO CX_ERROR_EXIT
	END
	--Capture mount paths used for silo restores
INSERT INTO #CCM_MMMedia
	SELECT a.*
	from	CCM_SOURCE_MMMedia a WITH (NOLOCK)
			INNER JOIN CCM_SOURCE_MMMediaSide b WITH (NOLOCK) ON a.MediaId = b.MediaId AND a.MediaId > 0
			INNER JOIN CCM_SOURCE_MMMountPath c WITH (NOLOCK) ON b.MediaSideId = c.MediaSideId
INNER JOIN #CCM_MMVolume d ON c.MountPathId = d.CurrMountPathId AND d.CurrMountPathId > 0
LEFT OUTER JOIN #CCM_MMMedia e ON a.MediaId = e.MediaId
	WHERE 	e.MediaId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMMedia by currMountPathId'
		GOTO CX_ERROR_EXIT
	END
	--Capture all mount paths(magnetic media) with in the library
INSERT INTO #CCM_MMMedia
	SELECT a.*
	from CCM_SOURCE_MMMedia a
WHERE  EXISTS (SELECT 1 from #CCM_MMMedia m WHERE m.LibraryId = a.LibraryId)
AND   NOT EXISTS (SELECT 1 FROM #CCM_MMMedia b WHERE b.MediaId = a.MediaId)
	AND   a.MediaTypeId = 10001
	AND   a.MediaId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMMedia by Library'
		GOTO CX_ERROR_EXIT
	END
	-- Capture dependent Mount Paths for deduped jobs
INSERT INTO #CCM_MMMedia
	SELECT DISTINCT	a.*
	FROM CCM_SOURCE_MMMedia a WITH (READUNCOMMITTED)
		INNER JOIN CCM_SOURCE_MMVolume MVSrc WITH (READUNCOMMITTED) ON MVSrc.MediaId = a.MediaId AND MVSrc.SIDBStoreId > 0
INNER JOIN (SELECT DISTINCT SIDBStoreId FROM #CCM_MMVolume) AS b ON MVSrc.SIDBStoreId = b.SIDBStoreId
WHERE NOT EXISTS (SELECT 1 FROM #CCM_MMMedia c WHERE a.MediaId = c.MediaId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMMedia by SidbStoreid'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMExportLocation
INSERT INTO #CCM_MMExportLocation
	SELECT a.*
	from CCM_SOURCE_MMExportLocation a
WHERE  EXISTS (SELECT 1 from #CCM_MMMedia WHERE ExportLocationId = a.ExportLocationId)
	AND   a.ExportLocationId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMExportLocation'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMMediaSide
INSERT INTO #CCM_MMMediaSide
	SELECT a.*
from CCM_SOURCE_MMMediaSide a INNER JOIN #CCM_MMMedia b ON  a.mediaId = b.mediaId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMMediaSide'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMMountPath
INSERT INTO #CCM_MMMountPath
	SELECT a.*
from CCM_SOURCE_MMMountPath a INNER JOIN #CCM_MMMediaSide b ON a.mediaSideId = b.mediaSideId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMMountPath'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO #CCM_MountPathMapping
	Select a.MountPathId, 0, '', '', '', a.MountPathName, -1 /*b.clientId*/, ''/*c.name*/, a.MountPathTypeId, 0, 0, ''
FROM   #CCM_MMMountPath a
    IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MountPathMapping'
		GOTO CX_ERROR_EXIT
	END
	/*
	 It is possible that the source mount path was shared across media agents via shared library.
In such cases, CommServ_Capture..CCM_MountPathMapping will have multiple records for the same mount path id,
	 each across a different source media agent id.
	  CCM will map this shared mount path from source into an ordinary mount path in destination commcell.
Hence, insert only one record per source mount path id into CommServ_Capture..CCM_MountPathMapping and the
	 the corresponding source media agent id will be the first media agent id (updated by the following
	 update statement)
	 */
UPDATE #CCM_MountPathMapping
	SET    SourceMediaAgentId = c.clientId, SourceMediaAgentName = d.name
FROM   #CCM_MountPathMapping a, #CCM_MMMountPath b, CCM_SOURCE_MMDrivePool c, CCM_SOURCE_APP_Client d
	WHERE  a.MountPathId  = b.MountPathId
	AND    b.MasterPoolId = c.MasterPoolId
	AND    c.clientId     = d.id
	AND    a.SourceMediaAgentId = -1
	AND    a.SourceMediaAgentName = ''
    IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MountPathMapping -- UPDATE -- SourceMediaAgentId,SourceMediaAgentName'
		GOTO CX_ERROR_EXIT
	END
UPDATE #CCM_MountPathMapping
	SET SourceDeviceId = A.DeviceId
FROM CCM_SOURCE_MMMountPathToStorageDevice A, #CCM_MountPathMapping B
	WHERE A.MountPathId = B.MountPathId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MountPathMapping -- SET SourceDeviceId'
		GOTO CX_ERROR_EXIT
	END
	/*Regular mount Paths get the source device id as 0 and source device name as N/A  */
UPDATE #CCM_MountPathMapping
	SET SourceDeviceName = A.AliasName
FROM CCM_SOURCE_MMDevice A, #CCM_MountPathMapping B
	WHERE A.DeviceId = B.SourceDeviceId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MountPathMapping -- SET SourceDeviceName'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMMountPathToStorageDevice
INSERT INTO #CCM_MMMountPathToStorageDevice
SELECT A.* FROM CCM_SOURCE_MMMountPathToStorageDevice A INNER JOIN #CCM_MMMountPath B ON A.MountPathId = B.MountPathId
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMMountPathToStorageDevice -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMDevice
INSERT INTO #CCM_MMDevice
SELECT A.* FROM CCM_SOURCE_MMDevice A INNER JOIN (SELECT DISTINCT DeviceId FROM #CCM_MMMountPathToStorageDevice) AS B ON A.DeviceId = B.DeviceId	AND A.DeviceId <> 0
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMDevice -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMDeviceController
	IF EXISTS(SELECT 1 FROM MMConfigs WHERE name = 'CCM_CONFIG_SCRUB_USER_CREDENTIALS_FOR_LIBRARIES' AND value = 1)
	BEGIN
INSERT 	INTO #CCM_MMDeviceController
		SELECT 	A.DeviceControllerId, A.ClientId, A.DeviceId, A.DeviceControllerActive, A.DeviceControllerEnabled, A.SNRVolumeId, A.UseCount,
				'', '', A.Folder, A.DeviceMounted, A.DeviceAccessible, A.VolumeRecoveryStatus, A.VolumeRecoveryTime,
				A.VolumeScsiReserved, A.DeviceAccessType, A.RMStatus, A.RMStatusUpdateTime, A.CredentialAssocId
		FROM	CCM_SOURCE_MMDeviceController A
				INNER JOIN (SELECT MIN(DeviceControllerId) DeviceControllerId, DeviceId FROM CCM_SOURCE_MMDeviceController GROUP BY DeviceId) AS B ON A.DeviceControllerId = B.DeviceControllerId
INNER JOIN #CCM_MMDevice C ON B.DeviceId = C.DeviceId
	END
	ELSE
	BEGIN
INSERT INTO #CCM_MMDeviceController
		SELECT A.*
		FROM	CCM_SOURCE_MMDeviceController A
				INNER JOIN (SELECT MIN(DeviceControllerId) DeviceControllerId, DeviceId FROM CCM_SOURCE_MMDeviceController GROUP BY DeviceId) AS B ON A.DeviceControllerId = B.DeviceControllerId
INNER JOIN #CCM_MMDevice C ON B.DeviceId = C.DeviceId
	END
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMDeviceController -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_CredentialAssoc
INSERT INTO #CCM_APP_CredentialAssoc
	SELECT A.*
	FROM CCM_SOURCE_APP_CredentialAssoc A
INNER JOIN #CCM_MMDeviceController B ON A.assocId = B.CredentialAssocId
LEFT OUTER JOIN #CCM_APP_CredentialAssoc C ON C.assocId = A.assocId
	WHERE C.assocId IS NULL
    IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_DB_APP_CredentialAssoc -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_Credentials
DECLARE @tailQuery VARCHAR(MAX)= ' A LEFT OUTER JOIN TEMPDB..#CCM_APP_Credentials B ON B.credentialId = A.credentialId
	WHERE B.credentialId IS NULL
AND EXISTS(SELECT 1 FROM #CCM_APP_CredentialAssoc C WHERE C.credentialId = A.credentialId) '
EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'APP_Credentials', 'TEMPDB..#CCM_APP_Credentials', '', @i_exportDBName, @tailQuery
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_APP_Credentials -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_DevicePathMapping
INSERT INTO #CCM_DevicePathMapping
SELECT DISTINCT A.DeviceId,A.AliasName,'',0,'','','' FROM #CCM_MMDevice A
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_DevicePathMapping -- INSERT'
		GOTO CX_ERROR_EXIT
	END
UPDATE #CCM_DevicePathMapping SET SourceDevicePath = DC.Folder
FROM #CCM_MMDeviceController DC
	WHERE SourceDeviceId = DC.DeviceId
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_DevicePathMapping -- UPDATE - SourceDevicePath'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMContainer
INSERT INTO #CCM_MMContainer
	SELECT a.*
	from CCM_SOURCE_MMContainer a INNER JOIN CCM_SOURCE_MMMedia b ON a.ContainerId = b.ContainerId
	WHERE a.ContainerId > 0
AND	  a.Flag & 1 <> 1
AND	  a.MediaType <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMContainer'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..MMCenteraInfo
INSERT INTO #CCM_MMCenteraInfo
	SELECT a.* from CCM_SOURCE_MMCenteraInfo a
	WHERE a.CenteraId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- MMCenteraInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..MMCenteraAccessNode
INSERT INTO #CCM_MMCenteraAccessNode
	SELECT a.* from CCM_SOURCE_MMCenteraAccessNode a
	WHERE a.CenteraId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- MMCenteraAccessNode'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_MMLibrary
	DECLARE @FromTable		varchar(1024)
	DECLARE @ToTable  		varchar(1024)
	DECLARE @ColumnListStr	varchar(max)
	DECLARE	@WhereClause	varchar(max)
	SET @FromTable = 'MMLibrary'
SET @ToTable = 'TEMPDB..#CCM_MMLibrary'
	SET @ColumnListStr = ''
SET @WhereClause = 'a INNER JOIN ( SELECT DISTINCT LibraryId FROM #CCM_MMMedia ) AS b ON a.LibraryId = b.LibraryId '
	EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, @FromTable, @ToTable, @ColumnListStr, @i_exportDBName, @WhereClause
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- MMLibrary'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_LibraryMapping
INSERT INTO #CCM_LibraryMapping
	SELECT a.LibraryId, a.AliasName, a.LibraryTypeId, 0, 0, ''
FROM TEMPDB..#CCM_MMLibrary a
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_LibraryMapping'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_MMMasterPool
INSERT INTO #CCM_MMMasterPool
	SELECT a.*
FROM CCM_SOURCE_MMMasterPool a INNER JOIN TEMPDB..#CCM_MMLibrary c ON a.LibraryId = c.LibraryId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- MMMasterPool'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CCM_DB_MMDrivePool
INSERT INTO #CCM_MMDrivePool
	SELECT a.*
FROM CCM_SOURCE_MMDrivePooL a INNER JOIN #CCM_MMMasterPool c ON a.MasterPoolId = c.MasterPoolId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- MMDrivePool'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_MMLibraryController
INSERT INTO #CCM_MMLibraryController
	SELECT a.*
FROM CCM_SOURCE_MMLibraryController a INNER JOIN TEMPDB..#CCM_MMLibrary c ON a.LibraryId = c.LibraryId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- MMLibraryController'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_MMEntityProp
INSERT INTO #CCM_MMEntityProp
	SELECT a.* FROM CCM_SOURCE_MMEntityProp a
	WHERE 	(
(a.EntityType = 1 AND EXISTS (SELECT 1 FROM #CCM_ArchGroup WHERE id = a.EntityId))
OR (a.EntityType = 2 AND EXISTS (SELECT 1 FROM #CCM_ArchGroupCopy WHERE id = a.EntityId ))
			)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- MMEntityProp'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_MMDiskHWInfo
	-- We can't select all the disks which are associted to these MAs because if the associted device may not part of the migration.
	-- So picking the disks which are associted to captured devices.
SET @tailQuery = ' A INNER JOIN #CCM_MMDevice B ON ( A.DeviceId = B.DeviceId OR A.DeviceId = 0)
INNER JOIN CCMEntitiesCaptured C ON C.EntityId = A.hostId AND C.EntityType = 11
			AND C.EntityCCId = 0 AND C.captureJobId = ' + CAST( @i_jobid AS VARCHAR(128)) + '
WHERE NOT EXISTS (SELECT 1 FROM TEMPDB..#CCM_MMDiskHWInfo WHERE DeviceId = A.DeviceId)'
EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'MMDiskHWInfo', 'TEMPDB..#CCM_MMDiskHWInfo', '', @i_exportDBName, @tailQuery
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMDiskHWInfo -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_MMSDSStoragePool
SET @tailQuery = ' A INNER JOIN TEMPDB..#CCM_MMLibrary B ON A.LibraryId = B.LibraryId
WHERE NOT EXISTS (SELECT 1 FROM TEMPDB..#CCM_MMSDSStoragePool WHERE StoragePoolId = A.StoragePoolId)'
EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'MMSDSStoragePool', 'TEMPDB..#CCM_MMSDSStoragePool', '', @i_exportDBName, @tailQuery
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMSDSStoragePool -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_MM_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_MM_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_MM_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_MM_to_XML'
GO

insert into GXDBVersions values(2, 'CCM_Capture_MM_to_XML',  '00010005007200050000', 'CCM_Capture_MM_to_XML', '00010005007200050000')
GO

