

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_MM_to_80.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_MM_to_80.sp,v 1.4.72.2 2018/03/20 00:51:13 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_MM_to_80 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_MM_to_80')
	drop procedure CCM_Capture_MM_to_80
IF EXISTS (select * from GxQscripts where name='CCM_Capture_MM_to_80')
	delete from GxQscripts where name = 'CCM_Capture_MM_to_80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_MM_to_80')
	delete from GXDBVersions where aliasname = 'CCM_Capture_MM_to_80'
GO
print '... Creating Procedure: CCM_Capture_MM_to_80'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_MM_to_80
  @i_clientId integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_MM.spb
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	/**************************************************************
	 * PrasadNara: 10:08 PM 9/3/2012
	 * We are calling this proc only when capturing last subclient in the dump.
	 * So making changes as required to capture all MM tables for all captured subclients in the dump.
	 **************************************************************/
	---------------------------------------------------------
	/*
	IF (@i_clientId <= 1)
	BEGIN
	    SET @errStr = 'ERROR: CCM_Capture_MM -- Invalid clientId'
		GOTO CX_ERROR_EXIT
	END
	*/
	---------------------------------------------------------
	-- CommServ_Capture..CCM_MMVolume
	-- Update made to capture all volume for a media
	-- that has some valid data. This is required for optical
	-- media
/*INSERT INTO CommServ_Capture_80..CCM_MMVolume
	SELECT a.* from CCM_SOURCE_MMVolume a
	WHERE a.mediaId IN
		(	SELECT DISTINCT MV.MediaId
FROM CommServ_Capture_80..CCM_ArchChunk as AC
				 LEFT OUTER JOIN
				 CCM_SOURCE_MMVolume as MV
			ON MV.VolumeId = AC.VolumeId)
AND a.VolumeId NOT IN (SELECT VolumeId FROM CommServ_Capture_80..CCM_MMVolume)
	AND a.VolumeId <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMVolume'
		GOTO CX_ERROR_EXIT
	END
	*/
	--Capture Volumes corresponding to the captured archChunks
INSERT INTO CommServ_Capture..CCM_MMVolume
	SELECT distinct
	MV.VolumeId, MV.VolumeName, MV.CreationTime, MV.VolumeFlags, MV.VolumeInitialized,
	MV.FlushBlockSizeKB, MV.NumberOfRestores, MV.NumberOfBackups, MV.NumberOfMounts, MV.NumberOfSoftErrors,
	MV.NumberOfHardErrors,	MV.LastRestoreTime, MV.LastBackupTime, MV.LogicalBytesMB, MV.PhysicalBytesMB,
	MV.NumberOfActiveFiles, MV.LastFile, MV.RecordingFormatId, MV.ExternalGUID, MV.OMLVersion,
	MV.VolumeState, MV.VolumeFullReason, MV.VolumeFullTime, MV.VolumeFullJobId, MV.origCCcommCellID,
	MV.origCCvolumeID, MV.MediaId, MV.MediaSideId, MV.Attributes, MV.MediaGroupId,
	MV.ReformatTime, MV.RMSpareStatus, MV.RMSpareStatusUpdateTime, MV.SIDBStoreId, MV.SiloStatus, MV.CurrMountPathId
FROM CCM_SOURCE_MMVolume as MV inner join CommServ_Capture..CCM_ArchChunk as AC
	ON MV.VolumeId = AC.VolumeId
WHERE NOT EXISTS(select volumeId from CommServ_Capture..CCM_MMVolume where volumeId = MV.VolumeId)
		AND MV.VolumeId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMVolume by archChunk'
		GOTO CX_ERROR_EXIT
	END
	--Capture SILOed volumes
INSERT INTO CommServ_Capture..CCM_MMVolume
	SELECT distinct
	MV.VolumeId, MV.VolumeName, MV.CreationTime, MV.VolumeFlags, MV.VolumeInitialized,
	MV.FlushBlockSizeKB, MV.NumberOfRestores, MV.NumberOfBackups, MV.NumberOfMounts, MV.NumberOfSoftErrors,
	MV.NumberOfHardErrors,	MV.LastRestoreTime, MV.LastBackupTime, MV.LogicalBytesMB, MV.PhysicalBytesMB,
	MV.NumberOfActiveFiles, MV.LastFile, MV.RecordingFormatId, MV.ExternalGUID, MV.OMLVersion,
	MV.VolumeState, MV.VolumeFullReason, MV.VolumeFullTime, MV.VolumeFullJobId, MV.origCCcommCellID,
	MV.origCCvolumeID, MV.MediaId, MV.MediaSideId, MV.Attributes, MV.MediaGroupId,
	MV.ReformatTime, MV.RMSpareStatus, MV.RMSpareStatusUpdateTime, MV.SIDBStoreId, MV.SiloStatus, MV.CurrMountPathId
FROM CCM_SOURCE_MMVolume as MV inner join CommServ_Capture..CCM_archFileSiloVolume as CSV
	ON MV.VolumeId = CSV.siloVolumeId
WHERE NOT EXISTS(select volumeId from CommServ_Capture..CCM_MMVolume where volumeId = MV.VolumeId)
		AND MV.VolumeId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMVolume by archFileSILOVolume'
		GOTO CX_ERROR_EXIT
	END
	--Capture all volumes for optical media
INSERT INTO CommServ_Capture..CCM_MMVolume
	SELECT distinct
	MV.VolumeId, MV.VolumeName, MV.CreationTime, MV.VolumeFlags, MV.VolumeInitialized,
	MV.FlushBlockSizeKB, MV.NumberOfRestores, MV.NumberOfBackups, MV.NumberOfMounts, MV.NumberOfSoftErrors,
	MV.NumberOfHardErrors,	MV.LastRestoreTime, MV.LastBackupTime, MV.LogicalBytesMB, MV.PhysicalBytesMB,
	MV.NumberOfActiveFiles, MV.LastFile, MV.RecordingFormatId, MV.ExternalGUID, MV.OMLVersion,
	MV.VolumeState, MV.VolumeFullReason, MV.VolumeFullTime, MV.VolumeFullJobId, MV.origCCcommCellID,
	MV.origCCvolumeID, MV.MediaId, MV.MediaSideId, MV.Attributes, MV.MediaGroupId,
	MV.ReformatTime, MV.RMSpareStatus, MV.RMSpareStatusUpdateTime, MV.SIDBStoreId, MV.SiloStatus, MV.CurrMountPathId
FROM CCM_SOURCE_MMVolume as MV inner join CommServ_Capture..CCM_MMVolume as CMV
	ON MV.MediaId = CMV.MediaId
	WHERE MV.RecordingFormatId <> 10001
AND NOT EXISTS(select volumeId from CommServ_Capture..CCM_MMVolume where volumeId = MV.VolumeId)
	AND MV.VolumeId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMVolume by MediaId for optical media'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMMedia
INSERT INTO CommServ_Capture..CCM_MMMedia
	SELECT
	a.MediaId, a.UniqueId, a.BarCode, a.MediaTypeId, a.CreationTime, a.NumberOfReUses, a.LastRestoreTime,
	a.LastBackupTime, a.LibraryId, a.SpareGroupId, a.LastExportTime, a.MediaLocation, a.ExternalGUID,
	a.MediaFlags, a.IsOMLWritten, a.MediaStatusReason, a.ExportLocationId, a.LastWriteLibraryId, a.Attributes,
	a.ContainerId, a.OverWriteJobId, a.origCCcommCellID, a.origCCmediaID, a.Descript, a.NumberOfSideOverwrites,
	a.ScheduleRunId, a.retentionFlags, a.retentionExpireTime, a.IsAged, a.IsInMediaGroup, a.PinMediaExpireTime,
	a.origSpareGroupId, a.RMSpareStatus, a.RMSpareStatusUpdateTime
	from CCM_SOURCE_MMMedia a
WHERE a.mediaId IN (SELECT distinct mediaId from CommServ_Capture..CCM_MMVolume)
AND   a.MediaId NOT IN (SELECT MediaId FROM CommServ_Capture..CCM_MMMedia)
	AND   a.MediaId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMMedia by MediaId'
		GOTO CX_ERROR_EXIT
	END
	--Capture mount paths used for silo restores
INSERT INTO CommServ_Capture..CCM_MMMedia
	SELECT
	a.MediaId, a.UniqueId, a.BarCode, a.MediaTypeId, a.CreationTime, a.NumberOfReUses, a.LastRestoreTime,
				 a.LastBackupTime, a.LibraryId, a.SpareGroupId, a.LastExportTime, a.MediaLocation, a.ExternalGUID,
				 a.MediaFlags, a.IsOMLWritten, a.MediaStatusReason, a.ExportLocationId, a.LastWriteLibraryId, a.Attributes,
				 a.ContainerId, a.OverWriteJobId, a.origCCcommCellID, a.origCCmediaID, a.Descript, a.NumberOfSideOverwrites,
				 a.ScheduleRunId, a.retentionFlags, a.retentionExpireTime, a.IsAged, a.IsInMediaGroup, a.PinMediaExpireTime,
				 a.origSpareGroupId, a.RMSpareStatus, a.RMSpareStatusUpdateTime
	from	CCM_SOURCE_MMMedia a
			INNER JOIN CCM_SOURCE_MMMediaSide b ON a.MediaId = b.MediaId AND a.MediaId > 0
			INNER JOIN CCM_SOURCE_MMMountPath c ON b.MediaSideId = c.MediaSideId
INNER JOIN CommServ_Capture..CCM_MMVolume d ON c.MountPathId = d.CurrMountPathId AND d.CurrMountPathId > 0
LEFT OUTER JOIN CommServ_Capture..CCM_MMMedia e ON a.MediaId = e.MediaId
	WHERE 	e.MediaId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMMedia by currMountPathId'
		GOTO CX_ERROR_EXIT
	END
	--Capture all mount paths(magnetic media) with in the library
INSERT INTO CommServ_Capture..CCM_MMMedia
	SELECT
	a.MediaId, a.UniqueId, a.BarCode, a.MediaTypeId, a.CreationTime, a.NumberOfReUses, a.LastRestoreTime,
	a.LastBackupTime, a.LibraryId, a.SpareGroupId, a.LastExportTime, a.MediaLocation, a.ExternalGUID,
	a.MediaFlags, a.IsOMLWritten, a.MediaStatusReason, a.ExportLocationId, a.LastWriteLibraryId, a.Attributes,
	a.ContainerId, a.OverWriteJobId, a.origCCcommCellID, a.origCCmediaID, a.Descript, a.NumberOfSideOverwrites,
	a.ScheduleRunId, a.retentionFlags, a.retentionExpireTime, a.IsAged, a.IsInMediaGroup, a.PinMediaExpireTime,
	a.origSpareGroupId, a.RMSpareStatus, a.RMSpareStatusUpdateTime
	from CCM_SOURCE_MMMedia a
WHERE a.LibraryId IN (SELECT LibraryId from CommServ_Capture..CCM_MMMedia)
AND   a.MediaId NOT IN (SELECT MediaId FROM CommServ_Capture..CCM_MMMedia)
	AND   a.MediaTypeId = 10001
	AND   a.MediaId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMMedia by Library'
		GOTO CX_ERROR_EXIT
	END
	-- Capture dependent Mount Paths for deduped jobs
INSERT INTO CommServ_Capture..CCM_MMMedia
	SELECT DISTINCT
	a.MediaId, a.UniqueId, a.BarCode, a.MediaTypeId, a.CreationTime, a.NumberOfReUses, a.LastRestoreTime,
	a.LastBackupTime, a.LibraryId, a.SpareGroupId, a.LastExportTime, a.MediaLocation, a.ExternalGUID,
	a.MediaFlags, a.IsOMLWritten, a.MediaStatusReason, a.ExportLocationId, a.LastWriteLibraryId, a.Attributes,
	a.ContainerId, a.OverWriteJobId, a.origCCcommCellID, a.origCCmediaID, a.Descript, a.NumberOfSideOverwrites,
	a.ScheduleRunId, a.retentionFlags, a.retentionExpireTime, a.IsAged, a.IsInMediaGroup, a.PinMediaExpireTime,
	a.origSpareGroupId, a.RMSpareStatus, a.RMSpareStatusUpdateTime
	FROM CCM_SOURCE_MMMedia a WITH (READUNCOMMITTED)
		INNER JOIN CCM_SOURCE_MMVolume MVSrc WITH (READUNCOMMITTED) ON MVSrc.MediaId = a.MediaId AND MVSrc.SIDBStoreId > 0
INNER JOIN (SELECT DISTINCT SIDBStoreId FROM CommServ_Capture..CCM_MMVolume) AS b ON MVSrc.SIDBStoreId = b.SIDBStoreId
LEFT OUTER JOIN CommServ_Capture..CCM_MMMedia c ON a.MediaId = c.MediaId
	WHERE c.MediaId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMMedia by SidbStoreid'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMExportLocation
INSERT INTO CommServ_Capture..CCM_MMExportLocation
	SELECT
	a.ExportLocationId, a.ExportLocation, a.Type, a.Descript
	from CCM_SOURCE_MMExportLocation a
WHERE a.ExportLocationId IN (SELECT DISTINCT ExportLocationId from CommServ_Capture..CCM_MMMedia)
AND   a.ExportLocationId NOT IN (SELECT ExportLocationId FROM CommServ_Capture..CCM_MMExportLocation)
	AND   a.ExportLocationId > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMExportLocation'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMMediaSide
INSERT INTO CommServ_Capture..CCM_MMMediaSide
	SELECT
	a.MediaSideId, a.MediaId, a.SideName, a.MediaSideFlags, a.NumberOfRestores, a.NumberOfBackups,
			 	 a.NumberOfMounts, a.NumberOfSoftErrors, a.NumberOfHardErrors, a.NumberOfReUses, a.LastRestoreTime,
			 	 a.LastBackupTime, a.TotalSpaceMB, a.FreeBytesMB, a.LogicalBytesMB, a.PhysicalBytesMB, a.IsOMLValid,
			 	 a.FailureReason, a.ExternalGUID, a.IsOMLWritten, a.isErasable
	from CCM_SOURCE_MMMediaSide a
WHERE a.mediaId IN (SELECT mediaId from CommServ_Capture..CCM_MMMedia)
AND   a.MediaSideId NOT IN (SELECT MediaSideId FROM CommServ_Capture..CCM_MMMediaSide)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMMediaSide'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMMountPath
INSERT INTO CommServ_Capture..CCM_MMMountPath
	SELECT
			a.MountPathId,a.MountPathName,a.MediaSideId,a.UserName,a.UserPassword,a.IsEnabled,
			a.NumberOfWriters,a.MaxConcurrentWriters,a.CurrentFileMarker,a.IsOffline,a.OfflineReason,
			CASE WHEN a.MountPathTypeId = 4 THEN 0 ELSE a.MountPathTypeId END,
			a.OffLineTimeStamp,a.origCCcommCellID,a.origCCmediaSideID,a.MaxDataToWriteMB,a.MagneticSpaceRsrvInMB,
			a.Attribute,a.MasterPoolId,a.LibraryId,a.RMStatus,a.RMStatusUpdateTime,a.OrigCCMountPathId,a.MagneticChunkFileIncrSizeMB,a.MountPathOfflineReasonEventId
	from CCM_SOURCE_MMMountPath a
WHERE a.mediaSideId IN (SELECT mediaSideId from CommServ_Capture..CCM_MMMediaSide)
AND   a.MountPathId NOT IN (SELECT MountPathId FROM CommServ_Capture..CCM_MMMountPath)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMMountPath'
		GOTO CX_ERROR_EXIT
	END
UPDATE CommServ_Capture..CCM_MMMountPath set mountpathname = d.Folder +
	case when CHARINDEX('\',d.folder,1) <> 0 then '\' else '/' end
	+ a.MountPathName
from CommServ_Capture..CCM_MMMountPath a inner join MMMountPath b ON a.mountpathid = b.mountpathid
	inner join MMMountPathToStorageDevice c on b.mountpathid = c.mountpathid
	cross apply (select top 1 deviceid, folder from MMDeviceController where DeviceId = c.DeviceId) d
	where charindex('/',a.MountPathName,1) = 0 AND charindex('\',a.MountPathName,1) = 0 and b.MountPathTypeId = 4
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- UPDATE MountPathName for StaticShared CCM_MMMountPath'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMContainer
INSERT INTO CommServ_Capture..CCM_MMContainer
	SELECT
	a.ContainerId, a.ContainerName, a.Flag, a.Capacity, a.MediaType, a.Descript, a.CreationTime, a.IsEmpty,
				 a.ContainerEmptyTime, a.TrackingId
	from CCM_SOURCE_MMContainer a INNER JOIN CCM_SOURCE_MMMedia b ON a.ContainerId = b.ContainerId
	WHERE a.ContainerId > 0
AND	  a.Flag & 1 <> 1
AND	  a.MediaType <> 0
AND   a.ContainerId NOT IN (SELECT ContainerId FROM CommServ_Capture..CCM_MMContainer)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- CCM_MMContainer'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..MMCenteraInfo
INSERT INTO CommServ_Capture..CCM_MMCenteraInfo
	SELECT a.* from CCM_SOURCE_MMCenteraInfo a
	WHERE a.CenteraId > 0
AND   a.CenteraId NOT IN (SELECT CenteraId FROM CommServ_Capture..CCM_MMCenteraInfo)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- MMCenteraInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..MMCenteraAccessNode
INSERT INTO CommServ_Capture..CCM_MMCenteraAccessNode
	SELECT a.* from CCM_SOURCE_MMCenteraAccessNode a
	WHERE a.CenteraId > 0
AND   a.AccessNodeId NOT IN (SELECT AccessNodeId FROM CommServ_Capture..CCM_MMCenteraAccessNode)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_MM -- MMCenteraAccessNode'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_MM_to_80')
	delete from GxQscripts where name = 'CCM_Capture_MM_to_80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_MM_to_80')
	delete from GXDBVersions where aliasname = 'CCM_Capture_MM_to_80'
GO

insert into GXDBVersions values(2, 'CCM_Capture_MM_to_80',  '00010004007200020000', 'CCM_Capture_MM_to_80', '00010004007200020000')
GO

