

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_JOB_to_XML.sp] ---------- 

--  +===================================================================================================+
--  | Stored Procedure: Capture client application data to temp db tables which will be converted to xml
--  +===================================================================================================+
-- $Id: CCM_Capture_JOB_to_XML.sp,v 1.5.112.4 2018/12/27 16:33:28 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_JOB_to_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_JOB_to_XML <<<'
	drop procedure CCM_Capture_JOB_to_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_JOB_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_JOB_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_JOB_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_JOB_to_XML'
GO
print '... Creating Procedure: CCM_Capture_JOB_to_XML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_JOB_to_XML
  @ccmParamFlags integer,
  @i_jobId integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_JOB.spb
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	IF OBJECT_ID('tempdb.dbo.#CCM_TEMP_JOB') IS NOT NULL DROP TABLE #CCM_TEMP_JOB
	CREATE TABLE #CCM_TEMP_JOB (jobid int, commcellId int, primary key (jobid, commcellId))
	-- Populate temp table variable #CCM_TEMP_JOB
	INSERT INTO #CCM_TEMP_JOB
	SELECT distinct a.jobId , a.commcellId
FROM #CCM_ArchFile a WITH (NOLOCK)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_TEMP_JOB'
		GOTO CX_ERROR_EXIT
	END
	-- Insert SILO Jobs
	INSERT INTO #CCM_TEMP_JOB
	SELECT distinct A.jobId, A.commCellId
FROM #CCM_ArchFile A WITH (NOLOCK) LEFT OUTER JOIN #CCM_JMJobStats B WITH (NOLOCK)
	ON A.jobId = B.jobId AND A.commCellId = B.commCellId
	WHERE EXISTS (SELECT 1 FROM CCM_SOURCE_App_Application c WITH (NOLOCK)
LEFT OUTER JOIN #CCM_App_Application d WITH (NOLOCK) ON c.id = d.id
						WHERE c.clientId = 2 and d.id IS NULL AND c.appTypeId <> 1000 AND c.id = A.appId)
						AND B.jobId is null
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_TEMP_JOB -- Insert SILO Jobs'
		GOTO CX_ERROR_EXIT
	END
	-- Capture Snap backup copy jobs
	INSERT INTO #CCM_TEMP_JOB
	SELECT DISTINCT a.jobId, a.commCellId
FROM CCM_SOURCE_JMBkpStats a WITH (NOLOCK), #CCM_App_Application b WITH (NOLOCK)
	WHERE a.opType= 60		   -- enum CVOpType- SNAPTOTAPE = 60
	AND a.appId = b.id
	AND b.appTypeId <> 1000
	AND a.status not in (2,4,9)  -- Failed / Killed / Failed To Start jobs
	AND NOT EXISTS(SELECT 1 FROM #CCM_TEMP_JOB
			WHERE jobid = a.jobId and commcellId = a.commCellId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_TEMP_JOB -Insert SnapBackup Copy Jobs'
		GOTO CX_ERROR_EXIT
	END
	-- Capture Snap backup copy - work flow jobs for the snap backupcopy jobs
	INSERT INTO #CCM_TEMP_JOB
	SELECT DISTINCT a.parentJobId, a.commCellId FROM CCM_SOURCE_JMJobDataLink a WITH (NOLOCK), #CCM_TEMP_JOB b
	WHERE a.childJobId = b.jobid
	AND a.commCellId = b.commcellId
	AND a.linkType = 4 -- enum CVJobDataLinkType - LINK_TYPE_SNAPTAPEWORKFLOW_UNIT	=	4
	AND NOT EXISTS(SELECT 1 FROM #CCM_TEMP_JOB
		WHERE jobid = a.parentJobId and commcellId = a.commCellId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_TEMP_JOB -Insert SnapBackup Copy  WorkFlow Jobs'
		GOTO CX_ERROR_EXIT
	END
	-- Some Jobs might be pruned and still have related jobs in JMJobDataLink table, which will be captured.
	DECLARE @JobCount int
	DECLARE @AdditionJobExists int
	SELECT @jobCount = COUNT(1) FROM #CCM_TEMP_JOB
	SET @AdditionJobExists = @jobCount
	WHILE (1 = 1)
	BEGIN
		INSERT	INTO #CCM_TEMP_JOB
		SELECT	DISTINCT b.childJobId, b.CommcellId
		FROM		#CCM_TEMP_JOB a
						INNER JOIN CCM_SOURCE_JMJobDataLink b WITH (NOLOCK) on a.JobId = b.parentJobId AND a.CommcellId = b.CommcellId
						LEFT JOIN #CCM_TEMP_JOB c on c.JobId = b.childJobId AND a.CommcellId = c.CommcellId
		WHERE		c.JobId IS NULL
		INSERT	INTO #CCM_TEMP_JOB
		SELECT	DISTINCT b.parentJobId, b.CommcellId
		FROM		#CCM_TEMP_JOB a
						INNER JOIN CCM_SOURCE_JMJobDataLink b WITH (NOLOCK) on a.JobId = b.childJobId AND a.CommcellId = b.CommcellId
						LEFT JOIN #CCM_TEMP_JOB c on c.JobId = b.parentJobId AND a.CommcellId = c.CommcellId
		WHERE		c.JobId IS NULL
		SELECT @jobCount = COUNT(1) FROM #CCM_TEMP_JOB
		IF @AdditionJobExists = @jobCount
		BEGIN
			SET @AdditionJobExists = 0
			BREAK
		END
		ELSE
		BEGIN
			SET @AdditionJobExists = @jobCount
			CONTINUE
		END
	END
	--Make sure multiple rows for same jobs are not captured
	DELETE FROM #CCM_TEMP_JOB
FROM #CCM_TEMP_JOB a INNER JOIN #CCM_JMJobStats b WITH (NOLOCK) ON a.jobid = b.jobId AND a.commcellId = b.commCellId
	--Skip jobs having no archive files
	DELETE FROM #CCM_TEMP_JOB
	FROM 	#CCM_TEMP_JOB a LEFT OUTER JOIN CCM_SOURCE_ArchFile b WITH (NOLOCK)
	ON a.jobId = b.jobId AND a.commcellId = b.commcellId
	WHERE 	b.jobId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Job -- CCM_TEMP_JOB -- DELETE jobs having no archfiles'
		GOTO CX_ERROR_EXIT
	END
	-- Capture VSA VM admin jobs
	INSERT INTO #CCM_TEMP_JOB
	SELECT DISTINCT a.parentJobId, a.commCellId FROM CCM_SOURCE_JMJobDataLink a WITH (NOLOCK), #CCM_TEMP_JOB b
	WHERE a.childJobId = b.jobid
	AND a.commCellId = b.commcellId
	AND a.linkType = 7 -- enum CVJobDataLinkType - LINK_TYPE_FOR_VSA_V2_PARENT_CHILD = 7
	AND NOT EXISTS(SELECT 1 FROM #CCM_TEMP_JOB
		WHERE jobid = a.parentJobId and commcellId = a.commCellId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_TEMP_JOB - Insert VSA VM admin jobs'
		GOTO CX_ERROR_EXIT
	END
	--Skip capturing data belongs to other migrated commcells for ROBO job
	DECLARE @captureOnlyLocalData integer = 0
	SET @captureOnlyLocalData = ISNULL((SELECT value from MMConfigs WITH (NOLOCK) where name = 'CCM_CONFIG_CAPTURE_ONLY_LOCAL_DATA_FOR_GRC'),1)
	IF ((@ccmParamFlags & 1) = 1 AND @captureOnlyLocalData = 1)
	BEGIN
		DELETE FROM  #CCM_TEMP_JOB
		WHERE CommCellId NOT IN (0,2)
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_Job -- CCM_TEMP_JOB -- DELETE other commcells jobs'
			GOTO CX_ERROR_EXIT
		END
	END
	-- CommServ_Capture..CCM_JMJobStats
INSERT INTO #CCM_JMJobStats
	SELECT a.jobId, a.status, a.opType, a.commCellId, a.jobCategory, a.jobDescription, xmlJobInfo, a.subOpType, a.foreignToken
	FROM #CCM_TEMP_JOB b INNER JOIN CCM_SOURCE_JMJobStats a WITH (NOLOCK) ON a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMJobStats'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMBkpStats
INSERT INTO #CCM_JMBkpStats
	SELECT a.*
	FROM #CCM_TEMP_JOB b INNER JOIN CCM_SOURCE_JMBkpStats a WITH (NOLOCK) ON a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMBkpStats'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMBkpAtmptStats
INSERT INTO #CCM_JMBkpAtmptStats
	SELECT a.*
	FROM #CCM_TEMP_JOB b INNER JOIN CCM_SOURCE_JMBkpAtmptStats a WITH (NOLOCK) ON a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMBkpAtmptStats'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMJobDataStats
INSERT INTO #CCM_JMJobDataStats
	SELECT DISTINCT a.*
	FROM #CCM_TEMP_JOB b INNER JOIN CCM_SOURCE_JMJobDataStats a WITH (NOLOCK) ON a.jobId = b.jobId AND a.commCellId = b.commCellId
INNER JOIN #CCM_ArchFileCopy c WITH (NOLOCK) ON c.archCopyId = a.archGrpCopyId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMJobDataStats'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMAdminJobStatsTable
INSERT INTO #CCM_JMAdminJobStatsTable
	SELECT a.*
	FROM #CCM_TEMP_JOB b INNER JOIN CCM_SOURCE_JMAdminJobStatsTable a WITH (NOLOCK) ON a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMAdminJobStatsTable'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMAdminJobAttemptStatsTable
INSERT INTO #CCM_JMAdminJobAttemptStatsTable
	SELECT a.*
	FROM  #CCM_TEMP_JOB b INNER JOIN CCM_SOURCE_JMAdminJobAttemptStatsTable a WITH (NOLOCK) ON a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMAdminJobAttemptStatsTable'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMJobOptions
INSERT INTO #CCM_JMJobOptions
	SELECT a.*
	FROM #CCM_TEMP_JOB b INNER JOIN CCM_SOURCE_JMJobOptions a WITH (NOLOCK) ON a.jobId = b.jobId AND a.commCellId = b.commCellId
AND a.attributeId NOT IN ( 27, 28 )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMJobOptions'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMJobDataLink
INSERT INTO #CCM_JMJobDataLink
	SELECT DISTINCT a.*
	FROM #CCM_TEMP_JOB b INNER JOIN CCM_SOURCE_JMJobDataLink a WITH (NOLOCK) ON a.commCellId = b.commCellId AND (a.parentJobId = b.jobId or a.childJobId = b.jobId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMJobDataLink'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMOracleRACClientsUsed
INSERT INTO #CCM_JMOracleRACClientsUsed
	SELECT a.* FROM CCM_SOURCE_JMOracleRACClientsUsed a WITH (NOLOCK), #CCM_TEMP_JOB b
	WHERE a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMOracleRACClientsUsed'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_archCheckHistory
INSERT INTO #CCM_ArchCheckHistory
	SELECT a.*
	FROM CCM_SOURCE_archCheckHistory a WITH (NOLOCK), #CCM_TEMP_JOB b
	WHERE a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_archCheckHistory'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMJobSnapshotStats
INSERT INTO #CCM_JMJobSnapshotStats
	SELECT a.*
	FROM CCM_SOURCE_JMJobSnapshotStats a WITH (NOLOCK), #CCM_TEMP_JOB b
	WHERE a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Job -- CCM_JMJobSnapshotStats'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_EvMsg
INSERT INTO #CCM_EvMsg
	SELECT a.*
	FROM #CCM_TEMP_JOB b INNER JOIN CCM_SOURCE_EvMsg a WITH (NOLOCK) ON a.jobId_l = b.jobId AND a.commCellId = b.commCellId
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Job -- CCM_EvMsg'
		GOTO CX_ERROR_EXIT
	END
	------------------------------------------------------
	-- CommServ_Capture..CCM_JMFailureReasonMsg
INSERT INTO #CCM_JMFailureReasonMsg
	SELECT a.*
	FROM CCM_SOURCE_JMFailureReasonMsg a WITH (NOLOCK) INNER JOIN #CCM_TEMP_JOB b ON a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Job -- CCM_JMFailureReasonMsg'
		GOTO CX_ERROR_EXIT
	END
	/*
	 It is possible to have dependent jobs where either of the parent job or child job
will not have archive files, as they might be aged. In such cases, CommServ_Capture..CCM_JMJobStats
will not have an entry for the job not having any archive files but CommServ_Capture..CCM_JMJobDataLink
	 will still have the entry for the dependency.
	   The fix is to ignore such dependency and the jobs will be migrated as standalone, non-dependent jobs.
	 */
	DECLARE @toDeleteDependentJobs TABLE(parentJobId int, childJobId int, commCellId int)
	INSERT INTO @toDeleteDependentJobs
	SELECT a.parentJobId, a.childJobId, a.commCellId
FROM   #CCM_JMJobDataLink a WITH (NOLOCK)
	WHERE NOT EXISTS(SELECT 1
FROM #CCM_JMJobStats b WITH (NOLOCK)
			WHERE b.jobId = a.parentJobId
			AND   b.commCellId = a.commCellId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- parentJobs'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO @toDeleteDependentJobs
	SELECT a.parentJobId, a.childJobId, a.commCellId
FROM   #CCM_JMJobDataLink a WITH (NOLOCK)
	WHERE NOT EXISTS(SELECT 1
FROM #CCM_JMJobStats b WITH (NOLOCK)
			WHERE b.jobId = a.childJobId
			AND   b.commCellId = a.commCellId)
	AND  NOT EXISTS(SELECT 1
			FROM   @toDeleteDependentJobs c
			WHERE  c.parentJobId = a.parentJobId
			AND    c.childJobId  = a.childJobId
			AND    c.commCellId  = a.commCellId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- childJobs'
		GOTO CX_ERROR_EXIT
	END
DELETE FROM #CCM_JMJobDataLink
FROM   #CCM_JMJobDataLink a WITH (NOLOCK), @toDeleteDependentJobs b
	WHERE  a.parentJobId = b.parentJobId
	AND    a.childJobId  = b.childJobId
	AND    a.commCellId  = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- DELETE -- CCM_JMJobDataLink -- dependentJobs without archive files'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_archFailedKilledJobInfo
INSERT INTO #CCM_archFailedKilledJobInfo
	SELECT a.* FROM CCM_SOURCE_archFailedKilledJobInfo a WITH (NOLOCK)
INNER JOIN #CCM_App_Application c WITH (NOLOCK) ON a.appId = c.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- INSERT -- CCM_archFailedKilledJobInfo'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------
	/*
	 * For robo capture list of all jobs that got aged, list of all jobs that got status 1000
	 * and list of all jobs that went from 100->101 (recopy case)
	 */
	IF (@ccmParamFlags & 1) = 1
	BEGIN
		DECLARE @endTrackingId bigint = ISNULL((SELECT trackingId FROM GRC_SubclientTrackingInfo WHERE subclientId = 0 AND jobId = @i_jobId AND commCellId = 2), 0)
IF NOT EXISTS(SELECT 1 FROM tempdb.sys.indexes WHERE name = 'CCM_DB_JMJOBDATASTATS_IDX')
CREATE INDEX CCM_DB_JMJOBDATASTATS_IDX ON #CCM_JMJobDataStats (jobId, commCellId, archGrpCopyId, dataType, appId)
		IF OBJECT_ID('tempdb.dbo.#GRCJMJobDataStatsTracking') IS NOT NULL DROP TABLE #GRCJMJobDataStatsTracking
		CREATE TABLE #GRCJMJobDataStatsTracking
		(
			trackingId		BIGINT,
			PRIMARY KEY (trackingId)
		)
		-- Capture Aged and Deleted status changes in last dump
		-- CommServ_Capture..CCM_GRCJMJobDataStatsTracking
		IF (
SELECT COUNT(1) FROM CCMCaptureEntities WHERE  Type = 7
			AND Status = 0
			AND JobId =
				(
					@i_jobId
				)
		) = 1
		BEGIN
			DECLARE @startTrackingId bigint = ISNULL((SELECT min(trackingId) FROM GRC_SubclientTrackingInfo WHERE subclientId > 0 AND jobId = @i_jobId AND commCellId = 2), 0)
			INSERT INTO #GRCJMJobDataStatsTracking
			SELECT MAX(TrackingId)
			FROM CCM_SOURCE_GRCJMJobDataStatsTracking
WHERE StatusChange IN(4, 5)
				AND TrackingId > @startTrackingId
				AND TrackingId <= @endTrackingId
			GROUP BY CommCellId, JobId, CopyId, DataType
INSERT INTO #CCM_GRCJMJobDataStatsTracking
			SELECT A.*
			FROM CCM_SOURCE_GRCJMJobDataStatsTracking A INNER JOIN  #GRCJMJobDataStatsTracking B ON A.TrackingId = B.TrackingId
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_GRCJMJobDataStatsTracking -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			DELETE #GRCJMJobDataStatsTracking
		END
		--Capture recopy status in the same dump where job got captured.
		--We should mark the job as recopy before merging the job on GRC
		INSERT INTO #GRCJMJobDataStatsTracking
		SELECT MAX(JT.TrackingId)
FROM CCM_SOURCE_GRCJMJobDataStatsTracking JT, #CCM_JMJobDataStats JS, GRC_SubclientTrackingInfo ST
		WHERE JS.jobId = JT.jobId AND JS.commCellId = JT.commCellId AND JS.archGrpCopyId = JT.copyId AND JS.dataType = JT.dataType
			AND JS.appId = ST.subclientId AND ST.jobId = @i_jobId AND ST.commCellId = 2
			AND JT.TrackingId > ST.TrackingId
			AND JT.TrackingId <= @endTrackingId
AND JT.StatusChange IN(2, 4, 5)
		GROUP BY JT.CommCellId, JT.JobId, JT.CopyId, JT.DataType
INSERT INTO #CCM_GRCJMJobDataStatsTracking
		SELECT A.*
		FROM CCM_SOURCE_GRCJMJobDataStatsTracking A INNER JOIN  #GRCJMJobDataStatsTracking B
			ON A.TrackingId = B.TrackingId
WHERE A.StatusChange = 2
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_GRCJMJobDataStatsTracking -- INSERT Recopy'
			GOTO CX_ERROR_EXIT
		END
	END
	------------------------------------------------------
	-- CommServ_Capture..CCM_JMFailureReasonMsgParam
INSERT INTO #CCM_JMFailureReasonMsgParam
	SELECT a.*
FROM CCM_SOURCE_JMFailureReasonMsgParam a WITH (NOLOCK) INNER JOIN #CCM_JMFailureReasonMsg b WITH (NOLOCK) ON a.msgId = b.Id
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Job -- CCM_JMFailureReasonMsgParam'
		GOTO CX_ERROR_EXIT
	END
	------------------------------------------------------
	-- CommServ_Capture..CCM_EvParam
INSERT INTO #CCM_EvParam
	SELECT  a.*
FROM #CCM_EvMsg b WITH (NOLOCK) INNER JOIN CCM_SOURCE_EvParam a WITH (NOLOCK) ON a.evMsgId = b.Id AND a.commCellId = b.commCellId
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Job -- CCM_EvParam'
		GOTO CX_ERROR_EXIT
	END
	------------------------------------------------------
	-- CommServ_Capture..CCM_APP_VMProp
IF EXISTS (SELECT 1 FROM CCM_SOURCE_APP_VMProp A WITH (NOLOCK) INNER JOIN #CCM_JMBkpStats B WITH (NOLOCK) ON A.jobid = B.jobid AND A.commCellId = B.commCellId)
	BEGIN
		DECLARE @clientId INT
INSERT INTO #CCM_APP_VMProp
		SELECT A.*
FROM CCM_SOURCE_APP_VMProp A WITH (NOLOCK) INNER JOIN #CCM_JMBkpStats B WITH (NOLOCK) ON A.jobid = B.jobid AND A.commCellId = B.commCellId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_APP_VMProp'
			GOTO CX_ERROR_EXIT
		END
		DECLARE @errCode INT
		DECLARE VMClientList CURSOR LOCAL FORWARD_ONLY FOR
		SELECT DISTINCT VMClientId
FROM #CCM_APP_VMProp A WITH (NOLOCK) LEFT OUTER JOIN #CCM_APP_Client B WITH (NOLOCK) ON A.VMclientId = B.id
		WHERE B.id IS NULL
		OPEN VMClientList
		FETCH NEXT FROM VMClientList
		INTO @clientId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			EXEC @errCode = CCM_Capture_Client_to_XML @clientId, @i_isExportFromLinkedServer, @i_exportDBName
			IF	@@ERROR > 0 OR @errCode <> 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_JOB -- Failed to capture VM client '+CAST(@clientId AS NVARCHAR(100))
				GOTO CX_ERROR_EXIT
			END
		FETCH NEXT FROM VMClientList
		INTO @clientId
		END
		CLOSE VMClientList
		DEALLOCATE VMClientList
	END
	-------------------------------------------------------
	-- CommServ_Capture..CCM_JMQinetixUpdateStatus
	DECLARE @tailQuery VARCHAR(MAX)
	SET @tailQuery = ' A INNER JOIN ' +
' #CCM_JMBkpStats B WITH (NOLOCK) '
	+' ON A.jobId = B.jobId AND A.commCellId = B.commCellId '
	EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'JMQinetixUpdateStatus', 'tempdb.dbo.#CCM_JMQinetixUpdateStatus', '', @i_exportDBName, @tailQuery
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Job -- CCM_JMQinetixUpdateStatus'
		GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------
	DROP TABLE #CCM_TEMP_JOB
    IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- DROP -- CCM_TEMP_JOB'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_JOB_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_JOB_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_JOB_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_JOB_to_XML'
GO

insert into GXDBVersions values(2, 'CCM_Capture_JOB_to_XML',  '00010005011200040000', 'CCM_Capture_JOB_to_XML', '00010005011200040000')
GO

