

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_JOB_to_80.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_JOB_to_80.sp,v 1.2.208.2 2018/03/20 00:39:13 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_JOB_to_80 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_JOB_to_80')
	drop procedure CCM_Capture_JOB_to_80
IF EXISTS (select * from GxQscripts where name='CCM_Capture_JOB_to_80')
	delete from GxQscripts where name = 'CCM_Capture_JOB_to_80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_JOB_to_80')
	delete from GXDBVersions where aliasname = 'CCM_Capture_JOB_to_80'
GO
print '... Creating Procedure: CCM_Capture_JOB_to_80'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_JOB_to_80
  @i_subClientId integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_JOB.spb
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	/**************************************************************
	 * PrasadNara: 10:08 PM 9/3/2012
	 * We are calling this proc only when capturing last subclient in the dump.
	 * So making changes as required to capture all JM tables for all captured subclients in the dump.
	 **************************************************************/
	---------------------------------------------------------
	/*
	IF (@i_subClientId < 0)
	BEGIN
	    SET @errStr = 'ERROR: CCM_Capture_JOB -- Invalid subclient'
		GOTO CX_ERROR_EXIT
	END
	*/
	---------------------------------------------------------
	IF OBJECT_ID('tempdb.dbo.#CCM_TEMP_JOB') IS NOT NULL DROP TABLE #CCM_TEMP_JOB
	CREATE TABLE #CCM_TEMP_JOB (jobid int, commcellId int, primary key (jobid, commcellId))
	-- Populate temp table variable #CCM_TEMP_JOB
	INSERT INTO #CCM_TEMP_JOB
	SELECT distinct a.jobId as jobid, a.commcellId
FROM CommServ_Capture..CCM_ArchFile a, CommServ_Capture..CCM_App_Application b
	WHERE a.appId = b.id AND b.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_TEMP_JOB'
		GOTO CX_ERROR_EXIT
	END
	-- Some Jobs might be pruned and still have related jobs in JMJobDataLink table, which will be captured.
	DECLARE @JobCount int
	DECLARE @AdditionJobExists int
	SELECT @jobCount = COUNT(*) FROM #CCM_TEMP_JOB
	SET @AdditionJobExists = @jobCount
	WHILE (1 = 1)
	BEGIN
		INSERT	INTO #CCM_TEMP_JOB
		SELECT	DISTINCT b.childJobId, b.CommcellId
		FROM		#CCM_TEMP_JOB a
						INNER JOIN CCM_SOURCE_JMJobDataLink b on a.JobId = b.parentJobId AND a.CommcellId = b.CommcellId
						LEFT JOIN #CCM_TEMP_JOB c on c.JobId = b.childJobId AND a.CommcellId = c.CommcellId
		WHERE		c.JobId IS NULL
		INSERT	INTO #CCM_TEMP_JOB
		SELECT	DISTINCT b.parentJobId, b.CommcellId
		FROM		#CCM_TEMP_JOB a
						INNER JOIN CCM_SOURCE_JMJobDataLink b on a.JobId = b.childJobId AND a.CommcellId = b.CommcellId
						LEFT JOIN #CCM_TEMP_JOB c on c.JobId = b.parentJobId AND a.CommcellId = c.CommcellId
		WHERE		c.JobId IS NULL
		SELECT @jobCount = COUNT(*) FROM #CCM_TEMP_JOB
		IF @AdditionJobExists = @jobCount
		BEGIN
			SET @AdditionJobExists = 0
			BREAK
		END
		ELSE
		BEGIN
			SET @AdditionJobExists = @jobCount
			CONTINUE
		END
	END
	--Make sure multiple rows for same jobs are not captured
	DELETE FROM #CCM_TEMP_JOB
FROM #CCM_TEMP_JOB a, CommServ_Capture..CCM_JMJobStats b
	WHERE a.jobid = b.jobId AND a.commcellId = b.commCellId
	/*--Skip jobs which are not in restricted job list
	IF (OBJECT_ID('tempdb.dbo.#CCM_Restricted_Capture_Entities') IS NOT NULL)
IF EXISTS(SELECT * FROM #CCM_Restricted_Capture_Entities WHERE EntityType = 23)
	BEGIN
		DELETE FROM #CCM_TEMP_JOB
		FROM 	#CCM_TEMP_JOB a LEFT OUTER JOIN #CCM_Restricted_Capture_Entities b
ON a.jobId = b.entityId AND a.commcellId = b.commcellId AND b.entityType = 23
		WHERE 	b.entityId IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_Job -- CCM_TEMP_JOB -- DELETE Non restricted jobs'
			GOTO CX_ERROR_EXIT
		END
	END
	*/
	-- CommServ_Capture..CCM_JMJobStats
INSERT INTO CommServ_Capture..CCM_JMJobStats
	SELECT
	a.jobId, a.status, a.opType, a.commCellId, a.jobCategory, a.jobDescription, a.xmlJobInfo
	FROM CCM_SOURCE_JMJobStats a, #CCM_TEMP_JOB b
	WHERE a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMJobStats'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMBkpStats
INSERT INTO CommServ_Capture..CCM_JMBkpStats
	SELECT
	a.jobId, a.commCellId, a.appId, a.appType, a.numAttempts, a.dataArchGrpId, a.copyID, a.bkpLevel,
	 a.indexOverride, a.status, a.duration, a.numStreams, a.servStartDate, a.servEndDate, a.opType,
	 a.fullCycleNum, a.initFrom, a.failureReason, a.bkpOptions, a.scanFileFailures, a.scanFolderFailures,
	 a.backupFileFailures, a.backupFolderFailures, a.oraSubLevel, a.username, a.totalWriteTime, a.priority,
	 a.totalCompBytes, a.totalUncompBytes, a.totalNumOfFiles, a.bkpattributes, a.logArchGrpId,
	 a.totalNumOfFolders, a.failureErrorCode, a.lastIncrJobTime, a.scanType, a.scanTypeChangeReason,
	 a.numStreamsRequested, a.dataStatus, a.agedTime, a.mediaDeletedTime, a.modifiedTime, a.version,
	 a.idaVersion, a.cIndexTime, a.cycleSequence, a.filesToXfer, a.cloudId, a.diffArchGrpId, a.totalBackupSize,
	 a.percentageChange, a.targetClientId, a.totalUncompBytesToXfer, a.displayStatus, a.dataBackedUp, a.logsBackedUp, a.openChain
	FROM CCM_SOURCE_JMBkpStats a, #CCM_TEMP_JOB b
	WHERE a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMBkpStats'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMBkpAtmptStats
INSERT INTO CommServ_Capture..CCM_JMBkpAtmptStats
	SELECT
	a.jobId, a.number, a.phase, a.elapsedTime, a.servStartDate, a.servEndDate, a.unCompBytes, a.compBytes,
	a.numObjects, a.status, a.failureReason, a.writeTime, a.restartString, a.attributes, a.commCellId,
	a.numFolders, a.archGrpId, a.copyId, a.maxStreamsUsed, a.modifiedTime
	FROM CCM_SOURCE_JMBkpAtmptStats a, #CCM_TEMP_JOB b
	WHERE a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMBkpAtmptStats'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMJobDataStats
INSERT INTO CommServ_Capture..CCM_JMJobDataStats
	SELECT DISTINCT
	a.jobId, a.archGrpId, a.archGrpCopyId, a.dataType, a.opType, a.auxCopyJobId, a.status, a.disabled,
	a.appId, a.commCellId, a.archCheckEndTime, a.archCheckStatus, a.retentionFlags, a.manualRetentionEndTime,
	a.copiedTime, a.agedTime, a.mediaDeletedTime, a.modifiedTime
	FROM CCM_SOURCE_JMJobDataStats a
		INNER JOIN  #CCM_TEMP_JOB b ON a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMJobDataStats'
		GOTO CX_ERROR_EXIT
	END
	/*--Skip capturing of copies which are not in restricted copy list
	IF (OBJECT_ID('tempdb.dbo.#CCM_Restricted_Capture_Entities') IS NOT NULL)
IF EXISTS(SELECT * FROM #CCM_Restricted_Capture_Entities WHERE EntityType = 18)
	BEGIN
DELETE	CommServ_Capture..CCM_JMJobDataStats
FROM	CommServ_Capture..CCM_JMJobDataStats a LEFT OUTER JOIN #CCM_Restricted_Capture_Entities b
ON a.archGrpCopyId = b.EntityId AND a.commCellId = b.commCellId AND b.EntityType = 18
		WHERE	b.EntityId IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMJobDataStats -- DELETE Non restricted jobs'
			GOTO CX_ERROR_EXIT
		END
	END
	*/
	-- CommServ_Capture..CCM_JMAdminJobStatsTable
INSERT INTO CommServ_Capture..CCM_JMAdminJobStatsTable
	SELECT
	a.jobId, a.opType, a.status, a.servStart, a.servEnd, a.archGrpID, a.archGrpName, a.AP_NumDays,
				 a.AP_IsForecast, a.AP_SeqNum, a.AC_NewMediaFlag, a.ER_BkpLevel, a.ER_DbName, a.ER_Destination,
				 a.ER_SendCount, a.ER_MediasUsed, a.EX_TotalMedia, a.EX_TotalSuccess, a.EX_TotalFailures, a.initFrom,
				 a.failureReason, a.archGrpCopyID, a.LibraryID, a.MI_InventoryType, a.username, a.totalWriteTime,
				 a.noOfStreams, a.priority, a.commCellId, a.appID, a.failureErrorCode, a.TotalSize, a.fullCycleNum,
				 a.dataStatus, a.workFlowId, a.embeddedObjects, a.uncompBytes, a.numFiles, a.skippedItems, a.jobFlags,
				 a.cloudId, a.successIndex, a.failIndex, a.totalBackupSize, a.version
	FROM CCM_SOURCE_JMAdminJobStatsTable a, #CCM_TEMP_JOB b
	WHERE a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMAdminJobStatsTable'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMAdminJobAttemptStatsTable
INSERT INTO CommServ_Capture..CCM_JMAdminJobAttemptStatsTable
	SELECT
	a.jobId, a.attemptNum, a.phaseNum, a.status, a.startTime, a.endTime, a.elapsedTime, a.failureReason,
	a.writeTime, a.commCellId, a.embeddedObjects, a.uncompBytes, a.numFiles, a.skippedItems, a.TotalSize
	FROM CCM_SOURCE_JMAdminJobAttemptStatsTable a, #CCM_TEMP_JOB b
	WHERE a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMAdminJobAttemptStatsTable'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMJobOptions
INSERT INTO CommServ_Capture..CCM_JMJobOptions
	SELECT
	a.*
	FROM CCM_SOURCE_JMJobOptions a, #CCM_TEMP_JOB b
	WHERE a.jobId = b.jobId AND a.commCellId = b.commCellId
	/* skipping these MA entries because on destination we don't have a way to give the mapping for these MAs, now the browse goes through accessible MA found via volumeId */
AND a.attributeId NOT IN ( 27, 28 )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMJobOptions'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMJobDataLink
INSERT INTO CommServ_Capture..CCM_JMJobDataLink
	SELECT DISTINCT a.* FROM CCM_SOURCE_JMJobDataLink a, #CCM_TEMP_JOB b
	WHERE a.commCellId = b.commCellId
	AND (a.parentJobId = b.jobId or a.childJobId = b.jobId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMJobDataLink'
		GOTO CX_ERROR_EXIT
	END
	/*
	 It is possible to have dependent jobs where either of the parent job or child job
will not have archive files, as they might be aged. In such cases, CommServ_Capture_80..CCM_JMJobStats
will not have an entry for the job not having any archive files but CommServ_Capture_80..CCM_JMJobDataLink
	 will still have the entry for the dependency.
	   The fix is to ignore such dependency and the jobs will be migrated as standalone, non-dependent jobs.
	 */
	DECLARE @toDeleteDependentJobs TABLE(parentJobId int, childJobId int, commCellId int)
	INSERT INTO @toDeleteDependentJobs
	SELECT a.parentJobId, a.childJobId, a.commCellId
FROM   CommServ_Capture..CCM_JMJobDataLink a
	WHERE NOT EXISTS(SELECT 1
FROM CommServ_Capture..CCM_JMJobStats b
	        WHERE b.jobId = a.parentJobId
	        AND   b.commCellId = a.commCellId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- parentJobs'
		GOTO CX_ERROR_EXIT
	END
    INSERT INTO @toDeleteDependentJobs
	SELECT a.parentJobId, a.childJobId, a.commCellId
FROM   CommServ_Capture..CCM_JMJobDataLink a
	WHERE NOT EXISTS(SELECT 1
FROM CommServ_Capture..CCM_JMJobStats b
	        WHERE b.jobId = a.childJobId
	        AND   b.commCellId = a.commCellId)
    AND  NOT EXISTS(SELECT 1
            FROM   @toDeleteDependentJobs c
            WHERE  c.parentJobId = a.parentJobId
            AND    c.childJobId  = a.childJobId
            AND    c.commCellId  = a.commCellId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- childJobs'
		GOTO CX_ERROR_EXIT
	END
DELETE FROM CommServ_Capture..CCM_JMJobDataLink
FROM   CommServ_Capture..CCM_JMJobDataLink a, @toDeleteDependentJobs b
	WHERE  a.parentJobId = b.parentJobId
	AND    a.childJobId  = b.childJobId
	AND    a.commCellId  = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- DELETE -- CCM_JMJobDataLink -- dependentJobs without archive files'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMOracleRACClientsUsed
INSERT INTO CommServ_Capture..CCM_JMOracleRACClientsUsed
	SELECT a.* FROM CCM_SOURCE_JMOracleRACClientsUsed a, #CCM_TEMP_JOB b
	WHERE a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- CCM_JMOracleRACClientsUsed'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_archCheckHistory
INSERT INTO CommServ_Capture..CCM_ArchCheckHistory
	SELECT a.*
	FROM CCM_SOURCE_archCheckHistory a, #CCM_TEMP_JOB b
	WHERE a.jobId = b.jobId AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archCheckHistory'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------
	------------------------------------------------------
	-------------------------------------------------------
	DROP TABLE #CCM_TEMP_JOB
    IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_JOB -- DROP -- CCM_TEMP_JOB'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_JOB_to_80')
	delete from GxQscripts where name = 'CCM_Capture_JOB_to_80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_JOB_to_80')
	delete from GXDBVersions where aliasname = 'CCM_Capture_JOB_to_80'
GO

insert into GXDBVersions values(2, 'CCM_Capture_JOB_to_80',  '00010002020800020000', 'CCM_Capture_JOB_to_80', '00010002020800020000')
GO

