

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Init_to_80.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture Init procedures.
--  +========================================================================+
-- $Id: CCM_Capture_Init_to_80.sp,v 1.3.86.1 2018/03/20 00:46:22 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_Init_to_80 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_Init_to_80')
	drop procedure CCM_Capture_Init_to_80
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Init_to_80')
	delete from GxQscripts where name = 'CCM_Capture_Init_to_80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Init_to_80')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Init_to_80'
GO
print '... Creating Procedure: CCM_Capture_Init_to_80'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_Init_to_80
AS
--Code Below Here is From CCM_Capture_Init.spb
  DECLARE @errorStr varchar(1024);
SET NOCOUNT ON
        SET @errorStr = 'NO_ERROR'
        -----------------------------------------------------------------------------------------
		IF NOT EXISTS (SELECT * FROM MASTER..SYSDATABASES
	    WHERE NAME = 'CommServ_Capture'
	    )
	    BEGIN
		    SET @errorStr = 'DATABASE CommServ_Capture DOES NOT EXIST'
		    GOTO CX_ERROR_EXIT
	    END
		IF EXISTS (SELECT * FROM CCM_SOURCE_APP_CommCell WHERE ID = 2 AND number = -1)
	    BEGIN
		    SET @errorStr = 'DATABASE CommServ DOES NOT HAVE PERMANENT LICENSE'
		    GOTO CX_ERROR_EXIT
	    END
	    IF OBJECT_ID ('CommServ_Capture.dbo.CCM_VirtualClientLicenses','U') IS NULL
    	BEGIN
				SET @errorStr = 'CCM_VirtualClientLicenses is not present in CommServ_Capture database.'
				GOTO CX_ERROR_EXIT
		END
      IF EXISTS (SELECT * FROM CommServ_Capture..CCM_APP_CommCell)
	    BEGIN
		    SET @errorStr = 'DATABASE CommServ_Capture HAS OLD CONTENTS, PLEASE DROP IT AND RECREATE A NEW ONE'
		    GOTO CX_ERROR_EXIT
	    END
        -----------------------------------------------------------------------------------------
        -- The following code is written to generate an unique id for the captured database
		-- The id is constructed using source commcell number and current time linked with char '_'
		IF EXISTS (SELECT * FROM CommServ_Capture..SYSOBJECTS WHERE NAME = 'CCM_DB_ID') DROP TABLE CommServ_Capture..CCM_DB_ID
		CREATE TABLE CommServ_Capture..CCM_DB_ID (id varchar(128))
		DECLARE @currentTime integer;
		DECLARE @commCellNum integer;
		DECLARE @id_string varchar(128);
		set @commCellNum = (select number from CCM_SOURCE_APP_CommCell where id = 2)
		set @currentTime = (select datediff(second, 'january 01, 1970',getdate()))
		set @id_string = convert(varchar(64), @commCellNum) + '_' + convert(varchar(64), @currentTime)
		INSERT INTO CommServ_Capture..CCM_DB_ID SELECT @id_string
		IF	@@ERROR > 0
		BEGIN
		    SET @errorStr = 'ERROR: CCM_Capture_Init -- CCM_DB_ID'
		    GOTO CX_ERROR_EXIT
		END
        -----------------------------------------------------------------------------------------
	SELECT	0, @errorStr
	RETURN (0)
CX_ERROR_EXIT:
	SELECT	-1, @errorStr
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Init_to_80')
	delete from GxQscripts where name = 'CCM_Capture_Init_to_80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Init_to_80')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Init_to_80'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Init_to_80',  '00010003008600010000', 'CCM_Capture_Init_to_80', '00010003008600010000')
GO

