

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Init_To_100.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture Init procedures.
--  +========================================================================+
-- $Id: CCM_Capture_Init_To_100.sp,v 1.1.60.1 2018/03/20 00:31:15 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_Init_To_100 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_Init_To_100')
	drop procedure CCM_Capture_Init_To_100
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Init_To_100')
	delete from GxQscripts where name = 'CCM_Capture_Init_To_100'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Init_To_100')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Init_To_100'
GO
print '... Creating Procedure: CCM_Capture_Init_To_100'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_Init_To_100
AS
--Code Below Here is From CCM_Capture_Init.spb
  DECLARE @errorStr varchar(1024);
SET NOCOUNT ON
        SET @errorStr = 'NO_ERROR'
        -----------------------------------------------------------------------------------------
		IF NOT EXISTS (SELECT * FROM MASTER..SYSDATABASES
	    WHERE NAME = 'CommServ_Capture'
	    )
	    BEGIN
		    SET @errorStr = 'DATABASE CommServ_Capture DOES NOT EXIST'
		    GOTO CX_ERROR_EXIT
	    END
      IF EXISTS (SELECT * FROM CommServ_Capture..CCM_APP_CommCell)
	    BEGIN
		    SET @errorStr = 'DATABASE CommServ_Capture HAS OLD CONTENTS, PLEASE DROP IT AND RECREATE A NEW ONE'
		    GOTO CX_ERROR_EXIT
	    END
        -----------------------------------------------------------------------------------------
        -- The following code is written to generate an unique id for the captured database
		-- The id is constructed using source commcell number and current time linked with char '_'
		IF EXISTS (SELECT * FROM CommServ_Capture..SYSOBJECTS WHERE NAME = 'CCM_DB_ID') DROP TABLE CommServ_Capture..CCM_DB_ID
		CREATE TABLE CommServ_Capture..CCM_DB_ID (id varchar(128))
		DECLARE @currentTime integer;
		DECLARE @commCellNum integer;
		DECLARE @id_string varchar(128);
		set @commCellNum = (select number from CCM_SOURCE_APP_CommCell where id = 2)
		set @currentTime = (select datediff(second, 'january 01, 1970',getdate()))
		set @id_string = convert(varchar(64), @commCellNum) + '_' + convert(varchar(64), @currentTime)
		INSERT INTO CommServ_Capture..CCM_DB_ID SELECT @id_string
		IF	@@ERROR > 0
		BEGIN
		    SET @errorStr = 'ERROR: CCM_Capture_Init -- CCM_DB_ID'
		    GOTO CX_ERROR_EXIT
		END
        -----------------------------------------------------------------------------------------
	SELECT	0, @errorStr
	RETURN (0)
CX_ERROR_EXIT:
	SELECT	-1, @errorStr
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Init_To_100')
	delete from GxQscripts where name = 'CCM_Capture_Init_To_100'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Init_To_100')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Init_To_100'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Init_To_100',  '00010001006000010000', 'CCM_Capture_Init_To_100', '00010001006000010000')
GO

