

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Holiday_To_90.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture Holidays associated with the client.
--  +========================================================================+
-- $Id: CCM_Capture_Holiday_To_90.sp,v 1.2.86.1 2018/03/20 00:39:18 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_Holiday_To_90 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_Holiday_To_90')
	drop procedure CCM_Capture_Holiday_To_90
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Holiday_To_90')
	delete from GxQscripts where name = 'CCM_Capture_Holiday_To_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Holiday_To_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Holiday_To_90'
GO
print '... Creating Procedure: CCM_Capture_Holiday_To_90'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_Holiday_To_90
  @i_clientId integer,
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_Holiday.spb
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	/**************************************************************
	 * PrasadNara: 10:08 PM 9/3/2012
	 * We are calling this proc only when capturing last subclient in the dump.
	 * So making changes as required to capture this for all captured subclients in the dump.
	 **************************************************************/
	---------------------------------------------------------
INSERT INTO CommServ_Capture..CCM_SchedHoliday
	SELECT DISTINCT
	a.startYear, a.startMonth, a.startDay, a.startHour, a.startMinute, a.startSecond, a.endYear, a.endMonth, a.endDay,
	a.endHour, a.endMinute, a.endSecond, a.modified, a.description, a.clientId, a.groupId, a.id
FROM CCM_SOURCE_SchedHoliday a INNER JOIN CommServ_Capture..CCM_App_Client b ON a.clientId = b.id
LEFT OUTER JOIN CommServ_Capture..CCM_SchedHoliday c ON a.clientId = c.clientId
	WHERE a.groupId = 0                    -- Avoid Group Specific Holidays
	  AND c.clientId IS NULL
	IF	@@ERROR > 0
	BEGIN
	 SET @errStr = 'ERROR: CCM_Capture_Holiday -- CCM_SchedHoliday'
	 GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Holiday_To_90')
	delete from GxQscripts where name = 'CCM_Capture_Holiday_To_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Holiday_To_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Holiday_To_90'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Holiday_To_90',  '00010002008600010000', 'CCM_Capture_Holiday_To_90', '00010002008600010000')
GO

