

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Entities_to_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Procedure: Capture requested entities into a XML.
--  +========================================================================+
-- $Id: CCM_Capture_Entities_to_XML.sp,v 1.16.12.8.4.1 2021/03/20 05:23:19 cliu Exp $
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCM_Capture_Entities_to_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_Entities_to_XML <<<'
	drop procedure CCM_Capture_Entities_to_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Entities_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_Entities_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Entities_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Entities_to_XML'
GO
print '... Creating Procedure: CCM_Capture_Entities_to_XML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCM_Capture_Entities_to_XML
  @i_entitiesToCaptureXml XML,
  @i_time_from integer,
  @i_time_to integer,
  @i_flags integer
AS
  DECLARE @o_errCode int
  DECLARE @o_errStr varchar(1024)
  DECLARE @o_CaptureResponseXml XML
SET @o_errCode = -1
SET @o_errStr = 'ERROR: GENERAL ERROR!'
SET NOCOUNT ON
declare @l_CaptureDataXml XML
DECLARE @l_EntitiesTab          TABLE(
                                        EntityId            INT,
                                        EntityType          INT,
                                        IsExclude           INT,
                                        clientId            INT
                                    )
DECLARE @l_Subclients           TABLE(  subclientId INT, clientId INT )
/******** Get Subclients list from input xml *********/
INSERT  INTO @l_EntitiesTab
SELECT  CASE entity.value('@_type_', 'INT')
WHEN 3 THEN entity.value('@clientId', 'INT')
WHEN 4 THEN entity.value('@applicationId', 'INT')
WHEN 5 THEN entity.value('@instanceId', 'INT')
WHEN 6 THEN entity.value('@backupsetId', 'INT')
WHEN 7 THEN entity.value('@subclientId', 'INT')
		ELSE  0
		END,
		entity.value('@_type_', 'INT'),
		ISNULL(entity.value('(flags/@exclude)[1]', 'INT'), 0),
		ISNULL(entity.value('@clientId', 'INT'), 0)
FROM    @i_entitiesToCaptureXml.nodes('/App_CaptureEntities/entities') AS entities(entity)
IF NOT EXISTS(SELECT 1 FROM @l_EntitiesTab)
	INSERT INTO @l_EntitiesTab VALUES (0, 1, 0, 0)
INSERT  INTO @l_Subclients
SELECT  DISTINCT a.id, a.clientId
FROM    APP_Application a, @l_EntitiesTab b
WHERE   a.appTypeId not in (1000,1030) /*1000 = CV_APPTYPE_COMMSRVMGMT , 1030  = CV_APPTYPE_SUBCLIENT_POLICY*/
		AND b.IsExclude = 0
AND b.EntityType in (1, 2, 72)
		OR
		(
			(b.clientId = 0 OR b.clientId = a.clientId)
			AND
			(
				CASE b.EntityType
WHEN 3 THEN a.clientId
WHEN 4 THEN a.appTypeId
WHEN 5 THEN a.instance
WHEN 6 THEN a.backupset
WHEN 7 THEN a.id
				END
			) = b.EntityId
		)
DELETE  @l_Subclients
FROM    @l_Subclients c, APP_Application a, @l_EntitiesTab b
WHERE   c.subclientId = a.id
		AND b.IsExclude = 1
		AND
		(
			(b.clientId = 0 OR b.clientId = a.clientId)
			AND
			(
				CASE b.EntityType
WHEN 3 THEN a.clientId
WHEN 4 THEN a.appTypeId
WHEN 5 THEN a.instance
WHEN 6 THEN a.backupset
WHEN 7 THEN a.id
				END
			) = b.EntityId
		)
-- if auto select complete cluster is set then capture all clients in the cluster
IF EXISTS(SELECT 1 FROM MMConfigs WHERE name = 'CCM_CONFIG_AUTO_SELECT_COMPLETE_CLUSTER_FOR_XML_CAPTURE' AND value = 1)
AND NOT EXISTS(SELECT 1 FROM @l_EntitiesTab WHERE EntityType in (1, 2, 72))
BEGIN
	DECLARE @l_ClusterClients		TABLE( clientId INT )
	DECLARE @l_clusterClientId		INT
	DECLARE ClusterClients_Cur CURSOR LOCAL FORWARD_ONLY FOR
	SELECT 	DISTINCT clientId FROM @l_Subclients
	OPEN ClusterClients_Cur
	FETCH NEXT FROM ClusterClients_Cur INTO @l_clusterClientId
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		INSERT INTO @l_ClusterClients
        SELECT * FROM GetClusterClientsForClient(@l_clusterClientId)
		FETCH NEXT FROM ClusterClients_Cur INTO @l_clusterClientId
	END
	CLOSE ClusterClients_Cur
	DEALLOCATE ClusterClients_Cur
	INSERT  INTO @l_Subclients
	SELECT  DISTINCT a.id, a.clientId
	FROM    APP_Application a
			INNER JOIN @l_ClusterClients b ON a.clientId = b.clientId
			LEFT OUTER JOIN @l_Subclients c ON a.id = c.subclientId
	WHERE   a.appTypeId not in (1000,1030) /*1000 = CV_APPTYPE_COMMSRVMGMT , 1030  = CV_APPTYPE_SUBCLIENT_POLICY*/
			AND c.subclientId IS NULL
END
/* Capture SAP HANA dependent physical clients */
IF (@i_flags & 2) > 0
BEGIN
	INSERT INTO @l_Subclients
	SELECT  DISTINCT R.id, R.clientId
	FROM @l_Subclients tApp
INNER JOIN APP_Application A WITH (NOLOCK) ON A.id = tApp.subclientId AND A.appTypeId = 135
		INNER JOIN APP_InstanceName I WITH (NOLOCK) ON A.instance = I.id
		INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON I.id = IP.componentNameId
			CROSS APPLY dbo.SplitString(IP.attrVal, '+') S
		INNER JOIN APP_Application R ON R.clientId = CAST(S.Data AS INT)
	WHERE IP.attrName = 'Database Clients' AND IP.modified = 0
	AND NOT EXISTS (SELECT 1 FROM @l_Subclients t WHERE t.subclientId = R.id )
END
/******** Create temp tables *********/
BEGIN TRY
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#l_errResponse_temp]')) --lpulickal
BEGIN
	DROP TABLE #l_errResponse_temp
END
CREATE  TABLE  #l_errResponse_temp (
	errCode int,
	errStr varchar(1024)
)
--Macro CCM_CREATE_TEMP_TABLES_ALL will be replaced with create table #CCM_* statements by DB_SQL_project while building the .sql from .sp

IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_DataPathMapping]') )
BEGIN
	DROP TABLE #CCM_DataPathMapping
END


CREATE  TABLE   #CCM_DataPathMapping (
	oldCopyId			integer	NOT NULL,

	newCopyId			integer	NOT NULL,

	oldPolicyName		varchar(1024)	NOT NULL,

	oldCopyName			varchar(1024)	NOT NULL,

	newMediaAgentId		integer	NOT NULL,

	newLibraryId		integer	NOT NULL,

	newDataPathId		integer	NOT NULL,

	newSpareGroupId		integer	NOT NULL,

	LibraryId           integer	NOT NULL,

	LibraryName         varchar(128)	NOT NULL,

	ClientId            integer	NOT NULL,

	DriveTypeId         integer	NOT NULL,

	DrivePoolId         integer	NOT NULL,

	flag                integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ClientNameMapping]') )
BEGIN
	DROP TABLE #CCM_ClientNameMapping
END


CREATE  TABLE   #CCM_ClientNameMapping (
	old_name				varchar(1024)	NOT NULL,

	new_name				varchar(1024)	NOT NULL,

	new_net_hostname		varchar(1024)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MountPathMapping]') )
BEGIN
	DROP TABLE #CCM_MountPathMapping
END


CREATE  TABLE   #CCM_MountPathMapping (
	MountPathId			integer	NOT NULL,

	newLibraryId		integer	NOT NULL,

	newMountPathName	varchar(1024)	NOT NULL,

	newUserName			varchar(1024)	NOT NULL,

	newPassword			varchar(2048)	NOT NULL,

	MountPathName            nvarchar(2048)	NOT NULL,

	SourceMediaAgentId       integer	NOT NULL,

	SourceMediaAgentName     nvarchar(510)	NOT NULL,

	MountPathType			 integer	NOT NULL,

	TargetDeviceMediaAgentId integer	NOT NULL,

	SourceDeviceId			 integer	NOT NULL,

	SourceDeviceName		 nvarchar(516)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ClientLicenses]') )
BEGIN
	DROP TABLE #CCM_ClientLicenses
END


CREATE  TABLE   #CCM_ClientLicenses (
	Old_clientId integer	NOT NULL,

	New_clientId integer	NOT NULL,

	appType integer	NOT NULL,

	simProdMapId integer	NOT NULL,

	simLicAppType integer	NOT NULL,

	simLicName varchar(128)	NOT NULL,

	minAppId integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxAccessPathMapping]') )
BEGIN
	DROP TABLE #CCM_IdxAccessPathMapping
END


CREATE  TABLE   #CCM_IdxAccessPathMapping (
	oldIdxSIDBStoreId		integer	NOT NULL,

	oldIdxSIDBStoreName	varchar(128)	NOT NULL,

	oldIdxAccessPathId	integer	NOT NULL,

	oldStoragePolicyName varchar(128)	NOT NULL,

	oldCopyName					varchar(128)	NOT NULL,

	oldClientName				varchar(128)	NOT NULL,

	oldPath							varchar(1024)	NOT NULL,

	newClientId					integer	NOT NULL,

	newPath							varchar(1024)	NOT NULL,

	newUserName					varchar(1024)	NOT NULL,

	newPassword					varchar(2048)	NOT NULL,

	isGlobal			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_VirtualClientLicenses]') )
BEGIN
	DROP TABLE #CCM_VirtualClientLicenses
END


CREATE  TABLE   #CCM_VirtualClientLicenses (
	OldVMClientId			integer	NOT NULL,

	NewVMClientId			integer	NOT NULL,

	NewVMName               nvarchar(510)	NOT NULL,

	OldPMClientId			integer	NOT NULL,

	NewPMClientId			integer	NOT NULL,

	NewPMName               nvarchar(510)	NOT NULL,

	AppType				integer	NOT NULL,

	LicType				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MountPathLicense]') )
BEGIN
	DROP TABLE #CCM_MountPathLicense
END


CREATE  TABLE   #CCM_MountPathLicense (
	clientId integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_DevicePathMapping]') )
BEGIN
	DROP TABLE #CCM_DevicePathMapping
END


CREATE  TABLE   #CCM_DevicePathMapping (
	SourceDeviceId		integer	NOT NULL,

	SourceDeviceName				varchar(max) NOT NULL,

	SourceDevicePath				varchar(max) NOT NULL,

	newMediaAgentId		integer	NOT NULL,

	newDevicePath		varchar(1024)	NOT NULL,

	newUserName			varchar(1024)	NOT NULL,

	newPassword			varchar(2048)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LibraryMapping]') )
BEGIN
	DROP TABLE #CCM_LibraryMapping
END


CREATE  TABLE   #CCM_LibraryMapping (
	SourceLibraryId			integer	NOT NULL,

	SourceLibraryName		nvarchar(128)	NOT NULL,

	SourceLibraryTypeId		integer	NOT NULL,

	newMediaAgentId			integer	NOT NULL,

	newLibraryId			integer	NOT NULL,

	newLibraryName			nvarchar(128)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_FeatureLicenses]') )
BEGIN
	DROP TABLE #CCM_FeatureLicenses
END


CREATE  TABLE   #CCM_FeatureLicenses (
	clientId integer	NOT NULL,

	appTypeId integer	NOT NULL,

	simLicAppType integer	NOT NULL,

	simLicName varchar(128)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ReformatedMedia]') )
BEGIN
	DROP TABLE #CCM_ReformatedMedia
END


CREATE  TABLE   #CCM_ReformatedMedia (
	MediaId				integer	NOT NULL,

	CommCellId			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CommCell]') )
BEGIN
	DROP TABLE #CCM_APP_CommCell
END


CREATE  TABLE   #CCM_APP_CommCell (
	id					INTEGER NOT NULL,

	number				integer	NOT NULL,

	clientId			integer	NOT NULL,

	parentId			integer	NOT NULL,

	aliasName			nvarchar(256)	NOT NULL,

	flags				integer	NOT NULL,

	refTime				INTEGER  NOT NULL,

	userName			nvarchar(256)	NOT NULL,

	userPassword		nvarchar(1024)	NOT NULL,

	smtpServer			nvarchar(256)	NOT NULL,

	timeZone			nvarchar(1024)	NOT NULL,

	ipAddress			nvarchar(25)	NOT NULL,

	modified			INTEGER  NOT NULL,

	ccOpMode			integer	NOT NULL,

	drIpAddress			nvarchar(25)	NOT NULL,

	encNumber			nvarchar(256)	NOT NULL,

	csGUID				nvarchar(40)	NOT NULL,

	type				tinyint default 1	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Client]') )
BEGIN
	DROP TABLE #CCM_APP_Client
END


CREATE  TABLE   #CCM_APP_Client (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	name			    nvarchar(255)	NOT NULL,

	simOperatingSystemId		integer	NOT NULL,	--  "FOREIGN KEY TO ANOTHER TABLE?"

	net_hostname	    nvarchar(255)	NOT NULL,

	client_password	    nvarchar(255)	NOT NULL,

	refTime				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	offlineEntity		integer	NOT NULL,

	offlineTimeStamp	INTEGER  NOT NULL,

	csHostName			nvarchar(255)	NOT NULL,

	clientDescription				nvarchar(MAX) NOT NULL,

	jobResultDir		nvarchar(255)	NOT NULL,

	clientSkewTime		integer	NOT NULL,

	cvdPort             integer	NOT NULL,

	evmgrcPort			integer	NOT NULL,

	status				integer	NOT NULL,

	releaseId			integer	NOT NULL,

	spaceCheckFlags		integer	NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy

	ccpTime				INTEGER  Default 0 NOT NULL,	-- "     "

	origCCId			integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	GUID				uniqueidentifier ROWGUIDCOL NULL,

	specialClientFlags	integer Default 0 NOT NULL,

	displayName			nvarchar(255) DEFAULT 'REPLACEWITHCLIENTNAME' NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ClientProp]') )
BEGIN
	DROP TABLE #CCM_APP_ClientProp
END


CREATE  TABLE   #CCM_APP_ClientProp (
	id					INTEGER NOT NULL,

	componentNameId		integer	NOT NULL,

	attrName			nvarchar(1024)	NOT NULL,

	attrType			integer	NOT NULL,

	attrVal				nvarchar(1024)	NOT NULL,

	created				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_VMProp]') )
BEGIN
	DROP TABLE #CCM_APP_VMProp
END


CREATE  TABLE   #CCM_APP_VMProp (
	jobId				integer	NOT NULL,

	commCellId			integer	NOT NULL,

	VMclientId			integer	NOT NULL,

	attrName			nvarchar(1024)	NOT NULL,

	attrType			integer	NOT NULL,

	attrVal				nvarchar(1024)	NOT NULL,

	ClientJobId			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMQinetixUpdateStatus]') )
BEGIN
	DROP TABLE #CCM_JMQinetixUpdateStatus
END


CREATE  TABLE   #CCM_JMQinetixUpdateStatus (
	jobId			integer	NOT NULL,

	commCellId		integer	NOT NULL,

	clientId		integer	NOT NULL,

	clientName		nvarchar(255)	NOT NULL,

	status			integer	NOT NULL,

	category		integer	NOT NULL,

	ostype			integer	NOT NULL,

	discoverPhaseStatus	integer	NOT NULL,

	foreignCommCellName	nvarchar(256)	NOT NULL,

	clientRegistry		XML,

	installedUpdates				nvarchar(MAX) NOT NULL,

	statusMessage		varchar(256)default '',	-- Localised message Ids from JMFailureReasonMsg NOT NULL

	transferStatus		integer NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Platform]') )
BEGIN
	DROP TABLE #CCM_APP_Platform
END


CREATE  TABLE   #CCM_APP_Platform (
	clientId		integer	NOT NULL,	-- clientId maps to client table

	platformType	integer	NOT NULL,	-- CV Platform Type defines in CVPlatformInfo.h

	install_dir	    nvarchar(255)	NOT NULL,

	refTime			INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_IDAName]') )
BEGIN
	DROP TABLE #CCM_APP_IDAName
END


CREATE  TABLE   #CCM_APP_IDAName (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	clientId			integer	NOT NULL,	--Foreign key to APP_Client Table

	appTypeId		    integer	NOT NULL,	--Foreign key to APP_iDAType table

	status				integer	NOT NULL,

	refTime				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy

	ccpTime				INTEGER  Default 0 NOT NULL	-- "     "



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_IDAProp]') )
BEGIN
	DROP TABLE #CCM_APP_IDAProp
END


CREATE  TABLE   #CCM_APP_IDAProp (
	id				INTEGER NOT NULL,

	componentNameId		integer	NOT NULL,

	attrName		    	nvarchar(1024)	NOT NULL,

	attrType			integer	NOT NULL,

	attrVal				nvarchar(MAX)NOT NuLl,

	created			INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_DCvolInfo]') )
BEGIN
	DROP TABLE #CCM_APP_DCvolInfo
END


CREATE  TABLE   #CCM_APP_DCvolInfo (
	id                   INTEGER NOT NULL,

	componentNameId      integer	NOT NULL,

	volName              nvarchar(400)	NOT NULL,

	capacity             integer	NOT NULL,

	initialRunStatus	  integer	NOT NULL,

	state				  integer	NOT NULL,

	refTime              INTEGER  NOT NULL,

	flags                integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_InstanceName]') )
BEGIN
	DROP TABLE #CCM_APP_InstanceName
END


CREATE  TABLE   #CCM_APP_InstanceName (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	name			    nvarchar(512)	NOT NULL,

	refTime				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	status				integer	NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy

	ccpTime				INTEGER  Default 0 NOT NULL,	-- "     "

	origCCId			integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	GUID				uniqueidentifier ROWGUIDCOL NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_InstanceProp]') )
BEGIN
	DROP TABLE #CCM_APP_InstanceProp
END


CREATE  TABLE   #CCM_APP_InstanceProp (
	id				INTEGER NOT NULL,

	componentNameId		integer	NOT NULL,

	attrName		    	nvarchar(1024)	NOT NULL,

	attrType			integer	NOT NULL,

	attrVal				nvarchar(MAX) NOT NULL,

	created			INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_InstFilterFile]') )
BEGIN
	DROP TABLE #CCM_APP_InstFilterFile
END


CREATE  TABLE   #CCM_APP_InstFilterFile (
	componentNameId		integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	type				integer	NOT NULL,

	fileName				nvarchar(MAX) NOT NULL,

	created				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	id                  INTEGER NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_BackupSetName]') )
BEGIN
	DROP TABLE #CCM_APP_BackupSetName
END


CREATE  TABLE   #CCM_APP_BackupSetName (
	id			INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	name			nvarchar(128)	NOT NULL,

	refTime			INTEGER  NOT NULL,

	modified		INTEGER  NOT NULL,

	status			integer	NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy

	ccpTime				INTEGER  Default 0 NOT NULL,	-- "     "

	origCCId			integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	GUID				uniqueidentifier ROWGUIDCOL NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_BackupSetProp]') )
BEGIN
	DROP TABLE #CCM_APP_BackupSetProp
END


CREATE  TABLE   #CCM_APP_BackupSetProp (
	id				INTEGER NOT NULL,

	componentNameId		integer	NOT NULL,

	attrName		    	nvarchar(1024)	NOT NULL,

	attrType			integer	NOT NULL,

	attrVal				nvarchar(MAX)NOT NuLl,

	created			INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_BackupSetFilterFile]') )
BEGIN
	DROP TABLE #CCM_APP_BackupSetFilterFile
END


CREATE  TABLE   #CCM_APP_BackupSetFilterFile (
	componentNameId		integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	type				integer	NOT NULL,

	fileName	    	nvarchar(1024)	NOT NULL,

	created				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Application]') )
BEGIN
	DROP TABLE #CCM_APP_Application
END


CREATE  TABLE   #CCM_APP_Application (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	clientId			integer	NOT NULL,

	appTypeId			integer	NOT NULL,

	instance	   	    	integer	NOT NULL,

	backupSet			integer	NOT NULL,

	appNumber			integer	NOT NULL,

	dataArchGrpID		smallint	NOT NULL,	-- Data Archive Group

	logArchGrpID		smallint	NOT NULL,	-- Index Archive Group

	refTime				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	subclientName		nvarchar(128)	NOT NULL,

	subclientStatus     integer	NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy

	ccpTime				INTEGER  Default 0 NOT NULL,	-- "     "

	origCCId			integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	GUID				uniqueidentifier ROWGUIDCOL NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_SubClientProp]') )
BEGIN
	DROP TABLE #CCM_APP_SubClientProp
END


CREATE  TABLE   #CCM_APP_SubClientProp (
	id				INTEGER NOT NULL,

	componentNameId		integer	NOT NULL,

	attrName		    	nvarchar(1024)	NOT NULL,

	attrType			integer	NOT NULL,

	attrVal				nvarchar(MAX)NOT NuLl,

	created			INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,	-- 9.0 Client Configuration Policy



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ComponentProp]') )
BEGIN
	DROP TABLE #CCM_APP_ComponentProp
END


CREATE  TABLE   #CCM_APP_ComponentProp (
	id				INTEGER NOT NULL,

	componentType	integer	NOT NULL,	-- Mailbox name, mailbox GUID, etc .... These are defined FOR this table

	componentId		integer	NOT NULL,	-- Key into existing property table  (e.g. subClientProp)

	propertyTypeId	integer	NOT NULL,	-- PROPERTY_EXCHANGE_MBOX (enum Property_Enum)

	dataType		integer	NOT NULL,	-- Integer, String, etc ... Also Property_enum!

	longVal			integer	NOT NULL,	-- Used to hold value for anything that will fit in it (long/short/bool etc ...

	longlongVal		bigint	NOT NULL,	-- Used to hold values for 64 bit entities

	stringVal       nVarchar(MaX) NULL,	-- Used to hold the rest!

	created			INTEGER  NOT NULL,

	modified		INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ScFilterFile]') )
BEGIN
	DROP TABLE #CCM_APP_ScFilterFile
END


CREATE  TABLE   #CCM_APP_ScFilterFile (
	id                  INTEGER NOT NULL,

	componentNameId		integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	type				integer	NOT NULL,

	fileName				nvarchar(MAX) NOT NULL,

	created				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer Default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_VMToPMMap]') )
BEGIN
	DROP TABLE #CCM_APP_VMToPMMap
END


CREATE  TABLE   #CCM_APP_VMToPMMap (
	VMClientId			integer	NOT NULL,

	PMClientId			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_VMBackupSet]') )
BEGIN
	DROP TABLE #CCM_APP_VMBackupSet
END


CREATE  TABLE   #CCM_APP_VMBackupSet (
	VMClientId			integer	NOT NULL,

	ParentBackupSetId	integer	NOT NULL,

	ChildBackupSetId	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simClientAppsV2]') )
BEGIN
	DROP TABLE #CCM_simClientAppsV2
END


CREATE  TABLE   #CCM_simClientAppsV2 (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	clientId			   integer	NOT NULL,

	simProdMapId		integer	NOT NULL,

	simGroupId			integer	NOT NULL,	-- NOT CURRENTLY A FOREGN KEY ... CONTRAINT ISSUES!!!!

	status				integer	NOT NULL,

	installTime			INTEGER  NOT NULL,

	buildId				varchar(32)	NOT NULL,

	releaseId			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simAllGalaxyRel]') )
BEGIN
	DROP TABLE #CCM_simAllGalaxyRel
END


CREATE  TABLE   #CCM_simAllGalaxyRel (
	id					integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	release			    varchar(128)	NOT NULL,

	buildNum			integer DEFAULT 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_PatchDBSPInfo]') )
BEGIN
	DROP TABLE #CCM_PatchDBSPInfo
END


CREATE  TABLE   #CCM_PatchDBSPInfo (
	SPNumber			integer	NOT NULL,

	PatchName			nvarchar(64)	NOT NULL,

	AppTypeId			integer	NOT NULL,

	SpMinorVersion		integer	NOT NULL,

	AliasName			nvarchar(64)	NOT NULL,

	StepNo				integer	NOT NULL,

	TransactionID		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simInstalledPackages]') )
BEGIN
	DROP TABLE #CCM_simInstalledPackages
END


CREATE  TABLE   #CCM_simInstalledPackages (
	id					INTEGER NOT NULL,

	ClientId			integer	NOT NULL,

	simPackageID		integer	NOT NULL,

	OpTime				datetime,

	OpType				char(25)	NOT NULL,

	UserID				integer	NOT NULL,

	HighestSP			integer	NOT NULL,

	AdditionalPatches				nvarchar(max)NULL,

	MissingPatches				nvarchar(max)NULL,

	Node				nvarchar(255),

	IsActive			integer default (1)	NOT NULL,

	SpMinorVersion		integer	NOT NULL,

	Baseline			integer	NOT NULL,

	BaselineDeltaSP				nvarchar(max)NULL,

	BaselineDeltaUpdate				nvarchar(max)NULL,

	SPVersionId			integer NULL,

	UPNumber		integer NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simInstalledPackagesHistory]') )
BEGIN
	DROP TABLE #CCM_simInstalledPackagesHistory
END


CREATE  TABLE   #CCM_simInstalledPackagesHistory (
	id					INTEGER NOT NULL,

	simInstalledPkgID	integer	NOT NULL,

	simPackageID		integer	NOT NULL,

	ClientId			integer	NOT NULL,

	InstallState		integer	NOT NULL,

	OpType				char(25)	NOT NULL,

	PreviousReleaseID	integer	NOT NULL,

	ReleaseID			integer	NOT NULL,

	OpTime				datetime,

	UserID				integer	NOT NULL,

	AppType				integer	NOT NULL,

	LicType				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simXMLRequest]') )
BEGIN
	DROP TABLE #CCM_simXMLRequest
END


CREATE  TABLE   #CCM_simXMLRequest (
	id			INTEGER NOT NULL,

	clientId	integer	NOT NULL,

	OpTimeUTC	datetime,

	xmlBlob		XML,

	xmlResponse	XML DEFAULT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CustomCalendar]') )
BEGIN
	DROP TABLE #CCM_APP_CustomCalendar
END


CREATE  TABLE   #CCM_APP_CustomCalendar (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	name				nvarchar(1024) 			NOT NULL,	-- Name of calendar

	beginYear			integer									NOT NULL,

	beginMonth			integer									NOT NULL,

	beginDate			integer									NOT NULL,

	noOfyears			integer									NOT NULL,

	isDefault			integer									NOT NULL,

	calType				integer									NOT NULL,

	createdTime			integer									NOT NULL,

	modifiedTime		integer									NOT NULL,

	origCCId			integer									DEFAULT		2	NOT NULL,

	GUID				uniqueidentifier ROWGUIDCOL NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CustomCalendarMonths]') )
BEGIN
	DROP TABLE #CCM_APP_CustomCalendarMonths
END


CREATE  TABLE   #CCM_APP_CustomCalendarMonths (
	calendarId			integer	NOT NULL,	-- FOREIGN KEY TO APP_CustomCalendar

	year				integer 		NOT NULL,			-- 2004, 2005

	month				integer 		NOT NULL,			-- Jan - 1, Feb = 2

	offset				integer									NOT NULL,		-- Offset from the standard calendar

	daysCount			integer									NOT NULL,   	-- Number of days in month

	startDate			DATETIME								NOT NULL,

	endDate				DATETIME								NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_OracleRacInstance]') )
BEGIN
	DROP TABLE #CCM_APP_OracleRacInstance
END


CREATE  TABLE   #CCM_APP_OracleRacInstance (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	instaceId			integer	NOT NULL,	-- Foreign key to galaxy instance Id

	clientId			integer	NOT NULL,	-- Foreign key to client table

	name				nvarchar(255)	NOT NULL,

	oracleHome		    nvarchar(255)	NOT NULL,

	oracleUser		    nvarchar(255)	NOT NULL,

	parellelInstance    nvarchar(255)	NOT NULL,

	InstanceOraUser     nvarchar(255)	NOT NULL,

	InstanceOraPasswd   nvarchar(255)	NOT NULL,

	InstanceOraService  nvarchar(255)	NOT NULL,

	tnsAdmin			nvarchar(255)	NOT NULL,

	threadId			integer	NOT NULL,

	instanceNumber		integer	NOT NULL,

	flag				integer	NOT NULL,

	status				integer	NOT NULL,	--Status Open = 1, mounted = 2, shutdown = 3, started = 4

	sbtLibName			nvarchar(255)	NOT NULL,

	ntPassword			nvarchar(255)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ExtendedProperties]') )
BEGIN
	DROP TABLE #CCM_APP_ExtendedProperties
END


CREATE  TABLE   #CCM_APP_ExtendedProperties (
	clientId			integer	NOT NULL,

	appTypeId			integer	NOT NULL,

	instance	   	    integer	NOT NULL,

	backupSet			integer	NOT NULL,

	subclientId			integer	NOT NULL,

	attrType			integer	NOT NULL,

	attrName	    	nvarchar(64)	NOT NULL,

	attrVal				nvarchar(max)NULL,

	MD5					varchar(64)	NOT NULL,

	created				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	ccpId				integer	NOT NULL,	-- 9.0 Client Configuration Policy



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ClientGroup]') )
BEGIN
	DROP TABLE #CCM_APP_ClientGroup
END


CREATE  TABLE   #CCM_APP_ClientGroup (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	name				nvarchar(512)	NOT NULL,

	description				nvarchar(MAX) NOT NULL,

	flag				integer	NOT NULL,

	status				integer	NOT NULL,

	userId				integer	NOT NULL,

	refTime				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL,

	fwPorts				nvarchar(255) default('')	NOT NULL,

	origCCId			integer		DEFAULT		2	NOT NULL,

	GUID				uniqueidentifier ROWGUIDCOL NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SchedHoliday]') )
BEGIN
	DROP TABLE #CCM_SchedHoliday
END


CREATE  TABLE   #CCM_SchedHoliday (
	startYear   integer	NOT NULL,

	startMonth  integer	NOT NULL,

	startDay    integer	NOT NULL,

	startHour   integer	NOT NULL,

	startMinute integer	NOT NULL,

	startSecond integer	NOT NULL,

	endYear     integer	NOT NULL,

	endMonth    integer	NOT NULL,

	endDay      integer	NOT NULL,

	endHour     integer	NOT NULL,

	endMinute   integer	NOT NULL,

	endSecond   integer	NOT NULL,

	modified	INTEGER  NOT NULL,	-- Used To Monitor if anything has changed

	description	nvarchar(80)	NOT NULL,

	clientId    integer	NOT NULL,

	groupId     integer	NOT NULL,

	id			INTEGER NOT NULL,

	vtPolicyId	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_OpWindowRule]') )
BEGIN
	DROP TABLE #CCM_APP_OpWindowRule
END


CREATE  TABLE   #CCM_APP_OpWindowRule (
	id				    integer	NOT NULL,

	clientId			integer	NOT NULL,

	appTypeId			integer	NOT NULL,

	opType				integer	NOT NULL,

	daysOfWeek			integer	NOT NULL,

	startTime			integer	NOT NULL,

	endTime				integer	NOT NULL,

	enable				integer	NOT NULL,

	description			nvarchar(1024)	NOT NULL,

	utilization			integer	NOT NULL,

	clientGroupId		integer	NOT NULL,

	instanceId			integer	NOT NULL,

	backupsetId			integer	NOT NULL,

	subclientId			integer	NOT NULL,

	startDate			integer	NOT NULL,

	endDate				integer	NOT NULL,

	schedulePolicyId	integer default 0	NOT NULL,

	weekOfTheMonth		integer default -1	NOT NULL,

	doNotSubmitJob		integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_MongoDbSCPriority]') )
BEGIN
	DROP TABLE #CCM_APP_MongoDbSCPriority
END


CREATE  TABLE   #CCM_APP_MongoDbSCPriority (
	id 			INTEGER NOT NULL,  		--Primary Key

	mdbNode		INTEGER	NOT NULL,

	subclientId 		INTEGER	NOT NULL,

	priority    INTEGER	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archGroup]') )
BEGIN
	DROP TABLE #CCM_archGroup
END


CREATE  TABLE   #CCM_archGroup (
	id                  SMALLINT NOT NULL,

	defaultCopy			smallint	NOT NULL,

	name				NVARCHAR(144)	NOT NULL,

	description				NVARCHAR(MAX) NOT NULL,

	maxStreams			integer	NOT NULL,

	type				tinyint	NOT NULL,

	incrSP				smallint	NOT NULL,

	origCCcommCellID	integer	NOT NULL,

	origCCarchGroupId	smallint	NOT NULL,

	defaultSnapCopy		smallint	NOT NULL,

	SIBlockSizeKB		integer	NOT NULL,

	AuxCopyAlertGB		integer	NOT NULL,

	AuxCopyAlertDays	integer	NOT NULL,

	flags				integer	NOT NULL,

	mediaPassword		varchar(2048)	NOT NULL,

	TimeZoneType		tinyint	NOT NULL,

	TimeZone				varchar(255)	NOT NULL,

	SubclientExtensionTimeStamp 			integer Default 0	NOT NULL,

	SubclientExtensionTimeStampEncrypted 	varchar(2048) Default ''	NOT NULL,

	logSP				smallint Default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archGroupCopy]') )
BEGIN
	DROP TABLE #CCM_archGroupCopy
END


CREATE  TABLE   #CCM_archGroupCopy (
	id					SMALLINT NOT NULL,		-- THIS FIELD -EITHER- AUTOGENERATED -OR- PASSED IN

	archGroupId      	smallint	NOT NULL,

	copy				smallint	NOT NULL,

	name				NVARCHAR(64)	NOT NULL,

	flags				integer	NOT NULL,

	maxMultiplex		tinyint	NOT NULL,	-- How many clients can backup to this copy simultaneously

	isActive			tinyint	NOT NULL,

	type				tinyint	NOT NULL,

	startTime			INTEGER  NOT NULL,

	waitForIfOffline	integer	NOT NULL,

	waitForIfBusy		integer	NOT NULL,

	archCheckStartTime	INTEGER  NOT NULL,

	origCCcommCellID	integer	NOT NULL,

	origCCarchCopyId	smallint	NOT NULL,

	sourceCopyId		smallint	NOT NULL,

	delayedDays			smallint	NOT NULL,

	maxStreamNum		integer	NOT NULL,

	archCheckValidPeriod	integer	NOT NULL,

	calendarId			integer	NOT NULL,

	SIDBStoreId			integer	NOT NULL,	-- The SIDBStoreId associated for this copy.

	encType				tinyint	NOT NULL,

	encKeyLen			smallint	NOT NULL,

	isSnapCopy			tinyint Default 0	NOT NULL,

	isMirrorCopy		tinyint Default 0	NOT NULL,

	NWWriteSpeed		integer Default 0	NOT NULL,

	SIDBSnapIntervalHours	integer Default 0	NOT NULL,

	siloAppId			integer Default 0	NOT NULL,

	nDataInstance		integer Default 0	NOT NULL,

	description				NVARCHAR(MAX)Default '' NOT NULL,

	dedupeFlags			integer Default 0	NOT NULL,

	blockCacheValidDays	integer Default 0	NOT NULL,

	nSiloStreams		integer Default 1	NOT NULL,

	silosInCache		integer Default 0	NOT NULL,

	siloRestoreMAClientId	integer Default 0	NOT NULL,

	siloRestoreClientId	integer Default 0	NOT NULL,

	sealStoreTaskId		integer Default 0	NOT NULL,

	extendedFlags		bigint Default 0	NOT NULL,

	destMediaCopyId		integer Default 0	NOT NULL,

	maxCacheDBSizeMB	integer Default 0	NOT NULL,

	DDBLimitExtensionTimeStamp integer Default 0	NOT NULL,

	DDBLimitExtensionTimeStampEncrypted varchar(2048) Default ''	NOT NULL,

	archCheckValidPeriodType	integer Default 3	NOT NULL,

	endTime				INTEGER  DEFAULT 2147483647 NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopyMediaRefreshProp]') )
BEGIN
	DROP TABLE #CCM_archCopyMediaRefreshProp
END


CREATE  TABLE   #CCM_archCopyMediaRefreshProp (
	copyId				smallint	NOT NULL,

	targetCopyId		smallint	NOT NULL,

	flags				integer	NOT NULL,

	daysAfterWritten	integer	NOT NULL,

	daysBeforeAged		integer	NOT NULL,

	percentage			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopyToGlobalPolicy]') )
BEGIN
	DROP TABLE #CCM_archCopyToGlobalPolicy
END


CREATE  TABLE   #CCM_archCopyToGlobalPolicy (
	copyId			smallint	NOT NULL,

	globalPolicyId		smallint	NOT NULL,

	flags			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archStream]') )
BEGIN
	DROP TABLE #CCM_archStream
END


CREATE  TABLE   #CCM_archStream (
	archGroupId			smallint	NOT NULL,

	archGroupCopyId		smallint	NOT NULL,

	stream				integer	NOT NULL,

	mediaGroupId		integer	NOT NULL,

	isActive			tinyint	NOT NULL,

	lastUsedTime		integer	NOT NULL,

	physicalDataSizeInGB	integer	NOT NULL,

	flags				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAgingRule]') )
BEGIN
	DROP TABLE #CCM_archAgingRule
END


CREATE  TABLE   #CCM_archAgingRule (
	copyId			  	smallint	NOT NULL,

	retentionDays  	integer	NOT NULL,

	fullCycles     	integer	NOT NULL,

	flags			   		integer	NOT NULL,

	weekStart				integer	NOT NULL,

	monthStart			integer	NOT NULL,

	yearStart				integer	NOT NULL,

	archiverRetDays integer DEFAULT -1	NOT NULL,

	retentionJobs			integer	NOT NULL,

	minutesSinceDayStarts            integer NOT NULL default 0,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAgingRuleExtended]') )
BEGIN
	DROP TABLE #CCM_archAgingRuleExtended
END


CREATE  TABLE   #CCM_archAgingRuleExtended (
	copyId			smallint	NOT NULL,

	retentionDays		integer	NOT NULL,

	retentionRule		integer	NOT NULL,

	currPeriodBegin		INTEGER  NOT NULL,

	currPeriodEnd		INTEGER  NOT NULL,

	prevPeriodBegin		INTEGER  NOT NULL,

	nextPeriodEnd		INTEGER  NOT NULL,

	GraceDays				integer	NOT NULL,

	EveryXHours                               integer not null  default  0,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAppCopyAgingRule]') )
BEGIN
	DROP TABLE #CCM_archAppCopyAgingRule
END


CREATE  TABLE   #CCM_archAppCopyAgingRule (
	appId										integer	NOT NULL,

	copyId			  					smallint	NOT NULL,

	retentionDays  					integer	NOT NULL,

	fullCycles 				    	integer	NOT NULL,

	flags			   						integer	NOT NULL,

	weekStart								integer	NOT NULL,

	monthStart							integer	NOT NULL,

	yearStart								integer	NOT NULL,

	archiverRetDays 				integer	NOT NULL,

	retentionJobs						integer	NOT NULL,

	minutesSinceDayStarts   integer	NOT NULL,

	archGrpId								smallint	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAppCopyAgingRuleExtended]') )
BEGIN
	DROP TABLE #CCM_archAppCopyAgingRuleExtended
END


CREATE  TABLE   #CCM_archAppCopyAgingRuleExtended (
	appId						integer	NOT NULL,

	copyId					smallint	NOT NULL,

	retentionDays		integer	NOT NULL,

	retentionRule		integer	NOT NULL,

	GraceDays				integer	NOT NULL,

	EveryXHours     integer	NOT NULL,

	archGrpId				smallint	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archSelectiveCopy]') )
BEGIN
	DROP TABLE #CCM_archSelectiveCopy
END


CREATE  TABLE   #CCM_archSelectiveCopy (
	copyId			smallint	NOT NULL,

	type			tinyint	NOT NULL,

	numPeriod		tinyint	NOT NULL,

	dayNumber		smallint	NOT NULL,

	startPeriod		INTEGER  NOT NULL,

	nextPeriod		INTEGER  NOT NULL,

	prevPeriodBegin	INTEGER  NOT NULL,

	nextPeriodEnd	INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopyToApp]') )
BEGIN
	DROP TABLE #CCM_archCopyToApp
END


CREATE  TABLE   #CCM_archCopyToApp (
	copyId			smallint	NOT NULL,

	clientId		integer	NOT NULL,

	appTypeId		integer	NOT NULL,

	instanceId	   	integer	NOT NULL,

	backupSetId		integer	NOT NULL,

	subClientId		integer	NOT NULL,

	clientGroupId	integer default 0	NOT NULL,

	exclude			integer default 0	NOT NULL,

	assocType		integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopySIDBStore]') )
BEGIN
	DROP TABLE #CCM_archCopySIDBStore
END


CREATE  TABLE   #CCM_archCopySIDBStore (
	CopyId							smallint	NOT NULL,

	SIDBStoreId						integer	NOT NULL,

	CommCellId						integer	NOT NULL,

	flags							integer	NOT NULL,

	TotalDataSizeBytes				bigint	NOT NULL,

	InstancedDataSizeBytes			bigint	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchEncKeyProvider]') )
BEGIN
	DROP TABLE #CCM_ArchEncKeyProvider
END


CREATE  TABLE   #CCM_ArchEncKeyProvider (
	KeyProviderId		INTEGER NOT NULL,

	KeyProviderName		NVARCHAR(64)	NOT NULL,

	KeyProviderType		integer	NOT NULL,

	EncType				integer	NOT NULL,

	EncKeyLength		integer	NOT NULL,

	Properties				nvarchar(max) NOT NULL,

	Modified			INTEGER  NOT NULL,

	Created				INTEGER  NOT NULL,

	GUID				uniqueidentifier,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchEncKeyProviderAssoc]') )
BEGIN
	DROP TABLE #CCM_ArchEncKeyProviderAssoc
END


CREATE  TABLE   #CCM_ArchEncKeyProviderAssoc (
	KeyProviderAssocId		INTEGER NOT NULL,

	KeyProviderId			integer	NOT NULL,

	EntityId				integer	NOT NULL,

	EntityType				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchCopyEncProperties]') )
BEGIN
	DROP TABLE #CCM_ArchCopyEncProperties
END


CREATE  TABLE   #CCM_ArchCopyEncProperties (
	CopyId				smallint	NOT NULL,

	PubKey				varchar(2048)	NOT NULL,

	PriKey				varchar(3072)	NOT NULL,

	MasterKeyId			varchar(2048)	NOT NULL,

	KeyProviderId		int	NOT NULL,

	EncType				int	NOT NULL,

	LastValidatedTime	INTEGER  default 0 NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archPipeConfig]') )
BEGIN
	DROP TABLE #CCM_archPipeConfig
END


CREATE  TABLE   #CCM_archPipeConfig (
	appNumber			integer	NOT NULL,

	compressWhere		tinyint	NOT NULL,

	numNWAgents			tinyint	NOT NULL,

	NWWriteSpeed		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFile]') )
BEGIN
	DROP TABLE #CCM_archFile
END


CREATE  TABLE   #CCM_archFile (
	id				INTEGER NOT NULL,

	name				NVARCHAR(2048)	NOT NULL,

	commCellId			integer	NOT NULL,

	archGroupId			smallint	NOT NULL,

	objName1			varchar(2048)	NOT NULL,

	flags				integer	NOT NULL,

	appId				integer	NOT NULL,

	fileType			tinyint	NOT NULL,

	cTime				integer	NOT NULL,

	jobId				integer	NOT NULL,

	backupLevel			integer	NOT NULL,

	isValid				smallint	NOT NULL,

	cloudId				integer	NOT NULL,

	contentIndexTime	integer	NOT NULL,

	nPushedItems		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileOracle]') )
BEGIN
	DROP TABLE #CCM_archFileOracle
END


CREATE  TABLE   #CCM_archFileOracle (
	archFileId		integer	NOT NULL,

	commCellId		integer	NOT NULL,

	appId					integer	NOT NULL,

	instanceId		integer	NOT NULL,

	clientId			integer	NOT NULL,

	archFileName	NVARCHAR(2048)	NOT NULL,

	fileType			integer	NOT NULL,

	flags					integer	NOT NULL,

	jobId					integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileOracleBackupPiece]') )
BEGIN
	DROP TABLE #CCM_archFileOracleBackupPiece
END


CREATE  TABLE   #CCM_archFileOracleBackupPiece (
	archFileId		INTEGER	NOT NULL,

	commCellId		INTEGER	NOT NULL,

	instanceId		INTEGER	NOT NULL,

	backupPiece		NVARCHAR(512)	NOT NULL,

	offset			BIGINT	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileCopy]') )
BEGIN
	DROP TABLE #CCM_archFileCopy
END


CREATE  TABLE   #CCM_archFileCopy (
	archFileId			integer	NOT NULL,	-- From archFile table

	commCellId     		integer	NOT NULL,

	archCopyId			smallint	NOT NULL,

	flags				integer	NOT NULL,

	isValid				smallint	NOT NULL,

	streamNum			integer	NOT NULL,

	lastChunkNumber		integer	NOT NULL,

	physicalSize		bigint	NOT NULL,

	logicalSize			bigint	NOT NULL,

	drivePoolId			int	NOT NULL,

	encRSA				tinyint	NOT NULL,

	encKeyType			tinyint	NOT NULL,

	encKey				varchar(1024)	NOT NULL,

	modifiedTime		INTEGER  NOT NULL,

	mediaType			integer	NOT NULL,

	agedBy				bigint	NOT NULL,

	encKeyId			int default 0	NOT NULL,

	unCompSize			bigint DEFAULT -1	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archChunk]') )
BEGIN
	DROP TABLE #CCM_archChunk
END


CREATE  TABLE   #CCM_archChunk (
	id				bigint	NOT NULL,	-- 64 bit number for unique chunk idetification

	commCellId      integer	NOT NULL,

	volumeId		integer	NOT NULL,

	fileMarkerNo	integer	NOT NULL,

	createTime		integer	NOT NULL,

	version			tinyint	NOT NULL,

	cclip			varchar(255)	NOT NULL,

	physicalSize	bigint	NOT NULL,

	logicalSize		bigint	NOT NULL,

	writeTime		integer	NOT NULL,

	flags			integer	NOT NULL,

	modifiedTime	INTEGER  NOT NULL,

	hwEncKey		varchar(114)	NOT NULL,

	agedBy			bigint	NOT NULL,

	origCCId		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archChunkMapping]') )
BEGIN
	DROP TABLE #CCM_archChunkMapping
END


CREATE  TABLE   #CCM_archChunkMapping (
	archChunkId			bigint	NOT NULL,

	archFileId			integer	NOT NULL,

	commCellId			integer	NOT NULL,

	archCopyId			smallint	NOT NULL,

	chunkNumber			integer	NOT NULL,

	physicalOffset		bigint	NOT NULL,

	logicalOffset		bigint	NOT NULL,

	physicalSize		bigint	NOT NULL,

	logicalSize			bigint	NOT NULL,

	flags				integer	NOT NULL,

	modifiedTime		INTEGER  NOT NULL,

	dedupedSize			bigint	NOT NULL,

	agedBy				bigint	NOT NULL,

	chunkCommCellId     integer	NOT NULL,

	jobId				integer	NOT NULL,

	unCompSize			bigint DEFAULT -1	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archDB2Log]') )
BEGIN
	DROP TABLE #CCM_archDB2Log
END


CREATE  TABLE   #CCM_archDB2Log (
	archFileId	integer	NOT NULL,

	firstLogTime	integer	NOT NULL,

	lastLogTime	integer	NOT NULL,

	firstLogNumber	integer	NOT NULL,

	lastLogNumber	integer	NOT NULL,

	commCellId	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCheckHistory]') )
BEGIN
	DROP TABLE #CCM_archCheckHistory
END


CREATE  TABLE   #CCM_archCheckHistory (
	jobId			integer	NOT NULL,

	commCellId      integer	NOT NULL,	--can be tinyint if it's tinyint in JM tables.

	archCopyId      smallint	NOT NULL,

	adminJobId		integer	NOT NULL,

	adminJobType	tinyint	NOT NULL,

	archCheckEndTime INTEGER  NOT NULL,

	archCheckStatus	tinyint	NOT NULL,

	errorString		varchar(4096)	NOT NULL,

	flags			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileSiloVolume]') )
BEGIN
	DROP TABLE #CCM_archFileSiloVolume
END


CREATE  TABLE   #CCM_archFileSiloVolume (
	archFileId			integer	NOT NULL,

	commCellId			integer	NOT NULL,

	siloVolumeId		integer	NOT NULL,

	lastSiloChunkId		bigint	NOT NULL,

	flags				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archChunkToSilo]') )
BEGIN
	DROP TABLE #CCM_archChunkToSilo
END


CREATE  TABLE   #CCM_archChunkToSilo (
	archChunkId		bigint	NOT NULL,	-- 64 bit number for unique chunk idetification

	commCellId      integer	NOT NULL,

	volumeId		integer	NOT NULL,

	flags			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFailedKilledJobInfo]') )
BEGIN
	DROP TABLE #CCM_archFailedKilledJobInfo
END


CREATE  TABLE   #CCM_archFailedKilledJobInfo (
	jobId							integer	NOT NULL,

	commCellId				integer	NOT NULL,

	servStartDate			INTEGER  NOT NULL,

	servEndDate				INTEGER  NOT NULL,

	appId							integer	NOT NULL,

	appType						integer	NOT NULL,

	archGrpId					smallint	NOT NULL,

	archGrpCopyId			smallint	NOT NULL,

	bkpLevel					integer	NOT NULL,

	opType						integer	NOT NULL,

	retentionFlags		integer	NOT NULL,

	flags							integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobStats]') )
BEGIN
	DROP TABLE #CCM_JMJobStats
END


CREATE  TABLE   #CCM_JMJobStats (
	jobId			integer	NOT NULL,

	status			integer	NOT NULL,

	opType			integer	NOT NULL,

	commCellId		integer	NOT NULL,

	jobCategory		integer	NOT NULL,

	jobDescription				nvarchar(max) NOT NULL,

	xmlJobInfo				nvarchar(max) NOT NULL,

	subOpType			integer	NOT NULL,

	foreignToken		nvarchar(2048)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobAction]') )
BEGIN
	DROP TABLE #CCM_JMJobAction
END


CREATE  TABLE   #CCM_JMJobAction (
	clientId 			integer	NOT NULL,	-- From APP_Client table

	mediaAgentID		integer	NOT NULL,

	appType				integer	NOT NULL,	-- From APP_iDAType table

	opType				integer	NOT NULL,

	action				integer	NOT NULL,

	appId				integer	NOT NULL,

	clientGroupId 		integer	NOT NULL,

	enableTimeZone		integer Default 0	NOT NULL,	-- 9.0 Timezone and time when to "re-enable"  Activity Control

	enableTime			INTEGER  Default 0 NOT NULL,	-- Skewed by Timezone

	UNCenableTime		INTEGER  Default 0 NOT NULL,	-- Greenich Time

	instanceID			INTEGER	NOT NULL,

	reason				NVARCHAR(1024) DEFAULT ''	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMBkpStats]') )
BEGIN
	DROP TABLE #CCM_JMBkpStats
END


CREATE  TABLE   #CCM_JMBkpStats (
	jobId				integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer	NOT NULL,

	appId				integer	NOT NULL,

	appType				integer	NOT NULL,

	numAttempts		integer	NOT NULL,

	dataArchGrpId		integer	NOT NULL,

	copyID				integer	NOT NULL,

	bkpLevel			integer	NOT NULL,

	indexOverride		integer	NOT NULL,

	status				integer	NOT NULL,

	duration			integer	NOT NULL,

	numStreams			integer	NOT NULL,

	servStartDate		INTEGER  NOT NULL,	-- Unix style date

	servEndDate			INTEGER  NOT NULL,	-- Unix style date

	opType				integer	NOT NULL,	-- From CVOpType Enum Type

	fullCycleNum		integer	NOT NULL,	-- Added for "Sparce Copy"

	initFrom		integer	NOT NULL,

	failureReason		varchar(256)	NOT NULL,

	bkpOptions		integer	NOT NULL,	-- Backup Options

	scanFileFailures	integer	NOT NULL,

	scanFolderFailures	integer	NOT NULL,

	backupFileFailures	integer	NOT NULL,

	backupFolderFailures	integer	NOT NULL,

	oraSubLevel		    integer	NOT NULL,	-- Sub backup level for oracle incremental job

	username		    nvarchar(255)	NOT NULL,

	totalWriteTime			integer	NOT NULL,

	priority	integer	NOT NULL,

	totalCompBytes		bigint	NOT NULL,

	totalUncompBytes	bigint	NOT NULL,

	totalNumOfFiles		bigint	NOT NULL,

	bkpattributes		bigint	NOT NULL,

	logArchGrpId		integer	NOT NULL,

	totalNumOfFolders	bigint	NOT NULL,

	failureErrorCode	integer	NOT NULL,

	lastIncrJobTime		integer	NOT NULL,

	scanType		integer	NOT NULL,

	scanTypeChangeReason	varchar(24),	-- saves the reason why the scan type was changed NOT NULL

	numStreamsRequested	integer	NOT NULL,

	dataStatus			integer	NOT NULL,

	agedTime			INTEGER  NOT NULL,

	mediaDeletedTime	INTEGER  NOT NULL,

	modifiedTime		INTEGER  NOT NULL,

	version				integer	NOT NULL,

	idaVersion			integer	NOT NULL,

	cIndexTime			INTEGER  NOT NULL,

	cycleSequence		integer	NOT NULL,

	filesToXfer			bigint	NOT NULL,

	cloudId				integer	NOT NULL,

	diffArchGrpId		integer	NOT NULL,

	totalBackupSize		bigint	NOT NULL,

	percentageChange 	integer	NOT NULL,

	targetClientId		integer	NOT NULL,

	totalUncompBytesToXfer	bigint	NOT NULL,

	displayStatus		integer	NOT NULL,

	dataBackedUp		integer	NOT NULL,

	logsBackedUp		integer	NOT NULL,

	openChain			integer	NOT NULL,

	secondaryBkpLevel	integer	NOT NULL,

	jobIdPrepared		integer	NOT NULL,

	jobIdActedOn		integer	NOT NULL,

	fromTime			integer	NOT NULL,

	toTime				integer	NOT NULL,

	subTaskId			integer	NOT NULL,

	nwTransBytes		bigint	NOT NULL,

	totSkippedObjects	bigint	NOT NULL,

	bkpAttributesEx		bigint	NOT NULL,

	jobReferenceTime	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMBkpAtmptStats]') )
BEGIN
	DROP TABLE #CCM_JMBkpAtmptStats
END


CREATE  TABLE   #CCM_JMBkpAtmptStats (
	jobId				integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	number				integer	NOT NULL,

	phase				integer	NOT NULL,

	elapsedTime			INTEGER  NOT NULL,

	servStartDate		INTEGER  NOT NULL,	-- Unix style date?

	servEndDate			INTEGER  NOT NULL,	-- Unix style date?

	unCompBytes			bigint	NOT NULL,

	compBytes			bigint	NOT NULL,

	numObjects			bigint	NOT NULL,	-- DOES THIS REALLY NEED TO BE A bigint?

	status				integer	NOT NULL,

	failureReason		varchar(256)	NOT NULL,

	writeTime			integer	NOT NULL,

	restartString		varchar(4096)	NOT NULL,

	attributes			integer	NOT NULL,

	commCellId			integer	NOT NULL,

	numFolders			bigint	NOT NULL,

	archGrpId			integer	NOT NULL,

	copyId				integer	NOT NULL,

	maxStreamsUsed		integer	NOT NULL,

	modifiedTime		INTEGER  NOT NULL,

	nwTransBytes		bigint	NOT NULL,

	totalAllocationTime				integer	NOT NULL,

	totalWaitTimeBeforeAllocation	integer	NOT NULL,

	readThroughput		float	NOT NULL,

	writeThroughput		float	NOT NULL,

	networkThroughput	float	NOT NULL,

	sidbLookups			float	NOT NULL,

	mediaAgent				nvarchar(max) NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMAdminJobStatsTable]') )
BEGIN
	DROP TABLE #CCM_JMAdminJobStatsTable
END


CREATE  TABLE   #CCM_JMAdminJobStatsTable (
	jobId				integer	NOT NULL,

	opType				integer	NOT NULL,

	status				integer	NOT NULL,

	servStart			INTEGER  NOT NULL,

	servEnd  			INTEGER  NOT NULL,

	archGrpID			integer	NOT NULL,

	archGrpName				nvarchar(max) NOT NULL,

	AP_NumDays			integer	NOT NULL,

	AP_IsForecast			integer	NOT NULL,

	AP_SeqNum			integer	NOT NULL,

	AC_NewMediaFlag			integer	NOT NULL,

	ER_BkpLevel			integer	NOT NULL,

	ER_DbName				nvarchar(max) NOT NULL,

	ER_Destination				nvarchar(max) NOT NULL,

	ER_SendCount			integer	NOT NULL,

	ER_MediasUsed				nvarchar(max) NOT NULL,

	EX_TotalMedia		bigint	NOT NULL,

	EX_TotalSuccess		bigint	NOT NULL,

	EX_TotalFailures	bigint	NOT NULL,

	initFrom		integer	NOT NULL,

	failureReason		varchar(256)	NOT NULL,

	archGrpCopyID			integer	NOT NULL,

	LibraryID		integer	NOT NULL,

	MI_InventoryType	integer	NOT NULL,

	username		    nvarchar(255)	NOT NULL,

	totalWriteTime		integer	NOT NULL,

	noOfStreams		integer	NOT NULL,

	priority	integer	NOT NULL,

	commCellId		integer	NOT NULL,

	appID			integer	NOT NULL,

	failureErrorCode	integer	NOT NULL,

	TotalSize		bigint	NOT NULL,

	fullCycleNum		integer	NOT NULL,

	dataStatus			integer	NOT NULL,

	workFlowId		integer	NOT NULL,

	embeddedObjects	bigint	NOT NULL,

	uncompBytes	bigint	NOT NULL,

	numFiles	bigint	NOT NULL,

	skippedItems	bigint	NOT NULL,

	jobFlags		integer	NOT NULL,

	cloudId			integer	NOT NULL,

	successIndex	bigint	NOT NULL,

	failIndex		bigint	NOT NULL,

	totalBackupSize	bigint	NOT NULL,

	version			integer	NOT NULL,

	fromTime		integer	NOT NULL,

	toTime			integer	NOT NULL,

	subTaskId		integer	NOT NULL,

	otherOpName				nvarchar(max) NOT NULL,

	nwTransBytes	bigint	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMAdminJobAttemptStatsTable]') )
BEGIN
	DROP TABLE #CCM_JMAdminJobAttemptStatsTable
END


CREATE  TABLE   #CCM_JMAdminJobAttemptStatsTable (
	jobId				integer	NOT NULL,

	attemptNum			integer	NOT NULL,

	phaseNum			integer	NOT NULL,

	status				integer	NOT NULL,

	startTime			INTEGER  NOT NULL,

	endTime				INTEGER  NOT NULL,

	elapsedTime			INTEGER  NOT NULL,

	failureReason		varchar(256)	NOT NULL,

	writeTime		integer	NOT NULL,

	commCellId		integer	NOT NULL,

	embeddedObjects	bigint	NOT NULL,

	uncompBytes		bigint	NOT NULL,

	numFiles		bigint	NOT NULL,

	skippedItems	bigint	NOT NULL,

	TotalSize		bigint	NOT NULL,

	nwTransBytes	bigint	NOT NULL,

	totalAllocationTime				integer	NOT NULL,

	totalWaitTimeBeforeAllocation	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobDataLink]') )
BEGIN
	DROP TABLE #CCM_JMJobDataLink
END


CREATE  TABLE   #CCM_JMJobDataLink (
	commCellId		integer	NOT NULL,

	parentJobId		integer	NOT NULL,

	childJobId		integer	NOT NULL,

	parentAppid		integer	NOT NULL,

	childAppid		integer	NOT NULL,

	linkType		integer	NOT NULL,

	childJobStatus		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobOptions]') )
BEGIN
	DROP TABLE #CCM_JMJobOptions
END


CREATE  TABLE   #CCM_JMJobOptions (
	jobId			integer	NOT NULL,

	commCellId		integer	NOT NULL,

	attributeId		integer	NOT NULL,

	attributeName	    	varchar(64)	NOT NULL,

	attributeValueInt	bigint	NOT NULL,

	attributeValue				nvarchar(MAX) NOT NULL,

	id                  INTEGER NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobDataStats]') )
BEGIN
	DROP TABLE #CCM_JMJobDataStats
END


CREATE  TABLE   #CCM_JMJobDataStats (
	jobId			integer	NOT NULL,

	archGrpId		smallint	NOT NULL,

	archGrpCopyId	smallint	NOT NULL,

	dataType		tinyint	NOT NULL,

	opType			tinyint	NOT NULL,

	auxCopyJobId	integer	NOT NULL,

	status			smallint	NOT NULL,

	disabled		integer	NOT NULL,

	appId			integer	NOT NULL,

	commCellId		integer	NOT NULL,	--can be tinyint if it's tinyint in JM tables.

	archCheckEndTime INTEGER  NOT NULL,

	archCheckStatus	tinyint	NOT NULL,

	retentionFlags	integer	NOT NULL,

	manualRetentionEndTime bigint	NOT NULL,

	copiedTime 		INTEGER  NOT NULL,

	agedTime		INTEGER  NOT NULL,

	mediaDeletedTime INTEGER  NOT NULL,

	modifiedTime	INTEGER  NOT NULL,

	sizeOnMedia		bigint	NOT NULL,

	agedBy			bigint	NOT NULL,

	flags			integer	NOT NULL,

	jobSelectionTime	bigint	NOT NULL,

	auxCopyStatus	smallInt DEFAULT -1	NOT NULL,

	unCompSize		bigint DEFAULT -1	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMOracleRACClientsUsed]') )
BEGIN
	DROP TABLE #CCM_JMOracleRACClientsUsed
END


CREATE  TABLE   #CCM_JMOracleRACClientsUsed (
	jobId					integer	NOT NULL,

	commCellId				integer	NOT NULL,

	phaseNumber				integer	NOT NULL,

	attemptNumber			integer	NOT NULL,

	racInstanceId			integer	NOT NULL,

	racHostId				integer	NOT NULL,

	isControlHost			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobInfo]') )
BEGIN
	DROP TABLE #CCM_JMJobInfo
END


CREATE  TABLE   #CCM_JMJobInfo (
	jobId				integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	initFrom		integer	NOT NULL,

	opType			integer	NOT NULL,

	userId			integer	NOT NULL,	-- FK REFERENCE ?????

	clientPriority	integer	NOT NULL,

	opPriority		integer	NOT NULL,

	appPriority		integer	NOT NULL,

	combPriority	integer	NOT NULL,

	currentPhase	integer	NOT NULL,

	jobStartTime	integer	NOT NULL,	-- TIME_T ????

	attemptStartTime integer	NOT NULL,

	serverEndTime	integer	NOT NULL,

	jobElapsedTime	integer	NOT NULL,

	elapsedTime		integer	NOT NULL,

	lastStartOrRun	integer	NOT NULL,

	phaseParams				varchar(max) NOT NULL,

	restartString				varchar(max) NOT NULL,

	startAttempts	integer	NOT NULL,

	runAttempts		integer	NOT NULL,

	state			integer	NOT NULL,

	pendingCause	integer	NOT NULL,

	restartable		integer	NOT NULL,

	appArgs				varchar(max) NOT NULL,

	numOfFailures		integer	NOT NULL,

	failureReason		varchar(256)	NOT NULL,

	preemptable			integer	NOT NULL,

	taskLinkID		integer	NOT NULL,

	percentcomplete		integer	NOT NULL,

	displayState		integer	NOT NULL,

	commCellId		integer	NOT NULL,

	resourcesAllocated	integer	NOT NULL,

	currentContext		integer	NOT NULL,

	libraryList				nvarchar(max) NOT NULL,

	driveList				nvarchar(max) NOT NULL,

	opUsername				nvarchar(max) NOT NULL,

	phaseOnSuccess		integer	NOT NULL,

	interruptedPhase	integer	NOT NULL,

	errorType		integer	NOT NULL,

	licenseVerified		integer	NOT NULL,

	currentPhaseName				nvarchar(max) NOT NULL,

	timeToComplete		integer	NOT NULL,

	lastUpdateFromClient	integer	NOT NULL,

	lastStateChangeTime	bigint	NOT NULL,	-- this column saves the time in milliseconds

	jobCategory		integer	NOT NULL,

	recoveredFromServiceRestart	integer	NOT NULL,

	noOfGUIMonitors		integer	NOT NULL,

	isScheduledAlert		integer	NOT NULL,

	jobBasedAlertId			integer	NOT NULL,

	alertName		nvarchar(128)	NOT NULL,

	shortMediaAgent				nvarchar(max),		-- short version of media agent name NOT NULL

	seqNumber		BIGINT default (0) NOT NULL,	-- sequence number

	activeFile				NVARCHAR(max) NOT NULL,

	guiAlertColorLevel	integer	NOT NULL,

	jobDescription				nvarchar(max) NOT NULL,

	xmlJobInfo				nvarchar(max) NOT NULL,

	subOpType				integer	NOT NULL,

	foreignToken		nvarchar(2048)	NOT NULL,

	preparedJobId			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMAdminJobInfoTable]') )
BEGIN
	DROP TABLE #CCM_JMAdminJobInfoTable
END


CREATE  TABLE   #CCM_JMAdminJobInfoTable (
	jobId				integer	NOT NULL,

	opType				integer	NOT NULL,

	status				integer	NOT NULL,

	servStart			INTEGER  NOT NULL,

	servEnd  			INTEGER  NOT NULL,

	archGrpID			integer	NOT NULL,

	archGrpName				nvarchar(max) NOT NULL,

	AP_NumDays			integer	NOT NULL,

	AP_IsForecast			integer	NOT NULL,

	AP_SeqNum			integer	NOT NULL,

	AC_NewMediaFlag			integer	NOT NULL,

	ER_BkpLevel			integer	NOT NULL,

	ER_DbName				nvarchar(max) NOT NULL,

	ER_Destination				nvarchar(max) NOT NULL,

	ER_SendCount			integer	NOT NULL,

	ER_MediasUsed				nvarchar(max) NOT NULL,

	TotalObjects		bigint	NOT NULL,

	ObjectsDone		bigint	NOT NULL,

	ObjectsFailed		bigint	NOT NULL,

	archGrpCopyID		integer	NOT NULL,

	LibraryID		integer	NOT NULL,

	MI_InventoryType	integer	NOT NULL,

	currentWriteTime	integer	NOT NULL,

	noOfStreams		integer	NOT NULL,

	appID			integer	NOT NULL,

	dependantJobId		integer	NOT NULL,

	workFlowId		integer	NOT NULL,

	srcMediaAgent				nvarchar(max) NOT NULL,

	destMediaAgent				nvarchar(max) NOT NULL,

	drivePoolId			integer	NOT NULL,

	mediaId				integer	NOT NULL,

	sourceJobId			integer	NOT NULL,

	TotalSize		bigint	NOT NULL,

	noOfStreamsAllocated	integer	NOT NULL,

	maxRestarts		integer	NOT NULL,

	restartInterval		integer	NOT NULL,

	embeddedObjects	bigint	NOT NULL,

	uncompBytes	bigint	NOT NULL,

	numFiles	bigint	NOT NULL,

	skippedItems	bigint	NOT NULL,

	writeTime	integer	NOT NULL,

	reportType		integer	NOT NULL,

	cloudId		integer	NOT NULL,

	reportSetId    integer	NOT NULL,

	reportName				nvarchar(max) NOT NULL,

	reportSetName				nvarchar(max) NOT NULL,

	fromTime	integer	NOT NULL,

	toTime		integer	NOT NULL,

	subTaskId		integer	NOT NULL,

	otherOpName				nvarchar(max) NOT NULL,

	nwTransBytes	bigint	NOT NULL,

	commCellId		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMBkpJobInfo]') )
BEGIN
	DROP TABLE #CCM_JMBkpJobInfo
END


CREATE  TABLE   #CCM_JMBkpJobInfo (
	jobId		integer	NOT NULL,

	commcellId		integer	NOT NULL,

	applicationId		integer	NOT NULL,

	numStreams		integer	NOT NULL,

	currentPolicy		integer	NOT NULL,

	targetCopyList				varchar(max) NOT NULL,

	bkpLevel		integer	NOT NULL,

	indexOverride		integer	NOT NULL,

	startNewMedia		integer	NOT NULL,

	compBytes		bigint	NOT NULL,

	unCompBytes		bigint	NOT NULL,

	filesToXfer		bigint	NOT NULL,

	backupTaskId		integer	NOT NULL,

	scanFileFailures	integer	NOT NULL,

	scanFolderFailures	integer	NOT NULL,

	backupFileFailures	integer	NOT NULL,

	backupFolderFailures	integer	NOT NULL,

	shadowCopyId				varchar(MAX) NOT NULL,

	bkpOptions		integer	NOT NULL,	-- Backup Options

	oraSubLevel		integer	NOT NULL,	-- Sub backup level for oracle incremental job

	bkpattributes		bigint	NOT NULL,

	dataPolicy		integer	NOT NULL,

	logPolicy		integer	NOT NULL,

	filesXfered		bigint	NOT NULL,

	currentThroughput	float	NOT NULL,

	averageThroughput	float	NOT NULL,

	filesIndexed		bigint	NOT NULL,

	filesFailedToIndex	bigint	NOT NULL,

	filesSkippedForIndex	bigint	NOT NULL,

	contentIndexDBSize	bigint	NOT NULL,

	totalMediaUsageTime	bigint	NOT NULL,

	mediaAgentName				nvarchar(max) NOT NULL,

	scanType		integer	NOT NULL,

	scanTypeChangeReason	varchar(24),	-- saves the reason why the scan type was changed NOT NULL

	numStreamsAllocated	integer	NOT NULL,

	maxRestarts		integer	NOT NULL,

	restartInterval		integer	NOT NULL,

	cloudId			integer	NOT NULL,

	diffPolicy		integer	NOT NULL,

	targetClientId		integer	NOT NULL,

	unCompBytesToXfer	bigint	NOT NULL,

	secondaryBkpLevel	integer	NOT NULL,

	jobIdActedOn		integer	NOT NULL,

	fromTime			integer	NOT NULL,

	toTime				integer	NOT NULL,

	nwTransBytes		bigint	NOT NULL,

	totSkippedObjects	bigint	NOT NULL,

	bkpAttributesEx		bigint	NOT NULL,

	jobReferenceTime	integer	NOT NULL,

	totReadBytes			bigint	NOT NULL,

	totReadTime				bigint	NOT NULL,

	totPhysicalWriteBytes	bigint	NOT NULL,

	totPhysicalWriteTime	bigint	NOT NULL,

	totNwTransTime			bigint	NOT NULL,

	totSidbLookups			bigint	NOT NULL,

	totSidbLookupTime		bigint	NOT NULL,

	readCurrentThroughput	float	NOT NULL,

	readAverageThroughput	float	NOT NULL,

	writeCurrentThroughput	float	NOT NULL,

	writeAverageThroughput	float	NOT NULL,

	networkCurrentThroughput	float	NOT NULL,

	networkAverageThroughput	float	NOT NULL,

	sidbCurrentLookups		float	NOT NULL,

	sidbAverageLookups		float	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobSnapshotStats]') )
BEGIN
	DROP TABLE #CCM_JMJobSnapshotStats
END


CREATE  TABLE   #CCM_JMJobSnapshotStats (
	jobId					integer	NOT NULL,

	commcellId				integer	NOT NULL,

	materializationStatus	smallint	NOT NULL,

	disabled				integer	NOT NULL,

	materializationJobId	integer	NOT NULL,

	appId					integer	NOT NULL,

	archGrpId				smallint	NOT NULL,

	unPickReason			integer	NOT NULL,

	flags					integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_GRCJMJobDataStatsTracking]') )
BEGIN
	DROP TABLE #CCM_GRCJMJobDataStatsTracking
END


CREATE  TABLE   #CCM_GRCJMJobDataStatsTracking (
	trackingId			BIGINT NOT NULL,

	commCellId			integer	NOT NULL,

	jobId						integer	NOT NULL,

	copyId		smallint	NOT NULL,

	dataType				tinyint	NOT NULL,

	statusChange			tinyint 	NOT NULL,

	createdTime		INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMFailureReasonMsg]') )
BEGIN
	DROP TABLE #CCM_JMFailureReasonMsg
END


CREATE  TABLE   #CCM_JMFailureReasonMsg (
	id					INTEGER NOT NULL,							-- PRIMARY KEY FOR THIS TABLE

	messageId			integer	NOT NULL,	-- The event message Identifier.

	paramNum			integer	NOT NULL,	-- Number of parameters assoc. w/ this message

	errorType			integer	NOT NULL,	-- The type of the error (hardware, software)

	commCellId			integer	NOT NULL,

	jobId				integer	NOT NULL,	-- f-key to JMJobStats(jobId)

	client				nvarchar(255),	-- Name of client who sent the message NOT NULL

	subsystem			nvarchar(255),	-- Name of application who sent the message NOT NULL

	copyId				integer	NOT NULL,	-- copy for which this message is generated

	rcId				integer	NOT NULL,	-- the rcid set for this message

	reservationId		integer	NOT NULL,	-- the reservation id for this message

	flags				integer	NOT NULL,	-- dont know any use right now

	guiAlertColorLevel	integer	NOT NULL,	-- level for gui popups

	clientVersion		integer	NOT NULL,	-- client version

	serverVersion		integer	NOT NULL,	-- server version

	iDA					integer	NOT NULL,	-- ida

	opType				integer	NOT NULL,	-- operation type

	phaseNumber			integer	NOT NULL,	-- phase number

	customMessageId		integer not null default(0),	-- custom (client provided) message id

	failureReasonTime	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMFailureReasonMsgParam]') )
BEGIN
	DROP TABLE #CCM_JMFailureReasonMsgParam
END


CREATE  TABLE   #CCM_JMFailureReasonMsgParam (
	msgId				integer	NOT NULL,	-- Points to JMFailureReasonMsg table

	eventid				integer	NOT NULL,	-- the eventid of the parameter

	position			integer	NOT NULL,	-- Parameter Position in the English Table

	type				integer	NOT NULL,	-- The Type of parameter Stored Here

	size				integer	NOT NULL,	-- The size of the data (in bytes)

	data				nvarchar(1023)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_evMsg]') )
BEGIN
	DROP TABLE #CCM_evMsg
END


CREATE  TABLE   #CCM_evMsg (
	id					INTEGER	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	timeSource     INTEGER  NOT NULL,	-- UNIX time event occured accord. to src computer

	timeServer     INTEGER  NOT NULL,	-- UNIX time when the event was rec'd by the EMS

	severity       integer	NOT NULL,	-- the level EL_INFO, EL_MINOR, EL_MAJOR, EL_CRITICAL

	ack            integer	NOT NULL,	-- Does this event require acknowledgement?

	acked          integer	NOT NULL,	-- Has the event been acknowledged?

	type           integer	NOT NULL,	-- ET_USER or ET_SYSTEM

	paramNum       integer	NOT NULL,	-- Number of parameters assoc. w/ this message

	messageId      integer	NOT NULL,	-- The event message Identifier.

	jobId_h	 integer	NOT NULL,

	jobId_l	 integer	NOT NULL,

	clientID       integer	NOT NULL,	-- f-key to client(id)

	commCellID     integer	NOT NULL,	-- f-key to commCell(id)

	userID         integer	NOT NULL,	-- f-key to users(id)

	subsystemID    integer	NOT NULL,	-- f-key to subsystem(id)

	client         varchar(128)	NOT NULL,

	commCell       varchar(128)	NOT NULL,

	userName       varchar(128)	NOT NULL,

	subsystem      varchar(128)	NOT NULL,

	msgEnglish     varchar(1024)	NOT NULL,

	repeatCount    integer	NOT NULL,

	lastOccurrence INTEGER  NOT NULL,

	nextPost       INTEGER  NOT NULL,

	mediaId					integer	NOT NULL,

	driveId					integer	NOT NULL,

	libraryId				integer	NOT NULL,

	maClientId			integer	NOT NULL,

	entityId		integer	default 0	NOT NULL,

	entityType	integer default 0	NOT NULL,

	anomalous   integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_evParam]') )
BEGIN
	DROP TABLE #CCM_evParam
END


CREATE  TABLE   #CCM_evParam (
	evMsgId				integer	NOT NULL,	-- Points to evMsg table

	position			integer	NOT NULL,	-- Parameter Position in the English Table

	type				integer	NOT NULL,	-- The Type of parameter Stored Here

	size				integer	NOT NULL,	-- The size of the data (in bytes)

	data				nvarchar(MAX),		--Support unlimited GUI Audit message NOT NULL

	eventId				integer	NOT NULL,	-- Event Id of the Message

	commcellId			integer		DEFAULT		2	NOT NULL,	--CN2 change.



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMExportLocation]') )
BEGIN
	DROP TABLE #CCM_MMExportLocation
END


CREATE  TABLE   #CCM_MMExportLocation (
	ExportLocationId	INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	ExportLocation		NVARCHAR(64)	NOT NULL,

	Type				integer	NOT NULL,

	Descript			NVARCHAR(256)	NOT NULL,

	origCCId			integer			NOT NULL,

	GUID				uniqueidentifier ROWGUIDCOL,

	ModifiedTime		integer		DEFAULT		0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMedia]') )
BEGIN
	DROP TABLE #CCM_MMMedia
END


CREATE  TABLE   #CCM_MMMedia (
	MediaId				INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	UniqueId			varchar(300)	NOT NULL,

	BarCode				varchar(256)	NOT NULL,

	MediaTypeId			integer	NOT NULL,

	CreationTime		INTEGER  NOT NULL,

	NumberOfReUses		integer	NOT NULL,

	LastRestoreTime		INTEGER  NOT NULL,

	LastBackupTime		INTEGER  NOT NULL,

	LibraryId			integer	NOT NULL,

	SpareGroupId		integer	NOT NULL,

	LastExportTime		INTEGER  NOT NULL,

	MediaLocation		integer	NOT NULL,

	ExternalGUID		varchar(33)	NOT NULL,

	MediaFlags			integer	NOT NULL,

	IsOMLWritten		integer	NOT NULL,

	MediaStatusReason	integer	NOT NULL,

	ExportLocationId	integer	NOT NULL,

	LastWriteLibraryId	integer	NOT NULL,

	Attributes			integer	NOT NULL,

	ContainerId			integer	NOT NULL,

	OverWriteJobId		bigint	NOT NULL,

	origCCcommCellID	integer	NOT NULL,

	origCCmediaID		integer	NOT NULL,

	Descript				NVARCHAR(MAX)default '' NOT NULL,

	NumberOfSideOverwrites integer	NOT NULL,

	ScheduleRunId		bigint	NOT NULL,

	retentionFlags integer	NOT NULL,

	retentionExpireTime bigint	NOT NULL,

	IsAged				integer	NOT NULL,

	IsInMediaGroup		integer	NOT NULL,

	PinMediaExpireTime				integer	NOT NULL,

	origSpareGroupId					integer	NOT NULL,

	RMSpareStatus							integer	NOT NULL,

	RMSpareStatusUpdateTime		integer	NOT NULL,

	ExtendedAttributes		integer	NOT NULL,

	minRetentionTime bigint	NOT NULL,

	HwEncKey			varchar(114)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMediaSide]') )
BEGIN
	DROP TABLE #CCM_MMMediaSide
END


CREATE  TABLE   #CCM_MMMediaSide (
	MediaSideId			INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	MediaId				integer	NOT NULL,

	SideName			varchar(80)	NOT NULL,

	MediaSideFlags		integer	NOT NULL,

	NumberOfRestores	integer	NOT NULL,

	NumberOfBackups		integer	NOT NULL,

	NumberOfMounts		integer	NOT NULL,

	NumberOfSoftErrors	integer	NOT NULL,

	NumberOfHardErrors	integer	NOT NULL,

	NumberOfReUses		integer	NOT NULL,

	LastRestoreTime		INTEGER  NOT NULL,

	LastBackupTime		INTEGER  NOT NULL,

	TotalSpaceMB		bigint	NOT NULL,

	FreeBytesMB			bigint	NOT NULL,

	LogicalBytesMB		integer	NOT NULL,

	PhysicalBytesMB		integer	NOT NULL,

	IsOMLValid			integer	NOT NULL,

	FailureReason		varchar(64)	NOT NULL,

	ExternalGUID		varchar(33)	NOT NULL,

	IsOMLWritten		integer	NOT NULL,

	isErasable			integer	NOT NULL,

	UploadDataMB		integer	NOT NULL,

	DownloadDataMB		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMVolume]') )
BEGIN
	DROP TABLE #CCM_MMVolume
END


CREATE  TABLE   #CCM_MMVolume (
	VolumeId			INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	VolumeName			varchar(112)	NOT NULL,

	CreationTime		INTEGER  NOT NULL,

	VolumeFlags			integer	NOT NULL,

	VolumeInitialized	integer	NOT NULL,

	FlushBlockSizeKB	integer	NOT NULL,

	NumberOfRestores	integer	NOT NULL,

	NumberOfBackups		integer	NOT NULL,

	NumberOfMounts		integer	NOT NULL,

	NumberOfSoftErrors	integer	NOT NULL,

	NumberOfHardErrors	integer	NOT NULL,

	LastRestoreTime		INTEGER  NOT NULL,

	LastBackupTime		INTEGER  NOT NULL,

	LogicalBytesMB		integer	NOT NULL,

	PhysicalBytesMB		integer	NOT NULL,

	NumberOfActiveFiles	integer	NOT NULL,

	LastFile			integer	NOT NULL,

	RecordingFormatId	integer	NOT NULL,

	ExternalGUID		varchar(33)	NOT NULL,

	OMLVersion			integer	NOT NULL,

	VolumeState			integer	NOT NULL,

	VolumeFullReason	integer	NOT NULL,

	VolumeFullTime		integer	NOT NULL,

	VolumeFullJobId		bigint	NOT NULL,

	origCCcommCellID	integer	NOT NULL,

	origCCvolumeID		integer	NOT NULL,

	MediaId				integer	NOT NULL,

	MediaSideId			integer	NOT NULL,

	Attributes			integer	NOT NULL,

	MediaGroupId		integer	NOT NULL,

	ReformatTime		INTEGER  NOT NULL,

	RMSpareStatus							integer	NOT NULL,

	RMSpareStatusUpdateTime		integer	NOT NULL,

	SIDBStoreId			integer	NOT NULL,

	SiloStatus			integer	NOT NULL,

	CurrMountPathId		integer	NOT NULL,

	FailureErrorCode		integer	NOT NULL,

	MMSpareStatus		integer	NOT NULL,

	LastSizeUpdateTime	INTEGER  NOT null default 0



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMediaGroup]') )
BEGIN
	DROP TABLE #CCM_MMMediaGroup
END


CREATE  TABLE   #CCM_MMMediaGroup (
	MediaGroupId			INTEGER NOT NULL,

	MediaGroupName			varchar(64)	NOT NULL,

	DrivePoolId				integer	NOT NULL,

	SpareGroupId			integer	NOT NULL,

	DesiredMediaTypeId		integer	NOT NULL,

	RecordingFormatId		integer	NOT NULL,

	DataPathId				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMountPath]') )
BEGIN
	DROP TABLE #CCM_MMMountPath
END


CREATE  TABLE   #CCM_MMMountPath (
	MountPathId						integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	MountPathName					NVARCHAR(1024)	NOT NULL,

	MediaSideId						integer	NOT NULL,

	UserName						varchar(1024)	NOT NULL,

	UserPassword					varchar(2048)	NOT NULL,

	IsEnabled						integer	NOT NULL,

	NumberOfWriters					integer	NOT NULL,

	MaxConcurrentWriters			integer	NOT NULL,

	CurrentFileMarker				integer	NOT NULL,

	IsOffline						integer	NOT NULL,

	OfflineReason					integer	NOT NULL,

	MountPathTypeId					integer	NOT NULL,

	OffLineTimeStamp				INTEGER  NOT NULL,

	origCCcommCellID				integer	NOT NULL,

	origCCmediaSideID				integer	NOT NULL,

	MaxDataToWriteMB				integer	NOT NULL,

	MagneticSpaceRsrvInMB			integer	NOT NULL,

	Attribute						integer	NOT NULL,

	MasterPoolId					integer	NOT NULL,

	LibraryId						integer	NOT NULL,

	RMStatus						integer	NOT NULL,

	RMStatusUpdateTime				integer	NOT NULL,

	OrigCCMountPathId				integer	NOT NULL,	-- On upgrade set this value to 0 and during

	MagneticChunkFileIncrSizeMB		integer	NOT NULL,

	MountPathOfflineReasonEventId	integer	NOT NULL,

	StagingMountPathId				integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDevice]') )
BEGIN
	DROP TABLE #CCM_MMDevice
END


CREATE  TABLE   #CCM_MMDevice (
	DeviceId				INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	AliasName				NVARCHAR(128)	NOT NULL,

	DeviceEnabled			integer	NOT NULL,

	DeviceBroken			integer	NOT NULL,

	DeviceTypeId			integer	NOT NULL,

	NumRestoresLifeTime		integer	NOT NULL,

	NumBackupsLifeTime		integer	NOT NULL,

	NumMountsLifeTime		integer	NOT NULL,

	NumErrsLifeTime			integer	NOT NULL,

	MinutesUsedLifeTime		integer	NOT NULL,

	OfflineReason			integer	NOT NULL,

	SNRPartitionId			integer	NOT NULL,

	DeviceStatus			integer	NOT NULL,

	DRUId					integer	NOT NULL,

	DeviceAttributes		integer	NOT NULL,

	DRUDeviceId				varchar(256)	NOT NULL,

	RMStatus								integer	NOT NULL,

	RMStatusUpdateTime			integer	NOT NULL,

	origCCId			integer	NOT NULL,

	origDeviceId			integer	NOT NULL,

	DisplayDeviceTypeId			integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDeviceController]') )
BEGIN
	DROP TABLE #CCM_MMDeviceController
END


CREATE  TABLE   #CCM_MMDeviceController (
	DeviceControllerId			INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	ClientId					integer	NOT NULL,

	DeviceId					integer	NOT NULL,

	DeviceControllerActive		integer	NOT NULL,

	DeviceControllerEnabled		integer	NOT NULL,

	SNRVolumeId					integer	NOT NULL,

	UseCount					integer	NOT NULL,

	UserName					varchar(1024)	NOT NULL,

	UserPassword				varchar(2048)	NOT NULL,

	Folder						varchar(1024)	NOT NULL,

	DeviceMounted				integer	NOT NULL,

	DeviceAccessible			integer	NOT NULL,

	VolumeRecoveryStatus		integer	NOT NULL,

	VolumeRecoveryTime			integer	NOT NULL,

	VolumeScsiReserved			integer	NOT NULL,

	DeviceAccessType			integer	NOT NULL,

	RMStatus								integer	NOT NULL,

	RMStatusUpdateTime			integer	NOT NULL,

	CredentialAssocId			integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMountPathToStorageDevice]') )
BEGIN
	DROP TABLE #CCM_MMMountPathToStorageDevice
END


CREATE  TABLE   #CCM_MMMountPathToStorageDevice (
	MountPathId		integer	NOT NULL,

	CenteraId		integer	NOT NULL,

	DeviceId		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMNDMPHostInfo]') )
BEGIN
	DROP TABLE #CCM_MMNDMPHostInfo
END


CREATE  TABLE   #CCM_MMNDMPHostInfo (
	NDMPHostId				INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	Login					varchar(1024)	NOT NULL,

	Password				varchar(2048)	NOT NULL,

	ListenPort				integer	NOT NULL,

	FirmwareRevision		varchar(32)	NOT NULL,

	OSType					integer	NOT NULL,

	AuthenticationScheme	integer	NOT NULL,

	ProtocolType			integer	NOT NULL,

	ProtocolRevision		varchar(32)	NOT NULL,

	CapabilityFlags			integer	NOT NULL,

	ClientId				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMContainer]') )
BEGIN
	DROP TABLE #CCM_MMContainer
END


CREATE  TABLE   #CCM_MMContainer (
	ContainerId				INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	ContainerName			NVARCHAR(256)	NOT NULL,

	Flag					integer	NOT NULL,

	Capacity				integer	NOT NULL,

	MediaType				integer	NOT NULL,

	Descript				NVARCHAR(3072)	NOT NULL,

	CreationTime			INTEGER  NOT NULL,

	IsEmpty					integer	NOT NULL,

	ContainerEmptyTime		INTEGER  NOT NULL,

	TrackingId				NVARCHAR(256) default ''	NOT NULL,

	SIDBStoreId				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMCenteraInfo]') )
BEGIN
	DROP TABLE #CCM_MMCenteraInfo
END


CREATE  TABLE   #CCM_MMCenteraInfo (
	CenteraId					INTEGER NOT NULL,			--PRIMARY KEY FOR THIS TABLE

	FriendlyName					varchar(512)	NOT NULL,

	ClusterName					varchar(512)	NOT NULL,

	ClusterId					varchar(512)	NOT NULL,

	Version						varchar(512)	NOT NULL,

	CapacityMB_h	 integer	NOT NULL,

	CapacityMB_l	 integer	NOT NULL,

	FreeSpaceMB_h	 integer	NOT NULL,

	FreeSpaceMB_l	 integer	NOT NULL,

	ReplicateAddress			varchar(512)	NOT NULL,

	ApiRetryInterval			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMCenteraAccessNode]') )
BEGIN
	DROP TABLE #CCM_MMCenteraAccessNode
END


CREATE  TABLE   #CCM_MMCenteraAccessNode (
	AccessNodeId			INTEGER NOT NULL,			--PRIMARY KEY FOR THIS TABLE

	NetHostName				varchar(1024)	NOT NULL,

	CenteraId				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMHost]') )
BEGIN
	DROP TABLE #CCM_MMHost
END


CREATE  TABLE   #CCM_MMHost (
	ClientId					integer	NOT NULL,

	MmHostType					integer	NOT NULL,

	MmHostSoftState				integer	NOT NULL,

	MmHostEnabled				integer	NOT NULL,

	OfflineReason				integer	NOT NULL,

	OfflineTimeStamp			INTEGER  NOT NULL,

	PatchLevel					integer	NOT NULL,

	IndexCacheUser				varchar(1024)	NOT NULL,

	IndexCachePassword			varchar(2048)	NOT NULL,

	IndexCachePathName			varchar(1024)	NOT NULL,

	IsIndexShared				integer	NOT NULL,

	Attribute					integer	NOT NULL,

	ScanIntervalInSec			integer	NOT NULL,

	Descript				NVARCHAR(MAX)default '' NOT NULL,

	MaxReservations				integer	NOT NULL,

	RMStatus							integer	NOT NULL,

	RMStatusUpdateTime		integer	NOT NULL,

	RolesBitMask			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxAccessPath]') )
BEGIN
	DROP TABLE #CCM_IdxAccessPath
END


CREATE  TABLE   #CCM_IdxAccessPath (
	IdxAccessPathId			INTEGER NOT NULL,

	IdxCacheId				integer	NOT NULL,

	ClientId				integer	NOT NULL,

	Path					varchar(1024)	NOT NULL,

	Username				varchar(1024)	NOT NULL,

	Password				varchar(2048)	NOT NULL,

	Enabled					integer	NOT NULL,

	SoftState				integer	NOT NULL,

	OfflineReason			integer	NOT NULL,

	Priority				integer	NOT NULL,

	LocalIndexTimeStamp		integer	NOT NULL,

	ActualDaysIndexRetain		integer	NOT NULL,

	Flags					integer	NOT NULL,

	AgeingNoOfDays			integer	NOT NULL,

	AgeingPercentDiskspace	integer	NOT NULL,

	DiskFreeThresholdMB		integer	NOT NULL,

	DiskFreeWarningThreshholdMB	integer	NOT NULL,

	TotalCapacityMB			integer	NOT NULL,

	FreeDiskSpaceMB			integer Default 0	NOT NULL,

	DiskUsageMB			integer Default 0	NOT NULL,

	DiskUsageLastChecked		integer Default 0	NOT NULL,

	StagingCachePath		varchar(1024)	NOT NULL,

	VolumeGUID			varchar(1024)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMLibrary]') )
BEGIN
	DROP TABLE #CCM_MMLibrary
END


CREATE  TABLE   #CCM_MMLibrary (
	LibraryId				INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	LibraryName				varchar(128)	NOT NULL,

	AliasName				NVARCHAR(128)	NOT NULL,

	LibrarySoftState		integer	NOT NULL,

	LibraryEnabled			integer	NOT NULL,

	LibraryBroken			integer	NOT NULL,

	LibraryTypeId			integer	NOT NULL,

	BarCodeReaderPresent	integer	NOT NULL,

	LibraryInstallTime		INTEGER  NOT NULL,

	LowWaterMarkMB			integer	NOT NULL,

	LibraryLicenseType		integer	NOT NULL,

	LibraryVendor			varchar(16)	NOT NULL,

	LibraryModel			varchar(32)	NOT NULL,

	FirmwareRevision		varchar(32)	NOT NULL,

	SerialNumber			varchar(32)	NOT NULL,

	WWNNumber				varchar(64)	NOT NULL,

	FiberChannelPort		integer	NOT NULL,

	NumberOfMounts			integer	NOT NULL,

	LastServiceTime			INTEGER  NOT NULL,

	DriveCount				integer	NOT NULL,

	BaseAddress				integer	NOT NULL,

	ExternalGUID			varchar(33)	NOT NULL,

	PrivateData				varchar(256)	NOT NULL,

	LibraryAttribute		integer	NOT NULL,

	MountTimeoutSec			integer	NOT NULL,

	UnmountTimeoutSec		integer	NOT NULL,

	NumberOfSoftErrors		integer	NOT NULL,

	NumberOfHardErrors		integer	NOT NULL,

	DefaultMediaTypeId		integer	NOT NULL,

	InventoryInProgress		integer	NOT NULL,

	IsConvertedToSited		integer	NOT NULL,

	LastFullInventoryTime	integer	NOT NULL,

	InventoryJobId_h	 integer	NOT NULL,

	InventoryJobId_l	 integer	NOT NULL,

	LibraryStatusReason		integer	NOT NULL,

	OfflineTimeStamp		INTEGER  NOT NULL,

	UseWithinDaysInSec		INTEGER  NOT NULL,

	DriveCleanIntervalInSec INTEGER  NOT NULL,

	VMSDirection			integer	NOT NULL,

	CacheMountPeriodInSec	integer	NOT NULL,

	StdAlnMedRetentionTime	INTEGER  NOT NULL,

	SlotBaseAddress			integer	NOT NULL,

	NumberOfMailSlots		integer	NOT NULL,

	TURIntervalInSec		integer	NOT NULL,

	ConfigParams			varchar(256)	NOT NULL,

	Descript				NVARCHAR(MAX)default '' NOT NULL,

	StdAlnChkIntervalInSec	INTEGER  NOT NULL,

	StdAlnNextChkTime		INTEGER  NOT NULL,

	ReadRetryIntervalInSec	INTEGER  NOT NULL,

	ReadRetryAttempts		integer	NOT NULL,

	RestrictActivity		integer	NOT NULL,

	LibraryStatusEventId	integer	NOT NULL,

	StartVMSElementAddress	integer	NOT NULL,

	ExtendedAttributes		integer	NOT NULL,

	ThresholdPercentage		integer	NOT NULL,

	ThresholdVariation		integer	NOT NULL,

	LibrarySubType			integer	NOT NULL,

	VTLType					integer	NOT NULL,

	origCCId				integer	NOT NULL,

	origLibraryId			integer	NOT NULL,

	LibSvrConfig			XML,

	WarningWaterMark		integer	NOT NULL,

	OutOfSpaceAlertInDays		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMasterPool]') )
BEGIN
	DROP TABLE #CCM_MMMasterPool
END


CREATE  TABLE   #CCM_MMMasterPool (
	MasterPoolId			INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	MasterPoolName			NVARCHAR(64)	NOT NULL,

	MasterPoolSoftState		integer	NOT NULL,

	MasterPoolEnabled		integer	NOT NULL,

	LibraryId				integer	NOT NULL,

	TotalDrives				integer	NOT NULL,

	ReservedDrives			integer	NOT NULL,

	MaxSwitchForHost		integer	NOT NULL,

	Descript				NVARCHAR(MAX)default '' NOT NULL,

	DriveTypeId				integer	NOT NULL,

	RMStatus					integer	NOT NULL,

	RMStatusUpdateTime		integer	NOT NULL,

	origCCId			integer	NOT NULL,

	origMasterPoolId		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDrivePool]') )
BEGIN
	DROP TABLE #CCM_MMDrivePool
END


CREATE  TABLE   #CCM_MMDrivePool (
	DrivePoolId			INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	DrivePoolName		NVARCHAR(64)	NOT NULL,

	DrivePoolSoftState	integer	NOT NULL,

	DrivePoolEnabled	integer	NOT NULL,

	ReservedDrives		integer	NOT NULL,

	DrivePoolType		integer	NOT NULL,

	MaxDrivesToSwitch	integer	NOT NULL,

	CopyMgrAccessPath   varchar(64)	NOT NULL,

	CopyManagerCtrlId	integer	NOT NULL,

	CostCategoryId		integer	NOT NULL,

	Descript				NVARCHAR(MAX)default '' NOT NULL,

	ClientId			integer	NOT NULL,

	MasterPoolId		integer	NOT NULL,

	NDMPHostId			integer	NOT NULL,

	RMStatus				integer	NOT NULL,

	RMStatusUpdateTime		integer	NOT NULL,

	origCCId			integer	NOT NULL,

	origDrivePoolId			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMLibraryController]') )
BEGIN
	DROP TABLE #CCM_MMLibraryController
END


CREATE  TABLE   #CCM_MMLibraryController (
	LibraryControllerId				INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	LibraryControllerName			varchar(144)	NOT NULL,

	ClientId						integer	NOT NULL,

	LibraryControllerSoftState		integer	NOT NULL,

	LibraryControllerActive			integer	NOT NULL,

	LibraryControllerType			integer	NOT NULL,

	LibraryControllerEnabled		integer	NOT NULL,

	LibraryId						integer	NOT NULL,

	ConnectionType					integer	NOT NULL,

	SCSIId							varchar(32)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlVersion]') )
BEGIN
	DROP TABLE #CCM_sqlVersion
END


CREATE  TABLE   #CCM_sqlVersion (
	id				INTEGER NOT NULL,

	commCellId		integer not null,

	type			integer	NOT NULL,

	major			integer not null,

	minor			integer 	NOT NULL,	--default 0,

	build			integer 	NOT NULL,	--default 0,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlServer]') )
BEGIN
	DROP TABLE #CCM_sqlServer
END


CREATE  TABLE   #CCM_sqlServer (
	instanceId		integer not null,			-- PRIMARY KEY FOR THIS TABLE

	commCellId		integer not null,

	serverName		varchar(128)	NOT NULL,

	sqlVersionId	integer not null,

	sa				varchar(128)	NOT NULL,

	saPassword		varchar(512)	NOT NULL,

	undoFile		varchar(1024)	NOT NULL,

	addTime			integer	NOT NULL,

	removalTime		integer default 0	NOT NULL,

	deleteFlag		integer default 0	NOT NULL,

	sqlNTAccount	varchar(256)	NOT NULL,

	sqlNTPassword	varchar(512)	NOT NULL,

	sqlServiceName	varchar(256)	NOT NULL,

	flags			integer default 0	NOT NULL,

	clientId		integer default 1	NOT NULL,	-- Default client setting to maintain foreign key integrity!



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlDatabase]') )
BEGIN
	DROP TABLE #CCM_sqlDatabase
END


CREATE  TABLE   #CCM_sqlDatabase (
	backupSetId			integer not null,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlServerId			integer not null,

	applicationNumber	integer	NOT NULL,

	databaseId			integer	NOT NULL,

	databaseName		varchar(128)	NOT NULL,

	creationTime		DATETIME,

	streams				integer default 1	NOT NULL,

	maxStreams			integer default 1	NOT NULL,

	allowFlags			integer	NOT NULL,

	addTime				integer	NOT NULL,

	removalTime			integer default 0	NOT NULL,

	deleteFlag			integer default 0	NOT NULL,

	systemFlags			integer default 0	NOT NULL,

	logStreams			integer default 1	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileGroup]') )
BEGIN
	DROP TABLE #CCM_sqlFileGroup
END


CREATE  TABLE   #CCM_sqlFileGroup (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlDatabaseId		integer not null,

	applicationNumber	integer	NOT NULL,

	groupId				integer	NOT NULL,

	fileGroupName		varchar(128)	NOT NULL,

	streams				integer default 1	NOT NULL,

	maxStreams			integer	default 1	NOT NULL,

	addTime				integer	NOT NULL,

	removalTime			integer default 0	NOT NULL,

	deleteFlag			integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFile]') )
BEGIN
	DROP TABLE #CCM_sqlFile
END


CREATE  TABLE   #CCM_sqlFile (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlFileGroupId		integer not null,

	fileId				integer	NOT NULL,

	physicalName		varchar(260)	NOT NULL,

	logicalName			varchar(128)	NOT NULL,

	size				integer	NOT NULL,

	maxSize				integer	NOT NULL,

	addTime				integer	NOT NULL,

	removalTime			integer default 0	NOT NULL,

	deleteFlag			integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlBackupSet]') )
BEGIN
	DROP TABLE #CCM_sqlBackupSet
END


CREATE  TABLE   #CCM_sqlBackupSet (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlDatabaseId		integer	NOT NULL,

	backupSetId			integer	NOT NULL,

	name				varchar(128)	NOT NULL,

	description			varchar(255)	NOT NULL,

	userName			varchar(128)	NOT NULL,

	vendorId			integer	NOT NULL,

	sqlVersionId		integer not null,

	mtfVersionId		integer not null,

	timeZone			integer	NOT NULL,

	galaxyStartTime		integer	NOT NULL,

	galaxyFinishTime	integer	NOT NULL,

	compatibility		integer	NOT NULL,

	dbVersion			integer	NOT NULL,

	backupSize			varchar(32)	NOT NULL,

	mediaSetId			integer	NOT NULL,

	streams				integer	NOT NULL,

	jobId_h	 integer  default 0	NOT NULL,

	jobId_l	 integer  default 0	NOT NULL,

	sqlFileSubClientId	integer default 0	NOT NULL,	-- if not zero, key to SqlFileSubClient Table



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlLSNs]') )
BEGIN
	DROP TABLE #CCM_sqlLSNs
END


CREATE  TABLE   #CCM_sqlLSNs (
	sqlBackupSetId		integer not null,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlDatabaseId		integer not null,

	startTime			DATETIME,

	finishTime			DATETIME,

	backupType			integer	NOT NULL,

	firstLSN			varchar(32)	NOT NULL,

	lastLSN				varchar(32)	NOT NULL,

	checkpointLSN		varchar(32)	NOT NULL,

	fullBackupLSN		varchar(32)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlArchiveSet]') )
BEGIN
	DROP TABLE #CCM_sqlArchiveSet
END


CREATE  TABLE   #CCM_sqlArchiveSet (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlBackupSetId		integer not null,

	mediaSetId			integer	NOT NULL,

	sequenceNumber		integer	NOT NULL,

	archiveGroup		integer	NOT NULL,

	archiveFile			integer	NOT NULL,

	bIsTombstoned		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlBackupFile]') )
BEGIN
	DROP TABLE #CCM_sqlBackupFile
END


CREATE  TABLE   #CCM_sqlBackupFile (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlFileGroupId		integer not null,

	sqlBackupSetId		integer not null,

	number				integer	NOT NULL,

	physicalName		varchar(260)	NOT NULL,

	logicalName			varchar(128)	NOT NULL,

	physicalDrive		varchar(260)	NOT NULL,

	pageSize			integer	NOT NULL,

	pageCount			integer	NOT NULL,

	type				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileSubClient]') )
BEGIN
	DROP TABLE #CCM_sqlFileSubClient
END


CREATE  TABLE   #CCM_sqlFileSubClient (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlDatabaseId		integer not null,

	applicationNumber	integer not null,		-- points to the APP_Application table but not foreign constraint is created for it!

	subClientName		varchar(128)	NOT NULL,

	streams				integer default 1	NOT NULL,

	maxStreams			integer	default 1	NOT NULL,

	flags				integer default 0	NOT NULL,

	sqlFileSubClientGroupId		integer default 0	NOT NULL,	-- points to the sqlFileSubClientGroup entry that is the root of the list, no foreign index!



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileSubClientGroup]') )
BEGIN
	DROP TABLE #CCM_sqlFileSubClientGroup
END


CREATE  TABLE   #CCM_sqlFileSubClientGroup (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlFileSubClientId	integer not null,		-- Parent

	sqlFileId			integer default 0	NOT NULL,	-- requires sqlFileGroupId to be set

	sqlFileGroupId		integer default 0	NOT NULL,	-- sqlFileId can be set or 0 to indicate include the entire file group

	nextId				integer default 0	NOT NULL,	-- points to next sqlFileSubClientGroup Record, network access



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlLogMarkNames]') )
BEGIN
	DROP TABLE #CCM_sqlLogMarkNames
END


CREATE  TABLE   #CCM_sqlLogMarkNames (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	commCellId			integer not null,

	sqlDatabaseId		integer not null,

	name				varchar(64)	NOT NULL,

	description			varchar(255)	NOT NULL,

	lsn					varchar(32)	NOT NULL,

	markTime			DATETIME,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlNames]') )
BEGIN
	DROP TABLE #CCM_sqlNames
END


CREATE  TABLE   #CCM_sqlNames (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	sqlId				integer	NOT NULL,

	name				varchar(1024)	NOT NULL,

	type				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlNames2]') )
BEGIN
	DROP TABLE #CCM_sqlNames2
END


CREATE  TABLE   #CCM_sqlNames2 (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	sqlId				integer	NOT NULL,

	name				nvarchar(1024)	NOT NULL,

	type				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlDbBackupInfo]') )
BEGIN
	DROP TABLE #CCM_sqlDbBackupInfo
END


CREATE  TABLE   #CCM_sqlDbBackupInfo (
	id							INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	backup_set_id				integer	NOT NULL,

	majorVersion				integer	NOT NULL,

	minorVersion				integer	NOT NULL,

	buildVersion				integer	NOT NULL,

	database_creation_date		integer	NOT NULL,

	backup_start_Date			integer	NOT NULL,

	backup_finish_Date			integer	NOT NULL,

	type						char(1)	NOT NULL,

	instanceId					integer	NOT NULL,

	appId						integer	NOT NULL,

	backup_size					bigint	NOT NULL,

	dbId						integer	NOT NULL,

	first_lsn					varchar(32)	NOT NULL,

	last_lsn					varchar(32)	NOT NULL,

	checkpoint_lsn				varchar(32)	NOT NULL,

	full_bkup_lsn				varchar(32)	NOT NULL,

	sqlNameId					integer	NOT NULL,

	sqlLastLogBackup			integer	NOT NULL,

	sqlVssFullbackupTime		varchar(64) NULL,

	is_copy						integer	NOT NULL,

	backupmethod				integer	NOT NULL,

	backupVendor				integer	NOT NULL,

	jobId						integer	NOT NULL,

	replica_id					uniqueidentifier NULL,

	group_database_id			uniqueidentifier NULL,

	first_recovery_fork_guid	uniqueidentifier NULL,

	last_recovery_fork_guid		uniqueidentifier NULL,

	differential_base_guid		uniqueidentifier NULL,

	database_guid				uniqueidentifier NULL,

	fork_point_lsn				varchar(32),

	differential_base_lsn		varchar(32),

	compressed_backup_size		varchar(32),

	begins_log_chain			char(1) NULL,

	has_backup_checksums		char(1) NULL,

	database_bkup_lsn			varchar(32)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlArchiveInfo]') )
BEGIN
	DROP TABLE #CCM_sqlArchiveInfo
END


CREATE  TABLE   #CCM_sqlArchiveInfo (
	sqlDbBackupFileId		integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	commCellId				integer	NOT NULL,

	aFileId					integer	NOT NULL,

	aFileOffset				bigint	NOT NULL,

	aGroupId				integer	NOT NULL,

	appId					integer	NOT NULL,

	DbFile				nvarchar(MAX)NULL,

	backupJobId				integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileBackupInfo]') )
BEGIN
	DROP TABLE #CCM_sqlFileBackupInfo
END


CREATE  TABLE   #CCM_sqlFileBackupInfo (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	sqlDbBackupInfoId	integer not null,

	number				integer	NOT NULL,

	pageSize			bigint	NOT NULL,

	pageCount			integer	NOT NULL,

	type				integer	NOT NULL,

	sqlNameFgId			integer	NOT NULL,

	sqlNamePhyId		integer	NOT NULL,

	sqlNameLogId		integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlLogMarks]') )
BEGIN
	DROP TABLE #CCM_sqlLogMarks
END


CREATE  TABLE   #CCM_sqlLogMarks (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	dbId				integer not null,

	instanceId			integer not null,

	dbName				nvarchar(128)	NOT NULL,

	name				nvarchar(64)	NOT NULL,

	description			nvarchar(255)	NOT NULL,

	lsn					varchar(32)	NOT NULL,

	markTime			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_oracleDataFiles]') )
BEGIN
	DROP TABLE #CCM_oracleDataFiles
END


CREATE  TABLE   #CCM_oracleDataFiles (
	id						INTEGER NOT NULL,							-- serial field for unqiue key and tablespace id

	name					varchar(2048),	-- Same as Job Manager jobID NOT NULL

	tblId					integer	NOT NULL,	-- TableSpace which this data file belongs to

	instId					integer	NOT NULL,	-- Instance Id to joing with AppManager Instance properties

	bkpNode					varchar(64),	-- Oracle Parallel Server Node NOT NULL

	status					integer	NOT NULL,	-- Status of Tablespace  ONLINE, OFFLINE, READ_ONLY

	created					INTEGER  NOT NULL,	-- Time at which Tablespace was inserted into table

	deleteFlag				integer	NOT NULL,	-- 0 = not deleted, 1 = deleted

	deleted			    	INTEGER  NOT NULL,	-- Time at which Tablespace was deleted

	modified				INTEGER  NOT NULL,	-- last time tablespace was updated

	opType					integer	NOT NULL,	-- type of entry, for browse or for backup

	backupsetId				integer	NOT NULL,	-- Galaxy BackupSetId

	maxDBdataSize			bigint	NOT NULL,	-- Maximum database size

	freeDBDataSize			bigint	NOT NULL,	-- Availabl space for data

	underDBDir				integer	NOT NULL,

	contType				integer	NOT NULL,

	totalPages				integer	NOT NULL,

	isAccessible			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_oracleTableSpaces]') )
BEGIN
	DROP TABLE #CCM_oracleTableSpaces
END


CREATE  TABLE   #CCM_oracleTableSpaces (
	id                  INTEGER NOT NULL,                     	-- serial field for unqiue key and tablespace id

	name                varchar(64),	-- Same as Job Manager jobID NOT NULL

	instId              integer	NOT NULL,	-- Instance Id to joing with AppManager Instance properties

	bkpNode             varchar(64),	-- Oracle Parallel Server Node NOT NULL

	status              integer	NOT NULL,	-- Status of Tablespace  ONLINE, OFFLINE, READ_ONLY

	created             INTEGER  NOT NULL,	-- Time at which Tablespace was inserted into table

	deleteFlag          integer	NOT NULL,	-- 0 = not deleted, 1 = deleted

	deleted             INTEGER  NOT NULL,	-- Time at which Tablespace was deleted

	modified            INTEGER  NOT NULL,	-- last time tablespace was updated

	opType              integer	NOT NULL,	-- type of entry, for browse or for backup

	backupsetId         integer	NOT NULL,	-- Galaxy BackupSetId

	tablespaceId        integer	NOT NULL,	-- DB2 tablespaceId

	maxDBdataSize       bigint	NOT NULL,	-- Maximum database size

	freeDBDataSize      bigint	NOT NULL,	-- Availabl space for data

	pdbId		integer default 0	NOT NULL,	--establishes relationship between OraclePDBs and OracleTablespaces (default value 0)

	highwatermark       integer default 0	NOT NULL,	--Store high watermark value for DB2 tablespaces.



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_oracleObjects]') )
BEGIN
	DROP TABLE #CCM_oracleObjects
END


CREATE  TABLE   #CCM_oracleObjects (
	id						INTEGER NOT NULL,							-- serial field for unqiue key

	subClientId				integer	NOT NULL,

	taskId					bigint	NOT NULL,	-- restore task id, only used for restore set type

	instId					integer	NOT NULL,	-- Instance Id to joing with AppManager Instance properties

	type					integer	NOT NULL,	-- TABLESPACE or DATAFILE

	parentId				integer	NOT NULL,	-- Parent Id, if this object has parent

	objId					integer	NOT NULL,	-- TableSpace which this data file belongs to

	setType					integer	NOT NULL,	-- 0 = do not backup, 1 = backup

	actionType				integer	NOT NULL,	-- Type of action: 0 - remove, 1 - change, 2 - add.

	name					varchar(2048),	-- The path of the new container for redirection. NOT NULL

	underDBDir				integer	NOT NULL,

	contType				integer	NOT NULL,

	totalPages				integer	NOT NULL,

	isAccessible			integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_OraclePluggableDBs]') )
BEGIN
	DROP TABLE #CCM_OraclePluggableDBs
END


CREATE  TABLE   #CCM_OraclePluggableDBs (
	pdbId               INTEGER NOT NULL,                     	-- serial field for unqiue key and tablespace id

	name                varchar(64),	-- Same as Job Manager jobID NOT NULL

	instId              integer	NOT NULL,	-- Instance Id to joing with AppManager Instance properties

	created             INTEGER  NOT NULL,	-- Time at which Tablespace was inserted into table

	deleteFlag          integer	NOT NULL,	-- 0 = not deleted, 1 = deleted

	deleted             INTEGER  NOT NULL,	-- Time at which Oracle PDB was deleted

	modified            INTEGER  NOT NULL,	-- last time tablespace was updated

	opType              integer	NOT NULL,	-- type of entry, for browse or for backup

	dbAttributes		xml,			    	-- Attributes of DB

	dbId				bigint					NOT NULL,	--dbId of the PDB



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybArchFileInfo]') )
BEGIN
	DROP TABLE #CCM_sybArchFileInfo
END


CREATE  TABLE   #CCM_sybArchFileInfo (
	id INTEGER NOT NULL,

	commCellId integer	NOT NULL,

	archFileId integer	NOT NULL,

	sybInstanceId integer	NOT NULL,

	sybSubclientId integer	NOT NULL,

	sybDatabaseId integer	NOT NULL,

	sybDatabaseName varchar(64)	NOT NULL,

	sybBackupJobId_h	 integer	NOT NULL,

	sybBackupJobId_l	 integer	NOT NULL,

	stream integer	NOT NULL,

	maxStream integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybTransLog]') )
BEGIN
	DROP TABLE #CCM_sybTransLog
END


CREATE  TABLE   #CCM_sybTransLog (
	id INTEGER NOT NULL,

	sybArchFileId	integer	NOT NULL,

	startTime	integer	NOT NULL,

	finishTime	integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybSystemDevices]') )
BEGIN
	DROP TABLE #CCM_sybSystemDevices
END


CREATE  TABLE   #CCM_sybSystemDevices (
	id INTEGER NOT NULL,

	sybBackupJobId_h integer	NOT NULL,

	sybBackupJobId_l integer	NOT NULL,

	commCellId    integer	NOT NULL,

	sybInstanceId integer	NOT NULL,

	sybSubclientId integer	NOT NULL,

	sybDatabaseId integer	NOT NULL,

	sybDatabaseName varchar(64)	NOT NULL,

	sybDevNumber integer	NOT NULL,

	sybDevLogicalName varchar(32)	NOT NULL,

	sybDevPhyName varchar(127)	NOT NULL,

	sybDevSize integer	NOT NULL,

	sybDevStatus integer	NOT NULL,

	sybDevCtrlType integer	NOT NULL,

	sybDevHigh integer	NOT NULL,

	sybDevLow integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybSystemUsages]') )
BEGIN
	DROP TABLE #CCM_sybSystemUsages
END


CREATE  TABLE   #CCM_sybSystemUsages (
	id INTEGER NOT NULL,

	sybDevId integer	NOT NULL,

	sybBackupJobId_h integer	NOT NULL,

	sybBackupJobId_l integer	NOT NULL,

	commCellId    integer	NOT NULL,

	sybInstanceId integer	NOT NULL,

	sybSubclientId integer	NOT NULL,

	sybDatabaseId integer	NOT NULL,

	sybDatabaseName varchar(64)	NOT NULL,

	sysSysLstart integer	NOT NULL,

	sybSysVstart integer	NOT NULL,

	sybSysVsize integer	NOT NULL,

	sybSysSegMap integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LicUsage]') )
BEGIN
	DROP TABLE #CCM_LicUsage
END


CREATE  TABLE   #CCM_LicUsage (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	Name			    nvarchar(255)	NOT NULL,

	CId					integer	NOT NULL,

	LicType				integer	NOT NULL,

	AppType				integer	NOT NULL,

	OpType				char(25)	NOT NULL,

	OpTimeUTC			datetime,

	TokensUsed			integer	NOT NULL,

	Eval				integer	NOT NULL,

	ExpiryDateUTC		datetime,

	ReleaseId			integer	NOT NULL,

	EncryptedField		varchar(2048)	NOT NULL,

	SimOSID				integer	NOT NULL,	-- simOsId from simpackagev2 to get rid of simpkg, pm and scav2 tbls

	Build				varchar(32),	-- Buildid from simclientappsv2 NOT NULL

	InstallFlag			integer DEFAULT 0	NOT NULL,	-- This is for storing if the install is for VM(Parags req)

	UserID				integer DEFAULT 0	NOT NULL,

	UsedCapacity		float	DEFAULT 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LicUsageHistory]') )
BEGIN
	DROP TABLE #CCM_LicUsageHistory
END


CREATE  TABLE   #CCM_LicUsageHistory (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	LicUsageId			integer	NOT NULL,

	Name				nvarchar(255)	NOT NULL,

	CId					integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	LicType				integer	NOT NULL,

	AppType				integer	NOT NULL,

	OpType				char(25)	NOT NULL,

	OpTimeUTC			datetime,

	TokensUsed			integer	NOT NULL,

	Eval				integer	NOT NULL,

	ExpiryDateUTC		datetime,

	ReleaseId			integer	NOT NULL,

	EncryptedField		varchar(2048)	NOT NULL,

	CreateTimeUTC		datetime,

	SimOSID				integer	NOT NULL,	-- simOsId from simpackagev2 to get rid of simpkg, pm and scav2 tbls

	Build				varchar(32),	-- Buildid from simclientappsv2 NOT NULL

	InstallFlag			integer DEFAULT 0	NOT NULL,	-- This is for storing if the install is for VM(Parags req)

	UserID				integer DEFAULT 0	NOT NULL,

	UsedCapacity		float	DEFAULT 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LicAal]') )
BEGIN
	DROP TABLE #CCM_LicAal
END


CREATE  TABLE   #CCM_LicAal (
	simLicAppTypeId		integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	eval_fld1			char ( 64)	NOT NULL,

	perm_fld1			char ( 64)	NOT NULL,

	commcellId		integer DEFAULT 2	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxSIDBStore]') )
BEGIN
	DROP TABLE #CCM_IdxSIDBStore
END


CREATE  TABLE   #CCM_IdxSIDBStore (
	SIDBStoreId						INTEGER NOT NULL,

	SIDBStoreName					NVARCHAR(256),	--	- by default, format will be: 'SIDB_CopyName_ID' NOT NULL

	SIDBStoreAliasName				NVARCHAR(256),	--	- by default, format will be: 'SIDB_CopyName' NOT NULL

	CommCellId						integer	NOT NULL,	--	- Needed for CCM.

	IdxCacheId						integer	NOT NULL,

	IdxAccessPathId					integer	NOT NULL,

	ClientId						integer	NOT NULL,	--redudandant but good for queries

	FirstBackupTime					INTEGER  NOT NULL,

	MinObjSizeKB					bigint	NOT NULL,

	oldestEligibleObjArchiveTime	INTEGER  NOT NULL,

	SignatureType					integer	NOT NULL,

	flags							integer	NOT NULL,

	TotalDataSizeBytes				bigint	NOT NULL,

	InstancedDataSizeBytes			bigint	NOT NULL,

	Status							integer	NOT NULL,

	LastAccessTime					integer	NOT NULL,

	CreatedTime						integer	NOT NULL,

	SealedTime						integer	NOT NULL,

	origCCSIDBStoreId				integer	NOT NULL,

	Version							integer	NOT NULL,

	SIDBSnapPath					varchar(1024)	NOT NULL,

	LastSnapTime					integer	NOT NULL,

	LastRecoveryTime				integer	NOT NULL,

	SealedReason					integer	NOT NULL,

	SIDBSiloedTime					integer	NOT NULL,

	SIDBSiloStatus					integer	NOT NULL,

	SIDBSiloJobId					integer	NOT NULL,

	SubStoreCount					integer	NOT NULL,

	MaxAllowedConnections				integer	NOT NULL,

	MaxNumOfAFsInSecFile				integer	NOT NULL,

	LastDDBVerificationTime			bigint DEFAULT 0	NOT NULL,

	LastDataVerificationTime		bigint DEFAULT 0	NOT NULL,

	DedupFactor					integer DEFAULT 1	NOT NULL,

	AppTypeGroupId					integer DEFAULT 0	NOT NULL,	--Refers to App_AppTypeGroup table

	ExtendedFlags					bigint DEFAULT 0	NOT NULL,

	FullReason						tinyint DEFAULT 0	NOT NULL,

	FullTime						INTEGER  DEFAULT 0 NOT NULL,

	SIDBGroupId						integer DEFAULT 0	NOT NULL,	--Refers to IdxSIDBGroup table

	LastQuickDDBVerificationTime	bigint DEFAULT 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxSIDBSubStore]') )
BEGIN
	DROP TABLE #CCM_IdxSIDBSubStore
END


CREATE  TABLE   #CCM_IdxSIDBSubStore (
	SIDBStoreId						integer	NOT NULL,

	SubStoreId						INTEGER NOT NULL,

	commCellId						integer	NOT NULL,

	GroupNumber						integer	NOT NULL,

	IdxCacheId						integer	NOT NULL,

	IdxAccessPathId					integer	NOT NULL,

	ClientId						integer	NOT NULL,	--redudandant but good for queries

	FirstBackupTime					INTEGER  NOT NULL,

	flags							integer	NOT NULL,

	TotalDataSizeBytes				bigint	NOT NULL,

	InstancedDataSizeBytes			bigint	NOT NULL,

	Status							integer	NOT NULL,

	LastAccessTime					integer	NOT NULL,

	CreatedTime						integer	NOT NULL,

	SealedTime						integer	NOT NULL,

	Version							integer	NOT NULL,

	SIDBSnapPath					varchar(1024)	NOT NULL,

	LastSnapTime					integer	NOT NULL,

	origSubStoreId					integer	NOT NULL,

	ReconLevel					integer	NOT NULL,

	LastSnapJobId					integer default 0	NOT NULL,

	DDBBackupCSGUID					nvarchar(40)	NOT NULL,

	PrimaryId					bigint default 0	NOT NULL,

	MemDbTimeStamp					integer default 0	NOT NULL,

	CorruptionTime					integer default 0	NOT NULL,

	ZeroRefBatchSeq						bigint default 0	NOT NULL,

	StartLogSequence				varchar(128) default ''	NOT NULL,

	EndLogSequence				varchar(128) default ''	NOT NULL,

	SnapLogSequence				varchar(128) default ''	NOT NULL,

	MaxNumOfAFsInSecFile			integer default 0	NOT NULL,

	ExtendedFlags				bigint default 0	NOT NULL,

	DDBSubClientId				integer default 0	NOT NULL,

	PageSize				integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_GXGlobalParam]') )
BEGIN
	DROP TABLE #CCM_GXGlobalParam
END


CREATE  TABLE   #CCM_GXGlobalParam (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	name		    	nvarchar(64)	NOT NULL,

	value				nvarchar(max) NOT NULL,

	created				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_Pattern]') )
BEGIN
	DROP TABLE #CCM_TM_Pattern
END


CREATE  TABLE   #CCM_TM_Pattern (
	patternId				INTEGER NOT NULL,

	name					nvarchar(255)					NOT NULL,

	ownerId					integer					NOT NULL,

	status					integer					NOT NULL,

	flags					integer					NOT NULL,

	freq_type				integer					NOT NULL,

	freq_interval			integer					NOT NULL,

	freq_relative_interval	integer					NOT NULL,

	freq_recurrence_factor	integer					NOT NULL,

	freq_subday_interval	integer					NOT NULL,

	skipOccurence			integer					NOT NULL,

	skipDayNumber			integer					NOT NULL,

	active_start_date		DATETIME			,

	active_start_time		integer					NOT NULL,

	active_end_date			DATETIME			,

	active_end_time			integer					NOT NULL,

	active_end_occurence	integer					NOT NULL,

	created					integer					NOT NULL,

	modified				integer					NOT NULL,

	tzId					integer					NOT NULL,

	calendarId				integer					NOT NULL,

	description				nvarchar(2048)	NOT NULL,

	local_start_date		integer					NOT NULL,

	local_end_date			integer					NOT NULL,

	disabled				tinyint					NOT NULL,

	deleted					tinyint					NOT NULL,

	scheduling				tinyint					NOT NULL,

	freq_restart_interval  	integer					NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_PatternAssoc]') )
BEGIN
	DROP TABLE #CCM_TM_PatternAssoc
END


CREATE  TABLE   #CCM_TM_PatternAssoc (
	patternAssocId				INTEGER NOT NULL,

	patternId					integer					NOT NULL,

	subTaskId					integer					NOT NULL,

	flags						integer					NOT NULL,	--schedule pattern is expired for this association

	disabled					tinyint					NOT NULL,

	deleted						tinyint					NOT NULL,

	scheduling					tinyint					NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_SubTask]') )
BEGIN
	DROP TABLE #CCM_TM_SubTask
END


CREATE  TABLE   #CCM_TM_SubTask (
	subTaskId				INTEGER NOT NULL,

	subTaskName				nvarchar(255) null,

	taskId					integer					NOT NULL,

	subTaskType				integer					NOT NULL,

	operationType			integer					NOT NULL,

	flags					integer					NOT NULL,

	subTaskOrder			integer					NOT NULL,

	deleted					tinyint					NOT NULL,

	uninstalled				tinyint					NOT NULL,

	defaultTask				tinyint					NOT NULL,

	subOperationType		xml					,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_AssocEntity]') )
BEGIN
	DROP TABLE #CCM_TM_AssocEntity
END


CREATE  TABLE   #CCM_TM_AssocEntity (
	assocId					INTEGER NOT NULL,

	assocType				integer					NOT NULL,

	taskId					integer					NOT NULL,

	flags					integer					NOT NULL,

	created					integer					NOT NULL,

	clientGroupId			integer					NOT NULL,

	clientId				integer					NOT NULL,

	apptypeId				integer					NOT NULL,

	instanceId				integer					NOT NULL,

	backupsetId				integer					NOT NULL,

	subclientId				integer					NOT NULL,

	policyId				integer					NOT NULL,

	copyId					integer					NOT NULL,

	srmReportSet			integer					NOT NULL,

	srmReportType			integer					NOT NULL,

	exclude					tinyint					NOT NULL,

	trackingPolicyId		integer					NOT NULL,

	MediaAgentId			integer					NOT NULL,

	agentlessPolicyId		integer					NOT NULL,

	workflowId				integer					NOT NULL,

	sidbStoreId				integer					NOT NULL,

	libraryId				integer					NOT NULL,

	logMonitoringPolicyId	integer					NOT NULL,

	entityId				integer	NOT NULL DEFAULT 0 , --Added for supporting Inventory data source and any other future entity types, entity type is stored in assoctype



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_Task]') )
BEGIN
	DROP TABLE #CCM_TM_Task
END


CREATE  TABLE   #CCM_TM_Task (
	taskId					INTEGER NOT NULL,

	taskName                nvarchar(255) null,

	taskType				integer					NOT NULL,

	flags					integer					NOT NULL,

	status					integer					NOT NULL,

	created					integer					NOT NULL,

	modified				integer					NOT NULL,

	alertId			 		integer					NOT NULL,

	ownerId					integer					NOT NULL,

	runUserId				integer					NOT NULL,

	initiatedFrom			integer					NOT NULL,

	sequenceNumber			varchar(255)			NOT NULL,

	localeId				integer					NOT NULL,

	description				nvarchar(2048) null,

	deleted					tinyint					NOT NULL,

	disabled				tinyint					NOT NULL,

	uninstalled				tinyint					NOT NULL,

	invalid					tinyint					NOT NULL,

	defaultTask				tinyint					NOT NULL,

	savedReport				tinyint					NOT NULL,

	serial					tinyint					NOT NULL,

	policyType				tinyint					NOT NULL,

	origCCId			integer		DEFAULT		2	NOT NULL,

	GUID				varchar(40)	DEFAULT	newid()	NOT NULL,

	isEZOperation			tinyint					NOT NULL,

	isAgentlessSRM			tinyint					NOT NULL,

	hidden				tinyint					NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMVolume]') )
BEGIN
	DROP TABLE #CCM_SMVolume
END


CREATE  TABLE   #CCM_SMVolume (
	SMVolumeId						INTEGER NOT NULL,

	SourceClientId					integer	NOT NULL,

	MountHostId						integer	NOT NULL,

	CommCellId						integer	NOT NULL,

	JobId							integer	NOT NULL,

	ArchFileId						integer	NOT NULL,

	CopyId							smallint	NOT NULL,

	AppId							integer	NOT NULL,

	AppTypeId						integer	NOT NULL,

	PruneFlags						integer	NOT NULL,

	VolumeFlags						bigint	NOT NULL,

	VolumeStatus					integer	NOT NULL,

	VolumeStatusUpdateTime			INTEGER  NOT NULL,

	MountStatus						integer	NOT NULL,

	MountStatusUpdateTime			INTEGER  NOT NULL,

	LogicalUnmountTime				INTEGER  NOT NULL,

	CreationTime					INTEGER  NOT NULL,

	RetryCount						integer	NOT NULL,

	DevMode							integer	NOT NULL,

	UserId							integer	NOT NULL,

	GroupId							integer	NOT NULL,

	SnapSource						integer	NOT NULL,

	MountProxyId					integer	NOT NULL,

	RemoteOp						integer	NOT NULL,

	RemoteOpStatus					integer	NOT NULL,

	VmHostId						integer	NOT NULL,

	RecoveryPointId					bigint	NOT NULL,

	OriginClientId					integer	NOT NULL,

	SourcePath						NVARCHAR(1024) default ''	NOT NULL,

	MountPath						NVARCHAR(1024) default ''	NOT NULL,

	SourceGUID						NVARCHAR(1024) default ''	NOT NULL,

	MountGUID						NVARCHAR(1024) default ''	NOT NULL,

	SourceDevice					NVARCHAR(1024) default ''	NOT NULL,

	MountDevice						NVARCHAR(1024) default ''	NOT NULL,

	MountOptions					NVARCHAR(1024) default ''	NOT NULL,

	ShadowSetId						NVARCHAR(40) default ''	NOT NULL,

	ShadowCopyId					NVARCHAR(40) default ''	NOT NULL,

	RepBasePath						NVARCHAR(1024) default ''	NOT NULL,

	RepRelativePath					NVARCHAR(1024) default ''	NOT NULL,

	OriginSourcePath				NVARCHAR(1024) default ''	NOT NULL,

	GUID						uniqueidentifier ROWGUIDCOL,		-- for Unique identification across CommCells

	ReserveField1				integer default 0	NOT NULL,

	ReserveField2				integer default 0	NOT NULL,

	ReserveFieldStr				NVARCHAR(255) default ''	NOT NULL,

	SourceVolumeId				integer default 0	NOT NULL,

	MasterJobId					integer default 0	NOT NULL,

	PartitionNum				integer default 0	NOT NULL,

	UsedSpaceBytes				bigint default 0	NOT NULL,

	TotalSpaceBytes				bigint default 0	NOT NULL,

	PseudoClientId				integer default 0	NOT NULL,

	RequestId					integer default 0	NOT NULL,

	TotalRetryCount				integer	default 0	NOT NULL,

	GroupingId					bigint default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMVolSnapMap]') )
BEGIN
	DROP TABLE #CCM_SMVolSnapMap
END


CREATE  TABLE   #CCM_SMVolSnapMap (
	SMVolSnapMapId		INTEGER NOT NULL,

	SMVolumeId			integer	NOT NULL,

	SMSnapId			integer	NOT NULL,

	MetaDataId			integer	NOT NULL,

	GroupId				integer	NOT NULL,

	PruneFlags			integer	NOT NULL,

	OrigCCId					integer	DEFAULT	2	NOT NULL,	-- for CommCell Migration Path

	GUID						uniqueidentifier ROWGUIDCOL,		-- for Unique identification across CommCells

	ReserveField1				integer default 0	NOT NULL,

	ReserveField2				integer default 0	NOT NULL,

	ReserveFieldStr				NVARCHAR(255) default ''	NOT NULL,

	Flags				bigint default 0	NOT NULL,

	GroupType			bigint default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMMetaData]') )
BEGIN
	DROP TABLE #CCM_SMMetaData
END


CREATE  TABLE   #CCM_SMMetaData (
	MetaDataId			INTEGER NOT NULL,

	MetaDataType		integer	NOT NULL,

	RefType				integer	NOT NULL,

	RefId				integer	NOT NULL,

	PruneFlags			integer	NOT NULL,

	MetaData				nvarchar(max) NOT NULL,

	OrigCCId					integer	DEFAULT	2	NOT NULL,	-- for CommCell Migration Path

	GUID						uniqueidentifier ROWGUIDCOL,		-- for Unique identification across CommCells

	ReserveField1				integer default 0	NOT NULL,

	ReserveField2				integer default 0	NOT NULL,

	ReserveFieldStr				NVARCHAR(255) default ''	NOT NULL,

	Flags				bigint default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMSnap]') )
BEGIN
	DROP TABLE #CCM_SMSnap
END


CREATE  TABLE   #CCM_SMSnap (
	SMSnapId						INTEGER NOT NULL,

	SnapShotEngineId				integer	NOT NULL,

	OriginalSnapEngineId			integer	NOT NULL,

	ControlHostId					integer	NOT NULL,

	GroupId							integer	NOT NULL,

	SnapType						integer	NOT NULL,

	SnapFlags						bigint	NOT NULL,

	PruneFlags						integer	NOT NULL,

	SnapStatus						integer	NOT NULL,

	SnapStatusUpdateTime			INTEGER  NOT NULL,

	CreationTime					INTEGER  NOT NULL,

	ReplicationStatus				bigint	NOT NULL,

	DeviceEntryType					integer	NOT NULL,

	ConnectionType					integer	NOT NULL,

	SnapSourceDevice				NVARCHAR(1024) default ''	NOT NULL,

	SnapDevice						NVARCHAR(1024) default ''	NOT NULL,

	ShadowCopyId					NVARCHAR(40) default ''	NOT NULL,

	UniqueIdentifier				NVARCHAR(1024) default ''	NOT NULL,

	SourceIdentifier				NVARCHAR(1024) default ''	NOT NULL,

	TargetIdentifier				NVARCHAR(1024) default ''	NOT NULL,

	OrigCCId						integer	DEFAULT	2	NOT NULL,	-- for CommCell Migration Path

	GUID							uniqueidentifier ROWGUIDCOL,		-- for Unique identification across CommCells

	ReserveField1					integer default 0	NOT NULL,

	ReserveField2					integer default 0	NOT NULL,

	ReserveFieldStr					NVARCHAR(255) default ''	NOT NULL,

	ArrayVolumeId					integer default 0	NOT NULL,

	LunId							integer default 0	NOT NULL,

	UsedSpaceBytes					bigint default -1	NOT NULL,

	ReserveField3					integer default 0	NOT NULL,

	ReserveField4					integer default 0	NOT NULL,

	ArraySrcDevice					NVARCHAR(1024) default ''	NOT NULL,

	ArrayTgtDevice					NVARCHAR(1024) default ''	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMControlHost]') )
BEGIN
	DROP TABLE #CCM_SMControlHost
END


CREATE  TABLE   #CCM_SMControlHost (
	ControlHostId				INTEGER NOT NULL,

	SnapShotEngineId			integer	NOT NULL,

	SnapVendorName				NVARCHAR(128) default ''	NOT NULL,

	SMArrayId					NVARCHAR(1024) default ''	NOT NULL,

	SMHostIP					NVARCHAR(1024) default ''	NOT NULL,

	SMHostName					NVARCHAR(1024) default ''	NOT NULL,

	SMHostPortNumber			integer	NOT NULL,

	SMHostUserName				NVARCHAR(1024) default ''	NOT NULL,

	SMHostPassword				NVARCHAR(2048) default ''	NOT NULL,

	SMHostFlags					integer	NOT NULL,

	SMHostStatus				integer	NOT NULL,

	SMHostDescription			NVARCHAR(1024) default ''	NOT NULL,

	SnapShotEngineName			NVARCHAR(1024) default ''	NOT NULL,

	DeviceGroupName				NVARCHAR(1024) default ''	NOT NULL,

	SMHostOption				integer	NOT NULL,

	SourceId					integer default 0	NOT NULL,

	OrigCCId					integer	DEFAULT	2	NOT NULL,	-- for CommCell Migration Path

	GUID						uniqueidentifier ROWGUIDCOL,		-- for Unique identification across CommCells

	ReserveField1				integer default 0	NOT NULL,

	ReserveField2				integer default 0	NOT NULL,

	ReserveFieldStr				NVARCHAR(255) default ''	NOT NULL,

	ClientId					integer default 1	NOT NULL,

	SoftState					integer default 0	NOT NULL,

	IsEnabled					integer default 0	NOT NULL,

	IsActive					integer default 0	NOT NULL,

	BrokenCode					integer default 0	NOT NULL,

	ReasonCode					integer default 0	NOT NULL,

	Flags						bigint default 0	NOT NULL,

	AdminConsole				NVARCHAR(1024) default ''	NOT NULL,

	Properties					XML default '',

	ReserveField3				integer default 0	NOT NULL,

	ReserveField4				integer default 0	NOT NULL,

	GroupingId					bigint default 0	NOT NULL,

	UniqueIdentifier			NVARCHAR(1024) default ''	NOT NULL,

	CreatedTime					DATETIME NOT NULL DEFAULT (GETUTCDATE()),

	ModifiedTime				DATETIME NOT NULL DEFAULT (GETUTCDATE()),

	CredentialId				integer default -1	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSProviders]') )
BEGIN
	DROP TABLE #CCM_UMDSProviders
END


CREATE  TABLE   #CCM_UMDSProviders (
	id				INTEGER NOT NULL,									-- Primary Key for this table

	domainName 		nvarchar(255),	-- full name NOT NULL

	hostName		nvarchar(4000),	-- Name used for connection NOT NULL

	description		nvarchar(3072),	-- "Friendly" name NOT NULL

	login			nvarchar(255),	-- login name NOT NULL

	password		nvarchar(400),	-- encrypted password NOT NULL

	trustedHostUser	nvarchar(255),	-- Obsoleted NOT NULL

	trustedHostPW	nvarchar(400),	--Obsoleted NOT NULL

	flags			integer	NOT NULL,	-- password aging policy

	enabled			integer	NOT NULL,	-- login enabled flag

	serviceType		integer	NOT NULL,	-- AD, etc .. For now, just "AD"

	modified		INTEGER  NOT NULL,	-- Used to determine "what has changed"

	dnsRoot			nvarchar(255),	-- Template name that will be dispalyed in the GUI NOT NULL

	dnsRootStatus	integer	NOT NULL,	-- dnsRoot status --(1-Resolved 0-UnResolved)

	useSecureLdap	integer	NOT NULL,	-- 1-Use SecureLdap 0-Use Ldap

	origCCId		integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	GUID			uniqueidentifier ROWGUIDCOL,			-- for uniquely identify across commcells

	port			integer 		DEFAULT         0	NOT NULL,

	resourceId		integer			DEFAULT         0		NOT NULL,

	checkTime		INTEGER 			DEFAULT			(24*60*60) NOT NULL,	-- Number of seconds before a user is revalidated against name server (0==infinite)

	ownerId			integer			DEFAULT			1	NOT NULL,	--User who created the domain, default owner is the master user

	ownerCompany	integer			DEFAULT			0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSgroups]') )
BEGIN
	DROP TABLE #CCM_UMDSgroups
END


CREATE  TABLE   #CCM_UMDSgroups (
	id			integer	NOT NULL,

	umdsProviderId		integer	NOT NULL,	-- Points to UMDSProviders table

	enabled				integer	NOT NULL,	-- is this group enabled

	name				nvarchar(255),	-- group name (from Externam Service) NOT NULL

	description			nvarchar(3072),	-- group description (friendly name) CV internal NOT NULL

	email				nvarchar(255),	-- Group Mail id NOT NULL

	lastCredSetTime 	INTEGER   default 0 NOT NULL,	-- Last time email was updated for this group

	oldId       		integer  default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMGroups]') )
BEGIN
	DROP TABLE #CCM_UMGroups
END


CREATE  TABLE   #CCM_UMGroups (
	id					INTEGER NOT NULL,								-- Primary Key for this table

	groupFlags			integer	NOT NULL,	-- is this group enabled

	allCapabilities		integer	NOT NULL,	-- See GF_XXX definitions above

	allAssociations		integer	NOT NULL,	-- with unlimited access

	selfAssociation		integer	NOT NULL,	-- has association to self

	name				NVARCHAR(255)	NOT NULL,

	description			NVARCHAR(3072),	-- group description NOT NULL

	origCCId			integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	GUID				uniqueidentifier ROWGUIDCOL,      	-- for Unique identification across CommCells

	umdsProviderId		integer DEFAULT 0	NOT NULL,	--umdsProviderId in case of external groups

	email				NVARCHAR(255) NOT NULL DEFAULT '',	--emailId in case of external groups

	lastCredSetTime		integer DEFAULT 0	NOT NULL,	--lastCredSetTime



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSGroupMaps]') )
BEGIN
	DROP TABLE #CCM_UMDSGroupMaps
END


CREATE  TABLE   #CCM_UMDSGroupMaps (
	umDSgroupId			integer	NOT NULL,	-- foreign key to UMUsers table

	umgroupId			integer	NOT NULL,	-- foreign key to UMGroups table

	flag				integer	NOT NULL,	-- For Maintenance

	umdsGroupMapsId     INTEGER NOT NULL, 	-- primary key of the table



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMUsers]') )
BEGIN
	DROP TABLE #CCM_UMUsers
END


CREATE  TABLE   #CCM_UMUsers (
	id				INTEGER NOT NULL,									-- Primary Key for this table

	name		    NVARCHAR(255)	NOT NULL,

	description				NVARCHAR(MAX) NOT NULL,

	login			NVARCHAR(255)	NOT NULL,

	password		nvarchar(400),	-- encrypted password NOT NULL

	email			NVARCHAR(255)	NOT NULL,

	datePasswordSet integer	NOT NULL,	-- password change date

	dateExpires		integer	NOT NULL,	-- account expiration date

	policy			integer	NOT NULL,	-- password aging policy

	enabled			integer	NOT NULL,	-- login enabled flag

	flags			integer	NOT NULL,	-- Deleted et al

	modified		INTEGER  NOT NULL,	-- Used to determine "what has changed"

	pVer			integer	NOT NULL,	-- Password Version .. actually a char casted up

	Pager           varchar(255),	-- Pager e-mail address NOT NULL

	lastLogInTime	INTEGER  NOT NULL,	-- Last time a user logged in with this login

	credSetTime		INTEGER  NOT NULL,	-- Last time the users credentials were updated

	umDSproviderId	integer	NOT NULL,	-- Points to umDSProvider table (==0 means local Commcell User)

	userGuid	 	nvarchar(256),	-- Generated User GUID ( also used in Commcell Migration) NOT NULL

	origUserGuid 	nvarchar(256),	-- Original DM2 User GUID NOT NULL

	origCCId		integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	salt			nvarchar(400) DEFAULT ''	NOT NULL,

	companyId		integer		DEFAULT		0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMUserGroup]') )
BEGIN
	DROP TABLE #CCM_UMUserGroup
END


CREATE  TABLE   #CCM_UMUserGroup (
	userId				integer	NOT NULL,	-- forign key to UMUsers table

	groupId				integer	NOT NULL,	-- foring key to UMGroups table

	flag				integer	NOT NULL,	-- For Maintenance

	umUserGroupId       INTEGER NOT NULL, 	-- primary key



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMUserPrefs]') )
BEGIN
	DROP TABLE #CCM_UMUserPrefs
END


CREATE  TABLE   #CCM_UMUserPrefs (
	userId		integer	NOT NULL,

	value				nvarchar(max) NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSUserGroup]') )
BEGIN
	DROP TABLE #CCM_UMDSUserGroup
END


CREATE  TABLE   #CCM_UMDSUserGroup (
	userId				integer	NOT NULL,	-- foreign key to UMUsers table

	groupId				integer	NOT NULL,	-- foreign key to UMgroup table

	flag				integer	NOT NULL,	-- For Maintenance

	umdsUserGroupId     INTEGER NOT NULL, 	--primary key



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMRoles]') )
BEGIN
	DROP TABLE #CCM_UMRoles
END


CREATE  TABLE   #CCM_UMRoles (
	id 						INTEGER NOT NULL,

	commcellId 			    integer    DEFAULT 2	NOT NULL,

	name   					NVARCHAR(255),	-- roles name NOT NULL

	description               NVARCHAR(3072),	-- roles description NOT NULL

	disabled             		integer	NOT NULL,	-- is this roles disabled

	isPrivate   				integer	NOT NULL,	-- keeping it as isPrivate instead of private since private is a keyword in cpp

	flags						integer	NOT NULL,	--to indicate DUMMY, DEFAULT, HIDDEN, etc

	ownerId                   integer	NOT NULL,

	created 					INTEGER  NOT NULL,

	modified 					INTEGER  NOT NULL,

	GUID                      uniqueidentifier ROWGUIDCOL,      	-- for Unique identification across CommCells

	xmlProperties				xml,										--for storing any properties that get added in the form of xml

	capabilitiesBitMask		bigint NOT NULL default 0,

	permissionsString			varchar(512) NOT NULL default ''



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMRolesPermissions]') )
BEGIN
	DROP TABLE #CCM_UMRolesPermissions
END


CREATE  TABLE   #CCM_UMRolesPermissions (
	roleId 			    			integer	NOT NULL,

	hierarchyLevel               		integer	NOT NULL,

	categoryId           	    		integer	NOT NULL,

	permissionId                   	integer	NOT NULL,

	excludeCategory	         		integer	NOT NULL,

	excludePermission					integer	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMRolesWithPermissionsExpanded]') )
BEGIN
	DROP TABLE #CCM_UMRolesWithPermissionsExpanded
END


CREATE  TABLE   #CCM_UMRolesWithPermissionsExpanded (
	roleId 							INT	NOT NULL,

	categoryId 						INT	NOT NULL,

	permissionId 					INT	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMOwners]') )
BEGIN
	DROP TABLE #CCM_UMOwners
END


CREATE  TABLE   #CCM_UMOwners (
	entityType			INT	NOT NULL,	--entity type defined in cventities.x

	entityId			INT	NOT NULL,	--entity id

	userOrGroupId		INT	NOT NULL,	--user or user group or external group id

	isUser				INT	NOT NULL,	--flag which when set to 1 indicates that the id in userOrGroupId column is userId else user Group Id

	authorId		    INT	NOT NULL,	--whoever is doing this operation

	flags				INT DEFAULT 1	NOT NULL,	--used to save some very important information like system created or user created

	companyId			INT DEFAULT 0	NOT NULL,	--this column refers to the company Id of this user / group to which this owner association is made for.



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMOwnerRoles]') )
BEGIN
	DROP TABLE #CCM_UMOwnerRoles
END


CREATE  TABLE   #CCM_UMOwnerRoles (
	entityType			INT	NOT NULL,	--entity type defined in cventities.x

	entityId			INT	NOT NULL,	--entity id

	roleId				INT		DEFAULT 0	NOT NULL,	--when role is associated

	permissionId		INT		DEFAULT 0	NOT NULL,	--when permission is associated directly

	authorId			INT	NOT NULL,	--whoever is doing that operation



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMSecurityAssociations]') )
BEGIN
	DROP TABLE #CCM_UMSecurityAssociations
END


CREATE  TABLE   #CCM_UMSecurityAssociations (
	roleId 						INT   DEFAULT 0	NOT NULL,	--when role is associated

	permissionId                INT   DEFAULT 0	NOT NULL,	--when permission is associated directly

	userOrGroupId 				INT	NOT NULL,	--user Id or user Group Id

	isUser 						INT	NOT NULL,	--flag which when set to 1 indicates that the id in userOrGroupId column is userId else user Group Id

	isRoleAllowed 				INT 	DEFAULT 1	NOT NULL,	--when set to 0 means that role is denied

	propagateToChildObjects 	INT 	DEFAULT 1	NOT NULL,	--flag to indicate whether the association should propagate to child objects

	roleValidityDate 			INT 	DEFAULT 0	NOT NULL,	--expiration date for this association (UTC)

	timeZone 					INT 	DEFAULT 0	NOT NULL,	--time zone for this expiration date (used only to send data back to GUI)

	exclude 					INT 	DEFAULT 0	NOT NULL,	--if some entity needs to be excluded from parent selection

	entityType1 				INT		DEFAULT 0	NOT NULL,	--the 5 entity hierarchy on which association is done

	entityId1 					INT		DEFAULT 0	NOT NULL,

	entityType2 				INT		DEFAULT 0	NOT NULL,

	entityId2 					INT		DEFAULT 0	NOT NULL,

	entityType3 				INT		DEFAULT 0	NOT NULL,

	entityId3 					INT		DEFAULT 0	NOT NULL,

	entityType4 				INT		DEFAULT 0	NOT NULL,

	entityId4 					INT		DEFAULT 0	NOT NULL,

	entityType5 				INT		DEFAULT 0	NOT NULL,

	entityId5 					INT		DEFAULT 0	NOT NULL,

	includeAll					INT		DEFAULT 0	NOT NULL,	--to indicate whether all entities of this entity type is selected or not

	isCreator					INT     DEFAULT 0	NOT NULL,	--flag to indicate whether this row corresponds to a entity creator (permissions are hard-coded in code)

	authorId					INT		DEFAULT 0	NOT NULL,	--this is a column for future reference- to indicate which user has done this operation

	companyId					INT		DEFAULT 0	NOT NULL,	--this column refers to the company Id of this user / group to which this security association is made for.

	securityId                          INTEGER NOT NULL,             	--this is a primary key column



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_edcJobIdMap]') )
BEGIN
	DROP TABLE #CCM_edcJobIdMap
END


CREATE  TABLE   #CCM_edcJobIdMap (
	mergedCcId	    integer		    not null,

	foreignJobId	nvarchar(512)	not null,

	newJobId	    integer		    not null



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_edcClientNameMap]') )
BEGIN
	DROP TABLE #CCM_edcClientNameMap
END


CREATE  TABLE   #CCM_edcClientNameMap (
	exServerAliasName 	nvarchar(255)	not null,

	exMachineName 		nvarchar(255)	not null,

	exMachineHostName 	nvarchar(255)	not null,

	gxMachineName 		nvarchar(255)	not null,

	gxMachineHostName 	nvarchar(255)	not null,

	creationTime 		integer		    not null,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archMaterializeSnapshotProp]') )
BEGIN
	DROP TABLE #CCM_archMaterializeSnapshotProp
END


CREATE  TABLE   #CCM_archMaterializeSnapshotProp (
	archGroupId		smallint	NOT NULL,

	enabled			tinyint	NOT NULL,

	type			tinyint	NOT NULL,

	flags			integer	NOT NULL,

	startTime		INTEGER  NOT NULL,

	sourceCopyId	smallint	NOT NULL,

	deferredDays	smallint	NOT NULL,

	numPeriod		tinyint	NOT NULL,

	dayNumber		smallint	NOT NULL,

	currPeriodBegin	INTEGER  NOT NULL,

	currPeriodEnd	INTEGER  NOT NULL,

	calendarId		integer	NOT NULL,

	numOfReaders	tinyint	NOT NULL,

	prevPeriodBegin	INTEGER  NOT NULL,

	nextPeriodEnd	INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_PatchUpdateAgentInfo]') )
BEGIN
	DROP TABLE #CCM_PatchUpdateAgentInfo
END


CREATE  TABLE   #CCM_PatchUpdateAgentInfo (
	id					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	clientId			integer	NOT NULL,

	isLocalDrive		integer	NOT NULL,

	cachePath			nvarchar(255)	NOT NULL,

	username			nvarchar(255)	NOT NULL,

	passwd				nvarchar(255)	NOT NULL,

	isEnabled			integer	NOT NULL,

	autoSyncWithCS		integer	NOT NULL,

	inSyncWithCS		integer	NOT NULL,

	isDeleted			integer	NOT NULL,

	packageStatus		integer	NOT NULL,

	SWSharePath			nvarchar(255)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_PatchMultiCache]') )
BEGIN
	DROP TABLE #CCM_PatchMultiCache
END


CREATE  TABLE   #CCM_PatchMultiCache (
	ClientId		integer	NOT NULL,

	ReleaseId		integer	NOT NULL,

	OSId			integer	NOT NULL,

	HighestSP		nvarchar(255)	NOT NULL,

	AddUpdates				nvarchar(max)NULL,

	IsSPValid       integer	NOT NULL,

	SPVersionId		integer NULL,

	id				INTEGER NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_CCRCommCellReadiness]') )
BEGIN
	DROP TABLE #CCM_CCRCommCellReadiness
END


CREATE  TABLE   #CCM_CCRCommCellReadiness (
	CCRId					INTEGER NOT NULL,			-- PRIMARY KEY FOR THIS TABLE

	CCRLevel				integer	NOT NULL,

	CCRStartTime			INTEGER  NOT NULL,

	CCREndTime				INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_CCRToSubClient]') )
BEGIN
	DROP TABLE #CCM_CCRToSubClient
END


CREATE  TABLE   #CCM_CCRToSubClient (
	CCRId					integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	ClientId				integer	NOT NULL,

	SubClientId				integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	DataPathId				integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	CCRResultFlag			integer	NOT NULL,

	lastUnCompBytes			bigint	NOT NULL,

	lastCompBytes			bigint	NOT NULL,

	capacityAvailable		bigint	NOT NULL,

	appTypeId				integer	NOT NULL,

	dataWritten					bigint	NOT NULL,

	CCRNetworkReadinessFlag		bigint	NOT NULL,

	CCRResourceReadinessFlag	bigint	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_CCRClientToClient]') )
BEGIN
	DROP TABLE #CCM_CCRClientToClient
END


CREATE  TABLE   #CCM_CCRClientToClient (
	FromClientId				integer	NOT NULL,

	FromClientInterfaceName		varchar(255)	NOT NULL,

	ToClientId					integer	NOT NULL,

	ToClientInterfaceName		varchar(255)	NOT NULL,

	NumberOfNWHops				integer	NOT NULL,

	NWDelayInMilliSec			integer	NOT NULL,

	LastUpdateTime				INTEGER  NOT NULL,

	IsEnabled					integer	NOT NULL,

	Flag						integer	NOT NULL,

	errorCode					integer	NOT NULL,

	lastOnlineTime				INTEGER  NOT NULL,

	serviceType					integer	NOT NULL,

	IsDip						integer	NOT NULL,

	lastOfflineTime				INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileCopyDedup]') )
BEGIN
	DROP TABLE #CCM_archFileCopyDedup
END


CREATE  TABLE   #CCM_archFileCopyDedup (
	archFileId				integer	NOT NULL,

	commCellId     			integer	NOT NULL,

	archCopyId				smallint	NOT NULL,

	SIDBStoreId				integer	NOT NULL,

	primaryObjects			integer	NOT NULL,

	secondaryObjects		integer	NOT NULL,

	primaryObjSize			bigint	NOT NULL,

	secondaryObjSize		bigint	NOT NULL,

	primaryMetaDataSize		bigint	NOT NULL,

	secondaryMetaDataSize	bigint	NOT NULL,

	transDataSize			bigint	NOT NULL,

	savedDataSize			bigint	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileSIDBKeys]') )
BEGIN
	DROP TABLE #CCM_archFileSIDBKeys
END


CREATE  TABLE   #CCM_archFileSIDBKeys (
	archFileId		integer	NOT NULL,

	commCellId		integer	NOT NULL,

	archCopyId		smallint	NOT NULL,

	encKeyType		tinyint	NOT NULL,

	encKey			varchar(1024)	NOT NULL,

	SIDBStoreId		integer	NOT NULL,

	encRSA			tinyint default 0	NOT NULL,

	encKeyId		integer default 0	NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMEntityProp]') )
BEGIN
	DROP TABLE #CCM_MMEntityProp
END


CREATE  TABLE   #CCM_MMEntityProp (
	EntityId		INTEGER	NOT NULL,	-- Will have SPID, SPCID, LibraryID etc

	EntityType		TINYINT	NOT NULL,	-- Will have entity type information like SP, SPC, Library etic, is defined in MMDefines.h

	propertyName	NVARCHAR(256)	NOT NULL,

	propDataType	INTEGER	NOT NULL,	-- Integer, String, etc ... Also Property_enum!, is defined in MMDefines.h

	intVal			INTEGER NULL DEFAULT 0, 		-- Used to hold value for anything that will fit in it (long/short/bool etc ...

	longlongVal		BIGINT NULL DEFAULT 0, 					-- Used to hold values for 64 bit entities

	stringVal				NVARCHAR(MAX) DEFAULT '',			-- Used to hold the rest! NOT NULL

	created			INTEGER  NOT NULL,

	modified		INTEGER  NOT NULL,

	CommCellId		INTEGER DEFAULT 2	NOT NULL,	-- Will have CommCell Id



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_DlpClientPass]') )
BEGIN
	DROP TABLE #CCM_DlpClientPass
END


CREATE  TABLE   #CCM_DlpClientPass (
	id		 INTEGER NOT NULL,

	clientId 	 INTEGER	NOT NULL,

	created  	 INTEGER	NOT NULL,

	flags			 INTEGER	NOT NULL,

	passPhrase VARCHAR(256)	NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archIndexingAged]') )
BEGIN
	DROP TABLE #CCM_archIndexingAged
END


CREATE  TABLE   #CCM_archIndexingAged (
	currentIdxServer    integer	NOT NULL,

	archFileId			integer	NOT NULL,

	commCellId			integer	NOT NULL,

	appId				integer	NOT NULL,

	pruneTime			integer	NOT NULL,

	backupSetGUID		uniqueidentifier ROWGUIDCOL NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_App_IndexDBInfo]') )
BEGIN
	DROP TABLE #CCM_App_IndexDBInfo
END


CREATE  TABLE   #CCM_App_IndexDBInfo (
	id							INTEGER NOT NULL,

	dbName                      VARCHAR(128) NOT NULL,

	type                        INTEGER	NOT NULL,

	idxDbEngineType             INTEGER	NOT NULL,

	backupSetId                 INT	NOT NULL,

	currentIdxServer            INT	NOT NULL,

	backupSetGUID               uniqueidentifier ROWGUIDCOL NOT NULL,

	properties                  XML NULL,

	isPrimary					INT NOT NULL,

	committedTransactionId      BIGINT DEFAULT 0 NOT NULL,

	archGroupId      			INT DEFAULT 0 NOT NULL,

	flags      					INT DEFAULT 0 NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_App_IndexCheckpointInfo]') )
BEGIN
	DROP TABLE #CCM_App_IndexCheckpointInfo
END


CREATE  TABLE   #CCM_App_IndexCheckpointInfo (
	dbName                	VARCHAR(128) NOT NULL,

	backupSetGUID           uniqueidentifier ROWGUIDCOL NOT NULL,

	afileId					INT	NOT NULL,

	commcellId            	INT	NOT NULL,

	startTime				BIGINT	NOT NULL,

	endTime               	BIGINT	NOT NULL,

	flags      			  	INT DEFAULT 0 NOT NULL,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_GRC_History]') )
BEGIN
	DROP TABLE #CCM_GRC_History
END


CREATE  TABLE   #CCM_GRC_History (
	EntityId							integer	NOT NULL,

	EntityType							integer	NOT NULL,

	DestCCID							integer	NOT NULL,

	SourceCCId 							integer	NOT NULL,

	EntityIdOnSourceCC 					integer	NOT NULL,

	ImportJobIdOnDestCC 				integer	NOT NULL,

	ImportTime							INTEGER  NOT NULL



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDiskHWInfo]') )
BEGIN
	DROP TABLE #CCM_MMDiskHWInfo
END


CREATE  TABLE   #CCM_MMDiskHWInfo (
	diskId			INTEGER NOT NULL, 	-- PRIMARY KEY FOR THIS TABLE

	deviceId		integer	NOT NULL,

	diskSerialNum		varchar(100)	NOT NULL,

	hostId			integer	NOT NULL,

	blockSize		integer	NOT NULL,

	version			integer	NOT NULL,

	numBlocks		bigint	NOT NULL,

	flags			bigint	NOT NULL,

	deviceLocation      varchar(1024)	NOT NULL,

	deviceOSPath		varchar(1024)	NOT NULL,

	backingDevice		varchar(1024)	NOT NULL,

	blockDeviceUUID		varchar(1024)	NOT NULL,

	freeSpaceMB			bigint	NOT NULL,

	diskCapacityMB		bigint	NOT NULL,

	ErrorCode			integer	NOT NULL,

	Properties			XML default '',

	blockNumber			integer default 0	NOT NULL,

	SubVolume			varchar(64)	NOT NULL,

	Vendor				varchar(16)	NOT NULL,

	FileSystem			varchar(32)	NOT NULL,

	Product				varchar(32)	NOT NULL,

	MountOptions		varchar(1024)	NOT NULL,

	BrickFullPath		varchar(1024)	NOT NULL,

	BrickHealth			integer	NOT NULL,

	BlockDeviceHealth	integer	NOT NULL,

	mountPathUsageType	integer	NOT NULL,

	GUID 				UNIQUEIDENTIFIER DEFAULT NEWID(),



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMScaleOutMAInfo]') )
BEGIN
	DROP TABLE #CCM_MMScaleOutMAInfo
END


CREATE  TABLE   #CCM_MMScaleOutMAInfo (
	ClientId 			integer	NOT NULL,

	NetworkInformation          	XML default '',

	GlusterMetaData				varbinary(max) NOT NULL,

	HardwareInformation				XML default '',



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMSDSStoragePool]') )
BEGIN
	DROP TABLE #CCM_MMSDSStoragePool
END


CREATE  TABLE   #CCM_MMSDSStoragePool (
	StoragePoolId				INTEGER NOT NULL,

	StoragePoolName				nvarchar(512)	NOT NULL,

	LibraryId					integer	NOT NULL,

	GDSPId						integer	NOT NULL,

	DisperseFactor				integer	NOT NULL,

	RedundancyFactor			integer	NOT NULL,

	NodesPerBlock				integer	NOT NULL,

	StoragePoolEnabled			integer	NOT NULL,

	NetworkInformation			XML default '',

	Metadata					XML default '',

	StoragePoolStatus			integer NOT null default 0,

	Flags					bigint NOT null default 0,



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CredentialAssoc]') )
BEGIN
	DROP TABLE #CCM_APP_CredentialAssoc
END


CREATE  TABLE   #CCM_APP_CredentialAssoc (
	assocId				INTEGER NOT NULL,

	credentialId		integer	NOT NULL,	-- foreign key to APP_CredentialRecords table

	entityType			integer	NOT NULL,

	entityId			integer	NOT NULL,

	CredAssocGUID		UNIQUEIDENTIFIER DEFAULT NEWSEQUENTIALID(),



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Credentials]') )
BEGIN
	DROP TABLE #CCM_APP_Credentials
END


CREATE  TABLE   #CCM_APP_Credentials (
	credentialId		INTEGER NOT NULL,

	credentialName		NVARCHAR(255),

	recordType			integer	NOT NULL,

	userName		    NVARCHAR(255)	NOT NULL,

	password			nvarchar(400)	NOT NULL,

	description			nvarchar(1024)	NOT NULL,

	created				INTEGER  NOT NULL,

	enabled             integer	NOT NULL,

	flags				integer	NOT NULL,

	credentialGUID		uniqueidentifier default NEWSEQUENTIALID(),

	credentialInfo		xml default '',



) 
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchEncKeys]') )
BEGIN
	DROP TABLE #CCM_ArchEncKeys
END


CREATE  TABLE   #CCM_ArchEncKeys (
	encKeyId		INTEGER NOT NULL,

	clientId		integer	NOT NULL,

	archCopyId		smallint	NOT NULL,

	encRSA			tinyint default 0	NOT NULL,

	encKeyType		int default 0	NOT NULL,

	encKey			varchar(1024)	NOT NULL,

	isActive		tinyint default 0	NOT NULL,

	createTime		INTEGER  NOT NULL,

	expiredTime		INTEGER  NOT NULL,

	origEncKeyId	int	NOT NULL,



) 

END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errCode = ERROR_NUMBER()
	SET @o_errStr = 'Exception in creating CCM_* tables in temp db at ERROR_LINE(): '+ CAST(ERROR_LINE() as varchar(10))+' ERROR_MESSAGE(): ' + ERROR_MESSAGE()
	GOTO CX_ERROR_EXIT
END CATCH
/******** Capture to temp tables *********/
DECLARE @l_subClientStr varchar(max) = ''
DECLARE @l_isDefaultSc integer = 0
IF (@i_flags & 2) > 0
	SET @l_isDefaultSc = 1
IF EXISTS (SELECT 1 FROM @l_Subclients)
BEGIN
	SELECT  @l_subClientStr = @l_subClientStr + CAST (subclientId AS VARCHAR(128)) + '_' FROM @l_Subclients
	SET @l_subClientStr = LEFT(@l_subClientStr, LEN(@l_subClientStr)-1)
	EXEC CCM_Capture_SubClient_to_XML  @l_subClientStr, 0, @i_time_from, @i_time_to, 0,0,0,0,'DUMMY', @l_isDefaultSc, 0,0, 0, 'CommServ'
	SET @o_errCode = (SELECT top 1 errCode FROM #l_errResponse_temp)
	IF (@o_errCode <> 0)
	BEGIN
		SET @o_errStr = 'Error in CCM_Capture_SubClient ' + (SELECT top 1 errStr FROM #l_errResponse_temp)
		GOTO CX_ERROR_EXIT
	END
END
ELSE
BEGIN
	DECLARE @ClientWithNoSubclientsId INT
	DECLARE ClientsWithNoSubClients_Cur CURSOR FOR
SELECT DISTINCT clientId FROM @l_EntitiesTab WHERE EntityType = 3
	OPEN ClientsWithNoSubClients_Cur
	FETCH NEXT FROM ClientsWithNoSubClients_Cur INTO @ClientWithNoSubclientsId
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		IF NOT EXISTS(SELECT 1 FROM APP_Application WHERE clientId = @ClientWithNoSubclientsId)
		BEGIN
			EXEC CCM_Capture_SubClient_to_XML  @l_subClientStr, @ClientWithNoSubclientsId, 0, 0, 0, 0, 0, 0, 'DUMMY', @l_isDefaultSc, 0, 0, 0, 'CommServ'
		END
		FETCH NEXT FROM ClientsWithNoSubClients_Cur INTO @ClientWithNoSubclientsId
	END
	CLOSE ClientsWithNoSubClients_Cur
	DEALLOCATE ClientsWithNoSubClients_Cur
END
DROP TABLE #l_errResponse_temp
/******** Dump captured data from temp tables to xml *********/
BEGIN TRY
set @l_CaptureDataXml =
	(
	select
	--Macro SELECT_CCM_TEMP_TABLES_ALL_AS_XML will be replaced with 'cast((select * from #CCM_<tbl name> for xml raw,root('CCM_<tbl name>')) as xml),'  by DB_SQL_project while building the .sql from .sp

cast((select dbo.NormalizeForXML(oldCopyId) AS oldCopyId, dbo.NormalizeForXML(newCopyId) AS newCopyId, dbo.NormalizeForXML(oldPolicyName) AS oldPolicyName, dbo.NormalizeForXML(oldCopyName) AS oldCopyName, dbo.NormalizeForXML(newMediaAgentId) AS newMediaAgentId, dbo.NormalizeForXML(newLibraryId) AS newLibraryId, dbo.NormalizeForXML(newDataPathId) AS newDataPathId, dbo.NormalizeForXML(newSpareGroupId) AS newSpareGroupId, dbo.NormalizeForXML(LibraryId) AS LibraryId, dbo.NormalizeForXML(LibraryName) AS LibraryName, dbo.NormalizeForXML(ClientId) AS ClientId, dbo.NormalizeForXML(DriveTypeId) AS DriveTypeId, dbo.NormalizeForXML(DrivePoolId) AS DrivePoolId, dbo.NormalizeForXML(flag) AS flag from #CCM_DataPathMapping for xml raw,root('CCM_DataPathMapping')) as xml),
cast((select dbo.NormalizeForXML(old_name) AS old_name, dbo.NormalizeForXML(new_name) AS new_name, dbo.NormalizeForXML(new_net_hostname) AS new_net_hostname from #CCM_ClientNameMapping for xml raw,root('CCM_ClientNameMapping')) as xml),
cast((select dbo.NormalizeForXML(MountPathId) AS MountPathId, dbo.NormalizeForXML(newLibraryId) AS newLibraryId, dbo.NormalizeForXML(newMountPathName) AS newMountPathName, dbo.NormalizeForXML(newUserName) AS newUserName, dbo.NormalizeForXML(newPassword) AS newPassword, dbo.NormalizeForXML(MountPathName) AS MountPathName, dbo.NormalizeForXML(SourceMediaAgentId) AS SourceMediaAgentId, dbo.NormalizeForXML(SourceMediaAgentName) AS SourceMediaAgentName, dbo.NormalizeForXML(MountPathType) AS MountPathType, dbo.NormalizeForXML(TargetDeviceMediaAgentId) AS TargetDeviceMediaAgentId, dbo.NormalizeForXML(SourceDeviceId) AS SourceDeviceId, dbo.NormalizeForXML(SourceDeviceName) AS SourceDeviceName from #CCM_MountPathMapping for xml raw,root('CCM_MountPathMapping')) as xml),
cast((select dbo.NormalizeForXML(Old_clientId) AS Old_clientId, dbo.NormalizeForXML(New_clientId) AS New_clientId, dbo.NormalizeForXML(appType) AS appType, dbo.NormalizeForXML(simProdMapId) AS simProdMapId, dbo.NormalizeForXML(simLicAppType) AS simLicAppType, dbo.NormalizeForXML(simLicName) AS simLicName, dbo.NormalizeForXML(minAppId) AS minAppId from #CCM_ClientLicenses for xml raw,root('CCM_ClientLicenses')) as xml),
cast((select dbo.NormalizeForXML(oldIdxSIDBStoreId) AS oldIdxSIDBStoreId, dbo.NormalizeForXML(oldIdxSIDBStoreName) AS oldIdxSIDBStoreName, dbo.NormalizeForXML(oldIdxAccessPathId) AS oldIdxAccessPathId, dbo.NormalizeForXML(oldStoragePolicyName) AS oldStoragePolicyName, dbo.NormalizeForXML(oldCopyName) AS oldCopyName, dbo.NormalizeForXML(oldClientName) AS oldClientName, dbo.NormalizeForXML(oldPath) AS oldPath, dbo.NormalizeForXML(newClientId) AS newClientId, dbo.NormalizeForXML(newPath) AS newPath, dbo.NormalizeForXML(newUserName) AS newUserName, dbo.NormalizeForXML(newPassword) AS newPassword, dbo.NormalizeForXML(isGlobal) AS isGlobal from #CCM_IdxAccessPathMapping for xml raw,root('CCM_IdxAccessPathMapping')) as xml),
cast((select dbo.NormalizeForXML(OldVMClientId) AS OldVMClientId, dbo.NormalizeForXML(NewVMClientId) AS NewVMClientId, dbo.NormalizeForXML(NewVMName) AS NewVMName, dbo.NormalizeForXML(OldPMClientId) AS OldPMClientId, dbo.NormalizeForXML(NewPMClientId) AS NewPMClientId, dbo.NormalizeForXML(NewPMName) AS NewPMName, dbo.NormalizeForXML(AppType) AS AppType, dbo.NormalizeForXML(LicType) AS LicType from #CCM_VirtualClientLicenses for xml raw,root('CCM_VirtualClientLicenses')) as xml),
cast((select dbo.NormalizeForXML(clientId) AS clientId from #CCM_MountPathLicense for xml raw,root('CCM_MountPathLicense')) as xml),
cast((select dbo.NormalizeForXML(SourceDeviceId) AS SourceDeviceId, dbo.NormalizeForXML(SourceDeviceName) AS SourceDeviceName, dbo.NormalizeForXML(SourceDevicePath) AS SourceDevicePath, dbo.NormalizeForXML(newMediaAgentId) AS newMediaAgentId, dbo.NormalizeForXML(newDevicePath) AS newDevicePath, dbo.NormalizeForXML(newUserName) AS newUserName, dbo.NormalizeForXML(newPassword) AS newPassword from #CCM_DevicePathMapping for xml raw,root('CCM_DevicePathMapping')) as xml),
cast((select dbo.NormalizeForXML(SourceLibraryId) AS SourceLibraryId, dbo.NormalizeForXML(SourceLibraryName) AS SourceLibraryName, dbo.NormalizeForXML(SourceLibraryTypeId) AS SourceLibraryTypeId, dbo.NormalizeForXML(newMediaAgentId) AS newMediaAgentId, dbo.NormalizeForXML(newLibraryId) AS newLibraryId, dbo.NormalizeForXML(newLibraryName) AS newLibraryName from #CCM_LibraryMapping for xml raw,root('CCM_LibraryMapping')) as xml),
cast((select dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(appTypeId) AS appTypeId, dbo.NormalizeForXML(simLicAppType) AS simLicAppType, dbo.NormalizeForXML(simLicName) AS simLicName from #CCM_FeatureLicenses for xml raw,root('CCM_FeatureLicenses')) as xml),
cast((select dbo.NormalizeForXML(MediaId) AS MediaId, dbo.NormalizeForXML(CommCellId) AS CommCellId from #CCM_ReformatedMedia for xml raw,root('CCM_ReformatedMedia')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(number) AS number, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(parentId) AS parentId, dbo.NormalizeForXML(aliasName) AS aliasName, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(refTime) AS refTime, dbo.NormalizeForXML(userName) AS userName, dbo.NormalizeForXML(userPassword) AS userPassword, dbo.NormalizeForXML(smtpServer) AS smtpServer, dbo.NormalizeForXML(timeZone) AS timeZone, dbo.NormalizeForXML(ipAddress) AS ipAddress, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(ccOpMode) AS ccOpMode, dbo.NormalizeForXML(drIpAddress) AS drIpAddress, dbo.NormalizeForXML(encNumber) AS encNumber, dbo.NormalizeForXML(csGUID) AS csGUID, dbo.NormalizeForXML(type) AS type from #CCM_APP_CommCell for xml raw,root('CCM_APP_CommCell')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(simOperatingSystemId) AS simOperatingSystemId, dbo.NormalizeForXML(net_hostname) AS net_hostname, dbo.NormalizeForXML(client_password) AS client_password, dbo.NormalizeForXML(refTime) AS refTime, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(offlineEntity) AS offlineEntity, dbo.NormalizeForXML(offlineTimeStamp) AS offlineTimeStamp, dbo.NormalizeForXML(csHostName) AS csHostName, dbo.NormalizeForXML(clientDescription) AS clientDescription, dbo.NormalizeForXML(jobResultDir) AS jobResultDir, dbo.NormalizeForXML(clientSkewTime) AS clientSkewTime, dbo.NormalizeForXML(cvdPort) AS cvdPort, dbo.NormalizeForXML(evmgrcPort) AS evmgrcPort, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(releaseId) AS releaseId, dbo.NormalizeForXML(spaceCheckFlags) AS spaceCheckFlags, dbo.NormalizeForXML(ccpId) AS ccpId, dbo.NormalizeForXML(ccpTime) AS ccpTime, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(GUID) AS GUID, dbo.NormalizeForXML(specialClientFlags) AS specialClientFlags, dbo.NormalizeForXML(displayName) AS displayName from #CCM_APP_Client for xml raw,root('CCM_APP_Client')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(componentNameId) AS componentNameId, dbo.NormalizeForXML(attrName) AS attrName, dbo.NormalizeForXML(attrType) AS attrType, dbo.NormalizeForXML(attrVal) AS attrVal, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(ccpId) AS ccpId from #CCM_APP_ClientProp for xml raw,root('CCM_APP_ClientProp')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(VMclientId) AS VMclientId, dbo.NormalizeForXML(attrName) AS attrName, dbo.NormalizeForXML(attrType) AS attrType, dbo.NormalizeForXML(attrVal) AS attrVal, dbo.NormalizeForXML(ClientJobId) AS ClientJobId from #CCM_APP_VMProp for xml raw,root('CCM_APP_VMProp')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(clientName) AS clientName, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(category) AS category, dbo.NormalizeForXML(ostype) AS ostype, dbo.NormalizeForXML(discoverPhaseStatus) AS discoverPhaseStatus, dbo.NormalizeForXML(foreignCommCellName) AS foreignCommCellName, clientRegistry, dbo.NormalizeForXML(installedUpdates) AS installedUpdates, dbo.NormalizeForXML(statusMessage) AS statusMessage, dbo.NormalizeForXML(transferStatus) AS transferStatus from #CCM_JMQinetixUpdateStatus for xml raw,root('CCM_JMQinetixUpdateStatus')) as xml),
cast((select dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(platformType) AS platformType, dbo.NormalizeForXML(install_dir) AS install_dir, dbo.NormalizeForXML(refTime) AS refTime from #CCM_APP_Platform for xml raw,root('CCM_APP_Platform')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(appTypeId) AS appTypeId, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(refTime) AS refTime, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(ccpId) AS ccpId, dbo.NormalizeForXML(ccpTime) AS ccpTime from #CCM_APP_IDAName for xml raw,root('CCM_APP_IDAName')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(componentNameId) AS componentNameId, dbo.NormalizeForXML(attrName) AS attrName, dbo.NormalizeForXML(attrType) AS attrType, dbo.NormalizeForXML(attrVal) AS attrVal, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(ccpId) AS ccpId from #CCM_APP_IDAProp for xml raw,root('CCM_APP_IDAProp')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(componentNameId) AS componentNameId, dbo.NormalizeForXML(volName) AS volName, dbo.NormalizeForXML(capacity) AS capacity, dbo.NormalizeForXML(initialRunStatus) AS initialRunStatus, dbo.NormalizeForXML(state) AS state, dbo.NormalizeForXML(refTime) AS refTime, dbo.NormalizeForXML(flags) AS flags from #CCM_APP_DCvolInfo for xml raw,root('CCM_APP_DCvolInfo')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(refTime) AS refTime, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(ccpId) AS ccpId, dbo.NormalizeForXML(ccpTime) AS ccpTime, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(GUID) AS GUID from #CCM_APP_InstanceName for xml raw,root('CCM_APP_InstanceName')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(componentNameId) AS componentNameId, dbo.NormalizeForXML(attrName) AS attrName, dbo.NormalizeForXML(attrType) AS attrType, dbo.NormalizeForXML(attrVal) AS attrVal, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(ccpId) AS ccpId from #CCM_APP_InstanceProp for xml raw,root('CCM_APP_InstanceProp')) as xml),
cast((select dbo.NormalizeForXML(componentNameId) AS componentNameId, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(fileName) AS fileName, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(id) AS id from #CCM_APP_InstFilterFile for xml raw,root('CCM_APP_InstFilterFile')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(refTime) AS refTime, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(ccpId) AS ccpId, dbo.NormalizeForXML(ccpTime) AS ccpTime, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(GUID) AS GUID from #CCM_APP_BackupSetName for xml raw,root('CCM_APP_BackupSetName')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(componentNameId) AS componentNameId, dbo.NormalizeForXML(attrName) AS attrName, dbo.NormalizeForXML(attrType) AS attrType, dbo.NormalizeForXML(attrVal) AS attrVal, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(ccpId) AS ccpId from #CCM_APP_BackupSetProp for xml raw,root('CCM_APP_BackupSetProp')) as xml),
cast((select dbo.NormalizeForXML(componentNameId) AS componentNameId, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(fileName) AS fileName, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified from #CCM_APP_BackupSetFilterFile for xml raw,root('CCM_APP_BackupSetFilterFile')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(appTypeId) AS appTypeId, dbo.NormalizeForXML(instance) AS instance, dbo.NormalizeForXML(backupSet) AS backupSet, dbo.NormalizeForXML(appNumber) AS appNumber, dbo.NormalizeForXML(dataArchGrpID) AS dataArchGrpID, dbo.NormalizeForXML(logArchGrpID) AS logArchGrpID, dbo.NormalizeForXML(refTime) AS refTime, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(subclientName) AS subclientName, dbo.NormalizeForXML(subclientStatus) AS subclientStatus, dbo.NormalizeForXML(ccpId) AS ccpId, dbo.NormalizeForXML(ccpTime) AS ccpTime, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(GUID) AS GUID from #CCM_APP_Application for xml raw,root('CCM_APP_Application')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(componentNameId) AS componentNameId, dbo.NormalizeForXML(attrName) AS attrName, dbo.NormalizeForXML(attrType) AS attrType, dbo.NormalizeForXML(attrVal) AS attrVal, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(ccpId) AS ccpId from #CCM_APP_SubClientProp for xml raw,root('CCM_APP_SubClientProp')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(componentType) AS componentType, dbo.NormalizeForXML(componentId) AS componentId, dbo.NormalizeForXML(propertyTypeId) AS propertyTypeId, dbo.NormalizeForXML(dataType) AS dataType, dbo.NormalizeForXML(longVal) AS longVal, dbo.NormalizeForXML(longlongVal) AS longlongVal, dbo.NormalizeForXML(stringVal) AS stringVal, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified from #CCM_APP_ComponentProp for xml raw,root('CCM_APP_ComponentProp')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(componentNameId) AS componentNameId, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(fileName) AS fileName, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(ccpId) AS ccpId from #CCM_APP_ScFilterFile for xml raw,root('CCM_APP_ScFilterFile')) as xml),
cast((select dbo.NormalizeForXML(VMClientId) AS VMClientId, dbo.NormalizeForXML(PMClientId) AS PMClientId from #CCM_APP_VMToPMMap for xml raw,root('CCM_APP_VMToPMMap')) as xml),
cast((select dbo.NormalizeForXML(VMClientId) AS VMClientId, dbo.NormalizeForXML(ParentBackupSetId) AS ParentBackupSetId, dbo.NormalizeForXML(ChildBackupSetId) AS ChildBackupSetId from #CCM_APP_VMBackupSet for xml raw,root('CCM_APP_VMBackupSet')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(simProdMapId) AS simProdMapId, dbo.NormalizeForXML(simGroupId) AS simGroupId, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(installTime) AS installTime, dbo.NormalizeForXML(buildId) AS buildId, dbo.NormalizeForXML(releaseId) AS releaseId from #CCM_simClientAppsV2 for xml raw,root('CCM_simClientAppsV2')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(release) AS release, dbo.NormalizeForXML(buildNum) AS buildNum from #CCM_simAllGalaxyRel for xml raw,root('CCM_simAllGalaxyRel')) as xml),
cast((select dbo.NormalizeForXML(SPNumber) AS SPNumber, dbo.NormalizeForXML(PatchName) AS PatchName, dbo.NormalizeForXML(AppTypeId) AS AppTypeId, dbo.NormalizeForXML(SpMinorVersion) AS SpMinorVersion, dbo.NormalizeForXML(AliasName) AS AliasName, dbo.NormalizeForXML(StepNo) AS StepNo, dbo.NormalizeForXML(TransactionID) AS TransactionID from #CCM_PatchDBSPInfo for xml raw,root('CCM_PatchDBSPInfo')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(ClientId) AS ClientId, dbo.NormalizeForXML(simPackageID) AS simPackageID, dbo.NormalizeForXML(OpTime) AS OpTime, dbo.NormalizeForXML(OpType) AS OpType, dbo.NormalizeForXML(UserID) AS UserID, dbo.NormalizeForXML(HighestSP) AS HighestSP, dbo.NormalizeForXML(AdditionalPatches) AS AdditionalPatches, dbo.NormalizeForXML(MissingPatches) AS MissingPatches, dbo.NormalizeForXML(Node) AS Node, dbo.NormalizeForXML(IsActive) AS IsActive, dbo.NormalizeForXML(SpMinorVersion) AS SpMinorVersion, dbo.NormalizeForXML(Baseline) AS Baseline, dbo.NormalizeForXML(BaselineDeltaSP) AS BaselineDeltaSP, dbo.NormalizeForXML(BaselineDeltaUpdate) AS BaselineDeltaUpdate, dbo.NormalizeForXML(SPVersionId) AS SPVersionId, dbo.NormalizeForXML(UPNumber) AS UPNumber from #CCM_simInstalledPackages for xml raw,root('CCM_simInstalledPackages')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(simInstalledPkgID) AS simInstalledPkgID, dbo.NormalizeForXML(simPackageID) AS simPackageID, dbo.NormalizeForXML(ClientId) AS ClientId, dbo.NormalizeForXML(InstallState) AS InstallState, dbo.NormalizeForXML(OpType) AS OpType, dbo.NormalizeForXML(PreviousReleaseID) AS PreviousReleaseID, dbo.NormalizeForXML(ReleaseID) AS ReleaseID, dbo.NormalizeForXML(OpTime) AS OpTime, dbo.NormalizeForXML(UserID) AS UserID, dbo.NormalizeForXML(AppType) AS AppType, dbo.NormalizeForXML(LicType) AS LicType from #CCM_simInstalledPackagesHistory for xml raw,root('CCM_simInstalledPackagesHistory')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(OpTimeUTC) AS OpTimeUTC, xmlBlob, xmlResponse from #CCM_simXMLRequest for xml raw,root('CCM_simXMLRequest')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(beginYear) AS beginYear, dbo.NormalizeForXML(beginMonth) AS beginMonth, dbo.NormalizeForXML(beginDate) AS beginDate, dbo.NormalizeForXML(noOfyears) AS noOfyears, dbo.NormalizeForXML(isDefault) AS isDefault, dbo.NormalizeForXML(calType) AS calType, dbo.NormalizeForXML(createdTime) AS createdTime, dbo.NormalizeForXML(modifiedTime) AS modifiedTime, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(GUID) AS GUID from #CCM_APP_CustomCalendar for xml raw,root('CCM_APP_CustomCalendar')) as xml),
cast((select dbo.NormalizeForXML(calendarId) AS calendarId, dbo.NormalizeForXML(year) AS year, dbo.NormalizeForXML(month) AS month, dbo.NormalizeForXML(offset) AS offset, dbo.NormalizeForXML(daysCount) AS daysCount, dbo.NormalizeForXML(startDate) AS startDate, dbo.NormalizeForXML(endDate) AS endDate from #CCM_APP_CustomCalendarMonths for xml raw,root('CCM_APP_CustomCalendarMonths')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(instaceId) AS instaceId, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(oracleHome) AS oracleHome, dbo.NormalizeForXML(oracleUser) AS oracleUser, dbo.NormalizeForXML(parellelInstance) AS parellelInstance, dbo.NormalizeForXML(InstanceOraUser) AS InstanceOraUser, dbo.NormalizeForXML(InstanceOraPasswd) AS InstanceOraPasswd, dbo.NormalizeForXML(InstanceOraService) AS InstanceOraService, dbo.NormalizeForXML(tnsAdmin) AS tnsAdmin, dbo.NormalizeForXML(threadId) AS threadId, dbo.NormalizeForXML(instanceNumber) AS instanceNumber, dbo.NormalizeForXML(flag) AS flag, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(sbtLibName) AS sbtLibName, dbo.NormalizeForXML(ntPassword) AS ntPassword from #CCM_APP_OracleRacInstance for xml raw,root('CCM_APP_OracleRacInstance')) as xml),
cast((select dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(appTypeId) AS appTypeId, dbo.NormalizeForXML(instance) AS instance, dbo.NormalizeForXML(backupSet) AS backupSet, dbo.NormalizeForXML(subclientId) AS subclientId, dbo.NormalizeForXML(attrType) AS attrType, dbo.NormalizeForXML(attrName) AS attrName, dbo.NormalizeForXML(attrVal) AS attrVal, dbo.NormalizeForXML(MD5) AS MD5, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(ccpId) AS ccpId from #CCM_APP_ExtendedProperties for xml raw,root('CCM_APP_ExtendedProperties')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(flag) AS flag, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(userId) AS userId, dbo.NormalizeForXML(refTime) AS refTime, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(fwPorts) AS fwPorts, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(GUID) AS GUID from #CCM_APP_ClientGroup for xml raw,root('CCM_APP_ClientGroup')) as xml),
cast((select dbo.NormalizeForXML(startYear) AS startYear, dbo.NormalizeForXML(startMonth) AS startMonth, dbo.NormalizeForXML(startDay) AS startDay, dbo.NormalizeForXML(startHour) AS startHour, dbo.NormalizeForXML(startMinute) AS startMinute, dbo.NormalizeForXML(startSecond) AS startSecond, dbo.NormalizeForXML(endYear) AS endYear, dbo.NormalizeForXML(endMonth) AS endMonth, dbo.NormalizeForXML(endDay) AS endDay, dbo.NormalizeForXML(endHour) AS endHour, dbo.NormalizeForXML(endMinute) AS endMinute, dbo.NormalizeForXML(endSecond) AS endSecond, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(groupId) AS groupId, dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(vtPolicyId) AS vtPolicyId from #CCM_SchedHoliday for xml raw,root('CCM_SchedHoliday')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(appTypeId) AS appTypeId, dbo.NormalizeForXML(opType) AS opType, dbo.NormalizeForXML(daysOfWeek) AS daysOfWeek, dbo.NormalizeForXML(startTime) AS startTime, dbo.NormalizeForXML(endTime) AS endTime, dbo.NormalizeForXML(enable) AS enable, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(utilization) AS utilization, dbo.NormalizeForXML(clientGroupId) AS clientGroupId, dbo.NormalizeForXML(instanceId) AS instanceId, dbo.NormalizeForXML(backupsetId) AS backupsetId, dbo.NormalizeForXML(subclientId) AS subclientId, dbo.NormalizeForXML(startDate) AS startDate, dbo.NormalizeForXML(endDate) AS endDate, dbo.NormalizeForXML(schedulePolicyId) AS schedulePolicyId, dbo.NormalizeForXML(weekOfTheMonth) AS weekOfTheMonth, dbo.NormalizeForXML(doNotSubmitJob) AS doNotSubmitJob from #CCM_APP_OpWindowRule for xml raw,root('CCM_APP_OpWindowRule')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(mdbNode) AS mdbNode, dbo.NormalizeForXML(subclientId) AS subclientId, dbo.NormalizeForXML(priority) AS priority from #CCM_APP_MongoDbSCPriority for xml raw,root('CCM_APP_MongoDbSCPriority')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(defaultCopy) AS defaultCopy, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(maxStreams) AS maxStreams, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(incrSP) AS incrSP, dbo.NormalizeForXML(origCCcommCellID) AS origCCcommCellID, dbo.NormalizeForXML(origCCarchGroupId) AS origCCarchGroupId, dbo.NormalizeForXML(defaultSnapCopy) AS defaultSnapCopy, dbo.NormalizeForXML(SIBlockSizeKB) AS SIBlockSizeKB, dbo.NormalizeForXML(AuxCopyAlertGB) AS AuxCopyAlertGB, dbo.NormalizeForXML(AuxCopyAlertDays) AS AuxCopyAlertDays, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(mediaPassword) AS mediaPassword, dbo.NormalizeForXML(TimeZoneType) AS TimeZoneType, dbo.NormalizeForXML(TimeZone) AS TimeZone, dbo.NormalizeForXML(SubclientExtensionTimeStamp) AS SubclientExtensionTimeStamp, dbo.NormalizeForXML(SubclientExtensionTimeStampEncrypted) AS SubclientExtensionTimeStampEncrypted, dbo.NormalizeForXML(logSP) AS logSP from #CCM_archGroup for xml raw,root('CCM_archGroup')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(archGroupId) AS archGroupId, dbo.NormalizeForXML(copy) AS copy, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(maxMultiplex) AS maxMultiplex, dbo.NormalizeForXML(isActive) AS isActive, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(startTime) AS startTime, dbo.NormalizeForXML(waitForIfOffline) AS waitForIfOffline, dbo.NormalizeForXML(waitForIfBusy) AS waitForIfBusy, dbo.NormalizeForXML(archCheckStartTime) AS archCheckStartTime, dbo.NormalizeForXML(origCCcommCellID) AS origCCcommCellID, dbo.NormalizeForXML(origCCarchCopyId) AS origCCarchCopyId, dbo.NormalizeForXML(sourceCopyId) AS sourceCopyId, dbo.NormalizeForXML(delayedDays) AS delayedDays, dbo.NormalizeForXML(maxStreamNum) AS maxStreamNum, dbo.NormalizeForXML(archCheckValidPeriod) AS archCheckValidPeriod, dbo.NormalizeForXML(calendarId) AS calendarId, dbo.NormalizeForXML(SIDBStoreId) AS SIDBStoreId, dbo.NormalizeForXML(encType) AS encType, dbo.NormalizeForXML(encKeyLen) AS encKeyLen, dbo.NormalizeForXML(isSnapCopy) AS isSnapCopy, dbo.NormalizeForXML(isMirrorCopy) AS isMirrorCopy, dbo.NormalizeForXML(NWWriteSpeed) AS NWWriteSpeed, dbo.NormalizeForXML(SIDBSnapIntervalHours) AS SIDBSnapIntervalHours, dbo.NormalizeForXML(siloAppId) AS siloAppId, dbo.NormalizeForXML(nDataInstance) AS nDataInstance, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(dedupeFlags) AS dedupeFlags, dbo.NormalizeForXML(blockCacheValidDays) AS blockCacheValidDays, dbo.NormalizeForXML(nSiloStreams) AS nSiloStreams, dbo.NormalizeForXML(silosInCache) AS silosInCache, dbo.NormalizeForXML(siloRestoreMAClientId) AS siloRestoreMAClientId, dbo.NormalizeForXML(siloRestoreClientId) AS siloRestoreClientId, dbo.NormalizeForXML(sealStoreTaskId) AS sealStoreTaskId, dbo.NormalizeForXML(extendedFlags) AS extendedFlags, dbo.NormalizeForXML(destMediaCopyId) AS destMediaCopyId, dbo.NormalizeForXML(maxCacheDBSizeMB) AS maxCacheDBSizeMB, dbo.NormalizeForXML(DDBLimitExtensionTimeStamp) AS DDBLimitExtensionTimeStamp, dbo.NormalizeForXML(DDBLimitExtensionTimeStampEncrypted) AS DDBLimitExtensionTimeStampEncrypted, dbo.NormalizeForXML(archCheckValidPeriodType) AS archCheckValidPeriodType, dbo.NormalizeForXML(endTime) AS endTime from #CCM_archGroupCopy for xml raw,root('CCM_archGroupCopy')) as xml),
cast((select dbo.NormalizeForXML(copyId) AS copyId, dbo.NormalizeForXML(targetCopyId) AS targetCopyId, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(daysAfterWritten) AS daysAfterWritten, dbo.NormalizeForXML(daysBeforeAged) AS daysBeforeAged, dbo.NormalizeForXML(percentage) AS percentage from #CCM_archCopyMediaRefreshProp for xml raw,root('CCM_archCopyMediaRefreshProp')) as xml),
cast((select dbo.NormalizeForXML(copyId) AS copyId, dbo.NormalizeForXML(globalPolicyId) AS globalPolicyId, dbo.NormalizeForXML(flags) AS flags from #CCM_archCopyToGlobalPolicy for xml raw,root('CCM_archCopyToGlobalPolicy')) as xml),
cast((select dbo.NormalizeForXML(archGroupId) AS archGroupId, dbo.NormalizeForXML(archGroupCopyId) AS archGroupCopyId, dbo.NormalizeForXML(stream) AS stream, dbo.NormalizeForXML(mediaGroupId) AS mediaGroupId, dbo.NormalizeForXML(isActive) AS isActive, dbo.NormalizeForXML(lastUsedTime) AS lastUsedTime, dbo.NormalizeForXML(physicalDataSizeInGB) AS physicalDataSizeInGB, dbo.NormalizeForXML(flags) AS flags from #CCM_archStream for xml raw,root('CCM_archStream')) as xml),
cast((select dbo.NormalizeForXML(copyId) AS copyId, dbo.NormalizeForXML(retentionDays) AS retentionDays, dbo.NormalizeForXML(fullCycles) AS fullCycles, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(weekStart) AS weekStart, dbo.NormalizeForXML(monthStart) AS monthStart, dbo.NormalizeForXML(yearStart) AS yearStart, dbo.NormalizeForXML(archiverRetDays) AS archiverRetDays, dbo.NormalizeForXML(retentionJobs) AS retentionJobs, dbo.NormalizeForXML(minutesSinceDayStarts) AS minutesSinceDayStarts from #CCM_archAgingRule for xml raw,root('CCM_archAgingRule')) as xml),
cast((select dbo.NormalizeForXML(copyId) AS copyId, dbo.NormalizeForXML(retentionDays) AS retentionDays, dbo.NormalizeForXML(retentionRule) AS retentionRule, dbo.NormalizeForXML(currPeriodBegin) AS currPeriodBegin, dbo.NormalizeForXML(currPeriodEnd) AS currPeriodEnd, dbo.NormalizeForXML(prevPeriodBegin) AS prevPeriodBegin, dbo.NormalizeForXML(nextPeriodEnd) AS nextPeriodEnd, dbo.NormalizeForXML(GraceDays) AS GraceDays, dbo.NormalizeForXML(EveryXHours) AS EveryXHours from #CCM_archAgingRuleExtended for xml raw,root('CCM_archAgingRuleExtended')) as xml),
cast((select dbo.NormalizeForXML(appId) AS appId, dbo.NormalizeForXML(copyId) AS copyId, dbo.NormalizeForXML(retentionDays) AS retentionDays, dbo.NormalizeForXML(fullCycles) AS fullCycles, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(weekStart) AS weekStart, dbo.NormalizeForXML(monthStart) AS monthStart, dbo.NormalizeForXML(yearStart) AS yearStart, dbo.NormalizeForXML(archiverRetDays) AS archiverRetDays, dbo.NormalizeForXML(retentionJobs) AS retentionJobs, dbo.NormalizeForXML(minutesSinceDayStarts) AS minutesSinceDayStarts, dbo.NormalizeForXML(archGrpId) AS archGrpId from #CCM_archAppCopyAgingRule for xml raw,root('CCM_archAppCopyAgingRule')) as xml),
cast((select dbo.NormalizeForXML(appId) AS appId, dbo.NormalizeForXML(copyId) AS copyId, dbo.NormalizeForXML(retentionDays) AS retentionDays, dbo.NormalizeForXML(retentionRule) AS retentionRule, dbo.NormalizeForXML(GraceDays) AS GraceDays, dbo.NormalizeForXML(EveryXHours) AS EveryXHours, dbo.NormalizeForXML(archGrpId) AS archGrpId from #CCM_archAppCopyAgingRuleExtended for xml raw,root('CCM_archAppCopyAgingRuleExtended')) as xml),
cast((select dbo.NormalizeForXML(copyId) AS copyId, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(numPeriod) AS numPeriod, dbo.NormalizeForXML(dayNumber) AS dayNumber, dbo.NormalizeForXML(startPeriod) AS startPeriod, dbo.NormalizeForXML(nextPeriod) AS nextPeriod, dbo.NormalizeForXML(prevPeriodBegin) AS prevPeriodBegin, dbo.NormalizeForXML(nextPeriodEnd) AS nextPeriodEnd from #CCM_archSelectiveCopy for xml raw,root('CCM_archSelectiveCopy')) as xml),
cast((select dbo.NormalizeForXML(copyId) AS copyId, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(appTypeId) AS appTypeId, dbo.NormalizeForXML(instanceId) AS instanceId, dbo.NormalizeForXML(backupSetId) AS backupSetId, dbo.NormalizeForXML(subClientId) AS subClientId, dbo.NormalizeForXML(clientGroupId) AS clientGroupId, dbo.NormalizeForXML(exclude) AS exclude, dbo.NormalizeForXML(assocType) AS assocType from #CCM_archCopyToApp for xml raw,root('CCM_archCopyToApp')) as xml),
cast((select dbo.NormalizeForXML(CopyId) AS CopyId, dbo.NormalizeForXML(SIDBStoreId) AS SIDBStoreId, dbo.NormalizeForXML(CommCellId) AS CommCellId, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(TotalDataSizeBytes) AS TotalDataSizeBytes, dbo.NormalizeForXML(InstancedDataSizeBytes) AS InstancedDataSizeBytes from #CCM_archCopySIDBStore for xml raw,root('CCM_archCopySIDBStore')) as xml),
cast((select dbo.NormalizeForXML(KeyProviderId) AS KeyProviderId, dbo.NormalizeForXML(KeyProviderName) AS KeyProviderName, dbo.NormalizeForXML(KeyProviderType) AS KeyProviderType, dbo.NormalizeForXML(EncType) AS EncType, dbo.NormalizeForXML(EncKeyLength) AS EncKeyLength, dbo.NormalizeForXML(Properties) AS Properties, dbo.NormalizeForXML(Modified) AS Modified, dbo.NormalizeForXML(Created) AS Created, dbo.NormalizeForXML(GUID) AS GUID from #CCM_ArchEncKeyProvider for xml raw,root('CCM_ArchEncKeyProvider')) as xml),
cast((select dbo.NormalizeForXML(KeyProviderAssocId) AS KeyProviderAssocId, dbo.NormalizeForXML(KeyProviderId) AS KeyProviderId, dbo.NormalizeForXML(EntityId) AS EntityId, dbo.NormalizeForXML(EntityType) AS EntityType from #CCM_ArchEncKeyProviderAssoc for xml raw,root('CCM_ArchEncKeyProviderAssoc')) as xml),
cast((select dbo.NormalizeForXML(CopyId) AS CopyId, dbo.NormalizeForXML(PubKey) AS PubKey, dbo.NormalizeForXML(PriKey) AS PriKey, dbo.NormalizeForXML(MasterKeyId) AS MasterKeyId, dbo.NormalizeForXML(KeyProviderId) AS KeyProviderId, dbo.NormalizeForXML(EncType) AS EncType, dbo.NormalizeForXML(LastValidatedTime) AS LastValidatedTime from #CCM_ArchCopyEncProperties for xml raw,root('CCM_ArchCopyEncProperties')) as xml),
cast((select dbo.NormalizeForXML(appNumber) AS appNumber, dbo.NormalizeForXML(compressWhere) AS compressWhere, dbo.NormalizeForXML(numNWAgents) AS numNWAgents, dbo.NormalizeForXML(NWWriteSpeed) AS NWWriteSpeed from #CCM_archPipeConfig for xml raw,root('CCM_archPipeConfig')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(archGroupId) AS archGroupId, dbo.NormalizeForXML(objName1) AS objName1, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(appId) AS appId, dbo.NormalizeForXML(fileType) AS fileType, dbo.NormalizeForXML(cTime) AS cTime, dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(backupLevel) AS backupLevel, dbo.NormalizeForXML(isValid) AS isValid, dbo.NormalizeForXML(cloudId) AS cloudId, dbo.NormalizeForXML(contentIndexTime) AS contentIndexTime, dbo.NormalizeForXML(nPushedItems) AS nPushedItems from #CCM_archFile for xml raw,root('CCM_archFile')) as xml),
cast((select dbo.NormalizeForXML(archFileId) AS archFileId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(appId) AS appId, dbo.NormalizeForXML(instanceId) AS instanceId, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(archFileName) AS archFileName, dbo.NormalizeForXML(fileType) AS fileType, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(jobId) AS jobId from #CCM_archFileOracle for xml raw,root('CCM_archFileOracle')) as xml),
cast((select dbo.NormalizeForXML(archFileId) AS archFileId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(instanceId) AS instanceId, dbo.NormalizeForXML(backupPiece) AS backupPiece, dbo.NormalizeForXML(offset) AS offset from #CCM_archFileOracleBackupPiece for xml raw,root('CCM_archFileOracleBackupPiece')) as xml),
cast((select dbo.NormalizeForXML(archFileId) AS archFileId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(archCopyId) AS archCopyId, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(isValid) AS isValid, dbo.NormalizeForXML(streamNum) AS streamNum, dbo.NormalizeForXML(lastChunkNumber) AS lastChunkNumber, dbo.NormalizeForXML(physicalSize) AS physicalSize, dbo.NormalizeForXML(logicalSize) AS logicalSize, dbo.NormalizeForXML(drivePoolId) AS drivePoolId, dbo.NormalizeForXML(encRSA) AS encRSA, dbo.NormalizeForXML(encKeyType) AS encKeyType, dbo.NormalizeForXML(encKey) AS encKey, dbo.NormalizeForXML(modifiedTime) AS modifiedTime, dbo.NormalizeForXML(mediaType) AS mediaType, dbo.NormalizeForXML(agedBy) AS agedBy, dbo.NormalizeForXML(encKeyId) AS encKeyId, dbo.NormalizeForXML(unCompSize) AS unCompSize from #CCM_archFileCopy for xml raw,root('CCM_archFileCopy')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(volumeId) AS volumeId, dbo.NormalizeForXML(fileMarkerNo) AS fileMarkerNo, dbo.NormalizeForXML(createTime) AS createTime, dbo.NormalizeForXML(version) AS version, dbo.NormalizeForXML(cclip) AS cclip, dbo.NormalizeForXML(physicalSize) AS physicalSize, dbo.NormalizeForXML(logicalSize) AS logicalSize, dbo.NormalizeForXML(writeTime) AS writeTime, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(modifiedTime) AS modifiedTime, dbo.NormalizeForXML(hwEncKey) AS hwEncKey, dbo.NormalizeForXML(agedBy) AS agedBy, dbo.NormalizeForXML(origCCId) AS origCCId from #CCM_archChunk for xml raw,root('CCM_archChunk')) as xml),
cast((select dbo.NormalizeForXML(archChunkId) AS archChunkId, dbo.NormalizeForXML(archFileId) AS archFileId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(archCopyId) AS archCopyId, dbo.NormalizeForXML(chunkNumber) AS chunkNumber, dbo.NormalizeForXML(physicalOffset) AS physicalOffset, dbo.NormalizeForXML(logicalOffset) AS logicalOffset, dbo.NormalizeForXML(physicalSize) AS physicalSize, dbo.NormalizeForXML(logicalSize) AS logicalSize, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(modifiedTime) AS modifiedTime, dbo.NormalizeForXML(dedupedSize) AS dedupedSize, dbo.NormalizeForXML(agedBy) AS agedBy, dbo.NormalizeForXML(chunkCommCellId) AS chunkCommCellId, dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(unCompSize) AS unCompSize from #CCM_archChunkMapping for xml raw,root('CCM_archChunkMapping')) as xml),
cast((select dbo.NormalizeForXML(archFileId) AS archFileId, dbo.NormalizeForXML(firstLogTime) AS firstLogTime, dbo.NormalizeForXML(lastLogTime) AS lastLogTime, dbo.NormalizeForXML(firstLogNumber) AS firstLogNumber, dbo.NormalizeForXML(lastLogNumber) AS lastLogNumber, dbo.NormalizeForXML(commCellId) AS commCellId from #CCM_archDB2Log for xml raw,root('CCM_archDB2Log')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(archCopyId) AS archCopyId, dbo.NormalizeForXML(adminJobId) AS adminJobId, dbo.NormalizeForXML(adminJobType) AS adminJobType, dbo.NormalizeForXML(archCheckEndTime) AS archCheckEndTime, dbo.NormalizeForXML(archCheckStatus) AS archCheckStatus, dbo.NormalizeForXML(errorString) AS errorString, dbo.NormalizeForXML(flags) AS flags from #CCM_archCheckHistory for xml raw,root('CCM_archCheckHistory')) as xml),
cast((select dbo.NormalizeForXML(archFileId) AS archFileId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(siloVolumeId) AS siloVolumeId, dbo.NormalizeForXML(lastSiloChunkId) AS lastSiloChunkId, dbo.NormalizeForXML(flags) AS flags from #CCM_archFileSiloVolume for xml raw,root('CCM_archFileSiloVolume')) as xml),
cast((select dbo.NormalizeForXML(archChunkId) AS archChunkId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(volumeId) AS volumeId, dbo.NormalizeForXML(flags) AS flags from #CCM_archChunkToSilo for xml raw,root('CCM_archChunkToSilo')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(servStartDate) AS servStartDate, dbo.NormalizeForXML(servEndDate) AS servEndDate, dbo.NormalizeForXML(appId) AS appId, dbo.NormalizeForXML(appType) AS appType, dbo.NormalizeForXML(archGrpId) AS archGrpId, dbo.NormalizeForXML(archGrpCopyId) AS archGrpCopyId, dbo.NormalizeForXML(bkpLevel) AS bkpLevel, dbo.NormalizeForXML(opType) AS opType, dbo.NormalizeForXML(retentionFlags) AS retentionFlags, dbo.NormalizeForXML(flags) AS flags from #CCM_archFailedKilledJobInfo for xml raw,root('CCM_archFailedKilledJobInfo')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(opType) AS opType, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(jobCategory) AS jobCategory, dbo.NormalizeForXML(jobDescription) AS jobDescription, dbo.NormalizeForXML(xmlJobInfo) AS xmlJobInfo, dbo.NormalizeForXML(subOpType) AS subOpType, dbo.NormalizeForXML(foreignToken) AS foreignToken from #CCM_JMJobStats for xml raw,root('CCM_JMJobStats')) as xml),
cast((select dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(mediaAgentID) AS mediaAgentID, dbo.NormalizeForXML(appType) AS appType, dbo.NormalizeForXML(opType) AS opType, dbo.NormalizeForXML(action) AS action, dbo.NormalizeForXML(appId) AS appId, dbo.NormalizeForXML(clientGroupId) AS clientGroupId, dbo.NormalizeForXML(enableTimeZone) AS enableTimeZone, dbo.NormalizeForXML(enableTime) AS enableTime, dbo.NormalizeForXML(UNCenableTime) AS UNCenableTime, dbo.NormalizeForXML(instanceID) AS instanceID, dbo.NormalizeForXML(reason) AS reason from #CCM_JMJobAction for xml raw,root('CCM_JMJobAction')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(appId) AS appId, dbo.NormalizeForXML(appType) AS appType, dbo.NormalizeForXML(numAttempts) AS numAttempts, dbo.NormalizeForXML(dataArchGrpId) AS dataArchGrpId, dbo.NormalizeForXML(copyID) AS copyID, dbo.NormalizeForXML(bkpLevel) AS bkpLevel, dbo.NormalizeForXML(indexOverride) AS indexOverride, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(duration) AS duration, dbo.NormalizeForXML(numStreams) AS numStreams, dbo.NormalizeForXML(servStartDate) AS servStartDate, dbo.NormalizeForXML(servEndDate) AS servEndDate, dbo.NormalizeForXML(opType) AS opType, dbo.NormalizeForXML(fullCycleNum) AS fullCycleNum, dbo.NormalizeForXML(initFrom) AS initFrom, dbo.NormalizeForXML(failureReason) AS failureReason, dbo.NormalizeForXML(bkpOptions) AS bkpOptions, dbo.NormalizeForXML(scanFileFailures) AS scanFileFailures, dbo.NormalizeForXML(scanFolderFailures) AS scanFolderFailures, dbo.NormalizeForXML(backupFileFailures) AS backupFileFailures, dbo.NormalizeForXML(backupFolderFailures) AS backupFolderFailures, dbo.NormalizeForXML(oraSubLevel) AS oraSubLevel, dbo.NormalizeForXML(username) AS username, dbo.NormalizeForXML(totalWriteTime) AS totalWriteTime, dbo.NormalizeForXML(priority) AS priority, dbo.NormalizeForXML(totalCompBytes) AS totalCompBytes, dbo.NormalizeForXML(totalUncompBytes) AS totalUncompBytes, dbo.NormalizeForXML(totalNumOfFiles) AS totalNumOfFiles, dbo.NormalizeForXML(bkpattributes) AS bkpattributes, dbo.NormalizeForXML(logArchGrpId) AS logArchGrpId, dbo.NormalizeForXML(totalNumOfFolders) AS totalNumOfFolders, dbo.NormalizeForXML(failureErrorCode) AS failureErrorCode, dbo.NormalizeForXML(lastIncrJobTime) AS lastIncrJobTime, dbo.NormalizeForXML(scanType) AS scanType, dbo.NormalizeForXML(scanTypeChangeReason) AS scanTypeChangeReason, dbo.NormalizeForXML(numStreamsRequested) AS numStreamsRequested, dbo.NormalizeForXML(dataStatus) AS dataStatus, dbo.NormalizeForXML(agedTime) AS agedTime, dbo.NormalizeForXML(mediaDeletedTime) AS mediaDeletedTime, dbo.NormalizeForXML(modifiedTime) AS modifiedTime, dbo.NormalizeForXML(version) AS version, dbo.NormalizeForXML(idaVersion) AS idaVersion, dbo.NormalizeForXML(cIndexTime) AS cIndexTime, dbo.NormalizeForXML(cycleSequence) AS cycleSequence, dbo.NormalizeForXML(filesToXfer) AS filesToXfer, dbo.NormalizeForXML(cloudId) AS cloudId, dbo.NormalizeForXML(diffArchGrpId) AS diffArchGrpId, dbo.NormalizeForXML(totalBackupSize) AS totalBackupSize, dbo.NormalizeForXML(percentageChange) AS percentageChange, dbo.NormalizeForXML(targetClientId) AS targetClientId, dbo.NormalizeForXML(totalUncompBytesToXfer) AS totalUncompBytesToXfer, dbo.NormalizeForXML(displayStatus) AS displayStatus, dbo.NormalizeForXML(dataBackedUp) AS dataBackedUp, dbo.NormalizeForXML(logsBackedUp) AS logsBackedUp, dbo.NormalizeForXML(openChain) AS openChain, dbo.NormalizeForXML(secondaryBkpLevel) AS secondaryBkpLevel, dbo.NormalizeForXML(jobIdPrepared) AS jobIdPrepared, dbo.NormalizeForXML(jobIdActedOn) AS jobIdActedOn, dbo.NormalizeForXML(fromTime) AS fromTime, dbo.NormalizeForXML(toTime) AS toTime, dbo.NormalizeForXML(subTaskId) AS subTaskId, dbo.NormalizeForXML(nwTransBytes) AS nwTransBytes, dbo.NormalizeForXML(totSkippedObjects) AS totSkippedObjects, dbo.NormalizeForXML(bkpAttributesEx) AS bkpAttributesEx, dbo.NormalizeForXML(jobReferenceTime) AS jobReferenceTime from #CCM_JMBkpStats for xml raw,root('CCM_JMBkpStats')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(number) AS number, dbo.NormalizeForXML(phase) AS phase, dbo.NormalizeForXML(elapsedTime) AS elapsedTime, dbo.NormalizeForXML(servStartDate) AS servStartDate, dbo.NormalizeForXML(servEndDate) AS servEndDate, dbo.NormalizeForXML(unCompBytes) AS unCompBytes, dbo.NormalizeForXML(compBytes) AS compBytes, dbo.NormalizeForXML(numObjects) AS numObjects, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(failureReason) AS failureReason, dbo.NormalizeForXML(writeTime) AS writeTime, dbo.NormalizeForXML(restartString) AS restartString, dbo.NormalizeForXML(attributes) AS attributes, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(numFolders) AS numFolders, dbo.NormalizeForXML(archGrpId) AS archGrpId, dbo.NormalizeForXML(copyId) AS copyId, dbo.NormalizeForXML(maxStreamsUsed) AS maxStreamsUsed, dbo.NormalizeForXML(modifiedTime) AS modifiedTime, dbo.NormalizeForXML(nwTransBytes) AS nwTransBytes, dbo.NormalizeForXML(totalAllocationTime) AS totalAllocationTime, dbo.NormalizeForXML(totalWaitTimeBeforeAllocation) AS totalWaitTimeBeforeAllocation, dbo.NormalizeForXML(readThroughput) AS readThroughput, dbo.NormalizeForXML(writeThroughput) AS writeThroughput, dbo.NormalizeForXML(networkThroughput) AS networkThroughput, dbo.NormalizeForXML(sidbLookups) AS sidbLookups, dbo.NormalizeForXML(mediaAgent) AS mediaAgent from #CCM_JMBkpAtmptStats for xml raw,root('CCM_JMBkpAtmptStats')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(opType) AS opType, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(servStart) AS servStart, dbo.NormalizeForXML(servEnd) AS servEnd, dbo.NormalizeForXML(archGrpID) AS archGrpID, dbo.NormalizeForXML(archGrpName) AS archGrpName, dbo.NormalizeForXML(AP_NumDays) AS AP_NumDays, dbo.NormalizeForXML(AP_IsForecast) AS AP_IsForecast, dbo.NormalizeForXML(AP_SeqNum) AS AP_SeqNum, dbo.NormalizeForXML(AC_NewMediaFlag) AS AC_NewMediaFlag, dbo.NormalizeForXML(ER_BkpLevel) AS ER_BkpLevel, dbo.NormalizeForXML(ER_DbName) AS ER_DbName, dbo.NormalizeForXML(ER_Destination) AS ER_Destination, dbo.NormalizeForXML(ER_SendCount) AS ER_SendCount, dbo.NormalizeForXML(ER_MediasUsed) AS ER_MediasUsed, dbo.NormalizeForXML(EX_TotalMedia) AS EX_TotalMedia, dbo.NormalizeForXML(EX_TotalSuccess) AS EX_TotalSuccess, dbo.NormalizeForXML(EX_TotalFailures) AS EX_TotalFailures, dbo.NormalizeForXML(initFrom) AS initFrom, dbo.NormalizeForXML(failureReason) AS failureReason, dbo.NormalizeForXML(archGrpCopyID) AS archGrpCopyID, dbo.NormalizeForXML(LibraryID) AS LibraryID, dbo.NormalizeForXML(MI_InventoryType) AS MI_InventoryType, dbo.NormalizeForXML(username) AS username, dbo.NormalizeForXML(totalWriteTime) AS totalWriteTime, dbo.NormalizeForXML(noOfStreams) AS noOfStreams, dbo.NormalizeForXML(priority) AS priority, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(appID) AS appID, dbo.NormalizeForXML(failureErrorCode) AS failureErrorCode, dbo.NormalizeForXML(TotalSize) AS TotalSize, dbo.NormalizeForXML(fullCycleNum) AS fullCycleNum, dbo.NormalizeForXML(dataStatus) AS dataStatus, dbo.NormalizeForXML(workFlowId) AS workFlowId, dbo.NormalizeForXML(embeddedObjects) AS embeddedObjects, dbo.NormalizeForXML(uncompBytes) AS uncompBytes, dbo.NormalizeForXML(numFiles) AS numFiles, dbo.NormalizeForXML(skippedItems) AS skippedItems, dbo.NormalizeForXML(jobFlags) AS jobFlags, dbo.NormalizeForXML(cloudId) AS cloudId, dbo.NormalizeForXML(successIndex) AS successIndex, dbo.NormalizeForXML(failIndex) AS failIndex, dbo.NormalizeForXML(totalBackupSize) AS totalBackupSize, dbo.NormalizeForXML(version) AS version, dbo.NormalizeForXML(fromTime) AS fromTime, dbo.NormalizeForXML(toTime) AS toTime, dbo.NormalizeForXML(subTaskId) AS subTaskId, dbo.NormalizeForXML(otherOpName) AS otherOpName, dbo.NormalizeForXML(nwTransBytes) AS nwTransBytes from #CCM_JMAdminJobStatsTable for xml raw,root('CCM_JMAdminJobStatsTable')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(attemptNum) AS attemptNum, dbo.NormalizeForXML(phaseNum) AS phaseNum, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(startTime) AS startTime, dbo.NormalizeForXML(endTime) AS endTime, dbo.NormalizeForXML(elapsedTime) AS elapsedTime, dbo.NormalizeForXML(failureReason) AS failureReason, dbo.NormalizeForXML(writeTime) AS writeTime, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(embeddedObjects) AS embeddedObjects, dbo.NormalizeForXML(uncompBytes) AS uncompBytes, dbo.NormalizeForXML(numFiles) AS numFiles, dbo.NormalizeForXML(skippedItems) AS skippedItems, dbo.NormalizeForXML(TotalSize) AS TotalSize, dbo.NormalizeForXML(nwTransBytes) AS nwTransBytes, dbo.NormalizeForXML(totalAllocationTime) AS totalAllocationTime, dbo.NormalizeForXML(totalWaitTimeBeforeAllocation) AS totalWaitTimeBeforeAllocation from #CCM_JMAdminJobAttemptStatsTable for xml raw,root('CCM_JMAdminJobAttemptStatsTable')) as xml),
cast((select dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(parentJobId) AS parentJobId, dbo.NormalizeForXML(childJobId) AS childJobId, dbo.NormalizeForXML(parentAppid) AS parentAppid, dbo.NormalizeForXML(childAppid) AS childAppid, dbo.NormalizeForXML(linkType) AS linkType, dbo.NormalizeForXML(childJobStatus) AS childJobStatus from #CCM_JMJobDataLink for xml raw,root('CCM_JMJobDataLink')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(attributeId) AS attributeId, dbo.NormalizeForXML(attributeName) AS attributeName, dbo.NormalizeForXML(attributeValueInt) AS attributeValueInt, dbo.NormalizeForXML(attributeValue) AS attributeValue, dbo.NormalizeForXML(id) AS id from #CCM_JMJobOptions for xml raw,root('CCM_JMJobOptions')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(archGrpId) AS archGrpId, dbo.NormalizeForXML(archGrpCopyId) AS archGrpCopyId, dbo.NormalizeForXML(dataType) AS dataType, dbo.NormalizeForXML(opType) AS opType, dbo.NormalizeForXML(auxCopyJobId) AS auxCopyJobId, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(disabled) AS disabled, dbo.NormalizeForXML(appId) AS appId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(archCheckEndTime) AS archCheckEndTime, dbo.NormalizeForXML(archCheckStatus) AS archCheckStatus, dbo.NormalizeForXML(retentionFlags) AS retentionFlags, dbo.NormalizeForXML(manualRetentionEndTime) AS manualRetentionEndTime, dbo.NormalizeForXML(copiedTime) AS copiedTime, dbo.NormalizeForXML(agedTime) AS agedTime, dbo.NormalizeForXML(mediaDeletedTime) AS mediaDeletedTime, dbo.NormalizeForXML(modifiedTime) AS modifiedTime, dbo.NormalizeForXML(sizeOnMedia) AS sizeOnMedia, dbo.NormalizeForXML(agedBy) AS agedBy, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(jobSelectionTime) AS jobSelectionTime, dbo.NormalizeForXML(auxCopyStatus) AS auxCopyStatus, dbo.NormalizeForXML(unCompSize) AS unCompSize from #CCM_JMJobDataStats for xml raw,root('CCM_JMJobDataStats')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(phaseNumber) AS phaseNumber, dbo.NormalizeForXML(attemptNumber) AS attemptNumber, dbo.NormalizeForXML(racInstanceId) AS racInstanceId, dbo.NormalizeForXML(racHostId) AS racHostId, dbo.NormalizeForXML(isControlHost) AS isControlHost from #CCM_JMOracleRACClientsUsed for xml raw,root('CCM_JMOracleRACClientsUsed')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(initFrom) AS initFrom, dbo.NormalizeForXML(opType) AS opType, dbo.NormalizeForXML(userId) AS userId, dbo.NormalizeForXML(clientPriority) AS clientPriority, dbo.NormalizeForXML(opPriority) AS opPriority, dbo.NormalizeForXML(appPriority) AS appPriority, dbo.NormalizeForXML(combPriority) AS combPriority, dbo.NormalizeForXML(currentPhase) AS currentPhase, dbo.NormalizeForXML(jobStartTime) AS jobStartTime, dbo.NormalizeForXML(attemptStartTime) AS attemptStartTime, dbo.NormalizeForXML(serverEndTime) AS serverEndTime, dbo.NormalizeForXML(jobElapsedTime) AS jobElapsedTime, dbo.NormalizeForXML(elapsedTime) AS elapsedTime, dbo.NormalizeForXML(lastStartOrRun) AS lastStartOrRun, dbo.NormalizeForXML(phaseParams) AS phaseParams, dbo.NormalizeForXML(restartString) AS restartString, dbo.NormalizeForXML(startAttempts) AS startAttempts, dbo.NormalizeForXML(runAttempts) AS runAttempts, dbo.NormalizeForXML(state) AS state, dbo.NormalizeForXML(pendingCause) AS pendingCause, dbo.NormalizeForXML(restartable) AS restartable, dbo.NormalizeForXML(appArgs) AS appArgs, dbo.NormalizeForXML(numOfFailures) AS numOfFailures, dbo.NormalizeForXML(failureReason) AS failureReason, dbo.NormalizeForXML(preemptable) AS preemptable, dbo.NormalizeForXML(taskLinkID) AS taskLinkID, dbo.NormalizeForXML(percentcomplete) AS percentcomplete, dbo.NormalizeForXML(displayState) AS displayState, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(resourcesAllocated) AS resourcesAllocated, dbo.NormalizeForXML(currentContext) AS currentContext, dbo.NormalizeForXML(libraryList) AS libraryList, dbo.NormalizeForXML(driveList) AS driveList, dbo.NormalizeForXML(opUsername) AS opUsername, dbo.NormalizeForXML(phaseOnSuccess) AS phaseOnSuccess, dbo.NormalizeForXML(interruptedPhase) AS interruptedPhase, dbo.NormalizeForXML(errorType) AS errorType, dbo.NormalizeForXML(licenseVerified) AS licenseVerified, dbo.NormalizeForXML(currentPhaseName) AS currentPhaseName, dbo.NormalizeForXML(timeToComplete) AS timeToComplete, dbo.NormalizeForXML(lastUpdateFromClient) AS lastUpdateFromClient, dbo.NormalizeForXML(lastStateChangeTime) AS lastStateChangeTime, dbo.NormalizeForXML(jobCategory) AS jobCategory, dbo.NormalizeForXML(recoveredFromServiceRestart) AS recoveredFromServiceRestart, dbo.NormalizeForXML(noOfGUIMonitors) AS noOfGUIMonitors, dbo.NormalizeForXML(isScheduledAlert) AS isScheduledAlert, dbo.NormalizeForXML(jobBasedAlertId) AS jobBasedAlertId, dbo.NormalizeForXML(alertName) AS alertName, dbo.NormalizeForXML(shortMediaAgent) AS shortMediaAgent, dbo.NormalizeForXML(seqNumber) AS seqNumber, dbo.NormalizeForXML(activeFile) AS activeFile, dbo.NormalizeForXML(guiAlertColorLevel) AS guiAlertColorLevel, dbo.NormalizeForXML(jobDescription) AS jobDescription, dbo.NormalizeForXML(xmlJobInfo) AS xmlJobInfo, dbo.NormalizeForXML(subOpType) AS subOpType, dbo.NormalizeForXML(foreignToken) AS foreignToken, dbo.NormalizeForXML(preparedJobId) AS preparedJobId from #CCM_JMJobInfo for xml raw,root('CCM_JMJobInfo')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(opType) AS opType, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(servStart) AS servStart, dbo.NormalizeForXML(servEnd) AS servEnd, dbo.NormalizeForXML(archGrpID) AS archGrpID, dbo.NormalizeForXML(archGrpName) AS archGrpName, dbo.NormalizeForXML(AP_NumDays) AS AP_NumDays, dbo.NormalizeForXML(AP_IsForecast) AS AP_IsForecast, dbo.NormalizeForXML(AP_SeqNum) AS AP_SeqNum, dbo.NormalizeForXML(AC_NewMediaFlag) AS AC_NewMediaFlag, dbo.NormalizeForXML(ER_BkpLevel) AS ER_BkpLevel, dbo.NormalizeForXML(ER_DbName) AS ER_DbName, dbo.NormalizeForXML(ER_Destination) AS ER_Destination, dbo.NormalizeForXML(ER_SendCount) AS ER_SendCount, dbo.NormalizeForXML(ER_MediasUsed) AS ER_MediasUsed, dbo.NormalizeForXML(TotalObjects) AS TotalObjects, dbo.NormalizeForXML(ObjectsDone) AS ObjectsDone, dbo.NormalizeForXML(ObjectsFailed) AS ObjectsFailed, dbo.NormalizeForXML(archGrpCopyID) AS archGrpCopyID, dbo.NormalizeForXML(LibraryID) AS LibraryID, dbo.NormalizeForXML(MI_InventoryType) AS MI_InventoryType, dbo.NormalizeForXML(currentWriteTime) AS currentWriteTime, dbo.NormalizeForXML(noOfStreams) AS noOfStreams, dbo.NormalizeForXML(appID) AS appID, dbo.NormalizeForXML(dependantJobId) AS dependantJobId, dbo.NormalizeForXML(workFlowId) AS workFlowId, dbo.NormalizeForXML(srcMediaAgent) AS srcMediaAgent, dbo.NormalizeForXML(destMediaAgent) AS destMediaAgent, dbo.NormalizeForXML(drivePoolId) AS drivePoolId, dbo.NormalizeForXML(mediaId) AS mediaId, dbo.NormalizeForXML(sourceJobId) AS sourceJobId, dbo.NormalizeForXML(TotalSize) AS TotalSize, dbo.NormalizeForXML(noOfStreamsAllocated) AS noOfStreamsAllocated, dbo.NormalizeForXML(maxRestarts) AS maxRestarts, dbo.NormalizeForXML(restartInterval) AS restartInterval, dbo.NormalizeForXML(embeddedObjects) AS embeddedObjects, dbo.NormalizeForXML(uncompBytes) AS uncompBytes, dbo.NormalizeForXML(numFiles) AS numFiles, dbo.NormalizeForXML(skippedItems) AS skippedItems, dbo.NormalizeForXML(writeTime) AS writeTime, dbo.NormalizeForXML(reportType) AS reportType, dbo.NormalizeForXML(cloudId) AS cloudId, dbo.NormalizeForXML(reportSetId) AS reportSetId, dbo.NormalizeForXML(reportName) AS reportName, dbo.NormalizeForXML(reportSetName) AS reportSetName, dbo.NormalizeForXML(fromTime) AS fromTime, dbo.NormalizeForXML(toTime) AS toTime, dbo.NormalizeForXML(subTaskId) AS subTaskId, dbo.NormalizeForXML(otherOpName) AS otherOpName, dbo.NormalizeForXML(nwTransBytes) AS nwTransBytes, dbo.NormalizeForXML(commCellId) AS commCellId from #CCM_JMAdminJobInfoTable for xml raw,root('CCM_JMAdminJobInfoTable')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(commcellId) AS commcellId, dbo.NormalizeForXML(applicationId) AS applicationId, dbo.NormalizeForXML(numStreams) AS numStreams, dbo.NormalizeForXML(currentPolicy) AS currentPolicy, dbo.NormalizeForXML(targetCopyList) AS targetCopyList, dbo.NormalizeForXML(bkpLevel) AS bkpLevel, dbo.NormalizeForXML(indexOverride) AS indexOverride, dbo.NormalizeForXML(startNewMedia) AS startNewMedia, dbo.NormalizeForXML(compBytes) AS compBytes, dbo.NormalizeForXML(unCompBytes) AS unCompBytes, dbo.NormalizeForXML(filesToXfer) AS filesToXfer, dbo.NormalizeForXML(backupTaskId) AS backupTaskId, dbo.NormalizeForXML(scanFileFailures) AS scanFileFailures, dbo.NormalizeForXML(scanFolderFailures) AS scanFolderFailures, dbo.NormalizeForXML(backupFileFailures) AS backupFileFailures, dbo.NormalizeForXML(backupFolderFailures) AS backupFolderFailures, dbo.NormalizeForXML(shadowCopyId) AS shadowCopyId, dbo.NormalizeForXML(bkpOptions) AS bkpOptions, dbo.NormalizeForXML(oraSubLevel) AS oraSubLevel, dbo.NormalizeForXML(bkpattributes) AS bkpattributes, dbo.NormalizeForXML(dataPolicy) AS dataPolicy, dbo.NormalizeForXML(logPolicy) AS logPolicy, dbo.NormalizeForXML(filesXfered) AS filesXfered, dbo.NormalizeForXML(currentThroughput) AS currentThroughput, dbo.NormalizeForXML(averageThroughput) AS averageThroughput, dbo.NormalizeForXML(filesIndexed) AS filesIndexed, dbo.NormalizeForXML(filesFailedToIndex) AS filesFailedToIndex, dbo.NormalizeForXML(filesSkippedForIndex) AS filesSkippedForIndex, dbo.NormalizeForXML(contentIndexDBSize) AS contentIndexDBSize, dbo.NormalizeForXML(totalMediaUsageTime) AS totalMediaUsageTime, dbo.NormalizeForXML(mediaAgentName) AS mediaAgentName, dbo.NormalizeForXML(scanType) AS scanType, dbo.NormalizeForXML(scanTypeChangeReason) AS scanTypeChangeReason, dbo.NormalizeForXML(numStreamsAllocated) AS numStreamsAllocated, dbo.NormalizeForXML(maxRestarts) AS maxRestarts, dbo.NormalizeForXML(restartInterval) AS restartInterval, dbo.NormalizeForXML(cloudId) AS cloudId, dbo.NormalizeForXML(diffPolicy) AS diffPolicy, dbo.NormalizeForXML(targetClientId) AS targetClientId, dbo.NormalizeForXML(unCompBytesToXfer) AS unCompBytesToXfer, dbo.NormalizeForXML(secondaryBkpLevel) AS secondaryBkpLevel, dbo.NormalizeForXML(jobIdActedOn) AS jobIdActedOn, dbo.NormalizeForXML(fromTime) AS fromTime, dbo.NormalizeForXML(toTime) AS toTime, dbo.NormalizeForXML(nwTransBytes) AS nwTransBytes, dbo.NormalizeForXML(totSkippedObjects) AS totSkippedObjects, dbo.NormalizeForXML(bkpAttributesEx) AS bkpAttributesEx, dbo.NormalizeForXML(jobReferenceTime) AS jobReferenceTime, dbo.NormalizeForXML(totReadBytes) AS totReadBytes, dbo.NormalizeForXML(totReadTime) AS totReadTime, dbo.NormalizeForXML(totPhysicalWriteBytes) AS totPhysicalWriteBytes, dbo.NormalizeForXML(totPhysicalWriteTime) AS totPhysicalWriteTime, dbo.NormalizeForXML(totNwTransTime) AS totNwTransTime, dbo.NormalizeForXML(totSidbLookups) AS totSidbLookups, dbo.NormalizeForXML(totSidbLookupTime) AS totSidbLookupTime, dbo.NormalizeForXML(readCurrentThroughput) AS readCurrentThroughput, dbo.NormalizeForXML(readAverageThroughput) AS readAverageThroughput, dbo.NormalizeForXML(writeCurrentThroughput) AS writeCurrentThroughput, dbo.NormalizeForXML(writeAverageThroughput) AS writeAverageThroughput, dbo.NormalizeForXML(networkCurrentThroughput) AS networkCurrentThroughput, dbo.NormalizeForXML(networkAverageThroughput) AS networkAverageThroughput, dbo.NormalizeForXML(sidbCurrentLookups) AS sidbCurrentLookups, dbo.NormalizeForXML(sidbAverageLookups) AS sidbAverageLookups from #CCM_JMBkpJobInfo for xml raw,root('CCM_JMBkpJobInfo')) as xml),
cast((select dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(commcellId) AS commcellId, dbo.NormalizeForXML(materializationStatus) AS materializationStatus, dbo.NormalizeForXML(disabled) AS disabled, dbo.NormalizeForXML(materializationJobId) AS materializationJobId, dbo.NormalizeForXML(appId) AS appId, dbo.NormalizeForXML(archGrpId) AS archGrpId, dbo.NormalizeForXML(unPickReason) AS unPickReason, dbo.NormalizeForXML(flags) AS flags from #CCM_JMJobSnapshotStats for xml raw,root('CCM_JMJobSnapshotStats')) as xml),
cast((select dbo.NormalizeForXML(trackingId) AS trackingId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(copyId) AS copyId, dbo.NormalizeForXML(dataType) AS dataType, dbo.NormalizeForXML(statusChange) AS statusChange, dbo.NormalizeForXML(createdTime) AS createdTime from #CCM_GRCJMJobDataStatsTracking for xml raw,root('CCM_GRCJMJobDataStatsTracking')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(messageId) AS messageId, dbo.NormalizeForXML(paramNum) AS paramNum, dbo.NormalizeForXML(errorType) AS errorType, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(client) AS client, dbo.NormalizeForXML(subsystem) AS subsystem, dbo.NormalizeForXML(copyId) AS copyId, dbo.NormalizeForXML(rcId) AS rcId, dbo.NormalizeForXML(reservationId) AS reservationId, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(guiAlertColorLevel) AS guiAlertColorLevel, dbo.NormalizeForXML(clientVersion) AS clientVersion, dbo.NormalizeForXML(serverVersion) AS serverVersion, dbo.NormalizeForXML(iDA) AS iDA, dbo.NormalizeForXML(opType) AS opType, dbo.NormalizeForXML(phaseNumber) AS phaseNumber, dbo.NormalizeForXML(customMessageId) AS customMessageId, dbo.NormalizeForXML(failureReasonTime) AS failureReasonTime from #CCM_JMFailureReasonMsg for xml raw,root('CCM_JMFailureReasonMsg')) as xml),
cast((select dbo.NormalizeForXML(msgId) AS msgId, dbo.NormalizeForXML(eventid) AS eventid, dbo.NormalizeForXML(position) AS position, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(size) AS size, dbo.NormalizeForXML(data) AS data from #CCM_JMFailureReasonMsgParam for xml raw,root('CCM_JMFailureReasonMsgParam')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(timeSource) AS timeSource, dbo.NormalizeForXML(timeServer) AS timeServer, dbo.NormalizeForXML(severity) AS severity, dbo.NormalizeForXML(ack) AS ack, dbo.NormalizeForXML(acked) AS acked, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(paramNum) AS paramNum, dbo.NormalizeForXML(messageId) AS messageId, dbo.NormalizeForXML(jobId_h) AS jobId_h, dbo.NormalizeForXML(jobId_l) AS jobId_l, dbo.NormalizeForXML(clientID) AS clientID, dbo.NormalizeForXML(commCellID) AS commCellID, dbo.NormalizeForXML(userID) AS userID, dbo.NormalizeForXML(subsystemID) AS subsystemID, dbo.NormalizeForXML(client) AS client, dbo.NormalizeForXML(commCell) AS commCell, dbo.NormalizeForXML(userName) AS userName, dbo.NormalizeForXML(subsystem) AS subsystem, dbo.NormalizeForXML(msgEnglish) AS msgEnglish, dbo.NormalizeForXML(repeatCount) AS repeatCount, dbo.NormalizeForXML(lastOccurrence) AS lastOccurrence, dbo.NormalizeForXML(nextPost) AS nextPost, dbo.NormalizeForXML(mediaId) AS mediaId, dbo.NormalizeForXML(driveId) AS driveId, dbo.NormalizeForXML(libraryId) AS libraryId, dbo.NormalizeForXML(maClientId) AS maClientId, dbo.NormalizeForXML(entityId) AS entityId, dbo.NormalizeForXML(entityType) AS entityType, dbo.NormalizeForXML(anomalous) AS anomalous from #CCM_evMsg for xml raw,root('CCM_evMsg')) as xml),
cast((select dbo.NormalizeForXML(evMsgId) AS evMsgId, dbo.NormalizeForXML(position) AS position, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(size) AS size, dbo.NormalizeForXML(data) AS data, dbo.NormalizeForXML(eventId) AS eventId, dbo.NormalizeForXML(commcellId) AS commcellId from #CCM_evParam for xml raw,root('CCM_evParam')) as xml),
cast((select dbo.NormalizeForXML(ExportLocationId) AS ExportLocationId, dbo.NormalizeForXML(ExportLocation) AS ExportLocation, dbo.NormalizeForXML(Type) AS Type, dbo.NormalizeForXML(Descript) AS Descript, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(GUID) AS GUID, dbo.NormalizeForXML(ModifiedTime) AS ModifiedTime from #CCM_MMExportLocation for xml raw,root('CCM_MMExportLocation')) as xml),
cast((select dbo.NormalizeForXML(MediaId) AS MediaId, dbo.NormalizeForXML(UniqueId) AS UniqueId, dbo.NormalizeForXML(BarCode) AS BarCode, dbo.NormalizeForXML(MediaTypeId) AS MediaTypeId, dbo.NormalizeForXML(CreationTime) AS CreationTime, dbo.NormalizeForXML(NumberOfReUses) AS NumberOfReUses, dbo.NormalizeForXML(LastRestoreTime) AS LastRestoreTime, dbo.NormalizeForXML(LastBackupTime) AS LastBackupTime, dbo.NormalizeForXML(LibraryId) AS LibraryId, dbo.NormalizeForXML(SpareGroupId) AS SpareGroupId, dbo.NormalizeForXML(LastExportTime) AS LastExportTime, dbo.NormalizeForXML(MediaLocation) AS MediaLocation, dbo.NormalizeForXML(ExternalGUID) AS ExternalGUID, dbo.NormalizeForXML(MediaFlags) AS MediaFlags, dbo.NormalizeForXML(IsOMLWritten) AS IsOMLWritten, dbo.NormalizeForXML(MediaStatusReason) AS MediaStatusReason, dbo.NormalizeForXML(ExportLocationId) AS ExportLocationId, dbo.NormalizeForXML(LastWriteLibraryId) AS LastWriteLibraryId, dbo.NormalizeForXML(Attributes) AS Attributes, dbo.NormalizeForXML(ContainerId) AS ContainerId, dbo.NormalizeForXML(OverWriteJobId) AS OverWriteJobId, dbo.NormalizeForXML(origCCcommCellID) AS origCCcommCellID, dbo.NormalizeForXML(origCCmediaID) AS origCCmediaID, dbo.NormalizeForXML(Descript) AS Descript, dbo.NormalizeForXML(NumberOfSideOverwrites) AS NumberOfSideOverwrites, dbo.NormalizeForXML(ScheduleRunId) AS ScheduleRunId, dbo.NormalizeForXML(retentionFlags) AS retentionFlags, dbo.NormalizeForXML(retentionExpireTime) AS retentionExpireTime, dbo.NormalizeForXML(IsAged) AS IsAged, dbo.NormalizeForXML(IsInMediaGroup) AS IsInMediaGroup, dbo.NormalizeForXML(PinMediaExpireTime) AS PinMediaExpireTime, dbo.NormalizeForXML(origSpareGroupId) AS origSpareGroupId, dbo.NormalizeForXML(RMSpareStatus) AS RMSpareStatus, dbo.NormalizeForXML(RMSpareStatusUpdateTime) AS RMSpareStatusUpdateTime, dbo.NormalizeForXML(ExtendedAttributes) AS ExtendedAttributes, dbo.NormalizeForXML(minRetentionTime) AS minRetentionTime, dbo.NormalizeForXML(HwEncKey) AS HwEncKey from #CCM_MMMedia for xml raw,root('CCM_MMMedia')) as xml),
cast((select dbo.NormalizeForXML(MediaSideId) AS MediaSideId, dbo.NormalizeForXML(MediaId) AS MediaId, dbo.NormalizeForXML(SideName) AS SideName, dbo.NormalizeForXML(MediaSideFlags) AS MediaSideFlags, dbo.NormalizeForXML(NumberOfRestores) AS NumberOfRestores, dbo.NormalizeForXML(NumberOfBackups) AS NumberOfBackups, dbo.NormalizeForXML(NumberOfMounts) AS NumberOfMounts, dbo.NormalizeForXML(NumberOfSoftErrors) AS NumberOfSoftErrors, dbo.NormalizeForXML(NumberOfHardErrors) AS NumberOfHardErrors, dbo.NormalizeForXML(NumberOfReUses) AS NumberOfReUses, dbo.NormalizeForXML(LastRestoreTime) AS LastRestoreTime, dbo.NormalizeForXML(LastBackupTime) AS LastBackupTime, dbo.NormalizeForXML(TotalSpaceMB) AS TotalSpaceMB, dbo.NormalizeForXML(FreeBytesMB) AS FreeBytesMB, dbo.NormalizeForXML(LogicalBytesMB) AS LogicalBytesMB, dbo.NormalizeForXML(PhysicalBytesMB) AS PhysicalBytesMB, dbo.NormalizeForXML(IsOMLValid) AS IsOMLValid, dbo.NormalizeForXML(FailureReason) AS FailureReason, dbo.NormalizeForXML(ExternalGUID) AS ExternalGUID, dbo.NormalizeForXML(IsOMLWritten) AS IsOMLWritten, dbo.NormalizeForXML(isErasable) AS isErasable, dbo.NormalizeForXML(UploadDataMB) AS UploadDataMB, dbo.NormalizeForXML(DownloadDataMB) AS DownloadDataMB from #CCM_MMMediaSide for xml raw,root('CCM_MMMediaSide')) as xml),
cast((select dbo.NormalizeForXML(VolumeId) AS VolumeId, dbo.NormalizeForXML(VolumeName) AS VolumeName, dbo.NormalizeForXML(CreationTime) AS CreationTime, dbo.NormalizeForXML(VolumeFlags) AS VolumeFlags, dbo.NormalizeForXML(VolumeInitialized) AS VolumeInitialized, dbo.NormalizeForXML(FlushBlockSizeKB) AS FlushBlockSizeKB, dbo.NormalizeForXML(NumberOfRestores) AS NumberOfRestores, dbo.NormalizeForXML(NumberOfBackups) AS NumberOfBackups, dbo.NormalizeForXML(NumberOfMounts) AS NumberOfMounts, dbo.NormalizeForXML(NumberOfSoftErrors) AS NumberOfSoftErrors, dbo.NormalizeForXML(NumberOfHardErrors) AS NumberOfHardErrors, dbo.NormalizeForXML(LastRestoreTime) AS LastRestoreTime, dbo.NormalizeForXML(LastBackupTime) AS LastBackupTime, dbo.NormalizeForXML(LogicalBytesMB) AS LogicalBytesMB, dbo.NormalizeForXML(PhysicalBytesMB) AS PhysicalBytesMB, dbo.NormalizeForXML(NumberOfActiveFiles) AS NumberOfActiveFiles, dbo.NormalizeForXML(LastFile) AS LastFile, dbo.NormalizeForXML(RecordingFormatId) AS RecordingFormatId, dbo.NormalizeForXML(ExternalGUID) AS ExternalGUID, dbo.NormalizeForXML(OMLVersion) AS OMLVersion, dbo.NormalizeForXML(VolumeState) AS VolumeState, dbo.NormalizeForXML(VolumeFullReason) AS VolumeFullReason, dbo.NormalizeForXML(VolumeFullTime) AS VolumeFullTime, dbo.NormalizeForXML(VolumeFullJobId) AS VolumeFullJobId, dbo.NormalizeForXML(origCCcommCellID) AS origCCcommCellID, dbo.NormalizeForXML(origCCvolumeID) AS origCCvolumeID, dbo.NormalizeForXML(MediaId) AS MediaId, dbo.NormalizeForXML(MediaSideId) AS MediaSideId, dbo.NormalizeForXML(Attributes) AS Attributes, dbo.NormalizeForXML(MediaGroupId) AS MediaGroupId, dbo.NormalizeForXML(ReformatTime) AS ReformatTime, dbo.NormalizeForXML(RMSpareStatus) AS RMSpareStatus, dbo.NormalizeForXML(RMSpareStatusUpdateTime) AS RMSpareStatusUpdateTime, dbo.NormalizeForXML(SIDBStoreId) AS SIDBStoreId, dbo.NormalizeForXML(SiloStatus) AS SiloStatus, dbo.NormalizeForXML(CurrMountPathId) AS CurrMountPathId, dbo.NormalizeForXML(FailureErrorCode) AS FailureErrorCode, dbo.NormalizeForXML(MMSpareStatus) AS MMSpareStatus, dbo.NormalizeForXML(LastSizeUpdateTime) AS LastSizeUpdateTime from #CCM_MMVolume for xml raw,root('CCM_MMVolume')) as xml),
cast((select dbo.NormalizeForXML(MediaGroupId) AS MediaGroupId, dbo.NormalizeForXML(MediaGroupName) AS MediaGroupName, dbo.NormalizeForXML(DrivePoolId) AS DrivePoolId, dbo.NormalizeForXML(SpareGroupId) AS SpareGroupId, dbo.NormalizeForXML(DesiredMediaTypeId) AS DesiredMediaTypeId, dbo.NormalizeForXML(RecordingFormatId) AS RecordingFormatId, dbo.NormalizeForXML(DataPathId) AS DataPathId from #CCM_MMMediaGroup for xml raw,root('CCM_MMMediaGroup')) as xml),
cast((select dbo.NormalizeForXML(MountPathId) AS MountPathId, dbo.NormalizeForXML(MountPathName) AS MountPathName, dbo.NormalizeForXML(MediaSideId) AS MediaSideId, dbo.NormalizeForXML(UserName) AS UserName, dbo.NormalizeForXML(UserPassword) AS UserPassword, dbo.NormalizeForXML(IsEnabled) AS IsEnabled, dbo.NormalizeForXML(NumberOfWriters) AS NumberOfWriters, dbo.NormalizeForXML(MaxConcurrentWriters) AS MaxConcurrentWriters, dbo.NormalizeForXML(CurrentFileMarker) AS CurrentFileMarker, dbo.NormalizeForXML(IsOffline) AS IsOffline, dbo.NormalizeForXML(OfflineReason) AS OfflineReason, dbo.NormalizeForXML(MountPathTypeId) AS MountPathTypeId, dbo.NormalizeForXML(OffLineTimeStamp) AS OffLineTimeStamp, dbo.NormalizeForXML(origCCcommCellID) AS origCCcommCellID, dbo.NormalizeForXML(origCCmediaSideID) AS origCCmediaSideID, dbo.NormalizeForXML(MaxDataToWriteMB) AS MaxDataToWriteMB, dbo.NormalizeForXML(MagneticSpaceRsrvInMB) AS MagneticSpaceRsrvInMB, dbo.NormalizeForXML(Attribute) AS Attribute, dbo.NormalizeForXML(MasterPoolId) AS MasterPoolId, dbo.NormalizeForXML(LibraryId) AS LibraryId, dbo.NormalizeForXML(RMStatus) AS RMStatus, dbo.NormalizeForXML(RMStatusUpdateTime) AS RMStatusUpdateTime, dbo.NormalizeForXML(OrigCCMountPathId) AS OrigCCMountPathId, dbo.NormalizeForXML(MagneticChunkFileIncrSizeMB) AS MagneticChunkFileIncrSizeMB, dbo.NormalizeForXML(MountPathOfflineReasonEventId) AS MountPathOfflineReasonEventId, dbo.NormalizeForXML(StagingMountPathId) AS StagingMountPathId from #CCM_MMMountPath for xml raw,root('CCM_MMMountPath')) as xml),
cast((select dbo.NormalizeForXML(DeviceId) AS DeviceId, dbo.NormalizeForXML(AliasName) AS AliasName, dbo.NormalizeForXML(DeviceEnabled) AS DeviceEnabled, dbo.NormalizeForXML(DeviceBroken) AS DeviceBroken, dbo.NormalizeForXML(DeviceTypeId) AS DeviceTypeId, dbo.NormalizeForXML(NumRestoresLifeTime) AS NumRestoresLifeTime, dbo.NormalizeForXML(NumBackupsLifeTime) AS NumBackupsLifeTime, dbo.NormalizeForXML(NumMountsLifeTime) AS NumMountsLifeTime, dbo.NormalizeForXML(NumErrsLifeTime) AS NumErrsLifeTime, dbo.NormalizeForXML(MinutesUsedLifeTime) AS MinutesUsedLifeTime, dbo.NormalizeForXML(OfflineReason) AS OfflineReason, dbo.NormalizeForXML(SNRPartitionId) AS SNRPartitionId, dbo.NormalizeForXML(DeviceStatus) AS DeviceStatus, dbo.NormalizeForXML(DRUId) AS DRUId, dbo.NormalizeForXML(DeviceAttributes) AS DeviceAttributes, dbo.NormalizeForXML(DRUDeviceId) AS DRUDeviceId, dbo.NormalizeForXML(RMStatus) AS RMStatus, dbo.NormalizeForXML(RMStatusUpdateTime) AS RMStatusUpdateTime, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(origDeviceId) AS origDeviceId, dbo.NormalizeForXML(DisplayDeviceTypeId) AS DisplayDeviceTypeId from #CCM_MMDevice for xml raw,root('CCM_MMDevice')) as xml),
cast((select dbo.NormalizeForXML(DeviceControllerId) AS DeviceControllerId, dbo.NormalizeForXML(ClientId) AS ClientId, dbo.NormalizeForXML(DeviceId) AS DeviceId, dbo.NormalizeForXML(DeviceControllerActive) AS DeviceControllerActive, dbo.NormalizeForXML(DeviceControllerEnabled) AS DeviceControllerEnabled, dbo.NormalizeForXML(SNRVolumeId) AS SNRVolumeId, dbo.NormalizeForXML(UseCount) AS UseCount, dbo.NormalizeForXML(UserName) AS UserName, dbo.NormalizeForXML(UserPassword) AS UserPassword, dbo.NormalizeForXML(Folder) AS Folder, dbo.NormalizeForXML(DeviceMounted) AS DeviceMounted, dbo.NormalizeForXML(DeviceAccessible) AS DeviceAccessible, dbo.NormalizeForXML(VolumeRecoveryStatus) AS VolumeRecoveryStatus, dbo.NormalizeForXML(VolumeRecoveryTime) AS VolumeRecoveryTime, dbo.NormalizeForXML(VolumeScsiReserved) AS VolumeScsiReserved, dbo.NormalizeForXML(DeviceAccessType) AS DeviceAccessType, dbo.NormalizeForXML(RMStatus) AS RMStatus, dbo.NormalizeForXML(RMStatusUpdateTime) AS RMStatusUpdateTime, dbo.NormalizeForXML(CredentialAssocId) AS CredentialAssocId from #CCM_MMDeviceController for xml raw,root('CCM_MMDeviceController')) as xml),
cast((select dbo.NormalizeForXML(MountPathId) AS MountPathId, dbo.NormalizeForXML(CenteraId) AS CenteraId, dbo.NormalizeForXML(DeviceId) AS DeviceId from #CCM_MMMountPathToStorageDevice for xml raw,root('CCM_MMMountPathToStorageDevice')) as xml),
cast((select dbo.NormalizeForXML(NDMPHostId) AS NDMPHostId, dbo.NormalizeForXML(Login) AS Login, dbo.NormalizeForXML(Password) AS Password, dbo.NormalizeForXML(ListenPort) AS ListenPort, dbo.NormalizeForXML(FirmwareRevision) AS FirmwareRevision, dbo.NormalizeForXML(OSType) AS OSType, dbo.NormalizeForXML(AuthenticationScheme) AS AuthenticationScheme, dbo.NormalizeForXML(ProtocolType) AS ProtocolType, dbo.NormalizeForXML(ProtocolRevision) AS ProtocolRevision, dbo.NormalizeForXML(CapabilityFlags) AS CapabilityFlags, dbo.NormalizeForXML(ClientId) AS ClientId from #CCM_MMNDMPHostInfo for xml raw,root('CCM_MMNDMPHostInfo')) as xml),
cast((select dbo.NormalizeForXML(ContainerId) AS ContainerId, dbo.NormalizeForXML(ContainerName) AS ContainerName, dbo.NormalizeForXML(Flag) AS Flag, dbo.NormalizeForXML(Capacity) AS Capacity, dbo.NormalizeForXML(MediaType) AS MediaType, dbo.NormalizeForXML(Descript) AS Descript, dbo.NormalizeForXML(CreationTime) AS CreationTime, dbo.NormalizeForXML(IsEmpty) AS IsEmpty, dbo.NormalizeForXML(ContainerEmptyTime) AS ContainerEmptyTime, dbo.NormalizeForXML(TrackingId) AS TrackingId, dbo.NormalizeForXML(SIDBStoreId) AS SIDBStoreId from #CCM_MMContainer for xml raw,root('CCM_MMContainer')) as xml),
cast((select dbo.NormalizeForXML(CenteraId) AS CenteraId, dbo.NormalizeForXML(FriendlyName) AS FriendlyName, dbo.NormalizeForXML(ClusterName) AS ClusterName, dbo.NormalizeForXML(ClusterId) AS ClusterId, dbo.NormalizeForXML(Version) AS Version, dbo.NormalizeForXML(CapacityMB_h) AS CapacityMB_h, dbo.NormalizeForXML(CapacityMB_l) AS CapacityMB_l, dbo.NormalizeForXML(FreeSpaceMB_h) AS FreeSpaceMB_h, dbo.NormalizeForXML(FreeSpaceMB_l) AS FreeSpaceMB_l, dbo.NormalizeForXML(ReplicateAddress) AS ReplicateAddress, dbo.NormalizeForXML(ApiRetryInterval) AS ApiRetryInterval from #CCM_MMCenteraInfo for xml raw,root('CCM_MMCenteraInfo')) as xml),
cast((select dbo.NormalizeForXML(AccessNodeId) AS AccessNodeId, dbo.NormalizeForXML(NetHostName) AS NetHostName, dbo.NormalizeForXML(CenteraId) AS CenteraId from #CCM_MMCenteraAccessNode for xml raw,root('CCM_MMCenteraAccessNode')) as xml),
cast((select dbo.NormalizeForXML(ClientId) AS ClientId, dbo.NormalizeForXML(MmHostType) AS MmHostType, dbo.NormalizeForXML(MmHostSoftState) AS MmHostSoftState, dbo.NormalizeForXML(MmHostEnabled) AS MmHostEnabled, dbo.NormalizeForXML(OfflineReason) AS OfflineReason, dbo.NormalizeForXML(OfflineTimeStamp) AS OfflineTimeStamp, dbo.NormalizeForXML(PatchLevel) AS PatchLevel, dbo.NormalizeForXML(IndexCacheUser) AS IndexCacheUser, dbo.NormalizeForXML(IndexCachePassword) AS IndexCachePassword, dbo.NormalizeForXML(IndexCachePathName) AS IndexCachePathName, dbo.NormalizeForXML(IsIndexShared) AS IsIndexShared, dbo.NormalizeForXML(Attribute) AS Attribute, dbo.NormalizeForXML(ScanIntervalInSec) AS ScanIntervalInSec, dbo.NormalizeForXML(Descript) AS Descript, dbo.NormalizeForXML(MaxReservations) AS MaxReservations, dbo.NormalizeForXML(RMStatus) AS RMStatus, dbo.NormalizeForXML(RMStatusUpdateTime) AS RMStatusUpdateTime, dbo.NormalizeForXML(RolesBitMask) AS RolesBitMask from #CCM_MMHost for xml raw,root('CCM_MMHost')) as xml),
cast((select dbo.NormalizeForXML(IdxAccessPathId) AS IdxAccessPathId, dbo.NormalizeForXML(IdxCacheId) AS IdxCacheId, dbo.NormalizeForXML(ClientId) AS ClientId, dbo.NormalizeForXML(Path) AS Path, dbo.NormalizeForXML(Username) AS Username, dbo.NormalizeForXML(Password) AS Password, dbo.NormalizeForXML(Enabled) AS Enabled, dbo.NormalizeForXML(SoftState) AS SoftState, dbo.NormalizeForXML(OfflineReason) AS OfflineReason, dbo.NormalizeForXML(Priority) AS Priority, dbo.NormalizeForXML(LocalIndexTimeStamp) AS LocalIndexTimeStamp, dbo.NormalizeForXML(ActualDaysIndexRetain) AS ActualDaysIndexRetain, dbo.NormalizeForXML(Flags) AS Flags, dbo.NormalizeForXML(AgeingNoOfDays) AS AgeingNoOfDays, dbo.NormalizeForXML(AgeingPercentDiskspace) AS AgeingPercentDiskspace, dbo.NormalizeForXML(DiskFreeThresholdMB) AS DiskFreeThresholdMB, dbo.NormalizeForXML(DiskFreeWarningThreshholdMB) AS DiskFreeWarningThreshholdMB, dbo.NormalizeForXML(TotalCapacityMB) AS TotalCapacityMB, dbo.NormalizeForXML(FreeDiskSpaceMB) AS FreeDiskSpaceMB, dbo.NormalizeForXML(DiskUsageMB) AS DiskUsageMB, dbo.NormalizeForXML(DiskUsageLastChecked) AS DiskUsageLastChecked, dbo.NormalizeForXML(StagingCachePath) AS StagingCachePath, dbo.NormalizeForXML(VolumeGUID) AS VolumeGUID from #CCM_IdxAccessPath for xml raw,root('CCM_IdxAccessPath')) as xml),
cast((select dbo.NormalizeForXML(LibraryId) AS LibraryId, dbo.NormalizeForXML(LibraryName) AS LibraryName, dbo.NormalizeForXML(AliasName) AS AliasName, dbo.NormalizeForXML(LibrarySoftState) AS LibrarySoftState, dbo.NormalizeForXML(LibraryEnabled) AS LibraryEnabled, dbo.NormalizeForXML(LibraryBroken) AS LibraryBroken, dbo.NormalizeForXML(LibraryTypeId) AS LibraryTypeId, dbo.NormalizeForXML(BarCodeReaderPresent) AS BarCodeReaderPresent, dbo.NormalizeForXML(LibraryInstallTime) AS LibraryInstallTime, dbo.NormalizeForXML(LowWaterMarkMB) AS LowWaterMarkMB, dbo.NormalizeForXML(LibraryLicenseType) AS LibraryLicenseType, dbo.NormalizeForXML(LibraryVendor) AS LibraryVendor, dbo.NormalizeForXML(LibraryModel) AS LibraryModel, dbo.NormalizeForXML(FirmwareRevision) AS FirmwareRevision, dbo.NormalizeForXML(SerialNumber) AS SerialNumber, dbo.NormalizeForXML(WWNNumber) AS WWNNumber, dbo.NormalizeForXML(FiberChannelPort) AS FiberChannelPort, dbo.NormalizeForXML(NumberOfMounts) AS NumberOfMounts, dbo.NormalizeForXML(LastServiceTime) AS LastServiceTime, dbo.NormalizeForXML(DriveCount) AS DriveCount, dbo.NormalizeForXML(BaseAddress) AS BaseAddress, dbo.NormalizeForXML(ExternalGUID) AS ExternalGUID, dbo.NormalizeForXML(PrivateData) AS PrivateData, dbo.NormalizeForXML(LibraryAttribute) AS LibraryAttribute, dbo.NormalizeForXML(MountTimeoutSec) AS MountTimeoutSec, dbo.NormalizeForXML(UnmountTimeoutSec) AS UnmountTimeoutSec, dbo.NormalizeForXML(NumberOfSoftErrors) AS NumberOfSoftErrors, dbo.NormalizeForXML(NumberOfHardErrors) AS NumberOfHardErrors, dbo.NormalizeForXML(DefaultMediaTypeId) AS DefaultMediaTypeId, dbo.NormalizeForXML(InventoryInProgress) AS InventoryInProgress, dbo.NormalizeForXML(IsConvertedToSited) AS IsConvertedToSited, dbo.NormalizeForXML(LastFullInventoryTime) AS LastFullInventoryTime, dbo.NormalizeForXML(InventoryJobId_h) AS InventoryJobId_h, dbo.NormalizeForXML(InventoryJobId_l) AS InventoryJobId_l, dbo.NormalizeForXML(LibraryStatusReason) AS LibraryStatusReason, dbo.NormalizeForXML(OfflineTimeStamp) AS OfflineTimeStamp, dbo.NormalizeForXML(UseWithinDaysInSec) AS UseWithinDaysInSec, dbo.NormalizeForXML(DriveCleanIntervalInSec) AS DriveCleanIntervalInSec, dbo.NormalizeForXML(VMSDirection) AS VMSDirection, dbo.NormalizeForXML(CacheMountPeriodInSec) AS CacheMountPeriodInSec, dbo.NormalizeForXML(StdAlnMedRetentionTime) AS StdAlnMedRetentionTime, dbo.NormalizeForXML(SlotBaseAddress) AS SlotBaseAddress, dbo.NormalizeForXML(NumberOfMailSlots) AS NumberOfMailSlots, dbo.NormalizeForXML(TURIntervalInSec) AS TURIntervalInSec, dbo.NormalizeForXML(ConfigParams) AS ConfigParams, dbo.NormalizeForXML(Descript) AS Descript, dbo.NormalizeForXML(StdAlnChkIntervalInSec) AS StdAlnChkIntervalInSec, dbo.NormalizeForXML(StdAlnNextChkTime) AS StdAlnNextChkTime, dbo.NormalizeForXML(ReadRetryIntervalInSec) AS ReadRetryIntervalInSec, dbo.NormalizeForXML(ReadRetryAttempts) AS ReadRetryAttempts, dbo.NormalizeForXML(RestrictActivity) AS RestrictActivity, dbo.NormalizeForXML(LibraryStatusEventId) AS LibraryStatusEventId, dbo.NormalizeForXML(StartVMSElementAddress) AS StartVMSElementAddress, dbo.NormalizeForXML(ExtendedAttributes) AS ExtendedAttributes, dbo.NormalizeForXML(ThresholdPercentage) AS ThresholdPercentage, dbo.NormalizeForXML(ThresholdVariation) AS ThresholdVariation, dbo.NormalizeForXML(LibrarySubType) AS LibrarySubType, dbo.NormalizeForXML(VTLType) AS VTLType, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(origLibraryId) AS origLibraryId, LibSvrConfig, dbo.NormalizeForXML(WarningWaterMark) AS WarningWaterMark, dbo.NormalizeForXML(OutOfSpaceAlertInDays) AS OutOfSpaceAlertInDays from #CCM_MMLibrary for xml raw,root('CCM_MMLibrary')) as xml),
cast((select dbo.NormalizeForXML(MasterPoolId) AS MasterPoolId, dbo.NormalizeForXML(MasterPoolName) AS MasterPoolName, dbo.NormalizeForXML(MasterPoolSoftState) AS MasterPoolSoftState, dbo.NormalizeForXML(MasterPoolEnabled) AS MasterPoolEnabled, dbo.NormalizeForXML(LibraryId) AS LibraryId, dbo.NormalizeForXML(TotalDrives) AS TotalDrives, dbo.NormalizeForXML(ReservedDrives) AS ReservedDrives, dbo.NormalizeForXML(MaxSwitchForHost) AS MaxSwitchForHost, dbo.NormalizeForXML(Descript) AS Descript, dbo.NormalizeForXML(DriveTypeId) AS DriveTypeId, dbo.NormalizeForXML(RMStatus) AS RMStatus, dbo.NormalizeForXML(RMStatusUpdateTime) AS RMStatusUpdateTime, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(origMasterPoolId) AS origMasterPoolId from #CCM_MMMasterPool for xml raw,root('CCM_MMMasterPool')) as xml),
cast((select dbo.NormalizeForXML(DrivePoolId) AS DrivePoolId, dbo.NormalizeForXML(DrivePoolName) AS DrivePoolName, dbo.NormalizeForXML(DrivePoolSoftState) AS DrivePoolSoftState, dbo.NormalizeForXML(DrivePoolEnabled) AS DrivePoolEnabled, dbo.NormalizeForXML(ReservedDrives) AS ReservedDrives, dbo.NormalizeForXML(DrivePoolType) AS DrivePoolType, dbo.NormalizeForXML(MaxDrivesToSwitch) AS MaxDrivesToSwitch, dbo.NormalizeForXML(CopyMgrAccessPath) AS CopyMgrAccessPath, dbo.NormalizeForXML(CopyManagerCtrlId) AS CopyManagerCtrlId, dbo.NormalizeForXML(CostCategoryId) AS CostCategoryId, dbo.NormalizeForXML(Descript) AS Descript, dbo.NormalizeForXML(ClientId) AS ClientId, dbo.NormalizeForXML(MasterPoolId) AS MasterPoolId, dbo.NormalizeForXML(NDMPHostId) AS NDMPHostId, dbo.NormalizeForXML(RMStatus) AS RMStatus, dbo.NormalizeForXML(RMStatusUpdateTime) AS RMStatusUpdateTime, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(origDrivePoolId) AS origDrivePoolId from #CCM_MMDrivePool for xml raw,root('CCM_MMDrivePool')) as xml),
cast((select dbo.NormalizeForXML(LibraryControllerId) AS LibraryControllerId, dbo.NormalizeForXML(LibraryControllerName) AS LibraryControllerName, dbo.NormalizeForXML(ClientId) AS ClientId, dbo.NormalizeForXML(LibraryControllerSoftState) AS LibraryControllerSoftState, dbo.NormalizeForXML(LibraryControllerActive) AS LibraryControllerActive, dbo.NormalizeForXML(LibraryControllerType) AS LibraryControllerType, dbo.NormalizeForXML(LibraryControllerEnabled) AS LibraryControllerEnabled, dbo.NormalizeForXML(LibraryId) AS LibraryId, dbo.NormalizeForXML(ConnectionType) AS ConnectionType, dbo.NormalizeForXML(SCSIId) AS SCSIId from #CCM_MMLibraryController for xml raw,root('CCM_MMLibraryController')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(major) AS major, dbo.NormalizeForXML(minor) AS minor, dbo.NormalizeForXML(build) AS build from #CCM_sqlVersion for xml raw,root('CCM_sqlVersion')) as xml),
cast((select dbo.NormalizeForXML(instanceId) AS instanceId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(serverName) AS serverName, dbo.NormalizeForXML(sqlVersionId) AS sqlVersionId, dbo.NormalizeForXML(sa) AS sa, dbo.NormalizeForXML(saPassword) AS saPassword, dbo.NormalizeForXML(undoFile) AS undoFile, dbo.NormalizeForXML(addTime) AS addTime, dbo.NormalizeForXML(removalTime) AS removalTime, dbo.NormalizeForXML(deleteFlag) AS deleteFlag, dbo.NormalizeForXML(sqlNTAccount) AS sqlNTAccount, dbo.NormalizeForXML(sqlNTPassword) AS sqlNTPassword, dbo.NormalizeForXML(sqlServiceName) AS sqlServiceName, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(clientId) AS clientId from #CCM_sqlServer for xml raw,root('CCM_sqlServer')) as xml),
cast((select dbo.NormalizeForXML(backupSetId) AS backupSetId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(sqlServerId) AS sqlServerId, dbo.NormalizeForXML(applicationNumber) AS applicationNumber, dbo.NormalizeForXML(databaseId) AS databaseId, dbo.NormalizeForXML(databaseName) AS databaseName, dbo.NormalizeForXML(creationTime) AS creationTime, dbo.NormalizeForXML(streams) AS streams, dbo.NormalizeForXML(maxStreams) AS maxStreams, dbo.NormalizeForXML(allowFlags) AS allowFlags, dbo.NormalizeForXML(addTime) AS addTime, dbo.NormalizeForXML(removalTime) AS removalTime, dbo.NormalizeForXML(deleteFlag) AS deleteFlag, dbo.NormalizeForXML(systemFlags) AS systemFlags, dbo.NormalizeForXML(logStreams) AS logStreams from #CCM_sqlDatabase for xml raw,root('CCM_sqlDatabase')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(sqlDatabaseId) AS sqlDatabaseId, dbo.NormalizeForXML(applicationNumber) AS applicationNumber, dbo.NormalizeForXML(groupId) AS groupId, dbo.NormalizeForXML(fileGroupName) AS fileGroupName, dbo.NormalizeForXML(streams) AS streams, dbo.NormalizeForXML(maxStreams) AS maxStreams, dbo.NormalizeForXML(addTime) AS addTime, dbo.NormalizeForXML(removalTime) AS removalTime, dbo.NormalizeForXML(deleteFlag) AS deleteFlag from #CCM_sqlFileGroup for xml raw,root('CCM_sqlFileGroup')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(sqlFileGroupId) AS sqlFileGroupId, dbo.NormalizeForXML(fileId) AS fileId, dbo.NormalizeForXML(physicalName) AS physicalName, dbo.NormalizeForXML(logicalName) AS logicalName, dbo.NormalizeForXML(size) AS size, dbo.NormalizeForXML(maxSize) AS maxSize, dbo.NormalizeForXML(addTime) AS addTime, dbo.NormalizeForXML(removalTime) AS removalTime, dbo.NormalizeForXML(deleteFlag) AS deleteFlag from #CCM_sqlFile for xml raw,root('CCM_sqlFile')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(sqlDatabaseId) AS sqlDatabaseId, dbo.NormalizeForXML(backupSetId) AS backupSetId, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(userName) AS userName, dbo.NormalizeForXML(vendorId) AS vendorId, dbo.NormalizeForXML(sqlVersionId) AS sqlVersionId, dbo.NormalizeForXML(mtfVersionId) AS mtfVersionId, dbo.NormalizeForXML(timeZone) AS timeZone, dbo.NormalizeForXML(galaxyStartTime) AS galaxyStartTime, dbo.NormalizeForXML(galaxyFinishTime) AS galaxyFinishTime, dbo.NormalizeForXML(compatibility) AS compatibility, dbo.NormalizeForXML(dbVersion) AS dbVersion, dbo.NormalizeForXML(backupSize) AS backupSize, dbo.NormalizeForXML(mediaSetId) AS mediaSetId, dbo.NormalizeForXML(streams) AS streams, dbo.NormalizeForXML(jobId_h) AS jobId_h, dbo.NormalizeForXML(jobId_l) AS jobId_l, dbo.NormalizeForXML(sqlFileSubClientId) AS sqlFileSubClientId from #CCM_sqlBackupSet for xml raw,root('CCM_sqlBackupSet')) as xml),
cast((select dbo.NormalizeForXML(sqlBackupSetId) AS sqlBackupSetId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(sqlDatabaseId) AS sqlDatabaseId, dbo.NormalizeForXML(startTime) AS startTime, dbo.NormalizeForXML(finishTime) AS finishTime, dbo.NormalizeForXML(backupType) AS backupType, dbo.NormalizeForXML(firstLSN) AS firstLSN, dbo.NormalizeForXML(lastLSN) AS lastLSN, dbo.NormalizeForXML(checkpointLSN) AS checkpointLSN, dbo.NormalizeForXML(fullBackupLSN) AS fullBackupLSN from #CCM_sqlLSNs for xml raw,root('CCM_sqlLSNs')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(sqlBackupSetId) AS sqlBackupSetId, dbo.NormalizeForXML(mediaSetId) AS mediaSetId, dbo.NormalizeForXML(sequenceNumber) AS sequenceNumber, dbo.NormalizeForXML(archiveGroup) AS archiveGroup, dbo.NormalizeForXML(archiveFile) AS archiveFile, dbo.NormalizeForXML(bIsTombstoned) AS bIsTombstoned from #CCM_sqlArchiveSet for xml raw,root('CCM_sqlArchiveSet')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(sqlFileGroupId) AS sqlFileGroupId, dbo.NormalizeForXML(sqlBackupSetId) AS sqlBackupSetId, dbo.NormalizeForXML(number) AS number, dbo.NormalizeForXML(physicalName) AS physicalName, dbo.NormalizeForXML(logicalName) AS logicalName, dbo.NormalizeForXML(physicalDrive) AS physicalDrive, dbo.NormalizeForXML(pageSize) AS pageSize, dbo.NormalizeForXML(pageCount) AS pageCount, dbo.NormalizeForXML(type) AS type from #CCM_sqlBackupFile for xml raw,root('CCM_sqlBackupFile')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(sqlDatabaseId) AS sqlDatabaseId, dbo.NormalizeForXML(applicationNumber) AS applicationNumber, dbo.NormalizeForXML(subClientName) AS subClientName, dbo.NormalizeForXML(streams) AS streams, dbo.NormalizeForXML(maxStreams) AS maxStreams, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(sqlFileSubClientGroupId) AS sqlFileSubClientGroupId from #CCM_sqlFileSubClient for xml raw,root('CCM_sqlFileSubClient')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(sqlFileSubClientId) AS sqlFileSubClientId, dbo.NormalizeForXML(sqlFileId) AS sqlFileId, dbo.NormalizeForXML(sqlFileGroupId) AS sqlFileGroupId, dbo.NormalizeForXML(nextId) AS nextId from #CCM_sqlFileSubClientGroup for xml raw,root('CCM_sqlFileSubClientGroup')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(sqlDatabaseId) AS sqlDatabaseId, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(lsn) AS lsn, dbo.NormalizeForXML(markTime) AS markTime from #CCM_sqlLogMarkNames for xml raw,root('CCM_sqlLogMarkNames')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(sqlId) AS sqlId, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(type) AS type from #CCM_sqlNames for xml raw,root('CCM_sqlNames')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(sqlId) AS sqlId, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(type) AS type from #CCM_sqlNames2 for xml raw,root('CCM_sqlNames2')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(backup_set_id) AS backup_set_id, dbo.NormalizeForXML(majorVersion) AS majorVersion, dbo.NormalizeForXML(minorVersion) AS minorVersion, dbo.NormalizeForXML(buildVersion) AS buildVersion, dbo.NormalizeForXML(database_creation_date) AS database_creation_date, dbo.NormalizeForXML(backup_start_Date) AS backup_start_Date, dbo.NormalizeForXML(backup_finish_Date) AS backup_finish_Date, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(instanceId) AS instanceId, dbo.NormalizeForXML(appId) AS appId, dbo.NormalizeForXML(backup_size) AS backup_size, dbo.NormalizeForXML(dbId) AS dbId, dbo.NormalizeForXML(first_lsn) AS first_lsn, dbo.NormalizeForXML(last_lsn) AS last_lsn, dbo.NormalizeForXML(checkpoint_lsn) AS checkpoint_lsn, dbo.NormalizeForXML(full_bkup_lsn) AS full_bkup_lsn, dbo.NormalizeForXML(sqlNameId) AS sqlNameId, dbo.NormalizeForXML(sqlLastLogBackup) AS sqlLastLogBackup, dbo.NormalizeForXML(sqlVssFullbackupTime) AS sqlVssFullbackupTime, dbo.NormalizeForXML(is_copy) AS is_copy, dbo.NormalizeForXML(backupmethod) AS backupmethod, dbo.NormalizeForXML(backupVendor) AS backupVendor, dbo.NormalizeForXML(jobId) AS jobId, dbo.NormalizeForXML(replica_id) AS replica_id, dbo.NormalizeForXML(group_database_id) AS group_database_id, dbo.NormalizeForXML(first_recovery_fork_guid) AS first_recovery_fork_guid, dbo.NormalizeForXML(last_recovery_fork_guid) AS last_recovery_fork_guid, dbo.NormalizeForXML(differential_base_guid) AS differential_base_guid, dbo.NormalizeForXML(database_guid) AS database_guid, dbo.NormalizeForXML(fork_point_lsn) AS fork_point_lsn, dbo.NormalizeForXML(differential_base_lsn) AS differential_base_lsn, dbo.NormalizeForXML(compressed_backup_size) AS compressed_backup_size, dbo.NormalizeForXML(begins_log_chain) AS begins_log_chain, dbo.NormalizeForXML(has_backup_checksums) AS has_backup_checksums, dbo.NormalizeForXML(database_bkup_lsn) AS database_bkup_lsn from #CCM_sqlDbBackupInfo for xml raw,root('CCM_sqlDbBackupInfo')) as xml),
cast((select dbo.NormalizeForXML(sqlDbBackupFileId) AS sqlDbBackupFileId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(aFileId) AS aFileId, dbo.NormalizeForXML(aFileOffset) AS aFileOffset, dbo.NormalizeForXML(aGroupId) AS aGroupId, dbo.NormalizeForXML(appId) AS appId, dbo.NormalizeForXML(DbFile) AS DbFile, dbo.NormalizeForXML(backupJobId) AS backupJobId from #CCM_sqlArchiveInfo for xml raw,root('CCM_sqlArchiveInfo')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(sqlDbBackupInfoId) AS sqlDbBackupInfoId, dbo.NormalizeForXML(number) AS number, dbo.NormalizeForXML(pageSize) AS pageSize, dbo.NormalizeForXML(pageCount) AS pageCount, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(sqlNameFgId) AS sqlNameFgId, dbo.NormalizeForXML(sqlNamePhyId) AS sqlNamePhyId, dbo.NormalizeForXML(sqlNameLogId) AS sqlNameLogId from #CCM_sqlFileBackupInfo for xml raw,root('CCM_sqlFileBackupInfo')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(dbId) AS dbId, dbo.NormalizeForXML(instanceId) AS instanceId, dbo.NormalizeForXML(dbName) AS dbName, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(lsn) AS lsn, dbo.NormalizeForXML(markTime) AS markTime from #CCM_sqlLogMarks for xml raw,root('CCM_sqlLogMarks')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(tblId) AS tblId, dbo.NormalizeForXML(instId) AS instId, dbo.NormalizeForXML(bkpNode) AS bkpNode, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(deleteFlag) AS deleteFlag, dbo.NormalizeForXML(deleted) AS deleted, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(opType) AS opType, dbo.NormalizeForXML(backupsetId) AS backupsetId, dbo.NormalizeForXML(maxDBdataSize) AS maxDBdataSize, dbo.NormalizeForXML(freeDBDataSize) AS freeDBDataSize, dbo.NormalizeForXML(underDBDir) AS underDBDir, dbo.NormalizeForXML(contType) AS contType, dbo.NormalizeForXML(totalPages) AS totalPages, dbo.NormalizeForXML(isAccessible) AS isAccessible from #CCM_oracleDataFiles for xml raw,root('CCM_oracleDataFiles')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(instId) AS instId, dbo.NormalizeForXML(bkpNode) AS bkpNode, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(deleteFlag) AS deleteFlag, dbo.NormalizeForXML(deleted) AS deleted, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(opType) AS opType, dbo.NormalizeForXML(backupsetId) AS backupsetId, dbo.NormalizeForXML(tablespaceId) AS tablespaceId, dbo.NormalizeForXML(maxDBdataSize) AS maxDBdataSize, dbo.NormalizeForXML(freeDBDataSize) AS freeDBDataSize, dbo.NormalizeForXML(pdbId) AS pdbId, dbo.NormalizeForXML(highwatermark) AS highwatermark from #CCM_oracleTableSpaces for xml raw,root('CCM_oracleTableSpaces')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(subClientId) AS subClientId, dbo.NormalizeForXML(taskId) AS taskId, dbo.NormalizeForXML(instId) AS instId, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(parentId) AS parentId, dbo.NormalizeForXML(objId) AS objId, dbo.NormalizeForXML(setType) AS setType, dbo.NormalizeForXML(actionType) AS actionType, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(underDBDir) AS underDBDir, dbo.NormalizeForXML(contType) AS contType, dbo.NormalizeForXML(totalPages) AS totalPages, dbo.NormalizeForXML(isAccessible) AS isAccessible from #CCM_oracleObjects for xml raw,root('CCM_oracleObjects')) as xml),
cast((select dbo.NormalizeForXML(pdbId) AS pdbId, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(instId) AS instId, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(deleteFlag) AS deleteFlag, dbo.NormalizeForXML(deleted) AS deleted, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(opType) AS opType, dbAttributes, dbo.NormalizeForXML(dbId) AS dbId from #CCM_OraclePluggableDBs for xml raw,root('CCM_OraclePluggableDBs')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(archFileId) AS archFileId, dbo.NormalizeForXML(sybInstanceId) AS sybInstanceId, dbo.NormalizeForXML(sybSubclientId) AS sybSubclientId, dbo.NormalizeForXML(sybDatabaseId) AS sybDatabaseId, dbo.NormalizeForXML(sybDatabaseName) AS sybDatabaseName, dbo.NormalizeForXML(sybBackupJobId_h) AS sybBackupJobId_h, dbo.NormalizeForXML(sybBackupJobId_l) AS sybBackupJobId_l, dbo.NormalizeForXML(stream) AS stream, dbo.NormalizeForXML(maxStream) AS maxStream from #CCM_sybArchFileInfo for xml raw,root('CCM_sybArchFileInfo')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(sybArchFileId) AS sybArchFileId, dbo.NormalizeForXML(startTime) AS startTime, dbo.NormalizeForXML(finishTime) AS finishTime from #CCM_sybTransLog for xml raw,root('CCM_sybTransLog')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(sybBackupJobId_h) AS sybBackupJobId_h, dbo.NormalizeForXML(sybBackupJobId_l) AS sybBackupJobId_l, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(sybInstanceId) AS sybInstanceId, dbo.NormalizeForXML(sybSubclientId) AS sybSubclientId, dbo.NormalizeForXML(sybDatabaseId) AS sybDatabaseId, dbo.NormalizeForXML(sybDatabaseName) AS sybDatabaseName, dbo.NormalizeForXML(sybDevNumber) AS sybDevNumber, dbo.NormalizeForXML(sybDevLogicalName) AS sybDevLogicalName, dbo.NormalizeForXML(sybDevPhyName) AS sybDevPhyName, dbo.NormalizeForXML(sybDevSize) AS sybDevSize, dbo.NormalizeForXML(sybDevStatus) AS sybDevStatus, dbo.NormalizeForXML(sybDevCtrlType) AS sybDevCtrlType, dbo.NormalizeForXML(sybDevHigh) AS sybDevHigh, dbo.NormalizeForXML(sybDevLow) AS sybDevLow from #CCM_sybSystemDevices for xml raw,root('CCM_sybSystemDevices')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(sybDevId) AS sybDevId, dbo.NormalizeForXML(sybBackupJobId_h) AS sybBackupJobId_h, dbo.NormalizeForXML(sybBackupJobId_l) AS sybBackupJobId_l, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(sybInstanceId) AS sybInstanceId, dbo.NormalizeForXML(sybSubclientId) AS sybSubclientId, dbo.NormalizeForXML(sybDatabaseId) AS sybDatabaseId, dbo.NormalizeForXML(sybDatabaseName) AS sybDatabaseName, dbo.NormalizeForXML(sysSysLstart) AS sysSysLstart, dbo.NormalizeForXML(sybSysVstart) AS sybSysVstart, dbo.NormalizeForXML(sybSysVsize) AS sybSysVsize, dbo.NormalizeForXML(sybSysSegMap) AS sybSysSegMap from #CCM_sybSystemUsages for xml raw,root('CCM_sybSystemUsages')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(Name) AS Name, dbo.NormalizeForXML(CId) AS CId, dbo.NormalizeForXML(LicType) AS LicType, dbo.NormalizeForXML(AppType) AS AppType, dbo.NormalizeForXML(OpType) AS OpType, dbo.NormalizeForXML(OpTimeUTC) AS OpTimeUTC, dbo.NormalizeForXML(TokensUsed) AS TokensUsed, dbo.NormalizeForXML(Eval) AS Eval, dbo.NormalizeForXML(ExpiryDateUTC) AS ExpiryDateUTC, dbo.NormalizeForXML(ReleaseId) AS ReleaseId, dbo.NormalizeForXML(EncryptedField) AS EncryptedField, dbo.NormalizeForXML(SimOSID) AS SimOSID, dbo.NormalizeForXML(Build) AS Build, dbo.NormalizeForXML(InstallFlag) AS InstallFlag, dbo.NormalizeForXML(UserID) AS UserID, dbo.NormalizeForXML(UsedCapacity) AS UsedCapacity from #CCM_LicUsage for xml raw,root('CCM_LicUsage')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(LicUsageId) AS LicUsageId, dbo.NormalizeForXML(Name) AS Name, dbo.NormalizeForXML(CId) AS CId, dbo.NormalizeForXML(LicType) AS LicType, dbo.NormalizeForXML(AppType) AS AppType, dbo.NormalizeForXML(OpType) AS OpType, dbo.NormalizeForXML(OpTimeUTC) AS OpTimeUTC, dbo.NormalizeForXML(TokensUsed) AS TokensUsed, dbo.NormalizeForXML(Eval) AS Eval, dbo.NormalizeForXML(ExpiryDateUTC) AS ExpiryDateUTC, dbo.NormalizeForXML(ReleaseId) AS ReleaseId, dbo.NormalizeForXML(EncryptedField) AS EncryptedField, dbo.NormalizeForXML(CreateTimeUTC) AS CreateTimeUTC, dbo.NormalizeForXML(SimOSID) AS SimOSID, dbo.NormalizeForXML(Build) AS Build, dbo.NormalizeForXML(InstallFlag) AS InstallFlag, dbo.NormalizeForXML(UserID) AS UserID, dbo.NormalizeForXML(UsedCapacity) AS UsedCapacity from #CCM_LicUsageHistory for xml raw,root('CCM_LicUsageHistory')) as xml),
cast((select dbo.NormalizeForXML(simLicAppTypeId) AS simLicAppTypeId, dbo.NormalizeForXML(eval_fld1) AS eval_fld1, dbo.NormalizeForXML(perm_fld1) AS perm_fld1, dbo.NormalizeForXML(commcellId) AS commcellId from #CCM_LicAal for xml raw,root('CCM_LicAal')) as xml),
cast((select dbo.NormalizeForXML(SIDBStoreId) AS SIDBStoreId, dbo.NormalizeForXML(SIDBStoreName) AS SIDBStoreName, dbo.NormalizeForXML(SIDBStoreAliasName) AS SIDBStoreAliasName, dbo.NormalizeForXML(CommCellId) AS CommCellId, dbo.NormalizeForXML(IdxCacheId) AS IdxCacheId, dbo.NormalizeForXML(IdxAccessPathId) AS IdxAccessPathId, dbo.NormalizeForXML(ClientId) AS ClientId, dbo.NormalizeForXML(FirstBackupTime) AS FirstBackupTime, dbo.NormalizeForXML(MinObjSizeKB) AS MinObjSizeKB, dbo.NormalizeForXML(oldestEligibleObjArchiveTime) AS oldestEligibleObjArchiveTime, dbo.NormalizeForXML(SignatureType) AS SignatureType, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(TotalDataSizeBytes) AS TotalDataSizeBytes, dbo.NormalizeForXML(InstancedDataSizeBytes) AS InstancedDataSizeBytes, dbo.NormalizeForXML(Status) AS Status, dbo.NormalizeForXML(LastAccessTime) AS LastAccessTime, dbo.NormalizeForXML(CreatedTime) AS CreatedTime, dbo.NormalizeForXML(SealedTime) AS SealedTime, dbo.NormalizeForXML(origCCSIDBStoreId) AS origCCSIDBStoreId, dbo.NormalizeForXML(Version) AS Version, dbo.NormalizeForXML(SIDBSnapPath) AS SIDBSnapPath, dbo.NormalizeForXML(LastSnapTime) AS LastSnapTime, dbo.NormalizeForXML(LastRecoveryTime) AS LastRecoveryTime, dbo.NormalizeForXML(SealedReason) AS SealedReason, dbo.NormalizeForXML(SIDBSiloedTime) AS SIDBSiloedTime, dbo.NormalizeForXML(SIDBSiloStatus) AS SIDBSiloStatus, dbo.NormalizeForXML(SIDBSiloJobId) AS SIDBSiloJobId, dbo.NormalizeForXML(SubStoreCount) AS SubStoreCount, dbo.NormalizeForXML(MaxAllowedConnections) AS MaxAllowedConnections, dbo.NormalizeForXML(MaxNumOfAFsInSecFile) AS MaxNumOfAFsInSecFile, dbo.NormalizeForXML(LastDDBVerificationTime) AS LastDDBVerificationTime, dbo.NormalizeForXML(LastDataVerificationTime) AS LastDataVerificationTime, dbo.NormalizeForXML(DedupFactor) AS DedupFactor, dbo.NormalizeForXML(AppTypeGroupId) AS AppTypeGroupId, dbo.NormalizeForXML(ExtendedFlags) AS ExtendedFlags, dbo.NormalizeForXML(FullReason) AS FullReason, dbo.NormalizeForXML(FullTime) AS FullTime, dbo.NormalizeForXML(SIDBGroupId) AS SIDBGroupId, dbo.NormalizeForXML(LastQuickDDBVerificationTime) AS LastQuickDDBVerificationTime from #CCM_IdxSIDBStore for xml raw,root('CCM_IdxSIDBStore')) as xml),
cast((select dbo.NormalizeForXML(SIDBStoreId) AS SIDBStoreId, dbo.NormalizeForXML(SubStoreId) AS SubStoreId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(GroupNumber) AS GroupNumber, dbo.NormalizeForXML(IdxCacheId) AS IdxCacheId, dbo.NormalizeForXML(IdxAccessPathId) AS IdxAccessPathId, dbo.NormalizeForXML(ClientId) AS ClientId, dbo.NormalizeForXML(FirstBackupTime) AS FirstBackupTime, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(TotalDataSizeBytes) AS TotalDataSizeBytes, dbo.NormalizeForXML(InstancedDataSizeBytes) AS InstancedDataSizeBytes, dbo.NormalizeForXML(Status) AS Status, dbo.NormalizeForXML(LastAccessTime) AS LastAccessTime, dbo.NormalizeForXML(CreatedTime) AS CreatedTime, dbo.NormalizeForXML(SealedTime) AS SealedTime, dbo.NormalizeForXML(Version) AS Version, dbo.NormalizeForXML(SIDBSnapPath) AS SIDBSnapPath, dbo.NormalizeForXML(LastSnapTime) AS LastSnapTime, dbo.NormalizeForXML(origSubStoreId) AS origSubStoreId, dbo.NormalizeForXML(ReconLevel) AS ReconLevel, dbo.NormalizeForXML(LastSnapJobId) AS LastSnapJobId, dbo.NormalizeForXML(DDBBackupCSGUID) AS DDBBackupCSGUID, dbo.NormalizeForXML(PrimaryId) AS PrimaryId, dbo.NormalizeForXML(MemDbTimeStamp) AS MemDbTimeStamp, dbo.NormalizeForXML(CorruptionTime) AS CorruptionTime, dbo.NormalizeForXML(ZeroRefBatchSeq) AS ZeroRefBatchSeq, dbo.NormalizeForXML(StartLogSequence) AS StartLogSequence, dbo.NormalizeForXML(EndLogSequence) AS EndLogSequence, dbo.NormalizeForXML(SnapLogSequence) AS SnapLogSequence, dbo.NormalizeForXML(MaxNumOfAFsInSecFile) AS MaxNumOfAFsInSecFile, dbo.NormalizeForXML(ExtendedFlags) AS ExtendedFlags, dbo.NormalizeForXML(DDBSubClientId) AS DDBSubClientId, dbo.NormalizeForXML(PageSize) AS PageSize from #CCM_IdxSIDBSubStore for xml raw,root('CCM_IdxSIDBSubStore')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(value) AS value, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified from #CCM_GXGlobalParam for xml raw,root('CCM_GXGlobalParam')) as xml),
cast((select dbo.NormalizeForXML(patternId) AS patternId, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(ownerId) AS ownerId, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(freq_type) AS freq_type, dbo.NormalizeForXML(freq_interval) AS freq_interval, dbo.NormalizeForXML(freq_relative_interval) AS freq_relative_interval, dbo.NormalizeForXML(freq_recurrence_factor) AS freq_recurrence_factor, dbo.NormalizeForXML(freq_subday_interval) AS freq_subday_interval, dbo.NormalizeForXML(skipOccurence) AS skipOccurence, dbo.NormalizeForXML(skipDayNumber) AS skipDayNumber, dbo.NormalizeForXML(active_start_date) AS active_start_date, dbo.NormalizeForXML(active_start_time) AS active_start_time, dbo.NormalizeForXML(active_end_date) AS active_end_date, dbo.NormalizeForXML(active_end_time) AS active_end_time, dbo.NormalizeForXML(active_end_occurence) AS active_end_occurence, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(tzId) AS tzId, dbo.NormalizeForXML(calendarId) AS calendarId, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(local_start_date) AS local_start_date, dbo.NormalizeForXML(local_end_date) AS local_end_date, dbo.NormalizeForXML(disabled) AS disabled, dbo.NormalizeForXML(deleted) AS deleted, dbo.NormalizeForXML(scheduling) AS scheduling, dbo.NormalizeForXML(freq_restart_interval) AS freq_restart_interval from #CCM_TM_Pattern for xml raw,root('CCM_TM_Pattern')) as xml),
cast((select dbo.NormalizeForXML(patternAssocId) AS patternAssocId, dbo.NormalizeForXML(patternId) AS patternId, dbo.NormalizeForXML(subTaskId) AS subTaskId, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(disabled) AS disabled, dbo.NormalizeForXML(deleted) AS deleted, dbo.NormalizeForXML(scheduling) AS scheduling from #CCM_TM_PatternAssoc for xml raw,root('CCM_TM_PatternAssoc')) as xml),
cast((select dbo.NormalizeForXML(subTaskId) AS subTaskId, dbo.NormalizeForXML(subTaskName) AS subTaskName, dbo.NormalizeForXML(taskId) AS taskId, dbo.NormalizeForXML(subTaskType) AS subTaskType, dbo.NormalizeForXML(operationType) AS operationType, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(subTaskOrder) AS subTaskOrder, dbo.NormalizeForXML(deleted) AS deleted, dbo.NormalizeForXML(uninstalled) AS uninstalled, dbo.NormalizeForXML(defaultTask) AS defaultTask, subOperationType from #CCM_TM_SubTask for xml raw,root('CCM_TM_SubTask')) as xml),
cast((select dbo.NormalizeForXML(assocId) AS assocId, dbo.NormalizeForXML(assocType) AS assocType, dbo.NormalizeForXML(taskId) AS taskId, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(clientGroupId) AS clientGroupId, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(apptypeId) AS apptypeId, dbo.NormalizeForXML(instanceId) AS instanceId, dbo.NormalizeForXML(backupsetId) AS backupsetId, dbo.NormalizeForXML(subclientId) AS subclientId, dbo.NormalizeForXML(policyId) AS policyId, dbo.NormalizeForXML(copyId) AS copyId, dbo.NormalizeForXML(srmReportSet) AS srmReportSet, dbo.NormalizeForXML(srmReportType) AS srmReportType, dbo.NormalizeForXML(exclude) AS exclude, dbo.NormalizeForXML(trackingPolicyId) AS trackingPolicyId, dbo.NormalizeForXML(MediaAgentId) AS MediaAgentId, dbo.NormalizeForXML(agentlessPolicyId) AS agentlessPolicyId, dbo.NormalizeForXML(workflowId) AS workflowId, dbo.NormalizeForXML(sidbStoreId) AS sidbStoreId, dbo.NormalizeForXML(libraryId) AS libraryId, dbo.NormalizeForXML(logMonitoringPolicyId) AS logMonitoringPolicyId, dbo.NormalizeForXML(entityId) AS entityId from #CCM_TM_AssocEntity for xml raw,root('CCM_TM_AssocEntity')) as xml),
cast((select dbo.NormalizeForXML(taskId) AS taskId, dbo.NormalizeForXML(taskName) AS taskName, dbo.NormalizeForXML(taskType) AS taskType, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(status) AS status, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(alertId) AS alertId, dbo.NormalizeForXML(ownerId) AS ownerId, dbo.NormalizeForXML(runUserId) AS runUserId, dbo.NormalizeForXML(initiatedFrom) AS initiatedFrom, dbo.NormalizeForXML(sequenceNumber) AS sequenceNumber, dbo.NormalizeForXML(localeId) AS localeId, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(deleted) AS deleted, dbo.NormalizeForXML(disabled) AS disabled, dbo.NormalizeForXML(uninstalled) AS uninstalled, dbo.NormalizeForXML(invalid) AS invalid, dbo.NormalizeForXML(defaultTask) AS defaultTask, dbo.NormalizeForXML(savedReport) AS savedReport, dbo.NormalizeForXML(serial) AS serial, dbo.NormalizeForXML(policyType) AS policyType, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(GUID) AS GUID, dbo.NormalizeForXML(isEZOperation) AS isEZOperation, dbo.NormalizeForXML(isAgentlessSRM) AS isAgentlessSRM, dbo.NormalizeForXML(hidden) AS hidden from #CCM_TM_Task for xml raw,root('CCM_TM_Task')) as xml),
cast((select dbo.NormalizeForXML(SMVolumeId) AS SMVolumeId, dbo.NormalizeForXML(SourceClientId) AS SourceClientId, dbo.NormalizeForXML(MountHostId) AS MountHostId, dbo.NormalizeForXML(CommCellId) AS CommCellId, dbo.NormalizeForXML(JobId) AS JobId, dbo.NormalizeForXML(ArchFileId) AS ArchFileId, dbo.NormalizeForXML(CopyId) AS CopyId, dbo.NormalizeForXML(AppId) AS AppId, dbo.NormalizeForXML(AppTypeId) AS AppTypeId, dbo.NormalizeForXML(PruneFlags) AS PruneFlags, dbo.NormalizeForXML(VolumeFlags) AS VolumeFlags, dbo.NormalizeForXML(VolumeStatus) AS VolumeStatus, dbo.NormalizeForXML(VolumeStatusUpdateTime) AS VolumeStatusUpdateTime, dbo.NormalizeForXML(MountStatus) AS MountStatus, dbo.NormalizeForXML(MountStatusUpdateTime) AS MountStatusUpdateTime, dbo.NormalizeForXML(LogicalUnmountTime) AS LogicalUnmountTime, dbo.NormalizeForXML(CreationTime) AS CreationTime, dbo.NormalizeForXML(RetryCount) AS RetryCount, dbo.NormalizeForXML(DevMode) AS DevMode, dbo.NormalizeForXML(UserId) AS UserId, dbo.NormalizeForXML(GroupId) AS GroupId, dbo.NormalizeForXML(SnapSource) AS SnapSource, dbo.NormalizeForXML(MountProxyId) AS MountProxyId, dbo.NormalizeForXML(RemoteOp) AS RemoteOp, dbo.NormalizeForXML(RemoteOpStatus) AS RemoteOpStatus, dbo.NormalizeForXML(VmHostId) AS VmHostId, dbo.NormalizeForXML(RecoveryPointId) AS RecoveryPointId, dbo.NormalizeForXML(OriginClientId) AS OriginClientId, dbo.NormalizeForXML(SourcePath) AS SourcePath, dbo.NormalizeForXML(MountPath) AS MountPath, dbo.NormalizeForXML(SourceGUID) AS SourceGUID, dbo.NormalizeForXML(MountGUID) AS MountGUID, dbo.NormalizeForXML(SourceDevice) AS SourceDevice, dbo.NormalizeForXML(MountDevice) AS MountDevice, dbo.NormalizeForXML(MountOptions) AS MountOptions, dbo.NormalizeForXML(ShadowSetId) AS ShadowSetId, dbo.NormalizeForXML(ShadowCopyId) AS ShadowCopyId, dbo.NormalizeForXML(RepBasePath) AS RepBasePath, dbo.NormalizeForXML(RepRelativePath) AS RepRelativePath, dbo.NormalizeForXML(OriginSourcePath) AS OriginSourcePath, dbo.NormalizeForXML(GUID) AS GUID, dbo.NormalizeForXML(ReserveField1) AS ReserveField1, dbo.NormalizeForXML(ReserveField2) AS ReserveField2, dbo.NormalizeForXML(ReserveFieldStr) AS ReserveFieldStr, dbo.NormalizeForXML(SourceVolumeId) AS SourceVolumeId, dbo.NormalizeForXML(MasterJobId) AS MasterJobId, dbo.NormalizeForXML(PartitionNum) AS PartitionNum, dbo.NormalizeForXML(UsedSpaceBytes) AS UsedSpaceBytes, dbo.NormalizeForXML(TotalSpaceBytes) AS TotalSpaceBytes, dbo.NormalizeForXML(PseudoClientId) AS PseudoClientId, dbo.NormalizeForXML(RequestId) AS RequestId, dbo.NormalizeForXML(TotalRetryCount) AS TotalRetryCount, dbo.NormalizeForXML(GroupingId) AS GroupingId from #CCM_SMVolume for xml raw,root('CCM_SMVolume')) as xml),
cast((select dbo.NormalizeForXML(SMVolSnapMapId) AS SMVolSnapMapId, dbo.NormalizeForXML(SMVolumeId) AS SMVolumeId, dbo.NormalizeForXML(SMSnapId) AS SMSnapId, dbo.NormalizeForXML(MetaDataId) AS MetaDataId, dbo.NormalizeForXML(GroupId) AS GroupId, dbo.NormalizeForXML(PruneFlags) AS PruneFlags, dbo.NormalizeForXML(OrigCCId) AS OrigCCId, dbo.NormalizeForXML(GUID) AS GUID, dbo.NormalizeForXML(ReserveField1) AS ReserveField1, dbo.NormalizeForXML(ReserveField2) AS ReserveField2, dbo.NormalizeForXML(ReserveFieldStr) AS ReserveFieldStr, dbo.NormalizeForXML(Flags) AS Flags, dbo.NormalizeForXML(GroupType) AS GroupType from #CCM_SMVolSnapMap for xml raw,root('CCM_SMVolSnapMap')) as xml),
cast((select dbo.NormalizeForXML(MetaDataId) AS MetaDataId, dbo.NormalizeForXML(MetaDataType) AS MetaDataType, dbo.NormalizeForXML(RefType) AS RefType, dbo.NormalizeForXML(RefId) AS RefId, dbo.NormalizeForXML(PruneFlags) AS PruneFlags, dbo.NormalizeForXML(MetaData) AS MetaData, dbo.NormalizeForXML(OrigCCId) AS OrigCCId, dbo.NormalizeForXML(GUID) AS GUID, dbo.NormalizeForXML(ReserveField1) AS ReserveField1, dbo.NormalizeForXML(ReserveField2) AS ReserveField2, dbo.NormalizeForXML(ReserveFieldStr) AS ReserveFieldStr, dbo.NormalizeForXML(Flags) AS Flags from #CCM_SMMetaData for xml raw,root('CCM_SMMetaData')) as xml),
cast((select dbo.NormalizeForXML(SMSnapId) AS SMSnapId, dbo.NormalizeForXML(SnapShotEngineId) AS SnapShotEngineId, dbo.NormalizeForXML(OriginalSnapEngineId) AS OriginalSnapEngineId, dbo.NormalizeForXML(ControlHostId) AS ControlHostId, dbo.NormalizeForXML(GroupId) AS GroupId, dbo.NormalizeForXML(SnapType) AS SnapType, dbo.NormalizeForXML(SnapFlags) AS SnapFlags, dbo.NormalizeForXML(PruneFlags) AS PruneFlags, dbo.NormalizeForXML(SnapStatus) AS SnapStatus, dbo.NormalizeForXML(SnapStatusUpdateTime) AS SnapStatusUpdateTime, dbo.NormalizeForXML(CreationTime) AS CreationTime, dbo.NormalizeForXML(ReplicationStatus) AS ReplicationStatus, dbo.NormalizeForXML(DeviceEntryType) AS DeviceEntryType, dbo.NormalizeForXML(ConnectionType) AS ConnectionType, dbo.NormalizeForXML(SnapSourceDevice) AS SnapSourceDevice, dbo.NormalizeForXML(SnapDevice) AS SnapDevice, dbo.NormalizeForXML(ShadowCopyId) AS ShadowCopyId, dbo.NormalizeForXML(UniqueIdentifier) AS UniqueIdentifier, dbo.NormalizeForXML(SourceIdentifier) AS SourceIdentifier, dbo.NormalizeForXML(TargetIdentifier) AS TargetIdentifier, dbo.NormalizeForXML(OrigCCId) AS OrigCCId, dbo.NormalizeForXML(GUID) AS GUID, dbo.NormalizeForXML(ReserveField1) AS ReserveField1, dbo.NormalizeForXML(ReserveField2) AS ReserveField2, dbo.NormalizeForXML(ReserveFieldStr) AS ReserveFieldStr, dbo.NormalizeForXML(ArrayVolumeId) AS ArrayVolumeId, dbo.NormalizeForXML(LunId) AS LunId, dbo.NormalizeForXML(UsedSpaceBytes) AS UsedSpaceBytes, dbo.NormalizeForXML(ReserveField3) AS ReserveField3, dbo.NormalizeForXML(ReserveField4) AS ReserveField4, dbo.NormalizeForXML(ArraySrcDevice) AS ArraySrcDevice, dbo.NormalizeForXML(ArrayTgtDevice) AS ArrayTgtDevice from #CCM_SMSnap for xml raw,root('CCM_SMSnap')) as xml),
cast((select dbo.NormalizeForXML(ControlHostId) AS ControlHostId, dbo.NormalizeForXML(SnapShotEngineId) AS SnapShotEngineId, dbo.NormalizeForXML(SnapVendorName) AS SnapVendorName, dbo.NormalizeForXML(SMArrayId) AS SMArrayId, dbo.NormalizeForXML(SMHostIP) AS SMHostIP, dbo.NormalizeForXML(SMHostName) AS SMHostName, dbo.NormalizeForXML(SMHostPortNumber) AS SMHostPortNumber, dbo.NormalizeForXML(SMHostUserName) AS SMHostUserName, dbo.NormalizeForXML(SMHostPassword) AS SMHostPassword, dbo.NormalizeForXML(SMHostFlags) AS SMHostFlags, dbo.NormalizeForXML(SMHostStatus) AS SMHostStatus, dbo.NormalizeForXML(SMHostDescription) AS SMHostDescription, dbo.NormalizeForXML(SnapShotEngineName) AS SnapShotEngineName, dbo.NormalizeForXML(DeviceGroupName) AS DeviceGroupName, dbo.NormalizeForXML(SMHostOption) AS SMHostOption, dbo.NormalizeForXML(SourceId) AS SourceId, dbo.NormalizeForXML(OrigCCId) AS OrigCCId, dbo.NormalizeForXML(GUID) AS GUID, dbo.NormalizeForXML(ReserveField1) AS ReserveField1, dbo.NormalizeForXML(ReserveField2) AS ReserveField2, dbo.NormalizeForXML(ReserveFieldStr) AS ReserveFieldStr, dbo.NormalizeForXML(ClientId) AS ClientId, dbo.NormalizeForXML(SoftState) AS SoftState, dbo.NormalizeForXML(IsEnabled) AS IsEnabled, dbo.NormalizeForXML(IsActive) AS IsActive, dbo.NormalizeForXML(BrokenCode) AS BrokenCode, dbo.NormalizeForXML(ReasonCode) AS ReasonCode, dbo.NormalizeForXML(Flags) AS Flags, dbo.NormalizeForXML(AdminConsole) AS AdminConsole, Properties, dbo.NormalizeForXML(ReserveField3) AS ReserveField3, dbo.NormalizeForXML(ReserveField4) AS ReserveField4, dbo.NormalizeForXML(GroupingId) AS GroupingId, dbo.NormalizeForXML(UniqueIdentifier) AS UniqueIdentifier, dbo.NormalizeForXML(CreatedTime) AS CreatedTime, dbo.NormalizeForXML(ModifiedTime) AS ModifiedTime, dbo.NormalizeForXML(CredentialId) AS CredentialId from #CCM_SMControlHost for xml raw,root('CCM_SMControlHost')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(domainName) AS domainName, dbo.NormalizeForXML(hostName) AS hostName, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(login) AS login, dbo.NormalizeForXML(password) AS password, dbo.NormalizeForXML(trustedHostUser) AS trustedHostUser, dbo.NormalizeForXML(trustedHostPW) AS trustedHostPW, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(enabled) AS enabled, dbo.NormalizeForXML(serviceType) AS serviceType, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(dnsRoot) AS dnsRoot, dbo.NormalizeForXML(dnsRootStatus) AS dnsRootStatus, dbo.NormalizeForXML(useSecureLdap) AS useSecureLdap, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(GUID) AS GUID, dbo.NormalizeForXML(port) AS port, dbo.NormalizeForXML(resourceId) AS resourceId, dbo.NormalizeForXML(checkTime) AS checkTime, dbo.NormalizeForXML(ownerId) AS ownerId, dbo.NormalizeForXML(ownerCompany) AS ownerCompany from #CCM_UMDSProviders for xml raw,root('CCM_UMDSProviders')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(umdsProviderId) AS umdsProviderId, dbo.NormalizeForXML(enabled) AS enabled, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(email) AS email, dbo.NormalizeForXML(lastCredSetTime) AS lastCredSetTime, dbo.NormalizeForXML(oldId) AS oldId from #CCM_UMDSgroups for xml raw,root('CCM_UMDSgroups')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(groupFlags) AS groupFlags, dbo.NormalizeForXML(allCapabilities) AS allCapabilities, dbo.NormalizeForXML(allAssociations) AS allAssociations, dbo.NormalizeForXML(selfAssociation) AS selfAssociation, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(GUID) AS GUID, dbo.NormalizeForXML(umdsProviderId) AS umdsProviderId, dbo.NormalizeForXML(email) AS email, dbo.NormalizeForXML(lastCredSetTime) AS lastCredSetTime from #CCM_UMGroups for xml raw,root('CCM_UMGroups')) as xml),
cast((select dbo.NormalizeForXML(umDSgroupId) AS umDSgroupId, dbo.NormalizeForXML(umgroupId) AS umgroupId, dbo.NormalizeForXML(flag) AS flag, dbo.NormalizeForXML(umdsGroupMapsId) AS umdsGroupMapsId from #CCM_UMDSGroupMaps for xml raw,root('CCM_UMDSGroupMaps')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(login) AS login, dbo.NormalizeForXML(password) AS password, dbo.NormalizeForXML(email) AS email, dbo.NormalizeForXML(datePasswordSet) AS datePasswordSet, dbo.NormalizeForXML(dateExpires) AS dateExpires, dbo.NormalizeForXML(policy) AS policy, dbo.NormalizeForXML(enabled) AS enabled, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(pVer) AS pVer, dbo.NormalizeForXML(Pager) AS Pager, dbo.NormalizeForXML(lastLogInTime) AS lastLogInTime, dbo.NormalizeForXML(credSetTime) AS credSetTime, dbo.NormalizeForXML(umDSproviderId) AS umDSproviderId, dbo.NormalizeForXML(userGuid) AS userGuid, dbo.NormalizeForXML(origUserGuid) AS origUserGuid, dbo.NormalizeForXML(origCCId) AS origCCId, dbo.NormalizeForXML(salt) AS salt, dbo.NormalizeForXML(companyId) AS companyId from #CCM_UMUsers for xml raw,root('CCM_UMUsers')) as xml),
cast((select dbo.NormalizeForXML(userId) AS userId, dbo.NormalizeForXML(groupId) AS groupId, dbo.NormalizeForXML(flag) AS flag, dbo.NormalizeForXML(umUserGroupId) AS umUserGroupId from #CCM_UMUserGroup for xml raw,root('CCM_UMUserGroup')) as xml),
cast((select dbo.NormalizeForXML(userId) AS userId, dbo.NormalizeForXML(value) AS value from #CCM_UMUserPrefs for xml raw,root('CCM_UMUserPrefs')) as xml),
cast((select dbo.NormalizeForXML(userId) AS userId, dbo.NormalizeForXML(groupId) AS groupId, dbo.NormalizeForXML(flag) AS flag, dbo.NormalizeForXML(umdsUserGroupId) AS umdsUserGroupId from #CCM_UMDSUserGroup for xml raw,root('CCM_UMDSUserGroup')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(commcellId) AS commcellId, dbo.NormalizeForXML(name) AS name, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(disabled) AS disabled, dbo.NormalizeForXML(isPrivate) AS isPrivate, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(ownerId) AS ownerId, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(GUID) AS GUID, xmlProperties, dbo.NormalizeForXML(capabilitiesBitMask) AS capabilitiesBitMask, dbo.NormalizeForXML(permissionsString) AS permissionsString from #CCM_UMRoles for xml raw,root('CCM_UMRoles')) as xml),
cast((select dbo.NormalizeForXML(roleId) AS roleId, dbo.NormalizeForXML(hierarchyLevel) AS hierarchyLevel, dbo.NormalizeForXML(categoryId) AS categoryId, dbo.NormalizeForXML(permissionId) AS permissionId, dbo.NormalizeForXML(excludeCategory) AS excludeCategory, dbo.NormalizeForXML(excludePermission) AS excludePermission from #CCM_UMRolesPermissions for xml raw,root('CCM_UMRolesPermissions')) as xml),
cast((select dbo.NormalizeForXML(roleId) AS roleId, dbo.NormalizeForXML(categoryId) AS categoryId, dbo.NormalizeForXML(permissionId) AS permissionId from #CCM_UMRolesWithPermissionsExpanded for xml raw,root('CCM_UMRolesWithPermissionsExpanded')) as xml),
cast((select dbo.NormalizeForXML(entityType) AS entityType, dbo.NormalizeForXML(entityId) AS entityId, dbo.NormalizeForXML(userOrGroupId) AS userOrGroupId, dbo.NormalizeForXML(isUser) AS isUser, dbo.NormalizeForXML(authorId) AS authorId, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(companyId) AS companyId from #CCM_UMOwners for xml raw,root('CCM_UMOwners')) as xml),
cast((select dbo.NormalizeForXML(entityType) AS entityType, dbo.NormalizeForXML(entityId) AS entityId, dbo.NormalizeForXML(roleId) AS roleId, dbo.NormalizeForXML(permissionId) AS permissionId, dbo.NormalizeForXML(authorId) AS authorId from #CCM_UMOwnerRoles for xml raw,root('CCM_UMOwnerRoles')) as xml),
cast((select dbo.NormalizeForXML(roleId) AS roleId, dbo.NormalizeForXML(permissionId) AS permissionId, dbo.NormalizeForXML(userOrGroupId) AS userOrGroupId, dbo.NormalizeForXML(isUser) AS isUser, dbo.NormalizeForXML(isRoleAllowed) AS isRoleAllowed, dbo.NormalizeForXML(propagateToChildObjects) AS propagateToChildObjects, dbo.NormalizeForXML(roleValidityDate) AS roleValidityDate, dbo.NormalizeForXML(timeZone) AS timeZone, dbo.NormalizeForXML(exclude) AS exclude, dbo.NormalizeForXML(entityType1) AS entityType1, dbo.NormalizeForXML(entityId1) AS entityId1, dbo.NormalizeForXML(entityType2) AS entityType2, dbo.NormalizeForXML(entityId2) AS entityId2, dbo.NormalizeForXML(entityType3) AS entityType3, dbo.NormalizeForXML(entityId3) AS entityId3, dbo.NormalizeForXML(entityType4) AS entityType4, dbo.NormalizeForXML(entityId4) AS entityId4, dbo.NormalizeForXML(entityType5) AS entityType5, dbo.NormalizeForXML(entityId5) AS entityId5, dbo.NormalizeForXML(includeAll) AS includeAll, dbo.NormalizeForXML(isCreator) AS isCreator, dbo.NormalizeForXML(authorId) AS authorId, dbo.NormalizeForXML(companyId) AS companyId, dbo.NormalizeForXML(securityId) AS securityId from #CCM_UMSecurityAssociations for xml raw,root('CCM_UMSecurityAssociations')) as xml),
cast((select dbo.NormalizeForXML(mergedCcId) AS mergedCcId, dbo.NormalizeForXML(foreignJobId) AS foreignJobId, dbo.NormalizeForXML(newJobId) AS newJobId from #CCM_edcJobIdMap for xml raw,root('CCM_edcJobIdMap')) as xml),
cast((select dbo.NormalizeForXML(exServerAliasName) AS exServerAliasName, dbo.NormalizeForXML(exMachineName) AS exMachineName, dbo.NormalizeForXML(exMachineHostName) AS exMachineHostName, dbo.NormalizeForXML(gxMachineName) AS gxMachineName, dbo.NormalizeForXML(gxMachineHostName) AS gxMachineHostName, dbo.NormalizeForXML(creationTime) AS creationTime from #CCM_edcClientNameMap for xml raw,root('CCM_edcClientNameMap')) as xml),
cast((select dbo.NormalizeForXML(archGroupId) AS archGroupId, dbo.NormalizeForXML(enabled) AS enabled, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(startTime) AS startTime, dbo.NormalizeForXML(sourceCopyId) AS sourceCopyId, dbo.NormalizeForXML(deferredDays) AS deferredDays, dbo.NormalizeForXML(numPeriod) AS numPeriod, dbo.NormalizeForXML(dayNumber) AS dayNumber, dbo.NormalizeForXML(currPeriodBegin) AS currPeriodBegin, dbo.NormalizeForXML(currPeriodEnd) AS currPeriodEnd, dbo.NormalizeForXML(calendarId) AS calendarId, dbo.NormalizeForXML(numOfReaders) AS numOfReaders, dbo.NormalizeForXML(prevPeriodBegin) AS prevPeriodBegin, dbo.NormalizeForXML(nextPeriodEnd) AS nextPeriodEnd from #CCM_archMaterializeSnapshotProp for xml raw,root('CCM_archMaterializeSnapshotProp')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(isLocalDrive) AS isLocalDrive, dbo.NormalizeForXML(cachePath) AS cachePath, dbo.NormalizeForXML(username) AS username, dbo.NormalizeForXML(passwd) AS passwd, dbo.NormalizeForXML(isEnabled) AS isEnabled, dbo.NormalizeForXML(autoSyncWithCS) AS autoSyncWithCS, dbo.NormalizeForXML(inSyncWithCS) AS inSyncWithCS, dbo.NormalizeForXML(isDeleted) AS isDeleted, dbo.NormalizeForXML(packageStatus) AS packageStatus, dbo.NormalizeForXML(SWSharePath) AS SWSharePath from #CCM_PatchUpdateAgentInfo for xml raw,root('CCM_PatchUpdateAgentInfo')) as xml),
cast((select dbo.NormalizeForXML(ClientId) AS ClientId, dbo.NormalizeForXML(ReleaseId) AS ReleaseId, dbo.NormalizeForXML(OSId) AS OSId, dbo.NormalizeForXML(HighestSP) AS HighestSP, dbo.NormalizeForXML(AddUpdates) AS AddUpdates, dbo.NormalizeForXML(IsSPValid) AS IsSPValid, dbo.NormalizeForXML(SPVersionId) AS SPVersionId, dbo.NormalizeForXML(id) AS id from #CCM_PatchMultiCache for xml raw,root('CCM_PatchMultiCache')) as xml),
cast((select dbo.NormalizeForXML(CCRId) AS CCRId, dbo.NormalizeForXML(CCRLevel) AS CCRLevel, dbo.NormalizeForXML(CCRStartTime) AS CCRStartTime, dbo.NormalizeForXML(CCREndTime) AS CCREndTime from #CCM_CCRCommCellReadiness for xml raw,root('CCM_CCRCommCellReadiness')) as xml),
cast((select dbo.NormalizeForXML(CCRId) AS CCRId, dbo.NormalizeForXML(ClientId) AS ClientId, dbo.NormalizeForXML(SubClientId) AS SubClientId, dbo.NormalizeForXML(DataPathId) AS DataPathId, dbo.NormalizeForXML(CCRResultFlag) AS CCRResultFlag, dbo.NormalizeForXML(lastUnCompBytes) AS lastUnCompBytes, dbo.NormalizeForXML(lastCompBytes) AS lastCompBytes, dbo.NormalizeForXML(capacityAvailable) AS capacityAvailable, dbo.NormalizeForXML(appTypeId) AS appTypeId, dbo.NormalizeForXML(dataWritten) AS dataWritten, dbo.NormalizeForXML(CCRNetworkReadinessFlag) AS CCRNetworkReadinessFlag, dbo.NormalizeForXML(CCRResourceReadinessFlag) AS CCRResourceReadinessFlag from #CCM_CCRToSubClient for xml raw,root('CCM_CCRToSubClient')) as xml),
cast((select dbo.NormalizeForXML(FromClientId) AS FromClientId, dbo.NormalizeForXML(FromClientInterfaceName) AS FromClientInterfaceName, dbo.NormalizeForXML(ToClientId) AS ToClientId, dbo.NormalizeForXML(ToClientInterfaceName) AS ToClientInterfaceName, dbo.NormalizeForXML(NumberOfNWHops) AS NumberOfNWHops, dbo.NormalizeForXML(NWDelayInMilliSec) AS NWDelayInMilliSec, dbo.NormalizeForXML(LastUpdateTime) AS LastUpdateTime, dbo.NormalizeForXML(IsEnabled) AS IsEnabled, dbo.NormalizeForXML(Flag) AS Flag, dbo.NormalizeForXML(errorCode) AS errorCode, dbo.NormalizeForXML(lastOnlineTime) AS lastOnlineTime, dbo.NormalizeForXML(serviceType) AS serviceType, dbo.NormalizeForXML(IsDip) AS IsDip, dbo.NormalizeForXML(lastOfflineTime) AS lastOfflineTime from #CCM_CCRClientToClient for xml raw,root('CCM_CCRClientToClient')) as xml),
cast((select dbo.NormalizeForXML(archFileId) AS archFileId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(archCopyId) AS archCopyId, dbo.NormalizeForXML(SIDBStoreId) AS SIDBStoreId, dbo.NormalizeForXML(primaryObjects) AS primaryObjects, dbo.NormalizeForXML(secondaryObjects) AS secondaryObjects, dbo.NormalizeForXML(primaryObjSize) AS primaryObjSize, dbo.NormalizeForXML(secondaryObjSize) AS secondaryObjSize, dbo.NormalizeForXML(primaryMetaDataSize) AS primaryMetaDataSize, dbo.NormalizeForXML(secondaryMetaDataSize) AS secondaryMetaDataSize, dbo.NormalizeForXML(transDataSize) AS transDataSize, dbo.NormalizeForXML(savedDataSize) AS savedDataSize from #CCM_archFileCopyDedup for xml raw,root('CCM_archFileCopyDedup')) as xml),
cast((select dbo.NormalizeForXML(archFileId) AS archFileId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(archCopyId) AS archCopyId, dbo.NormalizeForXML(encKeyType) AS encKeyType, dbo.NormalizeForXML(encKey) AS encKey, dbo.NormalizeForXML(SIDBStoreId) AS SIDBStoreId, dbo.NormalizeForXML(encRSA) AS encRSA, dbo.NormalizeForXML(encKeyId) AS encKeyId from #CCM_archFileSIDBKeys for xml raw,root('CCM_archFileSIDBKeys')) as xml),
cast((select dbo.NormalizeForXML(EntityId) AS EntityId, dbo.NormalizeForXML(EntityType) AS EntityType, dbo.NormalizeForXML(propertyName) AS propertyName, dbo.NormalizeForXML(propDataType) AS propDataType, dbo.NormalizeForXML(intVal) AS intVal, dbo.NormalizeForXML(longlongVal) AS longlongVal, dbo.NormalizeForXML(stringVal) AS stringVal, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(modified) AS modified, dbo.NormalizeForXML(CommCellId) AS CommCellId from #CCM_MMEntityProp for xml raw,root('CCM_MMEntityProp')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(passPhrase) AS passPhrase from #CCM_DlpClientPass for xml raw,root('CCM_DlpClientPass')) as xml),
cast((select dbo.NormalizeForXML(currentIdxServer) AS currentIdxServer, dbo.NormalizeForXML(archFileId) AS archFileId, dbo.NormalizeForXML(commCellId) AS commCellId, dbo.NormalizeForXML(appId) AS appId, dbo.NormalizeForXML(pruneTime) AS pruneTime, dbo.NormalizeForXML(backupSetGUID) AS backupSetGUID from #CCM_archIndexingAged for xml raw,root('CCM_archIndexingAged')) as xml),
cast((select dbo.NormalizeForXML(id) AS id, dbo.NormalizeForXML(dbName) AS dbName, dbo.NormalizeForXML(type) AS type, dbo.NormalizeForXML(idxDbEngineType) AS idxDbEngineType, dbo.NormalizeForXML(backupSetId) AS backupSetId, dbo.NormalizeForXML(currentIdxServer) AS currentIdxServer, dbo.NormalizeForXML(backupSetGUID) AS backupSetGUID, properties, dbo.NormalizeForXML(isPrimary) AS isPrimary, dbo.NormalizeForXML(committedTransactionId) AS committedTransactionId, dbo.NormalizeForXML(archGroupId) AS archGroupId, dbo.NormalizeForXML(flags) AS flags from #CCM_App_IndexDBInfo for xml raw,root('CCM_App_IndexDBInfo')) as xml),
cast((select dbo.NormalizeForXML(dbName) AS dbName, dbo.NormalizeForXML(backupSetGUID) AS backupSetGUID, dbo.NormalizeForXML(afileId) AS afileId, dbo.NormalizeForXML(commcellId) AS commcellId, dbo.NormalizeForXML(startTime) AS startTime, dbo.NormalizeForXML(endTime) AS endTime, dbo.NormalizeForXML(flags) AS flags from #CCM_App_IndexCheckpointInfo for xml raw,root('CCM_App_IndexCheckpointInfo')) as xml),
cast((select dbo.NormalizeForXML(EntityId) AS EntityId, dbo.NormalizeForXML(EntityType) AS EntityType, dbo.NormalizeForXML(DestCCID) AS DestCCID, dbo.NormalizeForXML(SourceCCId) AS SourceCCId, dbo.NormalizeForXML(EntityIdOnSourceCC) AS EntityIdOnSourceCC, dbo.NormalizeForXML(ImportJobIdOnDestCC) AS ImportJobIdOnDestCC, dbo.NormalizeForXML(ImportTime) AS ImportTime from #CCM_GRC_History for xml raw,root('CCM_GRC_History')) as xml),
cast((select dbo.NormalizeForXML(diskId) AS diskId, dbo.NormalizeForXML(deviceId) AS deviceId, dbo.NormalizeForXML(diskSerialNum) AS diskSerialNum, dbo.NormalizeForXML(hostId) AS hostId, dbo.NormalizeForXML(blockSize) AS blockSize, dbo.NormalizeForXML(version) AS version, dbo.NormalizeForXML(numBlocks) AS numBlocks, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(deviceLocation) AS deviceLocation, dbo.NormalizeForXML(deviceOSPath) AS deviceOSPath, dbo.NormalizeForXML(backingDevice) AS backingDevice, dbo.NormalizeForXML(blockDeviceUUID) AS blockDeviceUUID, dbo.NormalizeForXML(freeSpaceMB) AS freeSpaceMB, dbo.NormalizeForXML(diskCapacityMB) AS diskCapacityMB, dbo.NormalizeForXML(ErrorCode) AS ErrorCode, Properties, dbo.NormalizeForXML(blockNumber) AS blockNumber, dbo.NormalizeForXML(SubVolume) AS SubVolume, dbo.NormalizeForXML(Vendor) AS Vendor, dbo.NormalizeForXML(FileSystem) AS FileSystem, dbo.NormalizeForXML(Product) AS Product, dbo.NormalizeForXML(MountOptions) AS MountOptions, dbo.NormalizeForXML(BrickFullPath) AS BrickFullPath, dbo.NormalizeForXML(BrickHealth) AS BrickHealth, dbo.NormalizeForXML(BlockDeviceHealth) AS BlockDeviceHealth, dbo.NormalizeForXML(mountPathUsageType) AS mountPathUsageType, dbo.NormalizeForXML(GUID) AS GUID from #CCM_MMDiskHWInfo for xml raw,root('CCM_MMDiskHWInfo')) as xml),
cast((select dbo.NormalizeForXML(ClientId) AS ClientId, NetworkInformation, dbo.NormalizeForXML(GlusterMetaData) AS GlusterMetaData, HardwareInformation from #CCM_MMScaleOutMAInfo for xml raw,root('CCM_MMScaleOutMAInfo')) as xml),
cast((select dbo.NormalizeForXML(StoragePoolId) AS StoragePoolId, dbo.NormalizeForXML(StoragePoolName) AS StoragePoolName, dbo.NormalizeForXML(LibraryId) AS LibraryId, dbo.NormalizeForXML(GDSPId) AS GDSPId, dbo.NormalizeForXML(DisperseFactor) AS DisperseFactor, dbo.NormalizeForXML(RedundancyFactor) AS RedundancyFactor, dbo.NormalizeForXML(NodesPerBlock) AS NodesPerBlock, dbo.NormalizeForXML(StoragePoolEnabled) AS StoragePoolEnabled, NetworkInformation, Metadata, dbo.NormalizeForXML(StoragePoolStatus) AS StoragePoolStatus, dbo.NormalizeForXML(Flags) AS Flags from #CCM_MMSDSStoragePool for xml raw,root('CCM_MMSDSStoragePool')) as xml),
cast((select dbo.NormalizeForXML(assocId) AS assocId, dbo.NormalizeForXML(credentialId) AS credentialId, dbo.NormalizeForXML(entityType) AS entityType, dbo.NormalizeForXML(entityId) AS entityId, dbo.NormalizeForXML(CredAssocGUID) AS CredAssocGUID from #CCM_APP_CredentialAssoc for xml raw,root('CCM_APP_CredentialAssoc')) as xml),
cast((select dbo.NormalizeForXML(credentialId) AS credentialId, dbo.NormalizeForXML(credentialName) AS credentialName, dbo.NormalizeForXML(recordType) AS recordType, dbo.NormalizeForXML(userName) AS userName, dbo.NormalizeForXML(password) AS password, dbo.NormalizeForXML(description) AS description, dbo.NormalizeForXML(created) AS created, dbo.NormalizeForXML(enabled) AS enabled, dbo.NormalizeForXML(flags) AS flags, dbo.NormalizeForXML(credentialGUID) AS credentialGUID, credentialInfo from #CCM_APP_Credentials for xml raw,root('CCM_APP_Credentials')) as xml),
cast((select dbo.NormalizeForXML(encKeyId) AS encKeyId, dbo.NormalizeForXML(clientId) AS clientId, dbo.NormalizeForXML(archCopyId) AS archCopyId, dbo.NormalizeForXML(encRSA) AS encRSA, dbo.NormalizeForXML(encKeyType) AS encKeyType, dbo.NormalizeForXML(encKey) AS encKey, dbo.NormalizeForXML(isActive) AS isActive, dbo.NormalizeForXML(createTime) AS createTime, dbo.NormalizeForXML(expiredTime) AS expiredTime, dbo.NormalizeForXML(origEncKeyId) AS origEncKeyId from #CCM_ArchEncKeys for xml raw,root('CCM_ArchEncKeys')) as xml)
	for xml path(''),root('CapturedData')
	)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errCode = ERROR_NUMBER()
	SET @o_errStr = 'Exception in selecting data into xml from CCM_* tables at ERROR_LINE(): '+ CAST(ERROR_LINE() as varchar(10))+' ERROR_MESSAGE(): ' + ERROR_MESSAGE()
	GOTO CX_ERROR_EXIT
END CATCH
/******** Drop temp tables *********/
BEGIN TRY
--Macro CCM_DROP_TEMP_TABLES_ALL will be replaced with 'drop table #CCM_*' statements by DB_SQL project while building the .sql from .sp

IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_DataPathMapping]') )
BEGIN
	DROP TABLE #CCM_DataPathMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ClientNameMapping]') )
BEGIN
	DROP TABLE #CCM_ClientNameMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MountPathMapping]') )
BEGIN
	DROP TABLE #CCM_MountPathMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ClientLicenses]') )
BEGIN
	DROP TABLE #CCM_ClientLicenses
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxAccessPathMapping]') )
BEGIN
	DROP TABLE #CCM_IdxAccessPathMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_VirtualClientLicenses]') )
BEGIN
	DROP TABLE #CCM_VirtualClientLicenses
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MountPathLicense]') )
BEGIN
	DROP TABLE #CCM_MountPathLicense
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_DevicePathMapping]') )
BEGIN
	DROP TABLE #CCM_DevicePathMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LibraryMapping]') )
BEGIN
	DROP TABLE #CCM_LibraryMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_FeatureLicenses]') )
BEGIN
	DROP TABLE #CCM_FeatureLicenses
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ReformatedMedia]') )
BEGIN
	DROP TABLE #CCM_ReformatedMedia
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CommCell]') )
BEGIN
	DROP TABLE #CCM_APP_CommCell
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Client]') )
BEGIN
	DROP TABLE #CCM_APP_Client
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ClientProp]') )
BEGIN
	DROP TABLE #CCM_APP_ClientProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_VMProp]') )
BEGIN
	DROP TABLE #CCM_APP_VMProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMQinetixUpdateStatus]') )
BEGIN
	DROP TABLE #CCM_JMQinetixUpdateStatus
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Platform]') )
BEGIN
	DROP TABLE #CCM_APP_Platform
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_IDAName]') )
BEGIN
	DROP TABLE #CCM_APP_IDAName
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_IDAProp]') )
BEGIN
	DROP TABLE #CCM_APP_IDAProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_DCvolInfo]') )
BEGIN
	DROP TABLE #CCM_APP_DCvolInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_InstanceName]') )
BEGIN
	DROP TABLE #CCM_APP_InstanceName
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_InstanceProp]') )
BEGIN
	DROP TABLE #CCM_APP_InstanceProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_InstFilterFile]') )
BEGIN
	DROP TABLE #CCM_APP_InstFilterFile
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_BackupSetName]') )
BEGIN
	DROP TABLE #CCM_APP_BackupSetName
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_BackupSetProp]') )
BEGIN
	DROP TABLE #CCM_APP_BackupSetProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_BackupSetFilterFile]') )
BEGIN
	DROP TABLE #CCM_APP_BackupSetFilterFile
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Application]') )
BEGIN
	DROP TABLE #CCM_APP_Application
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_SubClientProp]') )
BEGIN
	DROP TABLE #CCM_APP_SubClientProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ComponentProp]') )
BEGIN
	DROP TABLE #CCM_APP_ComponentProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ScFilterFile]') )
BEGIN
	DROP TABLE #CCM_APP_ScFilterFile
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_VMToPMMap]') )
BEGIN
	DROP TABLE #CCM_APP_VMToPMMap
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_VMBackupSet]') )
BEGIN
	DROP TABLE #CCM_APP_VMBackupSet
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simClientAppsV2]') )
BEGIN
	DROP TABLE #CCM_simClientAppsV2
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simAllGalaxyRel]') )
BEGIN
	DROP TABLE #CCM_simAllGalaxyRel
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_PatchDBSPInfo]') )
BEGIN
	DROP TABLE #CCM_PatchDBSPInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simInstalledPackages]') )
BEGIN
	DROP TABLE #CCM_simInstalledPackages
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simInstalledPackagesHistory]') )
BEGIN
	DROP TABLE #CCM_simInstalledPackagesHistory
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_simXMLRequest]') )
BEGIN
	DROP TABLE #CCM_simXMLRequest
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CustomCalendar]') )
BEGIN
	DROP TABLE #CCM_APP_CustomCalendar
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CustomCalendarMonths]') )
BEGIN
	DROP TABLE #CCM_APP_CustomCalendarMonths
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_OracleRacInstance]') )
BEGIN
	DROP TABLE #CCM_APP_OracleRacInstance
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ExtendedProperties]') )
BEGIN
	DROP TABLE #CCM_APP_ExtendedProperties
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_ClientGroup]') )
BEGIN
	DROP TABLE #CCM_APP_ClientGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SchedHoliday]') )
BEGIN
	DROP TABLE #CCM_SchedHoliday
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_OpWindowRule]') )
BEGIN
	DROP TABLE #CCM_APP_OpWindowRule
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_MongoDbSCPriority]') )
BEGIN
	DROP TABLE #CCM_APP_MongoDbSCPriority
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archGroup]') )
BEGIN
	DROP TABLE #CCM_archGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archGroupCopy]') )
BEGIN
	DROP TABLE #CCM_archGroupCopy
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopyMediaRefreshProp]') )
BEGIN
	DROP TABLE #CCM_archCopyMediaRefreshProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopyToGlobalPolicy]') )
BEGIN
	DROP TABLE #CCM_archCopyToGlobalPolicy
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archStream]') )
BEGIN
	DROP TABLE #CCM_archStream
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAgingRule]') )
BEGIN
	DROP TABLE #CCM_archAgingRule
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAgingRuleExtended]') )
BEGIN
	DROP TABLE #CCM_archAgingRuleExtended
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAppCopyAgingRule]') )
BEGIN
	DROP TABLE #CCM_archAppCopyAgingRule
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archAppCopyAgingRuleExtended]') )
BEGIN
	DROP TABLE #CCM_archAppCopyAgingRuleExtended
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archSelectiveCopy]') )
BEGIN
	DROP TABLE #CCM_archSelectiveCopy
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopyToApp]') )
BEGIN
	DROP TABLE #CCM_archCopyToApp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCopySIDBStore]') )
BEGIN
	DROP TABLE #CCM_archCopySIDBStore
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchEncKeyProvider]') )
BEGIN
	DROP TABLE #CCM_ArchEncKeyProvider
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchEncKeyProviderAssoc]') )
BEGIN
	DROP TABLE #CCM_ArchEncKeyProviderAssoc
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchCopyEncProperties]') )
BEGIN
	DROP TABLE #CCM_ArchCopyEncProperties
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archPipeConfig]') )
BEGIN
	DROP TABLE #CCM_archPipeConfig
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFile]') )
BEGIN
	DROP TABLE #CCM_archFile
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileOracle]') )
BEGIN
	DROP TABLE #CCM_archFileOracle
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileOracleBackupPiece]') )
BEGIN
	DROP TABLE #CCM_archFileOracleBackupPiece
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileCopy]') )
BEGIN
	DROP TABLE #CCM_archFileCopy
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archChunk]') )
BEGIN
	DROP TABLE #CCM_archChunk
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archChunkMapping]') )
BEGIN
	DROP TABLE #CCM_archChunkMapping
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archDB2Log]') )
BEGIN
	DROP TABLE #CCM_archDB2Log
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archCheckHistory]') )
BEGIN
	DROP TABLE #CCM_archCheckHistory
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileSiloVolume]') )
BEGIN
	DROP TABLE #CCM_archFileSiloVolume
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archChunkToSilo]') )
BEGIN
	DROP TABLE #CCM_archChunkToSilo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFailedKilledJobInfo]') )
BEGIN
	DROP TABLE #CCM_archFailedKilledJobInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobStats]') )
BEGIN
	DROP TABLE #CCM_JMJobStats
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobAction]') )
BEGIN
	DROP TABLE #CCM_JMJobAction
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMBkpStats]') )
BEGIN
	DROP TABLE #CCM_JMBkpStats
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMBkpAtmptStats]') )
BEGIN
	DROP TABLE #CCM_JMBkpAtmptStats
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMAdminJobStatsTable]') )
BEGIN
	DROP TABLE #CCM_JMAdminJobStatsTable
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMAdminJobAttemptStatsTable]') )
BEGIN
	DROP TABLE #CCM_JMAdminJobAttemptStatsTable
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobDataLink]') )
BEGIN
	DROP TABLE #CCM_JMJobDataLink
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobOptions]') )
BEGIN
	DROP TABLE #CCM_JMJobOptions
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobDataStats]') )
BEGIN
	DROP TABLE #CCM_JMJobDataStats
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMOracleRACClientsUsed]') )
BEGIN
	DROP TABLE #CCM_JMOracleRACClientsUsed
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobInfo]') )
BEGIN
	DROP TABLE #CCM_JMJobInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMAdminJobInfoTable]') )
BEGIN
	DROP TABLE #CCM_JMAdminJobInfoTable
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMBkpJobInfo]') )
BEGIN
	DROP TABLE #CCM_JMBkpJobInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMJobSnapshotStats]') )
BEGIN
	DROP TABLE #CCM_JMJobSnapshotStats
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_GRCJMJobDataStatsTracking]') )
BEGIN
	DROP TABLE #CCM_GRCJMJobDataStatsTracking
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMFailureReasonMsg]') )
BEGIN
	DROP TABLE #CCM_JMFailureReasonMsg
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_JMFailureReasonMsgParam]') )
BEGIN
	DROP TABLE #CCM_JMFailureReasonMsgParam
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_evMsg]') )
BEGIN
	DROP TABLE #CCM_evMsg
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_evParam]') )
BEGIN
	DROP TABLE #CCM_evParam
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMExportLocation]') )
BEGIN
	DROP TABLE #CCM_MMExportLocation
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMedia]') )
BEGIN
	DROP TABLE #CCM_MMMedia
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMediaSide]') )
BEGIN
	DROP TABLE #CCM_MMMediaSide
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMVolume]') )
BEGIN
	DROP TABLE #CCM_MMVolume
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMediaGroup]') )
BEGIN
	DROP TABLE #CCM_MMMediaGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMountPath]') )
BEGIN
	DROP TABLE #CCM_MMMountPath
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDevice]') )
BEGIN
	DROP TABLE #CCM_MMDevice
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDeviceController]') )
BEGIN
	DROP TABLE #CCM_MMDeviceController
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMountPathToStorageDevice]') )
BEGIN
	DROP TABLE #CCM_MMMountPathToStorageDevice
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMNDMPHostInfo]') )
BEGIN
	DROP TABLE #CCM_MMNDMPHostInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMContainer]') )
BEGIN
	DROP TABLE #CCM_MMContainer
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMCenteraInfo]') )
BEGIN
	DROP TABLE #CCM_MMCenteraInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMCenteraAccessNode]') )
BEGIN
	DROP TABLE #CCM_MMCenteraAccessNode
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMHost]') )
BEGIN
	DROP TABLE #CCM_MMHost
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxAccessPath]') )
BEGIN
	DROP TABLE #CCM_IdxAccessPath
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMLibrary]') )
BEGIN
	DROP TABLE #CCM_MMLibrary
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMMasterPool]') )
BEGIN
	DROP TABLE #CCM_MMMasterPool
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDrivePool]') )
BEGIN
	DROP TABLE #CCM_MMDrivePool
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMLibraryController]') )
BEGIN
	DROP TABLE #CCM_MMLibraryController
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlVersion]') )
BEGIN
	DROP TABLE #CCM_sqlVersion
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlServer]') )
BEGIN
	DROP TABLE #CCM_sqlServer
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlDatabase]') )
BEGIN
	DROP TABLE #CCM_sqlDatabase
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileGroup]') )
BEGIN
	DROP TABLE #CCM_sqlFileGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFile]') )
BEGIN
	DROP TABLE #CCM_sqlFile
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlBackupSet]') )
BEGIN
	DROP TABLE #CCM_sqlBackupSet
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlLSNs]') )
BEGIN
	DROP TABLE #CCM_sqlLSNs
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlArchiveSet]') )
BEGIN
	DROP TABLE #CCM_sqlArchiveSet
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlBackupFile]') )
BEGIN
	DROP TABLE #CCM_sqlBackupFile
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileSubClient]') )
BEGIN
	DROP TABLE #CCM_sqlFileSubClient
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileSubClientGroup]') )
BEGIN
	DROP TABLE #CCM_sqlFileSubClientGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlLogMarkNames]') )
BEGIN
	DROP TABLE #CCM_sqlLogMarkNames
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlNames]') )
BEGIN
	DROP TABLE #CCM_sqlNames
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlNames2]') )
BEGIN
	DROP TABLE #CCM_sqlNames2
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlDbBackupInfo]') )
BEGIN
	DROP TABLE #CCM_sqlDbBackupInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlArchiveInfo]') )
BEGIN
	DROP TABLE #CCM_sqlArchiveInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlFileBackupInfo]') )
BEGIN
	DROP TABLE #CCM_sqlFileBackupInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sqlLogMarks]') )
BEGIN
	DROP TABLE #CCM_sqlLogMarks
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_oracleDataFiles]') )
BEGIN
	DROP TABLE #CCM_oracleDataFiles
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_oracleTableSpaces]') )
BEGIN
	DROP TABLE #CCM_oracleTableSpaces
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_oracleObjects]') )
BEGIN
	DROP TABLE #CCM_oracleObjects
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_OraclePluggableDBs]') )
BEGIN
	DROP TABLE #CCM_OraclePluggableDBs
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybArchFileInfo]') )
BEGIN
	DROP TABLE #CCM_sybArchFileInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybTransLog]') )
BEGIN
	DROP TABLE #CCM_sybTransLog
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybSystemDevices]') )
BEGIN
	DROP TABLE #CCM_sybSystemDevices
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_sybSystemUsages]') )
BEGIN
	DROP TABLE #CCM_sybSystemUsages
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LicUsage]') )
BEGIN
	DROP TABLE #CCM_LicUsage
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LicUsageHistory]') )
BEGIN
	DROP TABLE #CCM_LicUsageHistory
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_LicAal]') )
BEGIN
	DROP TABLE #CCM_LicAal
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxSIDBStore]') )
BEGIN
	DROP TABLE #CCM_IdxSIDBStore
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_IdxSIDBSubStore]') )
BEGIN
	DROP TABLE #CCM_IdxSIDBSubStore
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_GXGlobalParam]') )
BEGIN
	DROP TABLE #CCM_GXGlobalParam
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_Pattern]') )
BEGIN
	DROP TABLE #CCM_TM_Pattern
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_PatternAssoc]') )
BEGIN
	DROP TABLE #CCM_TM_PatternAssoc
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_SubTask]') )
BEGIN
	DROP TABLE #CCM_TM_SubTask
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_AssocEntity]') )
BEGIN
	DROP TABLE #CCM_TM_AssocEntity
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_TM_Task]') )
BEGIN
	DROP TABLE #CCM_TM_Task
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMVolume]') )
BEGIN
	DROP TABLE #CCM_SMVolume
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMVolSnapMap]') )
BEGIN
	DROP TABLE #CCM_SMVolSnapMap
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMMetaData]') )
BEGIN
	DROP TABLE #CCM_SMMetaData
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMSnap]') )
BEGIN
	DROP TABLE #CCM_SMSnap
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_SMControlHost]') )
BEGIN
	DROP TABLE #CCM_SMControlHost
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSProviders]') )
BEGIN
	DROP TABLE #CCM_UMDSProviders
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSgroups]') )
BEGIN
	DROP TABLE #CCM_UMDSgroups
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMGroups]') )
BEGIN
	DROP TABLE #CCM_UMGroups
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSGroupMaps]') )
BEGIN
	DROP TABLE #CCM_UMDSGroupMaps
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMUsers]') )
BEGIN
	DROP TABLE #CCM_UMUsers
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMUserGroup]') )
BEGIN
	DROP TABLE #CCM_UMUserGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMUserPrefs]') )
BEGIN
	DROP TABLE #CCM_UMUserPrefs
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMDSUserGroup]') )
BEGIN
	DROP TABLE #CCM_UMDSUserGroup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMRoles]') )
BEGIN
	DROP TABLE #CCM_UMRoles
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMRolesPermissions]') )
BEGIN
	DROP TABLE #CCM_UMRolesPermissions
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMRolesWithPermissionsExpanded]') )
BEGIN
	DROP TABLE #CCM_UMRolesWithPermissionsExpanded
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMOwners]') )
BEGIN
	DROP TABLE #CCM_UMOwners
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMOwnerRoles]') )
BEGIN
	DROP TABLE #CCM_UMOwnerRoles
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_UMSecurityAssociations]') )
BEGIN
	DROP TABLE #CCM_UMSecurityAssociations
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_edcJobIdMap]') )
BEGIN
	DROP TABLE #CCM_edcJobIdMap
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_edcClientNameMap]') )
BEGIN
	DROP TABLE #CCM_edcClientNameMap
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archMaterializeSnapshotProp]') )
BEGIN
	DROP TABLE #CCM_archMaterializeSnapshotProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_PatchUpdateAgentInfo]') )
BEGIN
	DROP TABLE #CCM_PatchUpdateAgentInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_PatchMultiCache]') )
BEGIN
	DROP TABLE #CCM_PatchMultiCache
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_CCRCommCellReadiness]') )
BEGIN
	DROP TABLE #CCM_CCRCommCellReadiness
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_CCRToSubClient]') )
BEGIN
	DROP TABLE #CCM_CCRToSubClient
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_CCRClientToClient]') )
BEGIN
	DROP TABLE #CCM_CCRClientToClient
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileCopyDedup]') )
BEGIN
	DROP TABLE #CCM_archFileCopyDedup
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archFileSIDBKeys]') )
BEGIN
	DROP TABLE #CCM_archFileSIDBKeys
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMEntityProp]') )
BEGIN
	DROP TABLE #CCM_MMEntityProp
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_DlpClientPass]') )
BEGIN
	DROP TABLE #CCM_DlpClientPass
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_archIndexingAged]') )
BEGIN
	DROP TABLE #CCM_archIndexingAged
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_App_IndexDBInfo]') )
BEGIN
	DROP TABLE #CCM_App_IndexDBInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_App_IndexCheckpointInfo]') )
BEGIN
	DROP TABLE #CCM_App_IndexCheckpointInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_GRC_History]') )
BEGIN
	DROP TABLE #CCM_GRC_History
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMDiskHWInfo]') )
BEGIN
	DROP TABLE #CCM_MMDiskHWInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMScaleOutMAInfo]') )
BEGIN
	DROP TABLE #CCM_MMScaleOutMAInfo
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_MMSDSStoragePool]') )
BEGIN
	DROP TABLE #CCM_MMSDSStoragePool
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CredentialAssoc]') )
BEGIN
	DROP TABLE #CCM_APP_CredentialAssoc
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Credentials]') )
BEGIN
	DROP TABLE #CCM_APP_Credentials
END
IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_ArchEncKeys]') )
BEGIN
	DROP TABLE #CCM_ArchEncKeys
END

END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errCode = ERROR_NUMBER()
	SET @o_errStr = 'Exception in dropping CCM_* tables from tempdb at ERROR_LINE(): '+ CAST(ERROR_LINE() as varchar(10))+' ERROR_MESSAGE(): ' + ERROR_MESSAGE()
	GOTO CX_ERROR_EXIT
END CATCH
/******** Return captured xml *********/
set @o_CaptureResponseXml =
(
select
	@i_entitiesToCaptureXml,
	@l_CaptureDataXml
	for xml path(''),root('CaptureResponse')
)
SET @o_errCode = 0
SET @o_errStr = 'NO ERROR'
SELECT @o_errCode, @o_errStr, @o_CaptureResponseXml
RETURN(0)
CX_ERROR_EXIT:
IF (Cursor_Status('LOCAL', 'SUBCLIENTS_TO_CAPTURE_CURSOR') >= -1)
BEGIN
	CLOSE SUBCLIENTS_TO_CAPTURE_CURSOR
  DEALLOCATE SUBCLIENTS_TO_CAPTURE_CURSOR
END
RAISERROR ('%s' , 16, 1, @o_errStr)
SELECT	@o_errCode, @o_errStr, @o_CaptureResponseXml
RETURN(-1)

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Entities_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_Entities_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Entities_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Entities_to_XML'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Entities_to_XML',  'v1.16.12.8.4.1', 'CCM_Capture_Entities_to_XML', 'v1.16.12.8.4.1')
GO

