

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Common_From_90.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture common entries from source commcell needed for
--  |                   validation before merge in the destination commcell.
--  +========================================================================+
-- $Id: CCM_Capture_Common_From_90.sp,v 1.2.88.1 2018/03/20 00:29:32 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_Common_From_90 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_Common_From_90')
	drop procedure CCM_Capture_Common_From_90
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Common_From_90')
	delete from GxQscripts where name = 'CCM_Capture_Common_From_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Common_From_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Common_From_90'
GO
print '... Creating Procedure: CCM_Capture_Common_From_90'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_Common_From_90
  @i_jobId integer,
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_Common.spb
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
	IF NOT EXISTS (SELECT * FROM MASTER..SYSDATABASES WHERE NAME = 'CommServ_Capture')
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Common -- DATABASE CommServ_Capture DOES NOT EXIST'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_simAllGalaxyRel
	INSERT INTO CommServ_Capture..CCM_simAllGalaxyRel
	SELECT
	*
	FROM CCM_SOURCE_simAllGalaxyRel
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Common -- CCM_simAllGalaxyRel'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_PatchDBSPInfo
	INSERT INTO CommServ_Capture..CCM_PatchDBSPInfo
	SELECT A.*
	FROM CCM_SOURCE_PatchDBSPInfo A LEFT JOIN CommServ_Capture..CCM_PatchDBSPInfo B ON A.SPNumber = B.SPNumber
	WHERE B.SPNumber IS NULL
	-- Capture the list of the clients in the common dump
	-- for the client limit check to be done in the merge side
	DECLARE @currentValue 	NVARCHAR(MAX) = ''
	SELECT @currentValue = @currentValue + value + '_'  FROM CCMCaptureEntities
	WHERE jobId = @i_jobId
	  AND type = 7 -- EntityType_SUBCLIENT_ENTITY (CvEntitiesMsgs.h)
	SET @currentValue = LEFT(@currentValue, LEN(@currentValue)-1)
	IF OBJECT_ID('tempdb..#scList') IS NOT NULL DROP TABLE #scList
		CREATE TABLE #scList (scId INT)
	INSERT INTO #scList
	SELECT DISTINCT _id FROM SplitStringByDelimiter(@currentValue,'_')
	INSERT INTO CommServ_Capture..CCM_APP_Application
	SELECT A.* FROM CCM_SOURCE_APP_Application A INNER JOIN #scList B ON A.id = B.scId AND A.appTypeId <> 1000  -- DR Sub-Client isn't captured
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Common -- CCM_APP_Application'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Capture..CCM_APP_Client
	SELECT 	*, ''
	FROM CCM_SOURCE_APP_Client
	WHERE id in (SELECT clientId FROM CommServ_Capture..CCM_APP_Application)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Common -- CCM_APP_Client'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Capture..CCM_MMHost
	SELECT * FROM CCM_SOURCE_MMHost
	WHERE ClientId IN (SELECT value FROM CCMCaptureEntities WHERE jobId = @i_jobId AND type = 11) -- EntityType_MEDIAAGENT_ENTITY (CvEntitiesMsgs.h)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Common -- CCM_MMHost'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CommServ_Capture..CCM_APP_Client
	SELECT 	*, ''
	FROM CCM_SOURCE_APP_Client
	WHERE id in (SELECT clientId FROM CommServ_Capture..CCM_MMHost)
	  AND id not in (SELECT id FROM CommServ_Capture..CCM_APP_Client)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Common -- CCM_APP_Client -- Media Agents'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_ClientProp
	INSERT INTO CommServ_Capture..CCM_APP_ClientProp
	SELECT * FROM CCM_SOURCE_APP_ClientProp
	WHERE componentNameId IN (SELECT id FROM CommServ_Capture..CCM_APP_Client)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Common -- CCM_APP_ClientProp'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_LicUsage
	INSERT		INTO CommServ_Capture..CCM_LicUsage
	SELECT	* FROM CCM_SOURCE_LicUsage
	WHERE		CId IN ( SELECT id FROM CommServ_Capture..CCM_APP_Client )
	IF	@@ERROR > 0
	BEGIN
		SET	@errStr = 'ERROR: CCM_Capture_Common -- CCM_LicUsage'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	IF (Cursor_Status('LOCAL', 'CCM_Cursor') >= -1)
	BEGIN
		CLOSE CCM_Cursor
		DEALLOCATE CCM_Cursor
	END
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Common_From_90')
	delete from GxQscripts where name = 'CCM_Capture_Common_From_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Common_From_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Common_From_90'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Common_From_90',  '00010002008800010000', 'CCM_Capture_Common_From_90', '00010002008800010000')
GO

